<?php

use App\Order\Constants\OrderSources;
use App\Reporting\MisReport\AttemptsCalculator;
use App\Reporting\MisReport\AttemptsCalculatorFeatureFlag;
use App\Reporting\MisReport\CurrentStatusFeatureFlag;
use App\Reporting\MisReport\DeliveryStatus;
use App\Reporting\MisReport\DeliveryStatusFeatureFlag;
use App\Time\Timer;
use App\Reporting\MisReport\CurrentStatus;

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Misreport extends CI_Controller
{

    private $queryString = '';
    private $queryParameters = [];


    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('common');
        $this->load->helper('log_helper');
        $this->load->library('misreportlib');
        $this->load->helper('promisedate_helper');
        if (!checkUrlAccessForUser('MISREPORT')) {
            redirect("Forbiddenaccess");
        }
    }

    /**
     * display search data for MIS Report page
     *
     *
     *
     * @param
     * @return    Array
     * @author    Developer Name external.ram.k@kuehne-nagel.com
     * @date      29-03-2021 11:00:00+05.30
     * @change    Asia
     */
    public function index()
    {
        $this->getsearchresult();
    }

    public function getsearchresult()
    {
        $data['page_title'] = $this->lang->line('mis_report');
        $data['sub_title'] = $this->lang->line('leftmenu_reports');
        $userid = $this->session->userdata("user_id");
        $aqucarrier = $post1['aqucarrier'] ?? [];
        $data['aqucarrierid'] = $aqucarrier;
        $data['carrierlist'] = $this->common->gettbldata(["user_id" => $userid], "id,name", "tb_vendors", 0, 0);
        $data['aquorder'] = [];
        $this->newtemplate->dashboard("reportshipment/misreport", $data);
    }

    /**
     * get searched data for query params
     *
     *
     *
     * @param
     * @return    Array
     * @author    Developer Name external.ram.k@kuehne-nagel.com
     * @date      29-03-2021 11:00:00+05.30
     * @change    Asia
     */
    public function searchorders($post)
    {
        log_error(UNIQLO_LOG_PREFIX . "searchorders inbound data: " . json_encode($post));

        $whr = array();
        if (!empty($post)) {
            /*$status_search = isset($post['aquordtype']) ? $post['aquordtype'] : "";*/
            if (isset($post['aqufromdate']) && $post['aqufromdate'] != "") {
                $aqufromdate = date('Y-m-d', strtotime($post['aqufromdate']));
                $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $aqufromdate;
            }
            if (isset($post['aqutodate']) && $post['aqutodate'] != "") {
                $todate = date('Y-m-d', strtotime($post['aqutodate']));
                $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
            }
            if (isset($post['booking_id']) && $post['booking_id'] != "") {
                $whr['o.order_id'] = $post['booking_id'];
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "searchorders outbound data: " . implode(', ', $whr));

        return $whr;
    }

    /**
     * get the uniqlo status report list into datatables
     *
     *
     *
     * @param Array Order Info.
     * @return    Array
     * @author    Developer Name external.ram.k@kuehne-nagel.com
     * @date      29-03-2021 11:00:00+05.30
     * @change    Asia
     */
    public function ajaxListing()
    {
        $this->queryString = '';
        $this->queryParameters = [];

        $this->load->model('DataArrayFormatter_model');
        $this->load->model('DataQueryFormatter_model');
        $this->load->model('Datatables_model');
        $this->load->model('Uniqlomodel');
        $draw = $this->input->post('draw', true);
        $start = $this->input->post('start', true);
        $userid = $this->session->userdata("user_id");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $custid = "";
        if (!empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        $country_userids = $other_checks = $wherein = $subcusts = array();
        if (!empty($this->session->userdata("country_user_ids")) && ($this->session->userdata(
                    "country_user_ids"
                ) != null) && (count($this->session->userdata("country_user_ids")) > 0)) {
            $country_userids = $this->session->userdata("country_user_ids");
        }
        $status_search = "";
        $post = $this->input->post('data', true);
        $order_status = $post['aquordtype'] ?? "";
        $ad_orderstatus = $post['order_status'] ?? "";
        if (isset($post['aqucarrier']) && $post['aqucarrier'] != array()) {
            $wherein['vendor_id'] = $post['aqucarrier'];
        }
        if (isset($post['aqucarrierid_adv']) && !empty($post['aqucarrierid_adv'])) {
            $wherein['vendor_id'] = $post['aqucarrierid_adv'];
        }
        if (!empty($order_status)) {
            $status_search = $order_status;
        }
        if (!empty($ad_orderstatus)) {
            $status_search = $ad_orderstatus;
        }
        $other_checks['status_search'] = $status_search;
        if (isset($post['shipper_name']) && $post['shipper_name'] != "") {
            $other_checks['shipper_name'] = $post['shipper_name'];
        }
        if (isset($post['consignee_name']) && $post['consignee_name'] != "") {
            $other_checks['consignee_name'] = $post['consignee_name'];
        }
        if (isset($post['lr_number']) && $post['lr_number'] != "") {
            $other_checks['lr_number'] = $post['lr_number'];
        }
        if (isset($post['customer_reference_number']) && $post['customer_reference_number'] != "") {
            $other_checks['customer_reference_number'] = $post['customer_reference_number'];
        }
        if (isset($post['qbook_pickupdatetime']) && $post['qbook_pickupdatetime'] != "") {
            $other_checks['qbook_pickupdatetime'] = $post['qbook_pickupdatetime'];
        }
        if (isset($post['container_num']) && $post['container_num'] != "") {
            $other_checks['container_num'] = trim($post['container_num']);
        }
        $other_checks['closed_from_date'] = $other_checks['closed_to_date'] = "";
        if ($this->session->userdata('user_role_id') == '4') {
            $userid = 0;
        }
        if (!empty($custid)) {
            if ($this->session->userdata('sub_cust') !== false) {
                $subcusts = $this->session->userdata('sub_cust');
                if (!empty($subcusts)) {
                    array_push($subcusts, $custid);
                } else {
                    $subcusts = [
                        $custid
                    ];
                }
            } else {
                $subcusts = [
                    $custid
                ];
            }
        }

        // searchorders returns array, even empty
        foreach ($this->searchorders($post) as $key => $value) {
            if ($key === "DATE_FORMAT(o.createdon,'%Y-%m-%d') >=" || $key === "DATE_FORMAT(o.createdon,'%Y-%m-%d') <=") {
                $this->queryString .= ' AND ' . $key . ' ? ';
            } else {
                $this->queryString .= ' AND ' . $key . ' = ? ';
            }
            $this->queryParameters[] = $value;
        }

        $this->queryString .= ' AND o.status!=0 ';
        if (isset($wherein['vendor_id']) && !empty($wherein['vendor_id'])) {
            # $wherein['vendor_id'] may come from $post['qucarrier'] or $post['aqucarrierid_adv']
            # it can be array or string - it's not clear
            if (is_array($wherein['vendor_id'])) {
                // if it's an array then use query binding
                $this->queryString .= ' AND o.vendor_id in ? ';
                $this->queryParameters[] = $wherein['vendor_id'];
            } else {
                // if it's glued array of ids then pass as string
                $this->queryString .= $wherein['vendor_id'] ? ' AND o.vendor_id in ( '.$wherein['vendor_id'].' )' : '';
            }
        }

        if (isset($other_checks['status_search']) && !empty($other_checks) && !empty($other_checks['status_search'])) {
            $status_search = $other_checks['status_search'];
            if ($status_search === 'PENDING') {
                $this->queryString .= " AND o.trip_id = 0 ";
            } elseif ($status_search === 'ACTIVE') {
                $this->queryString .= " AND o.trip_id!= 0 ";
                $this->queryString .= " AND o.trip_sts= 0 ";
            } elseif ($status_search === 'CLOSED') {
                $this->queryString .= " AND o.trip_id!= 0 ";
                $this->queryString .= " AND o.trip_sts= 1 ";
            }
        }

        if ($userid && $userid !== '0') {
            $this->queryString .= ' AND o.user_id in ? ';
            $this->queryParameters [] = !empty($country_userids) ? $country_userids : [ $userid ];
        }

        if (!isset($other_checks['consignee_name'])) {
            $other_checks['consignee_name'] = '';
        }
        if (!isset($other_checks['shipper_name'])) {
            $other_checks['shipper_name'] = '';
        }
        if (!isset($other_checks['qbook_pickupdatetime'])) {
            $other_checks['qbook_pickupdatetime'] = '';
        }
        if (!isset($other_checks['lr_number'])) {
            $other_checks['lr_number'] = '';
        }
        if (!isset($other_checks['customer_reference_number'])) {
            $other_checks['customer_reference_number'] = '';
        }

        $joinArray = [];
        $whereArray = [];
        $paramsArray = [];
        if (!empty($other_checks)) {
            if (($other_checks['consignee_name'] != '') || ($other_checks['shipper_name'] != '') || ($other_checks['customer_reference_number'] != '') || ($other_checks['qbook_pickupdatetime'] != '') || ($other_checks['lr_number'] != '')) {
                if (isset($other_checks['shipper_name']) && ($other_checks['shipper_name'] != '') && isset($other_checks['consignee_name']) && ($other_checks['consignee_name'] != '')) {
                    $s = $other_checks['shipper_name'];
                    $c = $other_checks['consignee_name'];
                    $joinArray[] = [
                        'tb' => 'tb_order_parties p',
                        'condition' => 'p.order_id=o.id',
                        'type' => 'LEFT'
                    ];
                    $joinArray[] = [
                        'tb' => 'tbl_party_master pm',
                        'condition' => 'pm.id=p.party_id',
                        'type' => 'LEFT'
                    ];
                    $whereArray[] = "((pm.name LIKE ? OR pm.mobile LIKE ? OR pm.code LIKE ?) OR (pm.name LIKE ? OR pm.mobile LIKE ? OR pm.code LIKE ?))";
                    $paramsArray = array_merge($paramsArray, [ '%'.$s.'%', '%'.$s.'%', '%'.$s.'%', '%'.$c.'%', '%'.$c.'%', '%'.$c.'%' ]);

                } elseif (isset($other_checks['consignee_name']) && ($other_checks['consignee_name'] != '')) {
                    $c = $other_checks['consignee_name'];
                    $joinArray[] = [
                        'tb' => 'tb_order_parties p',
                        'condition' => 'p.order_id=o.id',
                        'type' => 'LEFT'
                    ];
                    $joinArray[] = [
                        'tb' => 'tbl_party_master pm',
                        'condition' => 'pm.id=p.party_id',
                        'type' => 'LEFT'
                    ];
                    $whereArray[] = "(pm.name LIKE ? OR pm.mobile LIKE ? OR pm.code LIKE ?)";
                    $paramsArray = array_merge($paramsArray, [ '%'.$c.'%', '%'.$c.'%', '%'.$c.'%' ]);

                } elseif (isset($other_checks['shipper_name']) && ($other_checks['shipper_name'] != '')) {
                    $s = $other_checks['shipper_name'];
                    $joinArray[] = [
                        'tb' => 'tb_order_parties p',
                        'condition' => 'p.order_id=o.id',
                        'type' => 'LEFT'
                    ];
                    $joinArray[] = [
                        'tb' => 'tbl_party_master pm',
                        'condition' => 'pm.id=p.party_id',
                        'type' => 'LEFT'
                    ];
                    $whereArray[] = "(pm.name LIKE ? OR pm.mobile LIKE ? OR pm.code LIKE ?)";
                    $paramsArray = array_merge($paramsArray, [ '%'.$s.'%', '%'.$s.'%', '%'.$s.'%']);

                }
                if (isset($other_checks['customer_reference_number']) && ($other_checks['customer_reference_number'] != '')) {
                    $cust_ref_val = $other_checks['customer_reference_number'];
                    $joinArray[] = [
                        'tb' => 'tb_order_references orf',
                        'condition' => 'orf.order_id=o.id',
                        'type' => 'LEFT'
                    ];
                    $whereArray[] = "(orf.ref_value like ? and orf.reference_id='XSR' and orf.status='1') OR (orf.ref_value like ?  and orf.reference_id='DQ' and orf.status='1') OR (orf.ref_value like ?  and orf.reference_id='PO' and orf.status='1')";
                    $paramsArray = array_merge($paramsArray, [ '%'.$cust_ref_val.'%', '%'.$cust_ref_val, '%'.$cust_ref_val]);

                } elseif (isset($other_checks['lr_number']) && ($other_checks['lr_number'] != '')) {
                    $lr_val = $other_checks['lr_number'];
                    $joinArray[] = [
                        'tb' => 'tb_order_references orf',
                        'condition' => 'or.order_id=o.id',
                        'type' => 'LEFT'
                    ];
                    $whereArray[] = "(orf.ref_value like ? and orf.reference_id='PO' and orf.status='1') OR (orf.ref_value like ? and orf.reference_id='DQ' and orf.status='1')";
                    $paramsArray = array_merge($paramsArray, [ '%'.$lr_val.'%', '%'.$lr_val.'%']);

                }
                if (isset($other_checks['qbook_pickupdatetime']) && ($other_checks['qbook_pickupdatetime'] != '')) {
                    $pickdatetime = date("Y-m-d", strtotime($other_checks['qbook_pickupdatetime']));
                    $joinArray[] = [
                        'tb' => 'tb_stop_status tps',
                        'condition' => 'o.shift_id=tps.shipment_id',
                        'type' => 'LEFT'
                    ];
                    $whereArray[] = "(tps.status_id='4' OR tps.status_id='40') and (DATE_FORMAT(tps.createdon,'%Y-%m-%d') = ? OR DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') = ? )";
                    $paramsArray = array_merge($paramsArray, [ $pickdatetime, $pickdatetime ]);
                }
            }
        }
        if (isset($other_checks['container_num']) && $other_checks['container_num'] != '') {

            $container_number = $other_checks['container_num'];
            $joinArray[] = [
                'tb' => 'tb_order_references orf_ctr',
                'condition' => 'orf_ctr.order_id=o.id',
                'type' => 'LEFT'
            ];
            $whereArray[] = "(orf_ctr.ref_value like '%" . $container_number . "%' and orf_ctr.reference_id='AWB' and orf_ctr.status='1')";
            $paramsArray = array_merge($paramsArray, [ '%'.$container_number.'%' ]);
        }

        if (!empty($joinArray)) {

            $sql = "SELECT o.id FROM tb_orders o ";
            foreach ($joinArray as $eachJoin) {
                $sql .= ' ' . $eachJoin['type'] . ' JOIN ' . $eachJoin['tb'] . ' on ' . $eachJoin['condition'] . '';
            }
            $sql .= " WHERE o.id!= '' ";

            if (!empty($whereArray)) {
                $sql .= " and ". implode(' AND ', $whereArray);
                $dat = $this->db->query($sql, $paramsArray);
            } else {
                $dat = $this->db->query($sql);
            }

            if ($dat->num_rows() > 0) {
                $orderNumbers = [];
                $resultant = $dat->result_array();
                if (!empty($resultant)) {
                    foreach ($resultant as $eachOrdNum) {
                        $orderNumbers [] = $eachOrdNum['id'];
                    }
                    $this->queryString .= ' AND o.id in ? ';
                    $this->queryParameters [] = $orderNumbers;
                }
            }
        }

        if (!empty($subcusts)) {
            $this->queryString .= ' AND o.customer_id in ? ';
            $this->queryParameters [] = $subcusts;
        }

        //below query for pagination count and applying where condition in subquery for sub-query to be fast
        $compiledCount = '';
        $resultSet = $this->db->query(
            "select count(o.id) as count from tb_orders o where o.id!=0 " . $this->queryString,
            $this->queryParameters
        );
        if ($resultSet->num_rows() > 0) {
            $resdata = $resultSet->result_array();
            if (isset($resdata[0]['count'])) {
                $compiledCount = $resdata[0]['count'];
            }
        } else {
            $compiledCount = 0;
        }
        $selectColumns = array(
            'o.id',
            'o.order_id',
            'o.delivery_datetime',
            'o.goods_value',
            'o.pickup_city',
            'o.pickup_pincode',
            'o.pickup_address1',
            'o.pickup_address2',
            'o.delivery_company',
            'o.delivery_city',
            'o.delivery_address1',
            'o.delivery_address2',
            'o.delivery_pincode',
            'o.weight',
            'o.company_code',
            'o.branch_code',
            'o.createdon',
            'o.shift_id',
            'o.vendor_id',
            'o.customer_id',
            'o.trip_sts',
            'o.quantity',
            'o.created_source',
            'tv.name as vendor_name',
            'cust.name as customer_name',
            'cust.location as customer_loc',
            'od.order_type',
            'od.promise_deliver_date',
            'od.no_of_attempt',
            'ot.type_name',
            'ot.ordtype_code',
        );
        $table_name = 'tb_orders o';
        $indexColumn = 'o.id';
        $groupBy = 'o.id';
        $excludeCountQuery = 'Yes';
        $wherecondition = " o.id != '' " .
            $this->glueQueryStringWithParamsBinding(
                $this->queryString, $this->queryParameters
            );
        $joinsArray[] = [
            'table_name' => 'tb_vendors as tv',
            'condition' => "tv.id=o.vendor_id",
            'join_type' => 'left'
        ];
        $joinsArray[] = [
            'table_name' => 'tb_customers as cust',
            'condition' => "cust.id=o.customer_id",
            'join_type' => 'left'
        ];
        $joinsArray[] = [
            'table_name' => 'tb_order_details as od',
            'condition' => "od.order_row_id=o.id",
            'join_type' => 'left'
        ];
        $joinsArray[] = [
            'table_name' => 'tb_order_types ot',
            'condition' => "od.order_type=ot.id",
            'join_type' => 'left'
        ];
        $dataTableSortOrdering = [];
        $getRecordListing = $this->Datatables_model->datatablesQuery(
            $selectColumns,
            $dataTableSortOrdering,
            $table_name,
            $joinsArray,
            $wherecondition,
            $indexColumn,
            'TRUE',
            $groupBy,
            $excludeCountQuery,
            'POST'
        );
        if ($excludeCountQuery == 'Yes') {
            $totalRecords = $compiledCount;
            $recordsFiltered = $compiledCount;
        } else {
            $totalRecords = $getRecordListing['recordsTotal'];
            $recordsFiltered = $getRecordListing['recordsFiltered'];
        }
        $pickStatusArray = $deliveredStatusArray = $genericStatusArray = $trackStatusArray = $scanStatusArray = $regionZoneArray = $ediResponseArray = $getStatusDatesForPromiseDate = $cargoWeight = [];
        $reqData = [
            'id',
            'shift_id',
            'created_source',
            'pickup_city',
            'delivery_city',
            'pickup_pincode',
            'delivery_pincode'
        ];
        $this->db->query('SET SESSION group_concat_max_len=1000000');
        $formattedData = $this->DataArrayFormatter_model->getCommaSeparatedUnqiloOrdFields(
            $reqData,
            $getRecordListing['data']
        );
        if (isset($formattedData['commaSeparated']['id']) && $formattedData['commaSeparated']['id'] != '') {
            $codes = "'DQ','AWB','PO','ORD','XSR'";
            $formattedData = $this->DataQueryFormatter_model->getUniqloOrderReferenceData(
                $formattedData['commaSeparated']['id'],
                $formattedData,
                $codes
            );
            $trackStatusArray = $this->Uniqlomodel->getOrderTrackData($formattedData['commaSeparated']['id']);
            $scanStatusArray = $this->Uniqlomodel->getOrderScanData($formattedData['commaSeparated']['id']);
            $ediResponseArray = $this->Uniqlomodel->getEdiResponseData($formattedData['commaSeparated']['id'], $userid);
            $cargoWeight = $this->Uniqlomodel->getOrderCargoWeight($formattedData['commaSeparated']['id']);
        }
        if (isset($formattedData['commaSeparated']['shift_id']) && $formattedData['commaSeparated']['shift_id'] != '') {
            $deliveredStatusArray = $this->Uniqlomodel->getOrderStatusDelvier(
                $formattedData['commaSeparated']['shift_id']
            );
            $genericStatusArray = $this->Uniqlomodel->getOrderStatusGeneric(
                $formattedData['commaSeparated']['shift_id']
            );
            $pickStatusArray = $this->Uniqlomodel->getOrderStatusPicked($formattedData['commaSeparated']['shift_id']);
            $getStatusDatesForPromiseDate = $this->common->gettbldata("shipment_id IN (" . $formattedData['commaSeparated']['shift_id'] . ") AND shipment_id > 0 AND status ='1' AND status_code IN ('0470','2300','RTO','DTO')", "shipment_id,stop_type,status_id,status_code,createdon", "tb_stop_status", 0, 0);
        }
        if (isset($formattedData['commaSeparated']['pickup_pincode']) && $formattedData['commaSeparated']['pickup_pincode'] != '') {
            $pickpincodes = $formattedData['commaSeparated']['pickup_pincode'];
            $deliverpincodes = $formattedData['commaSeparated']['delivery_pincode'];
            $allpincodes = $pickpincodes . "," . $deliverpincodes;
            $pincodearr = explode(",", $allpincodes);
            $pincodetrim = array_map("trim", $pincodearr);
            $pincodelist = array_unique($pincodetrim);
            $totpincodes = '"' . implode('","', $pincodelist) . '"';
            $pickcitys = $formattedData['commaSeparated']['pickup_city'];
            $delivercitys = $formattedData['commaSeparated']['delivery_city'];
            $allcitys = $pickcitys . "," . $delivercitys . ",Bilaspur-HR";
            $citiesarr = explode(",", $allcitys);
            $citiestrim = array_map("trim", $citiesarr);
            $citieslist = array_unique($citiestrim);
            $totcities = '"' . implode('","', $citieslist) . '"';
            $regionZoneArray = $this->Uniqlomodel->getRegionZonesData($totpincodes, $totcities);
        }
        $getRecordListing = $ediResponse = $recordListing = [];
        if (isset($formattedData['orders'])) {
            $getRecordListing = $formattedData['orders'];
            ksort($getRecordListing);
        }
        foreach ($ediResponseArray as $eachLine) {
            $orderId = $eachLine['txn_obj_id'];
            $ediId = $eachLine['edi_id'];
            $response = json_decode($eachLine['edi_response'], true);
            $finalResponse = "";
            if ($ediId == 8) {
                if (isset($response['success'])) {
                    $resp = $response['rmk'] ?? "";
                    if (isset($response['packages'])) {
                        if (!empty($response['packages'])) {
                            $remark = $response['packages'][0]['remarks'] ?? [];
                            if (!empty($remark)) {
                                $finalResponse .= trim($remark[0]) ?? "";
                            }
                        }
                    }
                    $finalResponse .= ", " . $resp;
                }
            } elseif ($ediId == 9) {
                if (isset($response['shipments'])) {
                    $respc = $response['shipments'][0] ?? [];
                    $finalResponse = $respc['reason'] ?? "";
                }
            } elseif ($ediId == 10) {
                if (isset($response['AddManifestDetails'])) {
                    foreach ($response['AddManifestDetails'] as $res) {
                        if (isset($res['AuthKey']) && $res['AuthKey'] != "Valid") {
                            if (isset($res['ReturnMessage']) && $res['ReturnMessage'] != "successful") {
                                $finalResponse = $res['ReturnMessage'] ?? "";
                            }
                        } else {
                            $finalResponse = $res['ReturnMessage'] ?? "";
                        }
                    }
                }
            }
            $ediResponse[$orderId] = $finalResponse;
        }
        foreach ($getStatusDatesForPromiseDate as $eachLine) {
            $shipmentId = $eachLine['shipment_id'];
            if ($eachLine['status_code'] == "0470") {
                $manifestDateTime[$shipmentId] = $eachLine['createdon'];
            }
            if ($eachLine['stop_type'] == "D") {
                if (in_array($eachLine['status_code'], ['DTO', '2300']) || $eachLine['status_id'] == 1) {
                    $deliveredStatusDateTime[$shipmentId] = ucwords(date("d M Y", strtotime($eachLine['createdon'])));
                }
                if ($eachLine['status_code'] == "RTO") {
                    $rtoStatusDateTime[$shipmentId] = ucwords(date("d M Y", strtotime($eachLine['createdon'])));
                }
            }
        }
        $i = 0;
        if (!empty($getRecordListing)) {
            $cntr = 1;
            $currentStatusFeatureFlag = CurrentStatusFeatureFlag::isEnabled();
            $attemptsCalculatorFeatureFlag = AttemptsCalculatorFeatureFlag::isEnabled();
            $deliveryStatusFeatureFlag = DeliveryStatusFeatureFlag::isEnabled();
            foreach ($getRecordListing as $res) {
                $cust_reference_num = $lr_num = $container_num = '';
                $referenceData = '';
                $orderSource = intval($res['created_source']);
                $vendorId = intval($res['vendor_id']);

                if (isset($res['reference_value'])) {
                    $referenceData = $res['reference_value'];
                }
                if ($referenceData != '') {
                    $arrayData = $this->DataArrayFormatter_model->formatReferenceParameters($referenceData);
                    if ($orderSource === OrderSources::SWIFTLOG_RETURN) {
                        if (isset($arrayData['DQ'])) {
                            $lr_num = $arrayData['DQ'];
                        }
                        if (isset($arrayData['XSR'])) {
                            $cust_reference_num = $arrayData['XSR'];
                        }
                    } else {
                        if (isset($arrayData['PO'])) {
                            $lr_num = $arrayData['PO'];
                        }
                        if (isset($arrayData['DQ'])) {
                            $cust_reference_num = $arrayData['DQ'];
                        }
                    }
                    if (isset($arrayData['AWB'])) {
                        $container_num = $arrayData['AWB'];
                    }
                }
                $last_status_name = $delivery_date = $rtodtodate = "";
                $manifestdated = "";
                $ststype = $ord_stats = "Undelivered";
                $txnclosed = "Open";
                $reqStatusData = array('status_code' => '', 'stop_type' => '', 'status_id' => '', 'createdon' => '');
                if (isset($res['shift_id']) && $res['shift_id'] != '' && $res['shift_id'] != 0) {
                    $shiftIndex = $res['shift_id'];
                    if (isset($deliveredStatusArray[$shiftIndex])) {
                        $last_status_name = $deliveredStatusArray[$shiftIndex]['delivered_status_status_name'];
                        $reqStatusData['status_id'] = $deliveredStatusArray[$shiftIndex]['delivered_status_status_id'];
                        $reqStatusData['status_code'] = $deliveredStatusArray[$shiftIndex]['delivered_status_status_code'];
                        $reqStatusData['stop_type'] = $deliveredStatusArray[$shiftIndex]['delivered_status_stop_type'];
                        $reqStatusData['createdon'] = $deliveredStatusArray[$shiftIndex]['delivered_status_createdon'];
                        $ststype = "Delivered";
                        $txnclosed = "Closed";
                        $ord_stats = "Delivered";
                        if ($reqStatusData['createdon'] != "") {
                            if ($reqStatusData['status_code'] !== "RTO" && $vendorId !== 311) {
                                $deldate1 = getdatetimebytimezone($curtz, $reqStatusData['createdon'], DFLT_TZ);
                                $delivery_date = $deldate1['datetime'];
                            }
                        }
                        if ($reqStatusData['status_code'] == "RTO" || $reqStatusData['status_code'] == "DTO") {
                            $rtodtodate = $delivery_date;
                        }
                    } elseif (isset($genericStatusArray[$shiftIndex])) {
                        $last_status_name = $genericStatusArray[$shiftIndex]['generic_status_status_name'];
                        $reqStatusData['status_id'] = $genericStatusArray[$shiftIndex]['generic_status_status_id'];
                        $reqStatusData['status_code'] = $genericStatusArray[$shiftIndex]['generic_status_status_code'];
                        $reqStatusData['stop_type'] = $genericStatusArray[$shiftIndex]['generic_status_stop_type'];
                        $reqStatusData['createdon'] = $genericStatusArray[$shiftIndex]['generic_status_createdon'];
                    }
                }
                $pkgtype = "Prepaid";
                $firstreturndate = $returnPromiseDate = "";
                if ($res['trip_sts'] == 1) {
                    $txnclosed = "Closed";
                    $ord_stats = "Delivered";
                }
                $returndispatchcnt = $attemptCount = 0;
                if ($last_status_name == "Cancelled" || $last_status_name == "Canceled") {
                    $last_status_name = "Cancelled";
                    $ord_stats = "Cancelled";
                    $txnclosed = "Closed";
                }
                /*check report status and date times*/
                $pickupdate1 = "";
                if (!empty($pickStatusArray)) {
                    $pickstsindex = $res['shift_id'];
                    if (isset($pickStatusArray[$pickstsindex])) {
                        $pickstscode = $pickStatusArray[$pickstsindex]['pickup_status_status_code'];
                        if ($orderSource === OrderSources::SWIFTLOG && $pickstscode == '0500') {
                            $pickupdate1 = $pickStatusArray[$pickstsindex]['pickup_status_createdon'];
                            $chkrtime = getdatetimebytimezone($curtz, $pickupdate1, DFLT_TZ);
                            $pickupdate1 = $chkrtime['datetime'];
                        } elseif ($vendorId === 311 && $pickstscode == '0500') {
                            $pickupdate1 = $pickStatusArray[$pickstsindex]['pickup_status_createdon'];
                            $chkrtime = getdatetimebytimezone($curtz, $pickupdate1, DFLT_TZ);
                            $pickupdate1 = $chkrtime['datetime'];
                        } else {
                            $pickupdate1 = $pickStatusArray[$pickstsindex]['pickup_status_createdon'];
                            $chkrtime = getdatetimebytimezone($curtz, $pickupdate1, DFLT_TZ);
                            $pickupdate1 = $chkrtime['datetime'];
                        }
                    }
                }
                $dest_state = "";
                if ($orderSource === OrderSources::SWIFTLOG) {
                    $deliverycity = $res['delivery_city'];
                    $delivery_address2 = $res['delivery_address2'];
                    $chkdblspace = strrpos($deliverycity, "  ");
                    if ($chkdblspace) {
                        $citystate = explode("  ", $deliverycity);
                        if (count($citystate) > 1) {
                            $dest_state = trim($citystate[0]); /*state*/
                            $res['delivery_city'] = trim($citystate[1]); /*city*/
                        }
                    }
                    if ($dest_state == "") {
                        $dest_cnt = explode(", ", $delivery_address2);
                        if (!empty($dest_cnt)) {
                            if (count($dest_cnt) > 0) {
                                $dest_state = $dest_cnt[count($dest_cnt) - 1] ?? "";
                            }
                        }
                    }
                } else {
                    $dest_state = 'Haryana';
                }
                if ($dest_state == "") {
                    $dest_state = $delivery_address2;
                }
                $first_attempt = $last_attempt = $promisedate = $firstreturndispatchdt = $remarks = $fecalldate = "";
                $j = 0;
                $attemptchk = $cancelchk = $rtoreason = "";
                if (!empty($trackStatusArray)) {
                    $trackstsindex = $res['id'];
                    if (isset($trackStatusArray[$trackstsindex])) {
                        $dispatch_count = $trackStatusArray[$trackstsindex]['track_dispatch_count'];
                    }
                }

                $ordscanDataArray = $this->misreportlib->orderScanData($res, ($scanStatusArray[$res['id']] ?? []));

                if (!empty($ordscanDataArray)) {
                    if ($currentStatusFeatureFlag) {
                        $currentStatus = new CurrentStatus($ordscanDataArray, $last_status_name);
                        $remarks = $currentStatus->remarks();
                        $ststype = $currentStatus->statusType();
                        $last_status_name = $currentStatus->lastStatusName();
                        $currentStatus = isset($currentStatus) ? $currentStatus->currentStatus($ststype) : $ststype;
                    } else {
                        $recentrecord = $ordscanDataArray[count($ordscanDataArray) - 1];
                        if ($last_status_name != "Delivered" && $last_status_name != "In-Transit") {
                            $last_status_name = $recentrecord['scan_val'];
                            if ($last_status_name == "Canceled") {
                                $last_status_name = "Cancelled";
                            }
                        }
                        $remarks = $recentrecord['scan_instruction'];
                        $ststype = $recentrecord['scan_val'];
                        $currentStatus = $recentrecord['scan_instruction'] ?? $last_status_name;
                    }

                    if ($attemptsCalculatorFeatureFlag && in_array($vendorId, [310,311])) {
                        try {
                            $attempts = new AttemptsCalculator($orderSource, $ordscanDataArray, $vendorId, $ststype);
                        } catch (Exception $e) {
                            log_error(UNIQLO_LOG_PREFIX . "Misreport PHPExel_Writer_Exception " . $e->getMessage());
                        }
                    }
                    if (isset($attempts)) {
                        $manifestdated = $attempts->manifested();
                        if ($pickupdate1 == "") {
                            $pickupdate1 = $attempts->pickupDate();
                        }
                        $attemptCount = $attempts->pickupsInTotal();
                        $returndispatchcnt = $attempts->returnDispatchInTotal();
                        $firstreturndispatchdt = $attempts->firstReturnDispatch();
                        $first_attempt = $attempts->firstPickup();
                        $last_attempt = $attempts->lastPickup();
                        $delivery_date = $attempts->deliveryDate();
                        $txnclosed = $attempts->txnclosed();
                        $rtodtodate = $attempts->rtodtodate();
                        $rtoreason = $attempts->rtoreason();
                        $cancelchk = $attempts->cancelchk();
                        $fecalldate = $attempts->fecalldate();
                    } else {
                        foreach ($ordscanDataArray as $stsres) {
                            if ($stsres['scan_val'] == "Manifested" || $stsres['scan_instruction'] == "Shipment details manifested" || $stsres['scan_val'] == "Pickup Pending") {
                                $manifestdated = $stsres['scan_status_time'];
                            }
                            if (($stsres['scan_val'] == "In Transit" || $stsres['scan_val'] == "Open") && ($stsres['scan_instruction'] == "Pickup completed" || $stsres['scan_instruction'] == "Shipment picked up") && ($vendorId !== 311)) {
                                $pickupdate1 = $stsres['scan_status_time'];
                            }
                            if ($stsres['scan_val'] == "Shipment Picked Up" || $stsres['scan_status_code'] == '0011') {
                                $pickupdate1 = $stsres['scan_status_time'];
                            }
                            if ($stsres['scan_status_code'] == "006" || $stsres['scan_status_code'] == "1224") {
                                $attemptCount += 1;
                                $returndispatchcnt += 1;
                                if ($j == 0) {
                                    $first_attempt = $stsres['scan_status_time'];
                                    $firstreturndispatchdt = $stsres['scan_status_time'];
                                }
                                if ($j > 0) {
                                    $last_attempt = $stsres['scan_status_time'];
                                }
                                $attemptchk = $stsres['scan_status_time'];
                                $j++;
                            }

                            if ($orderSource === OrderSources::SWIFTLOG_RETURN && $stsres['scan_status_code'] === "X-DDD3FP") {
                                $attemptCount += 1;
                                if ($j == 0) {
                                    $first_attempt = $stsres['scan_status_time'];
                                }
                                if ($j > 0) {
                                    $last_attempt = $stsres['scan_status_time'];
                                }
                                $attemptchk = $stsres['scan_status_time'];
                                $j++;
                            }

                            if (in_array($stsres['scan_val'], ["Dispatched", "Out for delivery", "Out for Return"]) &&
                                in_array($stsres['scan_instruction'], ["Out for delivery", "Out for pickup"])
                                && $vendorId !== 311) {
                                $attemptCount += 1;
                                $returndispatchcnt += 1;
                                if ($j == 0) {
                                    $first_attempt = $stsres['scan_status_time'];
                                    $firstreturndispatchdt = $stsres['scan_status_time'];
                                }
                                if ($j > 0) {
                                    $last_attempt = $stsres['scan_status_time'];
                                }
                                $attemptchk = $stsres['scan_status_time'];
                                $j++;
                            }
                            $deliveredStatusCode = ['200', '20001', '20002', '345', '34501', '239', '20003', '999'];
                            if ($stsres['scan_val'] === "Delivered" || in_array(
                                    $stsres['scan_status_code'],
                                    $deliveredStatusCode
                                )) {
                                $delivery_date = $stsres['scan_status_time'];
                                $txnclosed = "Closed";
                            }
                            if (($vendorId === 310 && $stsres['prev_scan_val'] === "RTO") || $stsres['prev_scan_val'] === "DTO") {
                                $delivery_date = $stsres['scan_status_time'];
                                $txnclosed = "Closed";
                                $rtodtodate = $stsres['scan_status_time'];
                            }
                            if ($ststype == "RTO") {
                                if ($stsres['scan_val'] == "In Transit" && $stsres['scan_type'] == "UD") {
                                    $rtoreason .= $stsres['scan_instruction'] . ", ";
                                }
                            }
                            if ($stsres['scan_val'] == "Canceled" || ($stsres['scan_val'] == "Not Picked" && $stsres['scan_type'] == "UD") || ($stsres['scan_instruction'] == "Seller cancelled the order" || $stsres['scan_instruction'] == "Pickup/KYC request cancelled")) {
                                $cancelchk = $stsres['scan_instruction'];
                            }
                            if ($stsres['call_duration'] > 0) {
                                $fecalldate = $stsres['scan_status_time'];
                            }
                        }
                    }
                }

                if (($last_status_name == "Gate Out" || $last_status_name == "Shipment Received at Facility")) {
                    if ($pickupdate1 != "") {
                        $last_status_name = "Picked";
                    } else {
                        $last_status_name = "Pending";
                        $ststype = "Pending";
                    }
                }
                if ($last_status_name == "Booked by Supplier") {
                    $last_status_name = "Pending";
                    $ststype = "Pending";
                }
                if ($orderSource === OrderSources::SWIFTLOG_RETURN) {
                    $pkgtype = "Pickup";
                }
                $zone = "";

                if (!empty($regionZoneArray)) {
                    if ($vendorId == 0) {
                        $vendorId = 310;
                    }
                    $cczoneindex = $res['pickup_pincode'] . "_" . $res['delivery_pincode'] . "_310";
                    if ($orderSource === OrderSources::SWIFTLOG) {
                        $zoneindex = $res['pickup_pincode'] . "_" . $res['delivery_pincode'] . "_" . $vendorId;
                        /* cc order carrier index change to delhivery carrier*/
                        $cczoneindex = $res['pickup_pincode'] . "_" . $res['delivery_pincode'] . "_310";
                    } else {
                        $zoneindex = $res['delivery_pincode'] . "_" . $res['pickup_pincode'] . "_" . $vendorId;
                    }
                    if (isset($regionZoneArray[$zoneindex])) {
                        $zone = $regionZoneArray[$zoneindex]['zone_carrier_zone'];
                    } elseif (isset($regionZoneArray[$cczoneindex])) {
                        $zone = $regionZoneArray[$cczoneindex]['zone_carrier_zone'];
                    }
                }
                if (strpos((string)$res['promise_deliver_date'], "1970-01-01") !== false) {
                    $this->load->model('Reportmodel');
                    $shipmentStopStatusLists = $this->Reportmodel->getShipmentStopStatusLists($res['shift_id'], $curtz, $res['branch_code']);
                    foreach ($shipmentStopStatusLists as $shipmentStopStatus) {
                        if ($shipmentStopStatus['stop_type'] === "D" && (($shipmentStopStatus['status_code'] === 'DTO' || $shipmentStopStatus['status_code'] === '2300' || $shipmentStopStatus['status_id'] == 1) || ($vendorId == "310" && $shipmentStopStatus['status_code'] === 'RTO'))) {
                                $res['promise_deliver_date'] = date("d M Y", strtotime($shipmentStopStatus['createdon']));
                        }
                    }
                }
                if($res['promise_deliver_date'] != ""){
                    $promisedate = $returnPromiseDate = $res['promise_deliver_date'];
                }
                if ($promisedate == '') {
                    $promisedate = getPromiseDate([
                        'orderRowId' => $res['id'],
                        'containerNumber' => $container_num ?? "",
                        'orderSource' => $orderSource,
                        'pickupPincode' => $res['pickup_pincode'],
                        'deliveryPincode' => $res['delivery_pincode'],
                        'vendorId' => $vendorId,
                        'shiftId' => $res['shift_id'],
                        'companyCode' => $res['company_code'],
                        'branchCode' => $res['branch_code'],
                        'timeZone' => $curtz,
                        'deliveryDateTime' => $res['delivery_datetime'],
                        'orderTypeName' => $res['type_name'],
                        'manifestDateTime' => $manifestDateTime[$res['shift_id']] ?? "",
                        'deliveredDateTime' => $deliveredStatusDateTime[$res['shift_id']] ?? "",
                        'rtoStatusDateTime' => $rtoStatusDateTime[$res['shift_id']] ?? ""
                    ]);
                }
                $checkreason = "";
                if ($container_num == "") {
                    $last_status_name = $ststype = "Pending";
                    //$checkreason = $this->getedifailresponse($userid, $res['id'], $vendorId);
                    $checkreason =  $ediResponse[$res['id']] ?? "";
                }

                if ($deliveryStatusFeatureFlag) {
                    $deliveryStatus = new DeliveryStatus($delivery_date, $promisedate, $res['ordtype_code'] ?? '', $ststype, new Timer());
                    $days = $deliveryStatus->delayDays();
                    $ontime = $deliveryStatus->deliveryStatus();
                } else {
                    $days = $this->calculateDelayDays(
                        $delivery_date,
                        $promisedate,
                        $returnPromiseDate,
                        $res['ordtype_code'],
                        $ststype
                    );
                    $ontime = $days === 'N/A' ? $days : ($days > 0 ? "Early" : ($days < 0 ? "Delay" : "On-Time"));

                }

                if ($res['delivery_city'] == "") {
                    if ($res['delivery_address1'] != "") {
                        $res['delivery_city'] = $res['delivery_address1'];
                    }
                    if ($res['delivery_city'] == "") {
                        $res['delivery_city'] = $res['delivery_address2'];
                    }
                }
                $charged_weight = 0;
                if (isset($cargoWeight[$res['id']])) {
                    $charged_weight = $cargoWeight[$res['id']] ? round($cargoWeight[$res['id']], 2) : round($res['weight'], 2);
                }
                if ($orderSource === OrderSources::SWIFTLOG) {
                    $returnPromiseDate = "";
                    $firstreturndispatchdt = "";
                }
                if ($delivery_date == "" && $ord_stats == "Delivered") {
                    if ($cancelchk != "") {
                        $ord_stats = "Cancelled";
                        $last_status_name = "Cancelled";
                        $ststype = "Cancelled";
                        $remarks = $cancelchk;
                        $txnclosed = "Closed";
                    }
                }
                if ($orderSource === OrderSources::SWIFTLOG) {
                    if ($first_attempt == "" && $delivery_date != "") {
                        $first_attempt = $delivery_date;
                        $last_attempt = $delivery_date;
                    }
                    if ($last_attempt == "" && $delivery_date != "") {
                        $last_attempt = $delivery_date;
                    }
                } else {
                    if ($first_attempt == "" && $pickupdate1 != "") {
                        $first_attempt = $pickupdate1;
                        $last_attempt = $pickupdate1;
                    }
                    if ($last_attempt == "" && $pickupdate1 != "") {
                        $last_attempt = $pickupdate1;
                    }
                    if ($ststype == "In Transit" || $ststype == "In-Transit") {
                        $ststype = "Return In-Transit";
                    }
                }
                if ($first_attempt != "") {
                    $first_attempt = date("Y-m-d", strtotime($first_attempt));
                }
                if ($last_attempt != "") {
                    $last_attempt = date("Y-m-d", strtotime($last_attempt));
                }
                if ($promisedate != "") {
                    $promisedate = date("Y-m-d", strtotime($promisedate));
                }
                if ($delivery_date != "") {
                    $delivery_date = date("Y-m-d", strtotime($delivery_date));
                }
                if ($fecalldate != "") {
                    $fecalldate = date("Y-m-d", strtotime($fecalldate));
                }
                if ($firstreturndispatchdt != "") {
                    $firstreturndispatchdt = date("Y-m-d", strtotime($firstreturndispatchdt));
                }
                if ($returnPromiseDate != "") {
                    $returnPromiseDate = date("Y-m-d", strtotime($returnPromiseDate));
                }
                if ($rtodtodate != "") {
                    $rtodtodate = date("Y-m-d", strtotime($rtodtodate));
                }
                if ($orderSource === OrderSources::SWIFTLOG) {
                    $returndispatchcnt = $firstreturndispatchdt = $returnPromiseDate = "";
                }
                if ($last_status_name == "Delivered") {
                    $remarks = "";
                    $ststype = "Delivered";
                }
                if ($checkreason != "") {
                    $remarks = $checkreason;
                }
                if ($rtoreason != "") {
                    $remarks = $rtoreason;
                }
                if ($last_status_name == "Soft data uploaded" || $last_status_name == "Shipment Uploaded") {
                    $last_status_name = "Pending";
                    $ststype = "Pending";
                }
                if ($last_status_name == "Shipment Picked Up") {
                    $last_status_name = "Picked";
                }
                $goods_value = $res['goods_value'];

                if (strpos($promisedate, "1970-01-01") !== false) {
                    $promisedate= "";
                }

                $j = 0;
                $recordListing[$i][0] = "";
                $recordListing[$i][++$j] = $cntr;
                $recordListing[$i][++$j] = $container_num;
                $recordListing[$i][++$j] = $res['customer_loc'];
                $recordListing[$i][++$j] = date("Y-m", strtotime($res['createdon']));
                $recordListing[$i][++$j] = $lr_num;
                $recordListing[$i][++$j] = $cust_reference_num;
                $recordListing[$i][++$j] = $res['createdon'];
                $recordListing[$i][++$j] = $manifestdated;
                $recordListing[$i][++$j] = $pickupdate1;
                $recordListing[$i][++$j] = $currentStatus ?? "";
                $recordListing[$i][++$j] = $ststype;
                $recordListing[$i][++$j] = $res['delivery_pincode'];
                $recordListing[$i][++$j] = $res['delivery_city'];
                $recordListing[$i][++$j] = $dest_state;
                $recordListing[$i][++$j] = $pkgtype;
                $recordListing[$i][++$j] = $attemptCount;
                $recordListing[$i][++$j] = $first_attempt;
                $recordListing[$i][++$j] = $last_attempt;
                $recordListing[$i][++$j] = $promisedate;
                $recordListing[$i][++$j] = $checkreason;
                $recordListing[$i][++$j] = $delivery_date;
                $recordListing[$i][++$j] = $remarks;
                $recordListing[$i][++$j] = $fecalldate;
                $recordListing[$i][++$j] = "";
                $recordListing[$i][++$j] = $firstreturndate;
                $recordListing[$i][++$j] = $returndispatchcnt;
                $recordListing[$i][++$j] = $firstreturndispatchdt;
                $recordListing[$i][++$j] = $returnPromiseDate;
                $recordListing[$i][++$j] = $rtodtodate;
                $recordListing[$i][++$j] = $ord_stats;
                $recordListing[$i][++$j] = $txnclosed;
                $recordListing[$i][++$j] = $ontime;
                $recordListing[$i][++$j] = $days;
                $recordListing[$i][++$j] = "";
                $recordListing[$i][++$j] = $zone;
                $recordListing[$i][++$j] = $goods_value;
                $recordListing[$i][++$j] = $charged_weight;
                $recordListing[$i][++$j] = $res['vendor_name'];
                $recordListing[$i][++$j] = $res['ordtype_code'] === null ? "Normal" : $res['ordtype_code'];

                $i++;
                $cntr++;
            }

            $final_data = json_encode($recordListing);
        } else {
            $final_data = '[]';
        }

        $response = '{"draw":' . $draw . ',"recordsTotal":' . $totalRecords . ',"recordsFiltered":' . $recordsFiltered . ',"data":' . $final_data . '}';

        log_error(UNIQLO_LOG_PREFIX . "ajaxListing outbound data: " . $response);

        echo $response;
    }

    /* get the docket failure reason from edi transactions table */
    public function getedifailresponse($userid, $ordid, $vendor_id)
    {
        $response = "";
        $edi_id = 8;
        if ($vendor_id == '311') {
            $edi_id = 9;
        } elseif ($vendor_id == '312') {
            $edi_id = 10;
        }
        $qrywhr = array(
            "edi_id" => $edi_id,
            "edi_type" => 1,
            "bounded_type" => 2,
            "user_id" => $userid,
            "txn_obj_id" => $ordid,
            "status" => 0
        );
        $qryres = $this->common->gettblrowdata($qrywhr, "edi_response", "tb_etn_edi_transactions", 0, 0);
        if (count($qryres) > 0) {
            $postresp = json_decode($qryres['edi_response'], true);
            if ($edi_id == 8) {
                if (isset($postresp['success'])) {
                    $resp = isset($postresp['rmk']) ? $postresp['rmk'] : "";
                    if (isset($postresp['packages'])) {
                        if (!empty($postresp['packages'])) {
                            $remark = isset($postresp['packages'][0]['remarks']) ? $postresp['packages'][0]['remarks'] : array();
                            if (!empty($remark)) {
                                $response .= isset($remark[0]) ? trim($remark[0]) : "";
                            }
                        }
                    }
                    $response .= ", " . $resp;
                }
            } elseif ($edi_id == 9) {
                if (isset($postresp['shipments'])) {
                    $respc = isset($postresp['shipments'][0]) ? $postresp['shipments'][0] : array();
                    $response = isset($respc['reason']) ? $respc['reason'] : "";
                }
            } elseif ($edi_id == 10) {
                if (isset($postresp['AddManifestDetails'])) {
                    foreach ($postresp['AddManifestDetails'] as $res) {
                        if (isset($res['AuthKey']) && $res['AuthKey'] != "Valid") {
                            if (isset($res['ReturnMessage']) && $res['ReturnMessage'] != "successful") {
                                $response = isset($res['ReturnMessage']) ? $res['ReturnMessage'] : "";
                            }
                        } else {
                            $response = isset($res['ReturnMessage']) ? $res['ReturnMessage'] : "";
                        }
                    }
                }
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "getedifailresponse outbound data: " . $response);

        return $response;
    }

    /**
     * for Datatables_model->datatablesQuery purpose
     * there query params are passed as string
     * can't use strict query binding
     *
     * @param string $query
     * @param array $params
     * @return string
     */
    private function glueQueryStringWithParamsBinding (string $query, array $params): string {
        foreach ($params as $param) {
            $query = preg_replace(
                '#\?#',
                is_array($param) ? ' ( ' . implode(
                        ', ',
                        array_map(function ($item) {
                            return $this->db->escape($item);
                        }, $param)
                    ) . ' ) ' : $this->db->escape($param),
                $query,
                true
            );
        }
        return $query;
    }

    private function calculateDelayDays($deliveryDate, $promiseDate, $returnPromiseDate, $orderTypeCode, $status)
    {
        $deliveryDate = strtotime(date('Y-m-d', strtotime($deliveryDate)));
        $stringPromiseDate = strtotime(date('Y-m-d', strtotime($promiseDate)));
        $stringReturnPromiseDate = strtotime(date('Y-m-d', strtotime($returnPromiseDate)));
        $currentDate = strtotime(date('Y-m-d'));

        if ($orderTypeCode == 'SO') {
            $days = empty($promiseDate) ? 'N/A' : ($stringPromiseDate - $deliveryDate) / (60 * 60 * 24);
        }
        if ($orderTypeCode == 'Return') {
            $days = empty($returnPromiseDate) ? 'N/A' : ($stringReturnPromiseDate - $deliveryDate) / (60 * 60 * 24);
        }
        if (in_array($status, ["In Transit", "Return In Transit"])) {
            $days = empty($promiseDate) ? 'N/A' : ($stringPromiseDate - $currentDate) / (60 * 60 * 24);
        }
        if ($orderTypeCode == 'CC' || $status == 'Lost') {
            $days = "";
        }

        return $days ?? "";
    }
}
