<?php

use App\Order\Constants\OrderSources;
use App\Reporting\MisReport\AttemptsCalculator;
use App\Reporting\MisReport\AttemptsCalculatorFeatureFlag;
use App\Reporting\MisReport\CurrentStatusFeatureFlag;
use App\Reporting\MisReport\DeliveryStatus;
use App\Reporting\MisReport\DeliveryStatusFeatureFlag;
use App\Time\Timer;
use App\Reporting\MisReport\CurrentStatus;

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

ini_set('memory_limit', '4096M');
ini_set('max_execution_time', 2000);

require_once APPPATH . "/third_party/PHPExcel.php";

/**
 * @property CI_Email $email
 */
class Misreportnotify extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('common');
        $this->load->helper('log_helper');
        $this->load->library('misreportlib');
        $this->load->helper('promisedate_helper');
    }

    /**
     * Generate MIS Report as XLSX and send it by email. Report is following general rules:
     * 1. Include all orders from last 30 days
     * 2. Include all not closed orders for last 90 days
     */
    public function index(string $fromDate = '', int $latestDaysCount = 0, int $pastDaysCount = 0): void
    {
        $this->load->model('DataArrayFormatter_model');
        $this->load->model('DataQueryFormatter_model');
        $this->load->model('Datatables_model');
        $this->load->model('Uniqlomodel');

        $userid = '244';
        $curtz = 'Asia/Kolkata';
        $orderTableCondition = [];
        $validateDateValuesFlag = $this->validateDateValues($fromDate,$latestDaysCount,$pastDaysCount);
        if ($fromDate != '' && !$validateDateValuesFlag) {
            echo "date & days range values validation failed";
            return;
        }
        $triggeredFromUrl = false;
        if($fromDate != '' && $validateDateValuesFlag){
            $triggeredFromUrl = true;
            $mcurdt = date('Y-m-d', strtotime($fromDate));
            $prevDt = date("Y-m-d", strtotime("-{$latestDaysCount} days", strtotime($mcurdt)));
            $prevShortDate = date("Y-m-d", strtotime("-1 day", strtotime($prevDt)));
            $prevLongDate = date("Y-m-d", strtotime("-{$pastDaysCount} days", strtotime($prevShortDate)));
        } else {
            $mcurdt = date("Y-m-d");
            /* past 30 days for current day */
            $prevDt = date("Y-m-d", strtotime("-30 days", strtotime($mcurdt)));
            /* past 31 day and past day 90 from past 31st day for not closed orders */
            $prevShortDate = date("Y-m-d", strtotime("-1 day", strtotime($prevDt)));
            $prevLongDate = date("Y-m-d", strtotime("-59 days", strtotime($prevShortDate)));
        }
        $orderTableCondition[] = "DATE(o.createdon)" . " >= '" . $prevDt . "'";
        $orderTableCondition[] = "DATE(o.createdon)" . " <= '" . $mcurdt . "'";
        $orderTableCondition[] = 'o.status!=0';
        $orderTableCondition[] = "o.user_id = '$userid' ";
        $orderTableWhere = implode(' AND ', $orderTableCondition);
        $orderTableWhere = " and $orderTableWhere ";
        $selectColumns = [
            'o.id',
            'o.order_id',
            'o.delivery_datetime',
            'o.goods_value',
            'o.pickup_city',
            'o.pickup_pincode',
            'o.pickup_address1',
            'o.pickup_address2',
            'o.delivery_company',
            'o.delivery_city',
            'o.delivery_address1',
            'o.delivery_address2',
            'o.delivery_pincode',
            'o.weight',
            'o.company_code',
            'o.branch_code',
            'o.createdon',
            'o.shift_id',
            'o.vendor_id',
            'o.customer_id',
            'o.trip_sts',
            'o.quantity',
            'o.created_source',
            'cust.location as customer_loc',
            'od.order_type',
            'od.promise_deliver_date',
            'od.no_of_attempt',
            'ot.type_name',
            'ot.ordtype_code',
            'v.name as vendor_name',
        ];
        $table_name = 'tb_orders o';
        $indexColumn = 'o.createdon';
        $whrculumn = 'o.id';
        $wherecondition = $whrculumn . "!='' " . $orderTableWhere;
        $joinsArray[] = [
            'table_name' => 'tb_customers as cust',
            'condition' => "cust.id=o.customer_id",
            'join_type' => 'left'
        ];
        $joinsArray[] = [
            'table_name' => 'tb_order_details as od',
            'condition' => "od.order_row_id=o.id",
            'join_type' => 'left'
        ];
        $joinsArray[] = [
            'table_name' => 'tb_order_types ot',
            'condition' => "od.order_type=ot.id",
            'join_type' => 'left'
        ];
        $joinsArray[] = [
            'table_name' => 'tb_vendors v',
            'condition' => "v.id=o.vendor_id",
            'join_type' => 'left'
        ];
        $getRecordListing = $this->Datatables_model->datatablesMISQuery(
            $selectColumns,
            $table_name,
            $joinsArray,
            $wherecondition,
            $indexColumn
        );
        /*past 90 days not closed order data*/
        $noCloseOrderCondition[] = "DATE(o.createdon)" . " >= '" . $prevLongDate . "'";
        $noCloseOrderCondition[] = "DATE(o.createdon)" . " <= '" . $prevShortDate . "'";
        $noCloseOrderCondition[] = 'o.status!=0';
        $noCloseOrderCondition[] = "o.user_id = '$userid' ";
        $noCloseOrderTableWhere = implode(' AND ', $noCloseOrderCondition);
        $noCloseOrderTableWhere = " AND o.trip_sts=0 AND $noCloseOrderTableWhere ";
        $whereNpCloseOrdcondition = $whrculumn . "!='' " . $noCloseOrderTableWhere;
        $getNoCloseRecordListing = $this->Datatables_model->datatablesMISQuery(
            $selectColumns,
            $table_name,
            $joinsArray,
            $whereNpCloseOrdcondition,
            $indexColumn
        );
        if (!empty($getNoCloseRecordListing['data'])) {
            array_push($getNoCloseRecordListing['data'], ...$getRecordListing['data']);
            $getRecordListing['data'] = $getNoCloseRecordListing['data'];
        }
        $pickStatusArray = $deliveredStatusArray = $genericStatusArray = $trackStatusArray = $scanStatusArray = $regionZoneArray = $ediResponseArray = $getStatusDatesForPromiseDate = $cargoWeight = [];
        $reqData = array(
            'id',
            'shift_id',
            'created_source',
            'pickup_city',
            'delivery_city',
            'pickup_pincode',
            'delivery_pincode'
        );
        $this->db->query('SET SESSION group_concat_max_len=1000000');
        $formattedData = $this->DataArrayFormatter_model->getCommaSeparatedUnqiloOrdFields(
            $reqData,
            $getRecordListing['data']
        );
        if (isset($formattedData['commaSeparated']['id']) && $formattedData['commaSeparated']['id'] != '') {
            $codes = "'DQ','AWB','PO','ORD','XSR'";
            $formattedData = $this->DataQueryFormatter_model->getUniqloOrderReferenceData(
                $formattedData['commaSeparated']['id'],
                $formattedData,
                $codes
            );
            $trackStatusArray = $this->Uniqlomodel->getOrderTrackData($formattedData['commaSeparated']['id']);
            $scanStatusArray = $this->Uniqlomodel->getOrderScanData($formattedData['commaSeparated']['id']);
            //$ediResponseArray = $this->Uniqlomodel->getEdiResponseData($formattedData['commaSeparated']['id'], $userid);
            $cargoWeight = $this->Uniqlomodel->getOrderCargoWeight($formattedData['commaSeparated']['id']);
        }
        if (isset($formattedData['commaSeparated']['shift_id']) && $formattedData['commaSeparated']['shift_id'] > 0) {
            $deliveredStatusArray = $this->Uniqlomodel->getOrderStatusDelvier(
                $formattedData['commaSeparated']['shift_id']
            );
            $genericStatusArray = $this->Uniqlomodel->getOrderStatusGeneric(
                $formattedData['commaSeparated']['shift_id']
            );
            $pickStatusArray = $this->Uniqlomodel->getOrderStatusPicked($formattedData['commaSeparated']['shift_id']);
            // $getStatusDatesForPromiseDate = $this->common->gettbldata("shipment_id IN (" . $formattedData['commaSeparated']['shift_id'] . ") AND shipment_id > 0 AND status ='1' AND status_code IN ('0470','2300','RTO','DTO')", "shipment_id,stop_type,status_id,status_code,createdon", "tb_stop_status", 0, 0);
            $getStatusDatesForPromiseDate = $this->Uniqlomodel->getStatusDatesForPromiseDate($formattedData['commaSeparated']['shift_id']);
        }
        if (isset($formattedData['commaSeparated']['pickup_pincode']) && $formattedData['commaSeparated']['pickup_pincode'] != '') {
            $pickpincodes = $formattedData['commaSeparated']['pickup_pincode'];
            $deliverpincodes = $formattedData['commaSeparated']['delivery_pincode'];
            $allpincodes = $pickpincodes . "," . $deliverpincodes;
            $pincodearr = explode(",", $allpincodes);
            $pincodetrim = array_map("trim", $pincodearr);
            $pincodelist = array_unique($pincodetrim);
            $totpincodes = '"' . implode('","', $pincodelist) . '"';
            $pickcitys = $formattedData['commaSeparated']['pickup_city'];
            $delivercitys = $formattedData['commaSeparated']['delivery_city'];
            $allcitys = $pickcitys . "," . $delivercitys . ",Bilaspur-HR";
            $citiesarr = explode(",", $allcitys);
            $citiestrim = array_map("trim", $citiesarr);
            $citieslist = array_unique($citiestrim);
            $totcities = '"' . implode('","', $citieslist) . '"';
            $regionZoneArray = $this->Uniqlomodel->getRegionZonesData($totpincodes, $totcities);
        }
        $getRecordListing = $recordListing = $ediResponse = [];
        if (isset($formattedData['orders'])) {
            $getRecordListing = $formattedData['orders'];
        }
        foreach ($ediResponseArray as $eachLine) {
            $orderId = $eachLine['txn_obj_id'];
            $ediId = $eachLine['edi_id'];
            $response = json_decode($eachLine['edi_response'], true);
            $finalResponse = "";
            if ($ediId == 8) {
                if (isset($response['success'])) {
                    $resp = $response['rmk'] ?? "";
                    if (isset($response['packages'])) {
                        if (!empty($response['packages'])) {
                            $remark = $response['packages'][0]['remarks'] ?? [];
                            if (!empty($remark)) {
                                $finalResponse .= trim($remark[0]) ?? "";
                            }
                        }
                    }
                    $finalResponse .= ", " . $resp;
                }
            } elseif ($ediId == 9) {
                if (isset($response['shipments'])) {
                    $respc = $response['shipments'][0] ?? [];
                    $finalResponse = $respc['reason'] ?? "";
                }
            } elseif ($ediId == 10) {
                if (isset($response['AddManifestDetails'])) {
                    foreach ($response['AddManifestDetails'] as $res) {
                        if (isset($res['AuthKey']) && $res['AuthKey'] != "Valid") {
                            if (isset($res['ReturnMessage']) && $res['ReturnMessage'] != "successful") {
                                $finalResponse = $res['ReturnMessage'] ?? "";
                            }
                        } else {
                            $finalResponse = $res['ReturnMessage'] ?? "";
                        }
                    }
                }
            }
            $ediResponse[$orderId] = $finalResponse;
        }
        foreach ($getStatusDatesForPromiseDate as $eachLine) {
            $shipmentId = $eachLine['shipment_id'];
            if ($eachLine['status_code'] == "0470") {
                $manifestDateTime[$shipmentId] = $eachLine['createdon'];
            }
            if ($eachLine['stop_type'] == "D") {
                if (in_array($eachLine['status_code'], ['DTO', '2300']) || $eachLine['status_id'] == 1) {
                    $deliveredStatusDateTime[$shipmentId] = ucwords(date("d M Y", strtotime($eachLine['createdon'])));
                }
                if ($eachLine['status_code'] == "RTO") {
                    $rtoStatusDateTime[$shipmentId] = ucwords(date("d M Y", strtotime($eachLine['createdon'])));
                }
            }
        }
        if (!empty($getRecordListing)) {
            $cntr = 1;
            $currentStatusFeatureFlag = CurrentStatusFeatureFlag::isEnabled();
            $attemptsCalculatorFeatureFlag = AttemptsCalculatorFeatureFlag::isEnabled();
            $deliveryStatusFeatureFlag = DeliveryStatusFeatureFlag::isEnabled();
            foreach ($getRecordListing as $res) {
                $cust_reference_num = $lr_num = $container_num = '';
                $referenceData = '';
                $orderSource = intval($res['created_source']);
                $vendorId = intval($res['vendor_id']);

                if (isset($res['reference_value'])) {
                    $referenceData = $res['reference_value'];
                }
                if ($referenceData != '') {
                    $arrayData = $this->DataArrayFormatter_model->formatReferenceParameters($referenceData);
                    if ($orderSource == OrderSources::SWIFTLOG_RETURN) {
                        if (isset($arrayData['DQ'])) {
                            $lr_num = $arrayData['DQ'];
                        }
                        if (isset($arrayData['XSR'])) {
                            $cust_reference_num = $arrayData['XSR'];
                        }
                    } else {
                        if (isset($arrayData['PO'])) {
                            $lr_num = $arrayData['PO'];
                        }
                        if (isset($arrayData['DQ'])) {
                            $cust_reference_num = $arrayData['DQ'];
                        }
                    }
                    if (isset($arrayData['AWB'])) {
                        $container_num = $arrayData['AWB'];
                    }
                }
                $last_status_name = $delivery_date = $rtodtodate = "";
                $manifestdated = "";
                $ststype = $ord_stats = "Undelivered";
                $txnclosed = "Open";
                $reqStatusData = array('status_code' => '', 'stop_type' => '', 'status_id' => '', 'createdon' => '');
                if (isset($res['shift_id']) && $res['shift_id'] != '' && $res['shift_id'] != 0) {
                    $shiftIndex = $res['shift_id'];
                    if (isset($deliveredStatusArray[$shiftIndex])) {
                        $last_status_name = $deliveredStatusArray[$shiftIndex]['delivered_status_status_name'];
                        $reqStatusData['status_id'] = $deliveredStatusArray[$shiftIndex]['delivered_status_status_id'];
                        $reqStatusData['status_code'] = $deliveredStatusArray[$shiftIndex]['delivered_status_status_code'];
                        $reqStatusData['stop_type'] = $deliveredStatusArray[$shiftIndex]['delivered_status_stop_type'];
                        $reqStatusData['createdon'] = $deliveredStatusArray[$shiftIndex]['delivered_status_createdon'];
                        $ststype = "Delivered";
                        $txnclosed = "Closed";
                        $ord_stats = "Delivered";
                        if ($reqStatusData['createdon'] != "") {
                            if ($reqStatusData['status_code'] !== "RTO" && $vendorId !== 311) {
                                $deldate1 = getdatetimebytimezone($curtz, $reqStatusData['createdon'], DFLT_TZ);
                                $delivery_date = $deldate1['datetime'];
                            }
                        }
                        if ($reqStatusData['status_code'] == "RTO" || $reqStatusData['status_code'] == "DTO") {
                            $rtodtodate = $delivery_date;
                        }
                    } elseif (isset($genericStatusArray[$shiftIndex])) {
                        $last_status_name = $genericStatusArray[$shiftIndex]['generic_status_status_name'];
                        $reqStatusData['status_id'] = $genericStatusArray[$shiftIndex]['generic_status_status_id'];
                        $reqStatusData['status_code'] = $genericStatusArray[$shiftIndex]['generic_status_status_code'];
                        $reqStatusData['stop_type'] = $genericStatusArray[$shiftIndex]['generic_status_stop_type'];
                        $reqStatusData['createdon'] = $genericStatusArray[$shiftIndex]['generic_status_createdon'];
                    }
                }
                $pkgtype = "Prepaid";
                $firstreturndispatchdt = $returnPromiseDate = "";

                if ($res['trip_sts'] == 1) {
                    $txnclosed = "Closed";
                    $ord_stats = "Delivered";
                }
                $returndispatchcnt = $attemptcount = 0;
                if ($last_status_name == "Cancelled" || $last_status_name == "Canceled") {
                    $last_status_name = "Cancelled";
                    $ord_stats = "Cancelled";
                    $txnclosed = "Closed";
                }
                /*check report status and date times*/
                $pickupdate1 = "";
                if (!empty($pickStatusArray)) {
                    $pickstsindex = $res['shift_id'];
                    if (isset($pickStatusArray[$pickstsindex])) {
                        $pickstscode = $pickStatusArray[$pickstsindex]['pickup_status_status_code'];
                        if ($orderSource === OrderSources::SWIFTLOG && $pickstscode == '0500') {
                            $pickupdate1 = $pickStatusArray[$pickstsindex]['pickup_status_createdon'];
                            $chkrtime = getdatetimebytimezone($curtz, $pickupdate1, DFLT_TZ);
                            $pickupdate1 = $chkrtime['datetime'];
                        } else {
                            $pickupdate1 = $pickStatusArray[$pickstsindex]['pickup_status_createdon'];
                            $chkrtime = getdatetimebytimezone($curtz, $pickupdate1, DFLT_TZ);
                            $pickupdate1 = $chkrtime['datetime'];
                        }
                    }
                }
                $dest_state = "";
                if ($orderSource === OrderSources::SWIFTLOG) {
                    $deliverycity = $res['delivery_city'];
                    $delivery_address2 = $res['delivery_address2'];
                    $chkdblspace = strrpos($deliverycity, "  ");
                    if ($chkdblspace) {
                        $citystate = explode("  ", $deliverycity);
                        if (count($citystate) > 1) {
                            $dest_state = trim($citystate[0]); /*state*/
                            $res['delivery_city'] = trim($citystate[1]); /*city*/
                        }
                    }
                    if ($dest_state == "") {
                        $dest_cnt = explode(", ", $delivery_address2);
                        if (!empty($dest_cnt)) {
                            if (count($dest_cnt) > 0) {
                                $dest_state = $dest_cnt[count($dest_cnt) - 1] ?? "";
                            }
                        }
                    }
                } else {
                    $dest_state = 'Haryana';
                }
                if ($dest_state == "") {
                    $dest_state = $delivery_address2;
                }
                $first_attempt = $last_attempt = $promisedate = $remarks = $fecalldate = "";
                $j = 0;
                $attemptchk = $cancelchk = $rtoreason = "";
                $invoice_amount = 0;
                if (!empty($trackStatusArray)) {
                    $trackstsindex = $res['id'];
                    if (isset($trackStatusArray[$trackstsindex])) {
                        $invoice_amount = $trackStatusArray[$trackstsindex]['track_invoice_amount'];
                    }
                }

                $ordscanDataArray = $this->misreportlib->orderScanData($res, ($scanStatusArray[$res['id']] ?? []));

                if (!empty($ordscanDataArray)) {
                    if ($currentStatusFeatureFlag) {
                        $currentStatus = new CurrentStatus($ordscanDataArray, $last_status_name);
                        $remarks = $currentStatus->remarks();
                        $ststype = $currentStatus->statusType();
                        $last_status_name = $currentStatus->lastStatusName();
                        $currentStatus = isset($currentStatus) ? $currentStatus->currentStatus($ststype) : $ststype;
                    } else {
                        $recentrecord = $ordscanDataArray[count($ordscanDataArray) - 1];
                        if ($last_status_name != "Delivered" && $last_status_name != "In-Transit") {
                            $last_status_name = $recentrecord['scan_val'];
                            if ($last_status_name == "Canceled") {
                                $last_status_name = "Cancelled";
                            }
                        }
                        $remarks = $recentrecord['scan_instruction'];
                        $ststype = $recentrecord['scan_val'];
                        $currentStatus = $recentrecord['scan_instruction'] ?? $last_status_name;
                    }

                    if ($attemptsCalculatorFeatureFlag && in_array($vendorId, [310,311])) {
                        try {
                            $attempts = new AttemptsCalculator($orderSource, $ordscanDataArray, $vendorId, $ststype);
                        } catch (Exception $e) {
                            log_error(UNIQLO_LOG_PREFIX . "Misreport PHPExel_Writer_Exception " . $e->getMessage());
                        }
                    }
                    if (isset($attempts)) {
                        $manifestdated = $attempts->manifested();
                        if ($pickupdate1 == "") {
                            $pickupdate1 = $attempts->pickupDate();
                        }
                        $attemptcount = $attempts->pickupsInTotal();
                        $returndispatchcnt = $attempts->returnDispatchInTotal();
                        $firstreturndispatchdt = $attempts->firstReturnDispatch();
                        $first_attempt = $attempts->firstPickup();
                        $last_attempt = $attempts->lastPickup();
                        $delivery_date = $attempts->deliveryDate();
                        $txnclosed = $attempts->txnclosed();
                        $rtodtodate = $attempts->rtodtodate();
                        $rtoreason = $attempts->rtoreason();
                        $cancelchk = $attempts->cancelchk();
                        $fecalldate = $attempts->fecalldate();
                    } else {
                        $ecomdispatches = ['006', '77', '80', '82', '83', '100', '016'];

                        foreach ($ordscanDataArray as $stsres) {
                            if (($stsres['scan_val'] == "Manifested") || ($stsres['scan_instruction'] == "Shipment details manifested") || ($stsres['scan_status_code'] == '014') || ($stsres['scan_status_code'] == '016') || ($stsres['scan_status_code'] == '003')) {
                                $manifestdated = $stsres['scan_status_time'];
                            }
                            if (($stsres['scan_val'] == "In Transit" or $stsres['scan_val'] == "Open") && ($stsres['scan_instruction'] == "Pickup completed" || $stsres['scan_instruction'] == "Shipment picked up")) {
                                $pickupdate1 = $stsres['scan_status_time'];
                            }
                            if ($stsres['scan_val'] == "Shipment Picked Up") {
                                $pickupdate1 = $stsres['scan_status_time'];
                            }

                            if (in_array($stsres['scan_status_code'], $ecomdispatches)) {
                                $attemptcount += 1;
                                $returndispatchcnt += 1;
                                if ($j == 0) {
                                    $first_attempt = $stsres['scan_status_time'];
                                    $firstreturndispatchdt = $stsres['scan_status_time'];
                                }
                                if ($j > 0) {
                                    $last_attempt = $stsres['scan_status_time'];
                                }
                                $attemptchk = $stsres['scan_status_time'];
                                $j++;
                            }

                            if (in_array($stsres['scan_val'], ["Dispatched", "Out for delivery", "Out for Return"]) &&
                                in_array($stsres['scan_instruction'], ["Out for delivery", "Out for pickup"])
                                && $vendorId !== 311) {
                                $attemptcount += 1;
                                $returndispatchcnt += 1;
                                if ($j == 0) {
                                    $first_attempt = $stsres['scan_status_time'];
                                    $firstreturndispatchdt = $stsres['scan_status_time'];
                                }
                                if ($j > 0) {
                                    $last_attempt = $stsres['scan_status_time'];
                                }
                                $attemptchk = $stsres['scan_status_time'];
                                $j++;
                            }

                            $deliveredStatusCode = ['200', '20001', '20002', '345', '34501', '239', '20003', '999'];
                            if ($stsres['scan_val'] === "Delivered" || in_array(
                                    $stsres['scan_status_code'],
                                    $deliveredStatusCode
                                )) {
                                $delivery_date = $stsres['scan_status_time'];
                                $txnclosed = "Closed";
                            }

                            if (($vendorId === 310 && $stsres['prev_scan_val'] === "RTO") || $stsres['prev_scan_val'] === "DTO") {
                                $delivery_date = $stsres['scan_status_time'];
                                $txnclosed = "Closed";
                                $rtodtodate = $stsres['scan_status_time'];
                            }
                            if ($ststype == "RTO" || $stsres['scan_status_code'] == "777") {
                                if ($stsres['scan_val'] == "In Transit" && $stsres['scan_type'] == "UD") {
                                    $rtoreason .= $stsres['scan_instruction'] . ", ";
                                }
                            }
                            if ($stsres['scan_val'] == "Canceled" || ($stsres['scan_val'] == "Not Picked" && $stsres['scan_type'] == "UD") || ($stsres['scan_instruction'] == "Seller cancelled the order" || $stsres['scan_instruction'] == "Pickup/KYC request cancelled")) {
                                $cancelchk = $stsres['scan_instruction'];
                            }
                            if ($stsres['call_duration'] > 0) {
                                $fecalldate = $stsres['scan_status_time'];
                            }

                            if ($attemptcount > 0 && $first_attempt == "" && $attemptchk != "") {
                                $first_attempt = $attemptchk;
                            }
                        }
                    }
                }

                if (($last_status_name == "Gate Out" || $last_status_name == "Shipment Received at Facility")) {
                    if ($pickupdate1 != "") {
                        $last_status_name = "Picked";
                    } else {
                        $last_status_name = "Pending";
                        $ststype = "Pending";
                    }
                }
                if ($last_status_name == "Booked by Supplier") {
                    $last_status_name = "Pending";
                    $ststype = "Pending";
                }
                if ($orderSource === OrderSources::SWIFTLOG_RETURN) {
                    $pkgtype = "Pickup";
                }

                $zone = "";

                if (!empty($regionZoneArray)) {
                    $orderCarrier = $vendorId;
                    if ($orderCarrier == 0) {
                        $orderCarrier = 310;
                    }
                    $cczoneindex = $res['pickup_pincode'] . "_" . $res['delivery_pincode'] . "_310";
                    if ($orderSource === OrderSources::SWIFTLOG) {
                        $zoneindex = $res['pickup_pincode'] . "_" . $res['delivery_pincode'] . "_" . $orderCarrier;
                        /* cc order carrier index change to delhivery carrier*/
                        $cczoneindex = $res['pickup_pincode'] . "_" . $res['delivery_pincode'] . "_310";
                    } else {
                        $zoneindex = $res['delivery_pincode'] . "_" . $res['pickup_pincode'] . "_" . $orderCarrier;
                    }
                    if (isset($regionZoneArray[$zoneindex])) {
                        $zone = $regionZoneArray[$zoneindex]['zone_carrier_zone'];
                    } elseif (isset($regionZoneArray[$cczoneindex])) {
                        $zone = $regionZoneArray[$cczoneindex]['zone_carrier_zone'];
                    }
                }
                if (strpos($res['promise_deliver_date'], "1970-01-01") !== false) {
                    $this->load->model('Reportmodel');
                    $shipmentStopStatusLists = $this->Reportmodel->getShipmentStopStatusLists($res['shift_id'], $curtz, $res['branch_code']);
                    foreach ($shipmentStopStatusLists as $shipmentStopStatus) {
                        if ($shipmentStopStatus['stop_type'] === "D" && (($shipmentStopStatus['status_code'] === 'DTO' || $shipmentStopStatus['status_code'] === '2300' || $shipmentStopStatus['status_id'] == 1) || ($vendorId == "310" && $shipmentStopStatus['status_code'] === 'RTO'))) {
                                $res['promise_deliver_date'] = date("d M Y", strtotime($shipmentStopStatus['createdon']));
                        }
                    }
                }
                if($res['promise_deliver_date'] != ""){
                    $promisedate = $returnPromiseDate = $res['promise_deliver_date'];
                }
                if ($promisedate == '') {
                    $promisedate = getPromiseDate(
                        [
                            'orderRowId' => $res['id'],
                            'containerNumber' => $container_num ?? "",
                            'orderSource' => $orderSource,
                            'pickupPincode' => $res['pickup_pincode'],
                            'deliveryPincode' => $res['delivery_pincode'],
                            'vendorId' => $vendorId,
                            'shiftId' => $res['shift_id'],
                            'companyCode' => $res['company_code'],
                            'branchCode' => $res['branch_code'],
                            'timeZone' => $curtz,
                            'deliveryDateTime' => $res['delivery_datetime'],
                            'orderTypeName' => $res['type_name'],
                            'manifestDateTime' => $manifestDateTime[$res['shift_id']] ?? "",
                            'deliveredDateTime' => $deliveredStatusDateTime[$res['shift_id']] ?? "",
                            'rtoStatusDateTime' => $rtoStatusDateTime[$res['shift_id']] ?? ""
                        ]
                    );
                }
                if ($res['no_of_attempt'] != 0) {
                    $attemptcount = $res['no_of_attempt'];
                }
                $checkreason = "";
                if ($container_num == "") {
                    $last_status_name = $ststype = "Pending";
                    $checkreason =  $ediResponse[$res['id']] ?? "";
                    //$checkreason = $this->getedifailresponse($userid, $res['id'], $vendorId);
                }

                if ($deliveryStatusFeatureFlag) {
                    $deliveryStatus = new DeliveryStatus($delivery_date, $promisedate, $res['ordtype_code'] ?? '', $ststype, new Timer());
                    $days = $deliveryStatus->delayDays();
                    $ontime = $deliveryStatus->deliveryStatus();
                } else {
                    $days = $this->calculateDelayDays(
                        $delivery_date,
                        $promisedate,
                        $returnPromiseDate,
                        $res['ordtype_code'],
                        $ststype
                    );
                    $ontime = $days === 'N/A' ? $days : ($days > 0 ? "Early" : ($days < 0 ? "Delay" : "On-Time"));
                }

                if ($res['delivery_city'] == "") {
                    if ($res['delivery_address1'] != "") {
                        $res['delivery_city'] = $res['delivery_address1'];
                    }
                    if ($res['delivery_city'] == "") {
                        $res['delivery_city'] = $res['delivery_address2'];
                    }
                }
                $charged_weight = 0;
                if (isset($cargoWeight[$res['id']])) {
                    $charged_weight = $cargoWeight[$res['id']] ? round($cargoWeight[$res['id']], 2) : round($res['weight'], 2);
                }
                if ($orderSource === OrderSources::SWIFTLOG) {
                    $returnPromiseDate = "";
                    $firstreturndispatchdt = "";
                }
                if ($delivery_date == "" && $ord_stats == "Delivered") {
                    if ($cancelchk != "") {
                        $ord_stats = "Cancelled";
                        $last_status_name = "Cancelled";
                        $ststype = "Cancelled";
                        $remarks = $cancelchk;
                        $txnclosed = "Closed";
                    }
                }
                if ($orderSource === OrderSources::SWIFTLOG) {
                    if ($first_attempt == "" && $delivery_date != "") {
                        $first_attempt = $delivery_date;
                        $last_attempt = $delivery_date;
                    }
                    if ($last_attempt == "" && $delivery_date != "") {
                        $last_attempt = $delivery_date;
                    }
                } else {
                    if ($first_attempt == "" && $pickupdate1 != "") {
                        $first_attempt = $pickupdate1;
                        $last_attempt = $pickupdate1;
                    }
                    if ($last_attempt == "" && $pickupdate1 != "") {
                        $last_attempt = $pickupdate1;
                    }
                    if ($ststype == "In Transit" || $ststype == "In-Transit") {
                        $ststype = "Return In-Transit";
                    }
                }
                if ($first_attempt != "") {
                    $first_attempt = date("Y-m-d", strtotime($first_attempt));
                }
                if ($last_attempt != "") {
                    $last_attempt = date("Y-m-d", strtotime($last_attempt));
                }
                if ($promisedate != "") {
                    $promisedate = date("Y-m-d", strtotime($promisedate));
                }
                if ($delivery_date != "") {
                    $delivery_date = date("Y-m-d", strtotime($delivery_date));
                }
                if ($fecalldate != "") {
                    $fecalldate = date("Y-m-d", strtotime($fecalldate));
                }
                if ($firstreturndispatchdt != "") {
                    $firstreturndispatchdt = date("Y-m-d", strtotime($firstreturndispatchdt));
                }
                if ($returnPromiseDate != "") {
                    $returnPromiseDate = date("Y-m-d", strtotime($returnPromiseDate));
                }
                if ($rtodtodate != "") {
                    $rtodtodate = date("Y-m-d", strtotime($rtodtodate));
                }
                if ($orderSource === OrderSources::SWIFTLOG) {
                    $returndispatchcnt = $firstreturndispatchdt = $returnPromiseDate = "";
                }
                if ($last_status_name == "Delivered") {
                    $remarks = "";
                    $ststype = "Delivered";
                }
                if ($checkreason != "") {
                    $remarks = $checkreason;
                }
                if ($rtoreason != "") {
                    $remarks = $rtoreason;
                }
                if ($last_status_name == "Soft data uploaded" || $last_status_name == "Shipment Uploaded") {
                    $last_status_name = "Pending";
                    $ststype = "Pending";
                }
                if ($last_status_name == "Shipment Picked Up") {
                    $last_status_name = "Picked";
                }
                $goods_value = $res['goods_value'];
                $carrier = $res['vendor_name'];
                $order_type = $res['ordtype_code'];
                if (strpos($promisedate, "1970-01-01") !== false) {
                    $promisedate= "";
                }
                $recordListing[] = [
                    'sno' => $cntr,
                    'container_num' => $container_num,
                    'customer_loc' => $res['customer_loc'],
                    'order_ym' => date("Y-m", strtotime($res['createdon'])),
                    'ponum' => $lr_num,
                    'sid' => $cust_reference_num,
                    'order_date' => $res['createdon'],
                    'manifest' => $manifestdated,
                    'pickupdate' => $pickupdate1,
                    'current_status' => $currentStatus ?? "",
                    'status_type' => $ststype,
                    'deliver_pin' => $res['delivery_pincode'],
                    'delivery_city' => $res['delivery_city'],
                    'deliver_state' => $dest_state,
                    'package_type' => $pkgtype,
                    'attempt_cnt' => $attemptcount,
                    'first_attempt' => $first_attempt,
                    'last_attempt' => $last_attempt,
                    'promisedate' => $promisedate,
                    'non_service' => $checkreason,
                    'deliver_date' => $delivery_date,
                    'remarks' => $remarks,
                    'fecall_date' => $fecalldate,
                    'client_action' => "",
                    'return_dispathcnt' => $returndispatchcnt,
                    'first_returndate' => $firstreturndispatchdt,
                    'return_promisedate' => $returnPromiseDate,
                    'rtodto_date' => $rtodtodate,
                    'ord_status' => $ord_stats,
                    'final_sts' => $txnclosed,
                    'ontime' => $ontime,
                    'days' => $days,
                    'special_remark' => "",
                    'zone' => $zone,
                    'shipment_amount' => $goods_value,
                    'invoice_amount' => $invoice_amount,
                    'charged_weight' => $charged_weight,
                    'carrier'=>$carrier,
                    'order_type' => $order_type
                ];
                $cntr++;
            }
            $final_data = $recordListing;
            $fileName = $this->download_misexceldata($final_data);
            if ($fileName != "") {
                $sendmailwithdata = $this->sendmailwithdata($fileName);
                if ($sendmailwithdata && $triggeredFromUrl) {
                    $this->output->enable_profiler(TRUE);
                    echo "email sent successfully from date  ". $prevLongDate ." to ". $mcurdt;
                    return;
                }
            }
        }
    }

    /* get the docket failure reason from edi transactions table */
    public function getedifailresponse($userid, $ordid, $vendor_id)
    {
        $response = "";
        $edi_id = 8;
        if ($vendor_id == '311') {
            $edi_id = 9;
        } elseif ($vendor_id == '312') {
            $edi_id = 10;
        }
        $qrywhr = array(
            "edi_id" => $edi_id,
            "edi_type" => 1,
            "bounded_type" => 2,
            "user_id" => $userid,
            "txn_obj_id" => $ordid,
            "status" => 0
        );
        $qryres = $this->common->gettblrowdata($qrywhr, "edi_response", "tb_etn_edi_transactions", 0, 0);
        if (count($qryres) > 0) {
            $postresp = json_decode($qryres['edi_response'], true);
            if ($edi_id == 8) {
                if (isset($postresp['success'])) {
                    $resp = isset($postresp['rmk']) ? $postresp['rmk'] : "";
                    if (isset($postresp['packages'])) {
                        if (!empty($postresp['packages'])) {
                            $remark = isset($postresp['packages'][0]['remarks']) ? $postresp['packages'][0]['remarks'] : array();
                            if (!empty($remark)) {
                                $response .= isset($remark[0]) ? trim($remark[0]) : "";
                            }
                        }
                    }
                    $response .= ", " . $resp;
                }
            } elseif ($edi_id == 9) {
                if (isset($postresp['shipments'])) {
                    $respc = isset($postresp['shipments'][0]) ? $postresp['shipments'][0] : array();
                    $response = isset($respc['reason']) ? $respc['reason'] : "";
                }
            } elseif ($edi_id == 10) {
                if (isset($postresp['AddManifestDetails'])) {
                    foreach ($postresp['AddManifestDetails'] as $res) {
                        if (isset($res['AuthKey']) && $res['AuthKey'] != "Valid") {
                            if (isset($res['ReturnMessage']) && $res['ReturnMessage'] != "successful") {
                                $response = isset($res['ReturnMessage']) ? $res['ReturnMessage'] : "";
                            }
                        } else {
                            $response = isset($res['ReturnMessage']) ? $res['ReturnMessage'] : "";
                        }
                    }
                }
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "getedifailresponse outbound data: " . $response);

        return $response;
    }

    private function download_misexceldata($data) : string
    {
        log_error(UNIQLO_LOG_PREFIX . "download_misexceldata inbound data is ready");

        $fileName = "";
        if (!empty($data)) {
            $styleArray = array(
                'font' => array(
                    'bold' => true,
                    'color' => array('rgb' => 'FFFFFF'),
                    'size' => 10,
                    'name' => 'Verdana'
                )
            );

            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_to_sqlite;
            $cacheSettings = array('memoryCacheSize' => '512MB');
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);

            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
                ->getStyle('A1:AM1')
                ->applyFromArray(
                    array(
                        'fill' => array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => array('rgb' => '0c3b81')
                        )
                    )
                );

            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'S.No');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Docket Number');
            $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Origin');
            $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'YEAR & MONTH');
            $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Order Number');
            $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'SID');
            $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Order Date');
            $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Manifest Date');
            $objPHPExcel->getActiveSheet()->getStyle('H1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Pickup Date');
            $objPHPExcel->getActiveSheet()->getStyle('I1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Current Status');
            $objPHPExcel->getActiveSheet()->getStyle('J1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Status Type');
            $objPHPExcel->getActiveSheet()->getStyle('K1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Destination PIN');
            $objPHPExcel->getActiveSheet()->getStyle('L1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Destination City');
            $objPHPExcel->getActiveSheet()->getStyle('M1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', 'Destination STATE');
            $objPHPExcel->getActiveSheet()->getStyle('N1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('O1', 'Package Type');
            $objPHPExcel->getActiveSheet()->getStyle('O1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('P1', 'Attempt Count');
            $objPHPExcel->getActiveSheet()->getStyle('P1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'First Attempt Date');
            $objPHPExcel->getActiveSheet()->getStyle('Q1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('R1', 'Last Attempt Date');
            $objPHPExcel->getActiveSheet()->getStyle('R1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('S1', 'Promise Date');
            $objPHPExcel->getActiveSheet()->getStyle('S1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('T1', 'Non Serviceable Zone Shipment');
            $objPHPExcel->getActiveSheet()->getStyle('T1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('U1', 'Delivered Date');
            $objPHPExcel->getActiveSheet()->getStyle('U1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('V1', 'Undelivered / Return Reason');
            $objPHPExcel->getActiveSheet()->getStyle('V1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('W1', 'FE Call Date');
            $objPHPExcel->getActiveSheet()->getStyle('W1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('X1', 'Action Required by Client');
            $objPHPExcel->getActiveSheet()->getStyle('X1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y1', 'First Return Date');
            $objPHPExcel->getActiveSheet()->getStyle('Y1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Z1', 'Return Dispatch Count');
            $objPHPExcel->getActiveSheet()->getStyle('Z1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AA1', 'First Return Dispatch Date');
            $objPHPExcel->getActiveSheet()->getStyle('AA1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AB1', 'Return Promise Date');
            $objPHPExcel->getActiveSheet()->getStyle('AB1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AC1', 'RTO/DTO Delivered Date');
            $objPHPExcel->getActiveSheet()->getStyle('AC1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AD1', 'Logistics Comment');
            $objPHPExcel->getActiveSheet()->getStyle('AD1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AE1', 'Transaction Status');
            $objPHPExcel->getActiveSheet()->getStyle('AE1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AF1', 'On-Time/Delay');
            $objPHPExcel->getActiveSheet()->getStyle('AF1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AG1', 'Early/Delay Days');
            $objPHPExcel->getActiveSheet()->getStyle('AG1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AH1', 'Special Remark');
            $objPHPExcel->getActiveSheet()->getStyle('AH1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AI1', 'Carrier Zone');
            $objPHPExcel->getActiveSheet()->getStyle('AI1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AJ1', 'Shipment Amount');
            $objPHPExcel->getActiveSheet()->getStyle('AJ1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AK1', 'Charged Weight');
            $objPHPExcel->getActiveSheet()->getStyle('AK1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AL1', 'Carrier');
            $objPHPExcel->getActiveSheet()->getStyle('AL1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AM1', 'Booking Type');
            $objPHPExcel->getActiveSheet()->getStyle('AM1')->applyFromArray($styleArray);
            $activeWorksheet = $objPHPExcel->getActiveSheet();

            log_error(UNIQLO_LOG_PREFIX . 'download_misexceldata start setting cell values');

            $rowCount = 2;

            try {
                foreach ($data as $result) {
                    $activeWorksheet->SetCellValue('A' . $rowCount, $result['sno']);
                    $activeWorksheet->SetCellValue('B' . $rowCount, $result['container_num']);
                    $activeWorksheet->SetCellValue('C' . $rowCount, $result['customer_loc']);
                    $activeWorksheet->SetCellValue('D' . $rowCount, $result['order_ym']);
                    $activeWorksheet->SetCellValue('E' . $rowCount, $result['ponum']);
                    $activeWorksheet->SetCellValue('F' . $rowCount, $result['sid']);
                    $activeWorksheet->SetCellValue('G' . $rowCount, $result['order_date']);
                    $activeWorksheet->SetCellValue('H' . $rowCount, $result['manifest']);
                    $activeWorksheet->SetCellValue('I' . $rowCount, $result['pickupdate']);
                    $activeWorksheet->SetCellValue('J' . $rowCount, $result['current_status']);
                    $activeWorksheet->SetCellValue('K' . $rowCount, $result['status_type']);
                    $activeWorksheet->SetCellValue('L' . $rowCount, $result['deliver_pin']);
                    $activeWorksheet->SetCellValue('M' . $rowCount, $result['delivery_city']);
                    $activeWorksheet->SetCellValue('N' . $rowCount, $result['deliver_state']);
                    $activeWorksheet->SetCellValue('O' . $rowCount, $result['package_type']);
                    $activeWorksheet->SetCellValue('P' . $rowCount, $result['attempt_cnt']);
                    $activeWorksheet->SetCellValue('Q' . $rowCount, $result['first_attempt']);
                    $activeWorksheet->SetCellValue('R' . $rowCount, $result['last_attempt']);
                    $activeWorksheet->SetCellValue('S' . $rowCount, $result['promisedate']);
                    $activeWorksheet->SetCellValue('T' . $rowCount, $result['non_service']);
                    $activeWorksheet->SetCellValue('U' . $rowCount, $result['deliver_date']);
                    $activeWorksheet->SetCellValue('V' . $rowCount, $result['remarks']);
                    $activeWorksheet->SetCellValue('W' . $rowCount, $result['fecall_date']);
                    $activeWorksheet->SetCellValue('X' . $rowCount, $result['client_action']);
                    $activeWorksheet->SetCellValue('Y' . $rowCount, $result['first_returndate']);
                    $activeWorksheet->SetCellValue('Z' . $rowCount, $result['return_dispathcnt']);
                    $activeWorksheet->SetCellValue('AA' . $rowCount, $result['first_returndate']);
                    $activeWorksheet->SetCellValue('AB' . $rowCount, $result['return_promisedate']);
                    $activeWorksheet->SetCellValue('AC' . $rowCount, $result['rtodto_date']);
                    $activeWorksheet->SetCellValue('AD' . $rowCount, $result['ord_status']);
                    $activeWorksheet->SetCellValue('AE' . $rowCount, $result['final_sts']);
                    $activeWorksheet->SetCellValue('AF' . $rowCount, $result['ontime']);
                    $activeWorksheet->SetCellValue('AG' . $rowCount, $result['days']);
                    $activeWorksheet->SetCellValue('AH' . $rowCount, $result['special_remark']);
                    $activeWorksheet->SetCellValue('AI' . $rowCount, $result['zone']);
                    $activeWorksheet->SetCellValue('AJ' . $rowCount, $result['shipment_amount']);
                    $activeWorksheet->SetCellValue('AK' . $rowCount, $result['charged_weight']);
                    $activeWorksheet->SetCellValue('AL' . $rowCount, $result['carrier']);
                    $activeWorksheet->SetCellValue('AM' . $rowCount, $result['order_type']);
                    $rowCount++;
                }
            } catch (\Throwable $exception) {
                log_error(UNIQLO_LOG_PREFIX . 'download_misexceldata cannot set cell value ' . $exception->getMessage());
            }

            log_error(UNIQLO_LOG_PREFIX . "Misreport, Cells filled.");

            $fileName = 'UniqloMISReport-' . date("d-M") . '.xlsx';
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            /*
                If folder doesnt exists, create a folder in assets
                @author : Ramachandra <external.ram.k@kuehne-nagel.com>
            */
            if (!file_exists('assets/misreport')) {
                mkdir('assets/misreport', 0710, true);
            }
            try {
                $objWriter->save(str_replace(__FILE__, 'assets/misreport/' . $fileName, __FILE__));
            } catch (PHPExcel_Writer_Exception $e) {
                log_error(UNIQLO_LOG_PREFIX . "Misreport PHPExel_Writer_Exception " . $e->getMessage());
            }

            log_error(UNIQLO_LOG_PREFIX . "Misreport memory " . round(memory_get_peak_usage() / 1048576, 2) . "MB");
            log_error(UNIQLO_LOG_PREFIX . "Misreport php max memory " . ini_get('memory_limit') . "MB");
        }

        log_error(UNIQLO_LOG_PREFIX . "download_misexceldata outbound data: " . $fileName);

        return $fileName;
    }

    /*sending mail to generated excel report file in attachment*/
    private function sendmailwithdata($filename): bool
    {
        log_error(UNIQLO_LOG_PREFIX . "sendmailwithdata inbound data: " . $filename);
        log_error(UNIQLO_LOG_PREFIX . "Misreport, Sending mail");
        $this->load->library('PhpMailerLibrary');
        $subject = "Uniqlo MIS Report - " . date('Y-m-d');
        $message = "Hi Team,<br>";
        $message .= "Attached is the daily Uniqlo MIS Report for " . date('d-M') . "<br><br><br><br>";
        $message .= "Thanks,<br>Support Team,<br>svkonekt.com";
        $attachmentPath = sprintf('%s/assets/misreport/%s', FCPATH, $filename);
        if ($this->phpmailerlibrary->sendmail(MISREPORT_MAILS_GROUP, $subject, $message,json_decode(MISREPORT_CC_MAILS), [$attachmentPath])) {
            log_error(UNIQLO_LOG_PREFIX . "Misreport, Mail sent >> subject: " . $subject);
            return true;
        } else {
            log_error(UNIQLO_LOG_PREFIX . "Misreport, Mail failed >> subject: " . $subject);
            return false;
        }
    }

    private function calculateDelayDays($deliveryDate, $promiseDate, $returnPromiseDate, $orderTypeCode, $status)
    {
        $deliveryDate = strtotime(date('Y-m-d', strtotime($deliveryDate)));
        $stringPromiseDate = strtotime(date('Y-m-d', strtotime($promiseDate)));
        $stringReturnPromiseDate = strtotime(date('Y-m-d', strtotime($returnPromiseDate)));
        $currentDate = strtotime(date('Y-m-d'));

        if ($orderTypeCode == 'SO') {
            $days = empty($promiseDate) ? 'N/A' : ($stringPromiseDate - $deliveryDate) / (60 * 60 * 24);
        }
        if ($orderTypeCode == 'Return') {
            $days = empty($returnPromiseDate) ? 'N/A' : ($stringReturnPromiseDate - $deliveryDate) / (60 * 60 * 24);
        }
        if (in_array($status, ["In Transit", "Return In Transit"])) {
            $days = empty($promiseDate) ? 'N/A' : ($stringPromiseDate - $currentDate) / (60 * 60 * 24);
        }
        if ($orderTypeCode == 'CC' || $status == 'Lost') {
            $days = "";
        }

        return $days ?? "";
    }

    private function validateDateValues(string $fromDate, int $latestDaysCount, int $pastDaysCount): bool
    {
        $dateArray = explode('-', $fromDate);
        $dateFlag = $rangeFlag = 0;
        if (count($dateArray) == 3) {
            if (checkdate($dateArray[1], $dateArray[2], $dateArray[0])) {
                $dateFlag = 1;
            } else {
                $dateFlag = 0;
            }
        } else {
            $dateFlag = 0;
        }
        if ($latestDaysCount > 0 && $pastDaysCount > 0 && $latestDaysCount <= 20 && $pastDaysCount <= 20) {
            $rangeFlag = 1;
        }
        if ($dateFlag == 1 && $rangeFlag == 1) {
            return true;
        } else {
            return false;
        }
    }
}
