<?php

use App\EventsQueue\EventQueueManager;
use App\EventsQueue\OldEventsRemovalService;
use App\MobileEvents\EventManager;
use App\MobileEvents\MobileEvent;
use App\MobileEvents\MobileEventListener;
use App\MobileEvents\Payload\DummyPayload;

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class MobileEvents extends CI_Controller
{
    private const CRON_TIME_OUT_MARGIN_SEC = 5;
    private const INTERFACE_CLI = 'cli';

    public function __construct()
    {
        parent::__construct();
        $this->load->helper(['date', 'Log']);
        $this->load->model('cabmodel');
        $this->load->model('common');
        $this->load->library('smsnotifier');
        $this->load->library('sendfirebase');
        $this->load->library("statusintigration");
        $this->load->library("shippeostatusintigration");
        $this->load->library("commonpodedi");
        $this->load->library("macdamstatusintigration");
    }

    /**
     * @throws Throwable
     */
    public function index()
    {
        if (php_sapi_name() !== self::INTERFACE_CLI) {
            die('This action is command line only');
        }

        $eventManager = new EventManager($this, new EventQueueManager($this->db));
        $eventManager->lockAndProcessEvents();
    }

    /**
     * @throws Throwable
     */
    public function restartNotFinished()
    {
        if (php_sapi_name() !== self::INTERFACE_CLI) {
            die('This action is command line only');
        }

        $eventManager = new EventManager($this, new EventQueueManager($this->db));
        $eventManager->lockAndProcessNotFinishedEvents();
    }

    /**
     * Allows generating dummy events for dev-testing purpose, e.g. establish proper time execution for event manager.
     * This MUST NOT be executed on production.
     *
     * @param int $numberOfEvents Total number of dummy events to generate
     */
    public function createDummyEvents(int $numberOfEvents = 1): void
    {
        if (ENVIRONMENT === 'production') {
            echo "This command cannot be run on production environment\n";
            return;
        }

        $this->load->library('uuid');
        $payload = new DummyPayload(['foo' => 'bar']);
        $eventListener = new MobileEventListener($this->db, $this->uuid);

        do {
            $this->echoNumberOfEvents($numberOfEvents);

            $testEvent = new MobileEvent(MobileEvent::EVENT_DUMMY, $payload);
            $eventListener($testEvent);
            $numberOfEvents--;
        } while ($numberOfEvents > 0);
    }

    public function removeOldEvents(int $successfulEventsRetentionDays): void
    {
        if (php_sapi_name() !== self::INTERFACE_CLI) {
            die('This action is command line only');
        }
        $service = new OldEventsRemovalService($this->db);
        $service->remove($successfulEventsRetentionDays);
    }

    /**
     * @param int $numberOfEvents
     * @return string
     */
    private function getWord(int $numberOfEvents): string
    {
        return $numberOfEvents < 2 ? 'event' : 'events';
    }

    /**
     * @param int $numberOfEvents
     */
    private function echoNumberOfEvents(int $numberOfEvents): void
    {
        $word = $this->getWord($numberOfEvents);
        echo "$numberOfEvents $word remaining\n";
    }
}
