<?php

use App\ApiRequest\DataPreprocessing\BadRequestException;
use App\ApiRequest\DataPreprocessing\PostTimezoneFilter;
use App\ApiRequest\DataPreprocessing\UnauthorizedException;
use App\Mobile\V1\Trips\Actions\ActionRequest;
use App\Mobile\V1\Authentication\GetShipmentIdsFromAuthorization;
use App\Mobile\V1\Trips\Exception\ShipmentIdsNotProvidedForAuthorizationException;
use App\Mobile\V1\Trips\Exception\ShipmentDoesNotBelongToAuthorizationException;

/**
 * Create/Update Actions
 */
class MobileV1Action extends \CI_Controller
{
    private $shipmentIds;
    private $curtz;

    public function __construct()
    {
        parent::__construct();
        $this->load->driver('cache', array('adapter' => 'redis', 'backup' => 'file'));
    }

    /**
     * @throws BadRequestException
     * @throws ShipmentDoesNotBelongToAuthorizationException
     * @throws UnauthorizedException
     * @throws \App\ApiRequest\DataPreprocessing\ForbiddenException
     * @throws \App\ApiRequest\DataPreprocessing\TimezoneNotSpecifiedException
     */
    public function create()
    {
        $data = $this->getData();
        $action = new ActionRequest($this->db);
        $response = $action->request('create', $data, $this->shipmentIds, $this->curtz);

        echo json_encode($response);
    }

    /**
     * @throws BadRequestException
     * @throws ShipmentDoesNotBelongToAuthorizationException
     * @throws UnauthorizedException
     * @throws \App\ApiRequest\DataPreprocessing\ForbiddenException
     * @throws \App\ApiRequest\DataPreprocessing\TimezoneNotSpecifiedException
     */
    public function update()
    {
        $data = $this->getData();
        $action = new ActionRequest($this->db);
        $response = $action->request('update', $data, $this->shipmentIds, $this->curtz);

        echo json_encode($response);
    }

    /**
     * @return array|mixed
     * @throws BadRequestException
     * @throws ShipmentDoesNotBelongToAuthorizationException
     * @throws UnauthorizedException
     * @throws \App\ApiRequest\DataPreprocessing\ForbiddenException
     * @throws \App\ApiRequest\DataPreprocessing\TimezoneNotSpecifiedException
     */
    private function getData()
    {
        $headers = getallheaders();

        $authorization = $headers['Authorization'] ?? null;
        $this->curtz = PostTimezoneFilter::getValidatedCurtz($headers['Timezone'] ?? null);

        if ($authorization === null) {
            throw new UnauthorizedException("Authorization is empty.");
        }

        $this->shipmentIds = GetShipmentIdsFromAuthorization::getShipmentIdsFromAuthorization($authorization, $this->cache);

        if (empty($this->shipmentIds)) {
            throw new ShipmentIdsNotProvidedForAuthorizationException('Shipment IDs are missing');
        }

        if (!$data =  $this->input->post()) {
            if ($this->input->server('REQUEST_METHOD') !== 'POST') {
                throw new BadRequestException("Invalid request");
            }

            $data = json_decode($this->security->xss_clean($this->input->raw_input_stream), true);
        }

        if (!is_array($data) || empty($data)) {
            throw new BadRequestException("Invalid request");
        }

        return $data;
    }
}
