<?php

use App\ApiRequest\DataPreprocessing\BadRequestException;
use App\ApiRequest\DataPreprocessing\MethodNotAllowedException;
use App\ApiRequest\DataPreprocessing\PostTimezoneFilter;
use App\ApiRequest\DataPreprocessing\UnauthorizedException;
use App\Mobile\V1\Trips\CheckAuthorization;
use App\Mobile\V1\Trips\GetTripsFromTripIds;
use App\Mobile\V1\Trips\ReorderStops\NewOrderPersistence;
use App\Mobile\V1\Trips\ReorderStops\ReorderPayload;
use App\Mobile\V1\Trips\ReorderStops\ReorderPayloadStop;

class MobileV1TripStops extends \CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->driver('cache', array('adapter' => 'redis', 'backup' => 'file'));
        $this->load->model(['common']);
    }

    public function rank() {
        $headers = $this->input->request_headers();
        $authorization = $headers['Authorization'] ?? null;

        if ($authorization === null) {
            throw new UnauthorizedException("Authorization is empty.");
        }

        $raw = $this->input->raw_input_stream;
        $clean = $this->security->xss_clean($raw);

        $data = json_decode($clean, true);

        if (!is_array($data) || empty($data)) {
            throw new BadRequestException("POST data should not be empty.");
        }
        $curtz = PostTimezoneFilter::getValidatedCurtz($headers['Timezone'] ?? null);
        $payload = $this->parseInput($data);

        CheckAuthorization::isAuthorizedForShipment($authorization, $this->cache, $payload->shipmentId());
        $persistence = new NewOrderPersistence($this->db, $this->common);
        $persistence->persist($payload);

        $response = GetTripsFromTripIds::getTripFromShiftId($payload->shipmentId(), $this->db, $curtz);

        echo json_encode($response);
    }

    private function parseInput(array $input): ReorderPayload {
        $id = $input['id'] ?? null;
        $shipmentId = $input['shipment_id'] ?? null;
        $stops = [];
        foreach ($input['stops'] ?? [] as $stop) {
            $stopId = $stop['id'];
            $sortOrder = $stop['sort_order'];
            $stops[] = new ReorderPayloadStop($stopId, $sortOrder);
        }

        return new ReorderPayload($id, $shipmentId, ...$stops);
    }
}
