<?php

use App\ApiRequest\DataPreprocessing\PostTimezoneFilter;
use App\ApiRequest\DataPreprocessing\UnauthorizedException;
use App\Mobile\V1\Authentication\GetShipmentIdsFromAuthorization;
use App\Mobile\V1\Trips\GetTripsFromTripIds;

class MobileV1Trips extends \CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->driver('cache', array('adapter' => 'redis', 'backup' => 'file'));
    }

    public function index() {
        $headers = $this->input->request_headers();
        $authorization = $headers['Authorization'] ?? null;
        if ($authorization === null) {
            throw new UnauthorizedException("Authorization is empty.");
        }
        $curtz = PostTimezoneFilter::getValidatedCurtz($headers['Timezone'] ?? null);
        $shipmentIds = GetShipmentIdsFromAuthorization::getShipmentIdsFromAuthorization($authorization, $this->cache);
        echo json_encode(
            GetTripsFromTripIds::getTripsFromShipmentIds($shipmentIds, $this->db, $curtz),
        );
    }
}
