<?php
defined('BASEPATH') or exit('No direct script access allowed');


class Muditaedi extends CI_Controller
{
    const MUDITA_VENDOR_ID = SYS_TYPE == 'TMS' ? 464 : 565;
    public function __construct()
    {
        parent::__construct();
        $this->load->model("common");
        $this->load->library('uuid');
    }

    public function statuscron()
    {
        $query = $this->db->query("SELECT o.id,o.order_id,o.customer_id,o.trip_sts,o.vendor_id,r.reference_id, r.ref_value FROM tb_orders o LEFT JOIN tb_order_references r ON r.order_id=o.id  AND r.reference_id='BN'  where o.vendor_id=".self::MUDITA_VENDOR_ID." AND o.trip_sts=0 AND r.ref_value IS NOT NULL ");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $res) {
                $this->statusupdate($res->id, $res->ref_value);
                echo $res->order_id;
            }
        }
    }


    public function statuscronbycond($vendor_id,$customer_id,$order_id)
    {
        $where='';
        if($vendor_id !='' && $vendor_id !='0' ){
            $where.=" AND o.vendor_id=".$vendor_id;
        }
        if($customer_id !='' && $customer_id !='0' ){
            $where.=" AND o.customer_id=".$customer_id;
        }
        if($order_id !='' && $order_id !='0'){
            $where.=" AND o.order_id=".$order_id;
        }
        $query = $this->db->query("SELECT o.id,o.order_id,o.customer_id,o.trip_sts,o.vendor_id,r.reference_id, r.ref_value FROM tb_orders o LEFT JOIN tb_order_references r ON r.order_id=o.id  AND r.reference_id='BN'  where  o.trip_sts=0 ".$where." AND r.ref_value IS NOT NULL ");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $res) {
                $this->statusupdate($res->id, $res->ref_value);
                echo $res->order_id;
            }
        }
    }

    public function statusupdatewithouttrip($vendor_id,$customer_id,$order_id)
    {
        $where='';
        if($vendor_id !='' && $vendor_id !='0' ){
            $where.=" AND o.vendor_id=".$vendor_id;
        }
        if($customer_id !='' && $customer_id !='0' ){
            $where.=" AND o.customer_id=".$customer_id;
        }
        if($order_id !='' && $order_id !='0'){
            $where.=" AND o.order_id=".$order_id;
        }
        $query = $this->db->query("SELECT o.id,o.order_id,o.customer_id,o.trip_sts,o.vendor_id,r.reference_id, r.ref_value FROM tb_orders o LEFT JOIN tb_order_references r ON r.order_id=o.id  AND r.reference_id='BN'  where   r.ref_value IS NOT NULL ".$where." ");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $res) {
                $this->statusupdate($res->id, $res->ref_value);
                echo $res->order_id;
            }
        }
    }


    public function statusupdate($order_row_id, $ref_num)
    {

        if(strlen($ref_num)> 10){
            $url=MUDITA_STATUS_UPDATE_URL."criteria=ID=".$ref_num;
        }else{
            $url=MUDITA_STATUS_UPDATE_URL.'criteria=Docket_Number="'.$ref_num.'"';
        }

        $access_token_request_url = MUDITA_ACCESS_TOKEN_URL . '?grant_type=refresh_token&refresh_token=' . MUDITA_REFRESH_TOKEN . '&client_id=' . MUDITA_CLIENT_ID . '&client_secret=' . MUDITA_CLIENT_SECRET;
        $token = mudita_requestaccesstoken($access_token_request_url);
        if(isset($token['access_token'])) {
            $access_token = $token['access_token'];
            $headers = array(
                'Authorization: Zoho-oauthtoken ' . $access_token
            );
            $response = thirdparty_curl_get($url, $headers);
            $resp = json_decode($response, true);
            $timeline_data=$resp['data'][0]['Docket_Timeline'];
            if(count($timeline_data) >0){
                foreach ($timeline_data as $tdata){
                    $timeline_data_status=explode("|",$tdata['display_value']) ;
                    $docket_status=trim($timeline_data_status[0]);
                    $docket_time=date('Y-m-d H:i:s',strtotime($timeline_data_status[1]));
                    $curtz = "Asia/Kolkata";
                    $getactual = getdatetimebytimezone(DFLT_TZ, $docket_time, $curtz);
                    $createdon = $getactual['datetime'];
                    if($docket_status == 'Picked Up & In-transit'){
                        $status = "ALLOCATED";
                        $status_name = "Accepted by Driver";
                        $stop_type = "";
                        $code = '0212';
                        $status_id='10';
                        $this->load->helper('mudita_helper');
                        $mudita_trip_check = $this->common->gettblrowdata(array(
                            'id' => $order_row_id,
                            'trip_id' => 0
                        ), 'id', 'tb_orders', 0, 0);
                        if (! empty($mudita_trip_check)) {
                            $mudita_res_accept = muditaupdatestatusbymanifest($mudita_trip_check['id'], $createdon);
                        }
                        $status = "Gate In";
                        $status_name = 'Gate In';
                        $stop_type = "P";
                        $code = '0420';
                        $status_id='2';
                        $this->checkstatus($order_row_id,$docket_status,$docket_time,$status, $status_name,$stop_type, $code,$status_id);
                        $status = "PICKUP";
                        $status_name = 'Pickup Or Drop';
                        $stop_type = "P";
                        $code = '0500';
                        $status_id='1';
                        $this->checkstatus($order_row_id,$docket_status,$docket_time,$status, $status_name,$stop_type, $code,$status_id);
                        $status = "Gate OUT";
                        $status_name = 'Gate Out';
                        $stop_type = "P";
                        $code = '0191';
                        $status_id='3';
                        $this->checkstatus($order_row_id,$docket_status,$docket_time,$status, $status_name,$stop_type, $code,$status_id);

                        $status = "In Transit";
                        $status_name = 'Actual Transit Location';
                        $stop_type = "P";
                        $code = '1550';
                        $status_id='4';
                        $this->checkstatus($order_row_id,$docket_status,$docket_time,$status, $status_name,$stop_type, $code,$status_id);

                    }elseif($docket_status == 'Out for Delivery'){
                        $status = "Out for Delivery";
                        $status_name = 'Delivery Gate out';
                        $stop_type = "D";
                        $code = '2300';
                        $status_id='1';
                        $this->checkstatus($order_row_id,$docket_status,$docket_time,$status, $status_name,$stop_type, $code,$status_id);
                    }elseif($docket_status == 'Delivered'){

                        $status = "Delivered";
                        $status_name = 'Delivered to Consignee';
                        $stop_type = "D";
                        $code = '3000';
                        $status_id='3';
                        $this->checkstatus($order_row_id,$docket_status,$docket_time,$status, $status_name,$stop_type, $code,$status_id);

                        if($resp['data'][0]['Final_POD'] !=''){
                            $img_url=$resp['data'][0]['Final_POD'];
                            $this->img_upload($img_url,$order_row_id, $docket_time);
                        }

                        $order = $this->common->gettblrowdata(array(
                            'id' => $order_row_id
                        ), 'order_id,shift_id,trip_id', 'tb_orders', 0, 0);

                        $upd = $this->common->updatetbledata("tb_orders", array(
                            "trip_sts" => 1
                        ), array(
                            "id" => $order_row_id
                        ));
                        $upd = $this->common->updatetbledata("tb_shifts", array(
                            "status" => 0
                        ), array(
                            "id" => $order['shift_id']
                        ));
                        $upd = $this->common->updatetbledata("tb_trips", array(
                            "status" => 0
                        ), array(
                            "id" => $order['trip_id']
                        ));
                    }

                }
                echo " - Success"; echo "<br>";
            }else{
                echo " - Failure"; echo "<br>";
            }
        }

    }



    private function img_upload($url, $order_row_id, $docket_time)
    {
        $img = explode("/", $url);
        $imgpath = end($img);
        $poddata = bonds_copy_image($url);
        $img_path = NEW_POD_PATH . $imgpath;
        file_put_contents($img_path, $poddata);
        if ($imgpath != "") {

            $select = "id,order_id,user_id,shift_id,trip_id,company_code,branch_code,vendor_id";
            $where = array(
                'id' => $order_row_id,
                'status!=' => '0'
            );
            $table = "tb_orders";
            $res = $this->common->gettblrowdata($where, $select, $table, 0, 0);


            $chksign = array(
                "trip_id" => $res['trip_id'],
                "shipment_id" => $res['shift_id'],
                "doc_type" => '3',
                "imgpath" => $imgpath,
                "status" => 1
            );
            $signdata = $this->common->gettblrowdata($chksign, "id", "tb_pod_uploads", 0, 0);
            if (count($signdata) == 0) {
                $imageSize = filesize($img_path);
                $newUuid = $this->uuid->v4();
                $signarr = [
                    "trip_id" => $res['trip_id'],
                    "shipment_id" => $res['shift_id'],
                    "stop_id" => 0,
                    "stop_detail_id" => 0,
                    "stop_type" => "D",
                    "doc_type" => '3',
                    "imgpath" => $imgpath,
                    "user_id" => $res['user_id'],
                    "createdby" => 0,
                    "order_id" => $res['id'],
                    "createdon" => $docket_time,
                    "filesize" => $imageSize,
                    "hash" => $newUuid
                ];

                $ins = $this->common->insertTableData("tb_pod_uploads", $signarr);


            }
        }
    }

    public function checkstatus($order_row_id,$docket_status,$docket_time,$status, $status_name,$stop_type,$code,$status_id){
        $curtz = "Asia/Kolkata";
        $getactual = getdatetimebytimezone(DFLT_TZ, $docket_time, $curtz);
        $createdon = $getactual['datetime'];
        $location = '';
        $stop_id = $stop_detail_id   = $lat = $lng  = $driver_id = $vehicle_id = 0;
        $order = $this->common->gettblrowdata(array(
            'id' => $order_row_id
        ), 'order_id,shift_id,trip_id,pickup_pincode,delivery_pincode,plat,plng,dlat,dlng,vendor_id,user_id', 'tb_orders', 0, 0);

        $select = "id";
        $table = "tb_shiporder_stops";
        $where = array(
            "shipment_id" => $order['shift_id'],
            'stoptype' => $stop_type,
            "status" => 1
        );
        $stopidinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
        if (count($stopidinfo) > 0) {
            $stop_id = $stopidinfo['id'];
        }
        /* Getting vehicle and driver from trips table */
        $where = array(
            'shift_id' => $order['shift_id']
        );
        $select = "vehicle_id,driver_id";
        $table = "tb_trips";
        $dvinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
        if (count($dvinfo) > 0) {
            $driver_id = $dvinfo['driver_id'];
            $vehicle_id = $dvinfo['vehicle_id'];
        }
        $reason = 'From Mudita Cargo';
        $innr_array = array(
            'order_id' => $order_row_id,
            'shipment_id' => $order['shift_id'],
            'stop_id' => $stop_id,
            'stop_detail_id' => $stop_detail_id,
            'stop_type' => $stop_type,
            'trip_id' => $order['trip_id'],
            'status_id' => $status_id,
            'status_code' => $code,
            'status' => 1,
            'reason' => $reason,
            'latitude' => $lat,
            'longitude' => $lng,
            'createdon' => $createdon,
            'loc_name' => $location,
            'driver_id' => $driver_id,
            'vehicle_id' => $vehicle_id
        );
        $check_array = array(
            'order_id' => $order_row_id,
            'shipment_id' => $order['shift_id'],
            'stop_id' => $stop_id,
            'stop_detail_id' => $stop_detail_id,
            'stop_type' => $stop_type,
            'trip_id' => $order['trip_id'],
            'status_id' => $status_id,
            'status_code' => $code,
            'loc_name' => $location,
            'driver_id' => $driver_id,
            'vehicle_id' => $vehicle_id
        );
        $chk_qry = $this->db->select("id")->get_where('tb_stop_status', $check_array);
        if ($chk_qry->num_rows() == 0) {
            $stsins = $this->db->insert('tb_stop_status', $innr_array);
        } else {
            $stsins = $this->db->where_in("id", array(
                "id" => $chk_qry->row()->id
            ))
                ->update("tb_stop_status", $innr_array);
        }
    }

}

