<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class MultiOrderToCarrierAssign extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if (!$this->session->userdata('user_id')) {
            redirect('login');
        }
        error_reporting(0);
        $this->load->model(['shippeomodel', 'common','ShipmentVisibilityModel','MultiOrderToCarrierAssignModel']);
        $this->load->library(['carriercommonedilib', 'shippeostatusintigration', 'tollcarrieredi','TripCreateFromOrders']);
        if (!checkUrlAccessForUser('VISIBILITY')) {
            redirect("Forbiddenaccess");
        }
    }

    public function assignMultipleOrderToCarrierShipment()
    {
        $carrierId                      = $this->input->post("carrier_id", true);
        $vehicleId                      = $this->input->post("vehicle_id", true);
        $userId                         = $this->session->userdata('user_id');
        $scheduleDate                   = $this->input->post('schedule_date', true);
        $input                          = $this->input->post();
        $assginedDriverId               = isset($input['driveridhiden']) ? $input['driveridhiden'] : "";
        $vehicleType                    = isset($input['vehicle_typ']) ? $input['vehicle_typ'] : "";
        $driverId                       = isset($input['driver_id']) ? $input['driver_id'] : "";
        $shipmentCost                   = isset($input['shipment_cost']) ? $input['shipment_cost'] : "0";
        $carrierInstructions            = isset($input['carrier_instructions']) ? $input['carrier_instructions'] : "";
        $weightCapacity                 = isset($input['weight_capacity']) ? $input['weight_capacity'] : "";
        $volumeCapacity                 = isset($input['volume_capacity']) ? $input['volume_capacity'] : "";
        $additionalConditions           = isset($input['additional_conditions']) ? $input['additional_conditions'] : "";
        $temperatureRegime              = isset($input['temperature_regime']) ? $input['temperature_regime'] : "";
        $timeForLoadingPenalityRate     = isset($input['time_for_loading_penality_rate']) ? $input['time_for_loading_penality_rate'] : "";
        $rateCategory                   = isset($input['rate_category']) ? $input['rate_category'] : "";
        $shipmentCost                   = isset($input['shipment_cost']) ? $input['shipment_cost'] : "";
        $vehicleType                    = $input['vehicle_typeId'] ?? "";
        $dateTime                       = date('Y-m-d H:i:s');
        $shipmentIdList                 = explode(",", $this->input->post("shipment_id", true));

        foreach($shipmentIdList as $shipmentId) {
            if ($scheduleDate != null && strlen($scheduleDate) > 0) {
                $scheduleDate  = date("Y-m-d H:i:s", strtotime($scheduleDate));
                $this->common->updatetbledata("tb_shifts", ["schedule_date" => $scheduleDate], ["id" => $shipmentId]);
            }
            $this->common->updatetbledata("tb_shifts", [
                "schedule_date" => $scheduleDate,
                'vendor_id' => $carrierId,
                'vehicle_type' => $vehicleType,
                'carrier_instructions' => $carrierInstructions,
                'weight_capacity' => $weightCapacity,
                'volume_capacity' => $volumeCapacity,
                'additional_conditions' => $additionalConditions,
                'temperature_regime' => $temperatureRegime,
                'time_for_loading_penality_rate' => $timeForLoadingPenalityRate,
                'status' => 1
            ], ["id" => $shipmentId]);
            $checkShipmentRates = $this->MultiOrderToCarrierAssignModel->getShipmentRatesCount($shipmentId);
            if ($checkShipmentRates == 0) {
                $this->common->insertTableData(
                    "tb_shipment_rates",
                    [
                        "shift_id" => $shipmentId,
                        "category" => $rateCategory,
                        "rate" => $shipmentCost,
                        "status" => 1,
                        "created_on" => $dateTime
                    ]
                );
            }
            else
            {
                $this->common->updatetbledata("tb_shipment_rates", [
                    "category"   => $rateCategory,
                    "rate"       => $shipmentCost,
                    "updated_on" => $dateTime
                ], ["shift_id" => $shipmentId]);
            }
            $checkShifts = $this->MultiOrderToCarrierAssignModel->getShiftCount($shipmentId);
            if ($checkShifts > 0) {
                $getDriverInfo = $this->common->gettblrowdata(['vehicle_id' => $vehicleId, 'status' => 1], "driver_id","tb_vehicles_drivers",1,0);
                $vehicleDriverId  = $getDriverInfo ? $getDriverInfo['driver_id'] : 0;
                $timeZone = $this->session->userdata("usr_tzone")['timezone'];
                $this->shippeomodel->updateTrip($shipmentId, $vehicleId, $vehicleDriverId, $dateTime, $timeZone, $dateTime);
            }
            $this->common->updatetbledata("tb_orders", ["vendor_id" => $carrierId], ["shift_id" => $shipmentId]);
            $getShiftVehicle = $this->common->gettblrowdata([
                "shft_id" => $shipmentId,
                "carrier_id" => $carrierId,
                "status" => 1
            ], "id","tb_shft_veh",1,0);
            if ($getShiftVehicle) {
                $id = $getShiftVehicle['id'];
                $this->common->updatetbledata("tb_shft_veh", ["status" => "0", 'updated_on' => $dateTime], ["shft_id" => $shipmentId, "carrier_id" => $carrierId]);
                $getVehicleInfo = $this->common->gettblrowdata(['id' => $vehicleId], "register_number","tb_trucks_data",1,0);
                $registerNumber = $getVehicleInfo ? $getVehicleInfo['register_number'] : '';
                $this->common->updatetbledata("tb_shft_veh", [
                    "vehicle_id" => $vehicleId,
                    "register_number" => $registerNumber,
                    "status" => "1",
                    'updated_on' => $dateTime
                ], ["id" => $id]);
                $getVehicleDriver = $this->common->gettblrowdata(['vehicle_id' => $vehicleId, 'status' => 1], "driver_id","tb_vehicles_drivers",1,0);
                $vehiclesDriverId = $getVehicleDriver ? $getVehicleDriver['driver_id'] : 0;
                $this->common->insertTableData("tb_shft_veh_history", [
                    "user_id" => $userId,
                    "shft_id" => $shipmentId,
                    "carrier_id" => $carrierId,
                    "vehicle_id" => $vehicleId,
                    "driver_id" => $vehiclesDriverId,
                    "register_number" => $registerNumber,
                    "status" => "1",
                    'created_on' => $dateTime,
                    'updated_on' => $dateTime
                ]);
            } else {
                $getShiftVehicle = $this->common->gettblrowdata(["shft_id" => $shipmentId, "status" => 1], "id","tb_shft_veh",1,0);
                if ($getShiftVehicle) {
                    $id = $getShiftVehicle['id'];
                    $getTruckInfo = $this->common->gettblrowdata(["id" => $vehicleId], "register_number","tb_trucks_data",1,0);
                    $registerNumber = $getTruckInfo ? $getTruckInfo['register_number'] : "";
                    $this->common->updatetbledata("tb_shft_veh", [
                        "vehicle_id" => $vehicleId,
                        "carrier_id" => $carrierId,
                        "register_number" => $registerNumber,
                        "status" => "1",
                        'updated_on' => $dateTime
                    ], ["id" => $id]);

                    $getVehicleDriver = $this->common->gettblrowdata(['vehicle_id' => $vehicleId, 'status' => 1], "driver_id","tb_vehicles_drivers",1,0);
                    $vehicleDriverId = $getVehicleDriver ? $getVehicleDriver['driver_id'] : 0;
                    $vendorDetailsArray = [
                        "user_id" => $userId,
                        "shft_id" => $shipmentId,
                        "carrier_id" => $carrierId,
                        "vehicle_id" => $vehicleId,
                        "driver_id" => $vehicleDriverId,
                        "register_number" => $registerNumber,
                        "status" => "1",
                        'created_on' => $dateTime,
                        'updated_on' => $dateTime
                    ];
                    $this->common->insertTableData("tb_shft_veh_history", $vendorDetailsArray);
                } else {
                    $getTruckInfo   = $this->common->gettblrowdata(['id' => $vehicleId], "register_number","tb_trucks_data",1,0);
                    $registerNumber = $getTruckInfo ? $getTruckInfo['register_number'] : "";
                    $getShiftVehicle = $this->common->gettblrowdata(['shft_id' => $shipmentId], "id","tb_shft_veh",1,0);
                    if ($getShiftVehicle) {
                        $id = $getShiftVehicle['id'];
                        $this->common->updatetbledata("tb_shft_veh", [
                            "vehicle_id" => $vehicleId,
                            "carrier_id" => $carrierId,
                            "register_number" => $registerNumber,
                            "status" => "1",
                            'updated_on' => $dateTime
                        ], ["id" => $id]);
                        $getVehicleDriver = $this->common->gettblrowdata(['vehicle_id' => $vehicleId, 'status' => 1], "driver_id","tb_vehicles_drivers",1,0);
                        $vehicleDriverId = $getVehicleDriver ? $getVehicleDriver['driver_id'] : 0;
                        $vendorDetailsArray = [
                            "user_id" => $userId,
                            "shft_id" => $shipmentId,
                            "carrier_id" => $carrierId,
                            "vehicle_id" => $vehicleId,
                            "driver_id" => $vehicleDriverId,
                            "register_number" => $registerNumber,
                            "status" => "1",
                            'created_on' => $dateTime,
                            'updated_on' => $dateTime
                        ];
                        $this->common->insertTableData("tb_shft_veh_history", $vendorDetailsArray);
                    } else {
                        $insert = $this->common->insertTableData(
                            "tb_shft_veh",
                            [
                                "user_id" => $userId,
                                "shft_id" => $shipmentId,
                                "vehicle_id" => $vehicleId,
                                "carrier_id" => $carrierId,
                                "register_number" => $register_number,
                                "status" => "1",
                                'created_on' => $dateTime
                            ]
                        );
                        $getVehicleDriver = $this->common->gettblrowdata(['vehicle_id' => $vehicleId, 'status' => 1], "driver_id", "tb_vehicles_drivers",1,0);
                        $vehicleDriverId = $getVehicleDriver ? $getVehicleDriver['driver_id'] : 0;
                        $vendorDetailsArray = [
                            "user_id" => $userId,
                            "shft_id" => $shipmentId,
                            "carrier_id" => $carrierId,
                            "vehicle_id" => $vehicleId,
                            "driver_id" => $vehicleDriverId,
                            "register_number" => $register_number,
                            "status" => "1",
                            'created_on' => $dateTime,
                            'updated_on' => $dateTime
                        ];
                        $this->common->insertTableData("tb_shft_veh_history", $vendorDetailsArray);
                    }
                }
            }
            if ($this->session->userdata('company_code') === "UKKN")
            {
                $getVehicleDriver = $this->common->gettblrowdata(['vehicle_id' => $vehicleId, 'status' => 1], "driver_id", "tb_vehicles_drivers",1,0);
                if ($getVehicleDriver) {
                    $vehicleDriverId = $getVehicleDriver ? $getVehicleDriver['driver_id'] : 0;
                    $getAssignedDriver = $this->common->gettblrowdata(['vehicle_id' => $vehicleId, 'driver_id' => $vehicleDriverId, 'status' => 1], "id", "tbl_assigned_drivers",1,0);
                    if (empty($getAssignedDriver)) {
                        $insert = $this->common->insertTableData("tbl_assigned_drivers", [
                            "vehicle_id" => $vehicleId,
                            "user_id" => $userId,
                            "driver_id" => $vehicleDriverId,
                            "from_time" => $dateTime,
                            "to_time" => $dateTime,
                            "status" => 1,
                            'created_on' => $dateTime,
                            'updated_on' => $dateTime
                        ]);
                    }
                }
            }
            $getIMEInfo = $this->common->gettblrowdata(['id' => $vehicleId], "imei", "tb_trucks_data",1,0);
            $imei = $getIMEInfo ? $getIMEInfo['imei'] : '';
            $checkAssignedDriver = $this->common->gettblrowdata(["driver_id" => $assginedDriverId,"vehicle_id" => $vehicleId], "id", "tbl_assigned_drivers",1,0);
            if ($checkAssignedDriver) {
                $this->common->updatetbledata("tbl_assigned_drivers", [
                    "driver_id" => $driverId,
                    "status" => "1",
                    'updated_on' => $dateTime
                ], ["id" => $checkAssignedDriver['id']]);
            } else {
                $checkAssignedDriver = $this->common->gettblrowdata([
                    "driver_id <>" => $driverId,
                    "vehicle_id" => $vehicleId,
                    "status" => 1
                ], "id", "tbl_assigned_drivers",1,0);
                if (empty($checkAssignedDriver))
                {
                    $insert = $this->common->insertTableData(
                        "tbl_assigned_drivers",
                        [
                            "vehicle_id" => $vehicleId,
                            "user_id" => $userId,
                            "driver_id" => $driverId,
                            "mobile_no" => $register_number,
                            "imei" => $imei,
                            "from_time" => $dateTime,
                            "to_time" => $dateTime,
                            "status" => "1",
                            'created_on' => $dateTime
                        ]
                    );
                }
            }
            $this->common->insertTableData("tb_shft_veh_history", [
                "user_id" => $userId,
                "shft_id" => $shipmentId,
                "carrier_id" => $carrierId,
                "vehicle_id" => $vehicleId,
                "driver_id" => $driverId,
                "register_number" => $register_number,
                "status" => "1",
                'created_on' => $dateTime,
                'updated_on' => $dateTime
            ]);
            $shiftVehicleEmployee = $this->common->gettblrowdata(["shft_veh_id" => $id, "status" => 1], "id", "tb_shft_veh_emp",1,0);
            if (empty($shiftVehicleEmployee)) {
                $getShiftEmployees = $this->MultiOrderToCarrierAssignModel->getShiftEmployees($shipmentId);
                $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee",["shift_id" => $shipmentId]);
                if ($getShiftEmployees) {
                    $pri = 1;
                    foreach ($getShiftEmployees as $shiftEmployee) {
                        $insert = $this->common->insertTableData("tb_shft_veh_emp", [
                            "user_id" => $userId,
                            "shft_veh_id" => $id,
                            "emp_id" => $shiftEmployee['id'],
                            "priority" => $pri,
                            "pickup_time" => $shiftEmployee['pickup_datetime'],
                            'created_on' => $dateTime,
                            'updated_on' => $dateTime,
                            "status" => 1,
                            "drop_time" => $shiftEmployee['drop_datetime']
                        ]);
                        $pri++;
                    }
                }
            }
            $isVendorAutoAccept = $this->common->gettblrowdata(["id" => $carrierId, "tms_auto_accept" => 1], "id", "tb_vendors",1,0);
            if ($isVendorAutoAccept)
            {
                $getVehicleDriver = $this->common->gettblrowdata(['vehicle_id' => $vehicleId, 'status' => 1], "driver_id", "tb_vehicles_drivers",1,0);
                $driver_id = $getVehicleDriver ? $getVehicleDriver['driver_id'] : 0 ;
                $getTruckDriver = $this->common->gettblrowdata(['id' => $driver_id, 'status' => 1], "contact_num", "tb_truck_drivers",1,0);
                $contactNum = $getTruckDriver ? $getTruckDriver['contact_num'] : '';
                $getShifts  = $this->common->gettblrowdata(['shift_id' => $shipmentId], "id", "tb_trips",1,0);
                if (empty($getShifts)) {
                    $getVehicleDriver  = $this->common->gettblrowdata(['vehicle_id' => $vehicleId, 'status' => 1], "driver_id", "tb_vehicles_drivers",1,0);
                    $driver_id = $getVehicleDriver ? $getVehicleDriver['driver_id'] : 0;
                    $timeZone = $this->session->userdata("usr_tzone")['timezone'];
                    $this->shippeomodel->updateTrip($shipmentId, $vehicleId, $driver_id, $dateTime, $timeZone, $dateTime);
                    if (!empty($insert) && (($this->session->userdata('company_code') === 'NZKN') || ($this->session->userdata('company_code') == 'NZPG'))) {
                        $getVendorName  = $this->common->gettblrowdata(['id' => $carrierId,'name' => 'BASCIK TRANSPORT'], "name", "tb_vendors",1,0);
                        if ($getVendorName) {
                            $this->load->helper('nz_edis_helper');
                            bascikedi_call($shipmentId);
                        }
                        $getTOLLVendorName  = $this->common->gettblrowdata(['id' => $carrierId,'name' => 'TOLL NETWORKS (NZ) LTD'], "name", "tb_vendors",1,0);
                        if ($getTOLLVendorName) {
                            $getTOLLfile = $this->tollcarrieredi->shipmentdata($shipmentId);
                        }
                        if (checkAccessConditions('CHECK_ALTOVA_NZ_CARRIERS', $carrierId)) {
                            $carrierStatus = $this->carriercommonedilib->shipmentdata($shipmentId);
                        }
                    }
                }
            }
        }
        echo "1";
    }

    public function checkTripActiveStatus(): void
    {
        $post       = $this->input->post(null, true);
        $vehicleId  = $post['vehicle_id'];
        $shiftIds    = $post['shift_id'];
        $tripIds = [];
        foreach ($shiftIds as $shiftId)
        {
            $checkActiveTrips = $this->MultiOrderToCarrierAssignModel->checkActiveTrip($vehicleId,$shiftId);
            if ($checkActiveTrips){
                $tripIds[] = $checkActiveTrips;
            }
        }
        $status = 0; $message = "";
        if($tripIds)
        {
            $status = 1;
            $message = "The Trip ID ".implode(", ",$tripIds)." was already accepted by driver. So, we can't update.";
        }
        echo json_encode(compact('status','message'));
    }
}
