<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class NZGenQuickBook extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('session');
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->library('form_validation');
        $this->load->model('Order');
        $this->load->model('common');
        $this->load->library('email');
    }


    public function index($id = null)
    {
        $this->newtemplate->dashboard("custorders/order", []);
    }

    // the below method will open the popup for displaying quick book popup
    public function prepareQuickBookPOPUP()
    {
        $data = [];
        $this->load->model('Quickbook_model');
        $transport = $this->Quickbook_model->getTransportModes();
        $vas_data = $this->Quickbook_model->getVAS();
        $item_data = $this->Quickbook_model->getItemsMaster();
        $ref_data = $this->Quickbook_model->getReferenceData();
        $service_data = $this->Quickbook_model->getServicesData();
        $orderTypes = $this->Quickbook_model->getOrderTypes();
        $costCenters = $this->Quickbook_model->getCostCenter();
        foreach ($costCenters as $eachLine) {
            $departmentCodes[$eachLine['type_id']] = $eachLine['department_code'];
        }
        foreach ($service_data as $eachLine) {
            $ServiceWithMod[$eachLine['id']] = $eachLine['transport_mode'];
        }
        $getcustomerCid = $this->common->gettblrowdata(['id' => $this->session->userdata('cust_id')], "phone", "tb_customers", 0, 0);
        $checkDefaultServiceAndMOD = checkAccessConditions('PACT_SERVICE_SP_AND_MOD_SEA-FCL', $getcustomerCid['phone']);
        $data['defaultService'] = $checkDefaultServiceAndMOD ? "SP - Specialized Services" : "No Data";
        $data['defaultMOD'] = $checkDefaultServiceAndMOD ? "Less Than Truck Load" : "No Data";
        $data['transport'] = $transport;
        $data['vas_data'] = $vas_data;
        $data['items_data'] = $item_data;
        $data['ref_data'] = $ref_data;
        $data['service_data'] = $service_data;
        $data['orderTypes'] = $orderTypes;
        $data['costCenters'] = $costCenters;
        $data['departmentCodes'] = $departmentCodes ?? [];
        $data['ServiceWithMod'] = $ServiceWithMod ?? [];
        $this->load->view("custorders/quickBookModal", $data);
    }

    // the below method will save the quicbook order for newzealand
    public function saveQuickBook()
    {
        parse_str($_POST['data'], $post);
        //echo "<pre>";print_r($post);exit;

        $mandatoryFields = [
            'qb_shipper',
            'qb_consignee',
            'qb_customer_id',
            'qb_shipper_id',
            'qb_consignee_id',
            'qb_transport_mode',
            'qb_pickup_id',
            'qb_delivery_id',
            'qb_early_pickup',
            'qb_early_delivery',
            'qb_pickup',
            'qb_delivery',
            'qb_destination_branch',
            'qb_service',
            'qb_order_type',
            'qb_cost_center',
            'qb_cost_center',
        ];

        $errorMsg = '';
        foreach ($mandatoryFields as $eachField) {
            if (!isset($post[$eachField]) || $post[$eachField] == '') {
                $fieldname = ucwords(strtolower(str_replace(['qb_', '_'], ['', ' '], $eachField)));
                $errorMsg .= $fieldname . ', ';
            }
        }
        $quickBookCargoPackage  = (isset($post['qb_cargo_pkg']) && is_array($post['qb_cargo_pkg'])) ? array_filter($post['qb_cargo_pkg']) : [];
        $quickBookCargoQuantity = (isset($post['qb_cargo_qty']) && is_array($post['qb_cargo_qty'])) ? array_filter($post['qb_cargo_qty']) : [];
        $quickBookCargoWeight   = (isset($post['qb_cargo_weight']) && is_array($post['qb_cargo_weight'])) ? array_filter($post['qb_cargo_weight']) : [];
        if (empty($quickBookCargoQuantity) || empty($quickBookCargoPackage) || empty($quickBookCargoWeight)) {
            $errorMsg .= 'Minimum one cargo information is required with its Package, Quantity & Weight';
        }
        $this->db->where('type_name', 'Inwards Goods');
        $this->db->where('id', $post['qb_order_type']);
        $countInwardGoods = $this->db->count_all_results('tb_order_types');
        if ($countInwardGoods > 0) {
            if (!in_array('PO', $post['qb_ref_id'])) {
                $errorMsg .= 'PO Reference mandatory for Inwards Goods';
            } else {
                foreach ($post['qb_ref_id'] as $key => $value) {
                    if ($value === 'PO' && empty($post['qb_ref_value'][$key])) {
                        $errorMsg .= 'PO Reference mandatory for Inwards Goods';
                        break;
                    }
                }
            }
        }

        if (isset($post['qb_cargo_pkg']) && !empty($post['qb_cargo_pkg'])) {
            $errorWeight = false;
            foreach ($post['qb_cargo_pkg'] as $key => $value) {
                if (!empty($value)) {
                    $cargoWeight = isset($post['qb_cargo_weight'][$key]) ? $post['qb_cargo_weight'][$key] : 0;
                    if ($cargoWeight == '' || $cargoWeight <= 0) {
                        $errorWeight = true;
                    }
                }
            }
            if ($errorWeight) {
                $errorMsg .= 'Cargo weight should be greater than 0';
            }
        }
        $destination_branch_code = $post['qb_destination_branch'] ?? '';

        $errorMsg = trim($errorMsg, ', ');

        if ($errorMsg != '') {
            $resp = ['error' => 1, "message" => "Mandatory Fields Missing. Please Enter The Values For The Fields: $errorMsg"];
            echo json_encode($resp);
            exit;
        }
        if($destination_branch_code == "ERROR"){
            $errorMsg .= 'Destination Branch Code should not be ERROR';
        }
        if ($errorMsg != '') {
            $resp = ['error' => 1, "message" => "Mandatory Fields Missing. Please Check Destination Address: $errorMsg"];
            echo json_encode($resp);
            exit;
        }

        $cdate = date('Y-m-d H:i:s');
        $user_id = $this->session->userdata('user_id');
        $cust_id = $this->session->userdata('cust_id');

        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');

        $product = $shipment_id = $porder = $notify_party = '';

        $delivery_terms = $post['qb_delivery_term'] ?? "";
        $service = $post['qb_service'] ?? "";
        $incoterm = $post['qb_incoterm'] ?? "";
        $popuppickup = $post['qb_early_pickup'] ?? "";
        $popupdelivery = $post['qb_early_delivery'] ?? "";
        $department_code = $post['qb_department_code'] ?? "";
        $delivery_instructions = $post['qb_delivery_instructions'] ?? "";
        $pickup_instructions = $post['qb_pickup_instructions'] ?? "";

        // TODO: implement charge handling, available charge post fields:
        // qb_charge_price
        // qb_charge_currency
        // qb_charge_total_price
        // qb_charge_total_services_price
        // qb_charge_transit_time
        // qb_charge_vehicle_profile
        // qb_charge_vendor_profile

        $earlyQuickbookDelivery = ($popupdelivery != "") ? date('Y-m-d H:i:s', strtotime($popupdelivery)) : '';
        $earlyQuickbookPickup = ($popupdelivery != "") ? date('Y-m-d H:i:s', strtotime($popuppickup)) : '';

        $popuporder_type = $post['qb_order_type'] ?? "";
        $cost_center = $post['qb_cost_center'] ?? '';
        $popupmodeof_trasnport = $post['qb_transport_mode'] ?? "LTL";

        $pickup = $post['qb_shipper'];
        $delivery = $post['qb_consignee'];

        $drop_id = $pickup_custid = 0;

        $pickup_name = $pickup_country = $pickup_street = $pickup_pincode = $pickup_city = $drop_name = $drop_country = $drop_street = $drop_pincode = $drop_city = $pickup_state = $drop_state = "";
        $getdrop_custid = $this->db->query("SELECT name,country,state,street,customeridentifier,pincode,location_id as city FROM tbl_party_master WHERE id='" . $delivery . "'");

        if ($getdrop_custid->num_rows() > 0) {
            $drop_id = $getdrop_custid->row()->customeridentifier;
            $drop_name = $getdrop_custid->row()->name;
            $drop_country = $getdrop_custid->row()->country;
            $drop_street = $getdrop_custid->row()->street;
            $drop_pincode = $getdrop_custid->row()->pincode;
            $drop_city = $getdrop_custid->row()->city;
            $drop_state = $getdrop_custid->row()->state;
        }

        $getshippercustid = $this->db->query("SELECT name,country,state,street,customeridentifier,pincode,location_id as city FROM tbl_party_master WHERE id='" . $post['qb_shipper'] . "'");

        if ($getshippercustid->num_rows() > 0) {
            $pickup_custid = $getshippercustid->row()->customeridentifier;
            $pickup_name = $getshippercustid->row()->name;
            $pickup_country = $getshippercustid->row()->country;
            $pickup_street = $getshippercustid->row()->street;
            $pickup_pincode = $getshippercustid->row()->pincode;
            $pickup_city = $getshippercustid->row()->city;
            $pickup_state = $getshippercustid->row()->state;
        }

        $enddate = date('Y-m-d H:i:s', strtotime("+1 day"));
        $tid = 1;
        $tname = "";

        $gettrasnportmode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '" . $popupmodeof_trasnport . "'");

        if ($gettrasnportmode->num_rows() > 0) {
            $tid = $gettrasnportmode->row()->id;
            $tname = $gettrasnportmode->row()->name;
        }
        if ($shipment_id == "") {
            $shipment_id = "SVK" . time();
        }

        $ship_arr = [
            'shipid' => $shipment_id,
            'txnid' => $shipment_id,
            'trucktype' => $tname,
            'pickupcnt' => '1',
            'dropcnt' => '1',
            'insertusr' => $pickup_custid,
            'carrier' => '0',
            'insertuserdate' => $cdate,
            'enddate' => $enddate,
            'insdate' => $cdate,
            'upddate' => $cdate,
            'reason' => 'SHIPMENT',
            'purpose' => 'SEND INTEGRATION',
            'ship_object' => 'SHIPMENT',
            'logdate' => $cdate,
            'transport_mode' => $popupmodeof_trasnport,
            'domainname' => $branch_code,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'product' => $product,
            'freight_term' => '60',
            'freight_termname' => 'Free of Charge',
            'incoterm' => $incoterm,
            'modeoftransport' => $tid,
            'unitspec' => 1
        ];

        $chk_shipid = $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '" . $shipment_id . "'");

        if ($chk_shipid->num_rows() > 0) {
            $ship_row_id = $chk_shipid->row()->id;
            $this->db->where(['id' => $ship_row_id])->update("tb_shipments", $ship_arr);
        } else {
            $ship_arr['createdon'] = $cdate;
            $ship_ins = $this->db->insert("tb_shipments", $ship_arr);
            $ship_row_id = $this->db->insert_id();
        }

        $add1 = implode(",", [$pickup_street, $pickup_city, $pickup_country, $pickup_pincode]);
        $add2 = implode(",", [$drop_street, $drop_city, $drop_country, $drop_pincode]);

        $data = getlatlngsbyplace($add1);
        $lat1 = @$data[0];
        $lng1 = @$data[1];
        $data = getlatlngsbyplace($add2);
        $lat2 = @$data[0];
        $lng2 = @$data[1];

        if ($cust_id == "") {
            $customer_id = $pickup;
        } else {
            $customer_id = $cust_id;
        }

        if ($this->session->userdata('company_code') == 'NZKN' || $this->session->userdata('company_code') == 'NZPG') {
            if ($product == "") {
                $product = "KN AsiaLink";
            }
            if ($popupmodeof_trasnport == "") {
                $popupmodeof_trasnport = "LTL";
            }
            if ($service == "") {
                $service = "19";
            }
        }

        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $logdate = $getactual['datetime'];
        $getpickup = getdatetimebytimezone(DFLT_TZ, $earlyQuickbookPickup, $curtz);
        $pickupDateTime = $getpickup['datetime'];
        $getdelivery = getdatetimebytimezone(DFLT_TZ, $earlyQuickbookDelivery, $curtz);
        $deliveryDateTime = $getdelivery['datetime'];

        $ins = [
            'goods_value' => '0.00',
            'shipment_id' => $ship_row_id,
            'customer_id' => $customer_id,
            'product' => $product,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'pickup_datetime' => $pickupDateTime,
            'delivery_datetime' => $deliveryDateTime,
            'pickup_endtime' => $pickupDateTime,
            'drop_endtime' => $deliveryDateTime,
            'drop_custid' => $drop_id,
            'drop_partyid' => $drop_id,
            'user_id' => $user_id,
            'pickup_custid' => $pickup_custid,
            'pickup_partyid' => $pickup_custid,
            'pickup_country' => $pickup_country,
            'pickup_city' => $pickup_city,
            'pickup_pincode' => $pickup_pincode,
            'pickup_company' => $pickup_name,
            'pickup_address1' => $pickup_street,
            'delivery_country' => $drop_country,
            'delivery_city' => $drop_city,
            'delivery_pincode' => $drop_pincode,
            'delivery_company' => $drop_name,
            'delivery_address1' => $drop_street,
            'transport_mode' => $popupmodeof_trasnport,
            'plat' => $lat1,
            'plng' => $lng1,
            'dlat' => $lat2,
            'dlng' => $lng2,
            'modeoftransport' => $tid,
            'created_source' => '3',
            'delivery_address2' => $drop_state,
            'pickup_address2' => $pickup_state,
            'createdon' => $logdate,
            'destination_branch' => $destination_branch_code
        ];

        $this->db->insert("tb_orders", $ins);
        $order_id = $this->db->insert_id();
        $user_id = $this->session->userdata('user_id');

        if ($user_id != '') {
            $get_country = $this->db->select('country_code,company_code')->get_where('tb_users', ['id' => $user_id]);
            $country_code = $get_country->row()->country_code;
            $company_code = $get_country->row()->company_code;
            $genord = ['user_id' => $user_id, 'order_id' => $order_id, 'country_code' => $country_code, 'company_code' => $company_code];
            $booking_id = generatebookingid($genord);


            if(isset($post['qb_ref_id']) && !in_array('DQ',$post['qb_ref_id'])){
                if ( $shipment_id != "" ) {
                    $sql = " SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE 'DQ'
                        AND r.name=o.reference_id AND o.order_id= ? ";
                    $queryResult = $this->db->query($sql,[$order_id]);
                    if ( $queryResult->num_rows() === 0 ) {
                        $arr = [ 'order_id' => $order_id, 'reference_id' => 'DQ', 'ref_value' => $shipment_id, 'createdon' => $cdate ];
                        $this->db->insert( 'tb_order_references', $arr );
                    }
                }
            }

            $this->db->where(['id' => $order_id])->update('tb_orders', ['order_id' => $booking_id]);
            makeorderinvolvedpartiestype($customer_id, $order_id, 'CUSTOMER', $user_id, $company_code);
            insertOrdersRefFileLineIdentifier(['pickupCity' => $pickup_city, 'pickupState' => $pickup_state, 'pickupCountry' => $pickup_country, 'dropCity' => $drop_city, 'dropState' => $drop_state, 'dropCountry' => $drop_country, 'companyCode' => $company_code, 'branchCode' => $branch_code, 'orderRowId' => $order_id, 'date' => $logdate]);
            $details = [
                'shipper_id' => $post['qb_shipper'],
                'service' => $service,
                'delivery_term' => $delivery_terms,
                'incoterm' => $incoterm,
                'purchase_order' => $porder,
                'notify_party' => $notify_party,
                'department_code' => $department_code,
                'createdon' => $logdate,
                'order_row_id' => $order_id,
                'order_id' => $booking_id,
                'order_status' => 'Pending',
                'order_type' => $popuporder_type,
                'cost_center_id' => $cost_center,
                'order_remarks' => $delivery_instructions
            ];

            $this->db->insert('tb_order_details', $details);
        }

        $order_shipper_id = isset($post['qb_shipper']) ? $post['qb_shipper'] : "";
        $order_delivery_id = isset($post['qb_delivery']) ? $post['qb_delivery'] : "";
        $order_consignee_id = isset($post['qb_consignee']) ? $post['qb_consignee'] : "";
        $order_pickup_id = isset($post['qb_pickup']) ? $post['qb_pickup'] : "";

        $pickup_address = $pickup_street . "," . $pickup_city . "," . $pickup_state;
        $shipper_address = ['order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $pickup_address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id];
        $chk_shipperaddress = $this->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $order_shipper_id]);

        if ($chk_shipperaddress->num_rows() > 0) {
            $shipperadd_id = $chk_shipperaddress->row()->id;
            $this->db->where(['id' => $shipperadd_id])->update("tbl_orderparty_address", $shipper_address);
        } else {
            $shipper_address['createdon'] = $cdate;
            $this->db->insert("tbl_orderparty_address", $shipper_address);
        }

        $drop_address = $drop_street . "," . $drop_city . "," . $drop_state;
        $delivery_address = ['order_id' => $order_id, 'party_master_id' => $delivery, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $drop_address, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id];
        $chk_deliveryaddress = $this->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $delivery]);

        if ($chk_deliveryaddress->num_rows() > 0) {
            $dropadd_id = $chk_deliveryaddress->row()->id;
            $this->db->where(['id' => $dropadd_id])->update("tbl_orderparty_address", $delivery_address);
        } else {
            $delivery_address['createdon'] = $cdate;
            $this->db->insert("tbl_orderparty_address", $delivery_address);
        }

        $this->saveCargoDetails($post, $order_id);

        $total_weight = $total_volume = $total_quantity = 0;
        $gettotal = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $order_id . "'");
        if ($gettotal->num_rows() > 0) {
            $total_volume = $gettotal->row()->total_volume;
            $total_weight = $gettotal->row()->total_weight;
            $total_quantity = $gettotal->row()->total_quantity;
        }
        $cargo_forship = [];
        $getcargos = $this->db->query("SELECT quantity_type FROM tb_order_cargodetails WHERE order_id ='" . $order_id . "'");
        if ($getcargos->num_rows() > 0) {
            foreach ($getcargos->result() as $res) {
                $cargo_forship[] = $res->quantity_type;
            }
        }
        $unitspec = "";
        if (!empty($cargo_forship)) {
            $unitspec = implode(',', $cargo_forship);
        }

        $this->db->where(['id' => $ship_row_id])->update("tb_shipments", ['unitspec' => $unitspec, 'txncode' => $booking_id]);
        $this->db->where(['id' => $order_id])->update("tb_orders", ['volume' => $total_volume, 'weight' => $total_weight, 'quantity' => $total_quantity]);



        if ( $pickup_instructions != "" ) {
            $ins_ref = [ 'order_id' => $order_id, 'reference_id' => 'ORD_PIKINST', 'ref_value' => $pickup_instructions, 'createdon' => $logdate ];
            $this->db->insert( 'tb_order_references', $ins_ref );
        }
        if ( $delivery_instructions != "" ) {
            $ins_ref = [ 'order_id' => $order_id, 'reference_id' => 'ORD_DLVINST', 'ref_value' => $delivery_instructions, 'createdon' => $logdate ];
            $this->db->insert( 'tb_order_references', $ins_ref );
        }

        $this->saveReferenceDetails($post, $order_id);
        $this->saveVASDetails($post, $order_id);

        if ($order_shipper_id != "" || $order_shipper_id != 0) {
            $party_type = 0;
            $chk = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Shipper', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id]);
            if ($chk->num_rows() > 0) {
                $party_type = $chk->row()->id;
            } else {
                $chk1 = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Shipper', 'company_code' => $company_code, 'user_id' => $user_id]);
                if ($chk1->num_rows() > 0) {
                    $party_type = $chk1->row()->id;
                }
            }
            $party = ['order_id' => $order_id, 'party_id' => $order_shipper_id, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id];
            $this->db->insert("tb_order_parties", $party);
        }

        if ($order_delivery_id != "" || $order_delivery_id != 0) {
            $party_type = 0;
            $chk = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'DELIVERY', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id]);
            if ($chk->num_rows() > 0) {
                $party_type = $chk->row()->id;
            } else {
                $chk1 = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'DELIVERY', 'company_code' => $company_code, 'user_id' => $user_id]);
                if ($chk1->num_rows() > 0) {
                    $party_type = $chk1->row()->id;
                }
            }
            $party = ['order_id' => $order_id, 'party_id' => $order_delivery_id, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id];
            $this->db->insert("tb_order_parties", $party);
        }

        if ($order_consignee_id != "" || $order_consignee_id != 0) {
            $party_type = 0;
            $chk = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Consignee', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id]);
            if ($chk->num_rows() > 0) {
                $party_type = $chk->row()->id;
            } else {
                $chk1 = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'Consignee', 'company_code' => $company_code, 'user_id' => $user_id]);
                if ($chk1->num_rows() > 0) {
                    $party_type = $chk1->row()->id;
                }
            }
            $party = ['order_id' => $order_id, 'party_id' => $order_consignee_id, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id];
            $this->db->insert("tb_order_parties", $party);
        }

        if ($order_pickup_id != "" || $order_pickup_id != 0) {
            $party_type = 0;
            $chk = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'PICKUP', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id]);
            if ($chk->num_rows() > 0) {
                $party_type = $chk->row()->id;
            } else {
                $chk1 = $this->db->select("id")->get_where("tbl_party_types", ['name' => 'PICKUP', 'company_code' => $company_code, 'user_id' => $user_id]);
                if ($chk1->num_rows() > 0) {
                    $party_type = $chk1->row()->id;
                }
            }
            $party = ['order_id' => $order_id, 'party_id' => $order_pickup_id, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id];
            $this->db->insert("tb_order_parties", $party);
        }

        $redirectUrl = base_url() . 'KNGENQikBkg/index/' . $order_id;

        if ($order_id != '') {
            $resp = ['error' => 0, 'bookingId' => '' . $order_id . '', 'message' => "Order Placed Successfully. Your Booking ID Is $booking_id", 'redirect_url' => $redirectUrl];
        } else {
            $resp = ['error' => 1, 'message' => "Something Went Wrong. Please Try Again"];
        }

        echo json_encode($resp);
        exit;
    }

    // the below method will save the order cargo details
    public function saveCargoDetails($post, $order_id)
    {
        $cdate = date('Y-m-d H:i:s');
        $cargo_id = 0;
        $inner_id = $data = $inner = [];
        $user_id = $this->session->userdata('user_id');

        if (isset($post['qb_cargo_pkg']) && !empty($post['qb_cargo_pkg']) && sizeof($post['qb_cargo_pkg']) > 0) {
            foreach ($post['qb_cargo_pkg'] as $key => $value) {
                $popuplength = isset($post['qb_cargo_len'][$key]) ? $post['qb_cargo_len'][$key] : "0";
                $popupwidth = isset($post['qb_cargo_width'][$key]) ? $post['qb_cargo_width'][$key] : "0";
                $popupheight = isset($post['qb_cargo_height'][$key]) ? $post['qb_cargo_height'][$key] : "0";

                $popupweight = isset($post['qb_cargo_weight'][$key]) ? $post['qb_cargo_weight'][$key] : "0";
                $popupvolume = isset($post['qb_cargo_volume'][$key]) ? $post['qb_cargo_volume'][$key] : "0";

                $cargotype = $post['qb_cargo_pkg'][$key];
                $desc = $post['qb_cargo_desc'][$key];
                $qty = $post['qb_cargo_qty'][$key];

                $len_uom = $post['qb_cargo_len_uom'][$key];
                $width_uom = $post['qb_cargo_width_uom'][$key];
                $height_uom = $post['qb_cargo_height_uom'][$key];

                $weight_uom = $post['qb_cargo_weight_uom'][$key];
                $volume_uom = $post['qb_cargo_volume_uom'][$key];

                if ($popuplength == "") {
                    $popuplength = '0.00';
                }
                if ($popupwidth == "") {
                    $popupwidth = '0.00';
                }
                if ($popupheight == "") {
                    $popupheight = '0.00';
                }
                if ($popupweight == "") {
                    $popupweight = '0.00';
                }
                if ($popupvolume == "") {
                    $popupvolume = '0.00';
                }

                if ($cargotype != '') {
                    $cargo = [
                        'cargo_type' => $cargotype,
                        'goods_description' => $desc,
                        'quantity' => $qty,
                        'length' => $popuplength,
                        'length_unit' => $len_uom,
                        'width' => $popupwidth,
                        'width_unit' => $width_uom,
                        'height' => $popupheight,
                        'height_unit' => $height_uom,
                        'createdby' => $user_id,
                        'createdon' => $cdate,

                        'weight' => $popupweight,
                        'weight_unit' => $weight_uom,
                        'volume' => $popupvolume,
                        'volume_unit' => $volume_uom,
                    ];

                    $ins = $this->db->insert("tb_cargo_details", $cargo);
                    $cargo_id = $this->db->insert_id();

                    $gethandling_unit = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE '" . $cargotype . "'");
                    $handling_unit = "";
                    if ($gethandling_unit->num_rows() > 0) {
                        $handling_unit = $gethandling_unit->row()->id;
                    } else {
                        $handlingunit_ar = ['unit_name' => $cargotype, 'user_id' => $user_id, 'created_at' => $cdate, 'status' => '1'];
                        $this->db->insert("tbl_shipunit_types", $handlingunit_ar);
                        $handling_unit = $this->db->insert_id();
                    }
                    $cargo = [
                        'order_id' => $order_id,
                        'cargo_id' => $cargo_id,
                        'status' => '1',
                        'length' => $popuplength,
                        'width' => $popupwidth,
                        'height' => $popupheight,
                        'quantity' => $qty,
                        'cargo_content' => $desc,
                        'quantity_type' => $cargotype,
                        'handling_unit' => $handling_unit,
                        'weight' => $popupweight,
                        'volume' => $popupvolume
                    ];
                    $this->db->insert("tb_order_cargodetails", $cargo);
                }
            }
        }
    }

    // the below method will save the reference details
    public function saveReferenceDetails($post, $order_id)
    {
        $cdate = date('Y-m-d H:i:s');
        $user_id = $this->session->userdata('user_id');

        if (isset($post['qb_ref_id']) && !empty($post['qb_ref_id']) && sizeof($post['qb_ref_id']) > 0) {
            foreach ($post['qb_ref_id'] as $key => $value) {
                $id = isset($post['qb_ref_id'][$key]) ? $post['qb_ref_id'][$key] : "0";
                $name = isset($post['qb_ref_name'][$key]) ? $post['qb_ref_name'][$key] : "0";
                $value = isset($post['qb_ref_value'][$key]) ? $post['qb_ref_value'][$key] : "0";
                $ins_id = $order_ins_id = 0;

                if ($id != '') {
                    $ins_arr = ['name' => $id, 'description' => $name, 'createdon' => $cdate];
                    $chk_ar = $this->db->select('id')->get_where('tb_reference_master', ['name' => $id, 'status' => '1']);
                    if ($chk_ar->num_rows() == 0) {
                        $ins = $this->db->insert("tb_reference_master", $ins_arr);
                        $ins_id = $this->db->insert_id();
                    } else {
                        $ins_id = $chk_ar->row()->id;
                    }
                    if ($ins_id != "") {
                        $ins_order = ['reference_id' => $id, 'ref_value' => $value, 'createdon' => $cdate, 'order_id' => $order_id];
                        $ins = $this->db->insert("tb_order_references", $ins_order);
                        $order_ins_id = $this->db->insert_id();
                    }
                }
            }
        }
    }

    // the below method will save the VAS details
    public function saveVASDetails($post, $order_id)
    {
        $cdate = date('Y-m-d H:i:s');
        $user_id = $this->session->userdata('user_id');
        if (isset($post['qb_vas_list']) && !empty($post['qb_vas_list']) && sizeof($post['qb_vas_list']) > 0) {
            foreach ($post['qb_vas_list'] as $key => $value) {
                if (isset($post['qb_vas_id_' . $value])) {
                    $vas_id = isset($post['qb_vas_id_' . $value]) ? $post['qb_vas_id_' . $value] : 0;
                    $quantity = isset($post['qb_vas_quantity_' . $value]) ? $post['qb_vas_quantity_' . $value] : 0;

                    $ins = ['order_id' => $order_id, 'vas_id' => $vas_id, 'quantity' => $quantity, 'user_id' => $user_id, 'status' => '1', 'createdon' => $cdate];
                    $chkvas = $this->common->gettblrowdata(['vas_id' => $vas_id, 'order_id' => $order_id, 'status' => '1'], "id,quantity", "tb_order_vas", 0, 0);
                    if (!empty($chkvas)) {
                        $present_quantity = $chkvas['quantity'];
                        $vas_row_id = $chkvas['id'];
                        if ($vas_row_id != "0") {
                            $total_quantity = $quantity + $present_quantity;
                            $newupd = $this->common->updatetbledata("tb_order_vas", ['quantity' => $total_quantity], ['id' => $vas_row_id]);
                        }
                    } else {
                        $this->common->insertTableData("tb_order_vas", $ins);
                    }
                }
            }
        }
    }

    // the below method will fetch the rates from rateengine and display in quick book popup when clicked on get quote
    public function getQuoteFromRateEngine()
    {
        //assigning default values

        $offering_type = 'FTL';
        $mode = "Road";
        $sourcePin = $destPin = '';
        $pickupDate = "";
        $deliveryDate = "";
        $sourceCity = $destCity = '';
        parse_str($_POST['data'], $post);

        //echo "<pre>";print_r($post);exit;

        $mandatoryFields = [
            'qb_transport_mode',
            'qb_pickup_id',
            'qb_delivery_id',
            'qb_early_pickup',
            'qb_early_delivery',
            'qb_pickup_zip',
            'qb_delivery_zip',
            'qb_pickup_city',
            'qb_delivery_city'
        ];

        $errorMsg = '';
        foreach ($mandatoryFields as $eachField) {
            if (!isset($post[$eachField]) || $post[$eachField] == '') {
                $fieldname = ucwords(strtolower(str_replace("qb_", " ", $eachField)));
                $errorMsg .= $fieldname . ',';
            }
        }

        if (isset($post['qb_cargo_pkg']) && !empty($post['qb_cargo_pkg'])) {
            $errorWeight = false;
            foreach ($post['qb_cargo_pkg'] as $key => $value) {
                if (!empty($value)) {
                    $cargoWeight = isset($post['qb_cargo_weight'][$key]) ? $post['qb_cargo_weight'][$key] : 0;
                    if ($cargoWeight == '' || $cargoWeight <= 0) {
                        $errorWeight = true;
                    }
                }
            }
            if ($errorWeight) {
                $errorMsg .= 'Cargo weight should be greater than 0';
            }
        }

        $errorMsg = trim($errorMsg, ',');

        if ($errorMsg != '') {
            $resp = ['error' => 1, "message" => "Mandatory Fields Missing. Please Enter The Values For The Fields:$errorMsg"];
            echo json_encode($resp);
            exit;
        }

        $sourcePin = $post['qb_pickup_zip'];
        $destPin = $post['qb_delivery_zip'];
        $sourceCity = $post['qb_pickup_city'];
        $destCity = $post['qb_delivery_city'];

        $pickupProvince = $post['qb_pickup_province'];
        $destProvince = $post['qb_delivery_province'];
        $pickupCountry = $post['qb_pickup_country'];
        $destCountry = $post['qb_delivery_country'];

        $pickupData = [$sourcePin, $sourceCity, $pickupProvince, $pickupCountry];
        $destinationData = [$destPin, $destCity, $destProvince, $destCountry];
        $geoPairs = $this->generateGeoPairs($pickupData, $destinationData, 'DUMMY_FROM', 'DUMMY_TO');
        $geoTierPairs = $this->generateGeoPairsForGeoTier($pickupData, $destinationData, 'gsheet.geo_from', 'gsheet.geo_to');
        $offeringType = $post['qb_transport_mode'];
        $tariffType = 'BUY';
        $pickupDate = date("m/d/Y", strtotime($post['qb_early_pickup']));
        $deliveryDate = date("m/d/Y", strtotime($post['qb_early_delivery']));

        $cargoWeight = $cargoVolume = 0;
        if (!empty($post['qb_cargo_weight']) && sizeof($post['qb_cargo_weight']) > 0) {
            foreach ($post['qb_cargo_weight'] as $each) {
                if ($each > 0) {
                    $cargoWeight = $cargoWeight + $each;
                }
            }
        }

        if (!empty($post['qb_cargo_volume']) && sizeof($post['qb_cargo_volume']) > 0) {
            foreach ($post['qb_cargo_volume'] as $each) {
                if ($each > 0) {
                    $cargoVolume = $cargoVolume + $each;
                }
            }
        }
        $cargoQuantity = 0;
        if (!empty($post['qb_cargo_qty']) && sizeof($post['qb_cargo_qty']) > 0) {
            foreach ($post['qb_cargo_qty'] as $each) {
                if ($each > 0) {
                    $cargoQuantity = $cargoQuantity + $each;
                }
            }
        }
        $this->load->model('Quickbook_model');
        $ratePreferencesData = $this->Quickbook_model->getRatePreferencesInQuickBook(['sourcePin' => $sourcePin, 'sourceCity' => $sourceCity, 'sourceCountry' => $pickupCountry, 'sourceProvince' => $pickupProvince, 'destinationPin' => $destPin, 'destinationCity' => $destCity, 'destinationCountry' => $destCountry, 'destinationProvince' => $destProvince, 'companyCode' => $this->session->userdata('company_code'), 'branchCode' => $this->session->userdata('branch_code')]);
        $recordsToGet = $ratePreferencesData['recordsToGet'];
        if (empty($recordsToGet)) {
            $html = '<tr align="center">'
                . '<td colspan="6">No Records Found</td>'
                . '</tr>';
            $resp = [
                'error' => 0,
                'message' => $html,
                'rates' => [],
            ];

            echo json_encode($resp);
            exit;
        }
        $charges = $this->Quickbook_model->getCharges($cargoWeight, $cargoVolume, $cargoQuantity, $offeringType, $tariffType, $geoPairs, $geoTierPairs, $ratePreferencesData);
        $rates = $charges[0];

        if ($rates->num_rows() > 0) {
            $html = '';
            $i = 1;
            $totalAmount = 0;

            foreach ($rates->result_array() as $rate_index => $rate) {
                $vendorId = $vehicleId = '';
                if (isset($rate['vendor_profile_id'])) {
                    if ($rate['vendor_profile_id'] != '') {
                        $vendorId = $this->Quickbook_model->getVendorIdFromRateEngline($rate['vendor_profile_id']);
                    }
                }

                if (isset($rate['vehicle_profile_id'])) {
                    if ($rate['vehicle_profile_id'] != '') {
                        $vehicleId = $this->Quickbook_model->getVehicleIdFromRateEngline($rate['vehicle_profile_id']);
                    }
                }

                if (!empty($rate['uom_conversion_id'])) {
                    $rate['total_price'] = $this->Quickbook_model
                        ->getConversionFactorRate($cargoWeight, $cargoVolume, $cargoQuantity, $rate['uom_conversion_id'], $rate['price'], $rate['min_price'], $rate['rr_charge_type'], $rate['geotier_id'], $geoTierPairs, $rate['rate_id']);
                }

                $html .= '<tr align="center">'
                    . '<td><input type="radio" data-vendor="' . $vendorId . '" data-vehicle="' . $vehicleId . '" name="qb_charge" value="' . $rate['rate_id'] . '"></td>'
                    . '<td>' . $rate['vendor_profile'] . '</td>'
                    . '<td>' . $rate['vehicle_profile'] . '</td>'
                    . '<td>' . $rate['transit_time'] . '</td>'
                    . '<td>' . round($rate['total_price'], 2) . '</td>'
                    . '<td>' . $rate['currency'] . '</td>'
                    . '</tr>';
            }
        } else {
            $html = '<tr align="center">'
                . '<td colspan="6">No Records Found</td>'
                . '</tr>';
        }
        $resp = [
            'error' => 0,
            'message' => $html,
            'rates' => $rates->result_array(),
        ];

        echo json_encode($resp);
        exit;
    }

    private function generateGeoPairs($pickupDetails, $deliveryDetails, $src, $dst)
    {
        $geoHierarchy = [6, 5, 3, 2];
        $lanes = $geo = [];
        foreach ($pickupDetails as $pickupKey => $pickupvalue) {
            foreach ($deliveryDetails as $deliveryKey => $deliveryValue) {
                $lanes[] = '( lm.source_geo = ' . $geoHierarchy[$pickupKey] . ' AND ' . $src . ' = ' . $this->db->escape($pickupvalue) . ' AND lm.destination_geo=' . $geoHierarchy[$deliveryKey] . ' AND ' . $dst . ' = ' . $this->db->escape($deliveryValue) . ')';
            }
        }
        foreach ($pickupDetails as $i1) {
            foreach ($deliveryDetails as $i2) {
                $geo[] = '(' . $src . ' = ' . $this->db->escape($i1) . ' AND ' . $dst . ' = ' . $this->db->escape($i2) . ')';
            }
        }
        $lanesCondition = implode(' OR ', $lanes);
        $geoCondition = implode(' OR ', $geo);
        return ['lanesCondition' => $lanesCondition, 'geoCondition' => $geoCondition];
    }

    public function getdestinationoncode()
    {
        $post = $this->input->post();
        $province = $post['province'] ?? "";
        $city = $post['city'] ?? "";
        $code = "";
        $status = 'Error';
        if (!empty($province)) {
            if ($province != $city) {
                $wherecode = ['province' => $province, 'city' => $city];
            } else {
                $wherecode = ['province' => $province];
            }
            $getcode = $this->common->gettblrowdata($wherecode, "destination_branch_code", "tb_destination_branch_codes", 0, 0);

            if (!empty($getcode)) {
                $code = $getcode['destination_branch_code'];
                $status = 'Success';
            }
        }
        $response = ['status' => $status, "code" => $code];
        echo json_encode($response);
    }

    private function generateGeoPairsForGeoTier(array $pickupData, array $destinationData, string $geoFromKey, string $geoToKey): array
    {
        $geoHierarchy = ['POSTAL CODE','CITY','PROVINCE','COUNTRY'];
        foreach ($pickupData as $pickupKey => $i1) {
            foreach ($destinationData as $deliveryKey => $i2) {
                if ($pickupKey == $deliveryKey) {
                    $output[$geoHierarchy[$deliveryKey]] = '(' . $geoFromKey . ' = ' . $this->db->escape($i1) . ' AND ' . $geoToKey . ' = ' . $this->db->escape($i2) . ')';
                }
            }
        }
        return $output ?? [];
    }
}
