<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
class NZordersmanifest extends CI_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->library('session');
		require 'vendor/autoload.php';
		if($this->session->userdata('user_id') == ''){
			redirect('login');
		}
		$this->load->model('common');
		$this->load->model('Datatables_model');
		$this->load->model('DataArrayFormatter_model');
		$this->load->model('DataQueryFormatter_model');
	}

    public function index(int $carrierId, string $val): void
    {
		$data1 = [];
		$orderids = $post_ar = $formattedData = $final_data = array();
		if($val != ""){
            $getCarrierName = $this->common->gettblrowdata(['id' => $carrierId], "name", "tb_vendors", 0, 0);
            $data1['carrier_name'] = $getCarrierName['name'] ?? '';
			$company_code = $this->session->userdata('company_code');
			$orderids = explode("_",$val);
			if(!empty($orderids)){
				$selectColumns=array('o.id','o.order_id','o.pickup_company',
		        'o.delivery_company','o.delivery_city','od.order_remarks'
	        	);
	        	$table_name='tb_orders o';
		        $indexColumn='o.id';
		        $groupBy='o.id';
		        $excludeCountQuery='Yes';
		        $dataTableSortOrdering=array();
		        $joinsArray = array();
		        $orderTableWhere = "";
		        $orderNumbers =implode(',', $orderids);
		        $orderTableWhere = " AND o.company_code LIKE '".$company_code."' ";
		        if($orderNumbers!=''){
	                $orderTableWhere.=" and o.id in ($orderNumbers)";
	            }
		        $wherecondition= $indexColumn."!='' ".$orderTableWhere;
		        $joinsArray[]=array('table_name'=>'tb_order_details as od','condition'=>"o.id=od.order_row_id",'join_type'=>'left');
	        	$getRecordListing = $this->Datatables_model->datatablesQuery( $selectColumns, $dataTableSortOrdering, $table_name, $joinsArray, $wherecondition, $indexColumn, 'TRUE', $groupBy,$excludeCountQuery,'POST' );
	        	$reqData=array('id');
	        	$formattedData=$this->DataArrayFormatter_model->getCommaSeparatedFields($reqData,$getRecordListing['data']);

	        	if(isset($formattedData['commaSeparated']['id'])){
	        		$codes="'DQ'";
	        		$formattedData=$this->DataQueryFormatter_model->getOrderReferenceData($formattedData['commaSeparated']['id'],$formattedData,$codes);
	        		$formattedData=$this->DataQueryFormatter_model->getOrdercargodetailsformanifest($formattedData['commaSeparated']['id'],$formattedData);
	        		$formattedData=$this->DataQueryFormatter_model->getOrderCargoDetails($formattedData['commaSeparated']['id'],$formattedData);

	        	}
	        	$getRecordListing=array();
		        if(isset($formattedData['orders'])){
		            $getRecordListing=$formattedData['orders'];
		        }
		        $deliverynote = "";
				$total_weight = $total_volume = $total_quantity = 0;
		        if(!empty($getRecordListing)){
		        	foreach ( $getRecordListing as $res ) {
		        		$referenceData= '';
	                    if (isset($res['reference_value'])) {
	                        $referenceData = $res['reference_value'];
	                    }
	                    if($referenceData != ""){
	                    	$arrayData = $this->DataArrayFormatter_model->formatReferenceParameters($referenceData);
	                    }
	                    if (isset($arrayData['DQ'])) {
                            $deliverynote = $arrayData['DQ'];
                        }
                        $cargos = $cargosData = array();
                        if(isset($res['cargos'])){
                        	foreach ($res['cargos'] as $eachcargoline) {
                        		if(isset($eachcargoline['cargodetails'])){
	                        	$cargoDataArray = explode('+++++', $eachcargoline['cargodetails']);
	                        		foreach ($cargoDataArray as $Cargo) {
	                        			$cargosData[] = $this->giveInvoiceParameters($Cargo);
                        			}
                        		}
                        	}
                        }
						if(isset($res['totwg'])){
							$total_weight += $res['totwg'];
						}
						if(isset($res['totqty'])){
							$total_quantity += $res['totqty'];
						}
						if(isset($res['totvolume'])){
							$total_volume += $res['totvolume'];
						}
                        $generator = new Picqer\Barcode\BarcodeGeneratorPNG();
                        $final_data[]   = array('cargos'=>$cargosData,'deliverynote'=>$deliverynote,'order_id'=>$res['order_id'],'pickup_company'=>$res['pickup_company'],'delivery_company'=>$res['delivery_company'],'delivery_city'=>$res['delivery_city'],'order_remarks'=>$res['order_remarks'],'total_volume'=>$total_volume,'total_weight'=>$total_weight,'total_quantity'=>$total_quantity,'generator'=>$generator);
		        	}
		        }
				if(!empty($final_data)){
					$data1['final_data'] = $final_data;
					$output = $this->load->view('orders/nzmanifest', $data1, TRUE);

					$mpdf = new \Mpdf\Mpdf([
						'tempDir' => FCPATH .'assets/tmp',
						'default_font_size' => 9,
						'format' => 'A4-L'
					]);
					$mpdf->WriteHTML($output);
					$mpdf->Output("Manifest_" . date('YmdHis') . ".pdf", 'D');
				}
			}
		}
	}

	public function giveInvoiceParameters($invoiceParam) {
	    $finalArray = array();
	    if (!empty($invoiceParam) && $invoiceParam != '') {
	        $requiredArray = explode(';', $invoiceParam);
	        if (!empty($requiredArray) && sizeof($requiredArray) > 0) {
	            foreach ($requiredArray as $eachitem) {
	                $explodeArray = explode('=====', $eachitem);
	                if (!empty($explodeArray) && sizeof($explodeArray) > 0) {
	                    $key = isset($explodeArray[0]) ? $explodeArray[0] : "";
	                    $value = isset($explodeArray[1]) ? $explodeArray[1] : "";
	                    $finalArray[$key] = $value;
	                }
	            }
	        }
	    }
	    return $finalArray;
	}

    public function getCarriersBasedOnBranch(): void
    {
        $branchCode = $this->session->userdata('branch_code');
        echo json_encode($this->common->gettbldata(['branch_code' => $branchCode, 'status' => '1'], "id,name", "tb_vendors", 0, 0));
    }
}
?>
