<?php
if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Ndrreport extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('common');
        if (!checkUrlAccessForUser('NDRREPORT')) {
            redirect("Forbiddenaccess");
        }
    }
    /**
     * display search data for NDR Report page
     *
     *
     *
     * @author    Developer Name external.ram.k@kuehne-nagel.com
     * @date      29-03-2021 11:00:00+05.30
     * @change    Asia
     * @param
     * @return    Array
     */
    public function index()
    {
        $this->getsearchresult();
    }
    public function getsearchresult()
    {
        $cdate = date('Y-m-d h:i:s');
        $data['page_title'] = $this->lang->line('ndr_report');
        $data['sub_title'] = $this->lang->line('leftmenu_reports');
        $userid = $this->session->userdata("user_id");
        $aqucarrier = isset($post1['aqucarrier']) ? $post1['aqucarrier'] : array();
        $data['aqucarrierid'] = $aqucarrier;
        $data['carrierlist'] = $this->common->gettbldata(array("user_id"=>$userid),"id,name","tb_vendors",0,0);
        $data['aquorder'] = array();
        $this->newtemplate->dashboard("reportshipment/ndrreport", $data);
    }
    /**
     * get searched data for query params
     *
     *
     *
     * @author    Developer Name external.ram.k@kuehne-nagel.com
     * @date      29-03-2021 11:00:00+05.30
     * @change    Asia
     * @param
     * @return    Array
     */
    public function searchorders($post)
    {
        $whr = array();
        $post = $this->input->post(NULL,TRUE);
        $status_search = isset($post['aquordtype']) ? $post['aquordtype'] : "";
        if ($status_search == 'MANIFESTED') {
            if (isset($post['aqufromdate']) && $post['aqufromdate'] != "") {
                $aqufromdate = date('Y-m-d', strtotime($post['aqufromdate']));
                $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >="] = $aqufromdate;
            }
            if (isset($post['aqutodate']) && $post['aqutodate'] != "") {
                $todate = date('Y-m-d', strtotime($post['aqutodate']));
                $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="] = $todate;
            }
            if (isset($post['booking_id']) && $post['booking_id'] != "") {
                $whr['o.order_id'] = $post['booking_id'];
            }
        }else if($status_search == "CLOSED"){
            if (isset($post['booking_id']) && $post['booking_id'] != "") {
                $whr['o.order_id'] = $post['booking_id'];
            }
        } else {
            if (isset($post['aqufromdate']) && $post['aqufromdate'] != "") {
                $aqufromdate = date('Y-m-d', strtotime($post['aqufromdate']));
                $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $aqufromdate;
            }
            if (isset($post['aqutodate']) && $post['aqutodate'] != "") {
                $todate = date('Y-m-d', strtotime($post['aqutodate']));
                $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
            }
            if (isset($post['booking_id']) && $post['booking_id'] != "") {
                $whr['o.order_id'] = $post['booking_id'];
            }
        }
    }
    /**
     * get the uniqlo status report list into datatables
     *
     *
     *
     * @author    Developer Name external.ram.k@kuehne-nagel.com
     * @date      29-03-2021 11:00:00+05.30
     * @change    Asia
     * @param     Array Order Info.
     * @return    Array
     */
    public function ajaxListing(){
        $this->load->model('DataArrayFormatter_model');
        $this->load->model('DataQueryFormatter_model');
        $this->load->model('Datatables_model');
        $dataTableSortOrdering=array();
        $whr = array();
        $post = array();
        $status_search ="";
        $wherecondition='';
        $draw = $this->input->post('draw',TRUE);
        $start = $this->input->post('start',TRUE);
        $limit = $this->input->post('length',TRUE);
        $orderBy = $this->input->post('order',TRUE);
        $userid = $this->session->userdata("user_id");
        $company_code = $this->session->userdata("company_code");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $business_type = $this->session->userdata('business_type');
        $custid = "";
        if (!empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        $aquorder = $country_userids = $whr = $post = $where = $other_checks = $wherein = $subcusts = array();
        if (!empty($this->session->userdata("country_user_ids")) && ($this->session->userdata("country_user_ids") != null) && (count($this->session->userdata("country_user_ids")) > 0)) {
            $country_userids = $this->session->userdata("country_user_ids");
        }
        $status_search = "";
        $indexColumn = 'o.id';
        $post = $this->input->post('data',TRUE);
        $whr = $this->searchorders($post);
        $order_status = isset($post['aquordtype']) ? $post['aquordtype'] : "";
        $ad_orderstatus = isset($post['order_status']) ? $post['order_status'] : "";
        if (isset($post['aqucarrier']) && $post['aqucarrier'] != array()) {
            $wherein['vendor_id'] = $post['aqucarrier'];
        }
        if (isset($post['aqucarrierid_adv']) && !empty($post['aqucarrierid_adv'])) {
            $wherein['vendor_id'] = $post['aqucarrierid_adv'];
        }
        if (!empty($order_status)) {
            $status_search = $order_status;
        }
        if (!empty($ad_orderstatus)) {
            $status_search = $ad_orderstatus;
        }
        $other_checks['status_search'] = $status_search;
        if (isset($post['shipper_name']) && $post['shipper_name'] != "") {
            $other_checks['shipper_name'] = $post['shipper_name'];
        }
        if (isset($post['consignee_name']) && $post['consignee_name'] != "") {
            $other_checks['consignee_name'] = $post['consignee_name'];
        }
        if (isset($post['lr_number']) && $post['lr_number'] != "") {
            $other_checks['lr_number'] = $post['lr_number'];
        }
        if (isset($post['customer_reference_number']) && $post['customer_reference_number'] != "") {
            $other_checks['customer_reference_number'] = $post['customer_reference_number'];
        }
        if (isset($post['qbook_pickupdatetime']) && $post['qbook_pickupdatetime'] != "") {
            $other_checks['qbook_pickupdatetime'] = $post['qbook_pickupdatetime'];
        }
        if (isset($post['container_num']) && $post['container_num'] != "") {
            $other_checks['container_num'] = trim($post['container_num']);
        }
        $other_checks['closed_from_date'] = $other_checks['closed_to_date'] = "";
        if ($this->session->userdata('user_role_id')=='4') {
            $userid = 0;
        }
        if (! empty($custid)) {
            if ($this->session->userdata('sub_cust') !== FALSE) {
                $subcusts = $this->session->userdata('sub_cust');
                if (!empty($subcusts)) {
                    array_push($subcusts, $custid);
                } else {
                    $subcusts = array(
                        $custid
                    );
                }
            } else {
                $subcusts = array(
                    $custid
                );
            }
        }
        $orderTableCondition=array();
        if(!empty($whr)){
            foreach($whr as $key=>$value){
                $value="'$value'";
                if($key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') <=" || $key=="DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="){
                    $orderTableCondition[]= $key.$value;
                }else{
                    $orderTableCondition[]= $key.' = '.$value;
                }
            }
        }
        $orderTableCondition[]='o.status!=0';
        $orderTableCondition[]='o.shift_id!=0';
        if (isset($wherein) && ! empty($wherein)) {
            if (isset($wherein['vendor_id']) && $wherein['vendor_id'] != "") {
               $vendorIds=  implode(',',$wherein['vendor_id']);
               if($vendorIds!=''){
                $orderTableCondition[]= "o.vendor_id in ($vendorIds)";
               }
            }
        }
        if (isset($other_checks) && ! empty($other_checks)) {
            if (isset($other_checks['status_search']) && ! empty($other_checks['status_search'])) {
                $status_search = $other_checks['status_search'];
                if ($status_search == 'PENDING') {
                    $orderTableCondition[]= "o.trip_id = 0";
                } else if ($status_search == 'ACTIVE') {
                    $orderTableCondition[]= "o.trip_id!= 0";
                    $orderTableCondition[]= "o.trip_sts= 0";
                } else if ($status_search == 'CLOSED') {
                    $orderTableCondition[]= "o.trip_id!= 0";
                    $orderTableCondition[]= "o.trip_sts= 1";
                }
            }
        }
        if ($userid != '0' && $userid != '') {
            if (! empty($country_userids) && count($country_userids) > 0) {
                $countryuseridsArray=  implode(',',$country_userids);
               if($countryuseridsArray!=''){
                $orderTableCondition[]= "o.user_id in ($countryuseridsArray)";
               }
            } else {
                $orderTableCondition[]= "o.user_id = '$userid' ";
            }
        }
        $orderTableWhere= implode(' AND ',$orderTableCondition);
        $orderByCondition='';
        if(isset($orderBy[0]));{
            if($orderBy[0]!=''){
                $ordColIndex= $orderBy[0]['column'];
                $ordColDir= $orderBy[0]['dir'];
                if($ordColDir==''){
                    $ordColDir = 'asc';
                }
                if(isset($dataTableSortOrdering[$ordColIndex]) && $dataTableSortOrdering[$ordColIndex]!='' ){
                    $orderByCondition='  '.$dataTableSortOrdering[$ordColIndex].' '.$ordColDir.' ';
                }
            }
        }
        if($orderTableWhere!=''){
            $orderTableWhere=" and $orderTableWhere ";
        }
        if(!isset($other_checks['consignee_name'])){
            $other_checks['consignee_name']='';
        }
        if(!isset($other_checks['shipper_name'])){
            $other_checks['shipper_name']='';
        }
        if(!isset($other_checks['qbook_pickupdatetime'])){
            $other_checks['qbook_pickupdatetime']='';
        }
        if(!isset($other_checks['lr_number'])){
            $other_checks['lr_number']='';
        }
        if(!isset($other_checks['customer_reference_number'])){
            $other_checks['customer_reference_number']='';
        }
        $joinArray=array();
        $whereArray=array();
        if(!empty($other_checks) && sizeof($other_checks)>0){
            if( ($other_checks['consignee_name']!='') || ($other_checks['shipper_name']!='') || ($other_checks['customer_reference_number']!='')  ||  ($other_checks['qbook_pickupdatetime']!='') || ($other_checks['lr_number']!='')){
                $sql="select o.id from tb_orders o ";
            if (isset($other_checks['shipper_name']) && ($other_checks['shipper_name'] != '') && isset($other_checks['consignee_name']) && ($other_checks['consignee_name'] != '')) {
                $s = $other_checks['shipper_name'];
                $c = $other_checks['consignee_name'];
                $joinArray[]=array('tb'=>'tb_order_parties p','condition'=>'p.order_id=o.id','type'=>'LEFT');
                $joinArray[]=array('tb'=>'tbl_party_master pm','condition'=>'pm.id=p.party_id','type'=>'LEFT');
                $whereArray[]="((pm.name LIKE '%" . $s . "%' OR pm.mobile LIKE '%" . $s . "%' OR pm.code LIKE '%" . $s . "%') OR (pm.name LIKE '%" . $c . "%' OR pm.mobile LIKE '%" . $c . "%' OR pm.code LIKE '%" . $c . "%'))";
            } else if (isset($other_checks['consignee_name']) && ($other_checks['consignee_name'] != '')) {
                $c = $other_checks['consignee_name'];
                $joinArray[]=array('tb'=>'tb_order_parties p','condition'=>'p.order_id=o.id','type'=>'LEFT');
                $joinArray[]=array('tb'=>'tbl_party_master pm','condition'=>'pm.id=p.party_id','type'=>'LEFT');
                $whereArray[]="(pm.name LIKE '%" . $c . "%' OR pm.mobile LIKE '%" . $c . "%' OR pm.code LIKE '%" . $c . "%')";
            } else if (isset($other_checks['shipper_name']) && ($other_checks['shipper_name'] != '')) {
                $s = $other_checks['shipper_name'];
                $joinArray[]=array('tb'=>'tb_order_parties p','condition'=>'p.order_id=o.id','type'=>'LEFT');
                $joinArray[]=array('tb'=>'tbl_party_master pm','condition'=>'pm.id=p.party_id','type'=>'LEFT');
                $whereArray[]="(pm.name LIKE '%" . $s . "%' OR pm.mobile LIKE '%" . $s . "%' OR pm.code LIKE '%" . $s . "%')";
            }
            if (isset($other_checks['lr_number']) && ($other_checks['lr_number'] != '') && isset($other_checks['customer_reference_number']) && ($other_checks['customer_reference_number'] != '')) {
                $lr_val = $other_checks['lr_number'];
                $cust_ref_val = $other_checks['customer_reference_number'];
                $joinArray[]=array('tb'=>'tb_order_references orf','condition'=>'orf.order_id=o.id','type'=>'LEFT');
                if ($business_type == 'Customer') {
                     $whereArray[]="(orf.ref_value like '%" . $lr_val . "%' and orf.reference_id='XSR' and orf.status='1') OR (orf.ref_value like '%" . $cust_ref_val . "'  and orf.reference_id='DQ' and orf.status='1')";
                } else {
                    $whereArray[]="(orf.ref_value like '%" . $lr_val . "%' and orf.reference_id='XSR' and orf.status='1') OR (orf.ref_value like '%" . $cust_ref_val . "'  and orf.reference_id='DQ' and orf.status='1')";
                }
            } elseif (isset($other_checks['lr_number']) && ($other_checks['lr_number'] != '')) {
                $lr_val = $other_checks['lr_number'];
                $joinArray[]=array('tb'=>'tb_order_references orf','condition'=>'or.order_id=o.id','type'=>'LEFT');
                if ($business_type == 'Customer') {
                    $whereArray[]="(orf.ref_value like '%" . $lr_val . "%' and orf.reference_id='BN' and orf.status='1')";
                } else {
                    $whereArray[]="(orf.ref_value like '%" . $lr_val . "%' and orf.reference_id='PO' and orf.status='1')";
                }
            } elseif (isset($other_checks['customer_reference_number']) && ($other_checks['customer_reference_number'] != '')) {
                $cust_ref_val = $other_checks['customer_reference_number'];
                $joinArray[]=array('tb'=>'tb_order_references orf','condition'=>'orf.order_id=o.id','type'=>'LEFT');
                $whereArray[]="(orf.ref_value like '%" . $cust_ref_val . "%' and orf.reference_id='DQ' and orf.status='1')";
            }
            if (isset($other_checks['qbook_pickupdatetime']) && ($other_checks['qbook_pickupdatetime'] != '')) {
                $pickdatetime = date("Y-m-d", strtotime($other_checks['qbook_pickupdatetime']));
                $joinArray[]=array('tb'=>'tb_stop_status tps','condition'=>'o.shift_id=tps.shipment_id','type'=>'LEFT');
                $whereArray[]="(tps.status_id='10' and DATE_FORMAT(tps.createdon,'%Y-%m-%d') ='" . $pickdatetime . "') OR (DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') ='" . $pickdatetime . "')";
                 }
            }
        }
        if(isset($other_checks['container_num']) && $other_checks['container_num']!='' ){
            if(!isset($sql)){
                $sql="select o.id from tb_orders o ";
            }
            $container_number = $other_checks['container_num'];
            $joinArray[]=array('tb'=>'tb_order_references orf_ctr','condition'=>'orf_ctr.order_id=o.id','type'=>'LEFT');
            $whereArray[]="(orf_ctr.ref_value like '%" . $container_number . "%' and orf_ctr.reference_id='AWB' and orf_ctr.status='1')";
        }
        if ($status_search == 'MANIFESTED') {
            if(!isset($sql)){
                $sql="select o.id from tb_orders o ";
            }
            $joinArray[]=array('tb'=>'tb_order_status os','condition'=>'os.order_id=o.id','type'=>'LEFT');
            $whereArray[]=" os.status=1 and os.status_code=0470";
        }
        $ordCon='';
        if(!empty($whereArray) && sizeof($whereArray)>0){
            $ordCon= implode(' AND ',$whereArray);
        }
        if(!empty($joinArray) && sizeof($joinArray)>0){
            if(!isset($sql)){
                $sql="select o.id from tb_orders o ";
            }
            foreach($joinArray as $eachJoin){
                $sql.= ' '.$eachJoin['type'].' join '.$eachJoin['tb'].' on '.$eachJoin['condition'].'';
            }
            $sql.=" where o.id!= '' ";
            if($ordCon!=''){
                $sql.=" and $ordCon ";
            }
            $orderNumbers='';
            if($sql!=''){
                $dat = $this->db->query($sql);
                if ($dat->num_rows() > 0) {
                    $resultant = $dat->result_array();
                    if (! empty($resultant) && sizeof($resultant) > 0) {
                        foreach ($resultant as $eachOrdNum) {
                            $orderNumbers = $orderNumbers . $eachOrdNum['id'] . ',';
                        }
                    }
                    $orderNumbers = trim($orderNumbers, ',');
                    if($orderNumbers!=''){
                        $orderTableWhere.=" and o.id in ($orderNumbers)";
                    }
                }
            }
        }
        if(!empty($subcusts) && sizeof($subcusts)>0){
            $customerIdCondition= implode(',',$subcusts);
            if($customerIdCondition!=''){
                $orderTableWhere.=" and o.customer_id in ($customerIdCondition)";
            }
        }
        //below query for pagination count and applying where condition in subquery for sub-query to be fast
        $countAndOrderIdQuery="select count(o.id) as count from tb_orders o
        where o.id!=0 $orderTableWhere ";
         $compiledCount='';
        $resultSet=$this->db->query($countAndOrderIdQuery);
        if($resultSet->num_rows()>0){
            $resdata = $resultSet->result_array();
            if(isset($resdata[0]['count'])){
                $compiledCount=$resdata[0]['count'];
            }
        }else{
            $compiledCount=0;
        }
        $selectColumns=array('o.id','o.order_id','o.goods_value','o.transport_mode','o.pickup_company','o.pickup_city','o.pickup_address2',
        'o.delivery_company','o.delivery_city','o.delivery_address2','o.delivery_pincode','o.pickup_datetime','o.delivery_datetime','o.delivery_country',
        'o.createdon','o.shift_id','o.drop_endtime','o.vendor_id','o.customer_id','o.created_source','o.quantity','or.ref_value as ndrvalue','or.ref_belongs_to','or.order_shortNo','or.createdon as ndrdate','or.updatedon as ndrupddate','tv.name as vendor_name',
        'cust.name as customer_name','cust.code as customer_code','cust.location as customer_loc','pod.doc_type','pod.imgpath','pod.receiver_name','pod.createdon as pod_available'
        );
        $table_name='tb_orders o';
        $indexColumn='o.id';
        $groupBy='o.id';
        /*$orderBy='o.id desc';*/
        $excludeCountQuery = 'Yes';
        $wherecondition= $indexColumn."!='' ".$orderTableWhere;
        $orderByCondition=$orderByCondition;
        $timeZone=$curtz;
        $joinsArray[]=array('table_name'=>'tb_order_references as or','condition'=>"or.order_id=o.id AND or.reference_id='NDR' AND or.status=1",'join_type'=>'INNER');
        $joinsArray[]=array('table_name'=>'tb_vendors as tv','condition'=>"tv.id=o.vendor_id",'join_type'=>'left');
        $joinsArray[]=array('table_name'=>'tb_customers as cust','condition'=>"cust.id=o.customer_id",'join_type'=>'left');
        $joinsArray[]=array('table_name'=>'tb_pod_uploads as pod','condition'=>'o.id=pod.order_id AND pod.doc_type ="3" AND pod.stop_type ="D" AND pod.status ="1"','join_type'=>'left');
        $dataTableSortOrdering=array();
        $getRecordListing = $this->Datatables_model->datatablesQuery( $selectColumns, $dataTableSortOrdering, $table_name, $joinsArray, $wherecondition, $indexColumn, 'TRUE', $groupBy,$excludeCountQuery,'POST' );
        if($excludeCountQuery=='Yes'){
            $totalRecords     = $compiledCount;
            $recordsFiltered  = $compiledCount;
        }else{
            $totalRecords     = $getRecordListing['recordsTotal'];
            $recordsFiltered  = $getRecordListing['recordsFiltered'];
        }
        $reqData=array('id','shift_id');
        $this->db->query('SET SESSION group_concat_max_len=10240');
        $formattedData=$this->DataArrayFormatter_model->getCommaSeparatedFields($reqData,$getRecordListing['data']);
        if(isset($formattedData['commaSeparated']['id']) && $formattedData['commaSeparated']['id']!=''){
            $codes="'DQ','AWB','ORD','XSR'";
            $formattedData=$this->DataQueryFormatter_model->getOrderReferenceData($formattedData['commaSeparated']['id'],$formattedData,$codes);
            $formattedData=$this->DataQueryFormatter_model->getOrderCargoDetails($formattedData['commaSeparated']['id'],$formattedData);
            $formattedData=$this->DataQueryFormatter_model->getOrderCargoDetails($formattedData['commaSeparated']['id'],$formattedData);
            $formattedData=$this->DataQueryFormatter_model->getOrderCargoContent($formattedData['commaSeparated']['id'],$formattedData);
            $formattedData=$this->DataQueryFormatter_model->getEstimatedPickup($formattedData['commaSeparated']['id'],$formattedData);
        }
        if(isset($formattedData['commaSeparated']['shift_id']) && $formattedData['commaSeparated']['shift_id']!=''){
            $deliveredStatusArray=$this->DataQueryFormatter_model->getStopStatusDelviered($formattedData['commaSeparated']['shift_id']);
            $genericStatusArray=$this->DataQueryFormatter_model->getStopStatusGeneric($formattedData['commaSeparated']['shift_id']);
        }
        $getRecordListing=array();
        if(isset($formattedData['orders'])){
            $getRecordListing=$formattedData['orders'];
            krsort($getRecordListing);
        }
        $recordListing    = array();
        $content          = '[';
        $i                = 0;
        $srNumber = $start;
        if (!empty($getRecordListing)){
            $actionContent = '';
            $cntr=1;
            foreach($getRecordListing as $res) {
                $cust_reference_num = $lr_num = $delconsignee_date = $delivery_status = $container_num = $store_code = $load_plan_connote ='';
                    $referenceData='';
                    if (isset($res['reference_value'])) {
                        $referenceData = $res['reference_value'];
                    }
                if ($referenceData != '') {
                   $arrayData = $this->DataArrayFormatter_model->formatReferenceParameters($referenceData);
                    if (isset($arrayData['ORD'])) {
                        $lr_num = $arrayData['ORD'];
                    }
                    if (isset($arrayData['DQ'])) {
                        $cust_reference_num = $arrayData['DQ'];
                    }
                    if (isset($arrayData['AWB'])) {
                        $container_num = $arrayData['AWB'];
                    }
                }
                if(isset($res['cargo_content'])){
                    $tempContentArray = array();
                    $tempContentArray = explode('?????', $res['cargo_content']);
                    $tempContentArray = array_unique($tempContentArray);
                    $res['cargo_content'] = implode(',', $tempContentArray);
                }else{
                    $res['cargo_content']='';
                }
                $final_cargo_content = $res['cargo_content'];
                $this->load->helper('local_timezone_helper');
                $date = '0000-00-00 00:00:00';
                if(isset($res['estimated_pickup_time'])){
                    $estimatedPickupTime = dateConvertByTimeZone($res['estimated_pickup_time'],'UTC',$curtz);
                    if($estimatedPickupTime!=''){
                        $createdon = $estimatedPickupTime;
                    }else{
                        $createdon = '';
                    }
                }else{
                    $createdon = '';
                }
                if(isset($res['delivery_datetime'])){
                    $estimatedDeliveryTime = dateConvertByTimeZone($res['delivery_datetime'],'UTC',$curtz);
                    if($estimatedDeliveryTime!=''){
                        $estimate_d_date = $estimatedDeliveryTime;
                    }else{
                        $estimate_d_date='';
                    }
                }else{
                    $estimate_d_date='';
                }
                /* Time zone conversions*/
                if(isset($res['pickup_datetime'])){
                    $res['pickup_datetime']=dateConvertByTimeZone($res['pickup_datetime'],'UTC',$curtz);
                }
                if(isset($res['drop_endtime'])){
                    $res['drop_endtime']=dateConvertByTimeZone($res['drop_endtime'],'UTC',$curtz);
                }
                if(isset($res['delivery_datetime'])){
                    $res['delivery_datetime']=dateConvertByTimeZone($res['delivery_datetime'],'UTC',$curtz);
                }
                if ($createdon != '' || $estimate_d_date != '') {
                    if (($createdon != $date) && ($createdon != null)) {
                        $pickup_date = date("d M Y", strtotime($createdon));
                    } else {
                        $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                    }
                    if (($estimate_d_date != $date) && ($estimate_d_date != null)) {
                        $estimate_de_date = date("d M Y", strtotime($estimate_d_date));
                    } else {
                        $estimate_de_date = date("d M Y", strtotime($res['drop_endtime']));
                    }
                } else {
                    $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                    $estimate_de_date = date("d M Y", strtotime($res['drop_endtime']));
                }
                $last_status_name = $last_loc = $delivery_date = "";
                $delivery_status = "Not Delivered";
                $manifestdated = "";
                $reqStatusData=array(
                    'status_code'=>'','stop_type'=>'','status_id'=>'','createdon'=>'','loc_name'=>'','latitude'=>'','longitude'=>''
                );
                $reqStatusData['reason'] = "";
                if(isset($res['shift_id']) && $res['shift_id']!='' &&  $res['shift_id']!=0){
                    $shiftIndex=$res['shift_id'];
                    if(isset($deliveredStatusArray[$shiftIndex])){
                        if($deliveredStatusArray[$shiftIndex]['delivered_status_status_code']=='3000'){
                            $last_status_name=$deliveredStatusArray[$shiftIndex]['delivered_status_status_name'];
                            $reqStatusData['status_code']=$deliveredStatusArray[$shiftIndex]['delivered_status_status_code'];
                            $reqStatusData['stop_type']=$deliveredStatusArray[$shiftIndex]['delivered_status_stop_type'];
                            $reqStatusData['status_id']=$deliveredStatusArray[$shiftIndex]['delivered_status_id'];
                            $reqStatusData['createdon']=$deliveredStatusArray[$shiftIndex]['delivered_status_createdon'];
                            $reqStatusData['loc_name']=$deliveredStatusArray[$shiftIndex]['delivered_status_loc_name'];
                            $reqStatusData['latitude']=$deliveredStatusArray[$shiftIndex]['delivered_status_latitude'];
                            $reqStatusData['longitude']=$deliveredStatusArray[$shiftIndex]['delivered_status_longitude'];
                        }
                    }else{
                        if(isset($genericStatusArray[$shiftIndex])){
                            $last_status_name=$genericStatusArray[$shiftIndex]['generic_status_status_name'];
                            $reqStatusData['status_code']=$genericStatusArray[$shiftIndex]['generic_status_status_code'];
                            $reqStatusData['stop_type']=$genericStatusArray[$shiftIndex]['generic_status_stop_type'];
                            $reqStatusData['status_id']=$genericStatusArray[$shiftIndex]['generic_status_id'];
                            $reqStatusData['createdon']=$genericStatusArray[$shiftIndex]['generic_status_createdon'];
                            $reqStatusData['loc_name']=$genericStatusArray[$shiftIndex]['generic_status_loc_name'];
                            $reqStatusData['latitude']=$genericStatusArray[$shiftIndex]['generic_status_latitude'];
                            $reqStatusData['longitude']=$genericStatusArray[$shiftIndex]['generic_status_longitude'];
                            $reqStatusData['reason']=$genericStatusArray[$shiftIndex]['generic_status_reason'];
                        }
                    }
                    if ($reqStatusData['status_id'] == 1) {
                        if ($reqStatusData['stop_type'] == "P") {
                            $last_status_name = "Pickedup";
                        } else {
                            $last_status_name = "Delivered";
                        }
                    }
                    $lastscandate = $reqStatusData['createdon'];
                    $sts_reason = $reqStatusData['reason'];
                    if ($reqStatusData['status_code'] == '3000' && $reqStatusData['stop_type'] == 'D') {
                        $date = '0000-00-00 00:00:00';
                        $d_time = getEDAofNZShipmentbyord($res['id']);
                        $d_date = $d_time['time'];
                        $delivery_status = "Delivered";
                        if (isset($d_date) && $d_date != "") {
                            if (($d_date != $date) || (strtotime($d_date) > 0)) {
                                $delivery_date = date("d M Y", strtotime($d_date));
                            } else {
                                $delivery_date = "";
                            }
                        }
                    }
                    if ($reqStatusData['loc_name'] != null) {
                        $last_loc = $reqStatusData['loc_name'];
                    } else {
                        $lat = $reqStatusData['latitude'];
                        $lng = $reqStatusData['longitude'];
                        if($lat!='' && $lng!=''){
                            $last_loc = getLocationName($lat, $lng);
                        }
                    }
                }
                $carrierservice = $mdate=$scanned_date=$accepted="";
                $pickupdate=$pdate=$gateout=$gateoutdate=$transit=$transitdate=$delivered_time=$deliverydate='';
                if ($reqStatusData['status_code'] == '0470') {
                    $manifestdated = $reqStatusData['createdon'];
                    if($manifestdated != "" && $manifestdated != "0000-00-00 00:00:00" && $manifestdated != "0"){
                        $mdate = getdatetimebytimezone( $curtz, $manifestdated, DFLT_TZ );
                        $manifestdated = date('Y-m-d h:i A',strtotime($mdate['datetime']));
                    }
                }
                if($reqStatusData['status_code']=='0500'){
                    $pickupdate = $reqStatusData['createdon'];
                    if($pickupdate != "" && $pickupdate != "0000-00-00 00:00:00" && $pickupdate != "0"){
                        $pdate      = getdatetimebytimezone( $curtz, $pickupdate, DFLT_TZ );
                        $pickupdate = date('Y-m-d h:i A',strtotime($pdate['datetime']));
                    }
                }
                $pod_available = $imgpath = $receiver_name="";
                if(!isset($res['pod_available'])){
                    $res['pod_available']='';
                }
                if(!isset($res['receiver_name'])){
                    $res['receiver_name']='';
                }
                if(!isset($res['imgpath'])){
                    $res['imgpath']='';
                }
                $pod_available = $res['pod_available'];
                $receiver_name = $res['receiver_name'];
                $imgpath       = $res['imgpath'];
                if($pod_available != "" && $pod_available != "0000-00-00 00:00:00" && $pod_available != "0"){
                    $poddate = getdatetimebytimezone( $curtz, $pod_available, DFLT_TZ );
                    $pod_available = date('Y-m-d h:i A',strtotime($poddate['datetime']));
                }
                $allowed =  array('pdf');
                $ext = pathinfo($res['imgpath'], PATHINFO_EXTENSION);
                $imglink = checkimageintmsorknlmv($res['imgpath'], false);
                $podAction=$podDocs='';
                if($imglink != ""){
                    if(in_array($ext,$allowed)){
                        $podAction.= '<a target="_blank" href="'.$imglink.'">';
                        $podAction.=  '<img src="'.base_url("assets/img/docstore.png").' class="img-responsive" style="width: 22%;" type="application/pdf"></a>';
                    }else{
                        $podAction.= '<a target="_blank" href="'.$imglink.'"><img src="'.$imglink.'" class="img-responsive" style="width: 25%;"></a>';
                    }
                }
                $quotedOrderId=$res['order_id'];
                $quotedOrderId="'$quotedOrderId'";
                $quotedId=$res['id'];
                $podDocs.='<a href="#"  onclick="return orddocsdetails('.$quotedId.','.$quotedOrderId.')"
                            class="buttonCardIcon" data-action="open"
                            data-popup="open-data" data-side="right" data-toggle="tooltip" title="'.$this->lang->line("other_docs").'"><span class="icon tru-icon-tender-list"></span></span></a>';
                $empty  = "";
                $ststype = "Cancelled";
                if($last_status_name == "Delivered" || $last_status_name == "Pickedup"){
                    $ststype = "Delivered";
                }else{
                    $last_status_name = "Undelivered";
                }
                $pkgtype = "Prepaid";
                if($res['created_source'] == "16"){
                    $pkgtype = "Pickup";
                }
                $validaddr = "Valid Address";
                $consignvalid = "Yes";
                $clientreason = "";
                $content .= '[';
                    $j=0;
                    $recordListing[$i][0]  = '';
                    $recordListing[$i][++$j]  = $cntr;
                    $recordListing[$i][++$j]  = $container_num;
                    $recordListing[$i][++$j]=$res['customer_name']."(".$res['customer_code'].")";
                    $recordListing[$i][++$j]=$res['customer_loc'];
                    $recordListing[$i][++$j]=date("Y-m",strtotime($res['createdon']));
                    $recordListing[$i][++$j]  = $lr_num!='' ? $lr_num : 'NA';
                    $recordListing[$i][++$j]=$res['createdon'];
                    $recordListing[$i][++$j]=$manifestdated;
                    $recordListing[$i][++$j]=$pickupdate;
                    $recordListing[$i][++$j]=$res['pickup_datetime'];
                    $recordListing[$i][++$j]=$last_status_name;
                    $recordListing[$i][++$j]=$ststype;
                    $recordListing[$i][++$j]=$res['delivery_pincode'];
                    $recordListing[$i][++$j]=$res['delivery_city'];
                    $recordListing[$i][++$j]=$res['delivery_city'];
                    $recordListing[$i][++$j]='N';
                    $recordListing[$i][++$j]='S1';
                    $recordListing[$i][++$j]=$pkgtype;
                    $recordListing[$i][++$j]=$res['delivery_datetime'];
                    $recordListing[$i][++$j]=$res['quantity'];
                    $recordListing[$i][++$j]=$res['ndrdate'];
                    $recordListing[$i][++$j]=$res['quantity'];
                    $recordListing[$i][++$j]=$pickupdate;
                    $recordListing[$i][++$j]=$res['ndrdate'];
                    $recordListing[$i][++$j]=$res['ndrupddate'];
                    $recordListing[$i][++$j]=$pickupdate;
                    $recordListing[$i][++$j]=$pickupdate;
                    $recordListing[$i][++$j]="";
                    $recordListing[$i][++$j]=$validaddr;
                    $recordListing[$i][++$j]=$consignvalid;
                    $recordListing[$i][++$j]=$res['ndrdate'];
                    $recordListing[$i][++$j]='';
                    $recordListing[$i][++$j]=$lastscandate;
                    $recordListing[$i][++$j]=$sts_reason;
                    $recordListing[$i][++$j]=$clientreason;
                $i ++;
                $cntr++;
            }
            $content    .= ']';
            $final_data = json_encode($recordListing);
        } else {
            $final_data = '[]';
        }
        echo '{"draw":' . $draw . ',"recordsTotal":' . $totalRecords . ',"recordsFiltered":' . $recordsFiltered . ',"data":' . $final_data . '}';
    }
}
