<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use App\Generators\RandomString;

class Newroadlogship extends CI_Controller {

   public function __construct()
   {
      parent::__construct();
      $this->load->model('common');
   }

   public function superadmin(){
		$data = array();
		$cdate = date('Y-m-d');
		$pdate= $ddate = array();
		$btype = $this->session->userdata("business_type");
		$whr = $whr1 = "";
		if($btype == "Super Admin"){
			$userids = getsuperadminusers($this->session->userdata("user_id"));
			$whr .= " AND e.user_id IN(".implode(",", $userids).") ";
			$whr1 .= " AND o.user_id IN(".implode(",", $userids).") ";
		}else if($btype == "Truck_Owner"){
			$userid = $this->session->userdata("user_id");
			$whr .= " AND e.user_id=$userid ";
			$whr1 .= " AND o.user_id=$userid ";
		}else{
			$userid = $this->session->userdata("user_id");
			$cid = $this->session->userdata("cust_id");
			$whr .= " AND e.customer_id=$cid ";
			$whr1 .= " AND o.customer_id=$cid ";
		}
		/*active bookings*/
		$mainqry = "SELECT o.id FROM tb_trips t,tb_employee e,tb_orders o WHERE t.shift_id=e.shift_id AND e.order_id=o.order_id AND t.status=1 $whr GROUP BY o.order_id ORDER BY t.id DESC";
		$actbk = $this->db->query($mainqry);
		$data['activebooks'] = $actbk->num_rows();
		/*pending bookings*/
		$mainqry1 = $this->db->query("SELECT o.id FROM tb_trips t,tb_employee e,tb_orders o WHERE t.shift_id=e.shift_id AND e.order_id=o.order_id AND t.status=1 $whr GROUP BY o.order_id ORDER BY t.id DESC");
        if($mainqry1->num_rows()>0){
        	foreach ($mainqry1->result() as $po) {
        		$pos[] = $po->id;
        	}
        	$mainqry = "SELECT o.id FROM tb_orders o WHERE o.id NOT IN(".implode(',', $pos).") AND o.status IN(1,2) $whr1";
        }else{
        	$mainqry = "SELECT o.id FROM tb_orders o WHERE o.status in(1,2) $whr1";
        }
        $pendbk = $this->db->query($mainqry);
		$data['pendbooks'] = $pendbk->num_rows();
		/*completed bookings*/
        $mainqry = "SELECT o.id FROM tb_trips t,tb_employee e,tb_orders o WHERE t.shift_id=e.shift_id AND e.order_id=o.order_id AND t.status=0 $whr GROUP BY o.order_id ORDER BY t.id DESC";
        $donebk = $this->db->query($mainqry);
		$data['donebooks'] = $donebk->num_rows();
		/*alerts*/
		$mainqry = "SELECT a.id FROM tb_trips t,tb_trip_alerts a,tb_employee e,tb_orders o WHERE t.id=a.trip_id AND t.shift_id=e.shift_id AND e.order_id=o.order_id $whr GROUP BY a.id";
		$alertbk = $this->db->query($mainqry);
		$data['alertbooks'] = $alertbk->num_rows();
		$this->settemplate->dashboard("shift/superadmin", $data);
	}

    public function index(){
		$postData = file_get_contents('php://input');
		$xml = new SimpleXMLElement($postData);
		$userid = 1;
		$response = array();
		$statusmsg = "";
		if ($xml === false) {
		 	$statusmsg = "Invalid request,Please try again!";
		}else{
			$shipdata = $this->read_shipmentdata($xml);
			$logdate = date('Y-m-d H:i:s');
			if(!empty($shipdata)){
			   exit;
			   $response = $this->insertShipmentData($shipdata,$logdate);
			}
			if(!empty($response)){
				$statusmsg = "Success";
			}else{
				$statusmsg = "Failed for unformatted request,Please try again!";
			}
    	}
    	echo $statusmsg;
    }

   	public function read_shipmentdata($xml){
		$res = array();
		$xml->registerXPathNamespace('ns3', 'http://knie4.int.kn/com/lhdr/0200');
		$data = $xml->xpath('ns3:MessageHeader');
		$physicalreceiver = (string)($data[0]->xpath('ReceiverDetails')[0]->PhysicalReceiver);
		$logicalreceiver = (string)($data[0]->xpath('ReceiverDetails')[0]->LogicalReceiver);
		$physicalsender = (string)($data[0]->xpath('PhysicalSender')[0]);
		$logicalsender = (string)($data[0]->xpath('LogicalSender')[0]);
		$lreceiver = $preceiver = $psender = $lsender = $triptype = "";
		$loadcapacity = 0;
		$driver = $carrier = array();
		$preceiver = $physicalreceiver;
		$lreceiver = $logicalreceiver;
		$psender = $physicalsender;
		$lsender = $logicalsender;
		$sendapp = (string)($data[0]->xpath('SendingApplication')[0]);
		$msgtype = (string)($data[0]->xpath('MessageType')[0]);
		$version = (string)($data[0]->xpath('VersionNumber')[0]);
		$createdtime = (string)($data[0]->xpath('CreationDateTime')[0]);
		if($createdtime != ""){
		 $createdtime = date("Y-m-d H:i:s",strtotime($createdtime));
		}else{
		 $createdtime = date("Y-m-d H:i:s");
		}
		$res['header'] = array("preceiver"=>$preceiver,"lreceiver"=>$lreceiver,"psender"=>$psender,"lsender"=>$lsender,"sendapp"=>$sendapp,"msgtype"=>$msgtype,"version"=>$version,"createdtime"=>$createdtime);
		/* truck and trailer info */
		$arr = array();
		$xml->registerXPathNamespace('ns4', 'http://knie4.int.kn/com/ltru/0200');
		$titledata = $xml->xpath('//ns4:TruckAndTrailer');
		if(isset($titledata)){
			if(isset($titledata[0])){
			$arr['ordernum'] = (string)($titledata[0]->xpath('VoyageNumber')[0]);
			$arr['shipment_id'] = (string)($titledata[0]->xpath('TourNumber')[0]);
			$arr['origin'] = (string)($titledata[0]->xpath('Origin')[0]->Location[0]);
			$arr['originloc2'] = (string)($titledata[0]->xpath('Origin')[0]->Location[1]);
			$arr['origindate'] = (string)($titledata[0]->xpath('Origin')[0]->Date);
			$arr['noofshipments'] = (string)($titledata[0]->xpath('NumberOfShipments')[0]);
			$address = $triptype = $loadcapacity = "";
			if(null !== $titledata[0]->xpath('Address')){
				if(!empty($titledata[0]->xpath('Address'))){
				$address = (string)($titledata[0]->xpath('Address')[0]->attributes('ns2', TRUE)->AddressType);
				if($address == "CA"){
					$carrier['name'] = (string)($titledata[0]->xpath('Address')[0]->Name);
					$carrier['street'] = (string)($titledata[0]->xpath('Address')[0]->Street[0]);
					$carrier['street1'] = (string)($titledata[0]->xpath('Address')[0]->Street[1]);
					$carrier['city'] = (string)($titledata[0]->xpath('Address')[0]->City);
					$carrier['country'] = (string)($titledata[0]->xpath('Address')[0]->CountryCode);
					$carrier['zip'] = (string)($titledata[0]->xpath('Address')[0]->ZipCode);
					$carrier['custid'] = (string)($titledata[0]->xpath('Address')[0]->CustomerIdentifier);
					$carrier['partyid'] = (string)($titledata[0]->xpath('Address')[0]->PartyIdentifier);
					if(null !== (string)$titledata[0]->xpath('Address')[0]->ContactDetails){
						$driver['lastname'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->LastName);
						$driver['firstname'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->FirstName);
						$driver['contacttype'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->ContactType);
						$driver['commtype'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->Communication['ns2:CommunicationType']);
						/*(string)($titledata[0]->xpath('Address')[0]->ContactDetails->Communication->attributes('ns2',TRUE)->CommunicationType);*/
						$driver['commtypename'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->Communication);
						if(null !== $titledata[0]->xpath('DriverID')){
							if(!empty($titledata[0]->xpath('DriverID'))){
								$driver['driverid'] = (string)($titledata[0]->xpath('DriverID')[0]);
							}
						}
					}
					}
				} }
				if(null !== $titledata[0]->xpath('TripType')){
					if(!empty($titledata[0]->xpath('TripType'))){
					$triptype = (string)($titledata[0]->xpath('TripType')[0]);
				}
				}
				if(null !== $titledata[0]->xpath('LoadingCapacity')){
					if(!empty($titledata[0]->xpath('LoadingCapacity'))){
					$loadcapacity = (string)($titledata[0]->xpath('LoadingCapacity')[0]);
					}
				}
			}
		}
		$res['carrier'] = $carrier;
		$res['driver'] = $driver;
		$arr['triptype'] = $triptype;
		$arr['loadcapacity'] = $loadcapacity;
		$res['truck'] = $arr;
		$res['shipdata'] = array();
		$xml->registerXPathNamespace('ns20', 'http://knie4.int.kn/msg/roadshipment/0100');
		$mdata = $xml->xpath('//ns20:RoadShipment');
		$shinfo = $mdata[0]->xpath('Message')[0]->Shipment;
		foreach($shinfo as $key=>$cships){
			$res['shipdata'][] = $this->generateshipmentdata($cships,$key);
		}
		return $res;
    }
   	function generateshipmentdata($xml,$key){
   		$xml->registerXPathNamespace('ns5', 'http://knie4.int.kn/com/lmlv/0200');
		$titledata = $xml->xpath('ns5:MessageLevel');
		$arr['orderid'] = (string)($titledata[0]->xpath('TrackingNumber')[0]);
		$arr['sendercmpcode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->CompanyCode);
		$arr['senderbranchcode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->BranchCode);
		$arr['sendertransmode'] = 1;
		if(null !== (string)($titledata[0]->xpath('SenderInformation')[0]->ModeOfTransport)){
	        $arr['sendertransmode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->ModeOfTransport);
	    }
        $arr['senderflag'] = $arr['refcode'] = $arr['refvalue'] = "";
        if(null !== (string)($titledata[0]->xpath('SenderInformation')[0]->ExportImportFlag)){
	        $arr['senderflag'] = (string)($titledata[0]->xpath('SenderInformation')[0]->ExportImportFlag);
	    }
	    if(null !== $titledata[0]->xpath('MessageReferences')){
	    	if(!empty($titledata[0]->xpath('MessageReferences'))){
		    	$arr['refcode'] = (string)($titledata[0]->xpath('MessageReferences')[0]->Code);
	        	$arr['refvalue'] = (string)($titledata[0]->xpath('MessageReferences')[0]->Value);
	        }
	    }
        $infodata = $xml->ShipmentInformation;
        $infodata->registerXPathNamespace('ns7', 'http://knie4.int.kn/com/lshpd/0200');
		$details = $infodata->xpath('ns7:ShipmentDetails');
		$arr['packages'] = 1;
		$arr['measurements'] = array();
		$arr['dangerousflag'] = $arr['totaldangerousflag'] = $arr['source'] = $arr['sourcedate'] = $arr['destination'] = $arr['destinationdate'] = $arr['slocationcountry'] = $arr['dlocationcountry'] = "";
		if(!empty($details)){
			if(null !== $details[0]->xpath('TotalPackages')){
		    	if(!empty($details[0]->xpath('TotalPackages'))){
					$arr['packages'] = (string)($details[0]->xpath('TotalPackages')[0]);
				}
			}
			if(null !== $details[0]->xpath('Measurements')){
		    	if(!empty($details[0]->xpath('Measurements'))){
					foreach($details[0]->xpath('Measurements') as $mm){
						$arr['measurements'][] = array('mtype'=>(string)$mm->attributes('ns2', TRUE)->MeasurementType,'value'=>(string)$mm->Value,'uom'=>(string)$mm->UnitOfMeasurementCode);
					}
				}
			}
			if(null !== $details[0]->xpath('DangerousGoodsFlag')){
		    	if(!empty($details[0]->xpath('DangerousGoodsFlag'))){
				$arr['dangerousflag'] = (string)($details[0]->xpath('DangerousGoodsFlag')[0]);
			}}
			if(null !== $details[0]->xpath('TotalPackagesOfDangerousGoods')){
			    	if(!empty($details[0]->xpath('TotalPackagesOfDangerousGoods'))){
				$arr['totaldangerousflag'] = (string)($details[0]->xpath('TotalPackagesOfDangerousGoods')[0]);
			}}
			if(null !== $details[0]->xpath('Origin')){
			    	if(!empty($details[0]->xpath('Origin'))){
				$arr['source'] = (string)($details[0]->xpath('Origin')[0]->OriginLocation);
				$arr['sourcedate'] = (string)($details[0]->xpath('Origin')[0]->Date);
			}}
			if(null !== $details[0]->xpath('Destination')){
			    	if(!empty($details[0]->xpath('Destination'))){
				$arr['destination'] = (string)($details[0]->xpath('Destination')[0]->DestinationLocation);
				$arr['destinationdate'] = (string)($details[0]->xpath('Destination')[0]->Date);
			}}
			if(null !== $details[0]->xpath('Location')){
			    	if(!empty($details[0]->xpath('Location'))){
				$arr['slocationcountry'] = (string)($details[0]->xpath('Location')[0]);
				$arr['dlocationcountry'] = (string)($details[0]->xpath('Location')[1]);
			}}
		}
		$shipper = $consignee = $pf = $arr['references'] = array();
		$infodata->registerXPathNamespace('ns8', 'http://knie4.int.kn/com/ladr/0200');
		foreach($infodata->xpath('ns8:NameAddress') as $addr){
			if($addr->attributes('ns2', TRUE)->AddressType == "SH"){
				$shipper = array('name'=>(string)($addr->xpath('Name')[0]),'street'=>(string)($addr->xpath('Street')[0]),'city'=>(string)($addr->xpath('City')[0]),'country'=>(string)($addr->xpath('CountryCode')[0]),'zip'=>(string)($addr->xpath('ZipCode')[0]),'custid'=>(string)($addr->xpath('CustomerIdentifier')[0]),'partyid'=>(string)($addr->xpath('PartyIdentifier')[0]));
				if(null !== $addr->xpath('References')){
					if(!empty($addr->xpath('References'))){
						foreach($addr->xpath('References') as $cref){
							$arr['references'][] = array('code'=>(string)$cref->Code,'value'=>(string)$cref->Value);
						}
					}
				}
			}
			if($addr->attributes('ns2', TRUE)->AddressType == "CN"){
				$consignee = array('name'=>(string)($addr->xpath('Name')[0]),'street'=>(string)($addr->xpath('Street')[0]),'city'=>(string)($addr->xpath('City')[0]),'country'=>(string)($addr->xpath('CountryCode')[0]),'zip'=>(string)($addr->xpath('ZipCode')[0]),'custid'=>(string)($addr->xpath('CustomerIdentifier')[0]),'partyid'=>(string)($addr->xpath('PartyIdentifier')[0]));
			}
			if($addr->attributes('ns2', TRUE)->AddressType == "PF"){
				$pf = array('name'=>(string)($addr->xpath('Name')[0]),'street'=>(string)($addr->xpath('Street')[0]),'city'=>(string)($addr->xpath('City')[0]),'country'=>(string)($addr->xpath('CountryCode')[0]),'zip'=>(string)($addr->xpath('ZipCode')[0]),'custid'=>(string)($addr->xpath('CustomerIdentifier')[0]),'partyid'=>(string)($addr->xpath('PartyIdentifier')[0]));
			}
		}
		$arr['items_count'] = $arr['pkgs_count'] = 1;
		$arr['pkgs_uom'] = 'PCS';
		$arr['gross_weight'] = $arr['volume'] = 1;
		$arr['weight_uom'] = 'KGM';
		$arr['volume_uom'] = 'MTQ';
		$arr['cargo_content'] = 'Boxes';
		if(null !== $infodata[0]->xpath('CargoDescription')){
			if(!empty($infodata[0]->xpath('CargoDescription'))){
				$cargo = $infodata[0]->xpath('CargoDescription')[0];
				$cargo->registerXPathNamespace('ns9', 'http://knie4.int.kn/com/lcgod/0200');
				$cargodetails = $cargo->xpath('ns9:CargoDescriptionDetails');
				$arr['items_count'] = (string)($cargodetails[0]->xpath('CargoItem')[0]);
				$arr['pkgs_count'] = (string)($cargodetails[0]->xpath('NumberOfPackages')[0]->Value);
				$arr['pkgs_uom'] = (string)($cargodetails[0]->xpath('NumberOfPackages')[0]->QuantityType);
				$arr['gross_weight'] = (string)($cargodetails[0]->xpath('GrossWeight')[0]->Value);
				$arr['weight_uom'] = (string)($cargodetails[0]->xpath('GrossWeight')[0]->UnitOfMeasurementCode);
				$arr['volume'] = (string)($cargodetails[0]->xpath('Volume')[0]->Value);
				$arr['volume_uom'] = (string)($cargodetails[0]->xpath('Volume')[0]->UnitOfMeasurementCode);
				$arr['cargo_content'] = (string)($cargodetails[0]->xpath('CargoContent')[0]);
			}
		}
		$arr['shipper'] = $shipper;
		$arr['consignee'] = $consignee;
		$arr['pf'] = $pf;
		$infodata1 = $xml->ShipmentRoad;
        $infodata1->registerXPathNamespace('ns13', 'http://knie4.int.kn/com/lrdtl/0200');
		$roaddetail = $infodata1->xpath('ns13:RoadDetails');
		$arr['serviceproduct'] = $arr['servicetype'] = $arr['freight_term'] = $arr['freight_termname'] = "";
		if(null !== $roaddetail[0]->xpath('Product')){
			if(!empty($roaddetail[0]->xpath('Product'))){
			$arr['serviceproduct'] = (string)($roaddetail[0]->xpath('Product')[0]);
			} }
		if(null !== $roaddetail[0]->xpath('ServiceType')){
				if(!empty($roaddetail[0]->xpath('ServiceType'))){
	        $arr['servicetype'] = (string)($roaddetail[0]->xpath('ServiceType')[0]);
	    }}
	    if(null !== $roaddetail[0]->xpath('FreightName')){
				if(!empty($roaddetail[0]->xpath('FreightName'))){
	        $arr['freight_term'] = (string)($roaddetail[0]->xpath('FreightName')[0]->Term);
	    }}
	    if(null !== $roaddetail[0]->xpath('FreightName')){
				if(!empty($roaddetail[0]->xpath('FreightName'))){
	        $arr['freight_termname'] = (string)($roaddetail[0]->xpath('FreightName')[0]->Name);
	    }}
        $pickdrop = array();
        $p = $d = 0;
        $waypoints = $infodata1->TruckingWayPoint;
		foreach($waypoints as $sd){
			if($sd->attributes('ns20', TRUE)->WayPointType == "PUP"){
				$sd->registerXPathNamespace('ns8', 'http://knie4.int.kn/com/ladr/0200');
				$point = $sd->xpath('ns8:NameAddress');
				$arr1 = array();
				$arr1['pickup_company'] = (string)($point[0]->xpath('Name')[0]);
				$arr1['pickup_address'] = (string)($point[0]->xpath('Street')[0]);
				$street2 = isset($point[0]->xpath('Street')[1]) ? $point[0]->xpath('Street')[1] : "";
				$arr1['pickup_address1'] = (string)($street2);
				$arr1['pickup_city'] = (string)($point[0]->xpath('City')[0]);
				$arr1['pickup_countrycode'] = (string)($point[0]->xpath('CountryCode')[0]);
				$arr1['pickup_postal'] = (string)($point[0]->xpath('ZipCode')[0]);
				$arr1['pickup_custid'] = (string)($point[0]->xpath('CustomerIdentifier')[0]);
				$arr1['pickup_partyid'] = (string)($point[0]->xpath('PartyIdentifier')[0]);
				$arr1['pickup_datefrom'] = (string)$sd->DateRange->DateFrom;
				$arr1['pickup_datefromtime'] = (string)$sd->DateRange->TimeFrom;
				$arr1['pickup_dateto'] = (string)$sd->DateRange->DateTo;
				$arr1['pickup_datetotime'] = (string)$sd->DateRange->TimeTo;
				$arr1['sequence'] = (string)$sd->Sequence;
				$arr1['stoptype'] = 'P';
				$arr1['stop_type'] = (string)($point[0]->attributes('ns2', TRUE)->AddressType);
				$p++;
				$pickdrop[] = $arr1;
			}
			if($sd->attributes('ns20', TRUE)->WayPointType == "DEL"){
				$sd->registerXPathNamespace('ns8', 'http://knie4.int.kn/com/ladr/0200');
				$point = $sd->xpath('ns8:NameAddress');
				$arr2 = array();
				$arr2['drop_company'] = (string)($point[0]->xpath('Name')[0]);
				$arr2['drop_address'] = (string)($point[0]->xpath('Street')[0]);
				$street2 = isset($point[0]->xpath('Street')[1]) ? $point[0]->xpath('Street')[1] : "";
				$arr2['drop_address1'] = (string)($street2);
				$arr2['drop_city'] = (string)($point[0]->xpath('City')[0]);
				$arr2['drop_countrycode'] = (string)($point[0]->xpath('CountryCode')[0]);
				$arr2['drop_postal'] = (string)($point[0]->xpath('ZipCode')[0]);
				$arr2['drop_custid'] = (string)($point[0]->xpath('CustomerIdentifier')[0]);
				$arr2['drop_partyid'] = (string)($point[0]->xpath('PartyIdentifier')[0]);
				$arr2['drop_datefrom'] = (string)$sd->DateRange->DateFrom;
				$arr2['drop_datefromtime'] = (string)$sd->DateRange->TimeFrom;
				$arr2['drop_dateto'] = (string)$sd->DateRange->DateTo;
				$arr2['drop_datetotime'] = (string)$sd->DateRange->TimeTo;
				$arr2['sequence'] = (string)$sd->Sequence;
				$arr2['stoptype'] = 'D';
				$arr2['stop_type'] = (string)($point[0]->attributes('ns2', TRUE)->AddressType);
				$d++;
				$pickdrop[] = $arr2;
			}
		}
		$arr['pickdrops'] = $pickdrop;
		$arr['pickcount'] = $p;
		$arr['dropcount'] = $d;
		$infodata1->registerXPathNamespace('ns23', 'http://knie4.int.kn/com/lriroa/0200');
		$bdetail = $infodata1->xpath('ns23:ReportingInformationRailroad');
        $arr['typeofbusiness'] = (string)($bdetail[0]->xpath('TypeOfBusiness')[0]);
		return $arr;
   	}

   	public function insertShipmentData($data,$logdate){
      $curdt = date('Y-m-d H:i:s');
      $responseord = array();
      $transmode = "TL";
      $dedicateveh = 1;
      $user_id = 1;
      foreach($data['shipdata'] as $shipdata){
      $ttansmode = $shipdata['servicetype'];
      if($ttansmode != "Full Truck Load"){
      	$transmode = "LTL";
      	$dedicateveh = 0;
      }
      $firsttwochars = substr($data['header']['lsender'], 0,2);
      $company_code =  $shipdata['sendercmpcode'];
       $branch_code =  $shipdata['senderbranchcode'];
      $chk = $this->db->query("SELECT id,country_code,company_code,branch_code FROM tb_users WHERE country_code LIKE '%".$firsttwochars."%' AND company_code='".$company_code."' AND branch_code='".$branch_code."' LIMIT 1");
      if($chk->num_rows()>0){
      	$user_id = $chk->row()->id;
      }else{
      	$adminrand = time();
      	$adminpwd = password_hash($adminrand, PASSWORD_DEFAULT);
      	$udata = array('country_code'=>$firsttwochars, 'name'=>$firsttwochars."_Admin", 'company_indv_name'=>$company_code, 'business_type'=>'Truck_Owner', 'mobile_no'=>$adminrand, 'password'=>$adminpwd, 'emailid'=>'external.ram.k@kuehne-nagel.com', 'domain_name'=>$branch_code, 'location_id'=>1646, 'createdby'=>1, 'status'=>'Active', 'createdon'=>$curdt, 'updatedon'=>$curdt, 'company_code'=>$company_code, 'branch_code'=>$branch_code);
      	$user_id = $this->common->insertTableData('tb_users',$udata);
      }
		if(!empty($data['carrier'])){
		  if(!isset($data['carrier']['custid'])){
		  	$getcar = $this->db->select("name,mobile,location,address,pincode,country,code,custid,partyid")->get_where("tb_vendors",array("user_id"=>$user_id,"company_code"=>$shipdata['sendercmpcode'],"branch_code"=>$shipdata['senderbranchcode'],"status"=>1),1,0);
		  	if($getcar->num_rows()>0){
		  		$cardata = $getcar->row();
		  		$data['carrier']=array('name'=>$cardata->name,'street'=>$cardata->address,'street1'=>'','city'=>$cardata->location,'country'=>$cardata->country,'zip'=>$cardata->pincode,'custid'=>$cardata->custid,'partyid'=>$cardata->partyid);
		  	}
		  }
		}
		$carrier = $this->checkcarrier($data['carrier'],$shipdata['sendercmpcode'],$shipdata['senderbranchcode'],$user_id);
		$carrier_id = $carrier['id'];
		if(isset($carrier['party_id'])){ $carrier_party_id = $carrier['party_id']; }
		if(!isset($data['truck']['shipment_id'])){
			$data['truck']['shipment_id'] = mt_rand();
		}
		if(!isset($data['truck']['ordernum'])){
			$data['truck']['ordernum'] = mt_rand();
		}
      $shipdatains = array('shipid'=>$data['truck']['shipment_id'], 'txnid'=>$data['truck']['ordernum'], 'trucktype'=>$ttansmode,'product'=>$shipdata['serviceproduct'], 'pickupcnt'=>$shipdata['pickcount'], 'dropcnt'=>$shipdata['dropcount'], 'unitspec'=>$shipdata['cargo_content'], 'insertusr'=>$shipdata['shipper']['custid'], 'carrier'=>$carrier_id, 'insertuserdate'=>$shipdata['sourcedate'], 'enddate'=>$shipdata['destinationdate'], 'insdate'=>$shipdata['sourcedate'], 'upddate'=>$shipdata['destinationdate'], 'reason'=>'SHIPMENT', 'purpose'=>'SEND INTEGRATION', 'ship_object'=>'SHIPMENT', 'logdate'=>$logdate, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt, 'transport_mode'=>$transmode, 'txncode'=>$shipdata['orderid'],'domainname'=>$data['header']['lsender'],'company_code'=>$shipdata['sendercmpcode'],'branch_code'=>$shipdata['senderbranchcode'],'freight_term'=>$shipdata['freight_term'],'freight_termname'=>$shipdata['freight_termname'],'logicalreceiver'=>$data['header']['lreceiver'],'physicalreceiver'=>$data['header']['preceiver'],'physicalsender'=>$data['header']['psender'],'logicalsender'=>$data['header']['lsender'],'modeoftransport'=>$shipdata['sendertransmode']);
      $sship_id = $this->common->insertTableData('tb_shipments',$shipdatains);
      $pickup_datetime = $pickup_endtime = $delivery_datetime = $drop_endtime = $pickup_company = "";
      $starttime = $endtime = "";
      if(isset($shipdata['pickdrops'])){
      	if(!empty($shipdata['pickdrops'])){
      foreach($shipdata['pickdrops'] as $res){
      	if($res['stoptype'] == "P"){
      		$starttime = $res['pickup_datefromtime'];
      		$pickup_datetime = $res['pickup_datefrom']." ".$res['pickup_datefromtime'];
      		$pickup_datetime = date('Y-m-d H:i:s',strtotime($pickup_datetime));
      		$pickup_endtime = $res['pickup_dateto']." ".$res['pickup_datetotime'];
      		$pickup_endtime = date('Y-m-d H:i:s',strtotime($pickup_endtime));
      		$pickup_company = $res['pickup_company'];
      		$pickup_address = $res['pickup_address'];
      		$pickup_city = $res['pickup_city'];
      		$pickup_countrycode = $res['pickup_countrycode'];
      		$pickup_postal = $res['pickup_postal'];
      		$pickup_address1 = $res['pickup_address1'];
      		$pickup_custid = $res['pickup_custid'];
      		$pickup_partyid = $res['pickup_partyid'];
      	}
      	if($res['stoptype'] == "D"){
      		$endtime = $res['drop_datefromtime'];
      		$delivery_datetime = $res['drop_datefrom']." ".$res['drop_datefromtime'];
      		$delivery_datetime = date('Y-m-d H:i:s',strtotime($delivery_datetime));
      		$drop_endtime = $res['drop_dateto']." ".$res['drop_datetotime'];
      		$drop_endtime = date('Y-m-d H:i:s',strtotime($drop_endtime));
      		$drop_company = $res['drop_company'];
      		$drop_address = $res['drop_address'];
      		$drop_city = $res['drop_city'];
      		$drop_countrycode = $res['drop_countrycode'];
      		$drop_postal = $res['drop_postal'];
      		$drop_address1 = $res['drop_address1'];
      		$drop_custid = $res['drop_custid'];
      		$drop_partyid = $res['drop_partyid'];
      	}
      }
      	$chkcusttype = "SH";
      	if(isset($shipdata['freight_term'])){
      		if($shipdata['freight_term'] == "30" || $shipdata['freight_term'] == "31"){
      			$chkcusttype = "CN";
      		} else if($shipdata['freight_term'] == "20"){
      			$chkcusttype = "PF";
      		} else if($shipdata['freight_term'] == "10"){
      			$chkcusttype = "SH";
      		}
      	}
      	$customer_id = 0;
		$consignee = $this->checkconsignee($shipdata['consignee'],$shipdata['sendercmpcode'],$shipdata['senderbranchcode'],$user_id,$chkcusttype);
		if($consignee['id'] > 0){
			$customer_id = $consignee['id'];
		}
		if(isset($consignee['party_id'])){ $consignee_id = $consignee['party_id']; }
		$shipper = $this->checkshipper($shipdata['shipper'],$shipdata['sendercmpcode'],$shipdata['senderbranchcode'],$user_id,$chkcusttype);
		if($shipper['id'] > 0){
			$customer_id = $shipper['id'];
		}
		if(isset($shipper['party_id'])){ $shipper_id = $shipper['party_id']; }
		if(isset($shipdata['pf'])){
			if(!empty($shipdata['pf'])){
				$customer = $this->checkcustomer($shipdata['pf'],$shipdata['sendercmpcode'],$shipdata['senderbranchcode'],$user_id,$chkcusttype);
				if($customer['id'] > 0){
					$customer_id = $customer['id'];
				}
				if(isset($customer['party_id'])){ $cust_id = $customer['party_id']; }
			}
		}
		if($customer_id == 0){
			$branchwisecust = $this->db->query("SELECT id FROM tb_customers WHERE user_id=$user_id AND company_code='".$company_code."' AND branch_code='".$branch_code."' ORDER BY id ASC LIMIT 1");
			if($branchwisecust->num_rows() > 0){
				$customer_id = $branchwisecust->row()->id;
			}else{
				$randnum = mt_rand();
				$pwd = password_hash($randnum, PASSWORD_DEFAULT);
				$cinsdata = array('name'=>$company_code."_Customer", 'phone'=>$randnum, 'location'=>$firsttwochars, 'address'=>$firsttwochars, 'pincode'=>$firsttwochars, 'code'=>$randnum, 'country'=>$firsttwochars, 'password'=>$pwd, 'user_id'=>$user_id,'company_code'=>$company_code, 'branch_code'=>$branch_code, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
				$customer_id = $this->common->insertTableData('tb_customers',$cinsdata);
			}
		}
		 /*orders table */
        $chechord = $this->db->select("id")->get_where("tb_orders",array("order_id"=>$shipdata['orderid']),1,0);
    	if($chechord->num_rows()>0){
    	$orddata = array('pickup_datetime'=>$pickup_datetime, 'pickup_endtime'=>$pickup_endtime, 'delivery_datetime'=>$delivery_datetime, 'drop_endtime'=>$drop_endtime, 'pickup_company'=>$pickup_company, 'delivery_company'=>$drop_company, 'pickup_country'=>$pickup_countrycode, 'delivery_country'=>$drop_countrycode, 'pickup_city'=>$pickup_city, 'delivery_city'=>$drop_city, 'pickup_pincode'=>$pickup_postal, 'delivery_pincode'=>$drop_postal, 'pickup_address1'=>$pickup_address, 'delivery_address1'=>$drop_address, 'pickup_address2'=>$pickup_address1, 'delivery_address2'=>$drop_address1, 'quantity'=>$shipdata['pkgs_count'], 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'goods_value'=>$shipdata['pkgs_count'], 'transport_mode'=>$transmode, 'dedicated_vehicle'=>$dedicateveh, 'vehicle_type'=>$data['truck']['triptype'], 'user_id'=>$user_id, 'customer_id'=>$customer_id, 'vendor_id'=>$carrier_id, 'customer_name'=>$shipdata['consignee']['name'], 'customer_code'=>$shipdata['consignee']['custid'], 'customer_area'=>($shipdata['consignee']['street'].", ".$shipdata['consignee']['city'].", ".$shipdata['consignee']['zip']), 'customer_phone'=>$shipdata['consignee']['custid'], 'vendor_name'=>$shipdata['shipper']['name'], 'vendor_code'=>$shipdata['shipper']['custid'], 'vendor_area'=>($shipdata['shipper']['street'].", ".$shipdata['shipper']['city'].", ".$shipdata['shipper']['zip']), 'vendor_phone'=>$shipdata['shipper']['custid'],'company_code'=>$shipdata['sendercmpcode'],'branch_code'=>$shipdata['senderbranchcode'],'product'=>$shipdata['serviceproduct'],'shipment_id'=>$sship_id, 'pickup_custid'=>$pickup_custid, 'pickup_partyid'=>$pickup_partyid, 'drop_custid'=>$drop_custid, 'drop_partyid'=>$drop_partyid, 'status'=>2, 'updatedon'=>$curdt);
    		$ord_id = $chechord->row()->id;
      		$upd = $this->db->where(array("id"=>$ord_id))->update('tb_orders',$orddata);
  		}else{
  			$orddata = array('order_id'=>$shipdata['orderid'], 'pickup_datetime'=>$pickup_datetime, 'pickup_endtime'=>$pickup_endtime, 'delivery_datetime'=>$delivery_datetime, 'drop_endtime'=>$drop_endtime, 'pickup_company'=>$pickup_company, 'delivery_company'=>$drop_company, 'pickup_country'=>$pickup_countrycode, 'delivery_country'=>$drop_countrycode, 'pickup_city'=>$pickup_city, 'delivery_city'=>$drop_city, 'pickup_pincode'=>$pickup_postal, 'delivery_pincode'=>$drop_postal, 'pickup_address1'=>$pickup_address, 'delivery_address1'=>$drop_address, 'pickup_address2'=>$pickup_address1, 'delivery_address2'=>$drop_address1, 'quantity'=>$shipdata['pkgs_count'], 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'goods_value'=>$shipdata['pkgs_count'], 'transport_mode'=>$transmode, 'dedicated_vehicle'=>$dedicateveh, 'vehicle_type'=>$data['truck']['triptype'], 'user_id'=>$user_id, 'customer_id'=>$customer_id, 'vendor_id'=>$carrier_id, 'customer_name'=>$shipdata['consignee']['name'], 'customer_code'=>$shipdata['consignee']['custid'], 'customer_area'=>($shipdata['consignee']['street'].", ".$shipdata['consignee']['city'].", ".$shipdata['consignee']['zip']), 'customer_phone'=>$shipdata['consignee']['custid'], 'vendor_name'=>$shipdata['shipper']['name'], 'vendor_code'=>$shipdata['shipper']['custid'], 'vendor_area'=>($shipdata['shipper']['street'].", ".$shipdata['shipper']['city'].", ".$shipdata['shipper']['zip']), 'vendor_phone'=>$shipdata['shipper']['custid'],'company_code'=>$shipdata['sendercmpcode'],'branch_code'=>$shipdata['senderbranchcode'],'product'=>$shipdata['serviceproduct'],'shipment_id'=>$sship_id, 'pickup_custid'=>$pickup_custid, 'pickup_partyid'=>$pickup_partyid, 'drop_custid'=>$drop_custid, 'drop_partyid'=>$drop_partyid, 'status'=>2, 'createdon'=>$curdt, 'updatedon'=>$curdt,"created_source"=>"newroadlogship/insertShipmentData");
      		$ord_id = $this->common->insertTableData('tb_orders',$orddata);
  		}
  		if($ord_id >0){
  			/*cargo details*/
  			$cargodt = array('order_id'=>$ord_id,'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'quantity'=>$shipdata['pkgs_count'], 'quantity_type'=>$shipdata['pkgs_uom'], 'cargo_content'=>$shipdata['cargo_content']);
  			$chkcargo = $this->db->select("id")->get_where("tb_order_cargodetails",$cargodt);
  			if($chkcargo->num_rows() == 0){
	  			$cargodata = array('order_id'=>$ord_id, 'handling_unit'=>1, 'length'=>0.00, 'width'=>0.00, 'height'=>0.00, 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'quantity'=>$shipdata['pkgs_count'], 'quantity_type'=>$shipdata['pkgs_uom'], 'cargo_content'=>$shipdata['cargo_content'], 'status'=>1);
	  			$cargo_id = $this->common->insertTableData('tb_order_cargodetails',$cargodata);
	  		}
  			if(!empty($shipdata['references'])){
  				foreach($shipdata['references'] as $sref){
  					$chkdt = array('order_id'=>$ord_id, 'reference_id'=>$sref['code'], 'ref_value'=>$sref['value']);
  					$chkref = $this->db->select("id")->get_where("tb_order_references",$chkdt);
  					if($chkref->num_rows() == 0){
	  					$srefqry = array('order_id'=>$ord_id, 'reference_id'=>$sref['code'], 'ref_value'=>$sref['value'], 'status'=>1, 'createdon'=>$curdt);
	  					$srefqryins = $this->common->insertTableData('tb_order_references',$srefqry);
	  				}
  				}
  			}
  		}
      if($sship_id > 0){
      	if(isset($consignee_id)){
      		$checkparty = $this->db->select("id")->get_where("tb_order_parties",array('order_id'=>$ord_id,'party_id'=>$consignee_id),1,0);
      		if($checkparty->num_rows()>0){
      			$partyarr = array('order_number'=>$shipdata['orderid'],'party_id'=>$consignee_id, 'status'=>1);
	      		$partyid = $checkparty->row()->id;
	      		$upd = $this->db->where(array("id"=>$partyid))->update('tb_order_parties',$partyarr);
      		}else{
	      	$partyarr = array('order_id'=>$ord_id,'order_number'=>$shipdata['orderid'],'party_id'=>$consignee_id, 'status'=>1,'createdon'=>$curdt);
	      	$ins = $this->common->insertTableData("tb_order_parties",$partyarr);
	      }
	    }
	    if(isset($shipper_id)){
	    	$checkparty = $this->db->select("id")->get_where("tb_order_parties",array('order_id'=>$ord_id,'party_id'=>$shipper_id),1,0);
      		if($checkparty->num_rows()>0){
      			$partyarr = array('order_number'=>$shipdata['orderid'],'party_id'=>$shipper_id, 'status'=>1);
	      		$partyid = $checkparty->row()->id;
	      		$upd = $this->db->where(array("id"=>$partyid))->update('tb_order_parties',$partyarr);
      		}else{
	      	$partyarr = array('order_id'=>$ord_id,'order_number'=>$shipdata['orderid'],'party_id'=>$shipper_id, 'status'=>1,'createdon'=>$curdt);
	      	$ins = $this->common->insertTableData("tb_order_parties",$partyarr);
	      }
	    }
	    if(isset($carrier_party_id)){
	    	$checkparty = $this->db->select("id")->get_where("tb_order_parties",array('order_id'=>$ord_id,'party_id'=>$carrier_party_id),1,0);
      		if($checkparty->num_rows()>0){
      			$partyarr = array('order_number'=>$shipdata['orderid'],'party_id'=>$carrier_party_id, 'status'=>1);
	      		$partyid = $checkparty->row()->id;
	      		$upd = $this->db->where(array("id"=>$partyid))->update('tb_order_parties',$partyarr);
      		}else{
	      	$partyarr = array('order_id'=>$ord_id,'order_number'=>$shipdata['orderid'],'party_id'=>$carrier_party_id, 'status'=>1,'createdon'=>$curdt);
	      	$ins = $this->common->insertTableData("tb_order_parties",$partyarr);
	      }
	    }
	    if(isset($cust_id)){
	    	$checkparty = $this->db->select("id")->get_where("tb_order_parties",array('order_id'=>$ord_id,'party_id'=>$cust_id),1,0);
      		if($checkparty->num_rows()>0){
      			$partyarr = array('order_number'=>$shipdata['orderid'],'party_id'=>$cust_id, 'status'=>1);
	      		$partyid = $checkparty->row()->id;
	      		$upd = $this->db->where(array("id"=>$partyid))->update('tb_order_parties',$partyarr);
      		}else{
	      	$partyarr = array('order_id'=>$ord_id,'order_number'=>$shipdata['orderid'],'party_id'=>$cust_id, 'status'=>1,'createdon'=>$curdt);
	      	$ins = $this->common->insertTableData("tb_order_parties",$partyarr);
	      }
	    }
      }
      /* store in shipment table */
      $startlat = $startlong = $endlat = $endlong = "";
       $sloc = $shipdata['pickdrops'][0]['pickup_company'].", ".$shipdata['pickdrops'][0]['pickup_address'].", ".$shipdata['pickdrops'][0]['pickup_city'].", ".$shipdata['pickdrops'][0]['pickup_countrycode'].", ".$shipdata['pickdrops'][0]['pickup_postal'];
        $eloc = $shipdata['pickdrops'][1]['drop_company'].", ".$shipdata['pickdrops'][1]['drop_address'].", ".$shipdata['pickdrops'][1]['drop_city'].", ".$shipdata['pickdrops'][1]['drop_countrycode'].", ".$shipdata['pickdrops'][1]['drop_postal'];
      $cheklatlng = $this->getlatlongbylocname($sloc);
      if(!empty($cheklatlng)){
      	$startlat = $cheklatlng['latitude'];
      	$startlong = $cheklatlng['longitude'];
      }
      $cheklatlng1 = $this->getlatlongbylocname($eloc);
      if(!empty($cheklatlng1)){
      	$endlat = $cheklatlng1['latitude'];
      	$endlong = $cheklatlng1['longitude'];
      }
      $checkshipment = $this->db->select("id")->get_where("tb_shifts",array('shipmentid'=>$data['truck']['shipment_id']),1,0);
      if($checkshipment->num_rows()>0){
      	$shipment = array('user_id'=>$user_id, 'stime'=>date("H:i",strtotime($starttime)), 'etime'=>date("H:i",strtotime($endtime)), 'splace'=>$pickup_company, 'slat'=>$startlat,  'slng'=>$startlong, 'eplace'=>$drop_company, 'elat'=>$endlat,  'elng'=>$endlong, 'scity'=>$pickup_city, 'dcity'=>$drop_city, 'zone_id'=>1, 'empshift_start'=>date("H:i",strtotime($starttime)), 'empshift_end'=>date("H:i",strtotime($endtime)), 'trip_type'=>0, 'startdate'=>$pickup_datetime, 'enddate'=>$delivery_datetime, 'shipment_name'=>$shipdata['cargo_content'], 'shipment_id'=>$data['truck']['shipment_id'], 'customer_id'=>$customer_id, 'transport_mode'=>$transmode, 'vendor_id'=>$carrier_id, 'carrier_type'=>0, 'txnid'=>$data['truck']['ordernum'], 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'units'=>$shipdata['pkgs_count'], 'domainname'=>$data['header']['lsender'], 'vehicle_type'=>$data['truck']['triptype'], 'company_code'=>$shipdata['sendercmpcode'], 'branch_code'=>$shipdata['senderbranchcode'], 'status'=>1, 'updated_on'=>$curdt);
      		$ship_id = $checkshipment->row()->id;
	      	$upd = $this->db->where(array("id"=>$ship_id))->update('tb_shifts',$shipment);
      }else{
	      $shipment = array('user_id'=>$user_id, 'stime'=>date("H:i",strtotime($starttime)), 'etime'=>date("H:i",strtotime($endtime)), 'splace'=>$pickup_company, 'slat'=>$startlat,  'slng'=>$startlong, 'eplace'=>$drop_company, 'elat'=>$endlat,  'elng'=>$endlong, 'scity'=>$pickup_city, 'dcity'=>$drop_city, 'zone_id'=>1, 'empshift_start'=>date("H:i",strtotime($starttime)), 'empshift_end'=>date("H:i",strtotime($endtime)), 'trip_type'=>0, 'startdate'=>$pickup_datetime, 'enddate'=>$delivery_datetime, 'shipment_name'=>$shipdata['cargo_content'], 'shipmentid'=>$data['truck']['shipment_id'], 'shipment_id'=>$data['truck']['shipment_id'], 'customer_id'=>$customer_id, 'transport_mode'=>$transmode, 'vendor_id'=>$carrier_id, 'carrier_type'=>0, 'txnid'=>$data['truck']['ordernum'], 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'units'=>$shipdata['pkgs_count'], 'domainname'=>$data['header']['lsender'], 'vehicle_type'=>$data['truck']['triptype'],'company_code'=>$shipdata['sendercmpcode'], 'branch_code'=>$shipdata['senderbranchcode'], 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
	      $ship_id = $this->common->insertTableData("tb_shifts",$shipment);
	  }
	  $responseord[] = $ship_id;
      /*stop legs*/
      $stop1 = $shipdata['pickdrops'][0]['pickup_company'].", ".$shipdata['pickdrops'][0]['pickup_address'].", ".$shipdata['pickdrops'][0]['pickup_city'].", ".$shipdata['pickdrops'][0]['pickup_countrycode'].", ".$shipdata['pickdrops'][0]['pickup_postal'];

      $chkstoplegs = $this->db->select("id")->get_where("tb_shiporder_stops",array('stopname'=>$shipdata['pickdrops'][0]['pickup_company'], 'stopcity'=>$shipdata['pickdrops'][0]['pickup_city'], 'shipment_id'=>$ship_id,'txncode'=>$data['truck']['ordernum']),1,0);
      if($chkstoplegs->num_rows() > 0){
      	$shiporder = array('address'=>$stop1, 'stoptype'=>'P', 'startdate'=>$pickup_datetime, 'enddate'=>$pickup_endtime, 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'serviceprovider'=>$data['header']['sendapp'], 'ship_units'=>$shipdata['pkgs_count'], 'updated_on'=>$curdt);
      		$stopleg1_id = $chkstoplegs->row()->id;
	      	$upd = $this->db->where(array("id"=>$stopleg1_id))->update('tb_shiporder_stops',$shiporder);
      }else{
	      $shiporder = array('stopname'=>$shipdata['pickdrops'][0]['pickup_company'], 'plat'=>$startlat,  'plng'=>$startlong, 'stopcity'=>$shipdata['pickdrops'][0]['pickup_city'], 'address'=>$stop1, 'stoptype'=>'P', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>0, 'startdate'=>$pickup_datetime, 'enddate'=>$pickup_endtime, 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'shipmentstopid'=>0, 'serviceprovider'=>$data['header']['sendapp'], 'ship_units'=>$shipdata['pkgs_count'], 'txncode'=>$data['truck']['ordernum'], 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
	      $stopleg1_id = $this->common->insertTableData("tb_shiporder_stops",$shiporder);
	  	}
     $stop2 = $shipdata['pickdrops'][1]['drop_company'].", ".$shipdata['pickdrops'][1]['drop_address'].", ".$shipdata['pickdrops'][1]['drop_city'].", ".$shipdata['pickdrops'][1]['drop_countrycode'].", ".$shipdata['pickdrops'][1]['drop_postal'];
      $chkstoplegs = $this->db->select("id")->get_where("tb_shiporder_stops",array('stopname'=>$shipdata['pickdrops'][1]['drop_company'], 'stopcity'=>$shipdata['pickdrops'][1]['drop_city'], 'shipment_id'=>$ship_id, 'txncode'=>$data['truck']['ordernum']),1,0);
      if($chkstoplegs->num_rows() > 0){
      	$shiporder = array('address'=>$stop2, 'stoptype'=>'D', 'startdate'=>$delivery_datetime, 'enddate'=>$drop_endtime, 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'serviceprovider'=>$data['header']['sendapp'], 'ship_units'=>$shipdata['pkgs_count'], 'updated_on'=>$curdt);
      		$stopleg2_id = $chkstoplegs->row()->id;
	      	$upd = $this->db->where(array("id"=>$stopleg2_id))->update('tb_shiporder_stops',$shiporder);
      }else{
      $shiporder = array('stopname'=>$shipdata['pickdrops'][1]['drop_company'],'plat'=>$endlat,  'plng'=>$endlong, 'stopcity'=>$shipdata['pickdrops'][1]['drop_city'], 'address'=>$stop2, 'stoptype'=>'D', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>0, 'startdate'=>$delivery_datetime, 'enddate'=>$drop_endtime, 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'shipmentstopid'=>0, 'serviceprovider'=>$data['header']['sendapp'], 'ship_units'=>$shipdata['pkgs_count'], 'txncode'=>$data['truck']['ordernum'], 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
      $stopleg2_id = $this->common->insertTableData("tb_shiporder_stops",$shiporder);
  }
      /*stops*/
      $chkemp = $this->db->select("id")->get_where("tb_employee",array('assoc_id'=>$data['truck']['ordernum'],'order_id'=>$shipdata['orderid'],'shift_id'=>$ship_id,'stop_id'=>$stopleg1_id, 'drop_stopid'=>$stopleg2_id),1,0);
      if($chkemp->num_rows()>0){
      	$stops = array('pickup'=>$pickup_company, 'drop'=>$drop_company, 'pickup_city'=>$pickup_city, 'drop_city'=>$drop_city, 'pickup_datetime'=>$pickup_datetime, 'drop_datetime'=>$delivery_datetime, 'name'=>$shipdata['cargo_content'], 'address'=>$stop1, 'user_id'=>$user_id, 'updatedon'=>$curdt, 'capacity'=>$shipdata['gross_weight'], 'shipment_weight'=>$shipdata['gross_weight'], 'shipment_volume'=>$shipdata['volume'], 'ship_type'=>'P', 'customer_id'=>$customer_id, 'vendor_id'=>$carrier_id, 'startdate'=>$pickup_datetime, 'enddate'=>$delivery_datetime, 'pkgitemid'=>$shipdata['cargo_content'], 'no_of_pkgs'=>$shipdata['pkgs_count'], 'domainname'=>$data['header']['lsender']);
      	$stop_id = $chkemp->row()->id;
	    $upd = $this->db->where(array("id"=>$stop_id))->update('tb_employee',$stops);
      }else{
	      $stops = array('assoc_id'=>$data['truck']['ordernum'], 'pickup'=>$pickup_company,'plat'=>$startlat, 'plng'=>$startlong, 'drop'=>$drop_company,'dlat'=>$endlat,  'dlng'=>$endlong, 'pickup_city'=>$pickup_city, 'drop_city'=>$drop_city, 'pickup_datetime'=>$pickup_datetime, 'drop_datetime'=>$delivery_datetime, 'name'=>$shipdata['cargo_content'], 'phone'=>"", 'address'=>$stop1, 'user_id'=>$user_id, 'password' => RandomString::generate(10),'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt, 'material_id'=>0, 'capacity'=>$shipdata['gross_weight'], 'information'=>"", 'shipment_weight'=>$shipdata['gross_weight'], 'shipment_volume'=>$shipdata['volume'], 'ship_type'=>'P', 'customer_id'=>$customer_id, 'vendor_id'=>$carrier_id, 'shipment_id'=>0, 'startdate'=>$pickup_datetime, 'enddate'=>$delivery_datetime, 'shift_id'=>$ship_id, 'stop_order'=>1, 'drop_order'=>0, 'basic_stop'=>1, 'stop_id'=>$stopleg1_id, 'drop_stopid'=>$stopleg2_id, 'order_id'=>$shipdata['orderid'], 'pkgitemid'=>$shipdata['cargo_content'], 'no_of_pkgs'=>$shipdata['pkgs_count'], 'domainname'=>$data['header']['lsender']);
	      $stop_id = $this->common->insertTableData("tb_employee",$stops);
	  }
     	 /*driver info*/
      	$driver_id = 0;
        if(isset($data['driver']) && isset($data['driver']['firstname'])){
	       	if(isset($data['driver']['driverid'])){
	      		$chkdriver = $this->db->select("id")->get_where("tb_truck_drivers",array("contact_num"=>$data['driver']['driverid']),1,0);
	      		if($chkdriver->num_rows()==0){
					$driver = array('name'=>($data['driver']['firstname']." ".$data['driver']['lastname']), 'password'=>'TVRJek5EVTI=', 'contact_num'=>$data['driver']['driverid'], 'age'=>0, 'driving_since'=>'0', 'driving_licence_num'=>'', 'city'=>$pickup_city, 'createdon'=>$curdt, 'updatedon'=>$curdt, 'createdby'=>$user_id, 'updatedby'=>$user_id, 'user_id'=>$user_id, 'status'=>'Active');
					$driver_id = $this->common->insertTableData("tb_truck_drivers",$driver);
				}else{
					$driver_id = $chkdriver->row()->id;
				}
			}
	  	}
	  	$rand = mt_rand(1111111111,9999999999);
	  	if($driver_id == 0){
  			$chkdriver = $this->db->select("id")->get_where("tb_truck_drivers",array("vendor_id"=>$carrier_id,"status"=>"Active"),1,0);
  			if($chkdriver->num_rows()>0){
  				$driver_id = $chkdriver->row()->id;
  			}else{
  				$driver = array('name'=>$rand, 'password'=>'TVRJek5EVTI=', 'contact_num'=>$rand, 'age'=>0, 'driving_since'=>'0', 'driving_licence_num'=>'', 'city'=>$pickup_city, 'createdon'=>$curdt, 'updatedon'=>$curdt, 'createdby'=>$user_id, 'updatedby'=>$user_id, 'user_id'=>$user_id, 'vendor_id'=>$carrier_id, 'status'=>'Active');
				$driver_id = $this->common->insertTableData("tb_truck_drivers",$driver);
  			}
  		}
	  	$qry = $this->db->query("SELECT id FROM tb_vendor_vehicles WHERE vehicle_id NOT IN(SELECT vehicle_id FROM tb_trips WHERE status=1) and vendor_id=$carrier_id AND status=1 LIMIT 1");
	  	if($qry->num_rows()>0){
	  		$vehicleid = $qry->row()->id;
	  		$chk = $this->db->select("id,driver_id,status")->order_by("id","DESC")->get_where("tb_vehicles_drivers",array("vehicle_id"=>$vehicleid));
  			if($chk->num_rows()>0){
  				if($driver_id == $chk->row()->driver_id){
	  				$upd = $this->db->where(array("id"=>$chk->row()->id))->update("tb_vehicles_drivers",array("status"=>1));
	  			}else{
	  				$arr = array('vehicle_id'=>$vehicleid, 'driver_id'=>$driver_id, 'imei'=>"", 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
	  				$ins = $this->common->insertTableData("tb_vehicles_drivers",$arr);
	  			}
	  		}else{
	  			$arr = array('vehicle_id'=>$vehicleid, 'driver_id'=>$driver_id, 'imei'=>"", 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
	  			$ins = $this->common->insertTableData("tb_vehicles_drivers",$arr);
	  		}
	  	}else{
	  		$chk = $this->db->select("id")->order_by("id","DESC")->get_where("tb_trucks_data",array("user_id"=>$user_id,"status"=>"Active"),1,0);
  			if($chk->num_rows()>0){
  				$vehicleid = $chk->row()->id;
  			}else{
  				$arr = array('truck_number'=>$driver_id, 'length'=>100, 'breadth'=>100, 'truck_capacity'=>100, 'truck_type'=>94, 'available_type'=>"", 'description'=>"", 'register_number'=>$rand, 'insurence'=>"Yes", 'insuredby'=>"", 'insurestart'=>$curdt, 'insureexp'=>$curdt, 'route'=>$rand, 'user_id'=>$user_id, 'createdby'=>0, 'updatedby'=>0, 'status'=>'Active', 'createdon'=>$curdt, 'updatedon'=>$curdt);
  				$vehicleid = $this->common->insertTableData("tb_trucks_data",$arr);
  			}
  			$chk = $this->db->select("id,driver_id,status")->order_by("id","DESC")->get_where("tb_vehicles_drivers",array("vehicle_id"=>$vehicleid));
  			if($chk->num_rows()>0){
  				if($driver_id == $chk->row()->driver_id){
	  				$upd = $this->db->where(array("id"=>$chk->row()->id))->update("tb_vehicles_drivers",array("status"=>1));
	  			}else{
	  				$arr = array('vehicle_id'=>$vehicleid, 'driver_id'=>$driver_id, 'imei'=>"", 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
	  				$ins = $this->common->insertTableData("tb_vehicles_drivers",$arr);
	  			}
	  		}else{
	  			$arr = array('vehicle_id'=>$vehicleid, 'driver_id'=>$driver_id, 'imei'=>"", 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
	  			$ins = $this->common->insertTableData("tb_vehicles_drivers",$arr);
	  		}
	  	}
	  	}
	  }
	  }
      	return $responseord;
    }

    function getlatlongbylocname($address){
        $response = getlatlngsbyplace($address);
        return [
            'latitude' => $response[0],
            'longitude' => $response[1]
        ];
    }
    public function checkconsignee($customer,$cmpcode,$branchcode,$uid,$custtype){
      $cwhr = array('name'=>$customer['name'],"code"=>$customer['custid']);
	    $cselect = 'id';
      $curdt = date('Y-m-d H:i:s');
      $cust_id = 0;
      if($custtype == "CN"){
	      $ctable = 'tb_customers';
	      $chkcust = $this->common->gettblrowdata($cwhr,$cselect,$ctable,0,0);
	      if(count($chkcust) > 0){
	         $cust_id = $chkcust['id'];
	         $upddata = array('location'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'], 'user_id'=>$uid, 'status'=>1,'updatedon'=>$curdt);
	         $upd = $this->db->where(array("id"=>$cust_id))->update('tb_customers',$upddata);
	      }else{
	         $randnum = $customer['custid'];
	         $pwd = password_hash($randnum, PASSWORD_DEFAULT);
	         $cinsdata = array('name'=>$customer['name'], 'phone'=>$customer['custid'], 'location'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'], 'password'=>$pwd,'user_id'=>$uid, 'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
	         $cust_id = $this->common->insertTableData('tb_customers',$cinsdata);
	      }
	  }
      $cwhr['party_type_id'] = 3;
      $chkcust = $this->common->gettblrowdata($cwhr,$cselect,"tbl_party_master",0,0);
      if(count($chkcust) > 0){
         $custid = $chkcust['id'];
         $upddata = array('location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'], 'status'=>1,'updated_on'=>$curdt);
         $upd = $this->db->where(array("id"=>$custid))->update('tbl_party_master',$upddata);
      }else{
         $randnum = $customer['custid'];
         $pwd = password_hash($randnum, PASSWORD_DEFAULT);
         $cinsdata = array('party_type_id'=>3, 'name'=>$customer['name'], 'email'=>'svkonekt@kuehne-nagel.com','mobile'=>$customer['custid'], 'location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'],'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
         $custid = $this->common->insertTableData('tbl_party_master',$cinsdata);
      }
      $res['id'] = $cust_id;
      $res['party_id'] = $custid;
      return $res;
   }

	public function checkshipper($customer,$cmpcode,$branchcode,$uid,$custtype){
      $cwhr = array('name'=>$customer['name'],"code"=>$customer['custid']);
      $cselect = 'id';
      $curdt = date('Y-m-d H:i:s');
      $cust_id = 0;
      if($custtype == "SH"){
      	$ctable = 'tb_customers';
	      $chkcust = $this->common->gettblrowdata($cwhr,$cselect,$ctable,0,0);
	      if(count($chkcust) > 0){
	         $cust_id = $chkcust['id'];
	         $upddata = array('location'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'], 'user_id'=>$uid, 'status'=>1,'updatedon'=>$curdt);
	         $upd = $this->db->where(array("id"=>$cust_id))->update('tb_customers',$upddata);
	      }else{
	         $randnum = $customer['custid'];
	         $pwd = password_hash($randnum, PASSWORD_DEFAULT);
	         $cinsdata = array('name'=>$customer['name'], 'phone'=>$customer['custid'], 'location'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'], 'password'=>$pwd, 'user_id'=>$uid,'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
	         $cust_id = $this->common->insertTableData('tb_customers',$cinsdata);
	      }
	  }
      $cwhr['party_type_id'] = 4;
      $chkcust = $this->common->gettblrowdata($cwhr,$cselect,"tbl_party_master",0,0);
      if(count($chkcust) > 0){
         $custid = $chkcust['id'];
         $upddata = array('location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'],'status'=>1,'updated_on'=>$curdt);
         $upd = $this->db->where(array("id"=>$custid))->update('tbl_party_master',$upddata);
      }else{
         $randnum = $customer['custid'];
         $pwd = password_hash($randnum, PASSWORD_DEFAULT);
         $cinsdata = array('party_type_id'=>4, 'name'=>$customer['name'], 'email'=>'svkonekt@kuehne-nagel.com','mobile'=>$customer['custid'], 'location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'],'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
         $custid = $this->common->insertTableData('tbl_party_master',$cinsdata);
      }
      $res['id'] = $cust_id;
      $res['party_id'] = $custid;
      return $res;
   }

	public function checkcustomer($customer,$cmpcode,$branchcode,$uid,$custtype){
      $cwhr = array('name'=>$customer['name'],"code"=>$customer['custid']);
      $cselect = 'id';
      $curdt = date('Y-m-d H:i:s');
      $cust_id = 0;
      if($custtype == "PF"){
	      $ctable = 'tb_customers';
	      $chkcust = $this->common->gettblrowdata($cwhr,$cselect,$ctable,0,0);
	      if(count($chkcust) > 0){
	         $cust_id = $chkcust['id'];
	         $upddata = array('location'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'], 'user_id'=>$uid, 'status'=>1,'updatedon'=>$curdt);
	         $upd = $this->db->where(array("id"=>$cust_id))->update('tb_customers',$upddata);
	      }else{
	         $randnum = $customer['custid'];
	         $pwd = password_hash($randnum, PASSWORD_DEFAULT);
	         $cinsdata = array('name'=>$customer['name'], 'phone'=>$customer['custid'], 'location'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'], 'password'=>$pwd, 'user_id'=>$uid,'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
	         $cust_id = $this->common->insertTableData('tb_customers',$cinsdata);
	      }
	  }
      $cwhr['party_type_id'] = 1;
      $chkcust = $this->common->gettblrowdata($cwhr,$cselect,"tbl_party_master",0,0);
      if(count($chkcust) > 0){
         $custid = $chkcust['id'];
         $upddata = array('location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'],'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'],'user_id'=>$uid, 'status'=>1,'updated_on'=>$curdt);
         $upd = $this->db->where(array("id"=>$custid))->update('tbl_party_master',$upddata);
      }else{
         $randnum = $customer['custid'];
         $pwd = password_hash($randnum, PASSWORD_DEFAULT);
         $cinsdata = array('party_type_id'=>1, 'name'=>$customer['name'], 'email'=>'svkonekt@kuehne-nagel.com','mobile'=>$customer['custid'], 'location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'],'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
         $custid = $this->common->insertTableData('tbl_party_master',$cinsdata);
      }
      $res['id'] = $cust_id;
      $res['party_id'] = $custid;
      return $res;
    }

   public function checkcarrier($customer,$cmpcode,$branchcode,$uid){
   	$res = array();
   	$curdt = date('Y-m-d H:i:s');
   	if(isset($customer['custid'])){
	      $cwhr = array('name'=>$customer['name'],"code"=>$customer['custid']);
	      $ctable = 'tb_vendors';
	      $cselect = 'id';
	      $chkcust = $this->common->gettblrowdata($cwhr,$cselect,$ctable,0,0);
	      if(count($chkcust) > 0){
	         $cust_id = $chkcust['id'];
	         $addr = $customer['street'].", ".$customer['street1'].", ".$customer['city'].", ".$customer['country'].", ".$customer['zip'];
	         $upddata = array('location'=>$customer['city'], 'address'=>$addr, 'pincode'=>$customer['zip'],'country'=>$customer['country'], 'effective_date'=>date('Y-m-d'), 'expiry_date'=>date('Y-m-d'), 'service_id'=>$customer['custid'], 'service_name'=>$customer['partyid'],'user_id'=>$uid, 'status'=>1,'updated_on'=>$curdt);
	         $upd = $this->db->where(array("id"=>$cust_id))->update('tb_vendors',$upddata);
	      }else{
	         $randnum = $customer['custid'];
	         $pwd = password_hash($randnum, PASSWORD_DEFAULT);
	         $addr = $customer['street'].", ".$customer['street1'].", ".$customer['city'].", ".$customer['country'].", ".$customer['zip'];
	         $cinsdata = array('name'=>$customer['name'], 'mobile'=>$customer['custid'], 'location'=>$customer['city'], 'address'=>$addr, 'pincode'=>$customer['zip'], 'country'=>$customer['country'], 'password'=>$pwd,'email'=>'', 'code'=>$customer['custid'], 'offering_type'=>'FTL', 'carrier_grade'=>'ABC', 'effective_date'=>date('Y-m-d'), 'expiry_date'=>date('Y-m-d'), 'service_id'=>$customer['custid'], 'service_name'=>$customer['partyid'], 'user_id'=>$uid,'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
	         $cust_id = $this->common->insertTableData('tb_vendors',$cinsdata);
	      }
	      $cwhr['party_type_id'] = 2;
	      $chkcust = $this->common->gettblrowdata($cwhr,$cselect,"tbl_party_master",0,0);
	      if(count($chkcust) > 0){
	         $custid = $chkcust['id'];
	         $upddata = array('location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'], 'status'=>1,'updated_on'=>$curdt);
	         $upd = $this->db->where(array("id"=>$custid))->update('tbl_party_master',$upddata);
	      }else{
	         $randnum = $customer['custid'];
	         $pwd = password_hash($randnum, PASSWORD_DEFAULT);
	         $cinsdata = array('party_type_id'=>2, 'name'=>$customer['name'], 'email'=>'svkonekt@kuehne-nagel.com','mobile'=>$customer['custid'], 'location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'],'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
	         $custid = $this->common->insertTableData('tbl_party_master',$cinsdata);
	      }
	      $res['id'] = $cust_id;
	      $res['party_id'] = $custid;
	  }else{
	  	$randnum = time();
		$pwd =password_hash($randnum, PASSWORD_DEFAULT);
		$cntry = substr($cmpcode, 0,2);
		$addr = $cntry;
		$effctdate = date('Y-m-d');
		$cinsdata = array('name'=>$cntry."_Carrier", 'mobile'=>$randnum, 'location'=>$cntry, 'address'=>$addr, 'pincode'=>$addr, 'country'=>$cntry, 'password'=>$pwd,'email'=>'', 'code'=>$randnum, 'offering_type'=>'FTL', 'carrier_grade'=>'ABC', 'effective_date'=>$effctdate, 'expiry_date'=>$effctdate, 'service_id'=>$randnum, 'service_name'=>"", 'user_id'=>$uid,'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
		$cust_id = $this->common->insertTableData('tb_vendors',$cinsdata);
		$res['id'] = $cust_id;
	  }
      return $res;
   }

   public function updatestatus(){
   		$postData = file_get_contents('php://input');
		$xml = new SimpleXMLElement($postData);
		$userid = 1;
		$response = 0;
		$statusmsg = "";
		if ($xml === false) {
		 	$statusmsg = "Invalid request,Please try again!";
		}else{
			$shipdata = $this->read_shipmentstatus($xml);
			$logdate = date('Y-m-d H:i:s');
			if(!empty($shipdata)){
				print_r($shipdata);
			   /*log_message("error","parsed_status_data ".json_encode($shipdata));
			   $response = $this->insertShipmentData($shipdata,$logdate);*/
			}
			if($response > 0){
				$statusmsg = "Success";
			}else{
				$statusmsg = "Failed for unformatted request,Please try again!";
			}
    	}
    	echo $statusmsg;
   }

   public function read_shipmentstatus($xml){
		$res = array();
		$xml->registerXPathNamespace('ns9', 'http://knie4.int.kn/msg/roadstatus/0100');
		$mdata = $xml->xpath('//ns9:RoadStatus');
		$xml->registerXPathNamespace('ns3', 'http://knie4.int.kn/com/lhdr/0200');
		$data = $xml->xpath('ns3:MessageHeader');
		$physicalreceiver = (string)($data[0]->xpath('ReceiverDetails')[0]->PhysicalReceiver);
		$logicalreceiver = (string)($data[0]->xpath('ReceiverDetails')[0]->LogicalReceiver);
		$physicalsender = (string)($data[0]->xpath('PhysicalSender')[0]);
		$logicalsender = (string)($data[0]->xpath('LogicalSender')[0]);
		$lreceiver = $preceiver = $psender = $lsender = "";
		$driver = $carrier = array();
		$preceiver = $physicalreceiver;
		$lreceiver = $logicalreceiver;
		$psender = $physicalsender;
		$lsender = $logicalsender;
		$sendapp = (string)($data[0]->xpath('SendingApplication')[0]);
		$msgtype = (string)($data[0]->xpath('MessageType')[0]);
		$version = (string)($data[0]->xpath('VersionNumber')[0]);
		$createdtime = (string)($data[0]->xpath('CreationDateTime')[0]);
		if($createdtime != ""){
		 $createdtime = date("Y-m-d H:i:s",strtotime($createdtime));
		}else{
		 $createdtime = date("Y-m-d H:i:s");
		}
		$res['header'] = array("preceiver"=>$preceiver,"lreceiver"=>$lreceiver,"psender"=>$psender,"lsender"=>$lsender,"sendapp"=>$sendapp,"msgtype"=>$msgtype,"version"=>$version,"createdtime"=>$createdtime);
		/* truck and trailer info */
		$arr = array();
		$msgdata = $xml->Message;
		$msgdata->registerXPathNamespace('ns4', 'http://knie4.int.kn/com/ltru/0200');
		$titledata = $msgdata->xpath('//ns4:MessageLevel');
		$arr['orderid'] = (string)($titledata[0]->xpath('TrackingNumber')[0]);
		$arr['sendercmpcode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->CompanyCode);
		$arr['senderbranchcode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->BranchCode);
        $arr['senderdepcode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->DepartmentCode);
        $arr['sendertransmode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->ModeOfTransport);
        $arr['refcode'] = (string)($titledata[0]->xpath('MessageReferences')[0]->Code);
        $arr['refvalue'] = (string)($titledata[0]->xpath('MessageReferences')[0]->Value);
		$msgdata->registerXPathNamespace('ns5', 'http://knie4.int.kn/com/lsts/0200');
		$stsdata = $msgdata->xpath('//ns5:StatusInformation');
		$arr['status_code'] = (string)($stsdata[0]->attributes('ns2',TRUE)->StatusCode);
		$arr['status_date'] = (string)($stsdata[0]->xpath('StatusDate')[0]);
		$arr['status_time'] = (string)($stsdata[0]->xpath('StatusTime')[0]);
		$arr['status_time'] = date('H:i:s',strtotime($arr['status_time']));
		$arr['status_loc'] = (string)($stsdata[0]->xpath('StatusLocation')[0]);
		$arr['status_loc1'] = (string)($stsdata[0]->xpath('StatusLocation')[1]);
		$arr['status_additionaltime'] = "";
		if(isset($stsdata[0]->xpath('AdditionalStatusInformation')[0]->StatusEntryDateTime)){
			$arr['status_additionaltime'] = (string)($stsdata[0]->xpath('AdditionalStatusInformation')[0]->StatusEntryDateTime);
			$arr['status_additionaltime'] = date('H:i:s',strtotime($arr['status_additionaltime']));
		}
		$infodata1 = $mdata[0]->xpath('Message')[0]->Shipment;
        $infodata1->registerXPathNamespace('ns6', 'http://knie4.int.kn/com/lref/0100');
		$refdetail = $infodata1->xpath('//ns6:ReferencesDetails');
		$arr['ref_type'] = (string)($refdetail[0]->attributes('ns2',TRUE)->AddressType);
		$arr['ref_code'] = (string)($refdetail[0]->xpath('Code')[0]);
        $arr['ref_value'] = (string)($refdetail[0]->xpath('Value')[0]);
		$res['general'] = $arr;
      	return $res;
    }

}
