<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Notifymgmt extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('session');
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('common');
        $this->load->model('notifymodel');
        if (!checkUrlAccessForUser('COMMMGNT')) {
            redirect("Forbiddenaccess");
        }

    }

    public function index()
    {
        $data['page_title'] = $this->lang->line('notification_management');
        $data['sub_title'] = $this->lang->line('master_data');
        $where['nm.user_id'] = $this->session->userdata('user_id');
        $post = $this->input->post(NULL,TRUE);
        if(isset($post['customer_code']) && $post['customer_code']){
            $where['c.code'] = $post['customer_code'];
        }
        if(isset($post['service']) && $post['service']){
            $where['nm.service'] = $post['service'];
        }
        if(isset($post['product']) && !empty($post['product'])){
            $where['nm.product'] = $post['product'];
        }
        if(isset($post['incoterm']) && !empty($post['incoterm'])){
            $where['nm.inco_term'] = $post['incoterm'];
        }
        if(isset($post['service']) && !empty($post['service'])){
            $where['nm.service'] = $post['service'];
        }
        if(isset($post['order_type']) && !empty($post['order_type'])){
            $where['nm.order_type'] = $post['order_type'];
        }
        if(isset($post['notification_id']) && !empty($post['notification_id'])){
            $where['nm.notification_id'] = $post['notification_id'];
        }
        if(isset($post['company_code']) && !empty($post['company_code'])){
            $where['nm.company_code'] = $post['company_code'];
        }
        if(isset($post['branch_code']) && !empty($post['branch_code'])){
            $where['nm.branch_code'] = $post['branch_code'];
        }
        if(isset($post['department_code']) && !empty($post['department_code'])){
            $where['nm.department_code'] = $post['department_code'];
        }
        if(isset($post['from_country']) && !empty($post['from_country'])){
            $where['nm.from_country'] = $post['from_country'];
        }
        if(isset($post['to_country']) && !empty($post['to_country'])){
            $where['nm.to_country'] = $post['to_country'];
        }
        $company_code = $this->session->userdata('company_code');
        $data['countries'] = $this->notifymodel->getCountries();
        $data['departmentcodes'] =  getDepartmentMasterData();
        $data['notifycontacts'] = $this->notifymodel->notifyList($where);
        $this->newtemplate->dashboard('notifys/index', $data);
    }

    public function test(){
         $this->load->library('notifytrigger');
        $data['shift_id'] = 866;
        $data['action'] = 'trip_create';
        $data['body'] = $this->load->view('mail_forms/notifytrigger/trip_create',$data,true);
        $this->notifytrigger->sendtripnotify($data);
        exit;
        $data['page_title'] = 'New Booking Created';
        $data['subject'] = 'New Booking Created';
        $data['order_id'] = 1787;//2004;
        $data['action'] = 'booking_create';
        //$data['action'] = 'trip_create';
        $data['orderid'] = $this->common->gettblrowdata(['id'=>$data['order_id']],'order_id','tb_orders',0,0)['order_id'];
        $data['cargos'] = $this->common->gettbldata(['order_id'=>$data['order_id']],'quantity_type,quantity','tb_order_cargodetails',0,0);
        $data['body'] = $this->load->view('mail_forms/notifytrigger/booking_create',$data,true);
        $this->notifytrigger->sendordernotify($data);
    }

    public function tpl(){
        $data = [];
        $data['pagetitle'] = 'New Booking Created';
        $data['receivename'] = "receivename";
        $data['order_id'] = 1754;
        $data['orderid'] = 63223456;
        $data['shiftid'] = 'TA123456';
        $data['driver'] = "Driver";
        $data['drivermobile'] ="DriverMobile";
        $data['register_number'] ="9876543210";
        $data['cargos'] = $this->common->gettbldata(['order_id'=>$data['order_id']],'quantity_type,quantity','tb_order_cargodetails',0,0);
        $data['body'] = $this->load->view('mail_forms/notifytrigger/trip_delete',$data,false);
    }

    public function testmail(){
        $this->load->library('email');
        $this->email->to('external.ram.k@kuehne-nagel.com', 'Lakshmi');
        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
        $this->email->subject('svkonekt :: Notify MGNT TESTING');
        $this->email->set_mailtype('html');
        $this->email->message('NOTIFY MGNT TESTNIG MAIL BODY');
        if(!$this->email->send()){
            log_message("error",$this->email->print_debugger());
            echo "Mail Error check in log file";
        } else {
            echo "Mail Sent Successfully";
        }

    }

    public function add($id=null){
        $data['page_title'] = $this->lang->line('notification_management');
        $data['sub_title'] = $this->lang->line('notification_management');
        $data['countries'] = $this->notifymodel->getCountries();
        $company_code = $this->session->userdata('company_code');
        //$branch_code = $this->session->userdata('branch_code');
      /*  $data['departmentcodes'] = $this->common->gettbldata(array('company_code'=>$company_code,'status'=>1),'department_code','tb_department_master',0,0); */
        $data['departmentcodes'] =  getDepartmentMasterData();
        $data['customer_data'] = [];
        $data['customer_code'] = null;
        $data['id'] = null;
        $data['type'] = 'add';
        $data['combination'] = [];
        $post = $this->input->post(NULL,TRUE);
        if(count($post) > 0){            
                $input['user_id'] = $this->session->userdata('user_id');
                $input['company_code'] = $post['notify_company_code'];
                $input['branch_code'] = $post['notify_branch_code'];
                $input['department_code'] = (empty($post['notify_department_code']))?'':$post['notify_department_code'];
                $input['product'] = ($post['notify_product']=='0')?'':$post['notify_product'];
                $input['inco_term'] = ($post['notify_incoterm']=='0')?'':$post['notify_incoterm'];
                $input['service'] = ($post['notify_service']=='0')?'':$post['notify_service'];
                $input['order_type'] = ($post['notify_order_type']=='0')?'':$post['notify_order_type'];
                $input['from_country'] = $post['notify_from_country'];
                $input['to_country'] = $post['notify_to_country'];
                $input['party_id'] = 0;
                $input['partycontact_id'] = 0;
                $input['all_note'] = 0;
                $input['createdby'] = $input['user_id'];
                $input['updatedby'] = $input['user_id'];
               // print_r($input); exit;
                $input['customer_id'] = 0;
                if(!empty($post['notify_customer_id'])){
                    $customerinfo = $this->common->gettblrowdata(['code'=>$post['notify_customer_id']],'id','tb_customers',0,0);
                    if(isset($customerinfo['id'])){
                        $input['customer_id'] = $customerinfo['id'];
                    }
                }
                if(empty($post['notify_notification_id'])){
                    $input['notification_id'] = $this->generateNotifyID();
                }
                if(isset($post['count']) && !empty($post['count'])){
                    for($i=0;$i<$post['count'];$i++){
                        $role = $post['role'.$i];
                        $input['party_type'] = $role;
                        $primaryid = $post['role'.$i.'_primaryid'];
                        $input['party_type_id'] = $post['role'.$i.'_partyid'];
                        $input['booking_create'] = isset($post[$role.'_bookingcreate'])?1:0;
                        $input['booking_edit'] = isset($post[$role.'_bookingedit'])?1:0;
                        $input['booking_delete'] = isset($post[$role.'_bookingdelete'])?1:0;
                        $input['trip_create'] = isset($post[$role.'_tripcreate'])?1:0;
                        $input['trip_edit'] = isset($post[$role.'_tripedit'])?1:0;
                        $input['trip_delete'] = isset($post[$role.'_tripdelete'])?1:0;
                        $input['driver_accept'] = isset($post[$role.'_driveraccept'])?1:0;
                        $input['route_deviate'] = isset($post[$role.'_routedeviate'])?1:0;
                        $input['speed'] = isset($post[$role.'_speed'])?1:0;
                        $input['temperature'] = isset($post[$role.'_temperature'])?1:0;
                        $input['pickup_note'] = isset($post[$role.'_pickupnote'])?1:0;
                        $input['delivery_note'] = isset($post[$role.'_deliverynote'])?1:0;
                        $input['pod_note'] = isset($post[$role.'_podnote'])?1:0;
                        $input['sms_note'] = isset($post[$role.'_smsnote'])?1:0;
                        $input['email_note'] = isset($post[$role.'_emailnote'])?1:0;
                        $input['whatsapp_note'] = isset($post[$role.'_whatsappnote'])?1:0;
                       // $inputs[] = $input;
                        if($primaryid == 0){
                            $id = $this->common->insertTableData('tb_notify_management', $input);
                        } else {
                            $id = $this->common->updatetbledata('tb_notify_management', $input,['id'=>$primaryid]);
                        }
                    }
                }
            redirect('notifymgmt');
        } else if($id){
            $data['id'] = $id;
            $data['type'] = 'edit';
            $data['combination'] = $this->common->gettblrowdata(['id'=>$id],'*','tb_notify_management',0,0);
            $data['notifylist'] = $this->notifymodel->getNotifyData(['notification_id'=>$data['combination']['notification_id']]);
            //print_r($data['combination']); exit;
            if(!empty($data['combination']['customer_id'])){
                $customerinfo = $this->common->gettblrowdata(['id'=>$data['combination']['customer_id']],'code','tb_customers',0,0);
                $data['combination']['customer_id'] = $customerinfo['code'];
            } else {
                $data['combination']['customer_id'] = "";
            }
            //$this->newtemplate->dashboard('notifys/edit', $data);
            $this->load->view('notifys/edit', $data);
        } else {
            //$this->newtemplate->dashboard('notifys/add', $data);
            $this->load->view('notifys/add', $data);
        }
    }

    public function view($id){
        $data['page_title'] = $this->lang->line('notification_management');
        $data['sub_title'] = $this->lang->line('notification_management');
        $notifydata = $this->common->gettblrowdata(['id'=>$id],'notification_id','tb_notify_management',0,0);
        if(!empty($notifydata)){
            $data['notifylist'] = $this->notifymodel->notifyContactsList(['notification_id'=>$notifydata['notification_id']]);
            $data['notify'] = $data['notifylist'][0];
            //$this->newtemplate->dashboard('notifys/view',$data);
            $this->load->view('notifys/view', $data);
        } else {
            redirect('notifymgmt');
        }
    }

    public function getNotifydata(){

        $data['partytypes'] = $this->common->gettbldata(['user_id'=>$this->session->userdata('user_id')],'id,name','tbl_party_types',0,0);
        $post = $this->input->post(NULL,TRUE);
        $where['pt.status'] = 1;
        $where['nm.company_code'] = $post['company_code'];
        $where['nm.branch_code'] = $post['branch_code'];
        $where['nm.department_code'] = (!empty($post['department_code']))?$post['department_code']:'';
        $where['nm.from_country'] = $post['from_country'];
        $where['nm.to_country'] = $post['to_country'];
        $where['nm.product'] = $post['product'];
        $where['nm.service'] = $post['service'];
        $where['nm.order_type'] = $post['order_type'];
        $where['nm.inco_term'] = $post['incoterm'];
        if(!empty($post['notification_id'])){
            $where['nm.notification_id'] = $post['notification_id'];
        }
        if($post['customer_id']){
            $customerinfo = $this->common->gettblrowdata(['code'=>$post['customer_id']],'id','tb_customers',0,0);
            $where['nm.customer_id'] = $customerinfo['id'];
        } else {
            $where['nm.customer_id'] = $post['customer_id'];
        }
        $data['notifydata'] = $this->notifymodel->getNotifyData($where);
        /* if(count($data['notifydata']) == 0){
            unset($where['c.code']); //new customer
            $data['notifydata'] = $this->notifymodel->getNotifyData($where);
        } */
        echo  json_encode($data['notifydata']);
    }

    public function checkcombination(){
        $post = $this->input->post(NULL,TRUE);
        $where['company_code'] = $post['company_code'];
        $where['branch_code'] = $post['branch_code'];
        $where['department_code'] = (!empty($post['department_code']))?$post['department_code']:'';
        $where['from_country'] = $post['from_country'];
        $where['to_country'] = $post['to_country'];
        $where['product'] = $post['product'];
        $where['service'] = $post['service'];
        $where['order_type'] = $post['order_type'];
        $where['inco_term'] = $post['incoterm'];
        $where['notification_id !='] = $post['notification_id'];
        if($post['customer_id']){
            $customerinfo = $this->common->gettblrowdata(['code'=>$post['customer_id']],'id','tb_customers',0,0);
            $where['customer_id'] = $customerinfo['id'];
        } else {
            $where['customer_id'] = $post['customer_id'];
        }
        $result = $this->common->gettbldata($where,'*','tb_notify_management',0,0);
        if(empty($result)){
            $result['result'] ="Not existed";
        } else {
            $result['result'] = "existed";
        }
        echo json_encode($result['result']);
    }

    public function deletenotify($id){
        if($id != '' || $id != 0){
            $chk = $this->common->gettblrowdata(['id'=>$id],'notification_id','tb_notify_management',0,0);
            if($chk){
                $upd = $this->common->updatetbledata('tb_notify_management',['status'=>0],['notification_id'=>$chk['notification_id']]);
                if($upd){
                    echo "1";
                }else{
                    echo "0";
                }
            }else{
                echo "0";
            }
        }
    }

    public function getCustomerNotifydata(){
        $customer_code = $this->input->post('customer_code',TRUE);
        //$_POST['customer_code'] = '123789654';
        $where = [];
        if($this->input->post('customer_id')){
            $where["pm.customer_code"] = $this->input->post('customer_id',TRUE);
        } else {
            $where['pm.customer_code !='] = '';
        }
        if($this->input->post('company_code')){
            $where["pm.company_code"] =$this->input->post('company_code',TRUE);
        }
        if($this->input->post('branch_code')){
            $where["pm.branch_code"] =$this->input->post('branch_code',TRUE);
        }
        if($this->input->post('department_code')){
            $where["pm.department_code"] =$this->input->post('department_code',TRUE);
        }
        $data['customer_data'] = $this->notifymodel->getCustomerNotifydata($where);
        foreach($data['customer_data'] as $custdata){
            $custdata['partytype'] = ucwords($custdata['partytype']);
        }
        echo  json_encode($data['customer_data']);
    }

    public function generateNotifyID(){
        $latestid = $this->notifymodel->getlatestnotifyid();
        $num = substr($latestid, 6)+1;
        $numlength = strlen((string)$num);
        if($numlength == 1){
            $finalid = 'NOTIFY00'.$num;
        } else if($numlength == 2){
            $finalid = 'NOTIFY0'.$num;
        } else {
            $finalid = 'NOTIFY'.$num;
        }
        return $finalid;
    }

    public function getnotificationids(){
        $term = $this->input->post('term',TRUE);
        $list = $this->notifymodel->getnotificationids($term);
        echo json_encode($list);
    }

    public function getcompanies()
    {
        $post = $this->input->post(NULL,TRUE);

        $countryResult = [];
        if(isset($post['query'])){
            $keyword = strval($post['query']);
            $sql = $this->db->query("SELECT company_code FROM tb_company_master 
            WHERE (company_name LIKE ? OR company_code LIKE ?) 
            AND status=? ",["$keyword%","$keyword%",1]);
            if ($sql->num_rows() > 0) {
                foreach($sql->result_array() as $row) {
                    $countryResult[] = $row["company_code"];
                }
            }
        }
        echo json_encode($countryResult);
    }

    public function getcustomers(){
        $post = $this->input->post(NULL,TRUE);
        $custResult = [];
        if(isset($post['query'])){
            $keyword = strval($post['query']);
            $sql = $this->db->query("SELECT code FROM tb_customers WHERE (name LIKE ? OR code LIKE ?)
             AND status=?",["$keyword%","$keyword%",1]);
            if ($sql->num_rows() > 0) {
                foreach($sql->result_array() as $row) {
                    $custResult[] = $row["code"];
                }
            }
        }
        echo json_encode($custResult);
    }

    public function getCustomerslist(){
        $customers = $this->notifymodel->getCustomers($this->input->post('term',TRUE));
        echo json_encode($customers);
    }

    public function getbranches(){
        $branchResult = [];
        if(isset($_POST['query']) && isset($_POST['cmp'])){
            $keyword = strval($_POST['query']);
            $cmp = trim($_POST['cmp']);
            $sql = $this->db->query("SELECT branch_code FROM tb_branch_master WHERE (branch_name LIKE ? OR branch_code LIKE ?) 
            AND company_code=? AND status=1",["$keyword%","$keyword%",$cmp]);
            if ($sql->num_rows() > 0) {
                foreach($sql->result_array() as $row) {
                    $branchResult[] = $row["branch_code"];
                }
            }
        }
        echo json_encode($branchResult);
    }
}
