<?php if(!defined('BASEPATH')) exit('No direct script access allowed');


use App\Generators\RandomString;
use phpseclib\Net\SSH2;
use phpseclib\Net\SFTP;


class Nzmassstatus extends CI_Controller {

    private const  KNLOGIN_EPOD_PATH = "/pub/inbound/D3/FO";
    public function __construct() {

        parent::__construct();

        if($this->session->userdata('user_id') == ''){

            redirect('login');

        }

        $this->load->model(['common','MassStatusModel']);

        $this->load->library("statusintigration");
        $this->load->library("carriercommonedilib");
        $this->load->helper("log_helper");
        $this->load->library("sendpodtoknservice");
        $this->load->library(["tollcarrieredi", 'standard_status_execution']);
        if (!checkUrlAccessForUser('NZMASSSTATUS')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index(){

        $this->massupdate();

    }

    public function massupdate(){

        $data['page_title'] = $this->lang->line('menu_massstsupd');

        $data['sub_title'] = $this->lang->line('general_search');

        $uid = $this->session->userdata("user_id");

        $curtz = $this->session->userdata("usr_tzone")['timezone'];

        $chk_usrtype = $this->session->userdata("business_type");

        $carrierwhr = "";

        if($chk_usrtype == "Carrier"){

            $carrierwhr = " AND o.vendor_id =".$this->session->userdata("id");

        }else{

            $carrierwhr = " AND o.user_id =".$uid;

        }

        $config = array();

        $item = "";

        $post = $this->input->post(null,true);

        // ------New Code------------------------------------//

        if(isset($post['searchsubmit']) || isset($post['order_id'])){

            if(isset($post['searchsubmit'])){

                $item = trim($post['searchsubmit']);

            }else{

                $item = 1;

            }

        }

        if(isset($item) && $item != ""){

            $where1 = '';

            if (isset($post['order_id']) && $post['order_id'] != "") {

                $where1="AND o.order_id LIKE '%".$post['order_id']."%' ";

            }

            if(isset($post['trip_id'])  && $post['trip_id'] != ""){

                $where1 .="AND o.shipmentid LIKE '%".$post['trip_id']."%' ";

            }

            if(isset($post['driver']) && $post['driver'] != ""){

                $where1 .="AND (c.name LIKE '%".$post['driver']."%' OR c.mobile LIKE '%".$post['driver']."%' OR d.name LIKE '%".$post['driver']."%' OR d.contact_num LIKE '%".$post['driver']."%') ";

            }
            if (isset($post['reference']) && !empty($post['reference'])) {
                $ref = $this->MassStatusModel->getOrderRefValues($post['reference']);
                if (!empty($ref)) {
                    foreach ($ref as $result) {
                        $oid[] = $result['order_id'];
                    }
                    $oids = implode(",", $oid);
                    $where1 .= "AND o.id IN ($oids)";
                }else{
                    $where1 = "AND o.id = 0";
                }
            }

            $searchwhr = " $where1";

            $mainqry = "SELECT o.id,o.order_id,o.plat,o.plng,o.dlat,o.dlng,o.shift_id,o.trip_id,o.shipmentid,o.created_source,v.vehicle_id,a.driver_id,a.imei,d.contact_num,d.track_type,d.track_vendor,d.sim_carrier,t.actual_carrier_acceptance FROM tb_orders o LEFT JOIN tb_trips t ON t.id=o.trip_id,tb_shft_veh v,tb_vendors c,tbl_assigned_drivers a,tb_truck_drivers d WHERE o.shift_id=v.shft_id AND v.carrier_id=c.id AND v.vehicle_id=a.vehicle_id AND a.driver_id=d.id AND v.status=1 AND a.status=1 AND d.status='Active' $searchwhr $carrierwhr AND o.status NOT IN (0,3) AND o.shift_id>0 AND o.trip_sts=0 GROUP BY o.order_id ORDER BY o.id DESC";

            $custord1 = $this->db->query($mainqry);

        }elseif(isset($post['searchsubmita']) && $post['searchsubmita'] == "Search") {

            $where1 = '';

            if (isset($post['vehicle']) && $post['vehicle'] != "") {

                $where1= "AND v.register_number LIKE '%".$post['vehicle']."%' ";

            }

            if (isset($post['ref_id']) && $post['ref_id'] != "") {

                $ref = $this->db->query("SELECT order_id FROM tb_order_references WHERE status=1 AND ref_value!='' AND ref_value LIKE '%".$post['ref_id']."%' LIMIT 1");

                if($ref->num_rows()>0){

                    $oid = $ref->row()->order_id;

                    $where1 .= "AND o.id LIKE '%".$oid."%' ";

                }

            }

            $searchwhr = " $where1";

            $mainqry = "SELECT o.id,o.order_id,o.plat,o.plng,o.dlat,o.dlng,o.shift_id,o.trip_id,o.shipmentid,o.created_source,v.vehicle_id,a.driver_id,a.imei,d.contact_num,d.track_type,d.track_vendor,d.sim_carrier,t.actual_carrier_acceptance FROM tb_orders o LEFT JOIN tb_trips t ON t.id=o.trip_id,tb_shft_veh v,tb_vendors c,tbl_assigned_drivers a,tb_truck_drivers d WHERE o.shift_id=v.shft_id AND v.carrier_id=c.id AND v.vehicle_id=a.vehicle_id AND a.driver_id=d.id AND v.status=1 AND a.status=1 AND d.status='Active' $searchwhr $carrierwhr AND o.status NOT IN (0,3) AND o.shift_id>0 AND o.trip_sts=0 GROUP BY o.order_id ORDER BY o.id DESC";

            $custord1 = $this->db->query($mainqry);

        }else{

            $mainqry = "SELECT o.id,o.order_id,o.plat,o.plng,o.dlat,o.dlng,o.shift_id,o.trip_id,o.shipmentid,o.created_source,v.vehicle_id,a.driver_id,a.imei,d.contact_num,d.track_type,d.track_vendor,d.sim_carrier,t.actual_carrier_acceptance FROM tb_orders o LEFT JOIN tb_trips t ON t.id=o.trip_id,tb_shft_veh v,tb_vendors c,tbl_assigned_drivers a,tb_truck_drivers d WHERE o.shift_id=v.shft_id AND v.carrier_id=c.id AND v.vehicle_id=a.vehicle_id AND a.driver_id=d.id AND v.status=1 AND a.status=1 AND d.status='Active' $carrierwhr AND o.status NOT IN (0,3) AND o.shift_id>0 AND o.trip_sts=0 GROUP BY o.order_id ORDER BY o.id DESC";

            $custord1 = $this->db->query($mainqry);

        }

        $ordcount = $custord1->num_rows();

        $config["base_url"] = base_url() . "nzmassstatus/massupdate";

        $config["total_rows"] = $ordcount;

        $config["per_page"] = 10;

        $config["uri_segment"] = 3;

        $config['display_pages'] = TRUE;

        $this->pagination->initialize($config);

        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;

        $mainqry = $mainqry.' LIMIT ' . $page . ',' . $config["per_page"];

        $custord = $this->db->query($mainqry);

        $data['tripsdata'] = array();

        if($custord->num_rows()>0){

            foreach($custord->result() as $res){

                $ship_id = $res->shift_id;

                $tripid = $res->trip_id;

                $vehicle_id = $res->vehicle_id;

                $driver_id = $res->driver_id;

                $contact_num = $res->imei;

                $shipmentid = $res->shipmentid;

                $tracktype = 0; $trackvendor = $simcarrier = $contact_num = "";

                if($res->track_type == 1){

                    $tracktype = 1;

                    $trackvendor = $res->track_vendor;

                    $simcarrier = $res->sim_carrier;

                    $contact_num = $res->contact_num;

                }

                $ordid = $res->id;

                $order_id = $res->order_id;

                $refers = array();

                $ref = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=$ordid AND reference_id IN ('DQ','AAM','AWB','XSR','SD','INN') AND status=1 AND ref_value!='' ");

                if($ref->num_rows()>0){

                    $refers = $ref->result_array();

                }

                $saccept = $sgatein = $spickup = $sgateout = $intransit = $dgatein = $dpickup = $dgateout = 0;

                $s_saccept = $s_sgatein = $s_spickup = $s_sgateout = $s_intransit = $s_dgatein = $s_dpickup = $s_dgateout = 0;

                $s_sacceptcr = $s_sgateincr = $s_spickupcr = $s_sgateoutcr = $s_intransitcr = $s_dgateincr = $s_dpickupcr = $s_dgateoutcr = "";

                $pstpid = $dstpid = $pstodetailid = $dstodetailid = "";

                $chwhr = " AND ts.trip_id=$tripid AND ts.status=1";

                $stopsts = $this->db->query("SELECT sm.id as sid,sm.status_name,ts.id,ts.order_id,ts.stop_id,ts.stop_detail_id,ts.stop_type,ts.status_id,ts.createdon as createdon FROM tb_status_master sm LEFT JOIN tb_stop_status ts ON sm.id=ts.status_id AND ts.order_id=$ordid AND ts.shipment_id=$ship_id $chwhr WHERE sm.id IN(1,2,3,4,10)");

                 if($stopsts->num_rows()>0){

                    foreach($stopsts->result() as $st){

                        if($st->sid == 10){

                            if($st->id != "" && $st->status_id == 10){

                                $pstpid = $st->stop_id;

                                $pstodetailid = $st->stop_detail_id;

                                $saccept = $st->status_id;

                                $s_saccept = 1;

                                $s_sacceptcr = $st->createdon;

                                if($pstpid == "0" || $pstpid == ""){

                                    $sql = "SELECT s.id,e.id as stopdetailsid FROM tb_shiporder_stops s,tb_employee e WHERE s.shipment_id=$ship_id AND s.status=1 AND s.id=e.stop_id AND e.status=1 AND e.shift_id=$ship_id AND e.order_id='".$order_id."' LIMIT 1";

                                    $chkq = $this->db->query($sql);

                                    if($chkq->num_rows()>0){

                                        $pstpid = $chkq->row()->id;

                                        $pstodetailid = $chkq->row()->stopdetailsid;

                                    }

                                }

                            }else{

                                $sql = "SELECT s.id,e.id as stopdetailsid FROM tb_shiporder_stops s,tb_employee e WHERE s.shipment_id=$ship_id AND s.status=1 AND s.id=e.stop_id AND e.status=1 AND e.shift_id=$ship_id AND e.order_id='".$order_id."' LIMIT 1";

                                $chkq = $this->db->query($sql);

                                if($chkq->num_rows()>0){

                                    $pstpid = $chkq->row()->id;

                                    $pstodetailid = $chkq->row()->stopdetailsid;

                                    $saccept = $st->sid;

                                }

                            }

                        }

                        if($st->sid == 2){

                            if($st->id != "" && $st->status_id == 2 && $st->stop_type=="P"){

                                $pstpid = $st->stop_id;

                                $pstodetailid = $st->stop_detail_id;

                                $sgatein = $st->status_id;

                                $s_sgatein = 1;

                                $s_sgateincr = $st->createdon;

                            }else{

                                $sql = "SELECT s.id,e.id as stopdetailsid FROM tb_shiporder_stops s,tb_employee e WHERE s.shipment_id=$ship_id AND s.status=1 AND (s.id=e.stop_id OR s.id=e.drop_stopid) AND e.status=1 AND e.shift_id=$ship_id AND e.order_id='".$order_id."' LIMIT 1";

                                $chkq = $this->db->query($sql);

                                if($chkq->num_rows()>0){

                                    $pstpid = $chkq->row()->id;

                                    $pstodetailid = $chkq->row()->stopdetailsid;

                                    $sgatein = $st->sid;

                                }

                            }

                            if($st->id != "" && $st->status_id == 2 && $st->stop_type=="D"){

                                $dstpid = $st->stop_id;

                                $dstodetailid = $st->stop_detail_id;

                                $dgatein = $st->status_id;

                                $s_dgatein = 1;

                                $s_dgateincr = $st->createdon;

                            }else{

                                $sql = "SELECT s.id,e.id as stopdetailsid FROM tb_shiporder_stops s,tb_employee e WHERE s.shipment_id=$ship_id AND s.status=1 AND s.id=e.drop_stopid AND e.status=1 AND e.shift_id=$ship_id AND e.order_id='".$order_id."' LIMIT 1";

                                $chkq = $this->db->query($sql);

                                if($chkq->num_rows()>0){

                                    $dstpid = $chkq->row()->id;

                                    $dstodetailid = $chkq->row()->stopdetailsid;

                                    $dgatein = $st->sid;

                                }

                            }

                        }

                        if($st->sid == 1){

                            if($st->id != "" && $st->status_id == 1 && $st->stop_type=="P"){

                                $pstpid = $st->stop_id;

                                $pstodetailid = $st->stop_detail_id;

                                $spickup = $st->status_id;

                                $s_spickup = 1;

                                $s_spickupcr = $st->createdon;

                            }else{

                                $sql = "SELECT s.id,e.id as stopdetailsid FROM tb_shiporder_stops s,tb_employee e WHERE s.shipment_id=$ship_id AND s.status=1 AND s.id=e.stop_id AND e.status=1 AND e.shift_id=$ship_id AND e.order_id='".$order_id."' LIMIT 1";

                                $chkq = $this->db->query($sql);

                                if($chkq->num_rows()>0){

                                    $pstpid = $chkq->row()->id;

                                    $pstodetailid = $chkq->row()->stopdetailsid;

                                    $spickup = $st->sid;

                                }

                            }

                            if($st->id != "" && $st->status_id == 1 && $st->stop_type=="D"){

                                $dstpid = $st->stop_id;

                                $dstodetailid = $st->stop_detail_id;

                                $dpickup = $st->status_id;

                                $s_dpickup = 1;

                                $s_dpickupcr = $st->createdon;

                            }else{

                                $sql = "SELECT s.id,e.id as stopdetailsid FROM tb_shiporder_stops s,tb_employee e WHERE s.shipment_id=$ship_id AND s.status=1 AND s.id=e.drop_stopid AND e.status=1 AND e.shift_id=$ship_id AND e.order_id='".$order_id."' LIMIT 1";

                                $chkq = $this->db->query($sql);

                                if($chkq->num_rows()>0){

                                    $dstpid = $chkq->row()->id;

                                    $dstodetailid = $chkq->row()->stopdetailsid;

                                    $dpickup = $st->sid;

                                }

                            }

                        }

                        if($st->sid == 3){

                            if($st->id != "" && $st->status_id == 3 && $st->stop_type=="P"){

                                $pstpid = $st->stop_id;

                                $pstodetailid = $st->stop_detail_id;

                                $sgateout = $st->status_id;

                                $s_sgateout = 1;

                                $s_sgateoutcr = $st->createdon;

                            }else{

                                $sql = "SELECT s.id,e.id as stopdetailsid FROM tb_shiporder_stops s,tb_employee e WHERE s.shipment_id=$ship_id AND s.status=1 AND s.id=e.stop_id AND e.status=1 AND e.shift_id=$ship_id AND e.order_id='".$order_id."' LIMIT 1";

                                $chkq = $this->db->query($sql);

                                if($chkq->num_rows()>0){

                                    $pstpid = $chkq->row()->id;

                                    $pstodetailid = $chkq->row()->stopdetailsid;

                                    $sgateout = $st->sid;

                                }

                            }

                            if($st->id != "" && $st->status_id == 3 && $st->stop_type=="D"){

                                $dstpid = $st->stop_id;

                                $dstodetailid = $st->stop_detail_id;

                                $dgateout = $st->status_id;

                                $s_dgateout = 1;

                                $s_dgateoutcr = $st->createdon;

                            }else{

                                $sql = "SELECT s.id,e.id as stopdetailsid FROM tb_shiporder_stops s,tb_employee e WHERE s.shipment_id=$ship_id AND s.status=1 AND s.id=e.drop_stopid AND e.status=1 AND e.shift_id=$ship_id AND e.order_id='".$order_id."' LIMIT 1";

                                $chkq = $this->db->query($sql);

                                if($chkq->num_rows()>0){

                                    $dstpid = $chkq->row()->id;

                                    $dstodetailid = $chkq->row()->stopdetailsid;

                                    $dgateout = $st->sid;

                                }

                            }

                        }

                        if($st->sid == 4){

                            if($st->id != "" && $st->status_id == 4){

                                $pstpid = $st->stop_id;

                                $pstodetailid = $st->stop_detail_id;

                                $intransit = $st->status_id;

                                $s_intransit = 1;

                                $s_intransitcr = $st->createdon;

                            }else{

                                $sql = "SELECT s.id,e.id as stopdetailsid FROM tb_shiporder_stops s,tb_employee e WHERE s.shipment_id=$ship_id AND s.status=1 AND s.id=e.stop_id AND e.status=1 AND e.shift_id=$ship_id AND e.order_id='".$order_id."' LIMIT 1";

                                $chkq = $this->db->query($sql);

                                if($chkq->num_rows()>0){

                                    $pstpid = $chkq->row()->id;

                                    $pstodetailid = $chkq->row()->stopdetailsid;

                                    $intransit = $st->sid;

                                }

                            }

                        }

                    }

                }else{

                    $sql = "SELECT s.id,s.stoptype,s.ordernumber,e.id as stopdetailsid,s.status FROM tb_shiporder_stops s,tb_employee e WHERE s.shipment_id=$ship_id AND s.status=1 AND s.id=e.stop_id AND e.status=1 AND e.shift_id=$ship_id AND e.order_id='".$order_id."' UNION SELECT s.id,s.stoptype,s.ordernumber,e.id as stopdetailsid,s.status FROM tb_shiporder_stops s,tb_employee e WHERE s.shipment_id=$ship_id AND s.status=1 AND s.id=e.drop_stopid AND e.status=1 AND e.shift_id=$ship_id AND e.order_id='".$order_id."' ORDER BY ordernumber ASC ";

                    $emp = $this->db->query($sql);

                    if($emp->num_rows() > 0){

                        foreach($emp->result_array() as $res1){

                            if($res1['stoptype'] == "P" || $res1['stoptype'] == ""){

                                $saccept = 10;

                                $sgatein = 2;

                                $spickup = 1;

                                $sgateout = 3;

                                $intransit = 4;

                                $pstpid = $res1['id'];

                                $pstodetailid = $res1['stopdetailsid'];

                            }

                            if($res1['stoptype'] == "D"){

                                $dgatein = 2;

                                $dpickup = 1;

                                $dgateout = 3;

                                $dstpid = $res1['id'];

                                $dstodetailid = $res1['stopdetailsid'];

                            }

                        }

                    }

                }

                $created_source = $res->created_source;

                if($created_source == ""){

                    $created_source = 1;

                }
                if($dstpid == ""){
                    $dstpid = 0;
                }
                if($pstpid == ""){
                    $pstpid = 0;
                }
                if($pstodetailid == ""){
                    $pstodetailid = 0;
                }
                if($dstodetailid == ""){
                    $dstodetailid = 0;
                }

                $data['tripsdata'][] = ["trip_id"=>$tripid,"ship_id"=>$ship_id,"ord_id"=>$ordid,"shipmentid"=>$shipmentid,"order_id"=>$res->order_id,"refers"=>$refers,"saccept"=>$saccept,"sgatein"=>$sgatein,"spickup"=>$spickup,"sgateout"=>$sgateout,"intransit"=>$intransit,"dgatein"=>$dgatein,"dpickup"=>$dpickup,"dgateout"=>$dgateout,"s_saccept"=>$s_saccept,"s_sgatein"=>$s_sgatein,"s_spickup"=>$s_spickup,"s_sgateout"=>$s_sgateout,"s_intransit"=>$s_intransit,"s_dgatein"=>$s_dgatein,"s_dpickup"=>$s_dpickup,"s_dgateout"=>$s_dgateout,"s_sacceptcr"=>$s_sacceptcr,"s_sgateincr"=>$s_sgateincr,"s_spickupcr"=>$s_spickupcr,"s_sgateoutcr"=>$s_sgateoutcr,"s_intransitcr"=>$s_intransitcr,"s_dgateincr"=>$s_dgateincr,"s_dpickupcr"=>$s_dpickupcr,"s_dgateoutcr"=>$s_dgateoutcr,"pstpid"=>$pstpid,"dstpid"=>$dstpid,"pstodetailid"=>$pstodetailid,"dstodetailid"=>$dstodetailid,"vehicle_id"=>$vehicle_id,"driver_id"=>$driver_id,"tracktype"=>$tracktype,"trackvendor"=>$trackvendor,"simcarrier"=>$simcarrier,"contact_num"=>$contact_num,"plat"=>$res->plat,"plng"=>$res->plng,"dlat"=>$res->dlat,"dlng"=>$res->dlng,"created_source"=>$created_source,"actual_carrier_acceptance"=>$res->actual_carrier_acceptance];

            }

        }

        $data['postdata'] = $post;


        $this->newtemplate->dashboard("admin/nzmassstatus", $data);

    }

    public function update_order_status(){



        $arr = array();

        $trip_id = $arr['trip'] = $this->input->post("trip_id",true);

        $ship_id = $arr['ship'] = $this->input->post("ship_id",true);

        $ord_id = $arr['ord_id'] = $this->input->post("ord_id",true);

        $orderid = $arr['orderid'] = $this->input->post("orderid",true);

        $stopid = $arr['stopid'] = $this->input->post("stopid",true);

        $stopdetailid = $arr['stopdetailid'] = $this->input->post("stopdetid",true);

        $vehicle_id = $arr['vehicle_id'] = $this->input->post("vehicle_id",true);

        $driver_id = $arr['driver_id'] = $this->input->post("driver_id",true);

        $tracktype = $arr['tracktype'] = $this->input->post("tracktype",true);

        $trackvendor = $arr['trackvendor'] = $this->input->post("trackvendor",true);

        $contact_num = $arr['contact_num'] = $this->input->post("contact_num",true);

        $stype = $arr['stop_type'] =  $this->input->post("stop_type",true);

        $stsid = $arr['stsid'] = $this->input->post("stsid",true);

        $sts = $arr['status'] =   $this->input->post("status",true);

        $curtz = $arr['timezone'] =  $this->session->userdata("usr_tzone")['timezone'];

        $seldt = $stsdate = $this->input->post("sts_date",true);

        if(checkstsvaliddate($seldt)){

            $gentime = getdatetimebytimezone(DFLT_TZ,$seldt,$curtz);

            $stsdate = $gentime['datetime'];

        }else{

            $stsdate = "";

        }
        $company_code = $this->session->userdata('company_code');
        $arr['sts_date'] = $stsdate;
        $logdate = date('Y-m-d H:i:s');

        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);

        $curdt = $getactual['datetime'];

        $hrs = $this->session->userdata("usr_tzone")['hrs'];

        $lgusrid = $this->session->userdata("user_id");

        $latitude = $longitude = "";

        $createdsource = $this->input->post("created_source",true);

        $plat = $arr['plat'] = $this->input->post("plat",true);

        $plng = $arr['plng'] = $this->input->post("plng",true);

        $dlat = $arr['dlat'] = $this->input->post("dlat",true);

        $dlng = $arr['dlng'] = $this->input->post("dlng",true);

        if($plat == "" || $plng == ""){

            $chklatlng = $this->db->select("latitude,longitude")->get_where("tb_site_settings",array("user_id"=>$lgusrid),1,0);

            if($chklatlng->num_rows()>0){

                $plat = $chklatlng->row()->latitude;

                $plng = $chklatlng->row()->longitude;

            }

        }

        if($dlat == "" || $dlng == ""){

            $chklatlng = $this->db->select("latitude,longitude")->get_where("tb_site_settings",array("user_id"=>$lgusrid),1,0);

            if($chklatlng->num_rows()>0){

                $dlat = $chklatlng->row()->latitude;

                $dlng = $chklatlng->row()->longitude;

            }

        }
        $resultsts = 2;
        if($stsdate != "" && $sts == "0"){
            if ($vehicle_id > 0) {
                $this->common->updatetbledata("tb_trucks_data", ['latitude' => $stype === 'D' ? $dlat : $plat, 'longitude' => $stype === 'D' ? $dlng : $plng, 'receivedon' => $stsdate], ['id' => $vehicle_id]);
            }
            $stid = $stsid;

            if($stsid == "10"){ $stcode = "0212"; }

            if($stsid == "2" && $stype == "P"){ $stcode = "0420"; }

            if($stsid == "1" && $stype == "P"){ $stcode = "0500"; }

            if($stsid == "3" && $stype == "P"){ $stcode = "0191"; }

            if($stsid == "4"){ $stcode = "1550"; }

            if($stsid == "2" && $stype == "D"){ $stcode = "0192"; }

            if($stsid == "1" && $stype == "D"){ $stcode = "2300"; }

            if($stsid == "3" && $stype == "D"){ $stcode = "3000"; }

            if($stsid == "11"){ $stcode = "0218"; }
            $arr['status_code'] = $stcode;
            $chkcs = $this->db->select("trip_id")->get_where("tb_orders",array("id"=>$ord_id),1,0);

            if($chkcs->num_rows()>0){

                $arr['trip'] = $chkcs->row()->trip_id;

            }

            if($stsid == "10" && $arr['trip'] == "0"){

                $stcode = "0212";

                /*start trip*/

                $chqry = $this->db->select("id")->get_where("tb_trips",array('shift_id'=>$arr['ship'],'vehicle_id'=>$arr['vehicle_id'], 'driver_id'=>$arr['driver_id']),1,0);

                if($chqry->num_rows() == 0){

                    if($arr['contact_num'] == ""){

                        $newimei = $this->db->select("imei")->get_where("tbl_assigned_drivers",array('vehicle_id'=>$arr['vehicle_id'],'driver_id'=>$arr['driver_id'],'status'=>1),1,0);

                        if($newimei->num_rows()>0){

                            $arr['contact_num'] = $newimei->row()->imei;

                        }

                    }

                    $latitude = $plat;

                    $longitude = $plng;

                    $triparr = array('shift_id'=>$arr['ship'], 'vehicle_id'=>$arr['vehicle_id'], 'driver_id'=>$arr['driver_id'], 'stime'=>$stsdate, 'start_imei'=>$arr['contact_num'], 'splace'=>"", 'eplace'=>"", 'start_reading'=>0, 'end_reading'=>0, 'created_on'=>$stsdate, 'updated_on'=>$curdt, 'status'=>1, 'trip_type'=>0, 'transit_status'=>0,"plat"=>$latitude,"plng"=>$longitude);

                    $arr['trip'] = $this->common->insertTableData('tb_trips', $triparr);

                    $insarry = array("order_id"=>$arr['ord_id'],"shipment_id"=>$arr['ship'],"stop_id"=>0,"stop_detail_id"=>0,"stop_type"=>"","trip_id"=>$arr['trip'],"status_id"=>$stid,"latitude"=>$latitude,"longitude"=>$longitude,"status"=>1,"reason"=>"From Admin","vehicle_id"=>$arr['vehicle_id'],"driver_id"=>$arr['driver_id'],"status_code"=>$stcode,"createdon"=>$stsdate);

                    $ins = $this->db->insert("tb_stop_status",$insarry);

                    /* update orders table */

                    $ordwhr = array("shift_id"=>$arr['ship']);

                    $ordset = array("trip_id"=>$arr['trip']);

                    $upd = $this->db->set($ordset)->where($ordwhr)->update("tb_orders");

                    $postdata = array(

                        "shipment_id" => $arr['ship'],

                        "trip_id"     => $arr['trip'],

                        "driver_id"   => $arr['driver_id'],

                        "vehicle_id"  => $arr['vehicle_id'],

                        "order_id"    => $arr['orderid'],

                        "user_id"    => $lgusrid,

                        "stop_id"     => '',

                        "latitude"    => $latitude,

                        "longitude"   => $longitude,

                        "curtz"   => $curtz,

                        "hrs" => $hrs,

                        "web"  => $seldt

                    );



                    /*send to roadlog*/

                    if($createdsource == "18"){

                        $sts = $this->statusintigration->roadlogshipmentconfirm($postdata);

                    }else if($createdsource == "5"){

                        $sts = $this->statusintigration->salogshipmentstatus($postdata);

                    }
                    $this->sendnotify('driver_accept',$arr['ord_id']);
                    /* send notify mail to admin */

                    /*if($lgusrid == "12"){

                        $sndmail = $this->loadconfirmmail($postdata);

                    }*/
                     if ($company_code == "NZKN"){
                        $chkven = $this->db->select("vendor_id")->get_where("tb_shifts",array("id"=>$arr['ship']),1,0);
                        if ($chkven->num_rows() > 0) {
                            $vendor_id = $chkven->row()->vendor_id;
                            $getvendorname = $this->db->select("name")->get_where("tb_vendors",['id' => $vendor_id, 'name' => 'BASCIK TRANSPORT']);
                            if ($getvendorname->num_rows() > 0) {
                                $this->load->helper('nz_edis_helper');
                                bascikedi_call($arr['ship']); // Shift_id
                            }

							$gettilvendorname = $this->db->select("name")->get_where("tb_vendors", ['id' => $vendor_id, 'name' => 'TIL']);
                            if ($gettilvendorname->num_rows() > 0){
                                $gettilfile = $this->tiledicall($arr['ship']);
                            }

							$gettollvendorname = $this->db->select("name")->get_where("tb_vendors", ['id' => $vendor_id, 'name' => 'TOLL NETWORKS (NZ) LTD']);
                            if ($gettollvendorname->num_rows() > 0) {
								$getTOLLfile = $this->tollcarrieredi->shipmentdata($arr['ship']);
                            }

                            if (checkAccessConditions('CHECK_ALTOVA_NZ_CARRIERS', $vendor_id)) {
                                $carrierStatus = $this->carriercommonedilib->shipmentdata($arr['ship']);
                            }
                        }
                    }

                }
                $checkStatus = "RELATED_2_" . $company_code . "_CONSIGNEE_NOTIFICATION_STATUSES";
                if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $company_code) && checkAccessConditions($checkStatus, $stcode)) {
                    $this->load->library('notifytrigger');
                    $this->notifytrigger->sendNotificationToConsignee($arr['ord_id'], $stcode);
                }
                $resultsts = 1;

            }else if($arr['trip'] != "0" && $stid != "11"){

                $chqry = $this->db->select("id")->get_where("tb_stop_status",array("order_id"=>$arr['ord_id'],"shipment_id"=>$arr['ship'],"stop_id"=>$stopid,"stop_detail_id"=>$stopdetailid,"stop_type"=>$stype,"trip_id"=>$arr['trip'],"status_id"=>$stid),1,0);

                if($chqry->num_rows() == 0){

                    if($stid == "2" && $stype == "P"){

                        $ttdata = array("id"=>$arr['trip']);

                        $data2["updated_on"] = $curdt;

                        $data2["transit_status"] = '1';

                        $res = $this->db->set($data2)->where($ttdata)->update("tb_trips");

                    }

                    if($stype == "P" || $stid == "4"){

                        $latitude = $plat;

                        $longitude = $plng;

                    }

                    if($stype == "D"){

                        $latitude = $dlat;

                        $longitude = $dlng;

                    }

                    $insarry = array("order_id"=>$arr['ord_id'],"shipment_id"=>$arr['ship'],"stop_id"=>$stopid,"stop_detail_id"=>$stopdetailid,"stop_type"=>$stype,"trip_id"=>$arr['trip'],"status_id"=>$stid,"latitude"=>$latitude,"longitude"=>$longitude,"status"=>1,"reason"=>"From Admin","vehicle_id"=>$arr['vehicle_id'],"driver_id"=>$arr['driver_id'],"status_code"=>$stcode,"createdon"=>$stsdate);

                    $ins = $this->db->insert("tb_stop_status",$insarry);

                    $chqry1 = $this->db->select("id")->get_where("tb_trip_employee",array("employee_id"=>$stopdetailid,"stop_id"=>$stopid,"trip_id"=>$arr['trip'],"status"=>1),1,0);

                    if($chqry1->num_rows() == 0){

                        $insarr = array("employee_id"=>$stopdetailid,"stop_id"=>$stopid,"trip_id"=>$arr['trip'],"status"=>1, 'driver_late'=>0, 'emp_late'=>0, 'stime'=>$curdt, 'check_in'=>$curdt, 'absent_reason'=>'Closed', 'created_on'=>$curdt, 'updated_on'=>$curdt, 'pd_status'=>1);

                        $ins = $this->db->insert("tb_trip_employee",$insarr);

                    }

                    $postdata = [
                        "shipment_id" => $arr['ship'],
                        "trip_id"     => $arr['trip'],
                        "driver_id"   => $arr['driver_id'],
                        "stop_id"     => $stopid,
                        "order_id"    => $arr['orderid'],
                        "inc_id"      => 0,
                        "pod_type"    => '',
                        "latitude"    => $latitude,
                        "longitude"   => $longitude,
                        "stop_type" => $stype,
                        "vehicle_id" => $arr['vehicle_id'],
                        "curtz" => $curtz,
                        "hrs" => $hrs,
                        "web"  => $seldt,
                        "status_code"  => $stcode,
                        "ord_id"  => $arr['ord_id']
                    ];

                    if($createdsource == "18"){

                        if($stid == "4"){



                            $sts = $this->statusintigration->roadlogshipmentintransit($postdata);

                        }

                        if($stid == "2" && $stype == "P"){



                            $sts = $this->statusintigration->roadlogshipmentpgatein($postdata);

                        }

                        if($stid == "1" && $stype == "P"){



                            $sts = $this->statusintigration->roadlogshipmentpicked($postdata);
                            $this->sendnotify('pickup_note',$arr['ord_id']);
                        }

                        if($stid == "3" && $stype == "P"){

                            /*send to roadlog*/

                            $sts = $this->statusintigration->roadlogshipmentpgateout($postdata);

                        }

                        if($stid == "2" && $stype == "D"){



                            $sts = $this->statusintigration->roadlogshipmentdgatein($postdata);

                        }

                        if($stid == "1" && $stype == "D"){

                            /*send to roadlog*/

                            $sts = $this->statusintigration->roadlogshipmentdelivered($postdata);
                            $this->sendnotify('delivery_note',$arr['ord_id']);
                        }

                    }else if($createdsource == "5"){
                        if($stid == "1" && $stype == "P"){
                            $sts = $this->statusintigration->salogshipmentstatus($postdata);
                        }
                        if($stid == "1" && $stype == "D"){

                            $sts = $this->statusintigration->salogshipmentstatus($postdata);
                            $this->sendnotify('delivery_note',$arr['ord_id']);

                        }
                        if($stid == "3" && $stype == "P"){
                            $sts = $this->sendEPOPGateoutNotify($postdata);
                        }
                    }

                    if($stid == "3" && $stype == "D"){

                        if($createdsource == "5"){

                            $sts = $this->statusintigration->salogshipmentstatus($postdata);

                        }
                        if($createdsource == "18" || $createdsource == "5") {
                            $sts = $this->sendEPODGateoutNotify($postdata);
                        }
                    }

                    $resultsts = 1;

                }
                $checkStatus = "RELATED_2_" . $company_code . "_CONSIGNEE_NOTIFICATION_STATUSES";
                if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $company_code) && checkAccessConditions($checkStatus, $stcode)) {
                    $this->load->library('notifytrigger');
                    $this->notifytrigger->sendNotificationToConsignee($arr['ord_id'], $stcode);
                }

            }else if($stsid == "11" && $arr['trip'] != 0 && $arr['trip'] != ""){

                $latitude = $dlat;

                $longitude = $dlng;

                $postdata = array(

                    "shipment_id" => $arr['ship'],

                    "trip_id"     => $arr['trip'],

                    "driver_id"   => $arr["driver_id"],

                    "stop_id"     => '',

                    "order_id"    => $arr['orderid'],

                    "latitude"    => $latitude,

                    "longitude"   => $longitude,

                    "curtz"   => $curtz,

                    "hrs" => $hrs,

                    "web"  => $seldt

                );
                /*send to roadlog*/

                if($createdsource == "18"){

                    $sts = $this->statusintigration->roadlogshipmenttripdelivered($postdata);

                }

                $chkmuliti = $this->db->select("id")->get_where("tb_orders",array("shift_id"=>$arr['ship'],"trip_sts"=>'0'));

                if($chkmuliti->num_rows()>1){

                    $upd = $this->db->where(array("id"=>$ord_id,"trip_id !="=>0))->update("tb_orders",array("trip_sts"=>'1'));

                }else{

                    $updwhr  = array("id" => $arr['ship']);

                    $upddata = array("status" => '0', "updated_on" => $curdt);

                    $upd = $this->db->set($upddata)->where($updwhr)->update("tb_shifts");

                    $data1 = array();

                    $tdata = array("id"=>$arr['trip']);

                    $data1["end_imei"] = $arr['contact_num'];

                    $data1["end_reading"] = '0';

                    $data1["etime"] = $data1["updated_on"] = $curdt;

                    $data1["status"] = '0';

                    $data1["transit_status"] = '1';

                    $res = $this->db->set($data1)->where($tdata)->update("tb_trips");

                    if ($arr['ship'] > 0) {
                        $upd = $this->db->where(["shift_id" => $arr['ship']])->update("tb_orders", ["trip_sts" => '1']);
                    }

                    $gensum = $this->generatesummary($arr['trip'],$curtz);

                }

                $resultsts = 1;

            }
            try {
                $this->standard_status_execution->sendStandardXMLtoAltova($arr);
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
            }

        }

        echo $resultsts;

    }

    public function sendEPODGateoutNotify($postdata){
        //("error","pod".json_encode($postdata));
        $sdtref = getsdtreforder($postdata['ord_id']);
        if($sdtref == "DEL" || $sdtref == ""){
            $order_id = $postdata['order_id'];
            $ship_id = $postdata['shipment_id'];
            $trip_id = $postdata['trip_id'];
            $stop_id = $postdata['stop_id'];
            $driver_id = $postdata['driver_id'];
            $vehicle_id = $postdata['vehicle_id'];
            $curtz = $postdata['curtz'];
            $chkcust = $this->db->query("SELECT o.id,o.order_id,o.pickup_company,o.pickup_country,o.pickup_city,
            o.pickup_pincode, o.pickup_address1,o.delivery_company,o.delivery_country,o.delivery_city,
            o.delivery_pincode,o.delivery_address1, o.quantity,o.weight,o.volume,o.customer_id,o.user_id,
            o.created_source,c.name,c.gcm_id,c.company_code, c.branch_code,c.phone,c.code
            FROM tb_orders o,tb_customers c WHERE o.customer_id=c.id AND o.id='".$postdata['ord_id']."' LIMIT 1");
            if($chkcust->num_rows()>0){
                $ordid = $chkcust->row()->id;
                $user_id = $chkcust->row()->user_id;
                $company_code = $chkcust->row()->company_code;
                $branch_code = $chkcust->row()->branch_code;
                $createdsource = $chkcust->row()->created_source;
                $custcid = $chkcust->row()->phone;
                $custcode = $chkcust->row()->code;
                $order_id = $chkcust->row()->order_id;
                $pickup_company = $chkcust->row()->pickup_company;
                $pickup_country = $chkcust->row()->pickup_country;
                $pickup_city = $chkcust->row()->pickup_city;
                $pickup_pincode = $chkcust->row()->pickup_pincode;
                $pickup_address1 = $chkcust->row()->pickup_address1;
                $delivery_company = $chkcust->row()->delivery_company;
                $delivery_country = $chkcust->row()->delivery_country;
                $delivery_city = $chkcust->row()->delivery_city;
                $delivery_pincode = $chkcust->row()->delivery_pincode;
                $delivery_address1 = $chkcust->row()->delivery_address1;
                $quantity = $chkcust->row()->quantity;
                $weight = $chkcust->row()->weight;
                $volume = $chkcust->row()->volume;
                $chkadminusr = $this->db->query("SELECT name,emailid,cc_mails FROM tb_users WHERE id='$user_id' AND emailid!='' LIMIT 1");
                if($chkadminusr->num_rows()>0){
                    $receivename = $chkadminusr->row()->name;
                    $receivemail = $chkadminusr->row()->emailid;
                    $ccmail = array();
                    if($chkadminusr->row()->cc_mails != ""){
                        $ccmail[] = $chkadminusr->row()->cc_mails;
                    }
                    $data['order'] = array("order_id"=>$order_id,"pickup_company"=>$pickup_company,"pickup_country"=>$pickup_country,"pickup_city"=>$pickup_city,"pickup_pincode"=>$pickup_pincode,"pickup_address1"=>$pickup_address1,"delivery_company"=>$delivery_company,"delivery_country"=>$delivery_country,"delivery_city"=>$delivery_city,"delivery_pincode"=>$delivery_pincode,"delivery_address1"=>$delivery_address1,"quantity"=>$quantity,"weight"=>$weight,"volume"=>$volume);
                    $data['userid'] = $user_id;
                    $epodpath = "./assets/trippods/RL".$order_id.".pdf";
                    $data["pod"] = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,'".$curtz."') as createdon, ts.imgpath, ts.hash, e.order_id from tb_pod_uploads ts INNER JOIN tb_document_types dt ON dt.id=ts.doc_type AND dt.type_name != 'PUP' LEFT JOIN tb_employee e ON e.id = ts.stop_detail_id WHERE ts.order_id = '".$ordid."' AND ts.status=1 GROUP BY ts.id ORDER BY ts.createdon ASC");
                    /* get all order references in single row*/
                    $data["orderref"] = $this->common->getallorderreferences($ordid);
                    $this->load->library('m_pdf');
                    $sub = "svkonekt::Shipment ePOD & Milestone Status #".$order_id." ";
                    $data['page_title'] = "Trip ePOD";
                    $data['receivemail'] = $receivemail;
                    $data['receivename'] = $receivename;
                    $chkref = "XSR";
                    $whrin = " AND reference_id in('XSR','SD') ";
                    $chkordtypeqry = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=$ordid $whrin AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1");
                    $refvalue = $newsub = $orderDepartmentCode = "";
                    $iofeof = "EOF";
                    if($chkordtypeqry->num_rows()>1){
                        $refs = array();
                        foreach($chkordtypeqry->result() as $oref){
                            $refs[] = $oref->ref_value;
                            if($oref->reference_id == "XSR"){
                                $refvalue = $oref->ref_value;
                            }
                            if($oref->reference_id == "SD" && $oref->ref_value == "2"){
                                $iofeof = "IOF";
                            }
                        }
                        $newsub = $refvalue."#746#".$iofeof;
                        $sub .= $chkref.":".$refvalue."#746#".$iofeof."";
                        $chkparty = "SELECT emailid,party_name FROM tb_contact_notifys WHERE status=1 AND (pod_note=1 OR all_note=1) GROUP BY emailid";
                        $query = $this->db->query($chkparty);
                        if($query->num_rows()>0){
                            foreach($query->result() as $pmails){
                                $ccmail[] = $pmails->emailid;
                            }
                        }
                    }
                    $newsub = ($newsub == "") ? $sub : $newsub;
                    $data['mailtype'] = "ePOD";
                    $data['stops'] = [];
                    $data['pickup_datetime'] = $data['delivery_datetime'] = "";
                    $stops = $this->db->query("SELECT ss.stop_type,ss.status_id,ss.latitude,ss.longitude,convertToClientTZ(ss.createdon,'".$curtz."') as createdon,sm.status_name,t.register_number,d.name from tb_stop_status ss LEFT JOIN tb_status_master sm ON sm.id=ss.status_id LEFT JOIN tb_trucks_data t ON ss.vehicle_id=t.id LEFT JOIN tb_truck_drivers d ON ss.driver_id=d.id WHERE ss.shipment_id=".$ship_id." AND ss.status='1' ORDER BY ss.createdon ASC");
                    if($stops->num_rows()>0){
                        foreach($stops->result() as $sres){
                            $stsname = $sres->status_name;
                            if($sres->status_id=="2" && $sres->stop_type == "P"){
                                $stsname = "Pickup Gate In";
                            }
                            if($sres->status_id=="1" && $sres->stop_type == "P"){
                                $data['pickup_datetime'] = $sres->createdon;
                                $stsname = "Pickup Done";
                            }
                            if($sres->status_id=="3" && $sres->stop_type == "P"){
                                $stsname = "Pickup Gate Out";
                            }
                            if($sres->status_id=="2" && $sres->stop_type == "D"){
                                $stsname = "Delivery Gate In";
                            }
                            if($sres->status_id=="1" && $sres->stop_type == "D"){
                                $data['delivery_datetime'] = $sres->createdon;
                                $stsname = "Delivery Done";
                            }
                            if($sres->status_id=="3" && $sres->stop_type == "D"){
                                $stsname = "Delivery Gate Out";
                            }
                            $locname = "";
                            if($sres->latitude != ""){
                                $locname = getLocationName($sres->latitude,$sres->longitude);
                            }
                            $data["stops"][] = array("datetime"=>$sres->createdon,"status"=>$stsname,"truck_no"=>$sres->register_number,"driver"=>$sres->name,"location"=>$locname);
                        }
                    }
                    $html = $this->load->view('settings/bulkepod',$data,true);
                    $chk = @$this->m_pdf->pdf->WriteHTML($html);
                    $chk = @$this->m_pdf->pdf->Output($epodpath,"F");
                    $unique_id = "RL".$order_id.".".date("Ymd").".".date("his");
                    $pagescnt = $this->m_pdf->pdf->pages;
                    $pages = count($pagescnt);
                    if($createdsource == 5){ /* SALog JPL*/
                        $chkordtypeqry1 = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=$ordid AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1");
                        $bn = $inn = $iv = $dq = $cmp = $brn = "";
                        if($chkordtypeqry1->num_rows()>1){
                            foreach($chkordtypeqry1->result() as $oref1){
                                if($oref1->reference_id == "BN"){
                                    $bn = $oref1->ref_value;
                                }if($oref1->reference_id == "INN"){
                                    $inn = $oref1->ref_value;
                                }
                                if($oref1->reference_id == "DQ"){
                                    $dq = $oref1->ref_value;
                                }if($oref1->reference_id == "CMP"){
                                    $cmp = $oref1->ref_value;
                                }if($oref1->reference_id == "BRN"){
                                    $brn = $oref1->ref_value;
                                }
                            }
                        }
                        /*get department code for this order*/
                        $departmentCode = $this->common->gettblrowdata(['order_row_id'=>$ordid],"department_code","tb_order_details",0,0);
                        if(!empty($departmentCode)){
                            $orderDepartmentCode = $departmentCode['department_code'];
                        }
                        $cmp = ($cmp == "") ? $company_code : $cmp;
                        $brn = ($brn == "") ? $branch_code : $brn;
                        $countrycode = substr($company_code,0,-2);
                        $randomstr = RandomString::generate(10);
                        $jplData = [
                            "country"=>$cmp,
                            "branch"=>$brn,
                            "order_id"=>$order_id,
                            "time"=>date("hi"),
                            "unique_id"=>$unique_id,
                            "date"=>date("d.m.Y"),
                            "pages"=>$pages,
                            "xsr"=>$refvalue,
                            "sd"=>$orderDepartmentCode,
                            "bn"=>$bn,
                            "inn"=>$inn,
                            "iv"=>$iv,
                            "dq"=>$dq,
                            "custcid"=>$custcid,
                            "custcode"=>$custcode,
                            "countrycode"=>$countrycode,
                            "randomstr"=>$randomstr,
                            "doctype"=>746
                        ];
                        $jplFilePath = $this->saveSalogJPF($jplData);
                        $storeftipjpl = $this->uploadSalogKNFile($jplFilePath);
                        $storeftippdf = $this->uploadSalogKNFile($epodpath);
                    }else{
                        /*send ePOD to KNLogin*/
                        $jplData = [
                            "country"=>substr($company_code,0,-2),
                            "branch"=>substr($branch_code,2),
                            "order_id"=>$order_id,
                            "time"=>date("hi"),
                            "unique_id"=>$unique_id,
                            "date"=>date("d.m.Y"),
                            "pages"=>$pages
                        ];
                        $jplFilePath = $this->sendpodtoknservice->saveJPF($jplData);
                        $this->sendpodtoknservice->uploadKNFile($jplFilePath);
                        $this->sendpodtoknservice->uploadKNFile($epodpath);
                        $body = $this->load->view('mail_forms/deliveredshipment', $data, true);
                        $this->load->library('email');
                        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                        $this->email->to($receivemail, $receivename);
                        if(!empty($ccmail)){
                            $ccmail = array_unique($ccmail);
                            $cc_mail = implode(", ",$ccmail);
                            $cc_mail = '"'.$cc_mail.'"';
                            $this->email->cc($cc_mail);
                        }
                        $this->email->subject($newsub);
                        $this->email->set_mailtype("html");

                        $fileName = "RL".$order_id.".pdf";
                        $epodpath = sprintf('%s/assets/trippods/%s', FCPATH, $fileName);
                        $this->email->message($body);
                        $this->email->attach($epodpath);
                        $sendMailWithEpod = $this->email->send();
                    }
                }
            }
        }
    }

    public function generatesummary($tripid = null,$curtz = null)

    {

        if ($tripid != "") {

            $dist =  $trip_type =  $totalemp  = $uid = 0;

            if($curtz == ""){ $curtz = date_default_timezone_get(); }

            $logdate = date('Y-m-d H:i:s');

            $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);

            $curdt = $getactual['datetime'];

            $reg = "";

            $sql = $this->db->query("SELECT shift_id,vehicle_id,driver_id,convertToClientTZ(stime,'".$curtz."') as stime,convertToClientTZ(etime,'".$curtz."') as etime,etime as tetime, start_imei, end_imei, start_reading,end_reading,trip_type,plat,plng FROM tb_trips WHERE id=$tripid AND status=0 LIMIT 1");

            if ($sql->num_rows() > 0) {

                $data = array();

                $data['driver_name'] = $data['driver_num'] = "";

                $shift = $sql->row()->shift_id;

                $sql1 = $this->db->query("SELECT user_id,stime as setime,convertToClientTZ(startdate,'".$curtz."') as startdate, convertToClientTZ(enddate,'".$curtz."') as enddate,splace,eplace,elat,elng FROM tb_shifts WHERE id=".$shift." LIMIT 1");

                $data["trip"] = $sql1->row();

                $emp1 = $this->db->query("select e.name,convertToClientTZ(te.stime,'".$curtz."') as in_time,te.status as emp_status,te.driver_late,te.emp_late,te.absent_reason,m.material,e.shipment_volume,e.shipment_weight,e.order_id from tb_employee e,tb_trip_employee te,tb_materials m WHERE te.employee_id=e.id AND m.id=e.material_id AND te.trip_id=".$tripid);

                $emp = $this->db->query("SELECT IFNULL(SUM(IF(e.status='1',1,0)),0) AS attcnt, count(e.employee_id) AS totcnt FROM  tb_trip_employee e WHERE e.trip_id=" . $tripid);

                $start          = $sql->row()->stime;

                $end            = $sql->row()->etime;

                $imei           = $sql->row()->start_imei;

                $eimei          = $sql->row()->end_imei;

                $driverid       = $sql->row()->driver_id;

                $vehicleid      = $sql->row()->vehicle_id;

                $stime          = $sql1->row()->startdate;

                $etime          = $sql1->row()->enddate;

                $uid = $sql1->row()->user_id;

                $odometer_start = trim($sql->row()->start_reading);

                $odometer_end   = trim($sql->row()->end_reading);

                $trip_type      = $sql->row()->trip_type;

                $vendor_id = 0;

                $dlat = $dlng = "";

                $trucks_query = $this->db->query("select truck_capacity,register_number,vendor_id,truck_weight,truck_volume,latitude,longitude from tb_trucks_data WHERE id=$vehicleid LIMIT 1");

                $cab_capacity = $truck_weight = $truck_volume = 0;

                if($trucks_query->num_rows() > 0){

                    $cab_capacity = $trucks_query->row()->truck_capacity;

                    $reg = $trucks_query->row()->register_number;

                    $vendor_id = $trucks_query->row()->vendor_id;

                    $truck_weight = $trucks_query->row()->truck_weight;

                    $truck_volume = $trucks_query->row()->truck_volume;

                    $dlat = $trucks_query->row()->latitude;

                    $dlng = $trucks_query->row()->longitude;

                }

                if($dlat == ""){

                    $dlat = $sql->row()->plat;

                    $dlng = $sql->row()->plng;

                }

                if($dlat == $sql->row()->plat){

                    $dlat = $sql1->row()->elat;

                    $dlng = $sql1->row()->elng;

                }

                /*update end lat lng in trips*/

                $whrtrip = array("id"=>$tripid);

                $settrip = array("dlat"=>$dlat,"dlng"=>$dlng);

                $upd = $this->db->where($whrtrip)->update("tb_trips",$settrip);

                $vtripinfo = array("plat"=>$sql->row()->plat,"plng"=>$sql->row()->plng,"dlat"=>$dlat,"dlng"=>$dlng);

                $data['tripinfo'] = (Object)$vtripinfo;

                if($cab_capacity == ""){

                    $cab_capacity = 0;

                }

                $regg = $this->db->query("select name,contact_num,vendor_id from tb_truck_drivers WHERE id=$driverid LIMIT 1");

                if ($regg->num_rows() > 0) {

                    $data['driver_name'] = $regg->row()->name;

                    $data['driver_num']  = $regg->row()->contact_num;

                    $vnid = $regg->row()->vendor_id;

                    if($vendor_id == 0 && $vnid != 0){

                        $vendor_id  = $vnid;

                    }

                }

                $sql2 = $this->db->query("select latitude,longitude,convertToClientTZ(`timestamp`,'".$curtz."') as timestamp FROM tb_rtdrive_locations WHERE mobileimei='" . $imei . "' and timestamp<='$end' and timestamp>='$start' order by timestamp asc");

                $flag = 0;

                $lat = $lng = 0;

                $wflag = 0;

                $dist = 0;

                if ($sql2->num_rows() > 0) {

                    foreach ($sql2->result() as $row) {

                        if ($flag == 0) {

                            $flag = 1;

                        } else {

                            $a = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);

                            $dist = $dist + $a;

                        }

                        $lat = $row->latitude;

                        $lng = $row->longitude;

                    }

                }

                $attendemp = 0;

                $totalemp = getempcount($tripid);

                if ($emp->num_rows() > 0) {

                    $attendemp = $emp->row()->attcnt;

                }

                $data["noofemp"] = $totalemp;

                $driver_late = 0.00;

                $setime = date("Y-m-d H:i:s", strtotime($sql1->row()->setime));

                $tetime = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($sql->row()->tetime))));

                $to_time = strtotime($setime);

                $from_time = strtotime($tetime);

                if ($from_time > $to_time) {

                    $driver_late = round(abs($from_time - $to_time) / 60, 2);

                }

                $arr = array('trip_id' => $tripid, 'vehicle_id' => $vehicleid, 'driver_id' => $driverid, 'vendor_id' => $vendor_id, 'trip_distance' => $dist, 'no_of_emp' => $totalemp, 'attended_emp' => $attendemp, 'start_imei' => $imei, 'end_imei' => $eimei, 'start_time' => $stime, 'end_time' => $etime, 'user_id' => $uid, 'cab_capacity' => $cab_capacity, 'trip_status' => 1, 'trip_type' => $trip_type, 'ship_delay' => $driver_late, 'createdon' => $curdt);

                $chktrip = $this->db->select("id")->get_where("tb_trip_summary", array("trip_id" => $tripid), 1, 0);

                if ($chktrip->num_rows() == 0) {

                    $res = $this->db->insert("tb_trip_summary", $arr);

                }

                $data["trip_id"] = $tripid;

                $shifttime = 0;

                if ($trip_type != 2) {

                    $shti = $sql1->row()->startdate;

                    $shifttime = date('H:i A', strtotime($shti));

                } else {

                    $shifttime = "Empty";

                }

                $data["driver_late"]  = $driver_late;

                $data["empshifttime"] = $shifttime;

                $data["distance"]     = $dist;

                $data["stime"]        = $stime;

                $data["etime"]        = $etime;

                $data["simei"]        = $imei;

                $data["eimei"]        = $eimei;

                if ($odometer_end == "") {$odometer_end = 0;}

                if ($odometer_start == "") {$odometer_start = 0;}

                $data["odometer"]        = ($odometer_end - $odometer_start);

                $data["page_title"]      = "Trip Report";

                $data["capacity"]        = $cab_capacity;

                $data["employees"]       = $emp1;

                $data["trip_type"]       = $trip_type;

                $data["register_number"] = $reg;

                $data["truck_weight"]    = $truck_weight;

                $data["truck_volume"]    = $truck_volume;

                $data["ep"] = "";

                $getusermail = $this->db->select("name,emailid,cc_mails,address")->get_where("tb_users", array("id" => $uid, "emailid !=" => ""), 1, 0);

                if ($getusermail->num_rows() > 0) {

                    $receivemail = $getusermail->row()->emailid;

                    $receivename = $getusermail->row()->name;

                    $receivecc   = $getusermail->row()->cc_mails;

                    $data["ep"] = $getusermail->row()->address;

                    $insertdata = @array('trip_id' => $tripid, 'shift_id' => $shift, 'splace' => $data["trip"]->splace, 'eplace' => $data["trip"]->eplace, 'stime' => $stime, 'etime' => $etime, 'capacity' => $cab_capacity, 'simei' => $data['simei'], 'eimei' => $data['eimei'], 'totcnt' => $totalemp, 'attcnt' => $attendemp, 'distance' => $data['distance'], 'odometer' => $data['odometer'], 'driver_late' => $data['driver_late'], 'receivemail' => $receivemail, 'receivename' => $receivename, 'user_id' => $uid, 'createdon' => $curdt);

                    $repotmaildata = $this->db->insert('tb_trips_mails',$insertdata);

                    $this->load->library('email');

                    $this->email->to($receivemail, $receivename);

                    if ($receivecc != "") {

                        $this->email->cc($receivecc);

                    }

                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');

                    if ($trip_type == 1) {

                        $this->email->subject('svkonekt: Return Trip Status');

                    } else if ($trip_type == 2) {

                        $this->email->subject('svkonekt: Empty Trip Status');

                    } else {

                        $this->email->subject('svkonekt: Trip Status');

                    }

                    $this->email->set_mailtype('html');

                    $body = $this->load->view('mail_forms/basicreport', $data, true);

                    $this->email->message($body);

                    $sendmail = $this->email->send();

                }

            }

        }

    }
    /*public function getcsvfile($shift_id)
    {
        if($shift_id != ""){
            $result = array();
            $consignee_id = $shipper_id = 0;
            $shipper_city = $shipper_street = $shipper_state =  $consignee_city = $consignee_street = $consignee_state = $shipper_name = $consignee_name = "";
            $order_row_id = $shipment_number = 0;
            $this->db->select("o.id as order_row_id,o.order_id,o.pickup_company,o.delivery_company,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.pickup_pincode,o.delivery_pincode,o.pickup_address1,o.delivery_address1,o.pickup_address2,o.delivery_address2");
            $this->db->from("tb_orders o");
            $this->db->where("o.shift_id",$shift_id);
            $userdata = $this->db->get();
            if($userdata->num_rows()>0){
                log_message("error", 'Bascik FTP Connected');
                foreach($userdata->result() as $res){
                    $order_row_id = $res->order_row_id;
                    $getdq_note = $this->common->gettblrowdata(array('order_id'=>$order_row_id,'reference_id'=>'DQ'),'ref_value','tb_order_references',0,0);
                    if(!empty($getdq_note)){
                    $shipment_number = $getdq_note['ref_value']."00";
                    }
                    $orderfile = "";
                    $order_id = $res->order_id;
                    $order_cnt = mb_substr($order_id,6,4);
                    $orderfile = "KNO_".$order_cnt.date('Ymdhi_s')."6501".'.csv';
                    $filename = './assets/csvfiles/'.$orderfile;
                    $file = null;
                    if(file_exists($filename)){
                    $file = fopen($filename, 'w');
                    }else{
                    $file = fopen($filename, 'x');
                    }
                    $consignee_id = 0;
                    $consignee_name = $res->delivery_company;
                    $shipper_name = $res->pickup_company;
                    $shipper_city = $res->pickup_city;
                    $shipper_street = $res->pickup_address1;
                    $shipper_state = $res->pickup_address2;
                    $consignee_city = $res->delivery_city;
                    $consignee_street = $res->delivery_address1;
                    $consignee_state = $res->delivery_address2;
                    $cargo = array();
                    $getcargodetails = $this->db->query("SELECT c.cargo_type,c.goods_description,o.weight,o.volume,o.quantity FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='".$order_row_id."' AND o.status='1' AND o.cargo_id=c.id GROUP BY c.id ORDER BY c.id DESC");
                    if($getcargodetails->num_rows()>0){
                        foreach ($getcargodetails->result() as $row) {
                            $qty = $row->quantity;
                            $cargo_type = $row->cargo_type;
                            $description = $row->goods_description;
                            $weight = $row->weight;
                            $volume = $row->volume;
                            $empty = "";
                            $cargo[] = array('G','quantity'=>round($qty),'cargo_type'=>$cargo_type,'description'=>$description,'','weight'=>$weight,'volume'=>$volume);
                        }
                    }
                    $knorder_id = "SVK".$order_id;
                    $result = array('H',$knorder_id,'KU','',$shipper_name,$shipper_street,$shipper_state,$shipper_city,$consignee_name,$consignee_street,$consignee_state,$consignee_city,$shipment_number);
                    fputcsv($file,$result);
                    foreach ($cargo as $key => $value) {
                        fputcsv($file,$value);
                    }
                    fclose($file);
                    $new_file = "./TestReceiveEDI/".$orderfile;
                    if(SYS_TYPE == 'TMS'){
                        $new_file = "./ReceiveEDI/".$orderfile;
                    }
                    $d = $this->ftp->upload($new_file, $filename, false);
                    if($d){
                        log_message("error","Basic file sent");
                    }else{
                        log_message("error","Basic file not sent");
                    }
                }
            }
        }
    }*/
    public function sendnotify($action,$orderid){
        if(!empty($orderid)){
            $this->load->library('notifytrigger');
            $info['page_title'] = 'Booking Notification';
            $info['subject'] = 'Booking Notification';
            $info['order_id'] = $orderid;
            $info['action'] = $action;
            $orderinfo = $this->common->gettblrowdata(array('id'=>$orderid),'order_id','tb_orders',0,0);
            if(count($orderinfo)>0){
                $info['orderid'] = $orderinfo['order_id'];
                $info['cargos'] = $this->common->gettbldata(array('order_id'=>$orderid),'quantity_type,quantity','tb_order_cargodetails',0,0);
                $info['body'] = $this->load->view('mail_forms/notifytrigger/'.$action,$info,true);
                $this->notifytrigger->sendordernotify($info);
            } else {
                log_message('error','No Order data for id : '.$orderid);
            }
        } else {
            log_message('error','Empty Order ');
        }
    }

	public function tiledicall($shift_id='') {
		$curtz = $this->session->userdata("usr_tzone")['timezone'];
		if ($shift_id != "") {
			$where = array("shift_id" => $shift_id);
			$getorderids = $this->common->gettbldata($where,"*","tb_orders",0,0);
            if (empty($getorderids)) {
                echo "No orders found.";

            }else{

			 for ($i = 0; $i < count($getorderids); $i++) {
				 $orderid=$getorderids[$i]['id'];
				$request = "";
				$request .= "<?xml version='1.0' encoding='UTF-8'?>
				<CONSIGNMENT>
					<CONSIGNMENT_NUMBER>KN".$getorderids[$i]['order_id']."</CONSIGNMENT_NUMBER>
					<CONSIGNMENT_ID>KN".$getorderids[$i]['order_id']."</CONSIGNMENT_ID>
					<CLI_CODE>KUEGLE</CLI_CODE>
					<PICKUP_DUE_DATE>
						<DATE_VALUE>".getdatetimebytimezone($curtz,
						$getorderids[$i]['pickup_datetime'], DFLT_TZ)['date']."</DATE_VALUE>
						<TIME_VALUE>".getdatetimebytimezone($curtz,
						$getorderids[$i]['pickup_datetime'], DFLT_TZ)['time']."</TIME_VALUE>
					</PICKUP_DUE_DATE>
					<CONSIGNEE>
						<NAME>".$getorderids[$i]['delivery_company']."</NAME>
						<ADDRESS>
							<STREET>". $getorderids[$i]['delivery_address1']."</STREET>
							<SUBURB>".$getorderids[$i]['delivery_address2']."</SUBURB>
							<CITY>".$getorderids[$i]['delivery_city']."</CITY>
						</ADDRESS>
					</CONSIGNEE>
					<CONSIGNOR>
						<NAME>".$getorderids[$i]['pickup_company']."</NAME>
						<ADDRESS>
							<STREET>".$getorderids[$i]['pickup_address1']."</STREET>
							<SUBURB>".$getorderids[$i]['pickup_address2']."</SUBURB>
							<CITY>".$getorderids[$i]['pickup_city']."</CITY>
						</ADDRESS>
					</CONSIGNOR>
					<CONSIGNMENT_ITEMS>
						<CONSIGNMENT_ITEM>";
                 $itemqry = "SELECT tcd.`cargo_type`,toc.weight,toc.volume,toc.quantity FROM tb_order_cargodetails toc LEFT JOIN tb_cargo_details tcd ON toc.cargo_id=tcd.id WHERE order_id=? AND toc.status=1";
                 $itemres = $this->db->query($itemqry, [$orderid]);
					if($itemres->num_rows()>0){
							foreach($itemres->result() as $items) {

								$request .= " <ITEM>
											<ITEM_DESC>".$items->cargo_type."</ITEM_DESC>
											<WEIGHT>".$items->weight."</WEIGHT>
											<VOLUME>".$items->volume."</VOLUME>
											<QTY1>".$items->quantity."</QTY1>
											<SVS_CODE></SVS_CODE>
										</ITEM>";

							}
						}
                 $orderReferences = $this->common->getOrderDQPOReferences($orderid);
                 $senderRef = $receiverRef = "";
                 foreach ($orderReferences as $reference) {
                     if ($reference->reference_id == "DQ") {
                         $receiverRef = $reference->ref_value;
                     }
                     if ($reference->reference_id == "PO") {
                         $senderRef = $reference->ref_value;
                     }
                 }
				$request .= "</CONSIGNMENT_ITEM>
					</CONSIGNMENT_ITEMS>
					<FILE_NUMBER></FILE_NUMBER>
					<SENDER_REF>". $senderRef ."</SENDER_REF>
					<RECEIVER_REF>". $receiverRef ."</RECEIVER_REF>
					<PALLET_QTY>".$getorderids[$i]['quantity']."</PALLET_QTY>
				</CONSIGNMENT>";

				$filename = date('Ymd')."SVK".$getorderids[$i]['order_id'].".xml";
				$localfile = "./xml/tiledi/".$filename;
				if (!file_exists(dirname($localfile))) {
				  mkdir(dirname($localfile), 0700, true);
				}
				file_put_contents($localfile, $request);
				$localfile = "./xml/tiledi/".$filename;
				//$folder_name ="/pub/outbound/etntil";
				$folder_name =TIL_FOLDER_NAME;
				$sftp_url = TIL_FTP;
				$username = TIL_FTP_USER;
				$password = TIL_FTP_PWD;

				try{
                    $sftp = new SFTP($sftp_url);
                    if (!$sftp->login($username, $password)) {
                        unset($sftp);
                        log_message("error","Nzmassstatus(1881) >> tiledicall >> Cannot login into your TIL MTF server!");
                    }else{
                        $sftp->chdir($folder_name);
                        $sftp->put($folder_name."/".$filename,$localfile,SFTP::SOURCE_LOCAL_FILE);
                        unset($sftp);
                    }
                } catch (Exception $ex) {
                    log_message("error","Nzmassstatus(1881) >> tiledicall >> Some Problem occured in TIL MTF server!, Please Try Again Later.");
                }
			}
			echo 0;
		}
		}else{
			log_message("error","Nzmassstatus(1881) >> tiledicall >> Shift Id not received");
		}

	}
	
	public function pbtedi_call($shift_id='') {
		if ($shift_id != "") {
			$order_details=array();
			$whr = array("shift_id"=>$shift_id);
			$tripRes = $this->common->gettbldata($whr,"id","tb_trips",0,0);
			if(empty($tripRes)){
				echo "The trip is Not Accepted By Driver.";
                exit();
			}else{
				$whr = array("shift_id"=>$shift_id);
				$getorderids = $this->common->gettbldata($whr,"id,order_id","tb_orders",0,0);
				if(empty($getorderids)){
					echo "No orders found in this Trip.";
	                exit();
				}else{
					for ($i = 0; $i < count($getorderids); $i++) {
		                $order_id = $getorderids[$i]['id'];
		                $whr = array("id"=>$order_id);
						$order_info = $this->common->gettbldata($whr,"*","tb_orders",0,0);
		                $getcargos = $this->getCargoDetailsSum($order_id);
		                $cargo_info_res = $this->db->query("SELECT tcd.cargo_type,tcd.`goods_description`,toc.quantity,toc.weight,toc.volume FROM tb_order_cargodetails  toc LEFT OUTER JOIN `tb_cargo_details` tcd ON toc.cargo_id= tcd.id WHERE toc.order_id='".$order_id."' AND toc.status='1'");
		                $cargo_info=$cargo_info_res->result_array();
		                $order_details[] = array(
		                    "order_info" => $order_info,
		                    "cargo_summary" => $getcargos,
		                    "cargo_details" => $cargo_info
		                );

            		}
            		echo $shipdatres = $this->createpbtoutboudxml($order_details);

				}


			}
		}
	}
	
	function createpbtoutboudxml($pbtrunshipmentdata){

			$mainpath="./xml/pbt/";
			$files = glob($mainpath . "*");
			$num= $con= 1;
			if ($files){
				$num= $con= (sizeof($files)+1);
			}
			log_message("error","PBT EDI pbtrunshipmentdata ".json_encode($pbtrunshipmentdata));

	      for ($i = 0; $i < count($pbtrunshipmentdata); $i++) {

		      	$ordersdetails=$pbtrunshipmentdata[$i]["order_info"];
		      	$cargo_summary=$pbtrunshipmentdata[$i]["cargo_summary"];
		      	$cargo_details=$pbtrunshipmentdata[$i]["cargo_details"];
		      	$runsheetdate=date('Ymd');
				$runsheetnumber="ATKDF". sprintf("%'.05d", $num);
				$consnumber='KDF'. sprintf("%'.07d", $con);
	      		$order_id = $ordersdetails[0]['order_id'];
				$volumeinfo = $cargo_summary['volume'];
				$weightinfo = $cargo_summary['weight'];
				$shipquantity = $cargo_summary['quantity'];
				$tickno=1;
				$request="<?xml version='1.0' encoding='UTF-8'?>
					<PBLinkVersion> <PBLinkVersionCode>DDv1.3</PBLinkVersionCode>
				   <Runsheet>
				      <RunSheetHeader>
						 <RunSheetNumber>".$runsheetnumber."</RunSheetNumber>
				         <RunSheetDate>".$runsheetdate."</RunSheetDate>
				         <RunSheetCubic>".$volumeinfo."</RunSheetCubic>
				         <RunSheetWeight>".$weightinfo."</RunSheetWeight>
				         <RunSheetItems>".$shipquantity."</RunSheetItems>
				         <RunSheetConCount>1</RunSheetConCount>
				         <SenderName>".$ordersdetails[0]['pickup_company']."</SenderName>
				         <SenderStreet>".$ordersdetails[0]['pickup_address1']."</SenderStreet>
				         <SenderTown>".$ordersdetails[0]['pickup_address2']."</SenderTown>
				         <SenderCity>".$ordersdetails[0]['pickup_city']."</SenderCity>
				         <SenderPostalCode>".$ordersdetails[0]['pickup_pincode']."</SenderPostalCode>
						 <SenderPhone>+64-9-2573982</SenderPhone>
						 <SenderContact>KN Transport</SenderContact>
				      </RunSheetHeader>
				      <Consignment>
				         <ConsignmentType>Consignment</ConsignmentType>
				         <ConsignmentNumber>".$consnumber."</ConsignmentNumber>
				         <AccountNumber>25744</AccountNumber>
				         <TripCode></TripCode>
				         <Date>".$runsheetdate."</Date>
				         <ConsignmentSender>".$ordersdetails[0]['pickup_company']."</ConsignmentSender>
				         <SendersChepAccount>999999999</SendersChepAccount>
				         <ReceiversName>".$ordersdetails[0]['delivery_company']."</ReceiversName>
				         <ReceiversStreet>". $ordersdetails[0]['delivery_address1']."</ReceiversStreet>
				         <ReceiversTown>".$ordersdetails[0]['delivery_address2']."</ReceiversTown>
				         <ReceiversCity>".$ordersdetails[0]['delivery_city']."</ReceiversCity>
				         <ReceiversPostalCode>".$ordersdetails[0]['delivery_pincode']."</ReceiversPostalCode>
				         <ReceiverPhone>+64-9-2573982</ReceiverPhone>
				         <ReceiversChepAccount></ReceiversChepAccount>
				         <ChepPallets></ChepPallets>
				         <HazardClass></HazardClass>
				         <Comments></Comments>
				         <CustomerReference1></CustomerReference1>
				         <CustomerReference2></CustomerReference2>
				         <SaturdayDelivery>N</SaturdayDelivery>
				         <OvernightDelivery>N</OvernightDelivery>
				         <UrgentDelivery>N</UrgentDelivery>
				         <ExpressDelivery>N</ExpressDelivery>
				         <CustomerConsignment>".$order_id."</CustomerConsignment>
				         <ATL></ATL>";

				         foreach ($cargo_details as $cargo) {
				         	$TicketNumber=$consnumber.sprintf("%'.03d", $tickno);
				         	$request.="<Line>
									<PackageDescription>".$cargo['cargo_type']."</PackageDescription>
									<NbrItems>".$cargo['quantity']."</NbrItems>
									<Weight>".$cargo['weight']."</Weight>
									<Cubic>".$cargo['volume']."</Cubic>
									<TicketNumber>".$TicketNumber."</TicketNumber>
									<ItemHazardClass/>
									<PakID/>
								</Line>	";
								$tickno++;
				         }

				       $request.= "</Consignment>
				          </Runsheet></PBLinkVersion>";
					//log_message("error","PBT EDI request ".json_encode($request));
				    $filename = $runsheetnumber.".xml";
					$localfile = "./xml/pbt/".$filename;
					if (!file_exists(dirname($localfile))) {
					  mkdir(dirname($localfile), 0700, true);
					}
					file_put_contents($localfile, $request);
					$storepbtfile = $this->uploadPBTFile($localfile);

				  $num++;
		      	$con++;

		     }
		     return $filename;
    }
	
		 function getCargoDetailsSum($order_id) {
			$where = array("order_id" => $order_id, "status" => 1);
			$params = "count(*) total_cargos_count,group_concat(cargo_id,',') cargo_id, group_concat(handling_unit,',') handling_unit, sum(length) as length, sum(width) width, sum(height) height, sum(weight) weight, sum(volume) volume, sum(quantity) quantity,quantity_type,cargo_content";
			$this->db->select($params);
			$this->db->from('tb_order_cargodetails');
			$this->db->where($where);
			$this->db->group_by('order_id');
			$result = $this->db->get()->row_array();
			return $result;
		}


		public function uploadPBTFile($localfile){
			$remotefile = basename($localfile);
			$ftp = @ftp_connect("ftp.pbt.co.nz") or die("Could not connect");
			ftp_login($ftp,"pblftp","pblink0702") or die("invalid username or password");
			$ret = @ftp_nb_put($ftp, "/kandn/defence/in/$remotefile", $localfile, FTP_BINARY, FTP_AUTORESUME);
			while (FTP_MOREDATA == $ret)
			{
				$ret = ftp_nb_continue($ftp);
			}
			ftp_close($ftp);
		}
    /*send epop to salog*/
    public function sendEPOPGateoutNotify($postdata){
        /*check SDT Ref*/
        $sdtref = getsdtreforder($postdata['ord_id']);
        if($sdtref == "PUP" || $sdtref == ""){
            $order_id = $postdata['order_id'];
            $ship_id = $postdata['shipment_id'];
            $trip_id = $postdata['trip_id'];
            $stop_id = $postdata['stop_id'];
            $driver_id = $postdata['driver_id'];
            $vehicle_id = $postdata['vehicle_id'];
            $curtz = $postdata['curtz'];
            $chkcust = $this->db->query("SELECT o.id,o.order_id,o.customer_id,o.user_id,o.created_source,o.pickup_city,o.delivery_city,o.pickup_address1,o.delivery_address1,c.name,c.gcm_id,c.company_code,c.branch_code,c.phone,c.code FROM tb_orders o,tb_customers c WHERE o.customer_id=c.id AND o.id='".$postdata['ord_id']."' LIMIT 1");
            if($chkcust->num_rows()>0){
                $ordid = $chkcust->row()->id;
                $user_id = $chkcust->row()->user_id;
                $company_code = $chkcust->row()->company_code;
                $branch_code = $chkcust->row()->branch_code;
                $custcid = $chkcust->row()->phone;
                $custcode = $chkcust->row()->code;
                $pickup = $chkcust->row()->pickup_city;
                $delver = $chkcust->row()->delivery_city;
                $pickaddr = $chkcust->row()->pickup_address1;
                $deliveryaddr = $chkcust->row()->delivery_address1;
                $order_id = $chkcust->row()->order_id;
                $chkdocs = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,'".$curtz."') as createdon,ts.imgpath,'".$pickaddr."' as address,'".$pickup."' as pickup,'".$delver."' as `drop`,'".$order_id."' as order_id,ts.hash from tb_pod_uploads ts INNER JOIN tb_document_types dt ON dt.id=ts.doc_type AND dt.type_name='PUP' WHERE ts.order_id = ? AND ts.status=? GROUP BY ts.id ORDER BY ts.createdon ASC",[$ordid,1]);
                if($chkdocs->num_rows() > 0){
                    $data['order'] = [
                        "order_id"=>$order_id,
                        "pickup_address1"=>$pickaddr,
                        "delivery_address1"=>$deliveryaddr
                    ];
                    $data['userid'] = $user_id;
                    $epodpath = "./assets/trippods/RL".$order_id.".pdf";
                    $data["pod"] = $chkdocs;
                    /* get all order references in single row*/
                    $data["orderref"] = $this->common->getallorderreferences($ordid);
                    $refvalue = $orderDepartmentCode = "";
                    /*get department code for this order*/
                    $departmentCode = $this->common->gettblrowdata(['order_row_id'=>$ordid],"department_code","tb_order_details",0,0);
                    if(!empty($departmentCode)){
                        $orderDepartmentCode = $departmentCode['department_code'];
                    }
                    $data['pickup_datetime'] = $data['delivery_datetime'] = "";
                    $stops = $this->db->query("SELECT ss.stop_type,ss.status_id,ss.latitude,ss.longitude,convertToClientTZ(ss.createdon,'".$curtz."') as createdon,sm.status_name from tb_stop_status ss LEFT JOIN tb_status_master sm ON sm.id=ss.status_id WHERE ss.shipment_id=".$ship_id." AND ss.status='1' ORDER BY ss.createdon ASC");
                    if($stops->num_rows()>0){
                        foreach($stops->result() as $sres){
                            if($sres->status_id=="1" && $sres->stop_type == "P"){
                                $data['pickup_datetime'] = $sres->createdon;
                            }
                            if($sres->status_id=="1" && $sres->stop_type == "D"){
                                $data['delivery_datetime'] = $sres->createdon;
                            }
                        }
                    }
                    $this->load->library('m_pdf');
                    $html = $this->load->view('settings/bulkepod',$data,true);
                    $chk = @$this->m_pdf->pdf->WriteHTML($html);
                    $chk = @$this->m_pdf->pdf->Output($epodpath,"F");
                    $unique_id = "RL".$order_id.".".date("Ymd").".".date("his");
                    $pagescnt = $this->m_pdf->pdf->pages;
                    $pages = count($pagescnt);
                    /* SALog JPL*/
                    $chkordtypeqry1 = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=$ordid AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1");
                    $bn = $inn = $iv = $dq = $cmp = $brn = "";
                    if($chkordtypeqry1->num_rows()>1){
                        foreach($chkordtypeqry1->result() as $oref1){
                            if($oref1->reference_id == "BN"){
                                $bn = $oref1->ref_value;
                            }if($oref1->reference_id == "INN"){
                                $inn = $oref1->ref_value;
                            }if($oref1->reference_id == "IV"){
                                $iv = $oref1->ref_value;
                            }if($oref1->reference_id == "DQ"){
                                $dq = $oref1->ref_value;
                            }if($oref1->reference_id == "CMP"){
                                $cmp = $oref1->ref_value;
                            }if($oref1->reference_id == "BRN"){
                                $brn = $oref1->ref_value;
                            }
                            if($oref1->reference_id == "XSR"){
                                $refvalue = $oref1->ref_value;
                            }
                        }
                    }
                    $cmp = ($cmp == "") ? $company_code : $cmp;
                    $brn = ($brn == "") ? $branch_code : $brn;
                    $countrycode = substr($company_code,0,-2);
                    $randomstr = RandomString::generate(10);
                    $jplData = [
                        "country"=>$cmp,
                        "branch"=>$brn,
                        "order_id"=>$order_id,
                        "time"=>date("hi"),
                        "unique_id"=>$unique_id,
                        "date"=>date("d.m.Y"),
                        "pages"=>$pages,
                        "xsr"=>$refvalue,
                        "sd"=>$orderDepartmentCode,
                        "bn"=>$bn,
                        "inn"=>$inn,
                        "iv"=>$iv,
                        "dq"=>$dq,
                        "custcid"=>$custcid,
                        "custcode"=>$custcode,
                        "countrycode"=>$countrycode,
                        "randomstr"=>$randomstr,
                        "doctype"=>171
                    ];
                    $jplFilePath = $this->saveSalogJPF($jplData);
                    $storeftipjpl = $this->uploadSalogKNFile($jplFilePath);
                    $storeftippdf = $this->uploadSalogKNFile($epodpath);
                }
            }
        }
    }

    public function saveSalogJPF($jplData){
        $content = $this->load->view("jpl_salogtemplate",$jplData,TRUE);
        $order_id = $jplData["order_id"];
        $file_path = "./assets/jpl_files/RL$order_id.jpl";
        $fp = fopen($file_path,"wb");
        fwrite($fp,$content);
        fclose($fp);
        return $file_path;
    }

    public function uploadSalogKNFile($localfile){
        $remotefile = basename($localfile);
        $sftp_url = SALOG_FTP;
        $username = SALOG_FTP_USER;
        $password = SALOG_FTP_PWD;
        $folder_name = "/pub/inbound/D3/IF";
        try{
            $sftp = new SFTP($sftp_url);
            if (!$sftp->login($username, $password)) {
                unset($sftp);
                log_message("error","Cannot login into your SWIFTLOG MTF Test server !");
            }else{
                $sftp->chdir($folder_name);
                $sftp->put($folder_name."/".$remotefile,$localfile,SFTP::SOURCE_LOCAL_FILE);
                unset($sftp);
                return true;
            }
        } catch (Exception $ex) {
            log_message("error","Some Problem occured!, SWIFTLOG MTF Test server, Please Try Again Later.");
        }
    }
}
