<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class OptimizeTripOrders extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('session');
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(['OptimizeTripOrdersModel','common']);
        $this->companyCode = $this->session->userdata('company_code');
        $this->branchCode = $this->session->userdata('branch_code');
        $this->userId = $this->session->userdata('user_id');
        $this->sessionCurrency = $this->session->userdata("usr_tzone")['currency'];
        $this->sessionTimeZone = $this->session->userdata( "usr_tzone" )['timezone'];
    }
    public function index(){
        echo "OptimizeTripOrders";
    }

    public function prepareOptimizeTripList(){
        $data = [];
        $postData = $this->input->post(NULL,TRUE);
        $tariffType = $postData['tariffType'] ?: "BUY";
        $stringOrderIds = $postData['orderIds'] ?? "";
        $postCarrierId = $postData['carrierId'] ?: 0;
        if($stringOrderIds == "") {
            echo $this->load->view("orders/OptimizeTripOrdersView", $data, TRUE);exit;
        }
        $orderIds = explode(',', $stringOrderIds);
        $orderId = $orderIds[0];
        $ordersLocation = $this->OptimizeTripOrdersModel->getOrdersLocation($orderIds);
        if(empty($ordersLocation)) {
            echo $this->load->view("orders/OptimizeTripOrdersView", $data, TRUE);exit;
        }
        $getOrderCargos = $this->OptimizeTripOrdersModel->getOrderTotalDimensions($orderIds);
        $orderData = $ordersLocation[$orderId];
        $orderConstraints = $this->OptimizeTripOrdersModel->getOrderConstraints(['orderId'=>$orderId, 'fromDate'=>$orderData['fromDate'], 'toDate'=>$orderData['toDate'], 'sessionTimeZone'=>$this->sessionTimeZone]);
        $truckTypeConstraints = $orderConstraints['truckTypeConstraints'];
        $timeConstraints = $orderConstraints['timeConstraints'];
        $fromPincode  = $orderData['fromPincode'] ?: 'emptyValue';
        $fromCity  = $orderData['fromCity'] ?: 'emptyValue';
        $fromProvince  = $orderData['fromProvince'] ?: 'emptyValue';
        $fromCountry  = $orderData['fromCountry'] ?: 'emptyValue';
        $toPincode  = $orderData['toPincode'] ?: 'emptyValue';
        $toCity  = $orderData['toCity'] ?: 'emptyValue';
        $toProvince  = $orderData['toProvince'] ?: 'emptyValue';
        $toCountry  = $orderData['toCountry'] ?: 'emptyValue';
        $orderServiceRowId = $orderData['serviceRowId'] ?? 0; 
        $orderTimeDiff = $orderData['timeDiff'];
        $pickupData = [$fromPincode, $fromCity, $fromProvince, $fromCountry];
        $destinationData = [$toPincode, $toCity, $toProvince, $toCountry];
        $orderCargo = $getOrderCargos[$orderId];
        $cargoWeight = $orderCargo['totalWeight'];
        $cargoVolume = $orderCargo['totalVolume'];
        $cargoSecondWeight = $orderCargo['totalSecondWeight'];
        $cargoSecondVolume = $orderCargo['totalSecondVolume'];
        $cargoQuantity = $orderCargo['totalQuantity'];
        $distanceAndDuration = $this->rearrangeAndCalculateDistanceAndDurationForStops(['pickupLat'=>$orderData['fromLat'], 'pickupLng'=>$orderData['fromLng'], 'destinationLat'=>$orderData['toLat'], 'destinationLng'=>$orderData['toLng']]);
        $geoPairs = $this->generateGeoPairs($pickupData, $destinationData, ['lm.source', 'lm.destination', 'gsheet.geo_from', 'gsheet.geo_to'],[6, 5, 3, 2, 1]);
        $geoTierPairs = $this->generateGeoPairsForGeoTierTable($pickupData, $destinationData, ['gsheet.geo_from', 'gsheet.geo_to'],['POSTAL CODE','CITY','PROVINCE','COUNTRY']);
        $rates = $this->OptimizeTripOrdersModel->getChargesFromRates(['cargos'=>['cargoWeight'=> $cargoWeight ?? 1, 'cargoVolume'=> $cargoVolume ?? 1, 'cargoQuantity'=> $cargoQuantity ?? 1, 'cargoSecondWeight'=>$cargoSecondWeight ?? 0,'cargoSecondVolume'=>$cargoSecondVolume ?? 0], 'offeringType'=>$postData['modeOfTransport'] ?: $orderData['transportMode'], 'serviceType'=>$orderServiceRowId, 'geoPairs'=>$geoPairs, 'geoTierPairs'=> $geoTierPairs,'companyCode'=>$this->companyCode, 'branchCode'=>$this->branchCode, 'tariffType'=> $tariffType, 'orderAddons' => $orderData['orderAddons'], 'distanceAndDuration'=>$distanceAndDuration, 'orderTimeDiff'=>$orderTimeDiff, 'carrierId'=>$postCarrierId]);
        $allVendorProfileIds = $allVehicleProfileIds = $allCustomerProfileIds = [];
        $keys = array_column($rates, 'totalPrice');
        array_multisort($keys, SORT_ASC, $rates);
        $i = 0;
        foreach ($rates as $rate_index => $rate) {
            $vendorData = $vehicleTypeData = [];
            $rate['cheapestPriceFlag'] = 0;
            if($i == 0){
                $rate['cheapestPriceFlag'] = 1;
            }
            $i++;
            if (isset($rate['vendorProfileId'])) {
                if ($rate['vendorProfileId'] != '') {
                    if(in_array($rate['vendorProfileId'],$allVendorProfileIds)){
                        $vendorData = $allVendorProfilesData[$rate['vendorProfileId']] ?? [];
                    }else{
                        $allVendorProfilesData[$rate['vendorProfileId']] = $vendorData = $this->OptimizeTripOrdersModel->getVendorIdsFromVendorProfile($rate['vendorProfileId'], $postCarrierId);
                        $allVendorProfileIds[] = $rate['vendorProfileId'];
                    }
                    
                }
            }
            if (isset($rate['customerProfileId'])) {
                if ($rate['customerProfileId'] != '') {
                    if(in_array($rate['customerProfileId'],$allCustomerProfileIds)){
                        $customerData = $allCustomerProfilesData[$rate['customerProfileId']] ?? [];
                    }else{
                        $allCustomerProfilesData[$rate['customerProfileId']] = $customerData = $this->OptimizeTripOrdersModel->getCustomerIdsFromCustomerProfile($rate['customerProfileId']);
                        $allCustomerProfileIds[] = $rate['customerProfileId'];
                    }
                    
                }
            }
            if (isset($rate['vehicleProfileId'])) {
                if ($rate['vehicleProfileId'] != '') {
                    if(in_array($rate['vehicleProfileId'],$allVehicleProfileIds)){
                        $vehicleTypeData = $allVehicleProfilesData[$rate['vehicleProfileId']] ?? [];
                    }else{
                        $allVehicleProfilesData[$rate['vehicleProfileId']] = $vehicleTypeData = $this->OptimizeTripOrdersModel->getVehicleIdsFromVehicleProfile($rate['vehicleProfileId']);
                        $allVehicleProfileIds[] = $rate['vehicleProfileId'];
                    }
                }
            }
            $finalRates[] = $this->getRateRowsBasedOnCustomerVendorAndTruckTypeCount($rate, $vendorData, $vehicleTypeData, $customerData, array_unique($truckTypeConstraints));
        }
        $data['finalRates'] = $finalRates ?? [];
        $data['localCurrency'] = $this->sessionCurrency;
        $data['timeConstraints'] = $timeConstraints;
        $data['postData'] = $this->arrangePostDataToInputFields(['cargos'=>['cargoWeight'=> $cargoWeight ?? 1, 'cargoVolume'=> $cargoVolume ?? 1, 'cargoQuantity'=> $cargoQuantity ?? 1, 'cargoSecondWeight'=>$cargoSecondWeight ?? 0,'cargoSecondVolume'=>$cargoSecondVolume ?? 0],'orderAddons' => $orderData['orderAddons'], 'distanceAndDuration'=>$distanceAndDuration, 'orderTimeDiff'=>$orderTimeDiff, 'orderData'=>$orderData]);
        $thirdColumn = ($tariffType == "BUY") ? "Carrier" : "Customer";
        $data['tableHeaders'] = ['#', '', 'Vehicle Type', $thirdColumn, 'Price'];
        $data['tariffType'] = $tariffType;
        echo $this->load->view("orders/OptimizeTripOrdersView", $data, TRUE);
    }

    private function arrangePostDataToInputFields(array $postData): string
    {
        $cargos = $postData['cargos'] ?? [];
		$cargoWeight = $cargos['cargoWeight'] ?? 0;
        $cargoSecondWeight = $cargos['cargoSecondWeight'] ?? 0;
		$cargoVolume = $cargos['cargoVolume'] ?? 0;
        $cargoSecondVolume = $cargos['cargoSecondVolume'] ?? 0;
		$cargoQuantity = $cargos['cargoQuantity'] ?? 0;
		$orderAddons = $postData['orderAddons'] ?? [];
		$distanceAndDuration = $postData['distanceAndDuration'] ?? [];
		$distanceKm = $distanceAndDuration['distanceKm'] ?? 0;
		$distanceMiles = $distanceAndDuration['distanceMiles'] ?? 0;
		$durationMin = $distanceAndDuration['durationMin'] ?? 0;
		$durationHours = $distanceAndDuration['durationHours'] ?? 0;
		$durationDays = $distanceAndDuration['durationDays'] ?? 0;
        $orderData = $postData['orderData'] ?? [];
        $fromPincode  = $orderData['fromPincode'] ?: 'emptyValue';
        $fromCity  = $orderData['fromCity'] ?: 'emptyValue';
        $fromProvince  = $orderData['fromProvince'] ?: 'emptyValue';
        $fromCountry  = $orderData['fromCountry'] ?: 'emptyValue';
        $toPincode  = $orderData['toPincode'] ?: 'emptyValue';
        $toCity  = $orderData['toCity'] ?: 'emptyValue';
        $toProvince  = $orderData['toProvince'] ?: 'emptyValue';
        $toCountry  = $orderData['toCountry'] ?: 'emptyValue';
        $html = '<form id="optPopupData" class="optPopupData">
                    <input type="hidden" name="fromPincode" id="fromPincodeOptPopup" value="'.$fromPincode.'">
                    <input type="hidden" name="fromCity" id="fromCityOptPopup" value="'.$fromCity.'">
                    <input type="hidden" name="fromProvince" id="fromProvinceOptPopup" value="'.$fromProvince.'">
                    <input type="hidden" name="fromCountry" id="fromCountryOptPopup" value="'.$fromCountry.'">
                    <input type="hidden" name="toPincode" id="toPincodeOptPopup" value="'.$toPincode.'">
                    <input type="hidden" name="toCity" id="toCityOptPopup" value="'.$toCity.'">
                    <input type="hidden" name="toProvince" id="toProvinceOptPopup" value="'.$toProvince.'">
                    <input type="hidden" name="toCountry" id="toCountryOptPopup" value="'.$toCountry.'">
                    <input type="hidden" name="cargoWeight" id="cargoWeightOptPopup" value="'.$cargoWeight.'">
                    <input type="hidden" name="cargoSecondWeight" id="cargoSecondWeightOptPopup" value="'.$cargoSecondWeight.'">
                    <input type="hidden" name="cargoSecondVolume" id="cargoSecondVolumeOptPopup"value="'.$cargoSecondVolume.'">
                    <input type="hidden" name="cargoVolume" id="cargoVolumeOptPopup" value="'.$cargoVolume.'">
                    <input type="hidden" name="cargoQuantity" id="cargoQuantityOptPopup"value="'.$cargoQuantity.'">
                    <input type="hidden" name="distanceKm" id="distanceKmOptPopup"value="'.$distanceKm.'">
                    <input type="hidden" name="distanceMiles" id="distanceMilesOptPopup"value="'.$distanceMiles.'">
                    <input type="hidden" name="durationMin" id="durationMinOptPopup"value="'.$durationMin.'">
                    <input type="hidden" name="durationHours" id="durationHoursOptPopup"value="'.$durationHours.'">
                    <input type="hidden" name="durationDays" id="durationDaysOptPopup"value="'. $durationDays.'">';
        foreach($orderAddons as $eachAddon){
            $vasId = $eachAddon['vasId'];
            $quantity = $eachAddon['quantity'];
            $html .= '<input type="hidden" name="orderAddonsVasId[]" id="orderAddonsVasIdOptPopup" value="'.$vasId.'"><input type="hidden" name="orderAddonsQuantity[]" id="orderAddonsQuantityOptPopup" value="'.$quantity.'">';
        }
        $html .= "</form>";
        return $html;
    }

    public function rearrangeAndCalculateDistanceAndDurationForStops(array $data): array
    {
      //  $data = ['pickupLat'=>'17.4913185', 'pickupLng'=>'78.4273971', 'destinationLat'=>'16.5084889', 'destinationLng'=>'80.6400861'];
       // $stops[] = ['lat'=>$data['pickupLat'],'lng'=>$data['pickupLng']];
      //  $stops[] = ['lat'=>$data['destinationLat'],'lng'=>$data['destinationLng']];
    /*    $stops = [
            ['lat' => 17.387140, 'lng' => 78.491684], // Hyderabad
            ['lat' => 16.50617, 'lng' => 80.64802], // vij
            ['lat' => 16.314209, 'lng' => 80.435028], // guntur
            ['lat' => 17.686815, 'lng' => 83.218483], // vizag
        ]; */
        $stops = [
            ['lat' => $data['pickupLat'], 'lng' => $data['pickupLng']], // Hyderabad
            ['lat' => $data['destinationLat'], 'lng' => $data['destinationLng']]
        ];
       // echo "<pre>";
        // print_r($stops);
        $result = getDistanceAndDurationWithMultipleStops($stops);
        $totalDistanceKm = $result['totalDistanceKm'];
        $totalDistanceMiles = round($totalDistanceKm * 0.621371, 2);
        $totalDurationMin = $result['totalDurationMin'];
        $totalDurationHours = round($totalDurationMin / 60, 2);
        $totalDurationDays = round($totalDurationMin / 1440, 2);
        return ['distanceKm'=>$totalDistanceKm ?: 0, 'distanceMiles'=>$totalDistanceMiles ?: 0, 'durationMin'=>$totalDurationMin ?: 0, 'durationHours'=>$totalDurationHours ?: 0, 'durationDays'=>$totalDurationDays ?: 0];
    }

    private function getRateRowsBasedOnCustomerVendorAndTruckTypeCount(array $rates, array $vendorData, array $vehicleTypeData, array $customerData, array $truckTypeConstraints):array 
    {
        if((empty($vendorData) && empty($vehicleTypeData) && empty($customerData))){
            $finalRates[] = ['vendorId'=>"",'vendorName'=>"",'vendorCode'=>"", 'customerId'=>"",'customerName'=>"",'customerCode'=>"" ,'vehicleTypeId'=>"",'vehicleType'=>"",'vendorProfile'=>$rates['vendor_profile'],'vehicleProfile'=>$rates['vehicleProfileId'],'totalPrice'=>round($rates['totalPrice'],2),'currency'=>$rates['currency'],'rateRecordId'=>$rates['rateRecordId'],'rateOfferingId'=>$rates['rateOfferingId'],'rateServiceId'=>$rates['rateServiceId'], 'cheapestPriceFlag'=>$rates['cheapestPriceFlag'], 'clockIconFlag'=>$rates['clockIconFlag'], 'offeringRowId'=>$rates['offeringRowId'], 'recordRowId'=>$rates['recordRowId'], 'fuelSurchargepercentage'=>$rates['fuelSurchargepercentage'], 'fuelSurchargePercentageAmount'=>$rates['fuelSurchargePercentageAmount'], 'fuelSurchargeFlatAmount'=> $rates['fuelSurchargeFlatAmount'], 'uomConversionId'=>$rates['uomConversionId'], 'rateServiceRowId'=>$rates['rateServiceRowId']];
            return $finalRates;
        }
        if((empty($vendorData) && empty($customerData))){
            foreach($vehicleTypeData as $eachVehicleType){
                $truckTypeCriteriaNotMatched = 0;
                if((!in_array($eachVehicleType['rowId'],$truckTypeConstraints)) && (!empty($truckTypeConstraints))){
                    $truckTypeCriteriaNotMatched = 1;
                }
                $finalRates[] = ['vendorId'=>"",'vendorName'=>"",'vendorCode'=>"", 'customerId'=>"",'customerName'=>"",'customerCode'=>"", 'vehicleTypeId'=>$eachVehicleType['rowId'],'vehicleType'=>$eachVehicleType['truckType'],'vendorProfile'=>$rates['vendorProfileId'],'vehicleProfile'=>$rates['vehicleProfileId'],'totalPrice'=>round($rates['totalPrice'],2),'currency'=>$rates['currency'],'rateRecordId'=>$rates['rateRecordId'],'rateOfferingId'=>$rates['rateOfferingId'],'rateServiceId'=>$rates['rateServiceId'], 'cheapestPriceFlag'=>$rates['cheapestPriceFlag'], 'clockIconFlag'=>$rates['clockIconFlag'], 'offeringRowId'=>$rates['offeringRowId'], 'recordRowId'=>$rates['recordRowId'], 'fuelSurchargepercentage'=>$rates['fuelSurchargepercentage'], 'fuelSurchargePercentageAmount'=>$rates['fuelSurchargePercentageAmount'], 'fuelSurchargeFlatAmount'=> $rates['fuelSurchargeFlatAmount'], 'uomConversionId'=>$rates['uomConversionId'], 'rateServiceRowId'=>$rates['rateServiceRowId'], 'truckTypeCriteriaNotMatched'=>$truckTypeCriteriaNotMatched];
            }
            return $finalRates ?? [];
        }
        if(empty($vehicleTypeData)){
            foreach($customerData as $eachCustomer){
                $finalRates[] = ['vendorId'=>"",'vendorName'=>"",'vendorCode'=>"",'customerId'=>$eachCustomer['rowId'],'customerName'=>$eachCustomer['name'],'customerCode'=>$eachCustomer['code'], 'vehicleTypeId'=>"",'vehicleType'=>"",'vendorProfile'=>$rates['vendorProfileId'],'vehicleProfile'=>$rates['vehicleProfileId'],'totalPrice'=>round($rates['totalPrice'],2),'currency'=>$rates['currency'],'rateRecordId'=>$rates['rateRecordId'],'rateOfferingId'=>$rates['rateOfferingId'],'rateServiceId'=>$rates['rateServiceId'], 'cheapestPriceFlag'=>$rates['cheapestPriceFlag'], 'clockIconFlag'=>$rates['clockIconFlag'], 'offeringRowId'=>$rates['offeringRowId'], 'recordRowId'=>$rates['recordRowId'], 'fuelSurchargepercentage'=>$rates['fuelSurchargepercentage'], 'fuelSurchargePercentageAmount'=>$rates['fuelSurchargePercentageAmount'], 'fuelSurchargeFlatAmount'=> $rates['fuelSurchargeFlatAmount'], 'uomConversionId'=>$rates['uomConversionId'], 'rateServiceRowId'=>$rates['rateServiceRowId']];
            }
            foreach($vendorData as $eachVendor){
                $finalRates[] = ['vendorId'=>$eachVendor['rowId'],'vendorName'=>$eachVendor['name'],'vendorCode'=>$eachVendor['code'],'vehicleTypeId'=>"",'customerId'=>"",'customerName'=>"",'customerCode'=>"", 'vehicleType'=>"",'vendorProfile'=>$rates['vendorProfileId'],'vehicleProfile'=>$rates['vehicleProfileId'],'totalPrice'=>round($rates['totalPrice'],2),'currency'=>$rates['currency'],'rateRecordId'=>$rates['rateRecordId'],'rateOfferingId'=>$rates['rateOfferingId'],'rateServiceId'=>$rates['rateServiceId'], 'cheapestPriceFlag'=>$rates['cheapestPriceFlag'], 'clockIconFlag'=>$rates['clockIconFlag'], 'offeringRowId'=>$rates['offeringRowId'], 'recordRowId'=>$rates['recordRowId'], 'fuelSurchargepercentage'=>$rates['fuelSurchargepercentage'], 'fuelSurchargePercentageAmount'=>$rates['fuelSurchargePercentageAmount'], 'fuelSurchargeFlatAmount'=> $rates['fuelSurchargeFlatAmount'], 'uomConversionId'=>$rates['uomConversionId'], 'rateServiceRowId'=>$rates['rateServiceRowId']];
            }
            return $finalRates ?? [];
        }
        foreach($vendorData as $eachVendor){
            foreach($vehicleTypeData as $eachVehicleType){
                $truckTypeCriteriaNotMatched = 0;
                if((!in_array($eachVehicleType['rowId'],$truckTypeConstraints)) && (!empty($truckTypeConstraints))){
                    $truckTypeCriteriaNotMatched = 1;
                }
                $finalRates[] = ['vendorId'=>$eachVendor['rowId'],'vendorName'=>$eachVendor['name'],'vendorCode'=>$eachVendor['code'],'customerId'=>"",'customerName'=>"",'customerCode'=>"", 'vehicleTypeId'=>$eachVehicleType['rowId'],'vehicleType'=>$eachVehicleType['truckType'],'vendorProfile'=>$rates['vendorProfileId'],'vehicleProfile'=>$rates['vehicleProfileId'],'totalPrice'=>round($rates['totalPrice'],2),'currency'=>$rates['currency'],'rateRecordId'=>$rates['rateRecordId'],'rateOfferingId'=>$rates['rateOfferingId'],'rateServiceId'=>$rates['rateServiceId'], 'cheapestPriceFlag'=>$rates['cheapestPriceFlag'], 'clockIconFlag'=>$rates['clockIconFlag'], 'offeringRowId'=>$rates['offeringRowId'], 'recordRowId'=>$rates['recordRowId'], 'fuelSurchargepercentage'=>$rates['fuelSurchargepercentage'], 'fuelSurchargePercentageAmount'=>$rates['fuelSurchargePercentageAmount'], 'fuelSurchargeFlatAmount'=> $rates['fuelSurchargeFlatAmount'], 'uomConversionId'=>$rates['uomConversionId'], 'rateServiceRowId'=>$rates['rateServiceRowId'], 'truckTypeCriteriaNotMatched'=>$truckTypeCriteriaNotMatched];
            }
        }
        foreach($customerData as $eachCustomer){
            foreach($vehicleTypeData as $eachVehicleType){
                $truckTypeCriteriaNotMatched = 0;
                if((!in_array($eachVehicleType['rowId'],$truckTypeConstraints)) && (!empty($truckTypeConstraints))){
                    $truckTypeCriteriaNotMatched = 1;
                }
                $finalRates[] = ['vendorId'=>"",'vendorName'=>"",'vendorCode'=>"",'customerId'=>$eachCustomer['rowId'],'customerName'=>$eachCustomer['name'],'customerCode'=>$eachCustomer['code'], 'vehicleTypeId'=>$eachVehicleType['rowId'],'vehicleType'=>$eachVehicleType['truckType'],'vendorProfile'=>$rates['vendorProfileId'],'vehicleProfile'=>$rates['vehicleProfileId'],'totalPrice'=>round($rates['totalPrice'],2),'currency'=>$rates['currency'],'rateRecordId'=>$rates['rateRecordId'],'rateOfferingId'=>$rates['rateOfferingId'],'rateServiceId'=>$rates['rateServiceId'], 'cheapestPriceFlag'=>$rates['cheapestPriceFlag'], 'clockIconFlag'=>$rates['clockIconFlag'], 'offeringRowId'=>$rates['offeringRowId'], 'recordRowId'=>$rates['recordRowId'], 'fuelSurchargepercentage'=>$rates['fuelSurchargepercentage'], 'fuelSurchargePercentageAmount'=>$rates['fuelSurchargePercentageAmount'], 'fuelSurchargeFlatAmount'=> $rates['fuelSurchargeFlatAmount'], 'uomConversionId'=>$rates['uomConversionId'], 'rateServiceRowId'=>$rates['rateServiceRowId'], 'truckTypeCriteriaNotMatched'=>$truckTypeCriteriaNotMatched];
            }
        }
        return $finalRates ?? [];
    }
    private function generateGeoPairs(array $pickupDetails, array $deliveryDetails, array $columnNames, array $geoHierarchy): array
    {
        $checkRegion = $this->OptimizeTripOrdersModel->checkRegionData($pickupDetails,$deliveryDetails);
        $pickupRegions = $checkRegion['pickupRegions'];
        $deliveryRegions = $checkRegion['deliveryRegions'];
        $escapedPickupRegions = array_map([$this->db, 'escape'], $pickupRegions);
        $escapedDeliveryRegions = array_map([$this->db, 'escape'], $deliveryRegions);
        $lanes = $geo = [];
        foreach ($pickupDetails as $pickupValue) {
            foreach ($deliveryDetails as $deliveryValue) {
                $geo[] = '(' . $columnNames[2] . ' = ' . $this->db->escape($pickupValue) . ' AND ' . $columnNames[3] . ' = ' . $this->db->escape($deliveryValue) . ')';
            }
        }
        array_push($pickupDetails,'Region');
        array_push($deliveryDetails,'Region');
        $pickupCountry = $pickupDetails[3];
        $deliveryCountry = $deliveryDetails[3];
        foreach ($pickupDetails as $pickupKey => $pickupvalue) {
            foreach ($deliveryDetails as $deliveryKey => $deliveryValue) {
                if($geoHierarchy[$pickupKey] == 1){
                    if((!empty($escapedPickupRegions)) && ($deliveryValue != "Region")){
                        $lanes[] = '( lm.source_geo = ' . $geoHierarchy[$pickupKey]
                            . ' AND ' . $columnNames[0] . ' IN (' . implode(',', $escapedPickupRegions) . ')'
                            . ' AND lm.source_country = '.$this->db->escape($pickupCountry)
                            . ' AND lm.destination_geo = ' . $geoHierarchy[$deliveryKey]
                            . ' AND ' . $columnNames[1] . ' = ' . $this->db->escape($deliveryValue) . ')';
                    }
                }else{
                    if($geoHierarchy[$deliveryKey] == 1){
                        if((!empty($escapedDeliveryRegions)) && ($pickupValue != "Region")){
                            $lanes[] = '( lm.source_geo = ' . $geoHierarchy[$pickupKey] 
                                . ' AND ' . $columnNames[0] . ' = ' . $this->db->escape($pickupvalue) 
                                . ' AND lm.destination_geo = ' . $geoHierarchy[$deliveryKey] 
                                . ' AND ' . $columnNames[1] . ' IN ('  . implode(',', $escapedDeliveryRegions) . ')'
                                . ' AND lm.destination_country = '.$this->db->escape($deliveryCountry) . ')';
                        }
                    }else{
                        if(!in_array('Region',[$pickupValue, $deliveryValue])){
                            $lanes[] = '( lm.source_geo = ' . $geoHierarchy[$pickupKey] 
                                . ' AND ' . $columnNames[0] . ' = ' . $this->db->escape($pickupvalue) 
                                . ' AND lm.destination_geo=' . $geoHierarchy[$deliveryKey] 
                                . ' AND ' . $columnNames[1] . ' = ' . $this->db->escape($deliveryValue) . ')';
                        }
                    }
                }
            }
        }
        
        $lanesCondition = implode(' OR ', $lanes);
        $geoCondition = implode(' OR ', $geo);
        return ['lanesCondition' => $lanesCondition, 'geoCondition' => $geoCondition];
    }

    private function generateGeoPairsForGeoTierTable(array $pickupData, array $destinationData, array $geoKeys, array $geoHierarchy): array
    {
        foreach ($pickupData as $pickupKey => $pickupValue) {
            foreach ($destinationData as $deliveryKey => $deliveryValue) {
                if ($pickupKey == $deliveryKey) {
                    $output[$geoHierarchy[$deliveryKey]] = '(' . $geoKeys[0] . ' = ' . $this->db->escape($pickupValue) . ' AND ' . $geoKeys[1] . ' = ' . $this->db->escape($deliveryValue) . ')';
                }
            }
        }
        return $output ?? [];
    }

    public function getIndividualRateCharges()
    {
        $postData = $this->input->post(NULL,TRUE);
        $pickupData = [$postData['fromPincode'], $postData['fromCity'], $postData['fromProvince'], $postData['fromCountry']];
        $destinationData = [$postData['toPincode'], $postData['toCity'], $postData['toProvince'], $postData['toCountry']];
        $geoTierPairs = $this->generateGeoPairsForGeoTierTable($pickupData, $destinationData, ['gsheet.geo_from', 'gsheet.geo_to'],['POSTAL CODE','CITY','PROVINCE','COUNTRY']);
        $postData['geoTierPairs'] = $geoTierPairs;
        $orderAddonsVasId = $postData['orderAddonsVasId'] ?? [];
        $orderAddonsQuantity = $postData['orderAddonsQuantity'] ?? [];
        $i = 0;
        foreach($orderAddonsVasId as $eachLine){
            $quantity = $orderAddonsQuantity[$i] ?? 0;
            if($quantity > 0){
                $orderAddons[] = ['vasId'=>$eachLine,'quantity'=>$quantity];
                $i++;
            }
        }
        $postData['orderAddons'] = $orderAddons ?? [];
        $data['getAllCharges'] = $this->OptimizeTripOrdersModel->getAllRateChargesList($postData);
        $data['tableHeaders'] = ['Charge Code', 'Charge Description', 'Rate Id', 'Amount', 'Currency'];
        $fuelSurchargeAmount= ($postData['fuelSurchargeFlatAmount']  > 0) ? $postData['fuelSurchargeFlatAmount'] : (($postData['fuelSurchargePercentageAmount']  > 0) ? $postData['fuelSurchargePercentageAmount'] : 0 );
        if($fuelSurchargeAmount > 0){
            $data['fuelSurchargeRow'] = ['FAF', 'FAF', $postData['rateRecordId'], round($fuelSurchargeAmount,2), $this->sessionCurrency];
        }
        echo $this->load->view('orders/IndividualChargesView',$data, TRUE);
    }

    public function addRatesToTripWithoutPreference()
    {
        $currentDate = date('Y-m-d H:i:s');
        $postData = $this->input->post(NULL,TRUE);
        $pickupData = [$postData['fromPincode'], $postData['fromCity'], $postData['fromProvince'], $postData['fromCountry']];
        $destinationData = [$postData['toPincode'], $postData['toCity'], $postData['toProvince'], $postData['toCountry']];
        $geoTierPairs = $this->generateGeoPairsForGeoTierTable($pickupData, $destinationData, ['gsheet.geo_from', 'gsheet.geo_to'],['POSTAL CODE','CITY','PROVINCE','COUNTRY']);
        $postData['geoTierPairs'] = $geoTierPairs;
        $orderAddonsVasId = $postData['orderAddonsVasId'] ?? [];
        $orderAddonsQuantity = $postData['orderAddonsQuantity'] ?? [];
        $i = 0;
        foreach($orderAddonsVasId as $eachLine){
            $quantity = $orderAddonsQuantity[$i] ?? 0;
            if($quantity > 0){
                $orderAddons[] = ['vasId'=>$eachLine,'quantity'=>$quantity];
                $i++;
            }
        }
        $postData['orderAddons'] = $orderAddons ?? [];
        $allCharges = $this->OptimizeTripOrdersModel->getAllRateChargesList($postData);
        $individualCharges = $allCharges['individualCharges'];
        $geoTiers = $allCharges['geoTiers'];
        $ratTiers = $allCharges['ratTiers'];
        $chargeCodes = $allCharges['chargeCodes'];
        $tariffType = $postData['tariffType'] ?? 'BUY';
        $recipientRole = ($tariffType == "BUY") ? "Carrier" : "Customer";
        $orderIds = $postData['orderIds'];
        $getShiftId = $this->common->gettblrowdata("id IN (" . $orderIds . ")", "shift_id", "tb_orders", 0, 0);
        $shiftId = $getShiftId['shift_id'] ?? 0;
        $tripRevenue = ['type'=>($tariffType == "BUY") ? 1 : 0,'shift_id'=>$shiftId,'recipient_role '=>$recipientRole,'recipient_code'=>$postData['code'],'recipient_name'=>$postData['name'],'amount'=>0,'actual_amount'=>0,'currency'=>$this->sessionCurrency,'user_id'=>$this->userId,'createdon'=>$currentDate,'source_created'=>'AT - Apply Tariffs'];
        $revenueId = $this->common->insertTableData('trip_reveneus', $tripRevenue);
        $totalAmount = 0;
        foreach($individualCharges as $eachCharge){
            $chargeId = $eachCharge['chargeId'];
            $chargeDescription = $chargeCodes[$chargeId] ?? [];
            $totalAmount += $eachCharge['amount'];
            $rateId = $eachCharge['rateId'];
            $rateId = ($eachCharge['geoTierId'] ?? 0) > 0 ? $geoTiers[$eachCharge['geoTierId']] : $rateId;
            $rateId = ($eachCharge['rateTierId'] ?? 0) > 0 ? $ratTiers[$eachCharge['rateTierId']] : $rateId;
            $charges[] = ['revenue_id'=>$revenueId,'charge_code'=>$eachCharge['chargeId'],'description'=>$chargeDescription['name'] ?? "",'quantity_unit'=>'1','value'=>'1','rate_id'=>$rateId,'amount'=>$eachCharge['amount'],'currency'=>$eachCharge['currency'],'local_amount'=>$eachCharge['amount'],'local_currency'=>$eachCharge['currency'],'rate_service_id'=>$postData['rateServiceRowId'],'rate_offering_id'=>$postData['offeringRowId'],'rate_record_id'=>$postData['recordRowId'],'total_amount'=>$eachCharge['amount'],'user_id'=>$this->userId,'source_created'=>'AT - Apply Tariffs','createdon'=>$currentDate]; 
        }
        $fuelSurchargeAmount= ($postData['fuelSurchargeFlatAmount']  > 0) ? $postData['fuelSurchargeFlatAmount'] : (($postData['fuelSurchargePercentageAmount']  > 0) ? $postData['fuelSurchargePercentageAmount'] : 0 );
        if($fuelSurchargeAmount > 0){
            $amount = round($fuelSurchargeAmount,2);
            $totalAmount += $amount;
            $charges[] = ['revenue_id'=>$revenueId,'charge_code'=>'38','description'=>"FAF",'quantity_unit'=>'1','value'=>'1','rate_id'=>$postData['rateRecordId'],'amount'=>$amount,'currency'=>$this->sessionCurrency,'local_amount'=>$amount,'local_currency'=>$this->sessionCurrency,'rate_service_id'=>$postData['rateServiceRowId'],'rate_offering_id'=>$postData['offeringRowId'],'rate_record_id'=>$postData['recordRowId'],'total_amount'=>$amount,'user_id'=>$this->userId,'source_created'=>'AT - Apply Tariffs','createdon'=>$currentDate];
        }
        if(!empty($charges ?? [])){
            $this->common->insertbulk("trip_charges", $charges);
            $this->common->updatetbledata("trip_reveneus", ['actual_amount' => $totalAmount, 'amount' => $totalAmount], ['id' => $revenueId]);
        }
        echo "1";exit;
    }
}
?>