<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class OrderCo2ReportCron extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('OrderCo2Model');
        $this->load->library('OrdersCo2Update');
    }

    public function index()
    {
        $orderInfo = $this->OrderCo2Model->getClosedShipmentOrders();
        if (empty($orderInfo)) {
            echo "There is no Closed Orders for Co2 Report";
            log_message("error", "There is no Closed Orders for Co2 Report: " . date("d.m.Y H:i"));
            return;
        }
        try {
            $reponse = $this->ordersco2update->updateOrdersCo2Information($orderInfo);
            echo $reponse;
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While updating the CO2 Report " . $ex->getMessage());
        }
    }
}
