<?php if (!defined('BASEPATH')) {

  exit('No direct script access allowed');

}

class Ordercargoupdateexcel extends CI_Controller {

  	public function __Construct() {

	    parent::__Construct();

	    if ($this->session->userdata('user_id') == '') {
	      redirect('login');
	    }
        $this->load->model("common");
        $this->load->library('Ratemanagement');
        $this->load->library('Vatcalculationtorate');
        $this->load->model("Orderrevenuesmodel");
  	}

  	public function index(){
  		echo "To update Order Cargo by excel";
  	}
  	public function getexceldata(){
	  	ini_set('max_execution_time', 300);
	    require_once APPPATH . "/third_party/PHPExcel.php";
	    require_once APPPATH . "/third_party/PHPExcel/Writer/Excel2007.php";
	    $all_data = array();
	    $data =  $errorline= $message  =  array();
	    if (isset($_FILES['exlcargoupfile'])) {
		    $ext = pathinfo($_FILES['exlcargoupfile']['name'], PATHINFO_EXTENSION);
		    $value = [];
		    $val = [];
			if ($ext == "xls" || $ext == "xlsx") {
		        $path = $_FILES['exlcargoupfile']['tmp_name'];
		        $objPHPExcel = PHPExcel_IOFactory::load($path);
		        $cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
		        $data["arr_data"]=array();
		        foreach ($cell_collection as $cell) {
		          $column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
		          $row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
		          $data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
		          $newdtat[] = $column;
		          if ($row == 1) {
		              $data["header"][$row][$column] = $data_value;
		          } else if($row > 1){
		              $data["arr_data"][$row][$column] = $data_value;
		          }
		        }
		        $data['order_details'] = array();
		        $row = 2;
		        $arr=[];
		        $sno="";
		       $i=0;
		        foreach ($data["arr_data"] as $value[$row]) {
		        	$booking_id = isset($value[$row]['A']) ? $value[$row]['A'] : "";
			        if($sno != $booking_id){
			            if($booking_id != ""){
			                $sno = $booking_id;
			                $value[$row]['row'] = $row;
			                $arr[$sno][]=$value[$row];
			                $row++;
			            }else{
			                $value[$row]['row'] = $row;
			                $arr[$sno][]=$value[$row];
			                 $row++;
			            }
			        }else{
			            $value[$row]['row'] = $row;
			            $arr[$sno][]=$value[$row];
			            $row++;
			        }
			        $i++;
		        }
		        $arrdata = array();
		        if(!empty($arr)){
		          foreach($arr as $ar){
		            $arrdata[] = $ar;
		          }
		        }
		        if(!empty($arrdata)){
		        	if(!empty($arrdata)){
		        		$this->showviewpageforcargo($arrdata);
		        	}

		        }

		  	}
		}
	}

    public function showviewpageforcargo($arrdata)
    {
        $bookingIds = $errorLine = $message = [];
        if (!empty($arrdata)) {
            for ($i = 0; $i < count($arrdata); $i++) {
                $rowNo = $arrdata[$i]['0']['row'] ?? "";
                $bookingId = $arrdata[$i]['0']['A'] ?? "";
                if ($bookingId == "") {
                    $message[] = "Booking ID empty on line: " . $rowNo;
                    $errorLine[] = "booking_id" . $rowNo;
                } else {
                    $bookingIds[] = $bookingId;
                }
                $packageType = $arrdata[$i]['0']['B'] ?? "";
                if ($packageType == "") {
                    $message[] = "Package Type empty on line: " . $rowNo;
                    $errorLine[] = "package_type" . $rowNo;
                }
                $quantity = isset($arrdata[$i]['0']['C']) ? round($arrdata[$i]['0']['C']) : "";
                $secondWeight = $arrdata[$i]['0']['D'] ?? "";
                if ($this->getCargosCount($bookingId, $packageType) > 1) {
                    if ($quantity != "" && $packageType == "") {
                        $message[] = "Package Type missing on line: " . $rowNo;
                        $errorLine[] = "package_type_additional" . $rowNo;
                    }
                }
                $secondVolume = $arrdata[$i]['0']['E'] ?? "";
                $actualWeight = $arrdata[$i]['0']['F'] ?? "";
                $actualVolume = $arrdata[$i]['0']['G'] ?? "";
                $validateValues = [
                    'quantity'=> [
                        'message' => 'Quantity empty on line: ',
                        'value' => $quantity,
                    ],
                    'second_weight' => [
                        'message' => 'Weight empty on line: ',
                        'value' =>  $secondWeight,
                    ],
                    'second_volume' => [
                        'message' => 'Volume empty on line: ',
                        'value' => $secondVolume,
                    ],
                     'actual_weight' => [
                        'message' => 'Actual Weight empty on line: ',
                        'value' => $actualWeight,
                    ],
                     'actual_volume' => [
                        'message' => 'Actual Volume empty on line: ',
                        'value' => $actualVolume,
                    ],
                ];
                foreach ($validateValues as $key => $values) {
                    if ($values['value'] == "" || !is_numeric($values['value'])) {
                        $message[] = $values['message'] . $rowNo;
                        $errorLine[] = $key . $rowNo;
                    }
                }
                if ($bookingId != "") {
                    $data['cargo_details'][] = [
                        'booking_id' => $bookingId,
                        'quantity' => $quantity,
                        'second_weight' => $secondWeight,
                        'second_volume' => $secondVolume,
                        'actual_weight' => $actualWeight,
                        'actual_volume' => $actualVolume,
                        'row_no' => $rowNo,
                        'package_type' => $packageType,
                    ];
                }
            }
        }
        if (!empty($bookingIds)) {
            $existingBookingIds = $this->checkbookingidexistsornot($bookingIds);
            $nonExistingBookingIds = array_diff($bookingIds, $existingBookingIds);
        }
        $data['existing_booking_ids'] = $existingBookingIds ?? [];
        $data['non_existing_booking_ids'] = $nonExistingBookingIds ?? [];
        $data['error_line'] = $errorLine;
        $data['message'] = $message;
        $data['page_title'] = "Order Cargo Details Update";
        $this->settemplate->dashboard("orders/ordercargoexcel", $data);
    }

    public function checkbookingidexistsornot($bid_ar){
		$result = $response = array();
		$booking_ids = array_unique($bid_ar);
		$company_code = $this->session->userdata('company_code');
		$user_id = $this->session->userdata('user_id');
		$whr = "";
		if(!empty($booking_ids)){
			$whr = " order_id IN ('" . implode("','", $booking_ids) . "') AND  ";
		}
		if($whr != ""){
			$whr .= " user_id ='".$user_id."' ";
			$response = $this->Orderrevenuesmodel->checkbookingidexistsornot($whr);
			if(!empty($response)){
				foreach ($response as $row) {
					$result[] = $row['order_id'];
				}
			}
		}
		return $result;
	}
	public function saveordercargo(){
	    //log_message("error","OrderCargo:");
		$cdate = date('Y-m-d H:i:s');
    	$user_id = $this->session->userdata('user_id');
    	$company_code = $this->session->userdata('company_code');
    	$rowid = $order_cargo_rowid =$chkbillsts = $chkrevexistssts = $chkrev1sts = 0;
    	//log_message("error","orders:".json_encode($_POST['orders']));
    	if(!empty($_POST['orders'])){
	    	foreach($_POST['orders'] as $data){
	    		$info['booking_id']    = isset($data['booking_id']) ? $data['booking_id'] : "0";
	    		$info['package_type']  = isset($data['package_type']) ? $data['package_type'] : "";
	    		$info['quantity']      = isset($data['quantity']) ? $data['quantity'] : "1";
	    		$info['actual_weight'] = isset($data['actual_weight']) ? $data['actual_weight'] : "0";
	    		$info['actual_volume'] = isset($data['actual_volume']) ? $data['actual_volume'] : "0";
	    		$info['second_weight'] = isset($data['second_weight']) ? $data['second_weight'] : "0";
	    		$info['second_volume'] = isset($data['second_volume']) ? $data['second_volume'] : "0";
	    		$booking_id            = $info['booking_id'];
	    		if($booking_id >0){
	    			$getorder_id = $this->common->gettblrowdata(array('order_id'=>$booking_id,'status!='=>'0','user_id'=>$user_id),"id","tb_orders",0,0);
	    			$order_id = 0;
	    			if(!empty($getorder_id)){
	    				$order_id = $getorder_id['id'];
	    			}
	    			$info['order_id'] = $order_id;
	    			$chkrevexistssts = 1;
	    			$norecords = 1;
	    			/* Check if records are there or not if yes need to check if billed .If billed then should not update */
	    			$chkrevexists = $this->common->gettbldata(array('order_id'=>$order_id,'type'=>'0','status'=>'1'),"id","tb_reveneus",0,0);
	    			if(!empty($chkrevexists)){
	    				$norecords = 0;
	    			}
	    			/* If no records for revenue or cost need to update so manually kept value as 1 */
	    			if($norecords == 1){
	    				$chkrev1sts = $chkbillsts = 1;
	    			}else{
	    				/* Checking if billed or not for chkrev1 */
	    				if($order_id >0){
		    				/* Checking if billed one is sent to acon or not If send then need to update else shoould not update */
		    				$chkrev = $this->common->gettbldata(array('order_id'=>$order_id,'type'=>'0','status'=>'1','invoice_status'=>'2','bill_id>'=>'0'),"id,type,bill_id","tb_reveneus",0,0);
		    				if(!empty($chkrev)){
		    					foreach ($chkrev as $rev) {
		    						$chkbillsts = 0;
		    						$bill_id = $rev['bill_id'];
		    						/* If status = 2 that means acon is sent */
		    						$chkbill_status= $this->common->gettblrowdata(array('id'=>$bill_id,'status'=>'2'),"id","tbl_bills",0,0);
		    						if(empty($chkbill_status)){
		    							$chkbillsts=1;
		    							break;
		    						}
		    					}
		    				}else{
		    					$chkbillsts = 1;
		    				}
		    				$chkrev1 = $this->common->gettbldata(array('order_id'=>$order_id,'type'=>'0','status'=>'1','invoice_status<'=>'2'),"id,type,bill_id","tb_reveneus",0,0);
		    				if(!empty($chkrev1)){
		    					$chkrev1sts = 1;
		    					$chkbillsts = 1;
		    				}else{
		    					if($chkbillsts == 1){
		    						$chkrev1sts = 1;
		    					}
		    				}
		    			}
	    			}
	    			if($chkrev1sts == 1 && $chkbillsts == 1 && $chkrevexistssts == 1){
                                        $where = array("order_id" => $order_id);
                                        if(trim($info['package_type'])!='' && strlen($info['package_type'])>1){
                                            $where['quantity_type'] = $info['package_type'];
                                        }
    					$chksingleline = $this->common->gettblrowdata($where,"count(id) as line","tb_order_cargodetails",0,0);
	    				if(!empty($chksingleline)){
	    					$single_line = $chksingleline['line'];
	    					//log_message("error","single_line:".$single_line);
	    					if($single_line == 1){
	    						/* Scenario 1 : if order is having only 1 cargo line , then given values in excel should be updated */
	    						//log_message("error","info:".json_encode($info));
	    						$this->updatesinglelineordercargo($info);
	    					}else{
	    						/* Scenario 1 : if order is having more than 1 cargo line , then given values in excel should be updated based on package type if given , if package type not given then all should be updated */
	    						//log_message("error","info11:".json_encode($info));
	    						$this->updatemultilineordercarrgos($info);
	    					}
	    				}
    				}
	    		}
	    	}
	    }
	    redirect("orders");
	}

	public function updatemultilineordercarrgos($info){
		$upd = array();
		$total_weight = $total_secondweight = $total_volume = $total_secondvolume = $total_quantity = 0;
		if(!empty($info)){
			$order_id        = $info['order_id'];
			$actual_weight   = $info['actual_weight'];
			$actual_volume   = $info['actual_volume'];
			$second_volume   = $info['second_volume'];
			$second_weight   = $info['second_weight'];
			$package_type    = $info['package_type'];
			$quantity        = $info['quantity'];
			$whr = array();
			if($package_type != ""){
				$whr = array('order_id'=>$order_id,'status'=>'1','quantity_type'=>$package_type);
			}else{
				$whr = array('order_id'=>$order_id,'status'=>'1');
			}
			if($package_type == ""){
				$getordercargototaldetails = $this->Orderrevenuesmodel->getallordercargodetails($order_id);
				if(!empty($getordercargototaldetails)){
					foreach ($getordercargototaldetails as $details) {
						$total_weight        = $getordercargototaldetails['total_weight'];
						$total_secondweight  = $getordercargototaldetails['second_weight'];
						$total_volume        = $getordercargototaldetails['total_volume'];
						$total_secondvolume  = $getordercargototaldetails['second_volume'];
						$total_quantity      = $getordercargototaldetails['total_quantity'];
					}
				}
			}else{
				$getordercargototaldetails = $this->common->gettblrowdata(array('order_id'=>$order_id,'quantity_type'=>$package_type,'status'=>'1'),"sum(weight) as total_weight,sum(second_weight) as second_weight,sum(volume) as total_volume,sum(second_volume) as second_volume,sum(quantity) as quantity","tb_order_cargodetails",0,0);
				if(!empty($getordercargototaldetails)){
					$total_weight        = $getordercargototaldetails['total_weight'];
					$total_secondweight  = $getordercargototaldetails['second_weight'];
					$total_volume        = $getordercargototaldetails['total_volume'];
					$total_secondvolume  = $getordercargototaldetails['second_volume'];
					$total_quantity      = $getordercargototaldetails['quantity'];
				}
			}
			
			if(!empty($whr)){
				$getorderdetails = $this->common->gettbldata($whr,"id,cargo_id,weight,second_weight,volume,second_volume,quantity","tb_order_cargodetails",0,0);
				//log_message("error","query:".$this->db->last_query());

				/*
				*  Here $quantity is received data from excel sheet
                */
                $excel_global_quantity = $quantity;
            	if(!empty($getorderdetails)){
                    $order_cargos_count=sizeof($getorderdetails);
                    if($excel_global_quantity > $order_cargos_count){
                    	$default_update_quantity = 1;
                    }else{
                     	$default_update_quantity = 0;
                    }
                    $last_hit = 0;
    				if(!empty($getorderdetails)){
    					foreach ($getorderdetails as $cargos) {
    						$order_weight  = $cargos['weight'];
    						$order_cargoid = $cargos['id'];
    						$cargoid       = $cargos['cargo_id'];
    						if($actual_weight >0){
                                if(is_numeric($total_weight) && $total_weight>0){
                                    $calc_weight    = $actual_weight/$total_weight;
                                }else{
                                    $calc_weight    = $actual_weight;
                                }
    							$updated_weight = $calc_weight * $order_weight;
    							$upd['weight']  = $updated_weight;
    						}
    						$order_second_weight = $cargos['second_weight'];
    						if($second_weight >0){
                                                            if(is_numeric($total_secondweight) && $total_secondweight>0){
                                                                $calc_secweight       = $second_weight/$total_secondweight;
                                                            }else{
                                                                $calc_secweight       = $second_weight;
                                                            }
    							$updated_secweight    = $calc_secweight * $order_second_weight;
    							$upd['second_weight'] = $updated_secweight;
    						}
    						$order_volume = $cargos['volume'];
    						if($actual_volume >0){
                                                            if(is_numeric($total_volume) && $total_volume>0){
                                                                $calc_volume    = $actual_volume/$total_volume;
                                                            }else{
                                                                $calc_volume    = $actual_volume;
                                                            }
    							$updated_volume = $calc_volume * $order_volume;
    							$upd['volume']  = $updated_volume;
    						}
    						$order_second_volume = $cargos['second_volume'];
    						if($second_volume >0){
                                                            if(is_numeric($total_secondvolume) && $total_secondvolume>0){
                                                                $calc_secvolume       = $second_volume/$total_secondvolume;
                                                            }else{
                                                                $calc_secvolume       = $second_volume;
                                                            }
    							$updated_secvolume    = $calc_secvolume * $order_second_volume;
    							$upd['second_volume'] = $updated_secvolume;
    						}
    					/*	if($package_type != ""){*/
    						$order_quantity = $cargos['quantity'];
    						if(is_numeric($excel_global_quantity) && is_numeric($total_quantity) && $total_quantity >0 && $excel_global_quantity>0){
    							if($quantity >0){
    								// $calc_quantity    = $quantity/$total_quantity;
    								// $updated_quantity = $calc_quantity * $order_quantity;
    								// $upd['quantity']  = $updated_quantity;
    							}
    							if($last_hit == $order_cargos_count-1){
    								$upd['quantity']  = $excel_global_quantity;
    							}else{
    								$upd['quantity']  = $default_update_quantity;
    							}
    							if($default_update_quantity==1){
    								$excel_global_quantity--;
    							}
    							$last_hit=$last_hit+1;
    						}
    						/*}*/
    						$ordercaro_update = $this->common->updatetbledata("tb_order_cargodetails",$upd,array('id'=>$order_cargoid));
    						$cargo_update = $this->common->updatetbledata("tb_cargo_details",$upd,array('id'=>$cargoid));
    					}
    				}
    			}
    		}
			$this->updateratemanagement($order_id);
		}
	}
	public function updatesinglelineordercargo($info){
		$order_cargo_rowid = $cargo_id = 0;
		if(!empty($info)){
			$order_id        = $info['order_id'];
			$actual_weight   = $info['actual_weight'];
			$actual_volume   = $info['actual_volume'];
			$second_volume   = $info['second_volume'];
			$second_weight   = $info['second_weight'];
			$package_type    = $info['package_type'];
			$quantity        = $info['quantity'];
			$getorderdetails = $this->common->gettblrowdata(array('order_id'=>$order_id,'status'=>'1'),"id,cargo_id","tb_order_cargodetails",0,0);
			if(!empty($getorderdetails)){
				$cargo_id = $getorderdetails['cargo_id'];
				$order_cargo_rowid = $getorderdetails['id'];
			}
			if($order_cargo_rowid >0){
				if($quantity >0){
					$updar['quantity'] = $quantity;
				}
				if($actual_weight >0){
					$updar['weight'] = $actual_weight;
				}if($actual_volume >0){
					$updar['volume'] = $actual_volume;
				}if($second_volume >0){
					$updar['second_volume'] = $second_volume;
				}if($second_weight >0){
					$updar['second_weight'] = $second_weight;
				}
				$upd = $this->common->updatetbledata("tb_order_cargodetails",$updar,array('id'=>$order_cargo_rowid));
				$cargo_update = $this->common->updatetbledata("tb_cargo_details",$updar,array('id'=>$cargo_id));
			}
			$this->updateratemanagement($order_id);

		}

	}
	public function addnewcargodetailsfororder($data){
		$cdate = date('Y-m-d H:i:s');
		$user_id = $this->session->userdata('user_id');
		if(!empty($data)){
			$package_type = $data['package_type'];
			$handlingunit_id = 0;
			if($package_type != ""){
				$chkhandlingunit = $this->common->gettblrowdata(array('unit_name'=>$package_type),"id","tb_handling_units",0,0);
				if(!empty($chkhandlingunit)){
					$handlingunit_id = $chkhandlingunit['id'];
				}else{
					$inshandlingar =array('unit_name'=>$package_type,'description'=>$package_type,'status'=>'1','createdon'=>$cdate);
					$handlingunit_id = $this->common->insertTableData("tb_handling_units",$inshandlingar);
				}
				$cargo_ins = array('cargo_type'=>$package_type,'handling_unit'=>$package_type,'handlingunit_id'=>$handlingunit_id,'length'=>'1','length_unit'=>'M','width'=>'1','width_unit'=>'M','height'=>'1','height_unit'=>'M','weight'=>$data['actual_weight'],'second_weight'=>$data['second_weight'],'secondweight_uom'=>'Kg','volumetric_weight'=>'0','volweight_uom'=>'Kg','ldm'=>'0','weight_unit'=>'Kg','volume'=>$data['actual_volume'],'second_volume'=>$data['second_volume'],'secondvolume_uom'=>'cbm','volume_unit'=>'cbm','quantity'=>$data['quantity'],'status'=>'1','stackable'=>0,'grounded'=>0,'splittable'=>0,'dg_goods'=>0,'createdby'=>$user_id,'createdon'=>$cdate);
				$cargo_id= $this->common->insertTableData("tb_cargo_details",$cargo_ins);
				$ins_order = array('order_id'=>$data['order_id'],'cargo_id'=>$cargo_id,'handling_unit'=>$handlingunit_id,'length'=>'1','width'=>'1','height'=>'1','weight'=>$data['actual_weight'],'second_weight'=>$data['second_weight'],'volumetric_weight'=>'0','volweight_uom'=>'Kg','ldm'=>'0','volume'=>$data['actual_volume'],'second_volume'=>$data['second_volume'],'quantity'=>$data['quantity'],'scanned_quantity'=>'0','quantity_type'=>$package_type,'status'=>'1','createdon'=>$cdate);
				$order_cargoid= $this->common->insertTableData("tb_order_cargodetails",$ins_order);
			}
		}
		$order_id = $data['order_id'];

	}

	public function checkratetierexistsornot($tier_id,$user_id,$revenue_id,$offering_id,$order_id,$type,$charge_id,$rate_service_id,$rate_record_id){
		$chk = $vat_percentage = $totalwit_vat = $vat_amount = 0;
		$cdate = date('Y-m-d H:i:s');
		if($offering_id == ""){
			$offering_id = 0;
		}
		if(is_null($offering_id)){
			$offering_id = 0;
		}
		$currency = $this->session->userdata("usr_tzone")['currency'];
		$gettier_rowid = $this->common->gettblrowdata(array('id'=>$tier_id,'status'=>1),"tier_id","tb_tier_master",0,0);
		if(!empty($gettier_rowid)){
			$chk = 1;
			$record_id = $gettier_rowid['tier_id'];
			$tier_ar = $this->ratemanagement->getratechargeamount_bytier($offering_id,$tier_id,$order_id,$type,$user_id);
			if(!empty($tier_ar)){
				$total_amount = isset($tier_ar['cost']) ? $tier_ar['cost'] : 0;
				$getchargeid = $this->common->gettblrowdata(array('revenue_id'=>$revenue_id,'charge_code'=>$charge_id,'rate_id'=>$record_id,'status'=>'1'),"id,vat_percentage,vat_amount","tb_charges",0,0);
				if(!empty($getchargeid)){
					$charge_row_id  = $getchargeid['id'];
					$vat_percentage = $getchargeid['vat_percentage'];
					$vat_amount     = $getchargeid['vat_amount'];
					$totalwit_vat   = $total_amount;
	                if($vat_percentage >0){
	                	$vat_amount = ($vat_percentage * $total_amount) / 100;
						$totalwit_vat = $total_amount + $vat_amount;
	                }
	                $upcharge = $this->common->updatetbledata("tb_charges",array('amount'=>round($total_amount,4),'local_amount'=>round($total_amount,4),'vat_amount'=>round($vat_amount,4),'total_amount'=>round($totalwit_vat,4)),array('id'=>$charge_row_id));
				}else{
					$getchargename= $this->common->gettblrowdata(array('id'=>$charge_id,'status'=>'1'),"name","tb_charge_codes",0,0);
					$charge_name = "";
					if(!empty($getchargename)){
						$charge_name = $getchargename['name'];
					}
					$ins_ar = array('revenue_id'=>$revenue_id,'charge_code' => $charge_id, 'description' => $charge_name,'quantity_unit'=>'1','value'=>'1','rate_id'=>$record_id,'amount' => round($total_amount,4), 'currency' => $currency,'user_id'=>$user_id,'createdon'=>$cdate,'local_amount'=>round($total_amount,4),'local_currency'=>$currency,'status'=>'1');
					$this->common->insertTableData("tb_charges",$ins_ar);
					$rev_ids = array();
					$rev_ids[] = $revenue_id;
					$this->vatcalculationtorate->updatevattorevenues($rev_ids);
				}
			}
		}
		return $chk;
	}

	public function checkgeotierexistsornot($geo_tier_id,$user_id,$revenue_id,$offering_id,$order_id,$type,$charge_id,$rate_service_id,$rate_record_id){
		$chk = $totalwit_vat = $vat_percentage = $vat_amount = 0;
		$cdate = date('Y-m-d H:i:s');
		if($offering_id == ""){
			$offering_id = 0;
		}
		if(is_null($offering_id)){
			$offering_id = 0;
		}
		$currency = $this->session->userdata("usr_tzone")['currency'];
		$getuom = $this->common->gettblrowdata(array('id'=>$geo_tier_id,'status'=>'1'),"uom1,unit_measure1","tb_geo_tier",0,0);
		if(!empty($getuom)){
			$chk = 1;
			$uom1 = strtoupper($getuom['uom1']);
			$unit_measure1 = strtoupper($getuom['unit_measure1']);
			$charge_basis = $unit_measure1;
			$getcost = $this->common->gettblrowdata(array('geo_tier_id'=>$geo_tier_id,'status'=>'1'),"cost","tb_geo_tier_sheet",0,0);
			if(!empty($getcost)){
				$cost = $getcost['cost'];
				$total_amount = 0;
                $geo_tier_ar = $this->ratemanagement->getratechargeamount_bygeotier($offering_id,$geo_tier_id,$order_id,$type);
                if(!empty($geo_tier_ar)){
                    $record_id = $geo_tier_ar['geo_tier_id'];
                    $amount_ar = $geo_tier_ar['cost'];
                    if(!empty($amount_ar)){
                        $total_amount = isset($amount_ar['cost']) ? $amount_ar['cost'] : "";
                        $getchargeid = $this->common->gettblrowdata(array('revenue_id'=>$revenue_id,'charge_code'=>$charge_id,'rate_id'=>$record_id,'status'=>'1'),"id,vat_percentage,vat_amount","tb_charges",0,0);
						if(!empty($getchargeid)){
							$charge_row_id  = $getchargeid['id'];
							$vat_percentage = $getchargeid['vat_percentage'];
							$vat_amount     = $getchargeid['vat_amount'];
							$totalwit_vat   = $total_amount;
			                if($vat_percentage >0){
			                	$vat_amount = ($vat_percentage * $total_amount) / 100;
								$totalwit_vat = $total_amount + $vat_amount;
			                }
			                $upcharge = $this->common->updatetbledata("tb_charges",array('amount'=>round($total_amount,4),'local_amount'=>round($total_amount,4),'vat_amount'=>round($vat_amount,4),'total_amount'=>round($totalwit_vat,4)),array('id'=>$charge_row_id));
						}else{
							$getchargename= $this->common->gettblrowdata(array('id'=>$charge_id,'status'=>'1'),"name","tb_charge_codes",0,0);
							$charge_name = "";
							if(!empty($getchargename)){
								$charge_name = $getchargename['name'];
							}
							$ins_ar = array('revenue_id'=>$revenue_id,'charge_code' => $charge_id, 'description' => $charge_name,'quantity_unit'=>'1','value'=>'1','rate_id'=>$record_id,'amount' => round($total_amount,4), 'currency' => $currency,'user_id'=>$user_id,'createdon'=>$cdate,'local_amount'=>round($total_amount,4),'local_currency'=>$currency,'status'=>'1');
							$this->common->insertTableData("tb_charges",$ins_ar);
							$rev_ids = array();
	    					$rev_ids[] = $revenue_id;
							$this->vatcalculationtorate->updatevattorevenues($rev_ids);
						}
                    }
                }

			}
			if($offering_id >0){
				$offering_ids[] = $offering_id;
				$this->chkofferingexists_ornot($offering_ids,$revenue_id,$type,$user_id,$order_id);
			}
			if($rate_record_id >0){
				$record = $this->chkrecordexists_ornot($rate_record_id,$offering_id,$revenue_id,$type,$user_id,$order_id);
			}
		}
		return $chk;
	}

	public function chkrecordexists_ornot($rate_record_id,$offering_id,$revenue_id,$type,$user_id,$order_id){
		$cdate = date('Y-m-d H:i:s');
		/* check fixed type charge basis if any new one added or not */
		$total_weight = $total_volume = $total_ldm = 1;
		$getordercargototaldetails = $this->common->gettblrowdata(array('order_id'=>$order_id,'status'=>'1'),"sum(weight) as total_weight,sum(ldm) as total_ldm,sum(volume) as total_volume","tb_order_cargodetails",0,0);
			if(!empty($getordercargototaldetails)){
				$total_weight        = $getordercargototaldetails['total_weight'];
				$total_volume        = $getordercargototaldetails['total_volume'];
				$total_ldm           = $getordercargototaldetails['total_ldm'];
			}
		$chkraterecord  = $this->common->gettbldata(array('raterecord_id'=>$rate_record_id,'rr_charge_type'=>'FIXED','status'=>'1'),"id,rr_charge_type,rr_tier_id,geo_tier_id,rr_charge_id,charge_basis,min_amount,amount,currency","tb_raterecord_charges",0,0);
		if(!empty($chkraterecord)){
			foreach ($chkraterecord as $rec) {
				$charge_type  = strtoupper($rec['rr_charge_type']);
				$tier_id      = $rec['rr_tier_id'];
				$geo_tier_id  = $rec['geo_tier_id'];
				$charge_id    = $rec['rr_charge_id'];
				$charge_basis = strtoupper($rec['charge_basis']);
				$min_amount   = $rec['min_amount'];
				$amount       = $rec['amount'];
				$currency     = $rec['currency'];
				$unit2 = 1;
				if($charge_type == 'FIXED'){
					if($charge_basis == 'LDM' || $charge_basis =='PER LDM'){
						$charge_basis = 'LDM';
						$unit2 = $total_ldm;
					}
					if($charge_basis == 'CBM' || $charge_basis =='PER CBM'){
						$charge_basis = 'CBM';
						$unit2 = $total_volume;
					}
					if($charge_basis == 'KG' || $charge_basis =='PER KG'){
						$charge_basis = 'KG';
						$unit2 = $total_weight;
					}
					$unit_ar = $this->ratemanagement->claculateperkgamount($offering_id,$order_id,$user_id,$type,$amount,$charge_basis,'non-vas');
					if(!empty($unit_ar)){
                        $final_conversion = isset($unit_ar['final_conversion']) ? $unit_ar['final_conversion'] : '0';
                        if($final_conversion >0){
                            $unit2 = $final_conversion;
                        }
                    }
                    $total_amount = $unit2 * $amount;
					if($total_amount < $min_amount){
	                    $total_amount = $min_amount;
	                }
					$rate_id = $rate_record_id;
					$getrate_id = $this->common->gettblrowdata(array('id'=>$rate_record_id,'status'=>'1'),"rate_id","tb_rate_records",0,0);
					if(!empty($getrate_id)){
						$rate_id = $getrate_id['rate_id'];
						$getchargeid = $this->common->gettblrowdata(array('revenue_id'=>$revenue_id,'charge_code'=>$charge_id,'rate_id'=>$rate_id,'status'=>'1'),"id","tb_charges",0,0);
						if(empty($getchargeid)){
							$getchargename= $this->common->gettblrowdata(array('id'=>$charge_id,'status'=>'1'),"name","tb_charge_codes",0,0);
							$charge_name = "";
							if(!empty($getchargename)){
								$charge_name = $getchargename['name'];
							}
							$ins_ar = array('revenue_id'=>$revenue_id,'charge_code' => $charge_id, 'description' => $charge_name,'quantity_unit'=>'1','value'=>'1','rate_id'=>$rate_id,'amount' => round($total_amount,4), 'currency' => $currency,'user_id'=>$user_id,'createdon'=>$cdate,'local_amount'=>round($total_amount,4),'local_currency'=>$currency,'status'=>'1');
	    					$this->common->insertTableData("tb_charges",$ins_ar);
	    					$rev_ids = array();
	    					$rev_ids[] = $revenue_id;
	            			$this->vatcalculationtorate->updatevattorevenues($rev_ids);
						}
					}
				}
			}
		}
	}

	/* Update charges for the given order in excel based on rate record , rate offering,rate preference charges which are based on cargos */

	public function updateratemanagement($order_id){
		$rate_service = $offering_ids = $revenues = array();
		$unit2 = $offering_id = $charge_id = $totalwit_vat = $total_amount = $vat_amount = 0;
		$cdate = date('Y-m-d H:i:s');
		/* Check only revenues  which are not billed */
		$chkrev = $this->common->gettbldata(array('order_id'=>$order_id,'status'=>'1','invoice_status<'=>'2'),"id,type","tb_reveneus",0,0);
		if(!empty($chkrev)){
			foreach ($chkrev as $rev) {
				$revenues[] = array('id'=>$rev['id'],'type'=>$rev['type']);
			}
		}
		/*  Check revenues which are billed but not send to acon */
		$chkrev1 = $this->common->gettbldata(array('order_id'=>$order_id,'status'=>'1','invoice_status'=>'2','bill_id<>'=>'0'),"id,type,bill_id","tb_reveneus",0,0);
		if(!empty($chkrev1)){
			foreach ($chkrev1 as $rev) {
				$bill_id = $rev['bill_id'];
				$chkbill_status= $this->common->gettblrowdata(array('id'=>$bill_id,'status'=>'1'),"id","tbl_bills",0,0);
				if(!empty($chkbill_status)){
					$revenues[] = array('id'=>$rev['id'],'type'=>$rev['type']);
				}
			}
		}
		$total_volume = $total_weight = $total_ldm =$second_volume = $second_weight = $vat_percentage = 0;
		$secondweight_uom = $weight_unit ="";
		$currency = $this->session->userdata("usr_tzone")['currency'];
		$getorderdetails = $this->Orderrevenuesmodel->getallordercargodetails($order_id);
		if(!empty($getorderdetails)){
			$total_ldm = $getorderdetails['total_ldm'];
			$second_volume = $getorderdetails['second_volume'];
			$second_weight = $getorderdetails['second_weight'];
			$total_weight = $getorderdetails['total_weight'];
			$total_volume = $getorderdetails['total_volume'];
			$secondweight_uom = $getorderdetails['secondweight_uom'];
			$weight_unit = $getorderdetails['weight_unit'];
		}
		$user_id = $this->session->userdata('user_id');
		if(!empty($revenues)){
			foreach ($revenues as $res) {
				$revenue_id = $res['id'];
				$revtype = $res['type'];
				$type = 'SELL';
				if($revtype == '0'){
					$type = 'SELL';
				}else if($revtype == '1'){
					$type = 'BUY';
				}
				/* Get charges for the given reveue id which are having rate_id > 1*/
			    $getcharges = $this->common->gettbldata(array('revenue_id'=>$revenue_id,'status'=>'1'),"charge_code,rate_id,amount,rate_service_id,rate_offering_id,rate_record_id,status","tb_charges",0,0);
			    if(!empty($getcharges)){
			    	foreach ($getcharges as $charge) {
			    		$rate_id = $charge['rate_id'];
			    		$charge_id = $charge['charge_code'];
			    		$rate_service_id  = $charge['rate_service_id'];
			    		$rate_offering_id = $charge['rate_offering_id'];
			    		$rate_record_id   = $charge['rate_record_id'];
			    		if($rate_id != "1"&& $rate_id != ""){
			    			/* Get charges basis charges for rate record through rate id */
			    			$rate_record = $this->Orderrevenuesmodel->getraterecordcharges($rate_id);
			    			/* Check if rate_id in charges is from rate record or not */
			    			$chkraterecord  = $this->common->gettblrowdata(array('rate_id'=>$rate_id,'status'=>'1'),"id","tb_rate_records",0,0);
			    			if(!empty($chkraterecord)){
			    				$rate_row_id= $chkraterecord['id'];
								if(!empty($rate_record)){
				    				foreach ($rate_record as $rec) {
				    					$offering_ids[] = $rec['offering_id'];
				    					$charge_type= strtoupper($rec['rr_charge_type']);
				    					$tier_id= $rec['rr_tier_id'];
				    					$geo_tier_id= $rec['geo_tier_id'];
				    					$charge_id= $rec['rr_charge_id'];
				    					$charge_basis= strtoupper($rec['charge_basis']);
				    					$min_amount= $rec['min_amount'];
				    					$amount= $rec['amount'];
				    					$offering_id= $rec['offering_id'];
				    					$unit2 = 1;
				    					if($charge_type == 'FIXED'){
				    						if($charge_basis == 'LDM' || $charge_basis =='PER LDM'){
				    							$charge_basis = 'LDM';
				    							$unit2 = $total_ldm;
				    						}
				    						if($charge_basis == 'CBM' || $charge_basis =='PER CBM'){
				    							$charge_basis = 'CBM';
				    							$unit2 = $total_volume;
				    						}
				    						if($charge_basis == 'KG' || $charge_basis =='PER KG'){
				    							$charge_basis = 'KG';
				    							$unit2 = $total_weight;
				    						}
		    								$getchargeid = $this->common->gettblrowdata(array('revenue_id'=>$revenue_id,'charge_code'=>$charge_id,'rate_id'=>$rate_id,'status'=>'1'),"id,vat_percentage,vat_amount","tb_charges",0,0);
		    								if(!empty($getchargeid)){
		    									$charge_row_id  = $getchargeid['id'];
		    									$vat_percentage = $getchargeid['vat_percentage'];
		    									$vat_amount     = $getchargeid['vat_amount'];
		    									$unit_ar = $this->ratemanagement->claculateperkgamount($offering_id,$order_id,$user_id,$revtype,$amount,$charge_basis,'non-vas');
		    									if(!empty($unit_ar)){
				                                    $final_conversion = isset($unit_ar['final_conversion']) ? $unit_ar['final_conversion'] : '0';
				                                    if($final_conversion >0){
				                                        $unit2 = $final_conversion;
				                                    }
				                                }
				                                $total_amount = $unit2 * $amount;
		    									if($total_amount < $min_amount){
								                    $total_amount = $min_amount;
								                }
								                $totalwit_vat = $total_amount;
								                if($vat_percentage >0){
								                	$vat_amount = ($vat_percentage * $total_amount) / 100;
                    								$totalwit_vat = $total_amount + $vat_amount;
								                }
								                $upcharge = $this->common->updatetbledata("tb_charges",array('amount'=>round($total_amount,4),'local_amount'=>round($total_amount,4),'vat_amount'=>round($vat_amount,4),'total_amount'=>round($totalwit_vat,4)),array('id'=>$charge_row_id));
		    								}

				    					}else{
				    						$offering_id = $rate_offering_id;
				    						if(strtoupper($charge_type) == 'GEO TIER'){
				    							if(!is_null($geo_tier_id)){
				    								$this->checkgeotierexistsornot($geo_tier_id,$user_id,$revenue_id,$offering_id,$order_id,$revtype,$charge_id,$rate_service_id,$rate_record_id);
				    							}
				    						}else if(strtoupper($charge_type) == 'TIER'){
				    							if(!is_null($tier_id)){
				    								$this->checkratetierexistsornot($tier_id,$user_id,$revenue_id,$offering_id,$order_id,$revtype,$charge_id,$rate_service_id,$rate_record_id);
				    							}
				    						}
				    					}
				    				}
				    				$chkrateservice = $this->common->gettbldata(array('raterecord_id'=>$rate_row_id,'status'=>'1'),"raterecord_vas_id,raterecord_charge_id,charge_basis,min_amount,amount","tb_raterecord_services",0,0);
				    				$offering_rowid = $rate_offering_id;
				    				if(!empty($chkrateservice)){
				    					foreach ($chkrateservice as $service) {
				    						$vas_id = $service['raterecord_vas_id'];
					    					$raterecord_charge_id = $service['raterecord_charge_id'];
					    					$charge_basis = strtoupper($service['charge_basis']);
					    					$min_amount = $service['min_amount'];
					    					$amount = $service['amount'];
					    					$vat_percentage = $totalwit_vat = $vat_amount = 0;
					    					$chckchargeid = $this->common->gettblrowdata(array('revenue_id'=>$revenue_id,'charge_code'=>$raterecord_charge_id,'rate_id'=>$rate_id,'status'=>'1'),"id,vat_percentage,vat_amount","tb_charges",0,0);
					    					$chkvas = $this->common->gettblrowdata(array('order_id'=>$order_id,'vas_id'=>$vas_id,'status'=>'1'),"quantity","tb_order_vas",0,0);
					    					if(!empty($chckchargeid)){
					    						$charge_row_id  = $chckchargeid['id'];
					    						$vat_percentage = $chckchargeid['vat_percentage'];
					    						$vat_amount     = $chckchargeid['vat_amount'];
					    						$unit2 = 1;
					    						if(!empty($chkvas)){
					    							$vas_quantity = $chkvas['quantity'];
					    							if($charge_basis == 'PER KG' || $charge_basis == 'KG'){
					    								$unit2 = $total_weight;
					    							}
					    							if($charge_basis == 'PER CBM' || $charge_basis == 'CBM'){
					    								$unit2 = $total_volume;
					    							}
					    							if($charge_basis == 'PER LDM' || $charge_basis == 'LDM'){
					    								$unit2 = $total_ldm;
					    							}
					    							if($charge_basis == 'PER TRIP' || $charge_basis == 'TRIP'){
					    								$unit2 = $vas_quantity;
					    							}
					    							$unit_ar = $this->ratemanagement->claculateperkgamount($offering_rowid,$order_id,$user_id,$revtype,$amount,$charge_basis,'vas');
					    							if(!empty($unit_ar)){
					                                    $final_conversion = isset($unit_ar['final_conversion']) ? $unit_ar['final_conversion'] : '0';
					                                    if($final_conversion >0){
					                                        $unit2 = $final_conversion;
					                                    }
					                                }
					                                $total_amount = $unit2 * $amount;
					    							if($total_amount < $min_amount){
					    								$total_amount = $min_amount;
					    							}
					    							$totalwit_vat = $total_amount;
									                if($vat_percentage >0){
									                	$vat_amount = ($vat_percentage * $total_amount) / 100;
	                    								$totalwit_vat = $total_amount + $vat_amount;
									                }
					    							$upcharge = $this->common->updatetbledata("tb_charges",array('amount'=>round($total_amount,4),'local_amount'=>round($total_amount,4),'vat_amount'=>round($vat_amount,4),'total_amount'=>round($totalwit_vat,4)),array('id'=>$charge_row_id));
					    						}
					    					}else{
					    						$unit2 = 1;
					    						if(!empty($chkvas)){
					    							$vas_quantity = $chkvas['quantity'];
					    							if($charge_basis == 'PER KG' || $charge_basis == 'KG'){
					    								$unit2 = $total_weight;
					    							}
					    							if($charge_basis == 'PER CBM' || $charge_basis == 'CBM'){
					    								$unit2 = $total_volume;
					    							}
					    							if($charge_basis == 'PER LDM' || $charge_basis == 'LDM'){
					    								$unit2 = $total_ldm;
					    							}
					    							if($charge_basis == 'PER TRIP' || $charge_basis == 'TRIP'){
					    								$unit2 = $vas_quantity;
					    							}
					    							$unit_ar = $this->ratemanagement->claculateperkgamount($offering_rowid,$order_id,$user_id,$revtype,$amount,$charge_basis,'vas');
					    							if(!empty($unit_ar)){
					                                    $final_conversion = isset($unit_ar['final_conversion']) ? $unit_ar['final_conversion'] : '0';
					                                    if($final_conversion >0){
					                                        $unit2 = $final_conversion;
					                                    }
					                                }
					                                $total_amount = $unit2 * $amount;
					    							if($total_amount < $min_amount){
					    								$total_amount = $min_amount;
					    							}
					    							$getchargename= $this->common->gettblrowdata(array('id'=>$raterecord_charge_id,'status'=>'1'),"name","tb_charge_codes",0,0);
			    									$charge_name = "";
			    									if(!empty($getchargename)){
			    										$charge_name = $getchargename['name'];
			    									}
					    							$ins_ar = array('revenue_id'=>$revenue_id,'charge_code' => $raterecord_charge_id, 'description' => $charge_name,'quantity_unit'=>'1','value'=>'1','rate_id'=>$rate_id,'amount' => round($total_amount,4), 'currency' => $currency,'user_id'=>$user_id,'createdon'=>$cdate,'local_amount'=>round($total_amount,4),'local_currency'=>$currency,'status'=>'1');
							    					$this->common->insertTableData("tb_charges",$ins_ar);
							    					$rev_ids = array();
							    					$rev_ids[] = $revenue_id;
            										$this->vatcalculationtorate->updatevattorevenues($rev_ids);
					    						}
					    					}
				    					}
				    				}
								}
			    			}else{
				    				/* rate_id in charges is either offering id or not */
				    			$unit2 = 0;
			    				$chkrateoffering = $this->common->gettbldata(array('offering_id'=>$rate_id,'status'=>'1'),"id","tb_rate_offerings",0,0);
			    				if(!empty($chkrateoffering)){
			    					foreach ($chkrateoffering as $res1) {
			    						$rate_offering_id = $res1['id'];
				    					$chkrateofferingservice = $this->common->gettbldata(array('rateoffering_id'=>$rate_offering_id,'status'=>'1'),"ro_charge_id,charge_basis,amount","tb_rateoffering_services",0,0);
				    					if(!empty($chkrateofferingservice)){
				    						foreach ($chkrateofferingservice as $offeringservice) {
					    						$charge_id = $offeringservice['ro_charge_id'];
					    						$charge_basis = strtoupper($offeringservice['charge_basis']);
					    						$amount = $offeringservice['amount'];
					    						$total_amount = 0;
					    						$unit2 = 1;
					    						if($charge_basis == 'LDM' || $charge_basis =='PER LDM'){
					    							$unit2 = $total_ldm;
					    						}
					    						if($charge_basis == 'CBM' || $charge_basis =='PER CBM'){
					    							$unit2 = $total_volume;
					    						}
					    						if($charge_basis == 'KG' || $charge_basis =='PER KG'){
					    							$unit2 = $total_weight;
					    						}
					    						$totalwit_vat = $vat_percentage = $vat_amount = 0;
					    						$unit_ar = $this->ratemanagement->claculateperkgamount($rate_offering_id,$order_id,$user_id,$revtype,$amount,$charge_basis,'non-vas');
					    						if(!empty($unit_ar)){
				                                    $final_conversion = isset($unit_ar['final_conversion']) ? $unit_ar['final_conversion'] : '0';
				                                    if($final_conversion >0){
				                                        $unit2 = $final_conversion;
				                                    }
				                                }
				                                $total_amount = $unit2 * $amount;

					    						$getchargeid = $this->common->gettblrowdata(array('revenue_id'=>$revenue_id,'charge_code'=>$charge_id,'rate_id'=>$rate_id,'status'=>'1'),"id,vat_percentage,vat_amount","tb_charges",0,0);
			    								if(!empty($getchargeid)){
			    									$charge_row_id  = $getchargeid['id'];
			    									$vat_percentage = $getchargeid['vat_percentage'];
			    									$vat_amount     = $getchargeid['vat_amount'];
			    									$totalwit_vat   = $total_amount;
									                if($vat_percentage >0){
									                	$vat_amount = ($vat_percentage * $total_amount) / 100;
	                    								$totalwit_vat = $total_amount + $vat_amount;
									                }
									                $upcharge = $this->common->updatetbledata("tb_charges",array('amount'=>round($total_amount,4),'local_amount'=>round($total_amount,4),'vat_amount'=>round($vat_amount,4),'total_amount'=>round($totalwit_vat,4)),array('id'=>$charge_row_id));
			    								}else{
			    									$getchargename= $this->common->gettblrowdata(array('id'=>$charge_id,'status'=>'1'),"name","tb_charge_codes",0,0);
			    									$charge_name = "";
			    									if(!empty($getchargename)){
			    										$charge_name = $getchargename['name'];
			    									}
					    							$ins_ar = array('revenue_id'=>$revenue_id,'charge_code' => $charge_id, 'description' => $charge_name,'quantity_unit'=>'1','value'=>'1','rate_id'=>$rate_id,'amount' => round($total_amount,4), 'currency' => $currency,'user_id'=>$user_id,'createdon'=>$cdate,'local_amount'=>round($total_amount,4),'local_currency'=>$currency,'status'=>'1');
							    					$this->common->insertTableData("tb_charges",$ins_ar);
							    					$rev_ids = array();
							    					$rev_ids[] = $revenue_id;
            										$this->vatcalculationtorate->updatevattorevenues($rev_ids);
			    								}
					    					}
					    				}
			    					}
			    					/*check offering exits or not if yes update if no insert*/
				    				if(!empty($offering_ids)){
				    					$offering_ids = array_unique($offering_ids);
				    					$this->chkofferingexists_ornot($offering_ids,$revenue_id,$type,$user_id,$order_id);
				    				}
			    				}else{
			    					/* check if rate_id in charges in from geo tier or not */
			    					$offering_id = $rate_offering_id;
			    					$geo_tier_id = $rate_id;
			    					$getgeo_tier_id = $this->common->gettblrowdata(array('geo_tier_id'=>$rate_id,'status'=>'1'),"id","tb_geo_tier",0,0);
			    					if(!empty($getgeo_tier_id)){
			    						$geo_tier_id = $getgeo_tier_id['id'];
			    					}
			    					if(!is_null($geo_tier_id)){
			    						$chk_geo = $this->checkgeotierexistsornot($geo_tier_id,$user_id,$revenue_id,$offering_id,$order_id,$revtype,$charge_id,$rate_service_id,$rate_record_id);
				    				}else{
				    					/* check if rate_id in charges in from rate tier or not */
		    							$tier_id = $rate_id;
		    							$gettier_rowid = $this->common->gettblrowdata(array('tier_id'=>$tier_id,'status'=>1),"id","tb_tier_master",0,0);
		    							if(!empty($gettier_rowid)){
		    								$tier_id = $gettier_rowid['id'];
		    							}
		    							if($tier_id >0){
		    								$chk_tier = $this->checkratetierexistsornot($tier_id,$user_id,$revenue_id,$offering_id,$order_id,$revtype,$charge_id,$rate_service_id,$rate_record_id);
		    							}
				    				}
			    				}
			    			}
			    		}
			    	}
			    }
			    $total_revamount = 0;
			    $gettotalamount = $this->db->query("SELECT amount,currency,local_amount,local_currency,vat_percentage,vat_amount FROM tb_charges WHERE revenue_id ='".$revenue_id."' AND status = '1'");
		        if($gettotalamount->num_rows()>0){
		            foreach($gettotalamount->result() as $res){
		                $charge_currency = $res->currency;
		                $charge_amount = $res->amount;
		                $vat_percentage = $res->vat_percentage;
		                $vat_amount = $res->vat_amount;
		                if($vat_percentage && $vat_amount>0){
		                	$total_revamount += $vat_amount;
		                }
		                $total_revamount += $charge_amount;
		            }
		        }
		        if($total_revamount >0){
		        	$upd_rev = $this->common->updatetbledata("tb_reveneus",array('amount'=>round($total_revamount,4)),array('id'=>$revenue_id));
		        }
			}
		}
	}

	public function chkofferingexists_ornot($offering_ids,$revenue_id,$type,$user_id,$order_id){
		$cdate = date('Y-m-d H:i:s');
		$currency = $this->session->userdata("usr_tzone")['currency'];
		$total_ldm = $second_volume = $second_weight = $total_weight = $total_volume = $secondweight_uom = $weight_unit = 0;
		$getorderdetails = $this->Orderrevenuesmodel->getallordercargodetails($order_id);
		if(!empty($getorderdetails)){
			$total_ldm = $getorderdetails['total_ldm'];
			$second_volume = $getorderdetails['second_volume'];
			$second_weight = $getorderdetails['second_weight'];
			$total_weight = $getorderdetails['total_weight'];
			$total_volume = $getorderdetails['total_volume'];
			$secondweight_uom = $getorderdetails['secondweight_uom'];
			$weight_unit = $getorderdetails['weight_unit'];
		}
		if($revenue_id >0){
			if(!empty($offering_ids)){
				foreach ($offering_ids as $offer) {
				    $rate_offering_id = $offer;
				    $getoffer_id = $this->common->gettblrowdata(array('id'=>$rate_offering_id,'status'=>'1'),"offering_id","tb_rate_offerings",0,0);
				    if(!empty($getoffer_id)){
				    	$rate_id = $getoffer_id['offering_id'];
				    	$chkrateofferingservice = $this->common->gettbldata(array('rateoffering_id'=>$rate_offering_id,'status'=>'1'),"ro_charge_id,charge_basis,amount","tb_rateoffering_services",0,0);
    					if(!empty($chkrateofferingservice)){
    						foreach ($chkrateofferingservice as $offeringservice) {
	    						$charge_id = $offeringservice['ro_charge_id'];
	    						$charge_basis = strtoupper($offeringservice['charge_basis']);
	    						$amount = $offeringservice['amount'];
	    						$total_amount = 0;
	    						$unit2 = 1;
	    						if($charge_basis == 'LDM' || $charge_basis =='PER LDM'){
	    							$unit2 = $total_ldm;
	    						}
	    						if($charge_basis == 'CBM' || $charge_basis =='PER CBM'){
	    							$unit2 = $total_volume;
	    						}
	    						if($charge_basis == 'KG' || $charge_basis =='PER KG'){
	    							$unit2 = $total_weight;
	    						}
	    						$unit_ar = $this->ratemanagement->claculateperkgamount($rate_offering_id,$order_id,$user_id,$type,$amount,$charge_basis,'non-vas');
	    						if(!empty($unit_ar)){
	                                $final_conversion = isset($unit_ar['final_conversion']) ? $unit_ar['final_conversion'] : '0';
	                                if($final_conversion >0){
	                                    $unit2 = $final_conversion;
	                                }
	                            }
	                            $total_amount = $unit2 * $amount;
	    						$getchargeid = $this->common->gettblrowdata(array('revenue_id'=>$revenue_id,'charge_code'=>$charge_id,'rate_id'=>$rate_id,'status'=>'1'),"id","tb_charges",0,0);
								if(!empty($getchargeid)){

								}else{
									$getchargename= $this->common->gettblrowdata(array('id'=>$charge_id,'status'=>'1'),"name","tb_charge_codes",0,0);
									$charge_name = "";
									if(!empty($getchargename)){
										$charge_name = $getchargename['name'];
									}
	    							$ins_ar = array('revenue_id'=>$revenue_id,'charge_code' => $charge_id, 'description' => $charge_name,'quantity_unit'=>'1','value'=>'1','rate_id'=>$rate_id,'amount' => round($total_amount,4), 'currency' => $currency,'user_id'=>$user_id,'createdon'=>$cdate,'local_amount'=>round($total_amount,4),'local_currency'=>$currency,'status'=>'1');
			    					$this->common->insertTableData("tb_charges",$ins_ar);
			    					$rev_ids = array();
			    					$rev_ids[] = $revenue_id;
									$this->vatcalculationtorate->updatevattorevenues($rev_ids);
								}
	    					}
    					}
				    }
				}
			}
		}
	}

	function getCargosCount($booking_id,$package_type){
			$order_info = $this->common->gettblrowdata(array("order_id" => $booking_id), 'id', 'tb_orders', 0, 0);
			if ((!empty($order_info)) && count($order_info) > 0 && isset($order_info['id'])) {
				$id = $order_info['id'];
                                $where = array("order_id" => $id);
                                if(trim($package_type)!='' && strlen($package_type)>1){
                                    $where['quantity_type'] = $package_type;
                                }
				$cargo_info = $this->common->gettblrowdata($where, 'count(*) as total', 'tb_order_cargodetails', 0, 0);
				if ((!empty($cargo_info)) && count($cargo_info) > 0 && isset($cargo_info['total'])) {
					return $cargo_info['total'];
				}else{
					return 0;
				}
			}
			return 0;
	}

}
