<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Ordersreport extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('company_code') != 'CNKN') {
            redirect('login');
        }
        $this->load->model('Bufaorderdisplaymodel');
    }

    public function index()
    {
        if ($this->input->server('REQUEST_METHOD') == 'POST') {
            $params = $this->input->post(null, true);
        } else {
            $params = $this->input->get();
        }
        if (isset($params['fromdate']) && $params['fromdate'] != "") {
            $where['from_date'] = date('Y-m-d', strtotime($params['fromdate']));
            $_POST['fromdate'] = $params['fromdate'];
        }
        if (isset($params['todate']) && $params['todate'] != "") {
            $where['to_date'] = date('Y-m-d', strtotime($params['todate']));
            $_POST['todate'] = $params['todate'];
        }
        if (isset($params['customername']) && $params['customername'] != "") {
            $where['customer_name'] = $data['customer_names'] = $params['customername'];
            $_POST['customername'] = $params['customername'];
        }
        $where = [];
        $limit = $data['limit'] = $params['listValue'] ?? 7;
        $offset = isset($params['offset']) ? $params['offset'] : 0;
        if ((isset($params['searchsubmit']) && $params['searchsubmit'] == "Search") || ($this->session->userdata('searchValues'))) {
            $searchValues = [];
            if ((isset($params['fromdate']) && $params['fromdate'] != "")) {
                $searchValues['from_date'] = $where['from_date'] = date('Y-m-d', strtotime($params['fromdate']));
                $_POST['fromdate'] = $searchValues['from_date'];
            }
            if ((isset($params['todate']) && $params['todate'] != "")) {
                $searchValues['to_date'] = $where['to_date'] = date('Y-m-d', strtotime($params['todate']));
                $_POST['todate'] = $searchValues['to_date'];

            }
            if ((isset($params['customername']) && !empty($params['customername']))) {
                $searchValues['customer_name'] = $where['customer_name'] = $data['customer_names'] = $params['customername'];
                $_POST['customername'] = $searchValues['customer_name'];
            }
            if ((isset($this->session->userdata('searchValues')['fromdate']) && $this->session->userdata('searchValues')['fromdate'] != "")) {
                $searchValues['from_date'] = $where['from_date'] = date('Y-m-d', strtotime($this->session->userdata('searchValues')['fromdate']));
            }

            if ((isset($this->session->userdata('searchValues')['todate']) && $this->session->userdata('searchValues')['todate'] != "")) {
                $searchValues['to_date'] = $where['to_date'] = date('Y-m-d', strtotime($this->session->userdata('searchValues')['todate']));
            }
            if ((isset($this->session->userdata('searchValues')['customername']) && $this->session->userdata('searchValues')['customername'] != "")) {
                $searchValues['customer_name'] = $where['customer_name'] = $data['customer_names'] = $this->session->userdata('searchValues')['customername'];
            }
            $this->session->set_userdata('searchValues', $searchValues);
            if (isset($params['searchsubmit']) && $params['searchsubmit'] == "Search"){
                $offset = 0;
          }

        }
        $data['activeOrders'] = $data['closedOrders'] = $data['pendingOrders'] = $data['countOrders'] = 0;
        if (empty($params)) {
            $data['order_list'] = [];
        } else {
            $data['order_list'] = $this->Bufaorderdisplaymodel->getOrdersData($limit, $offset, $where);
            if(!count($data['order_list'])) {
                    $offset = 0;
                    $data['order_list'] = $this->Bufaorderdisplaymodel->getOrdersData($limit, $offset, $where);
            }
        }
        $this->session->set_userdata('offsetValue', $offset);
        $orderData = $this->Bufaorderdisplaymodel->getCountOfOrderWithDifferentStatuses($where);
        if (!empty($orderData)) {
            foreach ($orderData as $orderConditions) {
                if ($orderConditions['trip_sts'] == 0 && $orderConditions['shift_id'] > 0 && $orderConditions['trip_id'] > 0) {
                    $data['activeOrders'] += 1;
                }
                if ($orderConditions['trip_sts'] == 0 && ($orderConditions['shift_id'] > 0 || $orderConditions['shift_id'] == 0) && $orderConditions['trip_id'] == 0) {
                    $data['pendingOrders'] += 1;
                }
                if ($orderConditions['trip_sts'] == 1 && $orderConditions['shift_id'] > 0 && $orderConditions['trip_id'] > 0) {
                    $data['closedOrders'] += 1;
                }
            }
        }
        $data['countOrders'] = $this->Bufaorderdisplaymodel->getCountOfOrder($where);
        $data['ordersWithException'] = $this->Bufaorderdisplaymodel->getCountOfOrderWithStatusException($where);
        $isAjaxCall = isset($params['isAjaxCall']) ?? false;
        if ($isAjaxCall) {
            $this->load->view("bufaordersreport/body", $data);
        } else {
            $this->load->view("bufaordersreport/head", $data);
            $this->load->view("bufaordersreport/body", $data);
            $this->load->view("bufaordersreport/footer", $data);
        }
    }

    public function getCustomerNames()
    {
        $searchTerm = $this->input->post('searchTerm', true) ?? '';
        $getCustomerNames = $this->Bufaorderdisplaymodel->searchCustomers($searchTerm);
        foreach ($getCustomerNames as $customerNames) {
            $data[] = ['id' => $customerNames['name'], 'text' => $customerNames['name']];
        }
        echo json_encode($data ?? []);
    }
}
