<?php
use App\Generators\RandomString;

if (!defined('BASEPATH')) {

    exit('No direct script access allowed');

}

class Ordertripexcel extends CI_Controller {

    public function __construct() {

        parent::__construct();
        if (!$this->session->userdata('user_id')) {
            redirect('login');
        }
        $this->load->model("common");
        $this->load->library('altovaordercreation');
    }

    public function index(){
        echo "Import Order Trip Excel";
    }

    public function uploadinexcel(){
        ini_set('max_execution_time', 300);
        require_once APPPATH . "/third_party/PHPExcel.php";
        require_once APPPATH . "/third_party/PHPExcel/Writer/Excel2007.php";
        $all_data = array();
        $data =  $errorline= $message  =  array();
        if (isset($_FILES['import_file'])) {
            $ext = pathinfo($_FILES['import_file']['name'], PATHINFO_EXTENSION);
            $value = [];
            $val = [];
            if ($ext == "xls" || $ext == "xlsx") {
                $path = $_FILES['import_file']['tmp_name'];
                $objPHPExcel = PHPExcel_IOFactory::load($path);
                $cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
                $data["arr_data"]=array();
                foreach ($cell_collection as $cell) {
                    $column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
                    $row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
                    $data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
                    $newdtat[] = $column;
                    if ($row == 1) {
                        $data["header"][$row][$column] = $data_value;
                    } else if($row > 1){
                        $data["arr_data"][$row][$column] = $data_value;
                    }
                }
                $data['order_details'] = array();
                $row = 3;
                $arr=[];
                $sno="";
                foreach ($data["arr_data"] as $value[$row]) {
                    $delivery_note = isset($value[$row]['E']) ? $value[$row]['E'] : "";
                    if($sno != $delivery_note){
                        if($delivery_note != ""){
                            $sno = $delivery_note;
                            $value[$row]['row'] = $row;
                            $arr[$sno][]=$value[$row];
                            $row++;
                        }else{
                            $value[$row]['row'] = $row;
                            $arr[$sno][]=$value[$row];
                            $row++;
                        }
                    }else{
                        $value[$row]['row'] = $row;
                        $arr[$sno][]=$value[$row];
                        $row++;
                    }
                }

                $arrdata = array();
                if(!empty($arr)){
                    foreach($arr as $ar){
                        $arrdata[] = $ar;
                    }
                }
                if(!empty($arrdata)){
                    for($i=0, $iMax = count($arrdata); $i< $iMax; $i++){
                        $data['cargo_details'] =  $data['reference'] = array();
                        $rowno =  isset($arrdata[$i]['0']['row']) ? $arrdata[$i]['0']['row'] : "";
                        $mainrowno =  $rowno;
                        $carrier_id = isset($arrdata[$i]['0']['A']) ? $arrdata[$i]['0']['A'] : "";
                        if($carrier_id == ""){
                            $message[] = "Carrier ID empty on line: ".$rowno;
                            $errorline[] = "carrier_id".$rowno;
                        }
                        $transport_mode = isset($arrdata[$i]['0']['B']) ? $arrdata[$i]['0']['B'] : "";
                        if($transport_mode == ""){
                            $message[] = "Mode Of Transport empty on line: ".$rowno;
                            $errorline[] = "transport_mode".$rowno;
                        }
                        $vehicle_number = isset($arrdata[$i]['0']['C']) ? $arrdata[$i]['0']['C'] : "";
                        if($vehicle_number == ""){
                            $message[] = "Vehicle Number empty on line: ".$rowno;
                            $errorline[] = "vehicle_number".$rowno;
                        }
                        $lr_key = isset($arrdata[$i]['0']['D']) ? $arrdata[$i]['0']['D'] : "";
                        if($lr_key == ""){
                            $message[] = "LR Key empty on line: ".$rowno;
                            $errorline[] = "lr_key".$rowno;
                        }
                        $delivery_note = isset($arrdata[$i]['0']['E']) ? $arrdata[$i]['0']['E'] : "";
                        if($delivery_note == ""){
                            $message[] = "Delivery Note empty on line: ".$rowno;
                            $errorline[] = "delivery_note".$rowno;
                        }
                        $customer_id = isset($arrdata[$i]['0']['F']) ? $arrdata[$i]['0']['F'] : "";
                        if($customer_id == ""){
                            $message[] = "Customer Id empty on line: ".$rowno;
                            $errorline[] = "customer_id".$rowno;
                        }
                        $shipper_code = isset($arrdata[$i]['0']['G']) ? $arrdata[$i]['0']['G'] : "";
                        if($shipper_code == ""){
                            $message[] = "Shipper Code on line: ".$rowno;
                            $errorline[] = "shipper_code".$rowno;
                        }
                        $early_pickup = isset($arrdata[$i]['0']['H']) ? $arrdata[$i]['0']['H'] : "";
                        if($early_pickup != ""){
                            $UNIX_DATE = ($early_pickup - 25569) * 86400;
                            $EXCEL_DATE = 25569 + ($UNIX_DATE / 86400);
                            $UNIX_DATE = ($EXCEL_DATE - 25569) * 86400;
                            $early_pickup =  gmdate("Y-m-d H:i:s", $UNIX_DATE);
                        }
                        if(strstr($early_pickup, '1970-01-01') || $early_pickup == ""){
                            $message[] = "Early Pickup empty on line: ".$rowno;
                            $errorline[] = "early_pickup".$rowno;
                        }
                        $late_pickup = isset($arrdata[$i]['0']['I']) ? $arrdata[$i]['0']['I'] : "";
                        if($late_pickup != ""){
                            $UNIX_DATE = ($late_pickup - 25569) * 86400;
                            $EXCEL_DATE = 25569 + ($UNIX_DATE / 86400);
                            $UNIX_DATE = ($EXCEL_DATE - 25569) * 86400;
                            $late_pickup =  gmdate("Y-m-d H:i:s", $UNIX_DATE);
                        }
                        if(strstr($late_pickup, '1970-01-01') || $late_pickup == ""){
                            $message[] = "Invalid/Empty Late Pickup format on line: ".$rowno;
                            $errorline[] = "late_pickup".$rowno;
                        }
                        $early_delivery = isset($arrdata[$i]['0']['J']) ? $arrdata[$i]['0']['J'] : "";
                        if($early_delivery != ""){
                            $UNIX_DATE = ($early_delivery - 25569) * 86400;
                            $EXCEL_DATE = 25569 + ($UNIX_DATE / 86400);
                            $UNIX_DATE = ($EXCEL_DATE - 25569) * 86400;
                            $early_delivery =  gmdate("Y-m-d H:i:s", $UNIX_DATE);
                        }
                        if(strstr($early_delivery, '1970-01-01') || $early_delivery == ""){
                            $message[] = "Early Delivery empty on line: ".$rowno;
                            $errorline[] = "early_delivery".$rowno;
                        }
                        $late_delivery = isset($arrdata[$i]['0']['K']) ? $arrdata[$i]['0']['K'] : "";
                        if($late_delivery != ""){
                            $UNIX_DATE = ($late_delivery - 25569) * 86400;
                            $EXCEL_DATE = 25569 + ($UNIX_DATE / 86400);
                            $UNIX_DATE = ($EXCEL_DATE - 25569) * 86400;
                            $late_delivery =  gmdate("Y-m-d H:i:s", $UNIX_DATE);
                        }
                        if(strstr($late_delivery, '1970-01-01') || $late_delivery == ""){
                            $message[] = "Late Delivery empty on line: ".$rowno;
                            $errorline[] = "late_delivery".$rowno;
                        }
                        $consignee_code = isset($arrdata[$i]['0']['L']) ? $arrdata[$i]['0']['L'] : "";
                        if($consignee_code == ""){
                            $message[] = "Consignee Code empty on line: ".$rowno;
                            $errorline[] = "consignee_code".$rowno;
                        }
                        $consignee_name = isset($arrdata[$i]['0']['M']) ? $arrdata[$i]['0']['M'] : "";
                        if($consignee_name == ""){
                            $message[] = "Consinee Name empty on line: ".$rowno;
                            $errorline[] = "consignee_name".$rowno;
                        }
                        $consignee_street = isset($arrdata[$i]['0']['N']) ? $arrdata[$i]['0']['N'] : "";
                        if($consignee_street == ""){
                            $message[] = "Consignee Street empty on line: ".$rowno;
                            $errorline[] = "consignee_street".$rowno;
                        }
                        $consignee_city = isset($arrdata[$i]['0']['O']) ? $arrdata[$i]['0']['O'] : "";
                        if($consignee_city == ""){
                            $message[] = "consignee City on line: ".$rowno;
                            $errorline[] = "consignee_city".$rowno;
                        }
                        $consignee_state = isset($arrdata[$i]['0']['P']) ? $arrdata[$i]['0']['P'] : "";
                        if($consignee_state == ""){
                            $message[] = "Consignee State on line: ".$rowno;
                            $errorline[] = "consignee_state".$rowno;
                        }
                        $consignee_country = isset($arrdata[$i]['0']['Q']) ? $arrdata[$i]['0']['Q'] : "";
                        if($consignee_country == ""){
                            $message[] = "Consignee Country on line: ".$rowno;
                            $errorline[] = "consignee_country".$rowno;
                        }
                        $consignee_zipcode = isset($arrdata[$i]['0']['R']) ? $arrdata[$i]['0']['R'] : "";
                        if($consignee_zipcode == ""){
                            $message[] = "Consignee Zipcode on line: ".$rowno;
                            $errorline[] = "consignee_zipcode".$rowno;
                        }
                        $consignee_phone = isset($arrdata[$i]['0']['S']) ? $arrdata[$i]['0']['S'] : "";
                        if($consignee_phone == ""){
                            $message[] = "Consignee Phone on line: ".$rowno;
                            $errorline[] = "consignee_phone".$rowno;
                        }
                        $cargo_type = isset($arrdata[$i]['0']['T']) ? $arrdata[$i]['0']['T'] : "";
                        if($cargo_type == ""){
                            $message[] = "Cargo Type on line: ".$rowno;
                            $errorline[] = "cargo_type".$rowno;
                        }
                        $goods_description = isset($arrdata[$i]['0']['U']) ? $arrdata[$i]['0']['U'] : "";
                        if($goods_description == ""){
                            $message[] = "Cargo Type on line: ".$rowno;
                            $errorline[] = "goods_description".$rowno;
                        }
                        $quantity = isset($arrdata[$i]['0']['V']) ? $arrdata[$i]['0']['V'] : "1";
                        if($quantity == ""){
                            $message[] = "Quantity  on line: ".$rowno;
                            $errorline[] = "quantity".$rowno;
                        }
                        $length = isset($arrdata[$i]['0']['W']) ? $arrdata[$i]['0']['W'] : "1";
                        if($length == ""){
                            $message[] = "Length  on line: ".$rowno;
                            $errorline[] = "length".$rowno;
                        }
                        $width = isset($arrdata[$i]['0']['X']) ? $arrdata[$i]['0']['X'] : "1";
                        if($width == ""){
                            $message[] = "Width  on line: ".$rowno;
                            $errorline[] = "width".$rowno;
                        }
                        $height = isset($arrdata[$i]['0']['Y']) ? $arrdata[$i]['0']['Y'] : "1";
                        if($height == ""){
                            $message[] = "Height  on line: ".$rowno;
                            $errorline[] = "height".$rowno;
                        }
                        $weight = isset($arrdata[$i]['0']['Z']) ? $arrdata[$i]['0']['Z'] : "1";
                        if($weight == ""){
                            $message[] = "Weight  on line: ".$rowno;
                            $errorline[] = "weight".$rowno;
                        }
                        $pickup_id = $shipper_code;
                        $drop_id = $consignee_code;

                        $table = "tbl_party_master";
                        $whr = array("code"=>$shipper_code,'status'=>'1');
                        $whr1 = array("code"=>$consignee_code,'status'=>'1');
                        $company_code = $this->session->userdata('company_code');
                        $branch_code = $this->session->userdata('branch_code');
                        $user_id = $this->session->userdata('user_id');
                        $address = $consignee_street.$consignee_city.$consignee_state;
                        $consignee_details = array('code'=>$consignee_code,'name'=>$consignee_name,'mobile'=>$consignee_phone,'customeridentifier'=>$consignee_code,'company_code'=>$company_code,'branch_code'=>$branch_code,'location_id'=>$consignee_city,'address'=>$address,'country'=>$consignee_country,'state'=>$consignee_state,'street'=>$consignee_street,'pincode'=>$consignee_zipcode,'status'=>'1','user_id'=>$user_id);
                        $select = "id,name,email,mobile,code,location_id,country,state,street,pincode,fax";
                        $shippper_details = $this->chekpartymaster($select,$whr,$table,array());
                        $drop_details = $this->chekpartymaster($select,$whr1,$table,$consignee_details);
                        $pickup_row_id = $shippper_details['row_id'];
                        $data['reference'] = array();
                        $volume = $length * $width * $height * $quantity;
                        $stackable = 'off';
                        $data['cargo_details'][] =  array('cargo_type'=>$cargo_type,  'goods_description'=>$goods_description,  'length'=>$length,  'width'=>$width,   'height'=>$height, 'weight'=>$weight,  'quantity'=>$quantity, 'volume'=>$volume,'rowno'=>$rowno);
                        $company_code = $this->session->userdata('company_code');
                        $branch_code = $this->session->userdata('branch_code');
                        $data['order_details'][] = array('customer_id'=>$customer_id,'shipper_code'=>$shipper_code,'consignee_code'=>$consignee_code,'delivery_note'=>$delivery_note,'quantity'=>$quantity,'pickup_id'=>$pickup_id,'pickup_name'=>$shippper_details['name'],'pickup_street'=>$shippper_details['street'],'pickup_city'=>$shippper_details['city'],'pickup_state'=>$shippper_details['state'],'pickup_country'=>$shippper_details['country'],'pickup_pincode'=>$shippper_details['pincode'],'early_pickup'=>$early_pickup,'late_pickup'=>$late_pickup,'pickup_phone'=>$shippper_details['phone'],'pickup_fax'=>$shippper_details['fax'],'pickup_email'=>$shippper_details['email'],'pickup_row_id'=>$pickup_row_id,'drop_id'=>$drop_id,'drop_name'=>$drop_details['name'],'drop_street'=>$drop_details['street'],'drop_city'=>$drop_details['city'],'drop_state'=>$drop_details['state'],'drop_country'=>$drop_details['country'],'drop_pincode'=>$drop_details['pincode'],'early_drop'=>$early_delivery,'late_drop'=>$late_delivery,'drop_phone'=>$drop_details['phone'],'drop_fax'=>$drop_details['fax'],'drop_email'=>$drop_details['email'],'rowno'=>$mainrowno,'company_code'=>$company_code,'branch_code'=>$branch_code,'cargo_details'=>$data['cargo_details'],'involved_parties'=>array(),'lr_key'=>$lr_key,'carrier_id'=>$carrier_id,'transport_mode'=>$transport_mode,'department_code'=>'','dept_name'=>'','vehicle_number'=>$vehicle_number);

                    }
                }
            }
        }

        $data['errorline']   = $errorline;
        $data["message"]     = $message;
        $data["page_title"]  = "Import Orders";

        $this->settemplate->dashboard("orders/inimport",$data);
    }

    public function chekpartymaster($select,$whr,$table,$master){
        $shippper_details = array();
        $shippper_details['row_id'] = $shipper_details['id'] = 0;
        $shippper_details['city'] = $shippper_details['state'] = $shippper_details['country'] = $shippper_details['pincode'] = $shippper_details['phone'] = $shippper_details['fax'] = $shippper_details['street'] = $shippper_details['email'] = $shippper_details['name'] ="";
        $shipperdetails = $this->common->gettbldata($whr,$select,$table,0,0);
        if(!empty($shipperdetails)){
            $details = $shipperdetails[0];
            if(!empty($details)){
                $shippper_details['id'] = $details['code'];
                $shippper_details['row_id'] = $details['id'];
                $shippper_details['name'] = $details['name'];
                $shippper_details['city'] = $details['location_id'];
                $shippper_details['street'] = $details['street'];
                $shippper_details['state'] = $details['state'];
                $shippper_details['country'] = $details['country'];
                $shippper_details['pincode'] = $details['pincode'];
                $shippper_details['phone'] = $details['mobile'];
                $shippper_details['fax'] = $details['fax'];
                $shippper_details['email'] = $details['email'];
            }
        }else{
            if(!empty($master)){
                $master['party_type_id'] = 0;
                $shippper_details['id'] = $master['code'];
                $shippper_details['name'] = $master['name'];
                $shippper_details['city'] = $master['location_id'];
                $shippper_details['street'] = $master['street'];
                $shippper_details['state'] = $master['state'];
                $shippper_details['country'] = $master['country'];
                $shippper_details['pincode'] = $master['pincode'];
                $shippper_details['phone'] = $master['mobile'];
                $getconsignee_typeid = $this->common->gettblrowdata(array('name'=>'Consignee','user_id'=>$master['user_id'],'status'=>'1'),"id","tbl_party_types",0,0);
                if(!empty($getconsignee_typeid)){
                    $master['party_type_id'] = $getconsignee_typeid['id'];
                }
                $shippper_details['row_id'] = $this->common->insertTableData("tbl_party_master",$master);
            }
        }
        return $shippper_details;
    }
    public function addinorderdata(){
        $dummy_array = $order_list = $orders = array();
        $post_list = isset($_POST['orders']) ? $_POST['orders'] : array();
        if(!empty($post_list)){
            for($i=0, $iMax = count($post_list); $i< $iMax; $i++){
                $order_list[] = isset($post_list[$i]) ? $post_list[$i] : "";
                $first_lrkey = isset($post_list[$i]['lr_key']) ? $post_list[$i]['lr_key'] : "";
            }
        }
        $j = 0;
        if(!empty($order_list)){
            for($i=0, $iMax = count($order_list); $i< $iMax; $i++){
                $data = $order_list[$i];

                $orders[] =$this->insertcust_reffororder($data);

            }
        }
        $this->intripordershipment($orders);
        redirect('orders');
    }

    public function insertcust_reffororder($data){
        $cdate = date('Y-m-d H:i:s');

        $user_id = $this->session->userdata('user_id');
        $company_code = isset($data['company_code']) ? $data['company_code'] : "";
        $branch_code = isset($data['branch_code']) ? $data['branch_code'] : "";
        $department_code = isset($data['department_code']) ? $data['department_code'] : "";
        $transport_mode = isset($data['transport_mode']) ? $data['transport_mode'] : "";
        $service = isset($data['service']) ? $data['service'] : "";
        $service_id = "";
        if($service != ""){
            $getservice = $this->db->query("SELECT id FROM tb_service_master WHERE service_id LIKE '".$service."'");
            if($getservice->num_rows() >0){
                $service_id = $getservice->row()->id;
            }
        }
        $shipment_number = isset($data['delivery_note']) ? $data['delivery_note'] : "";
        $early_pickup = isset($data['early_pickup']) ? $data['early_pickup'] : "";
        $late_pickup = isset($data['late_pickup']) ? $data['late_pickup'] : "";
        $early_delivery = isset($data['early_drop']) ? $data['early_drop'] : "";
        $late_delivery = isset($data['late_drop']) ? $data['late_drop'] : "";
        $customer_id = isset($data['customer_id']) ? $data['customer_id'] : "";
        $trip_no = isset($data['trip_no']) ? $data['trip_no'] : "";
        $route = isset($data['route']) ? $data['route'] : "";
        $driver = isset($data['driver']) ? $data['driver'] : "";
        $vehicle_number = isset($data['vehicle_number']) ? $data['vehicle_number'] : "";
        $carrier_id = isset($data['carrier_id']) ? $data['carrier_id'] : "";
        $lr_key = isset($data['lr_key']) ? $data['lr_key'] : "";
        $customer_row_id = 0;
        if($customer_id != ""){
            $getcustomerid = $this->db->query("SELECT id FROM tb_customers WHERE code LIKE '".$customer_id."' ORDER BY id DESC");
            if($getcustomerid->num_rows() >0){
                $customer_row_id = $getcustomerid->row()->id;
            }
        }
        $curdate = $e_pickup = date('Y-m-d H:i:s');
        if($early_pickup != ""){
            $e_pickup = date('Y-m-d H:i:s',strtotime($early_pickup));
        }
        if($late_pickup != ""){
            $l_pickup = date('Y-m-d H:i:s',strtotime($late_pickup));
        }else{
            $l_pickup = date('Y-m-d H:i:s',strtotime('+1 hour',strtotime($e_pickup)));
        }
        if($early_delivery != ""){
            $e_delivery = date('Y-m-d H:i:s',strtotime($early_delivery));
        }else{
            $e_delivery = date('Y-m-d H:i:s',strtotime('+3 hour',strtotime($curdate)));
        }
        if($late_delivery != ""){
            $l_delivery = date('Y-m-d H:i:s',strtotime($late_delivery));
        }else{
            $l_delivery = date('Y-m-d H:i:s',strtotime('+4 hour',strtotime($curdate)));
        }
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
        $logdate = $getactual['datetime'];
        $getpickup = getdatetimebytimezone(DFLT_TZ,$e_pickup,$curtz);
        $e_pickup = $getpickup['datetime'];
        $getlpickup = getdatetimebytimezone(DFLT_TZ,$l_pickup,$curtz);
        $l_pickup = $getlpickup['datetime'];
        $getdelivery = getdatetimebytimezone(DFLT_TZ,$e_delivery,$curtz);
        $e_delivery = $getdelivery['datetime'];
        $getldelivery = getdatetimebytimezone(DFLT_TZ,$l_delivery,$curtz);
        $l_delivery = $getldelivery['datetime'];

        $pickup_id = isset($data['pickup_id']) ? $data['pickup_id'] : "";
        $pickup_name = isset($data['pickup_name']) ? $data['pickup_name'] : "";
        $pickup_street = isset($data['pickup_street']) ? $data['pickup_street'] : "";
        $pickup_city = isset($data['pickup_city']) ? $data['pickup_city'] : "";
        $pickup_state = isset($data['pickup_state']) ? $data['pickup_state'] : "";
        $pickup_country = isset($data['pickup_country']) ? $data['pickup_country'] : "";
        $pickup_pincode = isset($data['pickup_pincode']) ? $data['pickup_pincode'] : "";
        $pickup_fax = isset($data['pickup_fax']) ? $data['pickup_fax'] : "";
        $pickup_email = isset($data['pickup_email']) ? $data['pickup_email'] : "";
        $pickup_phone = isset($data['pickup_phone']) ? $data['pickup_phone'] : "";
        $address = $pickup_street.','.$pickup_city.','.$pickup_country;
        $shipper_row_id = 0;
        $chk_type = $this->db->select('id')->get_where("tbl_party_types",array('name'=>'Shipper','company_code'=>$company_code));
        if($chk_type->num_rows() >0){
            $shipper_type_id = $chk_type->row()->id;
        }else{
            $party_data = array('name'=>'Shipper','description'=>'Shipper','company_code'=>$company_code,'branch_code'=>$branch_code,'user_id'=>$user_id);
            $ins = $this->db->insert("tbl_party_types",$party_data);
            $shipper_type_id = $this->db->insert_id();
        }
        $master_data = array('party_type_id'=>$shipper_type_id,'name'=>$pickup_name,'mobile'=>$pickup_phone,'street'=>$pickup_street,'location_id'=>$pickup_city,'state'=>$pickup_state,'pincode'=>$pickup_pincode,'code'=>$pickup_id,'customeridentifier'=>$pickup_id,'country'=>$pickup_country,'email'=>$pickup_email,'fax'=>$pickup_fax,'company_code'=>$company_code,'branch_code'=>$branch_code,'address'=>$address);
        $chk = $this->db->select('id')->get_where("tbl_party_master",array('customeridentifier'=>$pickup_id));
        if($chk->num_rows() == 0){
            $master_data['created_on'] = $cdate;
            $ins = $this->db->insert('tbl_party_master',$master_data);
            $shipper_row_id = $this->db->insert_id();
        }else{
            $shipper_row_id = $chk->row()->id;
            $upd = $this->db->where(array('id'=>$shipper_row_id))->update("tbl_party_master",$master_data);
        }


        $drop_id = isset($data['drop_id']) ? $data['drop_id'] : "";
        $drop_name = isset($data['drop_name']) ? $data['drop_name'] : "";
        $drop_street = isset($data['drop_street']) ? $data['drop_street'] : "";
        $drop_city = isset($data['drop_city']) ? $data['drop_city'] : "";
        $drop_state = isset($data['drop_state']) ? $data['drop_state'] : "";
        $drop_country = isset($data['drop_country']) ? $data['drop_country'] : "";
        $drop_pincode = isset($data['drop_pincode']) ? $data['drop_pincode'] : "";
        $drop_fax = isset($data['drop_fax']) ? $data['drop_fax'] : "";
        $drop_email = isset($data['drop_email']) ? $data['drop_email'] : "";
        $drop_phone = isset($data['drop_phone']) ? $data['drop_phone'] : "";
        $drop_row_id = 0;
        $product = "";
        $incoterm = "";
        $daddress = $drop_street.','.$drop_city.','.$drop_country;
        $drop_data = array('name'=>$drop_name,'mobile'=>$drop_phone,'street'=>$drop_street,'location_id'=>$drop_city,'state'=>$drop_state,'pincode'=>$drop_pincode,'code'=>$drop_id,'customeridentifier'=>$drop_id,'country'=>$drop_country,'email'=>$drop_email,'fax'=>$drop_fax,'company_code'=>$company_code,'branch_code'=>$branch_code,'address'=>$daddress);
        $chk_type = $this->db->select('id')->get_where("tbl_party_types",array('name'=>'Consignee','company_code'=>$company_code));
        if($chk_type->num_rows() >0){
            $party_type_id = $chk_type->row()->id;
        }else{
            $party_types = array('company_code'=>$company_code,'branch_code'=>$branch_code,'name'=>'Consignee','user_id'=>$user_id,'created_on'=>$cdate,'status'=>'1');
            $ins_type = $this->db->insert("tbl_party_types",$party_types);
            $party_type_id = $this->db->insert_id();
        }
        $drop_data['party_type_id'] = $party_type_id;
        $chk_cust = $this->db->select("id")->get_where("tbl_party_master",array('code'=>$drop_id));
        if($chk_cust->num_rows() >0){
            $drop_id = $drop_id;
            $drop_row_id = $chk_cust->row()->id;
            $upd = $this->db->where(array('id'=>$drop_row_id))->update("tbl_party_master",$drop_data);
        }else{
            $drop_data['user_id'] = $user_id;
            $drop_data['created_on'] = $cdate;
            $drop_ins = $this->db->insert("tbl_party_master",$drop_data);
            $drop_row_id = $this->db->insert_id();
        }
        $ship_row_id = 0;
        $enddate = date('Y-m-d H:i:s',strtotime("+1 day"));
        $tid = 1; $tname = "Less Than TruckLoad";
        if($transport_mode == ""){
            $transport_mode = "LTL";
        }

        $gettrasnportmode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '".$transport_mode."'");
        if($gettrasnportmode->num_rows() >0){
            $tid = $gettrasnportmode->row()->id;
            $tname= $gettrasnportmode->row()->name;
        }
        if($shipment_number == ""){
            $shipment_number = "SVK".time();
        }
        $ship_arr = array('unitspec'=>1,'shipid'=>$shipment_number,'txnid'=>$shipment_number,'trucktype'=>$tname,'pickupcnt'=>'1','dropcnt'=>'1','insertusr'=>$pickup_id,'carrier'=>'0','insertuserdate'=>$cdate,'enddate'=>$enddate,'insdate'=>$cdate,'upddate'=>$cdate,'reason'=>'SHIPMENT','purpose'=>'SEND INTEGRATION','ship_object'=>'SHIPMENT','logdate'=>$cdate,'transport_mode'=>$transport_mode,'domainname'=>$branch_code,'company_code'=>$company_code,'branch_code'=>$branch_code,'product'=>$product,'freight_term'=>'60','freight_termname'=>'Free of Charge','incoterm'=>$incoterm,'modeoftransport'=>$tid);
        $chk_shipid= $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '".$shipment_number."'");

        if($chk_shipid->num_rows() >0){
            $ship_row_id = $chk_shipid->row()->id;
            $this->db->where(array('id'=>$ship_row_id))->update("tb_shipments",$ship_arr);
        }else{
            $ship_arr['createdon'] = $cdate;
            $ship_ins = $this->db->insert("tb_shipments",$ship_arr);
            $ship_row_id = $this->db->insert_id();
        }
        $loc = [];
        $add1 = implode(",",[$pickup_street,$pickup_city,$pickup_country,$pickup_pincode]);
        $add2 = implode(",",[$drop_street,$drop_city,$drop_country,$drop_pincode]);
        $loc = getlatlngsbyplace($add1);
        $lat1 = @$loc[0];
        $lng1 = @$loc[1];
        $loc = getlatlngsbyplace($add2);
        $lat2 = @$loc[0];
        $lng2 = @$loc[1];
        $goods_value = "0.00";
        $childid = 0;
        if($this->session->userdata('childid')){
            $childid = $this->session->userdata('childid');
        }
        $ins = array('shipment_id'=>$ship_row_id,'customer_id'=>$customer_row_id,'drop_custid'=>$drop_id,'drop_partyid'=>$drop_id,'product'=>$product,'goods_value'=>$goods_value,'company_code'=>$company_code,'branch_code'=>$branch_code,'pickup_datetime'=>$e_pickup,'delivery_datetime'=>$e_delivery,'pickup_endtime'=>$l_pickup,'drop_endtime'=>$l_delivery,'createdon'=>$cdate,'user_id'=>$user_id,'sub_uid'=>$childid,'pickup_custid'=>$pickup_id,'pickup_partyid'=>$pickup_id,'pickup_country'=>$pickup_country,'pickup_city'=>$pickup_city,'pickup_pincode'=>$pickup_pincode,'pickup_company'=>$pickup_name,'pickup_address1'=>$pickup_street,'pickup_address2'=>$pickup_state,'delivery_country'=>$drop_country,'delivery_city'=>$drop_city,'delivery_pincode'=>$drop_pincode,'delivery_company'=>$drop_name,'delivery_address1'=>$drop_street,'delivery_address2'=>$drop_state,'transport_mode'=>$transport_mode,'plat'=>$lat1,'plng'=>$lng1,'dlat'=>$lat2,'dlng'=>$lng2,'modeoftransport'=>$tid,'created_source'=>'4','createdon'=>$logdate);
        $ins_order = $this->db->insert("tb_orders",$ins);
        $order_id = $this->db->insert_id();

        if($user_id != ""){
            $get_country = $this->db->select('country_code,company_code')->get_where("tb_users",array('id'=>$user_id));
            $country_code  = $get_country->row()->country_code;
            $company_code  = $get_country->row()->company_code;
            $genord = array("user_id"=>$user_id,"order_id"=>$order_id,"country_code"=>$country_code,"company_code"=>$company_code);
            $booking_id = generatebookingid($genord);
            $term_id = "";
            $upd = $this->db->where(array('id'=>$order_id))->update("tb_orders",array('order_id'=>$booking_id));
            $invtypes = makeorderinvolvedpartiestype($customer_row_id,$order_id,"CUSTOMER", $user_id, $company_code);
            $details = array('service'=>$service_id,'department_code'=>$department_code,'delivery_term'=>$term_id,'incoterm'=>$incoterm,'purchase_order'=>'','notify_party'=>'','lane_reference'=>'','distance'=>'','temperature_control'=>'','valorance_insurance'=>'','high_cargo_value'=>'','customs_required'=>'','order_id'=>$booking_id,'order_row_id'=>$order_id,'createdon'=>$cdate,'shipper_id'=>$shipper_row_id,'order_type'=>'');
            $this->db->insert("tb_order_details",$details);

            if($shipper_row_id != 0){
                $order_parties = array('order_id'=>$order_id,'party_id'=>$shipper_row_id,'status'=>'1','createdon'=>$cdate,'party_type'=>$shipper_type_id);
                $ins_order_parties = $this->db->insert("tb_order_parties",$order_parties);
                $shipper_address = array('order_id'=>$order_id,'party_master_id'=>$shipper_row_id,'location_id'=>$pickup_city,'street'=>$pickup_street,'state'=>$pickup_state,'address'=>$address,'pincode'=>$pickup_pincode,'country'=>$pickup_country,'user_id'=>$user_id);
                $chk_shipperaddress = $this->db->select("id")->get_where("tbl_orderparty_address",array('order_id'=>$order_id,'party_master_id'=>$shipper_row_id));
                if($chk_shipperaddress->num_rows() >0){
                    $shipperadd_id = $chk_shipperaddress->row()->id;
                    $upd_add = $this->db->where(array('id'=>$shipperadd_id))->update("tbl_orderparty_address",$shipper_address);
                }
                else{
                    $shipper_address['createdon'] = $cdate;
                    $this->db->insert("tbl_orderparty_address",$shipper_address);
                    $shipperadd_id = $this->db->insert_id();
                }
            }

            if($drop_row_id != 0){
                $order_parties = array('order_id'=>$order_id,'party_id'=>$drop_row_id,'status'=>'1','createdon'=>$cdate,'party_type'=>$party_type_id);
                $ins_order_parties = $this->db->insert("tb_order_parties",$order_parties);

                $drop_address = array('order_id'=>$order_id,'party_master_id'=>$drop_row_id,'location_id'=>$drop_city,'street'=>$drop_street,'state'=>$drop_state,'address'=>$daddress,'pincode'=>$drop_pincode,'country'=>$drop_country,'user_id'=>$user_id);
                $chk_dropaddress = $this->db->select("id")->get_where("tbl_orderparty_address",array('order_id'=>$order_id,'party_master_id'=>$drop_row_id));
                if($chk_dropaddress->num_rows() >0){
                    $dropadd_id = $chk_dropaddress->row()->id;
                    $upd_add = $this->db->where(array('id'=>$dropadd_id))->update("tbl_orderparty_address",$drop_address);
                }
                else{
                    $drop_address['createdon'] = $cdate;
                    $this->db->insert("tbl_orderparty_address",$drop_address);
                    $dropadd_id = $this->db->insert_id();
                }
            }
            if ($shipment_number != "") {
                $ins_ref = array('order_id' => $order_id, 'reference_id' => 'DQ', 'ref_value' => $shipment_number, 'createdon' => $cdate);
                $ins     = $this->db->insert('tb_order_references', $ins_ref);

            }
        }
        /* if($deptname != ""){
           $div_reference = array('order_id'=>$order_id,'ref_value'=>$deptname,'reference_id'=>'DIV','status'=>'1','createdon'=>$cdate);
           $this->db->insert("tb_order_references",$div_reference);
         }*/

        $cargo = isset($data['cargo_details']) ? $data['cargo_details'] : array();
        if(!empty($cargo)){
            foreach($cargo as $car){
                $cargo_type = isset($car['cargo_type']) ? $car['cargo_type'] : "";
                $goods_desc = isset($car['goods_description']) ? $car['goods_description'] : "";
                $quantity = isset($car['quantity']) ? $car['quantity'] : "";
                $length = isset($car['length']) ? $car['length'] : "";
                $length_uom = isset($car['length_uom']) ? $car['length_uom'] : "m";
                $width = isset($car['width']) ? $car['width'] : "";
                $width_uom = isset($car['width_uom']) ? $car['width_uom'] : "m";
                $height = isset($car['height']) ? $car['height'] : "";
                $height_uom = isset($car['height_uom']) ? $car['height_uom'] : "m";
                $weight = isset($car['weight']) ? $car['weight'] : "";
                $weight_uom = isset($car['weight_uom']) ? $car['weight_uom'] : "kg";
                $volume = isset($car['volume']) ? $car['volume'] : "";
                $volume_uom = isset($car['volume_uom']) ? $car['volume_uom'] : "cbm";
                $stackable = isset($car['stackable']) ? $car['stackable'] : "";
                if($stackable == 'on'){
                    $stackable = 1;
                }else{
                    $stackable = 0;
                }
                $cargo_details = array('cargo_type'=>$cargo_type,'goods_description'=>$goods_desc,'quantity'=>$quantity,'length'=>$length,'length_unit'=>$length_uom,'width'=>$width,'width_unit'=>$width_uom,'height'=>$height,'height_unit'=>$height_uom,'weight'=>$weight,'weight_unit'=>$weight_uom,'volume'=>$volume,'volume_unit'=>$volume_uom,'stackable'=>$stackable,'createdby'=>$user_id,'createdon'=>$cdate);
                $ins = $this->db->insert("tb_cargo_details",$cargo_details);

                $cargo_row_id = $this->db->insert_id();
                $gethandling_unit = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE '".$cargo_type."'");
                $handling_unit = "";
                if($gethandling_unit->num_rows() >0){
                    $handling_unit = $gethandling_unit->row()->id;
                }else{
                    $handlingunit_ar = array('unit_name'=>$cargo_type,'user_id'=>$user_id,'created_at'=>$cdate,'status'=>'1');
                    $this->db->insert("tbl_shipunit_types",$handlingunit_ar);
                    $handling_unit = $this->db->insert_id();
                }
                $order_cargo = array('order_id'=>$order_id,'quantity'=>$quantity,'cargo_id'=>$cargo_row_id,'status'=>'1','createdon'=>$cdate,'cargo_content'=>$goods_desc,'quantity_type'=>$cargo_type,'length'=>$length,'width'=>$width,'height'=>$height,'weight'=>$weight,'volume'=>$volume,'handling_unit'=>$handling_unit);
                $insert_cargo_order = $this->db->insert("tb_order_cargodetails",$order_cargo);

            }
        }
        $cargo_forship = array();
        $getcargos  = $this->db->query("SELECT quantity_type FROM tb_order_cargodetails WHERE order_id ='".$order_id."'");
        if($getcargos->num_rows() >0){
            foreach($getcargos->result() as $res){
                $cargo_forship[] = $res->quantity_type;
            }
        }

        $unitspec = "1";
        if(!empty($cargo_forship)){
            $unitspec = implode(',', $cargo_forship);
        }

        $updship = $this->db->where(array('id'=>$ship_row_id))->update("tb_shipments",array('unitspec'=>$unitspec,'txncode'=>$booking_id));
        $total_weight = $total_volume = $total_quantity = 0;
        $gettotal = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='".$order_id."'");
        if($gettotal->num_rows() >0){
            $total_volume = $gettotal->row()->total_volume;
            $total_weight = $gettotal->row()->total_weight;
            $total_quantity = $gettotal->row()->total_quantity;
        }
        $upd_order = $this->db->where(array('id'=>$order_id))->update("tb_orders",array('volume'=>$total_volume,'weight'=>$total_weight,'quantity'=>$total_quantity));
        $enddate = date('Y-m-d H:i:s',strtotime("+1 day"));
        $gettrasnportmode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '".$transport_mode."'");
        if($gettrasnportmode->num_rows() >0){
            $tid = $gettrasnportmode->row()->id;
            $tname= $gettrasnportmode->row()->name;
        }
        $ship_arr = array('unitspec'=>1,'shipid'=>$shipment_number,'txnid'=>$shipment_number,'trucktype'=>$tname,'pickupcnt'=>'1','dropcnt'=>'1','insertusr'=>$pickup_id,'carrier'=>'0','insertuserdate'=>$cdate,'enddate'=>$enddate,'insdate'=>$cdate,'upddate'=>$cdate,'reason'=>'SHIPMENT','purpose'=>'SEND INTEGRATION','ship_object'=>'SHIPMENT','logdate'=>$cdate,'transport_mode'=>$transport_mode,'domainname'=>$branch_code,'company_code'=>$company_code,'branch_code'=>$branch_code,'product'=>$product,'freight_term'=>'60','freight_termname'=>'Free of Charge','incoterm'=>$incoterm,'modeoftransport'=>$tid);
        $chk_shipid= $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '".$shipment_number."'");

        if($chk_shipid->num_rows() >0){
            $ship_row_id = $chk_shipid->row()->id;
            $this->db->where(array('id'=>$ship_row_id))->update("tb_shipments",$ship_arr);
        }else{

            $ship_arr['createdon'] = $cdate;
            $ship_ins = $this->db->insert("tb_shipments",$ship_arr);
            $ship_row_id = $this->db->insert_id();
        }
        $reference = isset($data['reference']) ? $data['reference'] : array();
        if(!empty($reference)){
            foreach($reference as $ref){
                $reference_id = isset($ref['reference_id']) ? $ref['reference_id'] : "";
                $reference_name = isset($ref['reference_name']) ? $ref['reference_name'] : "";
                $reference_value = isset($ref['reference_value']) ? $ref['reference_value'] : "";

                $get_ref = $this->db->select('id')->get_where("tb_reference_master",array('name'=>$reference_id));
                if($get_ref->num_rows()>0){
                    $ins_ref = array('order_id'=>$order_id,'reference_id'=>$reference_id,'ref_value'=>$reference_value,'createdon'=>$cdate);
                    $ins = $this->db->insert('tb_order_references',$ins_ref);
                }else{
                    $ref_ar = array('name'=>$reference_id,'description'=>$reference_name,'status'=>'1','createdon'=>$cdate);
                    $this->db->insert('tb_reference_master',$ref_ar);
                    $reference_row_id = $this->db->insert_id();
                    $ins_ref = array('order_id'=>$order_id,'reference_id'=>$reference_id,'ref_value'=>$reference_value,'createdon'=>$cdate);
                    $ins = $this->db->insert('tb_order_references',$ins_ref);
                }
            }
        }
        $orders = array('order_id'=>$order_id,'booking_id'=>$booking_id,'carrier_id'=>$carrier_id,'lr_key'=>$lr_key,'vehicle_number'=>$vehicle_number);
        /* print_r($orders);exit;*/
        try {
            $this->altovaordercreation->sendOrderToAltova($order_id);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While Sending Order to Altova ".$ex->getMessage());
        }
        return $orders;

    }


    public function intripordershipment($orders){
        $dummy_array = array();
        $countryid = $this->session->userdata("usr_tzone")['phone_code'];
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        if(!empty($orders)){
            for($i=0, $iMax = count($orders); $i< $iMax; $i++){
                $order_forshift = $orders[$i]['order_id'];
                $vendor_forship = $orders[$i]['carrier_id'];
                $vehicle_forship = $orders[$i]['vehicle_number'];
                /*  $driver_forship = $orders[$i]['driver'];
                  $route_forship = $orders[$i]['route'];*/
                $booking_forship = $orders[$i]['booking_id'];
                $trip_forship = $orders[$i]['lr_key'];
                if(!in_array($orders[$i]['order_id'],$dummy_array)){
                    for($k=0, $kMax = count($orders); $k< $kMax; $k++){
                        $order_id = $orders[$k]['order_id'];
                        $booking_id = $orders[$k]['booking_id'];
                        $vendor_code = $orders[$k]['carrier_id'];
                        $register_number = $orders[$k]['vehicle_number'];
                        $trip_no = $orders[$k]['lr_key'];
                        /*$driver = $orders[$k]['driver'];
                        $route = $orders[$k]['route'];*/
                        if($trip_forship == $trip_no && $vendor_forship == $vendor_code){
                            $ord[] = $orders[$k];
                            $dummy_array[] =$orders[$k]['order_id'];
                        }
                    }
                }
            }
        }
        $j =0;
        for($i=0, $iMax = count($ord); $i< $iMax; $i++){
            if($j == '0'){
                $order_forshift = $ord[0]['order_id'];
                $vendor_forship = $ord[0]['carrier_id'];
                $vehicle_forship = $ord[0]['vehicle_number'];
                /*  $driver_forship = $ord[0]['driver'];
                  $route_forship = $ord[0]['route'];*/
                $booking_forship = $ord[0]['booking_id'];
                $trip_forship = $ord[0]['lr_key'];
            }else{
                $order_forshift = $ord[$j]['order_id'];
                $vendor_forship = $ord[$j]['carrier_id'];
                $vehicle_forship = $ord[$j]['vehicle_number'];
                /*   $driver_forship = $ord[$j]['driver'];
                   $route_forship = $ord[$j]['route'];*/
                $booking_forship = $ord[$j]['booking_id'];
                $trip_forship = $ord[$j]['lr_key'];
            }

            $order_id = $ord[$i]['order_id'];
            $booking_id = $ord[$i]['booking_id'];
            $vendor_code = $ord[$i]['carrier_id'];
            $register_number = $ord[$i]['vehicle_number'];
            $trip_no = $ord[$i]['lr_key'];
            /* $driver = $ord[$i]['driver'];
             $route = $ord[$i]['route'];*/
            $count_code=substr($company_code, 0, 2);

            $txnid = time();
            $year=date('y');
            $week=date('W');
            $seq_num=000001;
            if($booking_forship != "" && $booking_forship != ''){
                $seq_num=substr($booking_forship, -6);
            }
            $shipid = $txnid= "T".$count_code.$week.$year.$seq_num;
            if($vendor_code != ""){
                $response = 0;
                $user_id = $this->session->userdata('user_id');
                $userid = $this->session->userdata('user_id');
                $curtz = $this->session->userdata("usr_tzone")['timezone'];
                $logdate = date('Y-m-d H:i:s');
                $tpvehicle_type = 1;
                $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
                $curdt = $getactual['datetime'];
                $input = $this->input->post(null,true);
                $where  = array('code'=>$vendor_code,'status'=>'1');
                $select = "id,name";
                $table = "tb_vendors";
                $vendor_id = 0;
                $vendor_name  = "";
                $vendor_details = $this->common->gettblrowdata($where,$select,$table,0,0);
                if(count($vendor_details)>0){
                    $vendor_id = $vendor_details['id'];
                    $vendor_name = $vendor_details['name'];
                }
                if($vendor_id != 0){
                    $vslt = "id";
                    $vwhr = array('register_number'=>$register_number,'status'=>'Active','vendor_id'=>$vendor_id);
                    $vtbl = "tb_trucks_data";
                    $vehicle_details = $this->common->gettblrowdata($vwhr,$vslt,$vtbl,0,0);
                    if(count($vehicle_details)>0){
                        $vehicle_id = $vehicle_details['id'];
                    }else{
                        $vwhr = array('register_number'=>$register_number,'status'=>'Active');
                        $v1details = $this->common->gettblrowdata($vwhr,$vslt,$vtbl,0,0);
                        if(count($v1details) >0){
                            $vehicle_id = $v1details['id'];
                            $tablename = "tb_trucks_data";
                            $set = array("vendor_id"=>$vendor_id);
                            $whr = array('id'=>$vehicle_id);
                            $upd = $this->common->updatetbledata($tablename,$set,$whr);
                        }else{
                            $instable = "tb_trucks_data";
                            $insdata = array('truck_number'=>$register_number,'length'=>'0','breadth'=>'0','truck_capacity'=>'1','truck_type'=>'1','register_number'=>$register_number,'route'=>$register_number,'user_id'=>$user_id,'vendor_id'=>$vendor_id,'status'=>'Active','createdon'=>$logdate);
                            $vehicle_id = $this->common->insertTableData($instable,$insdata);
                        }
                    }
                }
                $driver_id = 0;$driver = "";
                if($driver != ""){
                    $dwhr = array('name'=>$driver);
                    $dslt = "id";
                    $dtbl = "tb_truck_drivers";
                    $driverdetails = $this->common->gettblrowdata($dwhr,$dslt,$dtbl,0,0);
                    if(count($driverdetails)>0){
                        $driver_id = $driverdetails['id'];
                    }else{
                        $dinstable = "tb_truck_drivers";
                        $pwd = RandomString::generate(10);
                        $password=password_hash($pwd, PASSWORD_DEFAULT);
                        $mobile = mt_rand(0,9);
                        $dinsdata = array('name'=>$driver,'password'=>$password,'contact_num'=>$mobile,'createdby'=>$user_id,'user_id'=>$user_id,'vendor_id'=>$vendor_id,'status'=>'Active','company_code'=>$company_code,'branch_code'=>$branch_code,'createdon'=>$logdate);
                        $vehicle_id = $this->common->insertTableData($dinstable,$dinsdata);
                    }
                }
                $sid = $order_id;
                if($shipid != "" && $vendor_id > 0 && $order_id >0){
                    $where = array("id"=>$order_id);
                    $select = "*";
                    $table = "tb_orders";
                    $order = $this->common->gettblrowdata($where,$select,$table,0,0);
                    if(count($order)>0){
                        $shift_idchk = $order['shift_id'];
                        if($shift_idchk == 0){
                            $stops_units = $this->db->query("SELECT oc.id,oc.quantity,oc.width,oc.height,oc.length,oc.weight,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.order_id = '$sid' AND im.id = oc.handling_unit AND oc.status='1'");
                            $pickup = $order['pickup_address1'];
                            if($pickup == ""){ $pickup = $order['pickup_city']; }
                            $delivery = $order['delivery_address1'];
                            if($delivery == ""){ $delivery = $order['delivery_city']; }
                            $address = $dropaddr = "";
                            if($order['pickup_address1'] != ""){
                                $address .= $order['pickup_address1'];
                                $dropaddr .= $order['delivery_address1'];
                            }
                            if($order['pickup_company'] != ""){
                                $address .= ", ".$order['pickup_company'];
                                $dropaddr .= ", ".$order['delivery_company'];
                            }
                            if($order['pickup_country'] != ""){
                                $address .= ", ".$order['pickup_country'];
                                $dropaddr .= ", ".$order['delivery_country'];
                            }
                            if($order['pickup_city'] != ""){
                                $address .= ", ".$order['pickup_city'];
                                $dropaddr .= ", ".$order['delivery_city'];
                            }
                            if($order['pickup_pincode'] != ""){
                                $address .= ", ".$order['pickup_pincode'];
                                $dropaddr .= ", ".$order['delivery_pincode'];
                            }
                            $plat = $order['plat'];
                            $plng = $order['plng'];
                            $dlat = $order['dlat'];
                            $dlng = $order['dlng'];
                            if($i == '0'){
                                $where = array("shipmentid"=>$shipid);
                                $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                                $table = "tb_shifts";
                                $shipment = $this->common->gettblrowdata($where,$select,$table,0,0);
                                if(count($shipment)==0){
                                    $curdt = $logdate;
                                    $splace = $order['pickup_address1'];
                                    $eplace = $order['delivery_address1'];
                                    $pickup_city = $order['pickup_city'];
                                    $delivery_city = $order['delivery_city'];
                                    $customer_id = $order['customer_id'];
                                    $transport_mode= $order['transport_mode'];
                                    $weight= $order['weight'];
                                    $volume= $order['volume'];
                                    $txnid = $shipid;
                                    if($tpvehicle_type!='' && $tpvehicle_type != 0){
                                        $vtwhere = array("id"=>$tpvehicle_type);
                                        $vtselect = "trucktype";
                                        $vttable = "tb_trucktypes";
                                        $vtorder = $this->common->gettblrowdata($vtwhere,$vtselect,$vttable,0,0);
                                        if(count($vtorder)>0){
                                            $vehicle_type = $vtorder['trucktype'];
                                        }else{
                                            $vehicle_type = $order['vehicle_type'];
                                        }
                                    }else{
                                        $vehicle_type = $order['vehicle_type'];
                                    }
                                    $startdate = $order['pickup_datetime'];
                                    $starttime = date('H:i',strtotime($startdate));
                                    $enddate = $order['delivery_datetime'];
                                    $endtime = date('H:i',strtotime($enddate));
                                    $insarr = array('user_id'=>$userid, 'stime'=>$starttime, 'etime'=>$endtime, 'splace'=>$order['pickup_city'], 'slat'=>$plat, 'slng'=>$plng, 'eplace'=>$order['delivery_city'], 'elat'=>$dlat, 'elng'=>$dlng, 'scity'=>$order['pickup_city'], 'dcity'=>$order['delivery_city'], 'zone_id'=>1, 'empshift_start'=>$starttime, 'empshift_end'=>$endtime, 'trip_type'=>0, 'startdate'=>$startdate, 'enddate'=>$enddate, 'shipment_name'=>'Boxes', 'shipment_id'=>0, 'transport_mode'=>$transport_mode, 'customer_id'=>$customer_id, 'vendor_id'=>$vendor_id, 'carrier_type'=>0, 'shipmentid'=>$txnid, 'txnid'=>$txnid,'weight'=>$weight, 'volume'=>$volume, 'units'=>$order['quantity'],'domainname'=>'INFD', 'vehicle_type'=>$vehicle_type,'company_code'=>$company_code,'branch_code'=>$branch_code, 'status'=>1);
                                    $this->db->insert("tb_shifts", $insarr);
                                    $ship_id = $this->db->insert_id();
                                }else{
                                    $ship_id = $shipment['id'];
                                }
                            }
                            else{
                                if($trip_forship == $trip_no && $vendor_forship == $vendor_code){
                                    $ship_id = $txnid = "0";
                                    $getshiftdata = $this->db->select("shift_id,shipmentid")->get_where("tb_orders",array('id'=>$order_forshift));
                                    if($getshiftdata->num_rows() >0){
                                        $ship_id = $getshiftdata->row()->shift_id;
                                        $txnid = $getshiftdata->row()->shipmentid;
                                    }
                                }else{
                                    $j =$i;
                                    $booking_forship = $ord[$j]['booking_id'];
                                    if($booking_forship != "" && $booking_forship != ''){
                                        $seq_num=substr($booking_forship, -6);
                                    }
                                    $shipid = $txnid= "T".$count_code.$week.$year.$seq_num;
                                    $where = array("shipmentid"=>$shipid);
                                    $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                                    $table = "tb_shifts";
                                    $shipment = $this->common->gettblrowdata($where,$select,$table,0,0);
                                    if(count($shipment)==0){
                                        $curdt = $logdate;
                                        $splace = $order['pickup_address1'];
                                        $eplace = $order['delivery_address1'];
                                        $pickup_city = $order['pickup_city'];
                                        $delivery_city = $order['delivery_city'];
                                        $customer_id = $order['customer_id'];
                                        $transport_mode= $order['transport_mode'];
                                        $weight= $order['weight'];
                                        $volume= $order['volume'];
                                        $txnid = $shipid;
                                        if($tpvehicle_type!='' && $tpvehicle_type != 0){
                                            $vtwhere = array("id"=>$tpvehicle_type);
                                            $vtselect = "trucktype";
                                            $vttable = "tb_trucktypes";
                                            $vtorder = $this->common->gettblrowdata($vtwhere,$vtselect,$vttable,0,0);
                                            if(count($vtorder)>0){
                                                $vehicle_type = $vtorder['trucktype'];
                                            }else{
                                                $vehicle_type = $order['vehicle_type'];
                                            }
                                        }else{
                                            $vehicle_type = $order['vehicle_type'];
                                        }
                                        $startdate = $order['pickup_datetime'];
                                        $starttime = date('H:i',strtotime($startdate));
                                        $enddate = $order['delivery_datetime'];
                                        $endtime = date('H:i',strtotime($enddate));
                                        $insarr = array('user_id'=>$userid, 'stime'=>$starttime, 'etime'=>$endtime, 'splace'=>$order['pickup_city'], 'slat'=>$plat, 'slng'=>$plng, 'eplace'=>$order['delivery_city'], 'elat'=>$dlat, 'elng'=>$dlng, 'scity'=>$order['pickup_city'], 'dcity'=>$order['delivery_city'], 'zone_id'=>1, 'empshift_start'=>$starttime, 'empshift_end'=>$endtime, 'trip_type'=>0, 'startdate'=>$startdate, 'enddate'=>$enddate, 'shipment_name'=>'Boxes', 'shipment_id'=>0, 'transport_mode'=>$transport_mode, 'customer_id'=>$customer_id, 'vendor_id'=>$vendor_id, 'carrier_type'=>0, 'shipmentid'=>$txnid, 'txnid'=>$txnid,'weight'=>$weight, 'volume'=>$volume, 'units'=>$order['quantity'],'domainname'=>'INFD', 'vehicle_type'=>$vehicle_type,'company_code'=>$company_code,'branch_code'=>$branch_code, 'status'=>1);
                                        $this->db->insert("tb_shifts", $insarr);
                                        $ship_id = $this->db->insert_id();
                                    }else{
                                        $ship_id = $shipment['id'];
                                    }

                                }
                            }


                            /*update order table*/
                            $capacity = $order['weight'];
                            if($capacity == ""){
                                $capacity = "0";
                            }
                            $upddt = array('vendor_id'=>$vendor_id,'shift_id'=>$ship_id,"shipmentid"=>$txnid);
                            $updwhr = array("id"=>$order_id);
                            $upd = $this->common->updatetbledata("tb_orders",$upddt,$updwhr);
                            $invtypes = makeorderinvolvedpartiestype($vendor_id,$order_id,"CARRIER", $user_id, $company_code);
                            $insarr = array('assoc_id'=>$txnid, 'pickup'=>$pickup, 'plat'=>$plat,
                                'plng'=>$plng, 'drop'=>$delivery,'dlat'=>$dlat, 'dlng'=>$dlng,
                                'pickup_city'=>$order['pickup_city'], 'drop_city'=>$order['delivery_city'],
                                'pickup_datetime'=>$order['pickup_datetime'], 'drop_datetime'=>$order['delivery_datetime'],
                                'name'=>'Boxes', 'phone'=>$order['customer_phone'],
                                'address'=>$address,'emailid'=>$order['customer_email'],
                                'user_id'=>$userid, 'status'=>1,
                                'createdon'=>$curdt, 'material_id'=>0,
                                'capacity'=>$capacity,
                                'information'=>$order['customer_comments'],
                                'shipment_weight'=>$order['weight'],
                                'shipment_volume'=>$order['volume'],
                                'ship_type'=>'P', 'customer_id'=>$order['customer_id'],
                                'vendor_id'=>$vendor_id, 'shipment_id'=>0, 'startdate'=>$order['pickup_datetime'],
                                'enddate'=>$order['delivery_datetime'], 'shift_id'=>$ship_id, 'stop_order'=>1,
                                'drop_order'=>0, 'basic_stop'=>0, 'stop_id'=>0, 'drop_stopid'=>0, 'order_id'=>$order['order_id'],
                                'pkgitemid'=>'BOXES', 'no_of_pkgs'=>$order['quantity'], 'domainname'=>'INFD');
                            $ins = $this->db->insert("tb_employee",$insarr);
                            $detail_id = $this->db->insert_id();
                            if($detail_id > 0 ){
                                if($stops_units->num_rows()>1){
                                    $odata=$stops_units->row();
                                    $upd = $this->db->query("UPDATE tb_order_cargodetails set stop_detail_id='$detail_id' WHERE id = '".$odata->id."'");
                                }
                                /*update orders table*/
                                $updwhr = array('id'=>$order_id);
                                $setwhr = array('status'=>2);
                                $ins = $this->db->where($updwhr)->update("tb_orders",$setwhr);
                                /*insert stops records */
                                $where = array("shipment_id"=>$ship_id,"stopcity"=>$order['pickup_city'],"stoptype"=>"P");
                                $select = "id";
                                $table = "tb_shiporder_stops";
                                $chkstop = $this->common->gettblrowdata($where,$select,$table,0,0);
                                if(count($chkstop) == 0){
                                    $insarr = array('stopname'=>$order['pickup_city'], 'plat'=>$plat, 'plng'=>$plng, 'stopcity'=>$order['pickup_city'], 'address'=>$address, 'stoptype'=>'P', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>1, 'startdate'=>$order['pickup_datetime'], 'enddate'=>$order['pickup_endtime'], 'weight'=>$order['weight'], 'volume'=>$order['volume'], 'shipmentstopid'=>0, 'ship_units'=>$order['quantity'], 'txncode'=>'NP', 'status'=>1, 'created_on'=>$curdt);
                                    $ins = $this->db->insert("tb_shiporder_stops",$insarr);
                                    $pickupstop_id = $this->db->insert_id();
                                }else{
                                    $pickupstop_id = $chkstop['id'];
                                }
                                $where = array("shipment_id"=>$ship_id,"stopcity"=>$order['delivery_city'],"stoptype"=>"D");
                                $select = "id";
                                $table = "tb_shiporder_stops";
                                $chkstop = $this->common->gettblrowdata($where,$select,$table,0,0);
                                if(count($chkstop) == 0){
                                    $insarr = array('stopname'=>$order['delivery_city'], 'plat'=>$dlat, 'plng'=>$dlng, 'stopcity'=>$order['delivery_city'], 'address'=>$dropaddr, 'stoptype'=>'D', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>2, 'startdate'=>$order['delivery_datetime'], 'enddate'=>$order['drop_endtime'], 'weight'=>$order['weight'], 'volume'=>$order['volume'], 'shipmentstopid'=>0, 'ship_units'=>$order['quantity'], 'txncode'=>'NP', 'status'=>1, 'created_on'=>$curdt);
                                    $ins = $this->db->insert("tb_shiporder_stops",$insarr);
                                    $dropstop_id = $this->db->insert_id();
                                }else{
                                    $dropstop_id = $chkstop['id'];
                                }
                                /*update pickupstop and drop stop id into details/tb_employee table */
                                $setarr = array('stop_id'=>$pickupstop_id, 'drop_stopid'=>$dropstop_id);
                                $setwhr = array('id'=>$detail_id);
                                $ins = $this->db->where($setwhr)->update("tb_employee",$setarr);
                                $chk1 = $this->db->select("id")->get_where("tb_shft_veh",array("shft_id"=>$ship_id),1,0);
                                if($chk1->num_rows() > 0){
                                    $shftvehid = $chk1->row()->id;
                                    $chk = $this->db->select("id")->get_where("tb_shft_veh_emp",array("shft_veh_id"=>$shftvehid,"status"=>1),1,0);
                                    if($chk->num_rows() == 0){
                                        $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee",array("shift_id"=>$ship_id));
                                        if($getemp->num_rows()>0){
                                            $pri = 1;
                                            foreach($getemp->result() as $gt){
                                                $insveh1 = array("user_id"=>$userid,"shft_veh_id"=>$shftvehid,"emp_id"=>$gt->id,"priority"=>$pri,"pickup_time"=>$gt->pickup_datetime, 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$gt->drop_datetime);
                                                $ins = $this->db->insert("tb_shft_veh_emp",$insveh1);
                                                $pri++;
                                            }
                                        }
                                    }else{
                                        $chkemp = $this->db->select("id")->get_where("tb_shft_veh_emp",array("shft_veh_id"=>$shftvehid,"emp_id"=>$detail_id,"status"=>1),1,0);
                                        if($chkemp->num_rows() == 0){
                                            $insveh1 = array("user_id"=>$userid,"shft_veh_id"=>$shftvehid,"emp_id"=>$detail_id,"priority"=>3,"pickup_time"=>$order['pickup_datetime'], 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$order['delivery_datetime']);
                                            $ins = $this->db->insert("tb_shft_veh_emp",$insveh1);
                                        }
                                    }
                                }else{
                                    if($vehicle_id != ""){
                                        $arr = array('user_id'=>$userid, 'route_id'=>0, 'shft_id'=>$ship_id, 'carrier_id'=>$vendor_id, 'vehicle_id'=>$vehicle_id, 'register_number'=>$register_number, 'status'=>1);
                                        $ins = $this->db->insert("tb_shft_veh",$arr);
                                        $shftvehid = $this->db->insert_id();
                                        $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee",array("shift_id"=>$ship_id));
                                        if($getemp->num_rows()>0){
                                            $pri = 1;
                                            foreach($getemp->result() as $gt){
                                                $insveh1 = array("user_id"=>$userid,"shft_veh_id"=>$shftvehid,"emp_id"=>$gt->id,"priority"=>$pri,"pickup_time"=>$gt->pickup_datetime, 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$gt->drop_datetime);
                                                $ins = $this->db->insert("tb_shft_veh_emp",$insveh1);
                                                $pri++;
                                            }
                                        }
                                    }
                                    if($vehicle_id != "" && $driver_id != ""){
                                        $chk = $this->db->select("id,driver_id,status")->order_by("id","DESC")->get_where("tb_vehicles_drivers",array("vehicle_id"=>$vehicle_id));
                                        if($chk->num_rows()>0){
                                            $driver_id = $chk->row()->driver_id;

                                        }
                                        if($driver_id >0){
                                            $chk11 = $this->db->select("id")->get_where("tbl_assigned_drivers",array("driver_id"=>$driver_id,"vehicle_id"=>$vehicle_id),1,0);
                                            if($chk11->num_rows()>0){
                                                $upd = $this->db->where(array("id"=>$chk11->row()->id))->update("tbl_assigned_drivers",array("status"=>"1",'updated_on'=>$curdt));
                                            }else{
                                                $chk111 = $this->db->select("id")->get_where("tbl_assigned_drivers",array("driver_id <>"=>$driver_id,"vehicle_id"=>$vehicle_id,"status"=>1),1,0);
                                                if($chk111->num_rows() == 0){
                                                    $ins = $this->db->insert("tbl_assigned_drivers",array("vehicle_id"=>$vehicle_id,"user_id"=>$userid,"driver_id"=>$driver_id,"mobile_no"=>$driver_id,"imei"=>"","from_time"=>$curdt,"to_time"=>$curdt,"status"=>"1",'created_on'=>$curdt));
                                                }else{
                                                    $upd = $this->db->where(array("id"=>$chk111->row()->id))->update("tbl_assigned_drivers",array("driver_id"=>$driver_id,'updated_on'=>$curdt));
                                                }
                                            }
                                        }

                                    }
                                }
                                $response = 1;
                                /* update status */
                                $chk = $this->db->select("id")->get_where("tb_stop_status",array("shipment_id"=>$ship_id,"status_id"=>9),1,0);
                                if($chk->num_rows() == 0){
                                    $curtz = $this->session->userdata("usr_tzone")['timezone'];
                                    $logdate = date('Y-m-d H:i:s');
                                    $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
                                    $curdt1 = $getactual['datetime'];
                                    $ins = array("shipment_id"=>$ship_id,"stop_id"=>0,"stop_detail_id"=>0,"stop_type"=>"","trip_id"=>0,"status_id"=>9,"status"=>1,"status_code"=>"0100","reason"=>"Coming from E-Booking","createdon"=>$curdt1);
                                    $insqry = $this->db->insert("tb_stop_status",$ins);
                                }
                            }
                        }
                    }
                }
            }
        }
    }


}

?>
