<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Packagetype extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        if ($this->session->userdata('user_id') != 30) {
            redirect("Forbiddenaccess");
        }
        $this->load->library('form_validation');
        $this->load->model("common");
        $this->load->model("packagetypemodel");
        if (!checkUrlAccessForUser('PACKAGETYPE')) {
            redirect("Forbiddenaccess");
        }
    }


    public function index()
    {
        if ($this->session->userdata('business_type') == "Carrier") {
            redirect('welcome/logout');
        }
        $data["page_title"] = $this->lang->line('bpartner_pkgtype');
        $data["sub_title"] = $this->lang->line('general_search');
        $where['status'] = 1;
        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
            $cargoType = $this->input->post('cargo_type', true);
            if (isset($cargoType) && $cargoType != "") {
                $where['cargo_type'] = $cargoType;
            }
            $handlingUnit = $this->input->post('handling_unit', true);
            if (isset($handlingUnit) && $handlingUnit != "") {
                $where['handling_unit'] = $handlingUnit;
            }
        }
        if (isset($_POST['searchsubmita']) && $_POST['searchsubmita'] == "Search") {
            $status = $this->input->post('status', true);
            if (isset($status) && $status != "") {
                $where['status'] = $status;
            }
            $cargoType = $this->input->post('acargo_type', true);
            if (isset($cargoType) && $cargoType != "") {
                $where['cargo_type'] = $cargoType;
            }
            $handlingUnit = $this->input->post('ahandling_unit', true);
            if (isset($handlingUnit) && $handlingUnit != "") {
                $where['handling_unit'] = $handlingUnit;
            }
        }
        $data['package_list'] = $this->packagetypemodel->getSearchData($where);
        $this->newtemplate->dashboard("packagetype/index", $data);
    }

    public function add()
    {
        if ($this->session->userdata('business_type') == "Carrier") {
            redirect('welcome/logout');
        }
        $data["page_title"] = $this->lang->line('bpartner_pkgtype');
        $data["sub_title"] = $this->lang->line('general_add');
        $this->newtemplate->dashboard("packagetype/add", $data);
    }

    public function save()
    {
        $this->form_validation->set_rules('cargo_type', $this->lang->line('bpartner_pkgtype'), 'required');
        $this->form_validation->set_rules('handling_unit', $this->lang->line('bpartner_pkgtype_category'), 'required');
        $this->form_validation->set_rules('length', $this->lang->line('general_length'), 'required');
        $this->form_validation->set_rules('length_unit', $this->lang->line('general_unit'), 'required');
        $this->form_validation->set_rules('width', $this->lang->line('general_width'), 'required');
        $this->form_validation->set_rules('width_unit', $this->lang->line('general_unit'), 'required');
        $this->form_validation->set_rules('weight', $this->lang->line('general_weight'), 'required');
        $this->form_validation->set_rules('weight_unit', $this->lang->line('general_unit'), 'required');
        $this->form_validation->set_rules('volume', $this->lang->line('general_volume'), 'required');
        $this->form_validation->set_rules('volume_unit', $this->lang->line('general_unit'), 'required');
        if ($this->form_validation->run() == false) {
            $this->load->view('packagetype/add');
        }
        $post = $this->input->post(null, true);

        $packageTypeName = $post['cargo_type'] ?? '';
        $packageTypeCategory = $post['handling_unit'] ?? '';
        $length = $post['length'] ?? 0.00;
        $lengthUnit = $post['length_unit'] ?? '';
        $width = $post['width'] ?? 0.00;
        $widthUnit = $post['width_unit'] ?? '';
        $weight = $post['weight'] ?? 0.00;
        $weightUnit = $post['weight_unit'] ?? '';
        $height = $post['height'] ?? 0.00;
        $heightUnit = $post['height_unit'] ?? '';
        $volume = $post['volume'] ?? 0.000;
        $volumeUnit = $post['volume_unit'] ?? '';
        $data = [
            "cargo_type" => $packageTypeName,
            "handling_unit" => $packageTypeCategory,
            "length" => $length,
            "length_unit" => $lengthUnit,
            "width" => $width,
            "width_unit" => $widthUnit,
            "height" => $height,
            "height_unit" => $heightUnit,
            "weight" => $weight,
            "weight_unit" => $weightUnit,
            "volume" => $volume,
            "volume_unit" => $volumeUnit,
            "createdon" => date('Y-m-d H:i:s')
        ];
        echo json_encode($this->common->insertTableData('tb_cargo_details', $data));
    }

    public function view(int $id): void
    {
        $data["page_title"] = $this->lang->line('bpartner_pkgtype');
        $data["sub_title"] = $this->lang->line('general_view');
        $data['pkg_type'] = $this->packagetypemodel->getPackageTypeData($id);
        $this->newtemplate->dashboard('packagetype/view', $data);
    }

    public function edit(int $id): void
    {
        $data["page_title"] = $this->lang->line('bpartner_pkgtype');
        $data["sub_title"] = $this->lang->line('general_edit');
        $data['pkg_type'] = $this->packagetypemodel->getPackageTypeData($id);
        $this->newtemplate->dashboard('packagetype/edit', $data);
    }

    public function delete(int $id): void
    {
        if ($id > 0) {
            $result = $this->db->where(['id' => $id])->update('tb_cargo_details', ['status' => 0]);
        }
        echo (isset($result)) ? "1" : "0";
    }

    public function update(int $id): void
    {
        if ($id > 0) {
            $post = $this->input->post(null, true);
            $packageTypeName = $post['cargo_type'] ?? '';
            $packageTypeCategory = $post['handling_unit'] ?? '';
            $length = $post['length'] ?? 0.00;
            $lengthUnit = $post['length_unit'] ?? '';
            $width = $post['width'] ?? 0.00;
            $widthUnit = $post['width_unit'] ?? '';
            $weight = $post['weight'] ?? 0.00;
            $weightUnit = $post['weight_unit'] ?? '';
            $height = $post['height'] ?? 0.00;
            $heightUnit = $post['height_unit'] ?? '';
            $volume = $post['volume'] ?? 0.000;
            $volumeUnit = $post['volume_unit'] ?? '';
            $data = [
                "cargo_type" => $packageTypeName,
                "handling_unit" => $packageTypeCategory,
                "length" => $length,
                "length_unit" => $lengthUnit,
                "width" => $width,
                "width_unit" => $widthUnit,
                "height" => $height,
                "height_unit" => $heightUnit,
                "weight" => $weight,
                "weight_unit" => $weightUnit,
                "volume" => $volume,
                "volume_unit" => $volumeUnit,
                "createdon" => date('Y-m-d H:i:s')
            ];
            $this->common->updatetbledata('tb_cargo_details', $data, ['id' => $id]);
            echo json_encode($id);
        }
    }

    public function checkPackageTypeData()
    {
        $post = $this->input->post(null, true);
        $id = $post['id'] ?? '';
        $packageTypeName = $post['cargo_type'] ?? '';
        $packageTypeCategory = $post['handling_unit'] ?? '';
        $length = $post['length'] ?? '';
        $lengthUnit = $post['length_unit'] ?? '';
        $width = $post['width'] ?? '';
        $widthUnit = $post['width_unit'] ?? '';
        $weight = $post['weight'] ?? '';
        $weightUnit = $post['weight_unit'] ?? '';
        $height = $post['height'] ?? '';
        $heightUnit = $post['height_unit'] ?? '';
        $volume = $post['volume'] ?? '';
        $volumeUnit = $post['volume_unit'] ?? '';
        $where = [
            "cargo_type" => $packageTypeName,
            "handling_unit" => $packageTypeCategory,
            "length" => $length,
            "length_unit" => $lengthUnit,
            "width" => $width,
            "width_unit" => $widthUnit,
            "height" => $height,
            "height_unit" => $heightUnit,
            "weight" => $weight,
            "weight_unit" => $weightUnit,
            "volume" => $volume,
            "volume_unit" => $volumeUnit,
            'status' => 1
        ];
        if ($id > 0) {
            $where['id !='] = $id;
        }
        $company = $this->common->gettblrowdata($where, 'id', 'tb_cargo_details', 0, 0);
        echo (empty($company)) ? "2" : "1";
    }
}
