<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once APPPATH . "/third_party/PHPExcel.php";

class Pactactivityreport extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        if ($this->session->userdata('company_code') != "NZPG") {
            redirect("Forbiddenaccess");
        }
        $this->userRoleId = $this->session->userdata('user_role_id');
        $this->load->model(['DataArrayFormatter_model', 'DataQueryFormatter_model', 'Datatables_model']);
    }

    public function index()
    {
        if ($this->userRoleId === "1") {
            $this->getCountryAdminSearchResult();
        } elseif ($this->userRoleId === "3") {
            redirect("Forbiddenaccess");
        } else {
            $this->getsearchresult();
        }
    }

    public function getCountryAdminSearchResult(){
        $data['postData'] = $this->input->post(null, true);
        $data['page_title'] = $this->lang->line('pactactivityreport');
        $data['sub_title'] = $this->lang->line('leftmenu_reports');
        $this->newtemplate->dashboard("pactactivityreport/countryAdminIndex", $data);
    }

    public function getsearchresult()
    {
        $business_type = $this->session->userdata('business_type');
        if ($business_type == 'Carrier') {
            redirect('/');
        }
        $data['page_title'] = $this->lang->line('pactactivityreport');
        $data['sub_title'] = $this->lang->line('leftmenu_reports');
        $this->newtemplate->dashboard("pactactivityreport/index", $data);
    }

    public function searchorders($post)
    {
        $whr = [];
        $statusSearch = isset($post['aquordtype']) ? $post['aquordtype'] : "";
        if ($statusSearch == 'MANIFESTED') {
            if (isset($post['aqufromdate']) && $post['aqufromdate'] != "") {
                $aqufromdate = date('Y-m-d', strtotime($post['aqufromdate']));
                $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >="] = $aqufromdate;
            }
            if (isset($post['aqutodate']) && $post['aqutodate'] != "") {
                $todate = date('Y-m-d', strtotime($post['aqutodate']));
                $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="] = $todate;
            }

            if (isset($post['booking_id']) && $post['booking_id'] != "") {
                $whr['o.order_id'] = $post['booking_id'];
            }
        } else {
            if (($statusSearch == "CLOSED") && ($this->session->userdata('company_code') == 'AUKN')) {
                if (isset($post['booking_id']) && $post['booking_id'] != "") {
                    $whr['o.order_id'] = $post['booking_id'];
                }
            } else {
                if (isset($post['aqufromdate']) && $post['aqufromdate'] != "") {
                    $aqufromdate = date('Y-m-d', strtotime($post['aqufromdate']));
                    $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $aqufromdate;
                }
                if (isset($post['aqutodate']) && $post['aqutodate'] != "") {
                    $todate = date('Y-m-d', strtotime($post['aqutodate']));
                    $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
                }

                if (isset($post['booking_id']) && $post['booking_id'] != "") {
                    $whr['o.order_id'] = $post['booking_id'];
                }
            }
        }
        return $whr;
    }

    public function getbookingid()
    {
        $uid = $this->session->userdata('user_id');
        $custid = "";
        $country_userids = [];
        if (!empty($this->session->userdata("country_user_ids")) && ($this->session->userdata("country_user_ids") != null) && (count($this->session->userdata("country_user_ids")) > 0)) {
            $country_userids = $this->session->userdata("country_user_ids");
        }
        $business_type = $this->session->userdata('business_type');
        if (!empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        $booking_id = isset($_POST["booking_id"]) ? $_POST["booking_id"] : "";
        $booking_id = trim($booking_id);
        $data = $subcusts = [];
        if (!empty($custid)) {
            if ($this->session->userdata('sub_cust') !== false) {
                $subcusts = $this->session->userdata('sub_cust');
                if (count($subcusts) > 0) {
                    array_push($subcusts, $custid);
                } else {
                    $subcusts = [
                        $custid
                    ];
                }
            } else {
                $subcusts = [
                    $custid
                ];
            }
        }
        if ($custid || !empty($subcusts)) {
            $get_data = $this->db->query(
                "SELECT order_id
                    FROM tb_orders
                    WHERE order_id LIKE ?
                    AND customer_id IN ?
                    AND status > ?",
                ['%' . $booking_id . '%', !empty($subcusts) ? $subcusts : [$custid], '0']
            );
        } else {
            $get_data = $this->db->query(
                "SELECT order_id
                    FROM tb_orders
                    WHERE order_id LIKE ?
                    AND status > ?",
                ['%' . $booking_id . '%', '0']
            );
        }
        if ($get_data->num_rows() > 0) {
            foreach ($get_data->result() as $get_data_f) {
                $data[] = $get_data_f->order_id;
            }
        }
        echo json_encode($data);
    }

    public function ajaxListing()
    {
        if ($this->session->userdata('user_id') == '') {
            echo 'SessionTimeout';
            return false;
        }
        $dataTableSortOrdering = [];
        $status_search = '';
        $wherecondition = '';
        $draw = $this->input->post('draw', true);
        $start = $this->input->post('start', true);
        $limit = $this->input->post('length', true);
        $orderBy = $this->input->post('order', true);

        $userid = $this->session->userdata("user_id");
        $company_code = $this->session->userdata("company_code");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $business_type = $this->session->userdata('business_type');
        if (!empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        $country_userids = $other_checks = $subcusts = [];
        if (!empty($this->session->userdata("country_user_ids")) && ($this->session->userdata("country_user_ids") != null) && (count($this->session->userdata("country_user_ids")) > 0)) {
            $country_userids = $this->session->userdata("country_user_ids");
        }
        $indexColumn = 'o.id';
        $post = $this->input->post('data', true);
        $whr = $this->searchorders($post);
        $order_status = isset($post['aquordtype']) ? $post['aquordtype'] : "";
        if (!empty($order_status)) {
            $status_search = $order_status;
        }
        $other_checks['status_search'] = $status_search;
        $other_checks['closed_from_date'] = $other_checks['closed_to_date'] = "";

        if ($this->session->userdata('user_role_id') == '4') {
            $userid = 0;
        }
        if (!empty($custid)) {
            if ($this->session->userdata('sub_cust') !== false) {
                $subcusts = $this->session->userdata('sub_cust');
                if (!empty($subcusts)) {
                    array_push($subcusts, $custid);
                } else {
                    $subcusts = [
                        $custid
                    ];
                }
            } else {
                $subcusts = [
                    $custid
                ];
            }
        }
        $orderTableCondition = [];
        if (!empty($whr)) {
            foreach ($whr as $key => $value) {
                $value = "'$value'";
                if ($key == "DATE_FORMAT(o.createdon,'%Y-%m-%d') >=" || $key == "DATE_FORMAT(o.createdon,'%Y-%m-%d') <=" || $key == "DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >=" || $key == "DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <=") {
                    $orderTableCondition[] = $key . $value;
                } else {
                    $orderTableCondition[] = $key . ' = ' . $value;
                }
            }
        }
        $orderTableCondition[] = 'o.status!=0';
        if (isset($other_checks) && !empty($other_checks)) {
            if (isset($other_checks['status_search']) && !empty($other_checks['status_search'])) {
                $status_search = $other_checks['status_search'];
                if ($status_search == 'PENDING') {
                    $orderTableCondition[] = "o.trip_id = 0";
                } else {
                    if ($status_search == 'ACTIVE') {
                        $orderTableCondition[] = "o.trip_id!= 0";
                        $orderTableCondition[] = "o.trip_sts= 0";
                    } else {
                        if ($status_search == 'CLOSED') {
                            $orderTableCondition[] = "o.trip_id!= 0";
                            $orderTableCondition[] = "o.trip_sts= 1";
                        }
                    }
                }
            }
        }
        if ($userid != '0' && $userid != '') {
            if (!empty($country_userids) && count($country_userids) > 0) {
                $countryuseridsArray = implode(',', $country_userids);
                if ($countryuseridsArray != '') {
                    $orderTableCondition[] = "o.user_id in ($countryuseridsArray)";
                }
            } else {
                $orderTableCondition[] = "o.user_id = '$userid' ";
            }
        }
        $orderTableWhere = implode(' AND ', $orderTableCondition);
        $orderByCondition = '';
        if (isset($orderBy[0])) {
            if ($orderBy[0] != '') {
                $ordColIndex = $orderBy[0]['column'];
                $ordColDir = $orderBy[0]['dir'];
                if ($ordColDir == '') {
                    $ordColDir = 'asc';
                }
                if (isset($dataTableSortOrdering[$ordColIndex]) && $dataTableSortOrdering[$ordColIndex] != '') {
                    $orderByCondition = '  ' . $dataTableSortOrdering[$ordColIndex] . ' ' . $ordColDir . ' ';
                }
            }
        }
        if ($orderTableWhere != '') {
            $orderTableWhere = " and $orderTableWhere ";
        }
        $joinArray = [];
        $whereArray = [];
        if ($status_search == 'MANIFESTED') {
            if (!isset($sql)) {
                $sql = "select o.id from tb_orders o ";
            }
            $joinArray[] = ['tb' => 'tb_order_status os', 'condition' => 'os.order_id=o.id', 'type' => 'LEFT'];
            $whereArray[] = " os.status=1 and os.status_code=2492";
        }
        $ordCon = '';
        if (!empty($whereArray) && sizeof($whereArray) > 0) {
            $ordCon = implode(' AND ', $whereArray);
        }
        if (!empty($joinArray) && sizeof($joinArray) > 0) {
            if (!isset($sql)) {
                $sql = "select o.id from tb_orders o ";
            }
            foreach ($joinArray as $eachJoin) {
                $sql .= ' ' . $eachJoin['type'] . ' join ' . $eachJoin['tb'] . ' on ' . $eachJoin['condition'] . '';
            }
            $sql .= " where o.id!= '' ";
            if ($ordCon != '') {
                $sql .= " and $ordCon ";
            }
            $orderNumbers = '';
            if ($sql != '') {
                $dat = $this->db->query($sql);
                if ($dat->num_rows() > 0) {
                    $resultant = $dat->result_array();
                    if (!empty($resultant) && sizeof($resultant) > 0) {
                        foreach ($resultant as $eachOrdNum) {
                            $orderNumbers = $orderNumbers . $eachOrdNum['id'] . ',';
                        }
                    }
                    $orderNumbers = trim($orderNumbers, ',');
                    if ($orderNumbers != '') {
                        $orderTableWhere .= " and o.id in ($orderNumbers)";
                    }
                }
            }
        }
        if (!empty($subcusts) && sizeof($subcusts) > 0) {
            $customerIdCondition = implode(',', $subcusts);
            if ($customerIdCondition != '') {
                $orderTableWhere .= " and o.customer_id in ($customerIdCondition)";
            }
        }
        $countAndOrderIdQuery = "select count(o.id) as count from tb_orders o
        where o.id!=0  $orderTableWhere ";
        $compiledCount = '';
        $resultSet = $this->db->query($countAndOrderIdQuery);
        if ($resultSet->num_rows() > 0) {
            $resdata = $resultSet->result_array();
            if (isset($resdata[0]['count'])) {
                $compiledCount = $resdata[0]['count'];
            }
        } else {
            $compiledCount = 0;
        }
        $selectColumns = [
            'o.id',
            'o.order_id',
            'o.goods_value',
            'o.transport_mode',
            'o.pickup_company',
            'o.pickup_city',
            'o.pickup_address1',
            'o.pickup_address2',
            'o.pickup_pincode',
            'o.delivery_company',
            'o.delivery_city',
            'o.delivery_address1',
            'o.delivery_address2',
            'o.delivery_pincode',
            'o.pickup_datetime',
            'o.delivery_datetime',
            'o.createdon',
            'o.shift_id',
            'o.drop_endtime',
            'o.vendor_id',
            'o.customer_id',
            'o.branch_code',
            'o.shipmentid',
            'tv.name as supplierName',
            'tv.name',
            'tv.address as supplierSteeetHouse',
            'tv.pincode as supplierPostalCode',
            'tv.code as supplierId',
            'cust.name as customer_name',
            'cust.code as customer_code',
            'cust.street as customer_street',
            'cust.pincode as customer_pincode'
        ];
        $table_name = 'tb_orders o';
        $indexColumn = 'o.id';
        $groupBy = 'o.id';
        $excludeCountQuery = 'Yes';
        $wherecondition = $indexColumn . "!='' " . $orderTableWhere;
        $orderByCondition = $orderByCondition;
        $timeZone = $curtz;
        $joinsArray[] = ['table_name' => 'tb_vendors as tv', 'condition' => "tv.id=o.vendor_id", 'join_type' => 'left'];
        $joinsArray[] = ['table_name' => 'tb_customers as cust', 'condition' => "cust.id=o.customer_id", 'join_type' => 'left'];
        $dataTableSortOrdering = [];
        $getRecordListing = $this->Datatables_model->datatablesQuery($selectColumns, $dataTableSortOrdering, $table_name, $joinsArray, $wherecondition, $indexColumn, 'TRUE', $groupBy, $excludeCountQuery, 'POST');
        if ($excludeCountQuery == 'Yes') {
            $totalRecords = $compiledCount;
            $recordsFiltered = $compiledCount;
        } else {
            $totalRecords = $getRecordListing['recordsTotal'];
            $recordsFiltered = $getRecordListing['recordsFiltered'];
        }
        $reqData = ['id', 'shift_id'];
        $this->db->query('SET SESSION  group_concat_max_len=10240');
        $formattedData = $this->DataArrayFormatter_model->getCommaSeparatedFields($reqData, $getRecordListing['data']);
        if (isset($formattedData['commaSeparated']['id']) && $formattedData['commaSeparated']['id'] != '') {
            $formattedData = $this->DataQueryFormatter_model->getReportOrderCargoDetails($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getOrderReferenceData($formattedData['commaSeparated']['id'], $formattedData, "'DQ','PO'");
            $formattedData = $this->DataQueryFormatter_model->getOrderTypeDetails($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getOrderCostTypeDetails($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getReportPartyDetails($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getChargeInfo($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getOrderStopStatusStatus($formattedData['commaSeparated']['id'], $formattedData, '0212');
        }
        if (isset($formattedData['commaSeparated']['shift_id']) && $formattedData['commaSeparated']['shift_id'] != '') {
            $deliveredStatusArray = $this->DataQueryFormatter_model->getStopStatusDelviered($formattedData['commaSeparated']['shift_id']);
            $genericStatusArray = $this->DataQueryFormatter_model->getStopStatusGeneric($formattedData['commaSeparated']['shift_id']);
        }
        $getRecordListing = [];
        if (isset($formattedData['orders'])) {
            $getRecordListing = $formattedData['orders'];
            krsort($getRecordListing);
        }
        $recordListing = [];
        $content = '[';
        $i = 0;
        if (!empty($getRecordListing)) {
            $cntr = 1;
            foreach ($getRecordListing as $res) {
                $this->load->helper('local_timezone_helper');
                $lastStatusName = $purchaseOrderNo = $deliveryOrderNo = $cargoQuantity = $cargoPackageType = $cargoActualWeight = $cargoWeightUnit = $cargoActualVolume = $cargoVolumeUnit = $chargeCodeStr = $chargeNameStr = $chargeAmountStr = $chargeCurrencyStr = $currency = $costTypeName = $departmentCode = $orderTypeName = $shipperId = $shipperId = $aconDebitorCode = $accepted = "";
                $totalCostAmount = 0;

                if (array_key_exists('stop_status_code', $res)) {
                    if ($res['stop_status_code'] != '') {
                        $stopStatusArray = [$res['stop_status_createdon'], $res['stop_status_code']];
                        $getStopStatusArray = $this->DataArrayFormatter_model->buildGenericArray($stopStatusArray);
                        if (!empty($getStopStatusArray) && sizeof($getStopStatusArray) > 0) {
                            foreach ($getStopStatusArray as $eachItem) {
                                if ($eachItem['status_code'] == '0212') {
                                    //Accepted  time
                                    $accepted = $eachItem['createdon'];
                                    if ($accepted != "" && $accepted != "0000-00-00 00:00:00" && $accepted != "0") {
                                        $pdate = getdatetimebytimezone($curtz, $accepted, DFLT_TZ);
                                        $accepted = date('Y-m-d h:i A', strtotime($pdate['datetime']));
                                    }
                                }
                            }
                        }
                    }
                }
                if (array_key_exists('partydetails_party_customer_identifier', $res)) {
                    $aconDebitorCodeStr = $res['partydetails_acon_debitor_code'];
                    $aconDebitorCodeArr = explode("?????", $aconDebitorCodeStr);
                    $customerIdentifierStr = $res['partydetails_party_customer_identifier'];
                    $customerIdentifierArr = explode("?????", $customerIdentifierStr);
                    $partyTypeNameStr = $res['partydetails_party_type_name'];
                    $partyTypeNameArr = explode("?????", $partyTypeNameStr);
                    foreach ($partyTypeNameArr as $key => $val) {
                        $partyName = str_replace("party_type_name=====", "", $val);
                        if ($partyName == "Consignee") {
                            $consigneeId = str_replace("party_customer_identifier=====", "", $customerIdentifierArr[$key]);
                        } else {
                            if ($partyName == "Shipper") {
                                $shipperId = str_replace("party_customer_identifier=====", "", $customerIdentifierArr[$key]);
                            } else {
                                if ($partyName == "CUSTOMER") {
                                    $aconDebitorCode = str_replace("acon_debitor_code=====", "", $aconDebitorCodeArr[$key]);
                                }
                            }
                        }
                    }
                }
                if (array_key_exists('cost_type_name', $res)) {
                    $costTypeName = $res['cost_type_name'];
                }
                if (array_key_exists('department_code', $res)) {
                    $departmentCode = $res['department_code'];
                }
                if (array_key_exists('order_type_name', $res)) {
                    $orderTypeName = $res['order_type_name'];
                }
                $delivery_status = "Not Delivered";
                $reqStatusData = ['status_code' => '', 'stop_type' => '', 'status_id' => ''];
                if (isset($res['shift_id']) && $res['shift_id'] != '' && $res['shift_id'] != 0) {
                    $shiftIndex = $res['shift_id'];
                    if (isset($deliveredStatusArray[$shiftIndex])) {
                        if ($deliveredStatusArray[$shiftIndex]['delivered_status_status_code'] == '3000') {
                            $lastStatusName = $deliveredStatusArray[$shiftIndex]['delivered_status_status_name'];
                            $reqStatusData['status_code'] = $deliveredStatusArray[$shiftIndex]['delivered_status_status_code'];
                            $reqStatusData['stop_type'] = $deliveredStatusArray[$shiftIndex]['delivered_status_stop_type'];
                            $reqStatusData['status_id'] = $deliveredStatusArray[$shiftIndex]['delivered_status_id'];
                        }
                    } else {
                        if (isset($genericStatusArray[$shiftIndex])) {
                            $lastStatusName = $genericStatusArray[$shiftIndex]['generic_status_status_name'];
                            $reqStatusData['status_code'] = $genericStatusArray[$shiftIndex]['generic_status_status_code'];
                            $reqStatusData['stop_type'] = $genericStatusArray[$shiftIndex]['generic_status_stop_type'];
                            $reqStatusData['status_id'] = $genericStatusArray[$shiftIndex]['generic_status_id'];
                        }
                    }
                    if ($reqStatusData['status_id'] == 1) {
                        if ($reqStatusData['stop_type'] == "P") {
                            $lastStatusName = "Pickedup";
                        } else {
                            $lastStatusName = "Delivered";
                        }
                    }
                    if ($reqStatusData['status_code'] == '0192' && $reqStatusData['stop_type'] == 'D' && $company_code == "INKN") {
                        $lastStatusName = "In Transit";
                    }
                    if ($reqStatusData['status_code'] == '0420' || $reqStatusData['status_code'] == '0191' && $reqStatusData['stop_type'] == 'P' && $company_code == "INKN") {
                        $lastStatusName = "Pick Up";
                    }
                    if ($reqStatusData['status_code'] == '3000' && $reqStatusData['stop_type'] == 'D') {
                        $date = '0000-00-00 00:00:00';
                        $d_time = getEDAofNZShipmentbyord($res['id']);
                        $d_date = $d_time['time'];
                        $delivery_status = "Delivered";
                        if (isset($d_date) && $d_date != "") {
                            if (($d_date != $date) || (strtotime($d_date) > 0)) {
                                $delivery_date = date("d M Y", strtotime($d_date));
                            } else {
                                $delivery_date = "";
                            }
                        }
                    }
                }
                if (array_key_exists('reference_value', $res)) {
                    $referenceValue = preg_replace("/\s+/", "", $res['reference_value']);
                    $referenceValueArr = explode("?????", $referenceValue);
                    foreach ($referenceValueArr as $val) {
                        if (strpos($val, "DQ") !== false) {
                            $deliveryOrderNo = str_replace('DQ=====', '', $val);
                        } else {
                            if (strpos($val, "PO") !== false) {
                                $purchaseOrderNo = str_replace('PO=====', '', $val);
                            }
                        }
                    }
                }
                if (array_key_exists('cargo_quantity', $res)) {
                    $cargoQuantity = $res['cargo_quantity'];
                }
                if (array_key_exists('cargo_package_type', $res)) {
                    $cargoPackageType = $res['cargo_package_type'];
                }
                if (array_key_exists('cargo_actual_weight', $res)) {
                    $cargoActualWeight = $res['cargo_actual_weight'];
                }
                if (array_key_exists('cargo_actual_weight_unit', $res)) {
                    $cargoWeightUnit = $res['cargo_actual_weight_unit'];
                }
                if (array_key_exists('cargo_actual_volume', $res)) {
                    $cargoActualVolume = $res['cargo_actual_volume'];
                }
                if (array_key_exists('cargo_actual_volume_unit', $res)) {
                    $cargoVolumeUnit = $res['cargo_actual_volume_unit'];
                }
                $content .= '[';
                $j = 0;
                $recordListing[$i][0] = '';
                $recordListing[$i][++$j] = $cntr;
                $recordListing[$i][++$j] = $res['order_id'];
                $recordListing[$i][++$j] = $deliveryOrderNo;
                $recordListing[$i][++$j] = $purchaseOrderNo;
                $order_cdate = $res['createdon'];
                if ($order_cdate != "" && $order_cdate != "0000-00-00 00:00:00" && $order_cdate != "0") {
                    $ocreatedon = getdatetimebytimezone($curtz, $order_cdate, DFLT_TZ);
                    $order_cdate = date('Y-m-d', strtotime($ocreatedon['datetime']));
                }
                $recordListing[$i][++$j] = $order_cdate;
                $recordListing[$i][++$j] = $shipperId;
                $recordListing[$i][++$j] = $res['pickup_company'];
                $recordListing[$i][++$j] = $res['pickup_address1'];
                $recordListing[$i][++$j] = $res['pickup_address2'];
                $recordListing[$i][++$j] = $res['pickup_city'];
                $recordListing[$i][++$j] = $res['pickup_pincode'];
                $recordListing[$i][++$j] = $consigneeId;
                $recordListing[$i][++$j] = $res['delivery_company'];
                $recordListing[$i][++$j] = $res['delivery_address1'];
                $recordListing[$i][++$j] = $res['delivery_address2'];
                $recordListing[$i][++$j] = $res['delivery_city'];
                $recordListing[$i][++$j] = $res['delivery_pincode'];
                $recordListing[$i][++$j] = $res['customer_code'];
                $recordListing[$i][++$j] = $aconDebitorCode;
                $recordListing[$i][++$j] = $res['customer_name'];
                $recordListing[$i][++$j] = $res['customer_street'];
                $recordListing[$i][++$j] = $res['customer_pincode'];
                $recordListing[$i][++$j] = $res['branch_code'];
                $recordListing[$i][++$j] = $costTypeName;
                $recordListing[$i][++$j] = $departmentCode;
                $recordListing[$i][++$j] = $orderTypeName;
                $recordListing[$i][++$j] = $res['transport_mode'];
                $recordListing[$i][++$j] = $cargoQuantity;
                $recordListing[$i][++$j] = $cargoPackageType;
                $recordListing[$i][++$j] = $cargoActualWeight;
                $recordListing[$i][++$j] = $cargoWeightUnit;
                $recordListing[$i][++$j] = $cargoActualVolume;
                $recordListing[$i][++$j] = $cargoVolumeUnit;
                $recordListing[$i][++$j] = $res['shipmentid'];
                $recordListing[$i][++$j] = $res['supplierName'];
                $recordListing[$i][++$j] = $res['supplierId'];
                $recordListing[$i][++$j] = $res['supplierName'];
                $recordListing[$i][++$j] = $res['supplierSteeetHouse'];
                $recordListing[$i][++$j] = $res['supplierPostalCode'];
                $k = 1;
                if (array_key_exists('chargedetails_chargecode', $res)) {
                    $chargeCodeArr = explode('?????', $res['chargedetails_chargecode']);
                    $chargeNameArr = explode('?????', $res['chargedetails_chargecodename']);
                    $chargeAmountArr = explode('?????', $res['chargedetails_amount']);
                    $chargeCurrencyArr = explode('?????', $res['chargedetails_currency']);
                    foreach ($chargeCodeArr as $key => $val) {
                        if ($k > 5) {
                            break;
                        }
                        $k++;
                        $recordListing[$i][++$j] = str_replace("charge_code=====", "", $val);
                        $recordListing[$i][++$j] = str_replace("name=====", "", $chargeNameArr[$key]);
                        $amtArr = str_replace("amount=====", "", $chargeAmountArr[$key]);
                        $recordListing[$i][++$j] = $amtArr;
                        $totalCostAmount = $amtArr + $totalCostAmount;
                        $currency = str_replace("currency=====", "", $chargeCurrencyArr[$key]);
                    }
                }
                if ($k <= 5) {
                    for ($l = $k; $l <= 5; $l++) {
                        $recordListing[$i][++$j] = "";
                        $recordListing[$i][++$j] = "";
                        $recordListing[$i][++$j] = "";
                    }
                }

                $recordListing[$i][++$j] = $totalCostAmount;
                $recordListing[$i][++$j] = $currency;
                $recordListing[$i][++$j] = $accepted;
                $recordListing[$i][++$j] = $lastStatusName;
                $i++;
                $cntr++;
            }
            $content .= ']';
            $final_data = json_encode($recordListing);
        } else {
            $final_data = '[]';
        }
        echo '{"draw":' . $draw . ',"recordsTotal":' . $totalRecords . ',"recordsFiltered":' . $recordsFiltered . ',"data":' . $final_data . '}';
    }

    public function getAllBranchOrdersList()
    {
        if ($this->userRoleId !== "1") {
            redirect("Forbiddenaccess");
        }
        $statusSearch = '';
        $draw = $this->input->post('draw', true);
        $start = $this->input->post('start', true);
        $limit = $this->input->post('length', true);
        $orderBy = $this->input->post('order', true);
        $timeZone = $this->session->userdata("usr_tzone")['timezone'];
        $countryUserIds = $otherChecks = [];
        if (!empty($this->session->userdata("country_user_ids")) && ($this->session->userdata("country_user_ids") != null) && (count($this->session->userdata("country_user_ids")) > 0)) {
            $countryUserIds = $this->session->userdata("country_user_ids");
        }
        if (empty($countryUserIds)) {
            redirect('/');
        }
        $post = $this->input->post('data', true);
        $where = $this->searchorders($post);
        $orderStatus = $post['aquordtype'] ?? "";
        if (!empty($orderStatus)) {
            $statusSearch = $orderStatus;
        }
        $otherChecks['status_search'] = $statusSearch;
        $otherChecks['closed_from_date'] = $otherChecks['closed_to_date'] = "";

        $orderTableCondition = [];
        foreach ($where as $key => $value) {
            $value = "'$value'";
            if ($key == "DATE_FORMAT(o.createdon,'%Y-%m-%d') >=" || $key == "DATE_FORMAT(o.createdon,'%Y-%m-%d') <=" || $key == "DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >=" || $key == "DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <=") {
                $orderTableCondition[] = $key . $value;
            } else {
                $orderTableCondition[] = $key . ' = ' . $value;
            }
        }
        $orderTableCondition[] = 'o.status!=0';
        if (isset($otherChecks) && !empty($otherChecks)) {
            if (isset($otherChecks['status_search']) && !empty($otherChecks['status_search'])) {
                $statusSearch = $otherChecks['status_search'];
                if ($statusSearch == 'PENDING') {
                    $orderTableCondition[] = "o.trip_id = 0";
                } elseif ($statusSearch == 'ACTIVE') {
                    $orderTableCondition[] = "o.trip_id!= 0";
                    $orderTableCondition[] = "o.trip_sts= 0";
                } elseif ($statusSearch == 'CLOSED') {
                    $orderTableCondition[] = "o.trip_id!= 0";
                    $orderTableCondition[] = "o.trip_sts= 1";
                }
            }
        }
        if (!empty($countryUserIds)) {
            $countryUsersArray = implode(',', $countryUserIds);
            if ($countryUsersArray != '') {
                $orderTableCondition[] = "o.user_id in ($countryUsersArray)";
            }
        }
        $orderTableWhere = implode(' AND ', $orderTableCondition);
        if (isset($orderBy[0])) {
            if ($orderBy[0] != '') {
                $ordColIndex = $orderBy[0]['column'];
                $ordColDir = $orderBy[0]['dir'];
                if ($ordColDir == '') {
                    $ordColDir = 'asc';
                }
            }
        }
        if ($orderTableWhere != '') {
            $orderTableWhere = " and $orderTableWhere ";
        }
        $joinArray = [];
        $whereArray = [];
        $sql = "select o.id from tb_orders o ";

        if ($statusSearch == 'MANIFESTED') {
            $joinArray[] = ['tb' => 'tb_order_status os', 'condition' => 'os.order_id=o.id', 'type' => 'LEFT'];
            $whereArray[] = " os.status=1 and os.status_code=2492";
        }
        $ordCon = '';
        if (!empty($whereArray) && sizeof($whereArray) > 0) {
            $ordCon = implode(' AND ', $whereArray);
        }
        if (!empty($joinArray)) {
            foreach ($joinArray as $eachJoin) {
                $sql .= ' ' . $eachJoin['type'] . ' join ' . $eachJoin['tb'] . ' on ' . $eachJoin['condition'] . '';
            }
            $sql .= " where o.id!= '' ";
            if ($ordCon != '') {
                $sql .= " and $ordCon ";
            }
            $orderNumbers = '';
            if ($sql != '') {
                $dat = $this->db->query($sql);
                if ($dat->num_rows() > 0) {
                    $resultant = $dat->result_array();
                    if (!empty($resultant) && sizeof($resultant) > 0) {
                        foreach ($resultant as $eachOrdNum) {
                            $orderNumbers = $orderNumbers . $eachOrdNum['id'] . ',';
                        }
                    }
                    $orderNumbers = trim($orderNumbers, ',');
                    if ($orderNumbers != '') {
                        $orderTableWhere .= " and o.id in ($orderNumbers)";
                    }
                }
            }
        }
        $countAndOrderIdQuery = "select count(o.id) as count from tb_orders o where o.id!=0  $orderTableWhere ";
        $compiledCount = '';
        $resultSet = $this->db->query($countAndOrderIdQuery);
        if ($resultSet->num_rows() > 0) {
            $resdata = $resultSet->result_array();
            if (isset($resdata[0]['count'])) {
                $compiledCount = $resdata[0]['count'];
            }
        } else {
            $compiledCount = 0;
        }
        $selectColumns = [
            'o.id',
            'o.order_id',
            'o.goods_value',
            'o.transport_mode',
            'o.pickup_company',
            'o.pickup_city',
            'o.pickup_address1',
            'o.pickup_address2',
            'o.pickup_pincode',
            'o.delivery_company',
            'o.delivery_city',
            'o.delivery_address1',
            'o.delivery_address2',
            'o.delivery_pincode',
            'o.pickup_datetime',
            'o.delivery_datetime',
            'o.createdon',
            'o.shift_id',
            'o.drop_endtime',
            'o.vendor_id',
            'o.customer_id',
            'o.branch_code',
            'o.shipmentid',
            'tv.name as supplierName',
            'cust.name as customer_name',
            'cust.code as customer_code',
        ];
        $excludeCountQuery = 'Yes';
        $wherecondition = "o.id !='' " . $orderTableWhere;
        $joinsArray[] = ['table_name' => 'tb_vendors as tv', 'condition' => "tv.id=o.vendor_id", 'join_type' => 'left'];
        $joinsArray[] = ['table_name' => 'tb_customers as cust', 'condition' => "cust.id=o.customer_id", 'join_type' => 'left'];
        $getRecordListing = $this->Datatables_model->datatablesQuery($selectColumns, [], 'tb_orders o', $joinsArray, $wherecondition, 'o.id', 'TRUE', 'o.id', 'Yes', 'POST');
        if ($excludeCountQuery == 'Yes') {
            $totalRecords = $compiledCount;
            $recordsFiltered = $compiledCount;
        } else {
            $totalRecords = $getRecordListing['recordsTotal'];
            $recordsFiltered = $getRecordListing['recordsFiltered'];
        }
        $reqData = ['id', 'shift_id'];
        $this->db->query('SET SESSION  group_concat_max_len=10240');
        $formattedData = $this->DataArrayFormatter_model->getCommaSeparatedFields($reqData, $getRecordListing['data']);
        if (isset($formattedData['commaSeparated']['id']) && $formattedData['commaSeparated']['id'] != '') {
            $formattedData = $this->DataQueryFormatter_model->getReportOrderCargoDetails($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getOrderReferenceData($formattedData['commaSeparated']['id'], $formattedData, "'DQ'");
            $formattedData = $this->DataQueryFormatter_model->getOrderTypeDetails($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getOrderCostTypeDetails($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getChargeInfo($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getOrderStopStatusStatus($formattedData['commaSeparated']['id'], $formattedData, "0500,3000");
            $formattedData = $this->DataQueryFormatter_model->getPODUploads($formattedData['commaSeparated']['id'], $formattedData);
        }
        $getRecordListing = [];
        if (isset($formattedData['orders'])) {
            $getRecordListing = $formattedData['orders'];
            krsort($getRecordListing);
        }
        $recordListing = [];
        $content = '[';
        $i = 0;
        if (!empty($getRecordListing)) {
            $cntr = 1;
            foreach ($getRecordListing as $res) {
                $this->load->helper('local_timezone_helper');
                $deliveryOrderNo = $currency = "";
                $totalCostAmount = 0;
                $costTypeName = $res['cost_type_name'] ?? "";
                $departmentCode = $res['department_code'] ?? "";
                $orderTypeName = $res['order_type_name'] ?? "";
                $checkReferenceValue = $res['reference_value'] ?? "";
                if ($checkReferenceValue != "") {
                    $referenceValue = preg_replace("/\s+/", "", $res['reference_value']);
                    $referenceValueArr = explode("?????", $referenceValue);
                    foreach ($referenceValueArr as $val) {
                        if (strpos($val, "DQ") !== false) {
                            $deliveryOrderNo = str_replace('DQ=====', '', $val);
                        }
                    }
                }
                $stopStatusCode = $res['stop_status_code'] ?? "";
                $deliveredDateTime = $pickupDateTime = "";
                if ($stopStatusCode != '') {
                    $getStopStatusArray = $this->DataArrayFormatter_model->buildGenericArray([$res['stop_status_createdon'], $res['stop_status_code']]);
                    foreach ($getStopStatusArray as $eachItem) {
                        if ($eachItem['status_code'] == '0500') {
                            $pickupDate = $eachItem['createdon'];
                            if ($pickupDate != "" && $pickupDate != "0000-00-00 00:00:00" && $pickupDate != "0") {
                                $pickupDateArray = getdatetimebytimezone($timeZone, $pickupDate, DFLT_TZ);
                                $pickupDateTime = date('Y-m-d h:i A', strtotime($pickupDateArray['datetime']));
                            }
                        }
                        if ($eachItem['status_code'] == '3000') {
                            $deliveredTime = $eachItem['createdon'];
                            if ($deliveredTime != "" && $deliveredTime != "0000-00-00 00:00:00" && $deliveredTime != "0") {
                                $deliverydate = getdatetimebytimezone($timeZone, $deliveredTime, DFLT_TZ);
                                $deliveredDateTime = date('Y-m-d h:i A', strtotime($deliverydate['datetime']));
                            }
                        }
                    }
                }
                $podStatus = $pickupPod = $dropPod = "";
                $podData = $res['pod_details'] ?? "";
                if ($podData != '') {
                    $podArray = $this->DataArrayFormatter_model->formatGenericParameters($podData);
                    if (!empty($podArray)) {
                        foreach ($podArray as $eachPod) {
                            $stopType = $eachPod['stop_type'] ?? "";
                            if ($stopType == 'P') {
                                $pickupPod = $eachPod['createdon'];
                                if ($pickupPod != "" && $pickupPod != "0000-00-00 00:00:00" && $pickupPod != "0") {
                                    $pickupPodArray = getdatetimebytimezone($timeZone, $pickupPod, DFLT_TZ);
                                    $pickupPod = date('Y-m-d h:i A', strtotime($pickupPodArray['datetime']));
                                }
                            } elseif ($stopType == 'D') {
                                $dropPod = $eachPod['createdon'];
                                if ($dropPod != "" && $dropPod != "0000-00-00 00:00:00" && $dropPod != "0") {
                                    $dropPodArray = getdatetimebytimezone($timeZone, $dropPod, DFLT_TZ);
                                    $dropPod = date('Y-m-d h:i A', strtotime($dropPodArray['datetime']));
                                }
                            }
                        }
                    }
                    if ($dropPod != "" && $dropPod != "0000-00-00 00:00:00") {
                        $podStatus .= "ePOD Available - " . date("d M,y h:i A", strtotime($dropPod)) . "<br>";
                    }

                    if ($pickupPod != "" && $pickupPod != "0000-00-00 00:00:00") {
                        $podStatus .= "Goods Loaded for Delivery-" . date("d M,y h:i A", strtotime($pickupPod)) . " ";
                    }
                }
                $cargoQuantity = $res['cargo_quantity'] ?? "";
                $cargoPackageType = $res['cargo_package_type'] ?? "";
                $cargoActualWeight = $res['cargo_actual_weight'] ?? "";
                $cargoWeightUnit = $res['cargo_actual_weight_unit'] ?? "";
                $cargoActualVolume = $res['cargo_actual_volume'] ?? "";
                $cargoVolumeUnit = $res['cargo_actual_volume_unit'] ?? "";

                $j = 0;
                $recordListing[$i][0] = '';
                $recordListing[$i][++$j] = $cntr;
                $recordListing[$i][++$j] = $res['branch_code'];
                $recordListing[$i][++$j] = $res['customer_name'];
                $recordListing[$i][++$j] = $res['order_id'];
                $recordListing[$i][++$j] = $deliveryOrderNo;
                $orderDate = $res['createdon'];
                if ($orderDate != "" && $orderDate != "0000-00-00 00:00:00" && $orderDate != "0") {
                    $ocreatedon = getdatetimebytimezone($timeZone, $orderDate, DFLT_TZ);
                    $orderDate = date('Y-m-d', strtotime($ocreatedon['datetime']));
                }
                $recordListing[$i][++$j] = $orderDate;
                $recordListing[$i][++$j] = $res['pickup_company'];
                $recordListing[$i][++$j] = $res['pickup_address1'];
                $recordListing[$i][++$j] = $res['pickup_address2'];
                $recordListing[$i][++$j] = $res['pickup_city'];
                $recordListing[$i][++$j] = $res['delivery_company'];
                $recordListing[$i][++$j] = $res['delivery_address1'];
                $recordListing[$i][++$j] = $res['delivery_address2'];
                $recordListing[$i][++$j] = $res['delivery_city'];
                $recordListing[$i][++$j] = $res['customer_code'];

                $recordListing[$i][++$j] = $costTypeName;
                $recordListing[$i][++$j] = $departmentCode;
                $recordListing[$i][++$j] = $orderTypeName;
                $recordListing[$i][++$j] = $res['transport_mode'];
                $recordListing[$i][++$j] = $cargoQuantity;
                $recordListing[$i][++$j] = $cargoPackageType;
                $recordListing[$i][++$j] = $cargoActualWeight;
                $recordListing[$i][++$j] = $cargoWeightUnit;
                $recordListing[$i][++$j] = $cargoActualVolume;
                $recordListing[$i][++$j] = $cargoVolumeUnit;
                $recordListing[$i][++$j] = $res['shipmentid'];
                $recordListing[$i][++$j] = $res['supplierName'];
                $recordListing[$i][++$j] = $pickupDateTime;
                $recordListing[$i][++$j] = $deliveredDateTime;
                $k = 1;
                if (array_key_exists('chargedetails_chargecode', $res)) {
                    $chargeCodeArr = explode('?????', $res['chargedetails_chargecode']);
                    $chargeNameArr = explode('?????', $res['chargedetails_chargecodename']);
                    $chargeAmountArr = explode('?????', $res['chargedetails_amount']);
                    $chargeCurrencyArr = explode('?????', $res['chargedetails_currency']);
                    foreach ($chargeCodeArr as $key => $val) {
                        if ($k > 5) {
                            break;
                        }
                        $k++;
                        $recordListing[$i][++$j] = str_replace("charge_code=====", "", $val);
                        $recordListing[$i][++$j] = str_replace("name=====", "", $chargeNameArr[$key]);
                        $amtArr = str_replace("amount=====", "", $chargeAmountArr[$key]);
                        $recordListing[$i][++$j] = $amtArr;
                        $totalCostAmount = $amtArr + $totalCostAmount;
                        $currency = str_replace("currency=====", "", $chargeCurrencyArr[$key]);
                    }
                }
                if ($k <= 5) {
                    for ($l = $k; $l <= 5; $l++) {
                        $recordListing[$i][++$j] = "";
                        $recordListing[$i][++$j] = "";
                        $recordListing[$i][++$j] = "";
                    }
                }

                $recordListing[$i][++$j] = $totalCostAmount;
                $recordListing[$i][++$j] = $currency;
                $recordListing[$i][++$j] = $podStatus;
                $i++;
                $cntr++;
            }
            $final_data = json_encode($recordListing);
        } else {
            $final_data = '[]';
        }
        echo '{"draw":' . $draw . ',"recordsTotal":' . $totalRecords . ',"recordsFiltered":' . $recordsFiltered . ',"data":' . $final_data . '}';
    }
}
