<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Panic extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
    }

    public function getAlerts(): void
    {
        $user_id = $this->session->userdata("user_id");
        $data = [];
        $data["status"] = "0";
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $userPanicAlertInfo = $this->session->has_userdata('usr_tzone') ? $this->session->userdata('usr_tzone') : [];
        $isPanicAlertRequired = (int)$userPanicAlertInfo['is_panic_alert_required'] ?? 1;
        if ($user_id != "" && $isPanicAlertRequired) {
            if (in_array($this->session->userdata("business_type"), ["Truck_Owner","Customer"])) {
                $dbFields = [
                    'pa.id',
                    'pa.driver_id',
                    'pa.trip_id',
                    'pa.vehicle_id',
                    'pa.user_id',
                    'pa.shift_id',
                    'pa.shipmentid',
                    'pa.driver_name',
                    'pa.contact_num',
                    'pa.lat',
                    'pa.lng',
                    'pa.splace',
                    'pa.stime',
                    'pa.eplace',
                    'pa.etime',
                    "convertToClientTZ(pa.clicked_on,'{$curtz}') as clicked_on",
                    'td.register_number',
                    'td.truck_number'
                ];
                $query = $this->db->select($dbFields)
                    ->from('tb_panic_alerts pa')
                    ->join('tb_trucks_data td', 'td.id = pa.vehicle_id', 'LEFT')
                    ->where([
                        'pa.user_id' => $user_id,
                        'pa.status' => 1
                    ])->group_by('pa.driver_id')
                    ->order_by('pa.id', 'DESC')
                    ->get();

                $alerts = $query->result();
                array_walk($alerts, function ($alert) {
                    $alert->position = getLocationName($alert->lat, $alert->lng);
                });

                if ($query->num_rows() > 0) {
                    $data["status"] = "1";
                    $data["html"] = $this->load->view("panic/view", ["alerts" => $alerts], true);
                }
            }
        }
        echo json_encode($data);
    }

    public function setPanicAlertStatus(): void
    {
        $panic_id = $this->input->post("id");
        $status = $this->input->post("status");
        $resolution_panic = $this->input->post("resolution_panic");
        $curdt = date('Y-m-d H:i:s');
        $uid = $this->session->userdata('user_id');
        if ($this->db->where(["id" => $panic_id])->get("tb_panic_alerts")->num_rows() > 0) {
            $this->db->where(["id" => $panic_id])->update("tb_panic_alerts", ["status" => $status, 'resolution_panic' => $resolution_panic, 'updated_by' => $uid, 'updated_on' => $curdt]);
        }
    }
}
