<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

/**
 * ParentCarrierServiceWorker updates parent_id for Carriers
 *
 * index() should be ran daily or often
 */
class ParentCarrierServiceWorker extends CI_Controller
{
    private const INTERFACE_CLI = 'cli';

    public function __construct()
    {
        parent::__construct();
        $this->load->model('common');
    }

    /**
     * @throws Throwable
     */
    public function index()
    {
        if (php_sapi_name() !== self::INTERFACE_CLI) {
            die('This action is command line only');
        }

        // Carrier sync
        $this->carrierSync();
    }

    /**
     *
     */
    private function carrierSync(): void
    {
        $carriers = $this->db->select('id, name, code')
            ->group_by('code')
            ->where("code != ''")
            ->having('count(code) > 1')
            ->get('tb_vendors')->result_array();

        foreach ($carriers as $carrier) {
            $this->db->where('code', $carrier['code'])
                ->where("id != ", $carrier['id'])
                ->update('tb_vendors', [
                    'parent_id' => $carrier['id']
                ]);
        }
    }
}
