<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Profile extends CI_Controller
{

    private $user_role_id = "";

    public function __Construct()
    {
        parent::__Construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model("common");
        $this->load->helper('drop_down');
    }

    public function index()
    {
        /**
         * user_role_id=1 means (appAdmin and countryAdmin) tables (tb_users,tb_admin_users)
         * user_role_id=2 means (Admin) tables(tb_users,tb_user_logins)
         * user_role_id=3 means (carrier) tables(tb_vendors)
         * user_role_id=4 means (customers) tables(tb_customers,tb_customer_logins)
         */
        error_reporting(0);
        $this->user_role_id = $this->session->userdata('user_role_id');
        $business_type = $this->session->userdata('business_type');
        $business_type = trim($business_type);
        /* log_message('error', "user_role_id:::" . $this->user_role_id); */
        $data['page_title'] = $this->lang->line('leftmenu_profile');
        $data['sub_title'] = $this->lang->line('leftmenu_profile');
        if ($this->user_role_id == "1") {
            if ($business_type == "app_admin") {
                $data['profile_data'] = $this->appAdmin();
            } else {
                $this->countryAdmin();
                exit;
            }
        } elseif ($this->user_role_id == "3") {
            $data['profile_data'] = $this->carrier();
        } elseif ($this->user_role_id == "4") {
            if (isset($_SESSION["child_id"])) {
                $this->subCustomer();
                exit;
            } else {
                $data['profile_data'] = $this->customer();
            }
        } elseif ($this->user_role_id == "5") {
            $uid = $this->session->userdata('id');
            $data['profile_data'] = $this->common->gettblrowdata(['id' => $uid], '*', 'kn_operators', 0, 0);
        } elseif (isset($_SESSION["childid"])) {
            $this->subUser();
            exit;
        } elseif($this->user_role_id == "6"){
            $this->countryAdmin();
            exit;
        } else {
            $uid = $this->session->userdata('user_id');
            $data['profile_data'] = $this->common->gettblrowdata([
                'id' => $uid
            ], '*', 'tb_users', 0, 0);
        }

        $this->settemplate->dashboard('userprofile', $data);
    }

    private function countryAdmin()
    {
        $data['page_title'] = $this->lang->line('leftmenu_profile');
        $data['sub_title'] = $this->lang->line('leftmenu_profile');
        $data = [];
        $uid = $this->session->userdata('user_id');
        $profile_data = $this->common->gettblrowdata([
            'id' => $uid
        ], '*', 'tb_admin_users', 0, 0);

        $data['user'] = [
            "id" => $profile_data["id"],
            "name" => $profile_data["name"],
            "mobile_no" => $profile_data["mobile_no"],
            "password" => $profile_data["password"],
            "emailid" => $profile_data["emailid"],
            "business_type" => $profile_data["business_type"],
            "user_code" => "",
            "attorney_number" => "",
            "attorney_date" => "",
            "signpath" => "",
            'job_profile' => ""
        ];

        $this->newtemplate->dashboard('profile/knsubuserprofile', $data);
    }

    private function appAdmin()
    {
        $data = [];
        $uid = $this->session->userdata('user_id');
        $data = $this->common->gettblrowdata([
            'id' => $uid
        ], '*', 'tb_users', 0, 0);

        return $data;
    }

    private function carrier()
    {
        $uid = $this->session->userdata('id');
        $profile_data = $this->common->gettblrowdata([
            'id' => $uid
        ], '*', 'tb_vendors', 0, 0);
        return [
            "id" => $profile_data["id"],
            "country_code" => $profile_data["country"],
            "name" => $profile_data["name"],
            "mobile_no" => $profile_data["mobile"],
            "password" => $profile_data["password"],
            "emailid" => $profile_data["email"],
            "location_id" => $profile_data["pincode"],
            "company_indv_name" => $profile_data["company_name"],
            "head_office" => $profile_data["address"],
            "gstin" => "",
            "company_code" => $profile_data["company_code"],
            "branch_code" => $profile_data["branch_code"],
            "attorney_number" => "",
            "attorney_date" => "",
            "job_profile " => ""
        ];
    }

    private function customer()
    {
        $uid = $this->session->userdata('cust_id');
        $profile_data = $this->common->gettblrowdata([
            'id' => $uid
        ], '*', 'tb_customers', 0, 0);

        return [
            "id" => $profile_data["id"],
            "country_code" => $profile_data["country"],
            "name" => $profile_data["name"],
            "mobile_no" => $profile_data["phone"],
            "password" => $profile_data["password"],
            "emailid" => $profile_data["email_id"],
            "location_id" => $profile_data["address"],
            "company_indv_name" => $profile_data["name"],
            "head_office" => $profile_data["location"],
            "gstin" => "",
            "company_code" => $profile_data["company_code"],
            "branch_code" => $profile_data["branch_code"],
            "attorney_number" => "",
            "attorney_date" => "",
            "job_profile" => ""
        ];
    }

    private function subUser()
    {
        $data['page_title'] = $this->lang->line('leftmenu_profile');
        $data['sub_title'] = $this->lang->line('leftmenu_profile');
        $id = $this->session->userdata('childid');

        if ($id > 0) {
            $data['user'] = $this->common->gettblrowdata(['id' => $id], '*', 'tb_user_logins', 0, 0);
            if (!empty($data['user'])) {
                $this->newtemplate->dashboard('profile/knsubuserprofile', $data);
            } else {
                $uid = $this->session->userdata('user_id');
                $data['profile_data'] = $this->common->gettblrowdata(['id' => $uid], '*', 'tb_users', 0, 0);
                $this->settemplate->dashboard('userprofile', $data);
            }
        }
    }

    private function subCustomer()
    {
        $data['page_title'] = $this->lang->line('leftmenu_profile');
        $data['sub_title'] = $this->lang->line('leftmenu_profile');
        $id = $this->session->userdata('child_id');
        if ($id > 0) {
            $sub_cus = $this->common->gettblrowdata(['id' => $id], '*', 'tb_customer_logins', 0, 0);
            $data['user'] = [
                "id" => $sub_cus["id"],
                "name" => $sub_cus["name"],
                "mobile_no" => $sub_cus["code"],
                "password" => $sub_cus["password"],
                "emailid" => $sub_cus["email_id"],
                "business_type" => "",
                "user_code" => ""
            ];

            if (!empty($data['user'])) {
                $this->newtemplate->dashboard('profile/knsubuserprofile', $data);
            } else {
                $data['profile_data'] = $this->customer();
                $this->settemplate->dashboard('userprofile', $data);
            }
        }
    }

    public function updateprofile(): void
    {
        $id = $this->session->userdata('user_id');
        $com = $this->input->get_post('company_indv_name', true);
        $nam = $this->input->get_post('name', true);
        $ema = $this->input->get_post('emailid', true);
        $country_code = $this->input->get_post('country_code', true);
        $branch_code = $this->input->get_post('branch_code', true);
        $head_office = $this->input->get_post('head_office', true);
        $gstin = $this->input->get_post('gstin', true);
        $password = $this->input->get_post('password');
        $cnf_password = $this->input->get_post('confirm_password');
        $attorney_number = $this->input->get_post('attorney_number', true);
        $job_profile = $this->input->get_post('job_profile', true);
        $attorney_date = $this->input->get_post('attorney_date', true);
        $attorney_date = (!empty($attorney_date)) ? (date("Y-m-d", strtotime($attorney_date))) : '0000-00-00';

        $this->form_validation->set_rules('company_indv_name', 'Company Name', 'trim|required');
        $this->form_validation->set_rules('name', 'User name', 'trim|required');
        $this->form_validation->set_rules('emailid', 'Email', 'trim|required|valid_email');
        $this->form_validation->set_rules('country_code', 'Country Name', 'trim|required');
        $this->form_validation->set_rules('company_code', 'Company Code', 'trim|required');
        $this->form_validation->set_rules('branch_code', 'Branch Code', 'trim|required');

        if ($password != $cnf_password) {
            $this->session->set_flashdata('error_msg', "Password and confirm password does not match");
        } elseif ($this->form_validation->run() == false) {
            $this->session->set_flashdata('error_msg', "Please enter valid details");
        } else {
            if ($_POST["ispwdedit"] == "1") {
                $password = password_hash($password, PASSWORD_DEFAULT);
                $data = [];
                $data["company_indv_name"] = $com;
                $data["name"] = $nam;
                $data["emailid"] = $ema;
                $data["password"] = $password;
                $data["country_code"] = $country_code;
                $data["branch_code"] = $branch_code;
                $data["head_office"] = $head_office;
                $data["gstin"] = $gstin;
                $data["attorney_number"] = $attorney_number;
                $data["job_profile"] = $job_profile;
            } elseif ($_POST["ispwdedit"] == "0") {
                $data = [];
                $data["company_indv_name"] = $com;
                $data["name"] = $nam;
                $data["emailid"] = $ema;
                $data["country_code"] = $country_code;
                $data["branch_code"] = $branch_code; //
                $data["head_office"] = $head_office; //
                $data["gstin"] = $gstin; //
                $data["attorney_number"] = $attorney_number;
                $data["job_profile"] = $job_profile;
            }

            if ($this->session->userdata('user_role_id') == "3") {
                $this->carrierProfileUpdate($data);
            } elseif ($this->session->userdata('user_role_id') == "4") {
                $this->customerProfileUpdate($data);
            } elseif (!empty($data)) {
                $data["signpath"] = $fileName = "";
                if (isset($_FILES)) {
                    if (isset($_FILES['signature']['name'])) {
                        $file_name = $_FILES['signature']['name'];
                        $signatures = explode('.', $_FILES['signature']['name']);
                        $file_ext = @strtolower(end($signatures));
                        $expensions = ["jpeg", "jpg", "png", "gif"];
                        if (in_array($file_ext, $expensions)) {
                            if ($file_name != "") {
                                $fileName = date('dmyhis') . '_' . $file_name;
                                $filePath = './assets/signatures/' . $fileName;
                                $imgsize = getimagesize($_FILES['signature']['tmp_name']);
                                if ($imgsize == false) {
                                } else {
                                    $quality = 50;
                                    if ($file_ext == "png") {
                                        $top = @imagecreatefrompng($_FILES['signature']['tmp_name']);
                                    } else {
                                        $top = @imagecreatefromjpeg($_FILES['signature']['tmp_name']);
                                    }
                                    if ($top) {
                                        header('Content-Type: image/jpeg');
                                        @imagejpeg($top, $filePath, $quality);
                                        @imagedestroy($top);
                                    } else {
                                        $fileName = "";
                                    }
                                }
                            }
                        }
                    }
                }
                if ($fileName != "") {
                    $data["signpath"] = $fileName;
                }
                if ($attorney_date != "") {
                    $data["attorney_date"] = $attorney_date;
                }
                $this->db->where("id", $id)->update("tb_users", $data);
            }
            $this->session->set_flashdata('success_msg', "Updated Successfully");
        }

        redirect('profile');
    }

    private function carrierProfileUpdate(array $data): void
    {
        $up_data = [
            "country" => $data["country_code"],
            "name" => $data["name"],
            "email" => $data["emailid"],
            "location" => $data["location_id"],
            "company_name" => $data["company_indv_name"],
            "address" => $data["head_office"]
        ];
        if (isset($data['password'])) {
            $up_data["password"] = $data["password"];
        }
        $id = $this->session->userdata('id');

        $this->common->updatetbledata('tb_vendors', $up_data, ['id' => $id]);
    }

    private function customerProfileUpdate(array $data): void
    {
        $up_data = [
            "email_id" => $data["emailid"],
            "address" => $data["location_id"],
            "name" => $data["company_indv_name"],
            "location" => $data["head_office"],
            "branch_code" => $data["branch_code"]
        ];
        if (isset($data['password'])) {
            $up_data["password"] = $data["password"];
        }
        $id = $this->session->userdata('cust_id');
        $this->common->updatetbledata('tb_customers', $up_data, ['id' => $id]);
    }

    public function updateknsubuser()
    {
        if (isset($_POST)) {
            $input = $this->input->post(null, true);
            if ($this->session->userdata('user_role_id') == "1" || $this->session->userdata('user_role_id') == "6"  ) {
                $this->countryAdminUpdate($input);
                exit;
            } elseif ($this->session->userdata('user_role_id') == "4") {
                $this->subCustomerUpdate($input);
                exit;
            }
            $id = $this->session->userdata("childid");
            if ($id != "") {
                $chk = $this->common->gettblrowdata([
                    "id" => $id
                ], "emailid,mobile_no", "tb_user_logins", 0, 0);
                $is_unique = $mis_unique = '';
                if (count($chk) > 0) {
                    if ($input['email'] != $chk['emailid']) {
                        $is_unique = '|is_unique[tb_user_logins.emailid]';
                    }
                    if ($input['mobile_no'] != $chk['mobile_no']) {
                        $mis_unique = '|is_unique[tb_user_logins.mobile_no]';
                    }
                }
                $this->form_validation->set_rules('name', 'Profile Name', 'required');
                $this->form_validation->set_rules('mobile_no', 'Username', 'required' . $mis_unique);
                $this->form_validation->set_rules('password', 'Password', 'required');
                $this->form_validation->set_rules('email', 'Email', 'required|valid_email' . $is_unique);
                if ($this->form_validation->run() == false) {
                    $this->form_validation->set_error_delimiters('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert">&times;</a>', '</div>');
                    $this->index();
                } else {
                    $array["signpath"] = $fileName = "";
                    if (isset($_FILES)) {
                        if (isset($_FILES['signature']['name'])) {
                            $file_name = $_FILES['signature']['name'];
                            $signatures = explode('.', $_FILES['signature']['name']);
                            $file_ext = @strtolower(end($signatures));
                            $expensions = ["jpeg", "jpg", "png", "gif"];
                            if (in_array($file_ext, $expensions)) {
                                if ($file_name != "") {
                                    $fileName = date('dmyhis') . '_' . $file_name;
                                    $filePath = './assets/signatures/' . $fileName;
                                    $imgsize = getimagesize($_FILES['signature']['tmp_name']);
                                    if ($imgsize == false) {
                                    } else {
                                        $quality = 50;
                                        if ($file_ext == "png") {
                                            $top = @imagecreatefrompng($_FILES['signature']['tmp_name']);
                                        } else {
                                            $top = @imagecreatefromjpeg($_FILES['signature']['tmp_name']);
                                        }
                                        if ($top) {
                                            header('Content-Type: image/jpeg');
                                            @imagejpeg($top, $filePath, $quality);
                                            @imagedestroy($top);
                                        } else {
                                            $fileName = "";
                                        }
                                    }
                                }
                            }
                        }
                    }

                    $attorney_date = (isset($input['attorney_date']) && !empty($input['attorney_date'])) ? (date("Y-m-d", strtotime($input['attorney_date']))) : '0000-00-00';
                    if ($fileName != "") {
                        $array["signpath"] = $fileName;
                    }
                    $array['name'] = $input['name'];
                    $array['mobile_no'] = trim($input['mobile_no']);
                    $array['business_type'] = $input['business_type'];
                    $array['emailid'] = $input['email'];
                    $array['password'] = password_hash($input['password'], PASSWORD_DEFAULT);
                    $array['user_code'] = $input['user_code'];
                    $array['attorney_number'] = $input['attorney_number'];
                    if ($attorney_date != "") {
                        $array['attorney_date'] = $attorney_date;
                    }
                    $array['job_profile'] = $input['job_profile'];
                    $array['updated_at'] = date('Y-m-d H:i:s');
                    $this->common->updatetbledata('tb_user_logins', $array, ['id' => $id]);
                }
            }
        }
        redirect('profile');
    }

    private function countryAdminUpdate($input): void
    {
        $array['name'] = $input['name'];
        $array['mobile_no'] = trim($input['mobile_no']);
        $array['business_type'] = $input['business_type'];
        $array['emailid'] = $input['email'];
        $array['password'] = password_hash($input['password'], PASSWORD_DEFAULT);
        $array['updatedon'] = date('Y-m-d H:i:s');
        $id = $this->session->userdata('user_id');
        $this->common->updatetbledata('tb_admin_users', $array, ['id' => $id]);

        redirect('profile');
    }

    private function subCustomerUpdate($input): void
    {
        $array['name'] = $input['name'];
        $array['code'] = trim($input['mobile_no']);
        $array['email_id'] = $input['email'];
        $array['password'] = password_hash($input['password'], PASSWORD_DEFAULT);
        $array['updatedon'] = date('Y-m-d H:i:s');
        $id = $this->session->userdata('child_id');
        $this->common->updatetbledata('tb_customer_logins', $array, ['id' => $id]);

        redirect('profile');
    }


    public function vehicles()
    {
        $data['page_title'] = "Vehicles";
        $whr = "gpsstatus=1 and user_id=" . $this->session->userdata('user_id');
        $this->load->library('pagination');
        $config["base_url"] = base_url() . "profile/vehicles";
        $sql = "select count(id) as countrows from tb_trucks_data where $whr";
        $query_count = $this->db->query($sql);
        // echo $query_count->row()->countrows;
        // exit;
        $config["total_rows"] = $query_count->row()->countrows;
        $config["per_page"] = 15;
        $config["uri_segment"] = 3;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $query = $this->mainqueryveh($whr, $config["per_page"], $page);
        $data['query'] = $query;
        $data["links"] = $this->pagination->create_links();
        $this->settemplate->dashboardtemp('uservehicles', $data);
    }

    public function mainqueryveh($whr, $perpage, $currentpage)
    {
        $sql = "select *,id as rowid from tb_trucks_data where $whr limit $currentpage, $perpage";
        $sql_download = "select *,id as rowid from tb_trucks_data where $whr ";
        $this->session->set_userdata('vehdownload', $sql_download);
        return $query = $this->db->query($sql);
    }

    public function changepassword()
    {
        $data['page_title'] = "Change Password";
        $sql = "select * from tb_users where id=" . $this->session->userdata('user_id');
        $data['query'] = $this->db->query($sql);
        $this->settemplate->dashboardtemp("changepassword", $data);
    }

    public function updatepassword()
    {
        $password = $this->input->get_post('password');
        $cnf_password = $this->input->get_post('confirm_password');
        if ($password != $cnf_password) {
            $this->session->set_flashdata('error_msg', "Password and confirm password does not match");
            redirect("profile");
        } else {
            $password = password_hash($password,PASSWORD_DEFAULT);
            $sql = "update tb_users set password='" . $password . "' where id=" . $id;
            $this->db->query($sql);
            $this->session->set_flashdata('success_msg', "Password Changed Successfully");
            redirect('profile');
        }
    }

    public function editvehicles($id = '')
    {
        $data['page_title'] = "Edit Vehicles";
        if ($id > 0) {
            $sql = "select register_number,phone,id from tb_trucks_data where id=" . $id;
            $query_data = $this->db->query($sql);
            $data['register_number'] = $query_data->row()->register_number;
            $data['phone'] = $query_data->row()->phone;
            $data['id'] = $query_data->row()->id;
            $this->settemplate->dashboardtemp("editvehicle", $data);
        } else {
            redirect('profile/vehicles');
        }
    }

    public function updatevehicle()
    {
        $register_number = $this->input->get_post('register_number');
        $mobil_no = $this->input->get_post('mobileno');
        $id = $this->input->post('rowid');
        $sql = "update tb_trucks_data set register_number='" . $register_number . "',phone=" . $mobil_no . " where id=" . $id;
        $this->db->query($sql);
        $this->session->set_flashdata('success_msg', "Vehicle Updated Successfully");
        redirect('profile/vehicles');
    }

}
