<?php if (!defined('BASEPATH')) {

	exit('No direct script access allowed');

}

class Quote extends CI_Controller {

	public function __Construct() {

		parent::__Construct();

		if ($this->session->userdata('user_id') == '') {
			redirect('login');
		}
        $this->load->model("common");
       /* $this->load->helper("cabs_helper");*/
	}

	public function index()

	{

		$data["page_title"]="Quote";

		$this->settemplate->dashboard("quote/index",$data);

	}

    public function review()
    {
        $responsedata = array();
        $post = $this->input->post();
        /* insert into orders table */
        if($this->session->userdata("business_type") == "Customer"){
            $lcustomerid = $this->session->userdata('cust_id');
        }else{
            $lcustomerid = 0;
        }
        $uid = $this->session->userdata('user_id');
        $curdt = date("Y-m-d H:i:s");
        $company_code = $branch_code = "";
        $chkusr = $this->db->select("company_code,branch_code")->get_where("tb_users",array("id"=>$uid),1,0);
        if($chkusr->num_rows()>0){
            $company_code = $chkusr->row()->company_code;
            $branch_code = $chkusr->row()->branch_code;
        }
        $ord = $company_code.time();
        $pdate = trim($post['pickup_date']);
        $pdate = str_replace(" ", "", $pdate);
        $pdate = strtr($pdate, '/', '-');
        if($pdate == ""){ $pdate = date('Y-m-d'); }
        $ptime = trim($post['pickup_start']);
        $pendtime = trim($post['pickup_end']);
        if($ptime != ""){
            $ptime = date("H:i", strtotime($ptime));
            $pdate = date('Y-m-d',strtotime($pdate));
            $pickup_time = $pdate." ".$ptime;
        }else{
            $pickup_time = date('Y-m-d H:i:s',strtotime($pdate));
        }
        $ddate = trim($post['drop_date']);
        $ddate = str_replace(" ", "", $ddate);
        $ddate = strtr($ddate, '/', '-');
        $dtime = trim($post['drop_start']);
        $dendtime = trim($post['drop_end']);
        if($ddate == ""){ $ddate = date('Y-m-d'); }
        if($dtime != ""){
            $dtime = date("H:i", strtotime($dtime));
            $ddate = date('Y-m-d',strtotime($ddate));
            $drop_time = $ddate." ".$dtime;
        }else{
            $drop_time = date('Y-m-d H:i:s',strtotime($ddate));
        }
        if($post['value_of_goods'] == ""){ $post['value_of_goods'] = 0; }
        if(!isset($post['vehicle_type'])){ $post['vehicle_type'] = ""; }
        if(!isset($post['dedicated_vehicle'])){ $post['dedicated_vehicle'] = 0; }
        /* check consignee */
        $cust = array('name'=>$post['consignee_full_name'],'phone'=>$post['consignee_phone']);
        $chkcust = $this->db->select('id')->get_where("tb_customers",$cust,1,0);
        if($chkcust->num_rows()>0){
            $customerid = $chkcust->row()->id;
        }else{
            $custarr = array('name'=>$post['consignee_full_name'],'phone'=>$post['consignee_phone'], 'location'=>$post['consignee_area'], 'address'=>$post['consignee_area'], 'code'=>$post['consignee_code'], 'email_id'=>$post['consignee_email'], 'password'=>'TVRJek5EVTI=', 'user_id'=>$uid, 'status'=>1,'createdon'=>$curdt);
            $customerid = $this->common->insertTableData("tb_customers",$custarr);
        }
        /* check consignor */
        $vend = array('name'=>$post['consignor_full_name'],'mobile'=>$post['consignor_phone']);
        $chkvend = $this->db->select('id')->get_where("tb_vendors",$vend,1,0);
        if($chkvend->num_rows()>0){
            $vendorid = $chkvend->row()->id;
        }else{
            $vendarr = array('name'=>$post['consignor_full_name'],'mobile'=>$post['consignor_phone'], 'location'=>$post['consignor_area'], 'address'=>$post['consignor_area'], 'code'=>$post['consignor_code'], 'email'=>$post['consignor_email'], 'password'=>'TVRJek5EVTI=', 'user_id'=>$uid, 'status'=>1,'created_on'=>$curdt);
            $vendorid = $this->common->insertTableData("tb_vendors",$vendarr);
        }
        $plat = $plng = $dlat = $dlng = "";
        $from = array("country"=>$post['pickup_country'],"city"=>$post['pickup_city'],'postalcode'=>$post['pickup_postal'],'address'=>$post['pickup_address_line1']);
        //$platlngs = getlatlngsbylocation($from);
        //if(count($platlngs)>0){
            $plat = isset($post["pickup_lat"]) ? $post["pickup_lat"] : '';
            $plng = isset($post["pickup_lng"]) ? $post["pickup_lng"] : '';
        //}
        $to = array("country"=>$post['drop_country'],"city"=>$post['drop_city'],'postalcode'=>$post['drop_postal'],'address'=>$post['drop_address_line1']);
        //$dlatlngs = getlatlngsbylocation($to);
        //if(count($dlatlngs)>0){
            $dlat = isset($post["drop_lat"]) ? $post["drop_lat"] : '';
            $dlng = isset($post["drop_lng"]) ? $post["drop_lng"] : '';
        //}
        if(strlen($plat)==0 || strlen($plng)==0){
            $platlngs = getlatlngsbylocation($from);
            if(count($platlngs)>0){
                $plat = isset($platlngs[0]) ? $platlngs[0] : '';
                $plng = isset($platlngs[1]) ? $platlngs[1] : '';
            }
        }
        if(strlen($dlat)==0 || strlen($dlng)==0){
            $dlatlngs = getlatlngsbylocation($to);
            if(count($dlatlngs)>0){
                $dlat = isset($dlatlngs[0]) ? $dlatlngs[0] : '';
                $dlng = isset($dlatlngs[1]) ? $dlatlngs[1] : '';
            }
        }
        if($lcustomerid > 0){
            $customerid = $lcustomerid;
        }
        $orddata = array('order_id'=>$ord, 'pickup_datetime'=>$pickup_time, 'pickup_endtime'=>$pendtime, 'delivery_datetime'=>$drop_time, 'drop_endtime'=>$dendtime, 'pickup_company'=>$post['pickup_company'], 'delivery_company'=>$post['drop_company'], 'pickup_country'=>$post['pickup_country'], 'delivery_country'=>$post['drop_country'], 'pickup_city'=>$post['pickup_city'], 'delivery_city'=>$post['drop_city'], 'pickup_pincode'=>$post['pickup_postal'], 'delivery_pincode'=>$post['drop_postal'], 'pickup_address1'=>$post['pickup_address_line1'], 'delivery_address1'=>$post['drop_address_line1'], 'pickup_address2'=>$post['pickup_address_line2'], 'delivery_address2'=>$post['drop_address_line2'], 'quantity'=>$post['cargo_total_qty'], 'weight'=>$post['cargo_total_weight'], 'volume'=>$post['cargo_total_vol'], 'goods_value'=>$post['value_of_goods'], 'transport_mode'=>$post['transportmode'], 'dedicated_vehicle'=>$post['dedicated_vehicle'], 'vehicle_type'=>$post['vehicle_type'], 'user_id'=>$uid, 'customer_id'=>$customerid, 'vendor_id'=>$vendorid, 'customer_name'=>$post['consignee_full_name'], 'customer_code'=>$post['consignee_code'], 'customer_area'=>$post['consignee_area'], 'customer_phone'=>$post['consignee_phone'], 'customer_email'=>$post['consignee_email'], 'customer_comments'=>$post['consignee_comments'], 'vendor_name'=>$post['consignor_full_name'], 'vendor_code'=>$post['consignor_code'], 'vendor_area'=>$post['consignor_area'], 'vendor_phone'=>$post['consignor_phone'], 'vendor_email'=>$post['consignor_email'], 'vendor_comments'=>$post['consignor_comments'], 'plat'=>$plat, 'plng'=>$plng, 'dlat'=>$dlat, 'dlng'=>$dlng, 'status'=>1, 'createdon'=>$curdt,"created_source"=>4,"company_code"=>$company_code,"branch_code"=>$branch_code,"modeoftransport"=>1);
        $orderid = $this->common->insertTableData("tb_orders",$orddata);
        /* insert into cargo types */
        if(isset($post['cargo_type'])){
            if(count($post['cargo_type'])>0){
                foreach($post['cargo_type'] as $ct){
                    if($ct != ""){
                        $ins = array('cargo_type'=>$ct, 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
                        $cargotype = $this->common->insertTableData("tb_order_cargotypes",$ins);
                    }
                }
            }
        }
        /* insert into cargo details */
        if(isset($post['handling_unit'])){
            if(count($post['handling_unit'])>0){
                for($i=0;$i<count($post['handling_unit']);$i++){
                    if($post['handling_unit'][$i] != "" && $post['unit_length'][$i] != ""){
                        $quantity_type = $cargo_content = "";
                        $unitnam = $post['handling_unit'][$i];
                        $rows = $this->db->query("SELECT unit_name FROM tbl_shipunit_types WHERE id = '$unitnam'");
                        if($rows->num_rows()>0){
                            $quantity_type = $cargo_content = $rows->row()->unit_name;
                        }
                        $cargodetails = array('order_id'=>$orderid, 'handling_unit'=>$post['handling_unit'][$i], 'length'=>$post['unit_length'][$i], 'width'=>$post['unit_width'][$i], 'height'=>$post['unit_height'][$i], 'weight'=>$post['unit_weight'][$i], 'quantity'=>$post['count'][$i], 'quantity_type'=>$quantity_type, 'cargo_content'=>$cargo_content, 'status'=>1, 'createdon'=>$curdt);
                        $cargo_details = $this->common->insertTableData("tb_order_cargodetails",$cargodetails);
                    }
                }
            }
        }
        /* insert into add ons */
        if(isset($post['detail_cargo'])){
            if(count($post['detail_cargo'])>0){
                foreach($post['detail_cargo'] as $dc){
                    if($dc != ""){
                        $ins = array('service_type'=>'original document return', 'addon_name'=>$dc, 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
                        $cargotype = $this->common->insertTableData("tb_order_addons",$ins);
                    }
                }
            }
        }
        if (isset($post['pickup_country']) && $post['drop_country'] != "") {
            /*start check and store locations data*/
            $rows = $this->db->query("SELECT id FROM tbl_country_master WHERE (country_name = '".$post['pickup_country']."' OR country_code = '".$post['pickup_country']."') AND status=1");
            $country_id = 0;
            if($rows->num_rows()>0){
                $country_id = $rows->row()->id;
            }else{
                $ins = $this->db->insert("tbl_country_master",array("country_name"=>$post['pickup_country'],"country_code"=>$post['pickup_country'],"user_id"=>$uid));
                $country_id = $this->db->insert_id();
            }
            $row["country_id"] = $country_id;
            if(strlen($post['pickup_company'])>0 && strlen($post['pickup_city'])>0){
                $rows = $this->db->query("SELECT id FROM tbl_location_master WHERE name = '".$post['pickup_city']."' AND pincode = '".$post['pickup_postal']."' AND country_id=$country_id  AND status=1 ");
                if($rows->num_rows() == 0){
                    $row["company"] = $post['pickup_company'];
                    $row["name"] = $post['pickup_city'];
                    $row["city_name"] = $post['pickup_city'];
                    $row["pincode"] = $post['pickup_postal'];
                    $row["latitude"] = $post['pickup_lat'];
                    $row["longitude"] = $post['pickup_lng'];
                    $row["address_line_number"] = $post['pickup_address_line1'];
                    $row["address_lines"] = $post['pickup_address_line2'];
                    $row["user_id"] = $uid;
                    $ins = $this->db->insert("tbl_location_master",$row);
                }
            }
            $row = array();
            $rows = $this->db->query("SELECT id FROM tbl_country_master WHERE (country_name = '".$post['drop_country']."' OR country_code = '".$post['drop_country']."') AND status=1");
            $country_id = 0;
            if($rows->num_rows()>0){
                $country_id = $rows->row()->id;
            }else{
                $ins = $this->db->insert("tbl_country_master",array("country_name"=>$post['drop_country'],"country_code"=>$post['drop_country'],"user_id"=>$uid));
                $country_id = $this->db->insert_id();
            }
            $row["country_id"] = $country_id;
            if(strlen($post['drop_country'])>0 && strlen($post['drop_city'])>0){
                $rows = $this->db->query("SELECT id FROM tbl_location_master WHERE name = '".$post['drop_city']."' AND pincode = '".$post['drop_postal']."' AND country_id=$country_id  AND status=1 ");
                if($rows->num_rows() == 0){
                    $row["company"] = $post['drop_company'];
                    $row["name"] = $post['drop_city'];
                    $row["city_name"] = $post['drop_city'];
                    $row["pincode"] = $post['drop_postal'];
                    $row["latitude"] = $post['drop_lat'];
                    $row["longitude"] = $post['drop_lng'];
                    $row["address_line_number"] = $post['drop_address_line1'];
                    $row["address_lines"] = $post['drop_address_line2'];
                    $row["user_id"] = $uid;
                    $ins = $this->db->insert("tbl_location_master",$row);
                }
            }
            /*end check and store locations data*/

            $post['createdon'] = date('Y-m-d H:i:s');
            $request = '';
            /*$request .= '<?xml version="1.0" encoding="UTF-8"?>';*/
            $request .= '<Transmission>';
            $request .= '<TransmissionHeader>';
            $request .= '<UserName>SGFD/SCAHY.BSCYADAV</UserName>';
            $request .= '<Password>4CHANGEME</Password>';
            $request .= '<TransmissionType>QUERY</TransmissionType>';
            $request .= '<AckSpec>';
            $request .= '<ComMethodGid>';
            $request .= '<Gid>';
            $request .= '<Xid>EMAIL</Xid>';
            $request .= '</Gid>';
            $request .= '</ComMethodGid>';
            $request .= '<AckOption>YES</AckOption>';
            $request .= '<ContactGid>';
            $request .= '<Gid>';
            $request .= '<Xid>SGFD/SCAHY.BSCYADAV</Xid>';
            $request .= '</Gid>';
            $request .= '</ContactGid>';
            $request .= '</AckSpec>';
            $request .= '</TransmissionHeader>';
            $request .= '<TransmissionBody>';
            $request .= '<GLogXMLElement>';
            $request .= '<RemoteQuery>';
            $request .= '<RIQQuery>';
            $request .= '<RIQRequestType>All</RIQRequestType>';
            $request .= '<SourceAddress>';
            $request .= '<MileageAddress>';
            $request .= '<CountryCode3Gid>';
            $request .= '<Gid>';
            $request .= '<DomainName/>';
            $request .= '<Xid>'.$post['pickup_country'].'</Xid>';
            $request .= '</Gid>';
            $request .= '</CountryCode3Gid>';
            $request .= '</MileageAddress>';
            $request .= '</SourceAddress>';
            $request .= '<DestAddress>';
            $request .= '<MileageAddress>';
            $request .= '<CountryCode3Gid>';
            $request .= '<Gid>';
            $request .= '<DomainName/>';
            $request .= '<Xid>'.$post['drop_country'].'</Xid>';
            $request .= '</Gid>';
            $request .= '</CountryCode3Gid>';
            $request .= '</MileageAddress>';
            $request .= '</DestAddress>';
            $request .= '<Perspective>S</Perspective>';
            $request .= '<IsPreferred>N</IsPreferred>';
            $request .= '<TransportModeGid>';
            $request .= '<Gid>';
            $request .= '<DomainName/>';
            $request .= '<Xid>'.$post['transportmode'].'</Xid>';
            $request .= '</Gid>';
            $request .= '</TransportModeGid>';
            if(isset($post['detail_cargo'])){
                for($i=0;$i<count($post['detail_cargo']);$i++){
                    $carg_detail = $post['detail_cargo'][$i];
                    $carg_detail = str_replace(' ', '', $post['detail_cargo'][$i]);
                    $carg_detail = strtoupper($carg_detail);
                    $request .= '<SpecialServiceGid>';
                    $request .= '<Gid>';
                    $request .= '<DomainName>SGFD/SCAHY</DomainName>';
                    $request .= '<Xid>TH_'.$carg_detail.'</Xid>';
                    $request .= '</Gid>';
                    $request .= '</SpecialServiceGid>';
                }
            }
            $request .= '<ShipUnit>';
            for($i=0;$i<count($post['handling_unit']);$i++){
                $vol = ($post['unit_length'][$i] * $post['unit_width'][$i] * $post['unit_height'][$i]);
                if($post['unit_weight'][$i] == ""){ $post['unit_weight'][$i] = 0; }
                $request .= '<ShipUnitCount>' . count($post['handling_unit']) . '</ShipUnitCount>';
                $request .= '<WeightVolume>';
                $request .= '<Weight>';
                $request .= '<WeightValue>' . $post['unit_weight'][$i] . '</WeightValue>';
                $request .= '<WeightUOMGid>';
                $request .= '<Gid>';
                $request .= '<Xid>KG</Xid>';
                $request .= '</Gid>';
                $request .= '</WeightUOMGid>';
                $request .= '</Weight>';
                $request .= '<Volume>';
                $request .= '<VolumeValue>' . $vol . '</VolumeValue>';
                $request .= '<VolumeUOMGid>';
                $request .= '<Gid>';
                $request .= '<Xid>CUCM</Xid>';
                $request .= '</Gid>';
                $request .= '</VolumeUOMGid>';
                $request .= '</Volume>';
                $request .= '</WeightVolume>';
            }
            $request .= '</ShipUnit>';
            $request .= '</RIQQuery>';
            $request .= '</RemoteQuery>';
            $request .= '</GLogXMLElement>';
            $request .= '</TransmissionBody>';
            $request .= '</Transmission>';
            $dom = new DOMDocument;
            $dom->loadXML($request);
            $dom->save('xml/example.xml');

            $serviceurl = OTM_URL;
            $headers = array('Content-Type: application/xml');
            $response = otmbookservicecurl($serviceurl,$headers,$request);
            $responsedata = $this->saveresponsedata($response, $shipid=1);
        }
        $data['response'] = $responsedata;
        $data['post'] = $post;
        $data["page_title"]="Review and book";
        $data['order_id'] = $ord;
        $this->settemplate->dashboard("quote/review",$data);
    }

    public function ebook_quote()
    {
        $responsedata = array();
        $post = $this->input->post();
        /* insert into orders table */
        $uid = $this->session->userdata('user_id');
        $curdt = date("Y-m-d H:i:s");
        $curtz = date_default_timezone_get();
        $getactual = getdatetimebytimezone(DFLT_TZ,$curdt,$curtz);
        $curdt = $getactual['datetime'];
        $ord = "ORDER_".date('his').time();
        $pdate = trim($post['pickup_date']);
        if($pdate == ""){ $pdate = $getactual['date']; }else{
            $getactual = getdatetimebytimezone(DFLT_TZ,$pdate,$curtz);
            $pdate = $getactual['date'];
        }
        $pickup_time = date('Y-m-d H:i:s',strtotime($pdate));
        $ddate = trim($post['drop_date']);
        if($ddate == ""){ $ddate = $getactual['date']; }else{
            $getactual = getdatetimebytimezone(DFLT_TZ,$ddate,$curtz);
            $ddate = $getactual['date'];
        }
        $drop_time = date('Y-m-d H:i:s',strtotime($ddate));
        $post['transportmode'] = isset($post['transportmode']) ? $post['transportmode'] : 'TL';
        $post['value_of_goods'] = isset($post['value_of_goods']) ? $post['value_of_goods'] : 0;
        $post['vehicle_type'] = isset($post['vehicle_type']) ? $post['vehicle_type'] : "";
        $post['dedicated_vehicle'] = isset($post['dedicated_vehicle']) ? $post['dedicated_vehicle'] : 0;
        $post['cargo_total_qty'] = $post['cargo_total_vol'] = 0;
        if(isset($post['quantity'])){
            foreach($post['quantity'] as $q){
                $post['cargo_total_qty'] += $q;
            }
        }
        if(isset($post['item_volume'])){
            foreach($post['item_volume'] as $iv){
                $post['cargo_total_vol'] += $iv;
            }
        }
        /* check parties */
        $customerid = $vendorid = 0;
        $post['consignee_full_name'] = $post['consignor_full_name'] = $post['consignee_phone'] = $post['consignor_phone'] = $post['consignee_email'] = $post['consignor_email'] = "";
        if(isset($post['party_id'])){
            for($i=0;$i<count($post['party_id']);$i++){
                $getparty=$this->db->get_where("tbl_party_master",array("id"=>$post['party_id'][$i],"user_id"=>$uid,"status"=>1),1,0);
                if($getparty->num_rows()>0){
                    $partytype = $getparty->row();
                    $partytypeid = isset($post['party_type_id'][$i]) ? $post['party_type_id'][$i] : "";
                    if($partytypeid == ""){ $partytypeid = 1; }
                    /* update party type */
                    $partyupd = $this->db->where(array("id"=>$partytype->id))->update("tbl_party_master",array("party_type_id"=>$partytypeid));
                    $prtyes = $this->db->select("id")->get_where("tbl_party_types",array("user_id"=>$uid,"name"=>"Shipper"),1,0);
                    $cust_p_type = 1;
                    if($prtyes->num_rows()>0){
                        $cust_p_type = $prtyes->row()->id;
                    }
                    $cprtyes = $this->db->select("id")->get_where("tbl_party_types",array("user_id"=>$uid,"name"=>"Carrier"),1,0);
                    $carr_p_type = 2;
                    if($cprtyes->num_rows()>0){
                        $carr_p_type = $cprtyes->row()->id;
                    }
                    if($cust_p_type == $partytypeid){ /* shipper *//* Consignee */
                        $post['consignee_full_name'] = $partytype->name;
                        $post['consignee_phone'] = $partytype->mobile;
                        $post['consignee_email'] = $partytype->email;
                        $cust = array('phone'=>$partytype->mobile);
                        $chkcust = $this->db->select('id')->get_where("tb_customers",$cust,1,0);
                        if($chkcust->num_rows()>0){
                            $customerid = $chkcust->row()->id;
                        }else{
                            $custarr = array('name'=>$partytype->name,'phone'=>$partytype->mobile, 'location'=>$partytype->location_id, 'address'=>$partytype->address, 'code'=>"", 'email_id'=>$partytype->email, 'password'=>'TVRJek5EVTI=', 'user_id'=>$uid, 'status'=>1,'createdon'=>$curdt);
                            $customerid = $this->common->insertTableData("tb_customers",$custarr);
                        }
                        $party = array('order_number'=>$ord,'party_id'=>$partytype->id);
                        $chkparty = $this->db->select('id')->get_where("tb_order_parties",$party,1,0);
                        if($chkparty->num_rows() == 0){
                            $partyarr = array('order_id'=>0,'order_number'=>$ord,'party_id'=>$partytype->id, 'status'=>1,'createdon'=>$curdt);
                            $parties = $this->common->insertTableData("tb_order_parties",$partyarr);
                        }
                    }else if($carr_p_type == $partytypeid){ /* carrier */
                        $post['consignor_full_name'] = $partytype->name;
                        $post['consignor_phone'] = $partytype->mobile;
                        $post['consignor_email'] = $partytype->email;
                        $vend = array('mobile'=>$partytype->mobile);
                        $chkvend = $this->db->select('id')->get_where("tb_vendors",$vend,1,0);
                        if($chkvend->num_rows()>0){
                            $vendorid = $chkvend->row()->id;
                        }else{
                            $vendarr = array('name'=>$partytype->name,'mobile'=>$partytype->mobile, 'location'=>$partytype->location_id, 'address'=>$partytype->address, 'code'=>"", 'email'=>$partytype->email, 'password'=>'TVRJek5EVTI=', 'user_id'=>$uid, 'status'=>1,'created_on'=>$curdt);
                            $vendorid = $this->common->insertTableData("tb_vendors",$vendarr);
                        }
                        $party = array('order_number'=>$ord,'party_id'=>$partytype->id);
                        $chkparty = $this->db->select('id')->get_where("tb_order_parties",$party,1,0);
                        if($chkparty->num_rows() == 0){
                            $partyarr = array('order_id'=>0,'order_number'=>$ord,'party_id'=>$partytype->id, 'status'=>1,'createdon'=>$curdt);
                            $parties = $this->common->insertTableData("tb_order_parties",$partyarr);
                        }
                    }else{ /* other parties */
                        $party = array('order_number'=>$ord,'party_id'=>$partytype->id);
                        $chkparty = $this->db->select('id')->get_where("tb_order_parties",$party,1,0);
                        if($chkparty->num_rows() == 0){
                            $partyarr = array('order_id'=>0,'order_number'=>$ord,'party_id'=>$partytype->id, 'status'=>1,'createdon'=>$curdt);
                            $parties = $this->common->insertTableData("tb_order_parties",$partyarr);
                        }
                    }
                }
            }
        }
        $plat = $plng = $dlat = $dlng = "";
        $from = array("country"=>$post['pickup_country'],"city"=>$post['pickup_city'],'postalcode'=>$post['pickup_postal_code'],'address'=>$post['pickup_location']);
        //$platlngs = getlatlngsbylocation($from);
        //if(count($platlngs)>0){
            $plat = isset($post["pickup_lat"]) ? $post["pickup_lat"] : '';
            $plng = isset($post["pickup_lng"]) ? $post["pickup_lng"] : '';
        //}
        $to = array("country"=>$post['drop_country'],"city"=>$post['drop_city'],'postalcode'=>$post['drop_postal_code'],'address'=>$post['drop_location']);
        //$dlatlngs = getlatlngsbylocation($to);
        //if(count($dlatlngs)>0){
            $dlat = isset($post["drop_lat"]) ? $post["drop_lat"] : '';
            $dlng = isset($post["drop_lng"]) ? $post["drop_lng"] : '';
        //}
        if(strlen($plat)==0 || strlen($plng)==0){
            $platlngs = getlatlngsbylocation($from);
            if(count($platlngs)>0){
                $plat = isset($platlngs[0]) ? $platlngs[0] : '';
                $plng = isset($platlngs[1]) ? $platlngs[1] : '';
            }
        }
        if(strlen($dlat)==0 || strlen($dlng)==0){
            $dlatlngs = getlatlngsbylocation($to);
            if(count($dlatlngs)>0){
                $dlat = isset($dlatlngs[0]) ? $dlatlngs[0] : '';
                $dlng = isset($dlatlngs[1]) ? $dlatlngs[1] : '';
            }
        }
        $orddata = array('order_id'=>$ord, 'pickup_datetime'=>$pickup_time, 'delivery_datetime'=>$drop_time, 'pickup_company'=>$post['pickup_company'], 'delivery_company'=>$post['drop_company'], 'pickup_country'=>$post['pickup_country'], 'delivery_country'=>$post['drop_country'], 'pickup_city'=>$post['pickup_city'], 'delivery_city'=>$post['drop_city'], 'pickup_pincode'=>$post['pickup_postal_code'], 'delivery_pincode'=>$post['drop_postal_code'], 'pickup_address1'=>$post['pickup_location'], 'delivery_address1'=>$post['drop_location'], 'quantity'=>$post['cargo_total_qty'], 'weight'=>$post['cargo_total_qty'], 'volume'=>$post['cargo_total_vol'], 'goods_value'=>$post['value_of_goods'], 'transport_mode'=>$post['transportmode'], 'dedicated_vehicle'=>$post['dedicated_vehicle'], 'vehicle_type'=>$post['vehicle_type'], 'user_id'=>$uid, 'customer_id'=>$customerid, 'vendor_id'=>$vendorid, 'customer_name'=>$post['consignee_full_name'], 'customer_phone'=>$post['consignee_phone'], 'customer_email'=>$post['consignee_email'], 'vendor_name'=>$post['consignor_full_name'], 'vendor_phone'=>$post['consignor_phone'], 'vendor_email'=>$post['consignor_email'], 'plat'=>$plat, 'plng'=>$plng, 'dlat'=>$dlat, 'dlng'=>$dlng, 'status'=>1, 'createdon'=>$curdt,"created_source"=>'4');
        $orderid = $this->common->insertTableData("tb_orders",$orddata);
        /* update order id in parties table */
        $updord = $this->db->where(array('order_number'=>$ord))->update("tb_order_parties",array("order_id"=>$orderid));
        /* insert into cargo types */
            $ins = array('cargo_type'=>"General Cargo", 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
            $cargotype = $this->common->insertTableData("tb_order_cargotypes",$ins);
        /* insert into cargo details */
        $post['handling_unit'] = $post['unit_length'] = $post['unit_width'] = $post['unit_height'] = $post['unit_weight'] = array();
        if(isset($post['item_id'])){
            for($i=0;$i<count($post['item_id']);$i++){
                $getunits = $this->db->get_where("tbl_item_master",array("id"=>$post['item_id'][$i],"user_id"=>$uid,"status"=>1),1,0);
                if($getunits->num_rows()>0){
                    $udata = $getunits->row();
                    $post['handling_unit'][] = $udata->unit_id;
                    $quantity_type = $cargo_content = "";
                    $rows = $this->db->query("SELECT unit_name FROM tbl_shipunit_types WHERE id = '$udata->unit_id'");
                    if($rows->num_rows()>0){
                        $quantity_type = $cargo_content = $rows->row()->unit_name;
                    }
                    $post['unit_length'][] = $udata->length;
                    $post['unit_width'][] = $udata->width;
                    $post['unit_height'][] = $udata->height;
                    $post['unit_weight'][] = $udata->weight;
                    $uweight = isset($post['quantity'][$i]) ? $post['quantity'][$i] : 0;
                    $cargodetails = array('order_id'=>$orderid, 'handling_unit'=>$udata->unit_id, 'length'=>$udata->length, 'width'=>$udata->width, 'height'=>$udata->height, 'weight'=>$udata->weight, 'quantity'=>$uweight, 'quantity_type'=>$quantity_type, 'cargo_content'=>$cargo_content, 'status'=>1, 'createdon'=>$curdt);
                    $cargo_details = $this->common->insertTableData("tb_order_cargodetails",$cargodetails);
                }
            }
        }
        /* insert into add ons */
        $post['detail_cargo'] = array();
        if(isset($post['service_id'])){
            for($i=0;$i<count($post['service_id']);$i++){
                if($post['service_id'][$i] != ""){
                    $chkserv = $this->db->get_where("tbl_addon_types",array("id"=>$post['service_id'][$i]),1,0);
                    if($chkserv->num_rows()>0){
                        $post['detail_cargo'][] = $chkserv->row()->addon_name;
                        $ins = array('service_type'=>'original document return', 'addon_name'=>$chkserv->row()->addon_name, 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
                        $cargotype = $this->common->insertTableData("tb_order_addons",$ins);
                    }
                }
            }
        }
        if(isset($post['remarks_id'])){
            for($i=0;$i<count($post['remarks_id']);$i++){
                if($post['remarks_id'][$i] != ""){
                    $chkserv = $this->db->get_where("tbl_remark_types",array("id"=>$post['remarks_id'][$i]),1,0);
                    if($chkserv->num_rows()>0){
                        $remarks = isset($post['remarks'][$i]) ? $post['remarks'][$i] : '';
                        $ins = array('order_id'=>$orderid, 'remark_id'=>$post['remarks_id'][$i], 'description'=>$remarks, 'status'=>1, 'createdon'=>$curdt);
                        $ordremark = $this->common->insertTableData("tb_order_remarks",$ins);
                    }
                }
            }
        }
        if (isset($post['pickup_country']) && $post['drop_country'] != "") {
            $post['createdon'] = date('Y-m-d H:i:s');
            $request = '';
            /*$request .= '<?xml version="1.0" encoding="UTF-8"?>';*/
            $request .= '<Transmission>';
            $request .= '<TransmissionHeader>';
            $request .= '<UserName>SGFD/SCAHY.BSCYADAV</UserName>';
            $request .= '<Password>4CHANGEME</Password>';
            $request .= '<TransmissionType>QUERY</TransmissionType>';
            $request .= '<AckSpec>';
            $request .= '<ComMethodGid>';
            $request .= '<Gid>';
            $request .= '<Xid>EMAIL</Xid>';
            $request .= '</Gid>';
            $request .= '</ComMethodGid>';
            $request .= '<AckOption>YES</AckOption>';
            $request .= '<ContactGid>';
            $request .= '<Gid>';
            $request .= '<Xid>SGFD/SCAHY.BSCYADAV</Xid>';
            $request .= '</Gid>';
            $request .= '</ContactGid>';
            $request .= '</AckSpec>';
            $request .= '</TransmissionHeader>';
            $request .= '<TransmissionBody>';
            $request .= '<GLogXMLElement>';
            $request .= '<RemoteQuery>';
            $request .= '<RIQQuery>';
            $request .= '<RIQRequestType>All</RIQRequestType>';
            $request .= '<SourceAddress>';
            $request .= '<MileageAddress>';
            $request .= '<CountryCode3Gid>';
            $request .= '<Gid>';
            $request .= '<DomainName/>';
            $request .= '<Xid>'.$post['pickup_country'].'</Xid>';
            $request .= '</Gid>';
            $request .= '</CountryCode3Gid>';
            $request .= '</MileageAddress>';
            $request .= '</SourceAddress>';
            $request .= '<DestAddress>';
            $request .= '<MileageAddress>';
            $request .= '<CountryCode3Gid>';
            $request .= '<Gid>';
            $request .= '<DomainName/>';
            $request .= '<Xid>'.$post['drop_country'].'</Xid>';
            $request .= '</Gid>';
            $request .= '</CountryCode3Gid>';
            $request .= '</MileageAddress>';
            $request .= '</DestAddress>';
            $request .= '<Perspective>S</Perspective>';
            $request .= '<IsPreferred>N</IsPreferred>';
            $request .= '<TransportModeGid>';
            $request .= '<Gid>';
            $request .= '<DomainName/>';
            $request .= '<Xid>'.$post['transportmode'].'</Xid>';
            $request .= '</Gid>';
            $request .= '</TransportModeGid>';
            if(isset($post['detail_cargo'])){
                for($i=0;$i<count($post['detail_cargo']);$i++){
                    $carg_detail = $post['detail_cargo'][$i];
                    $carg_detail = str_replace(' ', '', $post['detail_cargo'][$i]);
                    $carg_detail = strtoupper($carg_detail);
                    $request .= '<SpecialServiceGid>';
                    $request .= '<Gid>';
                    $request .= '<DomainName>SGFD/SCAHY</DomainName>';
                    $request .= '<Xid>TH_'.$carg_detail.'</Xid>';
                    $request .= '</Gid>';
                    $request .= '</SpecialServiceGid>';
                }
            }
            $request .= '<ShipUnit>';
            for($i=0;$i<count($post['handling_unit']);$i++){
                $vol = ($post['unit_length'][$i] * $post['unit_width'][$i] * $post['unit_height'][$i]);
                if($post['unit_weight'][$i] == ""){ $post['unit_weight'][$i] = 0; }
                $request .= '<ShipUnitCount>' . count($post['handling_unit']) . '</ShipUnitCount>';
                $request .= '<WeightVolume>';
                $request .= '<Weight>';
                $request .= '<WeightValue>' . $post['unit_weight'][$i] . '</WeightValue>';
                $request .= '<WeightUOMGid>';
                $request .= '<Gid>';
                $request .= '<Xid>KG</Xid>';
                $request .= '</Gid>';
                $request .= '</WeightUOMGid>';
                $request .= '</Weight>';
                $request .= '<Volume>';
                $request .= '<VolumeValue>' . $vol . '</VolumeValue>';
                $request .= '<VolumeUOMGid>';
                $request .= '<Gid>';
                $request .= '<Xid>CUCM</Xid>';
                $request .= '</Gid>';
                $request .= '</VolumeUOMGid>';
                $request .= '</Volume>';
                $request .= '</WeightVolume>';
            }
            $request .= '</ShipUnit>';
            $request .= '</RIQQuery>';
            $request .= '</RemoteQuery>';
            $request .= '</GLogXMLElement>';
            $request .= '</TransmissionBody>';
            $request .= '</Transmission>';
            $dom = new DOMDocument;
            //$dom->preserveWhiteSpace = FALSE;
            //log_message("error","request xml ".$request);
            $dom->loadXML($request);
            $dom->save('xml/example.xml');
            $serviceurl = OTM_URL;
            $headers = array('Content-Type: application/xml');
            $response = otmbookservicecurl($serviceurl,$headers,$request);
            $responsedata = $this->saveresponsedata($response, $shipid=1);
        }
        $data['response'] = $responsedata;
        $data['post'] = $post;
        $data["page_title"]="E - Booking";
        $data["sub_title"]="Quotes";
        $data['order_id'] = $ord;
        $this->settemplate->dashboard("ebook/ebook_quote",$data);
    }

    public function quickbook_quote()
    {
        $responsedata = array();
        $post = $this->input->post();
        /* insert into orders table */
        $uid = $this->session->userdata('user_id');
        $curdt = date("Y-m-d H:i:s");
        $ord = "ORDER_".time();
        $pdate = trim($post['pickup_date']);
        if($pdate == ""){ $pdate = date('Y-m-d'); }
        $pdate = strtr($pdate, '/', '-');
        $pickup_time = date('Y-m-d H:i:s',strtotime($pdate));
        $ddate = trim($post['drop_date']);
        if($ddate == ""){ $ddate = date('Y-m-d'); }
        $ddate = strtr($ddate, '/', '-');
        $drop_time = date('Y-m-d H:i:s',strtotime($ddate));
        $post['transportmode'] = isset($post['transportmode']) ? $post['transportmode'] : 'TL';
        $post['vehicle_type'] = isset($post['vehicle_type']) ? $post['vehicle_type'] : "";
        $post['dedicated_vehicle'] = isset($post['dedicated_vehicle']) ? $post['dedicated_vehicle'] : 0;
        /* check parties */
        $customerid = $vendorid = 0;
        $getcustomer = $this->db->query("select id from tb_customers where status='1' order by id");
        if($getcustomer->num_rows() >0){
            $customerid = $getcustomer->row()->id;
        }
        $getvendor = $this->db->query("select id from tb_vendors where status ='1' order by id");
        if($getvendor->num_rows() >0){
            $vendorid = $getvendor->row()->id;
        }
        $plat = $plng = $dlat = $dlng = "";
        $orddata = array('order_id'=>$ord, 'pickup_datetime'=>$pickup_time, 'delivery_datetime'=>$drop_time, 'pickup_company'=>"", 'delivery_company'=>"", 'pickup_country'=>$post['pickup_country'], 'delivery_country'=>$post['drop_country'], 'pickup_city'=>"", 'delivery_city'=>"", 'pickup_pincode'=>$post['pickup_postal_code'], 'delivery_pincode'=>$post['drop_postal_code'], 'pickup_address1'=>"", 'delivery_address1'=>"", 'quantity'=>"", 'weight'=>"", 'volume'=>"", 'goods_value'=>"", 'transport_mode'=>$post['transportmode'], 'dedicated_vehicle'=>$post['dedicated_vehicle'], 'vehicle_type'=>$post['vehicle_type'], 'user_id'=>$uid, 'customer_id'=>$customerid, 'vendor_id'=>$vendorid, 'customer_name'=>"", 'customer_phone'=>"", 'customer_email'=>"", 'vendor_name'=>"", 'vendor_phone'=>"", 'vendor_email'=>"", 'plat'=>"", 'plng'=>"", 'dlat'=>"", 'dlng'=>"", 'status'=>1, 'createdon'=>$curdt,"created_source"=>'4');
        $orderid = $this->common->insertTableData("tb_orders",$orddata);
        /* insert into cargo types */
            $ins = array('cargo_type'=>"General Cargo", 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
            $cargotype = $this->common->insertTableData("tb_order_cargotypes",$ins);

        if (isset($post['pickup_country']) && $post['drop_country'] != "") {
            /*start check and store locations data*/
            $rows = $this->db->query("SELECT id FROM tbl_country_master WHERE (country_name = '".$post['pickup_country']."' OR country_code = '".$post['pickup_country']."') AND status=1");
            if($rows->num_rows() == 0){
                $ins = $this->db->insert("tbl_country_master",array("country_name"=>$post['pickup_country'],"country_code"=>$post['pickup_country'],"user_id"=>$uid));
            }
            $rows = $this->db->query("SELECT id FROM tbl_country_master WHERE (country_name = '".$post['drop_country']."' OR country_code = '".$post['drop_country']."') AND status=1");
            if($rows->num_rows() == 0){
                $ins = $this->db->insert("tbl_country_master",array("country_name"=>$post['drop_country'],"country_code"=>$post['drop_country'],"user_id"=>$uid));
            }
            /*end check and store locations data*/
            $post['createdon'] = date('Y-m-d H:i:s');
            $request = '';
            /*$request .= '<?xml version="1.0" encoding="UTF-8"?>';*/
            $request .= '<Transmission>';
            $request .= '<TransmissionHeader>';
            $request .= '<UserName>SGFD/SCAHY.BSCYADAV</UserName>';
            $request .= '<Password>4CHANGEME</Password>';
            $request .= '<TransmissionType>QUERY</TransmissionType>';
            $request .= '<AckSpec>';
            $request .= '<ComMethodGid>';
            $request .= '<Gid>';
            $request .= '<Xid>EMAIL</Xid>';
            $request .= '</Gid>';
            $request .= '</ComMethodGid>';
            $request .= '<AckOption>YES</AckOption>';
            $request .= '<ContactGid>';
            $request .= '<Gid>';
            $request .= '<Xid>SGFD/SCAHY.BSCYADAV</Xid>';
            $request .= '</Gid>';
            $request .= '</ContactGid>';
            $request .= '</AckSpec>';
            $request .= '</TransmissionHeader>';
            $request .= '<TransmissionBody>';
            $request .= '<GLogXMLElement>';
            $request .= '<RemoteQuery>';
            $request .= '<RIQQuery>';
            $request .= '<RIQRequestType>All</RIQRequestType>';
            $request .= '<SourceAddress>';
            $request .= '<MileageAddress>';
            $request .= '<CountryCode3Gid>';
            $request .= '<Gid>';
            $request .= '<DomainName/>';
            $request .= '<Xid>'.$post['pickup_country'].'</Xid>';
            $request .= '</Gid>';
            $request .= '</CountryCode3Gid>';
            $request .= '</MileageAddress>';
            $request .= '</SourceAddress>';
            $request .= '<DestAddress>';
            $request .= '<MileageAddress>';
            $request .= '<CountryCode3Gid>';
            $request .= '<Gid>';
            $request .= '<DomainName/>';
            $request .= '<Xid>'.$post['drop_country'].'</Xid>';
            $request .= '</Gid>';
            $request .= '</CountryCode3Gid>';
            $request .= '</MileageAddress>';
            $request .= '</DestAddress>';
            $request .= '<Perspective>S</Perspective>';
            $request .= '<IsPreferred>N</IsPreferred>';
            $request .= '<TransportModeGid>';
            $request .= '<Gid>';
            $request .= '<DomainName/>';
            $request .= '<Xid>'.$post['transportmode'].'</Xid>';
            $request .= '</Gid>';
            $request .= '</TransportModeGid>';
            // $request .= '<SpecialServiceGid>';
            //     $request .= '<Gid>';
            //     $request .= '<DomainName>SGFD/SCAHY</DomainName>';
            //     $request .= '<Xid>TH_HANDLING</Xid>';
            //     $request .= '</Gid>';
            //     $request .= '</SpecialServiceGid>';
            $request .= '<ShipUnit>';
            $request .= '<ShipUnitCount>1</ShipUnitCount>';
            $request .= '<WeightVolume>';
            $request .= '<Weight>';
            $request .= '<WeightValue>1</WeightValue>';
            $request .= '<WeightUOMGid>';
            $request .= '<Gid>';
            $request .= '<Xid>KG</Xid>';
            $request .= '</Gid>';
            $request .= '</WeightUOMGid>';
            $request .= '</Weight>';
            $request .= '<Volume>';
            $request .= '<VolumeValue>1</VolumeValue>';
            $request .= '<VolumeUOMGid>';
            $request .= '<Gid>';
            $request .= '<Xid>CUCM</Xid>';
            $request .= '</Gid>';
            $request .= '</VolumeUOMGid>';
            $request .= '</Volume>';
            $request .= '</WeightVolume>';
            $request .= '</ShipUnit>';
            $request .= '</RIQQuery>';
            $request .= '</RemoteQuery>';
            $request .= '</GLogXMLElement>';
            $request .= '</TransmissionBody>';
            $request .= '</Transmission>';
            $dom = new DOMDocument;
            //$dom->preserveWhiteSpace = FALSE;
            $dom->loadXML($request);
            $dom->save('xml/example.xml');
            $serviceurl = OTM_URL;
            $headers = array('Content-Type: application/xml');
            $response = otmbookservicecurl($serviceurl,$headers,$request);
            $responsedata = $this->saveresponsedata($response, $shipid=1);
        }
        $data['response'] = $responsedata;
        $data['post'] = $post;
        $data["page_title"]="E - Booking";
        $data["sub_title"]="Quotes";
        $data['order_id'] = $ord;
        $this->load->view("ebook/quickbook_quote",$data);
    }

	public function complete($ordid)
	{
        $ord = $this->db->get_where("tb_orders",array("order_id"=>$ordid),1,0);
        if($ord->num_rows()>0){
            $orddata = $ord->row_array();
            $this->load->library('email');
            /* to shipper */
            $data['order'] = $orddata;
            $data['page_title'] = "Booking Confirmation";
            $party = $this->db->query("SELECT m.name,m.email_id FROM tb_orders o,tb_customers m WHERE o.customer_id=m.id AND o.order_id='$ordid' LIMIT 1");
            //print_r($this->db->last_query());exit;
            if($party->num_rows()>0){
                $partdata = $party->row_array();
                $data['receivemail'] = $receivemail = $partdata['email_id'];
                $data['receivename'] = $receivename = $partdata['name'];
                $this->email->to($receivemail, $receivename);
                $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                $this->email->subject('svkonekt :: Booking Complete #'.$ordid);
                $this->email->set_mailtype('html');
                $body = $this->load->view('mail_forms/bookedquote', $data, true);
                $this->email->message($body);
                $sendmail = $this->email->send();
            }

            $input = $this->input->post();
            if(isset($input["base_rate"]) && count($input["base_rate"])>0){
                foreach($input["base_rate"] as $base_index=>$base_rate){
                    $tb_order_base_rates = array(
                        "order_id" => $ordid,
                        "base_rate" => $base_rate,
                        "currency" => NULL,
                        "user_id" => $this->session->userdata('user_id')
                    );
                    $this->db->insert("tb_order_base_rates",$tb_order_base_rates);
                    $base_rate_id = $this->db->insert_id();
                    if(isset($input["service_cost"]) && count($input["service_cost"])>0){
                        foreach($input["service_cost"][$base_index] as $service_index=>$service_rate){
                            $tb_order_service_rates = array(
                                "order_id" => $ordid,
                                "base_rate_id" => $base_rate_id,
                                "rate_type" => NULL,
                                "rate" => NULL,
                                "currency" => NULL,
                                "user_id" => $this->session->userdata('user_id')
                            );
                            $this->db->insert("tb_order_service_rates",$tb_order_service_rates);
                        }
                    }
                }
            }

        }
		$data["page_title"]="Complete";
        $data['order_id'] = $ordid;
		$this->settemplate->dashboard("quote/complete",$data);
	}

    public function ebookcomplete($ordid)
    {
        $data["page_title"]="Complete";
        /* send mail to shipper and consignee */
        if($ordid != ""){
            $data = array();
            $ord = $this->db->get_where("tb_orders",array("order_id"=>$ordid),1,0);
            if($ord->num_rows()>0){
                $orddata = $ord->row_array();
                $this->load->library('email');
                /* to shipper */
                $data['order'] = $orddata;
                $data['page_title'] = "Booking Confirmation";
                $data['receivemail'] = $receivemail = trim($orddata['customer_email']);
                $data['receivename'] = $receivename = trim($orddata['customer_name']);
                if(strlen($receivemail)>0){
                    $this->email->to($receivemail, $receivename);
                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                    $this->email->subject('svkonekt :: Booking Complete #'.$ordid);
                    $this->email->set_mailtype('html');
                    $body = $this->load->view('mail_forms/bookedquote', $data, true);
                    $this->email->message($body);
                    $sendmail = $this->email->send();
                }
                /* to consignee */
                $party = $this->db->query("SELECT m.name,m.email FROM tb_order_parties p,tbl_party_master m,tbl_party_types t WHERE p.party_id=m.id AND m.party_type_id=t.id AND t.name='Consignee' AND p.order_number='".$ordid."' LIMIT 1");
                if($party->num_rows()>0){
                    $partdata = $party->row_array();
                    $data['receivemail'] = $receivemail = $partdata['email'];
                    $data['receivename'] = $receivename = $partdata['name'];
                    if($partdata['email'] != ""){
                        $this->email->to($receivemail, $receivename);
                    }else{
                        $this->email->to('external.ram.k@kuehne-nagel.com','RCREDDY');
                    }
                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                    $this->email->subject('svkonekt :: Booking Complete #'.$ordid);
                    $this->email->set_mailtype('html');
                    $body = $this->load->view('mail_forms/bookedquote', $data, true);
                    $this->email->message($body);
                    $sendmail = $this->email->send();
                }

                $input = $this->input->post();
                if(isset($input["base_rate"]) && count($input["base_rate"])>0){
                    foreach($input["base_rate"] as $base_index=>$base_rate){
                        $tb_order_base_rates = array(
                            "order_id" => $ordid,
                            "base_rate" => $base_rate,
                            "currency" => NULL,
                            "user_id" => $this->session->userdata('user_id')
                        );
                        $this->db->insert("tb_order_base_rates",$tb_order_base_rates);
                        $base_rate_id = $this->db->insert_id();
                        if(isset($input["service_cost"]) && count($input["service_cost"])>0){
                            foreach($input["service_cost"][$base_index] as $service_index=>$service_rate){
                                $tb_order_service_rates = array(
                                    "order_id" => $ordid,
                                    "base_rate_id" => $base_rate_id,
                                    "rate_type" => NULL,
                                    "rate" => NULL,
                                    "currency" => NULL,
                                    "user_id" => $this->session->userdata('user_id')
                                );
                                $ins = $this->db->insert("tb_order_service_rates",$tb_order_service_rates);
                            }
                        }
                    }
                }

                $data['order_id'] = $ordid;
                $data["page_title"]="E - Booking";
                $data["sub_title"]="Quoted";
                $this->settemplate->dashboard("ebook/ebookcomplete",$data);
            }
        }
    }
    public function ebooksave($ordid)
    {
        redirect("ebooking/search");
    }

	public function saveresponsedata($res, $id)
    {
    	$shidata = array();
            if (isset($res['TransmissionBody'])) {
                $shidata = $this->getshipmentcostdata($res['TransmissionBody']);
            }
        return $shidata;
    }

    public function getshipmentcostdata($data)
    {
        $res    = array();
        $others = $shipqry = $shipqryres = array();
        if (!empty($data)) {
            $qrydata = $data['GLogXMLElement']['RemoteQueryReply']['RIQQueryReply']['RIQQuery'];
            if (!empty($qrydata)) {
                $req_type       = $qrydata['RIQRequestType'];
                $source_addr    = $qrydata['SourceAddress']['MileageAddress']['CountryCode3Gid']['Gid']['Xid'];
                $dest_addr      = $qrydata['DestAddress']['MileageAddress']['CountryCode3Gid']['Gid']['Xid'];
                $transmode      = isset($qrydata['TransportModeGid']['Gid']['Xid']) ? $qrydata['TransportModeGid']['Gid']['Xid'] : '';
                $specialservices = array();
                $special_service = isset($qrydata['SpecialServiceGid'][0]['Gid']['Xid']) ? $qrydata['SpecialServiceGid'][0]['Gid']['Xid'] : '';
                if($special_service != ""){
                	foreach($qrydata['SpecialServiceGid'] as $res){
                		$specialservices[] = array('serviceid'=>$res['Gid']['Xid'],'domain'=>$res['Gid']['DomainName']);
                	}
                }else{
                	$special_service1 = isset($qrydata['SpecialServiceGid']['Gid']['Xid']) ? $qrydata['SpecialServiceGid']['Gid']['Xid'] : '';
                	if($special_service1 != ""){
	                	$specialservices[] = array('serviceid'=>$qrydata['SpecialServiceGid']['Gid']['Xid'],'domain'=>$qrydata['SpecialServiceGid']['Gid']['DomainName']);
	                }
                }
                $availabledate  = date('Y-m-d H:i:s', strtotime($qrydata['AvailableBy']['AvailableDate']));
                $stimezone      = $qrydata['AvailableBy']['TimeZoneGid']['Gid']['Xid'];
                $perspective    = $qrydata['Perspective'];
                $ispreferred    = $qrydata['IsPreferred'];
                $shipunits = array();
                $chkshipunitcnt = isset($qrydata['ShipUnit'][0]['ShipUnitCount']) ? $qrydata['ShipUnit'][0]['ShipUnitCount'] : '';
                if($chkshipunitcnt != ""){
                	foreach($qrydata['ShipUnit'] as $su){
                		$shipunitweight = $su['WeightVolume']['Weight']['WeightValue'];
		                $weighttype = $su['WeightVolume']['Weight']['WeightUOMGid']['Gid']['Xid'];
		                $shipunitvolume = $su['WeightVolume']['Volume']['VolumeValue'];
		                $volumetype     = $su['WeightVolume']['Volume']['VolumeUOMGid']['Gid']['Xid'];
		                $shipunitcount  = $su['ShipUnitCount'];
                		$shipunits[] = array('shipunitweight'=>$shipunitweight, 'weighttype'=>$weighttype, 'shipunitvolume'=>$shipunitvolume, 'volumetype'=>$volumetype, 'shipunitcount'=>$shipunitcount);
                	}
                }else{
                	$shipunitweight = $qrydata['ShipUnit']['WeightVolume']['Weight']['WeightValue'];
	                $weighttype     = $qrydata['ShipUnit']['WeightVolume']['Weight']['WeightUOMGid']['Gid']['Xid'];
	                $shipunitvolume = $qrydata['ShipUnit']['WeightVolume']['Volume']['VolumeValue'];
	                $volumetype     = $qrydata['ShipUnit']['WeightVolume']['Volume']['VolumeUOMGid']['Gid']['Xid'];
	                $shipunitcount  = $qrydata['ShipUnit']['ShipUnitCount'];
	                $shipunits[] = array('shipunitweight'=>$shipunitweight, 'weighttype'=>$weighttype, 'shipunitvolume'=>$shipunitvolume, 'volumetype'=>$volumetype, 'shipunitcount'=>$shipunitcount);
                }
                $shipqry = array('req_type'=>$req_type, 'source_addr'=>$source_addr, 'dest_addr'=>$dest_addr, 'availabledate'=>$availabledate, 'stimezone'=>$stimezone, 'perspective'=>$perspective, 'ispreferred'=>$ispreferred, 'shipmentunits'=>$shipunits,'specialservices'=>$specialservices,'transmode'=>$transmode);
            }
            $qryres = isset($data['GLogXMLElement']['RemoteQueryReply']['RIQQueryReply']['RIQResult']) ? $data['GLogXMLElement']['RemoteQueryReply']['RIQQueryReply']['RIQResult'] : array();
            if (!empty($qryres)) {
                $chkmulti = isset($qryres[0]['ServiceProviderGid']['Gid']['Xid']) ? $qryres[0]['ServiceProviderGid']['Gid']['Xid'] : '';
                if($chkmulti != ""){
                    foreach ($qryres as $qryres1) {
                        $getres = $this->getriqresult($qryres1,$source_addr);
                        $shipqryres[] = $getres;
                        $shipqryres[] = $getres;
                    }
                }else{
                    $getres = $this->getriqresult($qryres,$source_addr);
                    $shipqryres[] = $getres;
                }
            }
            $qrystatus = isset($data['GLogXMLElement']['RemoteQueryReply']['RIQQueryReply']['RemoteQueryStatus']) ? $data['GLogXMLElement']['RemoteQueryReply']['RIQQueryReply']['RemoteQueryStatus'] : array();
            if (!empty($qrystatus)) {
                $sts = $qrystatus['RemoteQueryStatusCode'];
                $stssubject = $qrystatus['RemoteQueryStatusSubject'];
                $stsmsg = $qrystatus['RemoteQueryStatusMessage'];
                $others = array('status' => $sts, 'subject' => $stssubject, 'message' => $stsmsg);
            }
            $res = array('qrydata' => $shipqry, 'qryres' => $shipqryres, 'others' => $others);
        }
        return $res;
    }

    function getriqresult($qryres1,$source_addr){
        $source_id = $source_addr;
        $serviceprovideid     = isset($qryres1['ServiceProviderGid']['Gid']['Xid']) ? $qryres1['ServiceProviderGid']['Gid']['Xid'] : '';
        $rateofferid          = isset($qryres1['RateOfferingGid']['Gid']['Xid']) ? $qryres1['RateOfferingGid']['Gid']['Xid'] : '';
        $rategeoid            = isset($qryres1['RateGeoGid']['Gid']['Xid']) ? $qryres1['RateGeoGid']['Gid']['Xid'] : '';
        $rateserviceid        = isset($qryres1['RateServiceGid']['Gid']['Xid']) ? $qryres1['RateServiceGid']['Gid']['Xid'] : '';
        $transportmodeid      = isset($qryres1['TransportModeGid']['Gid']['Xid']) ? $qryres1['TransportModeGid']['Gid']['Xid'] : '';
        $vehicletypeid        = isset($qryres1['EquipmentGroupGid']['Gid']['Xid']) ? $qryres1['EquipmentGroupGid']['Gid']['Xid'] : '';
        $delivby = isset($qryres1['DeliveryBy']['DeliveryByDate']) ? $qryres1['DeliveryBy']['DeliveryByDate'] : date('Y-m-d H:i:s');
        $deliveryby           = date('Y-m-d H:i:s', strtotime($delivby));
        $deliverytz           = isset($qryres1['DeliveryBy']['TimeZoneGid']['Gid']['Xid']) ? $qryres1['DeliveryBy']['TimeZoneGid']['Gid']['Xid'] : '';
        $pickby = isset($qryres1['PickupBy']['PickupByDate']) ? $qryres1['PickupBy']['PickupByDate'] : date('Y-m-d H:i:s');
        $pickupby             = date('Y-m-d H:i:s', strtotime($pickby));
        $pickuptz             = isset($qryres1['PickupBy']['TimeZoneGid']['Gid']['Xid']) ? $qryres1['PickupBy']['TimeZoneGid']['Gid']['Xid'] : '';
        $transittime          = isset($qryres1['TransitTime']['Duration']['DurationValue']) ? $qryres1['TransitTime']['Duration']['DurationValue'] : '';
        $timein               = isset($qryres1['TransitTime']['Duration']['DurationUOMGid']['Gid']['Xid']) ? $qryres1['TransitTime']['Duration']['DurationUOMGid']['Gid']['Xid'] : '';
        $costcurrcode         = isset($qryres1['Cost']['FinancialAmount']['GlobalCurrencyCode']) ? $qryres1['Cost']['FinancialAmount']['GlobalCurrencyCode'] : '';
        $costamount           = isset($qryres1['Cost']['FinancialAmount']['MonetaryAmount']) ? $qryres1['Cost']['FinancialAmount']['MonetaryAmount'] : '';
        $ratetobase           = isset($qryres1['Cost']['FinancialAmount']['RateToBase']) ? $qryres1['Cost']['FinancialAmount']['RateToBase'] : '';
        $fincurramount        = isset($qryres1['Cost']['FinancialAmount']['FuncCurrencyAmount']) ? $qryres1['Cost']['FinancialAmount']['FuncCurrencyAmount'] : '';
        $totcostcurrcode      = isset($qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['GlobalCurrencyCode']) ? $qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['GlobalCurrencyCode'] : '';
        $totcostamount        = isset($qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['MonetaryAmount']) ? $qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['MonetaryAmount'] : '';
        $totratetobase        = isset($qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['RateToBase']) ? $qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['RateToBase'] : '';
        $totfincurramount     = isset($qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['FuncCurrencyAmount']) ? $qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['FuncCurrencyAmount'] : '';
        $totweighttype        = isset($qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['WeightUOMGid']['Gid']['Xid']) ? $qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['WeightUOMGid']['Gid']['Xid'] : '';
        $costdetails = array();
        $chkcntcosts = isset($qryres1['CostDetails'][0]['CostType']) ? $qryres1['CostDetails'][0]['CostType'] : '';
        if($chkcntcosts != ""){
            foreach($qryres1['CostDetails'] as $cd){
                $costdettype          = isset($cd['CostType']) ? $cd['CostType'] : '';
                $costdetcurrcode      = isset($cd['Cost']['FinancialAmount']['GlobalCurrencyCode']) ? $cd['Cost']['FinancialAmount']['GlobalCurrencyCode'] : '';
                $costdetamount        = isset($cd['Cost']['FinancialAmount']['MonetaryAmount']) ? $cd['Cost']['FinancialAmount']['MonetaryAmount'] : '';
                $costdetratetobase    = isset($cd['Cost']['FinancialAmount']['RateToBase']) ? $cd['Cost']['FinancialAmount']['RateToBase'] : '';
                $costdetfincurramount = isset($cd['Cost']['FinancialAmount']['FuncCurrencyAmount']) ? $cd['Cost']['FinancialAmount']['FuncCurrencyAmount'] : '';
                $costdetiswaighted    = isset($cd['IsWeighted']) ? $cd['IsWeighted'] : '';
                $associd = isset($cd['AccessorialCodeGid']['Gid']['Xid']) ? $cd['AccessorialCodeGid']['Gid']['Xid'] : '';
                $costdetails[] = array('costdettype'=>$costdettype, 'costdetcurrcode'=>$costdetcurrcode, 'costdetamount'=>$costdetamount, 'costdetratetobase'=>$costdetratetobase, 'costdetfincurramount'=>$costdetfincurramount, 'costdetiswaighted'=>$costdetiswaighted,'associd'=>$associd);
            }
        }else{
            $costdettype          = isset($qryres1['CostDetails']['CostType']) ? $qryres1['CostDetails']['CostType'] : '';
            $costdetcurrcode      = isset($qryres1['CostDetails']['Cost']['FinancialAmount']['GlobalCurrencyCode']) ? $qryres1['CostDetails']['Cost']['FinancialAmount']['GlobalCurrencyCode'] : '';
            $costdetamount        = isset($qryres1['CostDetails']['Cost']['FinancialAmount']['MonetaryAmount']) ? $qryres1['CostDetails']['Cost']['FinancialAmount']['MonetaryAmount'] : '';
            $costdetratetobase    = isset($qryres1['CostDetails']['Cost']['FinancialAmount']['RateToBase']) ? $qryres1['CostDetails']['Cost']['FinancialAmount']['RateToBase'] : '';
            $costdetfincurramount = isset($qryres1['CostDetails']['Cost']['FinancialAmount']['FuncCurrencyAmount']) ? $qryres1['CostDetails']['Cost']['FinancialAmount']['FuncCurrencyAmount'] : '';
            $costdetiswaighted    = isset($qryres1['CostDetails']['IsWeighted']) ? $qryres1['CostDetails']['IsWeighted'] : '';
            $associd = isset($qryres1['CostDetails']['AccessorialCodeGid']['Gid']['Xid']) ? $qryres1['CostDetails']['AccessorialCodeGid']['Gid']['Xid'] : '';
            $costdetails[] = array('costdettype' => $costdettype, 'costdetcurrcode' => $costdetcurrcode, 'costdetamount' => $costdetamount, 'costdetratetobase' => $costdetratetobase, 'costdetfincurramount' => $costdetfincurramount, 'costdetiswaighted' => $costdetiswaighted,'associd'=>$associd);
        }
        $timefeasible         = isset($qryres1['IsTimeFeasible']) ? $qryres1['IsTimeFeasible'] : '';
        $optimalresult        = isset($qryres1['IsOptimalResult']) ? $qryres1['IsOptimalResult'] : '';
        $resperspective       = isset($qryres1['Perspective']) ? $qryres1['Perspective'] : '';
        $distance             = isset($qryres1['Distance']['DistanceValue']) ? $qryres1['Distance']['DistanceValue'] : 0;
        if ($distance != 0) {
            $distancetype = isset($qryres1['Distance']['DistanceUOMGid']['Gid']['Xid']) ? $qryres1['Distance']['DistanceUOMGid']['Gid']['Xid'] : 'MI';
        } else {
            $distancetype = "MI";
        }
        $shipqryres = array('source_id' => $source_id, 'serviceprovideid' => $serviceprovideid, 'rateofferid' => $rateofferid, 'rategeoid' => $rategeoid, 'rateserviceid' => $rateserviceid, 'transportmodeid' => $transportmodeid, 'deliveryby' => $deliveryby, 'deliverytz' => $deliverytz, 'pickupby' => $pickupby, 'pickuptz' => $pickuptz, 'transittime' => $transittime, 'timein' => $timein, 'costcurrcode' => $costcurrcode, 'costamount' => $costamount, 'ratetobase' => $ratetobase, 'fincurramount' => $fincurramount, 'totcostcurrcode' => $totcostcurrcode, 'totcostamount' => $totcostamount, 'totratetobase' => $totratetobase, 'totfincurramount' => $totfincurramount, 'totweighttype' => $totweighttype, 'costdetails'=>$costdetails, 'timefeasible' => $timefeasible, 'optimalresult' => $optimalresult, 'resperspective' => $resperspective, 'distance' => $distance, 'distancetype' => $distancetype, 'vehicletypeid' => $vehicletypeid);
        return $shipqryres;
    }

    public function insertShipCostData($shipdata, $id)
    {
        $curdt  = date('Y-m-d H:i:s');
        $result = 0;
        if ($id > 0 && !empty($shipdata)) {
            if (isset($shipdata['qrydata']) && isset($shipdata['qryres'])) {
                foreach ($shipdata['qryres'] as $res) {
                    $data = $shipdata['qrydata'] + $res;
                    if (isset($shipdata['others']['status'])) {
                        if ($shipdata['others']['status'] == "SUCCESS") {
                            $status = 1;
                        } else {
                            $status = 0;
                        }
                    }
                    $data['status']      = $status;
                    $data['shipment_id'] = $id;
                    $insdata             = $this->db->insert('tb_shipment_response_data', $data);
                }
            }
            $result = 1;
        }
        return $result;
    }

}
