<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
class Rateoffering
 extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if($this->session->userdata('user_id') == ''){
            redirect('login');
        }
        $this->load->library('form_validation');
        $this->load->model('common');
        $this->load->model('mastersmodel');
        $this->load->model('rateofferingmodel');
        if (!checkUrlAccessForUser('RATEOFFERING')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index() {
        $data['page_title'] = $this->lang->line('rateoffering');
        $data['sub_title'] = $this->lang->line('rateoffering');
        $userid = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        if($company_code == "RUKN"){
            $data['rservices'] = $this->common->gettbldata(array('status'=>1,'company_code'=>$company_code),'id,service_id','tb_rate_services',0,0);
        }else{
            $data['rservices'] = $this->common->gettbldata(array('status'=>1,'user_id'=>$userid),'id,service_id','tb_rate_services',0,0);
        }

        /*$data['transport'] = $this->common->gettbldata(array('status'=>1),'code,name','tb_transportmode',0,0);*/
        $data['transport'] = gettransportmode();
        if($company_code == "RUKN"){
            $where = array(
                'ro.status'=>1,
                'ro.company_code'=>$company_code,
            );
        }else{
            $where = array(
                'ro.status'=>1,
                'ro.user_id'=>$userid,
            );
        }
        $post = $this->input->post(NULL,TRUE);

        if(isset($post['offering_id']) && $post['offering_id']){
            $where['ro.offering_id'] = $post['offering_id'];
        }
        if(isset($post['advoffering_id']) && $post['advoffering_id']){
            $where['ro.offering_id'] = $post['advoffering_id'];
        }
        if(isset($post['offering_type'])  && $post['offering_type']){
            $where['ro.offering_type'] = $post['offering_type'];
        }
        if(isset($post['advoffering_type']) && $post['advoffering_type']){
            $where['ro.offering_type'] = $post['advoffering_type'];
        }
        if(isset($post['tarrif_type'])  && $post['tarrif_type']){
            $where['ro.tarrif_type'] = $post['tarrif_type'];
        }
        if(isset($post['offering_name'])  && $post['offering_name']){
            $where['ro.offering_name'] = $post['offering_name'];
        }
        if(isset($post['advtariff_type'])  && $post['advtariff_type']){
            $where['ro.tarrif_type'] = $post['advtariff_type'];
        }
        if(isset($post['rate_service_id'])  && $post['rate_service_id']){
            $where['ro.rate_service_id'] = $post['rate_service_id'];
        }
        if(isset($post['offering_quote'])  && $post['offering_quote']){
            $where['ro.offering_quote'] = 1;
        }
        if(isset($post['company_code']) && $post['company_code']){
            $where['ro.company_code'] = $post['company_code'];
        }
        if(isset($post['branch_code']) && $post['branch_code']){
            $where['ro.branch_code'] = $post['branch_code'];
        }
        if(isset($post['cust_profile_id'])){
            $custpfid = $this->common->gettblrowdata(['cust_profile_id'=>$post['cust_profile_id']],'id','tb_customer_profile',0,0);
            if($custpfid){
                $where['ro.cust_profile_id'] = $custpfid['id'];
            }
        }
        if(isset($post['vend_profile_id'])){
            $vendpfid = $this->common->gettblrowdata(['vend_profile_id'=>$post['vend_profile_id']],'id','tb_vendor_profile',0,0);
            if($vendpfid){
                $where['ro.vendor_profile_id'] = $vendpfid['id'];
            }
        }
        $data['rateofferings'] = $this->rateofferingmodel->getrateofferings($where);
        $this->newtemplate->dashboard("rateoffering/index", $data);
    }

    public function add(): void
    {
        $data['page_title'] = $this->lang->line('rateoffering');
        $data['sub_title'] = $this->lang->line('rateoffering');
        $userId = $this->session->userdata('user_id');
        $companyCode = $this->session->userdata('company_code');
        $branchCode = $this->session->userdata('branch_code');
        $whereCondition = ['status' => 1, 'user_id' => $userId];
        if ($companyCode == "RUKN") {
            $whereCondition = ['status' => 1, 'company_code' => $companyCode];
        }
        $data['doctypes'] = $this->common->gettbldata(['status' => 1], 'id,document_id,type_name as document_name', 'tb_document_types', 0, 0);
        if ($companyCode == 'RUKN') {
            $data['vaslist'] = $this->common->gettbldata(['company_code' => $companyCode, 'status' => 1], 'id,vas_id,vas_name', 'tb_vas_master', 0, 0);
        } else {
            $data['vaslist'] = $this->common->gettbldata(['company_code!=' => 'RUKN', 'status' => 1], 'id,vas_id,vas_name', 'tb_vas_master', 0, 0);
        }
        $data['rservices'] = $this->common->gettbldata($whereCondition, 'id,service_id,service_name', 'tb_rate_services', 0, 0);
        $data['chargeidlist'] = $this->rateofferingmodel->getchargeidlist(['status' => 1]);
        $data['chargebasis'] = ['Per KG', 'Per LDM', 'Per CBM', 'Per Stop', 'Per Trip', 'Per KM', 'Per Mile', 'waiting Time(Hrs)', 'Goods Value'];
        $data['currency'] = $this->session->userdata('usr_tzone')['currency'];
        $data['transport'] = gettransportmode();
        $post = $this->input->post(null, true);
        if (!empty($post)) {
            $vehicleProfileId = $post['vehicle_profile_id'] ?? 0;
            if ($vehicleProfileId > 0) {
                $vehicleProfileDetails = $this->common->gettblrowdata(['veh_profile_id' => $vehicleProfileId], 'id', 'tb_vehicle_profile', 0, 0);
            }
            $customerProfileId = $post['customer_profile_id'] ?? 0;
            if ($customerProfileId > 0) {
                $customerProfileDetails = $this->common->gettblrowdata(['cust_profile_id' => $customerProfileId], 'id', 'tb_customer_profile', 0, 0);
            }
            $vendorProfileId = $post['vendor_profile_id'] ?? 0;
            if ($vendorProfileId > 0) {
                $vendorProfileDetails = $this->common->gettblrowdata(['vend_profile_id' => $vendorProfileId], 'id', 'tb_vendor_profile', 0, 0);
            }
            $cargoProfileId = $post['cargo_profile_id'] ?? 0;
            if ($cargoProfileId > 0) {
                $cargoProfileDetails = $this->common->gettblrowdata(['cargo_profile_id' => $cargoProfileId], 'id', 'tb_cargo_profile', 0, 0);
            }
            $insertArray['offering_id'] = $this->genofferid();
            $insertArray['offering_type'] = $post['offering_type'] ?? 0;
            $insertArray['offering_name'] = $post['offering_name'] ?? "";
            $insertArray['rate_service_id'] = $post['rate_service_id'] ?? 0;
            $insertArray['lane_id'] = $post['lane_id'] ?? 0;
            $insertArray['effective_date'] = date('Y-m-d', strtotime($post['effective_date']));
            $insertArray['expiry_date'] = date('Y-m-d', strtotime($post['expiry_date']));
            $insertArray['offering_active'] = (isset($post['offering_active'])) ? 1 : 0;
            $insertArray['offering_quote'] = (isset($post['offering_quote'])) ? 1 : 0;
            $insertArray['tarrif_type'] = $post['tariff_type'] ?? "";
            $insertArray['veh_profile_id'] = $vehicleProfileDetails['id'] ?? 0;
            $insertArray['cust_profile_id'] = $customerProfileDetails['id'] ?? 0;
            $insertArray['vendor_profile_id'] = $vendorProfileDetails['id'] ?? 0;
            $insertArray['company_code'] = $post['company_code'] ?? $companyCode;
            $insertArray['branch_code'] = $post['branch_code'] ?? $branchCode;
            $insertArray['description'] = $post['description'] ?? "";
            $insertArray['uom_conversion_id'] = $post['conversion_id'] ?? 0;
            $insertArray['status'] = 1;
            $insertArray['user_id'] = $userId;
            $insertArray['createdon'] = $insertArray['updatedon'] = date('Y-m-d H:i:s');
            $rateOfferingId = $this->common->insertTableData('tb_rate_offerings', $insertArray);
            $constraint['rateoffering_id'] = $rateOfferingId;
            $constraint['min_weight'] = $post['min_weight'] ?? '0.00';
            $constraint['max_weight'] = $post['max_weight'] ?? '0.00';
            $constraint['weight_uom'] = $post['min_weight_uom'] ?? "KG";
            $constraint['min_volume'] = $post['min_volume'] ?? '0.00';
            $constraint['max_volume'] = $post['max_volume'] ?? '0.00';
            $constraint['volume_uom'] = $post['min_volume_uom'] ?? "CBM";
            $constraint['min_distance'] = $post['min_distance'] ?? '0.00';
            $constraint['max_distance'] = $post['max_distance'] ?? '0.00';
            $constraint['distance_uom'] = $post['min_distance_uom'] ?? "KM";
            $constraint['cargo_profile_id'] = $cargoProfileDetails['id'] ?? 0;
            $constraint['status'] = 1;
            $constraint['createdon'] = $constraint['updatedon'] = date('Y-m-d H:i:s');
            $constraintRowId = $this->common->insertTableData('tb_rateoffering_constraints', $constraint);
            $remarkTypeIds = (isset($post['rmktype_ids']) && $post['rmktype_ids'] != "") ? explode(',', $post['rmktype_ids']) : [];
            $documentIds = (isset($post['rofrdoc_ids']) && $post['rofrdoc_ids'] != "") ? explode(',', $post['rofrdoc_ids']) : [];
            $serviceIds = (isset($post['service_ids']) && $post['service_ids'] != "") ? explode(',', $post['service_ids']) : [];
            if (!empty($serviceIds)) {
                $this->rateofferingmodel->updaterofrmodule('tb_rateoffering_services', ['rateoffering_id' => $rateOfferingId], $serviceIds);
            }
            if (!empty($documentIds)) {
                $this->rateofferingmodel->updaterofrmodule('tb_rateoffering_docs', ['rateoffering_id' => $rateOfferingId], $documentIds);
            }
            if (!empty($remarkTypeIds)) {
                $remark['rateoffering_id'] = $rateOfferingId;
                $remark['status'] = 1;
                $remark['createdon'] = $remark['updatedon'] = date('Y-m-d H:i:s');
                foreach ($remarkTypeIds as $eachLine) {
                    if (!empty($eachLine)) {
                        $remark['remark_type'] = $eachLine;
                        $this->common->insertTableData('tb_rateoffering_remarks', $remark);
                    }
                }
            }
            redirect('rateoffering');
        } else {
            //$this->newtemplate->dashboard("rateoffering/add", $data);
            $this->load->view("rateoffering/add", $data);
        }
    }

    public function edit(int $rowId): void
    {
        $data['rateofr'] = $this->rateofferingmodel->getrateofr($rowId);
        $data['page_title'] = $this->lang->line('rateoffering');
        $data['sub_title'] = $this->lang->line('rateoffering');
        $data['transport'] = gettransportmode();
        if (empty($data['rateofr'])) {
            redirect('rateoffering/add');
        }
        $userId = $this->session->userdata('user_id');
        $companyCode = $this->session->userdata('company_code');
        $branchCode = $this->session->userdata('branch_code');
        $whereCondition = ['status' => 1, 'user_id' => $userId];
        if ($companyCode == "RUKN") {
            $whereCondition = ['status' => 1, 'company_code' => $companyCode];
        }
        $data['doctypes'] = $this->common->gettbldata(['status' => 1], 'id,document_id,type_name as document_name', 'tb_document_types', 0, 0);
        if ($companyCode == 'RUKN') {
            $data['vaslist'] = $this->common->gettbldata(['company_code' => $companyCode, 'status' => 1], 'id,vas_id,vas_name', 'tb_vas_master', 0, 0);
        } else {
            $data['vaslist'] = $this->common->gettbldata(['company_code!=' => 'RUKN', 'status' => 1], 'id,vas_id,vas_name', 'tb_vas_master', 0, 0);
        }
        $data['rservices'] = $this->common->gettbldata($whereCondition, 'id,service_id,service_name', 'tb_rate_services', 0, 0);
        $data['chargeidlist'] = $this->common->gettbldata(['status' => 1], 'id,charge_code,name', 'tb_charge_codes', 0, 0);
        $data['chargebasis'] = ['Per KG', 'Per LDM', 'Per CBM', 'Per Stop', 'Per Trip', 'Per KM', 'Per Mile', 'waiting Time(Hrs)', 'Goods Value'];
        $data['currency'] = $this->session->userdata('usr_tzone')['currency'];
        $post = $this->input->post(null, true);
        if (!empty($post)) {
            $vehicleProfileId = $post['vehicle_profile_id'] ?? 0;
            if ($vehicleProfileId > 0) {
                $vehicleProfileDetails = $this->common->gettblrowdata(['veh_profile_id' => $vehicleProfileId], 'id', 'tb_vehicle_profile', 0, 0);
            }
            $customerProfileId = $post['customer_profile_id'] ?? 0;
            if ($customerProfileId > 0) {
                $customerProfileDetails = $this->common->gettblrowdata(['cust_profile_id' => $customerProfileId], 'id', 'tb_customer_profile', 0, 0);
            }
            $vendorProfileId = $post['vendor_profile_id'] ?? 0;
            if ($vendorProfileId > 0) {
                $vendorProfileDetails = $this->common->gettblrowdata(['vend_profile_id' => $vendorProfileId], 'id', 'tb_vendor_profile', 0, 0);
            }
            $cargoProfileId = $post['cargo_profile_id'] ?? 0;
            if ($cargoProfileId > 0) {
                $cargoProfileDetails = $this->common->gettblrowdata(['cargo_profile_id' => $cargoProfileId], 'id', 'tb_cargo_profile', 0, 0);
            }
            $effectiveDate = $post['effective_date'] ?? "";
            $expiryDate = $post['expiry_date'] ?? "";
            $updateArray['offering_type'] = $post['offering_type'] ?? 0;
            $updateArray['offering_name'] = $post['offering_name'] ?? "";
            $updateArray['rate_service_id'] = $post['rate_service_id'] ?? 0;
            $updateArray['lane_id'] = $post['lane_id'] ?? "";
            $updateArray['effective_date'] = $effectiveDate !== "" ? date('Y-m-d', strtotime($effectiveDate)) : date('Y-m-d H:i:s');
            $updateArray['expiry_date'] = $expiryDate !== "" ? date('Y-m-d', strtotime($expiryDate)) : date('Y-m-d H:i:s', strtotime("+30 days"));
            $updateArray['offering_active'] = (isset($post['offering_active'])) ? 1 : 0;
            $updateArray['offering_quote'] = (isset($post['offering_quote'])) ? 1 : 0;
            $updateArray['tarrif_type'] = $post['tariff_type'] ?? "";
            $updateArray['veh_profile_id'] = $vehicleProfileDetails['id'] ?? 0;
            $updateArray['cust_profile_id'] = $customerProfileDetails['id'] ?? 0;
            $updateArray['vendor_profile_id'] = $vendorProfileDetails['id'] ?? 0;
            $updateArray['company_code'] = $post['company_code'] ?? $companyCode;
            $updateArray['branch_code'] = $post['branch_code'] ?? $branchCode;
            $updateArray['description'] = $post['description'] ?? "";
            $updateArray['uom_conversion_id'] = $post['conversion_id'] ?? 0;
            $updateArray['status'] = 1;
            $updateArray['user_id'] = $userId;
            $updateArray['createdon'] = $updateArray['updatedon'] = date('Y-m-d H:i:s');
            $this->common->updatetbledata('tb_rate_offerings', $updateArray, ['id' => $rowId]);
            $constraint['rateoffering_id'] = $rowId;
            $constraint['min_weight'] = $post['min_weight'] ?? '0.00';
            $constraint['max_weight'] = $post['max_weight'] ?? '0.00';
            $constraint['weight_uom'] = $post['min_weight_uom'] ?? "KG";
            $constraint['min_volume'] = $post['min_volume'] ?? '0.00';
            $constraint['max_volume'] = $post['max_volume'] ?? '0.00';
            $constraint['volume_uom'] = $post['min_volume_uom'] ?? "CBM";
            $constraint['min_distance'] = $post['min_distance'] ?? '0.00';
            $constraint['max_distance'] = $post['max_distance'] ?? '0.00';
            $constraint['distance_uom'] = $post['min_distance_uom'] ?? "KM";
            $constraint['cargo_profile_id'] = $cargoProfileDetails['id'] ?? 0;
            $constraint['status'] = 1;
            $constraint['createdon'] = $constraint['updatedon'] = date('Y-m-d H:i:s');
            $this->common->updatetbledata('tb_rateoffering_constraints', $constraint, ['rateoffering_id' => $rowId]);
            redirect('rateoffering');
        } else {
            //$this->newtemplate->dashboard("rateoffering/edit", $data);
            $this->load->view("rateoffering/edit", $data);
        }
    }

    public function view($id) {
        $data['rateofr'] = $this->rateofferingmodel->getrateofr($id);
        $data['page_title'] = $this->lang->line('rateoffering');
        $data['sub_title'] = $this->lang->line('rateoffering');
        if($data['rateofr']){
            //$this->newtemplate->dashboard("rateoffering/view", $data);
            $this->load->view("rateoffering/view", $data);
        } else {
            redirect('rateoffering');
        }
    }

    public function deleterateoffering($id){
        if($id != '' || $id != 0){
            $chk = $this->common->gettblrowdata(array('id'=>$id),'status','tb_rate_offerings',0,0);
            if($chk){
                $upd = $this->common->updatetbledata('tb_rate_offerings',array('status'=>0),array('id'=>$id));
                if($upd){
                    echo "1";
                }else{
                    echo "0";
                }
            }else{
                echo "0";
            }
        }
    }

    public function getofferingid(){
        $result = array();
        $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');
        $where['user_id'] = $user_id;
        if($company_code == "RUKN"){
            $where['company_code'] = $company_code;
        }else{
            $where['user_id'] = $user_id;
        }
        $where['status'] = 1;
        $like['offering_id'] = $this->input->post('term');
        $result = $this->mastersmodel->getsearchdata($like,$where,'id,offering_id','tb_rate_offerings');
        echo  json_encode($result);
    }

    public function genofferid(){
        $year = date('y');
        $week = date('W');
        $lane_res = $this->db->query("SELECT offering_id FROM tb_rate_offerings ORDER BY id DESC LIMIT 1");
        if ($lane_res->num_rows() > 0) {
            $get_offeringid = $lane_res->row()->offering_id;
            $get_offeringid_c = strlen($get_offeringid);
            if ($get_offeringid_c > 7) {
                $previous_weeknumber = substr($get_offeringid, 4, 2);
                $get_offeringid1 = substr($get_offeringid, 6);
                $get_offeringid2 = ltrim($get_offeringid1, 0);
                if ($previous_weeknumber < $week) {
                    $id1 = '0001';
                } else {
                    $i_id = $get_offeringid2;
                    $i_id ++;
                    $idlength = strlen($i_id);
                    if ($idlength == '1') {
                        $id1 = "000" . $i_id;
                    } else if ($idlength == '2') {
                        $id1 = "00" . $i_id;
                    } else if ($idlength == '3') {
                        $id1 = "0" . $i_id;
                    } else if ($idlength == '4') {
                        $id1 = $i_id;
                    } else {
                        $id1 = $i_id;
                    }
                }
            } else {
                $id1 = '0001';
            }

            $offering_id = "RO" . $year . $week . $id1;
            $chk = $this->db->query("select offering_id FROM tb_rate_offerings WHERE offering_id='" . $offering_id . "'");
            if ($chk->num_rows() > 0) {
                $iid = $id1;
                $iid ++;
                $ii_d = $iid;
                $id_length = strlen($iid);
                if ($id_length == '1') {
                    $ii_d = "000" . $iid;
                } else if ($id_length == '2') {
                    $ii_d = "00" . $iid;
                } else if ($id_length == '3') {
                    $ii_d = "0" . $iid;
                } else if ($id_length == '4') {
                    $ii_d = $iid;
                } else {
                    $ii_d = $iid;
                }
                $offering_id = "RO" . $year . $week . $ii_d;
            } else {
                $offering_id = $offering_id;
            }
        } else {
            $i_id = 1;
            $id1 = '000' . $i_id;
            $offering_id = "RO" . $year . $week . $id1;
        }

        return $offering_id;
    }

    public function getrateservices(){
        $where['company_code'] = $this->input->post('company_code');
        $where['branch_code'] = $this->input->post('branch_code');
        $like['service_id'] = $this->input->post('term');
        $rateservices = $this->mastersmodel->getsearchdata($like,$where,'id,service_id','tb_rate_services');
        echo  json_encode($rateservices);
    }

    public function getrateservicelanes(){
        $service_id = $this->input->post('service_id');
        $rateservicelanes = $this->rateofferingmodel->getlanesbyratesrv($service_id);
        echo json_encode($rateservicelanes);
    }

    public function getcustomerpflist() {
        $result = array();
        $select = 'id,cust_profile_id,name,company_code,branch_code';
        $where = array('status'=>1,'company_code'=>$this->session->userdata('company_code'),'branch_code'=>$this->session->userdata('branch_code'));
        if($this->input->post('term')){
            $like['cust_profile_id'] = $this->input->post('term');
        } else {
            $like = array();
        }
        $chkqry = $this->mastersmodel->getsearchdata($like,$where,$select,'tb_customer_profile');
        /* log_message('error',$this->db->last_query()); */
        if (!empty($chkqry)) {
            foreach ($chkqry as $res) {
                $check    = "<input type='radio' name='listcustomerpf' id='listcustomerpf_" . $res['id'] . "' class='listcustomerpf' onchange='selectcustomerpf(" . $res['id'] . ")' value='" . $res['cust_profile_id'] . "'>";
                $result[] = array('check' => $check,'cust_profile_id'=> $res['cust_profile_id'],'name'=>$res['name'],'company_code' => $res['company_code'],'branch_code'=>$res['branch_code']);
            }
        }
        echo json_encode($result);
    }

    public function getvehiclepflist() {
        $result = array();
        $select = 'id,veh_profile_id,name,company_code,branch_code';
        $where = array('status'=>1,'company_code'=>$this->session->userdata('company_code'),'branch_code'=>$this->session->userdata('branch_code'));
        if($this->input->post('term')){
            $like['veh_profile_id'] = $this->input->post('term');
        } else {
            $like = array();
        }
        $chkqry = $this->mastersmodel->getsearchdata($like,$where,$select,'tb_vehicle_profile');
        if (!empty($chkqry)) {
            foreach ($chkqry as $res) {
                $check    = "<input type='radio' name='listvehiclepf' id='listvehiclepf_" . $res['id'] . "' class='listvehiclepf' onchange='selectvehiclepf(" . $res['id'] . ")' value='" . $res['veh_profile_id'] . "'>";
                $result[] = array('check' => $check,'veh_profile_id'=> $res['veh_profile_id'],'name'=>$res['name'],'company_code' => $res['company_code'],'branch_code'=>$res['branch_code']);
            }
        }
        echo json_encode($result);
    }

    public function getvendorpflist() {
        $result = array();
        $select = 'id,vend_profile_id,name,company_code,branch_code';
        $where = array('status'=>1,'company_code'=>$this->session->userdata('company_code'),'branch_code'=>$this->session->userdata('branch_code'));
        if($this->input->post('term')){
            $like['vend_profile_id'] = $this->input->post('term');
        } else {
            $like = array();
        }
        $chkqry = $this->mastersmodel->getsearchdata($like,$where,$select,'tb_vendor_profile');
        if (!empty($chkqry)) {
            foreach ($chkqry as $res) {
                $check    = "<input type='radio' name='listvendorpf' id='listvendorpf_" . $res['id'] . "' class='listvendorpf' onchange='selectvendorpf(" . $res['id'] . ")' value='" . $res['vend_profile_id'] . "'>";
                $result[] = array('check' => $check,'vend_profile_id'=> $res['vend_profile_id'],'name'=>$res['name'],'company_code' => $res['company_code'],'branch_code'=>$res['branch_code']);
            }
        }
        echo json_encode($result);
    }

    public function getcargopflist() {
        $result = array();
        $select = 'id,cargo_profile_id,name,company_code,branch_code';
        $where = array('status'=>1,'company_code'=>$this->session->userdata('company_code'),'branch_code'=>$this->session->userdata('branch_code'));
        if($this->input->post('term')){
            $like['cargo_profile_id'] = $this->input->post('term');
        } else {
            $like = array();
        }
        $chkqry = $this->mastersmodel->getsearchdata($like,$where,$select,'tb_cargo_profile');
        if (!empty($chkqry)) {
            foreach ($chkqry as $res) {
                $check    = "<input type='radio' name='listcargopf' id='listcargopf_" . $res['id'] . "' class='listcargopf' onchange='selectcargopf(" . $res['id'] . ")' value='" . $res['cargo_profile_id'] . "'>";
                $result[] = array('check' => $check,'cargo_profile_id'=> $res['cargo_profile_id'],'name'=>$res['name'],'company_code' => $res['company_code'],'branch_code'=>$res['branch_code']);
            }
        }
        echo json_encode($result);
    }

    public function uniqueofferingid(){
        $where =array('offering_id'=>$this->input->post('offering_id'));
        $offering_id = $this->common->gettblrowdata($where,'id','tb_rate_offerings',0,0)['id'];
        if($offering_id){
            echo 0;
        } else {
            echo 1;
        }
    }

    public function saveremarktype($id = null){
        $post = $_POST;
        $rmktype['name'] = $post['remark_type'];
        $rmktype['description'] = $post['description'];
        if($id == null){
            $rmktype['status'] = 1;
            $rmktype['created_on'] = date('Y-m-d H:i:s');
            $rmktype['updated_on'] = date('Y-m-d H:i:s');
            $rmktype['company_code'] = $this->session->userdata('company_code');
            $rmktype['branch_code'] = $this->session->userdata('branch_code');
            $rmktype['user_id'] = $this->session->userdata('user_id');
            $data['id'] = $this->common->insertTableData('tbl_remark_types',$rmktype);
            if(isset($post['rofrid'])){
                $remark['rateoffering_id'] = $post['rofrid'];
                $remark['status'] = 1;
                $remark['createdon'] = date('Y-m-d H:i:s');
                $remark['updatedon'] = date('Y-m-d H:i:s');
                $remark['remark_type'] = $data['id'];
                $this->common->insertTableData('tb_rateoffering_remarks',$remark);
            }
        } else {
            $this->common->updatetbledata('tbl_remark_types',$rmktype,array('id'=>$id));
            $data['id'] = $id;
        }
        echo json_encode($data);
    }

    public function getdoctypename(){
        $id = $this->input->post('id');
        $doctype = array();
        if(!empty($id)){
            $doctype = $this->common->gettblrowdata(array('id'=>$id),'type_name as document_name','tb_document_types',0,0);
        }
        echo json_encode( $doctype);
    }

    public function getvasname(){
        $id = $this->input->post('id');
        $doctype = array();
        if(!empty($id)){
            $vas = $this->common->gettblrowdata(array('id'=>$id),'vas_name','tb_vas_master',0,0);
        }
        echo json_encode( $vas);
    }

    public function showremarktypes(){
        $remarktypes  = array();
        $ids     = isset($_POST['rmktype_list']) ? $_POST['rmktype_list'] : "";
        if ($ids != "") {
            $rmktype_ids = implode(',', $ids);
            if (!empty($rmktype_ids)) {
                $rmktypes = $this->rateofferingmodel->remarktypes($ids);
                foreach($rmktypes as $type){
                    $remark_type = '"'.$type['name'].'"';
                    $desc = '"'.$type['description'].'"';
                    $type['action'] = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowrmktypeEdit(this," . $type['id'] . "," . $remark_type . "," .$desc.");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowrmktypeElim(this," . $type['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowRemAdd(this);'><span class='glyphicon glyphicon-plus' > </span>".$this->lang->line('add_remark')."</a></li>";
                    $remarktypes[] = $type;
                }
            }
        }
        echo json_encode( $remarktypes);
    }

    public function getremarktypes(){
        $remarktypes  = array();
        $rofrid     = isset($_POST['rofrid']) ? $_POST['rofrid'] : "";
        if ($rofrid != "") {
            $rmktypes = $this->rateofferingmodel->remarktypesbyid($rofrid);
            foreach($rmktypes as $type){
                $remark_type = '"'.$type['name'].'"';
                $desc = '"'.$type['description'].'"';
                $type['action'] = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowrmktypeEdit(this," . $type['id'] . "," . $remark_type . "," .$desc.");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowrmktypeElim(this," . $type['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowRemAdd(this);'><span class='glyphicon glyphicon-plus' > </span>".$this->lang->line('add_remark')."</a></li>";
                $remarktypes[] = $type;
            }
        }
        echo json_encode( $remarktypes);
    }

    public function savedoc($id = null){
        $post = $_POST;
        $fileName = '';
        //$doc['document'] = $post['document'];
        $doc['document_id'] = $post['doc_id'];
        if (isset($_FILES)) {
            if (isset($_FILES['document']['name'])) {
                $config = array('upload_path'   => './assets/ratedocuments/',
                    'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG'
                    );
                $file_name = $_FILES['document']['name'];
                $file_ext= @strtolower(end(explode('.',$_FILES['document']['name'])));
                $expensions= array("jpeg","jpg","png","gif","pdf");
                if(in_array($file_ext,$expensions)){
                    $imgtype = "pdf";
                   // $config['file_name'] = "RL".$order_number.".pdf";
                    $this->load->library('upload', $config);
                    if ($this->upload->do_upload('document')) {
                        $imgname = $this->upload->data();
                        $fileName = $imgname['file_name'];
                    } else {
                        $data['upload_error'] = $this->upload->display_errors();
                    }
                }
            }
        }

        if($id == null){
            if(isset($post['rofrid'])){
                $doc['rateoffering_id'] = $post['rofrid'];
            } else {
                $doc['rateoffering_id'] = 0;
            }
            $doc['document'] = $fileName;
            $doc['status'] = 1;
            $doc['createdon'] = !empty($post['created_date'])?date('Y-m-d H:i:s',strtotime($post['created_date'])):date('Y-m-d H:i:s');
            $doc['updatedon'] = date('Y-m-d H:i:s');
            $data['id'] = $this->common->insertTableData('tb_rateoffering_docs',$doc);
        } else {
            $doc['updatedon'] = date('Y-m-d H:i:s');
            $this->common->updatetbledata('tb_rateoffering_docs',$doc,array('id'=>$id));
            $data['id'] = $id;
        }
        echo json_encode($data['id']);
    }

    public function showdocs(){
        $docs  = array();
        $ids     = isset($_POST['doc_list']) ? $_POST['doc_list'] : "";
        if ($ids != "") {
            $doclist = $this->rateofferingmodel->documentlist($ids);
            foreach($doclist as $doc){
                $doc['createdon'] = date('d-m-Y',strtotime($doc['createdon']));
                $docdt = '"'.$doc['createdon'].'"';
                $docid = '"'.$doc['documentid'].'"';
                $name = '"'.$doc['document_name'].'"';
                $document = '"'.$doc['document'].'"';
                $doctype = explode('.',$doc['document'])[1];
                $doclink = base_url('assets/ratedocuments/'.$doc['document']);
                if($doctype == 'pdf'){
                    $doc['document'] = '<a href="'.$doclink.'" target="_blank"><img name="doc" src="'.$doclink.'" style="height:40px" /></a>';
                  } else {
                    $doc['document'] = '<img name="doc" src="'.$doclink.'" style="height:40px" />';
                  }
                $doc['action'] = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li style='display:none;'><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowdocEdit(this," . $doc['id'] .",".$doc['document_id']. "," . $name . "," .$document.",".$docdt.");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowdocElim(this," . $doc['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowDocAdd(this);'><span class='glyphicon glyphicon-plus' > </span>".$this->lang->line('add_doc')."</a></li>";
                $docs[] = $doc;
            }
        }
        echo json_encode( $docs);
    }

    public function getdocs(){
        $docs  = array();
        $rofrid     = isset($_POST['rofrid']) ? $_POST['rofrid'] : "";
        if ($rofrid != "") {
            $doclist = $this->rateofferingmodel->documentlistbyid($rofrid);
            foreach($doclist as $doc){
                $doc['createdon'] = date('d-m-Y',strtotime($doc['createdon']));
                $docdt = '"'.$doc['createdon'].'"';
                $docid = '"'.$doc['documentid'].'"';
                $name = '"'.$doc['document_name'].'"';
                $document = '"'.$doc['document'].'"';
                $doctype = explode('.',$doc['document'])[1];
                $doclink = base_url('assets/ratedocuments/'.$doc['document']);
                if($doctype == 'pdf'){
                 $doc['document'] = '<a href="'.$doclink.'" target="_blank"><img name="doc" src="'.$doclink.'" style="height:40px" /></a>';
               } else {
               $doc['document'] = '<img name="doc" src="'.$doclink.'" style="height:40px" />';
               }
                $doc['action'] = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li style='display:none;'><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowdocEdit(this," . $doc['id'] .",".$doc['document_id']. "," . $name . "," .$document.",".$docdt.");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowdocElim(this," . $doc['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowDocAdd(this);'><span class='glyphicon glyphicon-plus' > </span>".$this->lang->line('add_doc')."</a></li>";
                $docs[] = $doc;
            }
        }
        echo json_encode( $docs);
    }

    public function saveservice($id = null){
        $post = $_POST;
        $service['min_amount'] = !empty($post['min_amount'])?$post['min_amount']:0;
        $service['amount'] = !empty($post['amount'])?$post['amount']:0;
        $service['currency'] = $post['currency'];
        $service['charge_basis'] = $post['charge_basis'];
        $service['ro_charge_id'] = $post['charge_id'];
        $service['ro_vas_id'] = $post['vas_id'];
        if($id == null){
            if(isset($post['rofrid'])){
                $service['rateoffering_id'] = $post['rofrid'];
            } else {
                $service['rateoffering_id'] = 0;
            }
            $service['status'] = 1;
            $service['createdon'] = date('Y-m-d H:i:s');
            $service['updatedon'] = date('Y-m-d H:i:s');
            $data['id'] = $this->common->insertTableData('tb_rateoffering_services',$service);
        } else {
            $service['updatedon'] = date('Y-m-d H:i:s');
            $this->common->updatetbledata('tb_rateoffering_services',$service,array('id'=>$id));
            $data['id'] = $id;
        }
        echo json_encode($data);
    }

    public function showservices(){
        $services  = array();
        $ids     = isset($_POST['services_list']) ? $_POST['services_list'] : "";
        if ($ids != "") {
            $servicelist = $this->rateofferingmodel->vaslist($ids);
            foreach($servicelist as $service){
                $vasname = '"'.$service['vas_name'].'"';
                $currency = '"'.$service['currency'].'"';
                $chargebasis = '"'.$service['charge_basis'].'"';
                $service['action'] = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowvasEdit(this," . $service['id'] .",".$service['ro_vas_id'].",".$vasname. "," . $service['ro_charge_id'] . "," .$chargebasis.",".$service['min_amount'].",".$service['amount'].",".$currency.");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowvasElim(this," . $service['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>".$this->lang->line('add_vas')."</a></li>";
                $services[] = $service;
            }
        }
        echo json_encode( $services);
    }

    public function getservices(){
        $services  = array();
        $rofrid     = isset($_POST['rofrid']) ? $_POST['rofrid'] : "";
        if ($rofrid != "") {
            $servicelist = $this->rateofferingmodel->vaslistbyid($rofrid);
            foreach($servicelist as $service){
                $vasname = '"'.$service['vas_name'].'"';
                $currency = '"'.$service['currency'].'"';
                $chargebasis = '"'.$service['charge_basis'].'"';
                $service['action'] = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowvasEdit(this," . $service['id'] .",".$service['ro_vas_id'].",".$vasname. "," . $service['ro_charge_id'] . "," .$chargebasis.",".$service['min_amount'].",".$service['amount'].",".$currency.");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowvasElim(this," . $service['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>".$this->lang->line('add_vas')."</a></li>";
                $services[] = $service;
            }
        }
        echo json_encode( $services);
    }

    public function deleteservice(){
        $id = $this->input->post('id');
        $this->common->updatetbledata('tb_rateoffering_services', array('status'=>0), array('id'=>$id));
        echo 'success';
    }

    public function deletedoc(){
        $id = $this->input->post('id');
        $this->common->updatetbledata('tb_rateoffering_docs', array('status'=>0), array('id'=>$id));
        echo 'success';
    }

    public function deletermktype(){
        $id = $this->input->post('id');
        $this->common->updatetbledata('tb_rateoffering_remarks', array('status'=>0), array('id'=>$id));
        echo 'success';
    }

    public function conversionlist(){
        $type = $this->input->post('type');
        $conversionlist = $this->common->gettbldata(array('type'=>$type,'status'=>1),'id,conversion_id,name','tb_knuom_conversion',0,0);
        echo json_encode( $conversionlist);
    }

    public function deletebulkrecords(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $ids = $this->input->post('deleteids');
            $result = true;
            foreach ($ids as $id) {
                $this->db->where('id', $id);
                $this->db->set('status', 0);
                $result = $this->db->update('tb_rate_offerings');
                if (!$result) {
                    $result = false;
                }
            }
            echo $result ? "success" : "failed";
        }
    }

    public function getDataFromProfiles(): void
    {
        $data = [];
        $postData = $this->input->post(null, true);
        $profileType = $data['profileType'] = $postData['type'] ?? "";
        $profileId = $postData['profileId'] ?? "";
        if ($profileType == "Vehicle Type") {
            $getProfileId = $this->common->gettblrowdata(['veh_profile_id' => $profileId], "id", "tb_vehicle_profile", 0, 0);
            $profileRowId = $getProfileId['id'] ?? 0;
            if ($profileRowId > 0) {
                $getVehicleProfileList = $this->rateofferingmodel->getVehicleProfilesListById($profileRowId);
                $data['headers'] = ['Truck Type', 'Description', 'Icon Image'];
                foreach ($getVehicleProfileList as $eachLine) {
                    $data['body'][] = ['truckType' => $eachLine['trucktype'], 'descrption' => $eachLine['description'], 'iconimg' => $eachLine['iconimg']];
                }
            }
        } elseif ($profileType == "Vendor") {
            $getProfileId = $this->common->gettblrowdata(['vend_profile_id' => $profileId], "id", "tb_vendor_profile", 0, 0);
            $profileRowId = $getProfileId['id'] ?? 0;
            if ($profileRowId > 0) {
                $getVendorProfileList = $this->rateofferingmodel->getVendorProfilesListById($profileRowId);
                $data['headers'] = ['Name', 'Code', 'Address', 'Mobile Number', 'Company Code', 'Branch Code'];
                foreach ($getVendorProfileList as $eachLine) {
                    $address = $eachLine['location'] . " , " . $eachLine['country'] . " , " . $eachLine['pincode'];
                    $data['body'][] = ['name' => $eachLine['name'], 'address' => $address, 'code' => $eachLine['code'], 'mobile' => $eachLine['mobile'], 'companyCode' => $eachLine['company_code'], 'branchCode' => $eachLine['branch_code']];
                }
            }
        } elseif ($profileType == "Customer") {
            $getProfileId = $this->common->gettblrowdata(['cust_profile_id' => $profileId], "id", "tb_customer_profile", 0, 0);
            $profileRowId = $getProfileId['id'] ?? 0;
            if ($profileRowId > 0) {
                $getCustomerProfileList = $this->rateofferingmodel->getCustomerProfilesListById($profileRowId);
                $data['headers'] = ['Name', 'Code', 'Address', 'Mobile Number', 'Company Code', 'Branch Code'];
                foreach ($getCustomerProfileList as $eachLine) {
                    $address = $eachLine['location'] . " , " . $eachLine['country'] . " , " . $eachLine['pincode'];
                    $data['body'][] = ['name' => $eachLine['name'], 'address' => $address, 'code' => $eachLine['code'], 'mobile' => $eachLine['phone'], 'companyCode' => $eachLine['company_code'], 'branchCode' => $eachLine['branch_code']];
                }
            }
        }
        echo $this->load->view('rateoffering/profilePopup', $data, true);
    }

 }
