<?php if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Ratepreference extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if (! $this->session->userdata('user_id')) {
            redirect('login');
        }
        $this->load->library('form_validation');
        $this->load->model('common');
        $this->load->model('mastersmodel');
        $this->load->model('rateprefermodel');
        $this->load->model('rateofferingmodel');
        if (! checkUrlAccessForUser('RATEPREFERENCE')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $data['page_title'] = $this->lang->line('ratepreference');
        $data['sub_title']  = $this->lang->line('ratepreference');
        $allwhere           = ['status' => 1];
        $user_id            = $this->session->userdata('user_id');
        $company_code       = $this->session->userdata('company_code');
        $where              = ['rp.status' => 1, 'rp.user_id' => $this->session->userdata('user_id')];
        if ($company_code == "RUKN") {
            $where = ['rp.status' => 1, 'rp.user_id' => $user_id];
        } else {
            $where = ['rp.status' => 1, 'rp.company_code' => $company_code];
        }
        $data['reftypes']      = $this->common->gettbldata(['status' => 1], 'id,name,description', 'tb_reference_master', 0, 0);
        $data['ordertypes']    = $this->common->gettbldata($allwhere, 'id,type_name,description', 'tb_order_types', 0, 0);
        $data['servicemaster'] = $this->common->gettbldata($allwhere, 'id,service_id', 'tb_service_master', 0, 0);
        $data['productmaster'] = $this->common->gettbldata($allwhere, 'id,name', 'tb_products_master', 0, 0);
        if ($this->input->post('rateprefer_id', true)) {
            $where['rp.rate_prefer_id'] = $this->input->post('rateprefer_id', true);
        }
        if ($this->input->post('advrateprefer_id', true)) {
            $where['rp.rate_prefer_id'] = $this->input->post('advrateprefer_id', true);
        }
        if ($this->input->post('rateprefer_name', true)) {
            $where['rp.rate_prefer_name'] = $this->input->post('rateprefer_name', true);
        }
        if ($this->input->post('advrateprefer_name', true)) {
            $where['rp.rate_prefer_name'] = $this->input->post('advrateprefer_name', true);
        }
        if ($this->input->post('cust_profile_id', true)) {
            $where['cp.cust_profile_id'] = $this->input->post('cust_profile_id', true);
        }
        if ($this->input->post('vend_profile_id', true)) {
            $where['vp.vend_profile_id'] = $this->input->post('vend_profile_id', true);
        }
        if ($this->input->post('from_date', true) != '' && $this->input->post('to_date', true) != '') {
            $from_date = date('Y-m-d', strtotime($this->input->post('from_date', true)));
            $to_date   = date('Y-m-d', strtotime($this->input->post('to_date', true) . ' +1 day '));
        } else {
            $from_date = null;
            $to_date   = null;
        }
        if ($this->input->post('cust_profile_id', true)) {
            $custpfid = $this->common->gettblrowdata(['cust_profile_id' => $this->input->post('cust_profile_id', true)], 'id', 'tb_customer_profile', 0, 0);
            if ($custpfid) {
                $where['rp.cust_profile_id'] = $custpfid['id'];
            }
        }
        if ($this->input->post('vendor_profile_id', true)) {
            $vendpfid = $this->common->gettblrowdata(['vend_profile_id' => $this->input->post('vend_profile_id', true)], 'id', 'tb_vendor_profile', 0, 0);
            if ($vendpfid) {
                $where['rp.vend_profile_id'] = $vendpfid['id'];
            }
        }
        $tbwhere = [];
        if ($this->input->post('order_type', true)) {
            $tbwhere['order_type'] = $this->input->post('order_type', true);
        }
        if ($this->input->post('reference_type', true)) {
            $tbwhere['ref_type'] = $this->input->post('reference_type', true);
        }
        if ($this->input->post('reference_type_value', true)) {
            $tbwhere['ref_value'] = $this->input->post('reference_type_value', true);
        }
        if ($this->input->post('product', true)) {
            $tbwhere['product'] = $this->input->post('product', true);
        }
        if ($this->input->post('service', true)) {
            $tbwhere['service'] = $this->input->post('service', true);
        }

        //print_r($where); exit;
        $data['ratepreferlist'] = $this->rateprefermodel->ratepreferlist($where, $tbwhere, $from_date, $to_date);
        $this->newtemplate->dashboard("ratepreference/index", $data);
    }

    public function add()
    {
        $data['page_title'] = $this->lang->line('ratepreference');
        $data['sub_title']  = $this->lang->line('ratepreference');
        $userid             = $this->session->userdata('user_id');
        $allwhere           = ['status' => 1,
            'company_code'                  => $this->session->userdata('company_code'),
            'branch_code'                   => $this->session->userdata('branch_code'),
        ];
        $data['countries']     = $this->common->gettbldata(['status' => 1], 'country_code,country_name', 'tbl_country_master', 0, 0);
        $data['reftypes']      = $this->common->gettbldata(['status' => 1], 'id,name,description', 'tb_reference_master', 0, 0);
        $data['ordertypes']    = getOrderTypes(0, $this->session->userdata('company_code'));
        $data['servicemaster'] = getServiceMasterData();
        $data['productmaster'] = getProductMasterData();
        $data['rservices']     = $this->common->gettbldata($allwhere, 'id,service_id,service_name', 'tb_rate_services', 0, 0);
        $post                  = $this->input->post(null, true);
        if (count($post) > 0) {
            $custpfid                = $this->common->gettblrowdata(['cust_profile_id' => $post['customer_profile_id']], 'id', 'tb_customer_profile', 0, 0);
            $vendpfid                = $this->common->gettblrowdata(['vend_profile_id' => $post['vendor_profile_id']], 'id', 'tb_vendor_profile', 0, 0);
            $rateofr                 = $this->common->gettblrowdata(['id' => $post['rate_offering_id']], 'tarrif_type', 'tb_rate_offerings', 0, 0);
            $rate_preference_id      = $this->genrpid();
            $prf['cust_profile_id']  = ($post['customer_profile_id']) ? $custpfid['id'] : 0;
            $prf['vend_profile_id']  = ($post['vendor_profile_id']) ? $vendpfid['id'] : 0;
            $prf['rate_prefer_id']   = $rate_preference_id;
            $prf['rate_prefer_name'] = $post['rate_prefer_name'];
            $prf['rate_service_id']  = $post['rate_service_id'];
            $prf['rate_offering_id'] = $post['rate_offering_id'];
            $prf['rate_record_id']   = $post['rate_record_id'];
            $prf['tariff_type']      = $post['tariff_type'];
            $prf['company_code']     = $post['company_code'];
            $prf['branch_code']      = $post['branch_code'];
            $prf['auto_bill']        = isset($post['auto_bill']) ? $post['auto_bill'] : 0;
            $prf['department_code']  = ($post['department_code']) ? $post['department_code'] : '';
            $prf['user_id']          = $this->session->userdata('user_id');
            $prf['status']           = 1;
            $prf['createdon']        = $prf['updatedon']        = date('Y-m-d H:i:s');
            $rpreid                  = $this->common->insertTableData('tb_rate_preferences', $prf);
            /* Update all tables with rate pref ID */
            $source_ids  = explode(',', $post['source_ids']);
            $dest_ids    = explode(',', $post['dest_ids']);
            $reftype_ids = explode(',', $post['reftype_ids']);
            $ordtype_ids = explode(',', $post['ordtype_ids']);
            $service_ids = explode(',', $post['service_ids']);
            $product_ids = explode(',', $post['product_ids']);
            $updatedata  = ['rate_prefer_id' => $rpreid];
            $this->rateofferingmodel->updaterofrmodule('tb_rateprefer_source', $updatedata, $source_ids);
            $this->rateofferingmodel->updaterofrmodule('tb_rateprefer_destination', $updatedata, $dest_ids);
            $this->rateofferingmodel->updaterofrmodule('tb_rateprefer_ref_types', $updatedata, $reftype_ids);
            $this->rateofferingmodel->updaterofrmodule('tb_rateprefer_ordertypes', $updatedata, $ordtype_ids);
            $this->rateofferingmodel->updaterofrmodule('tb_rateprefer_service', $updatedata, $service_ids);
            $this->rateofferingmodel->updaterofrmodule('tb_rateprefer_product', $updatedata, $product_ids);
            redirect('ratepreference');
        } else {
            //$this->newtemplate->dashboard("ratepreference/add", $data);
            $this->load->view("ratepreference/add", $data);
        }
    }

    public function edit($id)
    {
        $data['page_title'] = $this->lang->line('ratepreference');
        $data['sub_title']  = $this->lang->line('ratepreference');
        $userid             = $this->session->userdata('user_id');
        $data['rateprefer'] = $this->rateprefermodel->ratepreference($id);
        if ($data['rateprefer']) {
            $allwhere = ['status' => 1,
                'company_code'        => $this->session->userdata('company_code'),
                'branch_code'         => $this->session->userdata('branch_code'),
            ];
            $data['countries'] = $this->common->gettbldata(['status' => 1], 'country_code,country_name', 'tbl_country_master', 0, 0);
            $data['reftypes']  = $this->common->gettbldata(['status' => 1], 'id,name,description', 'tb_reference_master', 0, 0);
            /* $data['ordertypes'] = $this->common->gettbldata($allwhere,'id,type_name,description','tb_order_types',0,0);
        if(count($data['ordertypes']) > 0){
             $data['ordertypes'] = $this->common->gettbldata(array('status'=>1,'company_code','branch_code'=>'SGTGA'),'id,type_name,description','tb_order_types',0,0);
        } */
            $data['ordertypes']    = getOrderTypes(0, $this->session->userdata('company_code'));
            $data['servicemaster'] = getServiceMasterData();
            $data['productmaster'] = getProductMasterData();
            $data['rservices']     = $this->common->gettbldata($allwhere, 'id,service_id,service_name', 'tb_rate_services', 0, 0);
            $company_code          = $this->session->userdata('company_code');
            $user_id               = $this->session->userdata('user_id');
            if ($company_code == "RUKN") {
                $data['rofferings'] = $this->common->gettbldata(['rate_service_id' => $data['rateprefer']['rate_service_id'], 'status' => 1, 'company_code' => $company_code], 'id,offering_id,offering_name', 'tb_rate_offerings', 0, 0);
                $data['rrecords']   = $this->common->gettbldata(['offering_id' => $data['rateprefer']['rate_offering_id'], 'status' => 1, 'company_code' => $company_code], 'id,rate_id,record_name', 'tb_rate_records', 0, 0);
            } else {
                $data['rofferings'] = $this->common->gettbldata(['rate_service_id' => $data['rateprefer']['rate_service_id'], 'status' => 1, 'user_id' => $user_id], 'id,offering_id,offering_name', 'tb_rate_offerings', 0, 0);
                $data['rrecords']   = $this->common->gettbldata(['offering_id' => $data['rateprefer']['rate_offering_id'], 'status' => 1, 'user_id' => $user_id], 'id,rate_id,record_name', 'tb_rate_records', 0, 0);
            }
            $post = $this->input->post(null, true);
            if (count($post) > 0) {
                $custpfid = $this->common->gettblrowdata(['cust_profile_id' => $post['customer_profile_id']], 'id', 'tb_customer_profile', 0, 0);
                $vendpfid = $this->common->gettblrowdata(['vend_profile_id' => $post['vendor_profile_id']], 'id', 'tb_vendor_profile', 0, 0);
                $rateofr  = $this->common->gettblrowdata(['id' => $post['rate_offering_id']], 'tarrif_type', 'tb_rate_offerings', 0, 0);

                $prf['cust_profile_id']  = $post['customer_profile_id'] ? (isset($custpfid['id']) ? $custpfid['id'] : 0) : 0;
                $prf['vend_profile_id']  = $post['vendor_profile_id'] ? (isset($vendpfid['id']) ? $vendpfid['id'] : 0) : 0;
                $prf['rate_prefer_name'] = $post['rate_prefer_name'];
                $prf['rate_service_id']  = $post['rate_service_id'];
                $prf['rate_offering_id'] = $post['rate_offering_id'];
                $prf['tariff_type']      = $post['tariff_type'];
                $prf['rate_record_id']   = $post['rate_record_id'];
                /* $prf['tariff_type'] = $post['tariff_type'];*/
                $prf['auto_bill']       = isset($post['auto_bill']) ? $post['auto_bill'] : 0;
                $prf['company_code']    = $post['company_code'];
                $prf['branch_code']     = $post['branch_code'];
                $prf['department_code'] = ($post['department_code']) ? $post['department_code'] : '';
                $prf['updatedon']       = date('Y-m-d H:i:s');
                $rpreid                 = $this->common->updatetbledata('tb_rate_preferences', $prf, ['id' => $id]);
                redirect('ratepreference');
            } else {
                //$this->newtemplate->dashboard("ratepreference/edit", $data);
                $this->load->view("ratepreference/edit", $data);
            }
        } else {
            redirect('ratepreference/add');
        }
    }

    public function view($id)
    {
        $data['page_title'] = $this->lang->line('ratepreference');
        $data['sub_title']  = $this->lang->line('ratepreference');
        $userid             = $this->session->userdata('user_id');
        $data['rateprefer'] = $this->rateprefermodel->getRatePrefenceDetails($id);
        if ($data['rateprefer']) {
            //$this->newtemplate->dashboard("ratepreference/view", $data);
            $this->load->view("ratepreference/view", $data);
        } else {
            redirect('ratepreference/add');
        }
    }

    public function deleteratepreference($id)
    {
        if ($id != '' || $id != 0) {
            $chk = $this->common->gettblrowdata(['id' => $id], 'status', 'tb_rate_preferences', 0, 0);
            if ($chk) {
                $upd = $this->common->updatetbledata('tb_rate_preferences', ['status' => 0], ['id' => $id]);
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        }
    }

    public function getratepreferid()
    {
        $result       = [];
        $user_id      = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        if ($company_code == "RUKN") {
            $where['company_code'] = $company_code;
        } else {
            $where['user_id'] = $user_id;
        }
        $where['status']        = 1;
        $like['rate_prefer_id'] = $this->input->post('term', true);
        $result                 = $this->mastersmodel->getsearchdata($like, $where, 'id,rate_prefer_id', 'tb_rate_preferences');
        echo json_encode($result);
    }

    public function genrpid()
    {
        $year     = date('y');
        $week     = date('W');
        $lane_res = $this->db->query("SELECT rate_prefer_id FROM tb_rate_preferences ORDER BY id DESC LIMIT 1");
        if ($lane_res->num_rows() > 0) {
            $get_rpid   = $lane_res->row()->rate_prefer_id;
            $get_rpid_c = strlen($get_rpid);
            if ($get_rpid_c > 7) {
                $previous_weeknumber = substr($get_rpid, 4, 2);
                $get_rpid1           = substr($get_rpid, 6);
                $get_rpid2           = ltrim($get_rpid1, 0);
                if ($previous_weeknumber < $week) {
                    $id1 = '0001';
                } else {
                    $i_id = $get_rpid2;
                    $i_id++;
                    $idlength = strlen($i_id);
                    if ($idlength == '1') {
                        $id1 = "000" . $i_id;
                    } else if ($idlength == '2') {
                        $id1 = "00" . $i_id;
                    } else if ($idlength == '3') {
                        $id1 = "0" . $i_id;
                    } else if ($idlength == '4') {
                        $id1 = $i_id;
                    } else {
                        $id1 = $i_id;
                    }
                }
            } else {
                $id1 = '0001';
            }

            $rp_id = "RP" . $year . $week . $id1;
            $chk   = $this->db->query("select rate_prefer_id FROM tb_rate_preferences WHERE rate_prefer_id='" . $rp_id . "'");
            if ($chk->num_rows() > 0) {
                $iid = $id1;
                $iid++;
                $ii_d      = $iid;
                $id_length = strlen($iid);
                if ($id_length == '1') {
                    $ii_d = "000" . $iid;
                } else if ($id_length == '2') {
                    $ii_d = "00" . $iid;
                } else if ($id_length == '3') {
                    $ii_d = "0" . $iid;
                } else if ($id_length == '4') {
                    $ii_d = $iid;
                } else {
                    $ii_d = $iid;
                }
                $rp_id = "RP" . $year . $week . $ii_d;
            } else {
                $rp_id = $rp_id;
            }
        } else {
            $i_id  = 1;
            $id1   = '000' . $i_id;
            $rp_id = "RO" . $year . $week . $id1;
        }

        return $rp_id;
    }

    public function savesource($id = null)
    {
        $post   = $this->input->post(null, true);
        $userid = $this->session->userdata('user_id');
        if (! empty($post['shipper'])) {
            $party_id = $this->common->gettblrowdata(['code' => $post['shipper']], 'id', 'tbl_party_master', 0, 0);
        } else {
            $party_id['id'] = 0;
        }
        $source['party_id'] = $party_id['id'] ?? 0;
        $source['country']  = ($post['srccountry']) ? $post['srccountry'] : '';
        $source['state']    = ($post['srcprovince']) ? $post['srcprovince'] : '';
        $source['city']     = ($post['srccity']) ? $post['srccity'] : '';
        $source['pincode']  = ($post['srcpostalcode']) ? $post['srcpostalcode'] : '';
        if ($id == null) {
            if (isset($post['rprefid'])) {
                $source['rate_prefer_id'] = $post['rprefid'];
            } else {
                $source['rate_prefer_id'] = 0;
            }
            $source['user_id']   = $userid;
            $source['status']    = 1;
            $source['createdon'] = date('Y-m-d H:i:s');
            $source['updatedon'] = date('Y-m-d H:i:s');
            $data['id']          = $this->common->insertTableData('tb_rateprefer_source', $source);
        } else {
            $source['updatedon'] = date('Y-m-d H:i:s');
            $this->common->updatetbledata('tb_rateprefer_source', $source, ['id' => $id]);
            $data['id'] = $id;
        }
        echo json_encode($data);
    }

    public function showsourcelist()
    {
        $sourcelist = [];
        $post       = $this->input->post(null, true);
        $ids        = isset($post['source_list']) ? $post['source_list'] : "";
        if ($ids != "") {
            $srclist = $this->rateprefermodel->sourcelist($ids);
            foreach ($srclist as $src) {
                $src['party_id'] == ($src['party_id'] == 0) ? '' : $src['party_id'];
                $partyid       = '"' . $src['partyid'] . '"';
                $country       = '"' . $src['country'] . '"';
                $state         = '"' . $src['state'] . '"';
                $city          = '"' . $src['city'] . '"';
                $pincode       = '"' . $src['pincode'] . '"';
                $src['action'] = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowsrcEdit(this," . $src['id'] . "," . $src['party_id'] . "," . $partyid . "," . $country . "," . $state . "," . $city . "," . $pincode . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowsrcElim(this," . $src['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowSourceAdd(this);'><span class='glyphicon glyphicon-plus' > </span>" . $this->lang->line('add_source') . "</a></li>";
                $sourcelist[]  = $src;
            }
        }
        echo json_encode($sourcelist);
    }

    public function getsourcelist()
    {
        $sourcelist = [];
        $post       = $this->input->post(null, true);
        $rprefid    = isset($post['rprefid']) ? $post['rprefid'] : "";
        if ($rprefid != "") {
            $srclist = $this->rateprefermodel->sourcelistbyid($rprefid);
            foreach ($srclist as $src) {
                $src['party_id'] == ($src['party_id'] == 0) ? '' : $src['party_id'];
                $partyid       = '"' . $src['partyid'] . '"';
                $country       = '"' . $src['country'] . '"';
                $state         = '"' . $src['state'] . '"';
                $city          = '"' . $src['city'] . '"';
                $pincode       = '"' . $src['pincode'] . '"';
                $src['action'] = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowsrcEdit(this," . $src['id'] . "," . $src['party_id'] . "," . $partyid . "," . $country . "," . $state . "," . $city . "," . $pincode . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='removesource(" . $src['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowSourceAdd(this);'><span class='glyphicon glyphicon-plus' > </span>" . $this->lang->line('add_source') . "</a></li>";
                $sourcelist[]  = $src;
            }
        }
        echo json_encode($sourcelist);
    }

    public function deletepreferencedetails()
    {
        $tbl  = "";
        $post = $this->input->post(null, true);
        $type = isset($post['type']) ? $post['type'] : "";
        if ($type != "") {
            if ($type == 'source') {
                $tbl = "tb_rateprefer_source";
            }
            $id = isset($post['id']) ? $post['id'] : 0;
            if ($id == "") {
                $id = 0;
            }
            if ($tbl != "") {
                if ($id > 0) {
                    $upd = $this->common->updatetbledata($tbl, ['status' => '0'], ['id' => $id]);
                }
            }
        }
        echo json_encode($id);
    }

    public function savedestination($id = null)
    {
        $post   = $this->input->post(null, true);
        $userid = $this->session->userdata('user_id');
        if (! empty($post['consignee'])) {
            $party_id = $this->common->gettblrowdata(['code' => $post['consignee']], 'id', 'tbl_party_master', 0, 0);
        } else {
            $party_id['id'] = 0;
        }
        $dest['party_id'] = $party_id['id'] ?? 0;
        $dest['country']  = ($post['dstcountry']) ? $post['dstcountry'] : '';
        $dest['state']    = ($post['dstprovince']) ? $post['dstprovince'] : '';
        $dest['city']     = ($post['dstcity']) ? $post['dstcity'] : '';
        $dest['pincode']  = ($post['dstpostalcode']) ? $post['dstpostalcode'] : '';
        if ($id == null) {
            if (isset($post['rprefid'])) {
                $dest['rate_prefer_id'] = $post['rprefid'];
            } else {
                $dest['rate_prefer_id'] = 0;
            }
            $dest['user_id']   = $userid;
            $dest['status']    = 1;
            $dest['createdon'] = date('Y-m-d H:i:s');
            $dest['updatedon'] = date('Y-m-d H:i:s');
            $data['id']        = $this->common->insertTableData('tb_rateprefer_destination', $dest);
        } else {
            $dest['updatedon'] = date('Y-m-d H:i:s');
            $this->common->updatetbledata('tb_rateprefer_destination', $dest, ['id' => $id]);
            $data['id'] = $id;
        }
        echo json_encode($data);
    }

    public function showdestlist()
    {
        $destlist = [];
        $post     = $this->input->post(null, true);
        $ids      = isset($post['dest_list']) ? $post['dest_list'] : "";
        if ($ids != "") {
            $list = $this->rateprefermodel->destlist($ids);
            foreach ($list as $dest) {
                $dest['party_id'] == ($dest['party_id'] == 0) ? '' : $dest['party_id'];
                $partyid        = '"' . $dest['partyid'] . '"';
                $country        = '"' . $dest['country'] . '"';
                $state          = '"' . $dest['state'] . '"';
                $city           = '"' . $dest['city'] . '"';
                $pincode        = '"' . $dest['pincode'] . '"';
                $dest['action'] = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowdestEdit(this," . $dest['id'] . "," . $dest['party_id'] . "," . $partyid . "," . $country . "," . $state . "," . $city . "," . $pincode . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowdestElim(this," . $dest['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowDestAdd(this);'><span class='glyphicon glyphicon-plus' > </span>" . $this->lang->line('add_destination') . "</a></li>";
                $destlist[]     = $dest;
            }
        }
        echo json_encode($destlist);
    }

    public function deletedestination()
    {
        $id = $this->input->post('id', true);
        $this->common->updatetbledata('tb_rateprefer_destination', ['status' => 0], ['id' => $id]);
        echo json_encode($id);
    }

    public function deletereftype()
    {
        $id = $this->input->post('id', true);
        $this->common->updatetbledata('tb_rateprefer_ref_types', ['status' => 0], ['id' => $id]);
        echo json_encode($id);
    }

    public function deleteordtype()
    {
        $id = $this->input->post('id', true);
        $this->common->updatetbledata('tb_rateprefer_ordertypes', ['status' => 0], ['id' => $id]);
        echo json_encode($id);
    }

    public function deleteservice()
    {
        $id = $this->input->post('id', true);
        $this->common->updatetbledata('tb_rateprefer_service', ['status' => 0], ['id' => $id]);
        echo json_encode($id);
    }

    public function deleteproduct()
    {
        $id = $this->input->post('id', true);
        $this->common->updatetbledata('tb_rateprefer_product', ['status' => 0], ['id' => $id]);
        echo json_encode($id);
    }

    public function getdestlist()
    {
        $destlist = [];
        $post     = $this->input->post(null, true);
        $rprefid  = isset($post['rprefid']) ? $post['rprefid'] : "";
        if ($rprefid != "") {
            $list = $this->rateprefermodel->destlistbyid($rprefid);
            foreach ($list as $dest) {
                $dest['party_id'] == ($dest['party_id'] == 0) ? '' : $dest['party_id'];
                $partyid        = '"' . $dest['partyid'] . '"';
                $country        = '"' . $dest['country'] . '"';
                $state          = '"' . $dest['state'] . '"';
                $city           = '"' . $dest['city'] . '"';
                $pincode        = '"' . $dest['pincode'] . '"';
                $dest['action'] = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowdestEdit(this," . $dest['id'] . "," . $dest['party_id'] . "," . $partyid . "," . $country . "," . $state . "," . $city . "," . $pincode . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowdestElim(this," . $dest['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowDestAdd(this);'><span class='glyphicon glyphicon-plus' > </span>" . $this->lang->line('add_destination') . "</a></li>";
                $destlist[]     = $dest;
            }
        }
        echo json_encode($destlist);
    }

    public function getrefname()
    {
        $refid   = $this->input->post('refid', true);
        $refdata = $this->common->gettblrowdata(['id' => $refid], 'name,description', 'tb_reference_master', 0, 0);
        echo json_encode($refdata);
    }

    public function getordtypename()
    {
        $ordtypeid   = $this->input->post('ordtypeid', true);
        $ordtypedata = $this->common->gettblrowdata(['id' => $ordtypeid], 'type_name,description', 'tb_order_types', 0, 0);
        echo json_encode($ordtypedata);
    }

    public function getservicemastername()
    {
        $id          = $this->input->post('service_id', true);
        $servicedata = $this->common->gettblrowdata(['id' => $id], 'name', 'tb_service_master', 0, 0);
        echo json_encode($servicedata);
    }

    public function getproductmastername()
    {
        $id          = $this->input->post('product_id', true);
        $productdata = $this->common->gettblrowdata(['id' => $id], 'name', 'tb_products_master', 0, 0);
        echo json_encode($productdata);
    }

    public function savereftype($id = null)
    {
        $post                 = $this->input->post(null, true);
        $userid               = $this->session->userdata('user_id');
        $ref['ref_id']        = $post['reference_type_id'];
        $ref['ref_value']     = $post['ref_val'];
        $ref['ref_condition'] = $post['condition'];
        if ($id == null) {
            if (isset($post['rprefid'])) {
                $ref['rate_prefer_id'] = $post['rprefid'];
            } else {
                $ref['rate_prefer_id'] = 0;
            }
            $ref['user_id']   = $userid;
            $ref['status']    = 1;
            $ref['createdon'] = date('Y-m-d H:i:s');
            $ref['updatedon'] = date('Y-m-d H:i:s');
            $data['id']       = $this->common->insertTableData('tb_rateprefer_ref_types', $ref);
        } else {
            $ref['updatedon'] = date('Y-m-d H:i:s');
            $this->common->updatetbledata('tb_rateprefer_ref_types', $ref, ['id' => $id]);
            $data['id'] = $id;
        }
        echo json_encode($data);
    }

    public function showreftypelist()
    {
        $reftypelist = [];
        $post        = $this->input->post(null, true);
        $ids         = isset($post['reftype_list']) ? $post['reftype_list'] : "";
        if ($ids != "") {
            $list = $this->rateprefermodel->reftypelist($ids);
            foreach ($list as $li) {
                $info          = ['id' => $li['id'], 'ref_id' => $li['ref_id'], 'refname' => '', 'value' => htmlentities($li['ref_value'], ENT_QUOTES), 'condition' => $li['ref_condition']];
                $info          = htmlentities(json_encode($info));
                $li['action']  = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowrefEdit(this," . $li['id'] . "," . $info . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowrefElim(this," . $li['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowRefAdd(this);'><span class='glyphicon glyphicon-plus' > </span>" . $this->lang->line('add_reference_type') . "</a></li>";
                $reftypelist[] = $li;
            }
        }
        echo json_encode($reftypelist);
    }

    public function getreftypelist()
    {
        $reftypelist = [];
        $post        = $this->input->post(null, true);
        $rprefid     = isset($post['rprefid']) ? $post['rprefid'] : "";
        if ($rprefid != "") {
            $list = $this->rateprefermodel->reftypelistbyid($rprefid);
            foreach ($list as $li) {
                $info          = ['id' => $li['id'], 'ref_id' => $li['ref_id'], 'refname' => '', 'value' => htmlentities($li['ref_value'], ENT_QUOTES), 'condition' => $li['ref_condition']];
                $info          = htmlentities(json_encode($info));
                $li['action']  = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowrefEdit(this," . $li['id'] . "," . $info . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowrefElim(this," . $li['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowRefAdd(this);'><span class='glyphicon glyphicon-plus' > </span>" . $this->lang->line('add_reference_type') . "</a></li>";
                $reftypelist[] = $li;
            }
        }
        echo json_encode($reftypelist);
    }

    public function saveordtype($id = null)
    {
        $post                 = $this->input->post(null, true);
        $userid               = $this->session->userdata('user_id');
        $ord['order_type_id'] = $post['order_type_id'];
        if ($id == null) {
            if (isset($post['rprefid'])) {
                $ord['rate_prefer_id'] = $post['rprefid'];
            } else {
                $ord['rate_prefer_id'] = 0;
            }
            $ord['user_id']   = $userid;
            $ord['status']    = 1;
            $ord['createdon'] = date('Y-m-d H:i:s');
            $ord['updatedon'] = date('Y-m-d H:i:s');
            $data['id']       = $this->common->insertTableData('tb_rateprefer_ordertypes', $ord);
        } else {
            $ord['updatedon'] = date('Y-m-d H:i:s');
            $this->common->updatetbledata('tb_rateprefer_ordertypes', $ord, ['id' => $id]);
            $data['id'] = $id;
        }
        echo json_encode($data);
    }

    public function showordtypelist()
    {
        $ordtypelist = [];
        $post        = $this->input->post(null, true);
        $ids         = isset($_POST['ordtype_list']) ? $_POST['ordtype_list'] : "";
        if ($ids != "") {
            $list = $this->rateprefermodel->ordtypelist($ids);
            foreach ($list as $li) {
                $ordtype       = '"' . $li['type_name'] . '"';
                $ordname       = '"' . $li['type_name'] . '"';
                $li['action']  = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowordEdit(this," . $li['id'] . "," . $li['order_type_id'] . "," . $ordtype . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowordElim(this," . $li['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowOrdAdd(this);'><span class='glyphicon glyphicon-plus' > </span>" . $this->lang->line('add_order_type') . "</a></li>";
                $ordtypelist[] = $li;
            }
        }
        echo json_encode($ordtypelist);
    }

    public function getordtypelist()
    {
        $ordtypelist = [];
        $rprefid     = isset($_POST['rprefid']) ? $_POST['rprefid'] : "";
        if ($rprefid != "") {
            $list = $this->rateprefermodel->ordtypelistbyid($rprefid);
            foreach ($list as $li) {
                $ordtype       = '"' . $li['type_name'] . '"';
                $ordname       = '"' . $li['type_name'] . '"';
                $li['action']  = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowordEdit(this," . $li['id'] . "," . $li['order_type_id'] . "," . $ordtype . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowordElim(this," . $li['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowOrdAdd(this);'><span class='glyphicon glyphicon-plus' > </span>" . $this->lang->line('add_order_type') . "</a></li>";
                $ordtypelist[] = $li;
            }
        }
        echo json_encode($ordtypelist);
    }

    public function saveservice($id = null)
    {
        $post              = $this->input->post(null, true);
        $userid            = $this->session->userdata('user_id');
        $srv['service_id'] = $post['serviceid'];
        if ($id == null) {
            if (isset($post['rprefid'])) {
                $srv['rate_prefer_id'] = $post['rprefid'];
            } else {
                $srv['rate_prefer_id'] = 0;
            }
            $srv['user_id']   = $userid;
            $srv['status']    = 1;
            $srv['createdon'] = date('Y-m-d H:i:s');
            $srv['updatedon'] = date('Y-m-d H:i:s');
            $data['id']       = $this->common->insertTableData('tb_rateprefer_service', $srv);
        } else {
            $srv['updatedon'] = date('Y-m-d H:i:s');
            $this->common->updatetbledata('tb_rateprefer_service', $srv, ['id' => $id]);
            $data['id'] = $id;
        }
        echo json_encode($data);
    }

    public function showservicelist()
    {
        $servicelist = [];
        $post        = $this->input->post(null, true);
        $ids         = isset($post['service_list']) ? $post['service_list'] : "";
        if ($ids != "") {
            $list = $this->rateprefermodel->servicelist($ids);
            foreach ($list as $li) {
                $serviceid     = '"' . $li['serviceid'] . '"';
                $servicename   = '"' . $li['name'] . '"';
                $li['action']  = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowserviceEdit(this," . $li['id'] . "," . $li['service_id'] . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowserviceElim(this," . $li['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowServiceAdd(this);'><span class='glyphicon glyphicon-plus' > </span>" . $this->lang->line('add_service') . "</a></li>";
                $servicelist[] = $li;
            }
        }
        echo json_encode($servicelist);
    }

    public function getservicelist()
    {
        $servicelist = [];
        $post        = $this->input->post(null, true);
        $rprefid     = isset($post['rprefid']) ? $post['rprefid'] : "";
        if ($rprefid != "") {
            $list = $this->rateprefermodel->servicelistbyid($rprefid);
            foreach ($list as $li) {
                $serviceid    = '"' . $li['serviceid'] . '"';
                $servicename  = '"' . $li['name'] . '"';
                $li['action'] = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'><li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowserviceEdit(this," . $li['id'] . "," . $li['service_id'] . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowserviceElim(this," . $li['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowServiceAdd(this);'><span class='glyphicon glyphicon-plus' > </span>" . $this->lang->line('add_service') . "</a></li></ul></li></ul>";

                // this should be verified
                $li['action']  =
                $servicelist[] = $li;
            }
        }
        echo json_encode($servicelist);
    }

    public function saveproduct($id = null)
    {
        $post              = $this->input->post(null, true);
        $userid            = $this->session->userdata('user_id');
        $prd['product_id'] = $post['productid'];
        if ($id == null) {
            if (isset($post['rprefid'])) {
                $prd['rate_prefer_id'] = $post['rprefid'];
            } else {
                $prd['rate_prefer_id'] = 0;
            }
            $prd['user_id']   = $userid;
            $prd['status']    = 1;
            $prd['createdon'] = date('Y-m-d H:i:s');
            $prd['updatedon'] = date('Y-m-d H:i:s');
            $data['id']       = $this->common->insertTableData('tb_rateprefer_product', $prd);
        } else {
            $srv['updatedon'] = date('Y-m-d H:i:s');
            $this->common->updatetbledata('tb_rateprefer_product', $prd, ['id' => $id]);
            $data['id'] = $id;
        }
        echo json_encode($data);
    }

    public function showproductlist()
    {
        $productlist = [];
        $post        = $this->input->post(null, true);
        $ids         = isset($post['product_list']) ? $post['product_list'] : "";
        if ($ids != "") {
            $list = $this->rateprefermodel->productlist($ids);
            foreach ($list as $li) {
                $productname   = '"' . $li['name'] . '"';
                $li['action']  = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowproductEdit(this," . $li['id'] . "," . $li['product_id'] . "," . $productname . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowproductElim(this," . $li['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowProductAdd(this);'><span class='glyphicon glyphicon-plus' > </span>" . $this->lang->line('add_product') . "</a></li>";
                $productlist[] = $li;
            }
        }
        echo json_encode($productlist);
    }

    public function getproductlist()
    {
        $productlist = [];
        $post        = $this->input->post(null, true);
        $rprefid     = isset($post['rprefid']) ? $post['rprefid'] : "";
        if ($rprefid != "") {
            $list = $this->rateprefermodel->productlistbyid($rprefid);
            foreach ($list as $li) {
                $productname   = '"' . $li['name'] . '"';
                $li['action']  = "<ul class='nav nav-tabs'><li class='tablebtnrleft dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu dropdown-menu-left' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowproductEdit(this," . $li['id'] . "," . $li['product_id'] . "," . $productname . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowproductElim(this," . $li['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowProductAdd(this);'><span class='glyphicon glyphicon-plus' > </span>" . $this->lang->line('add_product') . "</a></li>";
                $productlist[] = $li;
            }
        }
        echo json_encode($productlist);
    }

    public function getratefferings()
    {
        $ttype       = "SELL";
        $post        = $this->input->post(null, true);
        $service_id  = $this->input->post('service_id', true);
        $tariff_type = isset($post['tariff_type']) ? $post['tariff_type'] : "0";
        if ($tariff_type == '1') {
            $ttype = "BUY";
        } else {
            $ttype = "SELL";
        }
        $user_id      = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        if ($company_code == "RUKN") {
            $rateofferings = $this->common->gettbldata(['rate_service_id' => $service_id, 'tarrif_type' => $ttype, 'status' => 1, 'company_code' => $company_code], 'id,offering_id,offering_name', 'tb_rate_offerings', 0, 0);
        } else {
            $rateofferings = $this->common->gettbldata(['rate_service_id' => $service_id, 'tarrif_type' => $ttype, 'status' => 1, 'user_id' => $user_id], 'id,offering_id,offering_name', 'tb_rate_offerings', 0, 0);
        }

        echo json_encode($rateofferings);
    }

    public function getraterecords()
    {
        $offering_id  = $this->input->post('offering_id', true);
        $rateofr      = $this->common->gettblrowdata(['id' => $offering_id], 'tarrif_type', 'tb_rate_offerings', 0, 0);
        $user_id      = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        if ($company_code == "RUKN") {
            $raterecords = $this->common->gettbldata(['offering_id' => $offering_id, 'status' => 1, 'company_code' => $company_code], 'id,rate_id,record_name', 'tb_rate_records', 0, 0);
        } else {
            $raterecords = $this->common->gettbldata(['offering_id' => $offering_id, 'status' => 1, 'user_id' => $user_id], 'id,rate_id,record_name', 'tb_rate_records', 0, 0);
        }

        echo json_encode(['list' => $raterecords, 'tarrif_type' => $rateofr['tarrif_type']]);
    }

    public function selectrateserviceontariftype()
    {
        $service         = [];
        $getservice_rows = 0;
        $post            = $this->input->post(null, true);
        $profile         = isset($post['profile']) ? $post['profile'] : "0";
        if ($profile == "") {
            $profile = 0;
        }
        $tariff_type = isset($post['tariff_type']) ? $post['tariff_type'] : "";
        if ($tariff_type == "1") {
            if ($profile != "0") {
                $getservices     = $this->rateprefermodel->getvendprofilebasedservices($profile);
                $getservice_rows = $getservices->num_rows();
            } else {
                // rateprefermodel->getsellbuybasedservices not exists.
                // return default [] instead error 500
                return [];

                $ttype           = "BUY";
                $getservices     = $this->rateprefermodel->getsellbuybasedservices($ttype);
                $getservice_rows = $getservices->num_rows();
            }
        } else {
            if ($profile != "0") {
                $getservices     = $this->rateprefermodel->getcustprofilebasedservices($profile);
                $getservice_rows = $getservices->num_rows();
            } else {
                // rateprefermodel->getsellbuybasedservices not exists.
                // return default [] instead error 500
                return [];

                $ttype           = "SELL";
                $getservices     = $this->rateprefermodel->getsellbuybasedservices($ttype);
                $getservice_rows = $getservices->num_rows();
            }
        }
        if ($getservice_rows > 0) {
            foreach ($getservices->result() as $res) {
                $service_name = $res->service_name;
                if ($service_name == "") {
                    $service_id = $res->service_id;
                } else {
                    $service_id = $res->service_id . '-' . $service_name;
                }
                $service[] = ['service_rowid' => $res->id, 'service' => $service_id];
            }
        }
        echo json_encode($service);
    }

    public function deletebulkrecords(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $ids    = $this->input->post('deleteids', true);
            $result = true;
            foreach ($ids as $id) {
                $this->db->where('id', $id);
                $this->db->set('status', 0);
                $result = $this->db->update('tb_rate_preferences');
                if (! $result) {
                    $result = false;
                }
            }
            echo $result ? "success" : "failed";
        }
    }

}
