<?php
 
class Reasoncode extends CI_Controller{
    function __construct()
    {
        parent::__construct();
        $this->load->model('Reason_code_model');
    } 

    /*
     * Listing of reason_codes
     */
    function index($per_page=0)
    {
        $params['limit'] = 10; 
        $params['offset'] = isset($per_page) ? $per_page : 0;
        
        $config = $this->config->item('pagination');
        $config['base_url'] = site_url('reasoncode/index');
        $config['total_rows'] = $this->Reason_code_model->get_all_reason_codes_count();
        $this->pagination->initialize($config);

        $data['reason_codes'] = $this->Reason_code_model->get_all_reason_codes($params);
        
        $data['_view'] = 'reasoncode/index';
        $this->settemplate->dashboard('reasoncode/index',$data);
    }

    /*
     * Adding a new reason_code
     */
    function add()
    {   
        $data['_view'] = 'reasoncode/add';
        $this->settemplate->dashboard('reasoncode/add',$data);
    }  
    /*
     * Adding a new reason_code
     */
    function reasoncodesave()
    {   
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $this->form_validation->set_rules('reason_code_id', 'Reason Code ID', 'required|is_unique[tb_reason_codes.reason_code_id]');
            if ($this->form_validation->run() == false) {
                $this->form_validation->set_error_delimiters('<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>');
                $this->add();
            }else{
                $pk = $this->input->post('domain_name').".".$this->input->post('reason_code_id');
                $params = array(
                    'pk' => $pk,
    				'reason_code_id' => $this->input->post('reason_code_id'),
    				'description' => $this->input->post('description'),
    				'domain_name' => $this->input->post('domain_name'),
    				'user_id' => $this->session->userdata('user_id'),
                    'status'=>"1",
    				'createdon' => date("Y-m-d H:i:s"),
                );
                
                $reason_code_id = $this->Reason_code_model->add_reason_code($params);
                redirect('reasoncode/index');
            }
        }
        else
        {            
           redirect('reasoncode/index');
        }
    }  

    /*
     * Editing a reason_code
     */
    function edit($id)
    {   
        // check if the reason_code exists before trying to edit it
        $data['reason_code'] = $this->Reason_code_model->get_reason_code($id);
        
        if(isset($data['reason_code']['id']))
        {
            $data['_view'] = 'reasoncode/edit';
            $this->settemplate->dashboard('reasoncode/edit',$data);
        }else{
            show_error('The reason_code you are trying to edit does not exist.');
        }
    } 


    public function checkrscodeupdate($statuscode) {
        if($this->input->post('id')){
            $id = $this->input->post('id');
        }else{
            $id = 0;
        }
        $whr = array("reason_code_id"=>$statuscode,"id <>"=>$id);
        $res = $this->db->select("id")->where($whr)->get("tb_reason_codes")->num_rows();
        if($res == 0){
            $response = true;
        }else {
            $this->form_validation->set_message('checkrscodeupdate','Reason Code ID is already exists to another reason!');
            $response = false;
        }
        return $response;
    }

    /*
     * Editing a reason_code
     */
    function reasoncodeupdate($id)
    {   
        // check if the reason_code exists before trying to edit it
        $data['reason_code'] = $this->Reason_code_model->get_reason_code($id);
        
        if(isset($data['reason_code']['id']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            {   
                $this->form_validation->set_rules('reason_code_id', 'Reason Code ID', 'required|callback_checkrscodeupdate');
                if ($this->form_validation->run() == false) {
                    $this->form_validation->set_error_delimiters('<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>');
                    $this->edit($id);
                }else{
                    $pk = $this->input->post('domain_name').".".$this->input->post('reason_code_id');
                    $params = array(
                    'pk' => $pk,
					'reason_code_id' => $this->input->post('reason_code_id'),
					'description' => $this->input->post('description'),
					'domain_name' => $this->input->post('domain_name'),
                    'user_id' => $this->session->userdata('user_id'),
                    'status'=>"1",
                );
                    $this->Reason_code_model->update_reason_code($id,$params);            
                    redirect('reasoncode/index');
                }
            }else{
                redirect('reasoncode/index');
            }
        }else{
            show_error('The reason_code you are trying to edit does not exist.');
        }
    } 

    /*
     * Deleting reason_code
     */
    function remove($id)
    {
        $reason_code = $this->Reason_code_model->get_reason_code($id);

        // check if the reason_code exists before trying to delete it
        if(isset($reason_code['id']))
        {
            $this->Reason_code_model->delete_reason_code($id);
            redirect('reasoncode/index');
        }
        else
            show_error('The reason_code you are trying to delete does not exist.');
    }
    
}
