<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

/**
 * @property ReportCWGLibrary $reportcwglibrary
 */
class ReportCWG extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if (empty($this->session->userdata('user_id'))) {
            redirect('login');
        }
        $this->load->library('ReportCWGLibrary');
        $this->load->model('ReportCWGModel');
        if (!checkUrlAccessForUser('REPORTCWG')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $data["page_title"] = "CWG";
        $data["sub_title"] = "Report";
        $this->newtemplate->dashboard("reportCWG/index", $data);
    }

    /**
     * @throws JsonException
     */
    public function getTableData()
    {
        if (empty($this->session->userdata('user_id'))) {
            echo 'SessionTimeout';
            return false;
        }

        $draw = $this->input->post('draw', true);
        $postData = $this->input->post('data', true);
        $getRevenueData = $this->reportcwglibrary->getCWGReportData($postData);
        if (empty($getRevenueData['data'])) {
            $finalData = '[]';
            echo '{"draw":' . $draw . ',"recordsTotal":' . 0 . ',"recordsFiltered":' . 0 . ',"data":' . $finalData . '}';
            return false;
        }
        $getFinalData = $this->reportcwglibrary->getDataTableRecords($getRevenueData['data']);
        echo '{"draw":' . $draw . ',"recordsTotal":' . $getRevenueData['ordersCount'] . ',
        "recordsFiltered":' . $getRevenueData['ordersCount'] . ',"data":' . $getFinalData . '}';
    }

    /**
     * @throws JsonException
     */
    public function getTripIds(): void
    {
        $tripId = $this->input->post('tripId', true) ?? "";
        $getUserIds = $this->reportcwglibrary->getUserIds();
        echo json_encode($this->ReportCWGModel->getTripIds($tripId, $getUserIds), JSON_THROW_ON_ERROR);
    }

    /**
     * @throws JsonException
     */
    public function getOrderIds(): void
    {
        $bookingId = $this->input->post('bookingId', true) ?? "";
        $getUserIds = $this->reportcwglibrary->getUserIds();
        echo json_encode($this->ReportCWGModel->getOrderIds($bookingId, $getUserIds), JSON_THROW_ON_ERROR);
    }

}
