<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
class Reporttruckvolume extends CI_Controller {

  public function __Construct() {
    parent::__Construct();
    $this->load->library('session');
    if($this->session->userdata('user_id') == ''){
      redirect('login');
    }
    $this->load->library('form_validation');
    $this->load->model('truckmodel');
    $this->load->model('aquaticamodel');
    $this->load->model('common');
    $this->load->library('email');
  }

  public function index()
  {
    $data['page_title'] = "Operational Report";
    $data['sub_title'] = "Report";
    $userid = $this->session->userdata("user_id");
    $custid = $this->session->userdata("cust_id");
    $country_userids = $this->session->userdata("country_user_ids");
    if($this->session->userdata('business_type') == 'Carrier'){
      redirect('/');
    }
    $where = array("user_id"=>$userid,"status"=>1);
    $select = "id,name";
    $table = "tb_vendors";
    $carrierlist=$this->common->gettbldata($where,$select,$table,0,0);
    $data['carrierlist']=$carrierlist;
    $order = $country_userids = $aquorder=array();
    $input = $this->input->post(null,true);

    $fromdate = isset($input['fromdate']) ? $input['fromdate'] : "";
    $todate   = isset($input['todate']) ? $input['todate'] : "";
    $ordtype  = isset($input['ordtype']) ? $input['ordtype'] : "";
    $carrier  = isset($input['carrier']) ? $input['carrier'] : array();
    
    $aqufromdate = isset($input['aqufromdate']) ? $input['aqufromdate'] : "";
    $aqutodate   = isset($input['aqutodate'])   ? $input['aqutodate'] : "";
    $aquordtype  = isset($input['aquordtype'])  ? $input['aquordtype'] : "";
    $aqucarrier  = isset($input['aqucarrier'])  ? $input['aqucarrier'] : array();

    $tab_type = isset($input['tab_type']) ? $input['tab_type'] : "";

    $tabname='volume';
    $data['order'] = $order;
    $data['fromdate']=$fromdate;
    $data['todate']=$todate;
    $data['ordtype']=$ordtype;
    $data['carrierid']=$carrier;
    $data['aquorder'] = $aquorder;
    $data['aqufromdate']=$aqufromdate;
    $data['aqutodate']=$aqutodate;
    $data['aquordtype']=$aquordtype;
    $data['aqucarrierid']=$aqucarrier;
    
    if($tab_type=='volume'){
	if($fromdate!='' && $todate!=''){
	$orderdata = $this->truckmodel->gettruckreportdata($userid,$custid,$country_userids,$fromdate,$todate,$ordtype,$carrier);
    if(!empty($orderdata)){
    foreach($orderdata as $res){
    $qry = $this->db->query("SELECT c.quantity,c.weight,c.volume FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='".$res['id']."' AND o.status='1' AND o.cargo_id=c.id GROUP BY c.id ORDER BY c.id DESC");
    $pieces=$weight=$volume=0;
    if($qry->num_rows() >0){
    foreach($qry->result() as $row){
      $pieces=$row->quantity+$pieces;
      $weight=$row->weight+$weight;
      $volume=$row->volume+$volume;
    }
    }
    $carrier_name='';
    $truckinfo = $this->db->query("SELECT v.name FROM tb_vendors v,tb_employee e WHERE e.order_id ='".$res['order_id']."' AND e.vendor_id=v.id");
    if($truckinfo->num_rows() >0){
       $carrier_name = $truckinfo->row()->name;
    }
    $status='';
    if($res['status']==1){
    $status='Pending';
    }
    else if($res['status']==2 && $res['trip_sts']==0){
    $status='Active';
    }
    else if($res['status']==2 && $res['trip_sts']==1){
    $status='Closed';
    }
    $order[] = array('order_row_id'=>$res['id'],'order_id'=>$res['order_id'],'pieces'=>$pieces,
    'weight'=>$weight,'volume'=>$volume,'createdon'=>$res['createdon'],'pickup'=>$res['pickup'],
    'delivery'=>$res['delivery'],'order_status'=>$status,'shipid'=>$res['shipid'],'carriername'=>$carrier_name);
    }
    }
    }
    $data['order'] = $order;
    $data['fromdate']=$fromdate;
    $data['todate']=$todate;
    $data['ordtype']=$ordtype;
    $data['carrierid']=$carrier;
    }//volume condition
   if($tab_type=='aquatica'){ // aquatica condition
    $tabname='aquatica';
    if($aqufromdate!='' && $aqutodate!=''){
    $orderdata = $this->aquaticamodel->gettruckreportdata($userid,$custid,$country_userids,$aqufromdate,$aqutodate,$aquordtype,$aqucarrier);
    if(!empty($orderdata)){
    foreach($orderdata as $res){
    $qry = $this->db->query("SELECT c.quantity,c.weight,c.volume,c.weight_unit,c.volume_unit FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='".$res['id']."' AND o.status='1' AND o.cargo_id=c.id GROUP BY c.id ORDER BY c.id DESC");
    $pieces=$weight=$volume=0;
    $weight_unit=$volume_unit='';
    $k=1;
    if($qry->num_rows() >0){
    foreach($qry->result() as $row){
        if($k==1){
        $weight_unit=$row->weight_unit;
        $volume_unit=$row->volume_unit;
        }
        $pieces=$row->quantity+$pieces;
        $weight=$row->weight+$weight;
        $volume=$row->volume+$volume;
        $k++;
    }
    }
    $carrier_name='';
    $truckinfo = $this->db->query("SELECT v.name FROM tb_vendors v,tb_employee e WHERE e.order_id ='".$res['order_id']."' AND e.vendor_id=v.id");
    if($truckinfo->num_rows() >0){
       $carrier_name = $truckinfo->row()->name;
    }
    $status='';
    if($res['status']==1){
    $status='Pending';
    }
    else if($res['status']==2 && $res['trip_sts']==0){
    $status='Active';
    }
    else if($res['status']==2 && $res['trip_sts']==1){
    $status='Closed';
    }

    $reference_num=$supplier_date=$cancelled_date=$delconsignee_date='';
    $ref_num = $this->aquaticamodel->getreferencedetails($res['id']);
        if($ref_num->num_rows() >0){
         $reference_num=$ref_num->row()->ref_value;
    }
    $supplier_info = $this->aquaticamodel->getsupdetails($res['order_id']);
    if($supplier_info->num_rows() >0){
         $supplier_date=date("d M Y",strtotime($supplier_info->row()->createdon));
    }
	 
    $deliverycons_info = $this->aquaticamodel->getdelconsigdetails($res['order_id']);
    if($deliverycons_info->num_rows() >0){
         $delconsignee_date=date("d M Y",strtotime($deliverycons_info->row()->createdon));
    }
    $cancelled_info = $this->aquaticamodel->getcanceldetails($res['order_id']);
    if($cancelled_info->num_rows() >0){
         $cancelled_date=date("d M Y",strtotime($cancelled_info->row()->createdon));
    }
    $aquorder[] = array('order_row_id'=>$res['id'],'order_id'=>$res['order_id'],'pieces'=>$pieces,
    'weight'=>$weight,'volume'=>$volume,'createdon'=>date("d M Y",strtotime($res['createdon'])),'pickup'=>$res['pickup'],
    'delivery'=>$res['delivery'],'order_status'=>$status,'shipid'=>$res['shipid'],
    'carriername'=>$carrier_name,'shipper_address'=>$res['pickup'],'shipper_city'=>$res['pickup_city'],
	'consignee_address'=>$res['delivery'],'consignee_city'=>$res['delivery_city'],
	'pickup_date'=>date("d M Y",strtotime($res['pickup_datetime'])), 
	'reference_num'=>$reference_num,'weight_unit'=>$weight_unit,
	'volume_unit'=>$volume_unit,'supplier_date'=>$supplier_date,'cancelled_date'=>$cancelled_date,'delconsignee_date'=>$delconsignee_date);
    }
    }
    }
    $data['aquorder'] = $aquorder;
    $data['aqufromdate']=$aqufromdate;
    $data['aqutodate']=$aqutodate;
    $data['aquordtype']=$aquordtype;
    $data['aqucarrierid']=$aqucarrier;
    }// aquatica condition
    
    $data['tabname']=$tabname;
	$this->settemplate->dashboard("reportstruck/volume", $data);
 }
}