<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Roster extends CI_Controller {

   public function __construct()
   {
      parent::__construct();
      /*$this->load->helper("roster_helper");*/
      /*if($this->session->userdata("user_id")==""){
         redirect("login");
      }*/
      $this->load->model('common');
   }

   public function index(){
      $data["page_title"]="Roster";
      $data["sub_title"]="Shipments";
      $from=date("Y-m-d");
      $limit=20;
      $to=date("Y-m-d",strtotime('sunday this week'));
      $next=0;
      $search="";
      if($_GET){
         $from=date("Y-m-d",strtotime(isset($_GET["from"])?$_GET["from"]:$from));
         $to=date("Y-m-d",strtotime(isset($_GET["to"])?$_GET["to"]:$to));
         $next=$_GET["next"];
         $search=isset($_GET["search"])?$_GET["search"]:"";
      }
      $con="";
      if($search!=""){
         $con="and e.name like '%".$search."%'";
      }
      $uid=$this->session->userdata("user_id");
      $data["user"]=$this->db->select("company_indv_name,mobile_no")->limit("1")->where("id",$uid)->get("tb_users")->row();
      $data["dates"]=$this->db->query("SELECT distinct(shiftdate) FROM `tb_emp_daily_status` where shiftdate>='$from' and shiftdate<='$to' and user_id=$uid order by id asc");
      $sql="SELECT `e`.* FROM `tb_employee` `e` INNER JOIN `tb_emp_daily_status` `d` ON `d`.`emp_id`=`e`.`id` WHERE `d`.`shiftdate` >= '$from' and `d`.`shiftdate` <= '$to' and d.user_id=$uid $con GROUP BY `e`.`id`";
      $data["emp"]=$this->db->query($sql." limit $next,$limit");
      $data["tot_emp"]=$this->db->query($sql);
      $emp=[];
      $rc=[];
      if($data["emp"]->num_rows()>0&&$data["dates"]->num_rows()>0){
         foreach($data["emp"]->result() as $r){
            $sql=$this->db->query("select * from tb_emp_daily_status where emp_id=$r->id and user_id=$uid");
            if($sql->num_rows()>0){
               foreach($sql->result() as $d){
                  $s1=$this->db->where("id",$d->shift_id)->get("tb_shifts");
                  $c="";
                  if($s1->num_rows()>0){
                     $s1=$s1->row();
                     $c= date("Y-m-d h:i A",strtotime($s1->startdate))." - ".date("Y-m-d h:i A",strtotime($s1->enddate));
                  }
                  $emp["id"]=$d->id;
                  $emp["emp_id"]=$d->emp_id;
                  $emp["assoc_id"]=$r->assoc_id;
                  $emp["name"]=$r->name;
                  $emp["mobile"]=$r->phone;
                  $emp["address"]=$r->address;
                  $emp["pickup"]=$r->pickup;
                  $emp["shift"]=$c;
                  $emp["route"]=$d->route_id;
                  foreach($data["dates"]->result() as $dt){
                     if($dt->shiftdate==$d->shiftdate){
                        $emp[$d->shiftdate]=array($d->absent_reason,$d->id);
                     }
                  }
               }
            }
            $rc[]=$emp;
         }
      }
      $data["records"]=$rc;
      $data["from"]=$from;
      $data["to"]=$to;
      $data["next"]=$next;
      $data["limit"]=$limit;
      $data["search"]=$search;
      $this->settemplate->dashboard("roster/index",$data);
   }
   function updaterow(){
      if($_POST){
         $id=isset($_POST["id"])?($_POST["id"]):"";
         $reason=isset($_POST["reason"])?($_POST["reason"]):"";
         $reason=trim($reason);
         if($id!=""){
            if($reason==""){
               $this->addtoLive($id);
               $this->db->where(array("id"=>$id))->update("tb_emp_daily_status",array("status"=>"1","absent_reason"=>$reason));
            }else{
               $this->db->where(array("id"=>$id))->update("tb_emp_daily_status",array("status"=>"0","absent_reason"=>$reason));
            }
         }
      }
   }
   function dailyupdate(){
      $today=date("Y-m-d");
      $uid=$this->session->userdata("user_id");
      $sql=$this->db->where(array("shiftdate"=>$today,"user_id"=>$uid))->get("tb_emp_daily_status");
      echo $this->db->last_query();
   }
   function addtoLive($id=null){
      if($id!=null){
         $emp=$this->db->where("id",$id)->get("tb_emp_daily_status")->row()->emp_id;
         $uid=$this->session->userdata("user_id");
         $q=$this->db->query("select t.shift_id,t.vehicle_id,te.* from tb_trips t,tb_trip_employee te where t.status='1' and te.employee_id=$emp and t.id=te.trip_id");
         if($q->num_rows()>0){
            $id=$q->row()->id;
            $shft_id=$q->row()->shift_id;
            $vehicle_id=$q->row()->vehicle_id;
            $this->db->query("insert into tb_roster_live_edits select * from tb_trip_employee where id=$id");
            $this->db->query("delete from tb_trip_employee where id=$id");
            $shft_veh=$this->db->query("select * from tb_shft_veh where shft_id=$shft_id and vehicle_id=$vehicle_id and status=1 order by updated_on desc limit 1");
            if($shft_veh->num_rows()>0){
               $shft_veh_id=$shft_veh->row()->id;
               $qq=$this->db->query("select id from tb_shft_veh_emp where shft_veh_id=$shft_veh_id and emp_id=$emp order by status desc limit 1");
               $next_priority=$this->db->query("select IFNULL((max(priority))+1,1) as `next` from tb_shft_veh_emp where shft_veh_id=$shft_veh_id and status=1")->row()->next;
               if($qq->num_rows()>0){
                  $this->db->where(array("id"=>$qq->row()->id))->update("tb_shft_veh_emp",array("priority"=>$next_priority,"status"=>1,"updated_on"=>date("Y-m-d H:i:s")));
               }else{
                  $this->db->insert("tb_shft_veh_emp",array("user_id"=>$uid,"shft_veh_id"=>$shft_veh_id,"emp_id"=>$emp,"priority"=>$next_priority,"updated_on"=>date("Y-m-d H:i:s")));
               }
            }
         }
      }
   }
   function unassignEmployee(){
      $emp_id=$this->input->post("emp_id");
      if(isset($emp_id) && $emp_id!=""){
         $sql=$this->db->where(array("emp_id"=>$emp_id,"shiftdate"=>date("Y-m-d")))->get("tb_emp_daily_status");
         if($sql->num_rows()>0){
            $shft_id=$sql->row()->shift_id;
            if($this->db->where(array("shift_id"=>$shft_id,"status"=>"1"))->get("tb_trips")->num_rows()==0){
               $this->db->where(array("emp_id"=>$emp_id,"status"=>"1"))->delete("tb_shft_veh_emp");
               $this->db->where(array("emp_id"=>$emp_id))->delete("tb_emp_daily_status");
               echo "1";
            }
         }else{
            $this->db->where(array("emp_id"=>$emp_id,"status"=>"1"))->delete("tb_shft_veh_emp");
            $this->db->where(array("emp_id"=>$emp_id))->delete("tb_emp_daily_status");
            echo "1";
         }
      }
   }

   public function automanualassign($shipmentid,$userid)
   {
      $uwhr = array('setting_type_id'=>1,'status'=>1,'user_id'=>$userid);
      $chkpos = $this->common->gettblrowdata($uwhr,'setting_value','tb_user_settings',0,0);
      if(count($chkpos) > 0){
         if($chkpos['setting_value'] == '1'){
            $addauto = $this->autoshipalert($shipmentid,$userid);
         }else{
            $addmanual = $this->manualshipalert($shipmentid,$userid);
         }
      }else{
         $addmanual = $this->manualshipalert($shipmentid,$userid);
      }
   }

   public function manualshipalert($shipid,$userid)
   {
      $dt = date('Y-m-d H:i:s');
      $insdata = array('user_id'=>$userid,'shipment_id'=>$shipid,'status'=>1,'createdon'=>$dt);
      $shipinsert = $this->common->insertTableData('tb_automanual_ships',$insdata);
   }

   public function autoshipalert($shipid,$userid)
   {
      $dt = date('Y-m-d H:i:s');
      $insdata = array('user_id'=>$userid,'shipment_id'=>$shipid,'status'=>1,'createdon'=>$dt);
      $shipinsert = $this->common->insertTableData('tb_automanual_ships',$insdata);
      /*$whr = array('id'=>$shipid);
      $shipmentdata = $this->common->gettbldata($whr,'id,slat,slng','tb_shifts',0,0);
      $chklive =
      $message = "Dear $emp,Your truck $reg ($driver_phone) will be start at $splace on $stime,track your truck by $link.";
      $fire_set = $this->sendfirebase->sendSinglePush(array("title"=>"Shipment Assign Auto Alert","message"=>$message,"emp_id"=>$emp_id,'type'=>'Driver'));*/
   }

   public function shipmentapirequest()
   {
       $postData = trim(file_get_contents('php://input'));
       $xml = simplexml_load_string($postData);
       $result = array();
       $userid = 1;
       $response = 0;
         $json = json_encode($xml);
         $res = json_decode($json,TRUE);
         $txndate = isset($res['TransmissionHeader']['TransmissionCreateDt']['GLogDate']) ? $res['TransmissionHeader']['TransmissionCreateDt']['GLogDate'] : "";
         $logdate = date('Y-m-d H:i:s');
         if($txndate != ""){
            $logdate = date('Y-m-d H:i:s',strtotime($txndate));
         }
         $users = array();
         $users['username'] = isset($res['TransmissionHeader']['UserName']) ? $res['TransmissionHeader']['UserName'] : "";
         $users['password'] = isset($res['TransmissionHeader']['Password']) ? $res['TransmissionHeader']['Password'] : "";
         $users['sysid'] = isset($res['TransmissionHeader']['SenderSystemId']) ? $res['TransmissionHeader']['SenderSystemId'] : "";
         $users['elementname'] = isset($res['TransmissionHeader']['GlogXMLElementName']) ? $res['TransmissionHeader']['GlogXMLElementName'] : "";
         $shidata = $this->get_shipmentdata($res['TransmissionBody']);
         if(!empty($shidata)){
            $result = array('logdate'=>$logdate,'users'=>$users,'shipdata'=>$shidata);
            $response = $this->insertShipData($result['shipdata'],$logdate);
         }
       /*}*/
       if($response > 0){
         $preparetrip = $this->integrateshipment($response);
         if(!empty($preparetrip)){
            $shipmentid = $preparetrip['shipment_id'];
            $chkoption = $this->automanualassign($shipmentid,$userid);
         }
         echo "Success";
       }else{
         echo "Failed for unformatted request,Please try again!";
       }
   }

   function createshipment($ship_id,$uid,$curdt,$shpname,$tnsmode,$shipid,$start,$end,$txnid,$domainname){
      $uwhr = array('status'=>1,'shipment_id'=>$ship_id);
      $getunits = $this->common->gettbldata($uwhr,'weight,volume,pkg_item_count','tb_shipment_units',0,0);
      $i = count($getunits);
      $j = 1;
      $weight = $volume = 0;
      $sfrom = $sto = $scity = $dcity = "";
      $slat = $slng = $elat = $elng = "";
      $pickestimate = $start;
      $stime = $pesttime = date('H:i',strtotime($pickestimate));
      $dropestimate = $end;
      $etime = $desttime = date('H:i',strtotime($dropestimate));
      $frmloc = $this->db->query('select location,pickupestimate FROM tb_shipment_stops WHERE shipment_id="'.$ship_id.'" ORDER BY stopnumber ASC LIMIT 1');
      if($frmloc->num_rows()>0){
         $loc = $frmloc->row()->location;
         if($pickestimate == '0000-00-00 00:00:00'){
            $pickestimate = $frmloc->row()->pickupestimate;
            $stime = $pesttime = date('H:i',strtotime($pickestimate));
         }
         $dd = $this->db->query('select locationname,city,address,latitude,longitude FROM tb_shipment_locations WHERE shipment_id="'.$ship_id.'" AND locationid="'.$loc.'" LIMIT 1');
         if($dd->num_rows() > 0){
            $slat = $dd->row()->latitude;
            $slng = $dd->row()->longitude;
            $sfrom = $dd->row()->locationname;
            $scity = $dd->row()->city;
         }
      }
      $toloc = $this->db->query('select location,deliveryestimate FROM tb_shipment_stops WHERE shipment_id="'.$ship_id.'" ORDER BY stopnumber DESC LIMIT 1');
      if($toloc->num_rows()>0){
         $dloc = $toloc->row()->location;
         if($dropestimate == '0000-00-00 00:00:00' || $dropestimate == ""){
            $dropestimate = $frmloc->row()->deliveryestimate;
            $etime = $desttime = date('H:i',strtotime($dropestimate));
         }
         $ddd1 = $this->db->query('select locationname,city,address,latitude,longitude FROM tb_shipment_locations WHERE shipment_id="'.$ship_id.'" AND locationid="'.$dloc.'" LIMIT 1');
         if($ddd1->num_rows() > 0){
            $elat = $ddd1->row()->latitude;
            $elng = $ddd1->row()->longitude;
            $sto = $ddd1->row()->locationname;
            $dcity = $ddd1->row()->city;
         }
      }
      $pkgitemcnt = 0;
      foreach($getunits as $unit){
         $weight += $unit['weight'];
         $volume += $unit['volume'];
         $pkgitemcnt += $unit['pkg_item_count'];
      }
      $ship_data = array('user_id'=>$uid, 'stime'=>$stime, 'etime'=>$etime, 'splace'=>$sfrom, 'slat'=>$slat, 'slng'=>$slng, 'eplace'=>$sto, 'elat'=>$elat, 'elng'=>$elng, 'scity'=>$scity, 'dcity'=>$dcity, 'zone_id'=>1,'startdate'=>$pickestimate,'enddate'=>$dropestimate, 'created_on'=>$curdt, 'updated_on'=>$curdt, 'status'=>1, 'empshift_start'=>$pesttime, 'empshift_end'=>$desttime, 'trip_type'=>0, 'shipment_name'=>$shpname, 'shipment_id'=>$ship_id, 'shipmentid'=>$shipid, 'transport_mode'=>$tnsmode, 'txnid'=>$txnid, 'weight'=>$weight, 'volume'=>$volume, 'units'=>$pkgitemcnt, 'domainname'=>$domainname);
      /*log_message('error',json_encode($ship_data));*/
      $shipinsert = $this->common->insertTableData('tb_shifts',$ship_data);
      /* add rates */
      $getrate = $this->db->get_where('tb_shipment_otmcosts',array('shipment_id'=>$ship_id));
      if($getrate->num_rows()>0){
         foreach($getrate->result() as $rt){
            $category = $rt->costtype;
            $cost = $rt->rate;
            $chk = $this->db->get_where('tb_shipment_rate_categories',array('name'=>$category),1,0);
            if($chk->num_rows() > 0){
               $categoryid = $chk->row()->id;
            }else{
               $arr = array('name'=>$category,'status'=>1,'createdon'=>$curdt,'updatedon'=>$curdt);
               $categoryid = $this->common->insertTableData('tb_shipment_rate_categories',$arr);
            }
            $ratearr = array('shift_id'=>$shipinsert,'category'=>$categoryid,'rate'=>$cost,'status'=>1,'created_on'=>$curdt,'updated_on'=>$curdt);
            $insrate = $this->common->insertTableData('tb_shipment_rates',$ratearr);
         }
      }
      /* end add rates */
      $response = array('id'=>$ship_id,'place'=>$sfrom,'slat'=>$slat,'slng'=>$slng,'weight'=>$weight,'volume'=>$volume,'shift_id'=>$shipinsert);
      return $response;
   }

   public function integrateshipment($ship_id)
   {
      $curdt = date('Y-m-d H:i:s');
      $uid = 1;
      $whr = array('id'=>$ship_id);
      $response = array();
      $select = 'id,shipid,txnid,trucktype,unitspec,insertusr,carrier,insertuserdate,enddate,logdate,reason,transport_mode,domainname';
      $table = 'tb_shipments';
      $shipdata = $this->common->gettblrowdata($whr,$select,$table,0,0);
      if(count($shipdata) > 0){
         // Check truck type
         $trucktype = $shipdata['trucktype'];
         $whr1 = array('trucktype'=>$trucktype);
         $select1 = 'id';
         $table1 = 'tb_trucktypes';
         $chktrucktype = $this->common->gettblrowdata($whr1,$select1,$table1,0,0);
         if(count($chktrucktype) == 0){
            $insdata = array('trucktype'=>$trucktype, 'description'=>$trucktype, 'status'=>'Active', 'createdon'=>$curdt, 'updatedon'=>$curdt);
            $ttype_id = $this->common->insertTableData('tb_trucktypes',$insdata);
         }
         // Insert Stops in tb_employee(shipments/stops) table
         $whr2 = array('shipment_id'=>$ship_id);
         $select2 = '*';
         $table2 = 'tb_shipment_stops';
         $getstops = $this->common->gettbldata($whr2,$select2,$table2,0,0);
         // Create shipment
         $shipment = $this->createshipment($ship_id,$uid,$curdt,$shipdata['unitspec'],$shipdata['transport_mode'],$shipdata['shipid'],$shipdata['insertuserdate'],$shipdata['enddate'],$shipdata['txnid'],$shipdata['domainname']);
         // Check Customer
         $cust_id = $this->checkcustomer($shipdata['insertusr'],$shipment,$uid,$curdt);
         $carrier_id = $this->checkcarrier($shipdata['carrier'],$shipment,$uid,$curdt);
         // Create Shipment Stops
         $stopings = $this->createstops($getstops,$cust_id,$carrier_id,$shipdata,$shipment,$uid,$curdt);
         /*$updatefromto = $this->updatefromtoship($shipdata['id'],$shipment['shift_id']);*/
         // update shipment for customer id
         $uset = array('customer_id'=>$cust_id,'vendor_id'=>$carrier_id);
         $uwhr = array('id'=>$shipment['shift_id']);
         $updatecust = $this->db->set($uset)->where($uwhr)->update('tb_shifts');
         $response = array('shipment_id'=>$shipment['shift_id']);
      }
      return $response;
   }

   public function updatefromtoship($shipmentid,$shftid){
      $get = $this->db->select('location')->order_by('stopnumber','DESC')->get_where('tb_shipment_stops',array('shipment_id'=>$shipmentid),1,0);
         $loc = $get->row()->location;
         $stable = $this->db->query("select locationname,city,latitude,longitude from tb_shipment_locations where shipment_id=$shipmentid and (locationid='".$loc."' OR address='".$loc."') LIMIT 1");
         if($stable->num_rows() > 0){
            $lat = $stable->row()->latitude;
            $lng = $stable->row()->latitude;
            $loc = $stable->row()->locationname.', '.$stable->row()->city;
         }else{
            $lat = '';
            $lng = '';
         }
      $upd = $this->db->where(array('id'=>$shftid))->update('tb_shifts',array('eplace'=>$get->row()->location,'elat'=>$lat,'elng'=>$lng));
   }

   public function checkcustomer($customer,$shipment,$uid,$curdt){
      $place = $shipment['place'];
      $slat = $shipment['slat'];
      $slng = $shipment['slng'];
      if (strpos($customer, ".") !== false) {
         $chk = explode(".", $customer);
         $cust = $chk[1];
      }else{
         $cust = $customer;
      }
      $cwhr = array('name'=>$cust);
      $ctable = 'tb_customers';
      $cselect = 'id';
      $chkcust = $this->common->gettblrowdata($cwhr,$cselect,$ctable,0,0);
      if(count($chkcust) > 0){
         $cust_id = $chkcust['id'];
      }else{
         $randnum = rand(1111111111,9999999999);
         $pwd = password_hash($randnum, PASSWORD_DEFAULT);
         $cinsdata = array('name'=>$cust, 'phone'=>$randnum, 'location'=>$place, 'address'=>$place, 'email_id'=>'', 'password'=>$pwd, 'user_id'=>$uid, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt, 'lat'=>$slat, 'lng'=>$slat);
         $cust_id = $this->common->insertTableData('tb_customers',$cinsdata);
      }
      return $cust_id;
   }

   public function checkcarrier($carrier,$shipment,$uid,$curdt){
      $place = $shipment['place'];
      $slat = $shipment['slat'];
      $slng = $shipment['slng'];
      if (strpos($carrier, ".") !== false) {
         $chk = explode(".", $carrier);
         $cust = $chk[1];
      }else{
         $cust = $carrier;
      }
      $cwhr = array('name'=>$cust);
      $ctable = 'tb_vendors';
      $cselect = 'id';
      $chkcust = $this->common->gettblrowdata($cwhr,$cselect,$ctable,0,0);
      if(count($chkcust) > 0){
         $cust_id = $chkcust['id'];
      }else{
         /*$pwd = mt_rand(4,6);*/
         $randnum = rand(1111111111,9999999999);
         $pwd = password_hash($randnum, PASSWORD_DEFAULT);
         $cinsdata = array('name'=>$cust, 'mobile'=>$randnum, 'address'=>$place, 'password'=>$pwd,'email'=>'', 'offering_type'=>'FTL', 'carrier_grade'=>'ABC', 'effective_date'=>date('Y-m-d'), 'expiry_date'=>date('Y-m-d'), 'service_id'=>'', 'service_name'=>'', 'user_id'=>$uid, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
         $cust_id = $this->common->insertTableData('tb_vendors',$cinsdata);
      }
      return $cust_id;
   }

   public function createstops($getstops,$customer,$carrierid,$ship,$shipment,$uid,$curdt){
      $i = 0;
      $content = $ship['unitspec'];
      $ship_id = $ship['id'];
      $shift_id = $shipment['shift_id'];
      foreach($getstops as $stop){
         $stopname = $address = $stopcity = $stop['location'];
         $plat1 = $plng1 = $txncode = "";
         $swhr = array('status'=>1,'shipment_id'=>$ship_id,'locationid'=>$stop['location']);
         $stable = 'tb_shipment_locations';
         $getlocs = $this->common->gettblrowdata($swhr,'*',$stable,0,0);
         if(count($getlocs)>0){
            $txncode = $getlocs['txncode'];
            $stopname = $getlocs['locationname'];
            $stopcity = $getlocs['city'];
            $address = $getlocs['locationname'].', '.$getlocs['city'].', '.$getlocs['address'].', '.$getlocs['postalcode'].', '.$getlocs['countrycode'];
            $serviceprovider = '';
            if($getlocs['serviceprovider'] != ""){
               $serviceprovider = $getlocs['serviceprovider'];
            }
            $plat1 = $getlocs['latitude'];
            $plng1 = $getlocs['longitude'];
         }
         $stoptype = $stop['stoptype'];
         $stopinsdata = array('stopname'=>$stopname, 'plat'=>$plat1, 'plng'=>$plng1, 'stopcity'=>$stopcity, 'address'=>$address, 'stoptype'=>$stoptype, 'shipment_id'=>$shift_id, 'ordernumber'=>$stop['stopnumber'], 'startdate'=>$stop['pickupestimate'], 'enddate'=>$stop['deliveryestimate'], 'weight'=>$shipment['weight'], 'volume'=>$shipment['volume'], 'shipmentstopid'=>$stop['id'], 'serviceprovider'=>$serviceprovider, 'txncode'=>$txncode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
         $stopid = $this->common->insertTableData('tb_shiporder_stops',$stopinsdata);
      }
      $chkqry = $this->db->query("SELECT id,shipmentstopid,startdate,enddate FROM tb_shiporder_stops WHERE shipment_id='$shift_id' ORDER BY id ASC");
      if($chkqry->num_rows()>0){
         foreach($chkqry->result_array() as $stop_id){
            $associd = time();
            $pwd = mt_rand(4,6);
            $stoplegs = $this->db->get_where('tb_shipmentstop_legs',array('stopid'=>$stop_id['shipmentstopid'],'shipment_id'=>$ship_id,'stoptype'=>'P'));
            if($stoplegs->num_rows() > 0){
               $j = 1;
               $p = $d = $orderid = 0;
               foreach($stoplegs->result() as $res){
                  $shipunit = $res->shipmentunit;
                  $dropstopid = $stop_id['id'];
                  $qry = $this->db->query("SELECT r.orderid FROM tb_shipment_orders r,tb_order_units o WHERE r.shipment_id=o.shipment_id AND r.id=o.order_id AND (o.lineunitid='".$shipunit."' OR o.unitid='".$shipunit."') AND r.shipment_id='$ship_id' LIMIT 1");
                  if($qry->num_rows()>0){
                     $orderid = $qry->row()->orderid;
                  }
                  if($orderid == 0){
                     $chkord = explode('-', $shipunit);
                     if(!empty($chkord)){
                        $orderid = $chkord[0];
                     }
                  }
                  $chkdrop = $this->db->query("SELECT stopid,stoptype FROM tb_shipmentstop_legs WHERE stoptype='D' AND shipment_id='$ship_id' AND shipmentunit='".$shipunit."'");
                  if($chkdrop->num_rows() > 0){
                     if($chkdrop->row()->stopid != $stop_id['shipmentstopid']){
                        $arr1 = array('shipmentstopid'=>$chkdrop->row()->stopid);
                        $dropstopid = $this->db->select('id')->get_where('tb_shiporder_stops',$arr1,1,0)->row()->id;
                        $d = 1;
                     }else{
                        $p = 1;
                        $d = 1;
                     }
                  }else{
                     $p = 1;
                  }
                  $customer = $this->checkcustomer($res->customer,$shipment,$uid,$curdt);
                  $uwhr = array('status'=>1,'shipment_id'=>$ship_id,'unitid'=>$shipunit);
                  $getunits = $this->common->gettblrowdata($uwhr,'*','tb_shipment_units',1,0);
                  $weight = $volume = 0;
                  $slat = $slng = $elat = $elng = $scity = $dcity = "";
                  $sfrom = $stopname;
                  $dfrom = $stopname;
                  $dfromaddr = $stopname;
                  $materialid = $unitcontent = $noofpkgs = 0;
                  if(count($getunits)>0){
                     $weight = $getunits['weight'];
                     $volume = $getunits['volume'];
                     $sfrom = $getunits['fromlocation'];
                     $dfrom = $getunits['tolocation'];
                     $material = $getunits['material'];
                     $unitcontent = $getunits['unitcontent'];
                     $noofpkgs = $getunits['pkg_item_count'];
                     if($material != ""){
                        $mt = $this->db->select('id')->get_where('tb_materials',array('material'=>$material),1,0);
                        if($mt->num_rows() > 0){
                           $materialid = $mt->row()->id;
                        }else{
                           $arr = array('material'=>$material,'status'=>'Active','createdon'=>$curdt,'updatedon'=>$curdt);
                           $materia = $this->db->insert('tb_materials',$arr);
                           $materialid = $this->db->insert_id();
                        }
                     }
                  }
                  $slatlng = $this->common->getlatlngs($ship_id,$sfrom);
                  if($slatlng->num_rows() > 0){
                     $slat = $slatlng->row()->latitude;
                     $slng = $slatlng->row()->longitude;
                     $sfrom = $slatlng->row()->locationname;
                     $scity = $slatlng->row()->city;
                     $sfromaddr = $slatlng->row()->address;
                  }
                  $dlatlng = $this->common->getlatlngs($ship_id,$dfrom);
                  if($dlatlng->num_rows() > 0){
                     $elat = $dlatlng->row()->latitude;
                     $elng = $dlatlng->row()->longitude;
                     $dfrom = $dlatlng->row()->locationname;
                     $dcity = $dlatlng->row()->city;
                     $dfromaddr = $dlatlng->row()->address;
                  }
                  $insdata = array('assoc_id'=>$associd, 'pickup'=>$sfrom, 'plat'=>$slat, 'plng'=>$slng, 'drop'=>$dfrom, 'dlat'=>$elat, 'dlng'=>$elng, 'pickup_city'=>$scity, 'drop_city'=>$dcity, 'pickup_datetime'=>$stop_id['startdate'],  'drop_datetime'=>$stop_id['enddate'],  'name'=>$content, 'phone'=>'123456789', 'address'=>$sfromaddr, 'user_id'=>$uid, 'password'=>$pwd, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt, 'material_id'=>$materialid, 'capacity'=>$weight, 'information'=>$ship['reason'], 'shipment_weight'=>$weight, 'shipment_volume'=>$volume, 'ship_type'=>$res->stoptype, 'customer_id'=>$customer, 'vendor_id'=>$carrierid, 'startdate'=>$stop_id['startdate'], 'enddate'=>$stop_id['enddate'], 'shipment_id'=>$ship_id, 'shift_id'=>$shipment['shift_id'], 'stop_order'=>$j, 'stop_id'=>$stop_id['id'], 'drop_stopid'=>$dropstopid, 'order_id'=>$orderid, 'pkgitemid'=>$unitcontent, 'no_of_pkgs'=>$noofpkgs);
                  $stop_id1 = $this->common->insertTableData('tb_employee',$insdata);
                  $upd = $this->db->set(array('weight'=>$weight,'volume'=>$volume))->where(array('id'=>$stop_id['id']))->update('tb_shiporder_stops');
                  $j++;
               }
               if($p > 0 && $d > 0){
                  $upd = $this->db->set(array('stoptype'=>'PD'))->where(array('id'=>$stopid))->update('tb_shiporder_stops');
               }else if($p > 0){
                  $upd = $this->db->set(array('stoptype'=>'P'))->where(array('id'=>$stopid))->update('tb_shiporder_stops');
               }else if($d > 0){
                  $upd = $this->db->set(array('stoptype'=>'D'))->where(array('id'=>$stopid))->update('tb_shiporder_stops');
               }
            }
         }
      }
   }

   public function insertShipData($data,$logdate){
      $curdt = date('Y-m-d H:i:s');
      $result = 0;
      $shipdata = array('shipid'=>$data['shipid'], 'txnid'=>$data['txnid'], 'trucktype'=>$data['trucktype'], 'pickupcnt'=>$data['pickupcnt'], 'dropcnt'=>$data['dropcnt'], 'unitspec'=>$data['unitspec'], 'insertusr'=>$data['insertusr'], 'carrier'=>$data['carrier'], 'insertuserdate'=>$data['insertdate'], 'enddate'=>$data['enddate'], 'insdate'=>$data['insdate'], 'upddate'=>$data['upddate'], 'reason'=>$data['reason'], 'purpose'=>$data['purpose'], 'ship_object'=>$data['object'], 'logdate'=>$logdate, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt, 'transport_mode'=>$data['tnsmode'], 'txncode'=>$data['txncode'],'domainname'=>$data['domainname']);
      $ship_id = $this->common->insertTableData('tb_shipments',$shipdata);
      if($ship_id > 0){
         // add shipment cost
         if(count($data['rates'])>0){
            foreach($data['rates'] as $rt){
               $arr = array('shipment_id'=>$ship_id, 'costtype'=>$rt['costtype'], 'rate'=>$rt['cost'], 'currency'=>$rt['currency'], 'status'=>1, 'created_on'=>$curdt);
               $inscost = $this->common->insertTableData('tb_shipment_otmcosts',$arr);
            }
         }
         $result = $ship_id;
         foreach($data['locations'] as $res){
            $locdata = array('shipment_id'=>$ship_id, 'locationid'=>$res['locationid'], 'locationname'=>$res['locationname'], 'city'=>$res['city'], 'address'=>$res['address'], 'postalcode'=>$res['postalcode'], 'countrycode'=>$res['countrycode'], 'latitude'=>$res['latitude'], 'longitude'=>$res['longitude'], 'serviceprovider'=>$res['serviceprovider'],'txncode'=>$res['txncode'], 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
            $insdata = $this->common->insertTableData('tb_shipment_locations',$locdata);
         }

         foreach($data['stops'] as $stop){
            $stopdata = array('shipment_id'=>$ship_id, 'stopnumber'=>$stop['stopnumber'], 'stopduration'=>$stop['stopduration'], 'location'=>$stop['location'], 'stopcustomer'=>$stop['stopcustomer'], 'distfrmprevious'=>$stop['distfrmprevious'], 'pickupplanned'=>$stop['pickupplanned'], 'pickupestimate'=>$stop['pickupestimate'], 'deliveryplan'=>$stop['deliveryplan'], 'deliveryestimate'=>$stop['deliveryestimate'], 'stoptype'=>$stop['stoptype'], 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
            $insdataid = $this->common->insertTableData('tb_shipment_stops',$stopdata);
            if(count($stop['pickdropdata']) > 0){
               foreach($stop['pickdropdata'] as $res){
                  $stoplegdata = array('stopid'=>$insdataid, 'stoptype'=>$res['arract'], 'shipment_id'=>$ship_id, 'shipmentunit'=>$res['arrashipunit'], 'customer'=>$res['customer'], 'duration'=>$res['arractduration'], 'status'=>1, 'createdon'=>$curdt);
                  $insdata = $this->common->insertTableData('tb_shipmentstop_legs',$stoplegdata);
               }
            }
         }

         foreach($data['getshipunits'] as $unit){
            $unitdata = array('shipment_id'=>$ship_id, 'unitid'=>$unit['unitid'], 'fromlocation'=>$unit['fromlocation'], 'tolocation'=>$unit['tolocation'], 'weight'=>$unit['weight'], 'weightuom'=>$unit['weightuom'], 'volume'=>$unit['volume'], 'volumeuom'=>$unit['volumeuom'], 'unitcustomer'=>$unit['unitcustomer'], 'unitcontent'=>$unit['unitcontent'], 'pkg_item_count'=>$unit['pkg_item_count'], 'material'=>$unit['material'], 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
            $insdata = $this->common->insertTableData('tb_shipment_units',$unitdata);
         }

         foreach($data['getshiporder'] as $ord){
            $orddata = array('shipment_id'=>$ship_id, 'orderid'=>$ord['orderid'], 'ordcustomer'=>$ord['ordcustomer'], 'fromlocation'=>$ord['fromlocation'], 'tolocation'=>$ord['tolocation'], 'weight'=>$ord['weight'], 'weightuom'=>$ord['weightuom'], 'volume'=>$ord['volume'], 'volumeuom'=>$ord['volumeuom'], 'txncode'=>$ord['txncode'], 'status'=>1, 'createdon'=>$curdt);
            $ordid = $this->common->insertTableData('tb_shipment_orders',$orddata);
            if(count($ord['shipunits'])>0){
               foreach($ord['shipunits'] as $or){
                  if($or != ""){
                     $arr1 = array('unitid'=>$or,'lineunitid'=>$ord['lineunitid'],'shipment_id'=>$ship_id,'order_id'=>$ordid);
                     $ins = $this->common->insertTableData('tb_order_units',$arr1);
                  }
               }
            }
         }
      }
      return $result;
   }

   public function get_shipmentdata($data){
      $res = array();
      if(!empty($data)){
         $txnid = isset($data['GLogXMLElement']['TransactionHeader']['SenderTransactionId']) ? $data['GLogXMLElement']['TransactionHeader']['SenderTransactionId'] : "";
         $insdate = date('Y-m-d H:i:s',strtotime($data['GLogXMLElement']['TransactionHeader']['ObjectModInfo']['InsertDt']['GLogDate']));
         $upddt = isset($data['GLogXMLElement']['TransactionHeader']['ObjectModInfo']['UpdateDt']['GLogDate']) ? $data['GLogXMLElement']['TransactionHeader']['ObjectModInfo']['UpdateDt']['GLogDate'] : '';
         if($upddt != ""){
            $upddate = date('Y-m-d H:i:s',strtotime($upddt));
         }else{
            $upddate = date('Y-m-d H:i:s');
         }
         $reason = isset($data['GLogXMLElement']['TransactionHeader']['SendReason']['Remark']['RemarkText']) ? $data['GLogXMLElement']['TransactionHeader']['SendReason']['Remark']['RemarkText'] : "";
         $purpose = isset($data['GLogXMLElement']['TransactionHeader']['SendReason']['SendReasonGid']['Gid']['Xid']) ? $data['GLogXMLElement']['TransactionHeader']['SendReason']['SendReasonGid']['Gid']['Xid'] : "";
         $object = isset($data['GLogXMLElement']['TransactionHeader']['SendReason']['ObjectType']) ? $data['GLogXMLElement']['TransactionHeader']['SendReason']['ObjectType']: "";
         $shipdetail = $this->getshipments($data['GLogXMLElement']['PlannedShipment']['Shipment']);
         $res = array('txnid'=>$txnid,'insdate'=>$insdate,'upddate'=>$upddate,'reason'=>$reason,'reason1'=>$shipdetail['reason'],'purpose'=>$purpose,'object'=>$object,'stops'=>$shipdetail['stops'],'locations'=>$shipdetail['locations'],'getshipunits'=>$shipdetail['getshipunits'],'getshiporder'=>$shipdetail['getshiporder'],'shipid'=>$shipdetail['shipid'],'trucktype'=>$shipdetail['trucktype'],'pickupcnt'=>$shipdetail['pickupcnt'],'dropcnt'=>$shipdetail['dropcnt'],'unitspec'=>$shipdetail['unitspec'],'insertusr'=>$shipdetail['insertusr'],'insertdate'=>$shipdetail['insertdate'],'enddate'=>$shipdetail['enddate'],'carrier'=>$shipdetail['carrier'],'tnsmode'=>$shipdetail['tnsmode'],'rates'=>$shipdetail['rates'],'txncode'=>$shipdetail['txncode'],'domainname'=>$shipdetail['domainname']);
      }
      return $res;
   }

   public function getshipments($data){
      $res = array();
      $reason = 'SHIPMENT';
      if(isset($data['ShipmentHeader']['SendReason'])){
         $reason = $data['ShipmentHeader']['SendReason']['Remark']['RemarkText'];
      }
      $shipid = mt_rand();
      if(isset($data['ShipmentHeader']['ShipmentGid'])){
         $shipid = $data['ShipmentHeader']['ShipmentGid']['Gid']['Xid'];
      }
      $txncode = isset($data['ShipmentHeader']['TransactionCode']) ? $data['ShipmentHeader']['TransactionCode'] : 'NP';
      $tnsmode = 'TL';
      if(isset($data['ShipmentHeader']['TransportModeGid'])){
         $tnsmode = $data['ShipmentHeader']['TransportModeGid']['Gid']['Xid'];
      }
      $trucktype = isset($data['SEquipment']['EquipmentGroupGid']['Gid']['Xid']) ? $data['SEquipment']['EquipmentGroupGid']['Gid']['Xid'] : '';
      if($trucktype == ""){
         $trucktype = isset($data['SEquipment']['SEquipmentGid']['Gid']['Xid']) ? $data['SEquipment']['SEquipmentGid']['Gid']['Xid'] : '';
      }
      if($trucktype == ""){
         $trucktype = 'Truck';
      }
      $pickupcnt = isset($data['SEquipment']['ShipmentSEquipmentInfo']['PickupStopNum']) ? $data['SEquipment']['ShipmentSEquipmentInfo']['PickupStopNum'] : '';
      if($pickupcnt == ""){
         $pickupcnt = 1;
      }
      $dropcnt = isset($data['SEquipment']['ShipmentSEquipmentInfo']['DropoffStopNum']) ? $data['SEquipment']['ShipmentSEquipmentInfo']['DropoffStopNum'] : '';
      if($dropcnt == ""){
         $dropcnt = 1;
      }
      $getstops = $this->getstops($data['ShipmentStop']);
      $getlocations = $this->getlocations($data['Location']);
      $getshipunits = $this->getShipUnits($data['ShipUnit']);
      $rates = array();
      if(isset($data['ShipmentHeader']['ShipmentCost'])){
         $rates = $this->getshiprates($data['ShipmentHeader']['ShipmentCost']);
      }
      $getshiporder = array();
      if(isset($data['Release'])){
         $getshiporder = $this->getShipReleases($data['Release']);
      }

      $unitspec = 'Boxes';
      if(isset($data['ShipUnitSpec'])){
         $unitspec = $data['ShipUnitSpec']['ShipUnitSpecGid']['Gid']['Xid'];
      }
      $insertusr = isset($data['RATE_OFFERING']['RATE_OFFERING_ROW']['INSERT_USER']) ? $data['RATE_OFFERING']['RATE_OFFERING_ROW']['INSERT_USER'] : '';
      $domainname = "INFD";
      if($insertusr == ""){
         $insertusr = isset($data['ShipmentHeader']['ShipmentGid']['Gid']['DomainName']) ? $data['ShipmentHeader']['ShipmentGid']['Gid']['DomainName'] : '';
         if($insertusr != ""){
            $chk = explode("/", $insertusr);
            if(isset($chk[1])){
               $insertusr = trim($chk[1]);
            }
            $domainname = trim($chk[0]);
         }
      }
      if($insertusr == ""){ $insertusr = 'SCAHY';}
      $carrier = isset($data['ShipmentHeader']['ServiceProviderGid']['Gid']['Xid']) ? $data['ShipmentHeader']['ServiceProviderGid']['Gid']['Xid'] : '';
      $insertdate = isset($data['RATE_OFFERING']['RATE_OFFERING_ROW']['INSERT_DATE']) ? $data['RATE_OFFERING']['RATE_OFFERING_ROW']['INSERT_DATE'] : '';
      if($insertdate == ""){
         $insertdate = isset($data['ShipmentHeader']['StartDt']['GLogDate']) ? $data['ShipmentHeader']['StartDt']['GLogDate'] : '';
         if($insertdate != ""){
            $insertdate = date('Y-m-d H:i:s',strtotime($insertdate));
         }
      }
      $enddate = isset($data['ShipmentHeader']['EndDt']['GLogDate']) ? $data['ShipmentHeader']['EndDt']['GLogDate'] : '';
      if($enddate != ""){
         $enddate = date('Y-m-d H:i:s',strtotime($enddate));
      }
      $res = array('stops'=>$getstops,'locations'=>$getlocations,'getshipunits'=>$getshipunits,'getshiporder'=>$getshiporder,'reason'=>$reason,'shipid'=>$shipid,'trucktype'=>$trucktype,'pickupcnt'=>$pickupcnt,'dropcnt'=>$dropcnt,'unitspec'=>$unitspec,'insertusr'=>$insertusr,'insertdate'=>$insertdate,'enddate'=>$enddate,'carrier'=>$carrier,'tnsmode'=>$tnsmode,'rates'=>$rates,'txncode'=>$txncode,'domainname'=>$domainname);
      return $res;
   }

   public function getshiprates($data){
      $res = array();
      if(!empty($data)){
         $chktype = isset($data[0]['Cost']['FinancialAmount']['MonetaryAmount']) ? $data[0]['Cost']['FinancialAmount']['MonetaryAmount'] : '';
         $costtype = isset($data['CostType']) ? $data['CostType'] : 'B';
         if($chktype != ""){
            foreach ($data as $dt){
               $shipcost = isset($dt['Cost']['FinancialAmount']['MonetaryAmount']) ? $dt['Cost']['FinancialAmount']['MonetaryAmount'] : 0;
               $currencycode = isset($dt['Cost']['FinancialAmount']['GlobalCurrencyCode']) ? $dt['Cost']['FinancialAmount']['GlobalCurrencyCode'] : 'INR';
               $res[] = array('cost'=>$shipcost,'currency'=>$currencycode,'costtype'=>$costtype);
            }
         }else{
            $shipcost = isset($data[0]['Cost']['FinancialAmount']['MonetaryAmount']) ? $data[0]['Cost']['FinancialAmount']['MonetaryAmount'] : 0;
            $currencycode = isset($data[0]['Cost']['FinancialAmount']['GlobalCurrencyCode']) ? $data[0]['Cost']['FinancialAmount']['GlobalCurrencyCode'] : 'INR';
            $res[] = array('cost'=>$shipcost,'currency'=>$currencycode,'costtype'=>$costtype);
         }
      }
      return $res;
   }
   public function getlocations($data){
      $res = array();
      if(!empty($data)){
         foreach ($data as $dt) {
            $sp = isset($dt['ServiceProvider']) ? $dt['ServiceProvider']['ServiceProviderAlias']['ServiceProviderAliasQualifierGid']['Gid']['Xid'] : '';
            $city = isset($dt['Address']['City']) ? $dt['Address']['City'] : '';
            $txncode = isset($dt['TransactionCode']) ? $dt['TransactionCode'] : 'NP';
            $postalcode = isset($dt['Address']['PostalCode']) ? $dt['Address']['PostalCode'] : '';
            $addrlines =  isset($dt['Address']['AddressLines']['AddressLine']) ? $dt['Address']['AddressLines']['AddressLine'] : '';
            $res[] = array('locationid'=>$dt['LocationGid']['Gid']['Xid'],'locationname'=>$dt['LocationName'],'city'=>$city,'address'=>$addrlines,'postalcode'=>$postalcode,'countrycode'=>$dt['Address']['CountryCode3Gid']['Gid']['Xid'],'latitude'=>$dt['Address']['Latitude'],'longitude'=>$dt['Address']['Longitude'],'serviceprovider'=>$sp,'txncode'=>$txncode);
         }
      }
      return $res;
   }

   public function getShipUnits($data){
      $res = array();
      if(!empty($data)){
         $chktype = isset($data[0]['ShipUnitGid']['Gid']['Xid']) ? $data[0]['ShipUnitGid']['Gid']['Xid'] : '';
         if($chktype != ""){
            foreach ($data as $dt) {
               /*$pkgitemcnt = isset($dt['ShipUnitContent']['PackagedItemSpecCount']) ? $dt['ShipUnitContent']['PackagedItemSpecCount'] : '';*/
               $pkgitemcnt = isset($dt['ShipUnitContent']['ItemQuantity']['PackagedItemCount']) ? $dt['ShipUnitContent']['ItemQuantity']['PackagedItemCount'] : '';
               if($pkgitemcnt == ''){
                  $pkgitemcnt = isset($dt['ShipUnitCount']) ? $dt['ShipUnitCount'] : 0;
               }
               if($pkgitemcnt == ""){ $pkgitemcnt = 0; }
               $material = isset($dt['TransportHandlingUnitRef']['ShipUnitSpecRef']['ShipUnitSpecGid']['Gid']['Xid']) ? $dt['TransportHandlingUnitRef']['ShipUnitSpecRef']['ShipUnitSpecGid']['Gid']['Xid'] : '';
               $shipunitid = isset($dt['ShipUnitGid']['Gid']['Xid']) ? $dt['ShipUnitGid']['Gid']['Xid'] : '';
               $unitcustomer = isset($dt['ShipUnitGid']['Gid']['DomainName']) ? $dt['ShipUnitGid']['Gid']['DomainName'] : '';
               if($unitcustomer != ""){
                  $chk = explode("/", $unitcustomer);
                  if(isset($chk[1])){
                     $unitcustomer = trim($chk[1]);
                  }
               }
               $fromlocation = isset($dt['ShipFromLocationRef']['LocationRef']['LocationGid']['Gid']['Xid']) ? $dt['ShipFromLocationRef']['LocationRef']['LocationGid']['Gid']['Xid'] : '';
               $tolocation = isset($dt['ShipToLocationRef']['LocationRef']['LocationGid']['Gid']['Xid']) ? $dt['ShipToLocationRef']['LocationRef']['LocationGid']['Gid']['Xid'] : '';
               $weight = isset($dt['WeightVolume']['Weight']['WeightValue']) ? $dt['WeightVolume']['Weight']['WeightValue'] : '';
               $weightuom = isset($dt['WeightVolume']['Weight']['WeightUOMGid']['Gid']['Xid']) ? $dt['WeightVolume']['Weight']['WeightUOMGid']['Gid']['Xid'] : '';
               $volume = isset($dt['WeightVolume']['Volume']['VolumeValue']) ? $dt['WeightVolume']['Volume']['VolumeValue'] : '';
               $volumeuom = isset($dt['WeightVolume']['Volume']['VolumeUOMGid']['Gid']['Xid']) ? $dt['WeightVolume']['Volume']['VolumeUOMGid']['Gid']['Xid'] : '';
               $unitcontent = isset($dt['ShipUnitContent']['PackagedItemRef']['PackagedItemGid']['Gid']['Xid']) ? $dt['ShipUnitContent']['PackagedItemRef']['PackagedItemGid']['Gid']['Xid'] : '';
               $res[] = array('unitid'=>$shipunitid,'unitcustomer'=>$unitcustomer,'fromlocation'=>$fromlocation,'tolocation'=>$tolocation,'weight'=>$weight,'weightuom'=>$weightuom,'volume'=>$volume,'volumeuom'=>$volumeuom,'unitcontent'=>$unitcontent,'pkg_item_count'=>$pkgitemcnt,'material'=>$material);
           }
         }else{
            $shipunitid = isset($data['ShipUnitGid']['Gid']['Xid']) ? $data['ShipUnitGid']['Gid']['Xid'] : '';
            $pkgitemcnt = isset($data['ShipUnitContent']['ItemQuantity']['PackagedItemCount']) ? $data['ShipUnitContent']['ItemQuantity']['PackagedItemCount'] : '';
            if($pkgitemcnt == ''){
               $pkgitemcnt = isset($data['ShipUnitCount']) ? $data['ShipUnitCount'] : 0;
            }
            if($pkgitemcnt == ""){ $pkgitemcnt = 0; }
            $material = isset($data['TransportHandlingUnitRef']['ShipUnitSpecRef']['ShipUnitSpecGid']['Gid']['Xid']) ? $data['TransportHandlingUnitRef']['ShipUnitSpecRef']['ShipUnitSpecGid']['Gid']['Xid'] : '';
            $unitcustomer = isset($data['ShipUnitGid']['Gid']['DomainName']) ? $data['ShipUnitGid']['Gid']['DomainName'] : '';
            if($unitcustomer != ""){
               $chk = explode("/", $unitcustomer);
               if(isset($chk[1])){
                  $unitcustomer = trim($chk[1]);
               }
            }
            $fromlocation = isset($data['ShipFromLocationRef']['LocationRef']['LocationGid']['Gid']['Xid']) ? $data['ShipFromLocationRef']['LocationRef']['LocationGid']['Gid']['Xid'] : '';
            $tolocation = isset($data['ShipToLocationRef']['LocationRef']['LocationGid']['Gid']['Xid']) ? $data['ShipToLocationRef']['LocationRef']['LocationGid']['Gid']['Xid'] : '';
            $weight = isset($data['WeightVolume']['Weight']['WeightValue']) ? $data['WeightVolume']['Weight']['WeightValue'] : 0;
            $weightuom = isset($data['WeightVolume']['Weight']['WeightUOMGid']['Gid']['Xid']) ? $data['WeightVolume']['Weight']['WeightUOMGid']['Gid']['Xid'] : '';
            $volume = isset($data['WeightVolume']['Volume']['VolumeValue']) ? $data['WeightVolume']['Volume']['VolumeValue'] : 0;
            $volumeuom = isset($data['WeightVolume']['Volume']['VolumeUOMGid']['Gid']['Xid']) ? $data['WeightVolume']['Volume']['VolumeUOMGid']['Gid']['Xid'] : '';
            $unitcontent = isset($data['ShipUnitContent']['PackagedItemRef']['PackagedItemGid']['Gid']['Xid']) ? $data['ShipUnitContent']['PackagedItemRef']['PackagedItemGid']['Gid']['Xid'] : '';
            $res[] = array('unitid'=>$shipunitid,'unitcustomer'=>$unitcustomer,'fromlocation'=>$fromlocation,'tolocation'=>$tolocation,'weight'=>$weight,'weightuom'=>$weightuom,'volume'=>$volume,'volumeuom'=>$volumeuom,'unitcontent'=>$unitcontent,'pkg_item_count'=>$pkgitemcnt,'material'=>$material);
         }
      }
      return $res;
   }

   public function getShipReleases($data){
      $res = array();
      if(!empty($data)){
         $chktype = isset($data[0]['ReleaseGid']['Gid']['Xid']) ? $data[0]['ReleaseGid']['Gid']['Xid'] : '';
         if($chktype != ""){
            foreach ($data as $dt) {
               $orderid = isset($dt['ReleaseGid']['Gid']['Xid']) ? $dt['ReleaseGid']['Gid']['Xid'] : '';
               $lineunitid = isset($dt['ReleaseLine']['ReleaseLineGid']['Gid']['Xid']) ? $dt['ReleaseLine']['ReleaseLineGid']['Gid']['Xid'] : '';
               $ordcustomer = isset($dt['ReleaseGid']['Gid']['DomainName']) ? $dt['ReleaseGid']['Gid']['DomainName'] : '';
               if($ordcustomer != ""){
                  $chk = explode("/", $ordcustomer);
                  if(isset($chk[1])){
                     $ordcustomer = trim($chk[1]);
                  }
               }
               $txncode = isset($dt['TransactionCode']) ? $dt['TransactionCode'] : 'NP';
               $fromlocation = isset($dt['ShipFromLocationRef']['LocationRef']['LocationGid']['Gid']['Xid']) ? $dt['ShipFromLocationRef']['LocationRef']['LocationGid']['Gid']['Xid'] : '';
               $tolocation = isset($dt['ShipToLocationRef']['LocationRef']['LocationGid']['Gid']['Xid']) ? $dt['ShipToLocationRef']['LocationRef']['LocationGid']['Gid']['Xid'] : '';
               $shipunit  = isset($dt['ShipUnit'][0]['ShipUnitGid']['Gid']['Xid']) ? $dt['ShipUnit'][0]['ShipUnitGid']['Gid']['Xid'] : '';
               $units = array();
               if($shipunit != ""){
                  foreach($dt['ShipUnit'] as $unitinfo){
                     $units[] = isset($unitinfo['ShipUnitGid']['Gid']['Xid']) ? $unitinfo['ShipUnitGid']['Gid']['Xid'] : '';
                  }
               }else{
                  $units[] = isset($dt['ShipUnit']['ShipUnitGid']['Gid']['Xid']) ? $dt['ShipUnit']['ShipUnitGid']['Gid']['Xid'] : '';
               }
               $weight = 0;//isset($dt['TotalWeightVolume']['WeightVolume']['Weight']['WeightValue']) ? $dt['WeightVolume']['Weight']['WeightValue'] : '';
               $weightuom = 0;//isset($dt['TotalWeightVolume']['WeightVolume']['Weight']['WeightUOMGid']['Gid']['Xid']) ? $dt['WeightVolume']['Weight']['WeightUOMGid']['Gid']['Xid'] : '';
               $volume = 0;//isset($dt['TotalWeightVolume']['WeightVolume']['Volume']['VolumeValue']) ? $dt['WeightVolume']['Volume']['VolumeValue'] : '';
               $volumeuom = 0;//isset($dt['TotalWeightVolume']['WeightVolume']['Volume']['VolumeUOMGid']['Gid']['Xid']) ? $dt['WeightVolume']['Volume']['VolumeUOMGid']['Gid']['Xid'] : '';
               $res[] = array('orderid'=>$orderid,'lineunitid'=>$lineunitid,'ordcustomer'=>$ordcustomer,'fromlocation'=>$fromlocation,'tolocation'=>$tolocation,'weight'=>$weight,'weightuom'=>$weightuom,'volume'=>$volume,'volumeuom'=>$volumeuom,'shipunits'=>$units,'txncode'=>$txncode);
           }
         }else{
            $orderid = isset($data['ReleaseGid']['Gid']['Xid']) ? $data['ReleaseGid']['Gid']['Xid'] : '';
            $lineunitid = isset($data['ReleaseLine']['ReleaseLineGid']['Gid']['Xid']) ? $data['ReleaseLine']['ReleaseLineGid']['Gid']['Xid'] : '';
            $ordcustomer = isset($data['ReleaseGid']['Gid']['DomainName']) ? $data['ReleaseGid']['Gid']['DomainName'] : '';
            if($ordcustomer != ""){
               $chk = explode("/", $ordcustomer);
               if(isset($chk[1])){
                  $ordcustomer = trim($chk[1]);
               }
            }
            $txncode = isset($data['TransactionCode']) ? $data['TransactionCode'] : 'NP';
            $fromlocation = isset($data['ShipFromLocationRef']['LocationRef']['LocationGid']['Gid']['Xid']) ? $data['ShipFromLocationRef']['LocationRef']['LocationGid']['Gid']['Xid'] : '';
            $tolocation = isset($data['ShipToLocationRef']['LocationRef']['LocationGid']['Gid']['Xid']) ? $data['ShipToLocationRef']['LocationRef']['LocationGid']['Gid']['Xid'] : '';
            $shipunit  = isset($data['ShipUnit'][0]['ShipUnitGid']['Gid']['Xid']) ? $data['ShipUnit'][0]['ShipUnitGid']['Gid']['Xid'] : '';
            $units1 = array();
            if($shipunit != ""){
               foreach($data['ShipUnit'] as $unitinfo){
                  $units1[] = isset($unitinfo['ShipUnitGid']['Gid']['Xid']) ? $unitinfo['ShipUnitGid']['Gid']['Xid'] : '';
               }
            }else{
               $unitid = isset($data['ShipUnit']['ShipUnitGid']['Gid']['Xid']) ? $data['ShipUnit']['ShipUnitGid']['Gid']['Xid'] : '';
               $units1[] = $unitid;
            }
            $weight = isset($dt['TotalWeightVolume']['WeightVolume']['Weight']['WeightValue']) ? $dt['WeightVolume']['Weight']['WeightValue'] : '';
            $weightuom = isset($dt['TotalWeightVolume']['WeightVolume']['Weight']['WeightUOMGid']['Gid']['Xid']) ? $dt['WeightVolume']['Weight']['WeightUOMGid']['Gid']['Xid'] : '';
            $volume = isset($dt['TotalWeightVolume']['WeightVolume']['Volume']['VolumeValue']) ? $dt['WeightVolume']['Volume']['VolumeValue'] : '';
            $volumeuom = isset($dt['TotalWeightVolume']['WeightVolume']['Volume']['VolumeUOMGid']['Gid']['Xid']) ? $dt['WeightVolume']['Volume']['VolumeUOMGid']['Gid']['Xid'] : '';
            $res[] = array('orderid'=>$orderid,'lineunitid'=>$lineunitid,'ordcustomer'=>$ordcustomer,'fromlocation'=>$fromlocation,'tolocation'=>$tolocation,'weight'=>$weight,'weightuom'=>$weightuom,'volume'=>$volume,'volumeuom'=>$volumeuom,'shipunits'=>$units1,'txncode'=>$txncode);
         }
      }
      return $res;
   }

   public function getstops($data){
      $result = array();
      if(!empty($data)){

         foreach ($data as $dt) {
            /*log_message('error',$dt[0]['ArrivalTime']['EventTime']['PlannedTime']['GLogDate']);*/
            $stoptype = isset($dt['StopType']) ? $dt['StopType'] : '';
            if($stoptype == ""){
               $stoptype = isset($dt['ShipmentStopDetail'][0]['Activity']) ? $dt['ShipmentStopDetail'][0]['Activity'] : '';
            }
            if($stoptype == ""){
               $stoptype = isset($dt['ShipmentStopDetail']['Activity']) ? $dt['ShipmentStopDetail']['Activity'] : '';
            }
            if($stoptype == ""){ $stoptype = 'P'; }
            $shipstoplegs = array();
            $acttype = isset($dt['ShipmentStopDetail'][0]['Activity']) ? $dt['ShipmentStopDetail'][0]['Activity'] : '';
            if($acttype != ""){
               foreach($dt['ShipmentStopDetail'] as $res){
                  $arract = isset($res['Activity']) ? $res['Activity'] : 'P';
                  $arrashipunit = isset($res['ShipUnitGid']['Gid']['Xid']) ? $res['ShipUnitGid']['Gid']['Xid'] : '';
                  $customer = isset($res['ShipUnitGid']['Gid']['DomainName']) ? $res['ShipUnitGid']['Gid']['DomainName'] : '';
                  if($customer != ""){
                     $chk = explode("/", $customer);
                     if(isset($chk[1])){
                        $customer = trim($chk[1]);
                     }
                  }
                  $arractduration = isset($res['ActivityDuration']['Duration']['DurationValue']) ? $res['ActivityDuration']['Duration']['DurationValue'] : '';
                  $shipstoplegs[] = array('arract'=>$arract,'arrashipunit'=>$arrashipunit,'customer'=>$customer,'arractduration'=>$arractduration);
               }
            }else{
               $arract = isset($dt['ShipmentStopDetail']['Activity']) ? $dt['ShipmentStopDetail']['Activity'] : '';
               $arractduration = isset($dt['ShipmentStopDetail']['ActivityDuration']['Duration']['DurationValue']) ? $dt['ShipmentStopDetail']['ActivityDuration']['Duration']['DurationValue'] : '';
               $arrashipunit = isset($dt['ShipmentStopDetail']['ShipUnitGid']['Gid']['Xid']) ? $dt['ShipmentStopDetail']['ShipUnitGid']['Gid']['Xid'] : '';
               $customer = isset($dt['ShipmentStopDetail']['ShipUnitGid']['Gid']['DomainName']) ? $dt['ShipmentStopDetail']['ShipUnitGid']['Gid']['DomainName'] : '';
               if($customer != ""){
                  $chk = explode("/", $customer);
                  if(isset($chk[1])){
                     $customer = trim($chk[1]);
                  }
               }
               $shipstoplegs[] = array('arract'=>$arract,'arrashipunit'=>$arrashipunit,'customer'=>$customer,'arractduration'=>$arractduration);
            }
            $stopsequence = isset($dt['StopSequence']) ? $dt['StopSequence'] : 1;
            $stopduration = isset($dt['StopDuration']['Duration']['DurationValue']) ? $dt['StopDuration']['Duration']['DurationValue'] : 0;
            $distfrmprevious = isset($dt['DistFromPrevStop']['Distance']['DistanceValue']) ? $dt['DistFromPrevStop']['Distance']['DistanceValue'] : 0;
            $stoplocation = isset($dt['LocationRef']['LocationGid']['Gid']['Xid']) ? $dt['LocationRef']['LocationGid']['Gid']['Xid'] : '';
            $stopcustomer = isset($dt['LocationRef']['LocationGid']['Gid']['DomainName']) ? $dt['LocationRef']['LocationGid']['Gid']['DomainName'] : '';
            if($stopcustomer != ""){
               $chk = explode("/", $stopcustomer);
               if(isset($chk[1])){
                  $stopcustomer = trim($chk[1]);
               }
            }
            $pickupplanned = date('Y-m-d H:i:s',strtotime($dt['ArrivalTime']['EventTime']['PlannedTime']['GLogDate']));
            $deliveryplan = date('Y-m-d H:i:s',strtotime($dt['DepartureTime']['EventTime']['PlannedTime']['GLogDate']));
            $pickupestimate = date('Y-m-d H:i:s',strtotime($dt['ArrivalTime']['EventTime']['EstimatedTime']['GLogDate']));
            $deliveryestimate = date('Y-m-d H:i:s',strtotime($dt['DepartureTime']['EventTime']['EstimatedTime']['GLogDate']));
            $result[] = array('stopnumber'=>$stopsequence,'stopduration'=>$stopduration,'location'=>$stoplocation,'distfrmprevious'=>$distfrmprevious,'stopcustomer'=>$stopcustomer,'pickupplanned'=>$pickupplanned,'pickupestimate'=>$pickupestimate,'deliveryplan'=>$deliveryplan,'deliveryestimate'=>$deliveryestimate,'stoptype'=>$stoptype,'pickdropdata'=>$shipstoplegs);
         }
      }
      return $result;
   }

   /*public function get_headerdata($data){
      $res = array();
      if(!empty($data)){
         $noofshipments = $data['SenderTransmissionNo'];
         $logdate = date('Y-m-d H:i:s',strtotime($data['TransmissionCreateDt']['GLogDate']));
         $res = array('shipmentcnt'=>$noofshipments,'logdate'=>$logdate);
      }
      return $res;
   }*/

   public function orderstatusapi(){
      $post = array(); /*$this->input->post();*/
      $post['shipment_id'] = "10";
      $post['trip_id'] = "10";
      if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
         $post['source_id'] = 'KN003';
         $post['source_reason_code'] = 'KN003C';
         $post['createdon'] = date('Y-m-d H:i:s');
         $request = '';
         /*$request .= '<?xml version="1.0" encoding="UTF-8"?>';*/
         $request .= '<Transmission>';
         $request .= '<TransmissionHeader>';
         $request .= '<UserName>SGFD/SCAHY.INTEGRATION</UserName>';
         $request .= '<Password>ALLIANCE</Password>';
         $request .= '<AckSpec>';
         $request .= '<ComMethodGid>';
         $request .= '<Gid>';
         $request .= '<Xid>EMAIL</Xid>';
         $request .= '</Gid>';
         $request .= '</ComMethodGid>';
         $request .= '<EmailAddress>athmanathan.gnanavel@Kuehne-Nagel.com</EmailAddress>';
         $request .= '<AckOption>ERROR</AckOption>';
         $request .= '</AckSpec>';
         $request .= '</TransmissionHeader>';
         $request .= '<TransmissionBody>';
         $request .= '<GLogXMLElement>';
         $request .= '<TransOrderStatus>';
         $request .= '<ReleaseGid>';
         $request .= '<Gid>';
         $request .= '<DomainName>SGFD/SCAHY</DomainName>';
         $request .= '<Xid>OR_HAR_MCO_PPD</Xid>';
         $request .= '</Gid>';
         $request .= '</ReleaseGid>';
         $request .= '<Description></Description>';
         $request .= '<StatusLevel>RELEASE</StatusLevel>';
         $request .= '<StatusCodeGid>';
         $request .= '<Gid>';
         $request .= '<DomainName>SGFD/SCAHY</DomainName>';
         $request .= '<Xid>' . $post['source_id'] . '</Xid>';
         $request .= '</Gid>';
         $request .= '</StatusCodeGid>';
         $request .= '<StatusReasonCodeGid>';
         $request .= '<Gid>';
         $request .= '<DomainName>SGFD/SCAHY</DomainName>';
         $request .= '<Xid>' . $post['source_reason_code'] . '</Xid>';
         $request .= '</Gid>';
         $request .= '</StatusReasonCodeGid>';
         $request .= '<TimeZoneGid>';
         $request .= '<Gid>';
         $request .= '<DomainName>PUBLIC</DomainName>';
         $request .= '<Xid>Local</Xid>';
         $request .= '</Gid>';
         $request .= '</TimeZoneGid>';
         $request .= '<EventDt>';
         $request .= '<TZId>Asia/Calcutta</TZId>';
         $request .= '<GLogDate>20190110084400</GLogDate>';
         $request .= '</EventDt>';
         $request .= '<ResponsiblePartyGid>';
         $request .= '<Gid>';
         $request .= '<DomainName>SGFD/SCAHY</DomainName>';
         $request .= '<Xid>KN_CARRIER</Xid>';
         $request .= '</Gid>';
         $request .= '</ResponsiblePartyGid>';
         $request .= '</TransOrderStatus>';
         $request .= '</GLogXMLElement>';
         $request .= '</TransmissionBody>';
         $request .= '</Transmission>';
         $dom = new DOMDocument;
         $dom->preserveWhiteSpace = FALSE;
         $dom->loadXML($request);
         $dom->save('xml/example.xml');
         $serviceurl = OTM_URL;
         $headers = array('Content-Type: application/xml');
         $response = otmbookservicecurl($serviceurl,$headers,$request);
         $responsedata = $this->ordstatusresponse($response, $post);
         echo "1";
      } else {
         echo "0";
      }
   }

   public function ordstatusresponse($response,$post){
      return true;
   }


   public function orderrealesestatusapi(){
      $post = array(); /*$this->input->post();*/
      $post['shipment_id'] = "10";
      $post['trip_id'] = "10";
      if ($post['shipment_id'] != "" && $post['trip_id'] != "") {
         $post['source_id'] = 'KN003';
         $post['source_reason_code'] = 'KN003C';
         $post['createdon'] = date('Y-m-d H:i:s');
         $request = '';
         /*$request .= '<?xml version="1.0" encoding="UTF-8"?>';*/
         $request .= '<Transmission>';
         $request .= '<TransmissionHeader></TransmissionHeader>';
         $request .= '<TransmissionBody>';
         $request .= '<GLogXMLElement>';
         $request .= '<TransactionHeader>';
         $request .= '<SenderTransactionId>36773685</SenderTransactionId>';
         $request .= '<SendReason>';
         $request .= '<Remark>';
         $request .= '<RemarkSequence>1</RemarkSequence>';
         $request .= '<RemarkQualifierGid>';
         $request .= '<Gid>';
         $request .= '<Xid>REM</Xid>';
         $request .= '</Gid>';
         $request .= '<RemarkText>TESTING</RemarkText>';
         $request .= '</RemarkQualifierGid>';
         $request .= '</Remark>';
         $request .= '<SendReasonGid>';
         $request .= '<Gid>';
         $request .= '<Xid>DOCUMENT_EVENT - null</Xid>';
         $request .= '</Gid>';
         $request .= '</SendReasonGid>';
         $request .= '<ObjectType>DOCUMENT</ObjectType>';
         $request .= '</SendReason>';
         $request .= '</TransactionHeader>';
         $request .= '<Document>';
         $request .= '<DocumentGid>';
         $request .= '<Gid>';
         $request .= '<DomainName>NMBKN</DomainName>';
         $request .= '<Xid>EST_POD_REPORT - KNFD_ESTAFETA_EPOD</Xid>';
         $request .= '</Gid>';
         $request .= '</DocumentGid>';
         $request .= '<TransactionCode>NP</TransactionCode>';
         $request .= '<DocumentOwner>';
         $request .= '<DataQueryTypeGid>';
         $request .= '<Gid>';
         $request .= '<Xid>ORDER RELEASE</Xid>';
         $request .= '</Gid>';
         $request .= '</DataQueryTypeGid>';
         $request .= '<ObjectGid>';
         $request .= '<Gid>';
         $request .= '<DomainName>NMBKN</DomainName>';
         $request .= '<Xid>EST_POD_REPORT</Xid>';
         $request .= '</Gid>';
         $request .= '</ObjectGid>';
         $request .= '</DocumentOwner>';
         $request .= '<DocumentContent>';
         $request .= '<DocMimeType>application/vnd.ms-excel</DocMimeType>';
         $request .= '<DocContentBinary></DocContentBinary>';
         $request .= '</DocumentContent>';
         $request .= '</Document>';
         $request .= '</GLogXMLElement>';
         $request .= '</TransmissionBody>';
         $request .= '</Transmission>';
         $dom = new DOMDocument;
         $dom->preserveWhiteSpace = FALSE;
         $dom->loadXML($request);
         $dom->save('xml/example.xml');
         $serviceurl = OTM_URL;
         $headers = array('Content-Type: application/xml');
         $response = otmbookservicecurl($serviceurl,$headers,$request);
         $responsedata = $this->ordreleasestatusresponse($response, $post);
         echo "1";
      } else {
         echo "0";
      }
   }

   public function ordreleasestatusresponse($response,$post){
      return true;
   }
}
