<?php
defined('BASEPATH') or exit('No direct script access allowed');
//edi 307
class RussaCarrierBiteTransit extends CI_Controller
{

    public function __Construct()
    {
        parent::__Construct();

        $this->load->model('TransportOrdermodel');
        $this->load->model('common');
        $this->load->model('Orderdata_jsonmodel');
        $this->load->library("Russacarrier_bitetransit");
    }


    public function index()
    {
        //$this->Orderdata_jsonmodel->gettransportorder('886');
        $this->russacarrier_bitetransit->shipmentdata(1581); //1581 shift_id


    }

    public function getshipmentstatus()
    {
        /*read carrier folders*/
        $localfile = "assets/rufiles/Status307.xml";
        $filedata = file_get_contents($localfile);
        $xml = new SimpleXMLElement($filedata);

        if ($xml === false) {

            echo "no file...";
        } else {
            $getstatusdata = $this->saveorderstatus($xml);
        }
    }





    public function saveorderstatus($stsdata)
    {
        $output = array();

        //print_r($stsdata);

        foreach ((array)$stsdata as $index => $node) {
            $output[$index] = (is_object($node)) ? xml2array($node) : $node;
        }

        if (!empty($output)) {
            $communicationReference = $output['communicationReference'];
            $communicationCounter = $output['communicationCounter'];
            $consignmentNumber = $output['consignmentNumber'];
            $shipment_id = $output['customerConsignmentNumber'];
            $toStatus = $output['toStatus'];


            $status_id = 1;
            if ($toStatus == "PICKUP") {
                $StatusCode = '0500';
            }
            if ($toStatus == "DELIVERY") {
                $StatusCode = '2300';
            }



            $re   = $this->db->select('order_id')->get_where("tb_order_references", array('ref_value' => $communicationReference));

            $ret = $re->row();
            $order_id = $ret->order_id;


            $status = $this->common->gettblrowdata(array("status_code" => $StatusCode, "status" => 1), "id,status_name", "tb_status_master", 0, 0);
            if (count($status) > 0) {
                $status_id = $status['id'];
            }


            $getorderinfo = $this->common->gettblrowdata(array("order_id" => $order_id, "shipmentid" => $shipment_id), "id,user_id,shift_id,trip_id", "tb_orders", 0, 0);


            if (count($getorderinfo) > 0) {
                $trip_id = $getorderinfo['trip_id'];
                $ship_id = $getorderinfo['shift_id'];
                $ord_id = $getorderinfo['id'];
                $countryinfo = getUserIDTimeZone($getorderinfo['user_id']);
                $stsdate = $StatusDate . " " . $StatusTime;
                $stsdate = date("Y-m-d H:i:s", strtotime($stsdate));
                if ($countryinfo['timezone'] != "") {
                    $getactual = getdatetimebytimezone(DFLT_TZ, $stsdate, $countryinfo['timezone']);
                    $stsdate = $getactual['datetime'];
                }

                if (count($getorderinfo) > 0) {
                    $trip_id = $getorderinfo['trip_id'];
                    $ship_id = $getorderinfo['shift_id'];
                    $ord_id = $getorderinfo['id'];
                    $countryinfo = getUserIDTimeZone($getorderinfo['user_id']);
                    $stsdate = $StatusDate . " " . $StatusTime;
                    $stsdate = date("Y-m-d H:i:s", strtotime($stsdate));
                    if ($countryinfo['timezone'] != "") {
                        $getactual = getdatetimebytimezone(DFLT_TZ, $stsdate, $countryinfo['timezone']);
                        $stsdate = $getactual['datetime'];
                    }


                    $stop_type = "P";
                    $stop_id = $stopdetails_id = $vehicle_id = $driver_id = 0;
                    $getstops = $this->common->gettblrowdata(array("shift_id" => $ship_id, "order_id" => $order_id), "id,stop_id,drop_stopid", "tb_employee", 0, 0);
                    if (count($getstops) > 0) {
                        $stopdetails_id = $getstops['id'];
                        if ($StatusCode == "0500") {
                            $stop_type = "P";
                            $stop_id = $getstops['stop_id'];
                        } else {
                            $stop_type = "D";
                            $stop_id = $getstops['drop_stopid'];
                        }
                    }
                    $getvehid = $this->common->gettblrowdata(array("shift_id" => $ship_id, "status" => 1), "vehicle_id", "tb_shft_veh", 0, 0);
                    if (count($getvehid) > 0) {
                        $vehicle_id = $getvehid['vehicle_id'];
                        $driver = $this->common->gettblrowdata(array("vehicle_id" => $vehicle_id, "status" => 1), "driver_id", "tbl_assigned_drivers", 0, 0);
                        if (count($driver) > 0) {
                            $driver_id = $driver['driver_id'];
                        }
                    }
                    $insarry = array("order_id" => $ord_id, "shipment_id" => $ship_id, "stop_id" => $stop_id, "stop_detail_id" => $stopdetails_id, "stop_type" => $stop_type, "trip_id" => $trip_id, "status_id" => $status_id, "latitude" => $latitude, "longitude" => $longitude, "loc_name" => $StatusLocation, "status" => 1, "reason" => $StatusRemark, "vehicle_id" => $vehicle_id, "driver_id" => $driver_id, "status_code" => $StatusCode, "createdon" => $stsdate);

                    $ins = $this->common->insertTableData("tb_stop_status", $insarry);
                }
            }
        }
    }
}
