<?php

defined('BASEPATH') or exit('No direct script access allowed');

use App\Controllers\AuthenticatedUserAbstract\AuthenticatedUserAbstract;

class Russia_edi_router extends AuthenticatedUserAbstract
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('Vendorservice');
    }

    public function callEdi(int $shift_id, int $carrerid, string $carrer): void
    {
        $company_code = $this->session->has_userdata('company_code') ? $this->session->userdata('company_code') : '';
        if ('' === $company_code || strlen($company_code) <= 3) {
            echo $this->vendorservice->failure('Please provide valid company code');
            return;
        }
        echo $this->vendorservice->vendorsRequestHandler($shift_id, $carrerid, $carrer, $company_code);
    }
}
