<?php if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Rutransportorder extends CI_Controller
{
    public function __Construct()
    {
        parent::__Construct();
        $this->load->library('session');
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('common');
        $this->load->model('truckwaybillmodel');
    }

    public function index($order_id, $shiftid = 0, $sign = 1, $sendemail = 0)
    {
        $data                       = $order_row_ids                       = $data['shipper_names']                       = $data['shipper_phonenos']                       = $data['shipper_addresses']                       = $data['consignee_names']                       = $data['consignee_addresses']                       = $data['consignee_phonenos']                       = [];
        $data['early_pickup_dates'] = $data['early_delivery_dates'] = $data['driver_pickup_instructions'] = $data['driver_delivery_instructions'] = $data['package_type'] = $data['goods_description'] = $check_pickup_dates = $check_delivery_dates = [];
        $user_id                    = $this->session->userdata('user_id');
        $data['goods_value']        = $data['cargo_weight']        = $data['cargo_volume']        = $data['cargo_quantity']        = 0;
        $data['trip_info']          = ['name' => '', 'shipmentid' => '', 'driving_licence_num' => ''];
        $data['carrier_info']       = ['name' => '', 'mobile' => '', 'fax' => '', 'contract_no' => ''];
        $data['costs_sum']          = $data['trip_created_on']          = "";
        $data['insurance']          = "no";
        $data['trip_sequence_no']   = "00000";
        $whr                        = ["id" => $order_id];
        if ($shiftid > 0) {
            $whr = ["shift_id" => $shiftid];
        }
        $get_orderdetails = $this->common->gettblrowdata($whr, 'shift_id,trip_id', 'tb_orders', 0, 0);
        if (! empty($get_orderdetails)) {
            $shift_id = $get_orderdetails['shift_id'];
            if ($shift_id > 0) {
                $get_order_info = $this->common->gettbldata(['shift_id' => $shift_id, 'status !=' => '0'], "id,pickup_datetime,delivery_datetime,goods_value", "tb_orders", 0, 0);
                if (! empty($get_order_info)) {
                    $early_pickup_count = $early_delivery_count = 1;
                    foreach ($get_order_info as $row) {
                        $order_row_ids[] = $row['id'];
                        if ($row['goods_value'] > 0) {
                            $data['goods_value'] += $row['goods_value'];
                        }
                        if ($row['pickup_datetime'] != "" && ! in_array($row['pickup_datetime'], $check_pickup_dates)) {
                            $check_pickup_dates[]         = $row['pickup_datetime'];
                            $data['early_pickup_dates'][] = $early_pickup_count . ". " . date("d.m.Y H:i", strtotime($row['pickup_datetime']));
                            $early_pickup_count++;
                        }
                        if ($row['delivery_datetime'] != "" && ! in_array($row['delivery_datetime'], $check_delivery_dates)) {
                            $check_delivery_dates[]         = $row['delivery_datetime'];
                            $data['early_delivery_dates'][] = $early_delivery_count . ". " . date("d.m.Y H:i", strtotime($row['delivery_datetime']));
                            $early_delivery_count++;
                        }
                    }
                }
                if (! empty($order_row_ids)) {
                    $get_order_partydetails = $this->truckwaybillmodel->get_order_partydetails($order_row_ids);
                    if (! empty($get_order_partydetails)) {
                        $cosignee_count = $cosignee_phone_count = $shipper_count = $shipper_phone_count = 1;
                        foreach ($get_order_partydetails as $partydetails) {
                            // if ($partydetails['partytype'] == 'Carrier') {
                            //     $data['carrier_info'] = array('name' => $partydetails['name'], 'mobile' => $partydetails['mobile'], 'fax' => $partydetails['fax'], 'contract_no' => $partydetails['contract_no']);
                            // }
                            if ($partydetails['partytype'] == 'Consignee') {
                                $cosignee_address = "";
                                if ($partydetails['pincode'] != "") {
                                    $cosignee_address .= $partydetails['pincode'];
                                }
                                if ($partydetails['country'] != "") {
                                    $cosignee_address .= ", " . $partydetails['country'];
                                }
                                if ($partydetails['state'] != "") {
                                    $cosignee_address .= ", " . $partydetails['state'];
                                }
                                if ($partydetails['location_id'] != "") {
                                    $cosignee_address .= ", " . $partydetails['location_id'];
                                }
                                if ($partydetails['street'] != "") {
                                    $cosignee_address .= ", " . $partydetails['street'];
                                }
                                if ($partydetails['house_number'] != "") {
                                    $cosignee_address .= ", " . $partydetails['house_number'];
                                }
                                if ($partydetails['building'] != "") {
                                    $cosignee_address .= ", " . $partydetails['building'];
                                }
                                $data['consignee_names'][] = $cosignee_count . ". " . $partydetails['name'];
                                if ($partydetails['mobile'] != "") {
                                    $data['consignee_phonenos'][] = $cosignee_phone_count . ". " . $partydetails['mobile'];
                                    $cosignee_phone_count++;
                                }
                                $data['consignee_addresses'][] = $cosignee_count . ". " . $cosignee_address;
                                $cosignee_count++;
                            }
                            if ($partydetails['partytype'] == 'Shipper') {
                                $shipper_address = "";
                                if ($partydetails['pincode'] != "") {
                                    $shipper_address .= $partydetails['pincode'];
                                }
                                if ($partydetails['country'] != "") {
                                    $shipper_address .= ", " . $partydetails['country'];
                                }
                                if ($partydetails['state'] != "") {
                                    $shipper_address .= ", " . $partydetails['state'];
                                }
                                if ($partydetails['location_id'] != "") {
                                    $shipper_address .= ", " . $partydetails['location_id'];
                                }
                                if ($partydetails['street'] != "") {
                                    $shipper_address .= ", " . $partydetails['street'];
                                }
                                if ($partydetails['house_number'] != "") {
                                    $shipper_address .= ", " . $partydetails['house_number'];
                                }
                                if ($partydetails['building'] != "") {
                                    $shipper_address .= ", " . $partydetails['building'];
                                }
                                $data['shipper_names'][] = $shipper_count . ". " . $partydetails['name'];
                                if ($partydetails['mobile'] != "") {
                                    $data['shipper_phonenos'][] = $shipper_phone_count . ". " . $partydetails['mobile'];
                                    $shipper_phone_count++;
                                }
                                $data['shipper_addresses'][] = $shipper_count . ". " . $shipper_address;
                                $shipper_count++;
                            }
                        }
                    }
                }
                if ($shift_id > 0) {
                    $getcarrier_by_shiftid = $this->truckwaybillmodel->getcarrier_by_shiftid($shift_id);
                    if (! empty($getcarrier_by_shiftid)) {
                        $data['carrier_info'] = ['name' => $getcarrier_by_shiftid['name'], 'mobile' => $getcarrier_by_shiftid['mobile'], 'fax' => $getcarrier_by_shiftid['fax'], 'contract_no' => $getcarrier_by_shiftid['contract_no']];
                    }
                }
                $trip_select   = "s.shipmentid,s.vehicle_type,s.weight_capacity,s.volume_capacity,s.additional_conditions,s.temperature_regime,s.time_for_loading_penality_rate,s.created_on,td.truck_number,td.register_number,td.truck_brand,dr.name,dr.driving_licence_num";
                $get_trip_info = $this->truckwaybillmodel->get_trip_info($shift_id, $trip_select);
                if (! empty($get_trip_info)) {
                    if ($get_trip_info['created_on'] != "") {
                        $data['trip_created_on']  = date("d.m.Y", strtotime($get_trip_info['created_on']));
                        $data['trip_sequence_no'] = get_trip_sequence_no($shift_id, $get_trip_info['created_on']);
                    }

                    $data['trip_info'] = [
                        'shipmentid'                     => $get_trip_info['shipmentid'],
                        'vehicle_type'                   => $get_trip_info['vehicle_type'],
                        'weight_capacity'                => $get_trip_info['weight_capacity'],
                        'volume_capacity'                => $get_trip_info['volume_capacity'],
                        'additional_conditions'          => $get_trip_info['additional_conditions'],
                        'temperature_regime'             => $get_trip_info['temperature_regime'],
                        'time_for_loading_penality_rate' => $get_trip_info['time_for_loading_penality_rate'],
                        'truck_number'                   => $get_trip_info['truck_number'],
                        'register_number'                => $get_trip_info['register_number'],
                        'truck_brand'                    => $get_trip_info['truck_brand'],
                        'driver_name'                    => $get_trip_info['name'],
                        'driving_licence_num'            => $get_trip_info['driving_licence_num'],
                    ];
                }
                if (! empty($order_row_ids)) {
                    $get_driver_instructions = $this->truckwaybillmodel->get_driver_instructions($order_row_ids);
                    if (! empty($get_driver_instructions)) {
                        $pickup_count = $delivery_count = 1;
                        foreach ($get_driver_instructions as $driver_instructions) {
                            if ($driver_instructions['reference_id'] == 'ORD_PIKINST') {
                                $data['driver_pickup_instructions'][] = $pickup_count . ". " . $driver_instructions['ref_value'];
                                $pickup_count++;
                            }
                            if ($driver_instructions['reference_id'] == 'ORD_DLVINST') {
                                $data['driver_delivery_instructions'][] = $delivery_count . ". " . $driver_instructions['ref_value'];
                                $delivery_count++;
                            }
                        }
                    }
                    $get_cargo_details = $this->truckwaybillmodel->get_cargo_details($order_row_ids);
                    if (! empty($get_cargo_details)) {
                        foreach ($get_cargo_details as $cargos) {
                            if ($cargos['weight'] > 0) {
                                $data['cargo_weight'] += $cargos['weight'];
                            }
                            if ($cargos['volume'] > 0) {
                                $data['cargo_volume'] += $cargos['volume'];
                            }
                            if ($cargos['quantity'] > 0) {
                                $data['cargo_quantity'] += $cargos['quantity'];
                            }
                            if ($cargos['quantity_type'] != "") {
                                $data['package_type'][] = $cargos['quantity_type'];
                            }
                            if ($cargos['cargo_content'] != "") {
                                $data['goods_description'][] = $cargos['cargo_content'];
                            }
                        }
                    }
                    if (! empty($data['package_type'])) {
                        $data['package_type'] = array_unique($data['package_type']);
                    }
                    if (! empty($data['goods_description'])) {
                        $data['goods_description'] = array_unique($data['goods_description']);
                    }
                    $get_costs_sum = $this->truckwaybillmodel->get_costs_sum($order_row_ids);
                    if ($get_costs_sum > 0) {
                        $data['costs_sum'] = $get_costs_sum . " руб. Вкл. НДС";
                    } else {
                        $data['costs_sum'] = "Согласно условиям договора" . $data['carrier_info']['contract_no'];
                    }
                    $check_vas_ins = $this->truckwaybillmodel->check_vas_ins($order_row_ids);
                    if ($check_vas_ins > 0) {
                        $data['insurance'] = "yes";
                    } else {
                        $data['insurance'] = "no";
                    }
                }
            }
        }
        $data['userinfo'] = ['name' => "", 'attorney_number' => "", 'attorney_date' => "", 'job_profile' => "", 'signpath' => ""];
        if ($this->session->userdata('childid')) {
            $cid               = $this->session->userdata('childid');
            $get_signaturepath = $this->common->gettblrowdata(["id" => $cid], 'name,attorney_number,attorney_date,signpath,job_profile', 'tb_user_logins', 0, 0);
            if (! empty($get_signaturepath)) {
                $signpath      = $get_signaturepath['signpath'];
                $attorney_date = $get_signaturepath['attorney_date'];
                if ($attorney_date != "" && $attorney_date != "0000-00-00") {
                    $attorney_date = date("d.m.Y", strtotime($attorney_date));
                } else {
                    $attorney_date = "";
                }
                $data['userinfo'] = ['name' => $get_signaturepath['name'], 'attorney_number' => $get_signaturepath['attorney_number'], 'attorney_date' => $attorney_date, 'job_profile' => $get_signaturepath['job_profile'], 'signpath' => $signpath];
            }
        } else {
            $get_userdetails = $this->common->gettblrowdata(["id" => $user_id], 'name,attorney_number,attorney_date,signpath,job_profile', 'tb_users', 0, 0);
            if (! empty($get_userdetails)) {
                $signpath      = $get_userdetails['signpath'];
                $attorney_date = $get_userdetails['attorney_date'];
                if ($attorney_date != "" && $attorney_date != "0000-00-00") {
                    $attorney_date = date("d.m.Y", strtotime($attorney_date));
                } else {
                    $attorney_date = "";
                }
                $data['userinfo'] = ['name' => $get_userdetails['name'], 'attorney_number' => $get_userdetails['attorney_number'], 'attorney_date' => $attorney_date, 'job_profile' => $get_userdetails['job_profile'], 'signpath' => $signpath];
            }
        }
        // print_r($data);
        // exit;
        if ($sign == 0) {
            $data['userinfo']['signpath'] = "";
        }
        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'tempDir'           => FCPATH . 'assets/tmp',
            'default_font_size' => 14.5,
            'format'            => 'A4',
            'margin_left'       => 10,
            'margin_right'      => 10,
            'margin_top'        => 10,
            'margin_bottom'     => 10,
            'margin_header'     => 10,
            'margin_footer'     => 10,
        ]);
        $html = "";
        $html .= $this->load->view('rutransportorder/index', $data, true);
        $mpdf->WriteHTML($html);
        if ($sendemail == 0) {
            $mpdf->Output('Transport_Order' . "_" . date('YmdHis') . ".pdf", 'D');
        } else {
            $post     = $this->input->post(null, true);
            $email_id = isset($post['email_id']) ? $post['email_id'] : "";
            $subject  = isset($post['subject']) ? $post['subject'] : "";
            $pdfpath  = EDOC_PATH . 'Transport_Order' . "_" . date('Ymd') . ".pdf";
            $mpdf->Output($pdfpath, 'F');
            $this->load->helper('ruemaildocuments_helper');
            $data   = ['documentno' => $data['trip_sequence_no'], 'customer_email' => $email_id, 'subject' => $subject, 'attachment' => $pdfpath];
            $status = senddocument($data);
            echo $status;
        }
    }
}
