<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Salogshipment extends CI_Controller
{
    private const NOTIFY_PARTY = 'NOTIFY_PARTY';
    private const FREIGHT_PAYER = 'FREIGHT_PAYER';
    private const PICKUP_PARTY = 'PICKUP';
    private const DELIVERY_PARTY = 'DELIVERY';
    private const SHIPPER_PARTY = 'Shipper';
    private const CONSIGNEE_PARTY = 'Consignee';
    private const CARRIER_PARTY = 'Carrier';
    private const CUSTOMER_PARTY = 'CUSTOMER';
    private const TRANSPORT_MODE_FOR_AIR = 2;
    private const TRANSPORT_MODE_FOR_SEA = 3;
    private const TAIWAN_COMPANY_CODE = 'TWKN';

    public function __construct()
    {
        parent::__construct();
        $this->load->model(['common', 'Order_details','Roadlogtosalogmodel', 'DeliveryDocumentModel', 'Standardstatusmodel']);
        $this->load->library(['Edi_logger', 'altovaordercreation', 'carrierstandardtripoutbound', 'Notifytrigger']);
    }

    public function index()
    {
        try {
            $postData = file_get_contents('php://input');
            if (!empty($postData)) {
                $xml = new SimpleXMLElement($postData);
                $response = array();
                $statusmsg = "";
                $preceiver = $lreceiver = $psender = $lsender = $shipmentid = $sendertransmode = $pickup_city = $company_code = $branch_code = "";
                if ($xml === false) {
                    $statusmsg = "Invalid request,Please try again!";
                } else {
                    $this->edi_logger->setEdi_request($postData);
                    $shipdata11 = $this->read_shipmentdata($xml);
                    $curtz = date_default_timezone_get();
                    $logdate = date('Y-m-d H:i:s');
                    $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
                    $logdate = $getactual['datetime'];
                    if (!empty($shipdata11)) {
                        /*log_message("error","SALogparseddata ".json_encode($shipdata11));*/
                        $response = $this->insertShipmentData($shipdata11, $logdate);
                    }
                    if (!empty($response)) {
                        $statusmsg = "Success";
                    } else {
                        $statusmsg = "Failed for unformatted request,Please try again!";
                    }
                }
            } else {
                $statusmsg = "Invalid request,Please try again!";
            }
            echo $statusmsg;
        } catch (Exception $exc) {
            $statusmsg = "Catch Block:" . $exc->getTraceAsString();
        } finally {
            $this->edi_logger->setEdi_type(1);
            $this->edi_logger->setTransaction_id(time());
            $this->edi_logger->setEdi_name('SALOG');
            $this->edi_logger->setBounded_type(1);
            $this->edi_logger->setEdi_format_type('XML');
            $this->edi_logger->setStatus(($statusmsg == 'Success' ? 1 : 0));
            $this->edi_logger->setEdi_response($statusmsg);
            $this->edi_logger->setObj_type_name('SALOG Ref');
            $this->edi_logger->saveToEdiLogs();
        }
    }

    public function read_shipmentdata($xml)
    {
        $res = $receivers = array();
        $lreceiver = $preceiver = $psender = $lsender = $triptype = "";
        $xml->registerXPathNamespace('ns3', 'http://knie4.int.kn/com/hdr/0500');
        $data = $xml->xpath('ns3:MSGHDR');
        if (null !== $data[0]->xpath('REC')) {
            if (!empty($data[0]->xpath('REC'))) {
                foreach ($data[0]->xpath('REC') as $mm) {
                    $receivers[] = array(
                        'physicalreceiver' => (string)$mm->PHYREC,
                        'logicalreceiver' => (string)$mm->LOGREC,
                        'mtype' => (string)$mm->attributes('ns2', true)->ADRTYP
                    );
                }
            }
        }
        $psender = (string)($data[0]->xpath('PHYSND')[0]);
        $lsender = (string)($data[0]->xpath('LOGSND')[0]);
        $sendapp = (string)($data[0]->xpath('SNDAPP')[0]);
        $msgtype = (string)($data[0]->xpath('MSGTYP')[0]);
        $version = (string)($data[0]->xpath('VERNUM')[0]);
        $createdtime = (string)($data[0]->xpath('CREDTM')[0]);
        if ($createdtime != "") {
            $createdtime = date("Y-m-d H:i:s", strtotime($createdtime));
        } else {
            $createdtime = date("Y-m-d H:i:s");
        }
        $loadcapacity = 0;
        $driver = $carrier = $consignor = array();
        $res['header'] = [
            "receivers" => $receivers,
            "psender" => $psender,
            "lsender" => $lsender,
            "sendapp" => $sendapp,
            "msgtype" => $msgtype,
            "version" => $version,
            "createdtime" => $createdtime,
            "function_code" => (string)($data[0]->xpath('FNCCDE')[0])
        ];
        $res['header']['preceiver'] = "";
        $res['header']['lreceiver'] = "";
        if (!empty($receivers)) {
            foreach ($receivers as $rec) {
                if ($rec['mtype'] == "CA") {
                    $res['header']['preceiver'] = $rec['physicalreceiver'];
                    $res['header']['lreceiver'] = $rec['logicalreceiver'];
                }
            }
        }
        $res['shipdata'] = array();
        $xml->registerXPathNamespace('ns5', 'http://knie4.int.kn/com/mlv/0500');
        $mdata = $xml->xpath('//ns23:ROASHP');
        $shinfo = $mdata[0]->xpath('MSG')[0]->SHP;
        foreach ($shinfo as $key => $cships) {
            $res['shipdata'][] = $this->generateshipmentdata($cships, $key);
        }
        return $res;
    }

    public function generateshipmentdata($xml, $key)
    {
        $xml->registerXPathNamespace('ns5', 'http://knie4.int.kn/com/mlv/0500');
        $titledata = $xml->xpath('ns5:MSGLVL');
        $arr['orderid'] = (string)($titledata[0]->xpath('TRCNUM')[0]);
        $arr['sendercmpcode'] = (string)($titledata[0]->xpath('SNDINF')[0]->CPNCDE);
        $arr['senderbranchcode'] = (string)($titledata[0]->xpath('SNDINF')[0]->BRACDE);
        $arr['senderdeptcode'] = (string)($titledata[0]->xpath('SNDINF')[0]->DPTCDE);
        $arr['sendertransmode'] = 1;
        if (null !== (string)($titledata[0]->xpath('SNDINF')[0]->MODTRS)) {
            $arr['sendertransmode'] = (string)($titledata[0]->xpath('SNDINF')[0]->MODTRS);
        }
        if (in_array($arr['senderdeptcode'], ['ACE', 'ACI', 'AE', 'AI', 'EC', 'IC']) && $arr['sendercmpcode'] == 'IDKN') {
            $arr['senderdeptcode'] = "OX";
        }
        $arr['xsrvalue'] = "";
        $arr['senderflag'] = "";
        if (null !== (string)($titledata[0]->xpath('SNDINF')[0]->EXPIMPFLG)) {
            $arr['senderflag'] = (string)($titledata[0]->xpath('SNDINF')[0]->EXPIMPFLG);
        }
        $arr['references'] = [];
        if (null !== $titledata[0]->xpath('REF') && !empty($titledata[0]->xpath('REF'))) {
            $refcode = (string)($titledata[0]->xpath('REF')[0]->CDE);
            $refvalue = (string)($titledata[0]->xpath('REF')[0]->VAL);
            if ($refcode == 'XSR') {
                $arr['xsrvalue'] = $refvalue;
            }
            if ($refcode == 'DQ') {
                $refcode = "ACD";
            }
            $arr['references'][] = [
                'code' => $refcode,
                'value' => $refvalue
            ];
        }
        $stsinf = $xml->xpath('ns6:STSINF');
        $arr['statusinfo_date'] = (string)($stsinf[0]->xpath('DTE')[0]);
        $arr['statusinfo_time'] = (string)($stsinf[0]->xpath('TME')[0]);
        $arr['statusinfo_locissue'] = (string)($stsinf[0]->xpath('STSLOC')[0]);
        $arr['statusinfo_trg'] = (string)($stsinf[0]->xpath('TRG')[0]);
        $arr['statusinfo_addrinfo'] = (string)($stsinf[0]->xpath('ADDSTSINF')[0]->ENTDTM);
        $arr['salog_user_email_id'] = ($stsinf[0]->xpath('ADDSTSINF')[0]->USRIDE != '') ? ($stsinf[0]->xpath('ADDSTSINF')[0]->USRIDE) . "@kuehne-nagel.com" : '';
        $arr['statusinfo_prl'] = (string)($stsinf[0]->xpath('PRL')[0]);
        $infodata = $xml->SHPINF;
        $infodata->registerXPathNamespace('ns7', 'http://knie4.int.kn/com/shpd/0600');
        $details = $infodata->xpath('ns7:SHPDTL');
        $arr['measurements'] = [];
        $arr['dangerousflag'] = $arr['source'] = $arr['sourcebranch'] = $arr['destination'] = $arr['destinationbranch'] = $arr['bussolcode'] = $arr['bussolcatecode'] = "";
        $arr['pkgs_count'] = 1;
        $arr['goods_value'] = 0;
        $arr['goods_currency'] = 'USD';
        $arr['pkgs_uom'] = 'PCS';
        $arr['gross_weight'] = $arr['volume'] = $arr['charge_weight'] = $arr['charge_uom'] = 1;
        $arr['weight_uom'] = 'KGM';
        $arr['volume_uom'] = 'MTQ';
        $arr['cargo_content'][] = 'Boxes';
        if (!empty($details)) {
            if (null !== $details[0]->xpath('TOTPAC') && !empty($details[0]->xpath('TOTPAC'))) {
                $arr['pkgs_count'] = (string)($details[0]->xpath('TOTPAC')[0]);
            }
            if (null !== $details[0]->xpath('MEA') && !empty($details[0]->xpath('MEA'))) {
                foreach ($details[0]->xpath('MEA') as $mm) {
                    $arr['measurements'][] = [
                        'mtype' => (string)$mm->attributes('ns2', true)->MEATYP,
                        'value' => (string)$mm->VAL,
                        'uom' => (string)$mm->UOMCDE
                    ];
                }
            }
            if (null !== $details[0]->xpath('DGSGOOFLG') && !empty($details[0]->xpath('DGSGOOFLG'))) {
                $arr['dangerousflag'] = (string)($details[0]->xpath('DGSGOOFLG')[0]);
            }
            if (null !== $details[0]->xpath('ORG') && !empty($details[0]->xpath('ORG'))) {
                $arr['source'] = (string)($details[0]->xpath('ORG')[0]->LOC[0]);
                $arr['sourcebranch'] = (string)($details[0]->xpath('ORG')[0]->LOC[1]);
            }
            if (null !== $details[0]->xpath('DES') && !empty($details[0]->xpath('DES'))) {
                $arr['destination'] = (string)($details[0]->xpath('DES')[0]->LOC[0]);
                $arr['destinationbranch'] = (string)($details[0]->xpath('DES')[0]->LOC[1]);
            }
            if (null !== $details[0]->xpath('MOA') && !empty($details[0]->xpath('MOA'))) {
                $arr['goods_value'] = (string)($details[0]->xpath('MOA')[0]->VAL);
                $arr['goods_currency'] = (string)($details[0]->xpath('MOA')[0]->CURCDE);
            }
            if (null !== $details[0]->xpath('BIZSOL') && !empty($details[0]->xpath('BIZSOL'))) {
                $arr['bussolcode'] = (string)($details[0]->xpath('BIZSOL')[0]->CDE);
                $arr['bussolcatecode'] = (string)($details[0]->xpath('BIZSOL')[0]->CATCDE);
            }
        }
        $shipper = $customer = $consignee = $pf = $dimensions = $arr['shreferences'] = $arr['cureferences'] = $arr['cnreferences'] = $arr['pfreferences'] = [];
        $infodata->registerXPathNamespace('ns8', 'http://knie4.int.kn/com/adr/0500');
        foreach ($infodata->xpath('ns8:ADR') as $addr) {
            if ($addr->attributes('ns2', true)->ADRTYP == "SH") {
                $firtname = (null !== $addr->xpath('NAM')) ? (string)($addr->xpath('NAM')[0]) : "";
                $lastName = isset($addr->xpath('NAM')[1]) ? (string)($addr->xpath('NAM')[1]) : "";
                if ($lastName != "") {
                    $firtname = $firtname . " " . $lastName;
                }
                $zipcode = $statecode = $state = "";
                if (null !== $addr->xpath('STTCDE')) {
                    $statecode = isset($addr->xpath('STTCDE')[0]) ? (string)($addr->xpath('STTCDE')[0]) : "";
                }
                if (null !== $addr->xpath('STT')) {
                    $state = isset($addr->xpath('STT')[0]) ? (string)($addr->xpath('STT')[0]) : "";
                }
                if (null !== $addr->xpath('ZIPCDE')) {
                    $zipcode = isset($addr->xpath('ZIPCDE')[0]) ? (string)($addr->xpath('ZIPCDE')[0]) : "";
                }
                $shipperStreetData = $this->getFullAddressData($addr);
                $shipper = [
                    'name' => $firtname,
                    'street' => $shipperStreetData['street'],
                    'street2' => $shipperStreetData['street2'],
                    'city' => (string)($addr->xpath('CTY')[0]),
                    'country' => (string)($addr->xpath('CNYCDE')[0]),
                    'zip' => $zipcode,
                    'custid' => (string)($addr->xpath('CID')[0]),
                    'partyid' => (string)($addr->xpath('IDE')[0]),
                    "statecode" => $statecode,
                    "state" => $state,
                    "contact" => $this->getContactInformation($addr)
                ];
                if (null !== $addr->xpath('REF')) {
                    if (!empty($addr->xpath('REF'))) {
                        foreach ($addr->xpath('REF') as $cref) {
                            $s = (string)$cref->CDE;
                            if ($s != "") {
                                if ($s == 'XSR') {
                                    $arr['xsrvalue'] = (string)$cref->VAL;
                                }
                                if ($s == 'DQ') {
                                    $s = "ACD";
                                }
                                $arr['shreferences'][] = [
                                    'code' => (string)$s,
                                    'value' => (string)$cref->VAL
                                ];
                            }
                        }
                    }
                }
            }
            if ($addr->attributes('ns2', true)->ADRTYP == "CU") {
                $firtname = (null !== $addr->xpath('NAM')) ? (string)($addr->xpath('NAM')[0]) : "";
                $zipcode = $statecode = $state = "";
                if (null !== $addr->xpath('STTCDE')) {
                    $statecode = isset($addr->xpath('STTCDE')[0]) ? (string)($addr->xpath('STTCDE')[0]) : "";
                }
                if (null !== $addr->xpath('STT')) {
                    $state = isset($addr->xpath('STT')[0]) ? (string)($addr->xpath('STT')[0]) : "";
                }
                if (null !== $addr->xpath('ZIPCDE')) {
                    $zipcode = isset($addr->xpath('ZIPCDE')[0]) ? (string)($addr->xpath('ZIPCDE')[0]) : "";
                }
                $customerStreetData = $this->getFullAddressData($addr);
                $customer = [
                    'name' => $firtname,
                    'street' => $customerStreetData['street'],
                    'street2' => $customerStreetData['street2'],
                    'city' => (string)($addr->xpath('CTY')[0]),
                    'country' => (string)($addr->xpath('CNYCDE')[0]),
                    'zip' => $zipcode,
                    'custid' => (string)($addr->xpath('CID')[0]),
                    'partyid' => (string)($addr->xpath('IDE')[0]),
                    "statecode" => $statecode,
                    "state" => $state,
                    "contact" => $this->getContactInformation($addr)
                ];
                if (null !== $addr->xpath('REF')) {
                    if (!empty($addr->xpath('REF'))) {
                        foreach ($addr->xpath('REF') as $cref) {
                            $s = (string)$cref->CDE;
                            if ($s != "") {
                                if ($s == 'XSR') {
                                    $arr['xsrvalue'] = (string)$cref->VAL;
                                }
                                if ($s == 'DQ') {
                                    $s = "ACD";
                                }
                                $arr['cureferences'][] = [
                                    'code' => (string)$s,
                                    'value' => (string)$cref->VAL
                                ];
                            }
                        }
                    }
                }
            }
            if ($addr->attributes('ns2', true)->ADRTYP == "CN") {
                $firtname = (null !== $addr->xpath('NAM')) ? (string)($addr->xpath('NAM')[0]) : "";
                $zipcode = $statecode = $state = $city = $country = $cid = $partyid = "";
                if (null !== $addr->xpath('STTCDE')) {
                    $statecode = isset($addr->xpath('STTCDE')[0]) ? (string)($addr->xpath('STTCDE')[0]) : "";
                }
                if (null !== $addr->xpath('STT')) {
                    $state = isset($addr->xpath('STT')[0]) ? (string)($addr->xpath('STT')[0]) : "";
                }
                if (null !== $addr->xpath('ZIPCDE')) {
                    $zipcode = isset($addr->xpath('ZIPCDE')[0]) ? (string)($addr->xpath('ZIPCDE')[0]) : "";
                }
                if (null !== $addr->xpath('CTY')) {
                    $city = isset($addr->xpath('CTY')[0]) ? (string)($addr->xpath('CTY')[0]) : "";
                }
                if (null !== $addr->xpath('CNYCDE')) {
                    $country = isset($addr->xpath('CNYCDE')[0]) ? (string)($addr->xpath('CNYCDE')[0]) : "";
                }
                if (null !== $addr->xpath('CID')) {
                    $cid = isset($addr->xpath('CID')[0]) ? (string)($addr->xpath('CID')[0]) : "";
                }
                if (null !== $addr->xpath('IDE')) {
                    $partyid = isset($addr->xpath('IDE')[0]) ? (string)($addr->xpath('IDE')[0]) : "";
                }
                $consigneeStreetData = $this->getFullAddressData($addr);
                $consignee = [
                    'name' => $firtname,
                    'street' => $consigneeStreetData['street'],
                    'street2' => $consigneeStreetData['street2'],
                    'city' => $city,
                    'country' => $country,
                    'zip' => $zipcode,
                    'custid' => $cid,
                    'partyid' => $partyid,
                    "statecode" => $statecode,
                    "state" => $state,
                    "contact" => $this->getContactInformation($addr)
                ];
                if (null !== $addr->xpath('CTAINF')) {
                    if (!empty($addr->xpath('CTAINF'))) {
                        $consignee['first_name'] = (string)($addr->xpath('CTAINF')[0]->LSTNAM);
                        $consignee['last_name'] = (string)($addr->xpath('CTAINF')[0]->FSTNAM);
                        $consignee['contact_type'] = (string)($addr->xpath('CTAINF')[0]->CTATYP);
                        $consignee['contact_num'] = (string)($addr->xpath('CTAINF')[0]->COM);
                    }
                }
                if (null !== $addr->xpath('REF')) {
                    if (!empty($addr->xpath('REF'))) {
                        foreach ($addr->xpath('REF') as $cref) {
                            $s = (string)$cref->CDE;
                            if ($s != "") {
                                if ($s == 'XSR') {
                                    $arr['xsrvalue'] = (string)$cref->VAL;
                                }
                                if ($s == 'DQ') {
                                    $s = "ACD";
                                }
                                $arr['cnreferences'][] = [
                                    'code' => (string)$s,
                                    'value' => (string)$cref->VAL
                                ];
                            }
                        }
                    }
                }
            }
            if ($addr->attributes('ns2', true)->ADRTYP == "PF") {
                $firtname = (null !== $addr->xpath('NAM')) ? (string)($addr->xpath('NAM')[0]) : "";
                $lastName = isset($addr->xpath('NAM')[1]) ? (string)($addr->xpath('NAM')[1]) : "";
                if ($lastName != "") {
                    $firtname = $firtname . " " . $lastName;
                }
                $zipcode = $statecode = $state = "";
                if (null !== $addr->xpath('STTCDE')) {
                    $statecode = isset($addr->xpath('STTCDE')[0]) ? (string)($addr->xpath('STTCDE')[0]) : "";
                }
                if (null !== $addr->xpath('STT')) {
                    $state = isset($addr->xpath('STT')[0]) ? (string)($addr->xpath('STT')[0]) : "";
                }
                if (null !== $addr->xpath('ZIPCDE')) {
                    $zipcode = isset($addr->xpath('ZIPCDE')[0]) ? (string)($addr->xpath('ZIPCDE')[0]) : "";
                }
                $pfStreetData = $this->getFullAddressData($addr);
                $pf = [
                    'name' => $firtname,
                    'street' => $pfStreetData['street'],
                    'street2' => $pfStreetData['street2'],
                    'city' => (string)($addr->xpath('CTY')[0]),
                    'country' => (string)($addr->xpath('CNYCDE')[0]),
                    'zip' => $zipcode,
                    'custid' => (string)($addr->xpath('CID')[0]),
                    'partyid' => (string)($addr->xpath('IDE')[0]),
                    "statecode" => $statecode,
                    "state" => $state,
                    "contact" => $this->getContactInformation($addr)
                ];
                if (null !== $addr->xpath('REF')) {
                    if (!empty($addr->xpath('REF'))) {
                        foreach ($addr->xpath('REF') as $cref) {
                            $s = (string)$cref->CDE;
                            if ($s != "") {
                                if ($s == 'XSR') {
                                    $arr['xsrvalue'] = (string)$cref->VAL;
                                }
                                if ($s == 'DQ') {
                                    $s = "ACD";
                                }
                                $arr['pfreferences'][] = [
                                    'code' => (string)$s,
                                    'value' => (string)$cref->VAL
                                ];
                            }
                        }
                    }
                }
            }
        }
        if (null !== $infodata[0]->xpath('CGODSC')) {
            if (!empty($infodata[0]->xpath('CGODSC'))) {
                $cargo = $infodata[0]->xpath('CGODSC')[0];
                $cargo->registerXPathNamespace('ns9', 'http://knie4.int.kn/com/cgod/0600');
                $cargodetails = $cargo->xpath('ns9:CGODTL');
                if (null !== $cargodetails[0]->xpath('NUMPAC')[0]) {
                    $arr['pkgs_count'] = isset(
                        $cargodetails[0]->xpath(
                            'NUMPAC'
                        )[0]->VAL
                    ) ? (string)($cargodetails[0]->xpath('NUMPAC')[0]->VAL) : 1;
                }
                if (null !== $cargodetails[0]->xpath('NUMPAC')[0]) {
                    $arr['pkgs_uom'] = isset(
                        $cargodetails[0]->xpath(
                            'NUMPAC'
                        )[0]->TYP
                    ) ? (string)($cargodetails[0]->xpath('NUMPAC')[0]->TYP) : 1;
                }
                if (null !== $cargodetails[0]->xpath('GRSWGT')[0]) {
                    $arr['gross_weight'] = isset(
                        $cargodetails[0]->xpath(
                            'GRSWGT'
                        )[0]->VAL
                    ) ? (string)($cargodetails[0]->xpath('GRSWGT')[0]->VAL) : 1;
                }
                if (null !== $cargodetails[0]->xpath('GRSWGT')[0]) {
                    $arr['weight_uom'] = isset(
                        $cargodetails[0]->xpath(
                            'GRSWGT'
                        )[0]->UOMCDE
                    ) ? (string)($cargodetails[0]->xpath('GRSWGT')[0]->UOMCDE) : 1;
                }
                if (null !== $cargodetails[0]->xpath('CHGWGT')) {
                    $arr['charge_weight'] = isset(
                        $cargodetails[0]->xpath(
                            'CHGWGT'
                        )[0]->VAL
                    ) ? (string)($cargodetails[0]->xpath('CHGWGT')[0]->VAL) : 0;
                    $arr['charge_uom'] = isset(
                        $cargodetails[0]->xpath(
                            'CHGWGT'
                        )[0]->UOMCDE
                    ) ? (string)($cargodetails[0]->xpath('CHGWGT')[0]->UOMCDE) : 0;
                }
                $arr['volume'] = (string)($cargodetails[0]->xpath('VOL')[0]->VAL);
                $arr['volume_uom'] = (string)($cargodetails[0]->xpath('VOL')[0]->UOMCDE);
                $arr['marks_numbers'] = isset($cargodetails[0]->xpath('CNTNUM')[0]) ? (string)($cargodetails[0]->xpath('CNTNUM')[0]) : '';
                if (null !== $cargodetails[0]->xpath('CGOCTT')) {
                    if (!empty($cargodetails[0]->xpath('CGOCTT'))) {
                        $arr['cargo_content'] = [];
                        foreach ($cargodetails[0]->xpath('CGOCTT') as $cgoctt) {
                            $arr['cargo_content'][] = $cgoctt;
                        }
                    }
                }
                $arr['dgCargos'] = [];
                $cargo->registerXPathNamespace('ns10', 'http://knie4.int.kn/com/dgs/0800');
                $dgCargodetails = $cargo->xpath('ns10:DGSGOO') !== null ? ($cargo->xpath('ns10:DGSGOO')) : "";
                if(!empty($dgCargodetails)) {
                    if (null !== $dgCargodetails[0]->xpath('DGSPOS')) {
                        if (!empty($dgCargodetails[0]->xpath('DGSPOS'))) {
                            foreach ($dgCargodetails[0]->xpath('DGSPOS') as $DGSPOS) {
                                $packageType = isset($DGSPOS->xpath('NUMPAC')[0]->TYP) ? (string)($DGSPOS->xpath('NUMPAC')[0]->TYP) : "";
                                $packageVal = isset($DGSPOS->xpath('NUMPAC')[0]->VAL) ? (string)($DGSPOS->xpath('NUMPAC')[0]->VAL) : "";
                                $DGSOVP = isset($DGSPOS->xpath('DGSOVP')[0]) ? (string)($DGSPOS->xpath('DGSOVP')[0]) : "";
                                $DGSDTL = $DGSPOS->xpath('DGSDTL')[0];
                                $QTYVAL = isset($DGSDTL->xpath('QTY')[0]->VAL) ? (string)($DGSDTL->xpath('QTY')[0]->VAL) : "";
                                $QTYTYP = isset($DGSDTL->xpath('QTY')[0]->TYP) ? (string)($DGSDTL->xpath('QTY')[0]->TYP) : "";
                                $UNONUMVAL = isset($DGSDTL->xpath('UNONUM')[0]->VAL) ? (string)($DGSDTL->xpath('UNONUM')[0]->VAL) : "";
                                $UNONUMVRT = isset($DGSDTL->xpath('UNONUM')[0]->VRT) ? (string)($DGSDTL->xpath('UNONUM')[0]->VRT) : "";
                                $UNONUMVER = isset($DGSDTL->xpath('UNONUM')[0]->VER) ? (string)($DGSDTL->xpath('UNONUM')[0]->VER) : "";
                                $CLS = isset($DGSDTL->xpath('CLS')[0]) ? (string)($DGSDTL->xpath('CLS')[0]) : "";
                                $PAKINR = isset($DGSDTL->xpath('PAKINR')[0]) ? (string)($DGSDTL->xpath('PAKINR')[0]) : "";
                                $DGSGOODSCLGG = isset($DGSDTL->xpath('DGSGOODSC')[0]->LGG) ? (string)($DGSDTL->xpath('DGSGOODSC')[0]->LGG) : "";
                                $DGSGOODSCPRPSHPNAM = isset($DGSDTL->xpath('DGSGOODSC')[0]->PRPSHPNAM) ? (string)($DGSDTL->xpath('DGSGOODSC')[0]->PRPSHPNAM) : "";
                                $LTDQTYFLG = isset($DGSDTL->xpath('LTDQTYFLG')[0]) ? (string)($DGSDTL->xpath('LTDQTYFLG')[0]) : "";
                                $EXCQTYFLG = isset($DGSDTL->xpath('EXCQTYFLG')[0]) ? (string)($DGSDTL->xpath('EXCQTYFLG')[0]) : "";
                                $ENHPRRWST = isset($DGSDTL->xpath('ENHPRR')[0]->WST) ? (string)($DGSDTL->xpath('ENHPRR')[0]->WST) : "";
                                $ENHPRRHOT = isset($DGSDTL->xpath('ENHPRR')[0]->HOT) ? (string)($DGSDTL->xpath('ENHPRR')[0]->HOT) : "";
                                $ENHPRREMP = isset($DGSDTL->xpath('ENHPRR')[0]->EMP) ? (string)($DGSDTL->xpath('ENHPRR')[0]->EMP) : "";
                                $ENHPRRSLVPAC = isset($DGSDTL->xpath('ENHPRR')[0]->SLVPAC) ? (string)($DGSDTL->xpath('ENHPRR')[0]->SLVPAC) : "";
                                $NDEKEY = isset($DGSDTL->xpath('NDEKEY')[0]) ? (string)($DGSDTL->xpath('NDEKEY')[0]) : "";
                                $HGHCON = isset($DGSDTL->xpath('HGHCON')[0]) ? (string)($DGSDTL->xpath('HGHCON')[0]) : "";
                                $ENVHAZ = isset($DGSDTL->xpath('ROA')[0]->ENVHAZ) ? (string)($DGSDTL->xpath('ROA')[0]->ENVHAZ) : "";
                                $NDEKEYS = isset($DGSPOS->xpath('NDEKEY')[0]) ? (string)($DGSPOS->xpath('NDEKEY')[0]) : "";
                                $arr['dgCargos'][] = [
                                    'packageType' => $packageType,
                                    'packageVal' => $packageVal,
                                    'dgsovp' => $DGSOVP,
                                    'qty_val' => $QTYVAL,
                                    'qty_typ' => $QTYTYP,
                                    'unonum_val' => $UNONUMVAL,
                                    'unonum_vrt' => $UNONUMVRT,
                                    'unonum_ver' => $UNONUMVER,
                                    'cls' => $CLS,
                                    'pak_inr' => $PAKINR,
                                    'dg_lgg' => $DGSGOODSCLGG,
                                    'dg_prpshpnm' => $DGSGOODSCPRPSHPNAM,
                                    'LTDQTYFLG' => $LTDQTYFLG,
                                    'EXCQTYFLG' => $EXCQTYFLG,
                                    'ENHPRRWST' => $ENHPRRWST,
                                    'ENHPRRHOT' => $ENHPRRHOT,
                                    'ENHPRREMP' => $ENHPRREMP,
                                    'ENHPRRSLVPAC' => $ENHPRRSLVPAC,
                                    'NDEKEY' => $NDEKEY,
                                    'HGHCON' => $HGHCON,
                                    '$ENVHAZ' => $ENVHAZ,
                                    'NDEKEYS' => $NDEKEYS,
                                ];
                            }
                        }
                    }
                }


                $cargo->registerXPathNamespace('ns11', 'http://knie4.int.kn/com/dim/0500');
                $dimens = $cargo->xpath('ns11:DIM');
                if (null !== $cargo->xpath('ns11:DIM')) {
                    foreach ($cargo->xpath('ns11:DIM') as $dim) {
                        $measurs = array();
                        foreach ($dim->xpath('MEA') as $ms) {
                            $measurs[] = [
                                "value" => $ms->VAL,
                                "uomcode" => $ms->UOMCDE,
                                "type" => $ms->attributes('ns2', true)->MEATYP
                            ];
                        }
                        $dimensions[] = [
                            "nopkgs" => (string)($dim->xpath('NUMPAC')[0]->VAL),
                            "mom" => (string)($dim->xpath('NUMPAC')[0]->TYP),
                            "measerments" => $measurs
                        ];
                    }
                }
            }
        }
        $arr['dimensions'] = $dimensions;
        $arr['shipper'] = $shipper;
        $arr['consignee'] = $consignee;
        $arr['customer'] = $customer;
        $arr['pf'] = $pf;
        $carrier = $ff = $do = [];
        $infodata1 = $xml->SHPROA;
        $infodata1->registerXPathNamespace('ns13', 'http://knie4.int.kn/com/rdtl/0600');
        $roaddetail = $infodata1->xpath('ns13:ROADTL');
        $arr['serviceproduct'] = $arr['servicetype'] = $arr['freight_term'] = $arr['freight_termname'] = "";
        if (null !== $roaddetail[0]->xpath('INSFLG')) {
            if (!empty($roaddetail[0]->xpath('INSFLG'))) {
                $arr['serviceproduct'] = (string)($roaddetail[0]->xpath('INSFLG')[0]);
            }
        }
        if ($arr['serviceproduct'] == "N" || $arr['serviceproduct'] == "Y") {
            $arr['serviceproduct'] = "LTL/FTL";
        }
        if (null !== $roaddetail[0]->xpath('TRUTYP')) {
            if (!empty($roaddetail[0]->xpath('TRUTYP'))) {
                $arr['servicetype'] = (string)($roaddetail[0]->xpath('TRUTYP')[0]);
            }
        }
        if (null !== $roaddetail[0]->xpath('BND')) {
            if (!empty($roaddetail[0]->xpath('BND'))) {
                $arr['freight_term'] = (string)($roaddetail[0]->xpath('BND')[0]->Term);
            }
        }
        $infodata1->registerXPathNamespace('ns24', 'http://knie4.int.kn/com/aia/0500');
        $getAdditionalInformation = $infodata1->xpath('ns24:ADDINFAIR')[0] ?? [];
        $additionalInformation = [];
        if (null !== (isset($getAdditionalInformation[0]) ? $getAdditionalInformation[0]->xpath('ORG') : null)) {
            if (!empty($getAdditionalInformation[0]->xpath('ORG'))) {
                $additionalInformation[] =  (string)($getAdditionalInformation[0]->xpath('ORG')[0]);
            }
        }
        if (null !== (isset($getAdditionalInformation[0]) ? $getAdditionalInformation[0]->xpath('DES') : null)) {
            if (!empty($getAdditionalInformation[0]->xpath('DES'))) {
                $additionalInformation[] =  (string)($getAdditionalInformation[0]->xpath('DES')[0]);
            }
        }
        $arr['additionalInformation'] = $arr['awbNumber'] = $arr['masAwdNumber'] = '';
        if (null !== (isset($getAdditionalInformation[0]) ? $getAdditionalInformation[0]->xpath('AWBNUM') : null)) {
            if (!empty($getAdditionalInformation[0]->xpath('AWBNUM'))) {
                $arr['awbNumber'] = (string)($getAdditionalInformation[0]->xpath('AWBNUM')[0]);
            }
        }
        if (null !== (isset($getAdditionalInformation[0]) ? $getAdditionalInformation[0]->xpath('MASAWBNUM') : null)) {
            if (!empty($getAdditionalInformation[0]->xpath('MASAWBNUM'))) {
                $arr['masAwdNumber'] = (string)($getAdditionalInformation[0]->xpath('MASAWBNUM')[0]);
            }
        }
        if (!empty($additionalInformation)) {
            $arr['additionalInformation'] = implode(' - ', $additionalInformation);
        }
        $pickdrop = $arr['careferences'] = $arr['ffreferences'] = $arr['doreferences'] = $contactinfo = [];
        $p = $d = 0;
        $infodata1->registerXPathNamespace('ns8', 'http://knie4.int.kn/com/adr/0500');
        $adrtypes = $infodata1->xpath('ns8:ADR');
        foreach ($adrtypes as $td) {
            if ($td->attributes('ns2', true)->ADRTYP == "CA") {
                $zipcode = $statecode = $state = $partyid = "";
                if (null !== $td->STTCDE) {
                    $statecode = (string)($td->STTCDE);
                }
                if (null !== $td->STT) {
                    $state = (string)($td->STT);
                }
                if (null !== $td->ZIPCDE) {
                    $zipcode = (string)($td->ZIPCDE);
                }
                if (null !== $td->IDE) {
                    $partyid = (string)($td->IDE);
                }
                $carrierStreetData = $this->getFullAddressData($td);
                $carrier = [
                    'name' => (string)($td->NAM),
                    'street' => $carrierStreetData['street'],
                    'street2' => $carrierStreetData['street2'],
                    'city' => (string)($td->CTY),
                    'country' => (string)($td->CNYCDE),
                    'zip' => $zipcode,
                    'custid' => (string)($td->CID),
                    'partyid' => $partyid,
                    "statecode" => $statecode,
                    "state" => $state,
                    "contact" => $this->getContactInformation($td)
                ];
                if (null !== $td->REF) {
                    if (!empty($td->REF)) {
                        foreach ($td->REF as $cref) {
                            $s = (string)$cref->CDE;
                            if ($s != "") {
                                if ($s == 'XSR') {
                                    $arr['xsrvalue'] = (string)$cref->VAL;
                                }
                                if ($s == 'DQ') {
                                    $s = "ACD";
                                }
                                $arr['careferences'][] = [
                                    'code' => (string)$s,
                                    'value' => (string)$cref->VAL
                                ];
                            }
                        }
                    }
                }
            }
            if ($td->attributes('ns2', true)->ADRTYP == "FF") {
                $zipcode = $statecode = $state = $partyid = "";
                if (null !== $td->STTCDE) {
                    $statecode = (string)($td->STTCDE);
                }
                if (null !== $td->STT) {
                    $state = (string)($td->STT);
                }
                if (null !== $td->ZIPCDE) {
                    $zipcode = (string)($td->ZIPCDE);
                }
                if (null !== $td->IDE) {
                    $partyid = (string)($td->IDE);
                }
                $ffStreetData = $this->getFullAddressData($td);
                $ff = [
                    'name' => (string)($td->NAM),
                    'street' => $ffStreetData['street'],
                    'street2' => $ffStreetData['street2'],
                    'city' => (string)($td->CTY),
                    'country' => (string)($td->CNYCDE),
                    'zip' => $zipcode,
                    'custid' => (string)($td->CID),
                    'partyid' => $partyid,
                    "statecode" => $statecode,
                    "state" => $state,
                    "contact" => $this->getContactInformation($td)
                ];
                if (null !== $td->xpath('CTAINF')) {
                    if (!empty($td->xpath('CTAINF'))) {
                        $ff['first_name'] = (string)($td->xpath('CTAINF')[0]->LSTNAM);
                        $ff['last_name'] = (string)($td->xpath('CTAINF')[0]->FSTNAM);
                        $ff['contact_type'] = (string)($td->xpath('CTAINF')[0]->CTATYP);
                        $ff['contact_num'] = (string)($td->xpath('CTAINF')[0]->COM);
                    }
                }
                if (null !== $td->REF) {
                    if (!empty($td->REF)) {
                        foreach ($td->REF as $cref) {
                            $s = (string)$cref->CDE;
                            if ($s != "") {
                                if ($s == 'XSR') {
                                    $arr['xsrvalue'] = (string)$cref->VAL;
                                }
                                if ($s == 'DQ') {
                                    $s = "ACD";
                                }
                                $arr['ffreferences'][] = [
                                    'code' => (string)$s,
                                    'value' => (string)$cref->VAL
                                ];
                            }
                        }
                    }
                }
            }
            if ($td->attributes('ns2', true)->ADRTYP == "DO") {
                $zipcode = $statecode = $state = $partyid = "";
                if (null !== $td->STTCDE) {
                    $statecode = (string)($td->STTCDE);
                }
                if (null !== $td->STT) {
                    $state = (string)($td->STT);
                }
                if (null !== $td->ZIPCDE) {
                    $zipcode = (string)($td->ZIPCDE);
                }
                if (null !== $td->IDE) {
                    $partyid = (string)($td->IDE);
                }
                $doStreetData = $this->getFullAddressData($td);
                $do = [
                    'name' => (string)($td->NAM),
                    'street' => $doStreetData['street'],
                    'street2' => $doStreetData['street2'],
                    'city' => (string)($td->CTY),
                    'country' => (string)($td->CNYCDE),
                    'zip' => $zipcode,
                    'custid' => (string)($td->CID),
                    'partyid' => $partyid,
                    "statecode" => $statecode,
                    "state" => $state,
                    "contact" => $this->getContactInformation($td)
                ];
                if (null !== $td->REF) {
                    if (!empty($td->REF)) {
                        foreach ($td->REF as $cref) {
                            $s = (string)$cref->CDE;
                            if ($s != "") {
                                if ($s == 'XSR') {
                                    $arr['xsrvalue'] = (string)$cref->VAL;
                                }
                                if ($s == 'DQ') {
                                    $s = "ACD";
                                }
                                $arr['doreferences'][] = [
                                    'code' => (string)$s,
                                    'value' => (string)$cref->VAL
                                ];
                            }
                        }
                    }
                }
            }
        }
        $infodata1->registerXPathNamespace('ns17', 'http://knie4.int.kn/com/txt/0500');
        $invoice = $infodata1->xpath('ns17:TXT');
        $arr['invoice'] = isset($invoice[0]) ? (string)($invoice[0]) : "";
        if ($arr['invoice'] != "") {
            $arr['invoice'] = str_replace("invoice no: ", "", $arr['invoice']);
        }
        $arr['carrier'] = $carrier;
        $arr['ff'] = $ff;
        $arr['do'] = $do;
        $waypoints = $infodata1->TRUWPN;
        foreach ($waypoints as $sd) {
            if ($sd->attributes('ns23', true)->WPNTYP == "PUP") {
                $sd->registerXPathNamespace('ns8', 'http://knie4.int.kn/com/adr/0500');
                $point = $sd->xpath('ns8:ADR');
                $arr1 = array();
                $pickupStreetData = $this->getFullAddressData($point[0]);
                $arr1['pickup_company'] = isset($point[0]->xpath('NAM')[0]) ? (string)($point[0]->xpath('NAM')[0]) : "";
                $arr1['pickup_address'] = $pickupStreetData['street'];
                $arr1['pickup_street2'] = $pickupStreetData['street2'];
                $arr1['pickup_city'] = isset($point[0]->xpath('CTY')[0]) ? (string)($point[0]->xpath('CTY')[0]) : "";
                $arr1['pickup_countrycode'] = isset($point[0]->xpath('CNYCDE')[0]) ? (string)($point[0]->xpath(
                    'CNYCDE'
                )[0]) : "";
                $arr1['pickup_state'] = isset($point[0]->xpath('STT')[0]) ? (string)($point[0]->xpath('STT')[0]) : "";
                $arr1['pickup_statecode'] = isset($point[0]->xpath('STTCDE')[0]) ? (string)($point[0]->xpath(
                    'STTCDE'
                )[0]) : "";
                $arr1['pickup_postal'] = isset($point[0]->xpath('ZIPCDE')[0]) ? (string)($point[0]->xpath(
                    'ZIPCDE'
                )[0]) : "";
                $arr1['pickup_custid'] = isset($point[0]->xpath('CID')[0]) ? (string)($point[0]->xpath('CID')[0]) : "";
                $partyid = isset($point[0]->xpath('IDE')[0]) ? $point[0]->xpath('IDE')[0] : "";
                $arr1['pickup_partyid'] = (string)($partyid);
                $arr1['sequence'] = 1;
                $arr1['stoptype'] = 'P';
                $arr1['pickup_datefrom'] = $arr1['pickup_dateto'] = isset($sd->DTERNG->DTEFRM) ? (string)$sd->DTERNG->DTEFRM : "";
                $arr1['pickup_datefromtime'] = isset($sd->DTERNG->TMEFRM) ? (string)$sd->DTERNG->TMEFRM : "";
                $arr1['pickup_datetotime'] = isset($sd->DTERNG->TMETO) ? (string)$sd->DTERNG->TMETO : "";
                $arr1['contact'] = $this->getContactInformation($point[0]);
                $p++;
                $pickdrop[] = $arr1;
            }
            if ($sd->attributes('ns23', true)->WPNTYP == "DEL") {
                $sd->registerXPathNamespace('ns8', 'http://knie4.int.kn/com/adr/0500');
                $point = $sd->xpath('ns8:ADR');
                $arr2 = array();
                $deliveryStreetData = $this->getFullAddressData($point[0]);
                $arr2['drop_company'] = isset($point[0]->xpath('NAM')[0]) ? (string)($point[0]->xpath('NAM')[0]) : "";
                $arr2['drop_address'] = $deliveryStreetData['street'];
                $arr2['drop_street2'] = $deliveryStreetData['street2'];
                $arr2['drop_city'] = isset($point[0]->xpath('CTY')[0]) ? (string)($point[0]->xpath('CTY')[0]) : "";
                $arr2['drop_countrycode'] = isset($point[0]->xpath('CNYCDE')[0]) ? (string)($point[0]->xpath(
                    'CNYCDE'
                )[0]) : "";
                $arr2['drop_state'] = isset($point[0]->xpath('STT')[0]) ? (string)($point[0]->xpath('STT')[0]) : "";
                $arr2['drop_statecode'] = isset($point[0]->xpath('STTCDE')[0]) ? (string)($point[0]->xpath(
                    'STTCDE'
                )[0]) : "";
                $arr2['drop_postal'] = isset($point[0]->xpath('ZIPCDE')[0]) ? (string)($point[0]->xpath(
                    'ZIPCDE'
                )[0]) : "";
                $arr2['drop_custid'] = isset($point[0]->xpath('CID')[0]) ? (string)($point[0]->xpath('CID')[0]) : "";
                $partyid = isset($point[0]->xpath('IDE')[0]) ? $point[0]->xpath('IDE')[0] : "";
                $arr2['drop_partyid'] = (string)($partyid);
                $arr2['sequence'] = 2;
                $arr2['stoptype'] = 'D';
                $arr2['drop_datefrom'] = $arr2['drop_dateto'] = isset($sd->DTERNG->DTEFRM) ? (string)$sd->DTERNG->DTEFRM : "";
                $arr2['drop_datefromtime'] = isset($sd->DTERNG->TMEFRM) ? (string)$sd->DTERNG->TMEFRM : "";
                $arr2['drop_datetotime'] = isset($sd->DTERNG->TMETO) ? (string)$sd->DTERNG->TMETO : "";
                $arr2['contact'] = $this->getContactInformation($point[0]);
                $d++;
                $pickdrop[] = $arr2;
            }
        }
        $arr['containerData'] = [];
        $arr['innerCargoData'] = [];
        if ($arr['sendertransmode'] == self::TRANSPORT_MODE_FOR_SEA) {
            $getContainersData = $this->parseContainersData($infodata1->CNTDTL ?? new stdClass());
            if (!empty($getContainersData['containersData'])) {
                $arr['containerData'] = $getContainersData['containersData'] ?? [];
                $arr['pkgs_count'] = $getContainersData['totalQuantity'];
                $arr['pkgs_uom'] = $getContainersData['containerTypesString'];
                $arr['gross_weight'] = $getContainersData['totalWeight'];
                $arr['weight_uom'] = $getContainersData['weightUom'];
                $arr['volume'] = $getContainersData['totalVolume'];
                $arr['volume_uom'] = $getContainersData['volumeUom'];
                $arr['sealReferenceNumbers'] = $getContainersData['sealReferenceNumbers'];
                $arr['innerCargoData'] = $this->parseInnerCargoData($infodata[0]->xpath('CGODSC') ?? []);
            }
        }
        $arr['pickdrops'] = $pickdrop;
        $arr['pickcount'] = $p;
        $arr['dropcount'] = $d;
        $arr['typeofbusiness'] = "DOMESTIC";
        return $arr;
    }

    public function insertShipmentData($data, $logdate)
    {
        $curtz = date_default_timezone_get();
        $curdt = $logdate;
        $responseord = [];
        $transmode = "TL";
        $dedicateveh = 0;
        $user_id = 1;
        $country_code = "";
        foreach ($data['shipdata'] as $shipdata) {
            $ttansmode = $shipdata['servicetype'];
            if ($ttansmode != "Full Truck Load") {
                $transmode = "LTL";
                $dedicateveh = 0;
            }
            $orderid = $shipdata['orderid'];
            $receivers = $data['header']['receivers'];
            $functionCode = $data['header']['function_code'];
            if ($functionCode == 'CA') {
                if ($this->cancelOrder($orderid, [
                    'function_code' => $functionCode,
                    'xsr_value' => $shipdata['xsrvalue'],
                    'dq_number' => $shipdata['orderid'],
                    'salog_user_email_id' => $shipdata['salog_user_email_id'],
                    'transport_mode' => $shipdata['sendertransmode'],
                    'sdt_value' => $ttansmode
                ])) {
                    return 'order cancelled';
                }
            }
            if (!empty($receivers)) {
                foreach ($receivers as $refs) {
                    $ordref = [
                        'order_id' => $orderid,
                        'physicalsender' => $data['header']['psender'],
                        'logicalsender' => $data['header']['lsender'],
                        'sendermsgtype' => $data['header']['msgtype'],
                        'physicalreceiver' => $refs['physicalreceiver'],
                        'logicalreceiver' => $refs['logicalreceiver'],
                        'receivermsgtype' => $refs['mtype'],
                        'senderapp' => $data['header']['sendapp']
                    ];
                    $ins = $this->db->insert("tb_order_send_receiver", $ordref);
                }
            }
            $lsender = $data['header']['lsender'];
            if (strlen($lsender) > 2) {
                $firsttwochars = substr($lsender, 0, 2);
            } else {
                $firsttwochars = $lsender;
            }
            $companycode = $company_code = $shipdata['sendercmpcode'];
            $branch_code = $shipdata['senderbranchcode'];
            $chklreceiver = $data['header']['lreceiver'];
            if ($chklreceiver != "" && $company_code != self::TAIWAN_COMPANY_CODE) {
                $chkcmp = $this->db->select("branch_code,company_code")->get_where(
                    "tb_branch_master",
                    [
                        "logical_sender" => $chklreceiver,
                        "status" => 1
                    ],
                    1,
                    0
                );
                if ($chkcmp->num_rows() > 0) {
                    $company_code = $chkcmp->row()->company_code;
                    $branch_code = $chkcmp->row()->branch_code;
                }
            }
            if ($company_code == self::TAIWAN_COMPANY_CODE) {
                $branch_code = 'TWTPE';
            }

            $chk = $this->db->query(
                "SELECT id,country_code FROM tb_users WHERE company_code='" . $company_code . "' AND branch_code='" . $branch_code . "' AND status='Active' LIMIT 1"
            );
            if ($chk->num_rows() > 0) {
                $user_id = $chk->row()->id;
                $country_code = $chk->row()->country_code;
            } else {
                $chk01 = $this->db->query(
                    "SELECT user_id FROM tb_user_companies WHERE company_code='" . $company_code . "' AND branch_code='" . $branch_code . "' AND status=1 LIMIT 1"
                );
                if ($chk01->num_rows() > 0) {
                    $user_id = $chk01->row()->user_id;
                } else {
                    $country_code = $firsttwochars;
                    $adminrand = time();
                    $adminpwd = password_hash($adminrand, PASSWORD_DEFAULT);
                    $udata = [
                        'country_code' => $firsttwochars,
                        'name' => $firsttwochars . "_Admin",
                        'company_indv_name' => $company_code,
                        'business_type' => 'Truck_Owner',
                        'mobile_no' => $adminrand,
                        'password' => $adminpwd,
                        'emailid' => 'svkonekt@kuehne-nagel.com',
                        'domain_name' => $branch_code,
                        'location_id' => 1646,
                        'createdby' => 1,
                        'status' => 'Active',
                        'createdon' => $curdt,
                        'company_code' => $company_code,
                        'branch_code' => $branch_code
                    ];
                    $user_id = $this->common->insertTableData('tb_users', $udata);
                }
            }
            $this->edi_logger->setUser_id($user_id);
            $carrier_id = 0;
            $allOrderParties = [];
            $data['truck']['shipment_id'] = $data['truck']['ordernum'] = mt_rand();
            $shipdata['incoterm'] = "";
            $getactual = getdatetimebytimezone(DFLT_TZ, $shipdata['statusinfo_date'], $curtz);
            /*cargo details*/
            $cargo_content = "Boxes";
            if (!empty($shipdata['cargo_content'])) {
                $cargo_content = implode(",", $shipdata['cargo_content']);
                $cargo_content = substr($cargo_content, 0, 95);
            }

            $shipdata['sourcedate'] = $shipdata['destinationdate'] = $getactual['datetime'];
            $shipdatains = [
                'shipid' => $orderid,
                'txnid' => $orderid,
                'trucktype' => $data['truck']['ordernum'],
                'product' => $shipdata['serviceproduct'],
                'pickupcnt' => $shipdata['pickcount'],
                'dropcnt' => $shipdata['dropcount'],
                'unitspec' => $cargo_content,
                'insertusr' => $shipdata['shipper']['custid'],
                'carrier' => $carrier_id,
                'insertuserdate' => $shipdata['statusinfo_date'],
                'enddate' => $shipdata['statusinfo_date'],
                'insdate' => $shipdata['statusinfo_date'],
                'upddate' => $shipdata['statusinfo_date'],
                'reason' => $data['header']['sendapp'],
                'purpose' => 'SEND INTEGRATION',
                'ship_object' => $data['header']['msgtype'],
                'logdate' => $logdate,
                'status' => 1,
                'createdon' => $curdt,
                'transport_mode' => $transmode,
                'txncode' => $shipdata['orderid'],
                'domainname' => $data['header']['lsender'],
                'company_code' => $shipdata['sendercmpcode'],
                'branch_code' => $branch_code,
                'freight_term' => $shipdata['freight_term'],
                'freight_termname' => $shipdata['freight_termname'],
                'incoterm' => $shipdata['incoterm'],
                'logicalreceiver' => $data['header']['lreceiver'],
                'physicalreceiver' => $data['header']['preceiver'],
                'physicalsender' => $data['header']['psender'],
                'logicalsender' => $data['header']['lsender'],
                'modeoftransport' => $shipdata['sendertransmode']
            ];
            $sship_id = $this->common->insertTableData('tb_shipments', $shipdatains);
            $pickup_datetime = $pickup_endtime = $delivery_datetime = $drop_endtime = $pickup_company = "";
            $check_pickup = $check_drop = 0;
            if (isset($shipdata['pickdrops'])) {
                foreach ($shipdata['pickdrops'] as $res) {
                    if ($res['stoptype'] == "P") {
                        $check_pickup = 1;
                        $orderPickupTime = $this->getOrderPickOrDeliveryDate($res['pickup_datefrom'],$res['pickup_datefromtime'],$user_id,$country_code);
                        $pickup_datetime = $orderPickupTime['datetime'];
                        $res['pickup_dateto'] = ($res['pickup_dateto'] != "") ? $res['pickup_dateto'] : date('Y-m-d', strtotime('+3 hours', strtotime($orderPickupTime['localtime'])));
                        $res['pickup_datetotime'] = ($res['pickup_datetotime'] != "") ? $res['pickup_datetotime'] : date('H:i:s', strtotime('+3 hours', strtotime($orderPickupTime['localtime'])));
                        $orderPickupEndTime = $this->getOrderPickOrDeliveryDate($res['pickup_dateto'],$res['pickup_datetotime'],$user_id,$country_code,"EndTime");
                        $pickup_endtime = $orderPickupEndTime['datetime'];
                        $pickup_company = $res['pickup_company'];
                        $pickup_address = $res['pickup_address'];
                        $pickup_street2 = $res['pickup_street2'];
                        $pickup_city = $res['pickup_city'];
                        $pickup_countrycode = $res['pickup_countrycode'];
                        $pickup_postal = $res['pickup_postal'];
                        $pickup_address1 = ($res['pickup_state'] == "") ? $pickup_city : $res['pickup_state'];
                        $pickup_statecode = $res['pickup_statecode'];
                        $pickup_custid = $res['pickup_custid'];
                        $pickup_partyid = $res['pickup_partyid'];
                        $pickupContact = $res['contact'];
                    }
                    if ($res['stoptype'] == "D") {
                        $check_drop = 1;
                        $orderDeliveryTime = $this->getOrderPickOrDeliveryDate($res['drop_datefrom'],$res['drop_datefromtime'],$user_id,$country_code);
                        $orderDeliveryTime['datetime'] = ($pickup_datetime != $orderDeliveryTime['datetime']) ? $orderDeliveryTime['datetime'] : date('Y-m-d H:i:s', strtotime('+3 hours', strtotime($orderDeliveryTime['datetime'])));
                        $delivery_datetime = $orderDeliveryTime['datetime'];
                        $res['drop_dateto'] = ($res['drop_dateto'] != "") ? $res['drop_dateto'] : date('Y-m-d', strtotime('+3 hours', strtotime($orderDeliveryTime['localtime'])));
                        $res['drop_datetotime'] = ($res['drop_datetotime'] != "") ? $res['drop_datetotime'] : date("H:i:s",strtotime('+3 hours', strtotime($orderDeliveryTime['localtime'])));
                        $orderDeliverEndTime = $this->getOrderPickOrDeliveryDate($res['drop_dateto'],$res['drop_datetotime'],$user_id,$country_code,"EndTime");
                        $drop_endtime = $orderDeliverEndTime['datetime'];
                        $drop_company = $res['drop_company'];
                        $drop_address = $res['drop_address'];
                        $drop_street2 = $res['drop_street2'];
                        $drop_city = $res['drop_city'];
                        $drop_countrycode = $res['drop_countrycode'];
                        $drop_postal = $res['drop_postal'];
                        $drop_address1 = ($res['drop_state'] == "") ? $drop_city : $res['drop_state'];
                        $drop_statecode = $res['drop_statecode'];
                        $drop_custid = $res['drop_custid'];
                        $drop_partyid = $res['drop_partyid'];
                        $dropContact = $res['contact'];
                    }
                }
                if ($check_pickup == 0 || $check_drop == 0) {
                    if ($check_pickup == 0 && isset($shipdata['shipper'])) {
                        $shipchk = $shipdata['shipper'];
                        $check_pickup = 1;
                        $pickup_datetime = $curdt;
                        $pickup_endtime = date('Y-m-d H:i:s', strtotime('+3 hours', strtotime($pickup_datetime)));
                        $pickup_company = $shipchk['name'];
                        $pickup_address = $shipchk['street'];
                        $pickup_street2 = $shipchk['street2'];
                        $pickup_city = $shipchk['city'];
                        $pickup_countrycode = $shipchk['country'];
                        $pickup_postal = $shipchk['zip'];
                        $pickup_address1 = $shipchk['state'];
                        $pickup_statecode = $shipchk['statecode'];
                        $pickup_custid = $shipchk['custid'];
                        $pickup_partyid = $shipchk['partyid'];
                        $pickupContact = $shipchk['contact'];
                    }
                    if ($check_drop == 0 && isset($shipdata['consignee'])) {
                        $check_drop = 1;
                        $conschk = $shipdata['consignee'];
                        $delivery_datetime = date('Y-m-d H:i:s', strtotime('+3 hours', strtotime($curdt)));
                        $drop_endtime = date('Y-m-d H:i:s', strtotime('+3 hours', strtotime($delivery_datetime)));
                        $drop_company = $conschk['name'];
                        $drop_address = $conschk['street'];
                        $drop_street2 = $conschk['street2'];
                        $drop_city = $conschk['city'];
                        $drop_countrycode = $conschk['country'];
                        $drop_postal = $conschk['zip'];
                        $drop_address1 = $conschk['state'];
                        $drop_statecode = $conschk['statecode'];
                        $drop_custid = $conschk['custid'];
                        $drop_partyid = $conschk['partyid'];
                        $dropContact = $conschk['contact'];
                    }
                }
                if ($check_pickup == 1 && $check_drop == 1) {
                    $chkcusttype = "";
                    if (isset($shipdata['freight_term'])) {
                        if ($shipdata['freight_term'] == "30" || $shipdata['freight_term'] == "31") {
                            $chkcusttype = "CN";
                        } else {
                            if ($shipdata['freight_term'] == "20") {
                                $chkcusttype = "PF";
                            } else {
                                if ($shipdata['freight_term'] == "10") {
                                    $chkcusttype = "SH";
                                } else {
                                    if ($shipdata['freight_term'] == "60") {
                                        $chkcusttype = "PF";
                                    }
                                }
                            }
                        }
                    } else {
                        $shipdata['freight_term'] = 60;
                    }
                    $customer_id = 0;
                    $shipdata['delivery'] = [
                        'name' => $drop_company,
                        'street' => $drop_address,
                        'street2' => $drop_street2,
                        'city' => $drop_city,
                        'country' => $drop_countrycode,
                        'zip' => $drop_postal,
                        'custid' => $drop_custid,
                        'partyid' => $drop_partyid,
                        "statecode" => $drop_statecode,
                        "state" => $drop_address1,
                        "contact" => $dropContact ?? []
                    ];
                    $shipdata['pickup'] = [
                        'name' => $pickup_company,
                        'street' => $pickup_address,
                        'street2' => $pickup_street2,
                        'city' => $pickup_city,
                        'country' => $pickup_countrycode,
                        'zip' => $pickup_postal,
                        'custid' => $pickup_custid,
                        'partyid' => $pickup_partyid,
                        "statecode" => $pickup_statecode,
                        "state" => $pickup_address1,
                        "contact" => $pickupContact ?? []
                    ];
                    $checkConsigneeAndShipperLogic = checkAccessConditions('SALOG_PARTY_CONDITION', $company_code);
                    if ($company_code == self::TAIWAN_COMPANY_CODE) {
                        $branch_code = $shipdata['senderbranchcode'];
                    }
                    if (!$checkConsigneeAndShipperLogic && !empty($shipdata['consignee'])) {
                        $deliverParty = $this->checkOrderParty(
                            $shipdata['consignee'],
                            $company_code,
                            $branch_code,
                            $user_id,
                            self::DELIVERY_PARTY,
                            $chkcusttype
                        );
                        $consignee = $this->checkOrderParty(
                            $shipdata['delivery'],
                            $company_code,
                            $branch_code,
                            $user_id,
                            self::CONSIGNEE_PARTY
                        );
                        $allOrderParties[] = [
                            "party_id" => $consignee['party_id'],
                            "party_type" => $consignee['party_type']
                        ];
                        if (!empty($consignee['contact_reference'])) {
                            $contactReferences [] = $consignee['contact_reference'];
                        }
                    } elseif ($checkConsigneeAndShipperLogic && !empty($shipdata['consignee'])) {
                        $deliverParty = $this->checkOrderParty(
                            $shipdata['delivery'],
                            $company_code,
                            $branch_code,
                            $user_id,
                            self::DELIVERY_PARTY,
                            $chkcusttype
                        );
                        $consignee = $this->checkOrderParty(
                            $shipdata['consignee'],
                            $company_code,
                            $branch_code,
                            $user_id,
                            self::CONSIGNEE_PARTY
                        );
                        $allOrderParties[] = [
                            "party_id" => $consignee['party_id'],
                            "party_type" => $consignee['party_type']
                        ];
                        if (!empty($consignee['contact_reference'])) {
                            $contactReferences [] = $consignee['contact_reference'];
                        }
                    } else {
                        $deliverParty = $this->checkOrderParty(
                            $shipdata['delivery'],
                            $company_code,
                            $branch_code,
                            $user_id,
                            self::DELIVERY_PARTY,
                            $chkcusttype
                        );
                    }
                    $allOrderParties[] = [
                        "party_id" => $deliverParty['party_id'],
                        "party_type" => $deliverParty['party_type']
                    ];
                    if (!empty($deliverParty['contact_reference'])) {
                        $contactReferences [] = $deliverParty['contact_reference'];
                    }
                    if ($deliverParty['id'] > 0) {
                        $customer_id = $deliverParty['id'];
                    }
                    if (!$checkConsigneeAndShipperLogic && !empty($shipdata['shipper'])) {
                        $pickupParty = $this->checkOrderParty(
                            $shipdata['shipper'],
                            $company_code,
                            $branch_code,
                            $user_id,
                            self::PICKUP_PARTY,
                            $chkcusttype
                        );
                        $shipper = $this->checkOrderParty(
                            $shipdata['pickup'],
                            $company_code,
                            $branch_code,
                            $user_id,
                            self::SHIPPER_PARTY
                        );
                        $allOrderParties[] = [
                            "party_id" => $shipper['party_id'],
                            "party_type" => $shipper['party_type']
                        ];
                        if (!empty($shipper['contact_reference'])) {
                            $contactReferences [] = $shipper['contact_reference'];
                        }
                    } elseif ($checkConsigneeAndShipperLogic && !empty($shipdata['shipper'])) {
                        $pickupParty = $this->checkOrderParty(
                            $shipdata['pickup'],
                            $company_code,
                            $branch_code,
                            $user_id,
                            self::PICKUP_PARTY,
                            $chkcusttype
                        );
                        $shipper = $this->checkOrderParty(
                            $shipdata['shipper'],
                            $company_code,
                            $branch_code,
                            $user_id,
                            self::SHIPPER_PARTY
                        );
                        $allOrderParties[] = [
                            "party_id" => $shipper['party_id'],
                            "party_type" => $shipper['party_type']
                        ];
                        if (!empty($shipper['contact_reference'])) {
                            $contactReferences [] = $shipper['contact_reference'];
                        }
                    } else {
                        $pickupParty = $this->checkOrderParty(
                            $shipdata['pickup'],
                            $company_code,
                            $branch_code,
                            $user_id,
                            self::PICKUP_PARTY,
                            $chkcusttype
                        );
                    }
                    $allOrderParties[] = [
                        "party_id" => $pickupParty['party_id'],
                        "party_type" => $pickupParty['party_type']
                    ];
                    if (!empty($pickupParty['contact_reference'])) {
                        $contactReferences [] = $pickupParty['contact_reference'];
                    }
                    if ($pickupParty['id'] > 0) {
                        $customer_id = $pickupParty['id'];
                    }

                    if (isset($shipdata['pf'])) {
                        if (!empty($shipdata['pf'])) {
                            $customer = $this->checkOrderParty(
                                $shipdata['pf'],
                                $company_code,
                                $branch_code,
                                $user_id,
                                self::FREIGHT_PAYER,
                                $chkcusttype
                            );
                            if ($customer['id'] > 0) {
                                $customer_id = $customer['id'];
                            }
                            $allOrderParties[] = [
                                "party_id" => $customer['party_id'],
                                "party_type" => $customer['party_type']
                            ];
                            if (!empty($customer['contact_reference'])) {
                                $contactReferences [] = $customer['contact_reference'];
                            }
                        }
                    }

                    $depart_code = $shipdata['senderdeptcode'];
                    $customerDetails = $this->checkSalogCustomersData([
                        'company_code' => $company_code,
                        'branch_code' => $branch_code,
                        'department_code' => $depart_code,
                        'transport_mode' => $shipdata['sendertransmode'],
                        'logical_sender' => $lsender,
                        'sender_branch_code' => $shipdata['senderbranchcode']
                    ]);
                    $customer_id = $customerDetails['customerId'];
                    $allOrderParties[] = [
                        "party_id" => $customerDetails['partyMasterId'],
                        "party_type" => $customerDetails['partyTypeId']
                    ];
                    if (!empty($shipdata['ff'])) {
                        $ff = $this->checkOrderParty(
                            $shipdata['ff'],
                            $company_code,
                            $branch_code,
                            $user_id,
                            self::FREIGHT_PAYER
                        );
                        $allOrderParties[] = [
                            "party_id" => $ff['party_id'],
                            "party_type" => $ff['party_type']
                        ];
                        if (!empty($ff['contact_reference'])) {
                            $contactReferences [] = $ff['contact_reference'];
                        }
                    }
                    if (!empty($shipdata['do'])) {
                        $do = $this->checkOrderParty(
                            $shipdata['do'],
                            $company_code,
                            $branch_code,
                            $user_id,
                            self::NOTIFY_PARTY
                        );
                        $allOrderParties[] = [
                            "party_id" => $do['party_id'],
                            "party_type" => $do['party_type']
                        ];
                        if (!empty($do['contact_reference'])) {
                            $contactReferences [] = $do['contact_reference'];
                        }
                    }
                    if ($customer_id == 0) {
                        if (!empty($shipdata['customer'])) {
                            $customer = $this->checkOrderParty(
                                $shipdata['customer'],
                                $company_code,
                                $branch_code,
                                $user_id,
                                self::CUSTOMER_PARTY
                            );
                            if ($customer['id'] > 0) {
                                $customer_id = $customer['id'];
                            }
                            $allOrderParties[] = [
                                "party_id" => $customer['party_id'],
                                "party_type" => $customer['party_type']
                            ];
                            if (!empty($customer['contact_reference'])) {
                                $contactReferences [] = $customer['contact_reference'];
                            }
                        } else {
                            if ($shipdata['freight_term'] != "60") {
                                $branchwisecust = $this->db->query(
                                    "SELECT id FROM tb_customers WHERE user_id=$user_id AND company_code='" . $company_code . "' AND branch_code='" . $branch_code . "' ORDER BY id ASC LIMIT 1"
                                );
                                if ($branchwisecust->num_rows() > 0) {
                                    $customer_id = $branchwisecust->row()->id;
                                } else {
                                    $randnum = mt_rand();
                                    $pwd = password_hash($randnum, PASSWORD_DEFAULT);
                                    $cinsdata = [
                                        'name' => $company_code . "_Customer",
                                        'phone' => $randnum,
                                        'location' => $firsttwochars,
                                        'address' => $firsttwochars,
                                        'pincode' => $firsttwochars,
                                        'code' => $randnum,
                                        'country' => $firsttwochars,
                                        'password' => $pwd,
                                        'user_id' => $user_id,
                                        'company_code' => $company_code,
                                        'branch_code' => $branch_code,
                                        'status' => 1,
                                        'createdon' => $curdt,
                                        'updatedon' => $curdt
                                    ];
                                    $customer_id = $this->common->insertTableData('tb_customers', $cinsdata);
                                }
                            }
                        }
                    }
                    /*orders table */
                    $startlat = $startlong = $endlat = $endlong = "";
                    $sloc = $pickup_address . ", " . $pickup_city . ", " . $pickup_countrycode . ", " . $pickup_postal;
                    $eloc = $drop_address . ", " . $drop_city . ", " . $drop_countrycode . ", " . $drop_postal;
                    $cheklatlng = $this->getlatlongbylocname($sloc);
                    if (!empty($cheklatlng)) {
                        $startlat = $cheklatlng['latitude'];
                        $startlong = $cheklatlng['longitude'];
                    }
                    $cheklatlng1 = $this->getlatlongbylocname($eloc);
                    if (!empty($cheklatlng1)) {
                        $endlat = $cheklatlng1['latitude'];
                        $endlong = $cheklatlng1['longitude'];
                    }
                    $xsrvalue = $shipdata['xsrvalue'];
                    $dqnum = $shipdata['orderid'];
                    $bookext = $booking_id = 0;
                    $oarr = $this->getExistingOrderIds($xsrvalue,$dqnum);
                    if ($company_code == self::TAIWAN_COMPANY_CODE) {
                        $branch_code = 'TWTPE';
                    }
                    $isNewOrder = 0;
                    if (($company_code == "IDKN") && ($shipdata['shipper']['custid'] == '1000613651')) {
                        $shipdata['shipper']['name'] = $pickup_company= 'Ecco Indonesia';
                        $shipdata['shipper']['custid'] = '1002895786';
                    }
                    if (($company_code == "IDKN") && ($shipdata['consignee']['custid'] == '1000613651')) {
                        $shipdata['consignee']['name'] = $drop_company = 'Ecco Indonesia';
                        $shipdata['consignee']['custid'] = '1002895786';
                    }
                    if (count($oarr) == 1) {
                        $orddata = [
                            'pickup_datetime' => $pickup_datetime,
                            'pickup_endtime' => $pickup_endtime,
                            'delivery_datetime' => $delivery_datetime,
                            'drop_endtime' => $drop_endtime,
                            'pickup_company' => $pickup_company,
                            'delivery_company' => $drop_company,
                            'pickup_country' => $pickup_countrycode,
                            'delivery_country' => $drop_countrycode,
                            'pickup_city' => $pickup_city,
                            'delivery_city' => $drop_city,
                            'pickup_pincode' => $pickup_postal,
                            'delivery_pincode' => $drop_postal,
                            'pickup_address1' => $pickup_address,
                            'delivery_address1' => $drop_address,
                            'pickup_address2' => $pickup_address1,
                            'delivery_address2' => $drop_address1,
                            'quantity' => $shipdata['pkgs_count'],
                            'weight' => $shipdata['gross_weight'],
                            'gross_weight_uom' => $shipdata['weight_uom'],
                            'chargeable_weight' => $shipdata['charge_weight'],
                            'chargeable_weight_uom' => $shipdata['charge_uom'],
                            'volume' => $shipdata['volume'],
                            'goods_value' => $shipdata['goods_value'],
                            'currency' => $shipdata['goods_currency'],
                            'transport_mode' => $transmode,
                            'dedicated_vehicle' => $dedicateveh,
                            'vehicle_type' => $transmode,
                            'user_id' => $user_id,
                            'customer_id' => $customer_id,
                            'customer_name' => $shipdata['customer']['name'],
                            'customer_code' => $shipdata['customer']['custid'],
                            'customer_area' => ($shipdata['customer']['street'] . ", " . $shipdata['customer']['city'] . ", " . $shipdata['customer']['zip']),
                            'customer_phone' => $shipdata['customer']['custid'],
                            'vendor_name' => $shipdata['shipper']['name'],
                            'vendor_code' => $shipdata['shipper']['custid'],
                            'vendor_area' => ($shipdata['shipper']['street'] . ", " . $shipdata['shipper']['city'] . ", " . $shipdata['shipper']['zip']),
                            'vendor_phone' => $shipdata['shipper']['custid'],
                            'plat' => $startlat,
                            'plng' => $startlong,
                            'dlat' => $endlat,
                            'dlng' => $endlong,
                            'company_code' => $company_code,
                            'branch_code' => $branch_code,
                            'product' => $shipdata['serviceproduct'],
                            'shipment_id' => $sship_id,
                            'pickup_custid' => $pickup_custid,
                            'pickup_partyid' => $pickup_partyid,
                            'drop_custid' => $drop_custid,
                            'drop_partyid' => $drop_partyid,
                            "created_source" => 5,
                            'logicalreceiver' => $data['header']['lreceiver'],
                            'physicalreceiver' => $data['header']['preceiver'],
                            'physicalsender' => $data['header']['psender'],
                            'logicalsender' => $data['header']['lsender'],
                            'modeoftransport' => $shipdata['sendertransmode']
                        ];
                        $ord_id = $oarr[0];
                        $upd = $this->common->updatetbledata('tb_orders', $orddata, ["id" => $ord_id]);
                        $bookext = 1;
                        $bookingchk = $this->common->gettblrowdata(
                            array("id" => $ord_id),
                            "order_id",
                            "tb_orders",
                            0,
                            0
                        );
                        if (count($bookingchk) > 0) {
                            $booking_id = $bookingchk['order_id'];
                        }
                    } else {
                        $isNewOrder = 1;
                        $orddata = [
                            'order_id' => $shipdata['orderid'],
                            'pickup_datetime' => $pickup_datetime,
                            'pickup_endtime' => $pickup_endtime,
                            'delivery_datetime' => $delivery_datetime,
                            'drop_endtime' => $drop_endtime,
                            'pickup_company' => $pickup_company,
                            'delivery_company' => $drop_company,
                            'pickup_country' => $pickup_countrycode,
                            'delivery_country' => $drop_countrycode,
                            'pickup_city' => $pickup_city,
                            'delivery_city' => $drop_city,
                            'pickup_pincode' => $pickup_postal,
                            'delivery_pincode' => $drop_postal,
                            'pickup_address1' => $pickup_address,
                            'delivery_address1' => $drop_address,
                            'pickup_address2' => $pickup_address1,
                            'delivery_address2' => $drop_address1,
                            'quantity' => $shipdata['pkgs_count'],
                            'weight' => $shipdata['gross_weight'],
                            'gross_weight_uom' => $shipdata['weight_uom'],
                            'chargeable_weight' => $shipdata['charge_weight'],
                            'chargeable_weight_uom' => $shipdata['charge_uom'],
                            'volume' => $shipdata['volume'],
                            'goods_value' => $shipdata['goods_value'],
                            'currency' => $shipdata['goods_currency'],
                            'transport_mode' => $transmode,
                            'dedicated_vehicle' => $dedicateveh,
                            'vehicle_type' => $transmode,
                            'user_id' => $user_id,
                            'customer_id' => $customer_id,
                            'vendor_id' => $carrier_id,
                            'customer_name' => $shipdata['customer']['name'],
                            'customer_code' => $shipdata['customer']['custid'],
                            'customer_area' => ($shipdata['customer']['street'] . ", " . $shipdata['customer']['city'] . ", " . $shipdata['customer']['zip']),
                            'customer_phone' => $shipdata['customer']['custid'],
                            'vendor_name' => $shipdata['shipper']['name'],
                            'vendor_code' => $shipdata['shipper']['custid'],
                            'vendor_area' => ($shipdata['shipper']['street'] . ", " . $shipdata['shipper']['city'] . ", " . $shipdata['shipper']['zip']),
                            'vendor_phone' => $shipdata['shipper']['custid'],
                            'plat' => $startlat,
                            'plng' => $startlong,
                            'dlat' => $endlat,
                            'dlng' => $endlong,
                            'company_code' => $company_code,
                            'branch_code' => $branch_code,
                            'product' => $shipdata['serviceproduct'],
                            'shipment_id' => $sship_id,
                            'pickup_custid' => $pickup_custid,
                            'pickup_partyid' => $pickup_partyid,
                            'drop_custid' => $drop_custid,
                            'drop_partyid' => $drop_partyid,
                            'status' => 1,
                            'createdon' => $curdt,
                            'updatedon' => $curdt,
                            "created_source" => 5,
                            'logicalreceiver' => $data['header']['lreceiver'],
                            'physicalreceiver' => $data['header']['preceiver'],
                            'physicalsender' => $data['header']['psender'],
                            'logicalsender' => $data['header']['lsender'],
                            'modeoftransport' => $shipdata['sendertransmode']
                        ];
                        $ord_id = $this->common->insertTableData('tb_orders', $orddata);
                    }
                    $this->edi_logger->setTxn_obj_id($xsrvalue);
                    $this->edi_logger->setCompany_code($shipdata['sendercmpcode']);
                    $this->edi_logger->setBranch_code($branch_code);
                    $responseord[] = $ord_id;
                    if ($ord_id > 0) {
                        $department_code = $shipdata['senderdeptcode'];
                        $order_type = $this->getOrderType($company_code, $branch_code);
                        if ($country_code == "") {
                            $get_country = $this->db->select('country_code,company_code')->get_where(
                                "tb_users",
                                ['id' => $user_id]
                            );
                            $country_code = $get_country->row()->country_code;
                            $company_code = $get_country->row()->company_code;
                        }
                        $genord = [
                            "user_id" => $user_id,
                            "order_id" => $ord_id,
                            "country_code" => $country_code,
                            "company_code" => $company_code
                        ];
                        if ($bookext == 0) {
                            $booking_id = generatebookingid($genord);
                            $upd = $this->common->updatetbledata(
                                "tb_orders",
                                ['order_id' => $booking_id],
                                ['id' => $ord_id]
                            );
                        }
                        $shipdata['order_id'] = $booking_id;
                        $checkDepartmentCode = $this->checkAndUpdateDepartment($department_code, $company_code, $branch_code);
                        if ($bookext == 0) {
                            $details_ins = [
                                'order_row_id' => $ord_id,
                                'order_id' => $booking_id,
                                'order_status' => 'PENDING',
                                'distance' => '0',
                                'department_code' => $department_code,
                                'order_type' => $order_type,
                                'createdon' => $curdt
                            ];
                            $detailsins = $this->common->insertTableData('tb_order_details', $details_ins);
                        } else {
                            $upd = $this->common->updatetbledata(
                                "tb_order_details",
                                [
                                    'department_code' => $department_code,
                                    'order_type' => $order_type
                                ],
                                ['order_row_id' => $ord_id]
                            );
                        }
                        /*update cargo details data*/
                        $cargoDetailId = $cargoId = 0;
                        $hunit = 1;
                        $chkhandlingunit = $this->db->select("id")->get_where(
                            "tbl_shipunit_types",
                            ["unit_name" => $shipdata['pkgs_uom'], "status" => 1],
                            1,
                            0
                            );
                        if ($chkhandlingunit->num_rows() > 0) {
                            $hunit = $chkhandlingunit->row()->id;
                        }
                        $dgGoods = ($shipdata['dangerousflag'] == "Y") ? 1 : 0;
                        $salogReferences = [];
                        if ($shipdata['sendertransmode'] == self::TRANSPORT_MODE_FOR_SEA && !empty($shipdata['containerData'])) {
                            $getCargoIdsByInsertOrUpdateOfOuterAndInnerCargos = $this->getCargoIdsByInsertOrUpdateOfOuterAndInnerCargos([
                                'containerData' => $shipdata['containerData'],
                                'innerCargoData' => $shipdata['innerCargoData'],
                                'dgCargos' => $shipdata['dgCargos'],
                                'shipData' => $shipdata,
                                'timeStamp' => $curdt,
                                'orderRowId' => $ord_id,
                                'userId' => $user_id
                            ]);
                            $cargoId = $getCargoIdsByInsertOrUpdateOfOuterAndInnerCargos['cargoId'];
                            $cargoDetailId = $getCargoIdsByInsertOrUpdateOfOuterAndInnerCargos['cargoDetailId'];
                            foreach($shipdata['sealReferenceNumbers'] as $eachSealReferenceNumber){
                                $salogReferences[] = [
                                    "order_id" => $ord_id,
                                    "reference_id" => 'SEAL',
                                    "ref_value" => $eachSealReferenceNumber
                                ];
                            }
                        } else {
                            $getCargoIdsByInsertOrUpdate = $this->getCargoIdsByInsertOrUpdate([
                                'shipData' => $shipdata,
                                'cargoContent' => $cargo_content,
                                'dgCargos' => $shipdata['dgCargos'],
                                'dgGoods' => $dgGoods,
                                'timeStamp' => $curdt,
                                'hunit' => $hunit,
                                'orderRowId' => $ord_id
                            ]);
                            $cargoId = $getCargoIdsByInsertOrUpdate['cargoId'];
                            $cargoDetailId = $getCargoIdsByInsertOrUpdate['cargoDetailId'];
                        }
                        $cargodata = [
                                'order_id' => $ord_id,
                                'cargo_id' => $cargoDetailId,
                                'handling_unit' => $hunit,
                                'length' => 0.00,
                                'width' => 0.00,
                                'height' => 0.00,
                                'weight' => $shipdata['gross_weight'],
                                'volume' => $shipdata['volume'],
                                'quantity' => $shipdata['pkgs_count'],
                                'quantity_type' => $shipdata['pkgs_uom'],
                                'cargo_content' => $cargo_content,
                                'status' => 1
                            ];
                        $qrcode = $this->generateQRCodes($cargoId, $cargodata);
                        /*send mail to customer*/
                        if(!empty($qrcode)) {
                            $custdata = [
                                "cust_id" => $customer_id,
                                "qr_path" => $qrcode['qr_path'],
                                "order_id" => $shipdata['orderid'],
                                'weight' => $shipdata['gross_weight'],
                                'volume' => $shipdata['volume'],
                                'quantity' => $shipdata['pkgs_count'],
                                'quantity_type' => $shipdata['pkgs_uom'],
                                'cargo_content' => $cargo_content
                            ];
                            if (!in_array($company_code, ['PLKN', 'AEKN', 'SGKN'])) {
                                $sendQRmail = $this->sendQRmail($custdata);
                            }
                        }
                    }
                    if ($ttansmode != "") {
                        $salogReferences[] = [
                            "order_id" => $ord_id,
                            "reference_id" => 'SDT',
                            "ref_value" => $ttansmode
                        ];
                    }
                    $isDQReplaceByXSR = 0;
                    if (checkAccessConditions('REFLECT_DQ_AS_XSR_COUNTRIES', $company_code)) {
                        $isDQReplaceByXSR = 1;
                    }
                    $salogReferences[] = [
                        "order_id" => $ord_id,
                        "reference_id" => 'DQ',
                        "ref_value" => $isDQReplaceByXSR === 1 ? $xsrvalue : $dqnum
                    ];
                    if (checkAccessConditions("CHECK_STS_REFERENCE_COUNTRIES", $company_code)) {
                        $ins_ref = ['order_id' => $ord_id, 'reference_id' => 'STS'];
                        $checkSTSRef = $this->common->gettblrowdata($ins_ref, "id", "tb_order_references", 0, 0);
                        if (count($checkSTSRef) == 0) {
                            $ins_ref['ref_value'] = "Pending";
                            $this->common->insertTableData("tb_order_references", $ins_ref);
                        }
                    }
                    $dangerousGoods = ($shipdata['dangerousflag'] != "") ? $shipdata['dangerousflag'] : "BLANK";
                    $salogReferences[] = [
                        "order_id" => $ord_id,
                        "reference_id" => 'DG',
                        "ref_value" => $dangerousGoods
                    ];
                    if (!empty($shipdata['references'])) {
                        foreach ($shipdata['references'] as $sref) {
                            $salogReferences[] = [
                                "order_id" => $ord_id,
                                "reference_id" => $sref['code'],
                                "ref_value" => $sref['value']
                            ];
                        }
                    }
                    if (!empty($shipdata['pfreferences'])) {
                        foreach ($shipdata['pfreferences'] as $pfref) {
                            $salogReferences[] = [
                                "order_id" => $ord_id,
                                "reference_id" => $pfref['code'],
                                "ref_value" => $pfref['value']
                            ];
                        }
                    }
                    if (!empty($shipdata['cnreferences'])) {
                        foreach ($shipdata['cnreferences'] as $cnref) {
                            $salogReferences[] = [
                                "order_id" => $ord_id,
                                "reference_id" => $cnref['code'],
                                "ref_value" => $cnref['value']
                            ];
                        }
                    }
                    if (!empty($shipdata['cureferences'])) {
                        foreach ($shipdata['cureferences'] as $curef) {
                            $salogReferences[] = [
                                "order_id" => $ord_id,
                                "reference_id" => $curef['code'],
                                "ref_value" => $curef['value']
                            ];
                        }
                    }
                    if (!empty($shipdata['shreferences'])) {
                        foreach ($shipdata['shreferences'] as $shref) {
                            $salogReferences[] = [
                                "order_id" => $ord_id,
                                "reference_id" => $shref['code'],
                                "ref_value" => $shref['value']
                            ];
                        }
                    }
                    if (!empty($shipdata['doreferences'])) {
                        foreach ($shipdata['doreferences'] as $doref) {
                            $salogReferences[] = [
                                "order_id" => $ord_id,
                                "reference_id" => $doref['code'],
                                "ref_value" => $doref['value']
                            ];
                        }
                    }
                    if (!empty($shipdata['ffreferences'])) {
                        foreach ($shipdata['ffreferences'] as $ffref) {
                            $salogReferences[] = [
                                "order_id" => $ord_id,
                                "reference_id" => $ffref['code'],
                                "ref_value" => $ffref['value']
                            ];
                        }
                    }
                    if (!empty($shipdata['careferences'])) {
                        foreach ($shipdata['careferences'] as $caref) {
                            $salogReferences[] = [
                                "order_id" => $ord_id,
                                "reference_id" => $caref['code'],
                                "ref_value" => $caref['value']
                            ];
                        }
                    }
                    if ($shipdata['invoice'] != "") {
                        $salogReferences[] = [
                            "order_id" => $ord_id,
                            "reference_id" => 'REM',
                            "ref_value" => $shipdata['invoice']
                        ];
                    }
                    $salogReferences[] = [
                        "order_id" => $ord_id,
                        "reference_id" => 'SD',
                        "ref_value" => $shipdata['sendertransmode']
                    ];
                    $salogReferences[] = [
                        "order_id" => $ord_id,
                        "reference_id" => 'CMP',
                        "ref_value" => $companycode
                    ];
                    $salogReferences[] = [
                        "order_id" => $ord_id,
                        "reference_id" => 'BRN',
                        "ref_value" => $shipdata['senderbranchcode']
                    ];
                    if ($shipdata['salog_user_email_id'] != '') {
                        $salogReferences[] = [
                            "order_id" => $ord_id,
                            "reference_id" => 'SAC',
                            "ref_value" => $shipdata['salog_user_email_id']
                        ];
                    }
                    if ($shipdata['additionalInformation'] != '') {
                        $salogReferences[] = [
                            "order_id" => $ord_id,
                            "reference_id" => 'SAD',
                            "ref_value" => $shipdata['additionalInformation']
                        ];
                    }
                    if ($shipdata['awbNumber'] != '') {
                        $salogReferences[] = [
                            "order_id" => $ord_id,
                            "reference_id" => 'AWB',
                            "ref_value" => $shipdata['awbNumber']
                        ];
                    }
                    if ($shipdata['masAwdNumber'] != '') {
                        $salogReferences[] = [
                            "order_id" => $ord_id,
                            "reference_id" => 'MAWB',
                            "ref_value" => $shipdata['masAwdNumber']
                        ];
                    }
                    if ($pickup_street2 != '') {
                        $salogReferences[] = [
                            "order_id" => $ord_id,
                            "reference_id" => 'SLA',
                            "ref_value" => $pickup_street2
                        ];
                    }
                    if ($drop_street2 != '') {
                        $salogReferences[] = [
                            "order_id" => $ord_id,
                            "reference_id" => 'DLA',
                            "ref_value" => $drop_street2
                        ];
                    }
                    if (!empty($contactReferences)) {
                        foreach ($contactReferences as $eachContactReference) {
                            $salogReferences[] = [
                                "order_id" => $ord_id,
                                "reference_id" => $eachContactReference['reference_id'],
                                "ref_value" => $eachContactReference['ref_value']
                            ];
                        }
                    }
                    $userTimeZone = $this->Roadlogtosalogmodel->getCountryTimeZoneByUserId($user_id);
                    $latestInboundData = [
                        'order_row_id' => $ord_id,
                        'estimated_early_pickup' => getdatetimebytimezone($userTimeZone, $pickup_datetime, DFLT_TZ)['datetime'],
                        'estimated_early_delivery' => getdatetimebytimezone($userTimeZone, $delivery_datetime, DFLT_TZ)['datetime'],
                        'total_actual_weight' => $shipdata['gross_weight']. " ". $shipdata['weight_uom'],
                        'total_weight' => $shipdata['charge_weight'] . " ". $shipdata['charge_uom'],
                        'total_actual_volume' => $shipdata['volume']. " ". $shipdata['volume_uom'],
                        'total_packages' => $shipdata['pkgs_count'],
                        'sla_reference' => $pickup_street2,
                        'dla_reference' => $drop_street2,
                        'sac_reference' => $shipdata['salog_user_email_id'],
                        'rem_reference' => $shipdata['invoice'],
                        'awb_reference' => $shipdata['awbNumber'],
                        'mawb_reference' => $shipdata['masAwdNumber']
                    ];
                    if ($functionCode == 'UP') {
                        $existingInboundData = $this->common->gettblrowdata(["order_row_id" => $ord_id], "*", "salog_inbound_history", 0, 0);
                        $emailBody = $this->compareAndGenerateEmailBody($latestInboundData, $existingInboundData);
                    }
                    $this->common->insertTableData('salog_inbound_history', $latestInboundData);
                    $this->addOrderReferences($salogReferences, $ord_id, $company_code);
                     if (in_array($functionCode,['UP','CR'])) {
                        try {
                            fetchSALOGDocuments($ord_id);
                            if ($functionCode == 'UP' && checkAccessConditions('DOWNLOAD_DOCS_FOR_UPDATED_SALOG_ORDERS', $company_code)) {
                               $isOrderIdExists = $this->common->gettblrowdata(["order_row_id" => $ord_id], "id", "salog_updated_orders", 0, 0);
                               if (!($isOrderIdExists)){
                                   $this->common->insertTableData('salog_updated_orders', ['order_row_id'=> $ord_id]);
                               }
                            }
                        } catch (Exception $ex) {
                            log_message("error", "Unable to download SALOG documents due to " . $ex->getMessage()." at ".gmdate('d-m-Y H:i'));
                        }
                    }
                    try {
                        $this->sendStatusMail([
                            'function_code' => $functionCode,
                            'booking_id' => $booking_id,
                            'xsr_value' => $xsrvalue,
                            'dq_number' => $dqnum,
                            'customer_id' => $customer_id,
                            'salog_user_email_id' => $shipdata['salog_user_email_id'],
                            'transport_mode' => $shipdata['sendertransmode'],
                            'company_code' => $company_code,
                            'branch_code' => $branch_code,
                            'sdt_value' => $ttansmode,
                            'email_body' => $emailBody ?? ''
                        ]);
                    } catch (Exception $ex) {
                        log_message("error", "Salog status mail failed " . $ex->getMessage());
                    }
                }
                if ($sship_id > 0) {
                    if (!empty($allOrderParties)) {
                        foreach ($allOrderParties as $aop) {
                            $this->updateOrderParty(
                                $ord_id,
                                $shipdata['orderid'],
                                $aop['party_id'],
                                $aop['party_type']
                            );
                        }
                    }
                }
            }
        }
        try {
            $this->altovaordercreation->sendOrderToAltova($ord_id);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While Sending Order to Altova " . $ex->getMessage());
        }
        try {
            $this->shipmentTriggerToCarrier($ord_id, $functionCode);
        } catch (Exception $ex) {
            log_message("error", "Salog Shipment Information Failed to sent Carrier " . $ex->getMessage());
        }

        if ( $isNewOrder === 1 ) {
            $countryInfo = $this->common->gettblrowdata(["country_code" => $pickup_countrycode],"country_name","tbl_country_master",0,0);
            $pickupCountry = $countryInfo ? $countryInfo['country_name'] : $pickup_countrycode;
            $countryInfo = $this->common->gettblrowdata(["country_code" => $drop_countrycode],"country_name","tbl_country_master",0,0);
            $dropCountry = $countryInfo ? $countryInfo['country_name'] : $drop_countrycode;
            $routingData = [
                'customerRowId' => $customer_id,
                'orderId' => $ord_id,
                'bookingId' => $booking_id,
                'pikupCountry' => $pickupCountry,
                'pikupCity' => $pickup_city,
                'pikupStreet' => $pickup_address,
                'pikupPincode' => $pickup_postal,
                'pikupState' => $pickup_address1,
                'dropCountry' => $dropCountry,
                'dropCity' => $drop_city,
                'dropPincode' => $drop_postal,
                'dropState' => $drop_address1,
                'dropStreet' => $drop_address,
                'orderInfo' => $orddata,
                'cargoData' => $cargodata,
            ];
            if(checkAccessConditions('RELATED_2_BRN_REF_FOR_ROUTING', $company_code)){
                $routingData['brnReference'] = $shipdata['senderbranchcode'] ?? "";
            }
            $this->triggerAutoRouting($routingData);
        }
        if ($functionCode == 'CR') {
            $getShiftId = $this->common->gettblrowdata(["id" => $ord_id], "shift_id", "tb_orders", 0, 0);
            if (($getShiftId['shift_id'] ?? 0) > 0) {
                $this->notifytrigger->sendNotificationToCarrier($getShiftId['shift_id'], $company_code, 'CR');
            }
        }
        return $responseord;
    }

    private function triggerAutoRouting( array $data): void {
        $pickupInfo     = $dropInfo = [];
        $customerEmail  = $customerPhone = "";
        $customerRowId  = $data['customerRowId'];
        $orderId        = $data['orderId'];
        $bookingId      = $data['bookingId'];
        $pikupCountry   = $data['pikupCountry'];
        $pikupCity      = $data['pikupCity'];
        $pikupStreet    = $data['pikupStreet'];
        $pikupPincode   = $data['pikupPincode'];
        $pikupState     = $data['pikupState'];
        $dropCountry    = $data['dropCountry'];
        $dropCity       = $data['dropCity'];
        $dropPincode    = $data['dropPincode'];
        $dropState      = $data['dropState'];
        $dropStreet     = $data['dropStreet'];
        $orderInfo      = $data['orderInfo'];
        $shipmentName   = "BOXES";
        $cargoData      = $data['cargoData'];
        if ( !empty($orderId) && !empty($customerRowId) ) {
            $customerInfo = $this->common->gettblrowdata( ['id' => $customerRowId], "phone,email_id", 'tb_customers', 0, 0 );
            if ( $customerInfo ) {
                $customerEmail = $customerInfo['email_id'];
                $customerPhone = $customerInfo['phone'];
            }
            $totalWeight  = $totalVolume = $totalQuantity = 0;
            $getCargoDetails = $this->common->gettblrowdata( ['order_id' => $orderId], "SUM(weight) as total_weight,SUM(volume) as total_volume,SUM(quantity) as total_quantity", 'tb_order_cargodetails', 0, 0 );
            if ( $getCargoDetails ) {
                $totalVolume   = $getCargoDetails['total_volume'];
                $totalWeight   = $getCargoDetails['total_weight'];
                $totalQuantity = $getCargoDetails['total_quantity'];
            }
            $pickupInfo['country']       = trim( $pikupCountry );
            $pickupInfo['order_country'] = trim( $pikupCountry );
            $pickupInfo['order_city']    = trim( $pikupCity );
            $pickupInfo['order_zipcode'] = trim( $pikupPincode );
            $pickupInfo['state']         = trim( $pikupState );
            $pickupInfo['city']          = trim( $pikupCity );
            $pickupInfo['region']        = trim( $pikupStreet );
            $pickupInfo['zipcode']       = trim( $pikupPincode );
            $pickupInfo['stoptype']    = "P";
            $dropInfo['country']       = trim( $dropCountry );
            $dropInfo['order_country'] = trim( $dropCountry );
            $dropInfo['order_city']    = trim( $dropCity );
            $dropInfo['order_zipcode'] = trim( $dropPincode );
            $dropInfo['state']         = trim( $dropState );
            $dropInfo['city']          = trim( $dropCity );
            $dropInfo['region']        = trim( $dropStreet );
            $dropInfo['zipcode']       = trim( $dropPincode );
            $dropInfo['stoptype']      = "D";
            $pickupGeoCode             = checkgeocode( $pickupInfo );
            $dropGeoCode               = checkgeocode( $dropInfo );
            if ( ! empty( $pickupGeoCode ) && ! empty( $dropGeoCode ) ) {
                $pickupGeoCode['stoptype'] = "P";
                $dropGeoCode['stoptype'] = "D";
                $pickupGeoCode['order_country'] = trim($pikupCountry);
                $pickupGeoCode['order_city'] = trim($pikupCity);
                $pickupGeoCode['order_zipcode'] = trim($pikupPincode);
                $dropGeoCode['order_country'] = trim($dropCountry);
                $dropGeoCode['order_city'] = trim($dropCity);
                $dropGeoCode['order_zipcode'] = trim($dropPincode);
                $pickupGeoCode['cargo'] = $cargoData;
                $dropGeoCode['cargo'] = $cargoData;
                $pickupGeoCode['salogFlag'] = $dropGeoCode['salogFlag'] = 1;
                $pickupGeoCode['brnReference'] = $dropGeoCode['brnReference'] = $data['brnReference'] ?? "";
                $pickupRoute = getcust_routeautomate($customerRowId, $pickupGeoCode);
                $dropRoute = getcust_routeautomate($customerRowId, $dropGeoCode);
                if ( ! empty( $pickupRoute ) && ! empty( $dropRoute ) ) {
                    $orderInfo['id']             = $orderId;
                    $orderInfo['order_id']       = $bookingId;
                    $orderInfo['shipment_name']  = $shipmentName;
                    $orderInfo['customer_phone'] = $customerPhone;
                    $orderInfo['customer_email'] = $customerEmail;
                    $orderInfo['volume']         = $totalVolume;
                    $orderInfo['weight']         = $totalWeight;
                    $orderInfo['quantity']       = $totalQuantity;
                    $orderInfo['quantity']       = $totalQuantity;
                    $shipment                    = createshipmentbyorder( $pickupRoute, $orderInfo );
                } else {
                    $pickupInfo['cargo'] = $cargoData;
                    $dropInfo['cargo'] =  $cargoData;
                    $pickupInfo['salogFlag'] = $dropInfo['salogFlag'] = 1;
                    $pickupInfo['brnReference'] = $dropInfo['brnReference'] = $data['brnReference'] ?? "";
                    $pickupRoute1 = getcust_routeautomate( $customerRowId, $pickupInfo );
                    $dropRoute1   = getcust_routeautomate( $customerRowId, $dropInfo );
                    if ( ! empty( $pickupRoute1 ) && ! empty( $dropRoute1 ) ) {
                        $orderInfo['id']             = $orderId;
                        $orderInfo['order_id']       = $bookingId;
                        $orderInfo['shipment_name']  = $shipmentName;
                        $orderInfo['customer_phone'] = $customerPhone;
                        $orderInfo['customer_email'] = $customerEmail;
                        $orderInfo['volume']         = $totalVolume;
                        $orderInfo['weight']         = $totalWeight;
                        $orderInfo['quantity']       = $totalQuantity;
                        $shipment                    = createshipmentbyorder( $pickupRoute1, $orderInfo );
                    }
                }
            } else {
                $pickupInfo['cargo'] = $cargoData;
                $dropInfo['cargo'] =  $cargoData;
                $pickupInfo['salogFlag'] = $dropInfo['salogFlag'] = 1;
                $pickupInfo['brnReference'] = $dropInfo['brnReference'] = $data['brnReference'] ?? "";
                $pickupRoute1 = getcust_routeautomate( $customerRowId, $pickupInfo );
                $dropRoute1   = getcust_routeautomate( $customerRowId, $dropInfo );
                if ( ! empty( $pickupRoute1 ) && ! empty( $dropRoute1 ) ) {
                    $orderInfo['id']             = $orderId;
                    $orderInfo['order_id']       = $bookingId;
                    $orderInfo['shipment_name']  = $shipmentName;
                    $orderInfo['customer_phone'] = $customerPhone;
                    $orderInfo['customer_email'] = $customerEmail;
                    $orderInfo['volume']         = $totalVolume;
                    $orderInfo['weight']         = $totalWeight;
                    $orderInfo['quantity']       = $totalQuantity;
                    $shipment                    = createshipmentbyorder( $pickupRoute1, $orderInfo );
                }
            }
        }
    }

    public function checkSalogCustomersData(array $data): array
    {
        $companyCode = $data['company_code'];
        $branchCode = $data['branch_code'];
        $departmentCode = $data['department_code'];
        $senderTransportMode = $data['transport_mode'];
        $logicalSender = $data['logical_sender'];
        if ($companyCode == 'CNKN') {
            $branchCode = $data['sender_branch_code'];
        }
        $customerId = $partyMasterId = $partyType = 0;
        $customerCode = $customerCompanyCode = $customerBranchCode = "";
        if ($senderTransportMode == self::TRANSPORT_MODE_FOR_SEA) {
            $buType = 'BUFS';
        } elseif ($senderTransportMode == self::TRANSPORT_MODE_FOR_AIR) {
            $buType = 'BUFA';
        } else {
            $buType = '';
        }
        if($buType != ''){
            $checkWithBuType = $this->common->gettblrowdata(['company_code' => $companyCode, 'branch_code' => $branchCode, 'bu_type' => $buType, 'logical_sender' => NULL, 'status' => '1'], "customer_id", "salog_customers", 0, 0);
            if (!empty($checkWithBuType)) {
                $customerId = $checkWithBuType['customer_id'];
            }
        }
        if($logicalSender != ''){
            $checkWithLogicalSender = $this->common->gettblrowdata(['company_code' => $companyCode, 'branch_code' => 'ALL', 'logical_sender' => $logicalSender, 'status' => '1'], "customer_id", "salog_customers", 0, 0);
            if (!empty($checkWithLogicalSender)) {
                $customerId = $checkWithLogicalSender['customer_id'];
            }
        }
        if ($customerId == 0) {
            $checkWithDepartmentCode = $this->common->gettblrowdata(['company_code' => $companyCode, 'branch_code' => $branchCode, 'department_code' => $departmentCode, 'bu_type' => NULL, 'logical_sender' => NULL, 'status' => '1'], "customer_id", "salog_customers", 0, 0);
            if (!empty($checkWithDepartmentCode)) {
                $customerId = $checkWithDepartmentCode['customer_id'];
            } else {
                $checkWithAllDepartmentCode = $this->common->gettblrowdata(['company_code' => $companyCode, 'branch_code' => $branchCode, 'department_code' => 'ALL', 'bu_type' => NULL, 'logical_sender' => NULL,  'status' => '1'], "customer_id", "salog_customers", 0, 0);
                if (!empty($checkWithAllDepartmentCode)) {
                    $customerId = $checkWithAllDepartmentCode['customer_id'];
                } else {
                    $checkWithAllBranchCode = $this->common->gettblrowdata(['company_code' => $companyCode, 'branch_code' => 'ALL', 'bu_type' => NULL, 'logical_sender' => NULL, 'status' => '1'], "customer_id", "salog_customers", 0, 0);
                    if (!empty($checkWithAllBranchCode)) {
                        $customerId = $checkWithAllBranchCode['customer_id'];
                    }
                }
            }
        }
        if ($customerId > 0) {
            $getCustomerCode = $this->common->gettblrowdata(['id' => $customerId, 'status' => '1'], "code,company_code,branch_code", "tb_customers", 0, 0);
            if (!empty($getCustomerCode)) {
                $customerCode = $getCustomerCode['code'];
                $customerCompanyCode = $getCustomerCode['company_code'];
                $customerBranchCode = $getCustomerCode['branch_code'];
            }
            if (empty($customerBranchCode)) {
                $customerBranchCode = $branchCode;
            }
            if (empty($customerCompanyCode)) {
                $customerCompanyCode = $companyCode;
            }
            if (!empty($customerCode)) {
                $getPartyMasterId = $this->common->gettblrowdata(['code' => $customerCode, 'company_code' => $customerCompanyCode, 'branch_code' => $customerBranchCode,'status'=>'1'], "id", "tbl_party_master", 0, 0);
                if (!empty($getPartyMasterId)) {
                    $partyMasterId = $getPartyMasterId['id'];
                }
            }
            $getPartyTypeWithBranchCode = $this->common->gettblrowdata(['name' => 'Customer', 'company_code' => $companyCode, 'branch_code' => $branchCode, 'status' => '1'], 'id', 'tbl_party_types', 0, 0);
            if (!empty($getPartyTypeWithBranchCode)) {
                $partyType = $getPartyTypeWithBranchCode['id'];
            } else {
                $getPartyTypeWithCompanyCode = $this->common->gettblrowdata(['name' => 'Customer', 'company_code' => $companyCode, 'status' => '1'], 'id', 'tbl_party_types', 0, 0);
                if (!empty($getPartyTypeWithCompanyCode)) {
                    $partyType = $getPartyTypeWithCompanyCode['id'];
                }
            }
        }
        return ['customerId' => $customerId, 'partyMasterId' => $partyMasterId, 'partyTypeId' => $partyType];
    }

    public function addOrderReferences(array $references, int $orderRowId, string $companyCode): void
    {
        $currentDate = date("Y-m-d H:i:s");
        $this->common->updatetbledata('tb_order_references', ['status' => 0], ['order_id' => $orderRowId, 'ref_belongs_to' => 'SALOG']);
        foreach ($references as $ordRef) {
            $ordRef['ref_belongs_to'] = 'SALOG';
            $chkrefs = $this->common->gettblrowdata($ordRef, "id", "tb_order_references", 0, 0);
            if ((($chkrefs['id'] ?? 0) > 0)) {
                $ordRef['status'] = 1;
                $this->common->updatetbledata('tb_order_references', $ordRef, ["id" => $chkrefs['id']]);
            }
            if (empty($chkrefs)) {
                $ordRefData = $ordRef;
                $ordRefData['ref_belongs_to'] = 'SALOG';
                $ordRefData['status'] = 1;
                $ordRefData['createdon'] = $currentDate;
                $this->common->insertTableData('tb_order_references', $ordRefData);
            }
        }
        if (checkAccessConditions('CHECK_CUSTOM_BROKERAGE_EXITS', $companyCode)) {
            $this->checkAndEnableCustomBrokerage($orderRowId, $companyCode);
        }
    }

    private function checkAndEnableCustomBrokerage(int $orderRowId, string $companyCode): void
    {
        $getCustomBrokerageRef = $this->common->gettblrowdata(['title' => 'CUSTOM_BROKERAGE_REF_ID'], "condition", "access_conditions", 0, 0);
        $customBrokerageRef = $getCustomBrokerageRef['condition'] ?? "ZSU";
        $checkOrderReference = $this->common->gettblrowdata(['order_id' => $orderRowId, 'reference_id' => $customBrokerageRef, 'status' => '1'], "id,ref_value,status", "tb_order_references", 0, 0);
        if (empty($checkOrderReference)) {
            return;
        }
        $customBrokerageRefRowId = $checkOrderReference['id'];
        $customBrokerageRefValue = $checkOrderReference['ref_value'];
        $customBrokerageRefStatus = $checkOrderReference['status'];
        if (checkAccessConditions('CHECK_CUSTOM_BROKERAGE_CIDS', $customBrokerageRefValue)) {
            $getPartyId = $this->common->gettblrowdata(['code' => $customBrokerageRefValue, 'company_code' => $companyCode, 'status' => '1'], "id", "tbl_party_master", 0, 0);
            if (empty($getPartyId)) {
                $checkSalogCustomBrokerage = $this->common->gettblrowdata(['salog_code' => $customBrokerageRefValue, 'company_code' => $companyCode, 'status' => '1'], "tms_code", "salog_custom_brokerages", 0, 0);
                if (empty($checkSalogCustomBrokerage)) {
                    return;
                }
                $getPartyId = $this->common->gettblrowdata(['code' => $checkSalogCustomBrokerage['tms_code'], 'company_code' => $companyCode, 'status' => '1'], "id", "tbl_party_master", 0, 0);
                if (empty($getPartyId)) {
                    return;
                }
                $this->common->updatetbledata('tb_order_references', ['ref_value' => $checkSalogCustomBrokerage['tms_code']], ['id' => $customBrokerageRefRowId]);
            }
            $partyId = $getPartyId['id'];
            $getPartyTypeId = $this->common->gettblrowdata(['name' => 'Customs Brokerage', 'company_code' => $companyCode, 'status' => '1'], "id", "tbl_party_types", 0, 0);
            $partyTypeId = $getPartyTypeId['id'] ?? 0;
            $checkOrderParty = $this->common->gettblrowdata(["order_id" => $orderRowId, "party_type" => $partyTypeId], "id", "tb_order_parties", 0, 0);
            $orderTypeData = ['order_id' => $orderRowId, 'party_id' => $partyId, 'party_type' => $partyTypeId, 'status' => '1'];
            if ($customBrokerageRefStatus > 0) {
                $orderTypeData['status'] = '1';
                if (empty($checkOrderParty)) {
                    $orderTypeData['createdon'] = date("Y-m-d H:i:s");
                    $this->common->insertTableData("tb_order_parties", $orderTypeData);
                } else {
                    $this->common->updatetbledata('tb_order_parties', $orderTypeData, ["id" => $checkOrderParty['id']]);
                }
            } else {
                if (!empty($checkOrderParty)) {
                    $orderTypeData['status'] = 0;
                    $this->common->updatetbledata('tb_order_parties', $orderTypeData, ["id" => $checkOrderParty['id']]);
                }
            }
        }
    }

    private function getOrderType($companycode,$branchcode)
    {
        $ordTypeId = 63;
        $orderTypeData = [
            "type_name" => "Standard",
            "company_code" => $companycode,
            "branch_code" => $branchcode
        ];
        $getordertype = $this->common->gettblrowdata($orderTypeData,"id","tb_order_types",0,0);
        if (!empty($getordertype)) {
            $ordTypeId = $getordertype['id'];
        }else{
            $orderTypeData["description"] = "Standard";
            $orderTypeData["ordtype_code"] = "S";
            $orderTypeData["status"] = 1;
            $orderTypeData["createdon"] = date("Y-m-d H:i:s");
            $ordTypeId = $this->common->insertTableData("tb_order_types", $orderTypeData);
        }
        return $ordTypeId;
    }

    private function checkAndUpdateDepartment($departmentcode,$companycode,$branchcode)
    {
        $departmentData = [
            "department_code" => $departmentcode,
            "company_code" => $companycode,
            "branch_code" => $branchcode
        ];
        $getDepartment = $this->common->gettblrowdata($departmentData,"id","tb_department_master",0,0);
        if (empty($getDepartment)) {
            $departmentData["department_name"] = $departmentcode;
            $departmentData["status"] = 1;
            $departmentData["createdon"] = date("Y-m-d H:i:s");
            $this->common->insertTableData("tb_department_master", $departmentData);
        }
    }

    public function getlatlongbylocname($address)
    {
        $response = getlatlngsbyplace($address);
        return [
            'latitude' => $response[0],
            'longitude' => $response[1]
        ];
    }

    public function checkOrderParty($customer, $cmpcode, $branchcode, $uid, $custtype, $customerType = null)
    {
        $vendorRowId = $customerRowId = 0;
        $partyData = [
            "code" => $customer['custid'],
            "company_code" => $cmpcode
        ];
        $cselect = 'id';
        $curdt = date("Y-m-d H:i:s");
        $partyTypeData = [];
        $partyTypeData['party_type_id'] = 4;
        if ($custtype == self::PICKUP_PARTY) {
            $partyTypeData['party_type_id'] = 8;
        } else {
            if ($custtype == self::NOTIFY_PARTY) {
                $partyTypeData['party_type_id'] = 6;
            } else {
                if ($custtype == self::FREIGHT_PAYER) {
                    $partyTypeData['party_type_id'] = 7;
                } else {
                    if ($custtype == self::SHIPPER_PARTY) {
                        $partyTypeData['party_type_id'] = 1;
                    } else {
                        if ($custtype == self::CONSIGNEE_PARTY) {
                            $partyTypeData['party_type_id'] = 3;
                        } else {
                            if ($custtype == self::CUSTOMER_PARTY) {
                                $partyTypeData['party_type_id'] = 5;
                            } else {
                                if ($custtype == self::CARRIER_PARTY) {
                                    $partyTypeData['party_type_id'] = 2;
                                }
                            }
                        }
                    }
                }
            }
        }
        $partyTypeCheck = ["name" => $custtype, 'company_code' => $cmpcode, 'branch_code' => $branchcode];
        $chkpartytype = $this->common->gettblrowdata($partyTypeCheck, "id", "tbl_party_types", 0, 0);
        if (!empty($chkpartytype)) {
            $partyTypeData['party_type_id'] = $chkpartytype['id'];
        }
        if ($cmpcode == "IDKN" && ($customer['custid'] == '1000613651') && (in_array($custtype,[self::SHIPPER_PARTY,self::CONSIGNEE_PARTY]) )) {
            $partyData['code'] = '1002895786';
            $getPartyID = $this->common->gettblrowdata($partyData, 'id', "tbl_party_master", 0, 0);
            if (!empty($getPartyID)) {
                $partyid = $getPartyID['id'];
            }
            $res['id'] = 0;
            $res['party_id'] = $partyid ?? 0;
            $res['party_type'] = $partyTypeData['party_type_id'];
            $res['contact_reference'] = [];
            return $res;
        }
        $cust_id = 0;
        if (($custtype == self::FREIGHT_PAYER && $customerType == "PF")
            || ($custtype == self::DELIVERY_PARTY && $customerType == "CN")
            || ($custtype == self::PICKUP_PARTY && $customerType == "SH")
            || ($custtype == self::CUSTOMER_PARTY)) {
            $ctable = 'tb_customers';
            $chkcust = $this->common->gettblrowdata($partyData, $cselect, $ctable, 0, 0);
            if (count($chkcust) > 0) {
                $customerRowId = $cust_id = $chkcust['id'];
                $upddata = [
                    'location' => $customer['city'],
                    'address' => $customer['street'],
                    'pincode' => $customer['zip'],
                    'country' => $customer['country'],
                    'user_id' => $uid,
                    'company_code' => $cmpcode,
                    'branch_code' => $branchcode,
                    'status' => 1,
                    'updatedon' => $curdt
                ];
                $upd = $this->common->updatetbledata('tb_customers', $upddata, ["id" => $cust_id]);
            } else {
                $randnum = $customer['custid'];
                $pwd = password_hash($randnum, PASSWORD_DEFAULT);
                $cinsdata = [
                    'name' => $customer['name'],
                    'phone' => $customer['custid'],
                    'location' => $customer['city'],
                    'address' => $customer['street'],
                    'pincode' => $customer['zip'],
                    'code' => $customer['custid'],
                    'country' => $customer['country'],
                    'state' => $customer['state'],
                    'password' => $pwd,
                    'user_id' => $uid,
                    'company_code' => $cmpcode,
                    'branch_code' => $branchcode,
                    'status' => 1,
                    'createdon' => $curdt,
                    'updatedon' => $curdt
                ];
                $customerRowId = $cust_id = $this->common->insertTableData('tb_customers', $cinsdata);
            }
        }
        $addr = $customer['street'];
        if ($customer['city'] != "") {
            $addr .= ", " . $customer['city'];
        }
        if ($customer['state'] != "") {
            $addr .= ", " . $customer['state'];
        } else {
            $customer['state'] = $customer['city'];
        }
        if ($customer['statecode'] != "") {
            $addr .= ", " . $customer['statecode'];
        }
        if ($customer['country'] != "") {
            $addr .= ", " . $customer['country'];
        }
        if ($customer['zip'] != "") {
            $addr .= ", " . $customer['zip'];
        }
        if ($custtype == "Carrier") {
            $ctable = 'tb_vendors';

            $chkcust = $this->common->gettblrowdata($partyData, $cselect, $ctable, 0, 0);
            if (count($chkcust) > 0) {
                $vendorRowId = $cust_id = $chkcust['id'];
                $upddata = [
                    'location' => $customer['city'],
                    'address' => $addr,
                    'pincode' => $customer['zip'],
                    'country' => $customer['country'],
                    'effective_date' => $curdt,
                    'expiry_date' => $curdt,
                    'service_id' => $customer['custid'],
                    'service_name' => $customer['partyid'],
                    'user_id' => $uid,
                    'company_code' => $cmpcode,
                    'branch_code' => $branchcode,
                    'status' => 1,
                    'updated_on' => $curdt
                ];
                $upd = $this->common->updatetbledata($ctable, $upddata, ["id" => $cust_id]);
            } else {
                $randnum = $customer['custid'];
                $pwd = password_hash($randnum, PASSWORD_DEFAULT);
                $cinsdata = array(
                    'name' => $customer['name'],
                    'mobile' => $customer['custid'],
                    'location' => $customer['city'],
                    'address' => $addr,
                    'pincode' => $customer['zip'],
                    'country' => $customer['country'],
                    'password' => $pwd,
                    'email' => '',
                    'code' => $customer['custid'],
                    'offering_type' => 'FTL',
                    'carrier_grade' => 'ABC',
                    'effective_date' => date('Y-m-d'),
                    'expiry_date' => date('Y-m-d'),
                    'service_id' => $customer['custid'],
                    'service_name' => $customer['partyid'],
                    'user_id' => $uid,
                    'company_code' => $cmpcode,
                    'branch_code' => $branchcode,
                    'status' => 1,
                    'created_on' => $curdt,
                    'updated_on' => $curdt
                );
                $vendorRowId = $cust_id = $this->common->insertTableData('tb_vendors', $cinsdata);
            }
        }
        $chkcust = $this->common->gettblrowdata(['code' => $customer['custid'], 'company_code' => $cmpcode, 'status' => '1'], 'id,party_type_id,party_types', "tbl_party_master", 0, 0);
        if (!empty($chkcust)) {
            $partyid = $chkcust['id'];
            $upddata = [
                'name' => $customer['name'],
                'location_id' => $customer['city'],
                'address' => $addr,
                'pincode' => $customer['zip'],
                'country' => $customer['country'],
                'state' => $customer['state'],
                'user_id' => $uid,
                'customeridentifier' => $customer['custid'],
                'partyindetifier' => $customer['partyid'],
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'street' => $customer['street'],
                'street_2' => $customer['street2'],
                'status' => 1,
                'updated_on' => $curdt
            ];
            $upd = $this->common->updatetbledata('tbl_party_master', $upddata, ["id" => $partyid]);
            $partyTypes = $chkcust['party_types'];
            $dbPartytype = $chkcust['party_type_id'];
            $this->updateUserPartyTypes(['dbPartytype' => $dbPartytype, 'currentPartyType' => $partyTypeData['party_type_id'], 'partyTypes' => $partyTypes, 'partyId' => $partyid]);
        } else {
            $cinsdata = [
                'party_type_id' => $partyTypeData['party_type_id'],
                'name' => $customer['name'],
                'email' => 'svkonekt@kuehne-nagel.com',
                'mobile' => $customer['custid'],
                'location_id' => $customer['city'],
                'address' => $addr,
                'pincode' => $customer['zip'],
                'code' => $customer['custid'],
                'country' => $customer['country'],
                'state' => $customer['state'],
                'user_id' => $uid,
                'customeridentifier' => $customer['custid'],
                'partyindetifier' => $customer['partyid'],
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'street' => $customer['street'],
                'street_2' => $customer['street2'],
                'status' => 1,
                'created_on' => $curdt,
                'updated_on' => $curdt
            ];
            $partyid = $this->common->insertTableData('tbl_party_master', $cinsdata);
        }
        if(!empty($customer['contact'])){
            $this->Roadlogtosalogmodel->insertOrUpdateContact([
                'partner_id' => $partyid,
                'name' => $customer['contact']['name'],
                'phone' => $customer['contact']['phone'],
                'email' => $customer['contact']['email'],
                'user_id' => $uid,
            ]);
            $contactReference = [
                "reference_id" => $this->getContactReferenceId($custtype),
                "ref_value" => $customer['contact']['name'] . "," . $customer['contact']['phone'] . "," . $customer['contact']['email']
            ];
        }
        if ($customerRowId > 0) {
            $this->common->updatetbledata('tb_customers', ['partner_id' => $partyid], ["id" => $customerRowId]);
        }
        if ($vendorRowId > 0) {
            $this->common->updatetbledata('tb_vendors', ['partyid' => $partyid], ["id" => $vendorRowId]);
        }
        $res['id'] = $cust_id;
        $res['party_id'] = $partyid;
        $res['party_type'] = $partyTypeData['party_type_id'];
        $res['contact_reference'] = $contactReference ?? [];
        return $res;
    }

    public function updateOrderParty($ordid, $ordernumber, $partyId, $partyType)
    {
        $curdt = date("Y-m-d H:i:s");
        $checkparty = $this->db->select("id")->get_where(
            "tb_order_parties",
            [
                'order_id' => $ordid,
                'party_id' => $partyId,
                'party_type' => $partyType
            ],
            1,
            0
        );
        if ($checkparty->num_rows() > 0) {
            $partyarr = [
                'order_number' => $ordernumber,
                'party_id' => $partyId,
                'party_type' => $partyType,
                'status' => 1
            ];
            $orderPartyId = $checkparty->row()->id;
            $upd = $this->db->where(array("id" => $orderPartyId))->update('tb_order_parties', $partyarr);
        } else {
            $partyarr = [
                'order_id' => $ordid,
                'order_number' => $ordernumber,
                'party_id' => $partyId,
                'party_type' => $partyType,
                'status' => 1,
                'createdon' => $curdt
            ];
            $ins = $this->common->insertTableData("tb_order_parties", $partyarr);
        }
    }

    /*generating QR codes and storing as foreigh key with tb_order_cargo_details table id column
    with tb_order_cargo_qrdetails table order_cargo_details_id */
    public function generateQRCodes($cargo_id, $cargodata)
    {
        $this->load->library('barcode');
        $qrid = array();
        $handling_unit = $cargodata["handling_unit"];
        $quantity = $cargodata["quantity"];
        $data = [];
        $data["order_cargo_details_id"] = $cargo_id;
        $data["handling_unit"] = $handling_unit;
        $data["quantity"] = $quantity;
        $data["path"] = $qrid['qr_path'] = $this->barcode->generate(
            json_encode(array("cargo_id" => $handling_unit, "quantity" => $quantity))
        );
        $qrid['id'] = $this->common->insertTableData("tb_order_cargo_qrdetails", $data);
        return $qrid;
    }

    public function barcode()
    {
        $data["path"] = "";
        $post = array();
        $post = $this->input->post(null, true);
        $this->load->library('barcode');
        if (!empty($post["qr_text"])) {
            $data["path"] = $this->barcode->generate($post["qr_text"]);
        }
        $this->load->view("barcode", $data);
    }

    public function sendQRmail($cust)
    {
        $chkcust = $this->db->select("name,email_id")->get_where(
            "tb_customers",
            array("id" => $cust['cust_id'], "email_id <>" => ""),
            1,
            0
        );
        if ($chkcust->num_rows() > 0) {
            $this->load->library('email');
            $receivecc = "external.ram.k@kuehne-nagel.com";
            $receivemail = $chkcust->row()->email_id;
            $receivename = $chkcust->row()->name;
            if ($receivemail == "seeta.krishnan@kuehne-nagel.com") {
            } else {
                $this->email->to($receivemail, $receivename);
                if ($receivecc != "") {
                    $this->email->cc($receivecc, "RCREDDY");
                }
                $data['page_title'] = "QR CODE";
                $data['receivename'] = $receivename;
                $data['weight'] = $cust['weight'];
                $data['volume'] = $cust['volume'];
                $data['quantity'] = $cust['quantity'];
                $data['quantity_type'] = $cust['quantity_type'];
                $data['cargo_content'] = $cust['cargo_content'];
                $data['order_id'] = $cust['order_id'];
                $data['qr_path'] = $cust['qr_path'];
                $data['subject'] = "svkonekt :: QR Code for your order cargo";
                $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                $this->email->subject($data['subject']);
                $this->email->set_mailtype('html');
                $body = $this->load->view('mail_forms/orderqrinfo', $data, true);
                $this->email->message($body);
                $send = $this->email->send();
                $this->sendnotify('booking_create', $data['order_id']);
            }
        }
    }

    public function sendnotify($action, $orderid)
    {
        if (!empty($orderid)) {
            $info['page_title'] = 'Booking Notification';
            $info['orderid'] = $bookingId = $orderid;
            $orderinfo = $this->common->gettblrowdata(
                array('order_id' => $orderid, 'status' => 1),
                'id',
                'tb_orders',
                0,
                0
            );
            if (count($orderinfo)) {
                $orderDetails = $this->DeliveryDocumentModel->getOrderCustomerName(0, $bookingId);
                $info['subject'] = "Booking ID:" . $bookingId . " Customer Name: " . $orderDetails[$bookingId]['customerName'] . " Delivery Docs: " . $orderDetails[$bookingId]['reference'];
                $info['order_id'] = $orderinfo['id'];
                $info['action'] = $action;
                $info['cargos'] = $this->common->gettbldata(
                    array('order_id' => $info['order_id']),
                    'quantity_type,quantity',
                    'tb_order_cargodetails',
                    0,
                    0
                );
                $info['body'] = $this->load->view('mail_forms/notifytrigger/' . $action, $info, true);
                $this->notifytrigger->sendordernotify($info);
            }/* else {
                log_message('error','no order info');
            }*/
        }
    }

    public function salogretrigger($shiftid = null)
    {
        /*2300 -> Delivery Shipment Dispatched, 2400 -> Planned Delivery Date, 3000 -> Delivered to Consignee, 3060 -> POD Available */
        $this->load->library("statusintigration");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $hrs = $this->session->userdata("usr_tzone")['hrs'];
        if ($shiftid != null) {
            $stopsts = $this->db->query("select * from tb_stop_status where shipment_id='" . $shiftid . "'");
            if ($stopsts->num_rows() != 0) {
                foreach ($stopsts->result() as $st) {
                    $ord_id = $st->order_id;
                    $chkcs = $this->db->select("order_id")->get_where("tb_orders", ["id" => $ord_id], 1, 0);
                    if ($chkcs->num_rows() > 0) {
                        $order_id = $chkcs->row()->order_id;
                    }

                    if (($st->status_code == "2300") || ($st->status_code == "3000") || ($st->status_code == "0500")) {
                        $postdata = [
                            "shipment_id" => $st->shipment_id,
                            "trip_id" => $st->trip_id,
                            "driver_id" => $st->driver_id,
                            "stop_id" => $st->stop_id,
                            "order_id" => $order_id,
                            "inc_id" => 0,
                            "pod_type" => '',
                            "latitude" => $st->latitude,
                            "longitude" => $st->longitude,
                            "stop_type" => $st->stop_type,
                            "vehicle_id" => $st->vehicle_id,
                            "curtz" => $curtz,
                            "hrs" => $hrs,
                            "web" => $st->createdon,
                            "status_code" => $st->status_code,
                            "ord_id" => $st->order_id,
                        ];
                        /*                      echo "<pre>";
                        print_r($postdata); */

                        $sts = $this->statusintigration->salogshipmentstatus($postdata);
                    }
                }
            }
        }
    }

    private function getOrderPickOrDeliveryDate($ordDate,$ordTime,$userId,$countryCode=null,$sourceType=null)
    {
        $orderDateTime = date("Y-m-d H:i:s");
        $dateResponse = [
            "localtime" => $orderDateTime,
            "datetime" => $orderDateTime
        ];
        $orderCountryTimeZone = "Asia/Singapore";
        if($countryCode != ""){
            $getCountryTimeZone = $this->common->gettblrowdata(["country_code"=>$countryCode,"status"=>1],"cntry_timezone","tbl_country_master",0,0);
            if(!empty($getCountryTimeZone)){
                $orderCountryTimeZone = $getCountryTimeZone['cntry_timezone'];
            }else{
                $getCountryTimeZone = $this->db->query("SELECT c.cntry_timezone FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=$userId AND c.status=1 LIMIT 1");
                if($getCountryTimeZone->num_rows()>0){
                    $orderCountryTimeZone = $getCountryTimeZone->row()->cntry_timezone;
                }
            }
        }else{
            $getCountryTimeZone = $this->db->query("SELECT c.cntry_timezone FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=$userId AND c.status=1 LIMIT 1");
            if($getCountryTimeZone->num_rows()>0){
                $orderCountryTimeZone = $getCountryTimeZone->row()->cntry_timezone;
            }
        }
        if($ordDate != ""){
            $ordDate = date("Y-m-d",strtotime($ordDate));
            if($ordTime != ""){
                $ordTime = date("H:i:s",strtotime($ordTime));
                $orderDateTime = $ordDate." ".$ordTime;
                $orderDateTime = date("Y-m-d H:i:s",strtotime($orderDateTime));
            }else{
                $ordTime = date("H:i:s",strtotime($orderDateTime));
                $orderDateTime = $ordDate." ".$ordTime;
                if($sourceType == "EndTime") {
                    $orderDateTime = date('Y-m-d H:i:s', strtotime('+3 hours', strtotime($orderDateTime)));
                }
            }
            $dateResponse['localtime'] = $orderDateTime;
            $convertGlobalTime = getdatetimebytimezone(DFLT_TZ,$orderDateTime,$orderCountryTimeZone);
            $dateResponse['datetime'] = $convertGlobalTime['datetime'];
        }else{
            $dateResponse['datetime'] = $orderDateTime;
            $convertLocalTime = getdatetimebytimezone($orderCountryTimeZone,$orderDateTime,DFLT_TZ);
            $dateResponse['localtime'] = $convertLocalTime['datetime'];
            if($sourceType == "EndTime") {
                $dateResponse['datetime'] = date('Y-m-d H:i:s', strtotime('+3 hours', strtotime($orderDateTime)));
                $convertLocalTime = getdatetimebytimezone($orderCountryTimeZone,$dateResponse['datetime'],DFLT_TZ);
                $dateResponse['localtime'] = $convertLocalTime['datetime'];
            }
        }
        return $dateResponse;
    }

    public function getFullAddressData($addr)
    {
        $streetArray = $street2Array = [];
        foreach ($addr->xpath('STR') as $streetValue) {
            $street = str_replace(['\'', '"'], '', $streetValue);
            if ($street != '') {
                $streetArray[]  = $street;
            }
        }
        foreach ($addr->xpath('PRNADR') as $pnrAddress) {
            $eachPnrAddress = str_replace(['\'', '"'], '', $pnrAddress);
            if ($pnrAddress->attributes('ns2', true)->SEQNUM > 1) {
                if ($eachPnrAddress != '') {
                    $street2Array[] = $eachPnrAddress;
                }
            }
            if ($pnrAddress->attributes('ns2', true)->SEQNUM == 4) {
                if ($eachPnrAddress != '') {
                    $streetArray[] = $eachPnrAddress;
                }
            }
        }
        return ['street' => implode(', ', $streetArray),'street2' => implode(', ', $street2Array)];
    }

    private function getCargoIdsByInsertOrUpdate(array $cargoInfo): array
    {
        $this->common->updatetbledata('tb_order_cargodetails', ['status' => 0], ["order_id" => $cargoInfo['orderRowId']]);
        $shipData = $cargoInfo['shipData'];
        $cargoDetail = [
            'cargo_type' => $shipData['pkgs_uom'],
            'handling_unit' => $cargoInfo['cargoContent'],
            'weight' => 0,
            'volume' => $shipData['volume'],
            'volume_unit' => $shipData['volume_uom'],
            'quantity' => $shipData['pkgs_count'],
            'marks_numbers' => $shipData['marks_numbers']
        ];
        $orderCargoDetails = [
            'order_id' => $cargoInfo['orderRowId'],
            'handling_unit' => $cargoInfo['hunit'],
            'weight' => 0,
            'volume' => $shipData['volume'],
            'quantity' => $shipData['pkgs_count'],
            'quantity_type' => $shipData['pkgs_uom'],
            'cargo_content' => $cargoInfo['cargoContent'],
            'marks_numbers' => $shipData['marks_numbers']
        ];
        if (!isset($shipData['dimensions']) || empty($shipData['dimensions'])) {
            $cargoDetail['weight'] = $orderCargoDetails['weight'] = $weight = $shipData['gross_weight'];
            $cargoDetail['weight_unit'] = $shipData['weight_uom'];
            $shipData['dimensions'][] = ['mom' => $shipData['pkgs_uom'], 'measerments' => [], 'nopkgs' => $shipData['pkgs_count']];
        }
        if (count($shipData['dimensions']) == 1) {
            $cargoDetail['weight'] = $orderCargoDetails['weight'] = $weight = $shipData['gross_weight'];
            $cargoDetail['weight_unit'] = $shipData['weight_uom'];
        }
        foreach ($shipData['dimensions'] as $cargoData) {
            $cargoDetail['cargo_type'] = $cargoData['mom'];
            foreach ($cargoData['measerments'] as $cargoUom) {
                if ($cargoUom['type'] == "AAD") {
                    $cargoDetail['weight'] = $weight = $cargoUom['value'];
                    $cargoDetail['weight_unit'] = $cargoUom['uomcode'];
                }
                if ($cargoUom['type'] == "HT") {
                    $cargoDetail['height'] = $height = $cargoUom['value'];
                    $cargoDetail['height_unit'] = $cargoUom['uomcode'];
                }
                if ($cargoUom['type'] == "WD") {
                    $cargoDetail['width'] = $width = $cargoUom['value'];
                    $cargoDetail['width_unit'] = $cargoUom['uomcode'];
                }
                if ($cargoUom['type'] == "LN") {
                    $cargoDetail['length'] = $length = $cargoUom['value'];
                    $cargoDetail['length_unit'] = $cargoUom['uomcode'];
                }
                if ($cargoUom['type'] == "ABJ") {
                    $cargoDetail['volume'] = $volume = $cargoUom['value'];
                    $cargoDetail['volume_unit'] = $cargoUom['uomcode'];
                }
            }
            $cargoDetail['goods_description'] = $cargoInfo['cargoContent'];
            $cargoDetail['dg_goods'] = $cargoInfo['dgGoods'];
            $cargoDetail['status'] = 1;
            $cargoDetail['createdon'] = $cargoInfo['timeStamp'];
            $cargoDetailId = $this->common->insertTableData('tb_cargo_details', $cargoDetail);
            $orderCargoDetails['cargo_id'] = $cargoDetailId;
            $orderCargoDetails['quantity'] = $cargoData['nopkgs'];
            if (!empty($cargoData['measerments'])) {
                $orderCargoDetails['weight'] = $weight ?? 0;
                $orderCargoDetails['length'] = $length ?? 0;
                $orderCargoDetails['width'] = $width ?? 0;
                $orderCargoDetails['height'] = $height ?? 0;
                $orderCargoDetails['volume'] = $volume ?? 0;
            }
            $orderCargoDetails['status'] = 1;
            $cargoId = $this->common->insertTableData('tb_order_cargodetails', $orderCargoDetails);
            if(!empty($cargoInfo['dgCargos'])){
                foreach ($cargoInfo['dgCargos'] as $dgcargoInfo){
                    $orderdgcargo =  [
                        'order_id' => $cargoInfo['orderRowId'],
                        'order_cargo_id' => $cargoId,
                        'num_pkgs' => $dgcargoInfo['packageVal'],
                        'pkg_qty_type' => $dgcargoInfo['packageType'],
                        'quantity' => $dgcargoInfo['qty_val'],
                        'quantity_type' => $dgcargoInfo['qty_typ'],
                        'org_number' => $dgcargoInfo['unonum_val'],
                        'org_name' => $dgcargoInfo['unonum_ver'],
                        'org_num_varient' => $dgcargoInfo['unonum_vrt'],
                        'db_class' => $dgcargoInfo['cls'],
                        'mainrisk' => $dgcargoInfo['pak_inr'],
                        'description' => $dgcargoInfo['dg_prpshpnm'],
                        'limitqty_flag' => $dgcargoInfo['LTDQTYFLG'],
                        'exceptqty_flag' => $dgcargoInfo['EXCQTYFLG']
                    ];
                    $checkOrderDGCargo = $this->db->select("id")->get_where("tb_order_dg_goods", $orderdgcargo);
                    if ($checkOrderDGCargo->num_rows() == 0) {
                        $DGcargoId = $this->common->insertTableData('tb_order_dg_goods', $orderdgcargo);
                    } else {
                        $DGcargoId = $checkOrderDGCargo->row()->id;
                    }
                }
            }
        }
        return ['cargoId' => $cargoId, 'cargoDetailId' => $cargoDetailId];
    }

    private function parseContainersData(object $data): array
    {
        $totalWeight = $totalVolume = $totalQuantity = 0;
        foreach ($data as $eachContainerDetails) {
            $marksAndNumbers = $goodsDescription = [];
            $containerDetails = $eachContainerDetails->xpath('ns19:CNT');
            if (null !== $containerDetails[0]->xpath('CNTNUM')[0]) {
                $containerNumber = isset(
                    $containerDetails[0]->xpath(
                        'CNTNUM'
                    )[0]
                ) ? (string)($containerDetails[0]->xpath('CNTNUM')[0]) : '';
            }
            if (null !== $containerDetails[0]->xpath('CNTTYP')[0]) {
                $containerType = isset(
                    $containerDetails[0]->xpath(
                        'CNTTYP'
                    )[0]
                ) ? (string)($containerDetails[0]->xpath('CNTTYP')[0]) : '';
                if ($containerType != '') {
                    $containerTypes[] = $containerType;
                }
            }
            if (null !== $containerDetails[0]->xpath('NUMPAC')[0]) {
                $containerQuantity = isset(
                    $containerDetails[0]->xpath(
                        'NUMPAC'
                    )[0]->VAL
                ) ? (string)($containerDetails[0]->xpath('NUMPAC')[0]->VAL) : 0;
                $totalQuantity += $containerQuantity;
            }
            foreach ($containerDetails[0]->xpath('SELNUM') as $sealNums) {
                $sealReferenceNumbers[] = ($containerNumber ?? '') . "-" . $sealNums;
            }
            if (null !== $containerDetails[0]->xpath('GRSWGT')[0]) {
                $grossWeight = isset(
                    $containerDetails[0]->xpath(
                        'GRSWGT'
                    )[0]->VAL
                ) ? (string)($containerDetails[0]->xpath('GRSWGT')[0]->VAL) : 0;
                $totalWeight += $grossWeight;
                $weightUom = isset(
                    $containerDetails[0]->xpath(
                        'GRSWGT'
                    )[0]->UOMCDE
                ) ? (string)($containerDetails[0]->xpath('GRSWGT')[0]->UOMCDE) : '';
            }
            if (null !== $containerDetails[0]->xpath('VOL')[0]) {
                $volume = isset(
                    $containerDetails[0]->xpath(
                        'VOL'
                    )[0]->VAL
                ) ? (string)($containerDetails[0]->xpath('VOL')[0]->VAL) : 0;
                $totalVolume += $volume;
                $volumeUom = isset(
                    $containerDetails[0]->xpath(
                        'VOL'
                    )[0]->UOMCDE
                ) ? (string)($containerDetails[0]->xpath('VOL')[0]->UOMCDE) : 0;
            }
            foreach ($containerDetails[0]->xpath('MKSNUM') as $eachMarksAndNumbers) {
                $marksAndNumbers[] = $eachMarksAndNumbers;
            }
            foreach ($containerDetails[0]->xpath('CGOCTT') as $eachGoodsDescription) {
                $goodsDescription[] = $eachGoodsDescription;
            }
            if (null !== $containerDetails[0]->xpath('DGSGOOFLG')[0]) {
                $dangerousGoodsFlag = isset(
                    $containerDetails[0]->xpath(
                        'DGSGOOFLG'
                    )[0]
                ) ? (string)($containerDetails[0]->xpath('DGSGOOFLG')[0]) : '';
            }
            $containersData[] = [
                'containerNumber' => $containerNumber ?? '',
                'containerType' => $containerType ?? '',
                'containerQuantity' => $containerQuantity ?? 1,
                'marksAndNumbers' => $marksAndNumbers,
                'goodsDescription' => $goodsDescription,
                'grossWeight' => $grossWeight ?? 0,
                'weightUom' => $weightUom ?? '',
                'volume' => $volume ?? 0,
                'volumeUom' => $volumeUom ?? '',
                'dangerousGoodsFlag' => $dangerousGoodsFlag ?? ''
            ];
        }
        if (!empty($containerTypes ?? [])) {
            $containerTypesString = implode(', ', $containerTypes);
        }
        return [
            'containersData' => $containersData ?? [],
            'containerTypesString' => $containerTypesString ?? '',
            'totalQuantity' => $totalQuantity,
            'totalWeight' => $totalWeight,
            'totalVolume' => $totalVolume,
            'weightUom' => $weightUom ?? '',
            'volumeUom' => $volumeUom ?? '',
            'sealReferenceNumbers' => $sealReferenceNumbers ?? [],
        ];
    }

    private function parseInnerCargoData(array $data): array
    {
        foreach ($data as $eachInnerCargo) {
            $goodsDescription = [];
            $eachInnerCargo->registerXPathNamespace('ns9', 'http://knie4.int.kn/com/cgod/0600');
            $innerCargoDetails = $eachInnerCargo->xpath('ns9:CGODTL');
            if (null !== $innerCargoDetails[0]->xpath('NUMPAC')[0]) {
                $eachQuantity = isset(
                    $innerCargoDetails[0]->xpath(
                        'NUMPAC'
                    )[0]->VAL
                ) ? (string)($innerCargoDetails[0]->xpath('NUMPAC')[0]->VAL) : 1;
            }
            if (null !== $innerCargoDetails[0]->xpath('NUMPAC')[0]) {
                $eachCargoType = isset(
                    $innerCargoDetails[0]->xpath(
                        'NUMPAC'
                    )[0]->TYP
                ) ? (string)($innerCargoDetails[0]->xpath('NUMPAC')[0]->TYP) : 1;
            }
            if (null !== $innerCargoDetails[0]->xpath('GRSWGT')[0]) {
                $eachGrossWeight = isset(
                    $innerCargoDetails[0]->xpath(
                        'GRSWGT'
                    )[0]->VAL
                ) ? (string)($innerCargoDetails[0]->xpath('GRSWGT')[0]->VAL) : 1;
            }
            if (null !== $innerCargoDetails[0]->xpath('GRSWGT')[0]) {
                $eachGrossWeightUom = isset(
                    $innerCargoDetails[0]->xpath(
                        'GRSWGT'
                    )[0]->UOMCDE
                ) ? (string)($innerCargoDetails[0]->xpath('GRSWGT')[0]->UOMCDE) : 1;
            }
            if (null !== $innerCargoDetails[0]->xpath('CHGWGT')) {
                $eachChargeWeight = isset(
                    $innerCargoDetails[0]->xpath(
                        'CHGWGT'
                    )[0]->VAL
                ) ? (string)($innerCargoDetails[0]->xpath('CHGWGT')[0]->VAL) : 0;
                $eachChargeWeightUom = isset(
                    $innerCargoDetails[0]->xpath(
                        'CHGWGT'
                    )[0]->UOMCDE
                ) ? (string)($innerCargoDetails[0]->xpath('CHGWGT')[0]->UOMCDE) : 0;
            }
            $eachVolume = isset(
                $innerCargoDetails[0]->xpath('VOL')[0]->VAL
            ) ? (string)($innerCargoDetails[0]->xpath('VOL')[0]->VAL) : 0;
            $eachVolumeUom = isset(
                $innerCargoDetails[0]->xpath('VOL')[0]->UOMCDE
            ) ? (string)($innerCargoDetails[0]->xpath('VOL')[0]->UOMCDE) : 0;
            $eachMarksNumbers = isset($innerCargoDetails[0]->xpath('CNTNUM')[0]) ? (string)($innerCargoDetails[0]->xpath('CNTNUM')[0]) : 0;
            foreach ($innerCargoDetails[0]->xpath('MKSNUM') as $eachMarksAndNumbers) {
                $goodsDescription[] = $eachMarksAndNumbers;
            }
            foreach ($innerCargoDetails[0]->xpath('CGOCTT') as $eachGoodsDescription) {
                $goodsDescription[] = $eachGoodsDescription;
            }
            $innerCargoDetailsData[$eachMarksNumbers][] = [
                'innerCargoType' => $eachCargoType ?? '',
                'innerCargoQuantity' => $eachQuantity ?? 1,
                'goodsDescription' => $goodsDescription,
                'grossWeight' => $eachGrossWeight ?? 0,
                'weightUom' => $eachGrossWeightUom ?? '',
                'volume' => $eachVolume ?? 0,
                'volumeUom' => $eachVolumeUom ?? '',
                'eachChargeWeight' => $eachChargeWeight ?? '',
                '$eachChargeWeightUom' => $eachChargeWeightUom ?? ''
            ];
        }
        return $innerCargoDetailsData ?? [];
    }

    private function getCargoIdsByInsertOrUpdateOfOuterAndInnerCargos(array $cargoInfo): array
    {
        $containerData = $cargoInfo['containerData'];
        $innerCargoData = $cargoInfo['innerCargoData'];
        $dgCargos = $cargoInfo['dgCargos'];
        foreach ($containerData as $eachContainerData) {
            $cargoDetail = [
                'cargo_type' => $eachContainerData['containerType'],
                'weight' => $eachContainerData['grossWeight'],
                'weight_unit' => $eachContainerData['weightUom'],
                'volume' => $eachContainerData['volume'],
                'volume_unit' => $eachContainerData['volumeUom'],
                'quantity' => 1,
                'status' => 1,
                'dg_goods' => ($eachContainerData['dangerousGoodsFlag'] == "Y") ? 1 : 0,
                'createdon' => $cargoInfo['timeStamp']
            ];
            if (!empty($eachContainerData['goodsDescription'])) {
                $cargoDetail['handling_unit'] = $cargoDetail['goods_description'] = $goodsDescription = implode(" ", $eachContainerData['goodsDescription']);
            }
            if (!empty($eachContainerData['marksAndNumbers'])) {
                $cargoDetail['marks_numbers'] = $marksAndNumbers = implode(" ", $eachContainerData['marksAndNumbers']);
            }
            $cargoDetailId = $this->common->insertTableData('tb_cargo_details', $cargoDetail);
            if (isset($innerCargoData[$eachContainerData['containerNumber']])) {
                $containersInnerCargosData = $innerCargoData[$eachContainerData['containerNumber']];
                foreach ($containersInnerCargosData as $containersInnerCargoData) {
                    $innerCargoInsertData = [
                        'cargo_id' => $cargoDetailId,
                        'cargo_type' => $containersInnerCargoData['innerCargoType'],
                        'goods_description' => implode(" ", $containersInnerCargoData['goodsDescription']),
                        'quantity' => $containersInnerCargoData['innerCargoQuantity'],
                        'weight' => $containersInnerCargoData['grossWeight'],
                        'weight_unit' => $containersInnerCargoData['weightUom'],
                        'volume' => $containersInnerCargoData['volume'],
                        'volume_unit' => $containersInnerCargoData['volumeUom'],
                        'createdby' => $cargoInfo['userId'],
                        'createdon' => $cargoInfo['timeStamp']
                    ];
                    $this->db->insert("tb_inner_cargo", $innerCargoInsertData);
                }
            }
            $orderCargoDetails = [
                'order_id' => $cargoInfo['orderRowId'],
                'cargo_id' => $cargoDetailId,
                'handling_unit' => $this->Order_details->getHandlingUnitId($eachContainerData['containerType'], ['userId' => $cargoInfo['userId'], 'dateTime' => $cargoInfo['timeStamp']]),
                'weight' => $eachContainerData['grossWeight'],
                'volume' => $eachContainerData['volume'],
                'quantity' => 1,
                'quantity_type' => $eachContainerData['containerType'],
                'cargo_content' => $goodsDescription ?? '',
                'marks_numbers' => $marksAndNumbers ?? ''
            ];
            $checkOrderCargo = $this->db->select("id")->get_where("tb_order_cargodetails", $orderCargoDetails);
            if ($checkOrderCargo->num_rows() == 0) {
                $orderCargoDetails['status'] = 1;
                $cargoId = $this->common->insertTableData('tb_order_cargodetails', $orderCargoDetails);
            } else {
                $cargoId = $checkOrderCargo->row()->id;
            }
            if(!empty($dgCargos)){
                foreach ($dgCargos as $dgcargoInfo){
                    $orderdgcargo =  [
                        'order_id' => $cargoInfo['orderRowId'],
                        'order_cargo_id' => $cargoId,
                        'num_pkgs' => $dgcargoInfo['packageVal'],
                        'pkg_qty_type' => $dgcargoInfo['packageType'],
                        'quantity' => $dgcargoInfo['qty_val'],
                        'quantity_type' => $dgcargoInfo['qty_typ'],
                        'org_number' => $dgcargoInfo['unonum_val'],
                        'org_name' => $dgcargoInfo['unonum_ver'],
                        'org_num_varient' => $dgcargoInfo['unonum_vrt'],
                        'db_class' => $dgcargoInfo['cls'],
                        'mainrisk' => $dgcargoInfo['pak_inr'],
                        'description' => $dgcargoInfo['dg_prpshpnm'],
                        'limitqty_flag' => $dgcargoInfo['LTDQTYFLG'],
                        'exceptqty_flag' => $dgcargoInfo['EXCQTYFLG']
                    ];
                    $checkOrderDGCargo = $this->db->select("id")->get_where("tb_order_dg_goods", $orderdgcargo);
                    if ($checkOrderDGCargo->num_rows() == 0) {
                        $DGcargoId = $this->common->insertTableData('tb_order_dg_goods', $orderdgcargo);
                    } else {
                        $DGcargoId = $checkOrderDGCargo->row()->id;
                    }
                }
            }

        }
        return ['cargoId' => $cargoId, 'cargoDetailId' => $cargoDetailId];
    }

    private function cancelOrder(string $salogTrackingId, array $data): bool
    {
        $orderIdArray = $this->getExistingOrderIds($data['xsr_value'],$data['dq_number']);
        if (empty($orderIdArray)) {
            log_message("error", "salog order cancellation unsuccessful  - " . $data['xsr_value'] . " - " . $data['dq_number']);
            return true;
        }
        if (!empty($orderIdArray) && $orderIdArray[0] > 0) {
            $this->common->updatetbledata('tb_orders', ['status' => 3], ["id" => $orderIdArray[0]]);
            $getTripShiftIds = $this->common->gettblrowdata(["id " => $orderIdArray[0]], "order_id,customer_id,shift_id,trip_id,company_code,branch_code", "tb_orders", 0, 0);
            if (!empty($getTripShiftIds)) {
                $data['booking_id']   = $getTripShiftIds['order_id'];
                $data['customer_id']  = $getTripShiftIds['customer_id'];
                $data['company_code'] = $getTripShiftIds['company_code'];
                $data['branch_code']  = $getTripShiftIds['branch_code'];
                try {
                    $isCancelled = $this->common->gettblrowdata(["id" => $orderIdArray[0],'status' => 3],"id","tb_orders",0,0);
                    if (count($isCancelled) > 0) {
                        log_message("error", "salog order cancel success -".$data['xsr_value']."-".$data['dq_number']." at ".gmdate('d-m-Y H:i'));
                        $this->sendStatusMail($data);
                    }
                } catch (Exception $ex) {
                    log_message("error", "Salog status mail failed " . $ex->getMessage());
                }
                if($getTripShiftIds['shift_id'] > 0){
                    $this->notifytrigger->sendNotificationToCarrier($getTripShiftIds['shift_id'], $data['company_code'], 'CA');
                    $this->common->updatetbledata('tb_shifts', ['status' => 0], ["id" => $getTripShiftIds['shift_id']]);
                }
                if($getTripShiftIds['trip_id'] > 0){
                    $this->common->updatetbledata('tb_trips', ['status' => 0], ["id" => $getTripShiftIds['trip_id']]);
                }
            }
            if (checkAccessConditions("CHECK_STS_REFERENCE_COUNTRIES", $data['company_code'])) {
                $ins_ref = ['order_id' => $orderIdArray[0], 'reference_id' => 'STS'];
                $checkSTSRef = $this->common->gettblrowdata($ins_ref, "id", "tb_order_references", 0, 0);
                if (count($checkSTSRef) > 0) {
                    $this->common->updatetbledata('tb_order_references', ['ref_value' => "Cancelled"], $ins_ref);
                }else{
                    $ins_ref['ref_value'] = "Cancelled";
                    $this->common->insertTableData("tb_order_references", $ins_ref);
                }
            }
            try {
                $this->shipmentTriggerToCarrier($orderIdArray[0],$data['function_code']);
            } catch (Exception $ex) {
                log_message("error", "Salog Shipment Information Failed to sent Carrier " . $ex->getMessage());
            }
        }
        return true;
    }

    private function getContactInformation(object $data): array
    {
        $contact = $data->xpath('CTAINF')[0] ?? [];
        if (!empty($contact)) {
            $firstName = (null !== $contact->FSTNAM) ? (string)($contact->FSTNAM) : "";
            $lastName = (null !== $contact->LSTNAM) ? (string)($contact->LSTNAM) : "";
            if ($lastName != "") {
                $firstName = $firstName . " " . $lastName;
            }
            $contactInfo = $contact->COM;
            foreach ($contactInfo as $eachRow) {
                if ($eachRow->attributes('ns2', true)->COMTYP == "TE") {
                    $mobileNumber = $eachRow;
                }
                if ($eachRow->attributes('ns2', true)->COMTYP == "EM") {
                    $emailId = $eachRow;
                }
            }
            $contactData = [
                'name' => $firstName ?? '',
                'phone' => $mobileNumber ?? '',
                'email' => $emailId ?? '',
            ];
        }
        return $contactData ?? [];
    }

    private function sendStatusMail(array $data): void
    {
        if (($data['transport_mode'] == self::TRANSPORT_MODE_FOR_AIR) && ($data['company_code'] == 'VNKN')) {
            return;
        }
        $this->load->library('PhpMailerLibrary');
        if ($data['function_code'] == 'CR') {
            $status = "Created ";
        } elseif ($data['function_code'] == 'UP') {
            $status = "Updated ";
        } elseif ($data['function_code'] == 'CA') {
            $status = "Cancelled ";
        } else {
            $status = "Created ";
        }
        if ($data['xsr_value'] != '') {
            $trackingNumber = $data['xsr_value'];
        } else {
            $trackingNumber = $data['dq_number'];
        }
        $customerGroupEmailIds = $ccMailIds = $bccMailIds = [];
        $toMailIds = [$data['salog_user_email_id']];
        $getCustomerIdAndCode = $this->Standardstatusmodel->getCustomerIdAndCode($data['booking_id']);
        $customerCode = $customerName = $customerEmailId = '';
        if (!empty($getCustomerIdAndCode)) {
            $customerCode = $getCustomerIdAndCode['code'];
            $customerName = $getCustomerIdAndCode['name'];
        }
        if ($data['customer_id'] > 0) {
            $customerGroupEmailIds = $this->Roadlogtosalogmodel->getCustomerGroupEmailIds($data['customer_id']);
        }
        $getCarrierEmailId = $this->Roadlogtosalogmodel->getCarrierEmailId($data['booking_id']);
        if ($data['company_code'] == 'VNKN') {
            $ccMailIds[] = 'knsgn.road.operationalcare@kuehne-nagel.com';
            $ccMailIds[] = 'knvn.svkonekt@kuehne-nagel.com';
        } elseif ($data['company_code'] == 'CNKN' || $data['company_code'] == 'TWKN'){
            if (($getCarrierEmailId['email'] ?? '') != '') {
                $bccMailIds[] = $getCarrierEmailId['email'];
            }
            switch ($customerCode) {
                case "1000211110":
                    if ($data['sdt_value'] == 'PUP' || $data['sdt_value'] == 'IMP') {
                        $ccMailIds[] = 'SZX-OCC@kuehne-nagel.com';
                    } elseif ($data['sdt_value'] == 'DEL') {
                        $ccMailIds[] = 'scnair-import.occ@kuehne-nagel.com';
                    }
                    break;
                case "1000211118":
                    if ($data['sdt_value'] == 'PUP' || $data['sdt_value'] == 'IMP') {
                        $ccMailIds[] = 'XMN-OCC@kuehne-nagel.com';
                    } elseif ($data['sdt_value'] == 'DEL') {
                        $ccMailIds[] = 'SCNAIR-IMPORT.OCC@KUEHNE-NAGEL.COM';
                    }
                    break;
                case "1000353916":
                    if ($data['sdt_value'] == 'PUP' || $data['sdt_value'] == 'IMP') {
                        $ccMailIds[] = 'HDU-OCC@kuehne-nagel.com';
                    } elseif ($data['sdt_value'] == 'DEL') {
                        $ccMailIds[] = 'SCNAIR-IMPORT.OCC@KUEHNE-NAGEL.COM';
                    }
                    break;
                case "1000397871":
                    $ccMailIds[] = 'knzsn.air.ccl@kuehne-nagel.com';
                    if ($data['sdt_value'] == 'PUP' || $data['sdt_value'] == 'IMP') {
                        $ccMailIds[] = 'SZX-OCC@kuehne-nagel.com';
                    } elseif ($data['sdt_value'] == 'DEL') {
                        $ccMailIds[] = 'SCNAIR-IMPORT.OCC@KUEHNE-NAGEL.COM';
                    }
                    break;
                case "1000466462":
                    if ($data['sdt_value'] == 'PUP' || $data['sdt_value'] == 'IMP') {
                        $ccMailIds[] = 'knhkg.zao.trucking@kuehne-nagel.com';
                    } elseif ($data['sdt_value'] == 'DEL') {
                        $ccMailIds[] = 'knhkg.zao.trucking@kuehne-nagel.com';
                        $ccMailIds[] = 'knhkg.zao.import@kuehne-nagel.com';
                    }
                    break;
                case "1004573268":
                    if ($data['sdt_value'] == 'PUP' || $data['sdt_value'] == 'IMP') {
                        $ccMailIds[] = 'knhkg.zao.trucking@kuehne-nagel.com';
                    }
                    break;
                case "1000659010":
                        $ccMailIds[] = 'kncgo.air.pricing@kuehne-nagel.com';
                    break;
                case "1000211120":
                    if ($data['sdt_value'] == 'PUP') {
                        $ccMailIds[] = 'knsia.air.ccl@kuehne-nagel.com';
                    } elseif ($data['sdt_value'] == 'DEL' || $data['sdt_value'] == 'IMP') {
                        $ccMailIds[] = 'knctu.air.occ@kuehne-nagel.com';
                    }
                    break;
                case "1000210679":
                    if ($data['sdt_value'] == 'PUP') {
                        $ccMailIds[] = 'knckg.air.ccl@kuehne-nagel.com';
                    } elseif ($data['sdt_value'] == 'DEL' || $data['sdt_value'] == 'IMP') {
                        $ccMailIds[] = 'knctu.air.occ@kuehne-nagel.com';
                    }
                    break;
                case "1000084925":
                    if ($data['sdt_value'] == 'PUP') {
                        $ccMailIds[] = 'knwuh.air.ccl@kuehne-nagel.com';
                    } elseif ($data['sdt_value'] == 'DEL' || $data['sdt_value'] == 'IMP') {
                        $ccMailIds[] = 'knctu.air.occ@kuehne-nagel.com';
                    }
                    break;
                case "1000599141":
                    if ($data['sdt_value'] == 'PUP') {
                        $ccMailIds[] = 'kncsx.air.ccl@kuehned-nagel.com';
                    } elseif ($data['sdt_value'] == 'DEL' || $data['sdt_value'] == 'IMP') {
                        $ccMailIds[] = 'knctu.air.occ@kuehne-nagel.com';
                    }
                    break;
                case "1000210660":
                    if ($data['sdt_value'] == 'PUP') {
                        $ccMailIds[] = 'knctu.air.ccl@kuehne-nagel.com';
                    } elseif ($data['sdt_value'] == 'DEL' || $data['sdt_value'] == 'IMP') {
                        $ccMailIds[] = 'knctu.air.occ@kuehne-nagel.com';
                    }
                    break;
                default:
                    $ccMailIds = [];
            }
        } elseif ($data['company_code'] == 'INKN') {
            $ccMailIds = ['brijain.mehtalia@kuehne-nagel.com', 'hari.prasad@kuehne-nagel.com', 'sandip.sahu@kuehne-nagel.com', 'rahul.kumar@kuehne-nagel.com', 'external.aravindh.ravi@kuehne-nagel.com', 'external.swara.ghadi@kuehne-nagel.com', 'external.juhi.rajput@kuehne-nagel.com', 'bhagwat.jadhav@kuehne-nagel.com', 'external.neelam.dwivedi@kuehne-nagel.com', 'rajampeta.ealeshwari@kuehne-nagel.com', 'he.manjunath@kuehne-nagel.com'];
        }
        $ccMailIds = array_merge($customerGroupEmailIds,$ccMailIds);
        $subject = ($trackingNumber ?? '') . " Order has been " . $status . $data['booking_id'];
        if(($data['company_code'] == 'PHKN') && ($customerName != '')){
            $subject .= "(".$customerName . ")";
            $bccMailIds[] = 'sol.ignacio@kuehne-nagel.com';
            if (in_array($customerCode, ['1005751990', '1000612148','1005202085'])) {
                $bccMailIds[] = $customerEmailId;
                if (($getCarrierEmailId['email'] ?? '') != '') {
                    $bccMailIds =  array_merge($bccMailIds,explode("; ",$getCarrierEmailId['email']));
                }
                array_push($toMailIds, 'angelie.omes@kuehne-nagel.com', 'florylie-joy.gumboc@kuehne-nagel.com');
                array_push($ccMailIds, 'm.sivakumar@kuehne-nagel.com', 'joel.padua@kuehne-nagel.com');
            }
        }
        $message = "Hi, <br><br>";
        $message .= "Booking has been " . $status . " in Svkonekt.<br>";
        $message .= "Tracking No : " . ($trackingNumber ?? '') . "<br>";
        $message .= "Svkonekt Booking ID : " . $data['booking_id'] . "<br>";
        if (isset($data['branch_code'])) {
            $message .= "Branch Name : " . $data['branch_code'] . "<br><br>";
        }
        if ($data['company_code'] === 'VNKN') {
            $bookingInfo = $this->common->gettblrowdata(['order_id'=>$data['booking_id']],'pickup_company,delivery_company,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address1,delivery_address1,pickup_address2,delivery_address2','tb_orders',1,1);
            if (!empty($bookingInfo)) {
                $bookingInfo = (object) $bookingInfo;
                $message .= "<b>Pickup Information : </b><br><br>";
                $message .= $bookingInfo->pickup_company."<br><br>";
                $message .= $bookingInfo->pickup_address1."<br><br>";
                $message .= $bookingInfo->pickup_address2."<br><br>";
                $message .= $bookingInfo->pickup_city.' - '.$bookingInfo->pickup_pincode."<br><br>";
                $message .= $bookingInfo->pickup_country."<br><br>";
                $message .= "<b>Delivery Information : </b><br><br>";
                $message .= $bookingInfo->delivery_company."<br><br>";
                $message .= $bookingInfo->delivery_address1."<br><br>";
                $message .= $bookingInfo->delivery_address2."<br><br>";
                $message .= $bookingInfo->delivery_city.' - '.$bookingInfo->delivery_pincode."<br><br>";
                $message .= $bookingInfo->delivery_country."<br><br>";
            }
        }
        if ($data['function_code'] == 'UP' && ($data['email_body'] ?? '') != '') {
            $message .= $data['email_body']."<br><br>";
        }
        $message .= "Best Regards,<br>";
        $message .= "Svkonekt Team";
        try {
            if ($this->phpmailerlibrary->sendMultipleToMail($toMailIds, $subject, $message, $ccMailIds, [], $bccMailIds)) {
                log_message("error", "salog status email sucess ".$subject." to - ".json_encode($toMailIds)." cc - ".json_encode($ccMailIds)." bcc - ".json_encode($bccMailIds)." email body- ".$message);
            } else {
                log_message("error", "salog status email failed ".$subject." to - ".json_encode($toMailIds)." cc - ".json_encode($ccMailIds)." bcc - ".json_encode($bccMailIds)." email body- ".$message);
            }
        } catch (Exception $e) {
            log_message("error", "salog status email failed - " . $e->getMessage());
        }
    }

    private function getContactReferenceId(string $customerType): string
    {
        return match ($customerType) {
            'Carrier' => 'CRI',
            'Shipper' => 'SHI',
            'Consignee' => 'CNI',
            'NOTIFY_PARTY' => 'NPI',
            'PICKUP' => 'PKI',
            'DELIVERY' => 'DLI',
            'CUSTOMER' => 'CUI',
            'FREIGHT_PAYER' => 'FPI',
            default => '',
        };
    }
    public function shipmentTriggerToCarrier(int $order_id,string $functionCode): void
    {
        $getShipmentDetails = $this->Order_details->checkShipmentCreation($order_id);
        log_message("error", "Shipment Information: " . json_encode($getShipmentDetails));
        if (!empty($getShipmentDetails) && $getShipmentDetails['shift_id']!=0) {
            $carrierEDIDetails = $this->common->carrierEDIDetails($getShipmentDetails['vendor_id']);
            if (!empty($carrierEDIDetails)) {
                if ($carrierEDIDetails["editype"] == "P") {
                    if ($carrierEDIDetails["ediservice"] == "Web Services") {
                        $response = $this->carrierstandardtripoutbound->shipmentdata($getShipmentDetails['shift_id'], $functionCode);
                    }
                }
                if ($carrierEDIDetails["editype"] == "T") {
                    $response = $this->carriercommonedilib->shipmentdata($getShipmentDetails['shift_id']);
                }
            }
        }
    }

    public function getExistingOrderIds(string $xsrValue, string $dqNumber): array
    {
        $orderIdsWithXsrAndDq = $this->Roadlogtosalogmodel->getOrderIdsWithSalogDqAndXsrValue($xsrValue, $dqNumber);
        if (empty($orderIdsWithXsrAndDq)) {
            return [];
        }
        $selectedOrderIds = [];
        foreach ($orderIdsWithXsrAndDq as $key => $value) {
            if (count($value) == 2) {
                if (($value['XSR'] ?? '') == $xsrValue && ($value['DQ'] ?? '') == $dqNumber) {
                    $selectedOrderIds[] = $key;
                }
            }
        }
        if (count($selectedOrderIds) > 1) {
            $selectedOrderId[] = max($selectedOrderIds);
        }
        if (count($selectedOrderIds) == 1) {
            $selectedOrderId[] = $selectedOrderIds[0];
        }
        return $selectedOrderId ?? [];
    }

    public function compareAndGenerateEmailBody(array $latestInboundData, array $existingInboundData): string
    {
        $emailBody = '';
        if (empty($latestInboundData) || empty($existingInboundData)) {
            return $emailBody;
        }
        $emailBodyHeaders = [
            'estimated_early_pickup' => 'Estimated Early Pickup : ',
            'estimated_early_delivery' => 'Estimated Early Delivery :  ',
            'total_actual_weight' => 'Total Actual Weight :  ',
            'total_weight' => 'Total Weight :  ',
            'total_actual_volume' => 'Total Actual Volume :  ',
            'total_packages' => 'Total Packages :  ',
            'sla_reference' => 'SLA Reference :  ',
            'dla_reference' => 'DLA Reference :  ',
            'sac_reference' => 'SAC Reference :  ',
            'rem_reference' => 'REM Reference :  ',
            'awb_reference' => 'AWB Reference :  ',
            'mawb_reference' => 'MAWB Reference :  '
        ];
        foreach ($emailBodyHeaders as $key => $eachEmailBodyHeaders) {
            if ($latestInboundData[$key] != $existingInboundData[$key]) {
                $emailBody .= $eachEmailBodyHeaders . "<span style='background-color: #ffe7e7;'><s>" . $existingInboundData[$key] . "</s></span>" . " " . "<span style='background-color: #e3fcef;'><b>" . $latestInboundData[$key] . "</b></span>" . "<br>";
            } else {
                $emailBody .= $eachEmailBodyHeaders . "<span style='background-color: #e3fcef;'><b>" . $latestInboundData[$key] . "</b></span>" . "<br>";
            }
        }
        return $emailBody;
    }

    public function updateUserPartyTypes(array $data): void
    {
        $partyNames = $partyTypesArray = [];
        if ($data['partyTypes'] != "") {
            $partyTypesArray = explode(',', $data['partyTypes']);
        }
        array_push($partyTypesArray, $data['currentPartyType']);
        if (!empty($partyTypesArray)) {
            array_push($partyTypesArray, $data['dbPartytype']);
            array_unique($partyTypesArray);
            $partyTypeDetails = $this->Order_details->getPartyTypeNames($partyTypesArray);
            foreach ($partyTypeDetails as $eachLine) {
                $partyNames[$eachLine['id']] = $eachLine['name'];
            }
            $latestPartyTypeId = $data['dbPartytype'];
            $latestPartyTypes = [];
            foreach ($partyNames as $key => $value) {
                if (in_array($value, ['CUSTOMER', 'CARRIER'])) {
                    $latestPartyTypeId = $key;
                }
                $latestPartyTypes[] = $key;
            }
            if (!empty($latestPartyTypes)) {
                $latestPartyTypesString = implode(",", $latestPartyTypes);
            }
            $this->common->updatetbledata("tbl_party_master", ['party_type_id' => $latestPartyTypeId, 'party_types' => $latestPartyTypesString ?? ""], ['id' => $data['partyId']]);
        }
    }
}
