<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Scanner extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['common', 'apis/CarrierInboundModel']);
    }

    public function index(): void
    {
        $this->load->view('scanner/scan_docket', true);
    }

    public function fetchDataFromAPI(): void
    {

        $input = $this->input->get('tknNo');
        $ref = $this->input->get('ref');
        $orderId = null;
        $orderDetails = $this->CarrierInboundModel->getOrderId(substr($input, 0, 10), $ref);
        if (! empty($orderDetails)) {
            $orderId  = $orderDetails[0]['order_id'];
            $id = $orderDetails[0]['id'];
            $response = $this->fetchCargoDetails($id, $orderId, $ref);
            echo json_encode($response);
        } else {
        }
    }

    public function displayCargo()
    {
        $rawData = $this->input->post('cargoData');
        $cargoData = json_decode($rawData, true);

        if (empty($cargoData)) {
            show_error("No cargo data received.");
        }

        $data['order_id'] = $cargoData['order_id'] ?? '';
        $data['ref'] = $cargoData['ref'] ?? '';
        $data['cargo_details'] = $cargoData['cargo_details'] ?? [];

        $this->load->view('scanner/cargo_table_view', $data);
    }

    public function UpdateScannerQuantity(): void
    {
        $input = $this->input->get('tknNo');
        $curr_ord_id = $this->input->get('curr_order_id');
        $cargo_id = $this->input->get('cargoId');
        $scanned_quantity = $this->input->get('ScanQu');
        $quantity = $this->input->get('quantity');
        $ref = $this->input->get('ref');
        $orderId = null;
        $orderDetails = $this->CarrierInboundModel->getOrderId(substr($input, 0, 10), $ref);
        $orderId  = $orderDetails[0]['order_id'];
        $Id  = $orderDetails[0]['id'];
        if (!empty($orderDetails)) {
            if ($curr_ord_id == $orderId and ($scanned_quantity < $quantity)) {
                $scanned_quantity += 1;
                $this->db->set('scanned_quantity', $scanned_quantity, false);
                $this->db->where('order_id', $Id);
                $this->db->where('cargo_id', $cargo_id);
                $this->db->update('tb_order_cargodetails');
                $data['error'] = "";
            } else {
                $data['error'] = "The Cargo Qunatity is Reached";
            }
            $response = $this->fetchCargoDetails($Id, $orderId, $ref);
            $data['ref'] = $ref ?? '';
            $data['order_id'] = $orderId ?? '';
            $data['cargo_details'] = $response ?? [];
            echo json_encode($data);
        } else {
        }
    }

    public function fetchCargoDetails($id, $orderId, $ref)
    {
        $sql = 'SELECT c.*,o.scanned_quantity FROM tb_cargo_details c,tb_order_cargodetails o  WHERE o.order_id =? AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC';
        $qry = $this->db->query($sql, [$id]);
        $cargo_ins = [];
        if ($qry->num_rows() > 0) {
            foreach ($qry->result() as $res) {
                $cargo_ins[] = [
                    'cargo_id' => $res->id,
                    'cargo_type' => $res->cargo_type,
                    'quantity' => $res->quantity ?? 0,
                    'scanned_quantity' => $res->scanned_quantity ?? 0
                ];
            }

            $response = [
                'ref' => $ref,
                'order_id' => $orderId,
                'cargo_details' => $cargo_ins
            ];
        }
        return $response;
    }
}
