<?php

defined('BASEPATH') or exit('No direct script access allowed');

use App\Libraries\infrastructure\ScheduledJobLoggerService;

class Scheduledjobhousekeeping extends CI_Controller
{
    /** @var ScheduledJobLoggerService */
    private $scheduledJobService;

    public function __construct()
    {
        parent::__construct();
        $this->scheduledJobService = ScheduledJobLoggerService::instance(get_class($this));
    }

    public function purgeoldlogs($days = 7)
    {
        $this->scheduledJobService->startJob();
        $this->scheduledJobService->log("purgeoldlogs", "Init purgeoldlogs() with number of days: " . $days);
        if ($this->scheduledJobService->purgeOldLogs($days)) {
            $this->scheduledJobService->log("purgeoldlogs", "finished purgeoldlogs() successfully");
            $this->scheduledJobService->finishJob(true);
        } else {
            $this->scheduledJobService->log("purgeoldlogs", "purgeoldlogs() failed");
            $this->scheduledJobService->finishJob(false);
        }
    }
}
