<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
use App\Traits\AutoRoutingTrait;

class Scheduledroutingtoorder extends CI_Controller
{
    use AutoRoutingTrait;

    public function __construct()
    {
        parent::__construct();
        $this->load->library(['session','form_validation','email','statusintigration','ratemanagement','tripCreateFromOrders']);
        $this->load->model(['scheduledrouting','common']);
        $this->load->helper("log");
    }

    public function index($id = null)
    {
        if(!$id) {
            redirect("routing");
            return;
        }

        $order_ids = $orders_list = [];
        $user_id =  $this->session->userdata('user_id');
        $tbl = "tb_routing_auto";

        $whr = ['id'=>$id, 'cust_id <>' => 0, 'triggered_type'=>'1', 'user_id'=>$user_id, 'status'=>1];

        $select = "cust_id,order_type,product,mot,service,pick_type,pick_val,deli_type,deli_val,carrier_id,vehicle_type,vehicle_id,driver_id,template_id,min_weight,max_weight,min_volume,max_volume,min_weight_uom,max_weight_uom,min_volume_uom,max_volume_uom,min_weight_ac,
            max_weight_ac,min_weight_uom_ac,max_weight_uom_ac,min_volume_ac,max_volume_ac,min_volume_uom_ac,max_volume_uom_ac,ship_identifier,cons_identifier,notify_identifier";

        $chkdirect = $this->common->gettbldata($whr,$select,$tbl,0,0);

        foreach ($chkdirect as $res) {
            $cust_id = $res['cust_id'];
            $pick_type = $res['pick_type'];
            $pick_val = $res['pick_val'];
            $deli_type = $res['deli_type'];
            $deli_val = $res['deli_val'];
            $carrier_id = $res['carrier_id'];
            $vehicle_type = $res['vehicle_type'];
            $driver_id = $res['driver_id'];
            $shiperIdentifier = $res['ship_identifier'];
            $consineeIdentifier = $res['cons_identifier'];
            $notifyIdentifier = $res['notify_identifier'];
            $vehicleId = $res['vehicle_id'];
            $templateId = $res['template_id'];
            if((strtoupper($deli_type) == 'REGION' && strtoupper($pick_type) == 'REGION') || (strtoupper($deli_type) == 'LOCATION ID' && strtoupper($pick_type) == 'LOCATION ID')) {
                $order_ids = $this->checkregion($pick_val,$deli_val,$cust_id,$carrier_id,$vehicle_type,$driver_id,$templateId);
            }else if((strtoupper($deli_type) == 'REGION' && strtoupper($pick_type) != 'REGION') || (strtoupper($deli_type) != 'REGION' && strtoupper($pick_type) == 'REGION')){
                $order_ids = $this->checksingleregion($pick_type,$pick_val,$deli_type,$deli_val,$cust_id,$carrier_id,$vehicle_type,$driver_id,$templateId);
            }else if((strtoupper($deli_type) == 'LOCATION ID' && strtoupper($pick_type) != 'LOCATION ID') || (strtoupper($deli_type) != 'LOCATION ID' && strtoupper($pick_type) == 'LOCATION ID')){
                $order_ids = $this->checksingleregion($pick_type,$pick_val,$deli_type,$deli_val,$cust_id,$carrier_id,$vehicle_type,$driver_id,$templateId);
            } else {
                [$pwhr, $dwhr] = $this->getWhereForOrderDetails($pick_type, $pick_val, $deli_type, $deli_val);
                $swhr = "o.user_id ='".$user_id."' AND o.customer_id ='".$cust_id."' AND o.status=1 AND o.shift_id ='0'";

                /* check constraints avalable or not */
                if ( $res['min_weight'] == '0.00' && $res['max_weight'] == '0.00' && $res['min_weight_ac'] == '0.00' && $res['max_weight_ac'] == '0.00' && $res['min_volume'] == '0.00' && $res['max_volume'] == '0.00' && $res['min_volume_ac'] == '0.00' && $res['max_volume_ac'] == '0.00' ) {
                    $constraints = 'yes';
                    // no constraints available
                } else {
                    $constraints = 'no';
                }

                if($pwhr != "" && $dwhr != "" && $swhr != ""){
                    $chkorder = $this->scheduledrouting->getorderswithouttrip($pwhr,$dwhr,$swhr);

                    foreach ($chkorder as $ord) {
                        $orderidd = $ord['id'];

                        $table = 'tb_order_cargodetails';
                        $whrr = array( 'order_id' => $orderidd, 'status' => 1 );
                        $selectt = 'id, order_id, cargo_id, handling_unit, length, width, height, weight, second_weight, volumetric_weight, volweight_uom, ldm, volume, second_volume, quantity, scanned_quantity, quantity_type, cargo_content';
                        $cargoinfo = $this->common->gettbldata( $whrr, $selectt, $table, 0, 0 );

                        if (count( $cargoinfo ) > 0) {
                            $weight = 0;
                            $second_weight = 0;
                            $volume = 0;
                            $second_volume = 0;

                            foreach ( $cargoinfo as $row ) {
                                $weight += $row['weight'];
                                $second_weight += $row['second_weight'];
                                $volume += $row['volume'];
                                $second_volume += $row['second_volume'];
                            }
                        }

                        $carfo_details = ['weight' => $weight, 'second_weight' => $second_weight, 'volume' => $volume, 'second_volume' => $second_volume];
                        $date = $ord['pickup'];

                        if($date != "" && $date != "0000-00-00" && $date != "1970-01-01") {
                            $this->getOrderDetails($order_ids, $carfo_details, $res, $constraints, $ord, $date);

                        }
                    }
                }
            }
            $dummy_array = $templateIds = $ordersWithTemplate = [];
            if (!empty($order_ids)) {
                for ($i = 0, $iMax = count($order_ids); $i < $iMax; $i++) {
                    $first_pdate = $order_ids[$i]['date'];
                    if (!in_array($order_ids[$i]['order_id'], $dummy_array)) {
                        for ($j = 0, $jMax = count($order_ids); $j < $jMax; $j++) {
                            $pickup_date = $order_ids[$j]['date'];
                            if ($first_pdate == $pickup_date) {
                                $templateId = $order_ids[$j]['templateId'] ?? 0;
                                if ($templateId > 0) {
                                    $templateIds[] = $templateId;
                                    $ordersWithTemplate[] = ['order_id' => $order_ids[$j]['order_id'], 'trip' => $order_ids[$j]['date'], 'booking_id' => $order_ids[$j]['booking_id'], 'vehicle_type' => $order_ids[$j]['vehicle_type'], 'vendor_id' => $order_ids[$j]['vendor_id'], 'driver_id' => $order_ids[$j]['driver_id'], 'vehicle_id' => $vehicleId, 'templateId' => $templateId];
                                } else {
                                    $orders_list[] = ['order_id' => $order_ids[$j]['order_id'], 'trip' => $order_ids[$j]['date'], 'booking_id' => $order_ids[$j]['booking_id'], 'vehicle_type' => $order_ids[$j]['vehicle_type'], 'vendor_id' => $order_ids[$j]['vendor_id'], 'driver_id' => $order_ids[$j]['driver_id'], 'vehicle_id' => $vehicleId];
                                    $dummy_array[] = $order_ids[$j]['order_id'];
                                }
                            }
                        }
                    }
                }
            }
            $ordersNewList = $this->checkIdentifireMatch(
                $orders_list,
                $shiperIdentifier,
                $consineeIdentifier,
                $notifyIdentifier
            );
            if (!count($ordersNewList)) {
                log_error('Auto routing: No valid orders found.');
            } else {
                $inserted = $this->inserttripdata($ordersNewList);

                if (!$inserted) {
                    log_error('Auto routing: Unable to save auto routing trip.');
                }
            }
            if (!empty($templateIds)) {
                $finalOrdersListWithTemplates = $this->checkIdentifireMatch(
                    $ordersWithTemplate,
                    $shiperIdentifier,
                    $consineeIdentifier,
                    $notifyIdentifier
                );
                if (empty($finalOrdersListWithTemplates)) {
                    log_error('Auto routing: No valid orders found with Template Id.');
                } else {
                    $keyValues = array_column($finalOrdersListWithTemplates, 'trip');
                    array_multisort($keyValues, SORT_ASC, $finalOrdersListWithTemplates);
                    $i = $createTrip = 0;
                    $finalOrders = $checkTrip = "";
                    $ordersCount = count($finalOrdersListWithTemplates);
                    foreach ($finalOrdersListWithTemplates as $eachLine) {
                        if ($i > 0) {
                            $eachLineTrip = $eachLine['trip'];
                            if ($eachLineTrip == $checkTrip) {
                                $finalOrders .= $eachLine['order_id'] . ",";
                            } else {
                                $response = $this->tripcreatefromorders->createTripByTripTemplate(['orderId' => $finalOrders, 'templateId' => $eachLine['templateId'], 'tripType' => 'multi']);
                                $orderIds = $response['orderIds'];
                                $orderShiftIds = $response['orderShiftIds'];
                                if (!empty($orderIds)) {
                                    $this->tripcreatefromorders->assignOrdersForNewTrip($orderIds, $orderShiftIds, "multi");
                                }
                                $finalOrders =  $eachLine['order_id'] . ",";
                                $checkTrip = $eachLine['trip'];
                            }
                            if (($ordersCount - 1) == $i) {
                                $createTrip = 1;
                            }
                        } else {
                            $checkTrip = $eachLine['trip'];
                            $finalOrders .= $eachLine['order_id'] . ",";
                            if ($ordersCount === 1) {
                                $createTrip = 1;
                            }
                        }
                        if ($createTrip > 0) {
                            $response = $this->tripcreatefromorders->createTripByTripTemplate(['orderId' => $finalOrders, 'templateId' => $eachLine['templateId'], 'tripType' => 'multi']);
                            $orderIds = $response['orderIds'];
                            $orderShiftIds = $response['orderShiftIds'];
                            if (!empty($orderIds)) {
                                $this->tripcreatefromorders->assignOrdersForNewTrip($orderIds, $orderShiftIds, "multi");
                            }
                            $finalOrders =  $eachLine['order_id'] . ",";
                            $checkTrip = $eachLine['trip'];
                            $createTrip = 0;
                        }
                        $i++;
                    }
                }
            }
        }
        redirect("routing");
    }

    public function checksingleregion($pick_type,$pick_val,$deli_type,$deli_val,$cust_id,$carrier_id,$vehicle_type,$driver_id,$templateId){
        $user_id = $this->session->userdata('user_id');
        $order_ids = array();
        /*get orderw with pendign status*/
        $whr = array();
        $select = $region_name = "";
        if(strtoupper($pick_type) == 'REGION'){
            $select = "id,order_id,DATE(pickup_datetime) as pickup,pickup_country as country,pickup_city as city,pickup_pincode as pincode,pickup_address2 as state";
            $region_name = $pick_val;
        }else if(strtoupper($deli_type) == 'REGION'){
            $select = "id,order_id,DATE(pickup_datetime) as pickup,delivery_country as country,delivery_city as city,delivery_pincode as pincode,delivery_address2 as state";
            $region_name = $deli_val;
        }
        if(strtoupper($pick_type) == 'COUNTRY'){
            $whr = array('pickup_country'=>$pick_val,'user_id'=>$user_id,'customer_id'=>$cust_id,'status'=>1,'shift_id'=>0);
        }else if(strtoupper($pick_type) == 'CITY'){
            $whr = array('pickup_city'=>$pick_val,'user_id'=>$user_id,'customer_id'=>$cust_id,'status'=>1,'shift_id'=>0);
        }else if(strtoupper($pick_type) == 'STATE'){
            $whr = array('pickup_address2'=>$pick_val,'user_id'=>$user_id,'customer_id'=>$cust_id,'status'=>1,'shift_id'=>0);
        }else if(strtoupper($pick_type) == 'ZIPCODE'){
            $whr = array('pickup_pincode'=>$pick_val,'user_id'=>$user_id,'customer_id'=>$cust_id,'status'=>1,'shift_id'=>0);
        }
        if(strtoupper($deli_type) == 'COUNTRY'){
            $whr = array('delivery_country'=>$deli_val,'user_id'=>$user_id,'customer_id'=>$cust_id,'status'=>1,'shift_id'=>0);
        }else if(strtoupper($deli_type) == 'CITY'){
            $whr = array('delivery_city'=>$deli_val,'user_id'=>$user_id,'customer_id'=>$cust_id,'status'=>1,'shift_id'=>0);
        }else if(strtoupper($deli_type) == 'STATE'){
            $whr = array('delivery_address2'=>$deli_val,'user_id'=>$user_id,'customer_id'=>$cust_id,'status'=>1,'shift_id'=>0);
        }else if(strtoupper($deli_type) == 'ZIPCODE'){
            $whr = array('delivery_pincode'=>$deli_val,'user_id'=>$user_id,'customer_id'=>$cust_id,'status'=>1,'shift_id'=>0);
        }
        if(empty($whr)){
            $whr = array('user_id'=>$user_id,'customer_id'=>$cust_id,'status'=>1,'shift_id'=>0);
        }
        if($select == ""){
            $select = "id,order_id,DATE(pickup_datetime) as pickup,pickup_country as country,pickup_city as city,pickup_pincode as pincode,pickup_address2 as state";
        }
        if($region_name == ""){
            $region_name = $pick_val;
        }
        if(!empty($whr) && $select != ""){
            $orderid = $this->common->gettbldata($whr,$select,"tb_orders",0,0);
            if(!empty($orderid)){
                foreach ($orderid as $order) {
                    $country = $order['country'];
                    $pincode= $order['pincode'];
                    $city= $order['city'];
                    $date = $order['pickup'];
                    if(strtolower($country) == "russia"){
                        $country = "RU";
                    }
                    if($country == "РОССИЯ" || $country == "Россия"){
                        $country = "RU";
                    }
                    if(strtolower($country) == 'australia' || strtoupper($country) == 'AU'){
                        $country = 'AU';
                    }
                    /* check region */
                    $chk_pincoderouting = $this->common->gettblrowdata(array('postal_code'=>$pincode,'country'=>$country,'region'=>$region_name,'status'=>'1'),"id","tb_kn_geocodes",0,0);
                    if(!empty($chk_pincoderouting)){
                        if($date != "" && $date != "0000-00-00" && $date != "1970-01-01"){
                            $order_ids[] = ['order_id' => $order['id'], 'date' => strtotime($date), 'booking_id' => $order['order_id'], 'vehicle_type' => $vehicle_type, 'vendor_id' => $carrier_id, 'driver_id' => $driver_id, 'templateId' => $templateId];
                        }
                    }else{
                        $chk_cityrouting = $this->common->gettblrowdata(array('city'=>$city,'country'=>$country,'region'=>$region_name,'status'=>'1'),"id","tb_kn_geocodes",0,0);
                        if(!empty($chk_cityrouting)){
                            if($date != "" && $date != "0000-00-00" && $date != "1970-01-01"){
                                $order_ids[] = ['order_id' => $order['id'], 'date' => strtotime($date), 'booking_id' => $order['order_id'], 'vehicle_type' => $vehicle_type, 'vendor_id' => $carrier_id, 'driver_id' => $driver_id, 'templateId' => $templateId];
                            }
                        }
                    }
                }
            }
        }
        return $order_ids;
    }

    public function checkregion($pick_region,$deli_region,$cust_id,$carrier_id,$vehicle_type,$driver_id,$templateId){
        $user_id = $this->session->userdata('user_id');
        $order_ids = array();
        if($pick_region != "" && $deli_region != ""){
            /*get orderw with pendign status*/
            $orderid = $this->common->gettbldata(array('user_id'=>$user_id,'customer_id'=>$cust_id,'status'=>1,'shift_id'=>0),"id,order_id,DATE(pickup_datetime) as pickup,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address2,delivery_address2","tb_orders",0,0);
            if(!empty($orderid)){
                foreach ($orderid as $order) {
                    $pickup_country = $order['pickup_country'];
                    $delivery_country= $order['delivery_country'];
                    $delivery_pincode= $order['delivery_pincode'];
                    $pickup_pincode= $order['pickup_pincode'];
                    $pickup_city= $order['pickup_city'];
                    $delivery_city= $order['delivery_city'];
                    $date = $order['pickup'];
                    if(strtolower($pickup_country) == "russia"){
                        $pickup_country = "RU";
                    }
                    if($pickup_country == "РОССИЯ" || $pickup_country == "Россия"){
                        $pickup_country = "RU";
                    }
                    if($delivery_country == "РОССИЯ" || $delivery_country == "Россия"){
                        $delivery_country = "RU";
                    }
                    if(strtolower($delivery_country) == "russia"){
                        $delivery_country = "RU";
                    }
                    if(strtolower($pickup_country) == 'australia' || strtoupper($pickup_country) == 'AU'){
                        $pickup_country = 'AU';
                    }
                    if(strtolower($delivery_country) == 'australia' || strtoupper($delivery_country) == 'AU'){
                        $delivery_country = 'AU';
                    }
                    if($pickup_pincode != "" && $delivery_pincode != ""){
                        /* check region */
                        $chk_pziprouting = $this->common->gettblrowdata(array('postal_code'=>$pickup_pincode,'country'=>$pickup_country,'region'=>$pick_region,'status'=>'1'),"id","tb_kn_geocodes",0,0);
                        if(!empty($chk_pziprouting)){
                            $chk_dzipreouting = $this->common->gettblrowdata(array('postal_code'=>$delivery_pincode,'country'=>$delivery_country,'region'=>$deli_region,'status'=>'1'),"id","tb_kn_geocodes",0,0);
                            if(!empty($chk_dzipreouting)){
                                if($date != "" && $date != "0000-00-00" && $date != "1970-01-01"){
                                    $order_ids[] = ['order_id' => $order['id'], 'date' => strtotime($date), 'booking_id' => $order['order_id'], 'vehicle_type' => $vehicle_type, 'vendor_id' => $carrier_id, 'driver_id' => $driver_id, 'templateId' => $templateId];
                                }
                            }
                        }else{
                            $chk_pcityrouting = $this->common->gettblrowdata(array('city'=>$pickup_city,'country'=>$pickup_country,'region'=>$pick_region,'status'=>'1'),"id","tb_kn_geocodes",0,0);
                            if(!empty($chk_pcityrouting)){
                                $chk_dcityrouting = $this->common->gettblrowdata(array('city'=>$delivery_city,'country'=>$delivery_country,'region'=>$deli_region,'status'=>'1'),"id","tb_kn_geocodes",0,0);
                                if(!empty($chk_dcityrouting)){
                                    if($date != "" && $date != "0000-00-00" && $date != "1970-01-01"){
                                        $order_ids[] = array('order_id' => $order['id'], 'date' => strtotime($date), 'booking_id' => $order['order_id'], 'vehicle_type' => $vehicle_type, 'vendor_id' => $carrier_id, 'driver_id' => $driver_id, 'templateId' => $templateId);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return $order_ids;
    }

    /**
     * @param array $order_ids
     * @param array $carfo_details
     * @param array $res
     * @param string $constraints
     * @param array $ord
     * @param string $date
     */
    private function getOrderDetails(array &$order_ids, array $carfo_details, array $res, string $constraints, array $ord, string $date) : void
    {
        $carrier_id         = $res['carrier_id'];
        $vehicle_type       = $res['vehicle_type'];
        $driver_id          = $res['driver_id'];

        $checkauto = $this->checkcargofir_autorout($carfo_details, $res);

        if ($checkauto == 'yes' || $constraints == 'yes') {
            $order_ids[] = ['order_id' => $ord['id'], 'date' => strtotime($date), 'booking_id' => $ord['order_id'], 'vehicle_type' => $vehicle_type, 'vendor_id' => $carrier_id, 'driver_id' => $driver_id, 'templateId' => $res['template_id']];
        }
    }

    /**
     * @param string $pick_type
     * @param string $pick_val
     * @param string $deli_type
     * @param string $deli_val
     * @return string[]
     */
    private function getWhereForOrderDetails(string $pick_type, string $pick_val, string $deli_type, string $deli_val): array
    {
        $pwhr = $dwhr = "";
        $getCountryDetails = [];
        if (strtoupper($pick_type) == 'COUNTRY') {
            $getCountryDetails = $this->common->gettblrowdata("(country_code='" . $pick_val . "' OR country_name='" . $pick_val . "') AND status=1", "country_name,country_code", "tbl_country_master", 0, 0);
            if (!empty($getCountryDetails)) {
                $countryCode = $getCountryDetails['country_code'];
                $countryName = $getCountryDetails['country_name'];
                $pwhr = "o.pickup_country IN ('" . implode("', '", [$countryName, $countryCode]) . "') ";
            } else {
                $pwhr = "o.pickup_country = '" . $pick_val . "' ";
            }
        }
        if (strtoupper($pick_type) == 'CITY') {
            $pwhr = "o.pickup_city = '" . $pick_val . "' ";
        }
        if (strtoupper($pick_type) == 'STATE') {
            $pwhr = "o.pickup_address2 = '" . $pick_val . "' ";
        }
        if (strtoupper($pick_type) == 'ZIPCODE') {
            $pwhr = "o.pickup_pincode = '" . $pick_val . "' ";
        }
        if (strtoupper($deli_type) == 'COUNTRY') {
            if ($pick_val != $deli_val) {
                $getCountryDetails = $this->common->gettblrowdata("(country_code='" . $deli_val . "' OR country_name='" . $deli_val . "') AND status=1", "country_name,country_code", "tbl_country_master", 0, 0);
            }
            if (!empty($getCountryDetails)) {
                $countryCode = $getCountryDetails['country_code'];
                $countryName = $getCountryDetails['country_name'];
                $dwhr = "o.delivery_country IN ('" . implode("', '", [$countryName, $countryCode]) . "') ";
            } else {
                $dwhr = "o.delivery_country = '" . $deli_val . "' ";
            }
        }
        if (strtoupper($deli_type) == 'CITY') {
            $dwhr = "o.delivery_city = '" . $deli_val . "' ";
        }
        if (strtoupper($deli_type) == 'STATE') {
            $dwhr = "o.delivery_address2 = '" . $deli_val . "' ";
        }
        if (strtoupper($deli_type) == 'ZIPCODE') {
            $dwhr = "o.delivery_pincode = '" . $deli_val . "' ";
        }

        return [$pwhr, $dwhr];
    }
}
