<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Shippeopositions extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model("common");
        $this->load->library(['Shippeotokengeneration', 'uuid', 'Shippeopositionsevent']);
    }

    /**
     *  Description: Whenever an Order Status is changed in Mass Status Update then this
     *  function will trigger Shippeo GPS Service Calls.
     */

    function index(): void
    {
        $this->isshippeovalidtoken();
        echo "<table style='font-family: arial,sans-serif;border-collapse: collapse;width: 100%;'>";
        echo "<tr>";
        echo "<th style='width:36%;border: 1px solid #dddddd;text-align: left;padding: 8px;'> Truck_Number</td>";
        echo "<th style='width:36%;border: 1px solid #dddddd;text-align: left;padding: 8px;'>Latitude</td>";
        echo "<th style='width:36%;border: 1px solid #dddddd;text-align: left;padding: 8px;'>Longitude</td>";
        echo "</tr>";
        echo "</table>";
        $this->shippeopositionsevent->shippeo_position_event_call($this->uuid->v4(), '', date('Y-m-d H:i:s'));
    }

    /**
     * It will check Shippeotoken validation
     */
    function isshippeovalidtoken(): void
    {
        $chktoken = $this->common->shippeotoken(SHIPPEOTOKENVALIDITY);
        if (!empty($chktoken)) {
            $this->shippeotokengeneration->shippeotokenUpdate();
        }
    }
}
