<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

use App\Authorization\Authorization;


class Smtccustorders extends CI_Controller
{

    /** @var CodeIgniterAuthorization $codeigniterauthorization */
    public $codeigniterauthorization;

    public function __construct()
    {
        parent::__construct();
        $this->load->library(['CodeIgniterAuthorization','session','form_validation','email','statusintigration','ratemanagement']);
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        if($this->session->userdata('company_code') == 'NZKN'){
           redirect('NZGENorders');
        }
        if($this->session->userdata('subcustomer') == '1'){
            redirect('Smtcsubcustorders');
        }
        $this->load->model(['smtcorder','common','Order','DeliveryDocumentModel']);
        if (!checkUrlAccessForUser('SMTCCUSTORDERS')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index($id =null)
    {
        if($id != ""){
            $this->orderslist($id);
        }else{
            $this->orderslist();
        }
    }

    public function orderslist($id =null){
        $data['page_title'] = $this->lang->line('order_list');
        $data['sub_title']  = $this->lang->line('menu_orders');
        $order              = $country_userids = array();
        $userid             = $this->session->userdata("user_id");
        $custid             = $this->session->userdata("cust_id");
        $country_userids    = $this->session->userdata("country_user_ids");
        $whr = $searchids = array();
        $post = array();
        if($id != ""){
            $searchids = array($id);
            $post['bookingid'] = array();
            $getbooking_id = $this->common->gettblrowdata(array('id'=>$id),"order_id","tb_orders",0,0);
            if(!empty($getbooking_id)){
                $post['bookingid'] = array($getbooking_id['order_id']);
            }
            $data['getbookingid'] = $post['bookingid'];
        }
        $status_search  = "";
        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
            $post = $this->input->post(NULL,TRUE);
        }
        if (!empty($post)) {
            $whr = $this->searchorders($post);
            $order_status = isset($post['status']) ? $post['status'] :"";
            $status_search = $order_status;
            $ad_orderstatus = isset( $post['order_status'] ) ? $post['order_status'] : "";
            if ( $status_search == "" ) {
                $status_search = $ad_orderstatus;
            }
            $searchids = isset($post['bookingid']) ? $post['bookingid'] : array();
			 /* container number search  */
         if(empty($searchids) && isset($post['container_no']) && !empty($post['container_no'])){
             /* get Order booking ids by using container number */
            $searchids = $this->GetContainernum();
         }
         elseif(!empty($searchids) && isset($post['container_no']) && !empty($post['container_no'])){
             $container_num_arr=$this->GetContainernum();
             $searchids=array_intersect($container_num_arr,$searchids);
         }

            $company_code = $this->session->userdata('company_code');
            $branch_code = $this->session->userdata('branch_code');
            $subcusts = array();
            if($this->session->userdata('sub_cust')){
                $subcusts = $this->session->userdata('sub_cust');
                if(!empty($subcusts)){
                  array_push($subcusts, $custid);
                }else{
                     $subcusts = array($custid);
                }
            }else{
                 $subcusts = array($custid);
            }
            $searchshipper_id = isset($post['searchshipper_id']) ? $post['searchshipper_id'] : "";
            if($searchshipper_id != ""){
                $shipper_orders = $this->smtcorder->getorders_bypartymaster('Shipper',$searchshipper_id,$user_id,$country_userids,$subcusts,$custid);
                if(!empty($shipper_orders)){
                    array_merge($shipper_orders,$searchids);
                }
            }
            $searchconsignee_id = isset($post['searchconsignee_id']) ? $post['searchconsignee_id'] : "";
            if($searchconsignee_id != ""){
                $consignee_orders = $this->smtcorder->getorders_bypartymaster('Consignee',$searchconsignee_id,$user_id,$country_userids,$subcusts,$custid);
                if(!empty($consignee_orders)){
                    array_merge($searchids,$consignee_orders);
                }
            }
            $response = $this->smtcorder->getorderdata('0', $searchids, $status_search, $custid, $country_userids, $whr, $subcusts);
            $ordersData = $response['orders'] ?? [];
            if (!empty($ordersData)) {
                $undefinedVariables = [
                    'reference_value',
                    'invoice_details',
                    'secondweight_uom',
                    'secondvolume_uom',
                    'second_weight',
                    'second_volume',
                    'totwg',
                    'totvol',
                    'totqty',
                    'delivered_time'
                ];
                foreach ($ordersData as $res) {
                    foreach ($undefinedVariables as $eachVar) {
                        if (!isset($res[$eachVar])) {
                            $res[$eachVar] = '';
                        }
                    }
                    $orderIds[] = $res['id'];
                    $trip_no = $res['shipmentid'];
                    if($trip_no == '0'){
                        $trip_no = "";
                    }
                    $trip_sts = $res['trip_sts'];
                    $otherstatus = $res['order_status'];
                    $trip_id = $res['trip_id'];
                    $created_source = $res['created_source'];
                    $order_status = 'PENDING';
                    if($trip_id != 0 && $trip_sts == 0){
                        $order_status = 'ACTIVE';
                    }
                    if($trip_id != 0 && $trip_sts == 1){
                        $order_status = 'CLOSED';
                    }
                    $otherstatus = strtoupper($res['order_status']);
                    if($otherstatus == ""){
                        $chkdetails = $this->db->select("order_status")->get_where("tb_order_details",array('order_row_id'=>$res['id']));
                        if($chkdetails->num_rows() >0){
                            $otherstatus = $chkdetails->row()->order_status;
                        }
                    }
                    if($otherstatus == 'READY'){
                        $otherstatus = 'READY';
                    }else if($otherstatus == 'INVOICE'){
                        $otherstatus = 'INVOICE';
                    }else{
                        $otherstatus = "";
                    }
                    $manifestno = $delivery_note = $container_no = $referenceData = $loadplanconnote = "";
                    if ( isset( $res['reference_value'] ) ) {
                        $referenceData = $res['reference_value'];
                    }
                    if ( $referenceData != '' ) {
                        $referenceDataArray = explode( '?????', $referenceData );
                        if ( ! empty( $referenceDataArray ) && sizeof( $referenceDataArray ) > 0 ) {
                            foreach ( $referenceDataArray as $eachRefData ) {
                                $reqArray = $this->giveReferenceParameters( $eachRefData );
                                if ( $reqArray['type'] == "CTR" ) {
                                    $container_no = $reqArray['value'];
                                } else if ( $reqArray['type'] == "DQ" ) {
                                    $delivery_note = $reqArray['value'];
                                } else if ( $reqArray['type'] == "LPC" ) {
                                    $loadplanconnote = $reqArray['value'];
                                }
                            }
                        }
                    }
                    $chkdate = '2020-07-01 00:00:00';
                    $createdon = $res['createdon'];
                    $order_str = strtotime($createdon);
                    $chk_str = strtotime($chkdate);
                    $early_pickup = $res['pickup_datetime'];

                    $early_delivery = $res['delivery_datetime'];
                    $curtz = $this->session->userdata("usr_tzone")['timezone'];
                    if($order_str > $chk_str){
                        if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00"){
                            $epickup = getdatetimebytimezone($curtz,$early_pickup,DFLT_TZ);
                            $early_pickup = $epickup['datetime'];
                        }
                        if($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00"){
                            $edelivery = getdatetimebytimezone($curtz,$early_delivery,DFLT_TZ);
                            $early_delivery = $edelivery['datetime'];
                        }
                    }
                    $order[] = [
                        'order_row_id' => $res['id'],
                        'order_id' => $res['order_id'],
                        'delivery_note' => $delivery_note,
                        'pickup' => $res['pickup'],
                        'delivery' => $res['delivery'],
                        'trip_no' => $trip_no,
                        'order_status' => $order_status,
                        'transport_mode' => $res['transport_mode'],
                        'createdon' => $res['createdon'],
                        'total_packages' => round($res['totqty']),
                        'weight' => $res['totwg'],
                        'volume' => $res['totvol'],
                        'company_code' => $res['company_code'],
                        'branch_code' => $res['branch_code'],
                        'otherstatus' => $otherstatus,
                        'delivery_date' => $early_delivery,
                        'pickup_date' => $early_pickup,
                        'container_no' => $container_no,
                        'loadplanconnote' => $loadplanconnote,
                        'created_source' => $created_source,
                        'costCenter' => $res['type_name'] ?? ""
                    ];
                }
            }
        }
        $invoice = $this->Order->getNZCustomerOrderRevenues($orderIds ?? [], $this->session->userdata("usr_tzone")['currency']);
        $data['order'] = $order;
        $data['invoice'] = $invoice;
        $this->newtemplate->dashboard("smtccustorders/order", $data);
    }

    public function giveReferenceParameters( $referenceParam ) {
        $finalArray = array();
        if ( ! empty( $referenceParam ) && $referenceParam != '' ) {
            $requiredArray = explode( '=====', $referenceParam );
            if ( ! empty( $requiredArray ) && sizeof( $requiredArray ) > 0 ) {
                $finalArray['type']  = isset( $requiredArray[0] ) ? trim( $requiredArray[0] ) : "";
                $finalArray['value'] = isset( $requiredArray[1] ) ? trim( $requiredArray[1] ) : "";
            }
        }

        return $finalArray;
    }

    public function searchorders($post)
    {
        $whr = array();
        $session_user_id = $this->session->userdata('user_id');
        $session_company_code = $this->session->userdata('company_code');
        $cdate = date('Y-m-d H:i:s');
        if (isset($post['fromdate']) && $post['fromdate'] != "") {
            $fromdate                                      = date('Y-m-d', strtotime($post['fromdate']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate;
            if(isset($post['todate'])){
                if($post['todate'] == ""){
                    $todate = date('Y-m-d', strtotime($cdate));
                    $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
                }
            }else{
                $todate = date('Y-m-d', strtotime($cdate));
                $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
            }
        }
        if (isset($post['todate']) && $post['todate'] != "") {
            $todate                                        = date('Y-m-d', strtotime($post['todate']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
        }
        if (isset($post['order_id']) && $post['order_id'] != "") {
            $whr['o.order_id'] = $post['order_id'];

        }
        if (isset($post['searchcustomer_id']) && $post['searchcustomer_id'] != "") {
            $getcustomer_id = $this->db->select("id")->get_where("tb_customers",array('code'=>$post['searchcustomer_id']));
            if($getcustomer_id->num_rows() >0){
                $whr['o.customer_id'] = $getcustomer_id->row()->id;
            }
        }
        if (isset($post['service']) && $post['service'] != "") {
            $whr['d.service'] = $post['service'];

        }
        if (isset($post['order_type']) && $post['order_type'] != "") {
            $whr['d.order_type'] = $post['order_type'];

        }
        if (isset($post['product']) && $post['product'] != "") {
            $whr['o.product'] = $post['product'];

        }
        if (isset($post['modeof_trasnport']) && $post['modeof_trasnport'] != "") {
            $whr['o.transport_mode'] = $post['modeof_trasnport'];

        }
        /*if (isset($post['searchshipper_id']) && $post['searchshipper_id'] != "") {
            $whr['o.pickup_custid'] = $post['searchshipper_id'];

        }
        if (isset($post['searchconsignee_id']) && $post['searchconsignee_id'] != "") {
            $whr['o.drop_custid'] = $post['searchconsignee_id'];

        }*/
        if (isset($post['trip_id']) && $post['trip_id'] != "") {
            $whr['o.shipmentid'] = $post['trip_id'];

        }
        if (isset($post['delivery_note']) && $post['delivery_note'] != "") {
           $getdelivery_noteid = $this->db->select("order_id")->get_where("tb_order_references",array('ref_value'=>$post['delivery_note'],'status'=>'1','reference_id'=>'DQ'));
            if($getdelivery_noteid->num_rows() >0){
                $order_id = $getdelivery_noteid->row()->order_id;
                $whr['o.id'] = $order_id;
            }
        }
        /* if (isset($post['container_no']) && $post['container_no'] != "") {
            $getcontainer_no = $this->db->select("order_id")->get_where("tb_order_references",array('ref_value'=>$post['container_no'],'status'=>'1','reference_id'=>'CTR'));
            if($getcontainer_no->num_rows() >0){
                $order_id = $getcontainer_no->row()->order_id;
                $whr['o.id'] = $order_id;
            }else{
                $whr['o.id'] = '0';
            }
        } */
        if (isset($post['purchase_order']) && $post['purchase_order'] != "") {
            $getpo = $this->db->query( "SELECT o.id FROM tb_orders o,tb_order_references r WHERE o.id = r.order_id AND o.company_code LIKE '" . $session_company_code . "' AND o.status !=0 AND r.reference_id LIKE 'PO' AND r.ref_value ='" . $post['purchase_order'] . "' AND r.Status='1'" );
            if ( $getpo->num_rows() > 0 ) {
                $order_id    = $getpo->row()->id;
                $whr['o.id'] = $order_id;
            } else {
                $whr['o.id'] = '0';

            }
        }

        if ( isset( $post['load_plan_connote'] ) && $post['load_plan_connote'] != "" ) {
            $getpo = $this->db->query( "SELECT o.id FROM tb_orders o,tb_order_references r WHERE o.id = r.order_id AND o.company_code LIKE '" . $session_company_code . "' AND o.status !=0 AND r.reference_id LIKE 'LPC' AND r.ref_value ='" . $post['load_plan_connote'] . "'" );
            if ( $getpo->num_rows() > 0 ) {
                $order_id    = $getpo->row()->id;
                $whr['o.id'] = $order_id;
            } else {
                $whr['o.id'] = '0';

            }
        }

        if (isset($post['company_code']) && $post['company_code'] != "") {
            $whr['o.company_code'] = $post['company_code'];

        }
        if (isset($post['branch_code']) && $post['branch_code'] != "") {
            $whr['o.branch_code'] = $post['branch_code'];

        }
        if (isset($post['from_date']) && $post['from_date'] != "") {
            $from_date                                     = date('Y-m-d', strtotime($post['from_date']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $from_date;

        }
        if (isset($post['todate']) && $post['todate'] != "") {
            $todate                                        = date('Y-m-d', strtotime($post['todate']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;

        }
        return $whr;

    }

    public function neworder()
    {
        $data             = $transport             = array();
        $user_id          = $this->session->userdata('user_id');
        $company_code     = $this->session->userdata('company_code');
        $branch_code      = $this->session->userdata('branch_code');
        $transport = gettransportmode();
        $data['transport']    = $transport;
        $data['company_code'] = $company_code;
        $data['branch_code']  = $branch_code;
        $pickup_details = $shipper_details = $consignee_details = array();
        $custid               = $this->session->userdata('cust_id');
        /*if ($custid != "") {
            $getpickupdetails = $this->smtcorder->getpickupdetails($custid);
            if ($getpickupdetails->num_rows() > 0) {
                $pickup_details = array('id' => $getpickupdetails->row()->id, 'name' => $getpickupdetails->row()->name, 'party_id' => $getpickupdetails->row()->code, 'address' => $getpickupdetails->row()->address, 'pincode' => $getpickupdetails->row()->pincode, 'country' => $getpickupdetails->row()->country);
            }
        }*/

        $ordertypes             = array();
        if ($custid != "") {
            $getpickupdetails = $this->smtcorder->getpickupdetails($custid);
            if ($getpickupdetails->num_rows() > 0) {
                $pickup_details = array('id' => $getpickupdetails->row()->id, 'name' => $getpickupdetails->row()->name, 'party_id' => $getpickupdetails->row()->code, 'address' => $getpickupdetails->row()->address, 'pincode' => $getpickupdetails->row()->pincode, 'country' => $getpickupdetails->row()->country);
            }
            $getorders = $this->db->select("id,type_name")->get_where("tb_order_types", array('customer_id' => $custid,'company_code'=>$company_code,'status'=>'1'));
            if ($getorders->num_rows() > 0) {
                foreach ($getorders->result() as $res) {
                    $ordertypes[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
                }
            }else{
                $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types",array('company_code'=>$company_code,"status"=>1));
                if($getorders->num_rows() >0){
                  foreach($getorders->result() as $res){
                    $ordertypes[] = array('type_id'=>$res->id,'type_name'=>$res->type_name);
                }
            }else{
              $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types",array('company_code'=>"SGKN","status"=>1));
              if($getorders->num_rows() >0){
                foreach($getorders->result() as $res){
                  $ordertypes[] = array('type_id'=>$res->id,'type_name'=>$res->type_name);
              }
          }
      }
  }
}else{

    $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types",array('company_code'=>$company_code,"status"=>1));
    if($getorders->num_rows() >0){
      foreach($getorders->result() as $res){
        $ordertypes[] = array('type_id'=>$res->id,'type_name'=>$res->type_name);
    }
}else{
  $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types",array('company_code'=>"SGKN","status"=>1));
  if($getorders->num_rows() >0){
    foreach($getorders->result() as $res){
      $ordertypes[] = array('type_id'=>$res->id,'type_name'=>$res->type_name);
  }
}
}

}
$roles = array();
$qyery=$this->db->query("SELECT id,name FROM tbl_party_types WHERE user_id= '".$user_id."' AND status=1 GROUP BY name");
if($qyery->num_rows() >0){
    foreach($qyery->result() as $res){
        $roles[] = array('id'=>$res->id,'name'=>$res->name);
    }
}
 $data['pickup_details'] = $pickup_details;
 $data['shipper_details'] = $shipper_details;
 $data['consignee_details'] = $consignee_details;
$data['ordertypes'] = $ordertypes;
$data['roles'] = $roles;
$this->newtemplate->dashboard('smtccustorders/neworder', $data);
}

public function copyorder($id = NULL) {
    $data = $order_types = array();
    $order_details = $shipper_details = $reference_details = $drop_details = $shipper_data = $consignee_data = $pickup_details = $delivery_data = $delivery_array = $chargecodes = array();
    $chkpickup = $chkdelivery = $chkshipper = $chkconsignee = $gen_shipper_id = $gen_consignee_id = 0;

    $order_details['type_name'] = $order_details['ordtype_code'] = "";
    if ($id != "") {
        $chkorder = $this->smtcorder->getordertoedit($id);
        if ($chkorder->num_rows() > 0) {
            $incoterm    = $chkorder->row()->incoterm;
            $shipment_id = "";
            if ($shipment_id != "" && $shipment_id != 0) {
                $getshipment_number = $this->db->select("shipid")->get_where("tb_shipments", array('id' => $shipment_id));
                if ($getshipment_number->num_rows() > 0) {
                    $shipment_id = $getshipment_number->row()->shipid;
                }
            }
            $pickup_custid = $chkorder->row()->pickup_custid;
            $status = $chkorder->row()->status;
            $trip_id = $chkorder->row()->trip_id;
            $trip_sts = $chkorder->row()->trip_sts;
            $order_status = "PENDING";
            /*if($trip_id != 0 && $trip_sts == 0){
                $order_status = 'ACTIVE';
            }
            if($trip_id != 0 && $trip_sts == 1){
                $order_status = 'CLOSED';
            }*/
            $chkdate = '2020-07-01 00:00:00';
            $createdon = $chkorder->row()->createdon;
            $order_str = strtotime($createdon);
            $chk_str = strtotime($chkdate);
            $early_pickup = $chkorder->row()->pickup_datetime;

            $early_delivery = $chkorder->row()->delivery_datetime;
            $late_pickup = $chkorder->row()->pickup_endtime;
            $late_delivery = $chkorder->row()->drop_endtime;
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            if($order_str > $chk_str){
                if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00"){
                    $epickup = getdatetimebytimezone($curtz,$early_pickup,DFLT_TZ);
                    $early_pickup = $epickup['datetime'];
                }
                if($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00"){
                    $edelivery = getdatetimebytimezone($curtz,$early_delivery,DFLT_TZ);
                    $early_delivery = $edelivery['datetime'];
                }
                if($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00"){
                    $lpickup = getdatetimebytimezone($curtz,$late_pickup,DFLT_TZ);
                    $late_pickup = $lpickup['datetime'];
                }
                if($late_delivery != "" && $late_delivery != "0000-00-00 00:00:00"){
                    $ldelivery = getdatetimebytimezone($curtz,$late_delivery,DFLT_TZ);
                    $late_delivery = $ldelivery['datetime'];
                }

            }
            $order_details = array('id' => $chkorder->row()->id,
            'order_id' => $chkorder->row()->order_id, 'shipment_id' => $shipment_id, 'early_pickup' => $early_pickup, 'early_delivery' => $early_delivery, 'late_pickup' => $late_pickup, 'late_delivery' => $late_delivery, 'product' => $chkorder->row()->product, 'service' => $chkorder->row()->service, 'delivery_term' => $chkorder->row()->delivery_term,
            'incoterm' => $chkorder->row()->incoterm, 'delivery_note' => $chkorder->row()->delivery_note,
            'purchase_order' => "",
            'notify_party' => $chkorder->row()->notify_party,
            'goods_value' => $chkorder->row()->goods_value,
            'lane_reference' => $chkorder->row()->lane_reference,
            'distance' => $chkorder->row()->distance, 'customs_required' => $chkorder->row()->customs_required,
            'high_cargo_value' => $chkorder->row()->high_cargo_value,
            'valorance_insurance' => $chkorder->row()->valorance_insurance,
            'temperature_control' => $chkorder->row()->temperature_control,
            'company_code' => $chkorder->row()->company_code, 'branch_code' => $chkorder->row()->branch_code, 'department_code' => $chkorder->row()->department_code,
            'createdon' => $chkorder->row()->createdon, 'order_type' => $chkorder->row()->order_type, 'transport_mode' => $chkorder->row()->transport_mode,
            'shipper_id' => $chkorder->row()->o_shipper_id,'consignee_id' => $chkorder->row()->consignee_id,'pickup_custid' => $chkorder->row()->pickup_custid,'drop_custid' => $chkorder->row()->drop_custid,
        );
    $order_details['order_status'] = $order_status;
    $o_shipper_id = $chkorder->row()->o_shipper_id;
    if($o_shipper_id >0){
        $gen_shipper_id = $o_shipper_id;
    }
    $o_consignee_id = $chkorder->row()->consignee_id;
    if($o_consignee_id >0){
        $gen_consignee_id = $o_consignee_id;
    }
    if ($incoterm != '') {
        $delivery_array = getDeliverytermsbyIncoterm($incoterm);
    }
    $pickup_id    = $chkorder->row()->customer_id;
    $company_code = $this->session->userdata('company_code');
    if ($company_code != "") {
        $company_code = $chkorder->row()->company_code;
    }
    $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('customer_id' => $pickup_id,'company_code'=>$company_code,'status'=>'1'));
    if ($getorders->num_rows() > 0) {
        foreach ($getorders->result() as $res) {
            $order_types[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
        }
    }else{
        $getorder_types = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('company_code' => $company_code, 'status' => 1));
        if ($getorder_types->num_rows() > 0) {
            foreach ($getorder_types->result() as $res) {
                $order_types[] = array('type_name' => $res->type_name, 'type_id' => $res->id);
            }
        }else{
            $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types",array('company_code'=>"SGKN","status"=>1));
            if($getorders->num_rows() >0){
                foreach($getorders->result() as $res){
                    $order_types[] = array('type_id'=>$res->id,'type_name'=>$res->type_name);
                }
            }
        }
    }
    $getpickupid = $this->db->select("id")->get_where("tbl_party_master", array(
        "code" => $chkorder->row()->pickup_custid
    ), 1, 0);
    if ($getpickupid->num_rows() > 0) {
    $order_details['pickup_id'] = $getpickupid->row()->id;
    }
    $getdropid = $this->db->select("id")->get_where("tbl_party_master", array(
        "code" => $chkorder->row()->drop_custid
    ), 1, 0);
    if ($getdropid->num_rows() > 0) {
    $order_details['drop_id'] = $getdropid->row()->id;
    }
    $getpickupdetails = $this->smtcorder->getpickupdetails($pickup_id);
    if ($getpickupdetails->num_rows() > 0) {
        $pickup_details = array('id' => $getpickupdetails->row()->id, 'name' => $getpickupdetails->row()->name, 'party_id' => $getpickupdetails->row()->code, 'address' => $getpickupdetails->row()->address, 'pincode' => $getpickupdetails->row()->pincode, 'country' => $getpickupdetails->row()->country);
    }
$drop_id        = $chkorder->row()->drop_custid;
$drop_row_id    = 0;
$party_row_ids = array();
$chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
    if($chekparty->num_rows() >0){
        foreach($chekparty->result() as $rr){

        $ptype = $rr->party_type;
        $chktype = $this->db->select("name")->get_where("tbl_party_types", array(
            "id" => $ptype
        ), 1, 0);
        if ($chktype->num_rows() > 0) {

            if (strtoupper($chktype->row()->name) == "CONSIGNEE") {
                $chkconsignee = 1;
                $gen_consignee_id = $rr->id;
                if($chkdelivery == 0){
                    $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                }
            } else if (strtoupper($chktype->row()->name) == "SHIPPER") {
                $chkshipper = 1;
                $gen_shipper_id = $rr->id;
                if($chkpickup == 0){
                    $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                }
            }else if (strtoupper($chktype->row()->name) == "DELIVERY") {
                $chkdelivery = 1;
                $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                if($gen_consignee_id >0){
                }else{
                    $gen_consignee_id = $rr->id;
                }
            }else if (strtoupper($chktype->row()->name) == "PICKUP") {
                $chkpickup = 1;
                $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                if($gen_shipper_id > 0){
                }else{
                    $gen_shipper_id = $rr->id;
                }
            }else if (strtoupper($chktype->row()->name) == "CARRIER"){
            }else{
            $party_row_ids[] = $rr->id;
        }
           }
       }
   }
   if($gen_shipper_id >0){
    $getshipperdetails = $this->smtcorder->getpartydetailsbyid($gen_shipper_id);
    if ($getshipperdetails->num_rows() > 0) {
        $shipper_data = array('id' => $getshipperdetails->row()->id,'name' => $getshipperdetails->row()->name, 'party_id' => $getshipperdetails->row()->code,'address' => $getshipperdetails->row()->address,'pincode' => $getshipperdetails->row()->pincode,'country' => $getshipperdetails->row()->country);
    }
}
if($gen_consignee_id >0){
    $getconsigneedetails = $this->smtcorder->getpartydetailsbyid($gen_consignee_id);
    if ($getconsigneedetails->num_rows() > 0) {
        $consignee_data = array('id' => $getconsigneedetails->row()->id,'name' => $getconsigneedetails->row()->name,'party_id' => $getconsigneedetails->row()->code,'address' => $getconsigneedetails->row()->address,'pincode' => $getconsigneedetails->row()->pincode,'country' => $getconsigneedetails->row()->country);
    }
}
   $shipper_details['name'] = $chkorder->row()->pickup;
   $shipper_details['street'] = $chkorder->row()->pickup_address1;
   $shipper_details['state'] = $chkorder->row()->pickup_address2;
   $shipper_details['city'] = $chkorder->row()->pickup_city;
   $shipper_details['country'] = $chkorder->row()->pickup_country;
   $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;

   $drop_details['name'] = $chkorder->row()->delivery;
   $drop_details['street'] = $chkorder->row()->delivery_address1;
   $drop_details['state'] = $chkorder->row()->delivery_address2;
   $drop_details['city'] = $chkorder->row()->delivery_city;
   $drop_details['country'] = $chkorder->row()->delivery_country;
   $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
   $drop_id = $chkorder->row()->drop_custid;
}

$user_id = $this->session->userdata('user_id');
$roles = array();
$qyery=$this->db->query("SELECT id,name FROM tbl_party_types WHERE user_id= '".$user_id."' AND status=1 GROUP BY name");
if($qyery->num_rows() >0){
    foreach($qyery->result() as $res){
        $roles[] = array('id'=>$res->id,'name'=>$res->name);
    }
}
$getchargecodes = $this->db->select("id,charge_code")->get_where("tb_charge_codes", array('status' => '1'));
if ($getchargecodes->num_rows() > 0) {
    foreach ($getchargecodes->result() as $res) {
        $chargecodes[] = array('charge_id' => $res->id, 'charge_code' => $res->charge_code);
    }
}
$cdate = date('Y-m-d H:i:s');
$cargo_row_ids = array();
$qry = $this->db->query("SELECT c.* FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='" . $id . "' AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC");
if ($qry->num_rows() > 0) {
    foreach ($qry->result() as $res) {
        $stackable = 'Off';
        if ($res->stackable == 0) {
            $stackable = 'Off';
        } else if ($res->stackable == 1) {
            $stackable = 'On';
        }
        $cargo_ins = array('cargo_type' => $res->cargo_type, 'goods_description' => $res->goods_description, 'quantity' => $res->quantity, 'length' => $res->length, 'length_unit' => $res->length_unit, 'width' => $res->width, 'width_unit' => $res->width_unit, 'height' => $res->height, 'height_unit' => $res->height_unit, 'weight' => $res->weight, 'weight_unit' => $res->weight_unit, 'volume' => $res->volume, 'volume_unit' => $res->volume_unit, 'stackable' => $res->stackable,'volumetric_weight'=>$res->volumetric_weight,'volweight_uom'=>$res->volweight_uom, 'createdby' => $user_id, 'createdon' => $cdate,'ldm'=>$res->ldm,'second_weight'=>$res->second_weight,'second_volume'=>$res->second_volume,'secondvolume_uom'=>$res->secondvolume_uom,'secondweight_uom'=>$res->secondweight_uom,'marks_numbers'=>$res->marks_numbers);
        $ins_cargo = $this->db->insert("tb_cargo_details",$cargo_ins);
        $cargo_row_ids[] = $this->db->insert_id();
        /*   array_push($ids,$cargo_row_id);*/
    }
}

}
$transport        = array();
$transport = gettransportmode();
$cargo_id = "";
if(!empty($cargo_row_ids)){
    $cargo_id = implode(',', $cargo_row_ids);
} $party_id = "";
if(!empty($party_row_ids)){
    $party_id = implode(',', $party_row_ids);
}
$order_details['cargo_id'] = $cargo_id;
$order_details['party_id'] = $party_id;
$data['transport']         = $transport;
$data['order_details']     = $order_details;
$data['pickup_details']    = $pickup_details;
$data['drop_details']      = $drop_details;
$data['shipper_details']   = $shipper_details;
$data['reference_details'] = $reference_details;
$data['order_types']       = $order_types;
$data['delivery_array']    = $delivery_array;
$data['chargecodes']       = $chargecodes;
$data['roles']             = $roles;
$data['shipper_data'] = $shipper_data;
$data['consignee_data'] = $consignee_data;
$data['order_type_flag'] = 'copy';

$this->newtemplate->dashboard('smtccustorders/copyorder', $data);
}

public function reverseorder($id = null)
{
    $data = $order_types = array();
    $order_details = $shipper_details = $drop_details = $pickup_details = $reference_details = $delivery_array = $shipper_data = $consignee_data =  $chargecodes = array();
    $chkpickup = $chkdelivery = $chkshipper = $chkconsignee = $gen_shipper_id = $gen_consignee_id = 0;
    $order_details['type_name'] = $order_details['ordtype_code'] = "";
    if ($id != "") {
        $chkorder = $this->smtcorder->getordertoedit($id);
        if ($chkorder->num_rows() > 0) {
            $incoterm    = $chkorder->row()->incoterm;
            $shipment_id = "";
            if ($shipment_id != "" && $shipment_id != 0) {

                $getshipment_number = $this->db->select("shipid")->get_where("tb_shipments", array('id' => $shipment_id));
                if ($getshipment_number->num_rows() > 0) {
                    $shipment_id = $getshipment_number->row()->shipid;
                }
            }
            $pickup_custid = $chkorder->row()->pickup_custid;
            $status = $chkorder->row()->status;
            $trip_id = $chkorder->row()->trip_id;
            $trip_sts = $chkorder->row()->trip_sts;
            $order_status = "PENDING";
            /*if($trip_id != 0 && $trip_sts == 0){
                $order_status = 'ACTIVE';
            }
            if($trip_id != 0 && $trip_sts == 1){
                $order_status = 'CLOSED';
            }*/
            $chkdate = '2020-07-01 00:00:00';
            $createdon = $chkorder->row()->createdon;
            $order_str = strtotime($createdon);
            $chk_str = strtotime($chkdate);
            $early_pickup = $chkorder->row()->pickup_datetime;

            $early_delivery = $chkorder->row()->delivery_datetime;
            $late_pickup = $chkorder->row()->pickup_endtime;
            $late_delivery = $chkorder->row()->drop_endtime;
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            if($order_str > $chk_str){
                if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00"){
                    $epickup = getdatetimebytimezone($curtz,$early_pickup,DFLT_TZ);
                    $early_pickup = $epickup['datetime'];
                }
                if($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00"){
                    $edelivery = getdatetimebytimezone($curtz,$early_delivery,DFLT_TZ);
                    $early_delivery = $edelivery['datetime'];
                }
                if($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00"){
                    $lpickup = getdatetimebytimezone($curtz,$late_pickup,DFLT_TZ);
                    $late_pickup = $lpickup['datetime'];
                }
                if($late_delivery != "" && $late_delivery != "0000-00-00 00:00:00"){
                    $ldelivery = getdatetimebytimezone($curtz,$late_delivery,DFLT_TZ);
                    $late_delivery = $ldelivery['datetime'];
                }

            }
$order_details = array(
    'id' => $chkorder->row()->id,
    'order_id' => $chkorder->row()->order_id,'shipment_id' => $shipment_id,
    'early_pickup' => $early_pickup,
    'early_delivery' => $early_delivery,
    'late_pickup' => $late_pickup,
    'late_delivery' => $late_delivery,
    'product' => $chkorder->row()->product,
    'service' => $chkorder->row()->service,'delivery_term' => $chkorder->row()->delivery_term,
    'incoterm' => $chkorder->row()->incoterm,'delivery_note' => $chkorder->row()->delivery_note,
    'purchase_order' => "",
    'notify_party' => $chkorder->row()->notify_party,'goods_value' => $chkorder->row()->goods_value,'lane_reference' => $chkorder->row()->lane_reference,
    'distance' => $chkorder->row()->distance, 'customs_required' => $chkorder->row()->customs_required,
    'high_cargo_value' => $chkorder->row()->high_cargo_value,
    'valorance_insurance' => $chkorder->row()->valorance_insurance,
    'temperature_control' => $chkorder->row()->temperature_control,
    'company_code' => $chkorder->row()->company_code,
    'branch_code' => $chkorder->row()->branch_code,
    'department_code' => $chkorder->row()->department_code,
    'createdon' => $chkorder->row()->createdon, 'order_type' => $chkorder->row()->order_type, 'transport_mode' => $chkorder->row()->transport_mode,
    'shipper_id' => $chkorder->row()->o_shipper_id,
    'consignee_id' => $chkorder->row()->consignee_id,
    'pickup_custid' => $chkorder->row()->pickup_custid,
    'drop_custid' => $chkorder->row()->drop_custid,
);
$order_details['order_status'] = $order_status;
if ($incoterm != '') {
    $delivery_array = getDeliverytermsbyIncoterm($incoterm);
}
$o_shipper_id = $chkorder->row()->o_shipper_id;
    if($o_shipper_id >0){
        $gen_shipper_id = $o_shipper_id;
    }
    $o_consignee_id = $chkorder->row()->consignee_id;
    if($o_consignee_id >0){
        $gen_consignee_id = $o_consignee_id;
    }
$pickup_id = $chkorder->row()->customer_id;
$company_code = $this->session->userdata('company_code');
if ($company_code != "") {
    $company_code = $chkorder->row()->company_code;
}
$getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('customer_id' => $pickup_id,'company_code'=>$company_code,'status'=>'1'));
if ($getorders->num_rows() > 0) {
    foreach ($getorders->result() as $res) {
        $order_types[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
    }
}else{
    $getorder_types = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('company_code' => $company_code, 'status' => 1));
    if ($getorder_types->num_rows() > 0) {
        foreach ($getorder_types->result() as $res) {
            $order_types[] = array('type_name' => $res->type_name, 'type_id' => $res->id);
        }
    }else{
        $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types",array('company_code'=>"SGKN","status"=>1));
        if($getorders->num_rows() >0){
            foreach($getorders->result() as $res){
                $order_types[] = array('type_id'=>$res->id,'type_name'=>$res->type_name);
            }
        }
    }
}
$getpickupid = $this->db->select("id")->get_where("tbl_party_master", array(
    "code" => $chkorder->row()->pickup_custid
), 1, 0);
if ($getpickupid->num_rows() > 0) {
$order_details['pickup_id'] = $getpickupid->row()->id;
}
$getdeliveryid = $this->db->select("id")->get_where("tbl_party_master", array(
    "code" => $chkorder->row()->drop_custid
), 1, 0);
if ($getdeliveryid->num_rows() > 0) {
$order_details['drop_id'] = $getdeliveryid->row()->id;
}
$getpickupdetails = $this->smtcorder->getpickupdetails($pickup_id);
if ($getpickupdetails->num_rows() > 0) {
    $pickup_details = array(
        'id' => $getpickupdetails->row()->id,
        'name' => $getpickupdetails->row()->name,'party_id' => $getpickupdetails->row()->code,'address' => $getpickupdetails->row()->address,
        'pincode' => $getpickupdetails->row()->pincode,
        'country' => $getpickupdetails->row()->country);
}
$drop_id = $chkorder->row()->drop_custid;
$drop_row_id = $pickup = $drop = 0;
$party_row_ids = array();
$chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
if ($chekparty->num_rows() > 0) {
    foreach ($chekparty->result() as $rr) {

        $ptype = $rr->party_type;
        $chktype = $this->db->select("name")->get_where("tbl_party_types",array("id"=>$ptype),1,0);
        if ($chktype->num_rows() > 0) {
            if (strtoupper($chktype->row()->name) == "SHIPPER") {
                $chkshipper = 1;
                $gen_shipper_id = $rr->id;
                if($chkpickup == 0){
                    $pickup = $rr->id;
                    $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                }
            }else if (strtoupper($chktype->row()->name) == "CONSIGNEE") {
                $chkconsignee = 1;
                $gen_consignee_id = $rr->id;
                if($chkdelivery == 0){
                    $drop = $rr->id;
                    $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                }
            }else if (strtoupper($chktype->row()->name) == "PICKUP") {
                $chkpickup = 1;
                $pickup = $rr->id;
                $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                if($gen_shipper_id > 0){
                }else{
                    $gen_shipper_id = $rr->id;
                }
            }else if (strtoupper($chktype->row()->name) == "DELIVERY") {
                $chkdelivery = 1;
                $drop = $rr->id;
                $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                if($gen_consignee_id >0){
                }else{
                    $gen_consignee_id = $rr->id;
                }
            } else if (strtoupper($chktype->row()->name) == "CARRIER") {

            } else {
                $party_row_ids[] = $rr->id;
            }
        }
    }
}
$order_details['pickup_id'] = $pickup;
$order_details['drop_id'] = $drop;
if($gen_shipper_id >0){
        $getshipperdetails = $this->smtcorder->getpartydetailsbyid($gen_shipper_id);
        if ($getshipperdetails->num_rows() > 0) {
            $shipper_data = array('id' => $getshipperdetails->row()->id,'name' => $getshipperdetails->row()->name, 'party_id' => $getshipperdetails->row()->code,'address' => $getshipperdetails->row()->address,'pincode' => $getshipperdetails->row()->pincode,'country' => $getshipperdetails->row()->country);
        }
    }
    if($gen_consignee_id >0){
        $getconsigneedetails = $this->smtcorder->getpartydetailsbyid($gen_consignee_id);
        if ($getconsigneedetails->num_rows() > 0) {
            $consignee_data = array('id' => $getconsigneedetails->row()->id,'name' => $getconsigneedetails->row()->name,'party_id' => $getconsigneedetails->row()->code,'address' => $getconsigneedetails->row()->address,'pincode' => $getconsigneedetails->row()->pincode,'country' => $getconsigneedetails->row()->country);
        }
    }
$drop_details['name'] = $chkorder->row()->pickup;
$drop_details['street'] = $chkorder->row()->pickup_address1;
$drop_details['state'] = $chkorder->row()->pickup_address2;
$drop_details['city'] = $chkorder->row()->pickup_city;
$drop_details['country'] = $chkorder->row()->pickup_country;
$drop_details['pincode'] = $chkorder->row()->pickup_pincode;

$shipper_details['name'] = $chkorder->row()->delivery;
$shipper_details['street'] = $chkorder->row()->delivery_address1;
$shipper_details['state'] = $chkorder->row()->delivery_address2;
$shipper_details['city'] = $chkorder->row()->delivery_city;
$shipper_details['country'] = $chkorder->row()->delivery_country;
$shipper_details['pincode'] = $chkorder->row()->delivery_pincode;
$drop_id = $chkorder->row()->drop_custid;
}
$cust_parties = array();
if($chkpickup == 0 && $chkdelivery == 0){
    $cust_parties['0'] = 0;
    $cust_parties['1'] = 0;
    $cust_parties['2'] = $gen_shipper_id;
    $cust_parties['3'] = $gen_consignee_id;
}

if (!empty($cust_parties)) {
    subcustpartiesinsert($chkorder->row()->id, $chkorder->row()->order_id, $cust_parties);
}
$user_id = $this->session->userdata('user_id');
$roles = array();
$qyery=$this->db->query("SELECT id,name FROM tbl_party_types WHERE user_id= '".$user_id."' AND status=1 GROUP BY name");
if($qyery->num_rows() >0){
    foreach($qyery->result() as $res){
        $roles[] = array('id'=>$res->id,'name'=>$res->name);
    }
}
$getchargecodes = $this->db->select("id,charge_code")->get_where("tb_charge_codes", array('status' => '1'));
if ($getchargecodes->num_rows() > 0) {
    foreach ($getchargecodes->result() as $res) {
        $chargecodes[] = array('charge_id' => $res->id, 'charge_code' => $res->charge_code);
    }
}
$cdate = date('Y-m-d H:i:s');
$cargo_row_ids = array();
$qry = $this->db->query("SELECT c.* FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='" . $id . "' AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC");
if ($qry->num_rows() > 0) {
    foreach ($qry->result() as $res) {
        $stackable = 'Off';
        if ($res->stackable == 0) {
            $stackable = 'Off';
        } else if ($res->stackable == 1) {
            $stackable = 'On';
        }
        $cargo_ins = array('cargo_type' => $res->cargo_type, 'goods_description' => $res->goods_description, 'quantity' => $res->quantity, 'length' => $res->length, 'length_unit' => $res->length_unit, 'width' => $res->width, 'width_unit' => $res->width_unit, 'height' => $res->height, 'height_unit' => $res->height_unit, 'weight' => $res->weight, 'weight_unit' => $res->weight_unit, 'volume' => $res->volume, 'volume_unit' => $res->volume_unit, 'stackable' => $res->stackable,'volumetric_weight'=>$res->volumetric_weight,'volweight_uom'=>$res->volweight_uom, 'createdby' => $user_id, 'createdon' => $cdate,'ldm'=>$res->ldm,'second_weight'=>$res->second_weight,'secondweight_uom'=>$res->secondweight_uom,'second_volume'=>$res->second_volume,'secondvolume_uom'=>$res->secondvolume_uom,'marks_numbers'=>$res->marks_numbers);
        $ins_cargo = $this->db->insert("tb_cargo_details",$cargo_ins);
        $cargo_row_ids[] = $this->db->insert_id();
        /*   array_push($ids,$cargo_row_id);*/
    }
}

}
$transport        = array();
$transport = gettransportmode();
$cargo_id = "";
if(!empty($cargo_row_ids)){
    $cargo_id = implode(',', $cargo_row_ids);
} $party_id = "";
if(!empty($party_row_ids)){
    $party_id = implode(',', $party_row_ids);
}
$order_details['cargo_id'] = $cargo_id;
$order_details['party_id'] = $party_id;
$order_details['shipper_id'] = $gen_shipper_id;
$order_details['consignee_id'] = $gen_consignee_id;
$data['transport'] = $transport;
$data['order_details'] = $order_details;
$data['pickup_details'] = $pickup_details;
$data['drop_details'] = $drop_details;
$data['shipper_details'] = $shipper_details;
$data['reference_details'] = $reference_details;
$data['order_types'] = $order_types;
$data['delivery_array'] = $delivery_array;
$data['chargecodes'] = $chargecodes;
$data['roles'] = $roles;
$data['shipper_data'] = $shipper_data;
$data['consignee_data'] = $consignee_data;
$data['order_type_flag'] = 'reverse';

$this->newtemplate->dashboard('smtccustorders/copyorder', $data);
}


public function editorder($id = null)
{
    $data = $order_types = array();
    $order_details = $shipper_details = $shipper_data = $consignee_data = $drop_details = $pickup_details = $reference_details = $delivery_array = $chargecodes = array();
    $gen_shipper_id = $gen_consignee_id =  $chkpickup = $chkdelivery = $chkshipper = $chkconsignee = 0;
    $order_details['type_name'] = $order_details['ordtype_code'] = $purchase_order = "";
    if ($id != "") {
        $chkorder = $this->smtcorder->getordertoedit($id);
        if ($chkorder->num_rows() > 0) {
            $incoterm    = $chkorder->row()->incoterm;
            $shipment_id = $pickup_inst = $delivery_inst = $container_no = "";
            $getdnote = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id ='".$id."' AND reference_id IN ('DQ','ORD_DLVINST','ORD_PIKINST','CTR','PO')");
            if($getdnote->num_rows() >0){
                foreach($getdnote->result() as $ref){
                    $ref_id = $ref->reference_id;
                    if($ref_id == 'DQ'){
                        $shipment_id = $ref->ref_value;
                    }
                    if($ref_id == 'ORD_DLVINST'){
                        $delivery_inst = $ref->ref_value;
                    }
                    if($ref_id == 'ORD_PIKINST'){
                        $pickup_inst = $ref->ref_value;
                    }
                    if($ref_id == 'CTR'){
                        $container_no = $ref->ref_value;
                    }
                    if($ref_id == 'PO'){
                        $purchase_order = $ref->ref_value;
                    }

                }
            }
            $pickup_custid = $chkorder->row()->pickup_custid;
            $status = $chkorder->row()->status;
            $trip_id = $chkorder->row()->trip_id;
            $trip_sts = $chkorder->row()->trip_sts;
            $order_status = "PENDING";
            if($trip_id != 0 && $trip_sts == 0){
                $order_status = 'ACTIVE';
            }
            if($trip_id != 0 && $trip_sts == 1){
                $order_status = 'CLOSED';
            }
            $chkdate = '2020-07-01 00:00:00';
            $createdon = $chkorder->row()->createdon;
            $order_str = strtotime($createdon);
            $chk_str = strtotime($chkdate);
            $early_pickup = $chkorder->row()->pickup_datetime;

            $early_delivery = $chkorder->row()->delivery_datetime;
            $late_pickup = $chkorder->row()->pickup_endtime;
            $late_delivery = $chkorder->row()->drop_endtime;
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            if($order_str > $chk_str){
                if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00"){
                    $epickup = getdatetimebytimezone($curtz,$early_pickup,DFLT_TZ);
                    $early_pickup = $epickup['datetime'];
                }
                if($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00"){
                    $edelivery = getdatetimebytimezone($curtz,$early_delivery,DFLT_TZ);
                    $early_delivery = $edelivery['datetime'];
                }
                if($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00"){
                    $lpickup = getdatetimebytimezone($curtz,$late_pickup,DFLT_TZ);
                    $late_pickup = $lpickup['datetime'];
                }
                if($late_delivery != "" && $late_delivery != "0000-00-00 00:00:00"){
                    $ldelivery = getdatetimebytimezone($curtz,$late_delivery,DFLT_TZ);
                    $late_delivery = $ldelivery['datetime'];
                }

            }
            $order_details = array(
                'id' => $chkorder->row()->id,
                'order_id' => $chkorder->row()->order_id,
                'shipment_id' => $shipment_id, 'early_pickup' => $early_pickup, 'early_delivery' => $early_delivery, 'late_pickup' => $late_pickup, 'late_delivery' => $late_delivery, 'product' => $chkorder->row()->product, 'service' => $chkorder->row()->service, 'delivery_term' => $chkorder->row()->delivery_term,
                'incoterm' => $chkorder->row()->incoterm, 'delivery_note' => $chkorder->row()->delivery_note, 'purchase_order' => $purchase_order, 'notify_party' => $chkorder->row()->notify_party, 'goods_value' => $chkorder->row()->goods_value, 'lane_reference' => $chkorder->row()->lane_reference, 'distance' => $chkorder->row()->distance, 'customs_required' => $chkorder->row()->customs_required, 'high_cargo_value' => $chkorder->row()->high_cargo_value, 'valorance_insurance' => $chkorder->row()->valorance_insurance, 'temperature_control' => $chkorder->row()->temperature_control, 'company_code' => $chkorder->row()->company_code, 'branch_code' => $chkorder->row()->branch_code, 'department_code' => $chkorder->row()->department_code, 'createdon' => $chkorder->row()->createdon, 'order_type' => $chkorder->row()->order_type, 'transport_mode' => $chkorder->row()->transport_mode,'container_no'=>$container_no,'shipper_id' => $chkorder->row()->o_shipper_id,'consignee_id' => $chkorder->row()->consignee_id,'pickup_custid' => $chkorder->row()->pickup_custid,'drop_custid' => $chkorder->row()->drop_custid);
            $gen_shipper_id = $chkorder->row()->o_shipper_id;
            $gen_consignee_id = $chkorder->row()->consignee_id;
            $order_details['order_status'] = $order_status;
            $o_shipper_id = $chkorder->row()->o_shipper_id;
            if($o_shipper_id >0){
                $gen_shipper_id = $o_shipper_id;
            }
            $o_consignee_id = $chkorder->row()->consignee_id;
            if($o_consignee_id >0){
                $gen_consignee_id = $o_consignee_id;
            }
            $getpickupid = $this->db->select("id")->get_where("tbl_party_master", array(
                "code" => $chkorder->row()->pickup_custid
            ), 1, 0);
            if ($getpickupid->num_rows() > 0) {
            $order_details['pickup_id'] = $getpickupid->row()->id;
            }
            $getdropid = $this->db->select("id")->get_where("tbl_party_master", array(
                "code" => $chkorder->row()->drop_custid
            ), 1, 0);
            if ($getdropid->num_rows() > 0) {
                $order_details['drop_id'] = $getdropid->row()->id;
            }
            if ($incoterm != '') {
                $delivery_array = getDeliverytermsbyIncoterm($incoterm);
            }
            $pickup_id    = $chkorder->row()->customer_id;
            $company_code = $this->session->userdata('company_code');
            if ($company_code != "") {
                $company_code = $chkorder->row()->company_code;
            }
            $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('customer_id' => $pickup_id,'company_code'=>$company_code,'status'=>'1'));
            if ($getorders->num_rows() > 0) {
                foreach ($getorders->result() as $res) {
                    $order_types[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
                }
            }else{
                $getorder_types = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('company_code' => $company_code, 'status' => 1));
                if ($getorder_types->num_rows() > 0) {
                    foreach ($getorder_types->result() as $res) {
                        $order_types[] = array('type_name' => $res->type_name, 'type_id' => $res->id);
                    }
                }else{
                    $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types",array('company_code'=>"SGKN","status"=>1));
                    if($getorders->num_rows() >0){
                        foreach($getorders->result() as $res){
                            $order_types[] = array('type_id'=>$res->id,'type_name'=>$res->type_name);
                        }
                    }
                }
            }
            $getpickupdetails = $this->smtcorder->getpickupdetails($pickup_id);
            if ($getpickupdetails->num_rows() > 0) {
                $pickup_details = array('id' => $getpickupdetails->row()->id, 'name' => $getpickupdetails->row()->name, 'party_id' => $getpickupdetails->row()->code, 'address' => $getpickupdetails->row()->address, 'pincode' => $getpickupdetails->row()->pincode, 'country' => $getpickupdetails->row()->country);
            }
            $drop_id        = $chkorder->row()->drop_custid;
            $drop_row_id    = 0;
            $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
            if($chekparty->num_rows() >0){
              foreach($chekparty->result() as $rr){
                $ptype = $rr->party_type;
                $chktype = $this->db->select("name")->get_where("tbl_party_types",array(
                    "id"=>$ptype
                ),1,0);
                if ($chktype->num_rows() > 0) {
                    if (strtoupper($chktype->row()->name) == "CONSIGNEE") {
                        $chkconsignee = 1;
                        $gen_consignee_id = $rr->id;
                        if($chkdelivery == 0){
                            $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                        }
                    } else if (strtoupper($chktype->row()->name) == "SHIPPER") {
                        $chkshipper = 1;
                        $gen_shipper_id = $rr->id;
                        if($chkpickup == 0){
                            $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                        }
                    }else if (strtoupper($chktype->row()->name) == "DELIVERY") {
                        $chkdelivery = 1;
                        $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                        if($gen_consignee_id >0){
                        }else{
                            $gen_consignee_id = $rr->id;
                        }
                    }else if (strtoupper($chktype->row()->name) == "PICKUP") {
                        $chkpickup = 1;
                        $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                        if($gen_shipper_id > 0){
                        }else{
                            $gen_shipper_id = $rr->id;
                        }
                    }
                }
            }
        }
        if($gen_shipper_id >0){
            $getshipperdetails = $this->smtcorder->getpartydetailsbyid($gen_shipper_id);
            if ($getshipperdetails->num_rows() > 0) {
                $shipper_data = array('id' => $getshipperdetails->row()->id,'name' => $getshipperdetails->row()->name, 'party_id' => $getshipperdetails->row()->code,'address' => $getshipperdetails->row()->address,'pincode' => $getshipperdetails->row()->pincode,'country' => $getshipperdetails->row()->country);
            }
        }
        if($gen_consignee_id >0){
            $getconsigneedetails = $this->smtcorder->getpartydetailsbyid($gen_consignee_id);
            if ($getconsigneedetails->num_rows() > 0) {
                $consignee_data = array('id' => $getconsigneedetails->row()->id,'name' => $getconsigneedetails->row()->name,'party_id' => $getconsigneedetails->row()->code,'address' => $getconsigneedetails->row()->address,'pincode' => $getconsigneedetails->row()->pincode,'country' => $getconsigneedetails->row()->country);
            }
        }
        $cust_parties = array();
        if($chkpickup == 0 && $chkdelivery == 0){
            $cust_parties['0'] = 0;
            $cust_parties['1'] = 0;
            $cust_parties['2'] = $gen_shipper_id;
            $cust_parties['3'] = $gen_consignee_id;
        }

        if (!empty($cust_parties)) {
            subcustpartiesinsert($chkorder->row()->id, $chkorder->row()->order_id, $cust_parties);
        }
        $order_details['shipper_id'] = $gen_shipper_id;
        $order_details['consignee_id'] = $gen_consignee_id;
 $shipper_details['name'] = $chkorder->row()->pickup;
 $shipper_details['street'] = $chkorder->row()->pickup_address1;
 $shipper_details['state'] = $chkorder->row()->pickup_address2;
 $shipper_details['city'] = $chkorder->row()->pickup_city;
 $shipper_details['country'] = $chkorder->row()->pickup_country;
 $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;

 $drop_details['name'] = $chkorder->row()->delivery;
 $drop_details['street'] = $chkorder->row()->delivery_address1;
 $drop_details['state'] = $chkorder->row()->delivery_address2;
 $drop_details['city'] = $chkorder->row()->delivery_city;
 $drop_details['country'] = $chkorder->row()->delivery_country;
 $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
 $drop_id = $chkorder->row()->drop_custid;
}
            /* $getcargo = $this->db->query("SELECT c.* FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='".$id."' AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC");
            $cargos = array();
            if($getcargo->num_rows() >0){
            foreach ($getcargo->result() as $res) {
            $cargo_type = '"'.$res->cargo_type.'"';
            $goods_desc = '"'.$res->goods_description.'"';
            $cargos[] = array('cargo_id'=>$res->id,'goods_desc'=>$res->goods_description,'cargo_type'=>$res->cargo_type,'length'=>$res->length." ".$res->length_unit,'width'=>$res->width." ".$res->width_unit,'height'=>$res->height." ".$res->height_unit,'weight'=>$res->weight." ".$res->weight_unit,'volume'=>$res->volume." ".$res->volume_unit,'quantity'=>$res->quantity,'action'=>$action);
            }
        }*/
        $user_id = $this->session->userdata('user_id');
        $roles = array();
        $qyery=$this->db->query("SELECT id,name FROM tbl_party_types WHERE user_id= '".$user_id."' AND status=1 GROUP BY name");
        if($qyery->num_rows() >0){
            foreach($qyery->result() as $res){
                $roles[] = array('id'=>$res->id,'name'=>$res->name);
            }
        }
        $getchargecodes = $this->db->select("id,charge_code")->get_where("tb_charge_codes", array('status' => '1'));
        if ($getchargecodes->num_rows() > 0) {
            foreach ($getchargecodes->result() as $res) {
                $chargecodes[] = array('charge_id' => $res->id, 'charge_code' => $res->charge_code);
            }
        }

    }
    $transport        = array();
    $transport = gettransportmode();
    $data['stoppagecodes'] = $data['resolutioncodes'] = array();
    $select = "id,code";
    /*$getstoppage = $this->smtcorder->getmasters('tbl_stoppage_master',$select);
    if($getstoppage->num_rows() > 0){
        foreach ($getstoppage->result()  as $res) {
          $data['stoppagecodes'][]  = array('id'=>$res->id,'code'=>$res->code);
      }
  }*/
  $select = "id,name";
 /* $getresolution = $this->smtcorder->getmasters('tbl_resolution_master',$select);
  if($getresolution->num_rows() > 0){
    foreach ($getresolution->result()  as $res) {
        $data['resolutioncodes'][]  = array('id'=>$res->id,'name'=>$res->name);
    }
}*/
$data['transport']         = $transport;
$data['order_details']     = $order_details;
$data['pickup_details']    = $pickup_details;
$data['drop_details']      = $drop_details;
$data['shipper_details']   = $shipper_details;
$data['reference_details'] = $reference_details;
$data['order_types']       = $order_types;
$data['delivery_array']    = $delivery_array;
$data['chargecodes']       = $chargecodes;
$data['roles']             = $roles;
$data['shipper_data'] = $shipper_data;
$data['consignee_data'] = $consignee_data;
        //  $data['cargos'] = $cargos;

$this->newtemplate->dashboard('smtccustorders/editorder', $data);
}

public function vieworder($id = NULL) {
    $this->codeigniterauthorization->isAuthorized(
        $this->session->userdata,
        Authorization::ENTITY_TYPE_ORDER,
        $id
    );
    $company_code = $this->session->userdata('company_code');
    $data = array();
    $order_details = $shipper_details = $drop_details = $pickup_details = $consignee_data = $shipper_data = $reference_details = array();
    $drop_row_id = $chkpickup = $chkdelivery = $chkshipper = $chkconsignee = $gen_shipper_id = $gen_consignee_id = 0;
    if ($id != "") {
        $chkorder = $this->smtcorder->getordertoedit($id);
        if ($chkorder->num_rows() > 0) {
            $transport = $chkorder->row()->transport_mode;
            $transport_mode = "";
            if ($transport != "") {

                $getmode = $this->db->select("name")->get_where("tb_transportmode", array('code' => $transport));
                if ($getmode->num_rows() > 0) {
                    $transport_mode = $getmode->row()->name;
                }
            }
            $shipment_id = $pickup_inst = $delivery_inst = $container_no = $purchase_order ="";
            $getdnote = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id ='".$id."' AND reference_id IN ('DQ','ORD_DLVINST','ORD_PIKINST','CTR','PO')");
            if($getdnote->num_rows() >0){
                foreach($getdnote->result() as $ref){
                    $ref_id = $ref->reference_id;
                    if($ref_id == 'DQ'){
                        $shipment_id = $ref->ref_value;
                    }
                    if($ref_id == 'ORD_DLVINST'){
                        $delivery_inst = $ref->ref_value;
                    }
                    if($ref_id == 'ORD_PIKINST'){
                        $pickup_inst = $ref->ref_value;
                    }
                    if($ref_id == 'CTR'){
                        $container_no = $ref->ref_value;
                    }
                    if($ref_id == 'PO'){
                        $purchase_order = $ref->ref_value;
                    }
                }
            }
            $pickup_custid = $chkorder->row()->pickup_custid;
            $trip_id = $chkorder->row()->trip_id;
            $trip_sts = $chkorder->row()->trip_sts;
            $order_status = "PENDING";
            if ($trip_id != 0 && $trip_sts == 0) {
                $order_status = 'ACTIVE';
            }
            if ($trip_id != 0 && $trip_sts == 1) {
                $order_status = 'CLOSED';
            }
            $chkdate = '2020-07-01 00:00:00';
            $createdon = $chkorder->row()->createdon;
            $order_str = strtotime($createdon);
            $chk_str = strtotime($chkdate);
            $early_pickup = $chkorder->row()->pickup_datetime;

            $early_delivery = $chkorder->row()->delivery_datetime;
            $late_pickup = $chkorder->row()->pickup_endtime;
            $late_delivery = $chkorder->row()->drop_endtime;
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            if($order_str > $chk_str){
                if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00"){
                    $epickup = getdatetimebytimezone($curtz,$early_pickup,DFLT_TZ);
                    $early_pickup = $epickup['datetime'];
                }
                if($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00"){
                    $edelivery = getdatetimebytimezone($curtz,$early_delivery,DFLT_TZ);
                    $early_delivery = $edelivery['datetime'];
                }
                if($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00"){
                    $lpickup = getdatetimebytimezone($curtz,$late_pickup,DFLT_TZ);
                    $late_pickup = $lpickup['datetime'];
                }
                if($late_delivery != "" && $late_delivery != "0000-00-00 00:00:00"){
                    $ldelivery = getdatetimebytimezone($curtz,$late_delivery,DFLT_TZ);
                    $late_delivery = $ldelivery['datetime'];
                }

            }
            $order_details = array('id' => $chkorder->row()->id, 'order_id' => $chkorder->row()->order_id, 'shipment_id' => $shipment_id, 'order_status' => $order_status, 'early_pickup' => $early_pickup, 'early_delivery' => $early_delivery, 'late_pickup' => $late_pickup, 'late_delivery' => $late_delivery, 'product' => $chkorder->row()->product, 'incoterm' => $chkorder->row()->incoterm, 'delivery_note' => $chkorder->row()->delivery_note, 'purchase_order' => $purchase_order, 'notify_party' => $chkorder->row()->notify_party, 'goods_value' => $chkorder->row()->goods_value, 'lane_reference' => $chkorder->row()->lane_reference, 'distance' => $chkorder->row()->distance, 'customs_required' => $chkorder->row()->customs_required, 'high_cargo_value' => $chkorder->row()->high_cargo_value, 'valorance_insurance' => $chkorder->row()->valorance_insurance, 'temperature_control' => $chkorder->row()->temperature_control, 'company_code' => $chkorder->row()->company_code, 'branch_code' => $chkorder->row()->branch_code, 'department_code' => $chkorder->row()->department_code, 'createdon' => $chkorder->row()->createdon, 'transport_mode' => $transport_mode,'container_no'=>$container_no,'pickup_custid' => $chkorder->row()->pickup_custid,'drop_custid' => $chkorder->row()->drop_custid);
            $delivery_term = "";
            $pickup_id = $chkorder->row()->customer_id;
            $ord_type = $chkorder->row()->order_type;
            $order_details['order_type'] = "";

            $getordertype = $this->db->select("type_name")->get_where("tb_order_types", array(
                'id' => $ord_type,
                'status' => '1',
                'company_code' => $chkorder->row()->company_code
            ));
            if ($getordertype->num_rows() > 0) {
                $order_details['order_type'] = $getordertype->row()->type_name;
            }
            $delivery_term_id = $chkorder->row()->delivery_term;
            if ($delivery_term_id != "") {

                $getdelivery_term = $this->db->select("term_id,name")->get_where("tb_delivery_terms", array(
                    'term_id' => $delivery_term_id
                ));
                if ($getdelivery_term->num_rows() > 0) {
                    $delivery_term = $getdelivery_term->row()->term_id . "-" . $getdelivery_term->row()->name;
                }
            }
            $service = "";
            $service_id = $chkorder->row()->service;
            if ($service_id != "") {
                $getservice = $this->db->select("service_id,name")->get_where("tb_service_master", array(
                    'id' => $service_id
                ));
                if ($getservice->num_rows() > 0) {
                    $service = $getservice->row()->service_id . "-" . $getservice->row()->name;
                }
            }
            $order_details['service'] = $service;
            $order_details['delivery_term'] = $delivery_term;

            $getpickupdetails = $this->db->select("id,name,address,pincode,code,country")->get_where("tb_customers", array(
                'status' => 1,
                'id' => $pickup_id
            ));
            if ($getpickupdetails->num_rows() > 0) {
                $pickup_details = array(
                    'id' => $getpickupdetails->row()->id,
                    'name' => $getpickupdetails->row()->name,
                    'party_id' => $getpickupdetails->row()->code,
                    'address' => $getpickupdetails->row()->address,
                    'pincode' => $getpickupdetails->row()->pincode,
                    'country' => $getpickupdetails->row()->country);
            }
            $o_shipper_id = $chkorder->row()->o_shipper_id;
            if($o_shipper_id >0){
                $gen_shipper_id = $o_shipper_id;
            }
            $o_consignee_id = $chkorder->row()->consignee_id;
            if($o_consignee_id >0){
                $gen_consignee_id = $o_consignee_id;
            }
            $drop_id = $chkorder->row()->drop_custid;

            $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
            if ($chekparty->num_rows() > 0) {
                foreach ($chekparty->result() as $rr) {
                    $ptype = $rr->party_type;
                    $chktype = $this->db->select("name")->get_where("tbl_party_types", array(
                        "id" => $ptype
                    ), 1, 0);
                    if ($chktype->num_rows() > 0) {
                        if (strtoupper($chktype->row()->name) == "CONSIGNEE") {
                            $chkconsignee = 1;
                            $gen_consignee_id = $rr->id;
                            if($chkdelivery == 0){
                                $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            }
                        } else if (strtoupper($chktype->row()->name) == "SHIPPER") {
                            $chkshipper = 1;
                            $gen_shipper_id = $rr->id;
                            if($chkpickup == 0){
                                $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            }
                        }else if (strtoupper($chktype->row()->name) == "DELIVERY") {
                            $chkdelivery = 1;
                            $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            if($gen_consignee_id >0){
                            }else{
                                $gen_consignee_id = $rr->id;
                            }
                        }else if (strtoupper($chktype->row()->name) == "PICKUP") {
                            $chkpickup = 1;
                            $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            if($gen_shipper_id > 0){
                            }else{
                                $gen_shipper_id = $rr->id;
                            }
                        }
                    }
                }
            }
            $shipper_details['name'] = $chkorder->row()->pickup;
            $shipper_details['street'] = $chkorder->row()->pickup_address1;
            $shipper_details['state'] = $chkorder->row()->pickup_address2;
            $shipper_details['city'] = $chkorder->row()->pickup_city;
            $shipper_details['country'] = $chkorder->row()->pickup_country;
            $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;

            $drop_details['name'] = $chkorder->row()->delivery;
            $drop_details['street'] = $chkorder->row()->delivery_address1;
            $drop_details['state'] = $chkorder->row()->delivery_address2;
            $drop_details['city'] = $chkorder->row()->delivery_city;
            $drop_details['country'] = $chkorder->row()->delivery_country;
            $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
            $drop_id = $chkorder->row()->drop_custid;
        }
    }

    if($gen_shipper_id >0){
        $getshipperdetails = $this->smtcorder->getpartydetailsbyid($gen_shipper_id);
        if ($getshipperdetails->num_rows() > 0) {
            $shipper_data = array('id' => $getshipperdetails->row()->id,'name' => $getshipperdetails->row()->name, 'party_id' => $getshipperdetails->row()->code,'address' => $getshipperdetails->row()->address,'pincode' => $getshipperdetails->row()->pincode,'country' => $getshipperdetails->row()->country);
        }
    }
    if($gen_consignee_id >0){
        $getconsigneedetails = $this->smtcorder->getpartydetailsbyid($gen_consignee_id);
        if ($getconsigneedetails->num_rows() > 0) {
            $consignee_data = array('id' => $getconsigneedetails->row()->id,'name' => $getconsigneedetails->row()->name,'party_id' => $getconsigneedetails->row()->code,'address' => $getconsigneedetails->row()->address,'pincode' => $getconsigneedetails->row()->pincode,'country' => $getconsigneedetails->row()->country);
        }
    }
    $cust_parties = array();
    if($chkpickup == 0 && $chkdelivery == 0){
        $cust_parties['0'] = 0;
        $cust_parties['1'] = 0;
        $cust_parties['2'] = $gen_shipper_id;
        $cust_parties['3'] = $gen_consignee_id;
    }

    if (!empty($cust_parties)) {
        subcustpartiesinsert($chkorder->row()->id, $chkorder->row()->order_id, $cust_parties);
    }
$data['order_details']     = $order_details;
$data['pickup_details']    = $pickup_details;
$data['drop_details']      = $drop_details;
$data['reference_details'] = $reference_details;
$data['shipper_details']   = $shipper_details;
$data['shipper_data'] = $shipper_data;

$data['consignee_data'] = $consignee_data;
$this->newtemplate->dashboard('smtccustorders/vieworder', $data);
}

public function updateorder() {
    $post = array();
    $order_consignee_id = $order_shipper_id = $chkshipper = $chkconsignee = $chkpickup = $chkdelivery =  0;
    $post = $this->input->post(NULL,TRUE);
    $order_id = isset($post['order_id']) ? $post['order_id'] : '0';
    if ($order_id != "0") {
        $cdate = date('Y-m-d H:i:s');
        $user_id = $this->session->userdata('user_id');
        $booking_id = isset($post['booking_id']) ? $post['booking_id'] : "";
        $company_code = isset($post['company_code']) ? $post['company_code'] : "";
        $branch_code = isset($post['branch_code']) ? $post['branch_code'] : "";
        $department_code = isset($post['department_code']) ? $post['department_code'] : "";
        $product = isset($post['product']) ? $post['product'] : "";
        $service = isset($post['service']) ? $post['service'] : "";
        $delivery_terms = isset($post['delivery_terms']) ? $post['delivery_terms'] : "";
        $modeof_trasnport = isset($post['modeof_trasnport']) ? $post['modeof_trasnport'] : "TL";
        $order_type = isset($post['order_type']) ? $post['order_type'] : "";
        $incoterm = isset($post['incoterm']) ? $post['incoterm'] : "";
        $shipment_id = isset($post['delivery_note']) ? $post['delivery_note'] : "";
        $container_no = isset($post['container_num']) ? $post['container_num'] : "";
        $porder = isset($post['purchase_order']) ? $post['purchase_order'] : "";
        $order_shipper_id = isset($post['order_shipper_id']) ? $post['order_shipper_id'] : "0";
        $pickup_custidd = isset($post['pickup_custid']) ? $post['pickup_custid'] : "0";
        $drop_custidd = isset($post['drop_custid']) ? $post['drop_custid'] : "0";
        $order_consignee_id = isset($post['order_consignee_id']) ? $this->db->escape_str($post['order_consignee_id']) : "";
        $customer_id = isset($post['customer_id']) ? $post['customer_id'] : "";
        $pickup_custidd = isset($post['pickup_custid']) ? $post['pickup_custid'] : "0";
        $drop_custidd = isset($post['drop_custid']) ? $post['drop_custid'] : "0";
        $pickup = isset($post['order_pickup_id']) ? $post['order_pickup_id'] : "0";
        $delivery = isset($post['order_delivery_id']) ? $post['order_delivery_id'] : "0";
        $getbookingid = $this->common->gettblrowdata(array('id'=>$order_id),"order_id","tb_orders",0,0);
        if(!empty($getbookingid)){
            $booking_id = $getbookingid['order_id'];
        }
            if($order_shipper_id > 0){
            }else{
                $order_shipper_id = $pickup;
            }
            if($order_consignee_id > 0){
            }else{
                $order_consignee_id = $delivery;
            }

            if ($shipment_id != "") {
                $upddq = $this->db->query("SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE 'DQ' AND r.name=o.reference_id AND o.order_id='" . $order_id."' AND o.ref_value LIKE '".$shipment_id."' ");
                if ($upddq->num_rows() > 0) {
                    /*$this->db->where(array('id' => $upddq->row()->id))->update('tb_order_references', array('ref_value' => $shipment_id));*/
                } else {
                    $arr = array('order_id' => $order_id, 'reference_id' => 'DQ', 'ref_value' => $shipment_id);
                    $this->db->insert('tb_order_references', $arr);
                }
            }
            if($company_code == 'AUKN' || $company_code == 'UKKN'){
                if ($container_no != "") {
                    $upddq = $this->db->query("SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE 'CTR' AND r.name=o.reference_id AND o.order_id=" . $order_id);
                    if ($upddq->num_rows() > 0) {
                        $this->db->where(array('id' => $upddq->row()->id))->update('tb_order_references', array('ref_value' => $container_no));
                    } else {
                        $arr = array('order_id' => $order_id, 'reference_id' => 'CTR', 'ref_value' => $container_no,'createdon'=>$cdate);
                        $this->db->insert('tb_order_references', $arr);
                    }
                }
            }
            if ($porder != "") {
                $updporder = $this->db->query("SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE 'PO' AND r.name=o.reference_id AND o.order_id='" . $order_id."' AND o.ref_value LIKE '".$porder."' ");
                if ($updporder->num_rows() > 0) {
                    /*$this->db->where(array('id' => $updporder->row()->id))->update('tb_order_references', array('ref_value' => $porder));*/
                } else {
                    $arr = array('order_id' => $order_id, 'reference_id' => 'PO', 'ref_value' => $porder);
                    $this->db->insert('tb_order_references', $arr);
                }
            }
            $goods_value = isset($post['goods_value']) ? $post['goods_value'] : "0.00";
            if ($goods_value == "") {
                $goods_value = 0.00;
            }
            $lane_reference   = isset($post['lane_reference']) ? $post['lane_reference'] : "";
            $distance         = isset($post['distance']) ? $post['distance'] : "";
            $party_row_id     = isset($post['order_party_row_id']) ? $post['order_party_row_id'] : "0";
            $reference_ids    = isset($post['reference_ids']) ? $post['reference_ids'] : "0";
            $order_inv_row_id = isset($post['order_inv_row_id']) ? $post['order_inv_row_id'] : '0';
            $order_cargo_id   = isset($post['order_cargo_id']) ? $post['order_cargo_id'] : "";
            $pickup           = isset($post['order_pickup_id']) ? $post['order_pickup_id'] : "";
            $delivery         = isset($post['order_delivery_id']) ? $post['order_delivery_id'] : "";
            $customs_required = isset($post['customs_required']) ? $post['customs_required'] : "0";
            $high_value_cargo = isset($post['high_value_cargo']) ? $post['high_value_cargo'] : "0";
            $ad_valorence_ins = isset($post['ad_valorence_ins']) ? $post['ad_valorence_ins'] : "0";
            $temp_control     = isset($post['temp_control']) ? $post['temp_control'] : "0";
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $early_pickup     = isset($post['early_pickup']) ? $post['early_pickup'] : "";
            $late_pickup      = isset($post['late_pickup']) ? $post['late_pickup'] : "";
            $early_delivery   = isset($post['early_delivery']) ? $post['early_delivery'] : "";
            $late_delivery    = isset($post['late_delivery']) ? $post['late_delivery'] : "";
            $e_pickup         = date('Y-m-d H:i:s');
            if ($early_pickup != "") {
                $e_pickup = date('Y-m-d H:i:s', strtotime($early_pickup));
            }
            if ($late_pickup != "") {
                $l_pickup = date('Y-m-d H:i:s', strtotime($late_pickup));
            } else {
                $l_pickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_pickup)));
            }
            $e_delivery = date('Y-m-d H:i:s');
            if ($early_delivery != "") {
                $e_delivery = date('Y-m-d H:i:s', strtotime($early_delivery));
            }
            if ($late_delivery != "") {
                $l_delivery = date('Y-m-d H:i:s', strtotime($late_delivery));
            } else {
                $l_delivery = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_delivery)));
            }
        $pickup_name = $pickup_country = $pickup_street = $pickup_pincode = $pickup_city = "";
        $drop_id = $drop_name = $drop_country = $drop_street = $drop_pincode = $drop_city = $drop_state = $pickup_state = $drop_state = $pickup_address = $drop_address = "";
        $pickup_custid = $drop_custid = $pickup_id = 0;

        $drop_row_id = $shipper_party_id = $consignee_party_id = 0;
        $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name,p.code,p.mobile,p.email,p.fax,o.id as order_party_id,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$order_id' GROUP BY o.party_type");
        if ($chekparty->num_rows() > 0) {
                foreach ($chekparty->result() as $rr) {
                    $ptype = $rr->party_type;
                    $chktype = $this->db->select("name")->get_where("tbl_party_types", array("id" => $ptype), 1, 0);
                    if ($chktype->num_rows() > 0) {
                    $party_name= strtoupper($chktype->row()->name);
                     if (strtoupper($chktype->row()->name) == "CONSIGNEE") {
                            $chkconsignee = 1;
                            if($order_consignee_id >0){
                            }else{
                                $order_consignee_id = $rr->id;
                            }
                            if($chkdelivery == 0){
                                $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            }
                        } else if (strtoupper($chktype->row()->name) == "SHIPPER") {
                            $chkshipper = 1;
                            if($order_shipper_id > 0){
                            }else{
                                $order_shipper_id = $rr->id;
                            }
                            if($chkpickup == 0){
                                $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            }
                        }else if (strtoupper($chktype->row()->name) == "DELIVERY") {
                            $chkdelivery = 1;
                            $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            if($order_consignee_id >0){
                            }else{
                                $order_consignee_id = $rr->id;
                            }
                        }else if (strtoupper($chktype->row()->name) == "PICKUP") {
                            $chkpickup = 1;
                            $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            if($order_shipper_id > 0){
                            }else{
                                $order_shipper_id = $rr->id;
                            }
                        }
                    }
                }
        }
        $cust_parties = array();
        $cust_parties['0'] = $order_shipper_id;
        $cust_parties['1'] = $order_consignee_id;
        $cust_parties['2'] = $pickup;
        $cust_parties['3'] = $delivery;
        if (!empty($cust_parties)) {
            subcustpartiesinsert($order_id, $booking_id, $cust_parties);
        }
            if ($pickup != "0") {
                $getshippercustid = $this->db->query("SELECT name,code,location_id as city,street,state,address,country,pincode FROM tbl_party_master WHERE id='" . $pickup . "'");
                if ($getshippercustid->num_rows() > 0) {
                    $pickup_custid = $getshippercustid->row()->code;
                    $pickup_name = $getshippercustid->row()->name;
                    $pickup_state = $getshippercustid->row()->state;
                    $pickup_address = $getshippercustid->row()->address;
                    $pickup_country = $getshippercustid->row()->country;
                    $pickup_street = $getshippercustid->row()->street;
                    $pickup_pincode = $getshippercustid->row()->pincode;
                    $pickup_city = $getshippercustid->row()->city;
                        $chkprevious_shipperaddress = $this->db->select('id')->get_where("tbl_orderparty_address", array(
                            'order_id' => $order_id,
                            'party_master_id' => $pickup_id,
                            'status' => '1'
                        ));
                        if ($chkprevious_shipperaddress->num_rows() > 0) {
                            $upd_oldsaddress = $this->db->where(array(
                                'id' => $chkprevious_shipperaddress->row()->id
                            ))
                            ->update("tbl_orderparty_address", array(
                                'status' => '0'
                            ));
                        }
                    $chkpartyaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array(
                        'order_id' => $order_id,
                        'party_master_id' => $order_shipper_id,
                        'status' => '1'
                    ));
                    $shipper_address = array(
                        'order_id' => $order_id,
                        'party_master_id' => $order_shipper_id,
                        'location_id' => $pickup_city,
                        'street' => $pickup_street,
                        'state' => $pickup_state,
                        'address' => $pickup_address,
                        'pincode' => $pickup_pincode,
                        'country' => $pickup_country,
                        'user_id' => $user_id,
                        'status' => '1'
                    );
                    if ($chkpartyaddress->num_rows() > 0) {
                        $pickup_addressid = $chkpartyaddress->row()->id;
                        $upd = $this->db->where(array(
                            'id' => $pickup_addressid
                        ))->update("tbl_orderparty_address", $shipper_address);
                    } else {
                        $shipper_address['createdon'] = $cdate;
                        $this->db->insert("tbl_orderparty_address", $shipper_address);
                    }
                }
            }
            /* }
             if ($drop_row_id != "0") {
                $chkdrop = $this->db->select("location_id,street,state,address,pincode,country")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $drop_row_id));
                if ($chkdrop->num_rows() > 0) {
                    $drop_city    = $chkdrop->row()->location_id;
                    $drop_state   = $chkdrop->row()->state;
                    $drop_country = $chkdrop->row()->country;
                    $drop_street  = $chkdrop->row()->street;
                    $drop_pincode = $chkdrop->row()->pincode;
                    $drop_address = $chkdrop->row()->address;
                }
             }else{*/
            if($delivery != "0"){
                $getdropcustid = $this->db->query("SELECT name,code,location_id as city,street,state,address,country,pincode FROM tbl_party_master WHERE id='" . $delivery . "'");
                if ($getdropcustid->num_rows() > 0) {
                    $drop_id = $delivery;
                    $drop_custid = $getdropcustid->row()->code;
                    $drop_name = $getdropcustid->row()->name;
                    $drop_state = $getdropcustid->row()->state;
                    $drop_address = $getdropcustid->row()->address;
                    $drop_country = $getdropcustid->row()->country;
                    $drop_street = $getdropcustid->row()->street;
                    $drop_pincode = $getdropcustid->row()->pincode;
                    $drop_city = $getdropcustid->row()->city;
                    if ($drop_row_id != 0) {
                        $chkprevious_dropaddress = $this->db->select('id')->get_where("tbl_orderparty_address", array(
                            'order_id' => $order_id,
                            'party_master_id' => $drop_row_id,
                            'status' => '1'
                        ));
                        if ($chkprevious_dropaddress->num_rows() > 0) {
                            $upd_olddaddress = $this->db->where(array(
                                'id' => $chkprevious_dropaddress->row()->id
                            ))
                            ->update("tbl_orderparty_address", array(
                                'status' => '0'
                            ));
                        }
                    }

                    $chkpartyaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array(
                        'order_id' => $order_id,
                        'party_master_id' => $delivery,
                        'status' => '1'
                    ));
                    $drop_address = array(
                        'order_id' => $order_id,
                        'party_master_id' => $delivery,
                        'location_id' => $drop_city,
                        'street' => $drop_street,
                        'state' => $drop_state,
                        'address' => $drop_address,
                        'pincode' => $drop_pincode,
                        'country' => $drop_country,
                        'user_id' => $user_id,
                        'status' => '1'
                    );
                    if ($chkpartyaddress->num_rows() > 0) {
                        $drop_addressid = $chkpartyaddress->row()->id;
                        $upd = $this->db->where(array(
                            'id' => $drop_addressid
                        ))->update("tbl_orderparty_address", $drop_address);
                    } else {
                        $drop_address['createdon'] = $cdate;
                        $this->db->insert("tbl_orderparty_address", $drop_address);
                    }
                }
            }
        $inv_customer = makeorderinvolvedpartiestype($customer_id, $order_id, "CUSTOMER", $user_id, $company_code);
        insertOrdersRefFileLineIdentifier(['pickupCity' => $pickup_city, 'pickupState' => $pickup_state, 'pickupCountry' => $pickup_country, 'dropCity' => $drop_city, 'dropState' => $drop_state, 'dropCountry' => $drop_country, 'companyCode' => $company_code, 'branchCode' => $branch_code, 'orderRowId' => $order_id, 'date' => $cdate]);
        $ship_row_id = 0;
        $enddate = date('Y-m-d H:i:s', strtotime("+1 day"));
        $tid = $tname = "";
        $gettrasnportmode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '" . $modeof_trasnport . "'");
        if ($gettrasnportmode->num_rows() > 0) {
            $tid = $gettrasnportmode->row()->id;
            $tname = $gettrasnportmode->row()->name;
        }
        $ship_arr = array(
            'unitspec' => 1,
            'shipid' => $shipment_id,
            'txnid' => $shipment_id,
            'trucktype' => $tname,
            'pickupcnt' => '1',
            'dropcnt' => '1',
            'insertusr' => $pickup_custid,
            'carrier' => '0',
            'insertuserdate' => $cdate,
            'enddate' => $enddate,
            'insdate' => $cdate,
            'upddate' => $cdate,
            'reason' => 'SHIPMENT',
            'purpose' => 'SEND INTEGRATION',
            'ship_object' => 'SHIPMENT',
            'logdate' => $cdate,
            'transport_mode' => $modeof_trasnport,
            'domainname' => $branch_code,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'product' => $product,
            'freight_term' => '60',
            'freight_termname' => 'Free of Charge',
            'incoterm' => $incoterm,
            'modeoftransport' => $tid
        );
        $chk_shipid = $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '" . $shipment_id . "'");
        if ($chk_shipid->num_rows() > 0) {
            $ship_row_id = $chk_shipid->row()->id;
            $this->db->where(array('id' => $ship_row_id))->update("tb_shipments", $ship_arr);
        } else {

            $ship_arr['createdon'] = $cdate;
            $ship_ins = $this->db->insert("tb_shipments", $ship_arr);
            $ship_row_id = $this->db->insert_id();
        }

        $ins = [
            'shipment_id' => $ship_row_id,
            'product' => $product,
            'pickup_datetime' => $e_pickup,
            'delivery_datetime' => $e_delivery,
            'pickup_endtime' => $l_pickup,
            'drop_endtime' => $l_delivery,
            'goods_value' => $goods_value,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'transport_mode' => $modeof_trasnport,
            'shipper_id' => $order_shipper_id,
            'consignee_id' => $order_consignee_id,
            'updatedon' => date('Y-m-d H:i:s')
        ];
        if ($pickup_name != "") {
            $ins['pickup_company'] = $pickup_name;
        }
        if ($pickup_country != "") {
            $ins['pickup_country'] = $pickup_country;
        }
        if ($drop_name != "") {
            $ins['delivery_company'] = $drop_name;
        }
        if ($drop_country != "") {
            $ins['delivery_country'] = $drop_country;
        }
        if ($pickup_street != "") {
            $ins['pickup_address1'] = $pickup_street;
        }
        if ($pickup_city != "") {
            $ins['pickup_city'] = $pickup_city;
        }
        if ($drop_custid != "") {
            $ins['drop_custid'] = $drop_custidd;
        }
        if ($drop_custid != "") {
            $ins['drop_partyid'] = $drop_custidd;
        }
        if ($pickup_custid != "") {
            $ins['pickup_custid'] = $pickup_custidd;
        }
        if ($pickup_custid != "") {
            $ins['pickup_partyid'] = $pickup_custidd;
        }
        if($pickup_pincode != ""){
            $ins['pickup_pincode'] = $pickup_pincode;
        }
        if($pickup_state != ""){
            $ins['pickup_address2'] = $pickup_state;
        }
        if($drop_street != ""){
            $ins['delivery_address1']  = $drop_street;
        }
        if($drop_state != ""){
            $ins['delivery_address2'] = $drop_state;
        }
        if($drop_city != ""){
            $ins['delivery_city'] = $drop_city;
        }
        if($drop_pincode != ""){
            $ins['delivery_pincode'] = $drop_pincode;
        }

        $this->db->where(array('id' => $order_id))->update('tb_orders', $ins);
        $details_ins  = array('service' => $service, 'delivery_term' => $delivery_terms, 'incoterm' => $incoterm, 'purchase_order' => $porder, 'lane_reference' => $lane_reference, 'distance' => $distance, 'department_code' => $department_code, 'temperature_control' => $temp_control, 'valorance_insurance' => $ad_valorence_ins, 'high_cargo_value' => $high_value_cargo, 'customs_required' => $customs_required, 'order_type' => $order_type);
        $upd_details  = $this->db->where(array('order_row_id' => $order_id))->update("tb_order_details", $details_ins);
        $total_weight = $total_volume = $total_quantity = 0;
        $gettotal = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $order_id . "'");
        if ($gettotal->num_rows() > 0) {
            $total_volume = $gettotal->row()->total_volume;
            $total_weight = $gettotal->row()->total_weight;
            $total_quantity = $gettotal->row()->total_quantity;
        }
        $upd_order = $this->db->where(array('id' => $order_id))->update("tb_orders", array('volume' => $total_volume, 'weight' => $total_weight, 'quantity' => $total_quantity));
        $this->ordernotify('booking_edit',$order_id);
    }
    if($order_id != "" && $order_id !='0'){
        $this->session->set_flashdata('success_msg','Order Updated Successfully - '.$booking_id);
        redirect('smtccustorders/orderslist/'.$order_id);
    }else{
        redirect('smtccustorders');
    }

}
public function insertorder() {
    $cdate = date('Y-m-d H:i:s');
    $user_id          = $this->session->userdata('user_id');
    $post   = array();
    $post   = $this->input->post(NULL,TRUE);
    $company_code     = isset($post['company_code']) ? $post['company_code'] : "";
    $branch_code      = isset($post['branch_code']) ? $post['branch_code'] : "";
    $department_code  = isset($post['department_code']) ? $post['department_code'] : "";
    $product          = isset($post['product']) ? $post['product'] : "";
    $service = isset($post['service']) ? $post['service'] : "";
    $delivery_terms = isset($post['delivery_terms']) ? $post['delivery_terms'] : "";
    $incoterm       = isset($post['incoterm']) ? $post['incoterm'] : "";
    $shipment_id    = isset($post['delivery_note']) ? $post['delivery_note'] : "";
    $container_no    = isset($post['container_num']) ? $post['container_num'] : "";
    $porder         = isset($post['purchase_order']) ? $post['purchase_order'] : "";
    $notify_party   = isset($post['notify_party']) ? $post['notify_party'] : "";
    $goods_value    = isset($post['goods_value']) ? $post['goods_value'] : "0.00";
    if ($goods_value == "") {
        $goods_value = 0.00;
    }
    $order_shipper_id = isset($post['order_shipper_id']) ? $this->db->escape_str($post['order_shipper_id']) : "";
    $order_consignee_id = isset($post['order_consignee_id']) ? $this->db->escape_str($post['order_consignee_id']) : "";
    if($order_shipper_id == ""){ $order_shipper_id = 0;}
    if($order_consignee_id == ""){ $order_consignee_id = 0;}
    $order_type_flag = isset($post['order_type_flag']) ? $this->db->escape_str($post['order_type_flag']) : "";
    $lane_reference   = isset($post['lane_reference']) ? $post['lane_reference'] : "";
    $distance         = isset($post['distance']) ? $post['distance'] : "";
    $party_row_id     = isset($post['order_party_row_id']) ? $post['order_party_row_id'] : "0";
    $reference_ids    = isset($post['reference_ids']) ? $post['reference_ids'] : "0";
    $order_inv_row_id = isset($post['order_inv_row_id']) ? $post['order_inv_row_id'] : '0';
    $order_cargo_id   = isset($post['order_cargo_id']) ? $post['order_cargo_id'] : "";
    $pickup           = isset($post['order_pickup_id']) ? $post['order_pickup_id'] : "";
    $customs_required = isset($post['customs_required']) ? $post['customs_required'] : "0";
    $high_value_cargo = isset($post['high_value_cargo']) ? $post['high_value_cargo'] : "0";
    $ad_valorence_ins = isset($post['ad_valorence_ins']) ? $post['ad_valorence_ins'] : "0";
    $temp_control     = isset($post['temp_control']) ? $post['temp_control'] : "0";
    $early_pickup     = isset($post['early_pickup']) ? $post['early_pickup'] : "";
    $late_pickup      = isset($post['late_pickup']) ? $post['late_pickup'] : "";
    $early_delivery   = isset($post['early_delivery']) ? $post['early_delivery'] : "";
    $late_delivery    = isset($post['late_delivery']) ? $post['late_delivery'] : "";
    $modeof_trasnport = isset($post['modeof_trasnport']) ? $post['modeof_trasnport'] : "LTL";
    $order_type       = isset($post['order_type']) ? $post['order_type'] : "";
    $e_pickup         = date('Y-m-d H:i:s');
    $delivery = isset($post['order_delivery_id']) ? $this->db->escape_str($post['order_delivery_id']) : "";
    if($delivery == ""){ $delivery = 0;}
    if ($early_pickup != "") {
        $e_pickup = date('Y-m-d H:i:s', strtotime($early_pickup));
    }
    if ($late_pickup != "") {
        $l_pickup = date('Y-m-d H:i:s', strtotime($late_pickup));
    } else {
        $l_pickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_pickup)));
    }
    $e_delivery = date('Y-m-d H:i:s');
    if ($early_delivery != "") {
        $e_delivery = date('Y-m-d H:i:s', strtotime($early_delivery));
    }
    if ($late_delivery != "") {
        $l_delivery = date('Y-m-d H:i:s', strtotime($late_delivery));
    } else {
        $l_delivery = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_delivery)));
    }
    $same_porder = "0";
    if($order_shipper_id =='' || $order_shipper_id == NULL){
        $order_shipper_id = $pickup;
    }else{
        $order_shipper_id = $order_shipper_id;
    }
    if($order_consignee_id =='' || $order_consignee_id == NULL){
        $order_consignee_id = $delivery;
    }else{
        $order_consignee_id = $order_consignee_id;
    }

    /*if ($porder != "") {

        $chkporder = $this->db->query("SELECT id FROM tb_order_details WHERE purchase_order='" . $porder . "' AND status='1'");
        if ($chkporder->num_rows() > 0) {
            $same_porder = "1";

        }
    }*/
    if ($same_porder == 1) {
        $this->session->set_flashdata('error_msg', 'Purchase Order "' . $porder . '" already exists with One ORDER');
        redirect("orders");
         /* return FALSE; */
    } else {
        $drop_id        = $pickup_custid        = 0;
        $pickup_name    = $pickup_country    = $pickup_street    = $pickup_pincode    = $pickup_city    = $drop_name    = $drop_country    = $drop_street    = $drop_pincode    = $drop_city    = $pickup_address    = $pickup_state    = $drop_address    = $drop_state = "";
        $getdrop_custid = $this->db->query("SELECT name,location_id as city,street,state,address,country,customeridentifier,pincode,code FROM tbl_party_master WHERE id='" . $delivery . "'");
        if ($getdrop_custid->num_rows() > 0) {
            $drop_id      = $getdrop_custid->row()->code;
            $drop_name    = $getdrop_custid->row()->name;
            $drop_state   = $getdrop_custid->row()->state;
            $drop_address = $getdrop_custid->row()->address;
            $drop_country = $getdrop_custid->row()->country;
            $drop_street  = $getdrop_custid->row()->street;
            $drop_pincode = $getdrop_custid->row()->pincode;
            $drop_city    = $getdrop_custid->row()->city;
        }

        $getshippercustid = $this->db->query("SELECT name,location_id as city,street,state,address,country,customeridentifier,pincode,code FROM tbl_party_master WHERE id='" . $pickup . "'");
        if ($getshippercustid->num_rows() > 0) {
            $pickup_custid  = $getshippercustid->row()->code;
            $pickup_name    = $getshippercustid->row()->name;
            $pickup_state   = $getshippercustid->row()->state;
            $pickup_address = $getshippercustid->row()->address;
            $pickup_country = $getshippercustid->row()->country;
            $pickup_street  = $getshippercustid->row()->street;
            $pickup_pincode = $getshippercustid->row()->pincode;
            $pickup_city    = $getshippercustid->row()->city;

        }
        $add1             = implode(",", [$pickup_street, $pickup_city, $pickup_country, $pickup_pincode]);
        $add2             = implode(",", [$drop_street, $drop_city, $drop_country, $drop_pincode]);
        $data             = getlatlngsbyplace($add1);
        $lat1             = @$data[0];
        $lng1             = @$data[1];
        $data             = [];
        $data             = getlatlngsbyplace($add2);
        $lat2             = @$data[0];
        $lng2             = @$data[1];
        $ship_row_id      = 0;
        $enddate          = date('Y-m-d H:i:s', strtotime("+1 day"));
        $tid              = $tname              = "";
        $gettrasnportmode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '" . $modeof_trasnport . "'");
        if ($gettrasnportmode->num_rows() > 0) {
            $tid   = $gettrasnportmode->row()->id;
            $tname = $gettrasnportmode->row()->name;
        }
        if ($shipment_id == "") {
            $shipment_id = "SVK" . time();
        }

        $ship_arr   = array('unitspec' => 1, 'shipid' => $shipment_id, 'txnid' => $shipment_id, 'trucktype' => $tname, 'pickupcnt' => '1', 'dropcnt' => '1', 'insertusr' => $pickup_custid, 'carrier' => '0', 'insertuserdate' => $cdate, 'enddate' => $enddate, 'insdate' => $cdate, 'upddate' => $cdate, 'reason' => 'SHIPMENT', 'purpose' => 'SEND INTEGRATION', 'ship_object' => 'SHIPMENT', 'logdate' => $cdate, 'transport_mode' => $modeof_trasnport, 'domainname' => $branch_code, 'company_code' => $company_code, 'branch_code' => $branch_code, 'product' => $product, 'freight_term' => '60', 'freight_termname' => 'Free of Charge', 'incoterm' => $incoterm, 'modeoftransport' => $tid);
        $chk_shipid = $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '" . $shipment_id . "'");

        if ($chk_shipid->num_rows() > 0) {
            $ship_row_id = $chk_shipid->row()->id;
            $this->db->where(array('id' => $ship_row_id))->update("tb_shipments", $ship_arr);
        } else {

            $ship_arr['createdon'] = $cdate;
            $ship_ins              = $this->db->insert("tb_shipments", $ship_arr);
            $ship_row_id           = $this->db->insert_id();
        }
        $customer_id = 0;
        $cust_id     = $this->session->userdata('cust_id');
        if ($cust_id == "") {
            $customer_id = $pickup;
        } else {
            $customer_id = $cust_id;
        }
        if ($this->session->userdata('company_code') == 'NZKN') {
            if ($product == "") {
                $product = "KN AsiaLink";
            }
            if ($modeof_trasnport == "") {
                $modeof_trasnport = "LTL";
            }
            if ($service == "") {
                $service = "19";
            }
        }
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
        $logdate = $getactual['datetime'];
        $getpickup = getdatetimebytimezone(DFLT_TZ,$e_pickup,$curtz);
        $e_pickup = $getpickup['datetime'];
        $getlpickup = getdatetimebytimezone(DFLT_TZ,$l_pickup,$curtz);
        $l_pickup = $getlpickup['datetime'];
        $getdelivery = getdatetimebytimezone(DFLT_TZ,$e_delivery,$curtz);
        $e_delivery = $getdelivery['datetime'];
        $getldelivery = getdatetimebytimezone(DFLT_TZ,$l_delivery,$curtz);
        $l_delivery = $getldelivery['datetime'];
        $ins       = array('shipment_id' => $ship_row_id, 'customer_id' => $customer_id, 'product' => $product, 'pickup_datetime' => $e_pickup, 'delivery_datetime' => $e_delivery, 'pickup_endtime' => $l_pickup, 'drop_endtime' => $l_delivery, 'goods_value' => $goods_value, 'company_code' => $company_code, 'branch_code' => $branch_code, 'createdon' => $cdate, 'drop_custid' => $drop_id, 'drop_partyid' => $drop_id, 'user_id' => $user_id, 'pickup_custid' => $pickup_custid, 'pickup_partyid' => $pickup_custid, 'pickup_country' => $pickup_country, 'pickup_city' => $pickup_city, 'pickup_pincode' => $pickup_pincode, 'pickup_company' => $pickup_name, 'pickup_address1' => $pickup_street,'pickup_address2'=>$pickup_state, 'delivery_country' => $drop_country, 'delivery_city' => $drop_city, 'delivery_pincode' => $drop_pincode, 'delivery_company' => $drop_name, 'delivery_address1' => $drop_street,'delivery_address2'=>$drop_state, 'is_created' => '1', 'plat' => $lat1, 'plng' => $lng1, 'dlat' => $lat2, 'dlng' => $lng2, 'transport_mode' => $modeof_trasnport,'created_source'=>'4','createdon'=>$logdate,'shipper_id' => $order_shipper_id,'consignee_id' => $order_consignee_id);
        $ins_order = $this->db->insert("tb_orders", $ins);
        $order_id  = $this->db->insert_id();

        $user_id = $this->session->userdata('user_id');
        if ($user_id != "") {
            $get_country = $this->db->select('country_code,company_code')->get_where("tb_users",array('id'=>$user_id));
            $country_code  = $get_country->row()->country_code;
            $company_code  = $get_country->row()->company_code;
            $genord = array("user_id"=>$user_id,"order_id"=>$order_id,"country_code"=>$country_code,"company_code"=>$company_code);
            $booking_id = generatebookingid($genord);
            $upd     = $this->db->where(array('id' => $order_id))->update("tb_orders", array('order_id' => $booking_id));
            $invtypes = makeorderinvolvedpartiestype($customer_id,$order_id,"CUSTOMER", $user_id, $company_code);
            insertOrdersRefFileLineIdentifier(['pickupCity' => $pickup_city, 'pickupState' => $pickup_state, 'pickupCountry' => $pickup_country, 'dropCity' => $drop_city, 'dropState' => $drop_state, 'dropCountry' => $drop_country, 'companyCode' => $company_code, 'branchCode' => $branch_code, 'orderRowId' => $order_id, 'date' => $cdate]);
            $details = array('service' => $service, 'delivery_term' => $delivery_terms, 'incoterm' => $incoterm, 'purchase_order' => $porder, 'notify_party' => $notify_party, 'lane_reference' => $lane_reference, 'distance' => $distance, 'department_code' => $department_code, 'temperature_control' => $temp_control, 'valorance_insurance' => $ad_valorence_ins, 'high_cargo_value' => $high_value_cargo, 'customs_required' => $customs_required, 'order_row_id' => $order_id, 'order_id' => $booking_id, 'createdon' => $cdate, 'shipper_id' => $order_shipper_id, 'order_type' => $order_type);
            $this->db->insert("tb_order_details", $details);
        }
        $shipper_address    = array('order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $pickup_address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id);
        $chk_shipperaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $order_shipper_id));
        if ($chk_shipperaddress->num_rows() > 0) {
            $shipperadd_id = $chk_shipperaddress->row()->id;
            $upd_add       = $this->db->where(array('id' => $shipperadd_id))->update("tbl_orderparty_address", $shipper_address);
        } else {
            $shipper_address['createdon'] = $cdate;
            $this->db->insert("tbl_orderparty_address", $shipper_address);
            $shipperadd_id = $this->db->insert_id();
        }
        $delivery_address    = array('order_id' => $order_id, 'party_master_id' => $delivery, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $drop_address, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id);
        $chk_deliveryaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $delivery));
        if ($chk_deliveryaddress->num_rows() > 0) {
            $dropadd_id = $chk_deliveryaddress->row()->id;
            $upd_add    = $this->db->where(array('id' => $dropadd_id))->update("tbl_orderparty_address", $delivery_address);
        } else {
            $delivery_address['createdon'] = $cdate;
            $this->db->insert("tbl_orderparty_address", $delivery_address);
            $dropadd_id = $this->db->insert_id();
        }
        $cargo_forship = array();
        if ($order_cargo_id != "") {
            $cargo_ids = array();
            $cargo_ids = explode(',', $order_cargo_id);
            for ($i = 0; $i < count($cargo_ids); $i++) {
                $length           = $width           = $height           = $weight           = $volume     =     $second_weight = $second_volume       = 0;
                $quantity         = 1;
                $getcargo_details = $this->db->query("SELECT cargo_type,length,width,height,weight,volumetric_weight,volume,second_weight,second_volume,quantity,goods_description,marks_numbers FROM tb_cargo_details WHERE id='" . $cargo_ids[$i] . "'");
                $cargo_type       = $description       = "";
                if ($getcargo_details->num_rows() > 0) {
                    $length            = $getcargo_details->row()->length;
                    $width             = $getcargo_details->row()->width;
                    $height            = $getcargo_details->row()->height;
                    $weight            = $getcargo_details->row()->weight;
                    $volumetric_weight = $getcargo_details->row()->volumetric_weight;
                    $volume            = $getcargo_details->row()->volume;
                    $quantity          = $getcargo_details->row()->quantity;
                    $cargo_type        = $getcargo_details->row()->cargo_type;
                    $description       = $getcargo_details->row()->goods_description;
                    $cargo_forship[$i] = $getcargo_details->row()->cargo_type;
                    $second_volume     = $getcargo_details->row()->second_volume;
                    $second_weight     = $getcargo_details->row()->second_weight;
                    $marks_numbers     = $getcargo_details->row()->marks_numbers;
                }
                $gethandling_unit = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE '" . $cargo_type . "'");
                $handling_unit    = "";
                if ($gethandling_unit->num_rows() > 0) {
                    $handling_unit = $gethandling_unit->row()->id;
                } else {
                    $handlingunit_ar = array('unit_name' => $cargo_type,'description'=>$cargo_type, 'user_id' => $user_id, 'created_at' => $cdate, 'status' => '1');
                    $this->db->insert("tbl_shipunit_types", $handlingunit_ar);
                    $handling_unit = $this->db->insert_id();
                }
                $cargo     = array('order_id' => $order_id, 'cargo_id' => $cargo_ids[$i], 'status' => '1', 'length' => $length, 'width' => $width, 'height' => $height, 'weight' => $weight,'volumetric_weight'=>$volumetric_weight,'volweight_uom'=>'kg', 'volume' => $volume, 'quantity' => $quantity, 'cargo_content' => $description, 'quantity_type' => $cargo_type, 'handling_unit' => $handling_unit,'second_weight'=>$second_weight,'second_volume'=>$second_volume,'marks_numbers'=>$marks_numbers);
                $ins_cargo = $this->db->insert("tb_order_cargodetails", $cargo);
            }
        }
        $unitspec = "1";
        if (!empty($cargo_forship)) {
            $unitspec = implode(',', $cargo_forship);
        }
        $updship      = $this->db->where(array('id' => $ship_row_id))->update("tb_shipments", array('unitspec' => $unitspec, 'txncode' => $booking_id));
        $total_weight = $total_volume = $total_quantity = 0;
        $gettotal     = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $order_id . "'");
        if ($gettotal->num_rows() > 0) {
            $total_volume   = $gettotal->row()->total_volume;
            $total_weight   = $gettotal->row()->total_weight;
            $total_quantity = $gettotal->row()->total_quantity;
        }
        $upd_order = $this->db->where(array('id' => $order_id))->update("tb_orders", array('volume' => $total_volume, 'weight' => $total_weight, 'quantity' => $total_quantity));
        $ids       = array();
        if ($reference_ids != "0") {
            $refids = explode(',', $reference_ids);
        }
        if (!empty($refids)) {
            for ($i = 0; $i < count($refids); $i++) {
                if ($refids[$i] != "") {
                    $chk = $this->db->query("SELECT o.id FROM tb_reference_master r,tb_order_references o WHERE r.id='" . $refids[$i] . "' AND r.name=o.reference_id");
                    if ($chk->num_rows() > 0) {
                        $upd = $this->db->where(array('id' => $chk->row()->id))->update("tb_order_references", array('order_id' => $order_id));
                    }
                }

            }
        }
        if ($shipment_id != "") {
            $ins_ref = array('order_id' => $order_id, 'reference_id' => 'DQ', 'ref_value' => $shipment_id, 'createdon' => $cdate);
            $ins     = $this->db->insert('tb_order_references', $ins_ref);

        }
        if($company_code == 'UKKN' || $company_code == 'AUKN'){
            if ($container_no != "") {
                $ins_ref = array('order_id' => $order_id, 'reference_id' => 'CTR', 'ref_value' => $container_no, 'createdon' => $cdate);
                $ins     = $this->db->insert('tb_order_references', $ins_ref);
            }
        }
        if ($porder != "") {
            $ins_ref = array('order_id' => $order_id, 'reference_id' => 'PO', 'ref_value' => $porder, 'createdon' => $cdate);
            $ins     = $this->db->insert('tb_order_references', $ins_ref);

        }
        // if ($party_row_id != "0") {
        //     $ids = explode(',', $party_row_id);
        // }
        // if ($order_inv_row_id != 0 || $order_inv_row_id != "") {
        //     array_push($ids, $order_inv_row_id);
        // }
            // if (!empty($ids)) {
            //     for ($i = 0; $i < count($ids); $i++) {
            //         if ($ids[$i] != "") {
            //             $getpartytype = $this->db->query("SELECT party_type_id FROM tbl_party_master WHERE id='" . $ids[$i] . "'");
            //             $party_type   = 1;
            //             if ($getpartytype->num_rows() > 0) {
            //                 $party_type = $getpartytype->row()->party_type_id;
            //             }
            //             $party     = array('order_id' => $order_id, 'party_id' => $ids[$i], 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id);
            //             $ins_party = $this->db->insert("tb_order_parties", $party);
            //         }
            //     }
            // }
        $cust_parties = array();
        $cust_parties['0'] = $order_shipper_id;
        $cust_parties['1'] = $order_consignee_id;
        $cust_parties['2'] = $pickup;
        $cust_parties['3'] = $delivery;
        if (!empty($cust_parties)) {
            subcustpartiesinsert($order_id, $booking_id, $cust_parties);
        }
        $this->ordernotify('booking_create',$order_id);
        $customerCode = $post['customer_id'] ?? "";
        $preferenceArray = [
            'pickup' => strtoupper($pickup_country),
            'pickup_state' => strtoupper($pickup_state),
            'pickup_city' => strtoupper($pickup_city),
            'pickup_pincode' => $pickup_pincode,
            'drop' => strtoupper($drop_country),
            'drop_state' => strtoupper($drop_state),
            'drop_city' => strtoupper($drop_city),
            'drop_pincode' => $drop_pincode,
            'customer_id' => $customerCode,
            'service' => $service,
            'product' => $product,
            'user_id' => $user_id,
            'company_code' => $company_code,
            'order_id' => $order_id,
            'order_type' => $order_type,
            'customer_row_id' => $customer_id,
        ];
        $this->ratemanagement->addrecodfororderinsertion($preferenceArray);
   }
    if($order_id != "" && $order_id !='0'){
        redirect('smtccustorders/orderslist/'.$order_id);
        $this->session->set_flashdata('success_msg','Order Created Successfully - '.$booking_id);
    }else{
        redirect("smtccustorders");
    }
}

public function savequickbook()
{
    $post   = array();
    $post   = $this->input->post(NULL,TRUE);
    $cdate = date('Y-m-d H:i:s');
    $user_id = $this->session->userdata('user_id');
    $cust_id = $this->session->userdata('cust_id');
    $company_code = isset($post['popupcompany_code']) ? $post['popupcompany_code'] : "";
    $branch_code = isset($post['popupbranch_code']) ? $post['popupbranch_code'] : "";
    $department_code = isset($post['popupdepartment_code']) ? $post['popupdepartment_code'] : "";
    $product = isset($post['productpopup']) ? $post['productpopup'] : "";
    $service = isset($post['servicepopup']) ? $post['servicepopup'] : "";
    $delivery_terms = isset($post['popupdelivery_terms']) ? $post['popupdelivery_terms'] : "";
    $incoterm = isset($post['incoterm_popup']) ? $post['incoterm_popup'] : "";
    $shipment_id = isset($post['popupdelivery_note']) ? $post['popupdelivery_note'] : "";
    $porder = isset($post['purchaseorder_popup']) ? $post['purchaseorder_popup'] : "";
    $notify_party = isset($post['popupnotifyparty']) ? $post['popupnotifyparty'] : "";
    $popuppickup = isset($post['popuppickup']) ? $post['popuppickup'] : "";
    $popupdelivery = isset($post['popupdelivery']) ? $post['popupdelivery'] : "";
    $popupshipper_id = isset($post['quickbookshipper_id']) ? $this->db->escape_str($post['quickbookshipper_id']) : "";
    $popupconsignee_id = isset($post['quickbookconsignee_id']) ? $this->db->escape_str($post['quickbookconsignee_id']) : "";
    $earlyquickbook_delivery = $latequickbook_delivery = "";
    $popupcustomer_id = isset($post['popupcustomer_id']) ? $this->db->escape_str($post['popupcustomer_id']) : "";
    if($popupdelivery != ""){
      $earlyquickbook_delivery = date('Y-m-d H:i:s',strtotime($popupdelivery));
      $latequickbook_delivery = date('Y-m-d H:i:s',strtotime('+1 hour',strtotime($earlyquickbook_delivery)));
    }
    $earlyquickbook_pickup = $latequickbook_pickup = "";
    if($popuppickup != ""){
      $earlyquickbook_pickup = date('Y-m-d H:i:s',strtotime($popuppickup));
      $latequickbook_pickup = date('Y-m-d H:i:s',strtotime('+1 hour',strtotime($earlyquickbook_pickup)));
    }
    $popuporder_type = isset($post['popuporder_type']) ? $post['popuporder_type'] : "";
    $popupmodeof_trasnport = isset($post['popupmodeof_trasnport']) ? $post['popupmodeof_trasnport'] : "LTL";

    $reference_ids = isset($post['quickbookreference_ids']) ? $post['quickbookreference_ids'] : "0";
    $quickbook_order_reference_ids = isset($post['quickbook_order_reference_ids']) ? $post['quickbook_order_reference_ids'] : "0";
    $order_cargo_id = isset($post['quickbookorder_cargo_id']) ? $post['quickbookorder_cargo_id'] : "";
    $inv_parties = array($post['quickbookshipper_id'],$post['quickbookconsignee_id']);
    $pickup = isset($post['quickbookpickup_id']) ? $this->db->escape_str($post['quickbookpickup_id']) : "0";
    if ($pickup == "") {
        $pickup = 0;
    }
    $delivery = $this->db->escape_str($post['quickbookdelivery_id']);
    $drop_id = $pickup_custid = 0;
      $pickup_name = $pickup_country = $pickup_street = $pickup_state = $drop_state = $pickup_pincode = $pickup_city =$drop_name = $drop_country = $drop_street = $drop_pincode = $drop_city = "";
    $getdrop_custid= $this->db->query("SELECT name,country,state,street,customeridentifier,pincode,location_id as city FROM tbl_party_master WHERE id='".$delivery."'");
    if($getdrop_custid->num_rows() >0){
      $drop_id = $getdrop_custid->row()->customeridentifier;
      $drop_name = $getdrop_custid->row()->name;
        $drop_country = $getdrop_custid->row()->country;
        $drop_state = $getdrop_custid->row()->state;
        $drop_street = $getdrop_custid->row()->street;
        $drop_pincode = $getdrop_custid->row()->pincode;
        $drop_city = $getdrop_custid->row()->city;
    }
    $getshippercustid= $this->db->query("SELECT name,country,state,street,customeridentifier,pincode,location_id as city FROM tbl_party_master WHERE id='".$pickup."'");
    if($getshippercustid->num_rows() >0){
        $pickup_custid = $getshippercustid->row()->customeridentifier;
        $pickup_name = $getshippercustid->row()->name;
        $pickup_country = $getshippercustid->row()->country;
        $pickup_state = $getshippercustid->row()->state;
        $pickup_street = $getshippercustid->row()->street;
        $pickup_pincode = $getshippercustid->row()->pincode;
        $pickup_city = $getshippercustid->row()->city;
    }
    $tname = "Full Truck Load";
    $tid ="FTL";
     $enddate = date('Y-m-d H:i:s',strtotime("+1 day"));
       $tid = 1; $tname = "";
      $gettrasnportmode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '".$popupmodeof_trasnport."'");
        if($gettrasnportmode->num_rows() >0){
          $tid = $gettrasnportmode->row()->id;
          $tname= $gettrasnportmode->row()->name;
        }
        if($shipment_id == ""){
            $shipment_id = "SVK".time();
        }
        $ship_row_id = 0;
        $ship_arr = array(
        'shipid'=>$shipment_id,
        'txnid'=>$shipment_id,
        'trucktype'=>$tname,
        'pickupcnt'=>'1',
        'dropcnt'=>'1',
        'insertusr'=>$pickup_custid,
        'carrier'=>'0',
        'insertuserdate'=>$cdate,
        'enddate'=>$enddate,
        'insdate'=>$cdate,
        'upddate'=>$cdate,
        'reason'=>'SHIPMENT',
        'purpose'=>'SEND INTEGRATION','ship_object'=>'SHIPMENT',
        'logdate'=>$cdate,'transport_mode'=>$popupmodeof_trasnport,'domainname'=>$branch_code,'company_code'=>$company_code,'branch_code'=>$branch_code,'product'=>$product,
        'freight_term'=>'60','freight_termname'=>'Free of Charge','incoterm'=>$incoterm,
        'modeoftransport'=>$tid,
        'unitspec'=>1
        );
      $chk_shipid= $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '".$shipment_id."'");

      if($chk_shipid->num_rows() >0){
        $ship_row_id = $chk_shipid->row()->id;
        $this->db->where(array('id'=>$ship_row_id))->update("tb_shipments",$ship_arr);
      }else{

       $ship_arr['createdon'] = $cdate;
        $ship_ins = $this->db->insert("tb_shipments",$ship_arr);
        $ship_row_id = $this->db->insert_id();
      }
     $add1 = implode(",",[$pickup_street,$pickup_city,$pickup_country,$pickup_pincode]);
      $add2 = implode(",",[$drop_street,$drop_city,$drop_country,$drop_pincode]);
      $data = getlatlngsbyplace($add1);
      $lat1 = @$data[0];
      $lng1 = @$data[1];
      $data = [];
      $data = getlatlngsbyplace($add2);
      $lat2 = @$data[0];
      $lng2 = @$data[1];
      $customer_id = 0;
      if($cust_id == ""){
        $customer_id = $pickup;
      }else{
        $customer_id = $cust_id;
      }
      if($this->session->userdata('company_code') == 'NZKN'){
        if($product == ""){
          $product = "KN AsiaLink";
        }
        if($popupmodeof_trasnport == ""){
          $popupmodeof_trasnport = "LTL";
        }
        if($service == ""){
          $service = "19";
        }
      }
      $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
        $logdate = $getactual['datetime'];
        $getpickup = getdatetimebytimezone(DFLT_TZ,$earlyquickbook_pickup,$curtz);
        $earlyquickbook_pickup = $getpickup['datetime'];
        $getlpickup = getdatetimebytimezone(DFLT_TZ,$latequickbook_pickup,$curtz);
        $latequickbook_pickup = $getlpickup['datetime'];
        $getdelivery = getdatetimebytimezone(DFLT_TZ,$earlyquickbook_delivery,$curtz);
        $earlyquickbook_delivery = $getdelivery['datetime'];
        $getldelivery = getdatetimebytimezone(DFLT_TZ,$latequickbook_delivery,$curtz);
        $latequickbook_delivery = $getldelivery['datetime'];
    $ins = array('goods_value'=>'0.00','shipment_id'=>$ship_row_id,'customer_id'=>$customer_id,
    'product'=>$product,
    'company_code'=>$company_code,'branch_code'=>$branch_code,
    'createdon'=>$cdate,'pickup_datetime'=>$earlyquickbook_pickup,'delivery_datetime'=>$earlyquickbook_delivery,'pickup_endtime'=>$latequickbook_pickup,'drop_endtime'=>$latequickbook_delivery,'drop_custid'=>$drop_id,
    'drop_partyid'=>$drop_id,
    'user_id'=>$user_id,'pickup_custid'=>$pickup_custid,'pickup_partyid'=>$pickup_custid,'pickup_country'=>$pickup_country,'pickup_city'=>$pickup_city,'pickup_pincode'=>$pickup_pincode,'pickup_company'=>$pickup_name,'pickup_address1'=>$pickup_street,'delivery_country'=>$drop_country,'delivery_city'=>$drop_city,'delivery_pincode'=>$drop_pincode,'delivery_company'=>$drop_name,'delivery_address1'=>$drop_street,'pickup_address2'=>$pickup_state,'delivery_address2'=>$drop_state,'transport_mode'=>$popupmodeof_trasnport,'plat'=>$lat1,
    'plng'=>$lng1,
    'dlat'=>$lat2,
    'dlng'=>$lng2,
    'modeoftransport'=>$tid,
    'created_source'=>'3',
    'createdon'=>$logdate,
    'shipper_id' => $popupshipper_id,
    'consignee_id' => $popupconsignee_id);
    $ins_order = $this->db->insert("tb_orders",$ins);
    $order_id = $this->db->insert_id();
    $user_id = $this->session->userdata('user_id');
    if($user_id != ""){
    $get_country = $this->db->select('country_code,company_code')->get_where("tb_users",array('id'=>$user_id));
    $country_code  = $get_country->row()->country_code;
    $company_code  = $get_country->row()->company_code;
    $genord = array(
        "user_id"=>$user_id,
        "order_id"=>$order_id,"country_code"=>$country_code,"company_code"=>$company_code
    );
    $booking_id = generatebookingid($genord);
    $upd = $this->db->where(array('id'=>$order_id))->update("tb_orders",array('order_id'=>$booking_id));
    $invtypes = makeorderinvolvedpartiestype($customer_id, $order_id, "CUSTOMER", $user_id, $company_code);
    insertOrdersRefFileLineIdentifier(['pickupCity' => $pickup_city, 'pickupState' => $pickup_state, 'pickupCountry' => $pickup_country, 'dropCity' => $drop_city, 'dropState' => $drop_state, 'dropCountry' => $drop_country, 'companyCode' => $company_code, 'branchCode' => $branch_code, 'orderRowId' => $order_id, 'date' => $cdate]);
    $details = array('shipper_id'=>$post['quickbookshipper_id'],'service'=>$service,'delivery_term'=>$delivery_terms,'incoterm'=>$incoterm,'purchase_order'=>$porder,'notify_party'=>$notify_party,'department_code'=>$department_code,'createdon'=>$cdate,'order_row_id'=>$order_id,'order_id'=>$booking_id,'order_type'=>$popuporder_type);
    $this->db->insert('tb_order_details',$details);
    }
    $order_shipper_id = isset($post['quickbookshipper_id']) ? $post['quickbookshipper_id'] : "";
    $order_consignee_id = isset($post['quickbookconsignee_id']) ? $post['quickbookconsignee_id'] : "";
    if($order_shipper_id >0){
        $order_shipper_id = $order_shipper_id;
    }else{
        $order_shipper_id = $pickup;
    }
    if($order_consignee_id >0){
        $order_consignee_id = $order_consignee_id;
    }else{
        $order_consignee_id = $delivery;
    }
    $pickup_address = $pickup_street.",".$pickup_city.",".$pickup_state;
   $shipper_address    = array('order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $pickup_address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id);
      $chk_shipperaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $order_shipper_id));
      if ($chk_shipperaddress->num_rows() > 0) {
          $shipperadd_id = $chk_shipperaddress->row()->id;
          $upd_add       = $this->db->where(array('id' => $shipperadd_id))->update("tbl_orderparty_address", $shipper_address);
      } else {
          $shipper_address['createdon'] = $cdate;
          $this->db->insert("tbl_orderparty_address", $shipper_address);
          $shipperadd_id = $this->db->insert_id();
      }
      $drop_address = $drop_street.",".$drop_city.",".$drop_state;
      $delivery_address    = array('order_id' => $order_id, 'party_master_id' => $delivery, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $drop_address, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id);
      $chk_deliveryaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $delivery));
      if ($chk_deliveryaddress->num_rows() > 0) {
          $dropadd_id = $chk_deliveryaddress->row()->id;
          $upd_add    = $this->db->where(array('id' => $dropadd_id))->update("tbl_orderparty_address", $delivery_address);
      } else {
          $delivery_address['createdon'] = $cdate;
          $this->db->insert("tbl_orderparty_address", $delivery_address);
          $dropadd_id = $this->db->insert_id();
      }
    if($order_cargo_id != ""){
      $cargo_ids = array();
        $cargo_ids = explode(',', $order_cargo_id);

        for($i=0;$i<count($cargo_ids);$i++){
           $length =
                  $width =  $height = $weight = $volume = $second_weight= $second_volume = 0;
                  $quantity = 1;
            if($cargo_ids[$i] != ""){
                $getcargo_details = $this->db->query("SELECT cargo_type,goods_description,length,width,height,weight,volumetric_weight,volume,second_weight,second_volume,quantity,marks_numbers FROM tb_cargo_details WHERE id='".$cargo_ids[$i]."'");
                $length = $width = $height = $weight = $volume = $quantity = $cargo_type = $description= "";
                if($getcargo_details->num_rows() >0){
                  $length = $getcargo_details->row()->length;
                  $width = $getcargo_details->row()->width;
                  $height = $getcargo_details->row()->height;
                  $weight = $getcargo_details->row()->weight;
                  $volume = $getcargo_details->row()->volume;
                  $quantity = $getcargo_details->row()->quantity;
                  $volumetric_weight = $getcargo_details->row()->volumetric_weight;
                  $cargo_type = $getcargo_details->row()->cargo_type;
                  $description = $getcargo_details->row()->goods_description;
                    $second_weight = $getcargo_details->row()->second_weight;
                  $second_volume = $getcargo_details->row()->second_volume;
                  $marks_numbers = $getcargo_details->row()->marks_numbers;
                }
                $gethandling_unit = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE '".$cargo_type."'");
              $handling_unit = "";
              if($gethandling_unit->num_rows() >0){
                $handling_unit = $gethandling_unit->row()->id;
              }else{
                $handlingunit_ar = array('unit_name'=>$cargo_type,'description'=>$cargo_type,'user_id'=>$user_id,'created_at'=>$cdate,'status'=>'1');
                $this->db->insert("tbl_shipunit_types",$handlingunit_ar);
                $handling_unit = $this->db->insert_id();
              }
            $cargo = array('order_id'=>$order_id,'cargo_id'=>$cargo_ids[$i],'status'=>'1','length'=>$length,'width'=>$width,'height'=>$height,'weight'=>$weight,'volume'=>$volume,'quantity'=>$quantity,'cargo_content'=>$description,'quantity_type'=>$cargo_type,'handling_unit'=>$handling_unit,'volumetric_weight'=>$volumetric_weight,'volweight_uom'=>'kg','second_weight'=>$second_weight,'second_volume'=>$second_volume,'marks_numbers'=>$marks_numbers);
            $this->db->insert("tb_order_cargodetails",$cargo);
            }
        }
    }
     $total_weight = $total_volume = $total_quantity = 0;
      $gettotal = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='".$order_id."'");
      if($gettotal->num_rows() >0){
        $total_volume = $gettotal->row()->total_volume;
        $total_weight = $gettotal->row()->total_weight;
        $total_quantity = $gettotal->row()->total_quantity;
      }
       $cargo_forship = array();
      $getcargos  = $this->db->query("SELECT quantity_type FROM tb_order_cargodetails WHERE order_id ='".$order_id."'");
      if($getcargos->num_rows() >0){
        foreach($getcargos->result() as $res){
          $cargo_forship[] = $res->quantity_type;
        }
      }
      $unitspec = "";
      if(!empty($cargo_forship)){
        $unitspec = implode(',', $cargo_forship);
      }
      $updship = $this->db->where(array('id'=>$ship_row_id))->update("tb_shipments",array('unitspec'=>$unitspec,'txncode'=>$booking_id));
       $upd_order = $this->db->where(array('id'=>$order_id))->update("tb_orders",array('volume'=>$total_volume,'weight'=>$total_weight,'quantity'=>$total_quantity));
    $ids = array();
    if($reference_ids != "0"){
      $refids = explode(',', $reference_ids);
    }
    $order_ref_ids = array();
    if($quickbook_order_reference_ids != "0"){
      $order_ref_ids = explode(',', $quickbook_order_reference_ids);
    }
    if(!empty($order_ref_ids)){
      for($i=0;$i<count($order_ref_ids);$i++){
          if($order_ref_ids[$i] != ""){
              $upd = $this->db->where(array('id'=>$order_ref_ids[$i]))->update("tb_order_references",array('order_id'=>$order_id));
          }
    }
    }
    if($shipment_id != ""){
        $ins_ref = array('order_id'=>$order_id,'reference_id'=>'DQ','ref_value'=>$shipment_id,'createdon'=>$cdate);
        $ins = $this->db->insert('tb_order_references',$ins_ref);
    }
       if($porder != ""){
        $ins_ref = array('order_id'=>$order_id,'reference_id'=>'PO','ref_value'=>$porder,'createdon'=>$cdate);
        $ins = $this->db->insert('tb_order_references',$ins_ref);

      }
      $cust_parties = array();
      $cust_parties['0'] = $order_shipper_id;
      $cust_parties['1'] = $order_consignee_id;
      $cust_parties['2'] = $pickup;
      $cust_parties['3'] = $delivery;
      if (!empty($cust_parties)) {
       subcustpartiesinsert($order_id, $booking_id, $cust_parties);
      }

    $this->ordernotify('booking_create',$order_id);
    $customerCode = $post['popupcustomer_id'] ?? "";
    $preferenceArray = [
        'pickup' => strtoupper($pickup_country),
        'pickup_state' => strtoupper($pickup_state),
        'pickup_city' => strtoupper($pickup_city),
        'pickup_pincode' => $pickup_pincode,
        'drop' => strtoupper($drop_country),
        'drop_state' => strtoupper($drop_state),
        'drop_city' => strtoupper($drop_city),
        'drop_pincode' => $drop_pincode,
        'customer_id' => $customerCode,
        'service' => $service,
        'product' => $product,
        'user_id' => $user_id,
        'company_code' => $company_code,
        'order_id' => $order_id,
        'order_type' => $popuporder_type,
        'customer_row_id' => $customer_id,
    ];
    $this->ratemanagement->addrecodfororderinsertion($preferenceArray);
    if($order_id != "" && $order_id !='0'){
        redirect('smtccustorders/orderslist/'.$order_id);
        $this->session->set_flashdata('success_msg','Order Created Successfully - '.$booking_id);
    }else{
        redirect("smtccustorders");
    }

}

    public function gettripcarinfo($id)
    {
        $result = array();
        if ($id != "") {
            $vendor_list = $this->db->select("code")->get_where("tb_vendors", array('id' => $id));
            if ($vendor_list->num_rows() > 0) {
                $result['carrier_name'] = $vendor_list->row()->code;
            }
            $drivers = '<select class="add_company Txtfld tripcar_id form-control" id="tdri_name" onchange="getdrid()"
            form="tripcreation" style="margin-top:4px;">
            <option value="">--Select--</option>';
            $drivers_list = $this->db->select("id,name")->get_where("tb_truck_drivers", array('vendor_id' => $id,
                'status'                                                                                      => 'Active'));
            if ($drivers_list->num_rows() > 0) {
                foreach ($drivers_list->result() as $row) {
                    $drivers .= '<option value="' . $row->id . '">' . $row->name . '</option>';
                }
            }
            $drivers .= '</select>';
            $result['drivers'] = $drivers;
        }
        echo json_encode($result);
    }
    public function gettripvelinfo()
    {
        $result    = array();
        $post      = $this->input->post(NULL,TRUE);
        $id        = $post['vtype'];
        $carrierid = $post['carrierid'];
        $res       = '';
        $vtypename = $this->db->select("description")->get_where("tb_trucktypes",
            array('id' => $id));
        if ($vtypename->num_rows() > 0) {
            $res = $vtypename->row()->description;
        }
        $result['typename'] = $res;
        $vehres             = '<select name="tvehnum" id="tvehnum" onchange="myfun()"
        form="tripcreation" class="Txtfld tripcar_id form-control" style="margin-top:4px;"><option value="">--Select--</option>';
        $vehile_list = $this->db->select("id,truck_number,register_number")->get_where("tb_trucks_data", array('truck_type' => $id, 'vendor_id' => $carrierid));
        /*$vehile_list =  $this->db->select("select td.id,td.truck_number,td.register_number from tb_trips tp,`tb_trucks_data` td where tp.vehicle_id=td.id and tp.transit_status=0 and td.truck_type='".$id."' AND td.vendor_id='".$carrierid."'");*/
        if ($vehile_list->num_rows() > 0) {
            foreach ($vehile_list->result() as $vehi) {
                $vehres .= '<option value="' . $vehi->id . '">' . $vehi->truck_number . '</option>';
            }
        }
        $vehres .= '</select>';
        $result['vehiclenum'] = $vehres;
        echo json_encode($result);
    }
    public function getvelinfo($id)
    {
        $result            = array();
        $result['transit'] = 0;
        if ($id != "") {
            $vendor_list = $this->db->select("truck_number")->get_where("tb_trucks_data", array('id' => $id));
            if ($vendor_list->num_rows() > 0) {
                $result['vehid'] = $vendor_list->row()->truck_number;
            }
            $trip_transit = $this->db->select("id")->get_where("tb_trips", array('vehicle_id' => $id, 'status' => 1));
            if ($trip_transit->num_rows() > 0) {
                $result['vehid']   = '';
                $result['transit'] = 1;
            }
        }
        echo json_encode($result);

    }
    public function getdriverid($id)
    {
        $res = '';
        if ($id != "") {
            $driver_list = $this->db->select("contact_num")->get_where("tb_truck_drivers", array('id' => $id), 1, 0);
            if ($driver_list->num_rows() > 0) {
                $res = $driver_list->row()->contact_num;
            }
        }
        echo $res;
    }

    public function triporderintoshipment()
    {
        $response = 0;
        $userid = $this->session->userdata('user_id');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
        $curdt = $getactual['datetime'];
        $input = $this->input->post(null,true);
        $shipid = $input['ship_id'];
        $vendor_id=$input['carrierid'];
        $vehicle_id = isset($input['tvehnum']) ? $input['tvehnum'] : "";
        $driver_id = isset($input['tdrivernum']) ? $input['tdrivernum'] : "";
        $tpvehicle_type=isset($input['vehicle_type']) ? $input['vehicle_type'] : 0;
        $vehicle_type = "";
        if($shipid != "" && $vendor_id > 0 && $input['ordid'] >0){
            $sid = $input['ordid'];
            $where = array("id"=>$input['ordid']);
            $select = "*";
            $table = "tb_orders";
            $order = $this->common->gettblrowdata($where,$select,$table,0,0);
            if(count($order)>0){
              $shift_idchk = $order['shift_id'];
              if($shift_idchk == 0){
                $stops_units = $this->db->query("SELECT oc.id,oc.quantity,oc.width,oc.height,oc.length,oc.weight,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.order_id = '$sid' AND im.id = oc.handling_unit AND oc.status='1'");
                $pickup = $order['pickup_address1'];
                if($pickup == ""){ $pickup = $order['pickup_city']; }
                $delivery = $order['delivery_address1'];
                if($delivery == ""){ $delivery = $order['delivery_city']; }
                $address = $dropaddr = "";
                if($order['pickup_address1'] != ""){
                    $address .= $order['pickup_address1'];
                    $dropaddr .= $order['delivery_address1'];
                }
                if($order['pickup_company'] != ""){
                    $address .= ", ".$order['pickup_company'];
                    $dropaddr .= ", ".$order['delivery_company'];
                }
                if($order['pickup_country'] != ""){
                    $address .= ", ".$order['pickup_country'];
                    $dropaddr .= ", ".$order['delivery_country'];
                }
                if($order['pickup_city'] != ""){
                    $address .= ", ".$order['pickup_city'];
                    $dropaddr .= ", ".$order['delivery_city'];
                }
                if($order['pickup_pincode'] != ""){
                    $address .= ", ".$order['pickup_pincode'];
                    $dropaddr .= ", ".$order['delivery_pincode'];
                }
                $plat = $order['plat'];
                $plng = $order['plng'];
                $dlat = $order['dlat'];
                $dlng = $order['dlng'];
                $where = array("shipmentid"=>$shipid);
                $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                $table = "tb_shifts";
                $shipment = $this->common->gettblrowdata($where,$select,$table,0,0);
                if(count($shipment)==0){
                  $curdt = $logdate;
                  $splace = $order['pickup_address1'];
                  $eplace = $order['delivery_address1'];
                  $pickup_city = $order['pickup_city'];
                  $delivery_city = $order['delivery_city'];
                  $customer_id = $order['customer_id'];
                  $transport_mode= $order['transport_mode'];
                  $weight= $order['weight'];
                  $volume= $order['volume'];
                  $txnid = $shipid;
                  if($tpvehicle_type!='' && $tpvehicle_type != 0){
                    $vtwhere = array("id"=>$tpvehicle_type);
                    $vtselect = "trucktype";
                    $vttable = "tb_trucktypes";
                    $vtorder = $this->common->gettblrowdata($vtwhere,$vtselect,$vttable,0,0);
                    if(count($vtorder)>0){
                      $vehicle_type = $vtorder['trucktype'];
                  }else{
                      $vehicle_type = $order['vehicle_type'];
                  }
              }else{
                $vehicle_type = $order['vehicle_type'];
            }
            $startdate = $order['pickup_datetime'];
            $starttime = date('H:i',strtotime($startdate));
            $enddate = $order['delivery_datetime'];
            $endtime = date('H:i',strtotime($enddate));
            $getactual = getdatetimebytimezone(DFLT_TZ,$enddate,$curtz);
            $enddate = $getactual['datetime'];
            $insarr = array('user_id'=>$userid, 'stime'=>$starttime, 'etime'=>$endtime, 'splace'=>$order['pickup_city'], 'slat'=>$plat, 'slng'=>$plng, 'eplace'=>$order['delivery_city'], 'elat'=>$dlat, 'elng'=>$dlng, 'scity'=>$order['pickup_city'], 'dcity'=>$order['delivery_city'], 'zone_id'=>1, 'empshift_start'=>$starttime, 'empshift_end'=>$endtime, 'trip_type'=>0, 'startdate'=>$startdate, 'enddate'=>$enddate, 'shipment_name'=>'Boxes', 'shipment_id'=>0, 'transport_mode'=>$transport_mode, 'customer_id'=>$customer_id, 'vendor_id'=>$vendor_id, 'carrier_type'=>0, 'shipmentid'=>$txnid, 'txnid'=>$txnid,'weight'=>$weight, 'volume'=>$volume, 'units'=>$order['quantity'],'domainname'=>'INFD', 'vehicle_type'=>$vehicle_type, 'status'=>1);
            $this->db->insert("tb_shifts", $insarr);
            $ship_id = $this->db->insert_id();
        }else{
          $ship_id = $shipment['id'];
      }
      /*update order table*/
      $upddt = array('vendor_id'=>$vendor_id,'shift_id'=>$ship_id,"shipmentid"=>$txnid);
      $updwhr = array("id"=>$input['ordid']);
      $upd = $this->common->updatetbledata("tb_orders",$upddt,$updwhr);
      $insarr = array('assoc_id'=>$shipid, 'pickup'=>$pickup, 'plat'=>$plat,
        'plng'=>$plng, 'drop'=>$delivery,'dlat'=>$dlat, 'dlng'=>$dlng,
        'pickup_city'=>$order['pickup_city'], 'drop_city'=>$order['delivery_city'],
        'pickup_datetime'=>$order['pickup_datetime'], 'drop_datetime'=>$order['delivery_datetime'],
        'name'=>'Boxes', 'phone'=>$order['customer_phone'],
        'address'=>$address,'emailid'=>$order['customer_email'],
        'user_id'=>$userid, 'status'=>1,
        'createdon'=>$curdt, 'material_id'=>0,
        'capacity'=>$order['weight'],
        'information'=>$order['customer_comments'],
        'shipment_weight'=>$order['weight'],
        'shipment_volume'=>$order['volume'],
        'ship_type'=>'P', 'customer_id'=>$order['customer_id'],
        'vendor_id'=>$vendor_id, 'shipment_id'=>0, 'startdate'=>$order['pickup_datetime'],
        'enddate'=>$order['delivery_datetime'], 'shift_id'=>$ship_id, 'stop_order'=>1,
        'drop_order'=>0, 'basic_stop'=>0, 'stop_id'=>0, 'drop_stopid'=>0, 'order_id'=>$order['order_id'],
        'pkgitemid'=>'BOXES', 'no_of_pkgs'=>$order['quantity'], 'domainname'=>'INFD');
      $ins = $this->db->insert("tb_employee",$insarr);
      $detail_id = $this->db->insert_id();
      if($detail_id > 0 ){
          if($stops_units->num_rows()>1){
            $odata=$stops_units->row();
            $upd = $this->db->query("UPDATE tb_order_cargodetails set status='0',stop_detail_id='$detail_id' WHERE id = '".$odata->id."'");
        }
        /*update orders table*/
        $updwhr = array('id'=>$input['ordid']);
        $setwhr = array('status'=>2);
        $ins = $this->db->where($updwhr)->update("tb_orders",$setwhr);
        /*insert stops records */
        $where = array("shipment_id"=>$ship_id,"stopcity"=>$order['pickup_city'],"stoptype"=>"P");
        $select = "id";
        $table = "tb_shiporder_stops";
        $chkstop = $this->common->gettblrowdata($where,$select,$table,0,0);
        if(count($chkstop) == 0){
            $insarr = array('stopname'=>$order['pickup_city'], 'plat'=>$plat, 'plng'=>$plng, 'stopcity'=>$order['pickup_city'], 'address'=>$address, 'stoptype'=>'P', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>1, 'startdate'=>$order['pickup_datetime'], 'enddate'=>$order['delivery_datetime'], 'weight'=>$order['weight'], 'volume'=>$order['volume'], 'shipmentstopid'=>0, 'ship_units'=>$order['quantity'], 'txncode'=>'NP', 'status'=>1, 'created_on'=>$curdt);
            $ins = $this->db->insert("tb_shiporder_stops",$insarr);
            $pickupstop_id = $this->db->insert_id();
        }else{
            $pickupstop_id = $chkstop['id'];
        }
        $where = array("shipment_id"=>$ship_id,"stopcity"=>$order['delivery_city'],"stoptype"=>"D");
        $select = "id";
        $table = "tb_shiporder_stops";
        $chkstop = $this->common->gettblrowdata($where,$select,$table,0,0);
        if(count($chkstop) == 0){
            $insarr = array('stopname'=>$order['delivery_city'], 'plat'=>$dlat, 'plng'=>$dlng, 'stopcity'=>$order['delivery_city'], 'address'=>$dropaddr, 'stoptype'=>'D', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>2, 'startdate'=>$order['delivery_datetime'], 'enddate'=>$order['delivery_datetime'], 'weight'=>$order['weight'], 'volume'=>$order['volume'], 'shipmentstopid'=>0, 'ship_units'=>$order['quantity'], 'txncode'=>'NP', 'status'=>1, 'created_on'=>$curdt);
            $ins = $this->db->insert("tb_shiporder_stops",$insarr);
            $dropstop_id = $this->db->insert_id();
        }else{
            $dropstop_id = $chkstop['id'];
        }
        /*update pickupstop and drop stop id into details/tb_employee table */
        $setarr = array('stop_id'=>$pickupstop_id, 'drop_stopid'=>$dropstop_id);
        $setwhr = array('id'=>$detail_id);
        $ins = $this->db->where($setwhr)->update("tb_employee",$setarr);
        $chk1 = $this->db->select("id")->get_where("tb_shft_veh",array("shft_id"=>$ship_id),1,0);
        if($chk1->num_rows() > 0){
            $shftvehid = $chk1->row()->id;
            $chk = $this->db->select("id")->get_where("tb_shft_veh_emp",array("shft_veh_id"=>$shftvehid,"status"=>1),1,0);
            if($chk->num_rows() == 0){
              $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee",array("shift_id"=>$ship_id));
              if($getemp->num_rows()>0){
                $pri = 1;
                foreach($getemp->result() as $gt){
                  $insveh1 = array("user_id"=>$userid,"shft_veh_id"=>$shftvehid,"emp_id"=>$gt->id,"priority"=>$pri,"pickup_time"=>$gt->pickup_datetime, 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$gt->drop_datetime);
                  $ins = $this->db->insert("tb_shft_veh_emp",$insveh1);
                  $pri++;
              }
          }
      }else{
          $chkemp = $this->db->select("id")->get_where("tb_shft_veh_emp",array("shft_veh_id"=>$shftvehid,"emp_id"=>$detail_id,"status"=>1),1,0);
          if($chkemp->num_rows() == 0){
            $insveh1 = array("user_id"=>$userid,"shft_veh_id"=>$shftvehid,"emp_id"=>$detail_id,"priority"=>3,"pickup_time"=>$order['pickup_datetime'], 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$order['delivery_datetime']);
            $ins = $this->db->insert("tb_shft_veh_emp",$insveh1);
        }
    }
}else{
    if($vehicle_id != ""){
      $veh_num = isset($input['vehicle_id']) ? $input['vehicle_id'] : "";
      $arr = array('user_id'=>$userid, 'route_id'=>0, 'shft_id'=>$ship_id, 'carrier_id'=>$vendor_id, 'vehicle_id'=>$vehicle_id, 'register_number'=>$veh_num, 'status'=>1);
      $ins = $this->db->insert("tb_shft_veh",$arr);
      $shftvehid = $this->db->insert_id();
      $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee",array("shift_id"=>$ship_id));
      if($getemp->num_rows()>0){
        $pri = 1;
        foreach($getemp->result() as $gt){
          $insveh1 = array("user_id"=>$userid,"shft_veh_id"=>$shftvehid,"emp_id"=>$gt->id,"priority"=>$pri,"pickup_time"=>$gt->pickup_datetime, 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$gt->drop_datetime);
          $ins = $this->db->insert("tb_shft_veh_emp",$insveh1);
          $pri++;
      }
  }
}
if($vehicle_id != "" && $driver_id != ""){
  $chk = $this->db->select("id,driver_id,status")->order_by("id","DESC")->get_where("tb_vehicles_drivers",array("vehicle_id"=>$vehicle_id));
  if($chk->num_rows()>0){
    if($driver_id == $chk->row()->driver_id){
      $upd = $this->db->where(array("id"=>$chk->row()->id))->update("tb_vehicles_drivers",array("status"=>1));
  }else{
      $arr = array('vehicle_id'=>$vehicle_id, 'driver_id'=>$driver_id, 'imei'=>"", 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
      $ins = $this->db->insert("tb_vehicles_drivers",$arr);
  }
}else{
    $arr = array('vehicle_id'=>$vehicle_id, 'driver_id'=>$driver_id, 'imei'=>"", 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
    $ins = $this->db->insert("tb_vehicles_drivers",$arr);
}
$chk11 = $this->db->select("id")->get_where("tbl_assigned_drivers",array("driver_id"=>$driver_id,"vehicle_id"=>$vehicle_id),1,0);
if($chk11->num_rows()>0){
    $upd = $this->db->where(array("id"=>$chk11->row()->id))->update("tbl_assigned_drivers",array("status"=>"1",'updated_on'=>$curdt));
}else{
    $chk111 = $this->db->select("id")->get_where("tbl_assigned_drivers",array("driver_id <>"=>$driver_id,"vehicle_id"=>$vehicle_id,"status"=>1),1,0);
    if($chk111->num_rows() == 0){
      $ins = $this->db->insert("tbl_assigned_drivers",array("vehicle_id"=>$vehicle_id,"user_id"=>$userid,"driver_id"=>$driver_id,"mobile_no"=>$driver_id,"imei"=>$imei,"from_time"=>$curdt,"to_time"=>$curdt,"status"=>"1",'created_on'=>$curdt));
  }else{
      $upd = $this->db->where(array("id"=>$chk111->row()->id))->update("tbl_assigned_drivers",array("driver_id"=>$driver_id,'updated_on'=>$curdt));
  }
}
}
}
$response = 1;
/* update status */
$chk = $this->db->select("id")->get_where("tb_stop_status",array("shipment_id"=>$ship_id,"status_id"=>9),1,0);
if($chk->num_rows() == 0){
    $curtz = $this->session->userdata("usr_tzone")['timezone'];
    $logdate = date('Y-m-d H:i:s');
    $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
    $curdt1 = $getactual['datetime'];
    $ins = array("shipment_id"=>$ship_id,"stop_id"=>0,"stop_detail_id"=>0,"stop_type"=>"","trip_id"=>0,"status_id"=>9,"status"=>1,"status_code"=>"0100","reason"=>"Coming from E-Booking","createdon"=>$curdt1);
    $insqry = $this->db->insert("tb_stop_status",$ins);
}
/*send email notification*/
if($vendor_id != ""){
    $chkven = $this->db->select("name,email")->get_where("tb_vendors",array("id"=>$vendor_id),1,0);
    if($chkven->num_rows()>0){
      $chkven1 = $this->db->select("name,emailid")->get_where("tb_users",array("id"=>$userid),1,0);
      if($chkven1->num_rows()>0){
        $sendername = $chkven1->row()->name;
        $senderemail = $chkven1->row()->emailid;
        if($senderemail == ""){
          $senderemail = "svkonekt@kuehne-nagel.com";
          $sendername = "svkonekt";
      }
      $receivename = $chkven->row()->name;
      $receivemail = $chkven->row()->email;
      $newsub = "svkonekt: Booked by Supplier for Order#".$order['order_id'];
      $data11['page_title'] = "Booked by Supplier";
      $data11['receivename'] = $receivename;
      $order['vehicle_type'] = $vehicle_type;
      $data11['order'] = $order;
      if($receivemail != ""){
        $this->load->library('email');
        $body = $this->load->view('mail_forms/bookedbysupplier', $data11, true);
        /*$this->email->from($senderemail, $sendername);*/
        $this->email->from('svkonekt@kuehne-nagel.com', 'Svkonekt');
        $this->email->to($receivemail, $receivename);
        $this->email->cc('external.ram.k@kuehne-nagel.com', "RCREDDY");
        $this->email->subject($newsub);
        $this->email->set_mailtype("html");
        $this->email->message($body);

          if(!$this->email->send()){
              log_message("error",$this->email->print_debugger());
          }

          $this->email->clear(true);
     }
    }
    }

}
}
}
}
}
if($response == 1){
    $this->session->set_flashdata('success_msg','Trip Created successfully..');
}else{
    $this->session->set_flashdata('error_msg','Oops..Something Went Wrong.');
}
redirect('smtccustorders');
}
/* code for trip management */
public function orderlabel($order_id)
{
    $data = $order_types = array();
    require 'vendor/autoload.php';
    $cargos               = array();
    $reference            = $shipmentnumber            = $communication_reference            = $date            = "";
    $drop_details['name'] = $drop_details['street'] = $drop_details['country'] = $drop_details['pincode'] = $shipper_details['name'] = $shipper_details['street'] = $shipper_details['country'] = $shipper_details['pincode'] = $shipper_details['city'] = $data['count'] = $data['weight'] = "";
    $cargos               = $drop_details               = $shipper_details               = array();
    if ($order_id != "") {
        if ($this->session->userdata('cust_id') == true) {
            $upd_orderstatus = $this->db->where(array('id' => $order_id))->update("tb_orders", array('order_status' => 'READY'));
        }
        $chkorder = $this->smtcorder->getordertoedit($order_id);
        if ($chkorder->num_rows() > 0) {
            $date      = $chkorder->row()->pickup_datetime;
            $reference = $chkorder->row()->shipment_id;
            if ($reference != "" && $reference != 0) {

                $getshipment_number = $this->db->select("shipid")->get_where("tb_shipments", array('id' => $reference));
                if ($getshipment_number->num_rows() > 0) {
                    $reference = $getshipment_number->row()->shipid;
                }
            }
            $shipmentnumber          = $chkorder->row()->order_id;
            $communication_reference = $chkorder->row()->purchase_order;

            $drop_id        = $chkorder->row()->drop_custid;
            $drop_row_id    = 0;
            $getdropdetails = $this->smtcorder->getpartydetailsbycid($drop_id);
            if ($getdropdetails->num_rows() > 0) {
                $drop_row_id  = $getdropdetails->row()->id;
                $drop_details = array('id' => $getdropdetails->row()->id, 'name' => $getdropdetails->row()->name, 'phone' => $getdropdetails->row()->mobile, 'email' => $getdropdetails->row()->email, 'fax' => $getdropdetails->row()->fax, 'party_id' => $getdropdetails->row()->customeridentifier);
            }
            if ($drop_row_id != '0') {
                $chkdrop = $this->db->select("location_id,street,state,address,pincode,country")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $drop_row_id));
                if ($chkdrop->num_rows() > 0) {
                    $drop_details['city']    = $chkdrop->row()->location_id;
                    $drop_details['state']   = $chkdrop->row()->state;
                    $drop_details['country'] = $chkdrop->row()->country;
                    $drop_details['street']  = $chkdrop->row()->street;
                    $drop_details['pincode'] = $chkdrop->row()->pincode;
                    $drop_details['address'] = $chkdrop->row()->address;
                }
            }

            $shipper_id    = $chkorder->row()->shipper_id;
            $getshipper_id = $this->db->query("SELECT shipper_id FROM tb_order_details WHERE  id='" . $order_id . "' LIMIT 1");
            if ($getshipper_id->num_rows() > 0) {
                $shipper_id = $getshipper_id->row()->shipper_id;
            }

            if ($shipper_id > 0) {
                $getshipperdetails = $this->smtcorder->getpartydetailsbyid($shipper_id);
                if ($getshipperdetails->num_rows() > 0) {
                    $shipper_details = array('id' => $getshipperdetails->row()->id, 'name' => $getshipperdetails->row()->name, 'phone' => $getshipperdetails->row()->mobile, 'email' => $getshipperdetails->row()->email, 'fax' => $getshipperdetails->row()->fax, 'party_id' => $getshipperdetails->row()->customeridentifier);
                }
                if ($shipper_id != "") {
                    $chk_shipperaddress = $this->db->select("location_id,street,state,address,pincode,country")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $shipper_id));
                    if ($chk_shipperaddress->num_rows() > 0) {
                        $shipper_details['city']    = $chk_shipperaddress->row()->location_id;
                        $shipper_details['country'] = $chk_shipperaddress->row()->country;
                        $shipper_details['street']  = $chk_shipperaddress->row()->street;
                        $shipper_details['pincode'] = $chk_shipperaddress->row()->pincode;
                        $shipper_details['state']   = $chk_shipperaddress->row()->state;
                        $shipper_details['address'] = $chk_shipperaddress->row()->address;
                    }

                }
            }

            $qry = $this->db->query("SELECT c.* FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='" . $order_id . "' AND o.cargo_id=c.id AND o.status='1' GROUP BY c.id ORDER BY c.id DESC");
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res) {
                    $units = $res->weight_unit;
                    if ($units == "") {
                        $units = "Kg";
                    }
                    $qty = $res->quantity;
                    $wt  = @round(($res->weight / $qty), 2);
                    for ($i = 1; $i <= $qty; $i++) {
                        $cargos[] = array('id' => $res->id, 'weight' => $wt . " " . $units);
                    }
                }
            }
        }
        $data['drop_details']            = $drop_details;
        $data['shipper_details']         = $shipper_details;
        $data['reference']               = $reference;
        $data['shipmentnumber']          = $shipmentnumber;
        $data['communication_reference'] = $communication_reference;
        if ($date != "") {
            $timestamp    = strtotime($date);
            $data['date'] = date('d M Y', $timestamp);
        }
        $data['cargos'] = $cargos;
        $ordernumber    = $chkorder->row()->order_id;
        $mpdf           = new \Mpdf\Mpdf([
            'mode'          => 'utf-8',
            'format'        => [100, 110],
            'margin_left'   => 0,
            'margin_right'  => 0,
            'margin_top'    => 0,
            'margin_bottom' => 0,
            'margin_header' => 0,
            'margin_footer' => 0,
        ]);

        $i             = 1;
        $data['count'] = count($cargos);
        foreach ($cargos as $cargo) {
            $data['weight'] = $cargo['weight'];
            $data['no']     = $i;
            $html           = $this->load->view('orders/orderlabel', $data, true);
            $mpdf->WriteHTML($html);
            $i++;
        }
        $mpdf->Output($ordernumber . "_" . date('YmdHis') . ".pdf", 'D');
    }
}
public function getorderdetails($order_id)
{
    if($order_id != ""){
        $cdate = date('Y-m-d H:i:s');
        $chkorder = $this->smtcorder->getordertoedit($order_id);
        $tripsts = "PENDING";
        $order_status = "PENDING";
        if($chkorder->num_rows() >0){
            $status = $chkorder->row()->status;
            $trip_sts = $chkorder->row()->trip_sts;
            $trip_id = $chkorder->row()->trip_id;
            if($trip_id != 0 && $trip_sts == 0){
                $order_status = 'ACTIVE';
                $tripsts = 'ACTIVE';
            }
            if($trip_id != 0 && $trip_sts == 1){
                $order_status = 'ACTIVE';
                $tripsts = 'ACTIVE';
            }
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $createdon = $chkorder->row()->createdon;
            $updatedon = $chkorder->row()->updatedon;
            //  $getactual = getdatetimebytimezone($curtz,$createdon,DFLT_TZ);
            $curdt = $cdate;
            /* $curdt = $getactual['datetime'];*/
            //  $getactual = getdatetimebytimezone($curtz,$updatedon,DFLT_TZ);
            $upddt = $cdate;
            /* $upddt = $getactual['datetime'];*/
            $parties = array();
            $vendor_id = $chkorder->row()->vendor_id;
            if($vendor_id != 0){
                $getvendor = $this->db->query("SELECT name,mobile,location,address,pincode,country,email,code FROM tb_vendors where id ='".$vendor_id."'");
                if($getvendor->num_rows() >0){
                    $vendordetails = array('name'=>$getvendor->row()->name,'party_id'=>$getvendor->row()->code,'address'=>$getvendor->row()->address,'pincode'=>$getvendor->row()->pincode,'country'=>$getvendor->row()->country,'street'=>"",'city'=>$getvendor->row()->location,'state'=>"",'phone'=>$getvendor->row()->mobile,'email'=>$getvendor->row()->email);
                }
            }
            $pickup_id = $chkorder->row()->customer_id;
            $getpickupdetails = $this->db->query("SELECT name,phone,state,street,location,pincode, address, email_id, code,country FROM tb_customers WHERE id='".$pickup_id."' AND status=1 LIMIT 1");
            if($getpickupdetails->num_rows() >0){
                $customerdetails = array('name'=>$getpickupdetails->row()->name,'party_id'=>$getpickupdetails->row()->code,'address'=>$getpickupdetails->row()->address,'pincode'=>$getpickupdetails->row()->pincode,'country'=>$getpickupdetails->row()->country,'street'=>$getpickupdetails->row()->street,'city'=>$getpickupdetails->row()->location,'state'=>$getpickupdetails->row()->state,'phone'=>$getpickupdetails->row()->phone,'email'=>$getpickupdetails->row()->email_id);
            }
            $consignee_mobile = $consignor_mobile = $shipper_mobile = $carrier_mobile = "";
            $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code, p.location_id, p.address, p.country,p.state, p.street, p.pincode, o.party_type, a.party_master_id, a.location_id as plocation_id,a.street as pstreet,a.state as pstate,a.address as paddress,a.pincode as ppincode,a.country as pcountry FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1 LEFT JOIN tbl_orderparty_address a ON o.party_id=a.party_master_id AND o.order_id=a.order_id AND a.status=1 WHERE p.status=1 AND o.order_id='$order_id' GROUP BY o.party_type");
            if($chekparty->num_rows()>0){
                foreach($chekparty->result() as $rr){
                    $pdetail = array();
                    $ptype = $rr->party_type;
                    $chktype = $this->db->select("name")->get_where("tbl_party_types",array("id"=>$ptype),1,0);
                    if($chktype->num_rows()>0){
                      if($rr->party_master_id != ""){
                        $pdetail = array('name'=>$rr->name,'party_id'=>$rr->code,'address'=>$rr->paddress,'pincode'=>$rr->ppincode,'country'=>$rr->pcountry,'street'=>$rr->pstreet,'city'=>$rr->plocation_id,'state'=>$rr->pstate,'phone'=>$rr->mobile,'email'=>$rr->email);
                    }else{
                        $pdetail = array('name'=>$rr->name,'party_id'=>$rr->code,'address'=>$rr->address,'pincode'=>$rr->pincode,'country'=>$rr->country,'street'=>$rr->street,'city'=>$rr->location_id,'state'=>$rr->state,'phone'=>$rr->mobile,'email'=>$rr->email);
                    }
                    if($chktype->row()->name == "Consignee"){
                        $pdetail['type'] = "Consignee";
                        $consignee_mobile = $rr->mobile;
                    }
                    /*if($chktype->row()->name == "CUSTOMER"){
                        $pdetail['type'] = "Customer";
                    }*/
                    if($chktype->row()->name == "Consignor"){
                        $pdetail['type'] = "Consignor";
                        $consignor_mobile = $rr->mobile;
                    }
                      /*if($chktype->row()->name == "FREIGHT_PAYER"){
                        $pdetail['type'] = "FREIGHT_PAYER";
                    }*/
                    if($chktype->row()->name == "Shipper"){
                        $pdetail['type'] = "Shipper";
                        $shipper_mobile = $rr->mobile;
                    }
                    if($chktype->row()->name == "Carrier"){
                        $pdetail['type'] = "Carrier";
                        $carrier_mobile = $rr->mobile;
                    }
                    $parties[] = $pdetail;
                    }
                }
            }
            $code = "";
            $areacodes = array("1","2","3","10","11","12","673","653","645","644","635","629","628","627","624","6","5","4","29","28","27","26","25","24","23","22","21","20","19","18","17","16","15","14","13","675","676","677","678","7","8","9");
            $zonecode = $this->session->userdata("usr_tzone");
            $currency = isset($zonecode['currency']) ? $zonecode['currency'] : "SGD";
            $company_code = $this->session->userdata("company_code");
            $branch_code = $this->session->userdata("branch_code");
            if(isset($zonecode['phone_code'])){
                $code = $zonecode['phone_code'];
            }else{
                if($company_code == "THKN"){
                    $code = "66";
                }
                if($company_code == "SGKN"){
                    $code = "65";
                }
                if($company_code == "INKN"){
                    $code = "91";
                }
            }
            $cargos = array();
            $total_volume = $total_weight = 0;
            $getcargos = $this->db->query("select handling_unit,length,width,height,weight,volume,quantity,quantity_type,cargo_content,marks_numbers from tb_order_cargodetails where order_id ='".$order_id."'");
            if($getcargos->num_rows() >0){
                foreach($getcargos->result() as $res){
                    $volume = $res->volume;
                    $weight = $res->weight;
                    if($volume == ""){ $volume = 1; }
                    if($weight == ""){ $weight = 1; }
                    $cargos[] = array('cargo_type'=>$res->quantity_type,'content'=>$res->cargo_content,'length'=>$res->length,'width'=>$res->width,'height'=>$res->height,'weight'=>$weight,'volume'=>$volume,'quantity'=>$res->quantity,'marks_numbers'=>$res->marks_numbers);
                    $total_volume += $volume;
                    $total_weight += $weight;
                }
            }
            if($chkorder->row()->company_code != ""){
                $company_code = $chkorder->row()->company_code;
            }
            if($chkorder->row()->branch_code != ""){
                $branch_code = $chkorder->row()->branch_code;
            }
            $shipperdetail = $vendordetails = $consignedetail = $consignordetail = $pfdetails = $customerdetails = array();
            $cncontact = $consignee_mobile;
            $cacontact = $consignor_mobile;
            if($cacontact == ""){
                $cacontact = $shipper_mobile;
            }
            $data = array('SenderTransmissionNo'=>$chkorder->row()->order_id,'order_status'=>$chkorder->row()->order_status, 'pickup_datetime'=>$chkorder->row()->pickup_datetime,'delivery_datetime'=>$chkorder->row()->delivery_datetime,'pickup_endtime'=>$chkorder->row()->pickup_endtime,'delivery_endtime'=>$chkorder->row()->drop_endtime,'createdon'=>$curdt,"delivery_company"=>$chkorder->row()->delivery_company,'delivery_contact'=>$cncontact,'delivery_city'=>$chkorder->row()->delivery_city,'delivery_country'=>$chkorder->row()->delivery_country,'delivery_address1'=>$chkorder->row()->delivery_address1,'delivery_address2'=>$chkorder->row()->delivery_address2,'delivery_pincode'=>$chkorder->row()->delivery_pincode,'branch_code'=>$branch_code,'company_code'=>$company_code,'transport_mode'=>$chkorder->row()->transport_mode,'pickup_country'=>$chkorder->row()->pickup_country,'pickup_pincode'=>$chkorder->row()->pickup_pincode,'country_code'=>$code,"pickup_company"=>$chkorder->row()->pickup_company,'pickup_contact'=>$cacontact,'pickup_city'=>$chkorder->row()->pickup_city,'pickup_address1'=>$chkorder->row()->pickup_address1,'pickup_address2'=>$chkorder->row()->pickup_address2,'cargos'=>$cargos,'total_weight'=>$total_weight,'total_volume'=>$total_volume,'tripsts'=>$tripsts,'ststime'=>$upddt,"area_code"=>$areacodes[1],"goods_value"=>$chkorder->row()->goods_value,"currency"=>$currency,"parties"=>$parties);
            $this->generateorderxml($data);
        }
    }
}

public function generateorderxml($data)
{
    $date = date('Y-m-d H:i:s');
    $timestamp = strtotime($date);
    $request = '';
    $request .= '<TransmissionMessage>';
    $request .= '<TransmissionHeader>';
    $request .= '<Version>1.0</Version>';
    $request .= '<UserName>INFD/PNQFD.INTEGRATION</UserName>';
    $request .= '<Password>ALLIANCE</Password>';
    $request.='<SenderTransmissionNo>'.$timestamp.'_'.$data['SenderTransmissionNo'].'</SenderTransmissionNo>';
    $request .= '<AckSpec>';
    $request .= '<ComMethodGid>transmission</ComMethodGid>';
    $request .= '<ComType>';
    $request .= '<Url>https://elog360.app/svkonekt_test/api/v1/edi</Url>';
    $request .= '<EmailAddress>dummy@email.com</EmailAddress>';
    $request .= '</ComType>';
    $request .= '<AckOption>SUCCESS</AckOption>';
    $request .= '</AckSpec>';
    $request .= '<Source>ETN</Source>';
    $request .= '<Destination>'.$data['branch_code'].'</Destination>';
    $request .= '<ReferenceId>'.$data['SenderTransmissionNo'].'</ReferenceId>';
    $modetrans = "FTL";
    if(isset($data['transport_mode'])){
        if($data['transport_mode'] == "TL"){
            $modetrans = "FTL";
        }else{
            $modetrans = "LTL";
        }
    }
    $request .= '<ModeOfTransport>'.$modetrans.'</ModeOfTransport>';
    $request .= '<Action>BookingDetails</Action>';
    $request .= '</TransmissionHeader>';
    $request .= '<TransmissionBody>';
    $request .= '<InvolvedParties>';
    foreach($data['parties'] as $ptype){
        if(isset($ptype['type'])){
            if($ptype['type'] == "Shipper"){
                $request .= '<Shipper>';
            }
            if($ptype['type'] == "Carrier"){
                $request .= '<Carrier>';
            }
            if($ptype['type'] == "Consignor"){
                $request .= '<Consignor>';
            }
            if($ptype['type'] == "Consignee"){
                $request .= '<Consignee>';
            }
            $request .= '<ID>'.$ptype['party_id'].'</ID>';
            $request .= '<FirstName>'.$ptype['name'].'</FirstName>';
            $request .= '<LastName>'.$ptype['name'].'</LastName>';
            $request .= '<FullName>'.$ptype['name'].'</FullName>';
            if($ptype['type'] == "Shipper"){
                $request .= '<UserName>ratchanee.limwatthana@kuehne-nagel.com</UserName>';
                $request .= '<Password>$2a$11$7xOpu6cePv2sR4HrzWGyOui1evc5GyHE2/72UQjYK9OJOvIEyKZGW</Password>';
            }
            if($ptype['type'] == "Carrier"){
                $request .= '<UserName>thananyas@jtclogistics.com</UserName>';
                $request .= '<Password>$2a$11$NrwvCZ2E9RTMdQJSlUGCT.Jeb13bKWkJP.HQ6pOdcSWjV74Y.18c2</Password>';
            }
            $request .= '<ContactNo>';
            $request .= '<CountryCode>'.$data['country_code'].'</CountryCode>';
            $request .= '<AreaCode>'.$data['area_code'].'</AreaCode>';
            $request .= '<ContactNo>'.$ptype['phone'].'</ContactNo>';
            $request .= '</ContactNo>';
            $request .= '<Company>';
            $request .= '<Name>'.$data['pickup_company'].'</Name>';
            $request .= '<ContactNo>+'.$data['country_code'].''.$data['area_code'].''.$ptype['phone'].'</ContactNo>';
            $request .= '<RegistrationNumber>'.$ptype['party_id'].'</RegistrationNumber>';
            $request .= '<EmailAddress>'.$ptype['email'].'</EmailAddress>';
            $request .= '</Company>';
            $request .= '<Address>';
            $request .= '<Country>'.$ptype['country'].'</Country>';
            $request .= '<City>'.$ptype['city'].'</City>';
            $request .= '<Postal>'.$ptype['pincode'].'</Postal>';
            $request .= '<Address1>'.$ptype['address'].'</Address1>';
            $request .= '<Address2>'.$ptype['street'].'</Address2>';
            $request .= '</Address>';
            if($ptype['type'] == "Consignor"){
                $request .= '<Comments></Comments>';
            }
            if($ptype['type'] == "Consignee"){
                $request .= '<Comments></Comments>';
            }
            if($ptype['type'] == "Shipper"){
                $request .= '</Shipper>';
            }
            if($ptype['type'] == "Carrier"){
                $request .= '</Carrier>';
            }
            if($ptype['type'] == "Consignor"){
                $request .= '</Consignor>';
            }
            if($ptype['type'] == "Consignee"){
                $request .= '</Consignee>';
            }
        }
    }
    $request .= '</InvolvedParties>';
    /*$request .= '<VehicleDetails>';
    $request .= '<VehicleTypeCode>6WC</VehicleTypeCode>';
    $request .= '<VehicleModelCode>SIX_WHEELER</VehicleModelCode>';
    $request .= '<RegistrationNumber></RegistrationNumber>';
    $request .= '<License></License>';
    $request .= '<ApplicableForDangerousGoods></ApplicableForDangerousGoods>';
    $request .= '<CommodityType>6 Wheeler Cabinet</CommodityType>';
    $request .= '<Properties>';
    $request .= '</Properties>';
    $request .= '</VehicleDetails>';*/
    $request .= '<TripDetails>';
    $request .= '<PickUp>';
    $request .= '<Company>';
    $request .= '<Name>'.$data['pickup_company'].'</Name>';
    $request .= '<ContactNo>'.$data['pickup_contact'].'</ContactNo>';
    $request .= '</Company>';
    $request .= '<Address>';
    $request .= '<Country>'.$data['pickup_country'].'</Country>';
    $request .= '<City>'.$data['pickup_city'].'</City>';
    $request .= '<Postal>'.$data['pickup_pincode'].'</Postal>';
    $request .= '<Address1>'.$data['pickup_address1'].'</Address1>';
    $request .= '<Address2>'.$data['pickup_address2'].'</Address2>';
    $request .= '</Address>';
    $request .= '<DateTime>';
    $request .= '<From>'.date("Y-m-d",strtotime($data['pickup_datetime'])).'T'.date("H:i:s",strtotime($data['pickup_datetime'])).'.000</From>';
    $request .= '<To>'.date("Y-m-d",strtotime($data['pickup_endtime'])).'T'.date("H:i:s",strtotime($data['pickup_endtime'])).'.000</To>';
    $request .= '</DateTime>';
    $request .= '</PickUp>';
    $request .= '<DropOff>';
    $request .= '<Company>';
    $request .= '<Name>'.$data['delivery_company'].'</Name>';
    $request .= '<ContactNo>'.$data['delivery_contact'].'</ContactNo>';
    $request .= '</Company>';
    $request .= '<Address>';
    $request .= '<Country>'.$data['delivery_country'].'</Country>';
    $request .= '<City>'.$data['delivery_city'].'</City>';
    $request .= '<Postal>'.$data['delivery_pincode'].'</Postal>';
    $request .= '<Address1>'.$data['delivery_address1'].'</Address1>';
    $request .= '<Address2>'.$data['delivery_address2'].'</Address2>';
    $request .= '</Address>';
    $request .= '<DateTime>';
    $request .= '<From>'.date("Y-m-d",strtotime($data['delivery_datetime'])).'T'.date("H:i:s",strtotime($data['delivery_datetime'])).'.000</From>';
    $request .= '<To>'.date("Y-m-d",strtotime($data['delivery_endtime'])).'T'.date("H:i:s",strtotime($data['delivery_endtime'])).'.000</To>';
    $request .= '</DateTime>';
    $request .= '</DropOff>';
    $request .= '</TripDetails>';
    $request .= '<CargoDetails>';
    $request .= '<CargoType>GENERAL CATEGORY</CargoType>';
    $request .= '<ValueOfGoods>'.$data['goods_value'].'</ValueOfGoods>';
    $request .= '<Items>';
    if(!empty($cargos)){
        foreach ($cargos as $goods){
            $request .= '<Item>';
            $request .= '<HandlingUnit>'.$goods['cargo_type'].'</HandlingUnit>';
            $request .= '<Length>';
            $request .= '<Value>'.$goods['length'].'</Value>';
            $request .= '<UOM>m</UOM>';
            $request .= '</Length>';
            $request .= '<Width>';
            $request .= '<Value>'.$goods['width'].'</Value>';
            $request .= '<UOM>m</UOM>';
            $request .= '</Width>';
            $request .= '<Height>';
            $request .= '<Value>'.$goods['height'].'</Value>';
            $request .= '<UOM>m</UOM>';
            $request .= '</Height>';
            $request .= '<Weight>';
            $request .= '<Value>'.$goods['weight'].'</Value>';
            $request .= '<UOM>m</UOM>';
            $request .= '</Weight>';
            $request .= '<TotalVolume>';
            $request .= '<Value>'.$data['total_volume'].'</Value>';
            $request .= '<UOM>cbm</UOM>';
            $request .= '</TotalVolume>';
            $request .= '<TotalWeight>';
            $request .= '<Value>'.$data['total_weight'].'</Value>';
            $request .= '<UOM>kg</UOM>';
            $request .= '</TotalWeight>';
            $request .= '<Quantity>'.$data['quantity'].'</Quantity>';
            $request .= '</Item>';
        }
    }
    $request .= '</Items>';
    $request .= '</CargoDetails>';
    $request .= '<Rate>';
    $request .= '<BuyGroup>';
    $request .= '<Freights>';
    $request .= '<Freight>';
    $request .= '  <FreightBuyRate>2000</FreightBuyRate>';
    $request .= '<Description></Description>';
    $request .= '<RateUnit>trip</RateUnit>';
    $request .= '<Currency>'.$data['currency'].'</Currency>';
    $request .= '<RevisedFreightBuyRate></RevisedFreightBuyRate>';
    $request .= '</Freight>';
    $request .= '</Freights>';
    $request .= '<Addons/>';
    $request .= '</BuyGroup>';
    $request .= '<SellGroup>';
    $request .= '<Freights>';
    $request .= '<Freight>';
    $request .= '<FreightBuyRate>2000</FreightBuyRate>';
    $request .= '<Description></Description>';
    $request .= '<RateUnit>trip</RateUnit>';
    $request .= '<Currency>'.$data['currency'].'</Currency>';
    $request .= '<KNMarginPercentage>25</KNMarginPercentage>';
    $request .= '<KNMarginAbs></KNMarginAbs>';
    $request .= '<SellPrice>2500</SellPrice>';
    $request .= '</Freight>';
    $request .= '</Freights>';
    $request .= '<Addons/>';
    $request .= '<Discount>500</Discount>';
    $request .= '</SellGroup>';
    $request .= '</Rate>';
    $request .='<Status>';
    $request .='<Shipper>';
    $request .='<StatusCode>READY_FOR_PICKUP</StatusCode>';
    $request .='<StatusValue>READY_FOR_PICKUP</StatusValue>';
    $request .='<DateTime>'.date("Y-m-d",strtotime($data['createdon'])).'T'.date("H:i:s",strtotime($data['createdon'])).'.049Z</DateTime>';
    $request .='</Shipper>';
    $request .='<Carrier>';
    $request .='<StatusCode>READY_FOR_PICKUP</StatusCode>';
    $request .='<StatusValue>READY_FOR_PICKUP</StatusValue>';
    $request .='<DateTime>'.date("Y-m-d",strtotime($data['createdon'])).'T'.date("H:i:s",strtotime($data['createdon'])).'.049Z</DateTime>';
    $request .='</Carrier>';
    $request .='<Booking>';
    $request .='<StatusCode>'.$data['tripsts'].'</StatusCode>';
    $request .='<StatusValue>'.$data['tripsts'].'</StatusValue>';
    $request .='<DateTime>'.date("Y-m-d",strtotime($data['ststime'])).'T'.date("H:i:s",strtotime($data['ststime'])).'.049Z</DateTime>';
    $request .='</Booking>';
    $request .='</Status>';
    $request .='<Remarks>';
    $request .='<ShipperInstructions></ShipperInstructions>';
    $request .='<AddressComments></AddressComments>';
    $request .='<SpecialAddons></SpecialAddons>';
    $request .='</Remarks>';
    $request .= '<KNOrgDetails>';
    $request .= '<KNCompanycode>'.$data['company_code'].'</KNCompanycode>';
    $request .= '<KNBranchcode>'.$data['branch_code'].'</KNBranchcode>';
    $request .= '</KNOrgDetails>';
    $request .= '</TransmissionBody>';
    $request .= '</TransmissionMessage>';

    $resname=date("Ymdhis");
    $dom = new DOMDocument;
    $dom->preserveWhiteSpace = FALSE;
    $dom->loadXML($request);
    $dom->save('xml/response'.$resname.'.xml');
    //log_message("error","request-order ".$request);
    $serviceurl = BOOKING_ETRA_URL;
    $username = BOOKING_ETRA_USRNAME;
    $password = BOOKING_ETRA_PWD;
    $auth = base64_encode($username.':'.$password);
    $headers = array(
      'Content-Type: application/xml',
      'Authorization: Basic '. base64_encode("$username:$password")
    );
    $output = thirdpartyservicecurl($serviceurl,$headers,$request);
}

    public function getallcostrevenues()
    {
        $order_id        = $this->input->post('order_id', TRUE);
        $reveneus        = $costs        = array();
        $totrevenue      = $totcost      = 0;
        $revenuecurrency = "";
        if ($order_id != "") {
            $getreveneus = $this->db->select("id,recipient_role,recipient_name,amount,currency")->get_where("tb_reveneus", array('order_id' => $order_id, 'status' => '1', 'type' => '0'));
            if ($getreveneus->num_rows() > 0) {
                foreach ($getreveneus->result() as $res) {
                    $totrevenue += floatval($res->amount);
                    $revenuecurrency = $res->currency;
                    $reveneus[]      = array('id' => $res->id, 'recipient_role' => $res->recipient_role, 'name' => $res->recipient_name, 'amount' => $res->amount, 'currency' => $res->currency);
                }
            }
            $revenuees_list = array();
            if (!empty($reveneus)) {
                foreach ($reveneus as $res) {
                    $revenuees_list[] = "<li class='revenuelist-modal' id='revenue_" . $res['id'] . "' onclick='getcostlistbyrevenue(" . $res['id'] . ")' data-modalnav='" . $res['currency'] . "'><label>" . $res['name'] . "</label> <span class='amount'>" . floatval($res['amount']) . " " . $res['currency'] . "</span></li>";

                }
            }

            $data['reveneus']        = $reveneus;
            $data['revenuecurrency'] = $revenuecurrency;
            $data['totrevenue']      = $totrevenue;
            $data['revenuees_list']  = $revenuees_list;
            $totcost                 = "";
            $costcurrency            = "";
            $costs                   = array();

            $getcosts = $this->db->select("id,recipient_role,recipient_name,amount,currency")->get_where("tb_reveneus", array('order_id' => $order_id, 'status' => '1', 'type' => '1'));
            if ($getcosts->num_rows() > 0) {
                foreach ($getcosts->result() as $res) {
                    $totcost += floatval($res->amount);
                    $costcurrency = $res->currency;
                    $costs[]      = '<li class="costlist-modal" id="cost_' . $res->id . '" onclick="getcostlistbycost(' . $res->id . ')" data-modalnav="dtdc"><label>' . $res->recipient_name . '</label> <span class="amount">' . floatval($res->amount) . ' ' . $res->currency . '</span></li>';
                }
            }
            $data['costs']        = $costs;
            $data['costcurrency'] = $costcurrency;
            $data['totcost']      = $totcost;
            $data['profit']       = 0;
            if ($totrevenue > 0) {
                $data['profit'] = ($totrevenue - $totcost);
            }

            echo json_encode($data);

        }
    }
    public function getallchargesbyid()
    {
        $post   = array();
        $post   = $this->input->post(NULL,TRUE);
        $id   = isset($post['id']) ? $post['id'] : "";
        $list = array();
        if ($id != "") {
            $getcharges = $this->db->select('description,amount,currency')->get_where("tb_charges", array('revenue_id' => $id, 'status' => '1'));
            if ($getcharges->num_rows() > 0) {
                foreach ($getcharges->result() as $res) {
                    $list[] = "<li><label>" . $res->description . " </label> <span class='amount'>" . floatval($res->amount) . " " . $res->currency . "</span></li>";
                }
            }
        }
        echo json_encode($list);
    }


    public function addrevenuebycalendar(){
        $cdate = date('Y-m-d H:i:s');
        $post   = array();
        $post   = $this->input->post(NULL,TRUE);
        $order_id = isset($post['order_id']) ? $post['order_id'] : "0";
        $amount = isset($post['amount']) ? $post['amount'] : "0";
        if($order_id != '0'){
            $currency = $this->session->userdata("usr_tzone")['currency'];
            $user_id = $this->session->userdata('user_id');
            $customer_name ="Customer";
            $customer_code = "0";
            $getcustomer_id = $this->db->query("select c.name,c.code  from tb_customers c,tb_orders o where c.id=o.customer_id and o.id='".$order_id."'");
            if($getcustomer_id->num_rows()>0){
                $customer_name = $getcustomer_id->row()->name;
                $customer_code = $getcustomer_id->row()->code;
            }
            $debtor_jfr = rand();
            $rev_ar = array('type'=>'0','order_id'=>$order_id,'recipient_role'=>'Customer','recipient_code'=>$customer_code,'recipient_name'=>$customer_name,'debtor_jfr'=>$debtor_jfr,'amount'=>round($amount,4),'currency'=>$currency,'status'=>'1','user_id'=>$user_id,'createdon'=>$cdate);
            $re_qry = $this->db->insert("tb_reveneus",$rev_ar);
            $revenue_id = $this->db->insert_id();
            $charges_ar = array('revenue_id'=>$revenue_id,'charge_code'=>'38','description'=>'Freight Charges','quantity_unit'=>'1','value'=>'1','rate_id'=>'1','amount'=>round($amount,2),'currency'=>$currency,'status'=>'1','user_id'=>$user_id,'createdon'=>$cdate);
            $ins = $this->db->insert("tb_charges",$charges_ar);
            if($ins){
                echo "1";
            }else{
                echo "0";
            }

        }
    }

    public function addcostbycalendar(){
        $cdate = date('Y-m-d H:i:s');
        $post   = array();
        $post   = $this->input->post(NULL,TRUE);
        $order_id = isset($post['order_id']) ? $post['order_id'] : "0";
        $amount = isset($post['amount']) ? $post['amount'] : "0";
        if($order_id != '0'){
            $currency = $this->session->userdata("usr_tzone")['currency'];
            $user_id = $this->session->userdata('user_id');
            $customer_name ="Vendor";
            $customer_code = "0";
            $this->db->select("m.name,m.code");
            $this->db->from("tbl_party_master m");
            $this->db->join("tbl_party_types p", "p.id=m.party_type_id", "LEFT");
            $this->db->like("p.name", 'Carrier');
            $this->db->where("m.user_id", $user_id);
            $where = "m.acon_debitor_code is  NOT NULL";
            $this->db->where($where);
            $this->db->order_by('m.id', 'DESC');
            $getroles = $this->db->get();
            if($getroles->num_rows() >0){
                $customer_name = $getroles->row()->name;
                $customer_code = $getroles->row()->code;
            }
            $debtor_jfr = rand();
            $rev_ar = array('type'=>'1','order_id'=>$order_id,'recipient_role'=>'Carrier','recipient_code'=>$customer_code,'recipient_name'=>$customer_name,'debtor_jfr'=>$debtor_jfr,'amount'=>round($amount,4),'currency'=>$currency,'status'=>'1','user_id'=>$user_id,'createdon'=>$cdate);
            $re_qry = $this->db->insert("tb_reveneus",$rev_ar);
            $revenue_id = $this->db->insert_id();
            $charges_ar = array('revenue_id'=>$revenue_id,'charge_code'=>'38','description'=>'Freight Charges','quantity_unit'=>'1','value'=>'1','rate_id'=>'1','amount'=>round($amount,2),'currency'=>$currency,'status'=>'1','user_id'=>$user_id,'createdon'=>$cdate);
            $ins = $this->db->insert("tb_charges",$charges_ar);
            if($ins){
                echo "1";
            }else{
                echo "0";
            }
        }
    }


    public function creditblock(){
        $post   = array();
        $post   = $this->input->post(NULL,TRUE);
        $uid = $this->session->userdata('user_id');
        $data['status'] = 0;
        $curdt = date('Y-m-d H:i:s');
        $cb_orderid = isset($post['cb_orderid']) ? $post['cb_orderid'] : 0;
        $creditid = isset($post['creditid']) ? $post['creditid'] : 0;
        $cb_companycode = isset($post['cb_companycode']) ? $post['cb_companycode'] : "";
        $cb_branchcode = isset($post['cb_branchcode']) ? $post['cb_branchcode'] : "";
        $cb_departcode = isset($post['cb_departcode']) ? $post['cb_departcode'] : "";
        $stoppage_id = isset($post['stoppage_id']) ? $post['stoppage_id'] : 0;
        $stoppage_name = isset($post['stoppage_name']) ? $post['stoppage_name'] : "";
        $stoppage_remark = isset($post['stoppage_remark']) ? $post['stoppage_remark'] : "";
        $remainder_date = isset($post['remainder_date']) ? $post['remainder_date'] : date('Y-m-d');
        $return_date = isset($post['return_date']) ? $post['return_date'] : date('Y-m-d');
        $resolution_id = isset($post['resolution_id']) ? $post['resolution_id'] : 0;
        $resolution_date = isset($post['resolution_date']) ? $post['resolution_date'] : date('Y-m-d');
        $extra_cost = isset($post['extra_cost']) ? $post['extra_cost'] : 0;
        $extracost_id = isset($post['extracost_id']) ? $post['extracost_id'] : "";
        $status_id = isset($post['status_id']) ? $post['status_id'] : 0;
        $status_dttime = isset($post['status_dttime']) ? $post['status_dttime'] : date('Y-m-d H:i:s');
        $status_remark = isset($post['status_remark']) ? $post['status_remark'] : "";
        $remainder_date = date('Y-m-d',strtotime($remainder_date));
        $return_date = date('Y-m-d',strtotime($return_date));
        $resolution_date = date('Y-m-d',strtotime($resolution_date));
        if($creditid == 0){
            $insdata = array('order_id'=>$cb_orderid, 'stoppage_id'=>$stoppage_id, 'stoppage_name'=>$stoppage_name, 'stoppage_remarks'=>$stoppage_remark, 'remainder_date'=>$remainder_date, 'return_date'=>$return_date, 'resolution_id'=>$resolution_id, 'resolution_date'=>$resolution_date, 'extra_cost'=>$extra_cost, 'extracost_id'=>$extracost_id, 'status_id'=>$status_id, 'status_datetime'=>$status_dttime, 'status_remark'=>$status_remark, 'company_code'=>$cb_companycode, 'branch_code'=>$cb_branchcode, 'department_code'=>$cb_departcode, 'user_id'=>$uid, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
            $ins = $this->db->insert("tbl_credit_blocked",$insdata);
            $creditblockid = $this->db->insert_id();
            $data['status'] = 1;
        }else{
            $updata = array('order_id'=>$cb_orderid, 'stoppage_id'=>$stoppage_id, 'stoppage_name'=>$stoppage_name, 'stoppage_remarks'=>$stoppage_remark, 'remainder_date'=>$remainder_date, 'return_date'=>$return_date, 'resolution_id'=>$resolution_id, 'resolution_date'=>$resolution_date, 'extra_cost'=>$extra_cost, 'extracost_id'=>$extracost_id, 'status_id'=>$status_id, 'status_datetime'=>$status_dttime, 'status_remark'=>$status_remark, 'company_code'=>$cb_companycode, 'branch_code'=>$cb_branchcode, 'department_code'=>$cb_departcode, 'user_id'=>$uid, 'updated_on'=>$curdt);
            $updatecredit =  $this->db->where_in("id",$creditid)->update("tbl_credit_blocked",$updata);
            $data['status'] = 1;
        }
        echo json_encode($data);
    }
    public function checkcreditblocked(){
        $post   = array();
        $post   = $this->input->post(NULL,TRUE);
        $order_id = isset($post['order_id']) ? $post['order_id'] : 0;
        $data = array();
        if($order_id > 0){
            $creditdata = $this->smtcorder->getcreditdata("tbl_credit_blocked",$order_id);
            if($creditdata->num_rows() > 0){
            $data = array('creditid'=>$creditdata->row()->id,'cb_orderid'=>$creditdata->row()->order_id, 'stoppage_id'=>$creditdata->row()->stoppage_id, 'stoppage_name'=>$creditdata->row()->stoppage_name, 'stoppage_remark'=>$creditdata->row()->stoppage_remarks, 'remainder_date'=>$creditdata->row()->remainder_date, 'return_date'=>$creditdata->row()->return_date, 'resolution_id'=>$creditdata->row()->resolution_id, 'resolution_date'=>$creditdata->row()->resolution_date, 'extra_cost'=>$creditdata->row()->extra_cost, 'extracost_id'=>$creditdata->row()->extracost_id, 'status_id'=>$creditdata->row()->status_id, 'status_dttime'=>$creditdata->row()->status_datetime, 'status_remark'=>$creditdata->row()->status_remark, 'cb_companycode'=>$creditdata->row()->company_code, 'cb_branchcode'=>$creditdata->row()->branch_code, 'cb_departcode'=>$creditdata->row()->department_code);
            }
        }
        echo json_encode($data);
    }
    public function getstoppagename($id)
    {
        $data['name'] = "";
        /*if ($id != "") {
        $getdesc = $this->db->query("SELECT name FROM tbl_stoppage_master WHERE id=$id AND status=1");
        if ($getdesc->num_rows() > 0) {
          $data['name'] = $getdesc->row()->name;
        }
        } */
        echo json_encode($data);
    }

    public function ordernotify($action,$orderid){
        $this->load->library('notifytrigger');
        $info['page_title'] = 'Booking Notification';
        $info['order_id'] = $orderid;
        $info['action'] = $action;
        $orderinfo = $this->common->gettblrowdata(array('id'=>$orderid),'order_id','tb_orders',0,0);
        if($orderinfo){
            $info['orderid'] = $bookingId = $orderinfo['order_id'];
            $info['cargos'] = $this->common->gettbldata(array('order_id'=>$orderid),'quantity_type,quantity','tb_order_cargodetails',0,0);
            $info['body'] = $this->load->view('mail_forms/notifytrigger/'.$action,$info,true);
            $orderDetails = $this->DeliveryDocumentModel->getOrderCustomerName(0, $bookingId);
            $info['subject'] = "Booking ID:" . $bookingId . " Customer Name: " . $orderDetails[$bookingId]['customerName'] . " Delivery Docs: " . $orderDetails[$bookingId]['reference'];
            $this->notifytrigger->sendordernotify($info);
        }
    }


	/*
	 get booking ids by using container number

     */
    private function  GetContainernum($containerNumber='',$excludeCompanyCode='No'){
        $result=$res=array();
        $post   = array();
        $post   = $this->input->post(NULL,TRUE);
          if($containerNumber!=''){
            $post['container_no']=$containerNumber;
          }
        if (isset($post['container_no']) && $post['container_no'] != "") {
            $user_id = $this->session->userdata('user_id');
			 $company_code     = $this->session->userdata('company_code');
			   $custid             = $this->session->userdata("cust_id");
			$country_userids = $this->session->userdata("country_user_ids");
            $ref_val=trim($post['container_no']);
            $where_like=array('r.ref_value'=>$ref_val);
            if($excludeCompanyCode=='Yes'){
                $whr=array('o.status!='=>'0','r.reference_id'=>'CTR','r.status'=>1,'o.customer_id'=>$custid);
            }else{
                $whr=array('o.status!='=>'0','r.reference_id'=>'CTR','r.status'=>1,'o.company_code'=>$company_code,'o.customer_id'=>$custid);
            }
            $result=$this->smtcorder->getorderbookingids($whr,$where_like);
		/*  log_message('error',"container to order ids ::->".$this->db->last_query()."<---");  */
            if(!empty($result)){
             $res=array_column($result,"order_id");
            }

        }
        return $res;
    }

    public function ajaxListing($id =null) {
        $this->load->model( 'Datatables_model' );
        $draw  = $this->input->get( 'draw',TRUE );
        $start = $this->input->get( 'start',TRUE );
        $post  = $this->input->get( 'data');
        $sessionCurrency = $this->session->userdata("usr_tzone")['currency'];
        $order = $country_userids = [];
        $userid =0;
        $custid = $this->session->userdata("cust_id");
        $country_userids = $this->session->userdata("country_user_ids");
        $whr = $searchids = [];
        $status_search  = "";
        if (!empty($post)) {
            $whr = $this->searchorders($post);
            $order_status = isset($post['status']) ? $post['status'] :"";
            $status_search = $order_status;
            $ad_orderstatus = isset( $post['order_status'] ) ? $post['order_status'] : "";
            if ( $status_search == "" ) {
                $status_search = $ad_orderstatus;
            }

            $company_code = $this->session->userdata('company_code');
            $branch_code = $this->session->userdata('branch_code');
            $subcusts = array();
            if($this->session->userdata('sub_cust')){
                $subcusts = $this->session->userdata('sub_cust');
                if(!empty($subcusts)){
                array_push($subcusts, $custid);
                }else{
                    $subcusts = array($custid);
                }
            }else{
                $subcusts = array($custid);
            }
            $shipper_orders = array();
            $searchids = isset($post['bookingid']) ? $post['bookingid'] : array();
            $searchshipper_id = isset($post['searchshipper_id']) ? $post['searchshipper_id'] : "";
            if($searchshipper_id != ""){
                $shipper_orders = $this->smtcorder->getorders_bypartymaster('Shipper',$searchshipper_id,$userid,$country_userids,$subcusts,$custid);
                if(empty($searchids) && !empty($shipper_orders)){
                    $searchids = $shipper_orders;
                }
                else if(!empty($searchids) && !empty($shipper_orders)){
                    $searchids = array_intersect($shipper_orders,$searchids);
                }
            }
            $consignee_orders = array();
            $searchconsignee_id = isset($post['searchconsignee_id']) ? $post['searchconsignee_id'] : "";
            if($searchconsignee_id != ""){
                $consignee_orders = $this->smtcorder->getorders_bypartymaster('Consignee',$searchconsignee_id,$userid,$country_userids,$subcusts,$custid);
                if(empty($searchids) && !empty($consignee_orders)){
                    $searchids = $consignee_orders;
                }
                else if(!empty($searchids) && !empty($consignee_orders)){
                    $searchids = array_intersect($consignee_orders,$searchids);
                }
            }

            /* container number search  */
            $excludeCompanyCode='Yes';
            if(empty($searchids) && isset($post['container_no']) && !empty($post['container_no'])){
                /* get Order booking ids by using container number */
                $searchids = $this->GetContainernum($post['container_no'],$excludeCompanyCode);
            }
            elseif(!empty($searchids) && isset($post['container_no']) && !empty($post['container_no'])){
                $container_num_arr=$this->GetContainernum($post['container_no'],$excludeCompanyCode);
                $searchids=array_intersect($container_num_arr,$searchids);
            }

        //where condition building for query logic starts
        $orderIds = $orderNumbers = '';
        if ( ! empty( $searchids ) && sizeof( $searchids ) > 0 ) {

           // $orderIds     = implode( ',', $searchids );
             $orderIds     = $searchids;

            // $orderNumbers = $this->smtcorder->getIdByOrderId( $orderIds );
        }

        // order table condtion for getting matched id's  based on the search for injecting in order reference sub query
        $orderTableCondition=array();
        if(!empty($whr)){
            foreach($whr as $key=>$value){
                $value="'$value'";
                if($key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') <=" || $key=="DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="){
                    $orderTableCondition[]= $key.$value;
                }else{
                    $orderTableCondition[]= $key.' = '.$value;
                }
            }
        }
        $orderTableCondition[]=' o.status!=0';
        if(!empty($searchids) && sizeof($searchids)>0){
            $orderSearchIds=  implode(',',$searchids);
               if($orderSearchIds!=''){
                $orderSearchIds = trim($orderSearchIds,',');
                $orderTableCondition[]= " o.order_id in ($orderSearchIds)";
               }
        }
        if ( $userid != '0' && $userid != '' ) {
			if ( ! empty( $country_userids ) ) {
                $orderSearchCountryIds=  implode(',',$country_userids);
                if($orderSearchCountryIds!=''){
                    $orderSearchCountryIds = trim($orderSearchCountryIds,',');
                    $orderTableCondition[]= " o.user_id in ($orderSearchCountryIds)";
                }
            } else {
                $orderTableCondition[]= "o.user_id = $userid";
			}
        }
        if($status_search == 'PENDING' || $status_search == 'SALOG PENDING'){
            $orderTableCondition[]= "o.trip_id = 0";
        }else if($status_search == 'ACTIVE' || $status_search == 'SALOG ACTIVE'){
            $orderTableCondition[]= "  o.trip_id != 0  and  o.trip_sts=0";
        }else if ( $status_search == 'CLOSED' || $status_search == 'SALOG CLOSED') {
			$orderTableCondition[]="  o.trip_id != 0  and  o.trip_sts = 1 ";
		}
        if($status_search == 'SALOG PENDING' || $status_search == 'SALOG ACTIVE' || $status_search == 'SALOG CLOSED' || $status_search == 'SALOG TO BE BILLED'){
            $orderTableCondition[]="  o.created_source = '5' ";
        }
        $noordercondition = 0;
        if($status_search == 'SALOG TO BE BILLED'){
            $salogorders = $this->smtcorder->getsalogtobebilled($country_userids,$userid,$subcusts,$custid);
            if(!empty($salogorders)){
                $orderTableCondition[] = " o.order_id in ('".implode("','", $salogorders)."') ";
            }else{
                $noordercondition = 1;
            }
        }
        if($noordercondition == '1'){
            $orderTableCondition[]= "o.id = 0";
        }
        if ( ! empty( $subcusts ) ) {
            $orderSearchSubCusts=  implode(',',$subcusts);
                if($orderSearchSubCusts!=''){
                    $orderTableCondition[]= "o.customer_id in ($orderSearchSubCusts)";
                }
		}else {
			if ( $custid != "" ) {
                $orderTableCondition[]= "o.customer_id = $custid";
			}
        }

        $ordeIdCondition = '';
		if ( $orderNumbers != '' ) {
            $orderNumbers=trim($orderNumbers,',');
			$ordeIdCondition = " and order_id in ($orderNumbers) ";
        }

        $wherecondition= $countWherecondition='';
        if(!empty($orderTableCondition) && sizeof($orderTableCondition)>0){
            $implodedConditions=implode(' and ',$orderTableCondition);
            if($implodedConditions!=''){
                $wherecondition.= $implodedConditions;
                $countWherecondition=' and '.$implodedConditions;
            }
        }


        //below query for pagination count and applying where condition in subquery for sub-query to be fast
        $countAndOrderIdQuery="select group_concat(o.id) as orderIds,count(o.id) as count from tb_orders o
        left join tb_order_details d on o.id=d.order_row_id
        where o.id!=0  $countWherecondition ";
        $compiledOrderIds= $compiledCount='';
        $resultSet=$this->db->query($countAndOrderIdQuery);
        if($resultSet->num_rows()>0){
            $resdata = $resultSet->result_array();
            if(isset($resdata[0]['count'])){
                $compiledCount=$resdata[0]['count'];
            }
            if(isset($resdata[0]['orderIds'])){
                $compiledOrderIds=$resdata[0]['orderIds'];
            }
        }else{
            $compiledCount=0;
        }

        $subQueryOrderCondition = '';
		if ( $compiledOrderIds != '' ) {
            $compiledOrderIds = trim($compiledOrderIds,',');
			$subQueryOrderCondition = " and order_id in ($compiledOrderIds) ";
        }

            $selectColumns = [
                'o.id',
                'o.order_id',
                'reference_inner.reference_value as reference_value',
                'o.pickup_company as pickup',
                'o.delivery_company as delivery',
                'o.shipmentid',
                'o.shipment_id',
                'o.order_status',
                'o.shift_id',
                'o.trip_sts',
                'o.trip_id',
                'd.order_status as order_detail_status',
                'o.createdon',
                'o.pickup_datetime',
                'o.delivery_datetime',
                'o.transport_mode',
                'sum(c.quantity) as totqty',
                'sum(c.weight) as totwg',
                'sum( c.volume) as totvol',
                'o.company_code',
                'o.branch_code',
                'o.created_source',
                'cc.type_name',
                'invoice_inner.amount as amount'
            ];
            $dataTableSortOrdering = [
                'o.id',
                'o.id',
                'o.order_id',
                'reference_value',
                'o.pickup_company',
                'o.delivery_company',
                'o.shipmentid',
                'o.order_status',
                'd.order_status',
                'o.createdon',
                'o.transport_mode',
                'sum(c.quantity)',
                'sum(c.weight)',
                'sum( c.volume)',
                'o.company_code',
                'o.branch_code',
                'o.created_source',
                'cc.type_name',
                'invoice_inner.amount as amount'
            ];

        // reference data sub query
        $subQuery1 = "(select order_id,GROUP_CONCAT(reference_value SEPARATOR '?????') as reference_value from (
        SELECT order_id,concat(reference_id,' ===== ',ref_value) as reference_value
            FROM tb_order_references ar where
            reference_id IN ('DQ','CTR','LPC') AND status=1
            $subQueryOrderCondition
            group by order_id,reference_id
            ) as a
            group by order_id ) as reference_inner ";

            $subQuery2 = "
                (SELECT order_id,sum(amount) as amount
                FROM tb_reveneus
                WHERE status = 1 AND type =0 $subQueryOrderCondition
                GROUP BY order_id
                ) as invoice_inner ";

        $table_name = 'tb_orders as o';
        $indexColumn = 'o.id';
        $joinsArray[] = ['table_name' => 'tb_order_details as d', 'condition' => "o.id=d.order_row_id", 'join_type' => 'left'];
        $joinsArray[] = ['table_name' => 'tb_order_cargodetails as c', 'condition' => "o.id=c.order_id", 'join_type' => 'left'];
        $joinsArray[] = ['table_name' => 'tb_cost_center as cc', 'condition' => "d.cost_center_id=cc.id", 'join_type' => 'left'];
        $joinsArray[] = ['table_name' => $subQuery1, 'condition' => "reference_inner.order_id=o.id", 'join_type' => 'left'];
        $joinsArray[] = ['table_name' => $subQuery2, 'condition' => "invoice_inner.order_id=o.id", 'join_type' => 'left'];

        $groupBy = 'o.id';
        $excludeCountQuery='Yes';
		$getRecordListing = $this->Datatables_model->datatablesQuery( $selectColumns, $dataTableSortOrdering, $table_name, $joinsArray, $wherecondition, $indexColumn, '', $groupBy,$excludeCountQuery );
        if($excludeCountQuery=='Yes'){
            $totalRecords     = $compiledCount;
            $recordsFiltered  = $compiledCount;
        }else{
            $totalRecords     = $getRecordListing['recordsTotal'];
		    $recordsFiltered  = $getRecordListing['recordsFiltered'];
        }

		$recordListing    = array();
        $content          = '[';
        $i                = 0;
        $srNumber = $start;

        if ( ! empty( $getRecordListing ) ) {
		    foreach ( $getRecordListing['data'] as $res ) {
                $delivery_note = $container_no =  $loadplanconnote='';
                $shipmentid = $res->shipment_id;
                $trip_no = $res->shipmentid;
                    if($trip_no == '0'){
                        $trip_no = "";
                    }
                    $shift_id = $res->shift_id;
                    $trip_sts = $res->trip_sts;
                    $otherstatus = $res->order_status;
                    $trip_id = $res->trip_id;

                    $order_status = 'PENDING';
                    if($trip_id != 0 && $trip_sts == 0){
                        $order_status = 'ACTIVE';
                    }
                    if($trip_id != 0 && $trip_sts == 1){
                        $order_status = 'CLOSED';
                    }
                    $otherstatus = strtoupper($res->order_status);
                    if($otherstatus == ""){
                        $otherstatus = $res->order_detail_status;
                    }

                    if($otherstatus == 'READY'){
                        $otherstatus = 'READY';
                    }else if($otherstatus == 'INVOICE'){
                        $otherstatus = 'INVOICE';
                    }else{
                        $otherstatus = "";
                    }

                    $delivery_note = $container_no = $referenceData = "";
					if ( isset( $res->reference_value ) ) {
						$referenceData = $res->reference_value;
                    }

                    if ( $referenceData != '' ) {
						$referenceDataArray = explode( '?????', $referenceData );
						if ( ! empty( $referenceDataArray ) && sizeof( $referenceDataArray ) > 0 ) {
							foreach ( $referenceDataArray as $eachRefData ) {
								$reqArray = $this->giveReferenceParameters( $eachRefData );
								if ( $reqArray['type'] == "CTR" ) {
									$container_no = $reqArray['value'];
								} else if ( $reqArray['type'] == "DQ" ) {
									$delivery_note = $reqArray['value'];
								}else if ( $reqArray['type'] == "LPC" ) {
                                    $loadplanconnote = $reqArray['value'];
                                    if($loadplanconnote != ""){
                                        $order_row_id = $res->id;
                                        $bookingid = $res->order_id;
                                        $span = '<i class="icon tru-icon-info" style="cursor: pointer;" onmouseover="getallloadplanconnote('. $order_row_id.','.$bookingid.');"></i>';
                                        $loadplanconnote = $reqArray['value']." ".$span;
                                    }
                                }
							}
						}
                    }

                    $chkdate = '2020-07-01 00:00:00';
                    $createdon = $res->createdon;
                    $order_str = strtotime($createdon);
                    $chk_str = strtotime($chkdate);
                    $early_pickup = $res->pickup_datetime;

                    $early_delivery = $res->delivery_datetime;
                    $curtz = $this->session->userdata("usr_tzone")['timezone'];
                    if($order_str > $chk_str){
                        if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00"){
                            $epickup = getdatetimebytimezone($curtz,$early_pickup,DFLT_TZ);
                            $early_pickup = $epickup['datetime'];
                        }
                        if($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00"){
                            $edelivery = getdatetimebytimezone($curtz,$early_delivery,DFLT_TZ);
                            $early_delivery = $edelivery['datetime'];
                        }
                    }

            $action="<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'><a class='dropdown-toggle' data-toggle='dropdown' href='#'>
                    <span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li>
                        <a href='".base_url()."smtccustorders/vieworder/$res->id' >
                            <span class='icon tru-icon-view' aria-hidden='true'></span>".$this->lang->line('general_view')."
                        </a>
                    </li>
                    <li>
                        <a href='".base_url()."smtccustorders/editorder/$res->id' class='dt-edit'>
                            <span class='icon tru-icon-edit' aria-hidden='true'></span>".$this->lang->line('general_edit')."
                        </a>
                    </li>
                    <li>
                        <a href='".base_url()."smtccustorders/deleteorder/$res->id' class='dt-delete'>
                            <span class='icon tru-icon-delete' aria-hidden='true'></span>".$this->lang->line('general_delete')."
                        </a>
                    </li>
                    <li>
                        <a href='".base_url()."smtccustorders/copyorder/$res->id' class='dt-delete'>
                            <span class='fa fa-clone' aria-hidden='true'></span>".$this->lang->line('copy_order')."
                        </a>
                    </li>
                    <li>
                        <a href='".base_url()."smtccustorders/reverseorder/$res->id' class='dt-delete'>
                            <span class='icon tru-icon-edit' aria-hidden='true'></span>".$this->lang->line('reverse_order')."
                        </a>
                    </li>
                    <li>
                        <a href='".base_url().">kntruckwaybill/index/$res->id'>
                            <span class='fas fa fa-file-pdf-o' aria-hidden='true'></span>".$this->lang->line('generate_twb')."
                        </a>
                    </li>
                    <li>
                        <a href='".base_url()."smtccustorders/orderlabel/$res->id'>
                            <span class='fas fa fa-file-pdf-o' aria-hidden='true'></span>".$this->lang->line('print_label')."
                        </a>
                    </li>

                </ul>
            </li>
            </ul>";

            $checkbox = '<div class="checkbox checkbox-info"><label><input type="checkbox" value="'.$res->id.'" class="recordcheckbox" name="chck1" id="'.$res->id.'"><span class="cr"><i class="cr-icon fa fa-check"></i></span>
            </label></div>';

                $empty  = "";
                $content .= '[';

                        $index=0;

                        $recordListing[ $i ][$index]  = $checkbox;
                        $recordListing[ $i ][++$index]  = $action;
						$recordListing[ $i ][++$index]  = $res->order_id;
                        $recordListing[ $i ][++$index]  = $delivery_note;
                        if($this->session->userdata('company_code') == 'UKKN' || $this->session->userdata('company_code') == 'AUKN'){
                            $recordListing[ $i ][++$index]  = $container_no;
                        }
                        if($this->session->userdata('company_code') == 'AUKN'){
                            $recordListing[ $i ][++$index]  = $loadplanconnote;
                            }

						$recordListing[ $i ][++$index]  = $res->pickup;
						$recordListing[ $i ][++$index]  = $res->delivery;
						$recordListing[ $i ][++$index]  = $trip_no;
						$recordListing[ $i ][++$index]  = $order_status;
                        $recordListing[ $i ][++$index]  =  date('Y-m-d',strtotime($res->createdon));
                        if($this->session->userdata('company_code')!="AUKN"){
                            $recordListing[ $i ][++$index]  = date('Y-m-d h:i A',strtotime($early_pickup));
                            $recordListing[ $i ][++$index] = date('Y-m-d h:i A',strtotime($early_delivery));
                        }
						$recordListing[ $i ][++$index] = $res->transport_mode;
						$recordListing[ $i ][++$index] = $res->totqty;
                        $recordListing[ $i ][++$index] = $otherstatus;
                        $recordListing[ $i ][++$index]  = $res->amount >0 ? $res->amount." ".$sessionCurrency : "";
                        $recordListing[ $i ][++$index]  = $res->type_name;
                        $weight= $volume= '';
                        if($res->totwg > 0){ $weight=round($res->totwg,2)." Kgs"; }
                        if($res->totvol > 0){$volume= round($res->totvol,2)." Cbm"; }

						$recordListing[ $i ][++$index] = $weight;
						$recordListing[ $i ][++$index] = $volume;
						$recordListing[ $i ][++$index] = $res->company_code;
						$recordListing[ $i ][++$index] = $res->branch_code;
                        $recordListing[ $i ][++$index] = (new \App\Libraries\OrderCreationSourceHelper())->getOrderSourceName($res->created_source);
				$i ++;
                $srNumber ++;
            }
            $content    .= ']';
            $final_data = json_encode( $recordListing );
        } else {
            $final_data = '[]';
        }
       // last loop
        }
        // echo '{"draw":'.$draw.',"recordsTotal":'.$totalRecords.',"recordsFiltered":'.$recordsFiltered.',"data":'.$final_data.'}';
        echo '{"draw":' . $draw . ',"recordsTotal":' . $recordsFiltered . ',"recordsFiltered":' . $recordsFiltered . ',"data":' . $final_data . '}';
	}

    public function deleteorders(): void
    {
        if($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->load->helper(['log']);
            $ids = $this->input->post('deleteids');
            $tables = [
                ['name' => 'tb_orders', 'column' => 'id'],
                ['name' => 'tb_order_details', 'column' => 'order_row_id'],
                ['name' => 'tb_order_parties', 'column' => 'order_id'],
                ['name' => 'tbl_orderparty_address', 'column' => 'order_id'],
                ['name' => 'tb_order_cargodetails', 'column' => 'order_id'],
                ['name' => 'tb_order_addons', 'column' => 'order_id'],
                ['name' => 'tb_order_references', 'column' => 'order_id'],
            ];
            $result = true;
            foreach ($tables as $table) {
                foreach ($ids as $id) {
                    $this->db->reset_query();
                    $data = $this->db->delete($table['name'], [$table['column'] => $id]);
                    if (!$data) {
                        $error = $this->db->error();
                        log_error(sprintf('While execute query [%s] the following error came back [%s]', $query, $error['message']));
                        $result = false;
                    }
                }
            }
            echo $result ? "success" : "failed";
        }
    }
    public function orderglobalsearch(){
        if (!checkUrlAccessForUser('CUSTOMER-GLOBALORDERS')) {
            redirect("Forbiddenaccess");
        }
        $data['page_title']=$this->lang->line('menu_orders');
        $data['sub_title']=$this->lang->line('global_search');
        $data['ord_type'] = "";
        $data['orders'] = array();
        $inp = 0;
        $cid = $this->session->userdata("cust_id");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $input = $this->input->post();
        $whr = "";
        if(!empty($input)){
            if(!empty($input['bookingid'])){
                $bookids = implode("','", $input['bookingid']);
                $inp = 1;
                $whr .= " AND o.order_id IN('".$bookids."')";
            }
            if(isset($input['pickup']) && !empty($input['pickup'])){
                $inp = 1;
                $whr .= " AND (o.pickup_country LIKE '%".$input['pickup']."%' OR o.pickup_city LIKE '%".$input['pickup']."%') ";
            }
            if(isset($input['drop']) && !empty($input['drop'])){
                $inp = 1;
                $whr .= " AND (o.delivery_country LIKE '%".$input['drop']."%' OR o.delivery_city LIKE '%".$input['drop']."%') ";
            }
            if(isset($input['fromdate_search'])){
                if($input['fromdate_search'] != ""){
                    $getactual = getdatetimebytimezone(DFLT_TZ,$input['fromdate_search'],$curtz);
                    $input['fromdate_search'] = $getactual['date'];
                    $inp = 1;
                    $whr .= " AND DATE(o.pickup_datetime)>='".$input['fromdate_search']."' ";
                }
            }if(isset($input['status'])){
                if($input['status'] != ""){
                    $searchsts = $input['status'];
                    if($searchsts == 'PENDING'){
                        $whr .= " AND o.trip_id =0 ";
                    }
                    if($searchsts == 'ACTIVE'){
                        $whr .= " AND o.trip_id != 0 AND o.trip_sts =0 ";
                    }
                    if($searchsts == 'CLOSED'){
                        $whr .=" AND o.trip_id != 0 AND o.trip_sts =1 ";
                    }
                }
            }
            if(isset($input['todate_search'])){
                if($input['todate_search'] != ""){
                    $getactual = getdatetimebytimezone(DFLT_TZ,$input['todate_search'],$curtz);
                    $input['todate_search'] = $getactual['date'];
                    $inp = 1;
                    $whr .= " AND DATE(o.delivery_datetime)<='".$input['todate_search']."' ";
                }
            }

            $getords = array();
            if(isset($input['reference'])){
                if(!empty($input['reference'])){
                    $inp = 1;
                    $reference = implode("','", $input['reference']);
                    $getords = $this->getOrdersbyRef($reference);
                }
            }
            if(isset($input['order_type'])){
                if(!empty($input['order_type'])){
                    $inp = 1;
                    $ordtye = implode("','", $input['order_type']);
                    $getords1 = $this->getOrdersbyRefOT("OT",$ordtye);
                    if(!empty($getords1)){
                        $getords = array_merge($getords,$getords1);
                    }else{
                        $getords2 = $this->getOrdersdetailsType($ordtye);
                        if(!empty($getords2)){
                            $getords = array_merge($getords,$getords2);
                        }
                    }
                }
            }
            if(!empty($getords)){
                $gords = implode("','",$getords);
                $whr .= " AND o.id IN('$gords') ";
            }
        }
        if($inp == 1 && $whr == ""){
            $whr .= " AND o.id IN(0) ";
        }
        $subcusts = array();
        if($this->session->userdata('sub_cust') !== FALSE){
            $subcusts = $this->session->userdata('sub_cust');
            if(!empty($subcusts)){
                array_push($subcusts, $cid);
            }
        }
        $whr1 = $whr2 = "";
        if(!empty($subcusts)){
            $whr1 .= " AND e.customer_id IN (".implode(',', $subcusts).") ";
            $whr2 .= " o.customer_id IN (".implode(',', $subcusts).") ";
        }else{
            $whr1 = " AND e.customer_id=".$cid;
            $whr2 = " o.customer_id=".$cid." ";
        }
        $mainqry = "SELECT count(o.id) as cnt FROM tb_orders o WHERE o.status !=0 AND $whr2 $whr";
        $custord1 = $this->db->query($mainqry);
        $pgcnt = $custord1->row()->cnt;
        $config = array();
        $config["base_url"] = base_url() . "Smtccustorders/orderglobalsearch";
        $config["total_rows"] = $pgcnt;
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $config['display_pages'] = TRUE;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $mainqry = "SELECT o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.plat,o.plng,o.status,o.trip_sts,o.shift_id,o.trip_id FROM tb_orders o WHERE $whr2 AND o.status != 0 $whr GROUP BY o.order_id ORDER BY o.pickup_datetime DESC";
        $qry = $mainqry . ' LIMIT ' . $page . ',' . $config["per_page"];
        $custord = $this->db->query($qry);
        if($custord->num_rows()>0){
            $data['orders'] = $custord->result_array();
        }
        $this->newtemplate->dashboard('custorders/globalsearch',$data);

    }
    public function getOrdersdetailsType($otype){
        $res = array();
        $cid = $this->session->userdata("user_id");
        $company_code = $this->session->userdata("company_code");
        if(!empty($otype)){
            $ordertype_id = 0;
            $getordertype_id = $this->db->select('id')->get_where("tb_order_types",array('ordtype_code'=>$otype,'company_code'=>$company_code,'status'=>'1'));
            if($getordertype_id->num_rows()>0){
                $ordertype_id = $getordertype_id->row()->id;
            }else{
                $getordertype = $this->db->select('id')->get_where("tb_order_types",array('ordtype_code'=>$otype,'company_code'=>'SGKN','status'=>'1'));
                if($getordertype->num_rows()>0){
                    $ordertype_id = $getordertype->row()->id;
                }
            }
            if($ordertype_id != 0){
                $order_qry = $this->db->query("select o.id FROM tb_orders o, tb_order_details d where d.order_type='".$ordertype_id."' AND o.user_id= '".$cid."' AND o.id=d.order_row_id");
                if($order_qry->num_rows()>0){
                    foreach ($order_qry->result() as $res1) {
                        $res[] = $res1->id;
                    }
                }
            }

        }

        return $res;
    }
    function getOrdersbyRefOT($refnum,$refval){
        $res = array();
        $cid = $this->session->userdata("cust_id");
        if(!empty($refval)){
            $subcusts = array();
            if($this->session->userdata('sub_cust') !== FALSE){
                $subcusts = $this->session->userdata('sub_cust');
                if(!empty($subcusts)){
                    array_push($subcusts, $cid);
                }
            }
            $whr = " AND o.customer_id=$cid ";
            if(!empty($subcusts)){
                $whr = " AND o.customer_id IN (".implode(',', $subcusts).") ";
            }
            $qry = $this->db->query("select r.order_id FROM tb_order_references r, tb_orders o WHERE r.order_id=o.id AND r.reference_id='".$refnum."' AND r.ref_value IN('".$refval."') $whr AND r.status=1");
            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
        return $res;
    }

    function getOrdersbyRef($refid){
        $res = array();
        $cid = $this->session->userdata("cust_id");
        if(!empty($refid)){
            $subcusts = array();
            if($this->session->userdata('sub_cust') !== FALSE){
                $subcusts = $this->session->userdata('sub_cust');
                if(!empty($subcusts)){
                    array_push($subcusts, $cid);
                }
            }
            $whr = " AND o.customer_id=$cid ";
            if(!empty($subcusts)){
                $whr = " AND o.customer_id IN (".implode(',', $subcusts).") ";
            }
            $qry = $this->db->query("select r.order_id FROM tb_order_references r, tb_orders o WHERE r.order_id=o.id AND  r.ref_value IN('".$refid."') $whr AND r.status=1");
            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
        return $res;
    }
}
?>
