<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class StandardOutBoundAPI extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['common', 'standardstatusmodel']);
        $this->load->library(['standardoutboundhandler','Edi_logger','CarrierDocumentOutbound','carrierstandardtripoutbound']);
    }

    public function customerOrderStatusOutbound()
    {
        $customerDetails = $this->standardstatusmodel->getOrderInformation("Customer", "Status");
        $externalStatusCode = $this->standardstatusmodel->getExternalStatusCode("Customer");
        if (empty($customerDetails)) {
            log_message("error", "There is no Status are avaiable for Triggering ");
            return;
        }
        $customerOrdersList = $this->getCustomerOrdersList($customerDetails);
        $this->standardoutboundhandler->sendOrderStatusoutbound($customerOrdersList, $externalStatusCode, "Customer");
    }

    public function carrierOrderStatusOutbound()
    {
        $customerDetails = $this->standardstatusmodel->getOrderInformation("Carrier", "Status");
        $externalStatusCode = $this->standardstatusmodel->getExternalStatusCode("Carrier");
        if (empty($customerDetails)) {
            log_message("error", "There is no Status are avaliable for Triggering");
            return;
        }
        $customerOrdersList = $this->getCustomerOrdersList($customerDetails);
        $this->standardoutboundhandler->sendOrderStatusoutbound($customerOrdersList, $externalStatusCode, "Carrier");
    }

    public function customerOrderPODOutbound()
    {
        $customerOrders = $this->standardstatusmodel->getOrderInformation("Customer", "POD");
        if (empty($customerOrders)) {
            log_message("error", "Sent EDI is not Activated for the Carrier: ");
            return;
        }
        $customerOrdersList = $this->getCustomerOrdersList($customerOrders);
        $this->standardoutboundhandler->sendDocumentOutBound($customerOrdersList, "Customer");
    }

    public function carrierOrderPODOutbound()
    {
        $customerOrders = $this->standardstatusmodel->getOrderInformation("Carrier", "POD");
        if (empty($customerOrders)) {
            log_message("error", "Sent EDI is not Activated for the Carrier: ");
            return;
        }
        $customerOrdersList = $this->getCustomerOrdersList($customerOrders);
        $this->standardoutboundhandler->sendDocumentOutBound($customerOrdersList, "Carrier");
    }

    private function getCustomerOrdersList(array $customerOrders): array
    {
        foreach ($customerOrders as $order) {
            $customerOrdersList[$order['customer_id']]["customerlinks"] = [
                "customer_name" => $order['customer_name'],
                "category_type" => $order['category_type'],
                "edi_url" => $order['edi_url'],
                "ediname" => $order['ediname'],
                "ediservice" => $order['ediservice'],
                "user_name" => $order['user_name'],
                "password" => $order['password'],
            ];
            $customerOrdersList[$order['customer_id']]['orderids'][] = $order['orderid'];
        }
        return $customerOrdersList ?? [];
    }

    public function documentOutboundToCarrier()
    {
        $getCarrierOrderList = $this->standardstatusmodel->getCarrierOrderList();
        if (empty($getCarrierOrderList)) {
            log_message("error", "There is no Orders for documentOutboundToCarrier");
            return;
        }
        foreach ($getCarrierOrderList as $order) {
            try {
                $this->carrierdocumentoutbound->sendDocumentsToCarrier($order['order_id']);
            } catch (Exception $ex) {
                log_message(
                    "error",
                    "Document Outbound cron failed: " . $order['order_id'] . " : " . $ex->getMessage()
                );
            }
        }
    }

    public function tripOutboundToCarrier()
    {
        $getCarriershipmentList = $this->standardstatusmodel->getCarrierShipmentList();
        if (empty($getCarriershipmentList)) {
            log_message("error", "StandardOutBoundAPI ->  There is no Shipments for Tripoutbound");
            return;
        }
        foreach ($getCarriershipmentList as $shipment) {
            try {
                $this->carrierstandardtripoutbound->shipmentdata($shipment['shift_id']);
            } catch (Exception $ex) {
                log_message("error", "StandardOutBoundAPI ->  Trip sending Failed to Carrier " . $shipment['shift_id'] . $ex->getMessage());
            }

            try {
                $this->carrierstandardtripoutbound->tripOutboundToEportal($shipment['shift_id']);
            } catch (Exception $ex) {
                log_message("error", "StandardOutBoundAPI -> Trip sending Failed to Eportal " . $shipment['shift_id'] . $ex->getMessage());
            }
        }
    }

}
