<?php defined('BASEPATH') OR exit('No direct script access allowed');

use phpseclib\Net\SSH2;
use phpseclib\Net\SFTP;
class Swiftlogedi extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->model('common');
    }
    
    public function index(){
        $sftp_url = SWIFLOG_FTP;
        $username = SWIFLOG_FTP_USER;
        $password = SWIFLOG_FTP_PWD;
        $files = array();
        $statusmsg = "No files";
        $file_names = array();
        $folder_name = "/pub/outbound/uniqlo/etnshipmentready/";
        $sftp = new SFTP($sftp_url);
        if (!$sftp->login($username, $password)) {
            unset($sftp);
          throw new \Exception('Cannot login into your server !');
        }
        $sftp->chdir($folder_name);
        $files_list = $sftp->nlist();
        if(!empty($files_list)){
            foreach ($files_list as $key => $value) {
                if($value != "." && $value != ".."){
                    $path_info = pathinfo($value);
                    $extesion = $path_info['extension'];
                    if($extesion == "xml"){
                        $server_file = "/pub/outbound/uniqlo/etnshipmentready/".$value;
                        $localfile = "./assets/swiftlog/".$value;
                        if (!file_exists(dirname($localfile))) {
                          mkdir(dirname($localfile), 0700, true);
                        }
                        @file_put_contents($localfile, $sftp->get($server_file));
                        $xml = simplexml_load_file($localfile);
                        /*$postData = simplexml_load_string($postData1);*/
                        /*log_message("error","swiftlog edi ".json_encode($postData));*/
                        /*edi log*/
                        $company_code = "INKN";
                        $branch_code = "INCL";
                        $edi_request = $value;
                        $edi_response = "";
                        $params = array('edi_type' => 1, /*'1->EDI Transport Order,2->EDI Status'*/
                            'transaction_id' => time(),
                            'edi_id' => 15, /*edi id based on name take it from tb_edi_types*/
                            'edi_name' => 'Swiftlog ShipmetReady',
                            'bounded_type' => 1, /*'1->Inbound(partner => kN),2->Outbound (KN => partner)'*/
                            'edi_format_type' => 'XML', 'status' => 0, 'obj_type' => 1, 'txn_obj_id' => 0,
                            'user_id' => 0, 'company_code' => $company_code, 'branch_code' => $branch_code,
                            'edi_request' => $edi_request, 'edi_response' => $edi_response);
                        $edilogid = $this->common->insertTableData('tb_etn_edi_transactions', $params);
                        if(!empty($xml)){
                            /*$xml = new simplexml_load_file($postData);*/
                            $bkp_file = "/pub/outbound/uniqlo/backups/etnshipmentready/".$value;
                            $sftp->put($bkp_file, $sftp->get($server_file));
                            $sftp->delete($server_file, false);
                            $userid = 1;
                            $response = array();
                            $preceiver = $lreceiver = $psender = $lsender = $shipmentid = $sendertransmode = $pickup_city = $company_code = $branch_code = "";
                            if ($xml === false) {
                                $statusmsg = "Invalid request,Please try again!";
                            }else{
                                $shipdata11 = $this->read_shipmentdata($xml);
                                if(!empty($shipdata11)){
                                    $response = $this->insertShipmentData($shipdata11);
                                }
                                $this->load->library('email');
                                $succmsg = "Assign Booking Pending";
                                $receivemail= array("pawan.batra@kuehne-nagel.com","sunny.sharma@kuehne-nagel.com");
                                /*I will remove this cc data after go live success*/
                                $cc = array("athmanathan.gnanavel@kuehne-nagel.com", "arun.perumalraj@kuehne-nagel.com","kumar.sanjeev@kuehne-nagel.com", "Sandeep.Singh@kuehne-nagel.com");
                                if(!empty($response)){
                                    if($response['order_id'] > 0){
                                        $orditem = isset($response['item_no']) ? $response['item_no'] : $response['ordinfo']['order_id'];
                                        $failmsg = "";
                                        $sub = "eTN: ".$orditem." Forward Order Assigning Status";
                                        if($response['ordtype'] != "CC"){
                                            /*check existed order trip*/
                                            $chekdocket = 0;
                                            if($response['existsord'] > 0){
                                                $chekdocket = $this->checkdocketnum($response);
                                                if($chekdocket>0){
                                                    $succmsg = "Assigned to Delhivery Carrier, Docket Number:".$chekdocket;
                                                }
                                            }
                                            $docketnum = 0;
                                            if($chekdocket == 0){
                                            $ship_id = $this->ordercreatetrip($response);
                                            if($ship_id > 0){
                                                $this->load->library("uniqloediservices");
                                                $sendtrip = $this->uniqloediservices->getdelverywaybillnumber($ship_id);
                                                if($sendtrip['status'] == 0){
                                                    $failmsg = "Delhivery: ".$sendtrip['data'];
                                                    /*send notify mail if no awb generate*/
                                                    $sub1 = "eTN: ".$orditem." Forward Order Assigning Failed";
                                                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                                                    $this->email->to($receivemail);
                                                    $this->email->cc($cc);
                                                    $this->email->subject($sub1);
                                                    $this->email->set_mailtype("html");
                                                    $body = "Dear Team, <br/>";
                                                    $body .= $sub1." <br/>";
                                                    $body .= "Details. <br/><br/>";
                                                    $body .= $failmsg."<br/><br/>";
                                                    $body .= "Thank You <br/>";
                                                    $body .= "svkonekt <br/>";
                                                    $this->email->message($body);
                                                    if(strpos($sendtrip['data'], 'Duplicate order id') !== false) {
                                                        $this->email->send();
                                                    }
                                                    $sendtrip1 = $this->uniqloediservices->forwardmanifestation($ship_id);
                                                    if($sendtrip1['status'] == 0){
                                                        $failmsg = "EcomExpress: ".$sendtrip1['data'];
                                                        /*send notify mail if no awb generate*/
                                                        $sub1 = "eTN: ".$orditem." Forward Order Assigning Failed";
                                                        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                                                        $this->email->to($receivemail);
                                                        $this->email->cc($cc);
                                                        $this->email->subject($sub1);
                                                        $this->email->set_mailtype("html");
                                                        $body = "Dear Team, <br/>";
                                                        $body .= $sub1." <br/>";
                                                        $body .= "Details. <br/><br/>";
                                                        $body .= $failmsg."<br/><br/>";
                                                        $body .= "Thank You <br/>";
                                                        $body .= "Svkonekt <br/>";
                                                        $this->email->message($body);
                                                        if(!$this->email->send()){
                                                        }
                                                        $sendtrip2 = $this->uniqloediservices->xbordercreatemanifestation($ship_id);
                                                        if($sendtrip2['status'] == 0){
                                                            $failmsg = "ExpressBees: ".$sendtrip2['data'];
                                                            /*send notify mail if no awb generate*/
                                                            $sub1 = "eTN: ".$orditem." Forward Order Assigning Failed";
                                                            $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                                                            $this->email->to($receivemail);
                                                            $this->email->cc($cc);
                                                            $this->email->subject($sub1);
                                                            $this->email->set_mailtype("html");
                                                            $body = "Dear Team, <br/>";
                                                            $body .= $sub1." <br/>";
                                                            $body .= "Details. <br/><br/>";
                                                            $body .= $failmsg."<br/><br/>";
                                                            $body .= "Thank You <br/>";
                                                            $body .= "Svkonekt <br/>";
                                                            $this->email->message($body);
                                                            if(!$this->email->send()){
                                                            }
                                                        }else{
                                                            $docketnum = 1;
                                                            $succmsg = "Assigned to ExpressBees Carrier, Docket Number:".$sendtrip2['data'];
                                                        }
                                                    }else{
                                                        $docketnum = 1;
                                                        $succmsg = "Assigned to EcomExpress Carrier, Docket Number:".$sendtrip1['data'];
                                                    }
                                                }else{
                                                    $docketnum = 1;
                                                    $succmsg = "Assigned to Delhivery Carrier, Docket Number:".$sendtrip['data'];
                                                }
                                                /*if no awb,remove shipment id, after update order then will again new trip for this*/
                                                if($docketnum == 0){
                                                    $set = array("shift_id"=>0,"status"=>1);
                                                    $whr = array("id"=>$response['order_id']);
                                                    $upd = $this->common->updatetbledata("tb_orders",$set,$whr);
                                                }
                                            }
                                        }
                                        }
                                        /*success mail*/
                                        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                                        $this->email->to($receivemail);
                                        $this->email->cc($cc);
                                        $this->email->subject($sub);
                                        $this->email->set_mailtype("html");
                                        $body = "Dear Team, <br/>";
                                        $body .= $sub." <br/>";
                                        $body .= "Assign Status: <br/>";
                                        $body .= $succmsg."<br/>";
                                        $body .= "Details: <br/>";
                                        if(isset($response['ordinfo'])){
                                            $ordinf = $response['ordinfo'];
                                            $wuom = isset($response['weight_unit']) ? $response['weight_unit'] : "Gms";
                                            $vuom = isset($response['volume_unit']) ? $response['volume_unit'] : "Cbm";
                                            $body .= "<b>Pickup:</b> <br/>";
                                            $pickaddr = $ordinf['pickup_company'].", ".$ordinf['pickup_address1'].", ".$ordinf['pickup_address2'].", ".$ordinf['pickup_city'].", ".$ordinf['pickup_pincode'].", ".$ordinf['pickup_country'];
                                            $pickaddrarr = explode(",",$pickaddr);
                                            $pickaddrtrim = array_map("trim",$pickaddrarr);
                                            $pickupaddr = array_unique($pickaddrtrim);
                                            $pickaddr = implode(", ",$pickupaddr);
                                            $body .= $pickaddr." <br/>";
                                            $body .= "<b>Delivery:</b> <br/>";
                                            $body .= $ordinf['delivery_pincode']." <br/>";
                                            $body .= "Item: ".$ordinf['product']." <br/>";
                                            $body .= "Weight: ".$ordinf['weight']." ".$wuom." <br/>";
                                            $body .= "Volume: ".$ordinf['volume']." ".$vuom." <br/>";
                                            $body .= "Quantity: ".$ordinf['quantity']." <br/> <br/>";
                                        }
                                        $body .= "Thank You <br/>";
                                        $body .= "Svkonekt <br/>";
                                        $this->email->message($body);

                                        if(!$this->email->send()) {
                                            log_message("error","uniqlo email fail alert ".$this->email->print_debugger());
                                        }

                                        $this->email->clear(true);
                                    }

                                    /*update edi log*/
                                    $whr = array("id"=>$edilogid);
                                    $set = array("status"=>1,"txn_obj_id"=>$response['order_id'],"user_id"=>$response['user_id'],'company_code' => $response['company_code'], 'branch_code' => $response['branch_code'],"edi_response"=>"Booking created successfully");
                                    $upd = $this->common->updatetbledata("tb_etn_edi_transactions",$set,$whr);
                                    $statusmsg = "Success";
                                }else{
                                    $whr = array("id"=>$edilogid);
                                    $set = array("edi_response"=>"Booking creation failed by unformated or required files not exists.");
                                    $upd = $this->common->updatetbledata("tb_etn_edi_transactions",$set,$whr);
                                    $sub2 = "eTN: Forward Booking file not contains proper data";
                                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                                    $this->email->to($receivemail);
                                    $this->email->cc($cc);
                                    $this->email->subject($sub2);
                                    $this->email->set_mailtype("html");
                                    $body = "Dear Team, <br/>";
                                    $body .= $sub2." <br/>";
                                    $body .= "Assign Status: <br/>";
                                    $body .= $succmsg."<br/>";
                                    $body .= "Details: <br/>";
                                    $body .= "File Name:".$edi_request."<br/><br/>";
                                    $body .= "Thank You <br/>";
                                    $body .= "Svkonekt <br/>";
                                    $this->email->message($body);

                                    if(!$this->email->send()){
                                        log_message("error","uniqlo order email fail alert ".$this->email->print_debugger());
                                    }

                                    $this->email->clear(true);

                                    $statusmsg = "Failed for unformatted request,Please try again!";
                                }
                            }
                        }
                    }
                }
            }
        }
        unset($sftp);
        echo $statusmsg;
    }
    /* check docket number */
    public function checkdocketnum($ord){
        $resp = 0;
        $ordid = $ord['existsord'];
        $whr = array("order_id"=>$ordid,"reference_id"=>"AWB","ref_value <>"=>"");
        $chkref = $this->common->gettblrowdata($whr,"ref_value","tb_order_references",0,0);
        if(count($chkref)>0){
            $resp = $chkref['ref_value'];
        }
        return $resp;
    }
    
    public function read_shipmentdata($xml){
        $res = $receivers = array();
        $lreceiver = $preceiver = $psender = $lsender = $triptype = "";
        $xml->registerXPathNamespace('rou', 'http://kn.swiftlog/routing/0200');
        $data = $xml->xpath('rou:Routing');
        $uuid = (string)($data[0]->xpath('rou:Uuid')[0]);
        $correlationid = (string)($data[0]->xpath('rou:JMSCorrelationID')[0]);
        $country = (string)($data[0]->xpath('rou:KNESB_Routing_Country')[0]);
        $warehouse = (string)($data[0]->xpath('rou:KNESB_Routing_Warehouse')[0]);
        $psender = (string)($data[0]->xpath('rou:KNESB_Routing_Client')[0]);
        $lreceiver = (string)($data[0]->xpath('rou:KNESB_Routing_ReceiverId')[0]);
        $xml->registerXPathNamespace('sr', 'http://kn.swiftlog/ShipmentReady/0200');
        $mdata = $xml->xpath('//sr:ShipmentReady');
        $msgtype = (string)($mdata[0]->xpath('MessageType')[0]);
        $version = (string)($mdata[0]->xpath('MessageVersion')[0]);
        $createdtime = date("Y-m-d H:i:s");
        $res['header'] = array("country"=>$country,"lreceiver"=>$lreceiver,"psender"=>$psender,"lsender"=>$psender,"preceiver"=>$lreceiver,"msgtype"=>$msgtype,"warehouse"=>$warehouse,"version"=>$version,"createdtime"=>$createdtime,"uuid"=>$uuid,"correlationid"=>$correlationid);
        $res['shipdata'] = array();
        $shinfo = $mdata[0]->xpath('Shipment')[0];
        foreach($shinfo as $key=>$cships){
            $res['shipdata'][] = $this->generateshipmentdata($cships,$key);
        }
        return $res;
    }
    
    function generateshipmentdata($xml,$key){
        /*main shipment info*/
        $xml->registerXPathNamespace('ssh', 'http://kn.swiftlog/SRShipment/0200');
        $titledata = $xml->xpath('//ssh:SRShipment');
        $arr['load_id'] = "";
        if (null !== $titledata[0]->xpath('OutboundLoad')) {
            if (!empty($titledata[0]->xpath('OutboundLoad'))) {
                $arr['load_id'] = (string)($titledata[0]->xpath('OutboundLoad')[0]);
            }
        }
        $arr['stop_id'] = "";
        if (null !== $titledata[0]->xpath('StopID')) {
            if (!empty($titledata[0]->xpath('StopID'))) {
                $arr['stop_id'] = (string)($titledata[0]->xpath('StopID')[0]);
            }
        }
        $arr['ship_id'] = $arr['orderid'] = (string)($titledata[0]->xpath('ShipmentID')[0]);
        $arr['warehouse'] = (string)($titledata[0]->xpath('Warehouse')[0]);
        $arr['carrier'] = (string)($titledata[0]->xpath('Carrier')[0]);
        $arr['servicelevel'] = (string)($titledata[0]->xpath('SeviceLevel')[0]);
        $arr['bol'] = (string)($titledata[0]->xpath('DocumentNumberBOL')[0]);
        $arr['product'] = (string)($titledata[0]->xpath('FreightCode')[0]);
        $arr['pronum'] = (string)($titledata[0]->xpath('ProNumber')[0]);
        $arr['delivery_start'] = (string)($titledata[0]->xpath('EarlyDeliveryDate')[0]);
        $arr['delivery_end'] = (string)($titledata[0]->xpath('LateDeliveryDate')[0]);
        $pickdrop = array();
        /*shipment level address*/
        $xml->registerXPathNamespace('adr', 'http://kn.swiftlog/address/0200');
        foreach($xml->xpath('//adr:Address') as $addr){
            $arr1 = array();
            $arr1['addr_type'] = isset($addr->xpath('AddressType')[0]) ? (string)($addr->xpath('AddressType')[0]) : "";
            $arr1['add_id'] = isset($addr->xpath('AddressID')[0]) ? (string)($addr->xpath('AddressID')[0]) : "";
            $arr1['timezone'] = isset($addr->xpath('TimeZone')[0]) ? (string)($addr->xpath('TimeZone')[0]) : "";
            $arr1['route_first_name'] = isset($addr->xpath('FirstName')[0]) ? (string)($addr->xpath('FirstName')[0]) : "";
            $arr1['route_last_name'] = isset($addr->xpath('LastName')[0]) ? (string)($addr->xpath('LastName')[0]) : "";
            $arr1['pickup_company'] = isset($addr->xpath('AddressName')[0]) ? (string)($addr->xpath('AddressName')[0]) : "";
            $arr1['pickup_address'] = isset($addr->xpath('AddressLine1')[0]) ? (string)($addr->xpath('AddressLine1')[0]) : "";
            $street2 = isset($addr->xpath('AddressLine2')[0]) ? $addr->xpath('AddressLine2')[0] : "";
            $street3 = isset($addr->xpath('AddressLine3')[0]) ? $addr->xpath('AddressLine3')[0] : "";
            $arr1['pickup_address1'] = (string)($street2);
            $arr1['pickup_address2'] = (string)($street3);
            $arr1['pickup_city'] = isset($addr->xpath('City')[0]) ? (string)($addr->xpath('City')[0]) : "";
            $arr1['pickup_countrycode'] = isset($addr->xpath('Country')[0]) ? (string)($addr->xpath('Country')[0]) : "";
            $arr1['pickup_postal'] = isset($addr->xpath('PostalCode')[0]) ? (string)($addr->xpath('PostalCode')[0]) : "";
            $arr1['state_province'] = isset($addr->xpath('StateProvince')[0]) ? (string)($addr->xpath('StateProvince')[0]) : "";
            $arr1['vat_number'] = isset($addr->xpath('VATNumber')[0]) ? (string)($addr->xpath('VATNumber')[0]) : "";
            $arr1['sequence'] = 1;
            $arr1['stoptype'] = 'P';
            $contactinfo = array();
            $contactinfo['first_name'] = (string)($addr->xpath('ContactDetails')[0]->ContactName);
            $contactinfo['contact'] = (string)($addr->xpath('ContactDetails')[0]->ContactPhone);
            $contactinfo['cumminicatemail'] = (string)($addr->xpath('ContactDetails')[0]->ContactEmail);
            $contactinfo['fax'] = (string)($addr->xpath('ContactDetails')[0]->ContactFax);
            $arr1['contactinfo'] = $contactinfo;
            $pickdrop[$arr1['addr_type']][] = $arr1;
        }
        $arr['pickdrops'] = $pickdrop;
        /*packages*/
        $xml->registerXPathNamespace('sph', 'http://kn.swiftlog/SRPackage/0200');
        $package = $xml->xpath('//sph:SRPackage');
        $packages['shipmentid'] = "";
        $packages['no_hu'] = $packages['total_volume'] = $packages['gross_weight'] = $packages['net_weight'] = 0;
        $packages['volume_uom'] = "Cbm";
        $packages['weight_uom'] = "gms";
        if(!empty($package)){
            if (null !== $package[0]->xpath('ShipmentID')) {
                if (!empty($package[0]->xpath('ShipmentID'))) {
                    $packages['shipmentid'] = isset($package[0]->xpath('ShipmentID')[0]) ? (string)($package[0]->xpath('ShipmentID')[0]) : "";
                    $packages['no_hu'] = isset($package[0]->xpath('NumberOfHU')[0]) ? (string)($package[0]->xpath('NumberOfHU')[0]) : 0;
                    $packages['total_volume'] = isset($package[0]->xpath('TotalVolume')[0]) ? (string)($package[0]->xpath('TotalVolume')[0]) : 0;
                    $packages['volume_uom'] = isset($package[0]->xpath('VolumeUOM')[0]) ? (string)($package[0]->xpath('VolumeUOM')[0]) : "Cbm";
                    $packages['net_weight'] = isset($package[0]->xpath('NetWeight')[0]) ? (string)($package[0]->xpath('NetWeight')[0]) : 0;
                    $packages['gross_weight'] = isset($package[0]->xpath('GrossWeight')[0]) ? (string)($package[0]->xpath('GrossWeight')[0]) : 0;
                    $packages['weight_uom'] = isset($package[0]->xpath('WeightUOM')[0]) ? (string)($package[0]->xpath('WeightUOM')[0]) : "gms";
                }
            }
        }
        $arr['package'] = $packages;
        /*package details*/
        $xml->registerXPathNamespace('spd', 'http://kn.swiftlog/SRPackageDetail/0200');
        $pkgd = $xml->xpath('//spd:SRPackageDetail');
        $packaged['shipmentid'] = $packaged['pkg_code'] = "";
        $packaged['sequence'] = $packaged['pkg_id'] = $packaged['track_num'] = $packaged['handlingunitype'] = $packaged['length'] = $packaged['width'] = $packaged['volume'] = $packaged['height'] = $packaged['length'] = $packaged['net_weight'] = $packaged['gross_weight'] = 0;
        $packaged['dim_uom'] = $packaged['weight_uom'] = "gms";
        $packaged['volume_uom'] = "Cbm";
        if(!empty($pkgd)){
            if (null !== $pkgd[0]->xpath('ShipmentID')) {
                if (!empty($pkgd[0]->xpath('ShipmentID'))) {
                    $packaged['shipmentid'] = isset($pkgd[0]->xpath('ShipmentID')[0]) ? (string)($pkgd[0]->xpath('ShipmentID')[0]) : "";
                    $packaged['sequence'] = isset($pkgd[0]->xpath('SequenceNumber')[0]) ? (string)($pkgd[0]->xpath('SequenceNumber')[0]) : 0;
                    $packaged['pkg_id'] = isset($pkgd[0]->xpath('PackageID')[0]) ? (string)($pkgd[0]->xpath('PackageID')[0]) : 0;
                    $packaged['pkg_code'] = isset($pkgd[0]->xpath('PackageCode')[0]) ? (string)($pkgd[0]->xpath('PackageCode')[0]) : "";
                    $packaged['track_num'] = isset($pkgd[0]->xpath('TrackingNumber')[0]) ? (string)($pkgd[0]->xpath('TrackingNumber')[0]) : 0;
                    $packaged['handlingunitype'] = isset($pkgd[0]->xpath('HandlingUnitType')[0]) ? (string)($pkgd[0]->xpath('HandlingUnitType')[0]) : 0;
                    $packaged['length'] = isset($pkgd[0]->xpath('Length')[0]) ? (string)($pkgd[0]->xpath('Length')[0]) : 0;
                    $packaged['width'] = isset($pkgd[0]->xpath('Width')[0]) ? (string)($pkgd[0]->xpath('Width')[0]) : 0;
                    $packaged['height'] = isset($pkgd[0]->xpath('Height')[0]) ? (string)($pkgd[0]->xpath('Height')[0]) : 0;
                    $packaged['length'] = isset($pkgd[0]->xpath('Length')[0]) ? (string)($pkgd[0]->xpath('Length')[0]) : 0;
                    $packaged['dim_uom'] = isset($pkgd[0]->xpath('DimensionUOM')[0]) ? (string)($pkgd[0]->xpath('DimensionUOM')[0]) : "CM";
                    $packaged['volume'] = isset($pkgd[0]->xpath('Volume')[0]) ? (string)($pkgd[0]->xpath('Volume')[0]) : 0;
                    $packaged['volume_uom'] = isset($pkgd[0]->xpath('VolumeUOM')[0]) ? (string)($pkgd[0]->xpath('VolumeUOM')[0]) : "Cbm";
                    $packaged['net_weight'] = isset($pkgd[0]->xpath('NetWeight')[0]) ? (string)($pkgd[0]->xpath('NetWeight')[0]) : 0;
                    $packaged['gross_weight'] = isset($pkgd[0]->xpath('GrossWeight')[0]) ? (string)($pkgd[0]->xpath('GrossWeight')[0]) : 0;
                    $packaged['weight_uom'] = isset($pkgd[0]->xpath('WeightUOM')[0]) ? (string)($pkgd[0]->xpath('WeightUOM')[0]) : "gms";
                }
            }
        }
        $arr['packagedetail'] = $packaged;
        /*Outbound order details*/
        $xml->registerXPathNamespace('sr', 'http://kn.swiftlog/ShipmentReady/0200');
        $mdata = $xml->xpath('//sr:ShipmentReady');
        $ordinfo = $mdata[0]->xpath('Shipment')[0]->OutboundOrder;
        $shipord = $ordinfo->xpath('//sco:SRShipmentOrder');
        $shipords['shipmentid'] = isset($shipord[0]->xpath('ShipmentID')[0]) ? (string)($shipord[0]->xpath('ShipmentID')[0]) : "";
        $shipords['warehouse'] = isset($shipord[0]->xpath('Warehouse')[0]) ? (string)($shipord[0]->xpath('Warehouse')[0]) : "";
        $shipords['client'] = isset($shipord[0]->xpath('Client')[0]) ? (string)($shipord[0]->xpath('Client')[0]) : "";
        $shipords['ord_num'] = isset($shipord[0]->xpath('OrderNumber')[0]) ? (string)($shipord[0]->xpath('OrderNumber')[0]) : "";
        $shipords['ord_type'] = isset($shipord[0]->xpath('OrderType')[0]) ? (string)($shipord[0]->xpath('OrderType')[0]) : "";
        $shipords['cust_po_num'] = isset($shipord[0]->xpath('CustomerPONumber')[0]) ? (string)($shipord[0]->xpath('CustomerPONumber')[0]) : "";
        $shipords['cust_po_type'] = isset($shipord[0]->xpath('CustomerPOType')[0]) ? (string)($shipord[0]->xpath('CustomerPOType')[0]) : "";
        $shipords['cust_po_date'] = isset($shipord[0]->xpath('CustomerPODate')[0]) ? (string)($shipord[0]->xpath('CustomerPODate')[0]) : "";
        $shipords['cust_payment'] = isset($shipord[0]->xpath('CustomerPaymentDetails')[0]) ? (string)($shipord[0]->xpath('CustomerPaymentDetails')[0]) : "";
        $shipords['deliver_contact'] = isset($shipord[0]->xpath('DeliveryContact')[0]) ? (string)($shipord[0]->xpath('DeliveryContact')[0]) : "";
        $shipords['service_type'] = isset($shipord[0]->xpath('ServiceType')[0]) ? (string)($shipord[0]->xpath('ServiceType')[0]) : "";
        $shipords['deliver_num'] = isset($shipord[0]->xpath('DeliveryNumber')[0]) ? (string)($shipord[0]->xpath('DeliveryNumber')[0]) : "";
        $shipords['delver_req'] = isset($shipord[0]->xpath('DeliveryRequest')[0]) ? (string)($shipord[0]->xpath('DeliveryRequest')[0]) : "";
        $shipords['rush_flag'] = isset($shipord[0]->xpath('RushFlag')[0]) ? (string)($shipord[0]->xpath('RushFlag')[0]) : "";
        $shipords['cust_ord_type'] = isset($shipord[0]->xpath('CustomsOrderType')[0]) ? (string)($shipord[0]->xpath('CustomsOrderType')[0]) : "";
        $arr['shiporder'] = $shipords;
        $arr['ohndelivery_addr1'] = $arr['ohndelivery_addr2'] = $arr['ohndelivery_addr3'] = "";
        $ordheader = $ordinfo->xpath('//ohn:OrderHeaderNote');
        for($f=0;$f<count($ordheader);$f++){
            $addr_note = isset($ordheader[$f]->xpath('NoteType')[0]) ? (string)($ordheader[$f]->xpath('NoteType')[0]) : "";
            if($addr_note == "DELIVERY_ADDRESS_1"){
                $arr['ohndelivery_addr1'] = isset($ordheader[$f]->xpath('NoteText')[0]) ? (string)($ordheader[$f]->xpath('NoteText')[0]) : "";
            }
            if($addr_note == "DELIVERY_ADDRESS_2"){
                $arr['ohndelivery_addr2'] = isset($ordheader[$f]->xpath('NoteText')[0]) ? (string)($ordheader[$f]->xpath('NoteText')[0]) : "";
            }
            if($addr_note == "DELIVERY_ADDRESS_3"){
                $arr['ohndelivery_addr3'] = isset($ordheader[$f]->xpath('NoteText')[0]) ? (string)($ordheader[$f]->xpath('NoteText')[0]) : "";
            }
        }
        $arr['iteminfor'] = array();
        /*Item information*/
        $iteninfo1 = $ordinfo->ItemInformation;
        for($i=0;$i<count($iteninfo1);$i++){
            $itemhead = $iteninfo1[$i]->xpath('//ns2:ItemHeader');
            $itemheads = array();
            $itemheads['client'] = isset($itemhead[$i]->xpath('Client')[0]) ? (string)($itemhead[$i]->xpath('Client')[0]) : "";
            $itemheads['item'] = isset($itemhead[$i]->xpath('Item')[0]) ? (string)($itemhead[$i]->xpath('Item')[0]) : "";
            $itemheads['display_item'] = isset($itemhead[$i]->xpath('DisplayItem')[0]) ? (string)($itemhead[$i]->xpath('DisplayItem')[0]) : "";
            $itemheads['item_family'] = isset($itemhead[$i]->xpath('ItemFamily')[0]) ? (string)($itemhead[$i]->xpath('ItemFamily')[0]) : "";
            $itemheads['receive_status'] = isset($itemhead[$i]->xpath('ReceiveStatus')[0]) ? (string)($itemhead[$i]->xpath('ReceiveStatus')[0]) : "";
            $itemheads['unit_cost'] = isset($itemhead[$i]->xpath('UnitCost')[0]->Value) ? (string)($itemhead[$i]->xpath('UnitCost')[0]->Value) : "";
            $itemheads['unit_cost_currency'] = isset($itemhead[$i]->xpath('UnitCost')[0]->Currency) ? (string)($itemhead[$i]->xpath('UnitCost')[0]->Currency) : "";
            $itemheads['item_type'] = isset($itemhead[$i]->xpath('ItemType')[0]) ? (string)($itemhead[$i]->xpath('ItemType')[0]) : "";
            $itemheads['colot_attr'] = isset($itemhead[$i]->xpath('ColourAttribute')[0]) ? (string)($itemhead[$i]->xpath('ColourAttribute')[0]) : "";
            $itemheads['style_attr'] = isset($itemhead[$i]->xpath('StyleAttribute')[0]) ? (string)($itemhead[$i]->xpath('StyleAttribute')[0]) : "";
            $itemheads['size_attr'] = isset($itemhead[$i]->xpath('SizeAttribute')[0]) ? (string)($itemhead[$i]->xpath('SizeAttribute')[0]) : "";
            $itemheads['lot_track'] = isset($itemhead[$i]->xpath('LotTracking')[0]) ? (string)($itemhead[$i]->xpath('LotTracking')[0]) : "";
            $itemheads['lot_format'] = isset($itemhead[$i]->xpath('LotFormat')[0]) ? (string)($itemhead[$i]->xpath('LotFormat')[0]) : "";
            $itemheads['origin_code'] = isset($itemhead[$i]->xpath('OriginCode')[0]) ? (string)($itemhead[$i]->xpath('OriginCode')[0]) : "";
            $itemheads['invent_date_flag1'] = isset($itemhead[$i]->xpath('InventoryAttributeDate1Flag')[0]) ? (string)($itemhead[$i]->xpath('InventoryAttributeDate1Flag')[0]) : "";
            $itemheads['invent_date_flag2'] = isset($itemhead[$i]->xpath('InventoryAttributeDate2Flag')[0]) ? (string)($itemhead[$i]->xpath('InventoryAttributeDate2Flag')[0]) : "";
            $itemheads['invent_txt_flag1'] = isset($itemhead[$i]->xpath('InventoryAttributeText1Flag')[0]) ? (string)($itemhead[$i]->xpath('InventoryAttributeText1Flag')[0]) : "";
            $itemheads['invent_txt_flag2'] = isset($itemhead[$i]->xpath('InventoryAttributeText2Flag')[0]) ? (string)($itemhead[$i]->xpath('InventoryAttributeText2Flag')[0]) : "";
            $itemheads['invent_txt_flag3'] = isset($itemhead[$i]->xpath('InventoryAttributeText3Flag')[0]) ? (string)($itemhead[$i]->xpath('InventoryAttributeText3Flag')[0]) : "";
            $itemheads['velocity_code'] = isset($itemhead[$i]->xpath('VelocityCode')[0]) ? (string)($itemhead[$i]->xpath('VelocityCode')[0]) : "";
            $itemheads['count_back'] = isset($itemhead[$i]->xpath('CountBack')[0]) ? (string)($itemhead[$i]->xpath('CountBack')[0]) : "";
            $itemheads['count_near_zero'] = isset($itemhead[$i]->xpath('CountNearZero')[0]) ? (string)($itemhead[$i]->xpath('CountNearZero')[0]) : "";
            $itemheads['count_near_zeroamount'] = isset($itemhead[$i]->xpath('CountNearZeroAmount')[0]) ? (string)($itemhead[$i]->xpath('CountNearZeroAmount')[0]) : "";
            $itemheads['sup_invent_adj'] = isset($itemhead[$i]->xpath('SupportsInventoryAdjustment')[0]) ? (string)($itemhead[$i]->xpath('SupportsInventoryAdjustment')[0]) : "";
            $itemheads['abc_code'] = isset($itemhead[$i]->xpath('ABCCode')[0]) ? (string)($itemhead[$i]->xpath('ABCCode')[0]) : "";
            $itemheads['receivable'] = isset($itemhead[$i]->xpath('Receivable')[0]) ? (string)($itemhead[$i]->xpath('Receivable')[0]) : "";
            $itemheads['cross_dock'] = isset($itemhead[$i]->xpath('AllowOpportunisticCrossDocking')[0]) ? (string)($itemhead[$i]->xpath('AllowOpportunisticCrossDocking')[0]) : "";
            $itemheads['custom_item_type'] = isset($itemhead[$i]->xpath('CustomsItemType')[0]) ? (string)($itemhead[$i]->xpath('CustomsItemType')[0]) : "";
            $itemheads['custom_vat_code'] = isset($itemhead[$i]->xpath('CustomsVATCode')[0]) ? (string)($itemhead[$i]->xpath('CustomsVATCode')[0]) : "";
            $itemheads['custom_comm_code'] = isset($itemhead[$i]->xpath('CustomsCommodityCode')[0]) ? (string)($itemhead[$i]->xpath('CustomsCommodityCode')[0]) : "";
            $itemheads['default_origin_code'] = isset($itemhead[$i]->xpath('DefaultOriginCode')[0]) ? (string)($itemhead[$i]->xpath('DefaultOriginCode')[0]) : "";
            $itemheads['duty_stamp'] = isset($itemhead[$i]->xpath('DutyStampTracked')[0]) ? (string)($itemhead[$i]->xpath('DutyStampTracked')[0]) : "";
            $itemheads['custom_cost'] = isset($itemhead[$i]->xpath('CustomsCost')->Value) ? (string)($itemhead[$i]->xpath('CustomsCost')->Value) : "";
            $itemheads['custom_cost_currency'] = isset($itemhead[$i]->xpath('CustomsCost')->Currency) ? (string)($itemhead[$i]->xpath('CustomsCost')->Currency) : "";
            /*Items description*/
            $itemdescs = array();
            $itemdesc = $iteninfo1[$i]->xpath('ohl:SRItemDescription');
            for($j=0;$j<count($itemdesc);$j++){
                $locale_id = isset($itemdesc[$j]->xpath('LocaleID')[0]) ? (string)($itemdesc[$j]->xpath('LocaleID')[0]) : "";
                if($locale_id == "US_ENGLISH"){
                    $idc['item_client'] = isset($itemdesc[$j]->xpath('ItemClient')[0]) ? (string)($itemdesc[$j]->xpath('ItemClient')[0]) : "";
                    $idc['item'] = isset($itemdesc[$j]->xpath('Item')[0]) ? (string)($itemdesc[$j]->xpath('Item')[0]) : "";
                    $idc['locale_id'] = isset($itemdesc[$j]->xpath('LocaleID')[0]) ? (string)($itemdesc[$j]->xpath('LocaleID')[0]) : "";
                    $idc['desc'] = isset($itemdesc[$j]->xpath('Description')[0]) ? (string)($itemdesc[$j]->xpath('Description')[0]) : "";
                    $idc['short_desc'] = isset($itemdesc[$j]->xpath('ShortDescription')[0]) ? (string)($itemdesc[$j]->xpath('ShortDescription')[0]) : "";
                    $itemdescs = $idc;
                }
            }
            /*ShipmentOrderLine*/
            $shipline2 = $iteninfo1[$i]->ShipmentOrderLine;
            $shipline1 = $shipline2->xpath('//ssl:SRShipmentLine');
            $shipline['shipmentid'] = isset($shipline1[0]->xpath('ShipmentID')[0]) ? (string)($shipline1[0]->xpath('ShipmentID')[0]) : "";
            $shipline['shipmentlineid'] = isset($shipline1[0]->xpath('ShipmentLineID')[0]) ? (string)($shipline1[0]->xpath('ShipmentLineID')[0]) : "";
            $shipline['ob_ord_line'] = isset($shipline1[0]->xpath('OutboundOrderLine')[0]) ? (string)($shipline1[0]->xpath('OutboundOrderLine')[0]) : "";
            $shipline['ob_ord_subline'] = isset($shipline1[0]->xpath('OutboundOrderSubLine')[0]) ? (string)($shipline1[0]->xpath('OutboundOrderSubLine')[0]) : "";
            $shipline['item_client'] = isset($shipline1[0]->xpath('ItemClient')[0]) ? (string)($shipline1[0]->xpath('ItemClient')[0]) : "";
            $shipline['item'] = isset($shipline1[0]->xpath('Item')[0]) ? (string)($shipline1[0]->xpath('Item')[0]) : "";
            $shipline['ord_qty'] = isset($shipline1[0]->xpath('OrderedQuantity')[0]) ? (string)($shipline1[0]->xpath('OrderedQuantity')[0]) : "";
            $shipline['ship_line_qty'] = isset($shipline1[0]->xpath('ShipmentLineQuantity')[0]) ? (string)($shipline1[0]->xpath('ShipmentLineQuantity')[0]) : "";
            $shipline['picked_qty'] = isset($shipline1[0]->xpath('PickedQuantity')[0]) ? (string)($shipline1[0]->xpath('PickedQuantity')[0]) : "";
            $shipline['allot_profile'] = isset($shipline1[0]->xpath('AllocationProfile')[0]) ? (string)($shipline1[0]->xpath('AllocationProfile')[0]) : "";
            $shipline['cust_item_num'] = isset($shipline1[0]->xpath('CustomerItemNumber')[0]) ? (string)($shipline1[0]->xpath('CustomerItemNumber')[0]) : "";
            $shipline['sale_ord_num'] = isset($shipline1[0]->xpath('SalesOrderNumber')[0]) ? (string)($shipline1[0]->xpath('SalesOrderNumber')[0]) : "";
            $shipline['sale_ord_line'] = isset($shipline1[0]->xpath('SalesOrderLine')[0]) ? (string)($shipline1[0]->xpath('SalesOrderLine')[0]) : "";
            $shipline['unit_price'] = isset($shipline1[0]->xpath('UnitPrice')->Value) ? (string)($shipline1[0]->xpath('UnitPrice')->Value) : "";
            $shipline['unit_price_currency'] = isset($shipline1[0]->xpath('UnitPrice')->Currency) ? (string)($shipline1[0]->xpath('UnitPrice')->Currency) : "";
            $shipline['partial'] = isset($shipline1[0]->xpath('Partial')[0]) ? (string)($shipline1[0]->xpath('Partial')[0]) : "";
            $shipline['req_lot_num'] = isset($shipline1[0]->xpath('RequestedLotNumber')[0]) ? (string)($shipline1[0]->xpath('RequestedLotNumber')[0]) : "";
            $shipline['req_inv_date1'] = isset($shipline1[0]->xpath('RequestedInventoryAttributeDate1')[0]) ? (string)($shipline1[0]->xpath('RequestedInventoryAttributeDate1')[0]) : "";
            $shipline['req_inv_date2'] = isset($shipline1[0]->xpath('RequestedInventoryAttributeDate2')[0]) ? (string)($shipline1[0]->xpath('RequestedInventoryAttributeDate2')[0]) : "";
            $shipline['req_inv_txt1'] = isset($shipline1[0]->xpath('RequestedInventoryAttributeText1')[0]) ? (string)($shipline1[0]->xpath('RequestedInventoryAttributeText1')[0]) : "";
            $shipline['req_inv_txt2'] = isset($shipline1[0]->xpath('RequestedInventoryAttributeText2')[0]) ? (string)($shipline1[0]->xpath('RequestedInventoryAttributeText2')[0]) : "";
            /*OrderLine Note*/
            $ordlines = array();
            $ordline1 = $shipline2->xpath('oln:OrderLineNote');
            for($k=0;$k<count($ordline1);$k++){
                $ordline = array();
                $ordline['ord_num'] = isset($ordline1[$k]->xpath('OrderNumber')[0]) ? (string)($ordline1[$k]->xpath('OrderNumber')[0]) : "";
                $ordline['line_num'] = isset($ordline1[$k]->xpath('LineNumber')[0]) ? (string)($ordline1[$k]->xpath('LineNumber')[0]) : "";
                $ordline['sub_line'] = isset($ordline1[$k]->xpath('SubLine')[0]) ? (string)($ordline1[$k]->xpath('SubLine')[0]) : "";
                $ordline['sequence'] = isset($ordline1[$k]->xpath('Sequence')[0]) ? (string)($ordline1[$k]->xpath('Sequence')[0]) : "";
                $ordline['note_type'] = isset($ordline1[$k]->xpath('NoteType')[0]) ? (string)($ordline1[$k]->xpath('NoteType')[0]) : "";
                $ordline['note_text'] = isset($ordline1[$k]->xpath('NoteText')[0]) ? (string)($ordline1[$k]->xpath('NoteText')[0]) : "";
                $ordlines[] = $ordline;
            }
            /*SRShipmentLineInventory*/
            $shiplineinv1 = $shipline2->xpath('//ssi:SRShipmentLineInventory');
            $shiplineinv['shipmentid'] = isset($shiplineinv1[$i]->xpath('ShipmentID')[0]) ? (string)($shiplineinv1[$i]->xpath('ShipmentID')[0]) : "";
            $shiplineinv['shipmentlineid'] = isset($shiplineinv1[$i]->xpath('ShipmentLineID')[0]) ? (string)($shiplineinv1[$i]->xpath('ShipmentLineID')[0]) : "";
            $shiplineinv['ob_ord_num'] = isset($shiplineinv1[$i]->xpath('OutboundOrderNumber')[0]) ? (string)($shiplineinv1[$i]->xpath('OutboundOrderNumber')[0]) : "";
            $shiplineinv['ob_ord_line'] = isset($shiplineinv1[$i]->xpath('OutboundOrderLine')[0]) ? (string)($shiplineinv1[$i]->xpath('OutboundOrderLine')[0]) : "";
            $shiplineinv['ob_ord_subline'] = isset($shiplineinv1[$i]->xpath('OutboundOrderSubLine')[0]) ? (string)($shiplineinv1[$i]->xpath('OutboundOrderSubLine')[0]) : "";
            $shiplineinv['pkg_id'] = isset($shiplineinv1[$i]->xpath('PackageID')[0]) ? (string)($shiplineinv1[$i]->xpath('PackageID')[0]) : "";
            $shiplineinv['lpn'] = isset($shiplineinv1[$i]->xpath('LPN')[0]) ? (string)($shiplineinv1[$i]->xpath('LPN')[0]) : "";
            $shiplineinv['case_id'] = isset($shiplineinv1[$i]->xpath('CaseIdentifier')[0]) ? (string)($shiplineinv1[$i]->xpath('CaseIdentifier')[0]) : "";
            $shiplineinv['piece_id'] = isset($shiplineinv1[$i]->xpath('PieceIdentifier')[0]) ? (string)($shiplineinv1[$i]->xpath('PieceIdentifier')[0]) : "";
            $shiplineinv['item_client'] = isset($shiplineinv1[$i]->xpath('ItemClient')[0]) ? (string)($shiplineinv1[$i]->xpath('ItemClient')[0]) : "";
            $shiplineinv['item'] = isset($shiplineinv1[$i]->xpath('Item')[0]) ? (string)($shiplineinv1[$i]->xpath('Item')[0]) : "";
            $shiplineinv['qty'] = isset($shiplineinv1[$i]->xpath('Quantity')[0]) ? (string)($shiplineinv1[$i]->xpath('Quantity')[0]) : "";
            $shiplineinv['inv_status'] = isset($shiplineinv1[$i]->xpath('InventoryStatus')[0]) ? (string)($shiplineinv1[$i]->xpath('InventoryStatus')[0]) : "";
            $shiplineinv['lot_num'] = isset($shiplineinv1[$i]->xpath('LotNumber')[0]) ? (string)($shiplineinv1[$i]->xpath('LotNumber')[0]) : "";
            $shiplineinv['exp_date'] = isset($shiplineinv1[$i]->xpath('ExpiryDate')[0]) ? (string)($shiplineinv1[$i]->xpath('ExpiryDate')[0]) : "";
            $shiplineinv['man_date'] = isset($shiplineinv1[$i]->xpath('ManufacturedDate')[0]) ? (string)($shiplineinv1[$i]->xpath('ManufacturedDate')[0]) : "";
            $shiplineinv['inv_date1'] = isset($shiplineinv1[$i]->xpath('InventoryAttributeDate1')[0]) ? (string)($shiplineinv1[$i]->xpath('InventoryAttributeDate1')[0]) : "";
            $shiplineinv['inv_date2'] = isset($shiplineinv1[$i]->xpath('InventoryAttributeDate2')[0]) ? (string)($shiplineinv1[$i]->xpath('InventoryAttributeDate2')[0]) : "";
            $shiplineinv['inv_txt1'] = isset($shiplineinv1[$i]->xpath('InventoryAttributeText1')[0]) ? (string)($shiplineinv1[$i]->xpath('InventoryAttributeText1')[0]) : "";
            $shiplineinv['inv_txt2'] = isset($shiplineinv1[$i]->xpath('InventoryAttributeText2')[0]) ? (string)($shiplineinv1[$i]->xpath('InventoryAttributeText2')[0]) : "";
            $arr['iteminfor'][] = array('itemhead'=>$itemheads,'itemdesc'=>$itemdescs,'shipline'=>$shipline,'ordline'=>$ordlines,'shiplineinv'=>$shiplineinv);
        }
        return $arr;
    }

    
    public function insertShipmentData($data){
        $curtz = date_default_timezone_set('UTC');
        $curdt = $data['header']['createdtime'];
        $responseord = array();
        $transmode = "LTL";
        $dedicateveh = 1;
        $user_id = 1;
        foreach($data['shipdata'] as $shipdata){
            $ttansmode = $shipdata['servicelevel'];
            if($ttansmode != "Full Truck Load"){
                $transmode = "LTL";
                $dedicateveh = 0;
            }
            $countrycode = $data['header']['country'];
            $company_code = $shipdata['sendercmpcode'] = $countrycode."SVK";
            $branch_code = "INCL";
            $shipdata['senderbranchcode'] = $data['header']['warehouse'];
            $whr = array('company_code'=>$company_code,'branch_code'=>$branch_code,'status'=>'Active');
            $chkusr = $this->common->gettblrowdata($whr,"id","tb_users",0,0);
            if(count($chkusr)>0){
                $user_id = $chkusr['id'];
            }else{
                $whr = array('company_code'=>$company_code,'branch_code'=>$branch_code,'status'=>1);
                $chkusr = $this->common->gettblrowdata($whr,"user_id","tb_user_companies",0,0);
                if(count($chkusr)>0){
                    $user_id = $chkusr['id'];
                }else{
                    $adminrand = "eTN".$company_code;
                    $adminpwd = password_hash($adminrand, PASSWORD_DEFAULT);
                    $udata = array('country_code'=>$countrycode, 'name'=>$countrycode."_Admin", 'company_indv_name'=>$company_code, 'business_type'=>'Truck_Owner', 'mobile_no'=>$adminrand, 'password'=>$adminpwd, 'emailid'=>'info@svkonekt.com', 'domain_name'=>$branch_code, 'location_id'=>1646, 'createdby'=>1, 'status'=>'Active', 'createdon'=>$curdt, 'company_code'=>$company_code, 'branch_code'=>$branch_code,"lat"=>'28.6862738',"lng"=>'77.2217831');
                    $user_id = $this->common->insertTableData('tb_users',$udata);
                }
            }
            $shipdata['sourcedate'] = $shipdata['destinationdate'] = $curdt;
            if($shipdata['product'] == ""){ $shipdata['product'] = isset($shipdata['iteminfor'][0]['itemdesc']['desc']) ? $shipdata['iteminfor'][0]['itemdesc']['desc'] : "";  }
            $shipdata['pickcount'] = $shipdata['dropcount'] = 1;
            $shipdata['handlingunit'] = $shipdata['packagedetail']['handlingunitype'];
            $shipdata['cargo_content'] = isset($shipdata['iteminfor'][0]['itemdesc']['desc']) ? $shipdata['iteminfor'][0]['itemdesc']['desc'] : "";
            $shipdata['freight_term'] = 60;
            $shipdata['freight_termname'] = 'Free of Charge';
            $shipdata['incoterm'] = '';
            $shipdata['sendertransmode'] = 2;
            $carrier_id = 0;
            $shipdatains = array('shipid'=>$shipdata['ship_id'], 'txnid'=>$shipdata['ship_id'], 'trucktype'=>$ttansmode,'product'=>$shipdata['product'], 'pickupcnt'=>$shipdata['pickcount'], 'dropcnt'=>$shipdata['dropcount'], 'unitspec'=>$shipdata['handlingunit'], 'insertusr'=>"", 'carrier'=>$carrier_id, 'insertuserdate'=>$shipdata['sourcedate'], 'enddate'=>$shipdata['destinationdate'], 'insdate'=>$shipdata['sourcedate'], 'upddate'=>$shipdata['destinationdate'], 'reason'=>'SHIPMENT', 'purpose'=>'SEND INTEGRATION', 'ship_object'=>'SHIPMENT', 'logdate'=>$curdt, 'status'=>1, 'createdon'=>$curdt, 'transport_mode'=>$transmode, 'txncode'=>$shipdata['orderid'],'domainname'=>$data['header']['lsender'],'company_code'=>$shipdata['sendercmpcode'],'branch_code'=>$branch_code,'freight_term'=>$shipdata['freight_term'],'freight_termname'=>$shipdata['freight_termname'],'incoterm'=>$shipdata['incoterm'],'logicalreceiver'=>$data['header']['lreceiver'],'physicalreceiver'=>$data['header']['preceiver'],'physicalsender'=>$data['header']['psender'],'logicalsender'=>$data['header']['lsender'],'modeoftransport'=>$shipdata['sendertransmode']);
            $sship_id = $this->common->insertTableData('tb_shipments',$shipdatains);
            $pickup_datetime = $pickup_endtime = $delivery_datetime = $drop_endtime = $pickup_company = "";
            $starttime = $endtime = $pickup_company = $drop_company = "";
            if(isset($shipdata['pickdrops'])){
                foreach($shipdata['pickdrops'] as $key=>$res1){
                    $res = $res1[0];
                    if($key == "Warehse"){
                        $starttime = $data['header']['createdtime'];
                        $pickup_datetime = $data['header']['createdtime'];
                        $curtzs = 'Asia/Kolkata';/*gettimezonebycountrycode('IN');*/
                        $getactual = getdatetimebytimezone(DFLT_TZ,$pickup_datetime,$curtzs);
                        $pickup_datetime = $getactual['datetime'];
                        $pickup_endtime = $data['header']['createdtime'];
                        $pickup_company = $res['pickup_company'];
                        $pickup_address = $res['pickup_address'];
                        $pickup_address1 = $pickup_address;
                        if($pickup_address1 == ""){
                            $pickup_address1 = $res['pickup_address1'];
                        }
                        $pickup_address2 = $res['pickup_address1'].", ".$res['pickup_address2'];
                        $pickup_city = $res['pickup_city'];
                        $pickup_countrycode = $res['pickup_countrycode'];
                        if($pickup_countrycode == "IND"){ $pickup_countrycode = "INDIA";}
                        $pickup_postal = $res['pickup_postal'];
                        $pickup_state = $res['state_province'];
                        $pickup_vat = $res['vat_number'];
                        $pickup_custid = $res['contactinfo']['contact'];
                        $pickup_partyid = $res['contactinfo']['contact'];
                        $shipper = $res['contactinfo']['first_name'];
                        if($shipper == ""){
                            $shipper = "KN_CUST";
                        }
                        $shipdata['shipper'] = array('name'=>$shipper,'street'=>$pickup_address,'city'=>$pickup_city,'country'=>$pickup_countrycode,'zip'=>$pickup_postal,'custid'=>$pickup_custid,'partyid'=>$pickup_partyid,'state'=>$pickup_state,'street_2'=>$pickup_address1,'street_3'=>$pickup_address2,'email'=>$res['contactinfo']['cumminicatemail'],'fax'=>$res['contactinfo']['fax'],"vat"=>$res['vat_number'],'first_name'=>$res['route_first_name'],'last_name'=>$res['route_last_name']);
                    }
                    if(($key == "Ship To") || ($key == "ShipTo") || ($key == "RouteTo")){
                        if($shipdata['delivery_start'] == ""){ $shipdata['delivery_start'] = $curdt; }
                        if($shipdata['delivery_end'] == ""){ $shipdata['delivery_end'] = $curdt; }
                        $endtime = $shipdata['delivery_start'];
                        $delivery_datetime = date('Y-m-d H:i:s',strtotime($shipdata['delivery_start']));
                        $curtzs = 'Asia/Kolkata';/*gettimezonebycountrycode('IN');*/
                        $getactual = getdatetimebytimezone(DFLT_TZ,$delivery_datetime,$curtzs);
                        $delivery_datetime = $getactual['datetime'];
                        $drop_endtime = date('Y-m-d H:i:s',strtotime($shipdata['delivery_end']));
                        $getactual = getdatetimebytimezone(DFLT_TZ,$drop_endtime,$curtzs);
                        $drop_endtime = $getactual['datetime'];
                        $drop_company = $res['pickup_company'];
                        $drop_city = $res['pickup_city'];
                        $drop_state = $res['state_province'];
                        if($shipdata['ohndelivery_addr1'] != ""){
                            $drop_address = $shipdata['ohndelivery_addr1'];
                            $chkdblspace = strrpos($drop_address,"  ");
                            if($chkdblspace){
                                $citystate = explode("  ",$drop_address);
                                if(count($citystate)>1){
                                    if($citystate[0] != ""){
                                        $drop_state = trim($citystate[0]); /*state*/
                                    }
                                    if($citystate[1] != ""){
                                        $drop_city = trim($citystate[1]); /*city*/
                                    }
                                }
                            }
                        }else{
                            $drop_address = $res['pickup_address'];
                        }
                        if($shipdata['ohndelivery_addr2'] != ""){
                            $drop_address1 = $shipdata['ohndelivery_addr2'];
                        }else{
                            $drop_address1 = $res['pickup_address1'];
                        }
                        if($shipdata['ohndelivery_addr3'] != ""){
                            $drop_address2 = $shipdata['ohndelivery_addr3'].", ".$drop_city.", ".$drop_state;
                        }else{
                            $drop_address2 = $drop_address1.", ".$res['pickup_address2'].", ".$drop_city.", ".$drop_state;
                        }
                        $drop_countrycode = $res['pickup_countrycode'];
                        if($drop_countrycode == "IND"){ $drop_countrycode = "INDIA";}
                        $drop_postal = $res['pickup_postal'];
                        $drop_vat = $res['vat_number'];
                        $drop_custid = $res['contactinfo']['contact'];
                        $drop_partyid = $res['contactinfo']['contact'];
                        $consignee = $res['contactinfo']['first_name'];
                        $shipdata['consignee'] = array('name'=>$consignee,'street'=>$drop_address,'city'=>$drop_city,'country'=>$drop_countrycode,'zip'=>$drop_postal,'custid'=>$drop_custid,'partyid'=>$drop_partyid,'state'=>$drop_state,'street_2'=>$drop_address1,'street_3'=>$drop_address2,'email'=>$res['contactinfo']['cumminicatemail'],'fax'=>$res['contactinfo']['fax'],"vat"=>$res['vat_number'],'first_name'=>$res['route_first_name'],'last_name'=>$res['route_last_name']);
                    }
                    if($key == "Carrier"){
                        $carr_address = $res['pickup_address'];
                        $carr_address1 = $res['pickup_address1'];
                        $carr_address2 = $res['pickup_address2'];
                        $carr_city = $res['pickup_city'];
                        $carr_countrycode = $res['pickup_countrycode'];
                        if($carr_countrycode == "IND"){ $carr_countrycode = "INDIA";}
                        $carr_postal = $res['pickup_postal'];
                        $carr_state = $res['state_province'];
                        $carr_vat = $res['vat_number'];
                        $carr_custid = $res['contactinfo']['contact'];
                        $carr_company = $res['pickup_company'];
                        if($carr_custid == ""){
                            $carr_custid = $carr_company;
                        }
                        if($carr_custid == ""){
                            if($shipdata['carrier'] != ""){
                                $carr_custid = $shipdata['carrier'];
                            }else{
                                $carr_custid = "DELHIVERY";
                            }
                        }
                        $carr_partyid = $res['contactinfo']['contact'];
                        $carrier = $res['contactinfo']['first_name'];
                        if($carrier == ""){
                            $carrier = $shipdata['carrier'];
                            if($carrier == ""){
                                if($carr_company != ""){
                                    $carrier = $carr_company;
                                }else{
                                    $carrier = "DELHIVERY";
                                }
                            }
                        }
                        $shipdata['carrier'] = array('name'=>$carrier,'street'=>$carr_address,'city'=>$carr_city,'country'=>$carr_countrycode,'zip'=>$carr_postal,'custid'=>$carr_custid,'partyid'=>$carr_partyid,'state'=>$carr_state,'street1'=>$carr_address1,'street_2'=>$carr_address1,'street_3'=>$carr_address2,'email'=>$res['contactinfo']['cumminicatemail'],'fax'=>$res['contactinfo']['fax'],"vat"=>$carr_vat,'first_name'=>$res['route_first_name'],'last_name'=>$res['route_last_name']);
                    }
                    if($key == "Client"){
                        $cust_address = $res['pickup_address'];
                        $cust_address1 = $res['pickup_address1'];
                        $cust_address2 = $res['pickup_address2'];
                        $cust_city = $res['pickup_city'];
                        $cust_countrycode = $res['pickup_countrycode'];
                        if($cust_countrycode == "IND"){ $cust_countrycode = "INDIA";}
                        $cust_postal = $res['pickup_postal'];
                        $cust_state = $res['state_province'];
                        $cust_vat = $res['vat_number'];
                        $cust_custid = $res['contactinfo']['contact'];
                        $cust_partyid = $res['contactinfo']['contact'];
                        $cust = $res['contactinfo']['first_name'];
                        if($cust == ""){
                            $cust = "UNIQLO EC WH";
                        }
                        $shipdata['customer'] = array('name'=>$cust,'street'=>$cust_address,'city'=>$cust_city,'country'=>$cust_countrycode,'zip'=>$cust_postal,'custid'=>$cust_custid,'partyid'=>$cust_partyid,'state'=>$cust_state,'street_2'=>$cust_address1,'street_3'=>$cust_address2,'email'=>$res['contactinfo']['cumminicatemail'],'fax'=>$res['contactinfo']['fax'],"vat"=>$cust_vat,'first_name'=>$res['route_first_name'],'last_name'=>$res['route_last_name']);
                    }
                }
                $customer_id = 0; $cn_partytype = 3; $sh_partytype = 1; $pf_partytype = 1;
                if($shipdata['shipper']['custid'] == ""){
                    $shipdata['shipper']['custid'] = @mt_rand(1111111111,9999999999);
                }
                if(isset($shipdata['customer'])){
                    if($shipdata['customer']['custid'] == ""){
                        $shipdata['customer']['custid'] = 'UNIQLOECWH';
                    }
                    $customer = $this->checkcustomer($shipdata['customer'],$shipdata['sendercmpcode'],$branch_code,$user_id,"PF");
                }else{
                    $customer = $this->checkcustomer($shipdata['shipper'],$shipdata['sendercmpcode'],$branch_code,$user_id,"PF");
                }
                if($customer['id'] > 0){
                    $customer_id = $customer['id'];
                }
                if(isset($customer['party_id'])){ $cust_id = $customer['party_id']; $pf_partytype = $customer['party_type']; }
                if($customer_id == 0){
                    $whr = array('user_id'=>$user_id,'company_code'=>$company_code,'branch_code'=>$branch_code);
                    $branchwisecust = $this->common->gettblrowdata($whr,"id","tb_customers",0,0);
                    if(count($branchwisecust) > 0){
                        $customer_id = $branchwisecust['id'];
                    }else{
                        $randnum = @mt_rand(1111111111,9999999999);
                        $pwd = password_hash($randnum, PASSWORD_DEFAULT);
                        $cinsdata = array('name'=>$company_code."_Customer", 'phone'=>$randnum, 'location'=>$countrycode, 'address'=>$countrycode, 'pincode'=>$countrycode, 'code'=>$randnum, 'country'=>$countrycode, 'password'=>$pwd, 'user_id'=>$user_id,'company_code'=>$company_code, 'branch_code'=>$branch_code, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
                        $customer_id = $this->common->insertTableData('tb_customers',$cinsdata);
                    }
                }
                if(isset($shipdata['consignee'])){
                    if(isset($shipdata['consignee']['custid'])){
                        if($shipdata['consignee']['custid'] == ""){
                            $shipdata['consignee']['custid'] = @mt_rand(1111111111,9999999999);
                        }
                    }else{
                        $shipdata['consignee']['custid'] = @mt_rand(1111111111,9999999999);
                    }
                    $consignee = $this->checkconsignee($shipdata['consignee'],$shipdata['sendercmpcode'],$branch_code,$user_id,"CN");
                    if(isset($consignee['party_id'])){ $consignee_id = $consignee['party_id']; $cn_partytype = $consignee['party_type']; }
                }else{
                    $shipdata['consignee'] = isset($shipdata['customer']) ? $shipdata['customer'] : array();
                    if(empty($shipdata['consignee'])){
                        $shipdata['consignee'] = $shipdata['shipper'];
                    }
                    $consignee = $this->checkconsignee($shipdata['consignee'],$shipdata['sendercmpcode'],$branch_code,$user_id,"CN");
                    if(isset($consignee['party_id'])){ $consignee_id = $consignee['party_id']; $cn_partytype = $consignee['party_type']; }
                }
                $shipper = $this->checkshipper($shipdata['shipper'],$shipdata['sendercmpcode'],$branch_code,$user_id,"SH");
                if(isset($shipper['party_id'])){ $shipper_id = $shipper['party_id']; $sh_partytype = $shipper['party_type']; }
                $shiptxnid = trim($shipdata['ship_id']);
                $ord_id = 0;$checkexists = 0;
                $shipdata['pkgs_count'] = $shipdata['package']['no_hu'];
                $shipdata['gross_weight'] = $shipdata['package']['gross_weight'];
                $shipdata['volume'] = $shipdata['package']['total_volume'];
                if($pickup_company != "" && $drop_company != ""){
                    $carrier1 = $shipdata['carrier'];
                    if(is_array($carrier1) && !empty($carrier1)){
                        $carrier = $this->checkcarrier($shipdata['carrier'],$shipdata['sendercmpcode'],$branch_code,$user_id);
                        $carrier_id = $carrier['id'];
                        if(isset($carrier['party_id'])){ $carrier_party_id = $carrier['party_id']; $ca_partytype = $carrier['party_type']; }
                    }else{
                        $ca_partytype = 2;
                        if($carrier1 == ""){ $carrier_id = 0; }else{
                            $shipdata['carrier'] = array('name'=>$carrier1,'street'=>$pickup_address,'email'=>'info@svkonekt.com','street1'=>$pickup_address,'city'=>$pickup_city,'country'=>$pickup_countrycode,'zip'=>$pickup_postal,'custid'=>$pickup_custid,'partyid'=>$pickup_partyid);
                            $carrier = $this->checkcarrier($shipdata['carrier'],$shipdata['sendercmpcode'],$branch_code,$user_id);
                            $carrier_id = $carrier['id'];
                            if(isset($carrier['party_id'])){ if($carrier['party_id'] != "") { $carrier_party_id = $carrier['party_id']; $ca_partytype = $carrier['party_type']; } }
                        }
                    }
                    $startlat = $startlong = $endlat = $endlong = "";
                    $sloc = $pickup_address.", ".$pickup_city.", ".$pickup_countrycode.", ".$pickup_postal;
                    $eloc = $drop_address.", ".$drop_city.", ".$drop_countrycode.", ".$drop_postal;
                    $cheklatlng = $this->getlatlongbylocname($sloc);
                    if(!empty($cheklatlng)){
                        $startlat = $cheklatlng['latitude'];
                        $startlong = $cheklatlng['longitude'];
                    }
                    $cheklatlng1 = $this->getlatlongbylocname($eloc);
                    if(!empty($cheklatlng1)){
                        $endlat = $cheklatlng1['latitude'];
                        $endlong = $cheklatlng1['longitude'];
                    }
                    $pick_name = $shipdata['shipper']['first_name']." ".$shipdata['shipper']['last_name'];
                    $deliver_name = $shipdata['consignee']['first_name']." ".$shipdata['consignee']['last_name'];
                    /*check order exists with PO number*/
                    if(!empty($shipdata['shiporder']['cust_po_num'])){
                        $chkdt = array('reference_id'=>"PO", 'ref_value'=>$shipdata['shiporder']['cust_po_num']);
                        $chkoref = $this->common->gettblrowdata($chkdt,"order_id","tb_order_references",0,0);
                        if(count($chkoref) > 0){
                            $checkexists = $chkoref['order_id'];
                        }
                    }
                    if($checkexists == 0){
                        $orddata = array('order_id'=>$shipdata['orderid'], 'pickup_datetime'=>$pickup_datetime, 'pickup_endtime'=>$pickup_endtime, 'delivery_datetime'=>$delivery_datetime, 'drop_endtime'=>$drop_endtime, 'pickup_company'=>$pickup_company, 'delivery_company'=>$drop_company, 'pickup_country'=>$pickup_countrycode, 'delivery_country'=>$drop_countrycode, 'pickup_city'=>$pickup_city, 'delivery_city'=>$drop_city, 'pickup_pincode'=>$pickup_postal, 'delivery_pincode'=>$drop_postal, 'pickup_address1'=>$pickup_address1, 'delivery_address1'=>$drop_address1, 'pickup_address2'=>$pickup_address2, 'delivery_address2'=>$drop_address2, 'quantity'=>$shipdata['pkgs_count'], 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'goods_value'=>$shipdata['pkgs_count'], 'transport_mode'=>$transmode, 'dedicated_vehicle'=>$dedicateveh, 'vehicle_type'=>$transmode, 'user_id'=>$user_id, 'customer_id'=>$customer_id, 'vendor_id'=>$carrier_id, 'customer_name'=>$pick_name, 'customer_code'=>$shipdata['shipper']['custid'], 'customer_area'=>($shipdata['shipper']['street'].", ".$shipdata['shipper']['city'].", ".$shipdata['shipper']['zip']), 'customer_phone'=>$shipdata['shipper']['custid'],'customer_email'=>"",'customer_comments'=>"", 'vendor_name'=>$deliver_name, 'vendor_code'=>$shipdata['consignee']['custid'], 'vendor_area'=>($shipdata['consignee']['street'].", ".$shipdata['consignee']['city'].", ".$shipdata['consignee']['zip']), 'vendor_phone'=>$shipdata['consignee']['custid'],'plat'=>$startlat,'plng'=>$startlong,'dlat'=>$endlat,'dlng'=>$endlong,'company_code'=>$shipdata['sendercmpcode'],'branch_code'=>$branch_code,'product'=>$shipdata['product'],'shipment_id'=>$sship_id, 'pickup_custid'=>$pickup_custid, 'pickup_partyid'=>$pickup_partyid, 'drop_custid'=>$drop_custid, 'drop_partyid'=>$drop_partyid, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt,"created_source"=>15,'shipmentid'=>$shiptxnid,'logicalreceiver'=>$data['header']['lreceiver'],'physicalreceiver'=>$data['header']['preceiver'],'physicalsender'=>$data['header']['psender'],'logicalsender'=>$data['header']['lsender'],'modeoftransport'=>$shipdata['sendertransmode']);
                        $ord_id = $this->common->insertTableData('tb_orders',$orddata);
                    }else{
                        $orddata = array('pickup_datetime'=>$pickup_datetime, 'pickup_endtime'=>$pickup_endtime, 'delivery_datetime'=>$delivery_datetime, 'drop_endtime'=>$drop_endtime, 'pickup_company'=>$pickup_company, 'delivery_company'=>$drop_company, 'pickup_country'=>$pickup_countrycode, 'delivery_country'=>$drop_countrycode, 'pickup_city'=>$pickup_city, 'delivery_city'=>$drop_city, 'pickup_pincode'=>$pickup_postal, 'delivery_pincode'=>$drop_postal, 'pickup_address1'=>$pickup_address1, 'delivery_address1'=>$drop_address1, 'pickup_address2'=>$pickup_address2, 'delivery_address2'=>$drop_address2, 'quantity'=>$shipdata['pkgs_count'], 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'goods_value'=>$shipdata['pkgs_count'], 'transport_mode'=>$transmode, 'dedicated_vehicle'=>$dedicateveh, 'vehicle_type'=>$transmode, 'user_id'=>$user_id, 'customer_id'=>$customer_id, 'customer_name'=>$pick_name, 'customer_code'=>$shipdata['shipper']['custid'], 'customer_area'=>($shipdata['shipper']['street'].", ".$shipdata['shipper']['city'].", ".$shipdata['shipper']['zip']), 'customer_phone'=>$shipdata['shipper']['custid'],'customer_email'=>"",'customer_comments'=>"", 'vendor_name'=>$deliver_name, 'vendor_code'=>$shipdata['consignee']['custid'], 'vendor_area'=>($shipdata['consignee']['street'].", ".$shipdata['consignee']['city'].", ".$shipdata['consignee']['zip']), 'vendor_phone'=>$shipdata['consignee']['custid'],'plat'=>$startlat,'plng'=>$startlong,'dlat'=>$endlat,'dlng'=>$endlong,'company_code'=>$shipdata['sendercmpcode'],'branch_code'=>$branch_code,'product'=>$shipdata['product'],'shipment_id'=>$sship_id, 'pickup_custid'=>$pickup_custid, 'pickup_partyid'=>$pickup_partyid, 'drop_custid'=>$drop_custid, 'drop_partyid'=>$drop_partyid, 'createdon'=>$curdt, 'updatedon'=>$curdt,"created_source"=>15,'shipmentid'=>$shiptxnid,'logicalreceiver'=>$data['header']['lreceiver'],'physicalreceiver'=>$data['header']['preceiver'],'physicalsender'=>$data['header']['psender'],'logicalsender'=>$data['header']['lsender'],'modeoftransport'=>$shipdata['sendertransmode']);
                        $ord_id = $checkexists;
                        $upwhr = array("id"=>$ord_id);
                        $updord = $this->common->updatetbledata('tb_orders',$orddata,$upwhr);
                    }
                }
                if($ord_id >0){
                    $responseord = array("order_id"=>$ord_id,"user_id"=>$user_id,"company_code"=>$shipdata['sendercmpcode'],"branch_code"=>$branch_code,"curtz"=>$curtz,'ordinfo'=>$orddata,"existsord"=>$checkexists);
                    /*cargo details*/
                    $weight_unit = "Gms"; $volume_unit = "Cbm";
                    $qty_vam = $goods_value = 0;
                    if(count($shipdata['iteminfor'])>0){
                        foreach($shipdata['iteminfor'] as $cargoinfo){
                            if($cargoinfo['shipline']['ord_qty'] == ""){ $cargoinfo['shipline']['ord_qty'] = 1; }
                            if($cargoinfo['itemhead']['unit_cost'] == ""){ $cargoinfo['itemhead']['unit_cost'] = 0; }
                            $qty_vam += $cargoinfo['shipline']['ord_qty'];
                            $goods_value += $cargoinfo['itemhead']['unit_cost'];
                            $gross_weight = round(($shipdata['gross_weight'] / count($shipdata['iteminfor'])),2);
                            $volume = round(($shipdata['volume'] / count($shipdata['iteminfor'])),2);
                            $ordcargodesc = $cargoinfo['itemdesc']['desc'];
                            $ordcargodesc = str_replace("&","and",$ordcargodesc);
                            $ordcargodesc = str_replace(";",",",$ordcargodesc);
                            $ordhandunit = $shipdata['handlingunit'];
                            $chkitemarr = array("item_number"=>$cargoinfo['itemhead']['item']);
                            $chkitemcargo = $this->common->gettblrowdata($chkitemarr,"id","tb_items",0,0);
                            if(count($chkitemcargo) == 0){
                                $ordcargodesc1 = substr($ordcargodesc, 0, 55);
                                $itemarr = array("item_id"=>$ordcargodesc1, "item_name"=>$ordcargodesc1, 'length'=>$shipdata['packagedetail']['length'], 'length_unit' => $shipdata['packagedetail']['dim_uom'], 'width'=>$shipdata['packagedetail']['width'], 'width_unit' => $shipdata['packagedetail']['dim_uom'], 'height'=>$shipdata['packagedetail']['height'], 'height_unit' => $shipdata['packagedetail']['dim_uom'], 'weight' => $shipdata['packagedetail']['gross_weight'], 'weight_unit' => $shipdata['packagedetail']['weight_uom'], 'volume' => $shipdata['packagedetail']['volume'], 'volume_unit' => $shipdata['packagedetail']['volume_uom'],"item_number"=>$cargoinfo['itemhead']['item']);
                                $item_id = $this->common->insertTableData('tb_items',$itemarr);
                            }else{
                                $item_id = $chkitemcargo['id'];
                            }
                            $chkarr = array('cargo_type'=>$ordhandunit,'item_id' => $item_id,'weight'=>$gross_weight,'volume'=>$volume,'quantity'=>$cargoinfo['shipline']['ord_qty']);
                            $weight_unit = $shipdata['packagedetail']['weight_uom'];
                            $volume_unit = $shipdata['packagedetail']['volume_uom'];
                            $cargo = array('cargo_type' => $ordhandunit, 'goods_description' => $ordcargodesc, 'quantity' => $cargoinfo['shipline']['ord_qty'], 'length'=>$shipdata['packagedetail']['length'], 'length_unit' => $shipdata['packagedetail']['dim_uom'], 'width'=>$shipdata['packagedetail']['width'], 'width_unit' => $shipdata['packagedetail']['dim_uom'], 'height'=>$shipdata['packagedetail']['height'], 'height_unit' => $shipdata['packagedetail']['dim_uom'], 'weight' => $shipdata['packagedetail']['gross_weight'], 'weight_unit' => $shipdata['packagedetail']['weight_uom'], 'volume' => $shipdata['packagedetail']['volume'], 'volume_unit' => $shipdata['packagedetail']['volume_uom'], 'item_id' => $item_id, 'stackable' => 0, 'createdby' => $user_id, 'createdon' => $curdt);
                            $chkcargo = $this->common->gettblrowdata($chkarr,"id","tb_cargo_details",0,0);
                            if(count($chkcargo) == 0){
                                $cargotbl_id = $this->common->insertTableData('tb_cargo_details',$cargo);
                            }else{
                                $cargotbl_id = $chkcargo['id'];
                            }
                            $cargodt = array('order_id'=>$ord_id,'cargo_id'=>$cargotbl_id,'weight'=>$gross_weight, 'volume'=>$volume, 'quantity'=>$cargoinfo['shipline']['ord_qty'], 'quantity_type'=>$shipdata['handlingunit'], 'cargo_content'=>$ordcargodesc,"qr_code"=>$cargoinfo['itemhead']['item']);
                            $chkcargo = $this->common->gettblrowdata($cargodt,"id","tb_order_cargodetails",0,0);
                            if(count($chkcargo) == 0){
                                $hunit = 1;
                                $chkhandlingunit = $this->common->gettblrowdata(array("user_id"=>$user_id,"unit_name"=>$shipdata['handlingunit']),"id","tbl_shipunit_types",0,0);
                                if(count($chkhandlingunit)>0){
                                    $hunit = $chkhandlingunit['id'];
                                }else{
                                    $hunitarr = array("unit_name"=>$shipdata['handlingunit'],"description"=>$shipdata['handlingunit'],"user_id"=>$user_id,"status"=>1,"created_at"=>$curdt);
                                    $hunit = $this->common->insertTableData('tbl_shipunit_types',$hunitarr);
                                }
                                $cargodata = array('order_id'=>$ord_id, 'cargo_id'=>$cargotbl_id, 'handling_unit'=>$hunit, 'length'=>$shipdata['packagedetail']['length'], 'width'=>$shipdata['packagedetail']['width'], 'height'=>$shipdata['packagedetail']['height'], 'weight'=>$gross_weight, 'volume'=>$volume, 'quantity'=>$cargoinfo['shipline']['ord_qty'], 'quantity_type'=>$shipdata['handlingunit'], 'cargo_content'=>$ordcargodesc, 'linebp_num1'=>$cargoinfo['shiplineinv']['piece_id'], 'label_number'=>$cargoinfo['shiplineinv']['piece_id'], "qr_code"=>$cargoinfo['itemhead']['item'], 'reference_order_num'=>$cargoinfo['shiplineinv']['shipmentlineid'], 'status'=>1);
                                $cargo_id = $this->common->insertTableData('tb_order_cargodetails',$cargodata);
                                /*add inner cargo*/
                                if(!empty($cargoinfo['ordline'])){
                                    $itemname = $color_code =$color_code_num =$size_code =$size_name =$pattern_length_code =$pattern_length_name = $dhsncode = "";
                                    $unit_price = $item_discount = $igst_rate = $sgst_rate = $cgst_rate = $igst_amt = $sgst_amt = $cgst_amt = 0.00;
                                    foreach($cargoinfo['ordline'] as $oline){
                                        if($oline['note_type'] == 'ITEM_NAME'){
                                            $itemname = $oline['note_text'];
                                        }if($oline['note_type'] == 'COLOR_CODE'){
                                            $color_code = $oline['note_text'];
                                        }if($oline['note_type'] == 'COLOR_CODE_NAME'){
                                            $color_code_num = $oline['note_text'];
                                        }if($oline['note_type'] == 'SIZE_CODE'){
                                            $size_code = $oline['note_text'];
                                        }if($oline['note_type'] == 'SIZE_NAME'){
                                            $size_name = $oline['note_text'];
                                        }if($oline['note_type'] == 'PATTERN_LENGTH_CODE'){
                                            $pattern_length_code = $oline['note_text'];
                                        }if($oline['note_type'] == 'PATTERN_LENGTH_NAME'){
                                            $pattern_length_name = $oline['note_text'];
                                        }if($oline['note_type'] == 'UNIT_PRICE'){
                                            $unit_price = $oline['note_text'];
                                        }if($oline['note_type'] == 'D_HSN_CODE'){
                                            $dhsncode = $oline['note_text'];
                                        }if($oline['note_type'] == 'ITEM_DISCOUNT'){
                                            $item_discount = $oline['note_text'];
                                        }if($oline['note_type'] == 'IGST_RATE'){
                                            $igst_rate = $oline['note_text'];
                                        }if($oline['note_type'] == 'SGST_RATE'){
                                            $sgst_rate = $oline['note_text'];
                                        }if($oline['note_type'] == 'CGST_RATE'){
                                            $cgst_rate = $oline['note_text'];
                                        }if($oline['note_type'] == 'IGST_AMOUNT'){
                                            $igst_amt = $oline['note_text'];
                                        }if($oline['note_type'] == 'SGST_AMOUNT'){
                                            $sgst_amt = $oline['note_text'];
                                        }if($oline['note_type'] == 'CGST_AMOUNT'){
                                            $cgst_amt = $oline['note_text'];
                                        }
                                    }
                                    if($itemname != "" && $color_code != "" && $size_code != ""){
                                        if($cargoinfo['shipline']['ord_qty'] > 1){
                                            $unit_price = ($unit_price * $cargoinfo['shipline']['ord_qty']);
                                        }
                                        $incargodt = array('cargo_id'=>$cargotbl_id, 'cargo_type'=>$itemname,'qr_code'=>$cargoinfo['itemhead']['item'],'item_order_id'=>$ord_id);
                                        $chkincargo = $this->common->gettblrowdata($incargodt,"id","tb_inner_cargo",0,0);
                                        if(count($chkincargo) == 0){
                                        $innerarr = array('cargo_id'=>$cargotbl_id, 'cargo_type'=>$itemname, 'goods_description'=>$itemname, 'quantity'=>$cargoinfo['shipline']['ord_qty'], 'scanned_quantity'=>0, 'length'=>$shipdata['packagedetail']['length'], 'length_unit'=>$shipdata['packagedetail']['dim_uom'], 'width'=>$shipdata['packagedetail']['width'], 'width_unit' => $shipdata['packagedetail']['dim_uom'], 'height'=>$shipdata['packagedetail']['height'], 'height_unit' => $shipdata['packagedetail']['dim_uom'], 'weight' => $shipdata['packagedetail']['gross_weight'], 'weight_unit' => $shipdata['packagedetail']['weight_uom'], 'volume' => $shipdata['packagedetail']['volume'], 'volume_unit' => $shipdata['packagedetail']['volume_uom'], 'stackable'=>0, 'qr_code'=>$cargoinfo['itemhead']['item'], 'status'=>1, 'createdby'=>$user_id, 'createdon'=>$curdt, 'updatedon'=>$curdt, 'ref_order_num'=>$cargoinfo['shiplineinv']['shipmentlineid'], 'color_code'=>$color_code, 'color_code_name'=>$color_code_num, 'size_code'=>$size_code, 'size_name'=>$size_name, 'pattern_length_code'=>$pattern_length_code, 'pattern_length_name'=>$pattern_length_name, 'unit_price'=>$unit_price, 'd_hsn_code'=>$dhsncode, 'item_discount'=>$item_discount, 'igst_rate'=>$igst_rate, 'sgst_rate'=>$sgst_rate, 'cgst_rate'=>$cgst_rate, 'igst_amount'=>$igst_amt, 'sgst_amount'=>$sgst_amt, 'cgst_amount'=>$cgst_amt,'item_order_id'=>$ord_id);
                                        $inner_id = $this->common->insertTableData('tb_inner_cargo',$innerarr);
                                        }else{
                                            $updinnerarr = array('cargo_id'=>$cargotbl_id, 'cargo_type'=>$itemname, 'goods_description'=>$itemname, 'quantity'=>$cargoinfo['shipline']['ord_qty'], 'scanned_quantity'=>0, 'length'=>$shipdata['packagedetail']['length'], 'length_unit'=>$shipdata['packagedetail']['dim_uom'], 'width'=>$shipdata['packagedetail']['width'], 'width_unit' => $shipdata['packagedetail']['dim_uom'], 'height'=>$shipdata['packagedetail']['height'], 'height_unit' => $shipdata['packagedetail']['dim_uom'], 'weight' => $shipdata['packagedetail']['gross_weight'], 'weight_unit' => $shipdata['packagedetail']['weight_uom'], 'volume' => $shipdata['packagedetail']['volume'], 'volume_unit' => $shipdata['packagedetail']['volume_uom'], 'stackable'=>0, 'qr_code'=>$cargoinfo['itemhead']['item'], 'status'=>1, 'createdby'=>$user_id, 'createdon'=>$curdt, 'updatedon'=>$curdt, 'ref_order_num'=>$cargoinfo['shiplineinv']['shipmentlineid'], 'color_code'=>$color_code, 'color_code_name'=>$color_code_num, 'size_code'=>$size_code, 'size_name'=>$size_name, 'pattern_length_code'=>$pattern_length_code, 'pattern_length_name'=>$pattern_length_name, 'unit_price'=>$unit_price, 'd_hsn_code'=>$dhsncode, 'item_discount'=>$item_discount, 'igst_rate'=>$igst_rate, 'sgst_rate'=>$sgst_rate, 'cgst_rate'=>$cgst_rate, 'igst_amount'=>$igst_amt, 'sgst_amount'=>$sgst_amt, 'cgst_amount'=>$cgst_amt,'item_order_id'=>$ord_id);
                                            $updinwhr = array("id"=>$chkincargo['id']);
                                            $inner_id = $this->common->updatetbledata('tb_inner_cargo',$updinnerarr,$updinwhr);
                                        }
                                    }
                                }
                                /*$qrcode = $this->generateQRCodes($cargo_id,$cargodata);*/
                                /*send mail to customer*/
                                /*$custdata = array("cust_id"=>$customer_id,"qr_path"=>$qrcode['qr_path'],"order_id"=>$shipdata['orderid'],'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'quantity'=>$shipdata['pkgs_count'], 'quantity_type'=>$shipdata['pkgs_uom'], 'cargo_content'=>$shipdata['cargo_content']);
                                $sendQRmail = $this->sendQRmail($custdata);*/
                            }
                        }
                    }
                    $responseord['weight_unit'] = $weight_unit;
                    $responseord['volume_unit'] = $volume_unit;
                    $department_code = $shipdata['senderbranchcode'];
                    $ordertype = $ordtype = $shipdata['shiporder']['ord_type'];
                    $ordertype_desc = "SALES ORDER";
                    if($ordertype == "CC"){
                        $ordertype_desc = "CLICK AND COLLECT";
                    }else{
                        $ordertype = "SO";
                    }
                    $whr = array('company_code'=>$company_code,'branch_code'=>$branch_code,"ordtype_code"=>$ordertype,"status"=>1);
                    $chk = $this->common->gettblrowdata($whr,"id","tb_order_types",0,0);
                    if(count($chk)>0){
                        $order_type = $chk['id'];
                    }else{
                        $insarr = array('type_name'=>$ordertype, 'description'=>$ordertype_desc, 'company_code'=>$company_code, 'branch_code'=>$branch_code, 'department_code'=>$department_code, 'customer_id'=>0, 'ordtype_code'=>$ordertype, 'status'=>1, 'createdon'=>$curdt);
                        $order_type = $this->common->insertTableData("tb_order_types",$insarr);
                    }
                    $responseord['ordtype'] = $ordtype;
                    $genord = array("user_id"=>$user_id,"order_id"=>$ord_id,"country_code"=>$countrycode,"company_code"=>$company_code);
                    $booking_id = $ord_id;
                    if($checkexists == 0){
                        $booking_id = generatebookingid($genord);
                    }else{
                        $getordid = $this->common->gettblrowdata(array('id'=>$ord_id),"order_id","tb_orders",0,0);
                        if(count($getordid)>0){
                            $booking_id = $getordid['order_id'];
                        }
                    }
                    $orddata['order_id'] = $booking_id;
                    $responseord['ordinfo'] = $orddata;
                    $shipdata['order_id'] = $booking_id;
                    $customs = 0;
                    if($shipdata['shiporder']['cust_ord_type'] == "Y"){
                        $customs = 1;
                    }
                    $servicetype = 1;
                    if($shipdata['shiporder']['service_type'] != ""){
                        $whr = array("service_id"=>$shipdata['shiporder']['service_type'],"status"=>1);
                        $chk = $this->common->gettblrowdata($whr,"id","tb_service_master",0,0);
                        if(count($chk)>0){
                            $servicetype = $chk['id'];
                        }else{
                            $insarr = array('company_code'=>$company_code, 'branch_code'=>$branch_code, 'user_id'=>$user_id, 'service_id'=>$shipdata['shiporder']['service_type'], 'name'=>$shipdata['shiporder']['service_type'], 'status'=>1, 'createdon'=>$curdt);
                            $servicetype = $this->common->insertTableData("tb_service_master",$insarr);
                        }
                    }
                    $upd = $this->common->updatetbledata("tb_orders",array('order_id'=>$booking_id,"quantity"=>$qty_vam,"goods_value"=>$goods_value),array('id'=>$ord_id));
                    if($checkexists == 0){
                        $details_ins = array('order_row_id' => $ord_id,'order_id' => $booking_id, 'order_status' => 'PENDING', 'distance' => '0', 'department_code' => $department_code, 'order_type' => $order_type,'warehouse'=>$shipdata['shiporder']['warehouse'],'client'=>$shipdata['shiporder']['client'],'ord_num'=>$shipdata['shiporder']['ord_num'],'po_type'=>$shipdata['shiporder']['cust_po_type'],'po_date'=>date('Y-m-d H:i:s',strtotime($shipdata['shiporder']['cust_po_date'])),'cust_payment'=>$shipdata['shiporder']['cust_payment'],'shipmentby'=>$shipdata['shiporder']['deliver_contact'],'delivery_request'=>$shipdata['shiporder']['delver_req'],'rush_flag'=>$shipdata['shiporder']['rush_flag'],'shipment_id'=>$shipdata['shiporder']['shipmentid'],'purchase_order'=>$shipdata['shiporder']['cust_po_num'],'delivery_note'=>$shipdata['shiporder']['deliver_num'],'customs_required'=>$customs,'service'=>$servicetype,'createdon'=>$curdt);
                        $detailsins = $this->common->insertTableData('tb_order_details',$details_ins);
                    }else{
                        $details_ins = array('order_row_id'=>$ord_id,'order_id' => $booking_id, 'distance' => '0', 'department_code' => $department_code, 'order_type' => $order_type,'warehouse'=>$shipdata['shiporder']['warehouse'],'client'=>$shipdata['shiporder']['client'],'ord_num'=>$shipdata['shiporder']['ord_num'],'po_type'=>$shipdata['shiporder']['cust_po_type'],'po_date'=>date('Y-m-d H:i:s',strtotime($shipdata['shiporder']['cust_po_date'])),'cust_payment'=>$shipdata['shiporder']['cust_payment'],'shipmentby'=>$shipdata['shiporder']['deliver_contact'],'delivery_request'=>$shipdata['shiporder']['delver_req'],'rush_flag'=>$shipdata['shiporder']['rush_flag'],'shipment_id'=>$shipdata['shiporder']['shipmentid'],'purchase_order'=>$shipdata['shiporder']['cust_po_num'],'delivery_note'=>$shipdata['shiporder']['deliver_num'],'customs_required'=>$customs,'service'=>$servicetype);
                        $detailsins = $this->common->updatetbledata('tb_order_details',$details_ins,array('order_row_id'=>$ord_id));
                    }
                    if(!empty($shipdata['ship_id'])){
                        $chkdt = array('order_id'=>$ord_id, 'reference_id'=>"DQ");
                        $chkref = $this->common->gettblrowdata($chkdt,"id","tb_order_references",0,0);
                        if(count($chkref) == 0){
                            $srefqry = array('order_id'=>$ord_id, 'reference_id'=>"DQ", 'ref_value'=>$shipdata['ship_id'], 'status'=>1, 'createdon'=>$curdt);
                            $srefqryins = $this->common->insertTableData('tb_order_references',$srefqry);
                        }else{
                            $whrref = array('id'=>$chkref['id']);
                            $updref = array('ref_value'=>$shipdata['ship_id'], 'status'=>1);
                            $srefqryins = $this->common->updatetbledata('tb_order_references',$updref,$whrref);
                        }
                    }
                    if(!empty($data['header']['uuid'])){
                        $chkdt = array('order_id'=>$ord_id, 'reference_id'=>"UUID");
                        $chkref1 = $this->common->gettblrowdata($chkdt,"id","tb_order_references",0,0);
                        if(count($chkref1) == 0){
                            $srefqry = array('order_id'=>$ord_id, 'reference_id'=>"UUID", 'ref_value'=>$data['header']['uuid'], 'status'=>1, 'createdon'=>$curdt);
                            $srefqryins = $this->common->insertTableData('tb_order_references',$srefqry);
                        }else{
                            $whrref = array('id'=>$chkref1['id']);
                            $updref = array('ref_value'=>$data['header']['uuid'], 'status'=>1);
                            $srefqryins = $this->common->updatetbledata('tb_order_references',$updref,$whrref);
                        }
                    }
                    if(!empty($data['header']['correlationid'])){
                        $chkdt = array('order_id'=>$ord_id, 'reference_id'=>"CORID", 'ref_value'=>$data['header']['correlationid']);
                        $chkref2 = $this->common->gettblrowdata($chkdt,"id","tb_order_references",0,0);
                        if(count($chkref2) == 0){
                            $srefqry = array('order_id'=>$ord_id, 'reference_id'=>"CORID", 'ref_value'=>$data['header']['correlationid'], 'status'=>1, 'createdon'=>$curdt);
                            $srefqryins = $this->common->insertTableData('tb_order_references',$srefqry);
                        }else{
                            $whrref = array('id'=>$chkref2['id']);
                            $updref = array('ref_value'=>$data['header']['correlationid'], 'status'=>1);
                            $srefqryins = $this->common->updatetbledata('tb_order_references',$updref,$whrref);
                        }
                    }
                    if(!empty($shipdata['senderbranchcode'])){
                        $chkdt = array('order_id'=>$ord_id, 'reference_id'=>"WH");
                        $chkref3 = $this->common->gettblrowdata($chkdt,"id","tb_order_references",0,0);
                        if(count($chkref3) == 0){
                            $srefqry = array('order_id'=>$ord_id, 'reference_id'=>"WH", 'ref_value'=>$shipdata['senderbranchcode'], 'status'=>1, 'createdon'=>$curdt);
                            $srefqryins = $this->common->insertTableData('tb_order_references',$srefqry);
                        }else{
                            $whrref = array('id'=>$chkref3['id']);
                            $updref = array('ref_value'=>$shipdata['senderbranchcode'], 'status'=>1);
                            $srefqryins = $this->common->updatetbledata('tb_order_references',$updref,$whrref);
                        }
                    }
                    if(!empty($shipdata['shiporder']['cust_po_num'])){
                        $chkdt = array('order_id'=>$ord_id, 'reference_id'=>"PO");
                        $chkref4 = $this->common->gettblrowdata($chkdt,"id","tb_order_references",0,0);
                        if(count($chkref4) == 0){
                            $srefqry = array('order_id'=>$ord_id, 'reference_id'=>"PO", 'ref_value'=>$shipdata['shiporder']['cust_po_num'], 'status'=>1, 'createdon'=>$curdt);
                            $srefqryins = $this->common->insertTableData('tb_order_references',$srefqry);
                        }else{
                            $whrref = array('id'=>$chkref4['id']);
                            $updref = array('ref_value'=>$shipdata['shiporder']['cust_po_num'], 'status'=>1);
                            $srefqryins = $this->common->updatetbledata('tb_order_references',$updref,$whrref);
                        }
                    }
                    /*if(!empty($shipdata['orderid'])){
                        $chkdt = array('order_id'=>$ord_id, 'reference_id'=>"XSR", 'ref_value'=>$shipdata['orderid']);
                        $chkref = $this->common->gettblrowdata($chkdt,"id","tb_order_references",0,0);
                        if(count($chkref) == 0){
                            $srefqry = array('order_id'=>$ord_id, 'reference_id'=>"XSR", 'ref_value'=>$shipdata['orderid'], 'status'=>1, 'createdon'=>$curdt);
                            $srefqryins = $this->common->insertTableData('tb_order_references',$srefqry);
                        }
                    }*/
                    if(!empty($shipdata['shiporder']['ord_num'])){
                        $responseord['item_no'] = $shipdata['shiporder']['ord_num'];
                        $chkdt = array('order_id'=>$ord_id, 'reference_id'=>"XSR");
                        $chkref5 = $this->common->gettblrowdata($chkdt,"id","tb_order_references",0,0);
                        if(count($chkref5) == 0){
                            $srefqry = array('order_id'=>$ord_id, 'reference_id'=>"XSR", 'ref_value'=>$shipdata['shiporder']['ord_num'], 'status'=>1, 'createdon'=>$curdt);
                            $srefqryins = $this->common->insertTableData('tb_order_references',$srefqry);
                        }else{
                            $whrref = array('id'=>$chkref5['id']);
                            $updref = array('ref_value'=>$shipdata['shiporder']['ord_num'], 'status'=>1);
                            $srefqryins = $this->common->updatetbledata('tb_order_references',$updref,$whrref);
                        }
                    }
                    if(isset($consignee_id)){
                        $checkparty = $this->common->gettblrowdata(array('order_id'=>$ord_id,'party_id'=>$consignee_id,'party_type'=>$cn_partytype),"id","tb_order_parties",0,0);
                        if(count($checkparty)>0){
                            $partyarr = array('order_number'=>$booking_id,'party_id'=>$consignee_id,'party_type'=>$cn_partytype, 'status'=>1);
                            $partyid = $checkparty['id'];
                            $upd = $this->common->updatetbledata('tb_order_parties',$partyarr,array("id"=>$partyid));
                        }else{
                            $partyarr = array('order_id'=>$ord_id,'order_number'=>$booking_id,'party_id'=>$consignee_id,'party_type'=>$cn_partytype, 'status'=>1,'createdon'=>$curdt);
                            $ins = $this->common->insertTableData("tb_order_parties",$partyarr);
                        }
                    }
                    if(isset($shipper_id)){
                        $checkparty = $this->common->gettblrowdata(array('order_id'=>$ord_id,'party_id'=>$shipper_id,'party_type'=>$sh_partytype),"id","tb_order_parties",0,0);
                        if(count($checkparty)>0){
                            $partyarr = array('order_number'=>$booking_id,'party_id'=>$shipper_id,'party_type'=>$sh_partytype, 'status'=>1);
                            $partyid = $checkparty['id'];
                            $upd = $this->common->updatetbledata('tb_order_parties',$partyarr,array("id"=>$partyid));
                        }else{
                            $partyarr = array('order_id'=>$ord_id,'order_number'=>$booking_id,'party_id'=>$shipper_id,'party_type'=>$sh_partytype, 'status'=>1,'createdon'=>$curdt);
                            $ins = $this->common->insertTableData("tb_order_parties",$partyarr);
                        }
                    }
                    if(isset($carrier_party_id)){
                        $checkparty = $this->common->gettblrowdata(array('order_id'=>$ord_id,'party_id'=>$carrier_party_id,'party_type'=>$ca_partytype),"id","tb_order_parties",0,0);
                        if(count($checkparty)>0){
                            $partyarr = array('order_number'=>$booking_id,'party_id'=>$carrier_party_id,'party_type'=>$ca_partytype, 'status'=>1);
                            $partyid = $checkparty['id'];
                            $upd = $this->common->updatetbledata('tb_order_parties',$partyarr,array("id"=>$partyid));
                        }else{
                            $partyarr = array('order_id'=>$ord_id,'order_number'=>$booking_id,'party_id'=>$carrier_party_id,'party_type'=>$ca_partytype, 'status'=>1,'createdon'=>$curdt);
                            $ins = $this->common->insertTableData("tb_order_parties",$partyarr);
                        }
                    }
                    if(isset($cust_id)){
                        $checkparty = $this->common->gettblrowdata(array('order_id'=>$ord_id,'party_id'=>$cust_id,'party_type'=>$pf_partytype),"id","tb_order_parties",0,0);
                        if(count($checkparty)>0){
                            $partyarr = array('order_number'=>$booking_id,'party_id'=>$cust_id,'party_type'=>$pf_partytype, 'status'=>1);
                            $partyid = $checkparty['id'];
                            $upd = $this->common->updatetbledata('tb_order_parties',$partyarr,array("id"=>$partyid));
                        }else{
                            $partyarr = array('order_id'=>$ord_id,'order_number'=>$booking_id,'party_id'=>$cust_id,'party_type'=>$pf_partytype, 'status'=>1,'createdon'=>$curdt);
                            $ins = $this->common->insertTableData("tb_order_parties",$partyarr);
                        }
                    }
                }
            }
        }
        return $responseord;
    }
   
    public function checkcarrier($customer,$cmpcode,$branchcode,$uid){
        $res = array();
        $curdt = date("Y-m-d H:i:s");
        $cwhr1['party_type_id'] = 2;
        $chkpartytype = $this->common->gettblrowdata(array("name"=>"Carrier","user_id"=>$uid,'company_code'=>$cmpcode),"id","tbl_party_types",0,0);
        if(count($chkpartytype)>0){
            $cwhr1['party_type_id'] = $chkpartytype['id'];
        }
        if(isset($customer['custid'])){
            if($customer['custid'] != ""){
                $cwhr = array('name'=>$customer['name'],"code"=>$customer['custid']);
                $ctable = 'tb_vendors';
                $cselect = 'id';
                $chkcust = $this->common->gettblrowdata($cwhr,$cselect,$ctable,0,0);
                if(count($chkcust) > 0){
                    $cust_id = $chkcust['id'];
                    $addr = $customer['street'].", ".$customer['street1'].", ".$customer['city'].", ".$customer['country'].", ".$customer['zip'];
                    $upddata = array('location'=>$customer['city'], 'address'=>$addr, 'pincode'=>$customer['zip'],'country'=>$customer['country'], 'effective_date'=>date('Y-m-d'), 'expiry_date'=>date('Y-m-d'), 'service_id'=>$customer['custid'], 'service_name'=>$customer['partyid'],'user_id'=>$uid, 'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1,'updated_on'=>$curdt);
                    $upd = $this->common->updatetbledata('tb_vendors',$upddata,array("id"=>$cust_id));
                }else{
                    $randnum = trim($customer['custid']);
                    $randnum = str_replace(" ", "", $randnum);
                    $randnum = str_replace("+", "", $randnum);
                    $randnum = str_replace("-", "", $randnum);
                    $pwd = password_hash($randnum, PASSWORD_DEFAULT);
                    $addr = $customer['street'].", ".$customer['street1'].", ".$customer['city'].", ".$customer['country'].", ".$customer['zip'];
                    $cinsdata = array('name'=>$customer['name'], 'mobile'=>$customer['custid'], 'location'=>$customer['city'], 'address'=>$addr, 'pincode'=>$customer['zip'], 'country'=>$customer['country'], 'password'=>$pwd,'email'=>$customer['email'], 'code'=>$customer['custid'], 'offering_type'=>'FTL', 'carrier_grade'=>'ABC', 'effective_date'=>date('Y-m-d'), 'expiry_date'=>date('Y-m-d'), 'service_id'=>$customer['custid'], 'service_name'=>$customer['partyid'], 'user_id'=>$uid,'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
                    $cust_id = $this->common->insertTableData('tb_vendors',$cinsdata);
                }
                $chkcust = $this->common->gettblrowdata($cwhr,$cselect,"tbl_party_master",0,0);
                if(count($chkcust) > 0){
                    $custid = $chkcust['id'];
                    $upddata = array('location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'], 'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1,'updated_on'=>$curdt);
                    $upd = $this->common->updatetbledata('tbl_party_master',$upddata,array("id"=>$custid));
                }else{
                    $randnum = trim($customer['custid']);
                    $randnum = str_replace(" ", "", $randnum);
                    $randnum = str_replace("+", "", $randnum);
                    $randnum = str_replace("-", "", $randnum);
                    $pwd =  password_hash($randnum, PASSWORD_DEFAULT);
                    $cinsdata = array('party_type_id'=>$cwhr1['party_type_id'], 'name'=>$customer['name'], 'email'=>$customer['email'],'mobile'=>$customer['custid'], 'location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'],'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
                    $custid = $this->common->insertTableData('tbl_party_master',$cinsdata);
                }
                $res['id'] = $cust_id;
                $res['party_id'] = $custid;
                $res['party_type'] = $cwhr1['party_type_id'];
            }else{
                if($customer['name'] != ""){
                    $cust_id = 0;
                    $custid = "";
                    $cwhr = array('name'=>$customer['name']);
                    $ctable = 'tb_vendors';
                    $cselect = 'id';
                    $chkcust = $this->common->gettblrowdata($cwhr,$cselect,$ctable,0,0);
                    if(count($chkcust) > 0){
                        $cust_id = $chkcust['id'];
                    }
                    $chkcust = $this->common->gettblrowdata($cwhr,$cselect,"tbl_party_master",0,0);
                    if(count($chkcust) > 0){
                        $custid = $chkcust['id'];
                    }
                    $res['id'] = $cust_id;
                    $res['party_id'] = $custid;
                    $res['party_type'] = $cwhr1['party_type_id'];
                }
            }
        }
        return $res;
    }
  
    public function checkcustomer($customer,$cmpcode,$branchcode,$uid,$custtype){
        $cwhr1 = array("code"=>$customer['custid']);
        $cselect = 'id';
        $curdt = date("Y-m-d H:i:s");
        $cust_id = 0;
        $ctable = 'tb_customers';
        $chkcust = $this->common->gettblrowdata($cwhr1,$cselect,$ctable,0,0);
        if(count($chkcust) > 0){
            $cust_id = $chkcust['id'];
            $upddata = array('location'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'], 'user_id'=>$uid, 'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1,'updatedon'=>$curdt);
            $upd = $this->common->updatetbledata('tb_customers',$upddata,array("id"=>$cust_id));
        }else{
            $randnum = $customer['custid'];
            $pwd = password_hash($randnum, PASSWORD_DEFAULT);
            $cinsdata = array('name'=>$customer['name'], 'phone'=>$customer['custid'], 'location'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'], 'password'=>$pwd, 'user_id'=>$uid,'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
            $cust_id = $this->common->insertTableData('tb_customers',$cinsdata);
        }
        $party_type_id = 5;
        $chkpartytype = $this->common->gettblrowdata(array("name"=>"Customer","user_id"=>$uid,'company_code'=>$cmpcode),"id","tbl_party_types",0,0);
        if(count($chkpartytype)>0){
            $party_type_id = $chkpartytype['id'];
        }
        $chkcust = $this->common->gettblrowdata($cwhr1,$cselect,"tbl_party_master",0,0);
        if(count($chkcust) > 0){
            $custid = $chkcust['id'];
            $upddata = array('location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'], 'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1,'updated_on'=>$curdt);
            $upd = $this->common->updatetbledata('tbl_party_master',$upddata,array("id"=>$custid));
        }else{
            $randnum = $customer['custid'];
            $pwd = password_hash($randnum, PASSWORD_DEFAULT);
            $cinsdata = array('party_type_id'=>$party_type_id, 'name'=>$customer['name'], 'email'=>$customer['email'],'mobile'=>$customer['custid'], 'location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'],'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
            $custid = $this->common->insertTableData('tbl_party_master',$cinsdata);
        }
        $res['id'] = $cust_id;
        $res['party_id'] = $custid;
        $res['party_type'] = $party_type_id;
        return $res;
    }
    
    public function checkconsignee($customer,$cmpcode,$branchcode,$uid,$custtype){
        $cwhr1 = array("code"=>$customer['custid']);
        $cselect = 'id';
        $curdt = date("Y-m-d H:i:s");
        $cust_id = 0;
        $party_type_id = 3;
        $chkpartytype = $this->common->gettblrowdata(array("name"=>"Consignee","user_id"=>$uid,'company_code'=>$cmpcode),"id","tbl_party_types",0,0);
        if(count($chkpartytype)>0){
            $party_type_id = $chkpartytype['id'];
        }
        $chkcust = $this->common->gettblrowdata($cwhr1,$cselect,"tbl_party_master",0,0);
        if(count($chkcust) > 0){
            $custid = $chkcust['id'];
            $upddata = array('location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'], 'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'state'=>$customer['state'],'street_2'=>$customer['street_2'],'street_3'=>$customer['street_3'],'email'=>$customer['email'],'fax'=>$customer['fax'],"vat_reg_no"=>$customer['vat'], 'status'=>1,'updated_on'=>$curdt);
            $upd = $this->common->updatetbledata('tbl_party_master',$upddata,array("id"=>$custid));
        }else{
            $randnum = $customer['custid'];
            $pwd = password_hash($randnum, PASSWORD_DEFAULT);
            $cinsdata = array('party_type_id'=>$party_type_id, 'name'=>$customer['name'],'email'=>$customer['email'],'mobile'=>$customer['custid'], 'location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'],'company_code'=>$cmpcode, 'branch_code'=>$branchcode,'state'=>$customer['state'],'street_2'=>$customer['street_2'],'street_3'=>$customer['street_3'],'fax'=>$customer['fax'],"vat_reg_no"=>$customer['vat'], 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
            $custid = $this->common->insertTableData('tbl_party_master',$cinsdata);
        }
        $res['id'] = $cust_id;
        $res['party_id'] = $custid;
        $res['party_type'] = $party_type_id;
        return $res;
    }
    
    public function checkshipper($customer,$cmpcode,$branchcode,$uid,$custtype){
        $cwhr1 = array("code"=>$customer['custid']);
        $cselect = 'id';
        $curdt = date("Y-m-d H:i:s");
        $cust_id = 0;
        $party_type_id = 1;
        $chkpartytype = $this->common->gettblrowdata(array("name"=>"Shipper","user_id"=>$uid,'company_code'=>$cmpcode),"id","tbl_party_types",0,0);
        if(count($chkpartytype)>0){
            $party_type_id = $chkpartytype['id'];
        }
        $chkcust = $this->common->gettblrowdata($cwhr1,$cselect,"tbl_party_master",0,0);
        if(count($chkcust) > 0){
            $custid = $chkcust['id'];
            $upddata = array('location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'], 'company_code'=>$cmpcode, 'branch_code'=>$branchcode,'state'=>$customer['state'],'street_2'=>$customer['street_2'],'street_3'=>$customer['street_3'],'email'=>$customer['email'],'fax'=>$customer['fax'],"vat_reg_no"=>$customer['vat'], 'status'=>1,'updated_on'=>$curdt);
            $upd = $this->common->updatetbledata('tbl_party_master',$upddata,array("id"=>$custid));;
        }else{
            $randnum = $customer['custid'];
            $pwd = password_hash($randnum, PASSWORD_DEFAULT);
            $cinsdata = array('party_type_id'=>$party_type_id, 'name'=>$customer['name'],'email'=>$customer['email'],'mobile'=>$customer['custid'], 'location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'],'company_code'=>$cmpcode, 'branch_code'=>$branchcode,'state'=>$customer['state'],'street_2'=>$customer['street_2'],'street_3'=>$customer['street_3'],'fax'=>$customer['fax'],"vat_reg_no"=>$customer['vat'], 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
            $custid = $this->common->insertTableData('tbl_party_master',$cinsdata);
        }
        $res['id'] = $cust_id;
        $res['party_id'] = $custid;
        $res['party_type'] = $party_type_id;
        return $res;
    }
    
    function getlatlongbylocname($address){
        $response = getlatlngsbyplace($address);
        return [
            'latitude' => $response[0],
            'longitude' => $response[1]
        ];
    }
   
    public function ordercreatetrip($ordinput){
        $response = 0;
        $userid = $ordinput['user_id'];
        $year = date('y');
        $week = date('W');
        $curtz = $ordinput['curtz'];
        $curdt = date('Y-m-d H:i:s');
        $count_code = substr($ordinput['company_code'], 0, 2);
        $input['ordid'] = $ordinput['order_id'];
        $order = $ordinput['ordinfo'];
        $order_nm = $order['order_id'];
        $seq_num = substr($order_nm, - 6);
        $shipid = "T" . $count_code . $week . $year . $seq_num;
        /* check for exists */
        /*
         * $twhere = array("shipmentid"=>$shipid);
         * $tselect = "id";
         * $ttable = "tb_shifts";
         * $tship = $this->common->gettblrowdata($twhere,$tselect,$ttable,0,0);
         * if(count($tship)>0){
         * $seq_num = ($seq_num + 1);
         * $shipid = "T".$count_code.$week.$year.$seq_num;
         * }
         */
        /* trip id creation ends here */
        $vendor_id = '310';
        $vehicle_id = "";
        $driver_id = "";
        $ttype = $this->common->gettblrowdata(array("trucktype"=>"LTL","status"=>"Active","company_code"=>$ordinput['company_code']),"id,trucktype","tb_trucktypes",0,0);
        if(count($ttype)>0){
            $tpvehicle_type = $ttype['id'];
            $vehicle_type = $ttype['trucktype'];
        }else{
            $tpvehicle_type = 1;
            $vehicle_type = 'truck';
        }
        $carrier_instructions = "";
        if ($shipid != "" && $ordinput['order_id'] > 0) {
            $shift_idchk = isset($order['shift_id']) ? $order['shift_id'] : 0;
            if ($shift_idchk == 0) {
                $pickup = $order['pickup_address1'];
                if ($pickup == "") {
                    $pickup = $order['pickup_city'];
                }
                $delivery = $order['delivery_address1'];
                if ($delivery == "") {
                    $delivery = $order['delivery_city'];
                }
                $address = $dropaddr = "";
                if ($order['pickup_address1'] != "") {
                    $address .= $order['pickup_address1'];
                    $dropaddr .= $order['delivery_address1'];
                }
                if ($order['pickup_company'] != "") {
                    $address .= ", " . $order['pickup_company'];
                    $dropaddr .= ", " . $order['delivery_company'];
                }
                if ($order['pickup_country'] != "") {
                    $address .= ", " . $order['pickup_country'];
                    $dropaddr .= ", " . $order['delivery_country'];
                }
                if ($order['pickup_city'] != "") {
                    $address .= ", " . $order['pickup_city'];
                    $dropaddr .= ", " . $order['delivery_city'];
                }
                if ($order['pickup_pincode'] != "") {
                    $address .= ", " . $order['pickup_pincode'];
                    $dropaddr .= ", " . $order['delivery_pincode'];
                }
                $plat = $order['plat'];
                $plng = $order['plng'];
                $dlat = $order['dlat'];
                $dlng = $order['dlng'];
                $where = array("shipmentid"=>$shipid);
                $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                $table = "tb_shifts";
                $shipment = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                if (count($shipment) == 0) {
                    $splace = $order['pickup_address1'];
                    $eplace = $order['delivery_address1'];
                    $pickup_city = $order['pickup_city'];
                    $delivery_city = $order['delivery_city'];
                    $customer_id = $order['customer_id'];
                    $transport_mode = $order['transport_mode'];
                    $weight = $order['weight'];
                    $volume = $order['volume'];
                    $txnid = $shipid;
                    $startdate = $order['pickup_datetime'];
                    $starttime = date('H:i', strtotime($startdate));
                    $enddate = $order['delivery_datetime'];
                    $endtime = date('H:i', strtotime($enddate));
                    /*$getactual = getdatetimebytimezone(DFLT_TZ,$enddate,$curtz);
                    $enddate = $getactual['datetime'];*/
                    $insarr = array(
                        'user_id'=>$userid,
                        'stime'=>$starttime,
                        'etime'=>$endtime,
                        'splace'=>$order['pickup_city'],
                        'slat'=>$plat,
                        'slng'=>$plng,
                        'eplace'=>$order['delivery_city'],
                        'elat'=>$dlat,
                        'elng'=>$dlng,
                        'scity'=>$order['pickup_city'],
                        'dcity'=>$order['delivery_city'],
                        'zone_id'=>1,
                        'empshift_start'=>$starttime,
                        'empshift_end'=>$endtime,
                        'trip_type'=>0,
                        'startdate'=>$startdate,
                        'enddate'=>$enddate,
                        'shipment_name'=>'Boxes',
                        'shipment_id'=>0,
                        'transport_mode'=>$transport_mode,
                        'customer_id'=>$customer_id,
                        'vendor_id'=>$vendor_id,
                        'carrier_type'=>0,
                        'shipmentid'=>$shipid,
                        'txnid'=>$txnid,
                        'weight'=>$weight,
                        'volume'=>$volume,
                        'units'=>$order['quantity'],
                        'domainname'=>'INFD',
                        'vehicle_type'=>$vehicle_type,
                        'company_code'=>$order['company_code'],
                        'branch_code'=>$order['branch_code'],
                        'carrier_instructions'=>$carrier_instructions,
                        'status'=>1
                    );
                    $ship_id = $this->common->insertTableData("tb_shifts", $insarr);
                } else {
                    $ship_id = $shipment['id'];
                }
                /* update order table */
                $upddt = array('vendor_id'=>$vendor_id,'shift_id'=>$ship_id,"shipmentid"=>$shipid,"status"=>2);
                $updwhr = array("id"=>$ordinput['order_id']);
                $upd = $this->common->updatetbledata("tb_orders", $upddt, $updwhr);
                /*$invtypes = makeorderinvolvedpartiestype($vendor_id, $ordinput['order_id'], "CARRIER");
                $this->ordernotify('trip_create', $ordinput['order_id']);*/
                $capacity = $order['weight'];
                if ($capacity == "") {
                    $capacity = "0";
                }
                /* insert stops records */
                $where = array("shipment_id"=>$ship_id,"stopcity"=>$order['pickup_city'], "stoptype"=>"P");
                $select = "id";
                $table = "tb_shiporder_stops";
                $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                if (count($chkstop) == 0) {
                    $insarr = array(
                        'stopname'=>$order['pickup_city'],
                        'plat'=>$plat,
                        'plng'=>$plng,
                        'stopcity'=>$order['pickup_city'],
                        'address'=>$address,
                        'stoptype'=>'P',
                        'stopstatus'=>0,
                        'shipment_id'=>$ship_id,
                        'ordernumber'=>1,
                        'startdate'=>$order['pickup_datetime'],
                        'enddate'=>$order['pickup_endtime'],
                        'weight'=>$order['weight'],
                        'volume'=>$order['volume'],
                        'shipmentstopid'=>0,
                        'ship_units'=>$order['quantity'],
                        'txncode'=>'NP',
                        'status'=>1,
                        'created_on'=>$curdt
                    );
                    $pickupstop_id = $this->common->insertTableData("tb_shiporder_stops", $insarr);
                } else {
                    $pickupstop_id = $chkstop['id'];
                }
                $where = array("shipment_id"=>$ship_id,"stopcity"=>$order['delivery_city'],"stoptype"=>"D");
                $select = "id";
                $table = "tb_shiporder_stops";
                $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                if (count($chkstop) == 0) {
                    $insarr = array(
                        'stopname'=>$order['delivery_city'],
                        'plat'=>$dlat,
                        'plng'=>$dlng,
                        'stopcity'=>$order['delivery_city'],
                        'address'=>$dropaddr,
                        'stoptype'=>'D',
                        'stopstatus'=>0,
                        'shipment_id'=>$ship_id,
                        'ordernumber'=>2,
                        'startdate'=>$order['delivery_datetime'],
                        'enddate'=>$order['drop_endtime'],
                        'weight'=>$order['weight'],
                        'volume'=>$order['volume'],
                        'shipmentstopid'=>0,
                        'ship_units'=>$order['quantity'],
                        'txncode'=>'NP',
                        'status'=>1,
                        'created_on'=>$curdt
                    );
                    $dropstop_id = $this->common->insertTableData("tb_shiporder_stops", $insarr);
                } else {
                    $dropstop_id = $chkstop['id'];
                }
                /* add pickupstop and drop stop id into details/tb_employee table */
                $where = array('stop_id'=>$pickupstop_id,'drop_stopid'=>$dropstop_id,'order_id'=>$order['order_id'],'shift_id'=>$ship_id);
                $select = "id";
                $table = "tb_employee";
                $chkemp = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                if (count($chkemp) == 0) {
                    $insarr = array(
                        'assoc_id'=>$shipid,
                        'pickup'=>$pickup,
                        'plat'=>$plat,
                        'plng'=>$plng,
                        'drop'=>$delivery,
                        'dlat'=>$dlat,
                        'dlng'=>$dlng,
                        'pickup_city'=>$order['pickup_city'],
                        'drop_city'=>$order['delivery_city'],
                        'pickup_datetime'=>$order['pickup_datetime'],
                        'drop_datetime'=>$order['delivery_datetime'],
                        'name'=>'Boxes',
                        'phone'=>$order['customer_phone'],
                        'address'=>$address,
                        'emailid'=>$order['customer_email'],
                        'user_id'=>$userid,
                        'status'=>1,
                        'createdon'=>$curdt,
                        'material_id'=>0,
                        'capacity'=>$capacity,
                        'information'=>$order['customer_comments'],
                        'shipment_weight'=>$order['weight'],
                        'shipment_volume'=>$order['volume'],
                        'ship_type'=>'P',
                        'customer_id'=>$order['customer_id'],
                        'vendor_id'=>$vendor_id,
                        'shipment_id'=>0,
                        'startdate'=>$order['pickup_datetime'],
                        'enddate'=>$order['delivery_datetime'],
                        'shift_id'=>$ship_id,
                        'stop_order'=>1,
                        'drop_order'=>0,
                        'basic_stop'=>0,
                        'stop_id'=>$pickupstop_id,
                        'drop_stopid'=>$dropstop_id,
                        'order_id'=>$order['order_id'],
                        'pkgitemid'=>'BOXES',
                        'no_of_pkgs'=>$order['quantity'],
                        'domainname'=>'INFD'
                    );
                    $detail_id = $this->common->insertTableData("tb_employee", $insarr);
                } else {
                    $detail_id = $chkemp['id'];
                }
                $upd = $this->common->updatetbledata("tb_order_cargodetails",array("stop_detail_id"=>$detail_id),array("order_id"=>$ordinput['order_id']));
                $chk1 = $this->common->gettblrowdata(array("shft_id"=>$ship_id),"id","tb_shft_veh",0,0);
                if (count($chk1) > 0) {
                    $shftvehid = $chk1['id'];
                    $chk = $this->common->gettblrowdata(array("shft_veh_id"=>$shftvehid,"status"=>1),"id","tb_shft_veh_emp",0,0);
                    if (count($chk) == 0) {
                        $getemp = $this->common->gettbldata(array("shift_id"=>$ship_id),"id,pickup_datetime,drop_datetime","tb_employee",0,0);
                        if (count($getemp) > 0) {
                            $pri = 1;
                            foreach ($getemp as $gt) {
                                $insveh1 = array(
                                    "user_id"=>$userid,
                                    "shft_veh_id"=>$shftvehid,
                                    "emp_id"=>$gt['id'],
                                    "priority"=>$pri,
                                    "pickup_time"=>$gt['pickup_datetime'],
                                    'created_on'=>$curdt,
                                    'updated_on'=>$curdt,
                                    "status"=>1,
                                    "drop_time"=>$gt['drop_datetime']
                                );
                                $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                $pri ++;
                            }
                        }
                    } else {
                        $chkemp = $this->common->gettblrowdata(array("shft_veh_id"=>$shftvehid,"emp_id"=>$detail_id,"status"=>1),"id","tb_shft_veh_emp",0,0);
                        if (count($chkemp) == 0) {
                            $insveh1 = array(
                                "user_id"=>$userid,
                                "shft_veh_id"=>$shftvehid,
                                "emp_id"=>$detail_id,
                                "priority"=>3,
                                "pickup_time"=>$order['pickup_datetime'],
                                'created_on'=>$curdt,
                                'updated_on'=>$curdt,
                                "status"=>1,
                                "drop_time"=>$order['delivery_datetime']
                            );
                            $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                        }
                    }
                } else {
                    $veh = $this->common->gettblrowdata(array("vendor_id"=>'310','status'=>'Active'),"id,register_number","tb_trucks_data",0,0);
                    if (count($veh)>0) {
                        $veh_num = $veh['register_number'];
                        $vehicle_id = $veh['id'];
                        $arr = array(
                            'user_id'=>$userid,
                            'route_id'=>0,
                            'shft_id'=>$ship_id,
                            'carrier_id'=>$vendor_id,
                            'vehicle_id'=>$vehicle_id,
                            'register_number'=>$veh_num,
                            'created_on'=>$curdt,
                            'updated_on'=>$curdt,
                            'status'=>1
                        );
                        $shftvehid = $this->common->insertTableData("tb_shft_veh", $arr);
                        $getemp = $this->common->gettbldata(array("shift_id"=>$ship_id),"id,pickup_datetime,drop_datetime","tb_employee",0,0);
                        if (count($getemp) > 0) {
                            $pri = 1;
                            foreach ($getemp as $gt) {
                                $insveh1 = array(
                                    "user_id"=>$userid,
                                    "shft_veh_id"=>$shftvehid,
                                    "emp_id"=>$gt['id'],
                                    "priority"=>$pri,
                                    "pickup_time"=>$gt['pickup_datetime'],
                                    'created_on'=>$curdt,
                                    'updated_on'=>$curdt,
                                    "status"=>1,
                                    "drop_time"=>$gt['drop_datetime']
                                );
                                $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                $pri ++;
                            }
                        }
                    }
                }
                if ($vehicle_id != "") {
                    $chk = $this->common->gettblrowdata(array("vehicle_id"=>$vehicle_id),"id,driver_id,status","tb_vehicles_drivers",0,0);
                    if (count($chk) > 0) {
                        $driver_id = $chk['driver_id'];
                        $chk11 = $this->common->gettblrowdata(array("driver_id"=>$driver_id,"vehicle_id"=>$vehicle_id),"id","tbl_assigned_drivers",0,0);
                        if (count($chk11) > 0) {
                            $upd = $this->common->updatetbledata("tbl_assigned_drivers",array("status"=>'1','updated_on'=>$curdt),array("id"=>$chk11['id']));
                        } else {
                            $insarr = array(
                                "vehicle_id"=>$vehicle_id,
                                "user_id"=>$userid,
                                "driver_id"=>$driver_id,
                                "mobile_no"=>$driver_id,
                                "imei"=>"",
                                "from_time"=>$curdt,
                                "to_time"=>$curdt,
                                "status"=>"1",
                                'created_on'=>$curdt
                            );
                            $ins = $this->common->insertTableData("tbl_assigned_drivers",$insarr);
                        }
                    }
                }
                $response = $ship_id;
                /* update status */
                $chk = $this->common->gettblrowdata(array("shipment_id"=>$ship_id,"status_id"=>9),"id","tb_stop_status",0,0);
                if(count($chk) == 0){
                    $ins = array(
                        "order_id"=>$ordinput['order_id'],
                        "shipment_id"=>$ship_id,
                        "stop_id"=>0,
                        "stop_detail_id"=>0,
                        "stop_type"=>"",
                        "trip_id"=>0,
                        "status_id"=>9,
                        "status"=>1,
                        "status_code"=>"0100",
                        "reason"=>"Coming from E-Booking",
                        "createdon"=>$curdt
                    );
                    $insqry = $this->common->insertTableData("tb_stop_status",$ins);
                }
            }
        }
        return $response;
    }
}
