<?php

defined('BASEPATH') or exit('No direct script access allowed');

use App\Libraries\infrastructure\ScheduledJobLoggerService;
use phpseclib\Net\SFTP;

class Swiftlogreturnorderedi extends CI_Controller
{
    private $scheduledJobService;
    public function __construct()
    {
        parent::__construct();
        $this->load->model('common');
        $this->load->helper('log_helper');
        $this->scheduledJobService = ScheduledJobLoggerService::instance(get_class($this));
    }

    /*get the zip files which contains excel files(order data) from MFT and store in TMS*/
    public function index()
    {
        $this->scheduledJobService->startJob();

        $sftp_url = SWIFLOG_FTP;
        $username = SWIFLOG_FTP_USER;
        $password = SWIFLOG_FTP_PWD;
        $files = [];
        $statusmsg = "No files";
        $actualfile = "";
        $file_names = array();
        $folder_name = "/pub/outbound/uniqlo/etnreturnorderinst/";
        $sftp = new SFTP($sftp_url);
        if (!$sftp->login($username, $password)) {
            $this->scheduledJobService->log("swiftlogreturnorderedi","Cannot login into SFTP server");
            unset($sftp);
            throw new Exception('Cannot login into your server !');
        }
        $sftp->chdir($folder_name);
        $files_list = $sftp->nlist();

        $this->scheduledJobService->log("swiftlogreturnorderedi","Number of files received: ".count($files_list));

        if (!empty($files_list)) {
            foreach ($files_list as $key => $value) {
                if ($value != "." && $value != "..") {
                    $path_info = pathinfo($value);
                    $actualfile = $value;
                    $extesion = $path_info['extension'];
                    if ($extesion == "zip") {
                        $server_file = "/pub/outbound/uniqlo/etnreturnorderinst/" . $value;
                        $localfile = "./assets/swiftlog/" . $value;
                        if (!file_exists(dirname($localfile))) {
                            mkdir(dirname($localfile), 0700, true);
                        }
                        $zipname = str_replace(".zip", "", $value);
                        /*edi log*/
                        $company_code = "INKN";
                        $branch_code = "INCL";
                        $edi_request = $value;
                        $edi_response = "";
                        $params = array(
                            'edi_type' => 1, /*'1->EDI Transport Order,2->EDI Status'*/
                            'transaction_id' => time(),
                            'edi_id' => 16, /*edi id based on name take it from tb_edi_types*/
                            'edi_name' => 'Swiftlog ReturnOrder',
                            'bounded_type' => 1, /*'1->Inbound(partner=>kN),2->Outbound (KN=>partner)'*/
                            'edi_format_type' => 'XML',
                            'status' => 0,
                            'obj_type' => 1,
                            'txn_obj_id' => 0,
                            'user_id' => 0,
                            'company_code' => $company_code,
                            'branch_code' => $branch_code,
                            'edi_request' => $edi_request,
                            'edi_response' => $edi_response
                        );

                        $edilogid = $this->common->insertTableData('tb_etn_edi_transactions', $params);

                        @file_put_contents($localfile, $sftp->get($server_file));
                        $filesinfo = array();
                        $filepath = $localfile;
                        $zip = new ZipArchive();
                        $res = $zip->open($filepath);
                        if ($res === true) {
                            if ($zip->setPassword(SWIFLOG_RETURN_ORDZIP_PWD)) {

                                $bkp_file = "/pub/outbound/uniqlo/backups/etnreturnorderinst/" . $value;
                                $sftp->put($bkp_file, $sftp->get($server_file));
                                $sftp->delete($server_file, false);
                                $dirname = "IN" . time();
                                mkdir('./assets/swiftlog/extracts/' . $dirname, 0710, true);
                                $extractpath = "./assets/swiftlog/extracts/" . $dirname . "/";
                                if (!file_exists(dirname($extractpath))) {
                                    mkdir(dirname($extractpath), 0710, true);
                                }
                                $zip->extractTo($extractpath);
                                $flag = 0;
                                for ($i = 0; $i < $zip->numFiles; $i++) {
                                    $filename = $zip->getNameIndex($i);
                                    $fileinfo = pathinfo($filename);
                                    $explodeFileName = explode('.', $fileinfo['basename']);
                                    $file_ext = @strtolower(end($explodeFileName));
                                    $expensions = array("csv", "CSV");
                                    if (in_array($file_ext, $expensions)) {
                                        $filen = explode('.', $fileinfo['basename'])[0];
                                        $filesinfo['list'][$filen] = $extractpath . '' . $fileinfo['basename'];
                                    }
                                }
                            }
                            $zip->close();
                        }
                        $csvresp = array();

                        if (!empty($filesinfo)) {
                            require_once APPPATH . "/third_party/PHPExcel.php";
                            require_once APPPATH . "/third_party/PHPExcel/Writer/Excel2007.php";
                            $files_list = $filesinfo['list'];

                            if (count($files_list) > 0) {
                                foreach ($files_list as $key => $path) {
                                    $objPHPExcel = PHPExcel_IOFactory::load($path);
                                    $cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
                                    $data["arr_data"] = $data["header"] = array();
                                    $newdtat = array();
                                    foreach ($cell_collection as $cell) {
                                        $column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
                                        $row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
                                        $data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
                                        if ($row == 1) {
                                            $newdtat[] = $column;
                                            $data["header"][$row][$column] = $data_value;
                                        } else {
                                            if ($data_value == "") {
                                                $data_value = "0";
                                            }

                                            $data["arr_data"][$row][$column] = $data_value;
                                        }
                                        if ($row > 1) {
                                            if (count($cell_collection) != count($newdtat)) {
                                                foreach ($newdtat as $val) {
                                                    if (!isset($data["arr_data"][$row][$val])) {
                                                        $data["arr_data"][$row][$val] = "";
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    $csvresp[$key] = $data;
                                }
                            }
                        }
                        $returnord = array();
                        if (!empty($csvresp)) {
                            foreach ($csvresp as $key => $resp) {
                                $arrdata = array();
                                $hdt = $resp['header'][1];
                                foreach ($resp['arr_data'] as $adt) {
                                    foreach ($adt as $k => $adt1) {
                                        $arrdata[$hdt[$k]] = $adt1;
                                    }
                                    $returnord[$key][] = $arrdata;
                                }
                            }
                        }
                        $ordresponse = array();
                        if (!empty($returnord)) {
                            $this->scheduledJobService->log("swiftlogreturnorderedi","Number of orders in received files: ".count($returnord['Head']));
                            $ordresponse = $this->insertShipmentData($returnord);
                            $this->load->library('email');
                            $succmsg = "Assign Booking Pending";
                            if (!empty($ordresponse)) {
                                foreach ($ordresponse as $response) {
                                    if (!empty($response)) {
                                        if ($response['order_id'] > 0) {
                                            $orditem = isset($response['item_no']) ? $response['item_no'] : $response['ordinfo']['order_id'];
                                            $failmsg = "";
                                            $sub = "eTN: " . $orditem . " Return Order Created";
                                            /*check existed order trip*/
                                            $chekdocket = 0;
                                            if ($response['existsord'] > 0) {
                                                $chekdocket = $this->checkdocketnum($response);
                                                if ($chekdocket > 0) {
                                                    $succmsg = "Assigned to Carrier, Docket Number:" . $chekdocket;
                                                }
                                            }
                                            /*success mail*/
                                            $this->email->from(SVKONEKT_EMAIL, 'svkonekt');
                                            $this->email->to(UNIQLO_ORDER_MAILS);
                                            $this->email->subject($sub);
                                            $this->email->set_mailtype("html");
                                            $body = "Dear Team, <br/>";
                                            $body .= $sub . " <br/>";
                                            $body .= "Assign Status: <br/>";
                                            $body .= $succmsg . "<br/>";
                                            $body .= "Details: <br/>";
                                            if (isset($response['ordinfo'])) {
                                                $ordinf = $response['ordinfo'];
                                                $body .= "<b>Pickup:</b> <br/>";
                                                $body .= $ordinf['pickup_pincode'] . " <br/>";
                                                $body .= "<b>Delivery:</b> <br/>";
                                                $body .= $ordinf['delivery_pincode'] . " <br/>";
                                                $body .= "Item: " . $ordinf['product'] . " <br/>";
                                                $body .= "Weight: " . $ordinf['weight'] . " Gms<br/>";
                                                $body .= "Volume: " . $ordinf['volume'] . " Cbm<br/>";
                                                $body .= "Quantity: " . $ordinf['quantity'] . " <br/> <br/>";
                                            }
                                            $body .= "Thank You <br/>";
                                            $body .= "Svkonekt <br/>";
                                            $this->email->message($body);

                                            if(!$this->email->send()){
                                                log_error(
                                                    UNIQLO_LOG_PREFIX . "Swiftlogreturnorderedi - Uniqlo problem with sending email with subject: " .
                                                    $sub . ", message: " . $this->email->print_debugger()
                                                );
                                            }

                                            $this->email->clear(true);
                                        }
                                    }
                                }
                            } else {
                                $sub2 = "eTN: Return Order file not contains proper data";
                                $this->email->from(SVKONEKT_EMAIL, 'svkonekt');
                                $this->email->to(UNIQLO_ORDER_MAILS);
                                $this->email->subject($sub2);
                                $this->email->set_mailtype("html");
                                $body = "Dear Team, <br/>";
                                $body .= $sub2 . " <br/>";
                                $body .= "Assign Status: <br/>";
                                $body .= $succmsg . "<br/>";
                                $body .= "Details: <br/>";
                                $body .= "File Name: " . $actualfile . "<br/><br/>";
                                $body .= "Thank You <br/>";
                                $body .= "Svkonekt <br/>";
                                $this->email->message($body);

                                if(!$this->email->send()) {
                                    log_error(
                                        UNIQLO_LOG_PREFIX . "Swiftlogreturnorderedi - Uniqlo problem with sending email with subject: " .
                                        $sub2 . ", message: " . $this->email->print_debugger()
                                    );
                                }

                                $this->email->clear(true);
                            }
                        } else {
                            $statusmsg = "Failed";
                        }
                        if (!empty($ordresponse)) {
                            if (isset($ordresponse[0]['order_id'])) {
                                if ($ordresponse[0]['order_id'] > 0) {
                                    /*update edi log*/
                                    $logordid = $ordresponse[0]['order_id'];
                                    $loguserid = isset($ordresponse[0]['user_id']) ? $ordresponse[0]['user_id'] : "244";
                                    $logcmpcode = isset($ordresponse[0]['company_code']) ? $ordresponse[0]['company_code'] : "INKN";
                                    $logbrnchcode = isset($ordresponse[0]['branch_code']) ? $ordresponse[0]['branch_code'] : "INCL";
                                    $set = array(
                                        "status" => 1,
                                        "txn_obj_id" => $logordid,
                                        "user_id" => $loguserid,
                                        'company_code' => $logcmpcode,
                                        'branch_code' => $logbrnchcode,
                                        "edi_response" => "Return Order created successfully"
                                    );
                                    $statusmsg = "Success";
                                } else {
                                    $set = array("edi_response" => "Return Order creation failed by Warehouse not found.");
                                    $statusmsg = "Warehouse not found";
                                }
                            } else {
                                $set = array("edi_response" => "Return Order creation failed by Warehouse not found.");
                                $statusmsg = "Warehouse not found";
                            }
                        } else {
                            $set = array("edi_response" => "Return Order creation failed by unformated or required files not exists.");
                            $statusmsg = "Failed for unformatted request,Please try again!";
                        }
                        $whr = array("id" => $edilogid);
                        $upd = $this->common->updatetbledata("tb_etn_edi_transactions", $set, $whr);
                        $this->scheduledJobService->log("swiftlogreturnorderedi","Orders created successfully with EDILog Id: ".$edilogid);
                    }
                }
            }
        }
        $this->scheduledJobService->finishJob(true);
        unset($sftp);
        echo $statusmsg;
    }

    /* check docket number */
    public function checkdocketnum($ord)
    {
        $resp = 0;
        $ordid = $ord['existsord'];
        $whr = array("order_id" => $ordid, "reference_id" => "AWB", "ref_value <>" => "", "status" => 1);
        $chkref = $this->common->gettblrowdata($whr, "ref_value", "tb_order_references", 0, 0);
        if (count($chkref) > 0) {
            $resp = $chkref['ref_value'];
        }

        log_error(UNIQLO_LOG_PREFIX . "Swiftlogreturnorderedi checkdocketnum AWB exists for order: " . $ordid. ", AWB:" . $resp);

        return $resp;
    }

    /*check and create client warehouse for delhivery carrier*/
    public function getwarehousebycode($warehouse)
    {
        $response = [];
        $wh = $this->common->gettblrowdata(
            ["code" => $warehouse, "status" => 1],
            "id,party_type_id,name,mobile,code,location_id,address,country,state,street,pincode,street_2,street_3",
            "tbl_party_master",
            0,
            0
        );
        if (count($wh) > 0) {
            $response['company_name'] = $wh['name'];
            $response['warehouse'] = $wh['code'];
            $response['contact'] = $wh['mobile'];
            $response['city'] = $wh['location_id'];
            $response['address'] = $wh['address'];
            $response['country'] = $wh['country'];
            $response['state'] = $wh['state'];
            $response['street'] = $wh['street'];
            $response['pincode'] = $wh['pincode'];
            $response['street_2'] = $wh['street_2'];
            $response['party_id'] = $wh['id'];
            $response['party_type_id'] = $wh['party_type_id'];
        } else {
            $uid = 244;
            $curdt = date("Y-m-d H:i:s");
            $cinsdata = array(
                'party_type_id' => 969,
                'name' => "KN JKS LOGISTICS PARK WH2",
                'email' => 'info@svkonekt.com',
                'mobile' => '9871605533',
                'location_id' => 'GURGAON',
                'address' => 'KUEHNE + NAGEL, JKS LOGISTICS PARK, WH2',
                'pincode' => '122413',
                'code' => $warehouse,
                'country' => 'INDIA',
                'state' => 'HARYANA',
                'user_id' => $uid,
                'customeridentifier' => $warehouse,
                'partyindetifier' => '8888',
                'company_code' => 'INKN',
                'branch_code' => 'INCL',
                'status' => 1,
                'created_on' => $curdt,
                'updated_on' => $curdt
            );

            $custid = $this->common->insertTableData('tbl_party_master', $cinsdata);
            $response['company_name'] = $wh['name'];
            $response['warehouse'] = $warehouse;
            $response['contact'] = $warehouse;
            $response['city'] = 'GURGAON';
            $response['address'] = 'KUEHNE + NAGEL, JKS LOGISTICS PARK, WH2';
            $response['country'] = 'INDIA';
            $response['state'] = 'HARYANA';
            $response['street'] = 'KUEHNE + NAGEL, JKS LOGISTICS PARK, WH2';
            $response['pincode'] = '122413';
            $response['street_2'] = 'KUEHNE + NAGEL, JKS LOGISTICS PARK, WH2';
            $response['party_id'] = $custid;
            $response['party_type_id'] = 969;
        }

        log_error(
            UNIQLO_LOG_PREFIX . "swiftlogreturnorderedi order warehouse data in getwarehousebycode(): " .
            implode(', ', $response)
        );

        return $response;
    }

    /*Store xml shipment data into Orders tables*/
    public function insertShipmentData($data)
    {
        log_error(
            UNIQLO_LOG_PREFIX . "Swiftlogreturnorderedi insertShipmentData inbound data: " . json_encode($data)
        );

        $curtz = date_default_timezone_set('UTC');
        $curdt = date('Y-m-d H:i:s');
        $responseord = $multiord = array();
        $transmode = "LTL";
        $dedicateveh = 0;
        $uniqId = uniqid();
        $user_id = 1;
        foreach ($data['Head'] as $hdata) {
            $countrycode = 'IN';
            $countryname = 'India';
            $warehouse = $this->getwarehousebycode($hdata['shipment_ec_warehouse_code']);
            if (!empty($warehouse)) {
                $ord_id = 0;
                $checkexists = 0;
                $company_code = $shipdata['sendercmpcode'] = $countrycode . "SVK";
                $branch_code = "INCL";
                $shipdata['senderbranchcode'] = $warehouse['warehouse'];
                $whr = array('company_code' => $company_code, 'branch_code' => $branch_code, 'status' => 'Active');
                $chkusr = $this->common->gettblrowdata($whr, "id", "tb_users", 0, 0);
                if (count($chkusr) > 0) {
                    $user_id = $chkusr['id'];
                } else {
                    $whr = array('company_code' => $company_code, 'branch_code' => $branch_code, 'status' => 1);
                    $chkusr = $this->common->gettblrowdata($whr, "user_id", "tb_user_companies", 0, 0);
                    if (count($chkusr) > 0) {
                        $user_id = $chkusr['id'];
                    } else {
                        $adminrand = "eTN" . $company_code;
                        $adminpwd = password_hash($adminrand, PASSWORD_DEFAULT);
                        $udata = array(
                            'country_code' => $countrycode,
                            'name' => $countrycode . "_Admin",
                            'company_indv_name' => $company_code,
                            'business_type' => 'Truck_Owner',
                            'mobile_no' => $adminrand,
                            'password' => $adminpwd,
                            'emailid' => 'info@svkonekt.com',
                            'domain_name' => $branch_code,
                            'location_id' => 1646,
                            'createdby' => 1,
                            'status' => 'Active',
                            'createdon' => $curdt,
                            'company_code' => $company_code,
                            'branch_code' => $branch_code,
                            "lat" => '28.6862738',
                            "lng" => '77.2217831'
                        );
                        $user_id = $this->common->insertTableData('tb_users', $udata);
                    }
                }
                $shipdata['ship_id'] = $hdata['order_no'];
                $shipdata['sourcedate'] = $shipdata['destinationdate'] = $curdt;
                $shipdata['pickcount'] = $shipdata['dropcount'] = 1;
                $shipdata['product'] = "";
                if ($shipdata['product'] == "") {
                    $shipdata['product'] = "BOX";
                }
                $shipdata['handlingunit'] = substr($shipdata['product'], 0, 29);
                $shipdata['cargo_content'] = $shipdata['product'];
                $shipdata['freight_term'] = 60;
                $shipdata['freight_termname'] = 'Free of Charge';
                $shipdata['incoterm'] = '';
                $shipdata['sendertransmode'] = 2;
                $carrier_id = 0;
                $shipdatains = array(
                    'shipid' => $shipdata['ship_id'],
                    'txnid' => $hdata['shipment_id'],
                    'trucktype' => $transmode,
                    'product' => $shipdata['product'],
                    'pickupcnt' => $shipdata['pickcount'],
                    'dropcnt' => $shipdata['dropcount'],
                    'unitspec' => $shipdata['cargo_content'],
                    'insertusr' => "",
                    'carrier' => $carrier_id,
                    'insertuserdate' => $shipdata['sourcedate'],
                    'enddate' => $shipdata['destinationdate'],
                    'insdate' => $shipdata['sourcedate'],
                    'upddate' => $shipdata['destinationdate'],
                    'reason' => 'SHIPMENT',
                    'purpose' => 'SEND INTEGRATION',
                    'ship_object' => 'SHIPMENT',
                    'logdate' => $curdt,
                    'status' => 1,
                    'createdon' => $curdt,
                    'transport_mode' => $transmode,
                    'txncode' => $hdata['returning_item_no'],
                    'domainname' => $branch_code,
                    'company_code' => $shipdata['sendercmpcode'],
                    'branch_code' => $branch_code,
                    'freight_term' => $shipdata['freight_term'],
                    'freight_termname' => $shipdata['freight_termname'],
                    'incoterm' => $shipdata['incoterm'],
                    'logicalreceiver' => $branch_code,
                    'physicalreceiver' => $branch_code,
                    'physicalsender' => $shipdata['senderbranchcode'],
                    'logicalsender' => $shipdata['senderbranchcode'],
                    'modeoftransport' => $shipdata['sendertransmode']
                );

                $sship_id = $this->common->insertTableData('tb_shipments', $shipdatains);
                $pickup_datetime = $pickup_endtime = $delivery_datetime = $drop_endtime = $pickup_company = "";
                $starttime = $endtime = $pickup_company = $drop_company = "";
                $starttime = $curdt;
                $pickup_datetime = $curdt;
                $pickup_endtime = $curdt;
                $pickup_company = removeSpecialCharacters($hdata['pickup_customer_name'], "name");
                $pickup_address = removeSpecialCharacters($hdata['pickup_address_1'], "address");
                $pickup_address1 = $pickup_address2 = "";
                $pickup_city = $pickup_state = "";
                $chkdblspace = strrpos($hdata['pickup_address_1'], "  ");
                if ($chkdblspace) {
                    $citystate = explode("  ", $hdata['pickup_address_1']);
                    if (count($citystate) > 1) {
                        $pickup_state = trim($citystate[0]); /*state*/
                        $pickup_city = trim($citystate[1]); /*city*/
                    }
                } else {
                    $citystate = explode(", ", $hdata['pickup_address_1']);
                    $pickup_city = $citystate[0];
                    $pickup_state = isset($citystate[1]) ? $citystate[1] : "";
                }
                $pickup_city = removeSpecialCharacters($pickup_city, "name");
                $pickup_state = removeSpecialCharacters($pickup_state, "name");
                if ($hdata['pickup_address_2'] != "") {
                    $pickup_address1 = $hdata['pickup_address_2'];
                    $pickup_address1 = removeSpecialCharacters($hdata['pickup_address_2'], "address");
                } else {
                    $pickup_address1 = $pickup_address;
                }
                if ($hdata['pickup_address_3'] != "") {
                    $pickup_address2 = $hdata['pickup_address_3'] . ", " . $pickup_city . ", " . $pickup_state;
                } else {
                    $pickup_address2 = $hdata['pickup_address_2'] . ", " . $pickup_city . ", " . $pickup_state;
                }
                $pickup_address2 = removeSpecialCharacters($pickup_address2, "address");
                $pickup_countrycode = $countryname;
                $pickup_postal = $hdata['pickup_postal_code'];
                $pickup_vat = "";
                $pickup_custid = $hdata['pickup_mobile_no'];
                $pickup_partyid = $hdata['pickup_phone_number'];
                $shipper = removeSpecialCharacters($hdata['pickup_customer_name'], "name");
                $shipdata['shipper'] = array(
                    'name' => $shipper,
                    'street' => $pickup_address,
                    'city' => $pickup_city,
                    'country' => $pickup_countrycode,
                    'zip' => $pickup_postal,
                    'custid' => $pickup_custid,
                    'partyid' => $pickup_partyid,
                    'state' => $pickup_state,
                    'street_2' => $pickup_address1,
                    'street_3' => $pickup_address2,
                    'email' => $hdata['email_id'],
                    'fax' => "",
                    "vat" => $pickup_vat
                );
                $shipdata['delivery_start'] = $shipdata['delivery_end'] = $hdata['returned_date'];
                if ($shipdata['delivery_start'] == "") {
                    $shipdata['delivery_start'] = $curdt;
                }
                if ($shipdata['delivery_end'] == "") {
                    $shipdata['delivery_end'] = $curdt;
                }
                if ($warehouse['company_name'] == "") {
                    $warehouse['company_name'] = "KN JKS LOGISTICS PARK WH2";
                }
                $endtime = $hdata['returned_date'];
                $delivery_datetime = date('Y-m-d H:i:s', strtotime($shipdata['delivery_start']));
                $drop_endtime = date('Y-m-d H:i:s', strtotime($hdata['returned_date']));
                $drop_company = $consignee = removeSpecialCharacters($warehouse['company_name'], "name");
                $drop_address = removeSpecialCharacters($warehouse['address'], "address");
                if ($warehouse['street'] == "") {
                    $warehouse['street'] = $drop_address;
                }
                if ($warehouse['street_2'] == "") {
                    $warehouse['street_2'] = $drop_address;
                }
                if ($warehouse['street'] == $warehouse['street_2']) {
                    $drop_address1 = $warehouse['street'];
                } else {
                    if (strpos($warehouse['street'], $warehouse['street_2']) !== false) {
                        $drop_address1 = $warehouse['street'];
                    } else {
                        $drop_address1 = $warehouse['street'] . ", " . $warehouse['street_2'];
                        $drop_address1 = substr($drop_address1, 0, 190);
                    }
                }
                $drop_address1 = removeSpecialCharacters($drop_address1, "address");
                $drop_address2 = substr($warehouse['street_2'], 0, 190);
                $drop_address2 = removeSpecialCharacters($drop_address2, "address");
                $drop_city = removeSpecialCharacters($warehouse['city'], "name");
                $drop_countrycode = $warehouse['country'];
                $drop_postal = $warehouse['pincode'];
                $drop_state = removeSpecialCharacters($warehouse['state'], "name");
                $drop_vat = "";
                $drop_custid = $warehouse['contact'];
                $drop_partyid = $warehouse['warehouse'];
                $shipdata['consignee'] = [
                    'name' => $consignee,
                    'street' => $drop_address,
                    'city' => $drop_city,
                    'country' => $drop_countrycode,
                    'zip' => $drop_postal,
                    'custid' => $drop_custid,
                    'partyid' => $drop_partyid,
                    'state' => $drop_state,
                    'street_2' => $drop_address1,
                    'street_3' => $drop_address2,
                    'email' => "",
                    'fax' => "",
                    "vat" => $drop_vat
                ];
                $customer_id = 0;
                $cn_partytype = 3;
                $sh_partytype = 1;
                $pf_partytype = 1;
                $customer = $this->checkcustomer(
                    $shipdata['shipper'],
                    $shipdata['sendercmpcode'],
                    $branch_code,
                    $user_id,
                    "PF"
                );
                if ($customer['id'] > 0) {
                    $customer_id = $customer['id'];
                }
                if (isset($customer['party_id'])) {
                    $cust_id = $customer['party_id'];
                    $pf_partytype = $customer['party_type'];
                }
                if ($customer_id == 0) {
                    $whr = array('user_id' => $user_id, 'company_code' => $company_code, 'branch_code' => $branch_code);
                    $branchwisecust = $this->common->gettblrowdata($whr, "id", "tb_customers", 0, 0);
                    if (count($branchwisecust) > 0) {
                        $customer_id = $branchwisecust['id'];
                    } else {
                        $randnum = mt_rand();
                        $pwd = password_hash($randnum, PASSWORD_DEFAULT);
                        $cinsdata = [
                            'name' => $company_code . "_Customer",
                            'phone' => $randnum,
                            'location' => $countrycode,
                            'address' => $countrycode,
                            'pincode' => $countrycode,
                            'code' => $randnum,
                            'country' => $countrycode,
                            'password' => $pwd,
                            'user_id' => $user_id,
                            'company_code' => $company_code,
                            'branch_code' => $branch_code,
                            'status' => 1,
                            'createdon' => $curdt,
                            'updatedon' => $curdt
                        ];

                        $customer_id = $this->common->insertTableData('tb_customers', $cinsdata);
                    }
                }
                $consignee = $this->checkconsignee(
                    $shipdata['consignee'],
                    $shipdata['sendercmpcode'],
                    $branch_code,
                    $user_id,
                    "CN"
                );
                if (isset($consignee['party_id'])) {
                    $consignee_id = $consignee['party_id'];
                    $cn_partytype = $consignee['party_type'];
                } else {
                    $consignee_id = $warehouse['party_id'];
                    $cn_partytype = $warehouse['party_type_id'];
                }
                $shipper = $this->checkshipper(
                    $shipdata['shipper'],
                    $shipdata['sendercmpcode'],
                    $branch_code,
                    $user_id,
                    "SH"
                );
                if (isset($shipper['party_id'])) {
                    $shipper_id = $shipper['party_id'];
                    $sh_partytype = $shipper['party_type'];
                }
                $shiptxnid = trim($hdata['shipment_id']);
                $quantity = 1;
                $weight = $gross_weight = 1;
                $shipdata['pkgs_count'] = $goods_value = 1;
                $shipdata['gross_weight'] = 1;
                $shipdata['volume'] = 0;
                $soorderid = $sovendorid = 0; /* so order data from return order DQ*/
                if ($pickup_company != "" && $drop_company != "") {
                    $startlat = $startlong = $endlat = $endlong = "";
                    $sloc = $pickup_address . ", " . $pickup_city . ", " . $pickup_countrycode . ", " . $pickup_postal;
                    $eloc = $drop_address . ", " . $drop_city . ", " . $drop_countrycode . ", " . $drop_postal;
                    $cheklatlng = $this->getlatlongbylocname($sloc);
                    if (!empty($cheklatlng)) {
                        $startlat = $cheklatlng['latitude'];
                        $startlong = $cheklatlng['longitude'];
                    }
                    $cheklatlng1 = $this->getlatlongbylocname($eloc);
                    if (!empty($cheklatlng1)) {
                        $endlat = $cheklatlng1['latitude'];
                        $endlong = $cheklatlng1['longitude'];
                    }
                    /*check order exists with PO number*/
                    if (!empty($hdata['returning_item_no'])) {
                        $chkdt = array('reference_id' => "DQ", 'ref_value' => $hdata['returning_item_no']);
                        $chkoref = $this->common->gettblrowdata($chkdt, "order_id", "tb_order_references", 0, 0);
                        if (count($chkoref) > 0) {
                            $checkexists = $chkoref['order_id'];
                        }
                    }
                    /*check forward order exists with PO number for weight and goods value*/
                    if (!empty($hdata['shipment_id'])) {
                        $ordshipmentid = trim($hdata['shipment_id']);
                        $chkpo = array('reference_id' => "PO", 'ref_value' => $ordshipmentid, "status" => 1);
                        $chkpoqry = $this->common->gettblrowdata($chkpo, "order_id", "tb_order_references", 0, 0);
                        if (count($chkpoqry) > 0) {
                            $chkord = array('id' => $chkpoqry['order_id'], 'created_source' => '15');
                            $chkordqry = $this->common->gettblrowdata(
                                $chkord,
                                "id,vendor_id,quantity,weight,goods_value",
                                "tb_orders",
                                0,
                                0
                            );
                            if (count($chkordqry) > 0) {
                                $gross_weight = $chkordqry['weight'];
                                $goods_value = $chkordqry['goods_value'];
                                $quantity = $chkordqry['quantity'];
                                $soorderid = $chkordqry['id'];
                                $sovendorid = $chkordqry['vendor_id'];
                            }
                        }
                    }
                    if ($checkexists == 0) {
                        $orddata = [
                            'order_id' => $hdata['order_no'],
                            'pickup_datetime' => $pickup_datetime,
                            'pickup_endtime' => $pickup_endtime,
                            'delivery_datetime' => $delivery_datetime,
                            'drop_endtime' => $drop_endtime,
                            'pickup_company' => $pickup_company,
                            'delivery_company' => $drop_company,
                            'pickup_country' => $pickup_countrycode,
                            'delivery_country' => $drop_countrycode,
                            'pickup_city' => $pickup_city,
                            'delivery_city' => $drop_city,
                            'pickup_pincode' => $pickup_postal,
                            'delivery_pincode' => $drop_postal,
                            'pickup_address1' => $pickup_address1,
                            'delivery_address1' => $drop_address,
                            'pickup_address2' => $pickup_address2,
                            'delivery_address2' => $drop_address1,
                            'quantity' => $shipdata['pkgs_count'],
                            'weight' => $weight,
                            'volume' => $shipdata['volume'],
                            'goods_value' => $goods_value,
                            'transport_mode' => $transmode,
                            'dedicated_vehicle' => $dedicateveh,
                            'vehicle_type' => $transmode,
                            'user_id' => $user_id,
                            'customer_id' => $customer_id,
                            'vendor_id' => $carrier_id,
                            'customer_name' => $shipdata['consignee']['name'],
                            'customer_code' => $shipdata['consignee']['custid'],
                            'customer_area' => substr($drop_address1, 0, 95),
                            'customer_phone' => $shipdata['consignee']['custid'],
                            'customer_email' => "",
                            'customer_comments' => "",
                            'vendor_name' => $shipdata['shipper']['name'],
                            'vendor_code' => $shipdata['shipper']['custid'],
                            'vendor_area' => substr($pickup_address2, 0, 95),
                            'vendor_phone' => $shipdata['shipper']['custid'],
                            'plat' => $startlat,
                            'plng' => $startlong,
                            'dlat' => $endlat,
                            'dlng' => $endlong,
                            'company_code' => $shipdata['sendercmpcode'],
                            'branch_code' => $branch_code,
                            'product' => $shipdata['product'],
                            'shipment_id' => $sship_id,
                            'pickup_custid' => $pickup_custid,
                            'pickup_partyid' => $pickup_partyid,
                            'drop_custid' => $drop_custid,
                            'drop_partyid' => $drop_partyid,
                            'status' => 1,
                            'createdon' => $curdt,
                            'updatedon' => $curdt,
                            "created_source" => 16,
                            'shipmentid' => $shiptxnid,
                            'logicalreceiver' => $branch_code,
                            'physicalreceiver' => $branch_code,
                            'physicalsender' => $shipdata['senderbranchcode'],
                            'logicalsender' => $shipdata['senderbranchcode'],
                            'modeoftransport' => $shipdata['sendertransmode'],
                            'uniqid_of_package' => $uniqId
                        ];

                        $ord_id = $this->common->insertTableData('tb_orders', $orddata);
                        $this->scheduledJobService->log("swiftlogreturnorderedi","Inserted data in a tb_orders in insertShipmentData(): ".$ord_id);
                    } else {
                        $orddata = [
                            'pickup_datetime' => $pickup_datetime,
                            'pickup_endtime' => $pickup_endtime,
                            'delivery_datetime' => $delivery_datetime,
                            'drop_endtime' => $drop_endtime,
                            'pickup_company' => $pickup_company,
                            'delivery_company' => $drop_company,
                            'pickup_country' => $pickup_countrycode,
                            'delivery_country' => $drop_countrycode,
                            'pickup_city' => $pickup_city,
                            'delivery_city' => $drop_city,
                            'pickup_pincode' => $pickup_postal,
                            'delivery_pincode' => $drop_postal,
                            'pickup_address1' => $pickup_address1,
                            'delivery_address1' => $drop_address,
                            'pickup_address2' => $pickup_address2,
                            'delivery_address2' => $drop_address1,
                            'quantity' => $shipdata['pkgs_count'],
                            'weight' => $weight,
                            'volume' => $shipdata['volume'],
                            'goods_value' => $goods_value,
                            'transport_mode' => $transmode,
                            'dedicated_vehicle' => $dedicateveh,
                            'vehicle_type' => $transmode,
                            'user_id' => $user_id,
                            'customer_id' => $customer_id,
                            'customer_name' => $shipdata['consignee']['name'],
                            'customer_code' => $shipdata['consignee']['custid'],
                            'customer_area' => substr($drop_address1, 0, 95),
                            'customer_phone' => $shipdata['consignee']['custid'],
                            'customer_email' => "",
                            'customer_comments' => "",
                            'vendor_name' => $shipdata['shipper']['name'],
                            'vendor_code' => $shipdata['shipper']['custid'],
                            'vendor_area' => substr($pickup_address2, 0, 95),
                            'vendor_phone' => $shipdata['shipper']['custid'],
                            'plat' => $startlat,
                            'plng' => $startlong,
                            'dlat' => $endlat,
                            'dlng' => $endlong,
                            'company_code' => $shipdata['sendercmpcode'],
                            'branch_code' => $branch_code,
                            'product' => $shipdata['product'],
                            'shipment_id' => $sship_id,
                            'pickup_custid' => $pickup_custid,
                            'pickup_partyid' => $pickup_partyid,
                            'drop_custid' => $drop_custid,
                            'drop_partyid' => $drop_partyid,
                            'createdon' => $curdt,
                            'updatedon' => $curdt,
                            "created_source" => 16,
                            'shipmentid' => $shiptxnid,
                            'logicalreceiver' => $branch_code,
                            'physicalreceiver' => $branch_code,
                            'physicalsender' => $shipdata['senderbranchcode'],
                            'logicalsender' => $shipdata['senderbranchcode'],
                            'modeoftransport' => $shipdata['sendertransmode'],
                            'uniqid_of_package' => $uniqId
                        ];
                        $ord_id = $checkexists;
                        $upwhr = [
                            "id" => $ord_id
                        ];

                        $this->scheduledJobService->log("swiftlogreturnorderedi","Updated data in a tb_orders in insertShipmentData(): ".$ord_id);

                        $this->common->updatetbledata('tb_orders', $orddata, $upwhr);
                    }
                } else {
                    /*send mail if not mandatory fileds exists*/
                    $this->load->library('email');
                    $sub = "eTN: " . $hdata['order_no'] . " Return Order manadatory fields are empty";
                    $this->email->from(SVKONEKT_EMAIL, 'svkonekt');
                    $this->email->to(UNIQLO_ORDER_MAILS);
                    $this->email->subject($sub);
                    $this->email->set_mailtype("html");
                    $body = "Dear Team, <br/>";
                    $body .= $sub . " <br/>";
                    $body .= "Please check once and upload again in MFT. <br/><br/><br/><br/>";
                    $body .= "Thank You <br/>";
                    $body .= "Svkonekt <br/>";
                    $this->email->message($body);

                    if(!$this->email->send()) {
                        log_error(
                            UNIQLO_LOG_PREFIX . "Swiftlogreturnorderedi Uniqlo problem with sending email with subject: " .
                            $sub . ", message: " . $this->email->print_debugger()
                        );
                    }

                    $this->email->clear(true);
                }
                if ($ord_id > 0) {
                    $genord = [
                        "user_id" => $user_id,
                        "order_id" => $ord_id,
                        "country_code" => $countrycode,
                        "company_code" => $company_code
                    ];
                    $booking_id = $ord_id;
                    if ($checkexists == 0) {
                        $booking_id = generatebookingid($genord);
                    } else {
                        $getordid = $this->common->gettblrowdata(array('id' => $ord_id), "order_id", "tb_orders", 0, 0);
                        if (count($getordid) > 0) {
                            $booking_id = $getordid['order_id'];
                        }
                    }
                    $orddata['order_id'] = $booking_id;
                    $responseord = [
                        "order_id" => $ord_id,
                        "user_id" => $user_id,
                        "company_code" => $shipdata['sendercmpcode'],
                        "branch_code" => $branch_code,
                        'curtz' => $curtz,
                        'ordinfo' => $orddata,
                        "existsord" => $checkexists,
                        'soorderid' => $soorderid,
                        'sovendorid' => $sovendorid
                    ];
                    $shipdata['product'] = "";
                    $shipdata['pkgs_count'] = "";
                    if ($shipdata['product'] == "") {
                        $shipdata['product'] = "BOX";
                    }
                    $shipdata['handlingunit'] = $shipdata['product'];
                    $shipdata['cargo_content'] = $shipdata['product'];
                    $volume = 0;
                    $product = "";
                    if (!empty($hdata['shipment_id'])) {
                        $hdata['shipment_id'] = trim($hdata['shipment_id']);
                        $responseord['item_no'] = $hdata['shipment_id'];
                        $chkdt = array('order_id' => $ord_id, 'reference_id' => "XSR");
                        $chkref = $this->common->gettblrowdata($chkdt, "id", "tb_order_references", 0, 0);
                        if (count($chkref) == 0) {
                            $srefqry = [
                                'order_id' => $ord_id,
                                'reference_id' => "XSR",
                                'ref_value' => $hdata['shipment_id'],
                                'status' => 1,
                                'createdon' => $curdt
                            ];

                            $this->common->insertTableData('tb_order_references', $srefqry);
                        } else {
                            $whrref = array('id' => $chkref['id']);
                            $updref = array('ref_value' => $hdata['shipment_id'], 'status' => 1);

                            $this->common->updatetbledata('tb_order_references', $updref, $whrref);
                        }
                    }
                    if (!empty($hdata['order_no'])) {
                        $chkdt = array('order_id' => $ord_id, 'reference_id' => "PSI");
                        $chkref1 = $this->common->gettblrowdata($chkdt, "id", "tb_order_references", 0, 0);
                        if (count($chkref1) == 0) {
                            $srefqry = [
                                'order_id' => $ord_id,
                                'reference_id' => "PSI",
                                'ref_value' => $hdata['order_no'],
                                'status' => 1,
                                'createdon' => $curdt
                            ];

                            $this->common->insertTableData('tb_order_references', $srefqry);
                        } else {
                            $whrref = array('id' => $chkref1['id']);
                            $updref = array('ref_value' => $hdata['order_no'], 'status' => 1);

                            $this->common->updatetbledata('tb_order_references', $updref, $whrref);
                        }
                    }
                    if (!empty($hdata['returning_item_no'])) {
                        $responseord['item_no'] = $hdata['returning_item_no'];
                        $chkdt = array('order_id' => $ord_id, 'reference_id' => "DQ");
                        $chkref2 = $this->common->gettblrowdata($chkdt, "id", "tb_order_references", 0, 0);
                        if (count($chkref2) == 0) {
                            $srefqry = array(
                                'order_id' => $ord_id,
                                'reference_id' => "DQ",
                                'ref_value' => $hdata['returning_item_no'],
                                'status' => 1,
                                'createdon' => $curdt
                            );

                            $this->common->insertTableData('tb_order_references', $srefqry);
                        } else {
                            $whrref = array('id' => $chkref2['id']);
                            $updref = array('ref_value' => $hdata['returning_item_no'], 'status' => 1);

                            $this->common->updatetbledata('tb_order_references', $updref, $whrref);
                        }
                    }
                    if (isset($consignee_id)) {
                        $checkparty = $this->common->gettblrowdata(
                            array('order_id' => $ord_id, 'party_id' => $consignee_id, 'party_type' => $cn_partytype),
                            "id",
                            "tb_order_parties",
                            0,
                            0
                        );
                        if (count($checkparty) > 0) {
                            $partyarr = array(
                                'order_number' => $booking_id,
                                'party_id' => $consignee_id,
                                'party_type' => $cn_partytype,
                                'status' => 1
                            );
                            $partyid = $checkparty['id'];

                            $this->common->updatetbledata('tb_order_parties', $partyarr, array("id" => $partyid)
                            );
                        } else {
                            $partyarr = array(
                                'order_id' => $ord_id,
                                'order_number' => $booking_id,
                                'party_id' => $consignee_id,
                                'party_type' => $cn_partytype,
                                'status' => 1,
                                'createdon' => $curdt
                            );

                            $this->common->insertTableData("tb_order_parties", $partyarr);
                        }
                    }
                    if (isset($shipper_id)) {
                        $checkparty = $this->common->gettblrowdata(
                            array('order_id' => $ord_id, 'party_id' => $shipper_id, 'party_type' => $sh_partytype),
                            "id",
                            "tb_order_parties",
                            0,
                            0
                        );
                        if (count($checkparty) > 0) {
                            $partyarr = array(
                                'order_number' => $booking_id,
                                'party_id' => $shipper_id,
                                'party_type' => $sh_partytype,
                                'status' => 1
                            );
                            $partyid = $checkparty['id'];

                            $this->common->updatetbledata('tb_order_parties', $partyarr, array("id" => $partyid)
                            );
                        } else {
                            $partyarr = array(
                                'order_id' => $ord_id,
                                'order_number' => $booking_id,
                                'party_id' => $shipper_id,
                                'party_type' => $sh_partytype,
                                'status' => 1,
                                'createdon' => $curdt
                            );

                            $this->common->insertTableData("tb_order_parties", $partyarr);
                        }
                    }
                    if (isset($cust_id)) {
                        $checkparty = $this->common->gettblrowdata(
                            array('order_id' => $ord_id, 'party_id' => $cust_id, 'party_type' => $pf_partytype),
                            "id",
                            "tb_order_parties",
                            0,
                            0
                        );
                        if (count($checkparty) > 0) {
                            $partyarr = array(
                                'order_number' => $booking_id,
                                'party_id' => $cust_id,
                                'party_type' => $pf_partytype,
                                'status' => 1
                            );
                            $partyid = $checkparty['id'];

                            $this->common->updatetbledata('tb_order_parties', $partyarr, array("id" => $partyid)
                            );
                        } else {
                            $partyarr = array(
                                'order_id' => $ord_id,
                                'order_number' => $booking_id,
                                'party_id' => $cust_id,
                                'party_type' => $pf_partytype,
                                'status' => 1,
                                'createdon' => $curdt
                            );

                            $this->common->insertTableData("tb_order_parties", $partyarr);
                        }
                    }
                    $returnitemqty = $ordcargo_value = 0;
                    $this->scheduledJobService->log("swiftlogreturnorderedi","Number of cargos in CSV: ".count($data['Detail']));
                    foreach ($data['Detail'] as $shipdata) {
                        if ($hdata['returning_item_no'] == $shipdata['returning_item_no']) {
                            $shipdata['product'] = $shipdata['application_item_name'];
                            $shipdata['pkgs_count'] = $shipdata['returning_item_quantity'];
                            $reason = $shipdata['returning_item_reason'];
                            if ($shipdata['pkgs_count'] == "") {
                                $shipdata['pkgs_count'] = 1;
                            }
                            $returnitemqty += $shipdata['pkgs_count'];
                            $volume += $volume;
                            if ($shipdata['product'] == "") {
                                $shipdata['product'] = "BOX";
                            }
                            $shipdata['handlingunit'] = substr($shipdata['product'], 0, 29);
                            $shipdata['cargo_content'] = $shipdata['product'];
                            $product = $shipdata['product'];
                            $shipdata['volume'] = $volume;
                            /*cargo details*/
                            $shipmentlineitem = isset($shipdata['shipment_line_no']) ? $shipdata['shipment_line_no'] : 0;
                            if ($shipmentlineitem == "") {
                                $shipmentlineitem = 0;
                            }
                            $l2_item_code = isset($shipdata['l2_item_code']) ? $shipdata['l2_item_code'] : "";
                            $l3_item_code = isset($shipdata['l3_item_code']) ? $shipdata['l3_item_code'] : "";
                            $itemname = $shipdata['application_item_name'];
                            $color_code = $shipdata['application_color_code'];
                            $color_code_num = $shipdata['application_color_name'];
                            $size_code = $shipdata['application_size_code'];
                            $size_name = $shipdata['application_size_name'];
                            $pattern_length_code = $shipdata['application_pattern_length_code'];
                            $pattern_length_name = $shipdata['application_pattern_length_name'];
                            $dhsncode = $shipdata['hsn_code'];
                            /*check for unit price from forward order*/
                            $unit_price = 0;
                            if($soorderid > 0) {
                                $pricearr = [
                                    'qr_code' => $l3_item_code,
                                    'item_order_id' => $soorderid,
                                    'shipment_line_no' => $shipmentlineitem
                                ];
                                $unitpriceqry = $this->common->gettbldata(
                                    $pricearr,
                                    "weight,unit_price",
                                    "tb_inner_cargo",
                                    0,
                                    0
                                );
                                if (count($unitpriceqry) > 0) {
                                    foreach ($unitpriceqry as $upr) {
                                        $unit_price += ($shipdata['pkgs_count'] * $upr['unit_price']);
                                    }
                                }
                            }
                            $ordcargo_value += $unit_price;
                            $itemarr = [
                                'item_id' => $shipdata['cargo_content'],
                                'item_name' => $shipdata['cargo_content'],
                                'item_number' => $l3_item_code
                            ];
                            $chkcargoitm = $this->common->gettblrowdata($itemarr, "id", "tb_items", 0, 0);
                            if (count($chkcargoitm) == 0) {
                                $itemarr = [
                                    'item_id' => $shipdata['cargo_content'],
                                    'item_name' => $shipdata['cargo_content'],
                                    'length' => 0,
                                    'length_unit' => 'G',
                                    'width' => 0,
                                    'width_unit' => 'M',
                                    'height' => 0,
                                    'height_unit' => 'M',
                                    'weight' => 0,
                                    'weight_unit' => 'G',
                                    'volume' => 0,
                                    'volume_unit' => 'Cbm',
                                    'description' => $shipdata['cargo_content'],
                                    'item_number' => $l3_item_code,
                                    'hsn_code' => $dhsncode,
                                    'color_code' => $color_code,
                                    'color_code_name' => $color_code_num,
                                    'size_code' => $size_code,
                                    'size_code_name' => $size_name,
                                    'unit_price' => $unit_price,
                                    'status' => 1,
                                    'createdby' => $user_id,
                                    'createdon' => $curdt,
                                    'updatedon' => $curdt
                                ];

                                $item_id = $this->common->insertTableData('tb_items', $itemarr);
                            } else {
                                $item_id = $chkcargoitm['id'];
                            }
                            $chkarr = [
                                'cargo_type' => $shipdata['cargo_content'],
                                'item_id' => $item_id
                            ];
                            $cargo = [
                                'cargo_type' => $shipdata['cargo_content'],
                                'goods_description' => $shipdata['cargo_content'],
                                'quantity' => $shipdata['pkgs_count'],
                                'length' => 0,
                                'length_unit' => 'G',
                                'width' => 0,
                                'width_unit' => 'M',
                                'height' => 0,
                                'height_unit' => 'M',
                                'weight' => $weight,
                                'weight_unit' => 'gms',
                                'volume' => 0,
                                'volume_unit' => 'Cbm',
                                'stackable' => 0,
                                'createdby' => $user_id,
                                'item_id' => $item_id,
                                'createdon' => $curdt
                            ];
                            $chkcargo = $this->common->gettblrowdata($chkarr, "id", "tb_cargo_details", 0, 0);
                            if (count($chkcargo) == 0) {

                                $cargotbl_id = $this->common->insertTableData('tb_cargo_details', $cargo);
                            } else {
                                $cargotbl_id = $chkcargo['id'];
                            }
                            $returning_item_no = isset($shipdata['returning_item_no']) ? $shipdata['returning_item_no'] : "";
                            $cargodt = array(
                                'order_id' => $ord_id,
                                'cargo_id' => $cargotbl_id,
                                'weight' => $weight,
                                'volume' => $shipdata['volume'],
                                'quantity' => $shipdata['pkgs_count'],
                                'quantity_type' => $shipdata['handlingunit'],
                                'cargo_content' => $shipdata['cargo_content'],
                                'linebp_num1' => $l2_item_code,
                                'qr_code' => $l3_item_code,
                                'reference_order_num' => $returning_item_no
                            );
                            $chkcargo = $this->common->gettblrowdata($cargodt, "id", "tb_order_cargodetails", 0, 0);
                            if (count($chkcargo) == 0) {
                                $hunit = 1;
                                $chkhandlingunit = $this->common->gettblrowdata(
                                    array("user_id" => $user_id, "unit_name" => $shipdata['handlingunit']),
                                    "id",
                                    "tbl_shipunit_types",
                                    0,
                                    0
                                );
                                if (count($chkhandlingunit) > 0) {
                                    $hunit = $chkhandlingunit['id'];
                                } else {
                                    $hunitarr = array(
                                        "unit_name" => $shipdata['handlingunit'],
                                        "description" => $shipdata['handlingunit'],
                                        "user_id" => $user_id,
                                        "status" => 1,
                                        "created_at" => $curdt
                                    );

                                    $hunit = $this->common->insertTableData('tbl_shipunit_types', $hunitarr);
                                }
                                $cargodata = array(
                                    'order_id' => $ord_id,
                                    'cargo_id' => $cargotbl_id,
                                    'handling_unit' => $hunit,
                                    'length' => 0,
                                    'width' => 0,
                                    'height' => 0,
                                    'weight' => $weight,
                                    'volume' => $shipdata['volume'],
                                    'quantity' => $shipdata['pkgs_count'],
                                    'quantity_type' => $shipdata['handlingunit'],
                                    'cargo_content' => $shipdata['cargo_content'],
                                    'status' => 1,
                                    'linebp_num1' => $l2_item_code,
                                    'qr_code' => $l3_item_code,
                                    'reference_order_num' => $returning_item_no,
                                    'load_plan_connote' => $reason
                                );

                                log_error(
                                    UNIQLO_LOG_PREFIX . "Swiftlogreturnorderedi insertShipmentData inserted data in a tb_order_cargodetails: " .
                                    implode(', ', $cargodata)
                                );

                                $this->common->insertTableData('tb_order_cargodetails', $cargodata);
                                /*add inner cargo*/
                                $item_discount = $igst_rate = $sgst_rate = $cgst_rate = $igst_amt = $sgst_amt = $cgst_amt = 0.00;
                                if ($itemname != "" && $color_code != "" && $size_code != "") {
                                    $incargodt = array(
                                        'cargo_id' => $cargotbl_id,
                                        'qr_code' => $l3_item_code,
                                        'shipment_line_no' => $shipmentlineitem
                                    );
                                    $incargodt['item_order_id'] = ($soorderid > 0) ? $soorderid : $ord_id;
                                    $chkincargo = $this->common->gettblrowdata(
                                        $incargodt,
                                        "id",
                                        "tb_inner_cargo",
                                        0,
                                        0
                                    );
                                    if (count($chkincargo) == 0) {
                                        $innerarr = [
                                            "cargo_id" => $cargotbl_id,
                                            "cargo_type" => $itemname,
                                            "goods_description" => $itemname,
                                            "quantity" => $shipdata['pkgs_count'],
                                            "scanned_quantity" => 0,
                                            "length" => 0,
                                            "length_unit" => "G",
                                            "width" => 0,
                                            "width_unit" => "M",
                                            "height" => 0,
                                            "height_unit" => "M",
                                            "weight" => $weight,
                                            "weight_unit" => "gms",
                                            "volume" => 0,
                                            "volume_unit" => "Cbm",
                                            "stackable" => 0,
                                            "qr_code" => $l3_item_code,
                                            "status" => 1,
                                            "createdby" => $user_id,
                                            "createdon" => $curdt,
                                            "updatedon" => $curdt,
                                            "ref_order_num" => $returning_item_no,
                                            "color_code" => $color_code,
                                            "color_code_name" => $color_code_num,
                                            "size_code" => $size_code,
                                            "size_name" => $size_name,
                                            "pattern_length_code" => $pattern_length_code,
                                            "pattern_length_name" => $pattern_length_name,
                                            "unit_price" => $unit_price,
                                            "d_hsn_code" => $dhsncode,
                                            "item_discount" => $item_discount,
                                            "igst_rate" => $igst_rate,
                                            "sgst_rate" => $sgst_rate,
                                            "cgst_rate" => $cgst_rate,
                                            "igst_amount" => $igst_amt,
                                            "sgst_amount" => $sgst_amt,
                                            "cgst_amount" => $cgst_amt,
                                            "item_order_id" => $ord_id,
                                            "shipment_line_no" => $shipmentlineitem
                                        ];

                                        log_error(
                                            UNIQLO_LOG_PREFIX . "Swiftlogreturnorderedi insertShipmentData inserted data in a tb_inner_cargo: " .
                                            implode(', ', $innerarr)
                                        );

                                        $this->common->insertTableData('tb_inner_cargo', $innerarr);
                                    } else {
                                        $updinnerarr = array(
                                            'cargo_id' => $cargotbl_id,
                                            'cargo_type' => $itemname,
                                            'goods_description' => $itemname,
                                            'quantity' => $shipdata['pkgs_count'],
                                            'qr_code' => $l3_item_code,
                                            'status' => 1,
                                            'color_code' => $color_code,
                                            'color_code_name' => $color_code_num,
                                            'size_code' => $size_code,
                                            'size_name' => $size_name,
                                            'pattern_length_code' => $pattern_length_code,
                                            'pattern_length_name' => $pattern_length_name
                                        );
                                        $updinwhr = array("id" => $chkincargo['id']);

                                        log_error(
                                            UNIQLO_LOG_PREFIX . "Swiftlogreturnorderedi insertShipmentData updated data in a tb_inner_cargo: " .
                                            implode(', ', $updinnerarr)
                                        );

                                        $this->common->updatetbledata(
                                            'tb_inner_cargo',
                                            $updinnerarr,
                                            $updinwhr
                                        );
                                    }
                                }
                            }
                        }
                    }
                    /*update tb_shipments,tb_orders*/
                    $whr = array('id' => $sship_id);
                    $set = array('product' => $product, 'unitspec' => $product);

                    $this->common->updatetbledata("tb_shipments", $set, $whr);

                    $shipdata['order_id'] = $booking_id;
                    $department_code = "INGGN01";
                    $ord_num = $hdata['returning_item_no'];
                    if ($ord_num == "") {
                        $ord_num = $hdata['shipment_id'];
                    }
                    $responseord['ordinfo']['quantity'] = $returnitemqty;
                    $responseord['ordinfo']['product'] = $product;
                    $responseord['ordinfo']['volume'] = $volume;
                    $set = [
                        "order_id" => $booking_id,
                        "quantity" => $returnitemqty,
                        "volume" => $volume,
                        "goods_value" => $ordcargo_value,
                        "product" => $product
                    ];

                    log_error(
                        UNIQLO_LOG_PREFIX . "Swiftlogreturnorderedi insertShipmentData updated data in a tb_orders: " .
                        implode(', ', $set)
                    );

                    $this->common->updatetbledata("tb_orders", $set, array('id' => $ord_id));
                    $whr = array(
                        "type_name" => 'Return',
                        "company_code" => $company_code,
                        "branch_code" => $branch_code,
                        "ordtype_code" => 'Return'
                    );
                    $chk = $this->common->gettblrowdata($whr, "id", "tb_order_types", 0, 0);
                    if (count($chk) > 0) {
                        $order_type = $chk['id'];
                    } else {
                        $insarr = array(
                            'type_name' => 'Return',
                            'description' => 'Return Orders',
                            'company_code' => $company_code,
                            'branch_code' => $branch_code,
                            'department_code' => $department_code,
                            'customer_id' => 0,
                            'ordtype_code' => 'Return',
                            'status' => 1,
                            'createdon' => $curdt
                        );

                        $order_type = $this->common->insertTableData("tb_order_types", $insarr);
                    }
                    if ($checkexists == 0) {
                        $details_ins = array(
                            'order_row_id' => $ord_id,
                            'order_id' => $booking_id,
                            'order_status' => 'PENDING',
                            'distance' => '0',
                            'department_code' => $department_code,
                            'order_type' => $order_type,
                            'ord_num' => $ord_num,
                            'createdon' => $curdt
                        );

                        $this->common->insertTableData('tb_order_details', $details_ins);
                    } else {
                        $details_ins = array(
                            'order_row_id' => $ord_id,
                            'order_id' => $booking_id,
                            'distance' => '0',
                            'department_code' => $department_code,
                            'order_type' => $order_type,
                            'ord_num' => $ord_num
                        );

                        $this->common->updatetbledata(
                            'tb_order_details',
                            $details_ins,
                            array('order_row_id' => $ord_id)
                        );
                    }
                } else {
                    $responseord['order_id'] = 0;
                }
            }
            $multiord[] = $responseord;
        }

        log_error(
            UNIQLO_LOG_PREFIX . "Swiftlogreturnorderedi insertShipmentData outbound data: " .
            json_encode($multiord)
        );

        return $multiord;
    }

    /*Store customer infomarion*/
    public function checkcustomer($customer, $cmpcode, $branchcode, $uid, $custtype)
    {
        log_error(
            UNIQLO_LOG_PREFIX . "Swiftlogreturnorderedi checkcustomer data: " . json_encode($customer)
        );
        $cwhr1 = array("code" => $customer['custid']);
        $cselect = 'id,email_id';
        $curdt = date("Y-m-d H:i:s");

        $ctable = 'tb_customers';
        $chkcust = $this->common->gettblrowdata($cwhr1, $cselect, $ctable, 0, 0);
        if (count($chkcust) > 0) {
            $cust_id = $chkcust['id'];
            if ($customer['email'] == "") {
                $customer['email'] = $chkcust['email_id'];
            }
            $upddata = array(
                'email_id' => $customer['email'],
                'location' => $customer['city'],
                'address' => $customer['street'],
                'pincode' => $customer['zip'],
                'country' => $customer['country'],
                'user_id' => $uid,
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'status' => 1,
                'updatedon' => $curdt
            );

            $this->common->updatetbledata('tb_customers', $upddata, array("id" => $cust_id));
        } else {
            $randnum = $customer['custid'];
            $pwd = password_hash($randnum, PASSWORD_DEFAULT);
            $cinsdata = array(
                'name' => $customer['name'],
                'email_id' => $customer['email'],
                'phone' => $customer['custid'],
                'location' => $customer['city'],
                'address' => $customer['street'],
                'pincode' => $customer['zip'],
                'code' => $customer['custid'],
                'country' => $customer['country'],
                'password' => $pwd,
                'user_id' => $uid,
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'status' => 1,
                'createdon' => $curdt,
                'updatedon' => $curdt
            );

            $cust_id = $this->common->insertTableData('tb_customers', $cinsdata);
        }
        $party_type_id = 5;
        $chkpartytype = $this->common->gettblrowdata(
            array("name" => "Customer", "user_id" => $uid, 'company_code' => $cmpcode),
            "id",
            "tbl_party_types",
            0,
            0
        );
        if (count($chkpartytype) > 0) {
            $party_type_id = $chkpartytype['id'];
        }
        $cselect = "id";
        $chkcust = $this->common->gettblrowdata($cwhr1, $cselect, "tbl_party_master", 0, 0);
        if (count($chkcust) > 0) {
            $custid = $chkcust['id'];
            $upddata = array(
                'location_id' => $customer['city'],
                'address' => $customer['street'],
                'pincode' => $customer['zip'],
                'country' => $customer['country'],
                'user_id' => $uid,
                'customeridentifier' => $customer['custid'],
                'partyindetifier' => $customer['partyid'],
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'status' => 1,
                'updated_on' => $curdt
            );

            $this->common->updatetbledata('tbl_party_master', $upddata, array("id" => $custid));
        } else {

            $cinsdata = array(
                'party_type_id' => $party_type_id,
                'name' => $customer['name'],
                'email' => $customer['email'],
                'mobile' => $customer['custid'],
                'location_id' => $customer['city'],
                'address' => $customer['street'],
                'pincode' => $customer['zip'],
                'code' => $customer['custid'],
                'country' => $customer['country'],
                'user_id' => $uid,
                'customeridentifier' => $customer['custid'],
                'partyindetifier' => $customer['partyid'],
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'status' => 1,
                'created_on' => $curdt,
                'updated_on' => $curdt
            );

            $custid = $this->common->insertTableData('tbl_party_master', $cinsdata);
        }
        $res['id'] = $cust_id;
        $res['party_id'] = $custid;
        $res['party_type'] = $party_type_id;
        return $res;
    }

    /*Store consignee infomarion*/
    public function checkconsignee($customer, $cmpcode, $branchcode, $uid, $custtype)
    {
        log_error(
            UNIQLO_LOG_PREFIX . "Swiftlogreturnorderedi checkconsignee data: " . json_encode($customer)
        );

        $cwhr1 = array("code" => $customer['custid']);
        $cselect = 'id';
        $curdt = date("Y-m-d H:i:s");
        $cust_id = 0;
        $party_type_id = 3;
        $chkpartytype = $this->common->gettblrowdata(
            array("name" => "Consignee", "user_id" => $uid, 'company_code' => $cmpcode),
            "id",
            "tbl_party_types",
            0,
            0
        );
        if (count($chkpartytype) > 0) {
            $party_type_id = $chkpartytype['id'];
        }
        $chkcust = $this->common->gettblrowdata($cwhr1, $cselect, "tbl_party_master", 0, 0);
        if (count($chkcust) > 0) {
            $custid = $chkcust['id'];
            $upddata = array(
                'location_id' => $customer['city'],
                'address' => $customer['street'],
                'pincode' => $customer['zip'],
                'country' => $customer['country'],
                'user_id' => $uid,
                'customeridentifier' => $customer['custid'],
                'partyindetifier' => $customer['partyid'],
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'state' => $customer['state'],
                'street_2' => $customer['street_2'],
                'street_3' => $customer['street_3'],
                'email' => $customer['email'],
                'fax' => $customer['fax'],
                "vat_reg_no" => $customer['vat'],
                'status' => 1,
                'updated_on' => $curdt
            );
            if ($customer['name'] != "") {
                $upddata['name'] = $customer['name'];
            }

            $this->common->updatetbledata('tbl_party_master', $upddata, array("id" => $custid));
        } else {

            $cinsdata = array(
                'party_type_id' => $party_type_id,
                'name' => $customer['name'],
                'email' => 'info@svkonekt.com',
                'mobile' => $customer['custid'],
                'location_id' => $customer['city'],
                'address' => $customer['street'],
                'pincode' => $customer['zip'],
                'code' => $customer['custid'],
                'country' => $customer['country'],
                'user_id' => $uid,
                'customeridentifier' => $customer['custid'],
                'partyindetifier' => $customer['partyid'],
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'state' => $customer['state'],
                'street_2' => $customer['street_2'],
                'street_3' => $customer['street_3'],
                'email' => $customer['email'],
                'fax' => $customer['fax'],
                "vat_reg_no" => $customer['vat'],
                'status' => 1,
                'created_on' => $curdt,
                'updated_on' => $curdt
            );

            $custid = $this->common->insertTableData('tbl_party_master', $cinsdata);
        }
        $res['id'] = $cust_id;
        $res['party_id'] = $custid;
        $res['party_type'] = $party_type_id;
        return $res;
    }

    /*Store shipper infomarion*/
    public function checkshipper($customer, $cmpcode, $branchcode, $uid, $custtype)
    {
        log_error(
            UNIQLO_LOG_PREFIX . "Swiftlogreturnorderedi checkshipper data: " . json_encode($customer)
        );
        $cwhr1 = array("code" => $customer['custid']);
        $cselect = 'id';
        $curdt = date("Y-m-d H:i:s");
        $cust_id = 0;
        $party_type_id = 1;
        $chkpartytype = $this->common->gettblrowdata(
            array("name" => "Shipper", "user_id" => $uid, 'company_code' => $cmpcode),
            "id",
            "tbl_party_types",
            0,
            0
        );
        if (count($chkpartytype) > 0) {
            $party_type_id = $chkpartytype['id'];
        }
        $chkcust = $this->common->gettblrowdata($cwhr1, $cselect, "tbl_party_master", 0, 0);
        if (count($chkcust) > 0) {
            $custid = $chkcust['id'];
            $upddata = array(
                'location_id' => $customer['city'],
                'address' => $customer['street'],
                'pincode' => $customer['zip'],
                'country' => $customer['country'],
                'user_id' => $uid,
                'customeridentifier' => $customer['custid'],
                'partyindetifier' => $customer['partyid'],
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'state' => $customer['state'],
                'street_2' => $customer['street_2'],
                'street_3' => $customer['street_3'],
                'email' => $customer['email'],
                'fax' => $customer['fax'],
                "vat_reg_no" => $customer['vat'],
                'status' => 1,
                'updated_on' => $curdt
            );

            $this->common->updatetbledata('tbl_party_master', $upddata, array("id" => $custid));
        } else {
            $randnum = $customer['custid'];
            $pwd =password_hash($randnum, PASSWORD_DEFAULT);
            $cinsdata = array(
                'party_type_id' => $party_type_id,
                'name' => $customer['name'],
                'email' => 'info@svkonekt.com',
                'mobile' => $customer['custid'],
                'location_id' => $customer['city'],
                'address' => $customer['street'],
                'pincode' => $customer['zip'],
                'code' => $customer['custid'],
                'country' => $customer['country'],
                'user_id' => $uid,
                'customeridentifier' => $customer['custid'],
                'partyindetifier' => $customer['partyid'],
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'state' => $customer['state'],
                'street_2' => $customer['street_2'],
                'street_3' => $customer['street_3'],
                'email' => $customer['email'],
                'fax' => $customer['fax'],
                "vat_reg_no" => $customer['vat'],
                'status' => 1,
                'created_on' => $curdt,
                'updated_on' => $curdt
            );

            $custid = $this->common->insertTableData('tbl_party_master', $cinsdata);
        }
        $res['id'] = $cust_id;
        $res['party_id'] = $custid;
        $res['party_type'] = $party_type_id;
        return $res;
    }

    /*get lat and lng info from pickup/delivery addresses*/
    public function getlatlongbylocname($address)
    {
        $response = getlatlngsbyplace($address);
        return [
            'latitude' => $response[0],
            'longitude' => $response[1]
        ];
    }
}
