<?php if (!defined('BASEPATH')) { exit('No direct script access allowed'); }

class TipCappaReport extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if ($this->session->userdata('user_id') === NULL) {
			redirect('login');
		}
	}

	public function index() {
		$data = [];
		$this->newtemplate->dashboard('reports/tipcappa',$data);
	}

	public function ajaxListing(): void {
		$this->load->model(['DataArrayFormatter_model','DataQueryFormatter_model','Datatables_model']);
		$whereCondition = $post = [];
		$draw   	= $this->input->post('draw',TRUE);
		$start  	= $this->input->post('start',TRUE);
		$limit  	= $this->input->post('length',TRUE);
		$orderBy  	= $this->input->post('order',TRUE);
		$indexColumn = 'o.id';
		$post   = $this->input->post( 'data',TRUE );
		$custid = $status_search = $epodp_date = $pod_status_date = $status_date = $wherecondition="";
		$curtz = $this->session->userdata("usr_tzone")['timezone'];
		$userid = $this->session->userdata("user_id");
		if(!empty($this->session->userdata("cust_id"))) {
			$custid = $this->session->userdata("cust_id");
		}
		$aquorder = $where = $wherein =  $subcusts  = [];
		$business_type 	= $this->session->userdata('business_type');
		$companyCode   	= $this->session->userdata('company_code');
		$branchCode   	= $this->session->userdata('branch_code');
		$userRoleId   	= (int) $this->session->userdata('user_role_id');
		$id   			= (int) $this->session->userdata('id');
		$whereCondition = $this->searchFilter($post);
		if(!empty($custid)) {
			if($this->session->userdata('sub_cust') !== FALSE) {
				$subcusts = $this->session->userdata('sub_cust');
				if(!empty($subcusts)){
					array_push($subcusts, $custid);
				} else {
					$subcusts = [$custid];
				}
			} else {
				$subcusts = [$custid];
			}
		}
		$orderTableCondition=[];
		$bindings = [];
		$orderTableCondition[]='o.status != ? ';
		$bindings[] = 0;
		if (!empty($whereCondition)) {
			foreach ($whereCondition as $key=>$value) {
				if ($key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') <=") {
					$orderTableCondition[]= $key." ? ";
					$bindings[] = $value;
				} else {
					$orderTableCondition[]= $key." = ? ";
					$bindings[] = $value;
				}
			}
		}
		if (!empty($subcusts) && count($subcusts) > 0) {
			$bindings[] = $subcusts;
			$orderTableCondition[]=" o.customer_id IN ?";
		} else {
			if ($custid != "") {
				$bindings[] = $custid;
				$orderTableCondition[]=" o.customer_id = ? ";
			}
		}
		if (!empty($branchCode) && $userRoleId === 2) {
            $bindings[] = $branchCode;
            $orderTableCondition[] = " o.branch_code = ? ";
        }
        if ($userRoleId === 3) {
        	$bindings[] = $id;
            $orderTableCondition[] = " o.vendor_id = ? ";
        }

		$orderTableWhere = implode(' AND ',$orderTableCondition);
		if ($orderTableWhere!='') {
			$orderTableWhere=" AND $orderTableWhere ";
		}

		$orderByCondition='';
		if (isset($orderBy[0])) {
			if ($orderBy[0]!='') {
				$ordColIndex= $orderBy[0]['column'];
				$ordColDir= $orderBy[0]['dir'];
				if ($ordColDir=='') {
					$ordColDir = 'asc';
				}
				if (isset($dataTableSortOrdering[$ordColIndex]) && $dataTableSortOrdering[$ordColIndex]!='' ) {
					$orderByCondition='  '.$dataTableSortOrdering[$ordColIndex].' '.$ordColDir.' ';
				}
			}
		}
		$compiledCount=0;
		$resultSet=$this->db->query("SELECT count(o.id) as count
			FROM tb_orders o
			LEFT JOIN tb_order_details d ON o.id = d.order_row_id
			WHERE 1 $orderTableWhere
			", $bindings);
		if ($resultSet->num_rows()>0) {
			$resdata = $resultSet->result_array();
			if (isset($resdata[0]['count'])) {
				$compiledCount=$resdata[0]['count'];
			}
		}
		$currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
		$selectColumns = ["
			o.id,
			o.order_id,
			convertToClientTZ(o.pickup_datetime,
			'{$currentTimeZone}') as early_pickup_datetime,
			convertToClientTZ(o.delivery_datetime,
			'{$currentTimeZone}') as early_delivery_datetime,
			o.pickup_address1,
			o.delivery_address1,
			o.shipmentid,
			o.pickup_company,
			o.delivery_company,
			o.status,
			o.createdon,
			o.shift_id,
			o.quantity,
			o.weight,
			o.volume,
			(SELECT quantity_type FROM tb_order_cargodetails WHERE order_id = o.id AND `status` = 1 LIMIT 1) AS quantity_type,
			ct.name as customer_name,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='0212' ORDER BY `tss`.`id` DESC LIMIT 1) AS `accepted_by_driver`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='0500' ORDER BY `tss`.`id` DESC LIMIT 1) AS `pickedup_datetime`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='2300' ORDER BY `tss`.`id` DESC LIMIT 1) AS `delivered_datetime`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='3000' ORDER BY `tss`.`id` DESC LIMIT 1) AS `completed_datetime`,
			CASE WHEN (SELECT COUNT(`tpu`.`id`) AS `is_pod` FROM `tb_pod_uploads` `tpu` WHERE `o`.`id`=`tpu`.`order_id` AND `doc_type`=3 AND `status`=1) > 0 THEN 'YES' ELSE 'NO' END AS pod_status,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='004A' ORDER BY `tss`.`id` DESC LIMIT 1) AS `hub_unloading`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='004B' ORDER BY `tss`.`id` DESC LIMIT 1) AS `hub_loading`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='0103' ORDER BY `tss`.`id` DESC LIMIT 1) AS `bkg_info`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='0140' ORDER BY `tss`.`id` DESC LIMIT 1) AS `booking_created`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='0200' ORDER BY `tss`.`id` DESC LIMIT 1) AS `empty_gateout`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='0220' ORDER BY `tss`.`id` DESC LIMIT 1) AS `empty_placed_supplier`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='0300' ORDER BY `tss`.`id` DESC LIMIT 1) AS `ready_at_supplier`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='0445' ORDER BY `tss`.`id` DESC LIMIT 1) AS `pickup_planned`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='0490' ORDER BY `tss`.`id` DESC LIMIT 1) AS `arrival_collection_point`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='0491' ORDER BY `tss`.`id` DESC LIMIT 1) AS `departure_collection_point`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='1000' ORDER BY `tss`.`id` DESC LIMIT 1) AS `arrived_origin_depot`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='1100' ORDER BY `tss`.`id` DESC LIMIT 1) AS `expory_customs_cleared`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='1300' ORDER BY `tss`.`id` DESC LIMIT 1) AS `shipped_on_vessel`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='1335' ORDER BY `tss`.`id` DESC LIMIT 1) AS `loaded_in_ferry`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='1336' ORDER BY `tss`.`id` DESC LIMIT 1) AS `unloaded_in_ferry`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='1065' ORDER BY `tss`.`id` DESC LIMIT 1) AS `fcl_at_cy`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='1200' ORDER BY `tss`.`id` DESC LIMIT 1) AS `vessel_sailing`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='1299' ORDER BY `tss`.`id` DESC LIMIT 1) AS `loaded_on_board`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='1400' ORDER BY `tss`.`id` DESC LIMIT 1) AS `arrived_port`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='1405' ORDER BY `tss`.`id` DESC LIMIT 1) AS `vessel_discharged`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='1500' ORDER BY `tss`.`id` DESC LIMIT 1) AS `kn_custom_clearance`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='1600' ORDER BY `tss`.`id` DESC LIMIT 1) AS `custom_clearance_done`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='1690' ORDER BY `tss`.`id` DESC LIMIT 1) AS `customs_released`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='1819' ORDER BY `tss`.`id` DESC LIMIT 1) AS `gateout_dispatched`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='2320' ORDER BY `tss`.`id` DESC LIMIT 1) AS `cfs_dispatch`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='2333' ORDER BY `tss`.`id` DESC LIMIT 1) AS `delivery_unloading_done`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='2400' ORDER BY `tss`.`id` DESC LIMIT 1) AS `delivery_date_planned`,
			(SELECT convertToClientTZ(`tss`.`createdon`, '{$currentTimeZone}') as createdon FROM `tb_stop_status` `tss` WHERE `o`.`id`=`tss`.`order_id` AND `tss`.`status_code`='3400' ORDER BY `tss`.`id` DESC LIMIT 1) AS `empty_gatein`
			"
		];
		$tableName='tb_orders o';
		$indexColumn='o.id';
		$groupBy='o.id';
		$excludeCountQuery='Yes';
		$wherecondition = $indexColumn . "!='' " . $orderTableWhere;
		$timeZone = $curtz;
		$joinsArray[]=['table_name'=>'tb_order_details as d','condition'=>"o.id=d.order_row_id",'join_type'=>'left'];
		$joinsArray[]=['table_name'=>'tb_customers as ct','condition'=>"o.customer_id=ct.id",'join_type'=>'left'];
		foreach ($bindings as $param) {
			$wherecondition = preg_replace(
				'#\?#',
				is_array($param) ? " (" . implode(", ", array_map(function($item) {
					return $this->db->escape($item);
				}, $param)).") " : $this->db->escape($param),
				$wherecondition,
				true
			);
		}
		$dataTableSortOrdering=[];
		$getRecordListing = $this->Datatables_model->datatablesQuery( $selectColumns, $dataTableSortOrdering, $tableName, $joinsArray, $wherecondition, $indexColumn, 'TRUE', $groupBy,$excludeCountQuery,'POST' );

		$reqData=['id','shift_id'];
		$this->db->query('SET SESSION  group_concat_max_len=10240');
		$formattedData = $this->DataArrayFormatter_model->getCommaSeparatedFields($reqData,$getRecordListing['data']);
		if(isset($formattedData['commaSeparated']['id']) && $formattedData['commaSeparated']['id']!=''){
			$refCodes = "'DQ','XSR'";
			$formattedData = $this->DataQueryFormatter_model->getOrderReferenceData($formattedData['commaSeparated']['id'],$formattedData,$refCodes);
		}
		if ($excludeCountQuery=='Yes') {
			$totalRecords     = $compiledCount;
			$recordsFiltered  = $compiledCount;
		} else {
			$totalRecords     = $getRecordListing['recordsTotal'];
			$recordsFiltered  = $getRecordListing['recordsFiltered'];
		}
		$getRecordListing=[];
		if (isset($formattedData['orders'])) {
			$getRecordListing=$formattedData['orders'];
			krsort($getRecordListing);
		}
		$recordListing    = [];
		$content          = '[';
		$i                 = 0;
		$srNumber = $start;
		if (!empty($getRecordListing)) {
			$actionContent = '';
			$cntr=1;
			foreach ($getRecordListing as $res) {
				$salogDQ = $salog_ref = $referenceData = "";
				if (isset($res['reference_value'])) {
					$referenceData = $res['reference_value'];
				}
				if ($referenceData != '') {
					$arrayData = $this->DataArrayFormatter_model->formatReferenceParameters($referenceData);
					$salogDQ = isset($arrayData['DQ']) ? $arrayData['DQ'] : '';
					$salog_ref = isset($arrayData['XSR']) ? $arrayData['XSR']: '';
				}
				$earlyPickupDateTime = (!empty($res['early_pickup_datetime'])) ? $res['early_pickup_datetime'] :  "" ;
				$earlyDeliveryDateTime = (!empty($res['early_delivery_datetime'])) ? $res['early_delivery_datetime'] :  "" ;
				$acceptedByDriver = (!empty($res['accepted_by_driver'])) ? date('d-m-Y h:i A',strtotime($res['accepted_by_driver'])) :  "" ;
				$pickedupDatetime = (!empty($res['pickedup_datetime'])) ? date('d-m-Y h:i A',strtotime($res['pickedup_datetime'])) :  "" ;
				$deliveredDatetime = (!empty($res['delivered_datetime'])) ? date('d-m-Y h:i A',strtotime($res['delivered_datetime'])) :  "" ;
				$completedDatetime = (!empty($res['completed_datetime'])) ? date('d-m-Y h:i A',strtotime($res['completed_datetime'])) :  "" ;
				$hubUnloading = $res['hub_unloading'] ? date('d-m-Y h:i A',strtotime($res['hub_unloading'])) : '';
				$hubLoading = $res['hub_loading'] ? date('d-m-Y h:i A',strtotime($res['hub_loading'])) : '';
				$bkgInfo = $res['bkg_info'] ? date('d-m-Y h:i A',strtotime($res['bkg_info'])) : '';
				$bookingCreated = $res['booking_created'] ? date('d-m-Y h:i A',strtotime($res['booking_created'])) : '';
				$emptyGateout = $res['empty_gateout'] ? date('d-m-Y h:i A',strtotime($res['empty_gateout'])) : '';
				$emptyPlacedSupplier = $res['empty_placed_supplier'] ? date('d-m-Y h:i A',strtotime($res['empty_placed_supplier'])) : '';
				$readyAtSupplier = $res['ready_at_supplier'] ? date('d-m-Y h:i A',strtotime($res['ready_at_supplier'])) : '';
				$pickupPlanned = $res['pickup_planned'] ? date('d-m-Y h:i A',strtotime($res['pickup_planned'])) : '';
				$arrivalCollectionPoint = $res['arrival_collection_point'] ? date('d-m-Y h:i A',strtotime($res['arrival_collection_point'])) : '';
				$departureCollectionPoint = $res['departure_collection_point'] ? date('d-m-Y h:i A',strtotime($res['departure_collection_point'])) : '';
				$arrivedOriginDepot = $res['arrived_origin_depot'] ? date('d-m-Y h:i A',strtotime($res['arrived_origin_depot'])) : '';
				$exporyCustomsCleared = $res['expory_customs_cleared'] ? date('d-m-Y h:i A',strtotime($res['expory_customs_cleared'])) : '';
				$shippedOnVessel = $res['shipped_on_vessel'] ? date('d-m-Y h:i A',strtotime($res['shipped_on_vessel'])) : '';
				$loadedInFerry = $res['loaded_in_ferry'] ? date('d-m-Y h:i A',strtotime($res['loaded_in_ferry'])) : '';
				$unloadedInFerry = $res['unloaded_in_ferry'] ? date('d-m-Y h:i A',strtotime($res['unloaded_in_ferry'])) : '';
				$fclAtCy = $res['fcl_at_cy'] ? date('d-m-Y h:i A',strtotime($res['fcl_at_cy'])) : '';
				$vesselSailing = $res['vessel_sailing'] ? date('d-m-Y h:i A',strtotime($res['vessel_sailing'])) : '';
				$loadedOnBoard = $res['loaded_on_board'] ? date('d-m-Y h:i A',strtotime($res['loaded_on_board'])) : '';
				$arrivedPort = $res['arrived_port'] ? date('d-m-Y h:i A',strtotime($res['arrived_port'])) : '';
				$vesselDischarged = $res['vessel_discharged'] ? date('d-m-Y h:i A',strtotime($res['vessel_discharged'])) : '';
				$knCustomClearance = $res['kn_custom_clearance'] ? date('d-m-Y h:i A',strtotime($res['kn_custom_clearance'])) : '';
				$customClearanceDone = $res['custom_clearance_done'] ? date('d-m-Y h:i A',strtotime($res['custom_clearance_done'])) : '';
				$customsReleased = $res['customs_released'] ? date('d-m-Y h:i A',strtotime($res['customs_released'])) : '';
				$gateoutDispatched = $res['gateout_dispatched'] ? date('d-m-Y h:i A',strtotime($res['gateout_dispatched'])) : '';
				$cfsDispatch = $res['cfs_dispatch'] ? date('d-m-Y h:i A',strtotime($res['cfs_dispatch'])) : '';
				$deliveryUnloading_done = $res['delivery_unloading_done'] ? date('d-m-Y h:i A',strtotime($res['delivery_unloading_done'])) : '';
				$deliveryDatePlanned = $res['delivery_date_planned'] ? date('d-m-Y h:i A',strtotime($res['delivery_date_planned'])) : '';
				$emptyGatein = $res['empty_gatein'] ? date('d-m-Y h:i A',strtotime($res['empty_gatein'])) : '';
				$content .= '[';
				$j=0;
				$recordListing[$i][0]  = '';
				$recordListing[$i][++$j]  = $res['order_id'];
				$recordListing[$i][++$j]  = $salog_ref;
				$recordListing[$i][++$j]  = $res['customer_name'];
				$recordListing[$i][++$j]  = $res['pickup_address1'];
				$recordListing[$i][++$j]  = $res['delivery_address1'];
				$recordListing[$i][++$j]  = $earlyPickupDateTime;
				$recordListing[$i][++$j]  = $earlyDeliveryDateTime;
				$recordListing[$i][++$j]  = $salogDQ;
				$recordListing[$i][++$j]  = $res['shipmentid'];
				$recordListing[$i][++$j]  = $res['pickup_company'];
				$recordListing[$i][++$j]  = $res['delivery_company'];
				$recordListing[$i][++$j]  = $hubUnloading;
				$recordListing[$i][++$j]  = $hubLoading;
				$recordListing[$i][++$j]  = $bkgInfo;
				$recordListing[$i][++$j]  = $acceptedByDriver;
				$recordListing[$i][++$j]  = $bookingCreated;
				$recordListing[$i][++$j]  = $emptyGateout;
				$recordListing[$i][++$j]  = $emptyPlacedSupplier;
				$recordListing[$i][++$j]  = $readyAtSupplier;
				$recordListing[$i][++$j]  = $pickupPlanned;
				$recordListing[$i][++$j]  = $arrivalCollectionPoint;
				$recordListing[$i][++$j]  = $departureCollectionPoint;
				$recordListing[$i][++$j]  = $pickedupDatetime;
				$recordListing[$i][++$j]  = $arrivedOriginDepot;
				$recordListing[$i][++$j]  = $exporyCustomsCleared;
				$recordListing[$i][++$j]  = $shippedOnVessel;
				$recordListing[$i][++$j]  = $loadedInFerry;
				$recordListing[$i][++$j]  = $unloadedInFerry;
				$recordListing[$i][++$j]  = $fclAtCy;
				$recordListing[$i][++$j]  = $vesselSailing;
				$recordListing[$i][++$j]  = $loadedOnBoard;
				$recordListing[$i][++$j]  = $arrivedPort;
				$recordListing[$i][++$j]  = $vesselDischarged;
				$recordListing[$i][++$j]  = $knCustomClearance;
				$recordListing[$i][++$j]  = $customClearanceDone;
				$recordListing[$i][++$j]  = $customsReleased;
				$recordListing[$i][++$j]  = $gateoutDispatched;
				$recordListing[$i][++$j]  = $deliveredDatetime;
				$recordListing[$i][++$j]  = $cfsDispatch;
				$recordListing[$i][++$j]  = $deliveryUnloading_done;
				$recordListing[$i][++$j]  = $deliveryDatePlanned;
				$recordListing[$i][++$j]  = $completedDatetime;
				$recordListing[$i][++$j]  = $emptyGatein;
				$recordListing[$i][++$j]  = $res['pod_status'];
				$i ++;
				$cntr++;
			}
			$content    .= ']';
			$final_data = json_encode( $recordListing );
		} else {
			$final_data = '[]';
		}
		echo '{"draw":' . $draw . ',"recordsTotal":' . $totalRecords . ',"recordsFiltered":' . $recordsFiltered . ',"data":' . $final_data . '}';
	}

	public function searchFilter(array $post = []) : array {
		$whereCondition = [];
		$whereCondition["o.company_code"] = $this->session->userdata('company_code');
		$whereCondition["o.created_source"] = 5;
		if (isset($post['fromdate_search']) && $post['fromdate_search'] != "") {
			$fromdate_search = date('Y-m-d', strtotime($post['fromdate_search']));
			$whereCondition["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate_search;
		}

		if (isset($post['todate_search']) && $post['todate_search'] != "") {
			$todate_search = date('Y-m-d', strtotime($post['todate_search']));
			$whereCondition["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate_search;
		}
		return $whereCondition;
	}
}