<?php if ( ! defined( 'BASEPATH' ) ) {
	exit( 'No direct script access allowed' );
}

class Transactions extends CI_Controller {

	public function __Construct() {
		parent::__Construct();
		$this->load->library( 'session' );
		if ( $this->session->userdata( 'user_id' ) == '' ) {
			redirect( 'login' );
		}

		$this->load->library( 'form_validation' );
		$this->load->model( 'common' );
		$this->load->model("transacmodel");
		$this->load->library( 'email' );
	}

	public function index( $id = NULL ) {

        $data['page_title'] = 'Trade Transactions List';
		$data['sub_title']  =  'Transactions';
        $user_id = $this->session->userdata('user_id');
        $data['user_id'] = $user_id;
        $where = array();
		$whr = array();
		$company_code=$this->session->userdata('company_code');

		$whr['t1.company_code'] = $company_code;
		$whr['t1.user_id'] = $user_id;

        if( $this->session->userdata( "user_role_id" ) == 4 ){
            $whr['t1.customer_id'] = $this->session->userdata("cust_id");
        }

        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
			$transaction_id = $this->input->post('transaction_id',true);
            $status = $this->input->post('status',true);
			$fdate = $this->input->post('fromdate',true);
			$edate = $this->input->post('todate',true);
            if (isset($fdate) && $fdate != "") {
                $date1=date('Y-m-d',strtotime($fdate));
				$whr["DATE(t1.createdon) >="] = $date1;
            }
			if (isset($edate) && $edate != "") {
                $date2=date('Y-m-d',strtotime($edate));
                $whr["DATE(t1.createdon) <="] = $date2;
			}
			if (isset($transaction_id) && $transaction_id != "") {
                $whr['t1.transaction_id'] = $transaction_id;
            }
			if (isset($status) && $status != "") {
                $whr['t1.transaction_status'] = $status;
            }

        }elseif(isset($_POST['searchsubmita']) && $_POST['searchsubmita'] == "Search") {
            $department_code = $this->input->post('department_code',true);
            $status = $this->input->post('status',true);
			$transaction_id = $this->input->post('transaction_id',true);
			$mobile = $this->input->post('mobile',true);
			$tod = $this->input->post('type_of_declaration',true);
			$transport_mode = $this->input->post('transport_mode',true);
			$gateway = $this->input->post('gateway',true);
			$ref_type = $this->input->post('ref_type',true);
			$ref_value = $this->input->post('ref_value',true);
			$trade_status = $this->input->post('trade_status',true);
			$fdate = $this->input->post('advfrom_date',true);
			$edate = $this->input->post('advto_date',true);

            if (isset($fdate) && $fdate != "") {
                $date1=date('Y-m-d',strtotime($fdate));
				$whr["DATE(t1.createdon) >="] = $date1;
            }
			if (isset($edate) && $edate != "") {
                $date2=date('Y-m-d',strtotime($edate));
				$whr["DATE(t1.createdon) <="] = $date2;
            }

            if (isset($department_code) && $department_code != "") {
                $where['t1.department_code'] = $department_code;
            }
			if (isset($transaction_id) && $transaction_id != "") {
                $where['t1.transaction_id'] = $transaction_id;
            }
            if (isset($mobile) && $mobile != "") {
                $where['t1.mobile'] = $mobile;
            }
             if (isset($tod) && $tod != "") {
                $where['t1.type_of_declaration'] = $tod;
            }

             if (isset($transport_mode) && $transport_mode != "") {
                $where['t1.transport_mode'] = $transport_mode;
            }

             if (isset($gateway) && $gateway != "") {
                $where['t1.gateway'] = $gateway;
            }

             if (isset($ref_type) && $ref_type != "") {
                $where['t1.ref_type'] = $ref_type;
            }

             if (isset($ref_value) && $ref_value != "") {
                $where['t1.ref_value'] = $ref_value;
            }
             if (isset($trade_status) && $trade_status != "") {
                $where['t1.transaction_status'] = $trade_status;
            }


			if (isset($status) && $status != "") {
                $where['t1.transaction_status'] = $status;
            }if (isset($ref_value) && $ref_value != "") {
                $where['t1.ref_value'] = $ref_value;
            }
        }

        $data['customer_code']='';
        if( $this->session->userdata( "user_role_id" ) == 4 ){
            $cust_id=$this->session->userdata( "cust_id" );
        	$customer=$this->transacmodel->getcustid($cust_id);
        	$data['customer_code']=$customer->code;
        	$data['customer_phone']=$customer->phone;
        	$data['customer_cid']=$customer->cid;
        }

		$data['document']=$this->transacmodel->getdocumenttypes();
		$data['transaction_data'] = $this->transacmodel->getsearchdata($whr,$where);
        $data['ref_names_arr'] = $this->transacmodel->getrefnums();
        $data['gateways'] = $this->transacmodel->getgateways();
        $data['declarations'] = $this->transacmodel->getdeclarations();
        $data['transport_mode'] = $this->transacmodel->gettransportmode();
		$this->newtemplate->dashboard("transactions/index", $data);
    }

    public function view($id){

        $data['page_title'] = 'Trade Transactions';
		$data['sub_title']  =  'View';
        $data['transaction_view'] = $this->transacmodel->viewdata($id);
        $data['routing_info'] = "";
        if($data['transaction_view']['routing_type'] > 0){
             /* Importer or exporter details */
            $routing_info=$this->getconsigneedetailsListbyIDnew($data['transaction_view']['routing_id']);
            $data['routing_info'] = $routing_info[0];
    	}
        $this->newtemplate->dashboard('transactions/view', $data);
    }

    public function edit($id){

        $data['page_title'] = 'Trade Transactions';
		$data['sub_title']  =  'Edit';
        $data['transaction_view'] = $this->transacmodel->viewdata($id);
        $data['routing_info'] = "";
        if($data['transaction_view']['routing_type'] > 0){
             /* Importer or exporter details */
            $routing_info=$this->getconsigneedetailsListbyIDnew($data['transaction_view']['routing_id']);
            $data['routing_info'] = $routing_info[0];
    	}

        if(!empty($_POST)){

            $cdate          = date( 'Y-m-d H:i:s' );
            $user_id        = $this->session->userdata( 'user_id' );
            $cust_id        = $this->session->userdata( 'cust_id' );
            $company_code   = isset( $_POST['company_code'] ) ? $_POST['company_code'] : "";
            $branch_code    = isset( $_POST['branch_code'] ) ? $_POST['branch_code'] : "";
		    $department_code= isset( $_POST['department_code'] ) ? $_POST['department_code'] : "";
            $mobile         = isset( $_POST['mobile'] ) ? $_POST['mobile'] : "";
            $customer_notification = isset( $_POST['customer_notification'] ) ? $_POST['customer_notification'] : "";
            $knadmin_notification = isset( $_POST['knadmin_notification'] ) ? $_POST['knadmin_notification'] : "";

    		if($customer_notification == '' && $knadmin_notification == ''){
    			$email_notification = 0;
    		}elseif($customer_notification != '' && $knadmin_notification == ''){
    			$email_notification = 1;
    		}elseif($customer_notification == '' && $knadmin_notification != ''){
    			$email_notification = 2;
    		}elseif($customer_notification != '' && $knadmin_notification != ''){
    			$email_notification = 3;
    		}

		$permit_requested_by  = isset( $_POST['permit_requested_by'] ) ? $_POST['permit_requested_by'] : "";
		$type_of_declaration  = isset( $_POST['type_of_declaration'] ) ? $_POST['type_of_declaration'] : "";
		$frieght_charge       = isset( $_POST['frieght_charge'] ) ? $_POST['frieght_charge'] : "";
		$transport_mode       = isset( $_POST['transport_mode'] ) ? $_POST['transport_mode'] : "";
		$other_remarks        = isset( $_POST['other_remarks'] ) ? $_POST['other_remarks'] : "";
		$gateway              = isset( $_POST['gateway'] ) ? $_POST['gateway'] : "";
		$coo                  = isset( $_POST['coo'] ) ? $_POST['coo'] : "";
        $type_of_coo          = isset( $_POST['type_of_coo'] ) ? $_POST['type_of_coo'] : "";
        $coo_shipment_numbers = isset( $_POST['coo_shipment_numbers'] ) ? $_POST['coo_shipment_numbers'] : "";
        $port_of_loading      = isset( $_POST['port_of_loading'] ) ? $_POST['port_of_loading'] : "";
        $uom_qty              = isset( $_POST['uom_qty'] ) ? $_POST['uom_qty'] : "";
        $destination_country  = isset( $_POST['destination_country'] ) ? $_POST['destination_country'] : "";
		$dg_cargo             = isset( $_POST['dg_cargo'] ) ? $_POST['dg_cargo'] : "";
		$bonded               = isset( $_POST['bonded'] ) ? $_POST['bonded'] : "";
		$shipment             = isset( $_POST['shipment'] ) ? $_POST['shipment'] : "";
		$routing_type         = isset( $_POST['routing_type'] ) ? $_POST['routing_type'] : "";
		$routing_id           = isset( $_POST['routing_id'] ) ? $_POST['routing_id'] : "";
		$ref_type             = isset( $_POST['ref_type'] ) ? $_POST['ref_type'] : "";
		$ref_value            = isset( $_POST['ref_value'] ) ? $_POST['ref_value'] : "";
		$trade_status         = isset( $_POST['trade_status'] ) ? $_POST['trade_status'] : "0";
		$round_document_id    = isset( $_POST['round_document_id'] ) ? $_POST['round_document_id'] : "";
        $get_country = $this->db->select('country_code,company_code')->get_where("tb_users", array(
            'id' => $user_id
        ));
        $country_code = $get_country->row()->country_code;

        if($cust_id ==''){
        	$cust_id  = $this->session->userdata( 'user_id' );
        }


		$trans_arr    = array(
			'mobile'              => $mobile,
			'permit_requested_by' => $permit_requested_by,
			'company_code'        => $company_code,
			'branch_code'         => $branch_code,
			'department_code'     => $department_code,
			'type_of_declaration' => $type_of_declaration,
			'frieght_charge'      => $frieght_charge,
			'transport_mode'      => $transport_mode,
			'other_remarks'       => $other_remarks,
			'gateway'             => $gateway,
			'coo_required'        => $coo,
            'type_of_coo'         => $type_of_coo,
            'coo_shipment_numbers'=> $coo_shipment_numbers,
            'port_of_loading'     => $port_of_loading,
            'uom_qty'             => $uom_qty,
            'destination_country' => $destination_country,
			'dg_cargo'            => $dg_cargo,
			'bonded'              => $bonded,
			'shipment'            => $shipment,
			'routing_type'        => $routing_type,
			'routing_id'          => $routing_id,
			'ref_type'            => $ref_type,
			'ref_value'           => $ref_value,
			'transaction_status'  => $trade_status,
			'email_notification'  => $email_notification,
			'updatedon'           => date( 'Y-m-d H:i:s' ),
		);

		$upd = $this->db->where( array( 'id' => $id ) )->update( "tb_trade_transactions",$trans_arr );

		$this->session->set_flashdata('success_msg', 'Transactions Updated Successfully - ');
		redirect( "transactions" );



        }

        $resDoc = $this->db->query("SELECT t1.*,t2.type_name FROM tb_doc_trade t1 Left JOIN tb_document_types t2 ON t2.id=t1.doctype_id where t1.status = 0 and t1.transaction_id = ".$data['transaction_view']['transaction_id']." ORDER BY t1.id ASC");
        $data['transaction_docs'] = $resDoc->result_array();
        $data['ref_names_arr'] = $this->transacmodel->getrefnums();
        $data['gateways'] = $this->transacmodel->getgateways();
        $data['declarations'] = $this->transacmodel->getdeclarations();
        $data['transport_mode'] = $this->transacmodel->gettransportmode();
        $data['document']=$this->transacmodel->getdocumenttypes();
        $this->newtemplate->dashboard('transactions/edit', $data);
    }


	public function findcountrybyname() {
		$name   = $this->input->post( 'name',true );
		$result = array();
		$chkqry = $this->db->select( 'id,company_name,company_code,description' )->get_where( "tb_company_master", array( 'company_code' => $name ) );
		if ( $chkqry->num_rows() > 0 ) {
			foreach ( $chkqry->result() as $res ) {
				$check    = "<input type='radio' name='listcompany' id='listcompany_" . $res->id . "' class='listcompany' onchange='selectcompany(" . $res->id . ")' value='" . $res->company_code . "'>";
				$result[] = array( 'check' => $check, 'company_code' => $res->company_code, 'company_name' => $res->company_name, 'description' => $res->description );
			}
		}
		echo json_encode( $result );
	}

	public function findbranchbyname() {
		$name   = $this->input->post( 'name',true );
		$result = array();
		$chkqry = $this->db->select( 'id,branch_name,company_code,description,branch_code' )->get_where( "tb_branch_master", array( 'branch_code' => $name ) );
		if ( $chkqry->num_rows() > 0 ) {
			foreach ( $chkqry->result() as $res ) {
				$check    = "<input type='radio' name='listbranch' id='listbranch_" . $res->id . "' class='listbranch' onchange='selectbranch(" . $res->id . ")' value='" . $res->branch_code . "'>";
				$result[] = array( 'check' => $check, 'branch_code' => $res->branch_code, 'branch_name' => $res->branch_name, 'company_code' => $res->company_code, 'description' => $res->description );
			}
		}
		echo json_encode( $result );
	}


	public function viewcompanylist() {
		$result = array();
		$check  = "";
		$popup  = isset( $_POST['popup'] ) ? $_POST['popup'] : "";
		$chkqry = $this->db->select( "id,company_name,company_code,description" )->get_where( "tb_company_master", array( 'status' => 1 ) );
		if ( $chkqry->num_rows() > 0 ) {
			foreach ( $chkqry->result() as $res ) {
				if ( $popup == 'popup' ) {
					$check = "<input type='radio' name='listpopupcompany' id='listpopupcompany_" . $res->id . "' class='listpopupcompany' onchange='selectpopupcompany(" . $res->id . ")' value='" . $res->company_code . "'>";
				} else {
					$check = "<input type='radio' name='listcompany' id='listcompany_" . $res->id . "' class='listcompany' onchange='selectcompany(" . $res->id . ")' value='" . $res->company_code . "'>";
				}
				$result[] = array( 'check' => $check, 'id' => $res->id, 'company_code' => $res->company_code, 'company_name' => $res->company_name, 'description' => $res->description );
			}
		}
		echo json_encode( $result );
	}


	public function getcompanyname() {
		$post   = $this->input->post();
		$term   = $post['term'];
		$result = array();
		$check  = "";
		$popup  = isset( $_POST['popup'] ) ? $_POST['popup'] : "";
		$this->db->select( "id,company_code,company_name,description" );
		$this->db->from( "tb_company_master" );
		$this->db->like( 'company_code', $term );
		$this->db->order_by( 'createdon', 'DESC' );
		$getcompanyname = $this->db->get();
		if ( $getcompanyname->num_rows() > 0 ) {
			foreach ( $getcompanyname->result() as $res ) {
				if ( $popup == 'popup' ) {
					$check = "<input type='radio' name='listpopupcompany' id='listpopupcompany_" . $res->id . "' class='listpopupcompany' onchange='selectpopupcompany(" . $res->id . ")' value='" . $res->company_code . "'>";
				} else {
					$check = "<input type='radio' name='listcompany' id='listcompany_" . $res->id . "' class='listcompany' onchange='selectcompany(" . $res->id . ")' value='" . $res->company_code . "'>";
				}
				$result[] = array( 'check' => $check, 'company_code' => $res->company_code, 'company_name' => $res->company_name, 'description' => $res->description );
			}
		}
		echo json_encode( $result );
	}

	public function addcompanydetails() {
		$post   = $this->input->post();
		$cdate  = date( 'Y-m-d H:i:s' );
		$ins_ar = array( 'company_name' => $post['company_name'], 'company_code' => $post['company_code'], 'description' => $post['description'], 'status' => 1, 'createdon' => $cdate );
		$chkqry = $this->db->select( 'id' )->get_where( "tb_company_master", array( 'company_name' => $post['company_name'], 'company_code' => $post['company_code'] ) );
		if ( $chkqry->num_rows() > 0 ) {
			echo json_encode( 2 );
		} else {
			$ins = $this->db->insert( 'tb_company_master', $ins_ar );
			if ( $ins ) {
				echo json_encode( 1 );
			} else {
				echo json_encode( 0 );
			}
		}

	}


	public function adddepartmentdetails() {
		$post   = $this->input->post();
		$cdate  = date( 'Y-m-d H:i:s' );
		$ins_ar = array( 'department_name' => $post['department_name'], 'department_code' => $post['department_code'], 'company_code' => $post['company_code'], 'branch_code' => $post['branch_code'], 'description' => $post['description'], 'status' => 1, 'createdon' => $cdate );
		$chkqry = $this->db->select( 'id' )->get_where( "tb_department_master", array( 'department_code' => $post['department_code'], 'department_name' => $post['department_name'], 'company_code' => $post['company_code'], 'branch_code' => $post['branch_code'] ) );
		if ( $chkqry->num_rows() > 0 ) {
			echo json_encode( 2 );
		} else {
			$ins = $this->db->insert( 'tb_department_master', $ins_ar );
			if ( $ins ) {
				echo json_encode( 1 );
			} else {
				echo json_encode( 0 );
			}
		}

	}

	public function getbranchbycompany() {
		$cmp_id = $this->input->post( 'cmp_code' ,true);
		$id     = $this->input->post( 'term',true );
		$result = array();
		$this->db->select( 'id,branch_code' );
		$this->db->from( 'tb_branch_master' );
		$this->db->like( 'company_code', $cmp_id );
		$this->db->like( 'branch_code', $id );
		$qry = $this->db->get();
		if ( $qry->num_rows() > 0 ) {
			foreach ( $qry->result() as $res ) {
				$result[] = array( 'id' => $res->id, 'branch_code' => $res->branch_code );
			}
		}
		echo json_encode( $result );
	}

	public function getbranchbyname() {
		$cmp_id = $this->input->post( 'name',true );
		$result = array();
		$this->db->select( 'id,branch_code,branch_name,company_code,description' );
		$this->db->from( 'tb_branch_master' );
		$this->db->like( 'branch_code', $cmp_id );
		$qry = $this->db->get();
		if ( $qry->num_rows() > 0 ) {
			foreach ( $qry->result() as $res ) {
				$check    = "<input type='radio' name='listbranch' id='listbranch_" . $res->id . "' class='listbranch' onchange='selectbranch(" . $res->id . ")' value='" . $res->branch_code . "'>";
				$result[] = array( 'check' => $check, 'id' => $res->id, 'branch_code' => $res->branch_code, 'branch_name' => $res->branch_name, 'company_code' => $res->company_code, 'description' => $res->description );
			}
		}
		echo json_encode( $result );
	}

	public function viewbranchlist() {
		$result       = array();
		$company_code = isset( $_POST['company_code'] ) ? $_POST['company_code'] : "";
		$check        = "";
		$popup        = isset( $_POST['popup'] ) ? $_POST['popup'] : "";

		$where = array( 'status' => 1 );
		if ( $company_code != "" ) {
			$where['company_code'] = $company_code;
		}
		$this->db->select( 'id,branch_code,branch_name,company_code,description' );
		$this->db->from( 'tb_branch_master' );
		$this->db->where( $where );
		$qry = $this->db->get();
		if ( $qry->num_rows() > 0 ) {
			foreach ( $qry->result() as $res ) {
				if ( $popup == 'popup' ) {
					$check = "<input type='radio' name='listpopupbranch' id='listpopupbranch_" . $res->id . "' class='listpopupbranch' onchange='selectpopupbranch(" . $res->id . ")' value='" . $res->branch_code . "'>";
				} else {
					$check = "<input type='radio' name='listbranch' id='listbranch_" . $res->id . "' class='listbranch' onchange='selectbranch(" . $res->id . ")' value='" . $res->branch_code . "'>";
				}
				$result[] = array( 'check' => $check, 'id' => $res->id, 'branch_code' => $res->branch_code, 'branch_name' => $res->branch_name, 'company_code' => $res->company_code, 'description' => $res->description );
			}
		}
		echo json_encode( $result );
	}

	public function addbranchdetails() {
		$post   = $this->input->post();
		$cdate  = date( 'Y-m-d H:i:s' );
		$ins_ar = array( 'branch_name' => $post['branch_name'], 'branch_code' => $post['branch_code'], 'company_code' => $post['company_code'], 'description' => $post['description'], 'status' => 1, 'createdon' => $cdate );
		$chkqry = $this->db->select( "id" )->get_where( "tb_branch_master", array( 'branch_code' => $post['branch_code'], 'branch_name' => $post['branch_name'] ) );
		if ( $chkqry->num_rows() > 0 ) {
			echo json_encode( 2 );
		} else {
			$ins = $this->db->insert( "tb_branch_master", $ins_ar );
			if ( $ins ) {
				echo json_encode( 1 );
			} else {
				echo json_encode( 0 );
			}
		}

	}

	public function getdepartmentbybranch() {
		$cmp_id = $this->input->post( 'branch_code',true );
		$id     = $this->input->post( 'term',true );
		$result = array();
		$qry    = $this->db->select( "id,department_code" );
		$this->db->from( "tb_department_master" );
		$this->db->where( array( 'branch_code' => $cmp_id ) );
		$this->db->like( 'department_code', $id );
		$qry = $this->db->get();
		if ( $qry->num_rows() > 0 ) {
			foreach ( $qry->result() as $res ) {
				$result[] = array( 'id' => $res->id, 'department_code' => $res->department_code );
			}
		}
		echo json_encode( $result );
	}

	public function finddepartmentlist() {
		$name   = $this->input->post( 'name',true );
		$result = array();
		$qry    = $this->db->select( "id,department_code,department_name,company_code,branch_code,description" )->get_where( "tb_department_master", array( 'department_code' => $name ) );
		if ( $qry->num_rows() > 0 ) {
			foreach ( $qry->result() as $res ) {
				$check    = "<input type='radio' name='listdepartment' id='listdepartment_" . $res->id . "' class='listdepartment' onchange='selectdepartment(" . $res->id . ")' value='" . $res->department_code . "'>";
				$result[] = array( 'check' => $check, 'id' => $res->id, 'department_code' => $res->department_code, 'department_name' => $res->department_name, 'company_code' => $res->company_code, 'branch_code' => $res->branch_code, 'description' => $res->description );
			}
		}
		echo json_encode( $result );
	}

	public function finddepartmentlikelist() {
		$name   = $this->input->post( 'name' ,true);
		$result = array();
		$qry    = $this->db->select( "id,department_code,department_name,company_code,branch_code,description" )->get_where( "tb_department_master", array( 'department_code' => $name ) );
		if ( $qry->num_rows() > 0 ) {
			foreach ( $qry->result() as $res ) {
				$check    = "<input type='radio' name='listdepartment' id='listdepartment_" . $res->id . "' class='listdepartment' onchange='selectdepartment(" . $res->id . ")' value='" . $res->department_code . "'>";
				$result[] = array( 'check' => $check, 'id' => $res->id, 'department_code' => $res->department_code, 'department_name' => $res->department_name, 'company_code' => $res->company_code, 'branch_code' => $res->branch_code, 'description' => $res->description );
			}
		}
		echo json_encode( $result );
	}

	public function viewdepartmentlist() {
		$result       = array();
		$company_code = isset( $_POST['company_code'] ) ? $_POST['company_code'] : "";
		$branch_code  = isset( $_POST['branch_code'] ) ? $_POST['branch_code'] : "";
		$popup        = isset( $_POST['popup'] ) ? $_POST['popup'] : "";
		$whr          = array( 'status' => 1 );
		if ( $company_code != "" ) {
			$whr['company_code'] = $company_code;
		}
		if ( $branch_code != "" ) {
			$whr['branch_code'] = $branch_code;
		}
		$this->db->select( "id,department_code,department_name,company_code,branch_code,description" );
		$this->db->from( "tb_department_master" );
		$this->db->where( $whr );
		$qry = $this->db->get();
		if ( $qry->num_rows() > 0 ) {
			foreach ( $qry->result() as $res ) {
				if ( $popup == 'popup' ) {
					$check = "<input type='radio' name='listpopupdepartment' id='listpopupdepartment_" . $res->id . "' class='listpopupdepartment' onchange='selectpopupdepartment(" . $res->id . ")' value='" . $res->department_code . "'>";
				} else {
					$check = "<input type='radio' name='listdepartment' id='listdepartment_" . $res->id . "' class='listdepartment' onchange='selectdepartment(" . $res->id . ")' value='" . $res->department_code . "'>";
				}
				$result[] = array( 'check' => $check, 'id' => $res->id, 'department_code' => $res->department_code, 'department_name' => $res->department_name, 'company_code' => $res->company_code, 'branch_code' => $res->branch_code, 'description' => $res->description );
			}
		}
		echo json_encode( $result );
	}

	public function checkcompanycode() {
		$companys = array();
		$c_code   = isset( $_POST['data'] ) ? $_POST['data'] : "";
		if ( ! empty( $c_code ) ) {
			$this->db->select( 'company_code' );
			$this->db->from( "tb_company_master" );
			$this->db->where_in( 'company_code', $c_code );
			$chk = $this->db->get();
			if ( $chk->num_rows() > 0 ) {
				foreach ( $chk->result() as $res ) {
					$companys[] = $res->company_code;
				}
			}
		}
		$diff_companys = array();
		if ( ! empty( $companys ) ) {
			$diff_companys = array_diff( $c_code, $companys );

		}
		echo json_encode( $diff_companys );
	}

	public function newtransaction() {
		$data         = $transport = array();
		$user_id      = $this->session->userdata( 'user_id' );
		$company_code = $this->session->userdata( 'company_code' );
		$branch_code  = $this->session->userdata( 'branch_code' );
		if ( $company_code == 'RUKN' ) {
			$gettrasnportmode = $this->db->query( "SELECT code,name FROM tb_transportmode WHERE code IN ('LTL','FTL','GRP')" );
			if ( $gettrasnportmode->num_rows() > 0 ) {
				foreach ( $gettrasnportmode->result() as $res ) {
					$transport[] = array( 'code' => $res->code, 'name' => $res->name );
				}
			}
		} else {
			$gettrasnportmode = $this->db->select( "code,name" )->get_where( "tb_transportmode", array( 'status' => 1 ) );
			if ( $gettrasnportmode->num_rows() > 0 ) {
				foreach ( $gettrasnportmode->result() as $res ) {
					$transport[] = array( 'code' => $res->code, 'name' => $res->name );
				}
			}
		}
		$data['transport']    = $transport;
		$data['company_code'] = $company_code;
		$data['branch_code']  = $branch_code;
		$pickup_details       = array();
		$custid               = $this->session->userdata( 'cust_id' );
		$ordertypes           = array();
		if ( $custid != "" ) {
			$getpickupdetails = $this->transacmodel->getpickupdetails( $custid );
			if ( $getpickupdetails->num_rows() > 0 ) {
				$pickup_details = array( 'id' => $getpickupdetails->row()->id, 'name' => $getpickupdetails->row()->name, 'party_id' => $getpickupdetails->row()->code, 'address' => $getpickupdetails->row()->address, 'pincode' => $getpickupdetails->row()->pincode, 'country' => $getpickupdetails->row()->country );
			}
			$getorders = $this->db->select( "id,type_name" )->group_by( "type_name" )->get_where( "tb_order_types", array( 'customer_id' => $custid, 'company_code' => $company_code, 'status' => '1' ) );
			if ( $getorders->num_rows() > 0 ) {
				foreach ( $getorders->result() as $res ) {
					$ordertypes[] = array( 'type_id' => $res->id, 'type_name' => $res->type_name );
				}
			} else {
				$getorders = $this->db->select( "id,type_name" )->group_by( "type_name" )->get_where( "tb_order_types", array( 'company_code' => $company_code, "status" => '1' ) );
				if ( $getorders->num_rows() > 0 ) {
					foreach ( $getorders->result() as $res ) {
						$ordertypes[] = array( 'type_id' => $res->id, 'type_name' => $res->type_name );
					}
				} else {
					$getorders = $this->db->select( "id,type_name" )->group_by( "type_name" )->get_where( "tb_order_types", array( 'company_code' => "SGKN", "status" => '1' ) );
					if ( $getorders->num_rows() > 0 ) {
						foreach ( $getorders->result() as $res ) {
							$ordertypes[] = array( 'type_id' => $res->id, 'type_name' => $res->type_name );
						}
					}
				}
			}
		} else {

			$getorders = $this->db->select( "id,type_name" )->group_by( "type_name" )->get_where( "tb_order_types", array( 'company_code' => $company_code, "status" => '1' ) );
			if ( $getorders->num_rows() > 0 ) {
				foreach ( $getorders->result() as $res ) {
					$ordertypes[] = array( 'type_id' => $res->id, 'type_name' => $res->type_name );
				}
			} else {
				$getorders = $this->db->select( "id,type_name" )->group_by( "type_name" )->get_where( "tb_order_types", array( 'company_code' => "SGKN", "status" => '1' ) );
				if ( $getorders->num_rows() > 0 ) {
					foreach ( $getorders->result() as $res ) {
						$ordertypes[] = array( 'type_id' => $res->id, 'type_name' => $res->type_name );
					}
				}
			}

		}
		$roles = array();
		$qyery = $this->db->query( "SELECT id,name FROM tbl_party_types WHERE user_id= '" . $user_id . "' AND status=1 GROUP BY name" );
		if ( $qyery->num_rows() > 0 ) {
			foreach ( $qyery->result() as $res ) {
				$roles[] = array( 'id' => $res->id, 'name' => $res->name );
			}
		}
		$getchargecodes = $this->db->select( "id,charge_code" )->get_where( "tb_charge_codes", array( 'status' => '1' ) );
		if ( $getchargecodes->num_rows() > 0 ) {
			foreach ( $getchargecodes->result() as $res ) {
				$chargecodes[] = array( 'charge_id' => $res->id, 'charge_code' => $res->charge_code );
			}
		}
		$data['vatcategory'] = array();
		$getvatcategory = $this->common->gettbldata(array('company_code'=>$company_code,'status' => '1'),"id,description,vat_category,vat_percentage","tb_vat_category",0,0);
		if (!empty($getvatcategory)) {
			foreach ($getvatcategory as $res) {
				$val = $res['id']."_".$res['vat_category'];
				$desc = $res['description']." (".$res['vat_category']."-".$res['vat_percentage'].")";
				$data['vatcategory'][] = array('id' => $res['id'],'val'=>$val, 'desc'=>$desc);
			}
		}
		$data['chargecodes']    = $chargecodes;
		$data['pickup_details'] = $pickup_details;
		$data['ordertypes']     = $ordertypes;
		$data['roles']          = $roles;
		$this->newtemplate->dashboard( 'transactions/newtransaction', $data );
	}

	public function getdeliverytermvalue() {
		$incoterm = $this->input->post( 'incoterm',true );
		$terms    = array();
		$terms    = getDeliverytermsbyIncoterm( $incoterm );

		echo json_encode( $terms );
	}

	public function getshipperID() {
		$parties      = array();
		$partytype_id = $this->input->post( 'partytype_id',true );
		$user_id      = $this->session->userdata( 'user_id' );
		$company_code = $this->session->userdata( 'company_code' );
		$whr          = " AND user_id ='" . $user_id . "' ";
		if ( $company_code == "RUKN" ) {
			$whr = "AND company_code LIKE '" . $company_code . "' ";
		} else {
			$whr = " AND user_id ='" . $user_id . "' ";
		}
		$where = "status = 1 AND code != '' AND company_code != '' AND company_code IS NOT NULL AND code is NOT NULL AND code != '0' " . $whr . " AND code LIKE '%" . $partytype_id . "%'";
		$this->db->select( "id,name,phone,code,email_id,company_code,branch_code" );
		$this->db->from( "tb_customers" );
		$this->db->where( $where );
		$this->db->group_by( 'id' );
		$this->db->order_by( 'createdon', 'DESC' );
		$chkqry = $this->db->get();

		if ( $chkqry->num_rows() > 0 ) {
			foreach ( $chkqry->result() as $res ) {
				$parties[] = array( 'id' => $res->id, 'party_id' => $res->code, 'name' => $res->name, 'phone' => $res->phone, 'email' => $res->email_id, 'company_code' => $res->company_code, 'branch_code' => $res->branch_code );
			}
		}
		if ( $company_code != "" ) {
			$getorder_types = $this->db->select( "id,type_name" )->get_where( "tb_order_types", array( 'company_code' => $company_code, 'status' => '1' ) );
			if ( $getorder_types->num_rows() > 0 ) {
				foreach ( $getorder_types->result() as $res ) {
					$parties['ordparties'][] = array( 'type_id' => $res->id, 'type_name' => $res->type_name );
				}
			}
		}
		echo json_encode( $parties );
	}

	public function getconsigneeID() {

		$user_id        = 1;
		$parties        = array();
		$code           = $this->input->post( 'partytype_id',true );
		$user_id        = $this->session->userdata( 'user_id' );
		$custid         = "0";
		$party_type     = isset( $_POST['type'] ) ? $_POST['type'] : "";
		$whr            = "";
		$chkcompanycode = $this->session->userdata( 'company_code' );
		$company_code   = $this->session->userdata( 'company_code' );
		if ( $chkcompanycode != 'NZKN' ) {
			if ( $this->session->userdata( 'cust_id' ) !== FALSE ) {
				$custid = $this->session->userdata( 'cust_id' );
			}
			$subcusts = array();
			if ( $custid != 0 ) {
				if ( $this->session->userdata( 'sub_cust' ) !== FALSE ) {
					$subcusts = $this->session->userdata( 'sub_cust' );
					if ( count( $subcusts ) > 0 ) {
						array_push( $subcusts, $custid );
					} else {
						$subcusts = $custid;
						// array_push($subcusts, $custid);
					}
				} else {
					$subcusts = $custid;
					// array_push($subcusts, $custid);
				}
			}
			$customer_code = array();
			if ( ! empty( $subcusts ) ) {
				$select          = "code";
				$table           = "tb_customers";
				$customerdetails = $this->transacmodel->getcustomercodebyids( $select, $table, $subcusts );
				if ( ! empty( $customerdetails ) ) {
					foreach ( $customerdetails as $cust ) {
						$customer_code[] = $cust['code'];
					}
				}
			}
			if ( ! empty( $customer_code ) ) {
				$whr = "AND m.customer_code IN ('" . implode( "','", $customer_code ) . "') ";
			}
		}
		$party_type_whr = "";
		if ( $party_type != "" ) {
			$party_type_whr = " AND p.name LIKE '" . $party_type . "' ";
		}
		$master_ids = array();
		if ( $company_code == 'RUKN' ) {
			$where = "m.code LIKE '%" . $code . "%' AND m.company_code LIKE '" . $company_code . "' AND m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.code IS NOT NULL AND m.code != '' AND m.code !='0' AND m.branch_code IS NOT NULL  AND m.status='1' " . $party_type_whr . " " . $whr;
		} else {
			$where = "m.code LIKE '%" . $code . "%' AND m.user_id='" . $user_id . "' AND m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.code IS NOT NULL AND m.code != '' AND m.code !='0' AND m.branch_code IS NOT NULL  AND m.status='1' " . $party_type_whr . " " . $whr;
		}


		$this->db->select( "m.id,m.code" );
		$this->db->from( "tbl_party_master m" );
		$this->db->join( "tbl_party_types p", "p.id=m.party_type_id", "LEFT" );
		$this->db->where( $where );
		$this->db->group_by( 'm.id' );
		$this->db->order_by( 'm.id', 'DESC' );
		$chkqry = $this->db->get();
		if ( $chkqry->num_rows() > 0 ) {
			foreach ( $chkqry->result() as $res ) {
				$master_ids[] = $res->id;
				$parties[]    = array( 'id' => $res->id, 'party_id' => $res->code );
			}
		}
		$additional_ids = array();
		if ( ! empty( $master_ids ) ) {
			$mwhr = "m.id NOT IN (" . implode( ',', $master_ids ) . ") AND ";
		} else {
			$mwhr = "";
		}
		if ( $company_code == "RUKN" ) {
			$getmultipleparties = $this->db->query( "SELECT m.id as master_id,m.party_types FROM tbl_party_master m WHERE " . $mwhr . " m.code LIKE '%" . $code . "%'  AND m.company_code LIKE '" . $company_code . "' AND m.party_types IS NOT NULL" );
		} else {
			$getmultipleparties = $this->db->query( "SELECT m.id as master_id,m.party_types FROM tbl_party_master m WHERE " . $mwhr . " m.code LIKE '%" . $code . "%'  AND m.user_id ='" . $user_id . "' AND m.party_types IS NOT NULL" );
		}

		if ( $getmultipleparties->num_rows() > 0 ) {
			foreach ( $getmultipleparties->result() as $res ) {
				$party_types = explode( ',', $res->party_types );
				if ( ! empty( $party_types ) ) {
					$chkshipper = $this->db->query( "SELECT id FROM tbl_party_types WHERE id IN (" . implode( ',', $party_types ) . ") AND name LIKE '" . $party_type . "'" );
					if ( $chkshipper->num_rows() > 0 ) {
						$additional_ids[] = $res->master_id;
					}
				}
			}
		}
		if ( ! empty( $additional_ids ) ) {
			if ( $company_code == 'RUKN' ) {
				$get_addids = $this->db->query( "SELECT m.id as master_id,m.code FROM tbl_party_master m WHERE m.id IN (" . implode( ',', $additional_ids ) . ") AND m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.branch_code IS NOT NULL AND m.company_code LIKE '" . $company_code . "' AND m.parent_id ='0'  AND m.status=1 ANd m.code != '' AND m.code is NOT NULL AND m.code != '0' GROUP BY m.id ORDER BY m.id DESC" );
			} else {
				$get_addids = $this->db->query( "SELECT m.id as master_id,m.code FROM tbl_party_master m WHERE m.id IN (" . implode( ',', $additional_ids ) . ") AND m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.branch_code IS NOT NULL AND m.user_id='" . $user_id . "' AND m.parent_id ='0'  AND m.status=1 ANd m.code != '' AND m.code is NOT NULL AND m.code != '0' GROUP BY m.id ORDER BY m.id DESC" );
			}

			if ( $get_addids->num_rows() > 0 ) {
				foreach ( $get_addids->result() as $res ) {
					$master_ids[] = $res->master_id;
					$parties[]    = array( 'id' => $res->master_id, 'party_id' => $res->code );
				}
			}
		}

		echo json_encode( $parties );

	}

	public function getconsigneedetailsbyID() {
		$user_id      = 1;
		$parties      = array();
		$code         = $this->input->post( 'id',true );
		$company_code = $this->session->userdata( 'company_code' );
		$user_id      = $this->session->userdata( 'user_id' );
		$where        = array();
		if ( $company_code == 'RUKN' ) {
			$where['company_code'] = $company_code;
		} else {
			$where['user_id'] = $user_id;
		}
		$this->db->select( "id,name,email,street,location_id as city,state,mobile,pincode,country,code,fax" );
		$this->db->from( "tbl_party_master" );
		$this->db->where( array( "code" => $code ) );
		if ( ! empty( $where ) ) {
			$this->db->where( $where );
		}
		$this->db->order_by( "id", "DESC" );
		$chkqry = $this->db->get();
		if ( $chkqry->num_rows() > 0 ) {
			$parties[] = array(
				'id'       => $chkqry->row()->id,
				'name'     => $chkqry->row()->name,
				'phone'    => $chkqry->row()->mobile,
				'street'   => $chkqry->row()->street,
				'city'     => $chkqry->row()->city,
				'pincode'  => $chkqry->row()->pincode,
				'code'     => $chkqry->row()->code,
				'country'  => $chkqry->row()->country,
				'email_id' => $chkqry->row()->email,
				'fax'      => $chkqry->row()->fax,
				'state'    => $chkqry->row()->state
			);
		}

		echo json_encode( $parties );
	}

	public function savequicktrade() {
		$cdate                = date( 'Y-m-d H:i:s' );
		$user_id              = $this->session->userdata( 'user_id' );
		$cust_id              = $this->session->userdata( 'cust_id' );
		$company_code         = isset( $_POST['company_code'] ) ? $_POST['company_code'] : "";
		$branch_code          = isset( $_POST['branch_code'] ) ? $_POST['branch_code'] : "";
		$department_code      = isset( $_POST['department_code'] ) ? $_POST['department_code'] : "";
		$mobile              = isset( $_POST['mobile'] ) ? $_POST['mobile'] : "";

		$customer_notification = isset( $_POST['customer_notification'] ) ? $_POST['customer_notification'] : "";
		$knadmin_notification = isset( $_POST['knadmin_notification'] ) ? $_POST['knadmin_notification'] : "";

		if($customer_notification == '' && $knadmin_notification == ''){
			$email_notification = 0;
		}elseif($customer_notification != '' && $knadmin_notification == ''){
			$email_notification = 1;
		}elseif($customer_notification == '' && $knadmin_notification != ''){
			$email_notification = 2;
		}elseif($customer_notification != '' && $knadmin_notification != ''){
			$email_notification = 3;
		}

		$permit_requested_by  = isset( $_POST['permit_requested_by'] ) ? $_POST['permit_requested_by'] : "";
		$type_of_declaration  = isset( $_POST['type_of_declaration'] ) ? $_POST['type_of_declaration'] : "";
		$frieght_charge       = isset( $_POST['frieght_charge'] ) ? $_POST['frieght_charge'] : "";
		$transport_mode       = isset( $_POST['transport_mode'] ) ? $_POST['transport_mode'] : "";
		$other_remarks        = isset( $_POST['other_remarks'] ) ? $_POST['other_remarks'] : "";
		$gateway              = isset( $_POST['gateway'] ) ? $_POST['gateway'] : "";
		$coo                  = isset( $_POST['coo'] ) ? $_POST['coo'] : "";
         $type_of_coo          = isset( $_POST['type_of_coo'] ) ? $_POST['type_of_coo'] : "";
        $coo_shipment_numbers = isset( $_POST['coo_shipment_numbers'] ) ? $_POST['coo_shipment_numbers'] : "";
        $port_of_loading      = isset( $_POST['port_of_loading'] ) ? $_POST['port_of_loading'] : "";
        $uom_qty              = isset( $_POST['uom_qty'] ) ? $_POST['uom_qty'] : "";
        $destination_country  = isset( $_POST['destination_country'] ) ? $_POST['destination_country'] : "";
		$dg_cargo             = isset( $_POST['dg_cargo'] ) ? $_POST['dg_cargo'] : "";
		$bonded               = isset( $_POST['bonded'] ) ? $_POST['bonded'] : "";
		$shipment             = isset( $_POST['shipment'] ) ? $_POST['shipment'] : "";
		$routing_type         = isset( $_POST['routing_type'] ) ? $_POST['routing_type'] : "";
		$routing_id           = isset( $_POST['routing_id'] ) ? $_POST['routing_id'] : "";
		$ref_type             = isset( $_POST['ref_type'] ) ? $_POST['ref_type'] : "";
		$ref_value            = isset( $_POST['ref_value'] ) ? $_POST['ref_value'] : "";
		$trade_status         = isset( $_POST['trade_status'] ) ? $_POST['trade_status'] : "0";
		$round_document_id    = isset( $_POST['round_document_id'] ) ? $_POST['round_document_id'] : "";


		$get_country = $this->db->select('country_code,company_code')->get_where("tb_users", array(
            'id' => $user_id
        ));
        $country_code = $get_country->row()->country_code;

        if($cust_id ==''){
        	$cust_id  = $this->session->userdata( 'user_id' );
        }


		$trans_arr    = array(
			'user_id'             => $user_id,
			'customer_id'         => $cust_id,
			'mobile'              => $mobile,
			'permit_requested_by' => $permit_requested_by,
			'company_code'        => $company_code,
			'branch_code'         => $branch_code,
			'department_code'     => $department_code,
			'type_of_declaration' => $type_of_declaration,
			'frieght_charge'      => $frieght_charge,
			'transport_mode'      => $transport_mode,
			'other_remarks'       => $other_remarks,
			'gateway'             => $gateway,
			'coo_required'        => $coo,
            'type_of_coo'         => $type_of_coo,
            'coo_shipment_numbers'=> $coo_shipment_numbers,
            'port_of_loading'     => $port_of_loading,
            'uom_qty'             => $uom_qty,
            'destination_country' => $destination_country,
			'dg_cargo'            => $dg_cargo,
			'bonded'              => $bonded,
			'shipment'            => $shipment,
			'routing_type'        => $routing_type,
			'routing_id'          => $routing_id,
			'ref_type'            => $ref_type,
			'ref_value'           => $ref_value,
			'transaction_status'  => $trade_status,
			'email_notification'  => $email_notification,
			'createdby'           => $user_id,
			'createdon'           => date( 'Y-m-d H:i:s' ),
		);

		$trans_ins   = $this->db->insert( "tb_trade_transactions", $trans_arr );




		$trans_id     = $this->db->insert_id();
		if($trans_id > 0){
			$genord = array(
                "user_id" => $user_id,
                "trans_id" => $trans_id,
                "country_code" => $country_code,
                "company_code" => $company_code
            );
        $transaction_id = $this->generatetransactionid($genord);

         if ( $transaction_id != ''){
		 $upd   = $this->db->where( array( 'id' => $trans_id ) )->update( "tb_trade_transactions", array( 'transaction_id' => $transaction_id ) );


		 if ($round_document_id != "") {
				$doc_ids = array();
				$doc_ids = explode(',', $round_document_id);
				for ($i = 0; $i < count($doc_ids); $i++) {
				$this->db->where(array('id'=>$doc_ids[$i]))->update('tb_doc_trade',array('transaction_id'=>$trans_id));
				}
			}


		}

		}
        $this->session->set_flashdata('success_msg', 'Transaction Created Successfully - ' . $transaction_id);
		redirect( "transactions" );

	}

	public function delete($id){
		 if ($id != '') {
            $this->db->where('id', $id);
            $this->db->set('status', 1);
            $result = $this->db->update('tb_trade_transactions');
            if ($result) {
                echo "1";
            } else {
                echo "0";
            }
        }
	}

	public function saverdocument($id = null){
        $user_id = $this->session->userdata('user_id');
        $post   = array();
		$post   = $this->input->post(NULL, TRUE);
		/* log_message('error',"post data:".json_encode($post)); */
        $data = array();
		$selectdoctype=isset($post['selectdoctype']) ? $post['selectdoctype'] : 0;

		//$file_name=isset($post['file_name']) ? $post['file_name'] : 0;

			 if (isset($_FILES)) {
        if (isset($_FILES['file_name']['name'])) {
            $config = array('upload_path'   => NEW_POD_PATH,
                'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG'
            );
            $file_name = $_FILES['file_name']['name'];
            $file_ext= @strtolower(end(explode('.',$_FILES['file_name']['name'])));
            $expensions= array("jpeg","jpg","png","gif","pdf");
            if(in_array($file_ext,$expensions)){
                if($file_ext == "pdf"){
                    $imgtype = "pdf";
                    $config['file_name'] = "RL".$selectdoctype.".pdf";
                    $this->load->library('upload', $config);
                    if ($this->upload->do_upload('file_name')) {
                        $imgname = $this->upload->data();
                        $imgtype = $imgname['image_type'];
                        $fileName = $imgname['file_name'];
                        $filePath = NEW_POD_PATH.$fileName;
                    }
                }else{
                    $fileName = date('dmyhis').''.$file_name;
                    $filePath = NEW_POD_PATH.$fileName;
                    $imgsize = getimagesize($_FILES['file_name']['tmp_name']);
                    if($imgsize == FALSE){ }else{
                        /*log_message("error","imgupload ".json_encode($_FILES));*/
                        $top_width = $imgsize[0];
                        $top_height = $imgsize[1];
                        $quality = 100;
                        if($file_ext == "png"){
                            $top = @imagecreatefrompng($_FILES['file_name']['tmp_name']);
                            $imgtype = "png";
                        }else{
                            $top = @imagecreatefromjpeg($_FILES['file_name']['tmp_name']);
                            if($file_ext == "jpg" || $file_ext == "jpeg"){
                                $imgtype = "jpeg";
                            }else{
                                $imgtype = $file_ext;
                            }
                        }
                        if($top){
                            header('Content-Type: image/jpeg');
                            @imagejpeg($top,$filePath,$quality);
                            @imagedestroy($top);
                        }else{
                            $fileName = "";
                            $sts = "2";
                        }
                    }
                }

                    $chrdata = array('filename' => $fileName,'createdby'=>$this->session->userdata( 'user_id' ) , 'createdon'=>date('Y-m-d H:i'),'doctype_id' => $selectdoctype,'status' => 0);


					if ($id == null) {
					$chrdata['transaction_id']=0;
					}else{
					$chrdata['transaction_id']=$id;
					}

					$result = $this->common->insertTableData("tb_doc_trade", $chrdata);
					$data= $result;

			}
		}
		}


		echo json_encode($data);

	}

    public function showdocumentdetails()
    {
    	$post   = array();
		$post   = $this->input->post(NULL, TRUE);
        $ids = isset($post['document_ids']) ? $post['document_ids'] : "";
        $data = array();
            if (! empty($ids)) {
                $qry = $this->db->query("SELECT * FROM tb_doc_trade WHERE id IN (" . $ids . ") AND status='0' GROUP BY id ORDER BY id DESC");
                if ($qry->num_rows() > 0) {

                    foreach ($qry->result() as $res) {
                        // extract($res);
						$filename="";
						$allowed =  array('pdf');
						$chk_e = $this->db->select('id,type_name')->get_where('tb_document_types', array(
                            'id' => $res->doctype_id
                        ));
                        if ($chk_e->num_rows() > 0) {
                            $exch_id = $chk_e->row()->type_name;
                            $exchid = $chk_e->row()->id;
                        }
                        $exch_id1 = '"' . $exchid . '"';
						if($res->filename != ""){
                            $base64DocumentData = getBase64DocumentData($res->filename);
                            $extention = $base64DocumentData['extention'];
                            $stringData = "'".$base64DocumentData['file_content']."',"."'".$extention."'";
                            if ($extention!= "") {
                                if (in_array($extention, $allowed)) {
                                    $path = '<a onclick="return downloadDocument(' . $stringData . ')"> <img src="' . base_url('assets/img/docstore.png') . '" class="img-responsive" style="width: 10%;" type="application/pdf"></a>';
                                } else {
                                    $path = '<a onclick="return downloadDocument(' . $stringData . ')"><img src="' . $base64DocumentData['file_content'] . '" class="img-responsive" style="width: 10%;"></a>';
                                }
                            }

                    $createdon=$res->createdon;

                    $action     = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deleteDocumentdetail(this," . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowaddDocument(this);'><span class='glyphicon glyphicon-plus' > </span>Add Doc</a></li> ";
                     $data[] = array(
					        'document_type' => $exch_id,
                            'file' => $path,
                             'createdon' => $createdon,
                            'action' => $action
                        );
                }
                    }
                }

        }
        echo json_encode($data);
    }

    public function deletedocumentdetails()
    {
    	$post   = array();
		$post   = $this->input->post(NULL, TRUE);
        $id = isset($post['id']) ? $post['id'] : '0';
        if ($id != '0') {
            $chk = $this->db->select('id')->get_where('tb_doc_trade', array(
                'id' => $id
            ));
            if ($chk->num_rows() > 0) {

                $upd = $this->db->where(array(
                    'id' => $id
                ))->update('tb_doc_trade', array(
                    'status' => 1
                ));
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        } else {
            echo "0";
        }
    }

    public function showdocumentviewdetails(){
	try {
        $trasaction_ids = isset($_POST['trasaction_id']) ? $_POST['trasaction_id'] : "";
		//$trasaction_id = $this->input->post('trasaction_id');
        $data = array();
		 //$charge_code = $tier_code="";
                $qry = $this->db->query("SELECT * FROM tb_doc_trade WHERE transaction_id IN (" . $trasaction_ids . ") AND status='0'");
                if ($qry->num_rows() > 0) {

                    foreach ($qry->result() as $res) {
                        // extract($res);
						$filename="";
						$allowed =  array('pdf');
						$chk_e = $this->db->select('id,type_name')->get_where('tb_document_types', array(
                            'id' => $res->doctype_id
                        ));
                        if ($chk_e->num_rows() > 0) {
                            $exch_id = $chk_e->row()->type_name;
                            $exchid = $chk_e->row()->id;
                        }

						if($res->filename != ""){
                    $ext = pathinfo($res->filename, PATHINFO_EXTENSION);
                    $imglink = checkimageintmsorknlmv($res->filename);
                    if($imglink != ""){
                        if(in_array($ext,$allowed)){
                            $path = '<a target="_blank" href="'.$imglink.'"> <img src="'.base_url('assets/img/docstore.png').'" class="img-responsive" style="width: 10%;" type="application/pdf"></a>';
                        }else{
                            $path = '<a target="_blank" href="'.$imglink.'"><img src="'.$imglink.'" class="img-responsive" style="width: 10%;"></a>';
                        }
                    }

                     $createdon=$res->createdon;
                      $action     = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deleteDocumentdetailedit(this," . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowaddDocument(this);'><span class='glyphicon glyphicon-plus' > </span>Add Doc</a></li> ";

                     $data[] = array(
					        'document_type' => $exch_id,
                            'file' => $path ,
                             'createdon' => $createdon ,
                             'action' => $action


                        );
                }
                    }

            }

        echo json_encode($data);
		} catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

	public function viewpartylist()
    {
        $parties =  $post =array();
        $user_id = $this->session->userdata('user_id');
         $post = $this->input->post(NULL,TRUE);
        $type = isset($post['type']) ? $post['type'] : "0";
        $party_type = isset($post['party']) ? $post['party'] : "";
        $customer_id = isset($post['customer_id']) ? $post['customer_id'] : "0";
        $check = "";
        $custid = "0";
        $whr = $usrwhr = "";
        if ($customer_id == "") {
            $customer_id = 0;
        }
        $chkcompanycode = $this->session->userdata('company_code');
        $permission = checkuserpermissions();
        if (in_array("businesspartners", $permission)) {
            $usrwhr = "";
        } else {
            $usrwhr = " AND m.user_id='" . $user_id . "' ";
        }
       /* if ($chkcompanycode != 'NZKN') {
            if ($this->session->userdata('cust_id') !== FALSE) {
                $custid = $this->session->userdata('cust_id');
            }
            $subcusts = array();
            if ($custid != 0) {
                if ($this->session->userdata('sub_cust') !== FALSE) {
                    $subcusts = $this->session->userdata('sub_cust');
                    if (count($subcusts) > 0) {
                        array_push($subcusts, $custid);
                    } else {
                        $subcusts = $custid;
                        // array_push($subcusts, $custid);
                    }
                } else {
                    $subcusts = $custid;
                    // array_push($subcusts, $custid);
                }
            }
            $customer_code = array();
            if (! empty($subcusts)) {
                $select = "code";
                $table = "tb_customers";
                $customerdetails = $this->Order->getcustomercodebyids($select, $table, $subcusts);
                if (! empty($customerdetails)) {
                    foreach ($customerdetails as $cust) {
                        $customer_code[] = $cust['code'];
                    }
                }
            }
            if (! empty($customer_code)) {
                $whr = "AND m.customer_code IN ('" . implode("','", $customer_code) . "') ";
            }
        }*/
        $party_type_whr = " ";
        if ($party_type != "") {
            $party_type_whr = " AND t.name LIKE '" . $party_type . "' ";
        }

        $contact_ids = $master_ids = array();
        if ($customer_id != '0') {
            $getid = $this->common->gettblrowdata(array(
                'code' => $customer_id
            ), "id", 'tbl_party_master', 0, 0);
            if (! empty($getid)) {
                $customer_row_id = $getid['id'];
                $get_custparties = $this->db->query("SELECT m.id as master_id,m.name as master_name,m.email as master_email_id,m.mobile as master_mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.country,m.street,t.name as party_name FROM tbl_party_master m,tbl_party_types t WHERE  m.company_code != '' AND m.company_code IS NOT NULL AND m.company_code LIKE '" . $chkcompanycode . "' AND m.branch_code != '' AND m.branch_code IS NOT NULL " . $usrwhr . " AND m.parent_id ='" . $customer_row_id . "' AND m.status=1 ANd m.code != '' AND m.code is NOT NULL AND m.code != '0' AND t.id=m.party_type_id  GROUP BY m.id ORDER BY m.id DESC");

                if ($get_custparties->num_rows() > 0) {
                    foreach ($get_custparties->result() as $res) {
                        if ($type == '1') {
                            $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                        } else {
                            $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                        }
                        $contact_ids[] = $res->master_id;
                        $master_ids[] = $res->master_id;
                        $parties[] = array(
                            'check' => $check,
                            'id' => $res->code,
                            'name' => $res->master_name,
                            'email' => $res->master_email_id,
                            'mobile' => $res->master_mobile,
                            'party_name' => $res->party_name,
                            'company_code' => $res->company_code,
                            'branch_code' => $res->branch_code,
                            'party_name' => $party_type,
                            'city' => $res->city,
                            'country' => $res->country,
                            'street' => $res->street
                        );
                    }
                }
            }
        }

        $get_parties = $this->db->query("SELECT m.id as master_id,m.name as master_name,m.email as master_email_id,m.mobile as master_mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.country,m.street,t.name as party_name FROM tbl_party_master m,tbl_party_types t WHERE m.company_code != '' AND m.company_code IS NOT NULL AND m.company_code LIKE '" . $chkcompanycode . "' AND m.branch_code != '' AND m.branch_code IS NOT NULL " . $whr . " " . $usrwhr . " AND m.parent_id ='0'  AND m.status=1 ANd m.code != '' AND m.code is NOT NULL AND m.code != '0' AND t.id=m.party_type_id " . $party_type_whr . " GROUP BY m.id ORDER BY m.id DESC");
        if ($get_parties->num_rows() > 0) {
            foreach ($get_parties->result() as $res) {
                if ($type == '1') {
                    $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                } else {
                    $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                }
                $master_ids[] = $res->master_id;
                $parties[] = array(
                    'check' => $check,
                    'id' => $res->code,
                    'name' => $res->master_name,
                    'email' => $res->master_email_id,
                    'mobile' => $res->master_mobile,
                    'party_name' => $res->party_name,
                    'company_code' => $res->company_code,
                    'branch_code' => $res->branch_code,
                    'party_name' => $res->party_name,
                    'city' => $res->city,
                    'country' => $res->country,
                    'street' => $res->street
                );
            }
        }
        $master_whr = "";
        $additional_ids = $party_types = array();
        if (! empty($master_ids)) {
            $master_whr = "AND m.id NOT IN (" . implode(',', $master_ids) . ")  ";
        }
        $getmultipleparties = $this->db->query("SELECT m.id as master_id,m.party_types FROM tbl_party_master m WHERE m.code IS NOT NULL " . $master_whr . " " . $whr . " " . $usrwhr . " AND m.party_types IS NOT NULL");
        if ($getmultipleparties->num_rows() > 0) {
            foreach ($getmultipleparties->result() as $res) {
                if ($res->party_types != "" && $res->party_types != '0') {
                    $party_types = explode(',', $res->party_types);
                    if (is_array($party_types)) {
                        if (! empty($party_types)) {
                            $chkshipper = $this->db->query("SELECT id FROM tbl_party_types WHERE id IN (" . implode(',', $party_types) . ") AND name LIKE '" . $party_type . "'");
                            if ($chkshipper->num_rows() > 0) {
                                $additional_ids[] = $res->master_id;
                            }
                        }
                    }
                }
            }
        }

        if (! empty($additional_ids)) {
            $get_addids = $this->db->query("SELECT m.id as master_id,m.name as master_name,m.email as master_email_id,m.mobile as master_mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.country,m.street FROM tbl_party_master m WHERE m.id IN (" . implode(',', $additional_ids) . ") AND m.company_code != '' AND m.company_code IS NOT NULL AND m.company_code LIKE '" . $chkcompanycode . "' AND m.branch_code != '' AND m.branch_code IS NOT NULL  " . $usrwhr . " AND m.parent_id ='0'  AND m.status=1 ANd m.code != '' AND m.code is NOT NULL AND m.code != '0' GROUP BY m.id ORDER BY m.id DESC");
            if ($get_addids->num_rows() > 0) {
                foreach ($get_addids->result() as $res) {
                    if ($type == '1') {
                        $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                    } else {
                        $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                    }
                    $master_ids[] = $res->master_id;
                    $parties[] = array(
                        'check' => $check,
                        'id' => $res->code,
                        'name' => $res->master_name,
                        'email' => $res->master_email_id,
                        'mobile' => $res->master_mobile,
                        'party_name' => $party_type,
                        'company_code' => $res->company_code,
                        'branch_code' => $res->branch_code,
                        'party_name' => $party_type,
                        'city' => $res->city,
                        'country' => $res->country,
                        'street' => $res->street
                    );
                }
            }
        }

        echo json_encode($parties);
    }

    public function getconsigneedetailsListbyID()
    {
        $user_id = 1;
        $parties = array();
        $code = $this->input->post('id',true);
        $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');
        $whr = "";
        if ($company_code == 'RUKN') {
            $whr = " AND p.company_code LIKE '" . $company_code . "' ";
        } else {
            $whr = " AND p.user_id='" . $user_id . "' ";
        }
        $chkqry = $this->db->query("SELECT p.id,p.party_type_id,p.name,p.email,p.street,p.location_id as city,p.state,p.mobile,p.address,p.pincode,p.country,p.code,p.fax FROM tbl_party_master p WHERE p.code LIKE '" . $code . "' " . $whr . " ORDER BY p.id DESC");
        if ($chkqry->num_rows() > 0) {
            $role_name = "";
            $getrolename = $this->db->select('name')->get_where("tbl_party_types", array(
                'id' => $chkqry->row()->party_type_id
            ));
            if ($getrolename->num_rows() > 0) {
                $role_name = $getrolename->row()->name;
            }
            $parties[] = array(
                'id' => $chkqry->row()->id,
                'name' => $chkqry->row()->name,
                'phone' => $chkqry->row()->mobile,
                'street' => $chkqry->row()->street,
                'city' => $chkqry->row()->city,
                'pincode' => $chkqry->row()->pincode,
                'code' => $chkqry->row()->code,
                'country' => $chkqry->row()->country,
                'email_id' => $chkqry->row()->email,
                'fax' => $chkqry->row()->fax,
                'state' => $chkqry->row()->state,
                'address' => $chkqry->row()->address,
                'party_type_id' => $chkqry->row()->party_type_id,
                'role_name' => $role_name
            );
        }
        echo json_encode($parties);
    }

    public function getshipperdetailsbyID()
    {
        $parties = array();
        $code = $this->input->post('id',true);
        $customer_id = "";
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        if ($company_code == 'RUKN') {
            $chkqry = $this->db->select("id,name,phone,location,address,street,location,state,pincode,code,country,email_id,fax,company_code,branch_code")->get_where("tb_customers", array(
                'code' => $code,
                'company_code' => $company_code,
                'status' => '1'
            ));
        } else {
            $chkqry = $this->db->select("id,name,phone,location,address,street,location,state,pincode,code,country,email_id,fax,company_code,branch_code")->get_where("tb_customers", array(
                'code' => $code,
                'user_id' => $user_id,
                'status' => '1'
            ));
        }

        if ($chkqry->num_rows() > 0) {
            $customer_id = $chkqry->row()->id;
            $parties['customer_details'][] = array(
                'id' => $chkqry->row()->id,
                'name' => $chkqry->row()->name,
                'phone' => $chkqry->row()->phone,
                'street' => $chkqry->row()->street,
                'city' => $chkqry->row()->location,
                'pincode' => $chkqry->row()->pincode,
                'code' => $chkqry->row()->code,
                'country' => $chkqry->row()->country,
                'email_id' => $chkqry->row()->email_id,
                'fax' => $chkqry->row()->fax,
                'state' => $chkqry->row()->state,
                'location' => $chkqry->row()->location,
                'address' => $chkqry->row()->address,
                'company_code' => $chkqry->row()->company_code,
                'branch_code' => $chkqry->row()->branch_code
            );
        }

        $parties['ordparties'] = array();
        if ($customer_id != "") {
            $getorder_types = $this->db->select("id,type_name")
                ->group_by('type_name')
                ->get_where("tb_order_types", array(
                'customer_id' => $customer_id,
                'status' => '1',
                'company_code' => $company_code
            ));
            if ($getorder_types->num_rows() > 0) {
                foreach ($getorder_types->result() as $res) {
                    $parties['ordparties'][] = array(
                        'type_id' => $res->id,
                        'type_name' => $res->type_name
                    );
                }
            } else {
                $getorders = $this->db->select("id,type_name")
                    ->group_by("type_name")
                    ->get_where("tb_order_types", array(
                    'company_code' => $company_code,
                    "status" => 1
                ));
                if ($getorders->num_rows() > 0) {
                    foreach ($getorders->result() as $res) {
                        $parties['ordparties'][] = array(
                            'type_id' => $res->id,
                            'type_name' => $res->type_name
                        );
                    }
                } else {
                    $getorders = $this->db->select("id,type_name")
                        ->group_by("type_name")
                        ->get_where("tb_order_types", array(
                        'company_code' => "SGKN",
                        "status" => 1
                    ));
                    if ($getorders->num_rows() > 0) {
                        foreach ($getorders->result() as $res) {
                            $parties['ordparties'][] = array(
                                'type_id' => $res->id,
                                'type_name' => $res->type_name
                            );
                        }
                    }
                }
            }
        }

        echo json_encode($parties);
    }

    public function getconsigneedetailsListbyIDnew($code)
    {
        $user_id = 1;
        $parties = array();
        $code = $code;
        $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');
        $whr = "";
        if ($company_code == 'RUKN') {
            $whr = " AND p.company_code LIKE '" . $company_code . "' ";
        } else {
            $whr = " AND p.user_id='" . $user_id . "' ";
        }
        $chkqry = $this->db->query("SELECT p.id,p.party_type_id,p.name,p.email,p.street,p.location_id as city,p.state,p.mobile,p.address,p.pincode,p.country,p.code,p.fax FROM tbl_party_master p WHERE p.code LIKE '" . $code . "' " . $whr . " ORDER BY p.id DESC");
        if ($chkqry->num_rows() > 0) {
            $role_name = "";
            $getrolename = $this->db->select('name')->get_where("tbl_party_types", array(
                'id' => $chkqry->row()->party_type_id
            ));
            if ($getrolename->num_rows() > 0) {
                $role_name = $getrolename->row()->name;
            }
            $parties[] = array(
                'id' => $chkqry->row()->id,
                'name' => $chkqry->row()->name,
                'phone' => $chkqry->row()->mobile,
                'street' => $chkqry->row()->street,
                'city' => $chkqry->row()->city,
                'pincode' => $chkqry->row()->pincode,
                'code' => $chkqry->row()->code,
                'country' => $chkqry->row()->country,
                'email_id' => $chkqry->row()->email,
                'fax' => $chkqry->row()->fax,
                'state' => $chkqry->row()->state,
                'address' => $chkqry->row()->address,
                'party_type_id' => $chkqry->row()->party_type_id,
                'role_name' => $role_name
            );
        }
        return $parties;
    }

    function generatetransactionid($transinfo=array()){
        $transaction_id = "";
        if(!empty($transinfo)){
            $userid = $transinfo['user_id'];
            $countrycode = $transinfo['country_code'];
            $company_code = $transinfo['company_code'];
            $trans_id = $transinfo['trans_id'];
            $tz = getUserTimeZone($countrycode);
            $country_code = $tz['phone_code'];
            $cdate = new DateTime("now", new DateTimeZone(DFLT_TZ));
            $year = $cdate->format('y');
            $week = $cdate->format('W');
            $codeyear = $country_code.$year;
            $ci = &get_instance();
            $previd = $ci->db->query("SELECT transaction_id FROM tb_trade_transactions WHERE id < '".$trans_id."' AND (transaction_id LIKE '" . $codeyear . "%' AND company_code LIKE '".$company_code."') ORDER BY id DESC LIMIT 1");
            if($previd->num_rows() > 0) {
                $week_orderno = $previd->row()->transaction_id;
                $cn_length = strlen($country_code);
                $wcount = $cn_length + 2;
                $prev_weekno = mb_substr($week_orderno, $wcount, 2);
                $ycount = $wcount+2;
                $prev_ordno = mb_substr($week_orderno, $ycount, 5);
                $id = ltrim($prev_ordno, 0);
                if ($prev_weekno < $week) {
                    $id = '0001';
                } else {
                    $i_id = $id;
                    $i_id++;
                    $idlength = strlen($i_id);
                    if ($idlength == '1') {
                        $id = "000" . $i_id;
                    } else if ($idlength == '2') {
                        $id = "00" . $i_id;
                    } else if ($idlength == '3') {
                        $id = "0" . $i_id;
                    } else if ($idlength == '4') {
                        $id = $i_id;
                    } else {
                        $id = $i_id;
                    }
                }
                $transaction_id = $country_code.$year.$week.$id;
                $chk = $ci->db->query("SELECT transaction_id FROM tb_trade_transactions WHERE transaction_id='".$transaction_id ."' ORDER BY id DESC LIMIT 1");
                if($chk->num_rows() > 0){
                    $iid = $id;
                    $iid++;
                    $ii_d = $iid;
                    $id_length = strlen($iid);
                    if ($id_length == '1') {
                        $ii_d = "000" . $iid;
                    } else if ($id_length == '2') {
                        $ii_d = "00" . $iid;
                    } else if ($id_length == '3') {
                        $ii_d = "0" . $iid;
                    } else if ($id_length == '4') {
                        $ii_d = $iid;
                    } else {
                        $ii_d = $iid;
                    }
                    $transaction_id = $country_code.$year.$week.$ii_d;
                }
            }else{
                $i_id = 1;
                $id = '000'.$i_id;
                $transaction_id = $country_code.$year.$week.$id;
            }
        }
        return $transaction_id;
    }




}

?>
