<?php

defined('BASEPATH') or exit('No direct script access allowed');

use App\Controllers\AuthenticatedUserAbstract\AuthenticatedUserAbstract;

class Transportwaybillforwarder extends AuthenticatedUserAbstract
{
    private $mpdf;

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('log');
    }

    public function index(int $shiftid = 0, bool $sign = true, bool $sendemail = false, int $customer_id = 0, bool $waybill = false): void
    {
        $this->load->model('Transportwaybillforwardermodel', 'transportwaybillforwardermodel');
        $transportwaybillcontent = $this->transportwaybillforwardermodel->getOrderInfo($shiftid, $customer_id);
        if (!$transportwaybillcontent['transaction_status']) {
            log_error('Unable to perform transportwaybillforwarder pdf generation, Please try again.');
            return;
        }
        if (!empty($transportwaybillcontent)) {
            $this->mpdf = new \Mpdf\Mpdf([
                'default_font_size' => 9,
                'tempDir' => FCPATH . 'assets/tmp',
                'format' => 'legal',
            ]);
            $this->mpdf->setAutoBottomMargin = 'false';
            $common_info = $transportwaybillcontent['common_info'];
            // set sign information
            if ($sign) {
                $signature = $this->transportwaybillforwardermodel->getDocumentSignature(
                    !$this->session->has_userdata('childid'),
                    $this->session->userdata('childid') ?? $this->session->userdata('user_id')
                );
                if ('' !== $signature) {
                    $common_info['signature'] = $signature;
                }
            }
            $vehicle_and_driver_info = $transportwaybillcontent['vehicle_and_driver_info'];
            $orderDetailsList = $transportwaybillcontent['orderDetailsList'];
            $driver_accepted_date = $transportwaybillcontent['driver_accepted_date'];
            $carrierDetails = [];
            $pdfPage = 0;
            $sizeOrderDetailList = count($orderDetailsList);
            foreach ($orderDetailsList as $individualOrderInfo) {
                $consigneeDetails = $customerDetails = $shipperDetails = [];
                $order_parties = $individualOrderInfo['order_parties'];
                $tripSequence = sprintf("%02d", $pdfPage);
                foreach ($order_parties as $orderParty) {
                    switch (strtolower($orderParty['role'])) {
                        case 'carrier':
                            $carrierDetails = $orderParty;
                            break;
                        case 'consignee':
                            $consigneeDetails = $orderParty;
                            break;
                        case 'customer':
                            $customerDetails = $orderParty;
                            break;
                        case 'shipper':
                            $shipperDetails = $orderParty;
                            break;
                    }
                }
                $data = [
                    'sign' => $sign,
                    'driver_accepted_date' => $driver_accepted_date,
                    'tripSequence' => $tripSequence,
                    'common_info' => $common_info,
                    "vehicle_and_driver_info" => $vehicle_and_driver_info,
                    "consigneeDetails" => $consigneeDetails,
                    "customerDetails" => $customerDetails,
                    "shipperDetails" => $shipperDetails,
                    "carrierDetails" => $carrierDetails,
                    "order_cargos" => $individualOrderInfo['order_cargos'],
                ];
                if ($waybill) {
                    $this->mpdf->WriteHTML(
                        $this->load->view("transportwaybillforwarder/transportwaybill", $data, true)
                    );
                } else {
                    $this->mpdf->WriteHTML(
                        $this->load->view("transportwaybillforwarder/transportwaybillforwarder", $data, true)
                    );
                }
                $pdfPage++;
                if ($pdfPage !== $sizeOrderDetailList) {
                    $this->mpdf->WriteHTML("<pagebreak/>");
                }
            }
            if ($sendemail) {
                $this->sendMail($common_info, $this->mpdf->Output('filename.pdf', 'S'));
            } else {
                echo $this->mpdf->Output(date('Ymdhs').'.pdf', 'D');
            }
        }
    }

    private function sendMail(array $common_info, string $pdf): void
    {
        $email = $this->input->post('email_id', true) ?? '';
        if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $trip_sequence_no = $common_info['trip_sequence_no'];
            $this->load->helper('email_templates_helper');
            $this->load->library('Mailhandler');
            $message = getRussiaTransportWaybillFreightForwarderEmailBody($trip_sequence_no);
            $subject = getRussiaTransportWaybillFreightForwarderEmailSubject($trip_sequence_no);
            $fileName = 'TransportWaybillFreightForwarder_' . $trip_sequence_no . date('YmdHis') . ".pdf";
            echo $this->mailhandler->mailRequestHandler($email, $subject, $message, $pdf, $fileName) ? "1" : "0";
        }
    }
}
