<?php

use App\Libraries\TripNotificationXmlCacheService;

/**
 * re-trigger trip notification on direct request
 */
class TripNotificationOnRequest extends CI_Controller
{
    /**
     * generate xml by order id, and send to open_boxes
     *
     * @param string $orderId
     */
    public function byOrderId(string $orderId): void
    {
        if (!$this->hasProperApiKey()) {
            echo "wrong key";
            return;
        }

        $service = new TripNotificationXmlCacheService();

        try {
            $outputXml = $service->forOrderId($orderId)
                ->fetch()
                ->getXml();

            $this->sendXmlToOpenBoxes($outputXml, $this->filename($orderId));
        } catch (Exception $e) {
            echo $e->getMessage();
            return;
        }

        echo 'done';
    }

    private function hasProperApiKey(): bool {

        if (empty($_GET['API_KEY'] ?? '')) {
            return false;
        }

        return checkAccessConditions('CWG_TripNotification_ApiKey', $_GET['API_KEY']);
    }

    private function sendXmlToOpenBoxes(string $outputXml, string $filename): void
    {
        $ci = &get_instance();
        $ci->load->library(
            'edi/carriernotification/CarrierNotificationSftpManager',
            'carriernotificationsftpmanager'
        );

        $ci->carriernotificationsftpmanager->initializeConnectionSettings(
            [
                'url' => OPENBOX_SERVER_IP,
                'username' => OPENBOX_USERNAME,
                'password' => OPENBOX_PASSWORD,
                'path' => OPENBOX_TRIP_NOTIFICATION_INBOUND
            ]
        );
        $ci->carriernotificationsftpmanager->uploadToSftp(
            $outputXml,
            $filename
        );
    }

    private function filename(string $orderId): string
    {
        $ci = &get_instance();
        $order = $ci->db->query(
            "SELECT shipment_id, vendor_id
            FROM tb_orders
            WHERE order_id= ?",
            [$orderId]
        )->row();

        return $order->shipment_id . '_' . $order->vendor_id;
    }
}
