<?php

use App\Order\Models\OrderReference;

defined('BASEPATH') or exit('No direct script access allowed');
/*
 * This controller will load the data of Trips.


 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Trips extends CI_Controller
{
    private $_userId = null;

    /**
     * Class Constructor
     */
    public function __construct()
    {
        parent::__construct();

        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->userId = $this->session->userdata('user_id');
        $this->companyCode = $this->session->userdata('company_code');
        $this->branchCode = $this->session->userdata('branch_code');
        $this->currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $this->userRoleId = $this->session->userdata('user_role_id');
        $this->departmentCode = $this->session->userdata('department_code') ?? "";
        $this->load->helper("jwt");
		$this->load->library(['form_validation','statusintigration','svkonektquote','shippeostatusintigration','macdamstatusintigration','knlogin','Exchangerate','crossborderlib','standard_status_execution','RateForMultilegs']);
        $this->load->model(['trips_model','common','triptemplatemodel']);
        //log_message("error","Trips:".checkUrlAccessForUser('TRIPS'));
        if (!checkUrlAccessForUser('TRIPS')) {
            redirect("Forbiddenaccess");
        }
    }

    /**
     * Displays all active Trips
     */
    public function index()
    {
        $this->tripslist();
	}

    public function searchConditions(array $post): string
    {
        $whereCondition = "";
        if (!empty($post)) {
            if (isset($post['shipmentid']) && $post['shipmentid'] != "") {
                $whereCondition .= " s.shipmentid = '" . $post['shipmentid'] . "' AND ";
            }
            if (isset($post['carrier_type']) && $post['carrier_type'] != "") {
                $whereCondition .= " s.carrier_type = '" . $post['carrier_type'] . "' AND ";
            }
            if (isset($post['fromdate']) && $post['fromdate'] != "") {
                $whereCondition .= "  DATE(s.startdate) >='" . date('Y-m-d', strtotime($post['fromdate'])) . "' AND ";
            }
            if (isset($post['todate']) && $post['todate'] != "") {
                $whereCondition .= "  DATE(s.enddate) >='" . date('Y-m-d', strtotime($post['todate'])) . "' AND ";
            }
            if (isset($post['carrier_id']) && $post['carrier_id'] != "") {
                $whereCondition .= "  v.code ='" . $post['carrier_id'] . "' AND ";
            }
            if (isset($post['carrier_name']) && $post['carrier_name'] != "") {
                $whereCondition .= "  v.name ='" . $post['carrier_name'] . "' AND ";
            }
            if (isset($post['driver_name']) && $post['driver_name'] != "") {
                $whereCondition .= "  d.name ='" . $post['driver_name'] . "' AND ";
            }
            if (isset($post['vehicle_type']) && $post['vehicle_type'] != "") {
                $whereCondition .= "  s.vehicle_type ='" . $post['vehicle_type'] . "' AND ";
            }
            if (isset($post['vehicle_id']) && $post['vehicle_id'] != "") {
                $whereCondition .= " t.register_number ='" . $post['vehicle_id'] . "' AND ";
            }
            if (isset($post['source_city']) && $post['source_city'] != "") {
                $whereCondition .= "  s.scity ='" . $post['source_city'] . "' AND ";
            }
            if (isset($post['destination_city']) && $post['destination_city'] != "") {
                $whereCondition .= "  s.dcity ='" . $post['destination_city'] . "' AND ";
            }
        }
        $whereCondition .= " s.status ='1' AND s.company_code ='" . $this->companyCode . "' AND s.branch_code ='" . $this->branchCode . "' AND  s.shift_leg_id ='0' ";
        return $whereCondition;
    }

    public function tripslist(): void
    {
        try {
            if ($this->input->method() === 'post') {
                $this->session->set_userdata('trip_search_post', $this->input->post());
                redirect('trips');
            }
            $data['page_title'] = $this->lang->line('trips_list');
            $data['sub_title'] = $this->lang->line('trips');
            $tripsdata = $shiftIds = $stopIds = $dropStopIds = $finalShiftIds = [];
            //$post = $this->input->post();
            $post = $this->session->userdata('trip_search_post') ?? [];
            $this->session->unset_userdata('trip_search_post');
            $whereCondition = $this->searchConditions($post);
            $queryResult = $this->trips_model->loadAllTripsDataByUser($whereCondition, $this->currentTimeZone);
            
            foreach ($queryResult as $eachRow) {
                $shiftIds[] = $eachRow['id'];
                $shiftData[$eachRow['id']] = [
                    'shiftRowId' => $eachRow['id'],
                    'fromPlace' => $eachRow['splace'],
                    'toPlace' => $eachRow['eplace'],
                    'startDate' => $eachRow['startdate'],
                    'endDate' => $eachRow['enddate'],
                    'shipmentId' => $eachRow['shipmentid'],
                    'tranportMode' => $eachRow['transport_mode'],
                    'weight' => $eachRow['weight'],
                    'volume' => $eachRow['volume'],
                    'units' => $eachRow['units'],
                    'vehicleType' => $eachRow['vehicle_type'],
                    'vendorName' => $eachRow['vendor_name'],
                    'driverName' => $eachRow['driver_name'],
                    'registerNumber' => $eachRow['register_number']
                ];
            }
            if (!empty($shiftIds)) {
                $pageCount = count($shiftIds);
                $config = [];
                $config["base_url"] = base_url() . "trips/index";
                $config["total_rows"] = $pageCount;
                $config["per_page"] = 10;
                $config["uri_segment"] = 3;
                $config['display_pages'] = true;
                $this->pagination->initialize($config);
                $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
                if (!is_numeric($page)) {
                    $page = 0;
                }
                $arrayStart = $page;
                for($i=0;$i<10;$i++){
                    if($i == 10){
                        break;
                    }
                    $arrayShiftId = $shiftIds[$arrayStart] ?? 0;
                    if($arrayShiftId == 0){
                        break;
                    }
                    $finalShiftIds[] = $shiftIds[$arrayStart] ?? 0;
                    $arrayStart++;
                }
                $stopWhereCondition = " shift_id IN (" . implode(',', $finalShiftIds) . ") AND status ='1'";
                $getStops = $this->common->gettbldata($stopWhereCondition, "shift_id,stop_id,drop_stopid", "tb_employee", 0, 0);
                if (!empty($getStops)) {
                    foreach ($getStops as $eachRow) {
                        $shiftId = $eachRow['shift_id'];
                        $stopIds[$shiftId][] = $eachRow['stop_id'];
                        $dropStopIds[$shiftId][] = $eachRow['drop_stopid'];
                    }
                }
                foreach ($shiftIds as $eachId) {
                    $shiftData[$eachId]['stopIds'] = $stopIds[$eachId] ?? [];
                    $shiftData[$eachId]['dropStopIds'] = $dropStopIds[$eachId] ?? [];
                }
                $finalWhereCondition = " s.id IN (" . implode(',', $finalShiftIds) . ") AND s.status ='1'";
                $finalQueryResult = $this->common->gettbldata($finalWhereCondition, "s.id", "tb_shifts as s", 0, 0);
                if (!empty($finalQueryResult)) {
                    foreach ($finalQueryResult as $eachRow) {
                        $shiftRowId = $eachRow['id'];
                        $tripsdata[] = [
                            'id' => $shiftRowId,
                            'fromPlace' => $shiftData[$shiftRowId]['fromPlace'],
                            'toPlace' => $shiftData[$shiftRowId]['toPlace'],
                            'startDate' => $shiftData[$shiftRowId]['startDate'],
                            'endDate' => $shiftData[$shiftRowId]['endDate'],
                            'shipmentId' => $shiftData[$shiftRowId]['shipmentId'],
                            'tranportMode' => $shiftData[$shiftRowId]['tranportMode'],
                            'weight' => $shiftData[$shiftRowId]['weight'],
                            'volume' => $shiftData[$shiftRowId]['volume'],
                            'units' => $shiftData[$shiftRowId]['units'],
                            'vehicleType' => $shiftData[$shiftRowId]['vehicleType'],
                            'vendorName' => $shiftData[$shiftRowId]['vendorName'],
                            'driverName' => $shiftData[$shiftRowId]['driverName'],
                            'registerNumber' => $shiftData[$shiftRowId]['registerNumber'],
                            'stopIdsCount' => count($shiftData[$shiftRowId]['stopIds']),
                            'dropStopIdsCount' => count($shiftData[$shiftRowId]['dropStopIds']),
                        ];
                    }
                }
            }
            $data['trips'] = $tripsdata;
            $this->newtemplate->dashboard("trips/KNET_trips_index", $data);
        } catch (\Exception $ex) {
            log_message('error', $ex->getMessage());
        }
    }

    /**
     * This action displays Trip details
     */
    /*public function KNETtripsedit(): void
    {
        try {
            $shiftId = $this->uri->segment(3);
            $data['page_title'] = $this->lang->line('trips');
            $data['sub_title'] = $this->lang->line('general_edit') . " " . $this->lang->line('trip_title');
            $data["shiftId"] = $shiftId;
            $data['branchCode'] = $this->branchCode;
            $data['companyCode'] = $this->companyCode;
            $data['currentTimeZone'] = $this->currentTimeZone;
            $data['details'] = $this->common->gettblrowdata(['id' => $shiftId], "id,shipmentid,transport_mode,carrier_type,company_code,branch_code,department_code,border_type,origin_id,destination_id", 'tb_shifts', 0, 0);
            if (in_array('', [$data['details']['origin_id'], $data['details']['destination_id']])) {
                $orderDetails = $this->getOriginDestinationIdsFromOrder($shiftId);
                $data['details']['origin_id'] = $orderDetails['origin_id'] ?? "";
                $data['details']['destination_id'] = $orderDetails['destination_id'] ?? "";
                $data['details']['origin_row_id'] = $orderDetails['origin_row_id'] ?? "";
                $data['details']['destination_row_id'] = $orderDetails['destination_row_id'] ?? "";
            }
            $data['shiftOrders'] = $this->trips_model->getShiftOrders($shiftId);
            $shiftLegsdata = $this->trips_model->getshiftlegsdata($shiftId);
            $data['checkLegs'] = $this->trips_model->checkLegsForMainShipment($shiftId);
            foreach($shiftLegsdata as $eachRow){
                $data['shiftLegsdata'][] = $eachRow;
            }
            $data['tripsStatusdata'] = $this->getlegTripstatusorders($shiftId);
            $data['userRoleId'] = $this->userRoleId;
            $data['userDepartmentCode'] = $this->departmentCode;
            $data['userBranchCode'] = $this->branchCode;
            if ($data['userRoleId'] === "5") {
                $childId = $this->session->userdata('childId');
                if ($childId > 0) {
                    $usersWithDepartmentCodes = $this->session->userdata('usersWithDepartmentCodes');
                    foreach ($usersWithDepartmentCodes as $eachLine) {
                        $subBranchesDepartmentCode[] = $eachLine['branchCode'] . "_" . $eachLine['departmentCode'];
                    }
                }
            }
            $data['subBranchesDepartmentCode'] = $subBranchesDepartmentCode ?? [];
            //$this->newtemplate->dashboard("trips/KNETtripsedit", $data);
             $this->load->view("trips/KNETtripsedit", $data);
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }*/
    
    public function KNETtripsedit(): void
    {
        try {
            $shiftId                 = $this->uri->segment(3);
            $data['page_title']      = $this->lang->line('trips');
            $data['sub_title']       = $this->lang->line('general_edit') . " " . $this->lang->line('trip_title');
            $data["shiftId"]         = $shiftId;
            $data['branchCode']      = $this->branchCode;
            $data['companyCode']     = $this->companyCode;
            $data['currentTimeZone'] = $this->currentTimeZone;
            $data['details']         = $this->common->gettblrowdata(['id' => $shiftId], "id,shipmentid,transport_mode,carrier_type,company_code,branch_code,department_code,border_type,origin_id,destination_id,customer_id,vendor_id", 'tb_shifts', 0, 0);
            if (in_array('', [$data['details']['origin_id'], $data['details']['destination_id']])) {
                $orderDetails                          = $this->getOriginDestinationIdsFromOrder($shiftId);
                $data['details']['origin_id']          = $orderDetails['origin_id'] ?? "";
                $data['details']['destination_id']     = $orderDetails['destination_id'] ?? "";
                $data['details']['origin_row_id']      = $orderDetails['origin_row_id'] ?? "";
                $data['details']['destination_row_id'] = $orderDetails['destination_row_id'] ?? "";
            }

            $data['shiftOrders'] = $this->trips_model->getShiftOrders($shiftId);
            //log_message("error", "shiftLegsdata:" . json_encode($data['shiftOrders']));
            foreach ($data['shiftOrders'] as $eachRow) {
                //log_message("error", "eachRow:" . json_encode($eachRow));
                //$data['shiftOrders'][] = $eachRow;
                $orderId               = $eachRow['orderRowId'];
                $product               = $eachRow['product'];
                $service               = $eachRow['service'];
            }

            $orderId = $orderId ?? "";
            $product = $product ?? "";
            $service = $service ?? "";

            $pickup_id         = $data['details']['customer_id'];
            $pickup_location = $delivery_location = "";
            if (isset($orderDetails)) {
                $pickup_location   = ['country' => $orderDetails['origin_country'], 'zipcode' => $orderDetails['origin_pincode'], 'user_id' => $orderDetails['origin_user_id'], 'city' => $orderDetails['origin_state']];
                $delivery_location = ['country' => $orderDetails['destination_country'], 'zipcode' => $orderDetails['destination_pincode'], 'user_id' => $orderDetails['destination_user_id'], 'city' => $orderDetails['destination_state']];
            }
            $info              = ['order_id' => $orderId, 'product' => $product];
            $data['rates']     = $this->ratemanagement->getcustomerprofiledetailsbyid($pickup_id, $service, $pickup_location, $delivery_location, $info);

            $shiftLegsdata     = $this->trips_model->getshiftlegsdata($shiftId);
            $data['checkLegs'] = $this->trips_model->checkLegsForMainShipment($shiftId);
            foreach ($shiftLegsdata as $eachRow) {
                $data['shiftLegsdata'][] = $eachRow;
            }
            $data['tripsStatusdata']    = $this->getlegTripstatusorders($shiftId);
            $data['userRoleId']         = $this->userRoleId;
            $data['userDepartmentCode'] = $this->departmentCode;
            $data['userBranchCode']     = $this->branchCode;
            if ($data['userRoleId'] === "5") {
                $childId = $this->session->userdata('childId');
                if ($childId > 0) {
                    $usersWithDepartmentCodes = $this->session->userdata('usersWithDepartmentCodes');
                    foreach ($usersWithDepartmentCodes as $eachLine) {
                        $subBranchesDepartmentCode[] = $eachLine['branchCode'] . "_" . $eachLine['departmentCode'];
                    }
                }
            }
            $data['subBranchesDepartmentCode'] = $subBranchesDepartmentCode ?? [];
            //$this->newtemplate->dashboard("trips/KNETtripsedit", $data);
           
            $this->load->view("trips/KNETtripsedit", $data);
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    public function getOriginDestinationIdsFromOrder(int $shiftId): array
    {
        $orderIds = $this->common->gettbldata(['shift_id' => $shiftId], "id", "tb_orders", 0, 0);
        if (empty($orderIds)) {
            return [];
        }
        $pickupOrderId = $deliveryOrderId = 0;
        $orderIdsCount = count($orderIds);
        if ($orderIdsCount > 1) {
            $pickupOrderId = $orderIds[0]['id'] ?? 0;
            $deliveryOrderId = $orderIds[$orderIdsCount - 1]['id'] ?? 0;
        } else {
            $pickupOrderId = $deliveryOrderId = $orderIds[0]['id'] ?? 0;
        }
        if ($pickupOrderId > 0 && $deliveryOrderId > 0) {
            $details = $this->trips_model->getOrderPickupDropDetails(['pickup' => $pickupOrderId, 'drop' => $deliveryOrderId, 'companyCode' => $this->companyCode]);
        }
        return $details ?? [];
    }

    public function getshiporderdetails(){
    	$shiftId = $this->input->post('shift_id',true);
    	$data['shiftOrders'] = $this->trips_model->getShiftOrders($shiftId);
    	echo json_encode($data);
    }

     public function getshiplegdetails(){
         $data['shiftLegsdata'] = [];
    	$shiftId = $this->input->post('shift_id',true);
    	$shiftLegsdata = $this->trips_model->getshiftlegsdata($shiftId);
         foreach($shiftLegsdata as $eachRow){
             $data['shiftLegsdata'][] = $eachRow;
         }
    	echo json_encode($data);
    }


    public function getlegTripstatusorders(int $shiftId): array
    {
        $finalShiftLegIds = $legIds = $shiftLegsData = $tripsdata = $tripIds = $closedTrips = [];
        $legsData = $this->common->gettbldata(['shift_leg_id' => $shiftId], "id,splace,eplace,convertToClientTZ(startdate,'" . $this->currentTimeZone . "') as startdate,convertToClientTZ(enddate,'" . $this->currentTimeZone . "') as enddate,convertToClientTZ(updated_on,'" . $this->currentTimeZone . "') as updatedon", "tb_shifts", 0, 0);
        foreach ($legsData as $eachLeg) {
            $legIds[] = $eachLeg['id'];
            $shiftLegsData[$eachLeg['id']] = ['id'=>$eachLeg['id'],'fromPlace' => $eachLeg['splace'], 'toPlace' => $eachLeg['eplace'], 'startDate' => $eachLeg['startdate'], 'endDate' => $eachLeg['enddate'],'updatedOn'=>$eachLeg['updatedon'],'tripId'=>'0','closedStatus'=>'0'];
        }
        if(empty($legIds)){
            return [];
        }
        $getTripOrders = $this->common->gettbldata("shift_id IN (" . implode(",", $legIds) . ") AND order_id != ''", "shift_id,trip_id", "tb_employee", 0, 0);
        foreach ($getTripOrders as $eachTripOrder) {
            $finalShiftLegIds[] = $eachTripOrder['shift_id'];
            $tripId = $eachTripOrder['trip_id'];
            if($tripId >0){
                $shiftLegsData[$eachTripOrder['shift_id']]['tripId'] = $tripId;
                $tripIds[] = $tripId;
            }
        }
        if(!empty($tripIds)){
            $checkLegClosedStatus = $this->common->gettbldata("id IN (".implode(',',$tripIds).") AND transit_status ='1' AND status ='0'","id","tb_trips",0,0);
            if(!empty($checkLegClosedStatus)){
                foreach ($checkLegClosedStatus as $eachRow){
                    $closedTrips[] = $eachRow['id'];
                }
            }
        }
        if(!empty($closedTrips)){
            foreach ($shiftLegsData as $eachLeg){
                $shiftId = $eachLeg['id'];
                $tripId = $eachLeg['tripId'];
                if($tripId >0 && in_array($tripId,$closedTrips)){
                    $shiftLegsData[$shiftId]['closedStatus'] = 1;
                }
            }
        }
        if (!empty($finalShiftLegIds)) {
            $finalShiftLegIds = array_unique($finalShiftLegIds);
            $crossBorderTrips = $this->trips_model->checkCbTripsWithVehicleDriver($finalShiftLegIds, "e.status ='1'");
            if (!empty($crossBorderTrips)) {
                foreach ($crossBorderTrips as $eachLine) {
                    $shiftData[$eachLine['employee_id']] = [
                        'id' => $eachLine['id'],
                        'employeeId'=>$eachLine['employee_id'],
                        'shiftLegId' => $shiftId,
                        'shipmentId' => $eachLine['shipmentid'],
                        'vehicleId' => $eachLine['vehicle_id'],
                        'driverId' => $eachLine['driver_id'],
                        'imei' => $eachLine['imei'],
                        'contactNumber' => $eachLine['contact_num'],
                        'trackType' => $eachLine['track_type'],
                        'trackVendor' => $eachLine['track_vendor'],
                        'simCarrier' => $eachLine['sim_carrier'],
                        'orderRowId' => $eachLine['orderrowid'],
                        'bookingId' => $eachLine['order_id'],
                        'tripId' => $eachLine['trip_id'],
                        'crossBorderCheck' => '1',
                        'fromPlace' => $shiftLegsData[$eachLine['id']]['fromPlace'] ?? '',
                        'toPlace' => $shiftLegsData[$eachLine['id']]['toPlace'] ?? '',
                        'startDate' => $shiftLegsData[$eachLine['id']]['startDate'] ?? '',
                        'endDate' => $shiftLegsData[$eachLine['id']]['endDate'] ?? '',
                        'tripUpdatedOn'=> $shiftLegsData[$eachLine['id']]['updatedOn'] ?? '',
                        'closedStatus'=> $shiftLegsData[$eachLine['id']]['closedStatus'] ?? '',
                    ];
                }
                $tripsdata = $this->crossborderlib->getstopsStatusBasedOnLegsForOrder($crossBorderTrips, $shiftData);
            }
        }
        return $tripsdata;
    }

    /* Get status dates and data ends here */
	/* Update Status bar */
 public function update_triplegs_status(){

      $arr = array();
	  $trip_id = $arr['trip'] =  isset($_POST['trip_id']) ? $_POST['trip_id'] : "0";
	  $ord_id = $arr['ord_id'] = isset($_POST['order_id']) ? $_POST['order_id'] : "";
	  $orderid =  $arr['orderid'] = isset($_POST['orderid']) ? $_POST['orderid'] : "";
	  $ship_id = $arr['ship'] =  isset($_POST['shift_id']) ? $_POST['shift_id'] : "";
	  $seldt = $stsdate = isset($_POST['status_date']) ? $_POST['status_date'] : "";
	  $stsid = $arr['stsid'] =  isset($_POST['status_type']) ? $_POST['status_type'] : "";
	  $stype =  $arr['stop_type'] = isset($_POST['s_type']) ? $_POST['s_type'] : "";
	  $sts = $arr['status'] = isset($_POST['status']) ? $_POST['status'] : "";
	  $stopid = $arr['stopid'] = isset($_POST['stopid']) ? $_POST['stopid'] : "0";
      $stopdetailid = $arr['stopdetailid'] = $this->input->post("stopdetid",true);
      $vehicle_id = $arr['vehicle_id'] = $this->input->post("vehicle_id",true);
      $driver_id = $arr['driver_id'] = $this->input->post("driver_id",true);
      $tracktype = $arr['tracktype'] = $this->input->post("tracktype",true);
      $trackvendor = $arr['trackvendor'] = $this->input->post("trackvendor",true);
      $contact_num = $arr['contact_num'] = $this->input->post("contact_num",true);
	  $curtz = $arr['timezone'] =  $this->session->userdata("usr_tzone")['timezone'];

$resultsts = 2;
    if(checkstsvaliddate($seldt)){
        $gentime = getdatetimebytimezone(DFLT_TZ,$seldt,$curtz);
        $stsdate = $gentime['datetime'];
    }else{
        $stsdate = "";
    }
     if ($this->userRoleId === "5") {
         $statusReason = "From KNOps";
     } else {
         $statusReason = "From Admin";
     }
     $arr['sts_date'] = $stsdate;
    $logdate = date('Y-m-d H:i:s');
    $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
    $curdt = $getactual['datetime'];
    $hrs = $this->session->userdata("usr_tzone")['hrs'];
    $lgusrid = $this->session->userdata("user_id");
    $latitude = $longitude = "";
    $createdsource = "";
    $plat = $plng = $dlat = $dlng = "";

	if($ord_id!='' || $ord_id!=0){

		$chkcs = $this->db->select("plat,plng,dlat,dlng,created_source")->get_where("tb_orders",array("id"=>$ord_id),1,0);
		if($chkcs->num_rows()>0){
			$createdsource = $chkcs->row()->created_source;
			if($createdsource == "18"){
				$createdsource = 1;
			}
			if($chkcs->row()->plat != ""){
				$plat = $chkcs->row()->plat;
				$plng = $chkcs->row()->plng;
			}else{
				$chklatlng = $this->db->select("latitude,longitude")->get_where("tb_site_settings",array("user_id"=>$lgusrid),1,0);
				if($chklatlng->num_rows()>0){
					$plat = $chklatlng->row()->latitude;
					$plng = $chklatlng->row()->longitude;
				}
			}
			if($chkcs->row()->dlat != ""){
				$dlat = $chkcs->row()->dlat;
				$dlng = $chkcs->row()->dlng;
			}else{
				$chklatlng = $this->db->select("latitude,longitude")->get_where("tb_site_settings",array("user_id"=>$lgusrid),1,0);
				if($chklatlng->num_rows()>0){
					$dlat = $chklatlng->row()->latitude;
					$dlng = $chklatlng->row()->longitude;
				}
			}
		}
		 if($stsdate != "" && $sts == "0"){
			$stid = $stsid;
			if($stsid == "10"){ $stcode = "0212"; }
			if($stsid == "2" && $stype == "P"){ $stcode = "0420"; }
			if($stsid == "1" && $stype == "P"){ $stcode = "0500"; }
			if($stsid == "3" && $stype == "P"){ $stcode = "0191"; }
			if($stsid == "4"){ $stcode = "1550"; }
			if($stsid == "2" && $stype == "D"){ $stcode = "0192"; }
			if($stsid == "1" && $stype == "D"){ $stcode = "2300"; }
			if($stsid == "3" && $stype == "D"){ $stcode = "3000"; }
			if($stsid == "11"){ $stcode = "0218"; }
             $arr['status_code'] = $stcode;
           /* log_message("error","stsid ".json_encode($stsid));
           log_message("error","trip ".json_encode($arr['trip']));*/
           if($stsid == "10" && $arr['trip'] == "0"){
             $stcode = "0212";
             /*start trip*/
             $chqry = $this->db->select("id")->get_where("tb_trips",array('shift_id'=>$arr['ship'], 'vehicle_id'=>$arr['vehicle_id'], 'driver_id'=>$arr['driver_id']),1,0);
             if($chqry->num_rows() == 0){
                if($arr['contact_num'] == ""){
                    $newimei = $this->db->select("imei")->get_where("tbl_assigned_drivers",array('vehicle_id'=>$arr['vehicle_id'],'driver_id'=>$arr['driver_id'],'status'=>1),1,0);
                    if($newimei->num_rows()>0){
                        $arr['contact_num'] = $newimei->row()->imei;
                    }
                }
                $latitude = $plat;
                $longitude = $plng;
                $triparr = array('shift_id'=>$arr['ship'], 'vehicle_id'=>$arr['vehicle_id'], 'driver_id'=>$arr['driver_id'], 'stime'=>$stsdate, 'start_imei'=>$arr['contact_num'], 'splace'=>"", 'eplace'=>"", 'start_reading'=>0, 'end_reading'=>0, 'created_on'=>$stsdate, 'updated_on'=>$curdt, 'status'=>1, 'trip_type'=>0, 'transit_status'=>0,"plat"=>$latitude,"plng"=>$longitude);
                $arr['trip'] = $this->common->insertTableData('tb_trips', $triparr);
                 $ins = $this->common->insertTableData("tb_stop_status", ["order_id" => $ord_id, "shipment_id" => $arr['ship'], "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => $arr['trip'], "status_id" => $stid, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "reason" => $statusReason, "vehicle_id" => $arr['vehicle_id'], "driver_id" => $arr['driver_id'], "status_code" => $stcode, "createdon" => $stsdate]);
            }else{
                $arr['trip'] = $chqry->row()->id;
                $chqryx = $this->db->select("id")->get_where("tb_stop_status",array("order_id"=>$ord_id,"shipment_id"=>$arr['ship'],"status_id"=>$stid),1,0);
                if($chqryx->num_rows() == 0){
                    $ins = $this->common->insertTableData("tb_stop_status", ["order_id" => $ord_id, "shipment_id" => $arr['ship'], "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => $arr['trip'], "status_id" => $stid, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "reason" => $statusReason, "vehicle_id" => $arr['vehicle_id'], "driver_id" => $arr['driver_id'], "status_code" => $stcode, "createdon" => $stsdate]);
                }
            }
            if($arr['trip'] > 0){
                /* update orders table */
                $ordwhr = array("shift_id"=>$arr['ship'],"order_id"=>$ord_id);
                $ordset = array("trip_id"=>$arr['trip']);
                $upd = $this->db->set($ordset)->where($ordwhr)->update("tb_employee");

                $postdata = array(
                    "shipment_id" => $arr['ship'],
                    "trip_id"     => $arr['trip'],
                    "driver_id"   => $arr['driver_id'],
                    "vehicle_id"  => $arr['vehicle_id'],
                    "order_id"    => $arr['orderid'],
                    "user_id"    => $lgusrid,
                    "stop_id"     => '',
                    "latitude"    => $latitude,
                    "longitude"   => $longitude,
                    "curtz"   => $curtz,
                    "hrs" => $hrs,
                    "web"  => $seldt,
                    "status_code"  => $stcode,
                    "ord_id"  => $ord_id
                );
                $resultsts = 1;

                if($createdsource == "18"){
                    $sts = $this->statusintigration->roadlogshipmentconfirm($postdata);
                } else if($createdsource == "5"){
                    $sts = $this->statusintigration->salogshipmentstatus($postdata);
                } else if($createdsource == "9"){
                    $sts = $this->svkonektquote->getstatusresponse($postdata);
                } else if($createdsource == "13"){
                    /*$this->load->library("amazonstatusintegration");
                    $sts = $this->amazonstatusintegration->outboundTrailerASN($postdata);*/
                } else if($createdsource == "8") {
                    $curtz = $this->session->userdata("usr_tzone")['timezone'];
                    $logdate = date('Y-m-d H:i:s');
                    $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
                    $cur_date = $getactual['datetime'];
                    $postdata['date_transmission'] = $cur_date;
                    $postdata["truck_number"] = null;
                    $chktruck = $this->db->query("SELECT truck_number FROM tb_trucks_data WHERE id = '".$arr['vehicle_id']."' LIMIT 1");
                    if($chktruck->num_rows() > 0) {
                        $postdata["truck_number"] = $chktruck->row()->truck_number;
                    }
                    $postdata["edi_reference"] = null;
                    $chkreference = $this->common->gettblrowdata(array('order_id'=>$ord_id,'reference_id'=>'EDI'),'ref_value','tb_order_references',0,0);
                    if(!empty($chkreference)) {
                        $postdata["edi_reference"] = $chkreference['ref_value'];
                    }
                    if($stid == "10") {
                        // Driver Accept
                        $postdata['situation_code'] = 'EML';
                        $postdata['justification_code'] = 'CFM';
                        $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                    }
                    if($stid == "2" && $stype == "P") {
                        // GATEIN
                        $postdata['situation_code'] = 'EML';
                        $postdata['justification_code'] = 'ARS';
                        $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                    }
                    if($stid == "1" && $stype == "P") {
                        // GATEIN PICKUP
                        $postdata['situation_code'] = 'ECH';
                        $postdata['justification_code'] = 'CFM';
                        $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                    }
                    if($stid == "4" && $stype == "P") {
                        // In-Transit
                        $postdata['situation_code'] = 'MLV';
                        $postdata['justification_code'] = 'CFM';
                        $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                    }
                    if($stid == "1" && $stype == "D") {
                        // Destination - delivery
                        $postdata['situation_code'] = 'LIV';
                        $postdata['justification_code'] = 'CFM';
                        $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                    }
                    if($stid == "3" && $stype == "D") {
                        // Destination - Gateout
                        $session_ccode = $this->session->userdata('company_code');
                        $postdata['situation_code'] = 'LIV';
                        $postdata['justification_code'] = 'DES';
                        $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        if($session_ccode == "PLKN"){
                            $postdata['company_code'] = $session_ccode;
                            $session_currency = $this->session->userdata("usr_tzone")['currency'];
                            $post['currency'] = $session_currency;
                        }
                    }
                } else if($createdsource == "12"){
                    $sts = $this->macdamstatusintigration->macdamshipmentconfirm($postdata);
                } else if($createdsource == "11") {
                    $sts = $this->knlogin->knloginshipmentstatus($postdata);
                }

                }

            }else if($arr['trip'] != "0" && $stid != "11"){
                $chqry = $this->db->select("id")->get_where("tb_stop_status",array("shipment_id"=>$arr['ship'],"order_id"=>$ord_id,"stop_id"=>$stopid,"stop_detail_id"=>$stopdetailid,"stop_type"=>$stype,"trip_id"=>$arr['trip'],"status_id"=>$stid),1,0);
                if($chqry->num_rows() == 0){
                    if($stid == "2" && $stype == "P"){
                        $ttdata = array("id"=>$arr['trip']);
                        $data2["updated_on"] = $curdt;
                        $data2["transit_status"] = '1';
                        $res = $this->db->set($data2)->where($ttdata)->update("tb_trips");
                    }
                    if($stype == "P" || $stid == "4"){
                        $latitude = $plat;
                        $longitude = $plng;
                    }
                    if($stype == "D"){
                        $latitude = $dlat;
                        $longitude = $dlng;
                    }

                    $ins = $this->common->insertTableData("tb_stop_status", ["order_id" => $ord_id, "shipment_id" => $arr['ship'], "stop_id" => $stopid, "stop_detail_id" => $stopdetailid, "stop_type" => $stype, "trip_id" => $arr['trip'], "status_id" => $stid, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "reason" => $statusReason, "vehicle_id" => $arr['vehicle_id'], "driver_id" => $arr['driver_id'], "status_code" => $stcode, "createdon" => $stsdate]);
                    $chqry1 = $this->db->select("id")->get_where("tb_trip_employee",array("employee_id"=>$stopdetailid,"stop_id"=>$stopid,"trip_id"=>$arr['trip'],"status"=>1),1,0);
                    if($chqry1->num_rows() == 0){
                        $insarr = array("employee_id"=>$stopdetailid,"stop_id"=>$stopid,"trip_id"=>$arr['trip'],"status"=>1, 'driver_late'=>0, 'emp_late'=>0, 'stime'=>$curdt, 'check_in'=>$curdt, 'absent_reason'=>'Closed', 'created_on'=>$curdt, 'updated_on'=>$curdt, 'pd_status'=>1);
                        $ins = $this->db->insert("tb_trip_employee",$insarr);
                    }
                    $postdata = array(
                        "shipment_id" => $arr['ship'],
                        "trip_id"     => $arr['trip'],
                        "driver_id"   => $arr['driver_id'],
                        "stop_id"     => $stopid,
                        "order_id"    => $arr['orderid'],
                        "inc_id"      => 0,
                        "pod_type"    => '',
                        "latitude"    => $latitude,
                        "longitude"   => $longitude,
                        "stop_type" => $stype,
                        "vehicle_id" => $arr['vehicle_id'],
                        "curtz" => $curtz,
                        "hrs" => $hrs,
                        "web"  => $seldt,
                        "status_code"  => $stcode,
                        "ord_id"  => $ord_id
                    );
                    if($stid == "1" && $stype == "P"){
                        //$this->sendnotify('pickup_note',$arr['ord_id']);
                    }
                    if($createdsource == "18"){
                        if($stid == "4"){
                            /*$sts = $this->statusintigration->shipmentintransit($postdata);*/
                            /*send to roadlog*/
                            $sts = $this->statusintigration->roadlogshipmentintransit($postdata);
                        }
                        if($stid == "2" && $stype == "P"){
                            /*$sts = $this->statusintigration->shipmentorderpicked($postdata);*/
                            $sts = $this->statusintigration->roadlogshipmentpgatein($postdata);
                        }
                        if($stid == "1" && $stype == "P"){
                            /*$sts = $this->statusintigration->shipmentorderpicked($postdata);*/
                            $sts = $this->statusintigration->roadlogshipmentpicked($postdata);
                        }
                        if($stid == "3" && $stype == "P"){
                            /*send to roadlog*/
                            $sts = $this->statusintigration->roadlogshipmentpgateout($postdata);
                        }
                        if($stid == "2" && $stype == "D"){
                            /*$sts = $this->statusintigration->shipmentorderpicked($postdata);*/
                            $sts = $this->statusintigration->roadlogshipmentdgatein($postdata);
                        }
                        if($stid == "1" && $stype == "D"){
                            /*$sts = $this->statusintigration->shipmentdelivered($postdata);*/
                            /*send to roadlog*/
                            /*  $this->sendnotify('delivery_note',$arr['ord_id']);*/
                            $sts = $this->statusintigration->roadlogshipmentdelivered($postdata);
                        }
                    }else if($createdsource == "5"){
                        if($stid == "1" && $stype == "D"){
                            $sts = $this->statusintigration->salogshipmentstatus($postdata);
                            /*   $this->sendnotify('delivery_note',$arr['ord_id']);*/
                        }
                        if($stid == "1" && $stype == "P"){
                            $sts = $this->statusintigration->salogshipmentstatus($postdata);
                        }
                    }else if($createdsource == '9'){
                        if($stid == '4' || ($stid == "1" && $stype == "P") || ($stid == "3" && $stype == "D")){
                            $postdata['user_id'] = $lgusrid;
                            if($stid == "1" && $stype == "P"){
                            }
                            /*if($stid == "1" && $stype == "D"){
                                $this->sendnotify('delivery_note',$arr['ord_id']);
                            }*/
                            $sts = $this->svkonektquote->getstatusresponse($postdata);
                        }
                    } else if($createdsource == "8") {
                        $curtz = $this->session->userdata("usr_tzone")['timezone'];
                        $logdate = date('Y-m-d H:i:s');
                        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
                        $cur_date = $getactual['datetime'];
                        $postdata['date_transmission'] = $cur_date;
                        $postdata["truck_number"] = null;
                        $chktruck = $this->db->query("SELECT truck_number FROM tb_trucks_data WHERE id = '".$arr['vehicle_id']."' LIMIT 1");
                        if($chktruck->num_rows() > 0) {
                            $postdata["truck_number"] = $chktruck->row()->truck_number;
                        }
                        $postdata["edi_reference"] = null;
                        $chkreference = $this->common->gettblrowdata(array('order_id'=>$ord_id,'reference_id'=>'EDI'),'ref_value','tb_order_references',0,0);
                        if(!empty($chkreference)) {
                            $postdata["edi_reference"] = $chkreference['ref_value'];
                        }
                        if($stid == "10") {
                        // Driver Accept
                            $postdata['situation_code'] = 'EML';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "2" && $stype == "P") {
                        // GATEIN
                            $postdata['situation_code'] = 'EML';
                            $postdata['justification_code'] = 'ARS';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "1" && $stype == "P") {
                        // GATEIN PICKUP
                            $postdata['situation_code'] = 'ECH';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "4" && $stype == "P") {
                        // In-Transit
                            $postdata['situation_code'] = 'MLV';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "1" && $stype == "D") {
                        // Destination - delivery
                            $postdata['situation_code'] = 'LIV';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "3" && $stype == "D") {
                        // Destination - Gateout
                            $postdata['situation_code'] = 'LIV';
                            $postdata['justification_code'] = 'DES';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                    } else if($createdsource == "12"){
                        if($stid == "4"){
                            $sts = $this->macdamstatusintigration->macdamshipmentintransit($postdata);
                        }
                        if($stid == "2" && $stype == "P"){
                            $sts = $this->macdamstatusintigration->macdamshipmentpgatein($postdata);
                        }
                        if($stid == "1" && $stype == "P"){
                            $sts = $this->macdamstatusintigration->macdamshipmentpicked($postdata);
                        }
                        if($stid == "3" && $stype == "P"){
                            /*send to macdamstatusintigration*/
                            $sts = $this->macdamstatusintigration->macdamshipmentpgateout($postdata);
                        }
                        if($stid == "2" && $stype == "D"){
                            $sts = $this->macdamstatusintigration->macdamshipmentdgatein($postdata);
                        }
                        if($stid == "1" && $stype == "D"){
                            $sts = $this->macdamstatusintigration->macdamshipmentdelivered($postdata);
                        }
                    } else if($createdsource == "11") {
                        $sts = $this->knlogin->knloginshipmentstatus($postdata);
                    }else if($createdsource == "13"){
                        $this->load->library("amazonstatusintegration");
                        if($stid == "2" && $stype == "P"){
                            $postdata['status_code'] = "TL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "1" && $stype == "P"){
                            $postdata['status_code'] = "CL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "3" && $stype == "P"){
                            $postdata['status_code'] = "LY";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "2" && $stype == "D"){
                            $postdata['status_code'] = "TL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "1" && $stype == "D"){
                            $postdata['status_code'] = "CL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "3" && $stype == "D"){
                            $postdata['status_code'] = "LY";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                    }
                    if($stid == "3" && $stype == "D"){
                        if($createdsource == "5"){
                            $sts = $this->statusintigration->salogshipmentstatus($postdata);
                        } else if($createdsource == "11") {
                            $sts = $this->knlogin->knloginshipmentstatus($postdata);
                        }
                        $session_ccode = $this->session->userdata('company_code');
                        if($session_ccode == "PLKN"){
                            $postdata['company_code'] = $session_ccode;
                            $session_currency = $this->session->userdata("usr_tzone")['currency'];
                            $post['currency'] = $session_currency;
                            $exchangerate = $this->exchangerate->updateexchangerate_byorderid($postdata);
                        }

                    }
                    $resultsts = 1;
                }
            }else if($stsid == "11" && $arr['trip'] != 0 && $arr['trip'] != ""){
                //log_message('error',"Get IN case 3");

                $latitude = $dlat;
                $longitude = $dlng;
                $postdata = array(
                    "shipment_id" => $arr['ship'],
                    "trip_id"     => $arr['trip'],
                    "driver_id"   => $arr["driver_id"],
                    "stop_id"     => '',
                    "order_id"    => $arr['orderid'],
                    "latitude"    => $latitude,
                    "longitude"   => $longitude,
                    "curtz"   => $curtz,
                    "hrs" => $hrs,
                    "web"  => $seldt
                );
                /*send to roadlog*/
                if($createdsource == "18"){
                    $sts = $this->statusintigration->roadlogshipmenttripdelivered($postdata);
                }
                if($createdsource == "12"){
                    $sts = $this->macdamstatusintigration->macdamshipmenttripdelivered($postdata);
                } else if($createdsource == "11") {
                    $sts = $this->knlogin->knloginshipmentstatus($postdata);
                }
                //$this->sendnotify('delivery_note',$arr['ord_id']);
                $chkmuliti = $this->db->select("id")->get_where("tb_orders",array("shift_id"=>$arr['ship'],"trip_sts"=>'0'));
                if($chkmuliti->num_rows()>1){
                    $upd = $this->db->where(array("id"=>$ord_id,"trip_id !="=>0))->update("tb_orders",array("trip_sts"=>'1'));
                }else{
                    $updwhr  = array("id" => $arr['ship']);
                    $upddata = array("status" => '0', "updated_on" => $curdt);
                    $upd = $this->db->set($upddata)->where($updwhr)->update("tb_shifts");
                    $data1 = array();
                    $tdata = array("id"=>$arr['trip']);
                    $data1["end_imei"] = $arr['contact_num'];
                    $data1["end_reading"] = '0';
                    $data1["etime"] = $data1["updated_on"] = $curdt;
                    $data1["status"] = '0';
                    $data1["transit_status"] = '1';
                    $res = $this->db->set($data1)->where($tdata)->update("tb_trips");
                    $upd = $this->db->where(array("shift_id"=>$arr['ship']))->update("tb_orders",array("trip_sts"=>'1'));
                    $gensum = $this->generatesummary($arr['trip'],$curtz);
                }
                $resultsts = 1;
            }
        }
        try {
            $this->standard_status_execution->sendStandardXMLtoAltova($arr);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
        }

	}else{
		$orderstatus=0;

		$orderqry = "SELECT tbe.order_id,tr.id FROM tb_employee tbe left outer join tb_orders tr on tbe.order_id=tr.order_id WHERE tbe.shift_id='".$ship_id."'";
		$orderqryId = $this->db->query($orderqry);
		$tripsdata = array();
		$tripid = $trip_id;
		$chkarr = array();
		$resultsts = 2;

		if ($orderqryId->num_rows() > 0) {
		foreach ($orderqryId->result() as $res) {
			$leg_ord_no= $res->order_id;
			$legordno= $res->id;
			$legstatus=0;
			$ordershiftsqry = "SELECT shift_id FROM tb_employee tbe LEFT OUTER JOIN tb_shifts ts ON tbe.shift_id=ts.`id` WHERE tbe.order_id='".$leg_ord_no."' AND ts.`shift_leg_id`!=0  AND ts.`id`<'$ship_id' ORDER BY ts.`id` ASC";
			$ordershifts = $this->db->query($ordershiftsqry);
			if ($ordershifts->num_rows() > 0) {
				foreach ($ordershifts->result() as $res) {
						$ord_shift_id= $res->shift_id;
						$ordershiftsstatusqry = "SELECT * FROM tb_stop_status WHERE order_id='".$legordno."' AND `shipment_id`='".$ord_shift_id."' AND `stop_type`='D' AND `status_id`='3'";
							$ordershiftsstatus = $this->db->query($ordershiftsstatusqry);
							if ($ordershiftsstatus->num_rows() > 0) {
								$legstatus++;
							}


				}
				if($legstatus==$ordershifts->num_rows()){
					$orderstatus++;
				}


			}else{
				$orderstatus++;
			}

		}
		//echo $orderstatus;
		if($orderstatus==$orderqryId->num_rows()){
				foreach ($orderqryId->result() as $res) {
			$leg_ord_no= $res->order_id;
			$chkcs = $this->db->select("plat,plng,dlat,dlng,created_source,id")->get_where("tb_orders",array("order_id"=>$leg_ord_no),1,0);
			if($chkcs->num_rows()>0){
				$leg_ord_id = $chkcs->row()->id;
				$createdsource = $chkcs->row()->created_source;
				if($createdsource == "18"){
					$createdsource = 1;
				}
				if($chkcs->row()->plat != ""){
					$plat = $chkcs->row()->plat;
					$plng = $chkcs->row()->plng;
				}else{
					$chklatlng = $this->db->select("latitude,longitude")->get_where("tb_site_settings",array("user_id"=>$lgusrid),1,0);
					if($chklatlng->num_rows()>0){
						$plat = $chklatlng->row()->latitude;
						$plng = $chklatlng->row()->longitude;
					}
				}
				if($chkcs->row()->dlat != ""){
					$dlat = $chkcs->row()->dlat;
					$dlng = $chkcs->row()->dlng;
				}else{
					$chklatlng = $this->db->select("latitude,longitude")->get_where("tb_site_settings",array("user_id"=>$lgusrid),1,0);
					if($chklatlng->num_rows()>0){
						$dlat = $chklatlng->row()->latitude;
						$dlng = $chklatlng->row()->longitude;
					}
				}
			}

		if($stsdate != "" && $sts == "0"){
			$stid = $stsid;
			if($stsid == "10"){ $stcode = "0212"; }
			if($stsid == "2" && $stype == "P"){ $stcode = "0420"; }
			if($stsid == "1" && $stype == "P"){ $stcode = "0500"; }
			if($stsid == "3" && $stype == "P"){ $stcode = "0191"; }
			if($stsid == "4"){ $stcode = "1550"; }
			if($stsid == "2" && $stype == "D"){ $stcode = "0192"; }
			if($stsid == "1" && $stype == "D"){ $stcode = "2300"; }
			if($stsid == "3" && $stype == "D"){ $stcode = "3000"; }
			if($stsid == "11"){ $stcode = "0218"; }
            $arr['status_code'] = $stcode;
			   if($stsid == "10"){
				 $stcode = "0212";
				 /*start trip*/
				 $chqry = $this->db->select("id")->get_where("tb_trips",array('shift_id'=>$arr['ship'], 'vehicle_id'=>$arr['vehicle_id'], 'driver_id'=>$arr['driver_id']),1,0);
				 if($chqry->num_rows() == 0){
					if($arr['contact_num'] == ""){
						$newimei = $this->db->select("imei")->get_where("tbl_assigned_drivers",array('vehicle_id'=>$arr['vehicle_id'],'driver_id'=>$arr['driver_id'],'status'=>1),1,0);
						if($newimei->num_rows()>0){
							$arr['contact_num'] = $newimei->row()->imei;
						}
					}
					$latitude = $plat;
					$longitude = $plng;
					$triparr = array('shift_id'=>$arr['ship'], 'vehicle_id'=>$arr['vehicle_id'], 'driver_id'=>$arr['driver_id'], 'stime'=>$stsdate, 'start_imei'=>$arr['contact_num'], 'splace'=>"", 'eplace'=>"", 'start_reading'=>0, 'end_reading'=>0, 'created_on'=>$stsdate, 'updated_on'=>$curdt, 'status'=>1, 'trip_type'=>0, 'transit_status'=>0,"plat"=>$latitude,"plng"=>$longitude);
					$arr['trip'] = $this->common->insertTableData('tb_trips', $triparr);
                     $ins = $this->common->insertTableData("tb_stop_status", ["order_id" => $leg_ord_id, "shipment_id" => $arr['ship'], "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => $arr['trip'], "status_id" => $stid, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "reason" => $statusReason, "vehicle_id" => $arr['vehicle_id'], "driver_id" => $arr['driver_id'], "status_code" => $stcode, "createdon" => $stsdate]);
				}else{
					$arr['trip'] = $chqry->row()->id;
					$chqryx = $this->db->select("id")->get_where("tb_stop_status",array("order_id"=>$leg_ord_id,"shipment_id"=>$arr['ship'],"status_id"=>$stid),1,0);
					if($chqryx->num_rows() == 0){
                        $ins = $this->common->insertTableData("tb_stop_status", ["order_id" => $leg_ord_id, "shipment_id" => $arr['ship'], "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => $arr['trip'], "status_id" => $stid, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "reason" => $statusReason, "vehicle_id" => $arr['vehicle_id'], "driver_id" => $arr['driver_id'], "status_code" => $stcode, "createdon" => $stsdate]);
					}
				}
            if($arr['trip'] > 0){
                /* update orders table */
				$ordwhr = array("shift_id"=>$arr['ship'],"order_id"=>$leg_ord_no);
                $ordset = array("trip_id"=>$arr['trip']);
                $upd = $this->db->set($ordset)->where($ordwhr)->update("tb_employee");
                $postdata = array(
                    "shipment_id" => $arr['ship'],
                    "trip_id"     => $arr['trip'],
                    "driver_id"   => $arr['driver_id'],
                    "vehicle_id"  => $arr['vehicle_id'],
                    "order_id"    => $arr['orderid'],
                    "user_id"    => $lgusrid,
                    "stop_id"     => '',
                    "latitude"    => $latitude,
                    "longitude"   => $longitude,
                    "curtz"   => $curtz,
                    "hrs" => $hrs,
                    "web"  => $seldt,
                    "status_code"  => $stcode,
                    "ord_id"  => $leg_ord_id
                );
                $resultsts = 1;

                if($createdsource == "18"){
                    $sts = $this->statusintigration->roadlogshipmentconfirm($postdata);
                } else if($createdsource == "5"){
                    $sts = $this->statusintigration->salogshipmentstatus($postdata);
                } else if($createdsource == "9"){
                    $sts = $this->svkonektquote->getstatusresponse($postdata);
                } else if($createdsource == "13"){
                    /*$this->load->library("amazonstatusintegration");
                    $sts = $this->amazonstatusintegration->outboundTrailerASN($postdata);*/
                } else if($createdsource == "8") {
                    $curtz = $this->session->userdata("usr_tzone")['timezone'];
                    $logdate = date('Y-m-d H:i:s');
                    $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
                    $cur_date = $getactual['datetime'];
                    $postdata['date_transmission'] = $cur_date;
                    $postdata["truck_number"] = null;
                    $chktruck = $this->db->query("SELECT truck_number FROM tb_trucks_data WHERE id = '".$arr['vehicle_id']."' LIMIT 1");
                    if($chktruck->num_rows() > 0) {
                        $postdata["truck_number"] = $chktruck->row()->truck_number;
                    }
                    $postdata["edi_reference"] = null;
                    $chkreference = $this->common->gettblrowdata(array('order_id'=>$leg_ord_id,'reference_id'=>'EDI'),'ref_value','tb_order_references',0,0);
                    if(!empty($chkreference)) {
                        $postdata["edi_reference"] = $chkreference['ref_value'];
                    }
                    if($stid == "10") {
                        // Driver Accept
                        $postdata['situation_code'] = 'EML';
                        $postdata['justification_code'] = 'CFM';
                        $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                    }
                    if($stid == "2" && $stype == "P") {
                        // GATEIN
                        $postdata['situation_code'] = 'EML';
                        $postdata['justification_code'] = 'ARS';
                        $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                    }
                    if($stid == "1" && $stype == "P") {
                        // GATEIN PICKUP
                        $postdata['situation_code'] = 'ECH';
                        $postdata['justification_code'] = 'CFM';
                        $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                    }
                    if($stid == "4" && $stype == "P") {
                        // In-Transit
                        $postdata['situation_code'] = 'MLV';
                        $postdata['justification_code'] = 'CFM';
                        $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                    }
                    if($stid == "1" && $stype == "D") {
                        // Destination - delivery
                        $postdata['situation_code'] = 'LIV';
                        $postdata['justification_code'] = 'CFM';
                        $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                    }
                    if($stid == "3" && $stype == "D") {
                        // Destination - Gateout
                        $session_ccode = $this->session->userdata('company_code');
                        $postdata['situation_code'] = 'LIV';
                        $postdata['justification_code'] = 'DES';
                        $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        if($session_ccode == "PLKN"){
                            $postdata['company_code'] = $session_ccode;
                            $session_currency = $this->session->userdata("usr_tzone")['currency'];
                            $post['currency'] = $session_currency;
                        }
                    }
                } else if($createdsource == "12"){
                    $sts = $this->macdamstatusintigration->macdamshipmentconfirm($postdata);
                } else if($createdsource == "11") {
                    $sts = $this->knlogin->knloginshipmentstatus($postdata);
                }

                }

            }else if($arr['trip'] != "0" && $stid != "11"){
                $chqry = $this->db->select("id")->get_where("tb_stop_status",array("shipment_id"=>$arr['ship'],'order_id'=>$leg_ord_id,"stop_id"=>$stopid,"stop_detail_id"=>$stopdetailid,"stop_type"=>$stype,"trip_id"=>$arr['trip'],"status_id"=>$stid),1,0);
                if($chqry->num_rows() == 0){
                    if($stid == "2" && $stype == "P"){
                        $ttdata = array("id"=>$arr['trip']);
                        $data2["updated_on"] = $curdt;
                        $data2["transit_status"] = '1';
                        $res = $this->db->set($data2)->where($ttdata)->update("tb_trips");
                    }
                    if($stype == "P" || $stid == "4"){
                        $latitude = $plat;
                        $longitude = $plng;
                    }
                    if($stype == "D"){
                        $latitude = $dlat;
                        $longitude = $dlng;
                    }

                    $ins = $this->common->insertTableData("tb_stop_status", ["order_id" => $leg_ord_id, "shipment_id" => $arr['ship'], "stop_id" => $stopid, "stop_detail_id" => $stopdetailid, "stop_type" => $stype, "trip_id" => $arr['trip'], "status_id" => $stid, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "reason" => $statusReason, "vehicle_id" => $arr['vehicle_id'], "driver_id" => $arr['driver_id'], "status_code" => $stcode, "createdon" => $stsdate]);
                    $chqry1 = $this->db->select("id")->get_where("tb_trip_employee",array("employee_id"=>$stopdetailid,"stop_id"=>$stopid,"trip_id"=>$arr['trip'],"status"=>1),1,0);
                    if($chqry1->num_rows() == 0){
                        $insarr = array("employee_id"=>$stopdetailid,"stop_id"=>$stopid,"trip_id"=>$arr['trip'],"status"=>1, 'driver_late'=>0, 'emp_late'=>0, 'stime'=>$curdt, 'check_in'=>$curdt, 'absent_reason'=>'Closed', 'created_on'=>$curdt, 'updated_on'=>$curdt, 'pd_status'=>1);
                        $ins = $this->db->insert("tb_trip_employee",$insarr);
                    }
                    $postdata = array(
                        "shipment_id" => $arr['ship'],
                        "trip_id"     => $arr['trip'],
                        "driver_id"   => $arr['driver_id'],
                        "stop_id"     => $stopid,
                        "order_id"    => $arr['orderid'],
                        "inc_id"      => 0,
                        "pod_type"    => '',
                        "latitude"    => $latitude,
                        "longitude"   => $longitude,
                        "stop_type" => $stype,
                        "vehicle_id" => $arr['vehicle_id'],
                        "curtz" => $curtz,
                        "hrs" => $hrs,
                        "web"  => $seldt,
                        "status_code"  => $stcode,
                        "ord_id"  => $leg_ord_id
                    );
                    if($stid == "1" && $stype == "P"){
                        //$this->sendnotify('pickup_note',$arr['ord_id']);
                    }
                    if($createdsource == "18"){
                        if($stid == "4"){
                            /*$sts = $this->statusintigration->shipmentintransit($postdata);*/
                            /*send to roadlog*/
                            $sts = $this->statusintigration->roadlogshipmentintransit($postdata);
                        }
                        if($stid == "2" && $stype == "P"){
                            /*$sts = $this->statusintigration->shipmentorderpicked($postdata);*/
                            $sts = $this->statusintigration->roadlogshipmentpgatein($postdata);
                        }
                        if($stid == "1" && $stype == "P"){
                            /*$sts = $this->statusintigration->shipmentorderpicked($postdata);*/
                            $sts = $this->statusintigration->roadlogshipmentpicked($postdata);
                        }
                        if($stid == "3" && $stype == "P"){
                            /*send to roadlog*/
                            $sts = $this->statusintigration->roadlogshipmentpgateout($postdata);
                        }
                        if($stid == "2" && $stype == "D"){
                            /*$sts = $this->statusintigration->shipmentorderpicked($postdata);*/
                            $sts = $this->statusintigration->roadlogshipmentdgatein($postdata);
                        }
                        if($stid == "1" && $stype == "D"){
                            /*$sts = $this->statusintigration->shipmentdelivered($postdata);*/
                            /*send to roadlog*/
                            /*  $this->sendnotify('delivery_note',$arr['ord_id']);*/
                            $sts = $this->statusintigration->roadlogshipmentdelivered($postdata);
                        }
                    }else if($createdsource == "5"){
                        if($stid == "1" && $stype == "D"){
                            $sts = $this->statusintigration->salogshipmentstatus($postdata);
                            /*   $this->sendnotify('delivery_note',$arr['ord_id']);*/
                        }
                        if($stid == "1" && $stype == "P"){
                            $sts = $this->statusintigration->salogshipmentstatus($postdata);
                        }
                    }else if($createdsource == '9'){
                        if($stid == '4' || ($stid == "1" && $stype == "P") || ($stid == "3" && $stype == "D")){
                            $postdata['user_id'] = $lgusrid;
                            if($stid == "1" && $stype == "P"){
                            }
                            /*if($stid == "1" && $stype == "D"){
                                $this->sendnotify('delivery_note',$arr['ord_id']);
                            }*/
                            $sts = $this->svkonektquote->getstatusresponse($postdata);
                        }
                    } else if($createdsource == "8") {
                        $curtz = $this->session->userdata("usr_tzone")['timezone'];
                        $logdate = date('Y-m-d H:i:s');
                        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
                        $cur_date = $getactual['datetime'];
                        $postdata['date_transmission'] = $cur_date;
                        $postdata["truck_number"] = null;
                        $chktruck = $this->db->query("SELECT truck_number FROM tb_trucks_data WHERE id = '".$arr['vehicle_id']."' LIMIT 1");
                        if($chktruck->num_rows() > 0) {
                            $postdata["truck_number"] = $chktruck->row()->truck_number;
                        }
                        $postdata["edi_reference"] = null;
                        $chkreference = $this->common->gettblrowdata(array('order_id'=>$leg_ord_id,'reference_id'=>'EDI'),'ref_value','tb_order_references',0,0);
                        if(!empty($chkreference)) {
                            $postdata["edi_reference"] = $chkreference['ref_value'];
                        }
                        if($stid == "10") {
                        // Driver Accept
                            $postdata['situation_code'] = 'EML';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "2" && $stype == "P") {
                        // GATEIN
                            $postdata['situation_code'] = 'EML';
                            $postdata['justification_code'] = 'ARS';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "1" && $stype == "P") {
                        // GATEIN PICKUP
                            $postdata['situation_code'] = 'ECH';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "4" && $stype == "P") {
                        // In-Transit
                            $postdata['situation_code'] = 'MLV';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "1" && $stype == "D") {
                        // Destination - delivery
                            $postdata['situation_code'] = 'LIV';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "3" && $stype == "D") {
                        // Destination - Gateout
                            $postdata['situation_code'] = 'LIV';
                            $postdata['justification_code'] = 'DES';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                    } else if($createdsource == "12"){
                        if($stid == "4"){
                            $sts = $this->macdamstatusintigration->macdamshipmentintransit($postdata);
                        }
                        if($stid == "2" && $stype == "P"){
                            $sts = $this->macdamstatusintigration->macdamshipmentpgatein($postdata);
                        }
                        if($stid == "1" && $stype == "P"){
                            $sts = $this->macdamstatusintigration->macdamshipmentpicked($postdata);
                        }
                        if($stid == "3" && $stype == "P"){
                            /*send to macdamstatusintigration*/
                            $sts = $this->macdamstatusintigration->macdamshipmentpgateout($postdata);
                        }
                        if($stid == "2" && $stype == "D"){
                            $sts = $this->macdamstatusintigration->macdamshipmentdgatein($postdata);
                        }
                        if($stid == "1" && $stype == "D"){
                            $sts = $this->macdamstatusintigration->macdamshipmentdelivered($postdata);
                        }
                    } else if($createdsource == "11") {
                        $sts = $this->knlogin->knloginshipmentstatus($postdata);
                    }else if($createdsource == "13"){
                        $this->load->library("amazonstatusintegration");
                        if($stid == "2" && $stype == "P"){
                            $postdata['status_code'] = "TL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "1" && $stype == "P"){
                            $postdata['status_code'] = "CL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "3" && $stype == "P"){
                            $postdata['status_code'] = "LY";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "2" && $stype == "D"){
                            $postdata['status_code'] = "TL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "1" && $stype == "D"){
                            $postdata['status_code'] = "CL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "3" && $stype == "D"){
                            $postdata['status_code'] = "LY";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                    }
                    if($stid == "3" && $stype == "D"){
                        if($createdsource == "5"){
                            $sts = $this->statusintigration->salogshipmentstatus($postdata);
                        } else if($createdsource == "11") {
                            $sts = $this->knlogin->knloginshipmentstatus($postdata);
                        }
                        $session_ccode = $this->session->userdata('company_code');
                        if($session_ccode == "PLKN"){
                            $postdata['company_code'] = $session_ccode;
                            $session_currency = $this->session->userdata("usr_tzone")['currency'];
                            $post['currency'] = $session_currency;
                            $exchangerate = $this->exchangerate->updateexchangerate_byorderid($postdata);
                        }

                    }
                    $resultsts = 1;
                }
            }else if($stsid == "11" && $arr['trip'] != 0 && $arr['trip'] != ""){
				$latitude = $dlat;
                $longitude = $dlng;
                   $ins = $this->common->insertTableData("tb_stop_status", ["order_id" => $leg_ord_id, "shipment_id" => $arr['ship'], "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => $arr['trip'], "status_id" => $stid, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "reason" => $statusReason, "vehicle_id" => $arr['vehicle_id'], "driver_id" => $arr['driver_id'], "status_code" => $stcode, "createdon" => $stsdate]);

				$upd = $this->db->where(array("id"=>$arr['ship']))->update("tb_shifts",array("status"=>'0'));
				$upd1 = $this->db->where(array("id"=>$arr['trip']))->update("tb_trips",array("status"=>'0'));


				$getorderships = "SELECT shift_id FROM tb_employee WHERE order_id='$leg_ord_no' and trip_id!='' group by shift_id";
				$getordershipsRes = $this->db->query($getorderships);

				$orserstatus = 0;
				//echo $getordershipsRes->num_rows();
				if ($getordershipsRes->num_rows() > 0) {
					foreach ($getordershipsRes->result() as $shipperid) {
						$shipperid= $shipperid->shift_id;
						$chqryx = $this->db->select("id")->get_where("tb_stop_status",array("order_id"=>$leg_ord_id,"shipment_id"=>$shipperid,"status_id"=>3,"stop_type"=>"D"),1,0);
						//echo $this->db->last_query();
						if($chqryx->num_rows()>0){
							$orserstatus++;
						}
					}
					//echo $orserstatus;
					if($getordershipsRes->num_rows()==$orserstatus){
							$ordwhr = array("id"=>$leg_ord_id);
							$ordset = array("trip_sts"=>1);
							$upd = $this->db->set($ordset)->where($ordwhr)->update("tb_orders");

							$shipmentstatus=0;
							$getships = $this->db->select("shift_leg_id")->get_where("tb_shifts",array("id"=>$arr['ship']),1,0);
							if($getships->num_rows()>0){
								$shift_leg_id = $getships->row()->shift_leg_id;
								$getshipsstatus = "SELECT id,status FROM tb_shifts WHERE shift_leg_id='$shift_leg_id' ";
								$getshipsstatusRes = $this->db->query($getshipsstatus);
								if ($getshipsstatusRes->num_rows() > 0) {
									foreach ($getshipsstatusRes->result() as $shipsstatus) {
										if($shipsstatus->status==0){
											$shipmentstatus++;
										}

									}
								}
								if($getshipsstatusRes->num_rows()==$shipmentstatus){
									$upd = $this->db->where(array("id"=>$shift_leg_id))->update("tb_shifts",array("status"=>'0'));
								}

							}

					}

				}







                $postdata = array(
                    "shipment_id" => $arr['ship'],
                    "trip_id"     => $arr['trip'],
                    "driver_id"   => $arr["driver_id"],
                    "stop_id"     => '',
                    "order_id"    => $arr['orderid'],
                    "latitude"    => $latitude,
                    "longitude"   => $longitude,
                    "curtz"   => $curtz,
                    "hrs" => $hrs,
                    "web"  => $seldt
                );
                /*send to roadlog*/
                if($createdsource == "18"){
                    $sts = $this->statusintigration->roadlogshipmenttripdelivered($postdata);
                }
                if($createdsource == "12"){
                    $sts = $this->macdamstatusintigration->macdamshipmenttripdelivered($postdata);
                } else if($createdsource == "11") {
                    $sts = $this->knlogin->knloginshipmentstatus($postdata);
                }
               /* // $this->sendnotify('delivery_note',$arr['ord_id']);
                $chkmuliti = $this->db->select("id")->get_where("tb_orders",array("shift_id"=>$arr['ship'],"trip_sts"=>'0'));
                if($chkmuliti->num_rows()>1){
                    $upd = $this->db->where(array("id"=>$leg_ord_id,"trip_id !="=>0))->update("tb_orders",array("trip_sts"=>'1'));
                }else{
                    $updwhr  = array("id" => $arr['ship']);
                    $upddata = array("status" => '0', "updated_on" => $curdt);
                    $upd = $this->db->set($upddata)->where($updwhr)->update("tb_shifts");
                    $data1 = array();
                    $tdata = array("id"=>$arr['trip']);
                    $data1["end_imei"] = $arr['contact_num'];
                    $data1["end_reading"] = '0';
                    $data1["etime"] = $data1["updated_on"] = $curdt;
                    $data1["status"] = '0';
                    $data1["transit_status"] = '1';
                    $res = $this->db->set($data1)->where($tdata)->update("tb_trips");
                    $upd = $this->db->where(array("shift_id"=>$arr['ship']))->update("tb_orders",array("trip_sts"=>'1'));
                    $gensum = $this->generatesummary($arr['trip'],$curtz);
                } */
                $resultsts = 1;
            }
        }


				}
			}else{
				 $resultsts = 3;
			}


		}
        try {
            $this->standard_status_execution->sendStandardXMLtoAltova($arr);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
        }

	}


       echo $resultsts;

	  // print_r($this->db->queries);
    }

/* Trip Status Bar Code Ends Here */

    public function getnoshiporders()
    {
        try {
            $border_type=isset($_POST['border_type'])==""?"":$_POST['border_type'];
            $orders_info = $orders = array();
            $limit = $start = 0;
            if ($this->userRoleId === "5" && $this->departmentCode != "") {
                $orders_info = $this->trips_model->getOrderDetailsForKNOps(['companyCode' => $this->companyCode, 'branchCode' => $this->branchCode, 'departmentCode' => $this->departmentCode]);
            } else {
                if ($this->userId != "0") {
                    if ($border_type == 0) {
                        $userId = $this->session->userdata('user_id');
                        $company_code = $this->session->userdata('company_code');
                        $where = ['status' => '1', 'shift_id' => '0', 'trip_id' => '0', 'company_code' => $company_code];
                    } else {
                        $where = ['status' => '1', 'shift_id' => '0', 'trip_id' => '0'];
                    }

                    $table = "tb_orders";
                    $select = "id,order_id,pickup_company,delivery_company,quantity,weight,volume,transport_mode,";
                    $orders_info = $this->common->gettbldata($where, $select, $table, $limit, $start);
                }
            }
            if (!empty($orders_info)) {
                foreach ($orders_info as $res) {
                    $checkbox = "<input type='checkbox' class='noshift_list' name='noshift_list[]' value='" . $res['id'] . "' id='noshift_" . $res['id'] . "'>";
                    $orders[] = array('checkbox' => $checkbox, 'id' => $res['id'], 'order_id' => $res['order_id'], 'pickup_company' => $res['pickup_company'], 'delivery_company' => $res['delivery_company'], 'quantity' => $res['quantity'], 'weight' => $res['weight'], 'volume' => $res['volume'], 'transport_mode' => $res['transport_mode']);
                }
            }
            echo json_encode($orders);
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * Fetches Order Details by Order Id
     */
    public function getorderdetailsbyid()
    {
        try {
            $post = $this->input->post(null, true);
            $order_id = $post['order_id'] ?? 0;
            $data = [];
            if ($order_id > 0) {
                $getid = $this->common->gettblrowdata(['id' => $order_id], "order_id, pickup_datetime,delivery_datetime,pickup_company,delivery_company,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address1,delivery_address1,pickup_address2,delivery_address2,shift_id", 'tb_orders', 0, 0);
                if (!empty($getid)) {
                    $shift_id = $getid['shift_id'];
                    if ($shift_id > 0) {
                        $tbemployee = $this->common->gettbldata(['order_id' => $getid['order_id'], 'status' => '1'], "shift_id", "tb_employee", 0, 0);
                        $data['legs'] = $tbemployee;
                    }
                    $data['orders'] = [
                        'pname' => $getid['pickup_company'],
                        'dname' => $getid['delivery_company'],
                        'pcountry' => $getid['pickup_country'],
                        'dcountry' => $getid['delivery_country'],
                        'pcity' => $getid['pickup_city'],
                        'dcity' => $getid['delivery_city'],
                        'ppincode' => $getid['pickup_pincode'],
                        'dpincode' => $getid['delivery_pincode'],
                        'pstreet' => $getid['pickup_address1'],
                        'pstate' => $getid['pickup_address2'],
                        'dstreet' => $getid['delivery_address1'],
                        'dstate' => $getid['delivery_address2']
                    ];
                }
            }
            echo json_encode($data);
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * Create the legs for shipment
     */
    public function createLegs()
    {
        try {
			$shiftId = $_POST['shift_id'] ?? "0";
			$carrier_type = $_POST['carrier_type'] ?? "0";
			$border_type = $_POST['border_type'] ?? "0";
			$company_code = $_POST['company_code'] ?? "0";
			$branch_code = $_POST['branch_code'] ?? "0";
			$department_code = $_POST['department_code'] ?? "0";
			$tripsdata = $_POST['tripsdata'] ?? [];
			$curdt = date('Y-m-d H:i:s');
			$userid = $this->session->userdata('user_id');
			$params = array("carrier_type"=>$carrier_type,"border_type"=>$border_type,"company_code"=>$company_code,"branch_code"=>$branch_code,"department_code"=>$department_code,'updated_on' => $curdt);
            $update = $this->trips_model->updatedata('tb_shifts', $shiftId, $params);
			$getshipmentid = $this->common->gettblrowdata(array('id' => $shiftId), "shipmentid,customer_id", 'tb_shifts', 0, 0);
			if (!empty($getshipmentid)) {
					$shipmentid = $getshipmentid['shipmentid'];
					$customer_id = $getshipmentid['customer_id'];
			}
			$plat = $plng = $dlat = $dlng = "";
			$capacity = "0";
			$legsdatainfo='';
			$legsdatashipinfo='';
            $userTimeZone = $this->session->userdata( "usr_tzone" )['timezone'];
			for($i=0, $iMax = count($tripsdata); $i< $iMax; $i++){

				for($j=0, $jMax = count($tripsdata[$i]); $j< $jMax; $j++){
					$leg_id=$tripsdata[$i][$j]['leg_id'];
					$vendor_id=$tripsdata[$i][$j]['vendor_id'];
					$vehicle_type=$tripsdata[$i][$j]['vehicle_type'];
					$vehicle_id=$tripsdata[$i][$j]['vehicle_id'];
					$driver_id=$tripsdata[$i][$j]['driver_id'];
					$splace=$tripsdata[$i][$j]['splace'];
					$startdate=$tripsdata[$i][$j]['startdate'];
					$eplace=$tripsdata[$i][$j]['eplace'];
					$enddate=$tripsdata[$i][$j]['enddate'];
					$leg_number_value=$tripsdata[$i][$j]['leg_number_value'];
					$shipper_row_id=$tripsdata[$i][$j]['shipper_row_id'];
					$drop_row_id=$tripsdata[$i][$j]['drop_row_id'];
					$modeof_transport=$tripsdata[$i][$j]['modeof_transport'];
                    $starttime = $endtime = "";
                    if ($startdate != "") {
                        $startdate = date('Y-m-d H:i:s', strtotime($startdate));
                        $getUtcStartDate = getdatetimebytimezone(DFLT_TZ, $startdate, $userTimeZone);
                        $startdate = $getUtcStartDate['datetime'];
                        $starttime = date('H:i', strtotime($getUtcStartDate['time']));
                    }
                    $shipdata=($i+1);
                    $getVendordata = $this->common->gettblrowdata(['id' => $vendor_id], "company_code,branch_code,user_id", 'tb_vendors', 0, 0);
                    if (!empty($getVendordata)) {
                        $company_code = $getVendordata['company_code'];
                        $branch_code = $getVendordata['branch_code'];
                        $userid = $getVendordata['user_id'];
                    }
                    $selectPartyMaster = "id,code,location_id,address,country,street,pincode,latitude,longitude";
                    $partyMasterTable = "tbl_party_master";
                    $pickupCode = $dropCode = "";
                    $getpickupdata = $this->common->gettblrowdata(['code' => $shipper_row_id], $selectPartyMaster, $partyMasterTable, 0, 0);
                    if (!empty($getpickupdata)) {
                        $pickup_city = $getpickupdata['location_id'];
                        $plat = $getpickupdata['latitude'];
                        $plng = $getpickupdata['longitude'];
                        $paddress = $getpickupdata['address'];
                        $legshipper_row_id = $getpickupdata['id'];
                        $pickupCode = $getpickupdata['code'];
                    } else {
                        $getpickupdata = $this->common->gettblrowdata(['id' => $shipper_row_id], $selectPartyMaster, $partyMasterTable, 0, 0);
                        if (!empty($getpickupdata)) {
                            $pickup_city = $getpickupdata['location_id'];
                            $plat = $getpickupdata['latitude'];
                            $plng = $getpickupdata['longitude'];
                            $paddress = $getpickupdata['address'];
                            $legshipper_row_id = $getpickupdata['id'];
                            $pickupCode = $getpickupdata['code'];
                        }
                    }
                    $getdropdata = $this->common->gettblrowdata(['code' => $drop_row_id], $selectPartyMaster, $partyMasterTable, 0, 0);
                    if (!empty($getdropdata)) {
                        $delivery_city = $getdropdata['location_id'];
                        $dlat = $getdropdata['latitude'];
                        $dlng = $getdropdata['longitude'];
                        $dropaddr = $getdropdata['address'];
                        $legdrop_row_id = $getdropdata['id'];
                        $dropCode = $getdropdata['code'];
                    } else {
                        $getdropdata = $this->common->gettblrowdata(['id' => $drop_row_id], $selectPartyMaster, $partyMasterTable, 0, 0);
                        if (!empty($getdropdata)) {
                            $delivery_city = $getdropdata['location_id'];
                            $dlat = $getdropdata['latitude'];
                            $dlng = $getdropdata['longitude'];
                            $dropaddr = $getdropdata['address'];
                            $legdrop_row_id = $getdropdata['id'];
                            $dropCode = $getdropdata['code'];
                        }
                    }
                    if (in_array("", [$plat, $plng])) {
                        $pickupCity = $getpickupdata['location_id'] ?? "";
                        $pickupCountry = $getpickupdata['country'] ?? "";
                        $pickupStreet = $getpickupdata['street'] ?? "";
                        $pickupPincode = $getpickupdata['pincode'] ?? "";
                        if (!in_array('', [$pickupStreet, $pickupCity, $pickupCountry, $pickupPincode])) {
                            $add1 = implode(",", [$pickupStreet, $pickupCity, $pickupCountry, $pickupPincode]);
                            $data = getlatlngsbyplace($add1);
                            $plat = @$data[0];
                            $plng = @$data[1];
                        }
                    }
                    if (in_array("", [$dlat, $dlng])) {
                        $deliveryCity = $getdropdata['location_id'] ?? "";
                        $deliveryCountry = $getdropdata['country'] ?? "";
                        $deliveryStreet = $getdropdata['street'] ?? "";
                        $deliveryPincode = $getdropdata['pincode'] ?? "";
                        if (!in_array('', [$deliveryStreet, $deliveryCity, $deliveryCountry, $deliveryPincode])) {
                            $add2 = implode(",", [$deliveryStreet, $deliveryCity, $deliveryCountry, $deliveryPincode]);
                            $data = getlatlngsbyplace($add2);
                            $dlat = @$data[0];
                            $dlng = @$data[1];
                        }
                    }

                    if ($enddate != "") {
                        $enddate = date('Y-m-d H:i:s', strtotime($enddate));
                        $getUtcEndDate = getdatetimebytimezone(DFLT_TZ, $enddate, $userTimeZone);
                        $enddate = $getUtcEndDate['datetime'];
                        $endtime = date('H:i', strtotime($getUtcEndDate['time']));
                    }
                    if ($i === 0 && $j === 0) {
                        $mainTripUpdate['startdate'] = $startdate;
                        $mainTripUpdate['stime'] = $mainTripUpdate['empshift_start'] = $starttime;
                        if ($pickupCode) {
                            $mainTripUpdate['origin_id'] = $pickupCode;
                        }
                    }
                    $mainTripUpdate['enddate'] = $enddate;
                    $mainTripUpdate['etime'] = $mainTripUpdate['empshift_end'] = $endtime;
                    if ($dropCode != "") {
                        $mainTripUpdate['destination_id'] = $dropCode;
                    }

					if($vendor_id!=0 || $splace!="" || $eplace!="" || $startdate!="" || $enddate!=""){
						if($leg_id==0){
							$shipid=$shipmentid."-".$shipdata;
							$insarr = array('user_id'=>$userid, 'stime'=>$starttime, 'etime'=>$endtime, 'splace'=>$splace, 'slat'=>$plat, 'slng'=>$plng, 'eplace'=>$eplace, 'elat'=>$dlat, 'elng'=>$dlng, 'scity'=>$splace, 'dcity'=>$eplace, 'zone_id'=>1, 'empshift_start'=>$starttime, 'empshift_end'=>$endtime, 'trip_type'=>0, 'startdate'=>$startdate, 'enddate'=>$enddate, 'shipment_name'=>'Boxes', 'shipment_id'=>0, 'vendor_id'=>$vendor_id, 'carrier_type'=>$carrier_type,'border_type'=>$border_type, 'shipmentid'=>$shipid, 'txnid'=>$shipid, 'domainname'=>'INFD', 'vehicle_type'=>$vehicle_type,'company_code'=>$company_code,'branch_code'=>$branch_code,'department_code'=>$department_code,'shift_leg_id'=>$shiftId,'customer_id'=>$customer_id, 'transport_mode'=>$modeof_transport , 'status'=>1);
							$ship_id = $this->common->insertTableData("tb_shifts", $insarr);
						   $legsdatainfo.=$ship_id.",";
						   $legsdatashipinfo.=$shipid.',';

						}else{
							$shipid=$leg_number_value;
							$ship_id=$leg_id;
							$legsdatainfo.=$ship_id.",";
						    $legsdatashipinfo.=$shipid.',';
							$updarr = array('user_id'=>$userid, 'stime'=>$starttime, 'etime'=>$endtime, 'splace'=>$splace, 'slat'=>$plat, 'slng'=>$plng, 'eplace'=>$eplace, 'elat'=>$dlat, 'elng'=>$dlng, 'scity'=>$splace, 'dcity'=>$eplace, 'zone_id'=>1, 'empshift_start'=>$starttime, 'empshift_end'=>$endtime, 'trip_type'=>0, 'startdate'=>$startdate, 'enddate'=>$enddate, 'shipment_name'=>'Boxes', 'shipment_id'=>0, 'vendor_id'=>$vendor_id, 'carrier_type'=>$carrier_type,'border_type'=>$border_type, 'shipmentid'=>$shipid, 'txnid'=>$shipid, 'domainname'=>'INFD', 'vehicle_type'=>$vehicle_type,'company_code'=>$company_code,'branch_code'=>$branch_code,'department_code'=>$department_code, 'shift_leg_id'=>$shiftId,'customer_id'=>$customer_id, 'transport_mode'=>$modeof_transport ,'status'=>1);
							$upd = $this->common->updatetbledata("tb_shifts", $updarr,array("id"=>$ship_id));

						}

						 /*insert stops records */
						$where = array("shipment_id"=>$ship_id,"stopcity"=>$splace,"stoptype"=>"P");
						$select = "id";
						$table = "tb_shiporder_stops";
						$chkstop = $this->common->gettblrowdata($where,$select,$table,0,0);
						if(count($chkstop) == 0){
							$insarr = array('stopname'=>$splace, 'plat'=>$plat, 'plng'=>$plng, 'stopcity'=>$splace, 'address'=>$paddress, 'stoptype'=>'P', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>1, 'startdate'=>$startdate, 'enddate'=>$enddate, 'shipmentstopid'=>0, 'txncode'=>'NP', 'status'=>1, 'created_on'=>$curdt,'stop_party_id'=>$legshipper_row_id);
							$ins = $this->db->insert("tb_shiporder_stops",$insarr);
							$pickupstop_id = $this->db->insert_id();
						}else{
							$pickupstop_id = $chkstop['id'];
							$insarr = array('stopname'=>$splace, 'plat'=>$plat, 'plng'=>$plng, 'stopcity'=>$splace, 'address'=>$paddress, 'stoptype'=>'P', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>1, 'startdate'=>$startdate, 'enddate'=>$enddate, 'shipmentstopid'=>0, 'txncode'=>'NP', 'status'=>1, 'created_on'=>$curdt,'stop_party_id'=>$legshipper_row_id);
							$ins = $this->common->updatetbledata("tb_shiporder_stops",$insarr,array("id"=>$pickupstop_id));
						}

						$where = array("shipment_id"=>$ship_id,"stopcity"=>$delivery_city,"stoptype"=>"D");
						$select = "id";
						$table = "tb_shiporder_stops";

						$chkstop = $this->common->gettblrowdata($where,$select,$table,0,0);
						if(count($chkstop) == 0){
							$insarr = array('stopname'=>$delivery_city, 'plat'=>$dlat, 'plng'=>$dlng, 'stopcity'=>$delivery_city, 'address'=>$dropaddr, 'stoptype'=>'D', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>2, 'startdate'=>$enddate, 'enddate'=>$enddate,  'shipmentstopid'=>0, 'txncode'=>'NP', 'status'=>1, 'created_on'=>$curdt,'stop_party_id'=>$legdrop_row_id);
							$ins = $this->db->insert("tb_shiporder_stops",$insarr);
							$dropstop_id = $this->db->insert_id();
						}else{
							$dropstop_id = $chkstop['id'];
							$insarr = array('stopname'=>$delivery_city, 'plat'=>$dlat, 'plng'=>$dlng, 'stopcity'=>$delivery_city, 'address'=>$dropaddr, 'stoptype'=>'D', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>2, 'startdate'=>$enddate, 'enddate'=>$enddate, 'shipmentstopid'=>0, 'txncode'=>'NP', 'status'=>1, 'created_on'=>$curdt,'stop_party_id'=>$legdrop_row_id);
							$ins = $this->common->updatetbledata("tb_shiporder_stops",$insarr,array("id"=>$dropstop_id));
						}

						if($vehicle_id !=0){
							$chk1 = $this->db->select("id")->get_where("tb_shft_veh",array("shft_id"=>$ship_id),1,0);
							if($chk1->num_rows() > 0){
								$shftvehid = $chk1->row()->id;
								$veh_num =  "";
								$arr = array('user_id'=>$userid, 'route_id'=>0, 'shft_id'=>$ship_id, 'carrier_id'=>$vendor_id, 'vehicle_id'=>$vehicle_id, 'register_number'=>$veh_num, 'created_on'=>$curdt,'updated_on'=>$curdt, 'status'=>1);
								 $this->common->updatetbledata("tb_shft_veh",$arr,array("id"=>$shftvehid));

							}else{
								if($vehicle_id !=0){
									$veh_num =  "";
									$arr = array('user_id'=>$userid, 'route_id'=>0, 'shft_id'=>$ship_id, 'carrier_id'=>$vendor_id, 'vehicle_id'=>$vehicle_id, 'register_number'=>$veh_num, 'created_on'=>$curdt,'updated_on'=>$curdt, 'status'=>1);
									$shftvehid = $this->common->insertTableData("tb_shft_veh",$arr);
							  }
							}
						}
                        $checkshiftveh=$this->db->select("tsd_id")->get_where("tb_shift_drivers",array("shift_id"=>$ship_id,"main_shift_id"=>$shiftId));
                        if($checkshiftveh->num_rows()==0){
                            $arr = array("vehicle_id"=>$vehicle_id,"driver_id"=>$driver_id,"shift_id"=>$ship_id,"main_shift_id"=>$shiftId,"vendor_id"=>$vendor_id,"shift_priority"=>$shipdata);
                            $ins = $this->common->insertTableData("tb_shift_drivers",$arr);
                        }else{
                            $shftvehid = $checkshiftveh->row()->tsd_id;
                            $arr = array("vehicle_id"=>$vehicle_id,"driver_id"=>$driver_id,"shift_id"=>$ship_id,"main_shift_id"=>$shiftId,"vendor_id"=>$vendor_id,"shift_priority"=>$shipdata);
                            $ins = $this->common->updatetbledata("tb_shift_drivers",$arr,array("tsd_id"=>$shftvehid));
                        }
                        if (!in_array('0', [$vehicle_id, $driver_id])) {
                            $this->triptemplatemodel->updateVehicleDriversData(['vehicleId' => $vehicle_id, 'driverId' => $driver_id, 'userId' => $userid, 'date' => $curdt]);
                        }
					}
				}
			}
            if(!empty($mainTripUpdate)){
                $updateTrip = $this->common->updatetbledata("tb_shifts", $mainTripUpdate, ['id'=>$shiftId]);
            }
		// log_message("error","createLegs".json_encode($this->db->queries));
			echo json_encode(array("status" => "1", "shipment_id" => $shiftId, "legsdatainfo"=>$legsdatainfo,"legsdatashipinfo"=>$legsdatashipinfo ));


        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * Soft Delete Shift
     */
    public function delete()
    {
        try {
            $shiftId = $this->uri->segment(3);
            $data['status'] = 0;
            $curdt = date('Y-m-d H:i:s');
            $params = array('status' => 0, 'updated_on' => $curdt);
            $update = $this->trips_model->updatedata('tb_shifts', $shiftId, $params);
            if ($update) {
                $data['status'] = 1;
            }

            echo json_encode($data);
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * Adds new order(s)
     */
    public function addorders()
    {
        try {
            $ids = $this->input->post('orderids',true);
            $shiftId = $this->input->post('shift_id',true);

            $orderIds = explode(',', $ids);
            $response = $this->trips_model->addOrder($orderIds, $shiftId);

            if ($response) {
                $data['status'] = 1;
            }
            echo json_encode($data);
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

/* Add Trip legs */
    public function addtriplegs()
    {
        $post = $this->input->post(null, true);
        $branchCode = $this->session->userdata('branch_code');
        $postlegIds = $post['triplegs'] ?? [];
        $OrderId = $post['order_id'] ?? "";
        $deallocateOrders = $post['deallocateOrders'] ?? [];
        $triplegIdS = array_diff($postlegIds, $deallocateOrders);
        $currentDate = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), $this->currentTimeZone);
        $curdt = date('Y-m-d H:i:s', strtotime($currentDate['datetime']));
        if (!empty($deallocateOrders)) {
            $this->trips_model->deallocateOrderFromMultiLegs($OrderId, $deallocateOrders);
        }
        foreach ($triplegIdS as $triplegsId) {
            $ship_id = $legIdsForRates[] = $triplegsId;
            $select = "SELECT ts.id,ts.`shipmentid`,ts.`vendor_id`,ts.vehicle_type,tsv.`vehicle_id`,tsd.driver_id,ts.user_id,ts.border_type,ts.company_code,ts.splace,ts.eplace,ts.slat,ts.slng,ts.elat,ts.elng,ts.startdate,ts.enddate FROM  tb_shifts ts LEFT OUTER JOIN tb_shft_veh tsv ON ts.id=tsv.shft_id LEFT OUTER JOIN tb_shift_drivers tsd ON tsd.vehicle_id=tsv.vehicle_id WHERE ts.id='$ship_id' GROUP BY ts.id";
            $shiftlegsRes = $this->db->query($select);
            $shiftlegsData = $shiftlegsRes->result_array();
            $weight = 0;
            $volume = 0;
            $ship_units = 0;

            foreach ($shiftlegsData as $res) {
                $shipmentid = $res['shipmentid'];
                $vendor_id = $res['vendor_id'];
                $vehicle_id = $res['vehicle_id'];
                $driver_id = $res['driver_id'];
                $tpvehicle_type = $res['vehicle_type'];
                $userid = $res['user_id'];
                $company_code = $res['company_code'];
                $border_type = $res['border_type'];
                $splace = $res['splace'];
                $eplace = $res['eplace'];
                $plat = $res['slat'];
                $plng = $res['slng'];
                $dlat = $res['elat'];
                $dlng = $res['elng'];
                $startdate = $res['startdate'];
                $enddate = $res['enddate'];

                $where = ["id" => $OrderId];
                $select = "*";
                $table = "tb_orders";
                $order = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                $sid = $OrderId;
                if (count($order) > 0) {
                    if ($border_type == 1) {
                        $insarrres = ['order_id' => $OrderId, 'reference_id' => "XBRDR", 'ref_value' => $company_code, 'status' => 1, 'createdon' => $curdt];
                        $ins = $this->db->insert("tb_order_references", $insarrres);
                        $notificationData = ['order_id' => $OrderId, 'company_code' => $company_code, 'branch_code' => $branchCode, 'xborder_reference' => $company_code];
                        $ins = $this->db->insert("xborder_notifications", $notificationData);
                        $checkNotificationReferences = $this->common->gettblrowdata(['order_id' => $OrderId, 'xborder_reference' => $company_code, 'status' => 1], "id", "xborder_notifications", 0, 0);
                        if (empty($checkNotificationReferences)) {
                            $ins = $this->common->insertTableData("xborder_notifications", ['order_id' => $OrderId, 'company_code' => $company_code, 'branch_code' => $branchCode, 'xborder_reference' => $company_code, 'status' => 1, 'createdon' => $curdt]);
                        }
                        $checkReferences = $this->common->gettblrowdata(['reference_id' => "XBRDR", 'ref_value' => $company_code, 'order_id' => $OrderId, 'status' => 1], "id", "tb_order_references", 0, 0);
                        if (empty($checkReferences)) {
                            $ins = $this->common->insertTableData("tb_order_references", ['order_id' => $OrderId, 'reference_id' => "XBRDR", 'ref_value' => $company_code, 'status' => 1, 'createdon' => $curdt]);
                        }
                    }
                    /*update stops records */
                    $where = ["shipment_id" => $ship_id, "stopcity" => $splace, "stoptype" => "P"];
                    $getpickup_stop_idres = $this->db->select("id,weight,ship_units,volume,address")->get_where("tb_shiporder_stops", $where, 1, 0);
                    if ($getpickup_stop_idres->num_rows() > 0) {
                        $pickupstop_id = $getpickup_stop_idres->row()->id;
                        $pickup = $getpickup_stop_idres->row()->address;
                        $weight = $getpickup_stop_idres->row()->weight;
                        $ship_units = $getpickup_stop_idres->row()->ship_units;
                        $volume = $getpickup_stop_idres->row()->id;
                    }


                    $weight += $order['weight'];
                    $volume += $order['volume'];
                    $ship_units += $order['quantity'];

                    $where = ["shipment_id" => $ship_id, "stopcity" => $eplace, "stoptype" => "D"];
                    $getdrop_stop_idres = $this->db->select("id,address")->get_where("tb_shiporder_stops", $where, 1, 0);
                    if ($getdrop_stop_idres->num_rows() > 0) {
                        $dropstop_id = $getdrop_stop_idres->row()->id;
                        $delivery = $getdrop_stop_idres->row()->address;
                    }

                    $updshiporderarr = ['weight' => $weight, 'volume' => $volume, 'ship_units' => $ship_units];
                    $upd = $this->common->updatetbledata("tb_shiporder_stops", $updshiporderarr, ["id" => $pickupstop_id]);
                    $upd = $this->common->updatetbledata("tb_shiporder_stops", $updshiporderarr, ["id" => $dropstop_id]);

                    $capacity = $order['weight'];
                    if ($capacity == "") {
                        $capacity = "0";
                    }

                    $customer_id = $order['customer_id'];
                    $updarr = ['weight' => $weight, 'volume' => $volume, 'units' => $ship_units, 'customer_id' => $customer_id];

                    $upd = $this->common->updatetbledata("tb_shifts", $updarr, ["id" => $ship_id]);

                    if ($pickup == "") {
                        $pickup = $order['pickup_city'];
                    }
                    if ($delivery == "") {
                        $delivery = $order['delivery_city'];
                    }

                    /*add pickupstop and drop stop id into details/tb_employee table */
                    $where = ['stop_id' => $pickupstop_id, 'drop_stopid' => $dropstop_id, 'order_id' => $order['order_id'], 'shift_id' => $ship_id];
                    $select = "id";
                    $table = "tb_employee";
                    $chkemp = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    $insarr = [
                        'assoc_id' => $shipmentid,
                        'pickup' => $pickup,
                        'plat' => $plat,
                        'plng' => $plng,
                        'drop' => $delivery,
                        'dlat' => $dlat,
                        'dlng' => $dlng,
                        'pickup_city' => $splace,
                        'drop_city' => $eplace,
                        'pickup_datetime' => $startdate,
                        'drop_datetime' => $enddate,
                        'name' => 'Boxes',
                        'phone' => $order['customer_phone'],
                        'address' => $pickup,
                        'emailid' => $order['customer_email'],
                        'user_id' => $userid,
                        'status' => 1,
                        'createdon' => $curdt,
                        'material_id' => 0,
                        'capacity' => $capacity,
                        'information' => $order['customer_comments'],
                        'shipment_weight' => $order['weight'],
                        'shipment_volume' => $order['volume'],
                        'ship_type' => 'P',
                        'customer_id' => $order['customer_id'],
                        'vendor_id' => $vendor_id,
                        'shipment_id' => 0,
                        'startdate' => $startdate,
                        'enddate' => $enddate,
                        'shift_id' => $ship_id,
                        'stop_order' => 1,
                        'drop_order' => 0,
                        'basic_stop' => 0,
                        'stop_id' => $pickupstop_id,
                        'drop_stopid' => $dropstop_id,
                        'order_id' => $order['order_id'],
                        'pkgitemid' => 'BOXES',
                        'no_of_pkgs' => $order['quantity'],
                        'domainname' => 'INFD'
                    ];
                    if (empty($chkemp)) {
                        $detail_id = $this->common->insertTableData("tb_employee", $insarr);
                    } else {
                        $detail_id = $chkemp['id'];
                        $update = $this->common->updatetbledata("tb_employee", $insarr, ['id' => $detail_id]);
                    }
                    $stops_units = $this->db->query("SELECT oc.id,oc.quantity,oc.width,oc.height,oc.length,oc.weight,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.order_id = '$sid' AND im.id = oc.handling_unit AND oc.status='1'");

                    if ($stops_units->num_rows() > 1) {
                        $odata = $stops_units->row();
                        $upd = $this->db->query("UPDATE tb_order_cargodetails set stop_detail_id='$detail_id' WHERE id = '" . $odata->id . "'");
                    }

                    if ($vehicle_id != 0 && $driver_id != 0) {
                        $vehar = ['vehicle_id' => $vehicle_id, 'status' => 1];
                        $chkdrivers = $this->db->select("driver_id")->get_where("tb_vehicles_drivers", $vehar, 1, 0);
                        if ($chkdrivers->num_rows() > 0) {
                            $veharr1 = ['vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status' => 1];
                            $chkveh1 = $this->db->select("id")->get_where("tbl_assigned_drivers", $veharr1, 1, 0);
                            if ($chkveh1->num_rows() == 0) {
                                $insveh1 = ["vehicle_id" => $vehicle_id, "user_id" => $userid, "driver_id" => $driver_id, "from_time" => $curdt, "to_time" => $curdt, "status" => 1, 'created_on' => $curdt, 'updated_on' => $curdt];
                                $ins = $this->db->insert("tbl_assigned_drivers", $insveh1);
                            }
                        }
                    }


                    /* update status */
                    $chk = $this->db->select("id")->get_where("tb_stop_status", ["shipment_id" => $ship_id, "order_id" => $sid, "status_id" => 9], 1, 0);
                    if ($chk->num_rows() == 0) {
                        $ins = ["shipment_id" => $ship_id, "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => 0, "status_id" => 9, "status" => 1, "status_code" => "0100", "order_id" => $sid, "reason" => "Coming from E-Booking", "createdon" => $curdt];
                        $insqry = $this->common->insertTableData("tb_stop_status", $ins);
                    }
                }
            }
        }
        $data['status'] = 1;
        $this->rateformultilegs->checkRatePreferenceForLegs($legIdsForRates ?? [], $OrderId);
        echo json_encode($data);
    }

    /**
     * Deletes an Order
     */
    public function deleteOrder()
    {
        try {
            $orderId = $this->input->post('order_id',true);
            $shiftId = $this->input->post('shift_id',true);
            $update = $this->trips_model->updateOrder($orderId, $shiftId);

            if ($update) {
                $refs = new OrderReference();
                $refs->deleteForOrder($orderId, ['DQ']);

                $data['status'] = 1;
            }

           echo json_encode($data);
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
    * This method fetches Order Documents
    */
    public function orddocsdetails()
    {
        try {
            $status = array();
            $shiftId = $this->input->post('shift_id');

			$ordersIds = $this->trips_model->getOrdersByShiftId($shiftId);
			foreach($ordersIds as $order_id){
				$getorderid=$this->db->query("select id,order_id from tb_orders where id='$order_id'");
				if ($getorderid->num_rows() > 0) {
					foreach ($getorderid->result() as $getorderres) {
						$getorderrid=$getorderres->order_id;
					}
				}


				$curtz = $this->session->userdata("usr_tzone")['timezone'];
				$sql1 = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,ts.createdon,ts.imgpath,ts.order_id,ts.user_id from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type WHERE ts.order_id = $order_id AND ts.status='1' GROUP BY ts.id");
				if ($sql1->num_rows() > 0) {
					foreach ($sql1->result() as $res) {
						if($res->latitude!="" && $res->longitude!=""){
							$location_name = getLocationName($res->latitude, $res->longitude);
						}else{
							$location_name="";
						}


						if($location_name==''){
								$where = array("order_id"=>$getorderrid);
								$getlocation=$this->db->select(" `pickup`,`drop`")->get_where("tb_employee",$where,1,0);
								if($getlocation->num_rows()>0){
									if($res->stop_type=='P'){
										$location_name = $getlocation->row()->pickup;
									}
									if($res->stop_type=='D'){
										$location_name = $getlocation->row()->drop;
									}


								}

						}

						$imgpath = "";
						$allowed = array('pdf');
						if ($res->imgpath != "") {
                            $base64DocumentData = getBase64DocumentData($res->imgpath);
                            $extention = $base64DocumentData['extention'];
                            $stringData = "'".$base64DocumentData['file_content']."',"."'".$extention."'";
                            if ($extention!= "") {
                                if (in_array($extention, $allowed)) {
                                    $path = '<a onclick="return downloadDocument(' . $stringData . ')"> <img src="' . base_url('assets/img/docstore.png') . '" class="img-responsive" style="width: 10%;" type="application/pdf"></a>';
                                } else {
                                    $path = '<a onclick="return downloadDocument(' . $stringData . ')"><img src="' . $base64DocumentData['file_content'] . '" class="img-responsive" style="width: 10%;"></a>';
                                }
                            }
							$driver = getDrivernameById($res->createdby)["name"];
							if($driver==""){
								if($res->user_id!=0){
									$where = array("id"=>$res->user_id);
									$getuser=$this->db->select("name")->get_where("tb_users",$where,1,0);
									if($getuser->num_rows()>0){
										$driver = $getuser->row()->name;

									}
								}else{
									$where = array("id"=>$this->session->userdata("user_id"));
									$getuser=$this->db->select("name")->get_where("tb_users",$where,1,0);
									if($getuser->num_rows()>0){
										$driver = $getuser->row()->name;

									}
								}

							}
							$action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' style='left: 0 !important;' role='menu'><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowshipdocAdd(this," . $shiftId . ");'><span class='glyphicon glyphicon-plus' > </span>Add Doc</a></li></li></ul>";
							$status[] = array('id' => $res->id, 'type_name' => $res->type_name, 'imgpath' => $path ?? "", 'stop_id' => $res->stop_id, 'stop_type' => $res->stop_type, 'date' => date("d M,y h:i A", strtotime($res->createdon)), 'action' => $action, 'location' => $location_name, 'driver' => $driver,"order_id"=>$getorderrid);
						}
					}
				}
			}

            echo json_encode($status);
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    public function addorderdoc() {
        $post = $this->input->post(null, true);
        $shiftId = $post['shift_id'] ?? 0;
        $data['stops'] = $data['document_types'] = [];
        $data['booking_id'] = $data['shift_id'] = $data['trip_id'] = $booking_id = 0;
        $data['company_code'] = $data['branch_code'] = "";
        $ordersIds = $this->trips_model->getOrderDetailsForKNOps([], $shiftId);
        foreach ($ordersIds as $eachId) {
            $data['orders'][] = ["orderid" => $eachId['id'], "ordernumber" => $eachId['order_id'], 'department_code' => $eachId['department_code']];
            $data['order_row_id'] = $eachId['id'];
            $data['booking_id'] = $booking_id = $eachId['order_id'];
            $data['company_code'] = $eachId['company_code'];
            $data['branch_code'] = $eachId['branch_code'];
            $data['shift_id'] = $eachId['shift_id'];
            $data['trip_id'] = $eachId['trip_id'];
            $sql = "SELECT o.id,o.stopname FROM tb_shiporder_stops o,tb_employee e WHERE o.shipment_id=e.shift_id AND e.order_id='" . $booking_id . "' AND o.status=1 AND e.status=1 ORDER BY o.ordernumber ASC";
            $stops = $this->db->query($sql);
            if ($stops->num_rows() > 0) {
                $data['stops'] = $stops->result_array();
                $data['document_types'] = $this->db->select("id,type_name")->get_where("tb_document_types", ["status" => 1])->result_array();
            } else {
                $data['document_types'] = $this->db->select("id,type_name")->get_where("tb_document_types", ["status" => 1, "type_name" => 'Others'])->result_array();
            }
        }
        echo json_encode($data);
    }
	public function getordercargodetails()
{
    $cargos   = array();
    $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "";
    if ($order_id != "") {
        $qry = $this->db->query("SELECT c.id,c.cargo_type,c.length_unit,c.width_unit,c.height_unit,c.weight_unit,c.volume_unit,c.goods_description,c.stackable,c.grounded,c.splittable,c.dg_goods,o.length,o.width,o.height,o.weight,o.volume,o.volumetric_weight,o.volweight_uom,c.ldm,o.quantity,o.scanned_quantity  FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='" . $order_id . "' AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC");

        if ($qry->num_rows() > 0) {
            foreach ($qry->result() as $res) {
                $stackable = 'Off';
                if ($res->stackable == 0) {
                    $stackable = 'Off';
                } else if ($res->stackable == 1) {
                    $stackable = 'On';
                }
                $grounded = 'Off';
                if ($res->grounded == 0) {
                    $grounded = 'Off';
                } else if ($res->grounded == 1) {
                    $grounded = 'On';
                }
                $splittable = 'Off';
                if ($res->splittable == 0) {
                    $splittable = 'Off';
                } else if ($res->splittable == 1) {
                    $splittable = 'On';
                }
                $dg_goods = 'Off';
                if ($res->dg_goods == 0) {
                    $dg_goods = 'Off';
                } else if ($res->dg_goods == 1) {
                    $dg_goods = 'On';
                }
                $cargo_type = '"' . $res->cargo_type . '"';

                $length_unit = '"' . $res->length_unit . '"';
                $width_unit = '"' . $res->width_unit . '"';
                $height_unit = '"' . $res->height_unit . '"';
                $weight_unit = '"' . $res->weight_unit . '"';
                $volume_unit = '"' . $res->volume_unit . '"';
                $volweight_uom = '"' . $res->volweight_uom . '"';
				$scanned_quantity = $res->scanned_quantity;
                if($scanned_quantity == ""){
                    $scanned_quantity = 0;
                }
                $getorderlegs = $this->trips_model->getOrderLegsByOrderRowId($order_id);
                $cargos[]   = array('cargo_type' => $res->cargo_type, 'quantity' => $res->quantity,'scanned_quantity'=>$scanned_quantity, 'length' => $res->length . " " . $res->length_unit, 'width' => $res->width . " " . $res->width_unit, 'height' => $res->height . " " . $res->height_unit, 'weight' => $res->weight . " " . $res->weight_unit, 'volume' => $res->volume . " " . $res->volume_unit,'volumetric_weight' => $res->volumetric_weight . " " . $res->volweight_uom,"ldm"=>$res->ldm,"orderlegs"=>$getorderlegs);
            }
        }

    }
	    //print_r($this->db->queries);
      echo json_encode($cargos);
}

/**
     * This method fetches lane_id, lane name based on service id
     * @param int service id
     * @return array
     */

	public function getlanevalues(){
		    //$lanevalues   = array();
			$service_id = isset($_POST['service_id']) ? $_POST['service_id'] : "";
			$lanevaluesQry = $this->db->query("SELECT tlm.id,tlm.`lane_id`,tlm.`lane_name` FROM tb_rate_offerings tro LEFT JOIN `tb_lanes_master` tlm ON tro.`lane_id`=tlm.id WHERE tro.`rate_service_id`='$service_id' GROUP BY tlm.id ORDER BY tlm.id ASC");
			 $lanevalues=$lanevaluesQry->result();
			 echo json_encode($lanevalues);

	}

	/**
     * This method fetches offering_id, offering_name based on service id
     * @param int rate_service and lane_id
     * @return array
     */

	public function getRateOffering(){
		    //$lanevalues   = array();
			$lanid = isset($_POST['lanid']) ? $_POST['lanid'] : "";
			$rate_service = isset($_POST['rate_service']) ? $_POST['rate_service'] : "";
			$offeringQry = $this->db->query("SELECT id,offering_id,offering_name FROM tb_rate_offerings WHERE `rate_service_id`='$rate_service' AND lane_id='$lanid' AND offering_active='1' AND tarrif_type='BUY' AND STATUS='1' GROUP BY id ORDER BY id ASC");
			 $offeringRes=$offeringQry->result();
			 echo json_encode($offeringRes);

	}
		/**
     * This method fetches rate cast values based on search option
     * @param int rate_service and lane_id
     * @return array
     */
	public function getcostratesdata(){
			$costrate_service = isset($_POST['costrate_service']) ? $_POST['costrate_service'] : "";
			$lane_id = isset($_POST['lane_id']) ? $_POST['lane_id'] : "";
			$costrate_offering = isset($_POST['costrate_offering']) ? $_POST['costrate_offering'] : "";
			$costrate_record = isset($_POST['costrate_record']) ? $_POST['costrate_record'] : "";
			$shift_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : "";
			$type = isset($_POST['type']) ? $_POST['type'] : "";
			$whr=array();
			if($costrate_service!=0){
				$whr['tro.rate_service_id']=$costrate_service;
			}
			if($lane_id!=0){
				$whr['tro.lane_id']=$lane_id;
			}
			if($costrate_offering!=0){
				$whr['tro.id']=$costrate_offering;
			}
			if($costrate_record!=0){
				$whr['trr.id']=$costrate_record;
			}
			if($shift_id!=0){
				$whr['tor.shift_id']=$shift_id;
			}
			if($type!=0){
				$whr['trev.type']=$type;
			}

			// get the trips rates/units as per the search options.
			$getcostratesdataRes = $this->trips_model->getratesbytrips($whr);
			//echo $this->db->last_query();
			echo json_encode($getcostratesdataRes);
	}

		/**
     * This method fetches lane_id, lane name based on service id
     * @param int service id
     * @return array
     */

	public function getrecord_byoffering(){
		$record = array();
		$offering_id =  isset($_POST['offering_id']) ? $_POST['offering_id'] : "";
		$record = array();
        $table = "tb_rate_records";
        $where = array('offering_id'=>$offering_id,'status'=>'1');
        $select = "id,rate_id,record_name";
        $getrecord = $this->common->gettbldata($where,$select,$table,0,0);
        if(!empty($getrecord)){
            foreach($getrecord as $res){
                $recordname = $res['rate_id']."-".$res['record_name'];

                $record[] = array('record_row_id'=>$res['id'],'record_name'=>$recordname);
            }

        }
		echo json_encode($record);

	}

	  /**
     * This method fetches all vehicles from master table
     * @param $userId Integer
     * @return array
     */

	function getorderdetails(){

		 try {
			$order_id =  isset($_POST['order_id']) ? $_POST['order_id'] : "";
			$purchase_order =  isset($_POST['purchase_order']) ? $_POST['purchase_order'] : "";
			$delivery_note =  isset($_POST['delivery_note']) ? $_POST['delivery_note'] : "";
			$pickupdate =  isset($_POST['pickupdate']) ? $_POST['pickupdate'] : "";
			$delivery_date =  isset($_POST['delivery_date']) ? $_POST['delivery_date'] : "";
			$customer_id =  isset($_POST['customer_id']) ? $_POST['customer_id'] : "";
			$cunsine_id =  isset($_POST['cunsine_id']) ? $_POST['cunsine_id'] : "";
			$shipper_id =  isset($_POST['shipper_id']) ? $_POST['shipper_id'] : "";
			$ref_type =  isset($_POST['ref_type']) ? $_POST['ref_type'] : "";
			$ref_val =  isset($_POST['ref_val']) ? $_POST['ref_val'] : "";
			$whr = array();
			if($order_id!=""){
				$whr['tor.order_id'] =$order_id;
			}
			if($purchase_order!=""){
				$whr['tod.purchase_order'] =$purchase_order;
			}
			if($delivery_note!=""){
				$whr['tod.delivery_note'] =$delivery_note;
			}
			if($cunsine_id!=""){
				$whr['tor.drop_custid'] =$cunsine_id;
			}
			if($shipper_id!=""){
				$whr['tor.pickup_custid'] =$shipper_id;
			}
			if($customer_id!=""){
				$whr['tor.customer_id'] =$customer_id;
			}
			if($pickupdate!=""){
				$whr['DATE(tor.pickup_datetime)'] = date('Y-m-d', strtotime($pickupdate));
			}
			if($delivery_date!=""){
				$whr['DATE(tor.delivery_datetime)'] = date('Y-m-d', strtotime($delivery_date));
			}
			if($ref_type!=""){
				$whr['torf.reference_id'] =$ref_type;
			}
			if($ref_val!=""){
				$whr['torf..ref_value'] =$ref_val;
			}
			$whr['tor.status']="1";
			$whr['tor.shift_id']="0";
			$whr['tor.trip_id']="0";


			 $orders_info = $orders = array();
			 $limit = $start = 0;

            if ($this->userId != "0") {

                $table = "tb_orders";
                $select = "tor.id,tor.order_id,tor.pickup_company,tor.delivery_company,tor.quantity,weight,tor.volume,tor.transport_mode";
                $orders_info = $this->trips_model->getorderdetails($whr, $select, $table, $limit, $start);
            }
			//echo $this->db->last_query();
			//print_r($orders_info);
          if (!empty($orders_info)) {
                foreach ($orders_info as $res) {
                    $checkbox = "<input type='checkbox' class='noshift_list' name='noshift_list[]' value='" . $res->id . "' id='noshift_" . $res->id . "'>";
                    $orders[] = array('checkbox' => $checkbox, 'id' => $res->id, 'order_id' => $res->order_id, 'pickup_company' => $res->pickup_company, 'delivery_company' => $res->delivery_company, 'quantity' => $res->quantity, 'weight' => $res->weight, 'volume' => $res->volume, 'transport_mode' => $res->transport_mode);
                }
            }
            echo json_encode($orders);

        } catch (\Exception $e) {
            echo $e->getMessage();
        }

	}

	  public function getCostDetailsByShiftId() {
        $shiftId = $this->input->post( 'shift_id',true );
        $cost_ids = $this->input->post( 'cost_ids',true );
        $costs    = array();

        $ordersIds = $this->trips_model->getOrdersByShiftId($shiftId );

        // Loop through Order Ids
        foreach ( $ordersIds as $order_id ) {
            $revenue = $this->common->gettbldata( array( 'order_id' => $order_id, 'status' => 1, 'type' => '1' ), '*', 'tb_reveneus', 0, 0 );
            // Loop Over $revenue
            if ( !empty( $revenue ) ) {
                foreach ( $revenue as $row ) {

                }
            }
        }
		echo json_encode($costs);
    }

	  /**
     * This method fetches all carrie Data from master table
     * @param companyCode
     * @return array
     */


    public function gettriplegs(): void
    {
        $companyCodeCondition = $data['CarrierNames'] = [];
        $checkCrossBorderCompanies = $this->common->gettblrowdata(['company_code' => $this->companyCode], 'xborder_code', 'tb_xborder_country', 0, 0);
        if (!empty($checkCrossBorderCompanies)) {
            $crossborder = $checkCrossBorderCompanies['xborder_code'];
            if ($crossborder != "") {
                $companyCodeCondition = explode(',', $crossborder);
            }
        }
        $companyCodeCondition[] = $this->companyCode;
        if (!empty($companyCodeCondition)) {
            $data['CarrierNames'] = $this->common->gettbldata("company_code IN ('" . implode("','", $companyCodeCondition) . "') AND status ='1'", "id,name", "tb_vendors", 0, 0);
        }
        echo json_encode($data);
    }

    /**
     * This method fetches all vehicles from master table
     * @param $userId Integer
     * @return array
     */

	public function getVehicleType(){
		 try {
			$carrierid =  isset($_POST['carrierid']) ? $_POST['carrierid'] : "";

			  // Variables
            $userId = $this->session->userdata('user_id');
            $branchCode = $this->session->userdata('branch_code');
            $companyCode = $this->session->userdata('company_code');
			$whr = array();
			$data = array();

			$vehicle_typedata=array();
			$truck_typedata=array();
			$truckvechdata=array();
			$vechicledrivers=array();
			$VehicleTypedta = $this->trips_model->getVehicleTypedta($carrierid);

			if(!empty($VehicleTypedta)){
			 foreach ( $VehicleTypedta as $VehicleTyperow ) {
				 $vehicle_typedata[]=array( 'vehicle_id' => $VehicleTyperow->vehicle_id, 'truck_number' => $VehicleTyperow->truck_number);
				 $truckvechdata[$VehicleTyperow->truck_type][]=array( 'vehicle_id' => $VehicleTyperow->vehicle_id, 'truck_number' => $VehicleTyperow->truck_number);
				 $truck_typedata[$VehicleTyperow->truck_type]=array('truck_type' => $VehicleTyperow->truck_type, 'trucktype' => $VehicleTyperow->trucktype);
				 $vechicledrivers[$VehicleTyperow->vehicle_id]=array('driverid' => $VehicleTyperow->driverid, 'drivername' => $VehicleTyperow->drivername);

			 }
			}
			$data = array('vehicleid' => $vehicle_typedata, 'trucktypedata' => $truck_typedata,'truckvechdata'=>$truckvechdata,'vechicledrivers'=>$vechicledrivers);
			echo json_encode($data);

			//echo $this->db->last_query();

		  } catch (\Exception $e) {
            echo $e->getMessage();
        }

	}
	public function getediturlid(){

		 try {
			$shipmentid =  isset($_POST['shipmentid']) ? $_POST['shipmentid'] : "";
			$getshiftidQry = $this->db->query("SELECT id FROM `tb_shifts` WHERE shipmentid LIKE '%".$shipmentid."%'");
			$getshiftidres=$getshiftidQry->result_array();
			echo $getshiftidres[0]['id'];
			//echo $this->db->last_query();

		  } catch (\Exception $e) {
            echo $e->getMessage();
        }

	}

	/* Voice Search Code */
	 public function checkvoice(){
	       $speechText = isset($_POST['speechText']) ? $_POST['speechText'] : "";
	        $userId = $this->session->userdata('user_id');
			$mainnewqry = "SELECT s.*,v.name AS carrier_name,sv.carrier_id,tds.truck_number AS vehicleID,ad.driver_id,ttd.name AS driver_name,(SELECT count(te.pickup) FROM tb_employee te WHERE te.order_id=so.order_id ) AS pickup,(SELECT count(te.drop)
			FROM tb_employee te WHERE te.order_id=so.order_id ) AS drops
			FROM tb_shifts s
			LEFT JOIN tb_shft_veh sv ON sv.shft_id=s.id
			LEFT JOIN tb_vendors v ON v.id = sv.carrier_id
			LEFT JOIN tb_orders so ON s.shipmentid=so.shipmentid
			LEFT JOIN tbl_assigned_drivers ad ON ad.vehicle_id=sv.vehicle_id
			LEFT JOIN tb_truck_drivers ttd ON ttd.id = ad.driver_id
			LEFT JOIN tb_trucks_data tds ON tds.id = ad.vehicle_id
			WHERE s.user_id=".$userId." AND (ttd.name LIKE '%".$speechText."%'  OR s.vehicle_type LIKE '%".$speechText."%' OR v.name LIKE '%".$speechText."%' OR s.startdate LIKE '%".$speechText."%' OR tds.truck_number LIKE '%".$speechText."%') AND s.status='1' GROUP BY s.shipmentid";
		$voiceod = $this->db->query($mainnewqry);
         $voicedata = array();
        if ($voiceod->num_rows() > 0) {
            foreach ($voiceod->result() as $res) {

				$id = $res->id;
				$shipmentid = $res->shipmentid;
				$startdate = $res->startdate;
				$enddate = $res->enddate;
				$splace = $res->splace;
				$eplace = $res->eplace;
				$carrier_name = $res->carrier_name;
				 $driver_name = $res->driver_name;
				 $vehicleID = $res->vehicleID;
				 $vehicle_type = $res->vehicle_type;
				 $transport_mode = $res->transport_mode;
				 $weight = $res->weight;
				 $volume = $res->volume;
				 $units = $res->units;
				 $pickup = $res->pickup;
				 $drop = $res->drops;

				$voicedata[] = array(
                    "id" => $id,
                    "shipmentid" => $shipmentid,
                    "startdate" => $startdate,
                    "enddate" => $enddate,
                    "splace" => $splace,
                    "eplace" => $eplace,
                    "carrier_name" => $carrier_name,
					"driver_name" => $driver_name,
                    "truck_number" => $vehicleID,
                    "vehicle_type" => $vehicle_type,
                    "transport_mode" => $transport_mode,
                    "weight" => $weight,
                    "volume" => $volume,
                    "units" => $units,
                    "pickup" => $pickup,
                    "drop" => $drop


                );
			}
			//print_r($voicedata);
			echo json_encode($voicedata);
		// Load View
            //$this->newtemplate->dashboard("trips/index", $data);

 }
	 }
/* Voice Search code end here */
public function getorderstatusdetails()
{

    $status   = array();
   $shift_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : "";

   $shiftlegqry = $this->db->query("Select id,shipmentid from tb_shifts where shift_leg_id='$shift_id'");
   if($shiftlegqry->num_rows()>0){
		foreach($shiftlegqry->result_array() as $shifts){
			$leg_id=$shifts['id'];
			$shipmentid=$shifts['shipmentid'];
   			$getshiftorders =  $this->db->query("SELECT tt.id,tt.order_id FROM tb_employee tbe,tb_orders tt WHERE tbe.order_id=tt.order_id AND tbe.shift_id='$leg_id'");
        	 if($getshiftorders->num_rows() >0){
           		 foreach($getshiftorders->result() as $res){
		 				$order_id = $res->id;
						if ($order_id != "") {
      						  $getshiftid = $this->db->select("order_id,shift_id")->get_where("tb_orders", array('id' => $order_id));
       						   if ($getshiftid->num_rows() > 0) {

								$bookingid = $getshiftid->row()->order_id;
         						$getorderstatus = $this->db->query("select o.id,o.order_id,o.latitude,o.longitude,o.status_code,o.status_date,o.status_type,DATE(o.status_date) as statusdate,s.status_name from tb_order_status o,tb_status_master s where o.order_id='".$order_id."' AND o.shift_id='".$leg_id."'  AND o.status_id=s.id AND o.status ='1'");
					         if($getorderstatus->num_rows() >0){
					            foreach($getorderstatus->result() as $res){
									if($res->latitude!="" && $res->longitude!=""){
										$location_name = getLocationName($res->latitude, $res->longitude);
									}else{
										$location_name="";
									}
									//$location_name = getLocationName($res->latitude,$res->longitude);


					                $location = '"'.$location_name.'"';
					                $code = $res->status_code."-".$res->status_name;
					                $status_code = '"'.$res->status_code.'"';
					                $status_name = '"'.$res->status_name.'"';
					                $date = $res->statusdate;
					                $type = "order_sts";
					                $stop_type = $res->status_type==""?"P":$res->status_type;
					                $order_id =$res->order_id;
					                $sts_value = '"'.$res->status_code.'_'.$stop_type.'_'.$status_name.'"';
					                $sts_name = '"'.$stop_type.'-'.$status_name.'"';
					                $action   = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu' style='left: 0 !important;><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAddstatus(this);'><span class='glyphicon glyphicon-plus' > </span>Add Status</a></li><li style='display:none;><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowEditStatus(this,".$res->id.",".$status_code.",".$location.",".$date.",".$sts_value.",".$sts_name.");'><span class='glyphicon glyphicon-pencil' > </span>Edit</a></li></ul></li></ul>";
					                $status[] = array('id' => $res->id, 'status_name' => $res->status_name, 'date' => $date, 'action' => $action,'stop_id'=>$res->status_code,'status_type'=>$stop_type,'location'=>$location_name,'order_id'=>$bookingid,"shipmentid"=>$shipmentid);

					            }
					        }

     			  $shift_id = $leg_id;
				        if ($shift_id != "0") {
				            $curtz     = $this->session->userdata("usr_tzone")['timezone'];

							$getstatus = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,ts.status_code,convertToClientTZ(ts.createdon,'".$curtz."') as createdon,sm.status_name,ts.shipment_id from tb_stop_status ts,tb_status_master sm,tb_employee e WHERE sm.id=ts.status_id AND ts.shipment_id=e.shift_id AND e.order_id='".$bookingid."' AND ts.shipment_id = '$shift_id' AND (ts.stop_detail_id=0 OR ts.stop_detail_id=e.id)  AND ts.status_code IN (1500,1510,1600,1610)  GROUP BY ts.id ORDER BY ts.id ASC");

				            if ($getstatus->num_rows() > 0) {
				                foreach ($getstatus->result() as $res) {
				                    $location_name = $res->loc_name;
				                    if($location_name == ""){
										if($res->latitude!="" && $res->longitude!=""){
											$location_name = getLocationName($res->latitude, $res->longitude);
										}else{
											$location_name="";
										}

				                    }
				                    $location = '"'.$location_name.'"';
				                    $status_code = '"'.$res->status_code.'"';
				                    $status_name = '"'.$res->status_name.'"';
				                    $shipmentid = '"'.$res->shipment_id.'"';
				                    $stop_type = $res->stop_type;
				                    if($stop_type == ""){
				                        $stop_type = "P";
				                    }
				                    if($status_code == 'KN007'){
				                        $name = 'PickUp';
				                    }else{
				                        $name = $res->status_name;
				                    }
				                    $sts_value = '"'.$res->status_code.'_'.$stop_type.'_'.$name.'"';
				                    $date = '"'.$res->createdon.'"';
				                    $sts_name = '"'.$stop_type.'-'.$name.'"';
				                    $action   = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu' style='left: 0 !important;><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAddstatus(this);'><span class='glyphicon glyphicon-plus' > </span>Add Status</a></li><li style='display:none;><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowEditStatus(this,".$res->id.",".$status_code.",".$location.",".$date.",".$sts_value.",".$sts_name.");'><span class='glyphicon glyphicon-pencil' > </span>Edit</a></li></ul></li></ul>";
				                    $status[] = array('id' => $res->id, 'lattitude' => $res->latitude, 'longitude' => $res->longitude, 'stop_id' => $res->status_code, 'status_name' => $res->status_name, 'date' => $res->createdon, 'action' => $action,'location'=>$location_name,'status_type'=>$stop_type,'order_id'=>$bookingid,"shipmentid"=>$shipmentid);
				                }

				            }
				        }
				    }
	}


			}
		 }else{
			 $orders=array();
			 $getshiftids=$this->db->query("SELECT id FROM `tb_shifts` WHERE `shift_leg_id`='$shift_id'");
			 if($getshiftids->num_rows()>0){
				foreach($getshiftids->result_array() as $stsrow1){
					$shiftId=$stsrow1['id'];
					$getlegshiftid = $this->db->query("SELECT id,order_id,shift_id from  tb_employee  WHERE shift_id='$shiftId'");
					if ($getlegshiftid->num_rows() > 0) {
						foreach($getshiftids->result_array() as $stsrow2){
							$order_id=$stsrow2['order_id'];
							$getshiftid = $this->db->select("order_id")->get_where("tb_orders", array('id' => $order_id));
							if ($getshiftid->num_rows() > 0) {

							$bookingid = $getshiftid->row()->order_id;
							$getorderstatus = $this->db->query("select o.id,o.order_id,o.latitude,o.longitude,o.status_code,o.status_date,o.status_date,s.status_name from tb_order_status o,tb_status_master s where o.order_id='".$order_id."' AND o.shift_id='".$shiftId."'  AND o.status_id=s.id AND o.status ='1'");
							if($getorderstatus->num_rows() >0){
							foreach($getorderstatus->result() as $res){
								//$location_name = getLocationName($res->latitude,$res->longitude);
								if($res->latitude!="" && $res->longitude!=""){
									$location_name = getLocationName($res->latitude, $res->longitude);
								}else{
									$location_name="";
								}

								$location = '"'.$location_name.'"';
								$code = $res->status_code."-".$res->status_name;
								$status_code = '"'.$res->status_code.'"';
								$status_name = '"'.$res->status_name.'"';
								$date = '"'.$res->status_date.'"';
								$date = '"'.$res->status_date.'"';
								$type = "order_sts";
								$stop_type = "P";
								$order_id =$res->order_id;
								$sts_value = '"'.$res->status_code.'_'.$stop_type.'_'.$status_name.'"';
								$sts_name = '"'.$stop_type.'-'.$status_name.'"';
								$action   = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu' style='left: 0 !important;><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAddstatus(this);'><span class='glyphicon glyphicon-plus' > </span>Add Status</a></li><li style='display:none;><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowEditStatus(this,".$res->id.",".$status_code.",".$location.",".$date.",".$sts_value.",".$sts_name.");'><span class='glyphicon glyphicon-pencil' > </span>Edit</a></li></ul></li></ul>";
								$status[] = array('id' => $res->id, 'status_name' => $res->status_name, 'date' => $res->status_date, 'action' => $action,'stop_id'=>$res->status_code,'status_type'=>$stop_type,'location'=>$location_name,'order_id'=>$bookingid,"shipmentid"=>$shipmentid);

						}
					}

				}
			}

					}


			}
		 }
		 }



		}
	}



     // print_r($status);
      //print_r($this->db->queries);
 echo json_encode($status);
}
public function checkordertrips(){

    $shift_id = $this->input->post('shift_id',true);
    $shiftOrders = $this->trips_model->getOrderDetailsForKNOps([], $shift_id);
    $orderselect = '<select name="status_order" onchange="getorderstatus(this,this.value);" class="form-control" id="status_order"><option value="">Select</option>';
    foreach ($shiftOrders as $stsrow1) {
        $orderid = $stsrow1['id'];
        $orderidvale = $stsrow1['order_id'];
        if ($this->userRoleId === "5" && $this->departmentCode !== "" && $this->departmentCode !== $stsrow1['department_code']) {
            $orderselect .= '<option value="' . $orderid . '" disabled> ' . $orderidvale . '</option>';
        } else {
            $orderselect .= '<option value="' . $orderid . '" > ' . $orderidvale . '</option>';
        }

    }
    $orderselect .= '</select>';

    $shiftlegqry = $this->db->query("Select id,shipmentid from tb_shifts where shift_leg_id='$shift_id'");
    $legselect = '<select name="status_leg" onchange="getlegorders(this,this.value);" class="form-control" id="status_leg"><option value="">Select</option>';
    if($shiftlegqry->num_rows()>0){
        foreach($shiftlegqry->result_array() as $shifts){
            $shiftid=$shifts['id'];
            $shipmentid=$shifts['shipmentid'];
            $legselect .= '<option value="'.$shiftid.'">'.$shipmentid.'</option>';

        }
    }
    $legselect .= '</select>';

    $statusselect='<select name="status_name" onchange="getstatusnamebyid(this);" class="form-control" id="status_name"><option value="">Select</option></select>';

    $dshipid = $pshipid = $dstopdetailsid = $pstopdetailsid = 0;

    $response = array('legselect'=>$legselect,'orderselect'=>$orderselect,'statusselect'=>$statusselect,'pshipid'=>$pshipid,'dshipid'=>$dshipid,'dstopdetailsid'=>$dstopdetailsid,'pstopdetailsid'=>$pstopdetailsid);
    echo json_encode($response);

}
public function checklegorder(){
	$shift_id = $this->input->post('shift_id',true);
	$leg_id = $this->input->post('leg_id',true);
	$shiftordersqry = $this->db->query("SELECT tt.id,tt.order_id FROM tb_employee tbe,tb_orders tt WHERE tbe.order_id=tt.order_id AND tbe.shift_id='".$leg_id."'");
	 $orderselect = '<select name="status_order" onchange="getorderstatus(this,this.value);" class="form-control" id="status_order"><option value="">Select</option>';
	if($shiftordersqry->num_rows()>0){
		foreach($shiftordersqry->result_array() as $stsrow1){
			$orderid=$stsrow1['id'];
			$orderidvale=$stsrow1['order_id'];
			$orderselect .= '<option value="'.$orderid.'">'.$orderidvale.'</option>';

		}
	}
	$orderselect .= '</select>';

	$shiftlegqry = $this->db->query("Select id,shipmentid from tb_shifts where shift_leg_id='".$shift_id."'");
	 $legselect = '<select name="status_leg" onchange="getlegorders(this,this.value);" class="form-control" id="status_leg"><option value="">Select</option>';
	if($shiftlegqry->num_rows()>0){
		foreach($shiftlegqry->result_array() as $shifts){
			$shiftid=$shifts['id'];
			$shipmentid=$shifts['shipmentid'];
			if($shiftid==$leg_id){
				$selectedtext='selected="selected"';
			}else{
				$selectedtext='';
			}
			$legselect .= '<option value="'.$shiftid.'" '.$selectedtext.'>'.$shipmentid.'</option>';

		}
	}
	$legselect .= '</select>';

	$statusselect='<select name="status_name" onchange="getstatusnamebyid(this);" class="form-control" id="status_name"><option value="">Select</option></select>';

	$dshipid = $pshipid = $dstopdetailsid = $pstopdetailsid = 0;

	 $response = array('legselect'=>$legselect,'orderselect'=>$orderselect,'statusselect'=>$statusselect,'pshipid'=>$pshipid,'dshipid'=>$dshipid,'dstopdetailsid'=>$dstopdetailsid,'pstopdetailsid'=>$pstopdetailsid);
	 echo json_encode($response);

}
public  function checktripfororder()
{
    $company_code = $this->session->userdata('company_code');
    $order_id = $this->input->post('order_id',true);
    $trip_id = $shift_id = $booking_id = 0;

	$shift_id = $this->input->post('shift_id',true);
    $leg_id = $this->input->post('leg_id',true);
	$shiftordersqry = $this->db->query("SELECT tt.id,tt.order_id FROM tb_employee tbe,tb_orders tt WHERE tbe.order_id=tt.order_id AND tbe.shift_id='$leg_id'");
	 $orderselect = '<select name="status_order" onchange="getorderstatus(this,this.value);" class="form-control" id="status_order"><option value="">Select order</option>';
	if($shiftordersqry->num_rows()>0){
		foreach($shiftordersqry->result_array() as $stsrow1){
			$orderid=$stsrow1['id'];
			$orderidvale=$stsrow1['order_id'];
			if($orderid==$order_id){
				$selectedtext='selected="selected"';
			}else{
				$selectedtext='';
			}
			$orderselect .= '<option value="'.$orderid.'" '.$selectedtext.'>'.$orderidvale.'</option>';

		}
	}
	$orderselect .= '</select>';

	$shiftlegqry = $this->db->query("Select id,shipmentid from tb_shifts where shift_leg_id='$shift_id'");
	 $legselect = '<select name="status_leg" onchange="getlegorders(this,this.value);" class="form-control" id="status_leg"><option value="">Select</option>';
	if($shiftlegqry->num_rows()>0){
		foreach($shiftlegqry->result_array() as $shifts){
			$shiftid=$shifts['id'];
			$shipmentid=$shifts['shipmentid'];
			if($shiftid==$leg_id){
				$selectedtext='selected="selected"';
			}else{
				$selectedtext='';
			}
			$legselect .= '<option value="'.$shiftid.'" '.$selectedtext.'>'.$shipmentid.'</option>';

		}
	}
	$legselect .= '</select>';

    $chkorder = $this->db->select("order_id,shift_id,trip_id")->get_where("tb_orders",array('id'=>$order_id));
    if($chkorder->num_rows() >0){
        $shift_id = $chkorder->row()->shift_id;
        $trip_id = $chkorder->row()->trip_id;
        $booking_id = $chkorder->row()->order_id;
    }
    $empid = 0;
    $getempid= $this->db->select("id")->get_where("tb_employee",array('order_id'=>$booking_id));
    if($getempid->num_rows() >0){
        $empid = $getempid->row()->id;
    }
    $dshipid = $pshipid = $dstopdetailsid = $pstopdetailsid = 0;
    $select = '<select name="status_name" onchange="getstatusnamebyid(this);" class="form-control" id="status_name"><option value="">Select</option>
	<option value="1500_P_Customs Clearance Strated">Customs Clearance Strated</option>
	<option value="1510_P_Customs Clearance Strated at Depot">Customs Clearance Strated at Depot</option>
	<option value="1600_P_Customs Clearance Completed at Bor">Customs Clearance Completed at Bor</option>
	<option value="1610_P_Customs Clearance Completed at Depot">Customs Clearance Completed at Depot</option></select>';
    if($shift_id != '0' && $empid != '0'){
        $accept_sts = 0;
        $chekaccept = $this->db->select("id")->get_where("tb_stop_status",array('shipment_id'=>$shift_id,'status_id'=>'10'));
        if($chekaccept->num_rows()>0){
            $accept_sts = '1';
        }
        $custom_sts = 0;
        $chkorderstatus = $this->db->select('id')->get_where("tb_order_status",array('order_id'=>$order_id,'status_id'=>'12'));
        if($chkorderstatus->num_rows()>0){
            $custom_sts = '1';
        }
        $chkstops = $this->db->query("SELECT s.id,s.stoptype,s.ordernumber,e.id as stopdetailsid,s.status FROM tb_shiporder_stops s,tb_employee e WHERE s.shipment_id=$shift_id AND s.status=1 AND s.id=e.stop_id AND e.status=1 AND e.id=$empid UNION SELECT s.id,s.stoptype,s.ordernumber,e.id as stopdetailsid,s.status FROM tb_shiporder_stops s,tb_employee e WHERE s.shipment_id=$shift_id AND s.status=1 AND s.id=e.drop_stopid AND e.status=1 AND e.id=$empid");
        if($chkstops->num_rows() >0){
            $select = '<select name="status_name" onchange="getstatusnamebyid(this);" class="form-control" id="status_name"><option value="">Select</option>';
            foreach ($chkstops->result() as $res) {
                if($res->stoptype == "P"){
                    $pshipid = $res->id;
                    $pstopdetailsid = $res->stopdetailsid;
                    $pickups = array();
                    $chktype = $this->db->select('status_code')->get_where("tb_stop_status",array('shipment_id'=>$shift_id,'status'=>'1','stop_type'=>'P'));
                    if($chktype->num_rows() >0){
                        foreach ($chktype->result() as $row) {
                            $pickups[] = $row->status_code;
                        }
                    }
                    if($company_code != "UKKN" && $company_code != "AUKN"){
                        if($custom_sts == '1'){
                            $custom = "disabled";
                        }else{
                            $custom = "";
                        }
                        if($accept_sts == '1'){
                            $accept = "disabled";
                        }else{
                            $accept = "";
                        }
                        if(in_array('KN002',$pickups)){
                            $gatein = "disabled";
                        }else{
                            $gatein = "";
                        }
                        if(in_array('KN007',$pickups)){
                            $pickup = "disabled";
                        }else{
                            $pickup = "";
                        }
                        if(in_array('KN001',$pickups)){
                            $gateout = "disabled";
                        }else{
                            $gateout = "";
                        }if(in_array('KN005',$pickups)){
                            $it = "disabled";
                        }else{
                            $it = "";
                        }if(in_array('RY',$pickups)){
                            $carrived = "disabled";
                        }else{
                            $carrived = "";
                        }if(in_array('ON',$pickups)){
                            $copened = "disabled";
                        }else{
                            $copened = "";
                        }if(in_array('ED',$pickups)){
                            $cclosed = "disabled";
                        }else{
                            $cclosed = "";
                        }if(in_array('ER',$pickups)){
                            $cdeparted = "disabled";
                        }else{
                            $cdeparted = "";
                        }if(in_array('TL',$pickups)){
                            $outbount_started = "disabled";
                        }else{
                            $outbount_started = "";
                        }if(in_array('CL',$pickups)){
                            $outbount_ended = "disabled";
                        }else{
                            $outbount_ended = "";
                        }if(in_array('LY',$pickups)){
                            $outbount_departed = "disabled";
                        }else{
                            $outbount_departed = "";
                        }

						$select .= '<option value="1500_P_Customs Clearance Strated">Customs Clearance Strated</option>';
						$select .= '<option value="1510_P_Customs Clearance Strated at Depot">Customs Clearance Strated at Depot</option>';
						$select .= '<option value="1600_P_Customs Clearance Completed at Bor">Customs Clearance Completed at Bor</option>';
						$select .= '<option value="1610_P_Customs Clearance Completed at Depot">Customs Clearance Completed at Depot</option>';

                    }else{
                        if(in_array('RY',$pickups)){
                            $carrived = "disabled";
                        }else{
                            $carrived = "";
                        }if(in_array('ON',$pickups)){
                            $copened = "disabled";
                        }else{
                            $copened = "";
                        }if(in_array('ED',$pickups)){
                            $cclosed = "disabled";
                        }else{
                            $cclosed = "";
                        }if(in_array('ER',$pickups)){
                            $cdeparted = "disabled";
                        }else{
                            $cdeparted = "";
                        }if(in_array('TL',$pickups)){
                            $outbount_started = "disabled";
                        }else{
                            $outbount_started = "";
                        }if(in_array('CL',$pickups)){
                            $outbount_ended = "disabled";
                        }else{
                            $outbount_ended = "";
                        }if(in_array('LY',$pickups)){
                            $outbount_departed = "disabled";
                        }else{
                            $outbount_departed = "";
                        }
                        $cmwhr = "UKKN";
                        if($company_code == "AUKN"){
                            $cmwhr = "UKKN";
                        }
                        $stsqry = $this->db->select('id,status_name,status_code')->get_where("tb_status_master",array("company_code"=>$cmwhr,"status"=>1));
                        if($stsqry->num_rows()>0){
                            foreach($stsqry->result_array() as $stsrow){
                                $getsts = "";
                                if($stsrow['status_code'] == "RY"){
                                    $getsts = $carrived;
                                }else if($stsrow['status_code'] == "ON"){
                                    $getsts = $copened;
                                }else if($stsrow['status_code'] == "ON"){
                                    $getsts = $copened;
                                }else if($stsrow['status_code'] == "ED"){
                                    $getsts = $cclosed;
                                }else if($stsrow['status_code'] == "ER"){
                                    $getsts = $cdeparted;
                                }else if($stsrow['status_code'] == "TL"){
                                    $getsts = $outbount_started;
                                }else if($stsrow['status_code'] == "CL"){
                                    $getsts = $outbount_ended;
                                }else if($stsrow['status_code'] == "LY"){
                                    $getsts = $outbount_departed;
                                }
                               // $select .= '<option value="'.$stsrow['status_code'].'" '.$getsts.'>'.$stsrow['status_name'].'</option>';
                            }
                        }

                    }
                }
                if($company_code != 'UKKN' && $company_code != "AUKN"){
                    if($res->stoptype == "D"){
                        $drops = array();
                        $chktype = $this->db->select('status_code')->get_where("tb_stop_status",array('shipment_id'=>$shift_id,'status'=>'1','stop_type'=>'D'));
                        if($chktype->num_rows() >0){
                            foreach ($chktype->result() as $row) {
                                $drops[] = $row->status_code;
                            }
                        }
                        $dshipid = $res->id;
                        $dstopdetailsid = $res->stopdetailsid;
                        if(in_array('KN002',$drops)){
                            $gatein = "disabled";
                        }else{
                            $gatein = "";
                        }
                        if(in_array('KN007',$drops)){
                            $pickup = "disabled";
                        }else{
                            $pickup = "";
                        }
                        if(in_array('KN001',$drops)){
                            $gateout = "disabled";
                        }else{
                            $gateout = "";
                        }
                        $cmwhr = "UKKN";
                        if($company_code == "AUKN"){
                            $cmwhr = "UKKN";
                        }
                        $stsqry = $this->db->query("select id,status_name,status_code from tb_status_master where company_code='".$cmwhr."' AND status_code IN('TL','CL','LY') AND status=1 ");
                        if($stsqry->num_rows()>0){
                            foreach($stsqry->result_array() as $stsrow1){
                                $getsts = "";
                                if($stsrow1['status_code'] == "TL"){
                                    $getsts = $outbount_started;
                                }else if($stsrow1['status_code'] == "CL"){
                                    $getsts = $outbount_ended;
                                }else if($stsrow1['status_code'] == "LY"){
                                    $getsts = $outbount_departed;
                                }
                               // $select .= '<option value="'.$stsrow1['status_code'].'" '.$getsts.'>'.$stsrow1['status_name'].'</option>';
                            }
                        }
                    }
                }

            }
        }
        $select .= "</select>";
    }
    $response = array('legselect'=>$legselect,'orderselect'=>$orderselect,'select'=>$select,'pshipid'=>$pshipid,'dshipid'=>$dshipid,'dstopdetailsid'=>$dstopdetailsid,'pstopdetailsid'=>$pstopdetailsid);
    echo json_encode($response);
}

public function addstatus($id = null){
    $curtz = $this->session->userdata("usr_tzone")['timezone'];
    $logdate = date('Y-m-d H:i:s');
    $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
    $curdt = $getactual['datetime'];
    $hrs = $this->session->userdata("usr_tzone")['hrs'];
    $order_id = isset($_POST['order_status_id']) ? $_POST['order_status_id'] : "0";
    $lattitude = $longitude = "";
    $booking_id = 0;
    if($order_id != "0"){
        $user_id = $this->session->userdata('user_id');
        $shift_id = $trip_id = $ord_id = 0;
        $createdsource = "";
        $chkshft       = $this->db->select( "id,order_id,plat,plng,dlat,dlng,shift_id,trip_id,created_source" )->get_where( "tb_orders", array( 'id' => $order_id ) );
			if ( $chkshft->num_rows() > 0 ) {
				$booking_id    = $chkshft->row()->order_id;
				$shift_id      = $chkshft->row()->shift_id;
				$trip_id       = $chkshft->row()->trip_id;
				$createdsource = $chkshft->row()->created_source;
				$ord_id        = $chkshft->row()->id;
				if ( $chkshft->row()->plat != "" ) {
					$plat = $chkshft->row()->plat;
					$plng = $chkshft->row()->plng;
				} else {
					$chklatlng = $this->db->select( "latitude,longitude" )->get_where( "tb_site_settings", array( "user_id" => $user_id ), 1, 0 );
					if ( $chklatlng->num_rows() > 0 ) {
						$plat = $chklatlng->row()->latitude;
						$plng = $chklatlng->row()->longitude;
					}
				}
				if ( $chkshft->row()->dlat != "" ) {
					$dlat = $chkshft->row()->dlat;
					$dlng = $chkshft->row()->dlng;
				} else {
					$chklatlng = $this->db->select( "latitude,longitude" )->get_where( "tb_site_settings", array( "user_id" => $user_id ), 1, 0 );
					if ( $chklatlng->num_rows() > 0 ) {
						$dlat = $chklatlng->row()->latitude;
						$dlng = $chklatlng->row()->longitude;
					}
				}
			}
        $status_code = isset($_POST['status_code']) ? $_POST['status_code'] : "";
        $status_date = isset($_POST['status_date']) ? $_POST['status_date'] : "";
        $status_leg = isset($_POST['status_leg']) ? $_POST['status_leg'] : "";
        if($status_date == ""){
            $status_date = date('Y-m-d H:i:s');
        }
        $pshipid = isset($_POST['pshipid']) ? $_POST['pshipid'] : "0";
        $dshipid = isset($_POST['dshipid']) ? $_POST['dshipid'] : "0";
        $pstopdetailsid = isset($_POST['pstopdetailsid']) ? $_POST['pstopdetailsid'] : "0";
        $dstopdetailsid = isset($_POST['dstopdetailsid']) ? $_POST['dstopdetailsid'] : "0";

        $sname = isset($_POST['status_name']) ? $_POST['status_name'] : "";
        $status_type = isset($_POST['status_type']) ? $_POST['status_type'] : "";
        $status_name = "";
		$stop_type = 'P';
        if($sname != ""){
            $sts = explode('_', $sname);

            if(!empty($sts)){
                $stop_type = isset($sts[1]) ? $sts[1] : "P";
                $status_name = isset($sts[2]) ? $sts[2] : "";
            }
        }
        $getstatusid = $this->db->select("id")->get_where("tb_status_master",array('status_code'=>$status_code));
        $status_id = 0;
        if($getstatusid->num_rows() >0){
            $status_id = $getstatusid->row()->id;
        }
        if($status_type=='P'){
        	$lattitude=$plat;
        	$longitude=$plng;
        }else{
			$lattitude=$dlat;
			$longitude=$dlng;
        }
		$status_ar = array('order_id'=>$order_id,'status_id'=>$status_id,'latitude'=>$lattitude,'longitude'=>$longitude,'status_code'=>$status_code,'status_type'=>$status_type,'status'=>'1','status_date'=>$status_date,'shift_id'=>$status_leg);
		$ins = $this->db->insert("tb_order_status",$status_ar);
		//print_r($this->db->queries);
        echo 1;


}

//print_r($this->db->queries);
}

	public function viewpopuporiginpartylist(){
		$parties     = array();
		$user_id     = $this->session->userdata( 'user_id' );
		$party_type  = isset( $_POST['party'] ) ? $_POST['party'] : "";

		$party_type_whr = $whr   = $usrwhr = "";
		$master_ids = array();
		$chkcompanycode = $this->session->userdata('company_code');
		if($party_type=='origin'){
			if ( $party_type != "" ) {
				$party_type_whr = " AND t.name  in ('Yard','Border','xDock','In Transit','Port','Shipper','PICKUP')";
				$partytypewhr = " AND name  in ('Yard','Border','xDock','In Transit','Port','Shipper','PICKUP')";
			}
		}else{
			if ( $party_type != "" ) {
				$party_type_whr = " AND t.name  in ('Yard','Border','xDock','In Transit','Port','Consignee','DELIVERY')";
				$partytypewhr = " AND name  in ('Yard','Border','xDock','In Transit','Port','Consignee','DELIVERY')";
			}

		}

		$getcrossbodercomapanires = $this->db->select("xborder_code")->get_where("tb_xborder_country",array('company_code'=>$chkcompanycode));
        if($getcrossbodercomapanires->num_rows() >0){
            $getcrossboder = $getcrossbodercomapanires->row()->xborder_code;
            if($getcrossboder!=""){
              $whr = "AND m.company_code IN ('".$chkcompanycode."','".implode("','", explode(',',$getcrossboder))."')  ";
             }else{
               $whr = "AND m.company_code IN ('".$chkcompanycode."')  ";
             }
        }else{
        	 $whr = "AND m.company_code IN ('".$chkcompanycode."')  ";
        }
        $get_parties = $this->db->query("SELECT m.id as master_id,m.name as master_name,m.email as master_email_id,m.mobile as master_mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.country,m.street,t.name as party_name FROM tbl_party_master m,tbl_party_types t WHERE m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.branch_code IS NOT NULL  AND m.parent_id ='0'  AND m.status=1  AND t.id=m.party_type_id " .$whr." ". $party_type_whr . " GROUP BY m.id ORDER BY m.id DESC" );


		if ( $get_parties->num_rows() > 0 ) {
			foreach ( $get_parties->result() as $res ) {
				$check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";

				$master_ids[] = $res->master_id;
				$parties[]    = array(
					'check'        => $check,
					'id'           => $res->code,
					'name'         => $res->master_name,
					'email'        => $res->master_email_id,
					'mobile'       => $res->master_mobile,
					'party_name'   => $res->party_name,
					'company_code' => $res->company_code,
					'branch_code'  => $res->branch_code,
					'party_name'   => $res->party_name,
					'city'         => $res->city,
					'country'      => $res->country,
					'street'       => $res->street
				);
			}
		}

		$master_whr     = "";

		$additional_ids = $party_types = array();
		if ( ! empty( $master_ids ) ) {
			$master_whr = "AND m.id NOT IN (" . implode( ',', $master_ids ) . ")  ";
		}
		$getmultipleparties = $this->db->query( "SELECT m.id as master_id,m.party_types FROM tbl_party_master m WHERE m.code IS NOT NULL " . $master_whr  . " AND m.party_types IS NOT NULL" );
		if ( $getmultipleparties->num_rows() > 0 ) {
			foreach ( $getmultipleparties->result() as $res ) {
				if ( $res->party_types != "" && $res->party_types != '0' ) {
					$party_types = explode( ',', $res->party_types );
					if(end($party_types)==""){
						array_pop($party_types);
					}
					/*if ( is_array( $party_types ) ) {
						if ( ! empty( $party_types ) ) {
							$chkshipper = $this->db->query( "SELECT id FROM tbl_party_types WHERE id IN (" . implode( ',', $party_types ) . ") ". $partytypewhr );
							if ($chkshipper!=null && $chkshipper->num_rows() > 0 ) {
								$additional_ids[] = $res->master_id;
							}
						}
					}*/
					if (is_array($party_types)) {
                        // Filter out any non-numeric or empty values
                        $party_types_cleaned = array_filter($party_types, function ($value) {
                            return is_numeric($value) && $value != '';
                        });
                    
                        if (!empty($party_types_cleaned)) {
                            // Now implode safely
                            $ids = implode(',', $party_types_cleaned);
                    
                            $chkshipper = $this->db->query(
                                "SELECT id FROM tbl_party_types WHERE id IN ($ids) $partytypewhr"
                            );
                    
                            if ($chkshipper && $chkshipper->num_rows() > 0) {
                                $additional_ids[] = $res->master_id;
                            }
                        } else {
                            log_error("Empty or invalid party_types array: " . json_encode($party_types));
                        }
                    }
				}
			}
		}

		if ( ! empty( $additional_ids ) ) {
			$get_addids = $this->db->query( "SELECT m.id as master_id,m.name as master_name,m.email as master_email_id,m.mobile as master_mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.country,m.street FROM tbl_party_master m WHERE m.id IN (" . implode( ',', $additional_ids ) . ") AND m.company_code != '' AND m.company_code IS NOT NULL  AND m.branch_code != '' AND m.branch_code IS NOT NULL   AND m.parent_id ='0'  AND m.status=1 GROUP BY m.id ORDER BY m.id DESC" );
			if ( $get_addids->num_rows() > 0 ) {
				foreach ( $get_addids->result() as $res ) {
					/* if ( $type == '1' ) {
						$check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
					} else { */
						$check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
					//}
					$master_ids[] = $res->master_id;
					$parties[]    = array(
						'check'        => $check,
						'id'           => $res->code,
						'name'         => $res->master_name,
						'email'        => $res->master_email_id,
						'mobile'       => $res->master_mobile,
						'party_name'   => $party_type,
						'company_code' => $res->company_code,
						'branch_code'  => $res->branch_code,
						'party_name'   => $party_type,
						'city'         => $res->city,
						'country'      => $res->country,
						'street'       => $res->street
					);
				}
			}
		}

		//log_message("error","PARTY query".json_encode($this->db->queries));

		echo json_encode( $parties );


	}

    public function vieworiginpartylist()
    {
        $post = $this->input->post(null, true);
        $partyType = $post['party'] ?? "origin";
        if ($partyType == 'origin') {
            $partyTypes = ['Shipper', 'Yard', 'Border', 'xDock', 'In Transit', 'Port'];
        } else {
            $partyTypes = ['Consignee', 'Yard', 'Border', 'xDock', 'In Transit', 'Port'];
        }
        $chkcompanycode = $this->session->userdata('company_code');
        $getCrossBorderCompanies = $this->common->gettblrowdata(['company_code' => $chkcompanycode], "xborder_code", "tb_xborder_country", 0, 0);
        if (empty($getCrossBorderCompanies)) {
            $crossBorderCompanyCodes = [$chkcompanycode];
        } else {
            $countriesString = $getCrossBorderCompanies['xborder_code'];
            if ($countriesString != "") {
                $crossBorderCompanyCodes = explode(',', $countriesString);
                $crossBorderCompanyCodes[] = $chkcompanycode;
            } else {
                $crossBorderCompanyCodes = [$chkcompanycode];
            }
        }
        $this->load->model('rateenquirymodel');
        $partyMaterData = $this->rateenquirymodel->getPartyMasterData($partyTypes ?? [], array_unique($crossBorderCompanyCodes),'100');
        $masterData = $partyMaterData['masterData'] ?? [];
        $typesData = $partyMaterData['partyTypeData'] ?? [];
        foreach ($masterData as $eachLine) {
            $checkBox = "<input type='radio' name='consigneelist' id='consigneelist_" . $eachLine['id'] . "' class='masterlist' onchange='selectparty(" . $eachLine['id'] . ")' value='" . $eachLine['code'] . "'>";
            $parties[] = [
                'check' => $checkBox,
                'id' => $eachLine['code'],
                'name' => $eachLine['name'],
                'email' => $eachLine['code'],
                'mobile' => $eachLine['location_id'],
                'country' => $eachLine['country'],
                'state' => $eachLine['state'],
                'street' => $eachLine['street'],
                'city' => $eachLine['pincode'],
                'company_code' => $eachLine['company_code'],
                'branch_code' => $eachLine['branch_code'],
                'party_name' => $typesData['party_type_id'] ?? $partyType,
            ];
        }
        echo json_encode($parties ?? []);
    }

    function selectpartytype(){
		$partiesdetails     = array();
		$user_id     = $this->session->userdata( 'user_id' );
		$typeid        = isset( $_POST['id'] ) ? $_POST['id'] : "0";
		$getstatusid = $this->db->select("id,code,location_id")->get_where("tbl_party_master",array('code'=>$typeid));
        $status_id = 0;
        if($getstatusid->num_rows() >0){
            $partiesdetails["party"] = $getstatusid->result_array();
        }
		echo json_encode( $partiesdetails );

	}
	function getpartylist(){
		$parties     = array();
		$user_id     = $this->session->userdata( 'user_id' );
		$party_type  = isset( $_POST['location_type'] ) ? $_POST['location_type'] : "";
		$party_code  = isset( $_POST['party_code'] ) ? $_POST['party_code'] : "";
		$party_name  = isset( $_POST['party_name'] ) ? $_POST['party_name'] : "";
		$border_type  = isset( $_POST['border_type'] ) ? $_POST['border_type'] : "";
		$type        = isset( $_POST['type'] ) ? $_POST['type'] : "0";

		if($party_type=='origin'){
			if ( $party_type != "" ) {
				$party_type_whr = " AND t.name LIKE 'Shipper' ";
			}
		}else{
			if ( $party_type != "" ) {
				$party_type_whr = " AND t.name LIKE 'Consignee' ";
			}

		}
		$whe='';
		if(strlen($party_code)>0 || $party_code !=""){
				$whe .= " AND m.code='$party_code'";
		}

		if(strlen($party_name)>0 || $party_name !=""){
				$whe .= " AND m.name LIKE '$party_name' ";
		}

		if($border_type==0){
			$chkcompanycode = $this->session->userdata('company_code');
			$get_parties = $this->db->query("SELECT m.id as master_id,m.name as master_name,m.email as master_email_id,m.mobile as master_mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.country,m.street,t.name as party_name FROM tbl_party_master m,tbl_party_types t WHERE m.company_code != '' AND m.company_code IS NOT NULL AND m.company_code LIKE '" . $chkcompanycode . "' AND m.branch_code != '' AND m.branch_code IS NOT NULL  AND m.parent_id ='0'  AND m.status=1 ANd m.code != '' AND m.code is NOT NULL AND m.code != '0' AND t.id=m.party_type_id " . $party_type_whr . $whe . " GROUP BY m.id ORDER BY m.id DESC" );
		}else{
			$get_parties = $this->db->query("SELECT m.id as master_id,m.name as master_name,m.email as master_email_id,m.mobile as master_mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.country,m.street,t.name as party_name FROM tbl_party_master m,tbl_party_types t WHERE m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.branch_code IS NOT NULL  AND m.parent_id ='0'  AND m.status=1 ANd m.code != '' AND m.code is NOT NULL AND m.code != '0' AND t.id=m.party_type_id " . $party_type_whr. $whe . " GROUP BY m.id ORDER BY m.id DESC" );
		}
		if ( $get_parties->num_rows() > 0 ) {
					foreach ( $get_parties->result() as $res ) {
						if ( $type == '1' ) {
							$check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
						} else {
							$check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
						}
						$master_ids[] = $res->master_id;
						$parties[]    = array(
							'check'        => $check,
							'id'           => $res->code,
							'name'         => $res->master_name,
							'email'        => $res->master_email_id,
							'mobile'       => $res->master_mobile,
							'party_name'   => $res->party_name,
							'company_code' => $res->company_code,
							'branch_code'  => $res->branch_code,
							'party_name'   => $res->party_name,
							'city'         => $res->city,
							'country'      => $res->country,
							'street'       => $res->street
						);
					}
				}



		echo json_encode( $parties );

	}

    public function addshipment()
    {
        $data['userid'] = $this->session->userdata('user_id');
        $data['userRoleId'] = $this->session->userdata('user_role_id');
        $data['companyCode'] = $this->session->userdata('company_code');
        $getTripTemplates = $this->triptemplatemodel->getTripTemplatesByUser($data['companyCode']);
        foreach ($getTripTemplates as $eachRow) {
            $data['templates'][] = ['id' => $eachRow['id'], 'templateId' => $eachRow['template_id'],'templateName'=>$eachRow['template_name']];
        }

        echo $this->load->view("trips/addshipment", $data, true);
    }

		public function storeshipment()
		{

			$shipper_row_id = isset( $_POST['shipper_row_id'] ) ? $_POST['shipper_row_id'] : "";
			$drop_row_id = isset( $_POST['drop_row_id'] ) ? $_POST['drop_row_id'] : "";
			$vendor_id = isset( $_POST['vendor_id'] ) ? $_POST['vendor_id'] : "";
			$start_date = isset( $_POST['start_date'] ) ? $_POST['start_date'] : "";
			$end_date = isset( $_POST['end_date'] ) ? $_POST['end_date'] : "";
			$transport_mode = isset( $_POST['transport_mode'] ) ? $_POST['transport_mode'] : "";

			$userid = $this->session->userdata('user_id');
			$curtz = $this->session->userdata("usr_tzone")['timezone'];
			$curdt = date('Y-m-d H:i:s');


			$count_code = $this->session->userdata("usr_tzone")['phone_code'];
			if($count_code == ""){
				$count_code = $this->session->userdata("usr_tzone")['country'];
			}
			$year=date('y');
			$week=date('W');
			$seq_num = substr(mt_rand(10,100000),0,5);
			$shipmentid = "T".$count_code.$week.$year.$seq_num;
			$txnid = time();
            $startDateArray = getdatetimebytimezone( DFLT_TZ, $start_date, $curtz );
            $start_date = $startDateArray['datetime'];
			$startdatevalue=explode(" ",$start_date);
			$starttime = $startdatevalue[1];
            $endDateArray = getdatetimebytimezone( DFLT_TZ, $end_date, $curtz );
            $end_date = $endDateArray['datetime'];
			$enddatevalue=explode(" ",$end_date);
			$endtime = $enddatevalue[1];

			/* $enddate = date('Y-m-d',strtotime($end_date));
			$endtime = date('H:i',strtotime($end_date)); */

			$company_code = $this->session->userdata('company_code');
			$branch_code = $this->session->userdata('branch_code');

			$shipperloc = $this->db->select("location_id,code")->get_where("tbl_party_master",array("code"=>$shipper_row_id,"status"=>1),1,0);
			if($shipperloc->num_rows()>0){
				$splace=$shipperloc->row()->location_id;
				$origin_id=$shipperloc->row()->code;
			}

			$droploc = $this->db->select("location_id,code")->get_where("tbl_party_master",array("code"=>$drop_row_id,"status"=>1),1,0);
			if($droploc->num_rows()>0){
				$eplace=$droploc->row()->location_id;
				$destination_id=$droploc->row()->code;
			}

			$data = array('user_id'=>$userid, 'splace'=>$splace,'eplace'=>$eplace,'scity'=>$splace,'dcity'=>$eplace,'stime'=>$starttime, 'etime'=>$endtime, 'zone_id'=>1, 'empshift_start'=>$starttime, 'empshift_end'=>$endtime, 'trip_type'=>0, 'startdate'=>$start_date, 'enddate'=>$end_date, 'shipment_name'=>'Boxes', 'transport_mode'=>$transport_mode, 'vendor_id'=>$vendor_id, 'carrier_type'=>0, 'txnid'=>$txnid, 'domainname'=>'INFD', 'status'=>1,'origin_id'=>$origin_id,'destination_id'=>$destination_id );

			$data['shipmentid']=$shipmentid;
			$data['created_on']=$curdt;
			$data['company_code']=$company_code;
			$data['branch_code']=$branch_code;
			$ins = $this->db->insert("tb_shifts",$data);
			$shift_id = $this->db->insert_id();



			echo $shift_id;


		}

}


