<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Truckervolumereport extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('session');

        if($this->session->userdata('user_id') == ''){
          redirect('login');
        }

        $this->load->library('form_validation');
        $this->load->model('truckmodel');
        $this->load->model('common');
        $this->load->library('email');
        if (!checkUrlAccessForUser('TRUCKERVOLUMEREPORT')) {
            redirect("Forbiddenaccess");
        }
    }
    public function index()
    {
        $this->getsearchresult();
    }
     /**
     * This method get truck volume report
     * @return    array (truck volumes list)
     * @last change: Container number,num of pallets added for australia
     */
    public function getsearchresult()
    {
        $data["page_title"] = $this->lang->line('trucker_volume');
        $data["sub_title"] = $this->lang->line('trucker_volume_search');
        $order =$user_details=array();
        $user_details['userid'] = $this->session->userdata("user_id");
        $user_details['custid'] = $this->session->userdata("cust_id");

        $user_details['company_code'] = $this->session->userdata("company_code");
       
        $user_details['country_userids'] = $this->session->userdata("country_user_ids");
        if($this->session->userdata('business_type') == 'Carrier'){
          redirect('/');
        }

        if ($user_details['company_code'] == "AUKN") {
            $where = array("company_code" => $user_details['company_code'], "status" => 1);
        } else {
            $where = array("user_id" => $user_details['userid'], "status" => 1);
        }
       

        /* $where = array("user_id"=>$userid,"status"=>1); */
        $select = "id,name";
        $table = "tb_vendors";
        $carrierlist=$this->common->gettbldata($where,$select,$table,0,0);
        $data['carrierlist']=$carrierlist;

        $carrier  = isset($_POST['carrier']) ? $_POST['carrier'] : array();
        $data['carrierid'] = $carrier;
        $carrieridadv  = isset($_POST['carrieridadv']) ? $_POST['carrieridadv'] : array();
        $data['carrieridadv'] = $carrieridadv;

        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
            $post = $_POST;
        }
        if(!empty($post)) {

            $whr = $this->searchvolume($post);
            
            $container_num=isset($post['container_num'])?$post['container_num']:'';
            if(!empty($container_num)){
                $whr['r.ref_value']=$container_num;
            }
            
            $order_status = isset($post['ordtype']) ? $post['ordtype'] :"";
            $ad_orderstatus = isset($post['ordtype_adv']) ? $post['ordtype_adv'] :"";

            $wherein = array();
            if ($carrier != array()) {
                $wherein['vendor_id'] = $carrier;
            }

            if ($carrieridadv != array()) {
                $wherein['vendor_id'] = $carrieridadv;
            }

            $status_search = $order_status;
            if($status_search == ""){
                 $status_search = $ad_orderstatus;
            }


            $orderdata = $this->truckmodel->getreporttruckvolume($user_details,$status_search,$whr,$wherein);
            if(!empty($orderdata)){
                foreach($orderdata as $res) {
                    $sql = 'SELECT o.quantity,c.weight,c.volume FROM tb_cargo_details c,tb_order_cargodetails o
                    WHERE o.order_id = ? AND o.status=1 AND o.cargo_id=c.id GROUP BY c.id ORDER BY c.id DESC';
                    $qry = $this->db->query($sql,[ $res['id'] ] );
                    $pieces=$weight=$volume=0;
                    if($qry->num_rows() >0) {
                        foreach($qry->result() as $row){
                          $pieces=$row->quantity+$pieces;
                          $weight=$row->weight+$weight;
                          $volume=$row->volume+$volume;
                        }
                    }
                    $carrier_name='';
                    
                    if ($user_details['company_code'] == "AUKN") {
                        $au_whr=array('status'=>1,'id'=>$res['vendor_id']);
                        $vender_res =$this->common->gettblrowdata($au_whr,'name','tb_vendors',0,0);
                        if(isset($vender_res['name']) && !empty($vender_res['name'])){
                            $carrier_name = $vender_res['name'];
                        }
                        
                    }else{
                        $truckinfo = $this->db->query("SELECT v.name FROM tb_vendors v,tb_employee e WHERE e.order_id ='".$res['order_id']."' AND e.vendor_id=v.id and v.id='".$res['vendor_id']."'");

                        if($truckinfo->num_rows() >0){
                           $carrier_name = $truckinfo->row()->name;
                        }
                    }

                    $trip_sts = $res['trip_sts'];
                    $trip_id = $res['trip_id'];

                    $order_status = 'PENDING';
                    if($trip_id != 0 && $trip_sts == 0){
                        $order_status = 'ACTIVE';
                    }
                    if($trip_id != 0 && $trip_sts == 1){
                        $order_status = 'CLOSED';
                    }

                    $getdnote = $this->db->select("ref_value")->get_where("tb_order_references",array('order_id'=>$res['id'],'reference_id'=>'DQ'));
                    if($getdnote->num_rows() >0){
                        $delivery_note = $getdnote->row()->ref_value;
                    } else {
                        $delivery_note = "";
                    }
                   
                    $order[] = array('order_row_id'=>$res['id'],'order_id'=>$res['order_id'],'pieces'=>$pieces,
                    'weight'=>$weight,'volume'=>$volume,'createdon'=>$res['createdon'],'pickup'=>$res['pickup'],
                    'delivery'=>$res['delivery'],'order_status'=>$order_status,'shipid'=>$delivery_note,'carriername'=>$carrier_name,'container_num'=>$res['container_num'],'num_of_pallets'=>$res['num_of_pallets']);
                    
                }
            }
        }

        $data['order'] = $order;
        $data['company_code'] = $this->session->userdata('company_code');
        $this->newtemplate->dashboard("reportstruck/volume", $data);
    }

    public function searchvolume($post)
    {
        $whr = array();
        if (isset($post['fromdate']) && $post['fromdate'] != "") {
            $fromdate                                      = date('Y-m-d', strtotime($post['fromdate']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate;

        }
        if (isset($post['todate']) && $post['todate'] != "") {
            $todate                                        = date('Y-m-d', strtotime($post['todate']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;

        }

        if (isset($post['from_date']) && $post['from_date'] != "") {
            $from_date                                      = date('Y-m-d', strtotime($post['from_date']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $from_date;

        }
        if (isset($post['to_date']) && $post['to_date'] != "") {
            $to_date                                        = date('Y-m-d', strtotime($post['to_date']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $to_date;

        }

        return $whr;
    }

}
