<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Truckload extends CI_Controller {

    public function __Construct() {
        parent::__Construct();
        $this->load->library('session');
        if($this->session->userdata('user_id') == ''){
          redirect('login');
        }
        $this->load->model('frieghttrack');
        $this->load->model('common');
    }

    public function index()  {
        //var containerData = {ID:'Flatdeck 48',Dim1:102,Dim2:576,Dim3:102,Weight:48000};
                // label, width, length, height, weightCapacity

        $data['container_data'] = array(
                                "label" => 'MyTruck1',
                                "width" => 102,
                                "length" => 576,
                                "height" => 202,
                                "weight" => 88000
                                );
        $data['packages']= array(
            array(
                "label" => 'Item 1',
                "width" => 70,
                "length" => 100,
                "height" => 90,
                "weight" => 630,
                "quantity" => 3
            ),
            array(
                "label" => 'Item 2',
                "width" => 60,
                "length" => 60,
                "height" => 60,
                "weight" => 216,
                "quantity" => 7
            ),
            array(
                "label" => 'Item 3',
                "width" => 28,
                "length" => 40,
                "height" => 30,
                "weight" => 34,
                "quantity" => 4
            ),
            array(
                "label" => 'Item 4',
                "width" => 23,
                "length" => 30,
                "height" => 34,
                "weight" => 24,
                "quantity" => 20
            ),
            array(
                "label" => 'Item 5',
                "width" => 20,
                "length" => 45,
                "height" => 30,
                "weight" => 27,
                "quantity" => 30
            ),
            array(
                "label" => 'Item 6',
                "width" => 22,
                "length" => 35,
                "height" => 30,
                "weight" => 14,
                "quantity" => 27
            )
        );
        $this->load->view('truckload/index',$data);
    }

    public function generate($shipmentid,$order_id)  { //OSGTGASG00002203 primary key of tb_shifts
        $containerinfo = $this->frieghttrack->getContainerInfo($shipmentid);
      /*  print_r($containerinfo);exit;*/
        $existing_cargos = $this->frieghttrack->getCargoDetailsByShiftid($shipmentid);
        $new_order_cargos = $this->frieghttrack->getCargoDetailsByOrderid($order_id);
        $new_order_weight = $new_order_cargos[0]->order_weight;
       /*  if($new_order_cargos){
            $shipment = $this->common->gettblrowdata(array('id'=>$shipmentid),'*','tb_shifts',1,1);
            $new_weight = $new_order_weight + $shipment['weight'];
            $this->common->updatetbledata('tb_shifts',array("weight"=>$calweight),array('id'=>$shipmentid));
        } */
        $tot_cargos = array_merge($existing_cargos,$new_order_cargos);
        if(count($containerinfo)>0 && count($tot_cargos)>0){ ;
            $data['container_data'] = array(
                "label" => $containerinfo->truck_number,
                "width" => $containerinfo->breadth,
                "length" => $containerinfo->length,
                "height" => 102,
                "weight" => $containerinfo->truck_capacity //weightcapacity
                );
            $data['packages']= array();

            foreach($tot_cargos as $cargo){
                $pack = array(
                    "label" => $cargo->cargo_content,
                    "width" => $cargo->width,
                    "length" => $cargo->length,
                    "height" => $cargo->height,
                    "weight" => '30',//$cargo->weight,
                    "quantity" => $cargo->quantity
                );
                $data['packages'][] = $pack;
            } ;
           /* print_r($data);exit;*/
            $this->load->view('truckload/index',$data);
        } else {
            if(count($containerinfo) == 0){
                $erro_msg = "There is No Container(vehicle)";
            }
            if(count($tot_cargos) == 0){
                $erro_msg = "There is no Packages";
            }
            show_error($erro_msg);
        }

    }
}